# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class EventHubResource(Resource):
    """Description of EventHub Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param created_at: Exact time the Event was created.
    :type created_at: datetime
    :param message_retention_in_days: Number of days to retain the events for
     this Event Hub.
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for EventHub.
    :type partition_count: long
    :param partition_ids: Current number of shards on the Event Hub.
    :type partition_ids: list of str
    :param status: Enumerates the possible values for the status of the
     EventHub. Possible values include: 'Active', 'Disabled', 'Restoring',
     'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming',
     'Unknown'
    :type status: str or :class:`EntityStatus
     <azure.mgmt.eventhub.models.EntityStatus>`
    :param updated_at: The exact time the message has been updated.
    :type updated_at: datetime
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, location, tags=None, created_at=None, message_retention_in_days=None, partition_count=None, partition_ids=None, status=None, updated_at=None):
        super(EventHubResource, self).__init__(location=location, tags=tags)
        self.created_at = created_at
        self.message_retention_in_days = message_retention_in_days
        self.partition_count = partition_count
        self.partition_ids = partition_ids
        self.status = status
        self.updated_at = updated_at
