# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventHubProperties(Model):
    """EventHubProperties.

    :param created_at: Exact time the Event was created.
    :type created_at: datetime
    :param message_retention_in_days: Number of days to retain the events for
     this Event Hub.
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for EventHub.
    :type partition_count: long
    :param partition_ids: Current number of shards on the Event Hub.
    :type partition_ids: list of str
    :param status: Enumerates the possible values for the status of the
     EventHub. Possible values include: 'Active', 'Disabled', 'Restoring',
     'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming',
     'Unknown'
    :type status: str or :class:`EntityStatus
     <azure.mgmt.eventhub.models.EntityStatus>`
    :param updated_at: The exact time the message has been updated.
    :type updated_at: datetime
    """ 

    _attribute_map = {
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'long'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, created_at=None, message_retention_in_days=None, partition_count=None, partition_ids=None, status=None, updated_at=None):
        self.created_at = created_at
        self.message_retention_in_days = message_retention_in_days
        self.partition_count = partition_count
        self.partition_ids = partition_ids
        self.status = status
        self.updated_at = updated_at
