# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConsumerGroupCreateOrUpdateParameters(Model):
    """Parameters supplied to the CreateOrUpdate Consumer Group operation.

    :param location: Location of the resource.
    :type location: str
    :param type: ARM type of the namespace.
    :type type: str
    :param name: Name of the consumer group.
    :type name: str
    :param created_at: Exact time the message was created.
    :type created_at: datetime
    :param event_hub_path: The path of the event hub.
    :type event_hub_path: str
    :param updated_at: The exact time the message has been updated.
    :type updated_at: datetime
    :param user_metadata: The user metadata.
    :type user_metadata: str
    """ 

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'event_hub_path': {'key': 'properties.eventHubPath', 'type': 'str'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'user_metadata': {'key': 'properties.userMetadata', 'type': 'str'},
    }

    def __init__(self, location, type=None, name=None, created_at=None, event_hub_path=None, updated_at=None, user_metadata=None):
        self.location = location
        self.type = type
        self.name = name
        self.created_at = created_at
        self.event_hub_path = event_hub_path
        self.updated_at = updated_at
        self.user_metadata = user_metadata
