﻿import behaviour
import unittest

import machine

class machine_spec( behaviour.Behaviour ):

	def setUp( self ):
	
		self.machine = machine.Machine()

	def test_MachineShouldInitiallyHaveStateOfTheFirstState( self ):
	
		self.machine.states = [ 'Shopping', 'CheckingOut' ]
		self.shouldEqual( self.machine.state, 'Shopping' )

	def test_MachineShouldRememberListOfValidStates( self ):
	
		self.machine.states = [ 'Shopping', 'CheckingOut' ]
		self.shouldEqual( self.machine.states, [ 'Shopping', 'CheckingOut' ] )

if __name__ == '__main__':
	suite = []
	suite += unittest.TestLoader().loadTestsFromTestCase( machine_spec )
	alltests = unittest.TestSuite( suite )
	unittest.TextTestRunner( verbosity=2 ).run( alltests )