# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.usage_metrics_operations import UsageMetricsOperations
from .operations.event_categories_operations import EventCategoriesOperations
from .operations.activity_logs_operations import ActivityLogsOperations
from .operations.tenant_activity_logs_operations import TenantActivityLogsOperations
from .operations.metric_definitions_operations import MetricDefinitionsOperations
from .operations.metrics_operations import MetricsOperations
from . import models


class MonitorClientConfiguration(AzureConfiguration):
    """Configuration for MonitorClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription Id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not isinstance(subscription_id, str):
            raise TypeError("Parameter 'subscription_id' must be str.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(MonitorClientConfiguration, self).__init__(base_url)

        self.add_user_agent('monitorclient/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class MonitorClient(object):
    """Composite Swagger for Monitor Client

    :ivar config: Configuration for client.
    :vartype config: MonitorClientConfiguration

    :ivar usage_metrics: UsageMetrics operations
    :vartype usage_metrics: .operations.UsageMetricsOperations
    :ivar event_categories: EventCategories operations
    :vartype event_categories: .operations.EventCategoriesOperations
    :ivar activity_logs: ActivityLogs operations
    :vartype activity_logs: .operations.ActivityLogsOperations
    :ivar tenant_activity_logs: TenantActivityLogs operations
    :vartype tenant_activity_logs: .operations.TenantActivityLogsOperations
    :ivar metric_definitions: MetricDefinitions operations
    :vartype metric_definitions: .operations.MetricDefinitionsOperations
    :ivar metrics: Metrics operations
    :vartype metrics: .operations.MetricsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription Id.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = MonitorClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.usage_metrics = UsageMetricsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.event_categories = EventCategoriesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.activity_logs = ActivityLogsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.tenant_activity_logs = TenantActivityLogsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.metric_definitions = MetricDefinitionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.metrics = MetricsOperations(
            self._client, self.config, self._serialize, self._deserialize)
