# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationPackage(Model):
    """An application package which represents a particular version of an
    application.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the application.
    :vartype id: str
    :ivar version: The version of the application package.
    :vartype version: str
    :ivar state: The current state of the application package. Possible values
     include: 'pending', 'active', 'unmapped'
    :vartype state: str or :class:`PackageState
     <azure.mgmt.batch.models.PackageState>`
    :ivar format: The format of the application package, if the package is
     active.
    :vartype format: str
    :ivar storage_url: The storage URL at which the application package is
     stored.
    :vartype storage_url: str
    :ivar storage_url_expiry: The UTC time at which the storage URL will
     expire.
    :vartype storage_url_expiry: datetime
    :ivar last_activation_time: The time at which the package was last
     activated, if the package is active.
    :vartype last_activation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'version': {'readonly': True},
        'state': {'readonly': True},
        'format': {'readonly': True},
        'storage_url': {'readonly': True},
        'storage_url_expiry': {'readonly': True},
        'last_activation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'state': {'key': 'state', 'type': 'PackageState'},
        'format': {'key': 'format', 'type': 'str'},
        'storage_url': {'key': 'storageUrl', 'type': 'str'},
        'storage_url_expiry': {'key': 'storageUrlExpiry', 'type': 'iso-8601'},
        'last_activation_time': {'key': 'lastActivationTime', 'type': 'iso-8601'},
    }

    def __init__(self):
        self.id = None
        self.version = None
        self.state = None
        self.format = None
        self.storage_url = None
        self.storage_url_expiry = None
        self.last_activation_time = None
