# encoding: UTF-8

typedefDict = {}

#########################################################################
###@author 中泰证券股份有限公司
###@file xtp_api_data_type.h
###@brief 定义兼容数据基本类型
#########################################################################
### 存放版本号的字符串长度
XTP_VERSION_LEN = 16
### 版本号类型
typedefDict["XTPVersionType"] = "string"
### 可交易日字符串长度
XTP_TRADING_DAY_LEN = 9
### 存放证券代码的字符串长度
XTP_TICKER_LEN = 16
### 存放证券名称的字符串长度
XTP_TICKER_NAME_LEN = 64
### 本地报单编号的字符串长度
XTP_LOCAL_ORDER_LEN = 11
### 交易所单号的字符串长度
XTP_ORDER_EXCH_LEN = 17
### 成交执行编号的字符串长度
XTP_EXEC_ID_LEN = 18
### 交易所交易员代码字符串长度
XTP_BRANCH_PBU_LEN = 7
### 用户资金账户的字符串长度
XTP_ACCOUNT_NAME_LEN = 16
#########################################################################
###@enum XTP_LOG_LEVEL 是日志输出级别类型
#########################################################################
typedefDict["XTP_LOG_LEVEL"] = "enum"
#########################################################################
###@enum XTP_PROTOCOL_TYPE 是通讯传输协议方式
#########################################################################
typedefDict["XTP_PROTOCOL_TYPE"] = "enum"
#########################################################################
###@enum XTP_EXCHANGE_TYPE 是交易所类型
#########################################################################
typedefDict["XTP_EXCHANGE_TYPE"] = "enum"
##########################################################################
###@enum XTP_MARKET_TYPE 市场类型
##########################################################################
typedefDict["XTP_MARKET_TYPE"] = "enum"
#########################################################################
###@enum XTP_PRICE_TYPE 是价格类型
#########################################################################
typedefDict["XTP_PRICE_TYPE"] = "enum"
#########################################################################
###@enum XTP_SIDE_TYPE 是买卖方向类型
#########################################################################
typedefDict["XTP_SIDE_TYPE"] = "enum"
#########################################################################
###@enum XTP_ORDER_ACTION_STATUS_TYPE 是报单操作状态类型
#########################################################################
typedefDict["XTP_ORDER_ACTION_STATUS_TYPE"] = "enum"
#########################################################################
###@enum XTP_ORDER_STATUS_TYPE 是报单状态类型
#########################################################################
typedefDict["XTP_ORDER_STATUS_TYPE"] = "enum"
#########################################################################
###@enum XTP_ORDER_SUBMIT_STATUS_TYPE 是报单提交状态类型
#########################################################################
typedefDict["XTP_ORDER_SUBMIT_STATUS_TYPE"] = "enum"
#########################################################################
###@enum XTP_TE_RESUME_TYPE 是公有流（订单响应、成交回报）重传方式
#########################################################################
typedefDict["XTP_TE_RESUME_TYPE"] = "enum"
##########################################################################
###@enum XTP_TICKER_TYPE 证券类型
##########################################################################
typedefDict["XTP_TICKER_TYPE"] = "enum"
##########################################################################
###@enum XTP_BUSINESS_TYPE 证券业务类型
##########################################################################
typedefDict["XTP_BUSINESS_TYPE"] = "enum"
#########################################################################
###@enum XTP_FUND_TRANSFER_TYPE 是资金流转方向类型
#########################################################################
typedefDict["XTP_FUND_TRANSFER_TYPE"] = "enum"
#########################################################################
###@enum XTP_FUND_OPER_STATUS 柜台资金操作结果
#########################################################################
typedefDict["XTP_FUND_OPER_STATUS"] = "enum"
#########################################################################
###TXTPTradeTypeType是成交类型类型
#########################################################################
typedefDict["TXTPTradeTypeType"] = "char"
###普通成交
XTP_TRDT_Common = '0'
###期权执行
XTP_TRDT_OptionsExecution = '1'
###OTC成交
XTP_TRDT_OTC = '2'
###期转现衍生成交
XTP_TRDT_EFPDerived = '3'
###组合衍生成交
XTP_TRDT_CombinationDerived = '4'
###ETF申购
XTP_TRDT_EFTPurchase = '5'
###ETF赎回
XTP_TRDT_EFTRedem = '6'
#########################################################################
###TXTPOrderTypeType是报单类型类型
#########################################################################
typedefDict["TXTPOrderTypeType"] = "char"
###正常
XTP_ORDT_Normal = '0'
###报价衍生
XTP_ORDT_DeriveFromQuote = '1'
###组合衍生
XTP_ORDT_DeriveFromCombination = '2'
###组合报单
XTP_ORDT_Combination = '3'
###条件单
XTP_ORDT_ConditionalOrder = '4'
###互换单
XTP_ORDT_Swap = '5'
