"""
pyart.graph._cm
===============

Data for radar related colormaps.

"""

# The data for the colormaps in this file were adapted from those found in
# ctables.py of the Deprecated_Metpy package by Patrick Marsh and Ryan May.
# https://github.com/pmarshwx/Deprecated_Metpy

# Standard National Weather Service Radar Colortables
_NWSRef_data = {
    'blue': [
        (0.0, 0.92549019607843142, 0.92549019607843142),
        (0.07142857, 0.96470588235294119, 0.96470588235294119),
        (0.14285714, 0.96470588235294119, 0.96470588235294119),
        (0.21428571, 0.0, 0.0),
        (0.28571429, 0.0, 0.0),
        (0.35714286, 0.0, 0.0),
        (0.42857143, 0.0, 0.0),
        (0.50000000, 0.0, 0.0),
        (0.57142857, 0.0, 0.0),
        (0.64285714, 0.0, 0.0),
        (0.71428571, 0.0, 0.0),
        (0.78571429, 0.0, 0.0),
        (0.85714286, 1.0, 1.0),
        (0.92857143, 0.78823529411764703, 0.78823529411764703),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.92549019607843142, 0.92549019607843142),
        (0.07142857, 0.62745098039215685, 0.62745098039215685),
        (0.14285714, 0.0, 0.0),
        (0.21428571, 1.0, 1.0),
        (0.28571429, 0.78431372549019607, 0.78431372549019607),
        (0.35714286, 0.56470588235294117, 0.56470588235294117),
        (0.42857143, 1.0, 1.0),
        (0.50000000, 0.75294117647058822, 0.75294117647058822),
        (0.57142857, 0.56470588235294117, 0.56470588235294117),
        (0.64285714, 0.0, 0.0),
        (0.71428571, 0.0, 0.0),
        (0.78571429, 0.0, 0.0),
        (0.85714286, 0.0, 0.0),
        (0.92857143, 0.33333333333333331, 0.33333333333333331),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.07142857, 0.0039215686274509803, 0.0039215686274509803),
        (0.14285714, 0.0, 0.0),
        (0.21428571, 0.0, 0.0),
        (0.28571429, 0.0, 0.0),
        (0.35714286, 0.0, 0.0),
        (0.42857143, 1.0, 1.0),
        (0.50000000, 0.90588235294117647, 0.90588235294117647),
        (0.57142857, 1.0, 1.0),
        (0.64285714, 1.0, 1.0),
        (0.71428571, 0.83921568627450982, 0.83921568627450982),
        (0.78571429, 0.75294117647058822, 0.75294117647058822),
        (0.85714286, 1.0, 1.0),
        (0.92857143, 0.59999999999999998, 0.59999999999999998),
    (1.0, 0.0, 0.0)]
}

_NWSVel_data = {
    'blue': [
        (0.0, 0.62352941176470589, 0.62352941176470589),
        (0.071428571428571425, 0.0, 0.0),
        (0.14285714285714285, 0.0, 0.0),
        (0.21428571428571427, 0.0, 0.0),
        (0.2857142857142857, 0.0, 0.0),
        (0.3571428571428571, 0.0, 0.0),
        (0.42857142857142855, 0.0, 0.0),
        (0.5, 0.46666666666666667, 0.46666666666666667),
        (0.5714285714285714, 0.46666666666666667, 0.46666666666666667),
        (0.64285714285714279, 0.0, 0.0),
        (0.71428571428571419, 0.0, 0.0),
        (0.7857142857142857, 0.0, 0.0),
        (0.8571428571428571, 0.0, 0.0),
        (0.92857142857142849, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.071428571428571425, 1.0, 1.0),
        (0.14285714285714285, 0.90980392156862744, 0.90980392156862744),
        (0.21428571428571427, 0.78431372549019607, 0.78431372549019607),
        (0.2857142857142857, 0.69019607843137254, 0.69019607843137254),
        (0.3571428571428571, 0.56470588235294117, 0.56470588235294117),
        (0.42857142857142855, 0.4392156862745098, 0.4392156862745098),
        (0.5, 0.59215686274509804, 0.59215686274509804),
        (0.5714285714285714, 0.46666666666666667, 0.46666666666666667),
        (0.64285714285714279, 0.0, 0.0),
        (0.71428571428571419, 0.0, 0.0),
        (0.7857142857142857, 0.0, 0.0),
        (0.8571428571428571, 0.0, 0.0),
        (0.92857142857142849, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.56470588235294117, 0.56470588235294117),
        (0.071428571428571425, 0.0, 0.0),
        (0.14285714285714285, 0.0, 0.0),
        (0.21428571428571427, 0.0, 0.0),
        (0.2857142857142857, 0.0, 0.0),
        (0.3571428571428571, 0.0, 0.0),
        (0.42857142857142855, 0.0, 0.0),
        (0.5, 0.46666666666666667, 0.46666666666666667),
        (0.5714285714285714, 0.59215686274509804, 0.59215686274509804),
        (0.64285714285714279, 0.50196078431372548, 0.50196078431372548),
        (0.71428571428571419, 0.62745098039215685, 0.62745098039215685),
        (0.7857142857142857, 0.72156862745098038, 0.72156862745098038),
        (0.8571428571428571, 0.84705882352941175, 0.84705882352941175),
        (0.92857142857142849, 0.93333333333333335, 0.93333333333333335),
        (1.0, 1.0, 1.0)]
}

_NWS_SPW_data = {
    'blue': [
        (0.0, 0.62352941176470589, 0.62352941176470589),
        (0.16666666666666666, 0.46274509803921571, 0.46274509803921571),
        (0.33333333333333331, 0.61176470588235299, 0.61176470588235299),
        (0.5, 0.0, 0.0),
        (0.66666666666666663, 0.0, 0.0),
        (0.83333333333333326, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.16666666666666666, 0.46274509803921571, 0.46274509803921571),
        (0.33333333333333331, 0.61176470588235299, 0.61176470588235299),
        (0.5, 0.73333333333333328, 0.73333333333333328),
        (0.66666666666666663, 0.0, 0.0),
        (0.83333333333333326, 0.4392156862745098, 0.4392156862745098),
        (1.0, 1.0, 1.0)],
    'red': [
        (0.0, 0.56470588235294117, 0.56470588235294117),
        (0.16666666666666666, 0.46274509803921571, 0.46274509803921571),
        (0.33333333333333331, 0.61176470588235299, 0.61176470588235299),
        (0.5, 0.0, 0.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.83333333333333326, 0.81568627450980391, 0.81568627450980391),
        (1.0, 1.0, 1.0)]
}

# Colors maps from Patrick Marsh (http://www.pmarshwx.com/)
_RefDiff_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.1111111111111111, 1.0, 1.0),
        (0.22222222222222221, 1.0, 1.0),
        (0.33333333333333331, 0.0, 0.0),
        (0.44444444444444442, 0.0, 0.0),
        (0.55555555555555558, 0.0, 0.0),
        (0.66666666666666663, 0.0, 0.0),
        (0.77777777777777768, 0.0, 0.0),
        (0.88888888888888884, 0.0, 0.0),
        (1.0, 1.0, 1.0)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.1111111111111111, 0.66666666666666663, 0.66666666666666663),
        (0.22222222222222221, 1.0, 1.0),
        (0.33333333333333331, 0.66666666666666663, 0.66666666666666663),
        (0.44444444444444442, 1.0, 1.0),
        (0.55555555555555558, 1.0, 1.0),
        (0.66666666666666663, 0.66666666666666663, 0.66666666666666663),
        (0.77777777777777768, 0.33333333333333331, 0.33333333333333331),
        (0.88888888888888884, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.1111111111111111, 0.0, 0.0),
        (0.22222222222222221, 0.0, 0.0),
        (0.33333333333333331, 0.0, 0.0),
        (0.44444444444444442, 0.0, 0.0),
        (0.55555555555555558, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.77777777777777768, 1.0, 1.0),
        (0.88888888888888884, 1.0, 1.0),
        (1.0, 1.0, 1.0)]
}

# Colortables from SoloII
_Carbone11_data = {
    'blue': [
        (0.0, 0.55686274509803924, 0.55686274509803924),
        (0.10000000000000001, 0.8901960784313725, 0.8901960784313725),
        (0.20000000000000001, 0.81176470588235294, 0.81176470588235294),
        (0.30000000000000004, 0.12156862745098039, 0.12156862745098039),
        (0.40000000000000002, 0.63529411764705879, 0.63529411764705879),
        (0.5, 0.90588235294117647, 0.90588235294117647),
        (0.60000000000000009, 0.050980392156862744, 0.050980392156862744),
        (0.70000000000000007, 0.23529411764705882, 0.23529411764705882),
        (0.80000000000000004, 0.34509803921568627, 0.34509803921568627),
        (0.90000000000000002, 0.52941176470588236, 0.52941176470588236),
        (1.0, 0.23529411764705882, 0.23529411764705882)],
    'green': [
        (0.0, 0.062745098039215685, 0.062745098039215685),
        (0.10000000000000001, 0.36078431372549019, 0.36078431372549019),
        (0.20000000000000001, 0.68627450980392157, 0.68627450980392157),
        (0.30000000000000004, 0.65098039215686276, 0.65098039215686276),
        (0.40000000000000002, 0.81568627450980391, 0.81568627450980391),
        (0.5, 0.90588235294117647, 0.90588235294117647),
        (0.60000000000000009, 0.86274509803921573, 0.86274509803921573),
        (0.70000000000000007, 0.69019607843137254, 0.69019607843137254),
        (0.80000000000000004, 0.4392156862745098, 0.4392156862745098),
        (0.90000000000000002, 0.4392156862745098, 0.4392156862745098),
        (1.0, 0.12549019607843137, 0.12549019607843137)],
    'red': [
        (0.0, 0.53725490196078429, 0.53725490196078429),
        (0.10000000000000001, 0.46274509803921571, 0.46274509803921571),
        (0.20000000000000001, 0.43137254901960786, 0.43137254901960786),
        (0.30000000000000004, 0.12156862745098039, 0.12156862745098039),
        (0.40000000000000002, 0.63529411764705879, 0.63529411764705879),
        (0.5, 0.90588235294117647, 0.90588235294117647),
        (0.60000000000000009, 0.96470588235294119, 0.96470588235294119),
        (0.70000000000000007, 0.94117647058823528, 0.94117647058823528),
        (0.80000000000000004, 0.63137254901960782, 0.63137254901960782),
        (0.90000000000000002, 0.8901960784313725, 0.8901960784313725),
        (1.0, 0.792156862745098, 0.792156862745098)]
}

_Carbone17_data = {
    'blue': [
        (0.0, 0.55686274509803924, 0.55686274509803924),
        (0.0625, 0.61960784313725492, 0.61960784313725492),
        (0.125, 0.88627450980392153, 0.88627450980392153),
        (0.1875, 0.80784313725490198, 0.80784313725490198),
        (0.25, 0.062745098039215685, 0.062745098039215685),
        (0.3125, 0.12156862745098039, 0.12156862745098039),
        (0.375, 0.42745098039215684, 0.42745098039215684),
        (0.4375, 0.63137254901960782, 0.63137254901960782),
        (0.5, 0.90588235294117647, 0.90588235294117647),
        (0.5625, 0.047058823529411764, 0.047058823529411764),
        (0.625, 0.10980392156862745, 0.10980392156862745),
        (0.6875, 0.20784313725490197, 0.20784313725490197),
        (0.75, 0.28627450980392155, 0.28627450980392155),
        (0.8125, 0.3411764705882353, 0.3411764705882353),
        (0.875, 0.46666666666666667, 0.46666666666666667),
        (0.9375, 0.41568627450980394, 0.41568627450980394),
        (1.0, 0.25098039215686274, 0.25098039215686274)],
    'green': [
        (0.0, 0.062745098039215685, 0.062745098039215685),
        (0.0625, 0.11764705882352941, 0.11764705882352941),
        (0.125, 0.36078431372549019, 0.36078431372549019),
        (0.1875, 0.68235294117647061, 0.68235294117647061),
        (0.25, 0.54117647058823526, 0.54117647058823526),
        (0.3125, 0.65098039215686276, 0.65098039215686276),
        (0.375, 0.7686274509803922, 0.7686274509803922),
        (0.4375, 0.81568627450980391, 0.81568627450980391),
        (0.5, 0.90196078431372551, 0.90196078431372551),
        (0.5625, 0.85882352941176465, 0.85882352941176465),
        (0.625, 0.74901960784313726, 0.74901960784313726),
        (0.6875, 0.63921568627450975, 0.63921568627450975),
        (0.75, 0.53333333333333333, 0.53333333333333333),
        (0.8125, 0.4392156862745098, 0.4392156862745098),
        (0.875, 0.37254901960784315, 0.37254901960784315),
        (0.9375, 0.27450980392156865, 0.27450980392156865),
        (1.0, 0.15294117647058825, 0.15294117647058825)],
    'red': [
        (0.0, 0.53725490196078429, 0.53725490196078429),
        (0.0625, 0.29019607843137257, 0.29019607843137257),
        (0.125, 0.45882352941176469, 0.45882352941176469),
        (0.1875, 0.43529411764705883, 0.43529411764705883),
        (0.25, 0.062745098039215685, 0.062745098039215685),
        (0.3125, 0.12156862745098039, 0.12156862745098039),
        (0.375, 0.42745098039215684, 0.42745098039215684),
        (0.4375, 0.63137254901960782, 0.63137254901960782),
        (0.5, 0.90588235294117647, 0.90588235294117647),
        (0.5625, 0.98039215686274506, 0.98039215686274506),
        (0.625, 0.98039215686274506, 0.98039215686274506),
        (0.6875, 0.8784313725490196, 0.8784313725490196),
        (0.75, 0.74901960784313726, 0.74901960784313726),
        (0.8125, 0.62745098039215685, 0.62745098039215685),
        (0.875, 0.87058823529411766, 0.87058823529411766),
        (0.9375, 0.94117647058823528, 0.94117647058823528),
        (1.0, 0.80784313725490198, 0.80784313725490198)]
}

_RRate11_data = {
    'blue': [
        (0.0, 0.50196078431372548, 0.50196078431372548),
        (0.10000000000000001, 0.62745098039215685, 0.62745098039215685),
        (0.20000000000000001, 0.93333333333333335, 0.93333333333333335),
        (0.30000000000000004, 0.027450980392156862, 0.027450980392156862),
        (0.40000000000000002, 0.34509803921568627, 0.34509803921568627),
        (0.5, 0.92156862745098034, 0.92156862745098034),
        (0.60000000000000009, 0.031372549019607843, 0.031372549019607843),
        (0.70000000000000007, 0.15294117647058825, 0.15294117647058825),
        (0.80000000000000004, 0.30588235294117649, 0.30588235294117649),
        (0.90000000000000002, 0.43137254901960786, 0.43137254901960786),
        (1.0, 0.23529411764705882, 0.23529411764705882)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.10000000000000001, 0.17254901960784313, 0.17254901960784313),
        (0.20000000000000001, 0.36078431372549019, 0.36078431372549019),
        (0.30000000000000004, 0.52156862745098043, 0.52156862745098043),
        (0.40000000000000002, 0.74509803921568629, 0.74509803921568629),
        (0.5, 0.93333333333333335, 0.93333333333333335),
        (0.60000000000000009, 0.85490196078431369, 0.85490196078431369),
        (0.70000000000000007, 0.60784313725490191, 0.60784313725490191),
        (0.80000000000000004, 0.38823529411764707, 0.38823529411764707),
        (0.90000000000000002, 0.3843137254901961, 0.3843137254901961),
        (1.0, 0.062745098039215685, 0.062745098039215685)],
    'red': [
        (0.0, 0.50196078431372548, 0.50196078431372548),
        (0.10000000000000001, 0.29803921568627451, 0.29803921568627451),
        (0.20000000000000001, 0.42352941176470588, 0.42352941176470588),
        (0.30000000000000004, 0.035294117647058823, 0.035294117647058823),
        (0.40000000000000002, 0.36470588235294116, 0.36470588235294116),
        (0.5, 0.94117647058823528, 0.94117647058823528),
        (0.60000000000000009, 0.99215686274509807, 0.99215686274509807),
        (0.70000000000000007, 0.93333333333333335, 0.93333333333333335),
        (0.80000000000000004, 0.58823529411764708, 0.58823529411764708),
        (0.90000000000000002, 0.93333333333333335, 0.93333333333333335),
        (1.0, 0.83137254901960789, 0.83137254901960789)]
}

_BlueBrown10_data = {
    'blue': [
        (0.0, 0.75294117647058822, 0.75294117647058822),
        (0.1111111111111111, 0.81176470588235294, 0.81176470588235294),
        (0.22222222222222221, 0.87450980392156863, 0.87450980392156863),
        (0.33333333333333331, 0.93725490196078431, 0.93725490196078431),
        (0.44444444444444442, 1.0, 1.0),
        (0.55555555555555558, 0.69411764705882351, 0.69411764705882351),
        (0.66666666666666663, 0.60392156862745094, 0.60392156862745094),
        (0.77777777777777768, 0.51372549019607838, 0.51372549019607838),
        (0.88888888888888884, 0.42745098039215684, 0.42745098039215684),
        (1.0, 0.33725490196078434, 0.33725490196078434)],
    'green': [
        (0.0, 0.37647058823529411, 0.37647058823529411),
        (0.1111111111111111, 0.51372549019607838, 0.51372549019607838),
        (0.22222222222222221, 0.65098039215686276, 0.65098039215686276),
        (0.33333333333333331, 0.78823529411764703, 0.78823529411764703),
        (0.44444444444444442, 0.92941176470588238, 0.92941176470588238),
        (0.55555555555555558, 0.90196078431372551, 0.90196078431372551),
        (0.66666666666666663, 0.76078431372549016, 0.76078431372549016),
        (0.77777777777777768, 0.62352941176470589, 0.62352941176470589),
        (0.88888888888888884, 0.48627450980392156, 0.48627450980392156),
        (1.0, 0.34509803921568627, 0.34509803921568627)],
    'red': [
        (0.0, 0.0039215686274509803, 0.0039215686274509803),
        (0.1111111111111111, 0.0039215686274509803, 0.0039215686274509803),
        (0.22222222222222221, 0.0039215686274509803, 0.0039215686274509803),
        (0.33333333333333331, 0.0039215686274509803, 0.0039215686274509803),
        (0.44444444444444442, 0.0078431372549019607, 0.0078431372549019607),
        (0.55555555555555558, 1.0, 1.0),
        (0.66666666666666663, 0.90196078431372551, 0.90196078431372551),
        (0.77777777777777768, 0.80392156862745101, 0.80392156862745101),
        (0.88888888888888884, 0.70588235294117652, 0.70588235294117652),
        (1.0, 0.60784313725490191, 0.60784313725490191)]
}

_BlueBrown11_data = {
    'blue': [
        (0.0, 0.75294117647058822, 0.75294117647058822),
        (0.10000000000000001, 0.81176470588235294, 0.81176470588235294),
        (0.20000000000000001, 0.87450980392156863, 0.87450980392156863),
        (0.30000000000000004, 0.93725490196078431, 0.93725490196078431),
        (0.40000000000000002, 1.0, 1.0),
        (0.5, 0.90588235294117647, 0.90588235294117647),
        (0.60000000000000009, 0.69411764705882351, 0.69411764705882351),
        (0.70000000000000007, 0.60392156862745094, 0.60392156862745094),
        (0.80000000000000004, 0.51372549019607838, 0.51372549019607838),
        (0.90000000000000002, 0.42745098039215684, 0.42745098039215684),
        (1.0, 0.33725490196078434, 0.33725490196078434)],
    'green': [
        (0.0, 0.37647058823529411, 0.37647058823529411),
        (0.10000000000000001, 0.51372549019607838, 0.51372549019607838),
        (0.20000000000000001, 0.65098039215686276, 0.65098039215686276),
        (0.30000000000000004, 0.78823529411764703, 0.78823529411764703),
        (0.40000000000000002, 0.92941176470588238, 0.92941176470588238),
        (0.5, 0.90196078431372551, 0.90196078431372551),
        (0.60000000000000009, 0.90196078431372551, 0.90196078431372551),
        (0.70000000000000007, 0.76078431372549016, 0.76078431372549016),
        (0.80000000000000004, 0.62352941176470589, 0.62352941176470589),
        (0.90000000000000002, 0.48627450980392156, 0.48627450980392156),
        (1.0, 0.34509803921568627, 0.34509803921568627)],
    'red': [
        (0.0, 0.0039215686274509803, 0.0039215686274509803),
        (0.10000000000000001, 0.0039215686274509803, 0.0039215686274509803),
        (0.20000000000000001, 0.0039215686274509803, 0.0039215686274509803),
        (0.30000000000000004, 0.0039215686274509803, 0.0039215686274509803),
        (0.40000000000000002, 0.0078431372549019607, 0.0078431372549019607),
        (0.5, 0.90588235294117647, 0.90588235294117647),
        (0.60000000000000009, 1.0, 1.0),
        (0.70000000000000007, 0.90196078431372551, 0.90196078431372551),
        (0.80000000000000004, 0.80392156862745101, 0.80392156862745101),
        (0.90000000000000002, 0.70588235294117652, 0.70588235294117652),
        (1.0, 0.60784313725490191, 0.60784313725490191)]
}

_Theodore16_data = {
    'blue': [
        (0.0, 0.99215686274509807, 0.99215686274509807),
        (0.066666666666666666, 0.99215686274509807, 0.99215686274509807),
        (0.13333333333333333, 0.82745098039215681, 0.82745098039215681),
        (0.20000000000000001, 0.6705882352941176, 0.6705882352941176),
        (0.26666666666666666, 0.0, 0.0),
        (0.33333333333333331, 0.36470588235294116, 0.36470588235294116),
        (0.40000000000000002, 0.59215686274509804, 0.59215686274509804),
        (0.46666666666666667, 0.82352941176470584, 0.82352941176470584),
        (0.53333333333333333, 0.58431372549019611, 0.58431372549019611),
        (0.59999999999999998, 0.0039215686274509803, 0.0039215686274509803),
        (0.66666666666666663, 0.062745098039215685, 0.062745098039215685),
        (0.73333333333333328, 0.17647058823529413, 0.17647058823529413),
        (0.80000000000000004, 0.11372549019607843, 0.11372549019607843),
        (0.8666666666666667, 0.34901960784313724, 0.34901960784313724),
        (0.93333333333333335, 0.24705882352941178, 0.24705882352941178),
        (1.0, 0.46666666666666667, 0.46666666666666667)],
    'green': [
        (0.0, 0.67450980392156867, 0.67450980392156867),
        (0.066666666666666666, 0.55686274509803924, 0.55686274509803924),
        (0.13333333333333333, 0.45098039215686275, 0.45098039215686275),
        (0.20000000000000001, 0.30980392156862746, 0.30980392156862746),
        (0.26666666666666666, 0.56862745098039214, 0.56862745098039214),
        (0.33333333333333331, 0.70588235294117652, 0.70588235294117652),
        (0.40000000000000002, 0.80000000000000004, 0.80000000000000004),
        (0.46666666666666667, 0.89411764705882357, 0.89411764705882357),
        (0.53333333333333333, 0.8901960784313725, 0.8901960784313725),
        (0.59999999999999998, 0.79607843137254897, 0.79607843137254897),
        (0.66666666666666663, 0.70196078431372544, 0.70196078431372544),
        (0.73333333333333328, 0.52941176470588236, 0.52941176470588236),
        (0.80000000000000004, 0.11372549019607843, 0.11372549019607843),
        (0.8666666666666667, 0.35294117647058826, 0.35294117647058826),
        (0.93333333333333335, 0.24705882352941178, 0.24705882352941178),
        (1.0, 0.29019607843137257, 0.29019607843137257)],
    'red': [
        (0.0, 0.67450980392156867, 0.67450980392156867),
        (0.066666666666666666, 0.55686274509803924, 0.55686274509803924),
        (0.13333333333333333, 0.45098039215686275, 0.45098039215686275),
        (0.20000000000000001, 0.30588235294117649, 0.30588235294117649),
        (0.26666666666666666, 0.12941176470588237, 0.12941176470588237),
        (0.33333333333333331, 0.36470588235294116, 0.36470588235294116),
        (0.40000000000000002, 0.59215686274509804, 0.59215686274509804),
        (0.46666666666666667, 0.82352941176470584, 0.82352941176470584),
        (0.53333333333333333, 0.93725490196078431, 0.93725490196078431),
        (0.59999999999999998, 0.93725490196078431, 0.93725490196078431),
        (0.66666666666666663, 0.93725490196078431, 0.93725490196078431),
        (0.73333333333333328, 0.75686274509803919, 0.75686274509803919),
        (0.80000000000000004, 0.64313725490196083, 0.64313725490196083),
        (0.8666666666666667, 0.74117647058823533, 0.74117647058823533),
        (0.93333333333333335, 0.86274509803921573, 0.86274509803921573),
        (1.0, 0.97254901960784312, 0.97254901960784312)]
}

_EWilson17_data = {
    'blue': [
        (0.0, 0.97647058823529409, 0.97647058823529409),
        (0.0625, 0.97647058823529409, 0.97647058823529409),
        (0.125, 0.93725490196078431, 0.93725490196078431),
        (0.1875, 0.97647058823529409, 0.97647058823529409),
        (0.25, 0.89411764705882357, 0.89411764705882357),
        (0.3125, 0.0, 0.0),
        (0.375, 0.30980392156862746, 0.30980392156862746),
        (0.4375, 0.0, 0.0),
        (0.5, 0.93725490196078431, 0.93725490196078431),
        (0.5625, 0.27058823529411763, 0.27058823529411763),
        (0.625, 0.46666666666666667, 0.46666666666666667),
        (0.6875, 0.0, 0.0),
        (0.75, 0.0, 0.0),
        (0.8125, 0.0, 0.0),
        (0.875, 0.68235294117647061, 0.68235294117647061),
        (0.9375, 0.46666666666666667, 0.46666666666666667),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.0625, 0.38823529411764707, 0.38823529411764707),
        (0.125, 0.9882352941176471, 0.9882352941176471),
        (0.1875, 0.62352941176470589, 0.62352941176470589),
        (0.25, 0.0, 0.0),
        (0.3125, 0.97647058823529409, 0.97647058823529409),
        (0.375, 0.74117647058823533, 0.74117647058823533),
        (0.4375, 0.53725490196078429, 0.53725490196078429),
        (0.5, 0.93725490196078431, 0.93725490196078431),
        (0.5625, 0.48627450980392156, 0.48627450980392156),
        (0.625, 0.62352941176470589, 0.62352941176470589),
        (0.6875, 0.48627450980392156, 0.48627450980392156),
        (0.75, 0.64313725490196083, 0.64313725490196083),
        (0.8125, 0.81960784313725488, 0.81960784313725488),
        (0.875, 0.68235294117647061, 0.68235294117647061),
        (0.9375, 0.46666666666666667, 0.46666666666666667),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.93725490196078431, 0.93725490196078431),
        (0.0625, 0.68235294117647061, 0.68235294117647061),
        (0.125, 0.0, 0.0),
        (0.1875, 0.0, 0.0),
        (0.25, 0.0, 0.0),
        (0.3125, 0.0, 0.0),
        (0.375, 0.30980392156862746, 0.30980392156862746),
        (0.4375, 0.0, 0.0),
        (0.5, 0.93725490196078431, 0.93725490196078431),
        (0.5625, 0.70196078431372544, 0.70196078431372544),
        (0.625, 0.74117647058823533, 0.74117647058823533),
        (0.6875, 0.97647058823529409, 0.97647058823529409),
        (0.75, 0.97647058823529409, 0.97647058823529409),
        (0.8125, 0.93725490196078431, 0.93725490196078431),
        (0.875, 0.99215686274509807, 0.99215686274509807),
        (0.9375, 0.97647058823529409, 0.97647058823529409),
        (1.0, 0.99215686274509807, 0.99215686274509807)]
}

_Wild25_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.041666666666666664, 1.0, 1.0),
        (0.083333333333333329, 1.0, 1.0),
        (0.125, 1.0, 1.0),
        (0.16666666666666666, 1.0, 1.0),
        (0.20833333333333331, 1.0, 1.0),
        (0.25, 1.0, 1.0),
        (0.29166666666666663, 1.0, 1.0),
        (0.33333333333333331, 0.066666666666666666, 0.066666666666666666),
        (0.375, 0.066666666666666666, 0.066666666666666666),
        (0.41666666666666663, 0.066666666666666666, 0.066666666666666666),
        (0.45833333333333331, 0.066666666666666666, 0.066666666666666666),
        (0.5, 0.78431372549019607, 0.78431372549019607),
        (0.54166666666666663, 0.011764705882352941, 0.011764705882352941),
        (0.58333333333333326, 0.37647058823529411, 0.37647058823529411),
        (0.625, 0.12156862745098039, 0.12156862745098039),
        (0.66666666666666663, 0.011764705882352941, 0.011764705882352941),
        (0.70833333333333326, 0.74509803921568629, 0.74509803921568629),
        (0.75, 0.53333333333333333, 0.53333333333333333),
        (0.79166666666666663, 0.3411764705882353, 0.3411764705882353),
        (0.83333333333333326, 0.0, 0.0),
        (0.875, 0.0, 0.0),
        (0.91666666666666663, 0.0, 0.0),
        (0.95833333333333326, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.015686274509803921, 0.015686274509803921),
        (0.041666666666666664, 0.015686274509803921, 0.015686274509803921),
        (0.083333333333333329, 0.015686274509803921, 0.015686274509803921),
        (0.125, 0.015686274509803921, 0.015686274509803921),
        (0.16666666666666666, 0.015686274509803921, 0.015686274509803921),
        (0.20833333333333331, 0.015686274509803921, 0.015686274509803921),
        (0.25, 0.50196078431372548, 0.50196078431372548),
        (0.29166666666666663, 0.75686274509803919, 0.75686274509803919),
        (0.33333333333333331, 0.9882352941176471, 0.9882352941176471),
        (0.375, 0.66274509803921566, 0.66274509803921566),
        (0.41666666666666663, 0.51764705882352946, 0.51764705882352946),
        (0.45833333333333331, 0.32549019607843138, 0.32549019607843138),
        (0.5, 0.78431372549019607, 0.78431372549019607),
        (0.54166666666666663, 0.28235294117647058, 0.28235294117647058),
        (0.58333333333333326, 0.58431372549019611, 0.58431372549019611),
        (0.625, 0.72156862745098038, 0.72156862745098038),
        (0.66666666666666663, 1.0, 1.0),
        (0.70833333333333326, 0.74509803921568629, 0.74509803921568629),
        (0.75, 0.53333333333333333, 0.53333333333333333),
        (0.79166666666666663, 0.3411764705882353, 0.3411764705882353),
        (0.83333333333333326, 0.46666666666666667, 0.46666666666666667),
        (0.875, 0.31372549019607843, 0.31372549019607843),
        (0.91666666666666663, 0.0, 0.0),
        (0.95833333333333326, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.99607843137254903, 0.99607843137254903),
        (0.041666666666666664, 0.85098039215686272, 0.85098039215686272),
        (0.083333333333333329, 0.70588235294117652, 0.70588235294117652),
        (0.125, 0.5725490196078431, 0.5725490196078431),
        (0.16666666666666666, 0.38823529411764707, 0.38823529411764707),
        (0.20833333333333331, 0.015686274509803921, 0.015686274509803921),
        (0.25, 0.015686274509803921, 0.015686274509803921),
        (0.29166666666666663, 0.015686274509803921, 0.015686274509803921),
        (0.33333333333333331, 0.015686274509803921, 0.015686274509803921),
        (0.375, 0.015686274509803921, 0.015686274509803921),
        (0.41666666666666663, 0.015686274509803921, 0.015686274509803921),
        (0.45833333333333331, 0.015686274509803921, 0.015686274509803921),
        (0.5, 0.78431372549019607, 0.78431372549019607),
        (0.54166666666666663, 0.65490196078431373, 0.65490196078431373),
        (0.58333333333333326, 0.85098039215686272, 0.85098039215686272),
        (0.625, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.70833333333333326, 0.99607843137254903, 0.99607843137254903),
        (0.75, 0.99607843137254903, 0.99607843137254903),
        (0.79166666666666663, 0.99607843137254903, 0.99607843137254903),
        (0.83333333333333326, 0.99607843137254903, 0.99607843137254903),
        (0.875, 0.87450980392156863, 0.87450980392156863),
        (0.91666666666666663, 0.54117647058823526, 0.54117647058823526),
        (0.95833333333333326, 0.82352941176470584, 0.82352941176470584),
        (1.0, 1.0, 1.0)]
}

_SCook18_data = {
    'blue': [
        (0.0, 0.9137254901960784, 0.9137254901960784),
        (0.058823529411764705, 0.9137254901960784, 0.9137254901960784),
        (0.11764705882352941, 0.88627450980392153, 0.88627450980392153),
        (0.1764705882352941, 0.85490196078431369, 0.85490196078431369),
        (0.23529411764705882, 0.69019607843137254, 0.69019607843137254),
        (0.29411764705882354, 0.42352941176470588, 0.42352941176470588),
        (0.3529411764705882, 0.054901960784313725, 0.054901960784313725),
        (0.41176470588235292, 0.011764705882352941, 0.011764705882352941),
        (0.47058823529411764, 0.3843137254901961, 0.3843137254901961),
        (0.52941176470588236, 0.45098039215686275, 0.45098039215686275),
        (0.58823529411764708, 0.30980392156862746, 0.30980392156862746),
        (0.6470588235294118, 0.18823529411764706, 0.18823529411764706),
        (0.70588235294117641, 0.066666666666666666, 0.066666666666666666),
        (0.76470588235294112, 0.058823529411764705, 0.058823529411764705),
        (0.82352941176470584, 0.2196078431372549, 0.2196078431372549),
        (0.88235294117647056, 0.3411764705882353, 0.3411764705882353),
        (0.94117647058823528, 0.070588235294117646, 0.070588235294117646),
        (1.0, 0.074509803921568626, 0.074509803921568626)],
    'green': [
        (0.0, 0.070588235294117646, 0.070588235294117646),
        (0.058823529411764705, 0.21176470588235294, 0.21176470588235294),
        (0.11764705882352941, 0.36078431372549019, 0.36078431372549019),
        (0.1764705882352941, 0.52156862745098043, 0.52156862745098043),
        (0.23529411764705882, 0.71372549019607845, 0.71372549019607845),
        (0.29411764705882354, 0.88235294117647056, 0.88235294117647056),
        (0.3529411764705882, 0.7803921568627451, 0.7803921568627451),
        (0.41176470588235292, 0.66666666666666663, 0.66666666666666663),
        (0.47058823529411764, 0.58431372549019611, 0.58431372549019611),
        (0.52941176470588236, 0.58039215686274515, 0.58039215686274515),
        (0.58823529411764708, 0.54117647058823526, 0.54117647058823526),
        (0.6470588235294118, 0.55686274509803924, 0.55686274509803924),
        (0.70588235294117641, 0.58823529411764708, 0.58823529411764708),
        (0.76470588235294112, 0.67450980392156867, 0.67450980392156867),
        (0.82352941176470584, 0.51372549019607838, 0.51372549019607838),
        (0.88235294117647056, 0.49019607843137253, 0.49019607843137253),
        (0.94117647058823528, 0.070588235294117646, 0.070588235294117646),
        (1.0, 0.074509803921568626, 0.074509803921568626)],
    'red': [
        (0.0, 0.76078431372549016, 0.76078431372549016),
        (0.058823529411764705, 0.57647058823529407, 0.57647058823529407),
        (0.11764705882352941, 0.32549019607843138, 0.32549019607843138),
        (0.1764705882352941, 0.082352941176470587, 0.082352941176470587),
        (0.23529411764705882, 0.0078431372549019607, 0.0078431372549019607),
        (0.29411764705882354, 0.0078431372549019607, 0.0078431372549019607),
        (0.3529411764705882, 0.0039215686274509803, 0.0039215686274509803),
        (0.41176470588235292, 0.0078431372549019607, 0.0078431372549019607),
        (0.47058823529411764, 0.3843137254901961, 0.3843137254901961),
        (0.52941176470588236, 0.70196078431372544, 0.70196078431372544),
        (0.58823529411764708, 0.75294117647058822, 0.75294117647058822),
        (0.6470588235294118, 0.85882352941176465, 0.85882352941176465),
        (0.70588235294117641, 0.95294117647058818, 0.95294117647058818),
        (0.76470588235294112, 0.97254901960784312, 0.97254901960784312),
        (0.82352941176470584, 0.89803921568627454, 0.89803921568627454),
        (0.88235294117647056, 0.96862745098039216, 0.96862745098039216),
        (0.94117647058823528, 0.99215686274509807, 0.99215686274509807),
        (1.0, 0.85490196078431369, 0.85490196078431369)]
}

_PD17_data = {
    'blue': [
        (0.0, 0.71372549019607845, 0.71372549019607845),
        (0.0625, 0.60784313725490191, 0.60784313725490191),
        (0.125, 0.0, 0.0),
        (0.1875, 0.039215686274509803, 0.039215686274509803),
        (0.25, 0.18431372549019609, 0.18431372549019609),
        (0.3125, 0.1803921568627451, 0.1803921568627451),
        (0.375, 0.14509803921568629, 0.14509803921568629),
        (0.4375, 0.027450980392156862, 0.027450980392156862),
        (0.5, 0.0, 0.0),
        (0.5625, 1.0, 1.0),
        (0.625, 0.93725490196078431, 0.93725490196078431),
        (0.6875, 0.75294117647058822, 0.75294117647058822),
        (0.75, 1.0, 1.0),
        (0.8125, 0.71372549019607845, 0.71372549019607845),
        (0.875, 0.97254901960784312, 0.97254901960784312),
        (0.9375, 0.50196078431372548, 0.50196078431372548),
        (1.0, 0.6470588235294118, 0.6470588235294118)],
    'green': [
        (0.0, 0.81176470588235294, 0.81176470588235294),
        (0.0625, 0.84705882352941175, 0.84705882352941175),
        (0.125, 0.58823529411764708, 0.58823529411764708),
        (0.1875, 0.46666666666666667, 0.46666666666666667),
        (0.25, 0.18431372549019609, 0.18431372549019609),
        (0.3125, 0.98039215686274506, 0.98039215686274506),
        (0.375, 0.98039215686274506, 0.98039215686274506),
        (0.4375, 0.77647058823529413, 0.77647058823529413),
        (0.5, 0.5725490196078431, 0.5725490196078431),
        (0.5625, 0.87450980392156863, 0.87450980392156863),
        (0.625, 0.58039215686274515, 0.58039215686274515),
        (0.6875, 0.32941176470588235, 0.32941176470588235),
        (0.75, 0.792156862745098, 0.792156862745098),
        (0.8125, 0.60392156862745094, 0.60392156862745094),
        (0.875, 0.97254901960784312, 0.97254901960784312),
        (0.9375, 0.62745098039215685, 0.62745098039215685),
        (1.0, 0.11372549019607843, 0.11372549019607843)],
    'red': [
        (0.0, 0.81568627450980391, 0.81568627450980391),
        (0.0625, 1.0, 1.0),
        (0.125, 1.0, 1.0),
        (0.1875, 0.80392156862745101, 0.80392156862745101),
        (0.25, 1.0, 1.0),
        (0.3125, 0.98039215686274506, 0.98039215686274506),
        (0.375, 0.14117647058823529, 0.14117647058823529),
        (0.4375, 0.10196078431372549, 0.10196078431372549),
        (0.5, 0.0, 0.0),
        (0.5625, 0.30196078431372547, 0.30196078431372547),
        (0.625, 0.3843137254901961, 0.3843137254901961),
        (0.6875, 0.37254901960784315, 0.37254901960784315),
        (0.75, 1.0, 1.0),
        (0.8125, 0.96862745098039216, 0.96862745098039216),
        (0.875, 0.97254901960784312, 0.97254901960784312),
        (0.9375, 0.62745098039215685, 0.62745098039215685),
        (1.0, 0.7686274509803922, 0.7686274509803922)]
}

_Gray5_data = {
    'blue': [
        (0.0, 0.42352941176470588, 0.42352941176470588),
        (0.25, 0.53333333333333333, 0.53333333333333333),
        (0.5, 0.6588235294117647, 0.6588235294117647),
        (0.75, 0.81568627450980391, 0.81568627450980391),
        (1.0, 0.93725490196078431, 0.93725490196078431)],
    'green': [
        (0.0, 0.42352941176470588, 0.42352941176470588),
        (0.25, 0.53333333333333333, 0.53333333333333333),
        (0.5, 0.6588235294117647, 0.6588235294117647),
        (0.75, 0.81568627450980391, 0.81568627450980391),
        (1.0, 0.93725490196078431, 0.93725490196078431)],
    'red': [
        (0.0, 0.42352941176470588, 0.42352941176470588),
        (0.25, 0.53333333333333333, 0.53333333333333333),
        (0.5, 0.6588235294117647, 0.6588235294117647),
        (0.75, 0.81568627450980391, 0.81568627450980391),
        (1.0, 0.93725490196078431, 0.93725490196078431)]
}

_Gray9_data = {
    'blue': [
        (0.0, 0.37647058823529411, 0.37647058823529411),
        (0.125, 0.45098039215686275, 0.45098039215686275),
        (0.25, 0.52549019607843139, 0.52549019607843139),
        (0.375, 0.59999999999999998, 0.59999999999999998),
        (0.5, 0.67450980392156867, 0.67450980392156867),
        (0.625, 0.75294117647058822, 0.75294117647058822),
        (0.75, 0.82352941176470584, 0.82352941176470584),
        (0.875, 0.90196078431372551, 0.90196078431372551),
        (1.0, 0.97647058823529409, 0.97647058823529409)],
    'green': [
        (0.0, 0.37647058823529411, 0.37647058823529411),
        (0.125, 0.45098039215686275, 0.45098039215686275),
        (0.25, 0.52549019607843139, 0.52549019607843139),
        (0.375, 0.59999999999999998, 0.59999999999999998),
        (0.5, 0.67450980392156867, 0.67450980392156867),
        (0.625, 0.75294117647058822, 0.75294117647058822),
        (0.75, 0.82352941176470584, 0.82352941176470584),
        (0.875, 0.90196078431372551, 0.90196078431372551),
        (1.0, 0.97647058823529409, 0.97647058823529409)],
    'red': [
        (0.0, 0.37647058823529411, 0.37647058823529411),
        (0.125, 0.45098039215686275, 0.45098039215686275),
        (0.25, 0.52549019607843139, 0.52549019607843139),
        (0.375, 0.59999999999999998, 0.59999999999999998),
        (0.5, 0.67450980392156867, 0.67450980392156867),
        (0.625, 0.75294117647058822, 0.75294117647058822),
        (0.75, 0.82352941176470584, 0.82352941176470584),
        (0.875, 0.90196078431372551, 0.90196078431372551),
        (1.0, 0.97647058823529409, 0.97647058823529409)]
}

_SymGray12_data = {
    'blue': [
        (0.0, 0.75294117647058822, 0.75294117647058822),
        (0.090909090909090912, 0.80000000000000004, 0.80000000000000004),
        (0.18181818181818182, 0.84313725490196079, 0.84313725490196079),
        (0.27272727272727271, 0.8901960784313725, 0.8901960784313725),
        (0.36363636363636365, 0.93725490196078431, 0.93725490196078431),
        (0.45454545454545459, 0.98431372549019602, 0.98431372549019602),
        (0.54545454545454541, 0.69019607843137254, 0.69019607843137254),
        (0.63636363636363635, 0.63529411764705879, 0.63529411764705879),
        (0.72727272727272729, 0.57647058823529407, 0.57647058823529407),
        (0.81818181818181823, 0.52156862745098043, 0.52156862745098043),
        (0.90909090909090917, 0.46666666666666667, 0.46666666666666667),
        (1.0, 0.41176470588235292, 0.41176470588235292)],
    'green': [
        (0.0, 0.75294117647058822, 0.75294117647058822),
        (0.090909090909090912, 0.80000000000000004, 0.80000000000000004),
        (0.18181818181818182, 0.84313725490196079, 0.84313725490196079),
        (0.27272727272727271, 0.8901960784313725, 0.8901960784313725),
        (0.36363636363636365, 0.93725490196078431, 0.93725490196078431),
        (0.45454545454545459, 0.98431372549019602, 0.98431372549019602),
        (0.54545454545454541, 0.69019607843137254, 0.69019607843137254),
        (0.63636363636363635, 0.63529411764705879, 0.63529411764705879),
        (0.72727272727272729, 0.57647058823529407, 0.57647058823529407),
        (0.81818181818181823, 0.52156862745098043, 0.52156862745098043),
        (0.90909090909090917, 0.46666666666666667, 0.46666666666666667),
        (1.0, 0.41176470588235292, 0.41176470588235292)],
    'red': [
        (0.0, 0.75294117647058822, 0.75294117647058822),
        (0.090909090909090912, 0.80000000000000004, 0.80000000000000004),
        (0.18181818181818182, 0.84313725490196079, 0.84313725490196079),
        (0.27272727272727271, 0.8901960784313725, 0.8901960784313725),
        (0.36363636363636365, 0.93725490196078431, 0.93725490196078431),
        (0.45454545454545459, 0.98431372549019602, 0.98431372549019602),
        (0.54545454545454541, 0.69019607843137254, 0.69019607843137254),
        (0.63636363636363635, 0.63529411764705879, 0.63529411764705879),
        (0.72727272727272729, 0.57647058823529407, 0.57647058823529407),
        (0.81818181818181823, 0.52156862745098043, 0.52156862745098043),
        (0.90909090909090917, 0.46666666666666667, 0.46666666666666667),
        (1.0, 0.41176470588235292, 0.41176470588235292)]
}

_Carbone42_data = {
    'blue': [
        (0.0, 0.63921568627450975, 0.63921568627450975),
        (0.024390243902439025, 0.55686274509803924, 0.55686274509803924),
        (0.04878048780487805, 0.58039215686274515, 0.58039215686274515),
        (0.073170731707317083, 0.6705882352941176, 0.6705882352941176),
        (0.097560975609756101, 0.76470588235294112, 0.76470588235294112),
        (0.12195121951219512, 0.89411764705882357, 0.89411764705882357),
        (0.14634146341463417, 0.99215686274509807, 0.99215686274509807),
        (0.17073170731707318, 0.99215686274509807, 0.99215686274509807),
        (0.1951219512195122, 0.59999999999999998, 0.59999999999999998),
        (0.21951219512195122, 0.36862745098039218, 0.36862745098039218),
        (0.24390243902439024, 0.0, 0.0),
        (0.26829268292682928, 0.0, 0.0),
        (0.29268292682926833, 0.0, 0.0),
        (0.31707317073170732, 0.058823529411764705, 0.058823529411764705),
        (0.34146341463414637, 0.17254901960784313, 0.17254901960784313),
        (0.36585365853658536, 0.28627450980392155, 0.28627450980392155),
        (0.3902439024390244, 0.40000000000000002, 0.40000000000000002),
        (0.41463414634146345, 0.51764705882352946, 0.51764705882352946),
        (0.43902439024390244, 0.63137254901960782, 0.63137254901960782),
        (0.46341463414634149, 0.74901960784313726, 0.74901960784313726),
        (0.48780487804878048, 0.81568627450980391, 0.81568627450980391),
        (0.51219512195121952, 0.69019607843137254, 0.69019607843137254),
        (0.53658536585365857, 0.34901960784313724, 0.34901960784313724),
        (0.56097560975609762, 0.0, 0.0),
        (0.58536585365853666, 0.019607843137254902, 0.019607843137254902),
        (0.6097560975609756, 0.054901960784313725, 0.054901960784313725),
        (0.63414634146341464, 0.082352941176470587, 0.082352941176470587),
        (0.65853658536585369, 0.11372549019607843, 0.11372549019607843),
        (0.68292682926829273, 0.14509803921568629, 0.14509803921568629),
        (0.70731707317073178, 0.17647058823529413, 0.17647058823529413),
        (0.73170731707317072, 0.20784313725490197, 0.20784313725490197),
        (0.75609756097560976, 0.23921568627450981, 0.23921568627450981),
        (0.78048780487804881, 0.24705882352941178, 0.24705882352941178),
        (0.80487804878048785, 0.24705882352941178, 0.24705882352941178),
        (0.8292682926829269, 0.29411764705882354, 0.29411764705882354),
        (0.85365853658536583, 0.37254901960784315, 0.37254901960784315),
        (0.87804878048780488, 0.0, 0.0),
        (0.90243902439024393, 0.18431372549019609, 0.18431372549019609),
        (0.92682926829268297, 0.27058823529411763, 0.27058823529411763),
        (0.95121951219512202, 0.35294117647058826, 0.35294117647058826),
        (0.97560975609756095, 0.35294117647058826, 0.35294117647058826),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.019607843137254902, 0.019607843137254902),
        (0.024390243902439025, 0.22352941176470589, 0.22352941176470589),
        (0.04878048780487805, 0.054901960784313725, 0.054901960784313725),
        (0.073170731707317083, 0.054901960784313725, 0.054901960784313725),
        (0.097560975609756101, 0.054901960784313725, 0.054901960784313725),
        (0.12195121951219512, 0.13725490196078433, 0.13725490196078433),
        (0.14634146341463417, 0.37254901960784315, 0.37254901960784315),
        (0.17073170731707318, 0.55686274509803924, 0.55686274509803924),
        (0.1951219512195122, 0.58823529411764708, 0.58823529411764708),
        (0.21951219512195122, 0.52156862745098043, 0.52156862745098043),
        (0.24390243902439024, 0.44313725490196076, 0.44313725490196076),
        (0.26829268292682928, 0.49019607843137253, 0.49019607843137253),
        (0.29268292682926833, 0.53725490196078429, 0.53725490196078429),
        (0.31707317073170732, 0.58431372549019611, 0.58431372549019611),
        (0.34146341463414637, 0.63137254901960782, 0.63137254901960782),
        (0.36585365853658536, 0.67843137254901964, 0.67843137254901964),
        (0.3902439024390244, 0.72156862745098038, 0.72156862745098038),
        (0.41463414634146345, 0.7686274509803922, 0.7686274509803922),
        (0.43902439024390244, 0.81568627450980391, 0.81568627450980391),
        (0.46341463414634149, 0.86274509803921573, 0.86274509803921573),
        (0.48780487804878048, 0.8901960784313725, 0.8901960784313725),
        (0.51219512195121952, 0.8901960784313725, 0.8901960784313725),
        (0.53658536585365857, 0.85882352941176465, 0.85882352941176465),
        (0.56097560975609762, 0.81176470588235294, 0.81176470588235294),
        (0.58536585365853666, 0.76470588235294112, 0.76470588235294112),
        (0.6097560975609756, 0.71764705882352942, 0.71764705882352942),
        (0.63414634146341464, 0.6705882352941176, 0.6705882352941176),
        (0.65853658536585369, 0.62352941176470589, 0.62352941176470589),
        (0.68292682926829273, 0.57647058823529407, 0.57647058823529407),
        (0.70731707317073178, 0.52941176470588236, 0.52941176470588236),
        (0.73170731707317072, 0.4823529411764706, 0.4823529411764706),
        (0.75609756097560976, 0.43529411764705883, 0.43529411764705883),
        (0.78048780487804881, 0.38823529411764707, 0.38823529411764707),
        (0.80487804878048785, 0.3411764705882353, 0.3411764705882353),
        (0.8292682926829269, 0.32549019607843138, 0.32549019607843138),
        (0.85365853658536583, 0.30980392156862746, 0.30980392156862746),
        (0.87804878048780488, 0.0, 0.0),
        (0.90243902439024393, 0.082352941176470587, 0.082352941176470587),
        (0.92682926829268297, 0.14509803921568629, 0.14509803921568629),
        (0.95121951219512202, 0.20784313725490197, 0.20784313725490197),
        (0.97560975609756095, 0.27058823529411763, 0.27058823529411763),
        (1.0, 0.011764705882352941, 0.011764705882352941)],
    'red': [
        (0.0, 0.46666666666666667, 0.46666666666666667),
        (0.024390243902439025, 0.40000000000000002, 0.40000000000000002),
        (0.04878048780487805, 0.16078431372549021, 0.16078431372549021),
        (0.073170731707317083, 0.22352941176470589, 0.22352941176470589),
        (0.097560975609756101, 0.28627450980392155, 0.28627450980392155),
        (0.12195121951219512, 0.34901960784313724, 0.34901960784313724),
        (0.14634146341463417, 0.41176470588235292, 0.41176470588235292),
        (0.17073170731707318, 0.44313725490196076, 0.44313725490196076),
        (0.1951219512195122, 0.27843137254901962, 0.27843137254901962),
        (0.21951219512195122, 0.18431372549019609, 0.18431372549019609),
        (0.24390243902439024, 0.0039215686274509803, 0.0039215686274509803),
        (0.26829268292682928, 0.0, 0.0),
        (0.29268292682926833, 0.0, 0.0),
        (0.31707317073170732, 0.058823529411764705, 0.058823529411764705),
        (0.34146341463414637, 0.17254901960784313, 0.17254901960784313),
        (0.36585365853658536, 0.28627450980392155, 0.28627450980392155),
        (0.3902439024390244, 0.40000000000000002, 0.40000000000000002),
        (0.41463414634146345, 0.51764705882352946, 0.51764705882352946),
        (0.43902439024390244, 0.63137254901960782, 0.63137254901960782),
        (0.46341463414634149, 0.74901960784313726, 0.74901960784313726),
        (0.48780487804878048, 0.81568627450980391, 0.81568627450980391),
        (0.51219512195121952, 0.92549019607843142, 0.92549019607843142),
        (0.53658536585365857, 0.93725490196078431, 0.93725490196078431),
        (0.56097560975609762, 0.93725490196078431, 0.93725490196078431),
        (0.58536585365853666, 0.93725490196078431, 0.93725490196078431),
        (0.6097560975609756, 0.93725490196078431, 0.93725490196078431),
        (0.63414634146341464, 0.92549019607843142, 0.92549019607843142),
        (0.65853658536585369, 0.87058823529411766, 0.87058823529411766),
        (0.68292682926829273, 0.81568627450980391, 0.81568627450980391),
        (0.70731707317073178, 0.75686274509803919, 0.75686274509803919),
        (0.73170731707317072, 0.70196078431372544, 0.70196078431372544),
        (0.75609756097560976, 0.6470588235294118, 0.6470588235294118),
        (0.78048780487804881, 0.58823529411764708, 0.58823529411764708),
        (0.80487804878048785, 0.53333333333333333, 0.53333333333333333),
        (0.8292682926829269, 0.4823529411764706, 0.4823529411764706),
        (0.85365853658536583, 0.62745098039215685, 0.62745098039215685),
        (0.87804878048780488, 0.62352941176470589, 0.62352941176470589),
        (0.90243902439024393, 0.71764705882352942, 0.71764705882352942),
        (0.92682926829268297, 0.81176470588235294, 0.81176470588235294),
        (0.95121951219512202, 0.8784313725490196, 0.8784313725490196),
        (0.97560975609756095, 0.94509803921568625, 0.94509803921568625),
        (1.0, 1.0, 1.0)]
}

# Colormaps from Data Graphics Research
# http://geography.uoregon.edu/datagraphics/color_scales.htm

_BrBu12_data = {
    'blue': [
        (0.0, 0.0, 0.0),
        (0.090909090909090912, 0.0, 0.0),
        (0.18181818181818182, 0.20999999999999999, 0.20999999999999999),
        (0.27272727272727271, 0.47999999999999998, 0.47999999999999998),
        (0.36363636363636365, 0.59499999999999997, 0.59499999999999997),
        (0.45454545454545459, 0.80800000000000005, 0.80800000000000005),
        (0.54545454545454541, 1.0, 1.0),
        (0.63636363636363635, 1.0, 1.0),
        (0.72727272727272729, 1.0, 1.0),
        (0.81818181818181823, 1.0, 1.0),
        (0.90909090909090917, 0.80000000000000004, 0.80000000000000004),
        (1.0, 0.59999999999999998, 0.59999999999999998)],
    'green': [
        (0.0, 0.10000000000000001, 0.10000000000000001),
        (0.090909090909090912, 0.187, 0.187),
        (0.18181818181818182, 0.379, 0.379),
        (0.27272727272727271, 0.60799999999999998, 0.60799999999999998),
        (0.36363636363636365, 0.68799999999999994, 0.68799999999999994),
        (0.45454545454545459, 0.85499999999999998, 0.85499999999999998),
        (0.54545454545454541, 0.99299999999999999, 0.99299999999999999),
        (0.63636363636363635, 0.97299999999999998, 0.97299999999999998),
        (0.72727272727272729, 0.93999999999999995, 0.93999999999999995),
        (0.81818181818181823, 0.89300000000000002, 0.89300000000000002),
        (0.90909090909090917, 0.66700000000000004, 0.66700000000000004),
        (1.0, 0.47999999999999998, 0.47999999999999998)],
    'red': [
        (0.0, 0.20000000000000001, 0.20000000000000001),
        (0.090909090909090912, 0.40000000000000002, 0.40000000000000002),
        (0.18181818181818182, 0.59999999999999998, 0.59999999999999998),
        (0.27272727272727271, 0.80000000000000004, 0.80000000000000004),
        (0.36363636363636365, 0.84999999999999998, 0.84999999999999998),
        (0.45454545454545459, 0.94999999999999996, 0.94999999999999996),
        (0.54545454545454541, 0.80000000000000004, 0.80000000000000004),
        (0.63636363636363635, 0.59999999999999998, 0.59999999999999998),
        (0.72727272727272729, 0.40000000000000002, 0.40000000000000002),
        (0.81818181818181823, 0.20000000000000001, 0.20000000000000001),
        (0.90909090909090917, 0.0, 0.0),
        (1.0, 0.0, 0.0)]
}

_GrMg16_data = {
    'blue': [
        (0.0, 0.0, 0.0),
        (0.066666666666666666, 0.0, 0.0),
        (0.13333333333333333, 0.0, 0.0),
        (0.20000000000000001, 0.0, 0.0),
        (0.26666666666666666, 0.316, 0.316),
        (0.33333333333333331, 0.52600000000000002, 0.52600000000000002),
        (0.40000000000000002, 0.73699999999999999, 0.73699999999999999),
        (0.46666666666666667, 1.0, 1.0),
        (0.53333333333333333, 1.0, 1.0),
        (0.59999999999999998, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.73333333333333328, 1.0, 1.0),
        (0.80000000000000004, 0.94699999999999995, 0.94699999999999995),
        (0.8666666666666667, 0.73699999999999999, 0.73699999999999999),
        (0.93333333333333335, 0.52600000000000002, 0.52600000000000002),
        (1.0, 0.316, 0.316)],
    'green': [
        (0.0, 0.316, 0.316),
        (0.066666666666666666, 0.52600000000000002, 0.52600000000000002),
        (0.13333333333333333, 0.73699999999999999, 0.73699999999999999),
        (0.20000000000000001, 0.94699999999999995, 0.94699999999999995),
        (0.26666666666666666, 1.0, 1.0),
        (0.33333333333333331, 1.0, 1.0),
        (0.40000000000000002, 1.0, 1.0),
        (0.46666666666666667, 1.0, 1.0),
        (0.53333333333333333, 0.94699999999999995, 0.94699999999999995),
        (0.59999999999999998, 0.73699999999999999, 0.73699999999999999),
        (0.66666666666666663, 0.52600000000000002, 0.52600000000000002),
        (0.73333333333333328, 0.316, 0.316),
        (0.80000000000000004, 0.0, 0.0),
        (0.8666666666666667, 0.0, 0.0),
        (0.93333333333333335, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.066666666666666666, 0.0, 0.0),
        (0.13333333333333333, 0.0, 0.0),
        (0.20000000000000001, 0.0, 0.0),
        (0.26666666666666666, 0.316, 0.316),
        (0.33333333333333331, 0.52600000000000002, 0.52600000000000002),
        (0.40000000000000002, 0.73699999999999999, 0.73699999999999999),
        (0.46666666666666667, 1.0, 1.0),
        (0.53333333333333333, 1.0, 1.0),
        (0.59999999999999998, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.73333333333333328, 1.0, 1.0),
        (0.80000000000000004, 0.94699999999999995, 0.94699999999999995),
        (0.8666666666666667, 0.73699999999999999, 0.73699999999999999),
        (0.93333333333333335, 0.52600000000000002, 0.52600000000000002),
        (1.0, 0.316, 0.316)]
}

_BrBu10_data = {
    'blue': [
        (0.0, 0.0, 0.0),
        (0.1111111111111111, 0.20999999999999999, 0.20999999999999999),
        (0.22222222222222221, 0.47999999999999998, 0.47999999999999998),
        (0.33333333333333331, 0.59499999999999997, 0.59499999999999997),
        (0.44444444444444442, 0.80800000000000005, 0.80800000000000005),
        (0.55555555555555558, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.77777777777777768, 1.0, 1.0),
        (0.88888888888888884, 1.0, 1.0),
        (1.0, 0.80000000000000004, 0.80000000000000004)],
    'green': [
        (0.0, 0.187, 0.187),
        (0.1111111111111111, 0.379, 0.379),
        (0.22222222222222221, 0.60799999999999998, 0.60799999999999998),
        (0.33333333333333331, 0.68799999999999994, 0.68799999999999994),
        (0.44444444444444442, 0.85499999999999998, 0.85499999999999998),
        (0.55555555555555558, 0.99299999999999999, 0.99299999999999999),
        (0.66666666666666663, 0.97299999999999998, 0.97299999999999998),
        (0.77777777777777768, 0.93999999999999995, 0.93999999999999995),
        (0.88888888888888884, 0.89300000000000002, 0.89300000000000002),
        (1.0, 0.66700000000000004, 0.66700000000000004)],
    'red': [
        (0.0, 0.40000000000000002, 0.40000000000000002),
        (0.1111111111111111, 0.59999999999999998, 0.59999999999999998),
        (0.22222222222222221, 0.80000000000000004, 0.80000000000000004),
        (0.33333333333333331, 0.84999999999999998, 0.84999999999999998),
        (0.44444444444444442, 0.94999999999999996, 0.94999999999999996),
        (0.55555555555555558, 0.80000000000000004, 0.80000000000000004),
        (0.66666666666666663, 0.59999999999999998, 0.59999999999999998),
        (0.77777777777777768, 0.40000000000000002, 0.40000000000000002),
        (0.88888888888888884, 0.20000000000000001, 0.20000000000000001),
        (1.0, 0.0, 0.0)]
}

_Bu10_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.1111111111111111, 1.0, 1.0),
        (0.22222222222222221, 1.0, 1.0),
        (0.33333333333333331, 1.0, 1.0),
        (0.44444444444444442, 1.0, 1.0),
        (0.55555555555555558, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.77777777777777768, 1.0, 1.0),
        (0.88888888888888884, 1.0, 1.0),
        (1.0, 1.0, 1.0)],
    'green': [
        (0.0, 1.0, 1.0),
        (0.1111111111111111, 0.98299999999999998, 0.98299999999999998),
        (0.22222222222222221, 0.94999999999999996, 0.94999999999999996),
        (0.33333333333333331, 0.90000000000000002, 0.90000000000000002),
        (0.44444444444444442, 0.83299999999999996, 0.83299999999999996),
        (0.55555555555555558, 0.75, 0.75),
        (0.66666666666666663, 0.65000000000000002, 0.65000000000000002),
        (0.77777777777777768, 0.53300000000000003, 0.53300000000000003),
        (0.88888888888888884, 0.40000000000000002, 0.40000000000000002),
        (1.0, 0.25, 0.25)],
    'red': [
        (0.0, 0.90000000000000002, 0.90000000000000002),
        (0.1111111111111111, 0.80000000000000004, 0.80000000000000004),
        (0.22222222222222221, 0.69999999999999996, 0.69999999999999996),
        (0.33333333333333331, 0.59999999999999998, 0.59999999999999998),
        (0.44444444444444442, 0.5, 0.5),
        (0.55555555555555558, 0.40000000000000002, 0.40000000000000002),
        (0.66666666666666663, 0.29999999999999999, 0.29999999999999999),
        (0.77777777777777768, 0.20000000000000001, 0.20000000000000001),
        (0.88888888888888884, 0.10000000000000001, 0.10000000000000001),
        (1.0, 0.0, 0.0)]
}

_BuDOr12_data = {
    'blue': [
        (0.0, 0.59999999999999998, 0.59999999999999998),
        (0.090909090909090912, 0.80000000000000004, 0.80000000000000004),
        (0.18181818181818182, 1.0, 1.0),
        (0.27272727272727271, 1.0, 1.0),
        (0.36363636363636365, 1.0, 1.0),
        (0.45454545454545459, 1.0, 1.0),
        (0.54545454545454541, 0.80000000000000004, 0.80000000000000004),
        (0.63636363636363635, 0.59999999999999998, 0.59999999999999998),
        (0.72727272727272729, 0.40000000000000002, 0.40000000000000002),
        (0.81818181818181823, 0.20000000000000001, 0.20000000000000001),
        (0.90909090909090917, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.56000000000000005, 0.56000000000000005),
        (0.090909090909090912, 0.76800000000000002, 0.76800000000000002),
        (0.18181818181818182, 0.97999999999999998, 0.97999999999999998),
        (0.27272727272727271, 0.98999999999999999, 0.98999999999999999),
        (0.36363636363636365, 0.997, 0.997),
        (0.45454545454545459, 1.0, 1.0),
        (0.54545454545454541, 0.90000000000000002, 0.90000000000000002),
        (0.63636363636363635, 0.79300000000000004, 0.79300000000000004),
        (0.72727272727272729, 0.68000000000000005, 0.68000000000000005),
        (0.81818181818181823, 0.56000000000000005, 0.56000000000000005),
        (0.90909090909090917, 0.34699999999999998, 0.34699999999999998),
        (1.0, 0.25, 0.25)],
    'red': [
        (0.0, 0.12, 0.12),
        (0.090909090909090912, 0.32000000000000001, 0.32000000000000001),
        (0.18181818181818182, 0.59999999999999998, 0.59999999999999998),
        (0.27272727272727271, 0.69999999999999996, 0.69999999999999996),
        (0.36363636363636365, 0.80000000000000004, 0.80000000000000004),
        (0.45454545454545459, 0.90000000000000002, 0.90000000000000002),
        (0.54545454545454541, 1.0, 1.0),
        (0.63636363636363635, 1.0, 1.0),
        (0.72727272727272729, 1.0, 1.0),
        (0.81818181818181823, 1.0, 1.0),
        (0.90909090909090917, 0.80000000000000004, 0.80000000000000004),
        (1.0, 0.59999999999999998, 0.59999999999999998)]
}

_StepSeq25_data = {
    'blue': [
        (0.0, 0.059999999999999998, 0.059999999999999998),
        (0.041666666666666664, 0.17499999999999999, 0.17499999999999999),
        (0.083333333333333329, 0.32000000000000001, 0.32000000000000001),
        (0.125, 0.495, 0.495),
        (0.16666666666666666, 0.69999999999999996, 0.69999999999999996),
        (0.20833333333333331, 0.059999999999999998, 0.059999999999999998),
        (0.25, 0.17499999999999999, 0.17499999999999999),
        (0.29166666666666663, 0.32000000000000001, 0.32000000000000001),
        (0.33333333333333331, 0.495, 0.495),
        (0.375, 0.69999999999999996, 0.69999999999999996),
        (0.41666666666666663, 0.059999999999999998, 0.059999999999999998),
        (0.45833333333333331, 0.17499999999999999, 0.17499999999999999),
        (0.5, 0.32000000000000001, 0.32000000000000001),
        (0.54166666666666663, 0.495, 0.495),
        (0.58333333333333326, 0.69999999999999996, 0.69999999999999996),
        (0.625, 0.59999999999999998, 0.59999999999999998),
        (0.66666666666666663, 0.69999999999999996, 0.69999999999999996),
        (0.70833333333333326, 0.80000000000000004, 0.80000000000000004),
        (0.75, 0.90000000000000002, 0.90000000000000002),
        (0.79166666666666663, 1.0, 1.0),
        (0.83333333333333326, 0.59999999999999998, 0.59999999999999998),
        (0.875, 0.69999999999999996, 0.69999999999999996),
        (0.91666666666666663, 0.80000000000000004, 0.80000000000000004),
        (0.95833333333333326, 0.90000000000000002, 0.90000000000000002),
        (1.0, 1.0, 1.0)],
    'green': [
        (0.0, 0.059999999999999998, 0.059999999999999998),
        (0.041666666666666664, 0.17499999999999999, 0.17499999999999999),
        (0.083333333333333329, 0.32000000000000001, 0.32000000000000001),
        (0.125, 0.495, 0.495),
        (0.16666666666666666, 0.69999999999999996, 0.69999999999999996),
        (0.20833333333333331, 0.33000000000000002, 0.33000000000000002),
        (0.25, 0.438, 0.438),
        (0.29166666666666663, 0.56000000000000005, 0.56000000000000005),
        (0.33333333333333331, 0.69699999999999995, 0.69699999999999995),
        (0.375, 0.84999999999999998, 0.84999999999999998),
        (0.41666666666666663, 0.59999999999999998, 0.59999999999999998),
        (0.45833333333333331, 0.69999999999999996, 0.69999999999999996),
        (0.5, 0.80000000000000004, 0.80000000000000004),
        (0.54166666666666663, 0.90000000000000002, 0.90000000000000002),
        (0.58333333333333326, 1.0, 1.0),
        (0.625, 0.41999999999999998, 0.41999999999999998),
        (0.66666666666666663, 0.52500000000000002, 0.52500000000000002),
        (0.70833333333333326, 0.64000000000000001, 0.64000000000000001),
        (0.75, 0.76500000000000001, 0.76500000000000001),
        (0.79166666666666663, 0.90000000000000002, 0.90000000000000002),
        (0.83333333333333326, 0.059999999999999998, 0.059999999999999998),
        (0.875, 0.17499999999999999, 0.17499999999999999),
        (0.91666666666666663, 0.32000000000000001, 0.32000000000000001),
        (0.95833333333333326, 0.495, 0.495),
        (1.0, 0.69999999999999996, 0.69999999999999996)],
    'red': [
        (0.0, 0.59999999999999998, 0.59999999999999998),
        (0.041666666666666664, 0.69999999999999996, 0.69999999999999996),
        (0.083333333333333329, 0.80000000000000004, 0.80000000000000004),
        (0.125, 0.90000000000000002, 0.90000000000000002),
        (0.16666666666666666, 1.0, 1.0),
        (0.20833333333333331, 0.59999999999999998, 0.59999999999999998),
        (0.25, 0.69999999999999996, 0.69999999999999996),
        (0.29166666666666663, 0.80000000000000004, 0.80000000000000004),
        (0.33333333333333331, 0.90000000000000002, 0.90000000000000002),
        (0.375, 1.0, 1.0),
        (0.41666666666666663, 0.41999999999999998, 0.41999999999999998),
        (0.45833333333333331, 0.52500000000000002, 0.52500000000000002),
        (0.5, 0.64000000000000001, 0.64000000000000001),
        (0.54166666666666663, 0.76500000000000001, 0.76500000000000001),
        (0.58333333333333326, 0.90000000000000002, 0.90000000000000002),
        (0.625, 0.059999999999999998, 0.059999999999999998),
        (0.66666666666666663, 0.17499999999999999, 0.17499999999999999),
        (0.70833333333333326, 0.32000000000000001, 0.32000000000000001),
        (0.75, 0.495, 0.495),
        (0.79166666666666663, 0.69999999999999996, 0.69999999999999996),
        (0.83333333333333326, 0.14999999999999999, 0.14999999999999999),
        (0.875, 0.26200000000000001, 0.26200000000000001),
        (0.91666666666666663, 0.40000000000000002, 0.40000000000000002),
        (0.95833333333333326, 0.56200000000000006, 0.56200000000000006),
        (1.0, 0.75, 0.75)]
}

_RdYlBu11b_data = {
    'blue': [
        (0.0, 0.13, 0.13),
        (0.10000000000000001, 0.19600000000000001, 0.19600000000000001),
        (0.20000000000000001, 0.37, 0.37),
        (0.30000000000000004, 0.45000000000000001, 0.45000000000000001),
        (0.40000000000000002, 0.59999999999999998, 0.59999999999999998),
        (0.5, 0.75, 0.75),
        (0.60000000000000009, 1.0, 1.0),
        (0.70000000000000007, 1.0, 1.0),
        (0.80000000000000004, 1.0, 1.0),
        (0.90000000000000002, 1.0, 1.0),
        (1.0, 1.0, 1.0)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.10000000000000001, 0.14999999999999999, 0.14999999999999999),
        (0.20000000000000001, 0.42999999999999999, 0.42999999999999999),
        (0.30000000000000004, 0.68000000000000005, 0.68000000000000005),
        (0.40000000000000002, 0.88, 0.88),
        (0.5, 1.0, 1.0),
        (0.60000000000000009, 1.0, 1.0),
        (0.70000000000000007, 0.96999999999999997, 0.96999999999999997),
        (0.80000000000000004, 0.84999999999999998, 0.84999999999999998),
        (0.90000000000000002, 0.63, 0.63),
        (1.0, 0.29999999999999999, 0.29999999999999999)],
    'red': [
        (0.0, 0.65000000000000002, 0.65000000000000002),
        (0.10000000000000001, 0.84999999999999998, 0.84999999999999998),
        (0.20000000000000001, 0.96999999999999997, 0.96999999999999997),
        (0.30000000000000004, 1.0, 1.0),
        (0.40000000000000002, 1.0, 1.0),
        (0.5, 1.0, 1.0),
        (0.60000000000000009, 0.88, 0.88),
        (0.70000000000000007, 0.67000000000000004, 0.67000000000000004),
        (0.80000000000000004, 0.45000000000000001, 0.45000000000000001),
        (0.90000000000000002, 0.25, 0.25),
        (1.0, 0.14999999999999999, 0.14999999999999999)]
}

_Bu7_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.16666666666666666, 1.0, 1.0),
        (0.33333333333333331, 1.0, 1.0),
        (0.5, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.83333333333333326, 0.80000000000000004, 0.80000000000000004),
        (1.0, 0.59999999999999998, 0.59999999999999998)],
    'green': [
        (0.0, 1.0, 1.0),
        (0.16666666666666666, 0.99299999999999999, 0.99299999999999999),
        (0.33333333333333331, 0.97299999999999998, 0.97299999999999998),
        (0.5, 0.93999999999999995, 0.93999999999999995),
        (0.66666666666666663, 0.89300000000000002, 0.89300000000000002),
        (0.83333333333333326, 0.66700000000000004, 0.66700000000000004),
        (1.0, 0.47999999999999998, 0.47999999999999998)],
    'red': [
        (0.0, 1.0, 1.0),
        (0.16666666666666666, 0.80000000000000004, 0.80000000000000004),
        (0.33333333333333331, 0.59999999999999998, 0.59999999999999998),
        (0.5, 0.40000000000000002, 0.40000000000000002),
        (0.66666666666666663, 0.20000000000000001, 0.20000000000000001),
        (0.83333333333333326, 0.0, 0.0),
        (1.0, 0.0, 0.0)]
}

_BuOr12_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.090909090909090912, 1.0, 1.0),
        (0.18181818181818182, 1.0, 1.0),
        (0.27272727272727271, 1.0, 1.0),
        (0.36363636363636365, 1.0, 1.0),
        (0.45454545454545459, 1.0, 1.0),
        (0.54545454545454541, 0.80000000000000004, 0.80000000000000004),
        (0.63636363636363635, 0.59999999999999998, 0.59999999999999998),
        (0.72727272727272729, 0.40000000000000002, 0.40000000000000002),
        (0.81818181818181823, 0.20000000000000001, 0.20000000000000001),
        (0.90909090909090917, 0.10000000000000001, 0.10000000000000001),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.16700000000000001, 0.16700000000000001),
        (0.090909090909090912, 0.40000000000000002, 0.40000000000000002),
        (0.18181818181818182, 0.59999999999999998, 0.59999999999999998),
        (0.27272727272727271, 0.80000000000000004, 0.80000000000000004),
        (0.36363636363636365, 0.93300000000000005, 0.93300000000000005),
        (0.45454545454545459, 1.0, 1.0),
        (0.54545454545454541, 1.0, 1.0),
        (0.63636363636363635, 0.93300000000000005, 0.93300000000000005),
        (0.72727272727272729, 0.80000000000000004, 0.80000000000000004),
        (0.81818181818181823, 0.59999999999999998, 0.59999999999999998),
        (0.90909090909090917, 0.40000000000000002, 0.40000000000000002),
        (1.0, 0.16700000000000001, 0.16700000000000001)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.090909090909090912, 0.10000000000000001, 0.10000000000000001),
        (0.18181818181818182, 0.20000000000000001, 0.20000000000000001),
        (0.27272727272727271, 0.40000000000000002, 0.40000000000000002),
        (0.36363636363636365, 0.59999999999999998, 0.59999999999999998),
        (0.45454545454545459, 0.80000000000000004, 0.80000000000000004),
        (0.54545454545454541, 1.0, 1.0),
        (0.63636363636363635, 1.0, 1.0),
        (0.72727272727272729, 1.0, 1.0),
        (0.81818181818181823, 1.0, 1.0),
        (0.90909090909090917, 1.0, 1.0),
        (1.0, 1.0, 1.0)]
}

_BuGr14_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.076923076923076927, 1.0, 1.0),
        (0.15384615384615385, 1.0, 1.0),
        (0.23076923076923078, 1.0, 1.0),
        (0.30769230769230771, 1.0, 1.0),
        (0.38461538461538464, 1.0, 1.0),
        (0.46153846153846156, 1.0, 1.0),
        (0.53846153846153855, 0.90000000000000002, 0.90000000000000002),
        (0.61538461538461542, 0.80000000000000004, 0.80000000000000004),
        (0.69230769230769229, 0.69999999999999996, 0.69999999999999996),
        (0.76923076923076927, 0.59999999999999998, 0.59999999999999998),
        (0.84615384615384626, 0.40000000000000002, 0.40000000000000002),
        (0.92307692307692313, 0.20000000000000001, 0.20000000000000001),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.076923076923076927, 0.20000000000000001, 0.20000000000000001),
        (0.15384615384615385, 0.40000000000000002, 0.40000000000000002),
        (0.23076923076923078, 0.59999999999999998, 0.59999999999999998),
        (0.30769230769230771, 0.69999999999999996, 0.69999999999999996),
        (0.38461538461538464, 0.80000000000000004, 0.80000000000000004),
        (0.46153846153846156, 0.90000000000000002, 0.90000000000000002),
        (0.53846153846153855, 1.0, 1.0),
        (0.61538461538461542, 1.0, 1.0),
        (0.69230769230769229, 1.0, 1.0),
        (0.76923076923076927, 1.0, 1.0),
        (0.84615384615384626, 1.0, 1.0),
        (0.92307692307692313, 1.0, 1.0),
        (1.0, 1.0, 1.0)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.076923076923076927, 0.20000000000000001, 0.20000000000000001),
        (0.15384615384615385, 0.40000000000000002, 0.40000000000000002),
        (0.23076923076923078, 0.59999999999999998, 0.59999999999999998),
        (0.30769230769230771, 0.69999999999999996, 0.69999999999999996),
        (0.38461538461538464, 0.80000000000000004, 0.80000000000000004),
        (0.46153846153846156, 0.90000000000000002, 0.90000000000000002),
        (0.53846153846153855, 0.90000000000000002, 0.90000000000000002),
        (0.61538461538461542, 0.80000000000000004, 0.80000000000000004),
        (0.69230769230769229, 0.69999999999999996, 0.69999999999999996),
        (0.76923076923076927, 0.59999999999999998, 0.59999999999999998),
        (0.84615384615384626, 0.40000000000000002, 0.40000000000000002),
        (0.92307692307692313, 0.20000000000000001, 0.20000000000000001),
        (1.0, 0.0, 0.0)]
}

_BuDRd18_data = {
    'blue': [
        (0.0, 0.84999999999999998, 0.84999999999999998),
        (0.058823529411764705, 0.96999999999999997, 0.96999999999999997),
        (0.11764705882352941, 1.0, 1.0),
        (0.1764705882352941, 1.0, 1.0),
        (0.23529411764705882, 1.0, 1.0),
        (0.29411764705882354, 1.0, 1.0),
        (0.3529411764705882, 1.0, 1.0),
        (0.41176470588235292, 1.0, 1.0),
        (0.47058823529411764, 1.0, 1.0),
        (0.52941176470588236, 0.92000000000000004, 0.92000000000000004),
        (0.58823529411764708, 0.73999999999999999, 0.73999999999999999),
        (0.6470588235294118, 0.59999999999999998, 0.59999999999999998),
        (0.70588235294117641, 0.46000000000000002, 0.46000000000000002),
        (0.76470588235294112, 0.34000000000000002, 0.34000000000000002),
        (0.82352941176470584, 0.23999999999999999, 0.23999999999999999),
        (0.88235294117647056, 0.20999999999999999, 0.20999999999999999),
        (0.94117647058823528, 0.187, 0.187),
        (1.0, 0.13, 0.13)],
    'green': [
        (0.0, 0.0, 0.0),
        (0.058823529411764705, 0.112, 0.112),
        (0.11764705882352941, 0.34200000000000003, 0.34200000000000003),
        (0.1764705882352941, 0.53100000000000003, 0.53100000000000003),
        (0.23529411764705882, 0.69199999999999995, 0.69199999999999995),
        (0.29411764705882354, 0.82899999999999996, 0.82899999999999996),
        (0.3529411764705882, 0.92000000000000004, 0.92000000000000004),
        (0.41176470588235292, 0.97799999999999998, 0.97799999999999998),
        (0.47058823529411764, 1.0, 1.0),
        (0.52941176470588236, 1.0, 1.0),
        (0.58823529411764708, 0.94799999999999995, 0.94799999999999995),
        (0.6470588235294118, 0.83999999999999997, 0.83999999999999997),
        (0.70588235294117641, 0.67600000000000005, 0.67600000000000005),
        (0.76470588235294112, 0.47199999999999998, 0.47199999999999998),
        (0.82352941176470584, 0.23999999999999999, 0.23999999999999999),
        (0.88235294117647056, 0.155, 0.155),
        (0.94117647058823528, 0.085000000000000006, 0.085000000000000006),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.14199999999999999, 0.14199999999999999),
        (0.058823529411764705, 0.097000000000000003, 0.097000000000000003),
        (0.11764705882352941, 0.16, 0.16),
        (0.1764705882352941, 0.23999999999999999, 0.23999999999999999),
        (0.23529411764705882, 0.34000000000000002, 0.34000000000000002),
        (0.29411764705882354, 0.46000000000000002, 0.46000000000000002),
        (0.3529411764705882, 0.59999999999999998, 0.59999999999999998),
        (0.41176470588235292, 0.73999999999999999, 0.73999999999999999),
        (0.47058823529411764, 0.92000000000000004, 0.92000000000000004),
        (0.52941176470588236, 1.0, 1.0),
        (0.58823529411764708, 1.0, 1.0),
        (0.6470588235294118, 1.0, 1.0),
        (0.70588235294117641, 1.0, 1.0),
        (0.76470588235294112, 1.0, 1.0),
        (0.82352941176470584, 1.0, 1.0),
        (0.88235294117647056, 0.96999999999999997, 0.96999999999999997),
        (0.94117647058823528, 0.84999999999999998, 0.84999999999999998),
        (1.0, 0.65000000000000002, 0.65000000000000002)]
}

_BuDOr18_data = {
    'blue': [
        (0.0, 0.40000000000000002, 0.40000000000000002),
        (0.058823529411764705, 0.59999999999999998, 0.59999999999999998),
        (0.11764705882352941, 0.80000000000000004, 0.80000000000000004),
        (0.1764705882352941, 1.0, 1.0),
        (0.23529411764705882, 1.0, 1.0),
        (0.29411764705882354, 1.0, 1.0),
        (0.3529411764705882, 1.0, 1.0),
        (0.41176470588235292, 1.0, 1.0),
        (0.47058823529411764, 1.0, 1.0),
        (0.52941176470588236, 1.0, 1.0),
        (0.58823529411764708, 0.80000000000000004, 0.80000000000000004),
        (0.6470588235294118, 0.59999999999999998, 0.59999999999999998),
        (0.70588235294117641, 0.40000000000000002, 0.40000000000000002),
        (0.76470588235294112, 0.20000000000000001, 0.20000000000000001),
        (0.82352941176470584, 0.0, 0.0),
        (0.88235294117647056, 0.0, 0.0),
        (0.94117647058823528, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.40000000000000002, 0.40000000000000002),
        (0.058823529411764705, 0.59999999999999998, 0.59999999999999998),
        (0.11764705882352941, 0.80000000000000004, 0.80000000000000004),
        (0.1764705882352941, 1.0, 1.0),
        (0.23529411764705882, 1.0, 1.0),
        (0.29411764705882354, 1.0, 1.0),
        (0.3529411764705882, 1.0, 1.0),
        (0.41176470588235292, 1.0, 1.0),
        (0.47058823529411764, 1.0, 1.0),
        (0.52941176470588236, 1.0, 1.0),
        (0.58823529411764708, 0.90000000000000002, 0.90000000000000002),
        (0.6470588235294118, 0.79300000000000004, 0.79300000000000004),
        (0.70588235294117641, 0.68000000000000005, 0.68000000000000005),
        (0.76470588235294112, 0.56000000000000005, 0.56000000000000005),
        (0.82352941176470584, 0.433, 0.433),
        (0.88235294117647056, 0.33300000000000002, 0.33300000000000002),
        (0.94117647058823528, 0.23999999999999999, 0.23999999999999999),
        (1.0, 0.153, 0.153)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.058823529411764705, 0.0, 0.0),
        (0.11764705882352941, 0.0, 0.0),
        (0.1764705882352941, 0.0, 0.0),
        (0.23529411764705882, 0.20000000000000001, 0.20000000000000001),
        (0.29411764705882354, 0.40000000000000002, 0.40000000000000002),
        (0.3529411764705882, 0.59999999999999998, 0.59999999999999998),
        (0.41176470588235292, 0.69999999999999996, 0.69999999999999996),
        (0.47058823529411764, 0.80000000000000004, 0.80000000000000004),
        (0.52941176470588236, 0.90000000000000002, 0.90000000000000002),
        (0.58823529411764708, 1.0, 1.0),
        (0.6470588235294118, 1.0, 1.0),
        (0.70588235294117641, 1.0, 1.0),
        (0.76470588235294112, 1.0, 1.0),
        (0.82352941176470584, 1.0, 1.0),
        (0.88235294117647056, 0.80000000000000004, 0.80000000000000004),
        (0.94117647058823528, 0.59999999999999998, 0.59999999999999998),
        (1.0, 0.40000000000000002, 0.40000000000000002)]
}

_BuOr8_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.14285714285714285, 1.0, 1.0),
        (0.2857142857142857, 1.0, 1.0),
        (0.42857142857142855, 1.0, 1.0),
        (0.5714285714285714, 0.80000000000000004, 0.80000000000000004),
        (0.71428571428571419, 0.59999999999999998, 0.59999999999999998),
        (0.8571428571428571, 0.29999999999999999, 0.29999999999999999),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.5, 0.5),
        (0.14285714285714285, 0.76700000000000002, 0.76700000000000002),
        (0.2857142857142857, 0.93300000000000005, 0.93300000000000005),
        (0.42857142857142855, 1.0, 1.0),
        (0.5714285714285714, 1.0, 1.0),
        (0.71428571428571419, 0.93300000000000005, 0.93300000000000005),
        (0.8571428571428571, 0.76700000000000002, 0.76700000000000002),
        (1.0, 0.5, 0.5)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.14285714285714285, 0.29999999999999999, 0.29999999999999999),
        (0.2857142857142857, 0.59999999999999998, 0.59999999999999998),
        (0.42857142857142855, 0.80000000000000004, 0.80000000000000004),
        (0.5714285714285714, 1.0, 1.0),
        (0.71428571428571419, 1.0, 1.0),
        (0.8571428571428571, 1.0, 1.0),
        (1.0, 1.0, 1.0)]
}

_Cat12_data = {
    'blue': [
        (0.0, 0.5, 0.5),
        (0.090909090909090912, 0.0, 0.0),
        (0.18181818181818182, 0.59999999999999998, 0.59999999999999998),
        (0.27272727272727271, 0.20000000000000001, 0.20000000000000001),
        (0.36363636363636365, 0.55000000000000004, 0.55000000000000004),
        (0.45454545454545459, 0.0, 0.0),
        (0.54545454545454541, 1.0, 1.0),
        (0.63636363636363635, 1.0, 1.0),
        (0.72727272727272729, 1.0, 1.0),
        (0.81818181818181823, 1.0, 1.0),
        (0.90909090909090917, 0.75, 0.75),
        (1.0, 0.20000000000000001, 0.20000000000000001)],
    'green': [
        (0.0, 0.75, 0.75),
        (0.090909090909090912, 0.5, 0.5),
        (0.18181818181818182, 1.0, 1.0),
        (0.27272727272727271, 1.0, 1.0),
        (0.36363636363636365, 1.0, 1.0),
        (0.45454545454545459, 1.0, 1.0),
        (0.54545454545454541, 0.93000000000000005, 0.93000000000000005),
        (0.63636363636363635, 0.69999999999999996, 0.69999999999999996),
        (0.72727272727272729, 0.75, 0.75),
        (0.81818181818181823, 0.29999999999999999, 0.29999999999999999),
        (0.90909090909090917, 0.59999999999999998, 0.59999999999999998),
        (1.0, 0.10000000000000001, 0.10000000000000001)],
    'red': [
        (0.0, 1.0, 1.0),
        (0.090909090909090912, 1.0, 1.0),
        (0.18181818181818182, 1.0, 1.0),
        (0.27272727272727271, 1.0, 1.0),
        (0.36363636363636365, 0.69999999999999996, 0.69999999999999996),
        (0.45454545454545459, 0.20000000000000001, 0.20000000000000001),
        (0.54545454545454541, 0.65000000000000002, 0.65000000000000002),
        (0.63636363636363635, 0.10000000000000001, 0.10000000000000001),
        (0.72727272727272729, 0.80000000000000004, 0.80000000000000004),
        (0.81818181818181823, 0.40000000000000002, 0.40000000000000002),
        (0.90909090909090917, 1.0, 1.0),
        (1.0, 0.90000000000000002, 0.90000000000000002)]
}

_BuGy8_data = {
    'blue': [
        (0.0, 0.80000000000000004, 0.80000000000000004),
        (0.14285714285714285, 1.0, 1.0),
        (0.2857142857142857, 1.0, 1.0),
        (0.42857142857142855, 1.0, 1.0),
        (0.5714285714285714, 0.90000000000000002, 0.90000000000000002),
        (0.71428571428571419, 0.59999999999999998, 0.59999999999999998),
        (0.8571428571428571, 0.40000000000000002, 0.40000000000000002),
        (1.0, 0.20000000000000001, 0.20000000000000001)],
    'green': [
        (0.0, 0.59999999999999998, 0.59999999999999998),
        (0.14285714285714285, 0.90000000000000002, 0.90000000000000002),
        (0.2857142857142857, 1.0, 1.0),
        (0.42857142857142855, 1.0, 1.0),
        (0.5714285714285714, 0.90000000000000002, 0.90000000000000002),
        (0.71428571428571419, 0.59999999999999998, 0.59999999999999998),
        (0.8571428571428571, 0.40000000000000002, 0.40000000000000002),
        (1.0, 0.20000000000000001, 0.20000000000000001)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.14285714285714285, 0.40000000000000002, 0.40000000000000002),
        (0.2857142857142857, 0.59999999999999998, 0.59999999999999998),
        (0.42857142857142855, 0.80000000000000004, 0.80000000000000004),
        (0.5714285714285714, 0.90000000000000002, 0.90000000000000002),
        (0.71428571428571419, 0.59999999999999998, 0.59999999999999998),
        (0.8571428571428571, 0.40000000000000002, 0.40000000000000002),
        (1.0, 0.20000000000000001, 0.20000000000000001)]
}

_BuOrR14_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.076923076923076927, 1.0, 1.0),
        (0.15384615384615385, 1.0, 1.0),
        (0.23076923076923078, 1.0, 1.0),
        (0.30769230769230771, 1.0, 1.0),
        (0.38461538461538464, 1.0, 1.0),
        (0.46153846153846156, 1.0, 1.0),
        (0.53846153846153855, 0.80000000000000004, 0.80000000000000004),
        (0.61538461538461542, 0.59999999999999998, 0.59999999999999998),
        (0.69230769230769229, 0.0, 0.0),
        (0.76923076923076927, 0.0, 0.0),
        (0.84615384615384626, 0.0, 0.0),
        (0.92307692307692313, 0.0, 0.0),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.35299999999999998, 0.35299999999999998),
        (0.076923076923076927, 0.46700000000000003, 0.46700000000000003),
        (0.15384615384615385, 0.56699999999999995, 0.56699999999999995),
        (0.23076923076923078, 0.69999999999999996, 0.69999999999999996),
        (0.30769230769230771, 0.83299999999999996, 0.83299999999999996),
        (0.38461538461538464, 0.93300000000000005, 0.93300000000000005),
        (0.46153846153846156, 0.97999999999999998, 0.97999999999999998),
        (0.53846153846153855, 1.0, 1.0),
        (0.61538461538461542, 1.0, 1.0),
        (0.69230769230769229, 1.0, 1.0),
        (0.76923076923076927, 0.80000000000000004, 0.80000000000000004),
        (0.84615384615384626, 0.59999999999999998, 0.59999999999999998),
        (0.92307692307692313, 0.40000000000000002, 0.40000000000000002),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.029999999999999999, 0.029999999999999999),
        (0.076923076923076927, 0.20000000000000001, 0.20000000000000001),
        (0.15384615384615385, 0.34999999999999998, 0.34999999999999998),
        (0.23076923076923078, 0.55000000000000004, 0.55000000000000004),
        (0.30769230769230771, 0.75, 0.75),
        (0.38461538461538464, 0.90000000000000002, 0.90000000000000002),
        (0.46153846153846156, 0.96999999999999997, 0.96999999999999997),
        (0.53846153846153855, 1.0, 1.0),
        (0.61538461538461542, 1.0, 1.0),
        (0.69230769230769229, 1.0, 1.0),
        (0.76923076923076927, 1.0, 1.0),
        (0.84615384615384626, 1.0, 1.0),
        (0.92307692307692313, 1.0, 1.0),
        (1.0, 1.0, 1.0)]
}

_BuOr10_data = {
    'blue': [
        (0.0, 1.0, 1.0),
        (0.1111111111111111, 1.0, 1.0),
        (0.22222222222222221, 1.0, 1.0),
        (0.33333333333333331, 1.0, 1.0),
        (0.44444444444444442, 1.0, 1.0),
        (0.55555555555555558, 0.80000000000000004, 0.80000000000000004),
        (0.66666666666666663, 0.59999999999999998, 0.59999999999999998),
        (0.77777777777777768, 0.40000000000000002, 0.40000000000000002),
        (0.88888888888888884, 0.20000000000000001, 0.20000000000000001),
        (1.0, 0.0, 0.0)],
    'green': [
        (0.0, 0.33300000000000002, 0.33300000000000002),
        (0.1111111111111111, 0.59999999999999998, 0.59999999999999998),
        (0.22222222222222221, 0.80000000000000004, 0.80000000000000004),
        (0.33333333333333331, 0.93300000000000005, 0.93300000000000005),
        (0.44444444444444442, 1.0, 1.0),
        (0.55555555555555558, 1.0, 1.0),
        (0.66666666666666663, 0.93300000000000005, 0.93300000000000005),
        (0.77777777777777768, 0.80000000000000004, 0.80000000000000004),
        (0.88888888888888884, 0.59999999999999998, 0.59999999999999998),
        (1.0, 0.33300000000000002, 0.33300000000000002)],
    'red': [
        (0.0, 0.0, 0.0),
        (0.1111111111111111, 0.20000000000000001, 0.20000000000000001),
        (0.22222222222222221, 0.40000000000000002, 0.40000000000000002),
        (0.33333333333333331, 0.59999999999999998, 0.59999999999999998),
        (0.44444444444444442, 0.80000000000000004, 0.80000000000000004),
        (0.55555555555555558, 1.0, 1.0),
        (0.66666666666666663, 1.0, 1.0),
        (0.77777777777777768, 1.0, 1.0),
        (0.88888888888888884, 1.0, 1.0),
        (1.0, 1.0, 1.0)]
}

_BuDRd12_data = {
    'blue': [
        (0.0, 0.84999999999999998, 0.84999999999999998),
        (0.090909090909090912, 1.0, 1.0),
        (0.18181818181818182, 1.0, 1.0),
        (0.27272727272727271, 1.0, 1.0),
        (0.36363636363636365, 1.0, 1.0),
        (0.45454545454545459, 1.0, 1.0),
        (0.54545454545454541, 0.75, 0.75),
        (0.63636363636363635, 0.59999999999999998, 0.59999999999999998),
        (0.72727272727272729, 0.45000000000000001, 0.45000000000000001),
        (0.81818181818181823, 0.37, 0.37),
        (0.90909090909090917, 0.19600000000000001, 0.19600000000000001),
        (1.0, 0.13, 0.13)],
    'green': [
        (0.0, 0.042999999999999997, 0.042999999999999997),
        (0.090909090909090912, 0.30599999999999999, 0.30599999999999999),
        (0.18181818181818182, 0.63, 0.63),
        (0.27272727272727271, 0.85299999999999998, 0.85299999999999998),
        (0.36363636363636365, 0.97299999999999998, 0.97299999999999998),
        (0.45454545454545459, 1.0, 1.0),
        (0.54545454545454541, 1.0, 1.0),
        (0.63636363636363635, 0.88, 0.88),
        (0.72727272727272729, 0.67900000000000005, 0.67900000000000005),
        (0.81818181818181823, 0.42999999999999999, 0.42999999999999999),
        (0.90909090909090917, 0.14999999999999999, 0.14999999999999999),
        (1.0, 0.0, 0.0)],
    'red': [
        (0.0, 0.16400000000000001, 0.16400000000000001),
        (0.090909090909090912, 0.14999999999999999, 0.14999999999999999),
        (0.18181818181818182, 0.25, 0.25),
        (0.27272727272727271, 0.45000000000000001, 0.45000000000000001),
        (0.36363636363636365, 0.67000000000000004, 0.67000000000000004),
        (0.45454545454545459, 0.88, 0.88),
        (0.54545454545454541, 1.0, 1.0),
        (0.63636363636363635, 1.0, 1.0),
        (0.72727272727272729, 1.0, 1.0),
        (0.81818181818181823, 0.96999999999999997, 0.96999999999999997),
        (0.90909090909090917, 0.84999999999999998, 0.84999999999999998),
        (1.0, 0.65000000000000002, 0.65000000000000002)]
}

datad = {
    'NWSRef': _NWSRef_data,
    'NWSVel': _NWSVel_data,
    'NWS_SPW': _NWS_SPW_data,
    'RefDiff': _RefDiff_data,
    'Carbone11': _Carbone11_data,
    'Carbone17': _Carbone17_data,
    'RRate11': _RRate11_data,
    'BlueBrown10': _BlueBrown10_data,
    'BlueBrown11': _BlueBrown11_data,
    'Theodore16': _Theodore16_data,
    'EWilson17': _EWilson17_data,
    'Wild25': _Wild25_data,
    'SCook18': _SCook18_data,
    'PD17': _PD17_data,
    'Gray5': _Gray5_data,
    'Gray9': _Gray9_data,
    'SymGray12': _SymGray12_data,
    'Carbone42': _Carbone42_data,
    'BrBu12': _BrBu12_data,
    'GrMg16': _GrMg16_data,
    'BrBu10': _BrBu10_data,
    'Bu10': _Bu10_data,
    'BuDOr12': _BuDOr12_data,
    'StepSeq25': _StepSeq25_data,
    'RdYlBu11b': _RdYlBu11b_data,
    'Bu7': _Bu7_data,
    'BuOr12': _BuOr12_data,
    'BuGr14': _BuGr14_data,
    'BuDRd18': _BuDRd18_data,
    'BuDOr18': _BuDOr18_data,
    'BuOr8': _BuOr8_data,
    'Cat12': _Cat12_data,
    'BuGy8': _BuGy8_data,
    'BuOrR14': _BuOrR14_data,
    'BuOr10': _BuOr10_data,
    'BuDRd12': _BuDRd12_data,
}
