# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AadMetadata(Model):
    """Azure Active Directory metadata used for secured connection to cluster.

    :param authority: The AAD authority url.
    :type authority: str
    :param client: The AAD client application Id.
    :type client: str
    :param cluster: The AAD cluster application Id.
    :type cluster: str
    :param login: The AAD login url.
    :type login: str
    :param redirect: The client application redirect address.
    :type redirect: str
    :param tenant: The AAD tenant Id.
    :type tenant: str
    """

    _attribute_map = {
        'authority': {'key': 'authority', 'type': 'str'},
        'client': {'key': 'client', 'type': 'str'},
        'cluster': {'key': 'cluster', 'type': 'str'},
        'login': {'key': 'login', 'type': 'str'},
        'redirect': {'key': 'redirect', 'type': 'str'},
        'tenant': {'key': 'tenant', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AadMetadata, self).__init__(**kwargs)
        self.authority = kwargs.get('authority', None)
        self.client = kwargs.get('client', None)
        self.cluster = kwargs.get('cluster', None)
        self.login = kwargs.get('login', None)
        self.redirect = kwargs.get('redirect', None)
        self.tenant = kwargs.get('tenant', None)


class AadMetadataObject(Model):
    """Azure Active Directory metadata object used for secured connection to
    cluster.

    :param type: The client authentication method.
    :type type: str
    :param metadata: Azure Active Directory metadata used for secured
     connection to cluster.
    :type metadata: ~azure.servicefabric.models.AadMetadata
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'AadMetadata'},
    }

    def __init__(self, **kwargs):
        super(AadMetadataObject, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.metadata = kwargs.get('metadata', None)


class ScalingMechanismDescription(Model):
    """Describes the mechanism for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartitionInstanceCountScaleMechanism,
    AddRemoveIncrementalNamedPartitionScalingMechanism

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'PartitionInstanceCount': 'PartitionInstanceCountScaleMechanism', 'AddRemoveIncrementalNamedPartition': 'AddRemoveIncrementalNamedPartitionScalingMechanism'}
    }

    def __init__(self, **kwargs):
        super(ScalingMechanismDescription, self).__init__(**kwargs)
        self.kind = None


class AddRemoveIncrementalNamedPartitionScalingMechanism(ScalingMechanismDescription):
    """Represents a scaling mechanism for adding or removing named partitions of a
    stateless service. Partition names are in the format '0','1''N-1'.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param min_partition_count: Required. Minimum number of named partitions
     of the service.
    :type min_partition_count: int
    :param max_partition_count: Required. Maximum number of named partitions
     of the service.
    :type max_partition_count: int
    :param scale_increment: Required. The number of instances to add or remove
     during a scaling operation.
    :type scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_partition_count': {'required': True},
        'max_partition_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'min_partition_count': {'key': 'MinPartitionCount', 'type': 'int'},
        'max_partition_count': {'key': 'MaxPartitionCount', 'type': 'int'},
        'scale_increment': {'key': 'ScaleIncrement', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AddRemoveIncrementalNamedPartitionScalingMechanism, self).__init__(**kwargs)
        self.min_partition_count = kwargs.get('min_partition_count', None)
        self.max_partition_count = kwargs.get('max_partition_count', None)
        self.scale_increment = kwargs.get('scale_increment', None)
        self.kind = 'AddRemoveIncrementalNamedPartition'


class AutoScalingMechanism(Model):
    """Describes the mechanism for performing auto scaling operation. Derived
    classes will describe the actual mechanism.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AddRemoveReplicaScalingMechanism

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AddRemoveReplica': 'AddRemoveReplicaScalingMechanism'}
    }

    def __init__(self, **kwargs):
        super(AutoScalingMechanism, self).__init__(**kwargs)
        self.kind = None


class AddRemoveReplicaScalingMechanism(AutoScalingMechanism):
    """Describes the horizontal auto scaling mechanism that adds or removes
    replicas (containers or container groups).

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param min_count: Required. Minimum number of containers (scale down won't
     be performed below this number).
    :type min_count: int
    :param max_count: Required. Maximum number of containers (scale up won't
     be performed above this number).
    :type max_count: int
    :param scale_increment: Required. Each time auto scaling is performed,
     this number of containers will be added or removed.
    :type scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_count': {'required': True},
        'max_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'min_count': {'key': 'minCount', 'type': 'int'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'scale_increment': {'key': 'scaleIncrement', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AddRemoveReplicaScalingMechanism, self).__init__(**kwargs)
        self.min_count = kwargs.get('min_count', None)
        self.max_count = kwargs.get('max_count', None)
        self.scale_increment = kwargs.get('scale_increment', None)
        self.kind = 'AddRemoveReplica'


class AnalysisEventMetadata(Model):
    """Metadata about an Analysis Event.

    :param delay: The analysis delay.
    :type delay: timedelta
    :param duration: The duration of analysis.
    :type duration: timedelta
    """

    _attribute_map = {
        'delay': {'key': 'Delay', 'type': 'duration'},
        'duration': {'key': 'Duration', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(AnalysisEventMetadata, self).__init__(**kwargs)
        self.delay = kwargs.get('delay', None)
        self.duration = kwargs.get('duration', None)


class BackupConfigurationInfo(Model):
    """Describes the backup configuration information.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApplicationBackupConfigurationInfo,
    ServiceBackupConfigurationInfo, PartitionBackupConfigurationInfo

    All required parameters must be populated in order to send to Azure.

    :param policy_name: The name of the backup policy which is applicable to
     this Service Fabric application or service or partition.
    :type policy_name: str
    :param policy_inherited_from: Specifies the scope at which the backup
     policy is applied. Possible values include: 'Invalid', 'Partition',
     'Service', 'Application'
    :type policy_inherited_from: str or
     ~azure.servicefabric.models.BackupPolicyScope
    :param suspension_info: Describes the backup suspension details.
    :type suspension_info: ~azure.servicefabric.models.BackupSuspensionInfo
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'policy_name': {'key': 'PolicyName', 'type': 'str'},
        'policy_inherited_from': {'key': 'PolicyInheritedFrom', 'type': 'str'},
        'suspension_info': {'key': 'SuspensionInfo', 'type': 'BackupSuspensionInfo'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Application': 'ApplicationBackupConfigurationInfo', 'Service': 'ServiceBackupConfigurationInfo', 'Partition': 'PartitionBackupConfigurationInfo'}
    }

    def __init__(self, **kwargs):
        super(BackupConfigurationInfo, self).__init__(**kwargs)
        self.policy_name = kwargs.get('policy_name', None)
        self.policy_inherited_from = kwargs.get('policy_inherited_from', None)
        self.suspension_info = kwargs.get('suspension_info', None)
        self.kind = None


class ApplicationBackupConfigurationInfo(BackupConfigurationInfo):
    """Backup configuration information for a specific Service Fabric application
    specifying what backup policy is being applied and suspend description, if
    any.

    All required parameters must be populated in order to send to Azure.

    :param policy_name: The name of the backup policy which is applicable to
     this Service Fabric application or service or partition.
    :type policy_name: str
    :param policy_inherited_from: Specifies the scope at which the backup
     policy is applied. Possible values include: 'Invalid', 'Partition',
     'Service', 'Application'
    :type policy_inherited_from: str or
     ~azure.servicefabric.models.BackupPolicyScope
    :param suspension_info: Describes the backup suspension details.
    :type suspension_info: ~azure.servicefabric.models.BackupSuspensionInfo
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'policy_name': {'key': 'PolicyName', 'type': 'str'},
        'policy_inherited_from': {'key': 'PolicyInheritedFrom', 'type': 'str'},
        'suspension_info': {'key': 'SuspensionInfo', 'type': 'BackupSuspensionInfo'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationBackupConfigurationInfo, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.kind = 'Application'


class BackupEntity(Model):
    """Describes the Service Fabric entity that is configured for backup.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApplicationBackupEntity, ServiceBackupEntity,
    PartitionBackupEntity

    All required parameters must be populated in order to send to Azure.

    :param entity_kind: Required. Constant filled by server.
    :type entity_kind: str
    """

    _validation = {
        'entity_kind': {'required': True},
    }

    _attribute_map = {
        'entity_kind': {'key': 'EntityKind', 'type': 'str'},
    }

    _subtype_map = {
        'entity_kind': {'Application': 'ApplicationBackupEntity', 'Service': 'ServiceBackupEntity', 'Partition': 'PartitionBackupEntity'}
    }

    def __init__(self, **kwargs):
        super(BackupEntity, self).__init__(**kwargs)
        self.entity_kind = None


class ApplicationBackupEntity(BackupEntity):
    """Identifies the Service Fabric application which is being backed up.

    All required parameters must be populated in order to send to Azure.

    :param entity_kind: Required. Constant filled by server.
    :type entity_kind: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    """

    _validation = {
        'entity_kind': {'required': True},
    }

    _attribute_map = {
        'entity_kind': {'key': 'EntityKind', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationBackupEntity, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.entity_kind = 'Application'


class ApplicationCapacityDescription(Model):
    """Describes capacity information for services of this application. This
    description can be used for describing the following.
    - Reserving the capacity for the services on the nodes
    - Limiting the total number of nodes that services of this application can
    run on
    - Limiting the custom capacity metrics to limit the total consumption of
    this metric by the services of this application.

    :param minimum_nodes: The minimum number of nodes where Service Fabric
     will reserve capacity for this application. Note that this does not mean
     that the services of this application will be placed on all of those
     nodes. If this property is set to zero, no capacity will be reserved. The
     value of this property cannot be more than the value of the MaximumNodes
     property.
    :type minimum_nodes: long
    :param maximum_nodes: The maximum number of nodes where Service Fabric
     will reserve capacity for this application. Note that this does not mean
     that the services of this application will be placed on all of those
     nodes. By default, the value of this property is zero and it means that
     the services can be placed on any node. Default value: 0 .
    :type maximum_nodes: long
    :param application_metrics: List of application capacity metric
     description.
    :type application_metrics:
     list[~azure.servicefabric.models.ApplicationMetricDescription]
    """

    _validation = {
        'minimum_nodes': {'minimum': 0},
        'maximum_nodes': {'minimum': 0},
    }

    _attribute_map = {
        'minimum_nodes': {'key': 'MinimumNodes', 'type': 'long'},
        'maximum_nodes': {'key': 'MaximumNodes', 'type': 'long'},
        'application_metrics': {'key': 'ApplicationMetrics', 'type': '[ApplicationMetricDescription]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationCapacityDescription, self).__init__(**kwargs)
        self.minimum_nodes = kwargs.get('minimum_nodes', None)
        self.maximum_nodes = kwargs.get('maximum_nodes', 0)
        self.application_metrics = kwargs.get('application_metrics', None)


class FabricEvent(Model):
    """Represents the base for all Fabric Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApplicationEvent, ClusterEvent, ContainerInstanceEvent,
    NodeEvent, PartitionEvent, ReplicaEvent, ServiceEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ApplicationEvent': 'ApplicationEvent', 'ClusterEvent': 'ClusterEvent', 'ContainerInstanceEvent': 'ContainerInstanceEvent', 'NodeEvent': 'NodeEvent', 'PartitionEvent': 'PartitionEvent', 'ReplicaEvent': 'ReplicaEvent', 'ServiceEvent': 'ServiceEvent'}
    }

    def __init__(self, **kwargs):
        super(FabricEvent, self).__init__(**kwargs)
        self.event_instance_id = kwargs.get('event_instance_id', None)
        self.category = kwargs.get('category', None)
        self.time_stamp = kwargs.get('time_stamp', None)
        self.has_correlated_events = kwargs.get('has_correlated_events', None)
        self.kind = None


class ApplicationEvent(FabricEvent):
    """Represents the base for all Application Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApplicationCreatedEvent, ApplicationDeletedEvent,
    ApplicationNewHealthReportEvent, ApplicationHealthReportExpiredEvent,
    ApplicationUpgradeCompletedEvent, ApplicationUpgradeDomainCompletedEvent,
    ApplicationUpgradeRollbackCompletedEvent,
    ApplicationUpgradeRollbackStartedEvent, ApplicationUpgradeStartedEvent,
    DeployedApplicationNewHealthReportEvent,
    DeployedApplicationHealthReportExpiredEvent, ApplicationProcessExitedEvent,
    ApplicationContainerInstanceExitedEvent,
    DeployedServicePackageNewHealthReportEvent,
    DeployedServicePackageHealthReportExpiredEvent,
    ChaosCodePackageRestartScheduledEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ApplicationCreated': 'ApplicationCreatedEvent', 'ApplicationDeleted': 'ApplicationDeletedEvent', 'ApplicationNewHealthReport': 'ApplicationNewHealthReportEvent', 'ApplicationHealthReportExpired': 'ApplicationHealthReportExpiredEvent', 'ApplicationUpgradeCompleted': 'ApplicationUpgradeCompletedEvent', 'ApplicationUpgradeDomainCompleted': 'ApplicationUpgradeDomainCompletedEvent', 'ApplicationUpgradeRollbackCompleted': 'ApplicationUpgradeRollbackCompletedEvent', 'ApplicationUpgradeRollbackStarted': 'ApplicationUpgradeRollbackStartedEvent', 'ApplicationUpgradeStarted': 'ApplicationUpgradeStartedEvent', 'DeployedApplicationNewHealthReport': 'DeployedApplicationNewHealthReportEvent', 'DeployedApplicationHealthReportExpired': 'DeployedApplicationHealthReportExpiredEvent', 'ApplicationProcessExited': 'ApplicationProcessExitedEvent', 'ApplicationContainerInstanceExited': 'ApplicationContainerInstanceExitedEvent', 'DeployedServicePackageNewHealthReport': 'DeployedServicePackageNewHealthReportEvent', 'DeployedServicePackageHealthReportExpired': 'DeployedServicePackageHealthReportExpiredEvent', 'ChaosCodePackageRestartScheduled': 'ChaosCodePackageRestartScheduledEvent'}
    }

    def __init__(self, **kwargs):
        super(ApplicationEvent, self).__init__(**kwargs)
        self.application_id = kwargs.get('application_id', None)
        self.kind = 'ApplicationEvent'


class ApplicationContainerInstanceExitedEvent(ApplicationEvent):
    """Container Exited event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param service_name: Required. Name of Service.
    :type service_name: str
    :param service_package_name: Required. Name of Service package.
    :type service_package_name: str
    :param service_package_activation_id: Required. Activation Id of Service
     package.
    :type service_package_activation_id: str
    :param is_exclusive: Required. Indicates IsExclusive flag.
    :type is_exclusive: bool
    :param code_package_name: Required. Name of Code package.
    :type code_package_name: str
    :param entry_point_type: Required. Type of EntryPoint.
    :type entry_point_type: str
    :param image_name: Required. Name of Container image.
    :type image_name: str
    :param container_name: Required. Name of Container.
    :type container_name: str
    :param host_id: Required. Host Id.
    :type host_id: str
    :param exit_code: Required. Exit code of process.
    :type exit_code: long
    :param unexpected_termination: Required. Indicates if termination is
     unexpected.
    :type unexpected_termination: bool
    :param start_time: Required. Start time of process.
    :type start_time: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'service_name': {'required': True},
        'service_package_name': {'required': True},
        'service_package_activation_id': {'required': True},
        'is_exclusive': {'required': True},
        'code_package_name': {'required': True},
        'entry_point_type': {'required': True},
        'image_name': {'required': True},
        'container_name': {'required': True},
        'host_id': {'required': True},
        'exit_code': {'required': True},
        'unexpected_termination': {'required': True},
        'start_time': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_package_name': {'key': 'ServicePackageName', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'is_exclusive': {'key': 'IsExclusive', 'type': 'bool'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'entry_point_type': {'key': 'EntryPointType', 'type': 'str'},
        'image_name': {'key': 'ImageName', 'type': 'str'},
        'container_name': {'key': 'ContainerName', 'type': 'str'},
        'host_id': {'key': 'HostId', 'type': 'str'},
        'exit_code': {'key': 'ExitCode', 'type': 'long'},
        'unexpected_termination': {'key': 'UnexpectedTermination', 'type': 'bool'},
        'start_time': {'key': 'StartTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ApplicationContainerInstanceExitedEvent, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.service_package_name = kwargs.get('service_package_name', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.is_exclusive = kwargs.get('is_exclusive', None)
        self.code_package_name = kwargs.get('code_package_name', None)
        self.entry_point_type = kwargs.get('entry_point_type', None)
        self.image_name = kwargs.get('image_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.host_id = kwargs.get('host_id', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.unexpected_termination = kwargs.get('unexpected_termination', None)
        self.start_time = kwargs.get('start_time', None)
        self.kind = 'ApplicationContainerInstanceExited'


class ApplicationCreatedEvent(ApplicationEvent):
    """Application Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param application_type_version: Required. Application type version.
    :type application_type_version: str
    :param application_definition_kind: Required. Application definition kind.
    :type application_definition_kind: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_type_name': {'required': True},
        'application_type_version': {'required': True},
        'application_definition_kind': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'application_definition_kind': {'key': 'ApplicationDefinitionKind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationCreatedEvent, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.application_definition_kind = kwargs.get('application_definition_kind', None)
        self.kind = 'ApplicationCreated'


class ApplicationDeletedEvent(ApplicationEvent):
    """Application Deleted event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param application_type_version: Required. Application type version.
    :type application_type_version: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_type_name': {'required': True},
        'application_type_version': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationDeletedEvent, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.kind = 'ApplicationDeleted'


class ApplicationDescription(Model):
    """Describes a Service Fabric application.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the application, including the
     'fabric:' URI scheme.
    :type name: str
    :param type_name: Required. The application type name as defined in the
     application manifest.
    :type type_name: str
    :param type_version: Required. The version of the application type as
     defined in the application manifest.
    :type type_version: str
    :param parameter_list: List of application parameters with overridden
     values from their default values specified in the application manifest.
    :type parameter_list:
     list[~azure.servicefabric.models.ApplicationParameter]
    :param application_capacity: Describes capacity information for services
     of this application. This description can be used for describing the
     following.
     - Reserving the capacity for the services on the nodes
     - Limiting the total number of nodes that services of this application can
     run on
     - Limiting the custom capacity metrics to limit the total consumption of
     this metric by the services of this application
    :type application_capacity:
     ~azure.servicefabric.models.ApplicationCapacityDescription
    :param managed_application_identity: Managed application identity
     description.
    :type managed_application_identity:
     ~azure.servicefabric.models.ManagedApplicationIdentityDescription
    """

    _validation = {
        'name': {'required': True},
        'type_name': {'required': True},
        'type_version': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'type_version': {'key': 'TypeVersion', 'type': 'str'},
        'parameter_list': {'key': 'ParameterList', 'type': '[ApplicationParameter]'},
        'application_capacity': {'key': 'ApplicationCapacity', 'type': 'ApplicationCapacityDescription'},
        'managed_application_identity': {'key': 'ManagedApplicationIdentity', 'type': 'ManagedApplicationIdentityDescription'},
    }

    def __init__(self, **kwargs):
        super(ApplicationDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type_name = kwargs.get('type_name', None)
        self.type_version = kwargs.get('type_version', None)
        self.parameter_list = kwargs.get('parameter_list', None)
        self.application_capacity = kwargs.get('application_capacity', None)
        self.managed_application_identity = kwargs.get('managed_application_identity', None)


class EntityHealth(Model):
    """Health information common to all entities in the cluster. It contains the
    aggregated health state, health events and unhealthy evaluation.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
    }

    def __init__(self, **kwargs):
        super(EntityHealth, self).__init__(**kwargs)
        self.aggregated_health_state = kwargs.get('aggregated_health_state', None)
        self.health_events = kwargs.get('health_events', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.health_statistics = kwargs.get('health_statistics', None)


class ApplicationHealth(EntityHealth):
    """Represents the health of the application. Contains the application
    aggregated health state and the service and deployed application health
    states.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param name: The name of the application, including the 'fabric:' URI
     scheme.
    :type name: str
    :param service_health_states: Service health states as found in the health
     store.
    :type service_health_states:
     list[~azure.servicefabric.models.ServiceHealthState]
    :param deployed_application_health_states: Deployed application health
     states as found in the health store.
    :type deployed_application_health_states:
     list[~azure.servicefabric.models.DeployedApplicationHealthState]
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'name': {'key': 'Name', 'type': 'str'},
        'service_health_states': {'key': 'ServiceHealthStates', 'type': '[ServiceHealthState]'},
        'deployed_application_health_states': {'key': 'DeployedApplicationHealthStates', 'type': '[DeployedApplicationHealthState]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealth, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.service_health_states = kwargs.get('service_health_states', None)
        self.deployed_application_health_states = kwargs.get('deployed_application_health_states', None)


class HealthEvaluation(Model):
    """Represents a health evaluation which describes the data and the algorithm
    used by health manager to evaluate the health of an entity.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApplicationHealthEvaluation, ApplicationsHealthEvaluation,
    ApplicationTypeApplicationsHealthEvaluation,
    DeltaNodesCheckHealthEvaluation, DeployedApplicationHealthEvaluation,
    DeployedApplicationsHealthEvaluation,
    DeployedServicePackageHealthEvaluation,
    DeployedServicePackagesHealthEvaluation, EventHealthEvaluation,
    NodeHealthEvaluation, NodesHealthEvaluation, PartitionHealthEvaluation,
    PartitionsHealthEvaluation, ReplicaHealthEvaluation,
    ReplicasHealthEvaluation, ServiceHealthEvaluation,
    ServicesHealthEvaluation, SystemApplicationHealthEvaluation,
    UpgradeDomainDeltaNodesCheckHealthEvaluation,
    UpgradeDomainNodesHealthEvaluation

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Application': 'ApplicationHealthEvaluation', 'Applications': 'ApplicationsHealthEvaluation', 'ApplicationTypeApplications': 'ApplicationTypeApplicationsHealthEvaluation', 'DeltaNodesCheck': 'DeltaNodesCheckHealthEvaluation', 'DeployedApplication': 'DeployedApplicationHealthEvaluation', 'DeployedApplications': 'DeployedApplicationsHealthEvaluation', 'DeployedServicePackage': 'DeployedServicePackageHealthEvaluation', 'DeployedServicePackages': 'DeployedServicePackagesHealthEvaluation', 'Event': 'EventHealthEvaluation', 'Node': 'NodeHealthEvaluation', 'Nodes': 'NodesHealthEvaluation', 'Partition': 'PartitionHealthEvaluation', 'Partitions': 'PartitionsHealthEvaluation', 'Replica': 'ReplicaHealthEvaluation', 'Replicas': 'ReplicasHealthEvaluation', 'Service': 'ServiceHealthEvaluation', 'Services': 'ServicesHealthEvaluation', 'SystemApplication': 'SystemApplicationHealthEvaluation', 'UpgradeDomainDeltaNodesCheck': 'UpgradeDomainDeltaNodesCheckHealthEvaluation', 'UpgradeDomainNodes': 'UpgradeDomainNodesHealthEvaluation'}
    }

    def __init__(self, **kwargs):
        super(HealthEvaluation, self).__init__(**kwargs)
        self.aggregated_health_state = kwargs.get('aggregated_health_state', None)
        self.description = kwargs.get('description', None)
        self.kind = None


class ApplicationHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for an application, containing information
    about the data and the algorithm used by the health store to evaluate
    health.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the current aggregated health state of the application. The types of the
     unhealthy evaluations can be DeployedApplicationsHealthEvaluation,
     ServicesHealthEvaluation or EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthEvaluation, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Application'


class ApplicationHealthPolicies(Model):
    """Defines the application health policy map used to evaluate the health of an
    application or one of its children entities.

    :param application_health_policy_map: The wrapper that contains the map
     with application health policies used to evaluate specific applications in
     the cluster.
    :type application_health_policy_map:
     list[~azure.servicefabric.models.ApplicationHealthPolicyMapItem]
    """

    _attribute_map = {
        'application_health_policy_map': {'key': 'ApplicationHealthPolicyMap', 'type': '[ApplicationHealthPolicyMapItem]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthPolicies, self).__init__(**kwargs)
        self.application_health_policy_map = kwargs.get('application_health_policy_map', None)


class ApplicationHealthPolicy(Model):
    """Defines a health policy used to evaluate the health of an application or
    one of its children entities.

    :param consider_warning_as_error: Indicates whether warnings are treated
     with the same severity as errors. Default value: False .
    :type consider_warning_as_error: bool
    :param max_percent_unhealthy_deployed_applications: The maximum allowed
     percentage of unhealthy deployed applications. Allowed values are Byte
     values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed
     applications that can be unhealthy before the application is considered in
     error.
     This is calculated by dividing the number of unhealthy deployed
     applications over the number of nodes where the application is currently
     deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of
     nodes. Default percentage is zero. Default value: 0 .
    :type max_percent_unhealthy_deployed_applications: int
    :param default_service_type_health_policy: The health policy used by
     default to evaluate the health of a service type.
    :type default_service_type_health_policy:
     ~azure.servicefabric.models.ServiceTypeHealthPolicy
    :param service_type_health_policy_map: The map with service type health
     policy per service type name. The map is empty by default.
    :type service_type_health_policy_map:
     list[~azure.servicefabric.models.ServiceTypeHealthPolicyMapItem]
    """

    _attribute_map = {
        'consider_warning_as_error': {'key': 'ConsiderWarningAsError', 'type': 'bool'},
        'max_percent_unhealthy_deployed_applications': {'key': 'MaxPercentUnhealthyDeployedApplications', 'type': 'int'},
        'default_service_type_health_policy': {'key': 'DefaultServiceTypeHealthPolicy', 'type': 'ServiceTypeHealthPolicy'},
        'service_type_health_policy_map': {'key': 'ServiceTypeHealthPolicyMap', 'type': '[ServiceTypeHealthPolicyMapItem]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthPolicy, self).__init__(**kwargs)
        self.consider_warning_as_error = kwargs.get('consider_warning_as_error', False)
        self.max_percent_unhealthy_deployed_applications = kwargs.get('max_percent_unhealthy_deployed_applications', 0)
        self.default_service_type_health_policy = kwargs.get('default_service_type_health_policy', None)
        self.service_type_health_policy_map = kwargs.get('service_type_health_policy_map', None)


class ApplicationHealthPolicyMapItem(Model):
    """Defines an item in ApplicationHealthPolicyMap.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key of the application health policy map item.
     This is the name of the application.
    :type key: str
    :param value: Required. The value of the application health policy map
     item. This is the ApplicationHealthPolicy for this application.
    :type value: ~azure.servicefabric.models.ApplicationHealthPolicy
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'ApplicationHealthPolicy'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthPolicyMapItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ApplicationHealthReportExpiredEvent(ApplicationEvent):
    """Application Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_instance_id: Required. Id of Application instance.
    :type application_instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_instance_id': {'key': 'ApplicationInstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthReportExpiredEvent, self).__init__(**kwargs)
        self.application_instance_id = kwargs.get('application_instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'ApplicationHealthReportExpired'


class EntityHealthState(Model):
    """A base type for the health state of various entities in the cluster. It
    contains the aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityHealthState, self).__init__(**kwargs)
        self.aggregated_health_state = kwargs.get('aggregated_health_state', None)


class ApplicationHealthState(EntityHealthState):
    """Represents the health state of an application, which contains the
    application identifier and the aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param name: The name of the application, including the 'fabric:' URI
     scheme.
    :type name: str
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthState, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class EntityHealthStateChunk(Model):
    """A base type for the health state chunk of various entities in the cluster.
    It contains the aggregated health state.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityHealthStateChunk, self).__init__(**kwargs)
        self.health_state = kwargs.get('health_state', None)


class ApplicationHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a application.
    The application health state chunk contains the application name, its
    aggregated health state and any children services and deployed applications
    that respect the filters in cluster health chunk query description.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param application_type_name: The application type name as defined in the
     application manifest.
    :type application_type_name: str
    :param service_health_state_chunks: The list of service health state
     chunks in the cluster that respect the filters in the cluster health chunk
     query description.
    :type service_health_state_chunks:
     ~azure.servicefabric.models.ServiceHealthStateChunkList
    :param deployed_application_health_state_chunks: The list of deployed
     application health state chunks in the cluster that respect the filters in
     the cluster health chunk query description.
    :type deployed_application_health_state_chunks:
     ~azure.servicefabric.models.DeployedApplicationHealthStateChunkList
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'service_health_state_chunks': {'key': 'ServiceHealthStateChunks', 'type': 'ServiceHealthStateChunkList'},
        'deployed_application_health_state_chunks': {'key': 'DeployedApplicationHealthStateChunks', 'type': 'DeployedApplicationHealthStateChunkList'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthStateChunk, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.service_health_state_chunks = kwargs.get('service_health_state_chunks', None)
        self.deployed_application_health_state_chunks = kwargs.get('deployed_application_health_state_chunks', None)


class EntityHealthStateChunkList(Model):
    """A base type for the list of health state chunks found in the cluster. It
    contains the total number of health states that match the input filters.

    :param total_count: Total number of entity health state objects that match
     the specified filters from the cluster health chunk query description.
    :type total_count: long
    """

    _attribute_map = {
        'total_count': {'key': 'TotalCount', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(EntityHealthStateChunkList, self).__init__(**kwargs)
        self.total_count = kwargs.get('total_count', None)


class ApplicationHealthStateChunkList(EntityHealthStateChunkList):
    """The list of application health state chunks in the cluster that respect the
    input filters in the chunk query. Returned by get cluster health state
    chunks query.

    :param total_count: Total number of entity health state objects that match
     the specified filters from the cluster health chunk query description.
    :type total_count: long
    :param items: The list of application health state chunks that respect the
     input filters in the chunk query.
    :type items: list[~azure.servicefabric.models.ApplicationHealthStateChunk]
    """

    _attribute_map = {
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'items': {'key': 'Items', 'type': '[ApplicationHealthStateChunk]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthStateChunkList, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class ApplicationHealthStateFilter(Model):
    """Defines matching criteria to determine whether a application should be
    included in the cluster health chunk.
    One filter can match zero, one or multiple applications, depending on its
    properties.

    :param application_name_filter: The name of the application that matches
     the filter, as a fabric uri. The filter is applied only to the specified
     application, if it exists.
     If the application doesn't exist, no application is returned in the
     cluster health chunk based on this filter.
     If the application exists, it is included in the cluster health chunk if
     it respects the other filter properties.
     If not specified, all applications are matched against the other filter
     members, like health state filter.
    :type application_name_filter: str
    :param application_type_name_filter: The name of the application type that
     matches the filter.
     If specified, the filter is applied only to applications of the selected
     application type, if any exists.
     If no applications of the specified application type exists, no
     application is returned in the cluster health chunk based on this filter.
     Each application of the specified application type is included in the
     cluster health chunk if it respects the other filter properties.
     If not specified, all applications are matched against the other filter
     members, like health state filter.
    :type application_type_name_filter: str
    :param health_state_filter: The filter for the health state of the
     applications. It allows selecting applications if they match the desired
     health states.
     The possible values are integer value of one of the following health
     states. Only applications that match the filter are returned. All
     applications are used to evaluate the cluster aggregated health state.
     If not specified, default value is None, unless the application name or
     the application type name are specified. If the filter has default value
     and application name is specified, the matching application is returned.
     The state values are flag-based enumeration, so the value could be a
     combination of these values obtained using bitwise 'OR' operator.
     For example, if the provided value is 6, it matches applications with
     HealthState value of OK (2) and Warning (4).
     - Default - Default value. Matches any HealthState. The value is zero.
     - None - Filter that doesn't match any HealthState value. Used in order to
     return no results on a given collection of states. The value is 1.
     - Ok - Filter that matches input with HealthState value Ok. The value is
     2.
     - Warning - Filter that matches input with HealthState value Warning. The
     value is 4.
     - Error - Filter that matches input with HealthState value Error. The
     value is 8.
     - All - Filter that matches input with any HealthState value. The value is
     65535. Default value: 0 .
    :type health_state_filter: int
    :param service_filters: Defines a list of filters that specify which
     services to be included in the returned cluster health chunk as children
     of the application. The services are returned only if the parent
     application matches a filter.
     If the list is empty, no services are returned. All the services are used
     to evaluate the parent application aggregated health state, regardless of
     the input filters.
     The application filter may specify multiple service filters.
     For example, it can specify a filter to return all services with health
     state Error and another filter to always include a service identified by
     its service name.
    :type service_filters:
     list[~azure.servicefabric.models.ServiceHealthStateFilter]
    :param deployed_application_filters: Defines a list of filters that
     specify which deployed applications to be included in the returned cluster
     health chunk as children of the application. The deployed applications are
     returned only if the parent application matches a filter.
     If the list is empty, no deployed applications are returned. All the
     deployed applications are used to evaluate the parent application
     aggregated health state, regardless of the input filters.
     The application filter may specify multiple deployed application filters.
     For example, it can specify a filter to return all deployed applications
     with health state Error and another filter to always include a deployed
     application on a specified node.
    :type deployed_application_filters:
     list[~azure.servicefabric.models.DeployedApplicationHealthStateFilter]
    """

    _attribute_map = {
        'application_name_filter': {'key': 'ApplicationNameFilter', 'type': 'str'},
        'application_type_name_filter': {'key': 'ApplicationTypeNameFilter', 'type': 'str'},
        'health_state_filter': {'key': 'HealthStateFilter', 'type': 'int'},
        'service_filters': {'key': 'ServiceFilters', 'type': '[ServiceHealthStateFilter]'},
        'deployed_application_filters': {'key': 'DeployedApplicationFilters', 'type': '[DeployedApplicationHealthStateFilter]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationHealthStateFilter, self).__init__(**kwargs)
        self.application_name_filter = kwargs.get('application_name_filter', None)
        self.application_type_name_filter = kwargs.get('application_type_name_filter', None)
        self.health_state_filter = kwargs.get('health_state_filter', 0)
        self.service_filters = kwargs.get('service_filters', None)
        self.deployed_application_filters = kwargs.get('deployed_application_filters', None)


class ApplicationInfo(Model):
    """Information about a Service Fabric application.

    :param id: The identity of the application. This is an encoded
     representation of the application name. This is used in the REST APIs to
     identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type id: str
    :param name: The name of the application, including the 'fabric:' URI
     scheme.
    :type name: str
    :param type_name: The application type name as defined in the application
     manifest.
    :type type_name: str
    :param type_version: The version of the application type as defined in the
     application manifest.
    :type type_version: str
    :param status: The status of the application. Possible values include:
     'Invalid', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :type status: str or ~azure.servicefabric.models.ApplicationStatus
    :param parameters: List of application parameters with overridden values
     from their default values specified in the application manifest.
    :type parameters: list[~azure.servicefabric.models.ApplicationParameter]
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param application_definition_kind: The mechanism used to define a Service
     Fabric application. Possible values include: 'Invalid',
     'ServiceFabricApplicationDescription', 'Compose'
    :type application_definition_kind: str or
     ~azure.servicefabric.models.ApplicationDefinitionKind
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'type_version': {'key': 'TypeVersion', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'parameters': {'key': 'Parameters', 'type': '[ApplicationParameter]'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'application_definition_kind': {'key': 'ApplicationDefinitionKind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_name = kwargs.get('type_name', None)
        self.type_version = kwargs.get('type_version', None)
        self.status = kwargs.get('status', None)
        self.parameters = kwargs.get('parameters', None)
        self.health_state = kwargs.get('health_state', None)
        self.application_definition_kind = kwargs.get('application_definition_kind', None)


class ApplicationLoadInfo(Model):
    """Load Information about a Service Fabric application.

    :param id: The identity of the application. This is an encoded
     representation of the application name. This is used in the REST APIs to
     identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type id: str
    :param minimum_nodes: The minimum number of nodes for this application.
     It is the number of nodes where Service Fabric will reserve Capacity in
     the cluster which equals to ReservedLoad * MinimumNodes for this
     Application instance.
     For applications that do not have application capacity defined this value
     will be zero.
    :type minimum_nodes: long
    :param maximum_nodes: The maximum number of nodes where this application
     can be instantiated.
     It is the number of nodes this application is allowed to span.
     For applications that do not have application capacity defined this value
     will be zero.
    :type maximum_nodes: long
    :param node_count: The number of nodes on which this application is
     instantiated.
     For applications that do not have application capacity defined this value
     will be zero.
    :type node_count: long
    :param application_load_metric_information: List of application capacity
     metric description.
    :type application_load_metric_information:
     list[~azure.servicefabric.models.ApplicationMetricDescription]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'minimum_nodes': {'key': 'MinimumNodes', 'type': 'long'},
        'maximum_nodes': {'key': 'MaximumNodes', 'type': 'long'},
        'node_count': {'key': 'NodeCount', 'type': 'long'},
        'application_load_metric_information': {'key': 'ApplicationLoadMetricInformation', 'type': '[ApplicationMetricDescription]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationLoadInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.minimum_nodes = kwargs.get('minimum_nodes', None)
        self.maximum_nodes = kwargs.get('maximum_nodes', None)
        self.node_count = kwargs.get('node_count', None)
        self.application_load_metric_information = kwargs.get('application_load_metric_information', None)


class ApplicationMetricDescription(Model):
    """Describes capacity information for a custom resource balancing metric. This
    can be used to limit the total consumption of this metric by the services
    of this application.

    :param name: The name of the metric.
    :type name: str
    :param maximum_capacity: The maximum node capacity for Service Fabric
     application.
     This is the maximum Load for an instance of this application on a single
     node. Even if the capacity of node is greater than this value, Service
     Fabric will limit the total load of services within the application on
     each node to this value.
     If set to zero, capacity for this metric is unlimited on each node.
     When creating a new application with application capacity defined, the
     product of MaximumNodes and this value must always be smaller than or
     equal to TotalApplicationCapacity.
     When updating existing application with application capacity, the product
     of MaximumNodes and this value must always be smaller than or equal to
     TotalApplicationCapacity.
    :type maximum_capacity: long
    :param reservation_capacity: The node reservation capacity for Service
     Fabric application.
     This is the amount of load which is reserved on nodes which have instances
     of this application.
     If MinimumNodes is specified, then the product of these values will be the
     capacity reserved in the cluster for the application.
     If set to zero, no capacity is reserved for this metric.
     When setting application capacity or when updating application capacity;
     this value must be smaller than or equal to MaximumCapacity for each
     metric.
    :type reservation_capacity: long
    :param total_application_capacity: The total metric capacity for Service
     Fabric application.
     This is the total metric capacity for this application in the cluster.
     Service Fabric will try to limit the sum of loads of services within the
     application to this value.
     When creating a new application with application capacity defined, the
     product of MaximumNodes and MaximumCapacity must always be smaller than or
     equal to this value.
    :type total_application_capacity: long
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'maximum_capacity': {'key': 'MaximumCapacity', 'type': 'long'},
        'reservation_capacity': {'key': 'ReservationCapacity', 'type': 'long'},
        'total_application_capacity': {'key': 'TotalApplicationCapacity', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(ApplicationMetricDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.maximum_capacity = kwargs.get('maximum_capacity', None)
        self.reservation_capacity = kwargs.get('reservation_capacity', None)
        self.total_application_capacity = kwargs.get('total_application_capacity', None)


class ApplicationNameInfo(Model):
    """Information about the application name.

    :param id: The identity of the application. This is an encoded
     representation of the application name. This is used in the REST APIs to
     identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type id: str
    :param name: The name of the application, including the 'fabric:' URI
     scheme.
    :type name: str
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationNameInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)


class ApplicationNewHealthReportEvent(ApplicationEvent):
    """Application Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_instance_id: Required. Id of Application instance.
    :type application_instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_instance_id': {'key': 'ApplicationInstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ApplicationNewHealthReportEvent, self).__init__(**kwargs)
        self.application_instance_id = kwargs.get('application_instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'ApplicationNewHealthReport'


class ApplicationParameter(Model):
    """Describes an application parameter override to be applied when creating or
    upgrading an application.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The name of the parameter.
    :type key: str
    :param value: Required. The value of the parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationParameter, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ApplicationProcessExitedEvent(ApplicationEvent):
    """Process Exited event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param service_name: Required. Name of Service.
    :type service_name: str
    :param service_package_name: Required. Name of Service package.
    :type service_package_name: str
    :param service_package_activation_id: Required. Activation Id of Service
     package.
    :type service_package_activation_id: str
    :param is_exclusive: Required. Indicates IsExclusive flag.
    :type is_exclusive: bool
    :param code_package_name: Required. Name of Code package.
    :type code_package_name: str
    :param entry_point_type: Required. Type of EntryPoint.
    :type entry_point_type: str
    :param exe_name: Required. Name of executable.
    :type exe_name: str
    :param process_id: Required. Process Id.
    :type process_id: long
    :param host_id: Required. Host Id.
    :type host_id: str
    :param exit_code: Required. Exit code of process.
    :type exit_code: long
    :param unexpected_termination: Required. Indicates if termination is
     unexpected.
    :type unexpected_termination: bool
    :param start_time: Required. Start time of process.
    :type start_time: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'service_name': {'required': True},
        'service_package_name': {'required': True},
        'service_package_activation_id': {'required': True},
        'is_exclusive': {'required': True},
        'code_package_name': {'required': True},
        'entry_point_type': {'required': True},
        'exe_name': {'required': True},
        'process_id': {'required': True},
        'host_id': {'required': True},
        'exit_code': {'required': True},
        'unexpected_termination': {'required': True},
        'start_time': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_package_name': {'key': 'ServicePackageName', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'is_exclusive': {'key': 'IsExclusive', 'type': 'bool'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'entry_point_type': {'key': 'EntryPointType', 'type': 'str'},
        'exe_name': {'key': 'ExeName', 'type': 'str'},
        'process_id': {'key': 'ProcessId', 'type': 'long'},
        'host_id': {'key': 'HostId', 'type': 'str'},
        'exit_code': {'key': 'ExitCode', 'type': 'long'},
        'unexpected_termination': {'key': 'UnexpectedTermination', 'type': 'bool'},
        'start_time': {'key': 'StartTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ApplicationProcessExitedEvent, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.service_package_name = kwargs.get('service_package_name', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.is_exclusive = kwargs.get('is_exclusive', None)
        self.code_package_name = kwargs.get('code_package_name', None)
        self.entry_point_type = kwargs.get('entry_point_type', None)
        self.exe_name = kwargs.get('exe_name', None)
        self.process_id = kwargs.get('process_id', None)
        self.host_id = kwargs.get('host_id', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.unexpected_termination = kwargs.get('unexpected_termination', None)
        self.start_time = kwargs.get('start_time', None)
        self.kind = 'ApplicationProcessExited'


class ApplicationResourceDescription(Model):
    """This type describes a application resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Application resource.
    :type name: str
    :param description: User readable description of the application.
    :type description: str
    :param services: Describes the services in the application. This property
     is used to create or modify services of the application. On get only the
     name of the service is returned. The service description can be obtained
     by querying for the service resource.
    :type services:
     list[~azure.servicefabric.models.ServiceResourceDescription]
    :param diagnostics: Describes the diagnostics definition and usage for an
     application resource.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsDescription
    :param debug_params: Internal - used by Visual Studio to setup the
     debugging session on the local development environment.
    :type debug_params: str
    :ivar service_names: Names of the services in the application.
    :vartype service_names: list[str]
    :ivar status: Status of the application. Possible values include:
     'Unknown', 'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the application.
    :vartype status_details: str
    :ivar health_state: Describes the health state of an application resource.
     Possible values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :vartype health_state: str or ~azure.servicefabric.models.HealthState
    :ivar unhealthy_evaluation: When the application's health state is not
     'Ok', this additional details from service fabric Health Manager for the
     user to know why the application is marked unhealthy.
    :vartype unhealthy_evaluation: str
    :param identity: Describes the identity of the application.
    :type identity: ~azure.servicefabric.models.IdentityDescription
    """

    _validation = {
        'name': {'required': True},
        'service_names': {'readonly': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'health_state': {'readonly': True},
        'unhealthy_evaluation': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'services': {'key': 'properties.services', 'type': '[ServiceResourceDescription]'},
        'diagnostics': {'key': 'properties.diagnostics', 'type': 'DiagnosticsDescription'},
        'debug_params': {'key': 'properties.debugParams', 'type': 'str'},
        'service_names': {'key': 'properties.serviceNames', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'health_state': {'key': 'properties.healthState', 'type': 'str'},
        'unhealthy_evaluation': {'key': 'properties.unhealthyEvaluation', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityDescription'},
    }

    def __init__(self, **kwargs):
        super(ApplicationResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.services = kwargs.get('services', None)
        self.diagnostics = kwargs.get('diagnostics', None)
        self.debug_params = kwargs.get('debug_params', None)
        self.service_names = None
        self.status = None
        self.status_details = None
        self.health_state = None
        self.unhealthy_evaluation = None
        self.identity = kwargs.get('identity', None)


class VolumeReference(Model):
    """Describes a reference to a volume resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the volume being referenced.
    :type name: str
    :param read_only: The flag indicating whether the volume is read only.
     Default is 'false'.
    :type read_only: bool
    :param destination_path: Required. The path within the container at which
     the volume should be mounted. Only valid path characters are allowed.
    :type destination_path: str
    """

    _validation = {
        'name': {'required': True},
        'destination_path': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
        'destination_path': {'key': 'destinationPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VolumeReference, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.read_only = kwargs.get('read_only', None)
        self.destination_path = kwargs.get('destination_path', None)


class ApplicationScopedVolume(VolumeReference):
    """Describes a volume whose lifetime is scoped to the application's lifetime.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the volume being referenced.
    :type name: str
    :param read_only: The flag indicating whether the volume is read only.
     Default is 'false'.
    :type read_only: bool
    :param destination_path: Required. The path within the container at which
     the volume should be mounted. Only valid path characters are allowed.
    :type destination_path: str
    :param creation_parameters: Required. Describes parameters for creating
     application-scoped volumes.
    :type creation_parameters:
     ~azure.servicefabric.models.ApplicationScopedVolumeCreationParameters
    """

    _validation = {
        'name': {'required': True},
        'destination_path': {'required': True},
        'creation_parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
        'destination_path': {'key': 'destinationPath', 'type': 'str'},
        'creation_parameters': {'key': 'creationParameters', 'type': 'ApplicationScopedVolumeCreationParameters'},
    }

    def __init__(self, **kwargs):
        super(ApplicationScopedVolume, self).__init__(**kwargs)
        self.creation_parameters = kwargs.get('creation_parameters', None)


class ApplicationScopedVolumeCreationParameters(Model):
    """Describes parameters for creating application-scoped volumes.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are:
    ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk

    All required parameters must be populated in order to send to Azure.

    :param description: User readable description of the volume.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ServiceFabricVolumeDisk': 'ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk'}
    }

    def __init__(self, **kwargs):
        super(ApplicationScopedVolumeCreationParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.kind = None


class ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk(ApplicationScopedVolumeCreationParameters):
    """Describes parameters for creating application-scoped volumes provided by
    Service Fabric Volume Disks.

    All required parameters must be populated in order to send to Azure.

    :param description: User readable description of the volume.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param size_disk: Required. Volume size. Possible values include: 'Small',
     'Medium', 'Large'
    :type size_disk: str or ~azure.servicefabric.models.SizeTypes
    """

    _validation = {
        'kind': {'required': True},
        'size_disk': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'size_disk': {'key': 'sizeDisk', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk, self).__init__(**kwargs)
        self.size_disk = kwargs.get('size_disk', None)
        self.kind = 'ServiceFabricVolumeDisk'


class ApplicationsHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for applications, containing health
    evaluations for each unhealthy application that impacted current aggregated
    health state.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param max_percent_unhealthy_applications: Maximum allowed percentage of
     unhealthy applications from the ClusterHealthPolicy.
    :type max_percent_unhealthy_applications: int
    :param total_count: Total number of applications from the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     ApplicationHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'max_percent_unhealthy_applications': {'key': 'MaxPercentUnhealthyApplications', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationsHealthEvaluation, self).__init__(**kwargs)
        self.max_percent_unhealthy_applications = kwargs.get('max_percent_unhealthy_applications', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Applications'


class ApplicationTypeApplicationsHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for applications of a particular application
    type. The application type applications evaluation can be returned when
    cluster health evaluation returns unhealthy aggregated health state, either
    Error or Warning. It contains health evaluations for each unhealthy
    application of the included application type that impacted current
    aggregated health state.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_type_name: The application type name as defined in the
     application manifest.
    :type application_type_name: str
    :param max_percent_unhealthy_applications: Maximum allowed percentage of
     unhealthy applications for the application type, specified as an entry in
     ApplicationTypeHealthPolicyMap.
    :type max_percent_unhealthy_applications: int
    :param total_count: Total number of applications of the application type
     found in the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     ApplicationHealthEvaluation of this application type that impacted the
     aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'max_percent_unhealthy_applications': {'key': 'MaxPercentUnhealthyApplications', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationTypeApplicationsHealthEvaluation, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.max_percent_unhealthy_applications = kwargs.get('max_percent_unhealthy_applications', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'ApplicationTypeApplications'


class ApplicationTypeHealthPolicyMapItem(Model):
    """Defines an item in ApplicationTypeHealthPolicyMap.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key of the application type health policy map
     item. This is the name of the application type.
    :type key: str
    :param value: Required. The value of the application type health policy
     map item.
     The max percent unhealthy applications allowed for the application type.
     Must be between zero and 100.
    :type value: int
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ApplicationTypeHealthPolicyMapItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ApplicationTypeImageStorePath(Model):
    """Path description for the application package in the image store specified
    during the prior copy operation.

    All required parameters must be populated in order to send to Azure.

    :param application_type_build_path: Required. The relative image store
     path to the application package.
    :type application_type_build_path: str
    """

    _validation = {
        'application_type_build_path': {'required': True},
    }

    _attribute_map = {
        'application_type_build_path': {'key': 'ApplicationTypeBuildPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationTypeImageStorePath, self).__init__(**kwargs)
        self.application_type_build_path = kwargs.get('application_type_build_path', None)


class ApplicationTypeInfo(Model):
    """Information about an application type.

    :param name: The application type name as defined in the application
     manifest.
    :type name: str
    :param version: The version of the application type as defined in the
     application manifest.
    :type version: str
    :param default_parameter_list: List of application type parameters that
     can be overridden when creating or updating the application.
    :type default_parameter_list:
     list[~azure.servicefabric.models.ApplicationParameter]
    :param status: The status of the application type. Possible values
     include: 'Invalid', 'Provisioning', 'Available', 'Unprovisioning',
     'Failed'
    :type status: str or ~azure.servicefabric.models.ApplicationTypeStatus
    :param status_details: Additional detailed information about the status of
     the application type.
    :type status_details: str
    :param application_type_definition_kind: The mechanism used to define a
     Service Fabric application type. Possible values include: 'Invalid',
     'ServiceFabricApplicationPackage', 'Compose'
    :type application_type_definition_kind: str or
     ~azure.servicefabric.models.ApplicationTypeDefinitionKind
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'default_parameter_list': {'key': 'DefaultParameterList', 'type': '[ApplicationParameter]'},
        'status': {'key': 'Status', 'type': 'str'},
        'status_details': {'key': 'StatusDetails', 'type': 'str'},
        'application_type_definition_kind': {'key': 'ApplicationTypeDefinitionKind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationTypeInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)
        self.default_parameter_list = kwargs.get('default_parameter_list', None)
        self.status = kwargs.get('status', None)
        self.status_details = kwargs.get('status_details', None)
        self.application_type_definition_kind = kwargs.get('application_type_definition_kind', None)


class ApplicationTypeManifest(Model):
    """Contains the manifest describing an application type registered in a
    Service Fabric cluster.

    :param manifest: The XML manifest as a string.
    :type manifest: str
    """

    _attribute_map = {
        'manifest': {'key': 'Manifest', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationTypeManifest, self).__init__(**kwargs)
        self.manifest = kwargs.get('manifest', None)


class ApplicationUpgradeCompletedEvent(ApplicationEvent):
    """Application Upgrade Completed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param application_type_version: Required. Application type version.
    :type application_type_version: str
    :param overall_upgrade_elapsed_time_in_ms: Required. Overall upgrade time
     in milli-seconds.
    :type overall_upgrade_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_type_name': {'required': True},
        'application_type_version': {'required': True},
        'overall_upgrade_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'overall_upgrade_elapsed_time_in_ms': {'key': 'OverallUpgradeElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeCompletedEvent, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.overall_upgrade_elapsed_time_in_ms = kwargs.get('overall_upgrade_elapsed_time_in_ms', None)
        self.kind = 'ApplicationUpgradeCompleted'


class ApplicationUpgradeDescription(Model):
    """Describes the parameters for an application upgrade. Note that upgrade
    description replaces the existing application description. This means that
    if the parameters are not specified, the existing parameters on the
    applications will be overwritten with the empty parameters list. This would
    result in the application using the default value of the parameters from
    the application manifest. If you do not want to change any existing
    parameter values, please get the application parameters first using the
    GetApplicationInfo query and then supply those values as Parameters in this
    ApplicationUpgradeDescription.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the target application, including the
     'fabric:' URI scheme.
    :type name: str
    :param target_application_type_version: Required. The target application
     type version (found in the application manifest) for the application
     upgrade.
    :type target_application_type_version: str
    :param parameters: List of application parameters with overridden values
     from their default values specified in the application manifest.
    :type parameters: list[~azure.servicefabric.models.ApplicationParameter]
    :param upgrade_kind: Required. The kind of upgrade out of the following
     possible values. Possible values include: 'Invalid', 'Rolling'. Default
     value: "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeKind
    :param rolling_upgrade_mode: The mode used to monitor health during a
     rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and
     Monitored. Possible values include: 'Invalid', 'UnmonitoredAuto',
     'UnmonitoredManual', 'Monitored'. Default value: "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param upgrade_replica_set_check_timeout_in_seconds: The maximum amount of
     time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires,
     processing of the upgrade domain will proceed regardless of availability
     loss issues. The timeout is reset at the start of each upgrade domain.
     Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit
     integer).
    :type upgrade_replica_set_check_timeout_in_seconds: long
    :param force_restart: If true, then processes are forcefully restarted
     during upgrade even when the code version has not changed (the upgrade
     only changes configuration or data).
    :type force_restart: bool
    :param sort_order: Defines the order in which an upgrade proceeds through
     the cluster. Possible values include: 'Invalid', 'Default', 'Numeric',
     'Lexicographical', 'ReverseNumeric', 'ReverseLexicographical'. Default
     value: "Default" .
    :type sort_order: str or ~azure.servicefabric.models.UpgradeSortOrder
    :param monitoring_policy: Describes the parameters for monitoring an
     upgrade in Monitored mode.
    :type monitoring_policy:
     ~azure.servicefabric.models.MonitoringPolicyDescription
    :param application_health_policy: Defines a health policy used to evaluate
     the health of an application or one of its children entities.
    :type application_health_policy:
     ~azure.servicefabric.models.ApplicationHealthPolicy
    """

    _validation = {
        'name': {'required': True},
        'target_application_type_version': {'required': True},
        'upgrade_kind': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'target_application_type_version': {'key': 'TargetApplicationTypeVersion', 'type': 'str'},
        'parameters': {'key': 'Parameters', 'type': '[ApplicationParameter]'},
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'upgrade_replica_set_check_timeout_in_seconds': {'key': 'UpgradeReplicaSetCheckTimeoutInSeconds', 'type': 'long'},
        'force_restart': {'key': 'ForceRestart', 'type': 'bool'},
        'sort_order': {'key': 'SortOrder', 'type': 'str'},
        'monitoring_policy': {'key': 'MonitoringPolicy', 'type': 'MonitoringPolicyDescription'},
        'application_health_policy': {'key': 'ApplicationHealthPolicy', 'type': 'ApplicationHealthPolicy'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.target_application_type_version = kwargs.get('target_application_type_version', None)
        self.parameters = kwargs.get('parameters', None)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.upgrade_replica_set_check_timeout_in_seconds = kwargs.get('upgrade_replica_set_check_timeout_in_seconds', None)
        self.force_restart = kwargs.get('force_restart', None)
        self.sort_order = kwargs.get('sort_order', "Default")
        self.monitoring_policy = kwargs.get('monitoring_policy', None)
        self.application_health_policy = kwargs.get('application_health_policy', None)


class ApplicationUpgradeDomainCompletedEvent(ApplicationEvent):
    """Application Upgrade Domain Completed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param current_application_type_version: Required. Current Application
     type version.
    :type current_application_type_version: str
    :param application_type_version: Required. Target Application type
     version.
    :type application_type_version: str
    :param upgrade_state: Required. State of upgrade.
    :type upgrade_state: str
    :param upgrade_domains: Required. Upgrade domains.
    :type upgrade_domains: str
    :param upgrade_domain_elapsed_time_in_ms: Required. Upgrade time of domain
     in milli-seconds.
    :type upgrade_domain_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_type_name': {'required': True},
        'current_application_type_version': {'required': True},
        'application_type_version': {'required': True},
        'upgrade_state': {'required': True},
        'upgrade_domains': {'required': True},
        'upgrade_domain_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'current_application_type_version': {'key': 'CurrentApplicationTypeVersion', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'upgrade_state': {'key': 'UpgradeState', 'type': 'str'},
        'upgrade_domains': {'key': 'UpgradeDomains', 'type': 'str'},
        'upgrade_domain_elapsed_time_in_ms': {'key': 'UpgradeDomainElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeDomainCompletedEvent, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.current_application_type_version = kwargs.get('current_application_type_version', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.upgrade_state = kwargs.get('upgrade_state', None)
        self.upgrade_domains = kwargs.get('upgrade_domains', None)
        self.upgrade_domain_elapsed_time_in_ms = kwargs.get('upgrade_domain_elapsed_time_in_ms', None)
        self.kind = 'ApplicationUpgradeDomainCompleted'


class ApplicationUpgradeProgressInfo(Model):
    """Describes the parameters for an application upgrade.

    :param name: The name of the target application, including the 'fabric:'
     URI scheme.
    :type name: str
    :param type_name: The application type name as defined in the application
     manifest.
    :type type_name: str
    :param target_application_type_version: The target application type
     version (found in the application manifest) for the application upgrade.
    :type target_application_type_version: str
    :param upgrade_domains: List of upgrade domains and their statuses.
    :type upgrade_domains: list[~azure.servicefabric.models.UpgradeDomainInfo]
    :param upgrade_state: The state of the upgrade domain. Possible values
     include: 'Invalid', 'RollingBackInProgress', 'RollingBackCompleted',
     'RollingForwardPending', 'RollingForwardInProgress',
     'RollingForwardCompleted', 'Failed'
    :type upgrade_state: str or ~azure.servicefabric.models.UpgradeState
    :param next_upgrade_domain: The name of the next upgrade domain to be
     processed.
    :type next_upgrade_domain: str
    :param rolling_upgrade_mode: The mode used to monitor health during a
     rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and
     Monitored. Possible values include: 'Invalid', 'UnmonitoredAuto',
     'UnmonitoredManual', 'Monitored'. Default value: "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param upgrade_description: Describes the parameters for an application
     upgrade. Note that upgrade description replaces the existing application
     description. This means that if the parameters are not specified, the
     existing parameters on the applications will be overwritten with the empty
     parameters list. This would result in the application using the default
     value of the parameters from the application manifest. If you do not want
     to change any existing parameter values, please get the application
     parameters first using the GetApplicationInfo query and then supply those
     values as Parameters in this ApplicationUpgradeDescription.
    :type upgrade_description:
     ~azure.servicefabric.models.ApplicationUpgradeDescription
    :param upgrade_duration_in_milliseconds: The estimated total amount of
     time spent processing the overall upgrade.
    :type upgrade_duration_in_milliseconds: str
    :param upgrade_domain_duration_in_milliseconds: The estimated total amount
     of time spent processing the current upgrade domain.
    :type upgrade_domain_duration_in_milliseconds: str
    :param unhealthy_evaluations: List of health evaluations that resulted in
     the current aggregated health state.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param current_upgrade_domain_progress: Information about the current
     in-progress upgrade domain.
    :type current_upgrade_domain_progress:
     ~azure.servicefabric.models.CurrentUpgradeDomainProgressInfo
    :param start_timestamp_utc: The estimated UTC datetime when the upgrade
     started.
    :type start_timestamp_utc: str
    :param failure_timestamp_utc: The estimated UTC datetime when the upgrade
     failed and FailureAction was executed.
    :type failure_timestamp_utc: str
    :param failure_reason: The cause of an upgrade failure that resulted in
     FailureAction being executed. Possible values include: 'None',
     'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout',
     'OverallUpgradeTimeout'
    :type failure_reason: str or ~azure.servicefabric.models.FailureReason
    :param upgrade_domain_progress_at_failure: Information about the upgrade
     domain progress at the time of upgrade failure.
    :type upgrade_domain_progress_at_failure:
     ~azure.servicefabric.models.FailureUpgradeDomainProgressInfo
    :param upgrade_status_details: Additional detailed information about the
     status of the pending upgrade.
    :type upgrade_status_details: str
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'target_application_type_version': {'key': 'TargetApplicationTypeVersion', 'type': 'str'},
        'upgrade_domains': {'key': 'UpgradeDomains', 'type': '[UpgradeDomainInfo]'},
        'upgrade_state': {'key': 'UpgradeState', 'type': 'str'},
        'next_upgrade_domain': {'key': 'NextUpgradeDomain', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'upgrade_description': {'key': 'UpgradeDescription', 'type': 'ApplicationUpgradeDescription'},
        'upgrade_duration_in_milliseconds': {'key': 'UpgradeDurationInMilliseconds', 'type': 'str'},
        'upgrade_domain_duration_in_milliseconds': {'key': 'UpgradeDomainDurationInMilliseconds', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'current_upgrade_domain_progress': {'key': 'CurrentUpgradeDomainProgress', 'type': 'CurrentUpgradeDomainProgressInfo'},
        'start_timestamp_utc': {'key': 'StartTimestampUtc', 'type': 'str'},
        'failure_timestamp_utc': {'key': 'FailureTimestampUtc', 'type': 'str'},
        'failure_reason': {'key': 'FailureReason', 'type': 'str'},
        'upgrade_domain_progress_at_failure': {'key': 'UpgradeDomainProgressAtFailure', 'type': 'FailureUpgradeDomainProgressInfo'},
        'upgrade_status_details': {'key': 'UpgradeStatusDetails', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeProgressInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type_name = kwargs.get('type_name', None)
        self.target_application_type_version = kwargs.get('target_application_type_version', None)
        self.upgrade_domains = kwargs.get('upgrade_domains', None)
        self.upgrade_state = kwargs.get('upgrade_state', None)
        self.next_upgrade_domain = kwargs.get('next_upgrade_domain', None)
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.upgrade_description = kwargs.get('upgrade_description', None)
        self.upgrade_duration_in_milliseconds = kwargs.get('upgrade_duration_in_milliseconds', None)
        self.upgrade_domain_duration_in_milliseconds = kwargs.get('upgrade_domain_duration_in_milliseconds', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.current_upgrade_domain_progress = kwargs.get('current_upgrade_domain_progress', None)
        self.start_timestamp_utc = kwargs.get('start_timestamp_utc', None)
        self.failure_timestamp_utc = kwargs.get('failure_timestamp_utc', None)
        self.failure_reason = kwargs.get('failure_reason', None)
        self.upgrade_domain_progress_at_failure = kwargs.get('upgrade_domain_progress_at_failure', None)
        self.upgrade_status_details = kwargs.get('upgrade_status_details', None)


class ApplicationUpgradeRollbackCompletedEvent(ApplicationEvent):
    """Application Upgrade Rollback Completed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param application_type_version: Required. Application type version.
    :type application_type_version: str
    :param failure_reason: Required. Describes reason of failure.
    :type failure_reason: str
    :param overall_upgrade_elapsed_time_in_ms: Required. Overall upgrade time
     in milli-seconds.
    :type overall_upgrade_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_type_name': {'required': True},
        'application_type_version': {'required': True},
        'failure_reason': {'required': True},
        'overall_upgrade_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'failure_reason': {'key': 'FailureReason', 'type': 'str'},
        'overall_upgrade_elapsed_time_in_ms': {'key': 'OverallUpgradeElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeRollbackCompletedEvent, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.failure_reason = kwargs.get('failure_reason', None)
        self.overall_upgrade_elapsed_time_in_ms = kwargs.get('overall_upgrade_elapsed_time_in_ms', None)
        self.kind = 'ApplicationUpgradeRollbackCompleted'


class ApplicationUpgradeRollbackStartedEvent(ApplicationEvent):
    """Application Upgrade Rollback Started event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param current_application_type_version: Required. Current Application
     type version.
    :type current_application_type_version: str
    :param application_type_version: Required. Target Application type
     version.
    :type application_type_version: str
    :param failure_reason: Required. Describes reason of failure.
    :type failure_reason: str
    :param overall_upgrade_elapsed_time_in_ms: Required. Overall upgrade time
     in milli-seconds.
    :type overall_upgrade_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_type_name': {'required': True},
        'current_application_type_version': {'required': True},
        'application_type_version': {'required': True},
        'failure_reason': {'required': True},
        'overall_upgrade_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'current_application_type_version': {'key': 'CurrentApplicationTypeVersion', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'failure_reason': {'key': 'FailureReason', 'type': 'str'},
        'overall_upgrade_elapsed_time_in_ms': {'key': 'OverallUpgradeElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeRollbackStartedEvent, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.current_application_type_version = kwargs.get('current_application_type_version', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.failure_reason = kwargs.get('failure_reason', None)
        self.overall_upgrade_elapsed_time_in_ms = kwargs.get('overall_upgrade_elapsed_time_in_ms', None)
        self.kind = 'ApplicationUpgradeRollbackStarted'


class ApplicationUpgradeStartedEvent(ApplicationEvent):
    """Application Upgrade Started event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param current_application_type_version: Required. Current Application
     type version.
    :type current_application_type_version: str
    :param application_type_version: Required. Target Application type
     version.
    :type application_type_version: str
    :param upgrade_type: Required. Type of upgrade.
    :type upgrade_type: str
    :param rolling_upgrade_mode: Required. Mode of upgrade.
    :type rolling_upgrade_mode: str
    :param failure_action: Required. Action if failed.
    :type failure_action: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_type_name': {'required': True},
        'current_application_type_version': {'required': True},
        'application_type_version': {'required': True},
        'upgrade_type': {'required': True},
        'rolling_upgrade_mode': {'required': True},
        'failure_action': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'current_application_type_version': {'key': 'CurrentApplicationTypeVersion', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'upgrade_type': {'key': 'UpgradeType', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'failure_action': {'key': 'FailureAction', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeStartedEvent, self).__init__(**kwargs)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.current_application_type_version = kwargs.get('current_application_type_version', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.upgrade_type = kwargs.get('upgrade_type', None)
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', None)
        self.failure_action = kwargs.get('failure_action', None)
        self.kind = 'ApplicationUpgradeStarted'


class ApplicationUpgradeUpdateDescription(Model):
    """Describes the parameters for updating an ongoing application upgrade.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the application, including the
     'fabric:' URI scheme.
    :type name: str
    :param upgrade_kind: Required. The kind of upgrade out of the following
     possible values. Possible values include: 'Invalid', 'Rolling'. Default
     value: "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeKind
    :param application_health_policy: Defines a health policy used to evaluate
     the health of an application or one of its children entities.
    :type application_health_policy:
     ~azure.servicefabric.models.ApplicationHealthPolicy
    :param update_description: Describes the parameters for updating a rolling
     upgrade of application or cluster.
    :type update_description:
     ~azure.servicefabric.models.RollingUpgradeUpdateDescription
    """

    _validation = {
        'name': {'required': True},
        'upgrade_kind': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'application_health_policy': {'key': 'ApplicationHealthPolicy', 'type': 'ApplicationHealthPolicy'},
        'update_description': {'key': 'UpdateDescription', 'type': 'RollingUpgradeUpdateDescription'},
    }

    def __init__(self, **kwargs):
        super(ApplicationUpgradeUpdateDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.application_health_policy = kwargs.get('application_health_policy', None)
        self.update_description = kwargs.get('update_description', None)


class AutoScalingMetric(Model):
    """Describes the metric that is used for triggering auto scaling operation.
    Derived classes will describe resources or metrics.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoScalingResourceMetric

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Resource': 'AutoScalingResourceMetric'}
    }

    def __init__(self, **kwargs):
        super(AutoScalingMetric, self).__init__(**kwargs)
        self.kind = None


class AutoScalingPolicy(Model):
    """Describes the auto scaling policy.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the auto scaling policy.
    :type name: str
    :param trigger: Required. Determines when auto scaling operation will be
     invoked.
    :type trigger: ~azure.servicefabric.models.AutoScalingTrigger
    :param mechanism: Required. The mechanism that is used to scale when auto
     scaling operation is invoked.
    :type mechanism: ~azure.servicefabric.models.AutoScalingMechanism
    """

    _validation = {
        'name': {'required': True},
        'trigger': {'required': True},
        'mechanism': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'trigger': {'key': 'trigger', 'type': 'AutoScalingTrigger'},
        'mechanism': {'key': 'mechanism', 'type': 'AutoScalingMechanism'},
    }

    def __init__(self, **kwargs):
        super(AutoScalingPolicy, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.trigger = kwargs.get('trigger', None)
        self.mechanism = kwargs.get('mechanism', None)


class AutoScalingResourceMetric(AutoScalingMetric):
    """Describes the resource that is used for triggering auto scaling.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param name: Required. Name of the resource. Possible values include:
     'cpu', 'memoryInGB'
    :type name: str or
     ~azure.servicefabric.models.AutoScalingResourceMetricName
    """

    _validation = {
        'kind': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutoScalingResourceMetric, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.kind = 'Resource'


class AutoScalingTrigger(Model):
    """Describes the trigger for performing auto scaling operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AverageLoadScalingTrigger

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AverageLoad': 'AverageLoadScalingTrigger'}
    }

    def __init__(self, **kwargs):
        super(AutoScalingTrigger, self).__init__(**kwargs)
        self.kind = None


class AverageLoadScalingTrigger(AutoScalingTrigger):
    """Describes the average load trigger used for auto scaling.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param metric: Required. Description of the metric that is used for
     scaling.
    :type metric: ~azure.servicefabric.models.AutoScalingMetric
    :param lower_load_threshold: Required. Lower load threshold (if average
     load is below this threshold, service will scale down).
    :type lower_load_threshold: float
    :param upper_load_threshold: Required. Upper load threshold (if average
     load is above this threshold, service will scale up).
    :type upper_load_threshold: float
    :param scale_interval_in_seconds: Required. Scale interval that indicates
     how often will this trigger be checked.
    :type scale_interval_in_seconds: int
    """

    _validation = {
        'kind': {'required': True},
        'metric': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval_in_seconds': {'required': True, 'minimum': 60},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'metric': {'key': 'metric', 'type': 'AutoScalingMetric'},
        'lower_load_threshold': {'key': 'lowerLoadThreshold', 'type': 'float'},
        'upper_load_threshold': {'key': 'upperLoadThreshold', 'type': 'float'},
        'scale_interval_in_seconds': {'key': 'scaleIntervalInSeconds', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AverageLoadScalingTrigger, self).__init__(**kwargs)
        self.metric = kwargs.get('metric', None)
        self.lower_load_threshold = kwargs.get('lower_load_threshold', None)
        self.upper_load_threshold = kwargs.get('upper_load_threshold', None)
        self.scale_interval_in_seconds = kwargs.get('scale_interval_in_seconds', None)
        self.kind = 'AverageLoad'


class ScalingTriggerDescription(Model):
    """Describes the trigger for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AveragePartitionLoadScalingTrigger,
    AverageServiceLoadScalingTrigger

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AveragePartitionLoad': 'AveragePartitionLoadScalingTrigger', 'AverageServiceLoad': 'AverageServiceLoadScalingTrigger'}
    }

    def __init__(self, **kwargs):
        super(ScalingTriggerDescription, self).__init__(**kwargs)
        self.kind = None


class AveragePartitionLoadScalingTrigger(ScalingTriggerDescription):
    """Represents a scaling trigger related to an average load of a
    metric/resource of a partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param metric_name: Required. The name of the metric for which usage
     should be tracked.
    :type metric_name: str
    :param lower_load_threshold: Required. The lower limit of the load below
     which a scale in operation should be performed.
    :type lower_load_threshold: str
    :param upper_load_threshold: Required. The upper limit of the load beyond
     which a scale out operation should be performed.
    :type upper_load_threshold: str
    :param scale_interval_in_seconds: Required. The period in seconds on which
     a decision is made whether to scale or not.
    :type scale_interval_in_seconds: long
    """

    _validation = {
        'kind': {'required': True},
        'metric_name': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval_in_seconds': {'required': True, 'maximum': 4294967295, 'minimum': 0},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'metric_name': {'key': 'MetricName', 'type': 'str'},
        'lower_load_threshold': {'key': 'LowerLoadThreshold', 'type': 'str'},
        'upper_load_threshold': {'key': 'UpperLoadThreshold', 'type': 'str'},
        'scale_interval_in_seconds': {'key': 'ScaleIntervalInSeconds', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(AveragePartitionLoadScalingTrigger, self).__init__(**kwargs)
        self.metric_name = kwargs.get('metric_name', None)
        self.lower_load_threshold = kwargs.get('lower_load_threshold', None)
        self.upper_load_threshold = kwargs.get('upper_load_threshold', None)
        self.scale_interval_in_seconds = kwargs.get('scale_interval_in_seconds', None)
        self.kind = 'AveragePartitionLoad'


class AverageServiceLoadScalingTrigger(ScalingTriggerDescription):
    """Represents a scaling policy related to an average load of a metric/resource
    of a service.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param metric_name: Required. The name of the metric for which usage
     should be tracked.
    :type metric_name: str
    :param lower_load_threshold: Required. The lower limit of the load below
     which a scale in operation should be performed.
    :type lower_load_threshold: str
    :param upper_load_threshold: Required. The upper limit of the load beyond
     which a scale out operation should be performed.
    :type upper_load_threshold: str
    :param scale_interval_in_seconds: Required. The period in seconds on which
     a decision is made whether to scale or not.
    :type scale_interval_in_seconds: long
    """

    _validation = {
        'kind': {'required': True},
        'metric_name': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval_in_seconds': {'required': True, 'maximum': 4294967295, 'minimum': 0},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'metric_name': {'key': 'MetricName', 'type': 'str'},
        'lower_load_threshold': {'key': 'LowerLoadThreshold', 'type': 'str'},
        'upper_load_threshold': {'key': 'UpperLoadThreshold', 'type': 'str'},
        'scale_interval_in_seconds': {'key': 'ScaleIntervalInSeconds', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(AverageServiceLoadScalingTrigger, self).__init__(**kwargs)
        self.metric_name = kwargs.get('metric_name', None)
        self.lower_load_threshold = kwargs.get('lower_load_threshold', None)
        self.upper_load_threshold = kwargs.get('upper_load_threshold', None)
        self.scale_interval_in_seconds = kwargs.get('scale_interval_in_seconds', None)
        self.kind = 'AverageServiceLoad'


class BackupStorageDescription(Model):
    """Describes the parameters for the backup storage.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobBackupStorageDescription,
    FileShareBackupStorageDescription

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name for this backup storage.
    :type friendly_name: str
    :param storage_kind: Required. Constant filled by server.
    :type storage_kind: str
    """

    _validation = {
        'storage_kind': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'FriendlyName', 'type': 'str'},
        'storage_kind': {'key': 'StorageKind', 'type': 'str'},
    }

    _subtype_map = {
        'storage_kind': {'AzureBlobStore': 'AzureBlobBackupStorageDescription', 'FileShare': 'FileShareBackupStorageDescription'}
    }

    def __init__(self, **kwargs):
        super(BackupStorageDescription, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.storage_kind = None


class AzureBlobBackupStorageDescription(BackupStorageDescription):
    """Describes the parameters for Azure blob store used for storing and
    enumerating backups.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name for this backup storage.
    :type friendly_name: str
    :param storage_kind: Required. Constant filled by server.
    :type storage_kind: str
    :param connection_string: Required. The connection string to connect to
     the Azure blob store.
    :type connection_string: str
    :param container_name: Required. The name of the container in the blob
     store to store and enumerate backups from.
    :type container_name: str
    """

    _validation = {
        'storage_kind': {'required': True},
        'connection_string': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'FriendlyName', 'type': 'str'},
        'storage_kind': {'key': 'StorageKind', 'type': 'str'},
        'connection_string': {'key': 'ConnectionString', 'type': 'str'},
        'container_name': {'key': 'ContainerName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureBlobBackupStorageDescription, self).__init__(**kwargs)
        self.connection_string = kwargs.get('connection_string', None)
        self.container_name = kwargs.get('container_name', None)
        self.storage_kind = 'AzureBlobStore'


class DiagnosticsSinkProperties(Model):
    """Properties of a DiagnosticsSink.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureInternalMonitoringPipelineSinkDescription

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the sink. This value is referenced by
     DiagnosticsReferenceDescription
    :type name: str
    :param description: A description of the sink.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AzureInternalMonitoringPipeline': 'AzureInternalMonitoringPipelineSinkDescription'}
    }

    def __init__(self, **kwargs):
        super(DiagnosticsSinkProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.kind = None


class AzureInternalMonitoringPipelineSinkDescription(DiagnosticsSinkProperties):
    """Diagnostics settings for Geneva.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the sink. This value is referenced by
     DiagnosticsReferenceDescription
    :type name: str
    :param description: A description of the sink.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param account_name: Azure Internal monitoring pipeline account.
    :type account_name: str
    :param namespace: Azure Internal monitoring pipeline account namespace.
    :type namespace: str
    :param ma_config_url: Azure Internal monitoring agent configuration.
    :type ma_config_url: str
    :param fluentd_config_url: Azure Internal monitoring agent fluentd
     configuration.
    :type fluentd_config_url: str
    :param auto_key_config_url: Azure Internal monitoring pipeline autokey
     associated with the certificate.
    :type auto_key_config_url: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'ma_config_url': {'key': 'maConfigUrl', 'type': 'str'},
        'fluentd_config_url': {'key': 'fluentdConfigUrl', 'type': 'str'},
        'auto_key_config_url': {'key': 'autoKeyConfigUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureInternalMonitoringPipelineSinkDescription, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.namespace = kwargs.get('namespace', None)
        self.ma_config_url = kwargs.get('ma_config_url', None)
        self.fluentd_config_url = kwargs.get('fluentd_config_url', None)
        self.auto_key_config_url = kwargs.get('auto_key_config_url', None)
        self.kind = 'AzureInternalMonitoringPipeline'


class BackupInfo(Model):
    """Represents a backup point which can be used to trigger a restore.

    :param backup_id: Unique backup ID .
    :type backup_id: str
    :param backup_chain_id: Unique backup chain ID. All backups part of the
     same chain has the same backup chain id. A backup chain is comprised of 1
     full backup and multiple incremental backups.
    :type backup_chain_id: str
    :param application_name: Name of the Service Fabric application this
     partition backup belongs to.
    :type application_name: str
    :param service_name: Name of the Service Fabric service this partition
     backup belongs to.
    :type service_name: str
    :param partition_information: Information about the partition to which
     this backup belongs to
    :type partition_information:
     ~azure.servicefabric.models.PartitionInformation
    :param backup_location: Location of the backup, relative to the backup
     store.
    :type backup_location: str
    :param backup_type: Describes the type of backup, whether its full or
     incremental. Possible values include: 'Invalid', 'Full', 'Incremental'
    :type backup_type: str or ~azure.servicefabric.models.BackupType
    :param epoch_of_last_backup_record: Epoch of the last record in this
     backup.
    :type epoch_of_last_backup_record: ~azure.servicefabric.models.Epoch
    :param lsn_of_last_backup_record: LSN of the last record in this backup.
    :type lsn_of_last_backup_record: str
    :param creation_time_utc: The date time when this backup was taken.
    :type creation_time_utc: datetime
    :param service_manifest_version: Manifest Version of the service this
     partition backup belongs to.
    :type service_manifest_version: str
    :param failure_error: Denotes the failure encountered in getting backup
     point information.
    :type failure_error: ~azure.servicefabric.models.FabricErrorError
    """

    _attribute_map = {
        'backup_id': {'key': 'BackupId', 'type': 'str'},
        'backup_chain_id': {'key': 'BackupChainId', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'backup_location': {'key': 'BackupLocation', 'type': 'str'},
        'backup_type': {'key': 'BackupType', 'type': 'str'},
        'epoch_of_last_backup_record': {'key': 'EpochOfLastBackupRecord', 'type': 'Epoch'},
        'lsn_of_last_backup_record': {'key': 'LsnOfLastBackupRecord', 'type': 'str'},
        'creation_time_utc': {'key': 'CreationTimeUtc', 'type': 'iso-8601'},
        'service_manifest_version': {'key': 'ServiceManifestVersion', 'type': 'str'},
        'failure_error': {'key': 'FailureError', 'type': 'FabricErrorError'},
    }

    def __init__(self, **kwargs):
        super(BackupInfo, self).__init__(**kwargs)
        self.backup_id = kwargs.get('backup_id', None)
        self.backup_chain_id = kwargs.get('backup_chain_id', None)
        self.application_name = kwargs.get('application_name', None)
        self.service_name = kwargs.get('service_name', None)
        self.partition_information = kwargs.get('partition_information', None)
        self.backup_location = kwargs.get('backup_location', None)
        self.backup_type = kwargs.get('backup_type', None)
        self.epoch_of_last_backup_record = kwargs.get('epoch_of_last_backup_record', None)
        self.lsn_of_last_backup_record = kwargs.get('lsn_of_last_backup_record', None)
        self.creation_time_utc = kwargs.get('creation_time_utc', None)
        self.service_manifest_version = kwargs.get('service_manifest_version', None)
        self.failure_error = kwargs.get('failure_error', None)


class BackupPartitionDescription(Model):
    """Describes the parameters for triggering partition's backup.

    :param backup_storage: Specifies the details of the backup storage where
     to save the backup.
    :type backup_storage: ~azure.servicefabric.models.BackupStorageDescription
    """

    _attribute_map = {
        'backup_storage': {'key': 'BackupStorage', 'type': 'BackupStorageDescription'},
    }

    def __init__(self, **kwargs):
        super(BackupPartitionDescription, self).__init__(**kwargs)
        self.backup_storage = kwargs.get('backup_storage', None)


class BackupPolicyDescription(Model):
    """Describes a backup policy for configuring periodic backup.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name identifying this backup policy.
    :type name: str
    :param auto_restore_on_data_loss: Required. Specifies whether to trigger
     restore automatically using the latest available backup in case the
     partition experiences a data loss event.
    :type auto_restore_on_data_loss: bool
    :param max_incremental_backups: Required. Defines the maximum number of
     incremental backups to be taken between two full backups. This is just the
     upper limit. A full backup may be taken before specified number of
     incremental backups are completed in one of the following conditions
     - The replica has never taken a full backup since it has become primary,
     - Some of the log records since the last backup has been truncated, or
     - Replica passed the MaxAccumulatedBackupLogSizeInMB limit.
    :type max_incremental_backups: int
    :param schedule: Required. Describes the backup schedule parameters.
    :type schedule: ~azure.servicefabric.models.BackupScheduleDescription
    :param storage: Required. Describes the details of backup storage where to
     store the periodic backups.
    :type storage: ~azure.servicefabric.models.BackupStorageDescription
    :param retention_policy: Describes the policy to retain backups in
     storage.
    :type retention_policy:
     ~azure.servicefabric.models.RetentionPolicyDescription
    """

    _validation = {
        'name': {'required': True},
        'auto_restore_on_data_loss': {'required': True},
        'max_incremental_backups': {'required': True, 'maximum': 255, 'minimum': 0},
        'schedule': {'required': True},
        'storage': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'auto_restore_on_data_loss': {'key': 'AutoRestoreOnDataLoss', 'type': 'bool'},
        'max_incremental_backups': {'key': 'MaxIncrementalBackups', 'type': 'int'},
        'schedule': {'key': 'Schedule', 'type': 'BackupScheduleDescription'},
        'storage': {'key': 'Storage', 'type': 'BackupStorageDescription'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicyDescription'},
    }

    def __init__(self, **kwargs):
        super(BackupPolicyDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.auto_restore_on_data_loss = kwargs.get('auto_restore_on_data_loss', None)
        self.max_incremental_backups = kwargs.get('max_incremental_backups', None)
        self.schedule = kwargs.get('schedule', None)
        self.storage = kwargs.get('storage', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class BackupProgressInfo(Model):
    """Describes the progress of a partition's backup.

    :param backup_state: Represents the current state of the partition backup
     operation. Possible values include: 'Invalid', 'Accepted',
     'BackupInProgress', 'Success', 'Failure', 'Timeout'
    :type backup_state: str or ~azure.servicefabric.models.BackupState
    :param time_stamp_utc: TimeStamp in UTC when operation succeeded or
     failed.
    :type time_stamp_utc: datetime
    :param backup_id: Unique ID of the newly created backup.
    :type backup_id: str
    :param backup_location: Location, relative to the backup store, of the
     newly created backup.
    :type backup_location: str
    :param epoch_of_last_backup_record: Specifies the epoch of the last record
     included in backup.
    :type epoch_of_last_backup_record: ~azure.servicefabric.models.Epoch
    :param lsn_of_last_backup_record: The LSN of last record included in
     backup.
    :type lsn_of_last_backup_record: str
    :param failure_error: Denotes the failure encountered in performing backup
     operation.
    :type failure_error: ~azure.servicefabric.models.FabricErrorError
    """

    _attribute_map = {
        'backup_state': {'key': 'BackupState', 'type': 'str'},
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'backup_id': {'key': 'BackupId', 'type': 'str'},
        'backup_location': {'key': 'BackupLocation', 'type': 'str'},
        'epoch_of_last_backup_record': {'key': 'EpochOfLastBackupRecord', 'type': 'Epoch'},
        'lsn_of_last_backup_record': {'key': 'LsnOfLastBackupRecord', 'type': 'str'},
        'failure_error': {'key': 'FailureError', 'type': 'FabricErrorError'},
    }

    def __init__(self, **kwargs):
        super(BackupProgressInfo, self).__init__(**kwargs)
        self.backup_state = kwargs.get('backup_state', None)
        self.time_stamp_utc = kwargs.get('time_stamp_utc', None)
        self.backup_id = kwargs.get('backup_id', None)
        self.backup_location = kwargs.get('backup_location', None)
        self.epoch_of_last_backup_record = kwargs.get('epoch_of_last_backup_record', None)
        self.lsn_of_last_backup_record = kwargs.get('lsn_of_last_backup_record', None)
        self.failure_error = kwargs.get('failure_error', None)


class BackupScheduleDescription(Model):
    """Describes the backup schedule parameters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FrequencyBasedBackupScheduleDescription,
    TimeBasedBackupScheduleDescription

    All required parameters must be populated in order to send to Azure.

    :param schedule_kind: Required. Constant filled by server.
    :type schedule_kind: str
    """

    _validation = {
        'schedule_kind': {'required': True},
    }

    _attribute_map = {
        'schedule_kind': {'key': 'ScheduleKind', 'type': 'str'},
    }

    _subtype_map = {
        'schedule_kind': {'FrequencyBased': 'FrequencyBasedBackupScheduleDescription', 'TimeBased': 'TimeBasedBackupScheduleDescription'}
    }

    def __init__(self, **kwargs):
        super(BackupScheduleDescription, self).__init__(**kwargs)
        self.schedule_kind = None


class BackupSuspensionInfo(Model):
    """Describes the backup suspension details.

    :param is_suspended: Indicates whether periodic backup is suspended at
     this level or not.
    :type is_suspended: bool
    :param suspension_inherited_from: Specifies the scope at which the backup
     suspension was applied. Possible values include: 'Invalid', 'Partition',
     'Service', 'Application'
    :type suspension_inherited_from: str or
     ~azure.servicefabric.models.BackupSuspensionScope
    """

    _attribute_map = {
        'is_suspended': {'key': 'IsSuspended', 'type': 'bool'},
        'suspension_inherited_from': {'key': 'SuspensionInheritedFrom', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackupSuspensionInfo, self).__init__(**kwargs)
        self.is_suspended = kwargs.get('is_suspended', None)
        self.suspension_inherited_from = kwargs.get('suspension_inherited_from', None)


class RetentionPolicyDescription(Model):
    """Describes the retention policy configured.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BasicRetentionPolicyDescription

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    """

    _validation = {
        'retention_policy_type': {'required': True},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'RetentionPolicyType', 'type': 'str'},
    }

    _subtype_map = {
        'retention_policy_type': {'Basic': 'BasicRetentionPolicyDescription'}
    }

    def __init__(self, **kwargs):
        super(RetentionPolicyDescription, self).__init__(**kwargs)
        self.retention_policy_type = None


class BasicRetentionPolicyDescription(RetentionPolicyDescription):
    """Describes basic retention policy.

    All required parameters must be populated in order to send to Azure.

    :param retention_policy_type: Required. Constant filled by server.
    :type retention_policy_type: str
    :param retention_duration: Required. It is the minimum duration for which
     a backup created, will remain stored in the storage and might get deleted
     after that span of time. It should be specified in ISO8601 format.
    :type retention_duration: timedelta
    :param minimum_number_of_backups: It is the minimum number of backups to
     be retained at any point of time. If specified with a non zero value,
     backups will not be deleted even if the backups have gone past retention
     duration and have number of backups less than or equal to it.
    :type minimum_number_of_backups: int
    """

    _validation = {
        'retention_policy_type': {'required': True},
        'retention_duration': {'required': True},
        'minimum_number_of_backups': {'minimum': 0},
    }

    _attribute_map = {
        'retention_policy_type': {'key': 'RetentionPolicyType', 'type': 'str'},
        'retention_duration': {'key': 'RetentionDuration', 'type': 'duration'},
        'minimum_number_of_backups': {'key': 'MinimumNumberOfBackups', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BasicRetentionPolicyDescription, self).__init__(**kwargs)
        self.retention_duration = kwargs.get('retention_duration', None)
        self.minimum_number_of_backups = kwargs.get('minimum_number_of_backups', None)
        self.retention_policy_type = 'Basic'


class PropertyValue(Model):
    """Describes a Service Fabric property value.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BinaryPropertyValue, Int64PropertyValue,
    DoublePropertyValue, StringPropertyValue, GuidPropertyValue

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Binary': 'BinaryPropertyValue', 'Int64': 'Int64PropertyValue', 'Double': 'DoublePropertyValue', 'String': 'StringPropertyValue', 'Guid': 'GuidPropertyValue'}
    }

    def __init__(self, **kwargs):
        super(PropertyValue, self).__init__(**kwargs)
        self.kind = None


class BinaryPropertyValue(PropertyValue):
    """Describes a Service Fabric property value of type Binary.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param data: Required. Array of bytes to be sent as an integer array. Each
     element of array is a number between 0 and 255.
    :type data: list[int]
    """

    _validation = {
        'kind': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'data': {'key': 'Data', 'type': '[int]'},
    }

    def __init__(self, **kwargs):
        super(BinaryPropertyValue, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.kind = 'Binary'


class Chaos(Model):
    """Contains a description of Chaos.

    :param chaos_parameters: If Chaos is running, these are the parameters
     Chaos is running with.
    :type chaos_parameters: ~azure.servicefabric.models.ChaosParameters
    :param status: Current status of the Chaos run. Possible values include:
     'Invalid', 'Running', 'Stopped'
    :type status: str or ~azure.servicefabric.models.ChaosStatus
    :param schedule_status: Current status of the schedule. Possible values
     include: 'Invalid', 'Stopped', 'Active', 'Expired', 'Pending'
    :type schedule_status: str or
     ~azure.servicefabric.models.ChaosScheduleStatus
    """

    _attribute_map = {
        'chaos_parameters': {'key': 'ChaosParameters', 'type': 'ChaosParameters'},
        'status': {'key': 'Status', 'type': 'str'},
        'schedule_status': {'key': 'ScheduleStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Chaos, self).__init__(**kwargs)
        self.chaos_parameters = kwargs.get('chaos_parameters', None)
        self.status = kwargs.get('status', None)
        self.schedule_status = kwargs.get('schedule_status', None)


class ChaosCodePackageRestartScheduledEvent(ApplicationEvent):
    """Chaos Restart Code Package Fault Scheduled event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param fault_group_id: Required. Id of fault group.
    :type fault_group_id: str
    :param fault_id: Required. Id of fault.
    :type fault_id: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param service_manifest_name: Required. Service manifest name.
    :type service_manifest_name: str
    :param code_package_name: Required. Code package name.
    :type code_package_name: str
    :param service_package_activation_id: Required. Id of Service package
     activation.
    :type service_package_activation_id: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'fault_group_id': {'required': True},
        'fault_id': {'required': True},
        'node_name': {'required': True},
        'service_manifest_name': {'required': True},
        'code_package_name': {'required': True},
        'service_package_activation_id': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'fault_group_id': {'key': 'FaultGroupId', 'type': 'str'},
        'fault_id': {'key': 'FaultId', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ChaosCodePackageRestartScheduledEvent, self).__init__(**kwargs)
        self.fault_group_id = kwargs.get('fault_group_id', None)
        self.fault_id = kwargs.get('fault_id', None)
        self.node_name = kwargs.get('node_name', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.code_package_name = kwargs.get('code_package_name', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.kind = 'ChaosCodePackageRestartScheduled'


class ChaosContext(Model):
    """Describes a map, which is a collection of (string, string) type key-value
    pairs. The map can be used to record information about
    the Chaos run. There cannot be more than 100 such pairs and each string
    (key or value) can be at most 4095 characters long.
    This map is set by the starter of the Chaos run to optionally store the
    context about the specific run.

    :param map: Describes a map that contains a collection of
     ChaosContextMapItem's.
    :type map: dict[str, str]
    """

    _attribute_map = {
        'map': {'key': 'Map', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ChaosContext, self).__init__(**kwargs)
        self.map = kwargs.get('map', None)


class ChaosEvent(Model):
    """Represents an event generated during a Chaos run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExecutingFaultsChaosEvent, StartedChaosEvent,
    StoppedChaosEvent, TestErrorChaosEvent, ValidationFailedChaosEvent,
    WaitingChaosEvent

    All required parameters must be populated in order to send to Azure.

    :param time_stamp_utc: Required. The UTC timestamp when this Chaos event
     was generated.
    :type time_stamp_utc: datetime
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ExecutingFaults': 'ExecutingFaultsChaosEvent', 'Started': 'StartedChaosEvent', 'Stopped': 'StoppedChaosEvent', 'TestError': 'TestErrorChaosEvent', 'ValidationFailed': 'ValidationFailedChaosEvent', 'Waiting': 'WaitingChaosEvent'}
    }

    def __init__(self, **kwargs):
        super(ChaosEvent, self).__init__(**kwargs)
        self.time_stamp_utc = kwargs.get('time_stamp_utc', None)
        self.kind = None


class ChaosEventsSegment(Model):
    """Contains the list of Chaos events and the continuation token to get the
    next segment.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param history: List of Chaos events that meet the user-supplied criteria.
    :type history: list[~azure.servicefabric.models.ChaosEventWrapper]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'history': {'key': 'History', 'type': '[ChaosEventWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ChaosEventsSegment, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.history = kwargs.get('history', None)


class ChaosEventWrapper(Model):
    """Wrapper object for Chaos event.

    :param chaos_event: Represents an event generated during a Chaos run.
    :type chaos_event: ~azure.servicefabric.models.ChaosEvent
    """

    _attribute_map = {
        'chaos_event': {'key': 'ChaosEvent', 'type': 'ChaosEvent'},
    }

    def __init__(self, **kwargs):
        super(ChaosEventWrapper, self).__init__(**kwargs)
        self.chaos_event = kwargs.get('chaos_event', None)


class NodeEvent(FabricEvent):
    """Represents the base for all Node Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NodeAbortedEvent, NodeAddedToClusterEvent,
    NodeClosedEvent, NodeDeactivateCompletedEvent, NodeDeactivateStartedEvent,
    NodeDownEvent, NodeNewHealthReportEvent, NodeHealthReportExpiredEvent,
    NodeOpenSucceededEvent, NodeOpenFailedEvent, NodeRemovedFromClusterEvent,
    NodeUpEvent, ChaosNodeRestartScheduledEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'NodeAborted': 'NodeAbortedEvent', 'NodeAddedToCluster': 'NodeAddedToClusterEvent', 'NodeClosed': 'NodeClosedEvent', 'NodeDeactivateCompleted': 'NodeDeactivateCompletedEvent', 'NodeDeactivateStarted': 'NodeDeactivateStartedEvent', 'NodeDown': 'NodeDownEvent', 'NodeNewHealthReport': 'NodeNewHealthReportEvent', 'NodeHealthReportExpired': 'NodeHealthReportExpiredEvent', 'NodeOpenSucceeded': 'NodeOpenSucceededEvent', 'NodeOpenFailed': 'NodeOpenFailedEvent', 'NodeRemovedFromCluster': 'NodeRemovedFromClusterEvent', 'NodeUp': 'NodeUpEvent', 'ChaosNodeRestartScheduled': 'ChaosNodeRestartScheduledEvent'}
    }

    def __init__(self, **kwargs):
        super(NodeEvent, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.kind = 'NodeEvent'


class ChaosNodeRestartScheduledEvent(NodeEvent):
    """Chaos Restart Node Fault Scheduled event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance_id: Required. Id of Node instance.
    :type node_instance_id: long
    :param fault_group_id: Required. Id of fault group.
    :type fault_group_id: str
    :param fault_id: Required. Id of fault.
    :type fault_id: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance_id': {'required': True},
        'fault_group_id': {'required': True},
        'fault_id': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance_id': {'key': 'NodeInstanceId', 'type': 'long'},
        'fault_group_id': {'key': 'FaultGroupId', 'type': 'str'},
        'fault_id': {'key': 'FaultId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ChaosNodeRestartScheduledEvent, self).__init__(**kwargs)
        self.node_instance_id = kwargs.get('node_instance_id', None)
        self.fault_group_id = kwargs.get('fault_group_id', None)
        self.fault_id = kwargs.get('fault_id', None)
        self.kind = 'ChaosNodeRestartScheduled'


class ChaosParameters(Model):
    """Defines all the parameters to configure a Chaos run.

    :param time_to_run_in_seconds: Total time (in seconds) for which Chaos
     will run before automatically stopping. The maximum allowed value is
     4,294,967,295 (System.UInt32.MaxValue). Default value: "4294967295" .
    :type time_to_run_in_seconds: str
    :param max_cluster_stabilization_timeout_in_seconds: The maximum amount of
     time to wait for all cluster entities to become stable and healthy. Chaos
     executes in iterations and at the start of each iteration it validates the
     health of cluster entities.
     During validation if a cluster entity is not stable and healthy within
     MaxClusterStabilizationTimeoutInSeconds, Chaos generates a validation
     failed event. Default value: 60 .
    :type max_cluster_stabilization_timeout_in_seconds: long
    :param max_concurrent_faults: MaxConcurrentFaults is the maximum number of
     concurrent faults induced per iteration.
     Chaos executes in iterations and two consecutive iterations are separated
     by a validation phase.
     The higher the concurrency, the more aggressive the injection of faults,
     leading to inducing more complex series of states to uncover bugs.
     The recommendation is to start with a value of 2 or 3 and to exercise
     caution while moving up. Default value: 1 .
    :type max_concurrent_faults: long
    :param enable_move_replica_faults: Enables or disables the move primary
     and move secondary faults. Default value: True .
    :type enable_move_replica_faults: bool
    :param wait_time_between_faults_in_seconds: Wait time (in seconds) between
     consecutive faults within a single iteration.
     The larger the value, the lower the overlapping between faults and the
     simpler the sequence of state transitions that the cluster goes through.
     The recommendation is to start with a value between 1 and 5 and exercise
     caution while moving up. Default value: 20 .
    :type wait_time_between_faults_in_seconds: long
    :param wait_time_between_iterations_in_seconds: Time-separation (in
     seconds) between two consecutive iterations of Chaos.
     The larger the value, the lower the fault injection rate. Default value:
     30 .
    :type wait_time_between_iterations_in_seconds: long
    :param cluster_health_policy: Passed-in cluster health policy is used to
     validate health of the cluster in between Chaos iterations. If the cluster
     health is in error or if an unexpected exception happens during fault
     execution--to provide the cluster with some time to recuperate--Chaos will
     wait for 30 minutes before the next health-check.
    :type cluster_health_policy:
     ~azure.servicefabric.models.ClusterHealthPolicy
    :param context: Describes a map, which is a collection of (string, string)
     type key-value pairs. The map can be used to record information about
     the Chaos run. There cannot be more than 100 such pairs and each string
     (key or value) can be at most 4095 characters long.
     This map is set by the starter of the Chaos run to optionally store the
     context about the specific run.
    :type context: ~azure.servicefabric.models.ChaosContext
    :param chaos_target_filter: List of cluster entities to target for Chaos
     faults.
     This filter can be used to target Chaos faults only to certain node types
     or only to certain application instances. If ChaosTargetFilter is not
     used, Chaos faults all cluster entities.
     If ChaosTargetFilter is used, Chaos faults only the entities that meet the
     ChaosTargetFilter specification.
    :type chaos_target_filter: ~azure.servicefabric.models.ChaosTargetFilter
    """

    _validation = {
        'max_cluster_stabilization_timeout_in_seconds': {'maximum': 4294967295, 'minimum': 0},
        'max_concurrent_faults': {'maximum': 4294967295, 'minimum': 0},
        'wait_time_between_faults_in_seconds': {'maximum': 4294967295, 'minimum': 0},
        'wait_time_between_iterations_in_seconds': {'maximum': 4294967295, 'minimum': 0},
    }

    _attribute_map = {
        'time_to_run_in_seconds': {'key': 'TimeToRunInSeconds', 'type': 'str'},
        'max_cluster_stabilization_timeout_in_seconds': {'key': 'MaxClusterStabilizationTimeoutInSeconds', 'type': 'long'},
        'max_concurrent_faults': {'key': 'MaxConcurrentFaults', 'type': 'long'},
        'enable_move_replica_faults': {'key': 'EnableMoveReplicaFaults', 'type': 'bool'},
        'wait_time_between_faults_in_seconds': {'key': 'WaitTimeBetweenFaultsInSeconds', 'type': 'long'},
        'wait_time_between_iterations_in_seconds': {'key': 'WaitTimeBetweenIterationsInSeconds', 'type': 'long'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'ClusterHealthPolicy'},
        'context': {'key': 'Context', 'type': 'ChaosContext'},
        'chaos_target_filter': {'key': 'ChaosTargetFilter', 'type': 'ChaosTargetFilter'},
    }

    def __init__(self, **kwargs):
        super(ChaosParameters, self).__init__(**kwargs)
        self.time_to_run_in_seconds = kwargs.get('time_to_run_in_seconds', "4294967295")
        self.max_cluster_stabilization_timeout_in_seconds = kwargs.get('max_cluster_stabilization_timeout_in_seconds', 60)
        self.max_concurrent_faults = kwargs.get('max_concurrent_faults', 1)
        self.enable_move_replica_faults = kwargs.get('enable_move_replica_faults', True)
        self.wait_time_between_faults_in_seconds = kwargs.get('wait_time_between_faults_in_seconds', 20)
        self.wait_time_between_iterations_in_seconds = kwargs.get('wait_time_between_iterations_in_seconds', 30)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)
        self.context = kwargs.get('context', None)
        self.chaos_target_filter = kwargs.get('chaos_target_filter', None)


class ChaosParametersDictionaryItem(Model):
    """Defines an item in ChaosParametersDictionary of the Chaos Schedule.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key identifying the Chaos Parameter in the
     dictionary. This key is referenced by Chaos Schedule Jobs.
    :type key: str
    :param value: Required. Defines all the parameters to configure a Chaos
     run.
    :type value: ~azure.servicefabric.models.ChaosParameters
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'ChaosParameters'},
    }

    def __init__(self, **kwargs):
        super(ChaosParametersDictionaryItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class PartitionEvent(FabricEvent):
    """Represents the base for all Partition Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartitionAnalysisEvent, PartitionNewHealthReportEvent,
    PartitionHealthReportExpiredEvent, PartitionReconfiguredEvent,
    ChaosPartitionSecondaryMoveScheduledEvent,
    ChaosPartitionPrimaryMoveScheduledEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'PartitionAnalysisEvent': 'PartitionAnalysisEvent', 'PartitionNewHealthReport': 'PartitionNewHealthReportEvent', 'PartitionHealthReportExpired': 'PartitionHealthReportExpiredEvent', 'PartitionReconfigured': 'PartitionReconfiguredEvent', 'ChaosPartitionSecondaryMoveScheduled': 'ChaosPartitionSecondaryMoveScheduledEvent', 'ChaosPartitionPrimaryMoveScheduled': 'ChaosPartitionPrimaryMoveScheduledEvent'}
    }

    def __init__(self, **kwargs):
        super(PartitionEvent, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.kind = 'PartitionEvent'


class ChaosPartitionPrimaryMoveScheduledEvent(PartitionEvent):
    """Chaos Move Primary Fault Scheduled event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param fault_group_id: Required. Id of fault group.
    :type fault_group_id: str
    :param fault_id: Required. Id of fault.
    :type fault_id: str
    :param service_name: Required. Service name.
    :type service_name: str
    :param node_to: Required. The name of a Service Fabric node.
    :type node_to: str
    :param forced_move: Required. Indicates a forced move.
    :type forced_move: bool
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'fault_group_id': {'required': True},
        'fault_id': {'required': True},
        'service_name': {'required': True},
        'node_to': {'required': True},
        'forced_move': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'fault_group_id': {'key': 'FaultGroupId', 'type': 'str'},
        'fault_id': {'key': 'FaultId', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'node_to': {'key': 'NodeTo', 'type': 'str'},
        'forced_move': {'key': 'ForcedMove', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ChaosPartitionPrimaryMoveScheduledEvent, self).__init__(**kwargs)
        self.fault_group_id = kwargs.get('fault_group_id', None)
        self.fault_id = kwargs.get('fault_id', None)
        self.service_name = kwargs.get('service_name', None)
        self.node_to = kwargs.get('node_to', None)
        self.forced_move = kwargs.get('forced_move', None)
        self.kind = 'ChaosPartitionPrimaryMoveScheduled'


class ChaosPartitionSecondaryMoveScheduledEvent(PartitionEvent):
    """Chaos Move Secondary Fault Scheduled event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param fault_group_id: Required. Id of fault group.
    :type fault_group_id: str
    :param fault_id: Required. Id of fault.
    :type fault_id: str
    :param service_name: Required. Service name.
    :type service_name: str
    :param source_node: Required. The name of a Service Fabric node.
    :type source_node: str
    :param destination_node: Required. The name of a Service Fabric node.
    :type destination_node: str
    :param forced_move: Required. Indicates a forced move.
    :type forced_move: bool
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'fault_group_id': {'required': True},
        'fault_id': {'required': True},
        'service_name': {'required': True},
        'source_node': {'required': True},
        'destination_node': {'required': True},
        'forced_move': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'fault_group_id': {'key': 'FaultGroupId', 'type': 'str'},
        'fault_id': {'key': 'FaultId', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'source_node': {'key': 'SourceNode', 'type': 'str'},
        'destination_node': {'key': 'DestinationNode', 'type': 'str'},
        'forced_move': {'key': 'ForcedMove', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ChaosPartitionSecondaryMoveScheduledEvent, self).__init__(**kwargs)
        self.fault_group_id = kwargs.get('fault_group_id', None)
        self.fault_id = kwargs.get('fault_id', None)
        self.service_name = kwargs.get('service_name', None)
        self.source_node = kwargs.get('source_node', None)
        self.destination_node = kwargs.get('destination_node', None)
        self.forced_move = kwargs.get('forced_move', None)
        self.kind = 'ChaosPartitionSecondaryMoveScheduled'


class ReplicaEvent(FabricEvent):
    """Represents the base for all Replica Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulReplicaNewHealthReportEvent,
    StatefulReplicaHealthReportExpiredEvent,
    StatelessReplicaNewHealthReportEvent,
    StatelessReplicaHealthReportExpiredEvent,
    ChaosReplicaRemovalScheduledEvent, ChaosReplicaRestartScheduledEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param replica_id: Required. Id of a stateful service replica. ReplicaId
     is used by Service Fabric to uniquely identify a replica of a partition.
     It is unique within a partition and does not change for the lifetime of
     the replica. If a replica gets dropped and another replica gets created on
     the same node for the same partition, it will get a different value for
     the id. Sometimes the id of a stateless service instance is also referred
     as a replica id.
    :type replica_id: long
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'replica_id': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'long'},
    }

    _subtype_map = {
        'kind': {'StatefulReplicaNewHealthReport': 'StatefulReplicaNewHealthReportEvent', 'StatefulReplicaHealthReportExpired': 'StatefulReplicaHealthReportExpiredEvent', 'StatelessReplicaNewHealthReport': 'StatelessReplicaNewHealthReportEvent', 'StatelessReplicaHealthReportExpired': 'StatelessReplicaHealthReportExpiredEvent', 'ChaosReplicaRemovalScheduled': 'ChaosReplicaRemovalScheduledEvent', 'ChaosReplicaRestartScheduled': 'ChaosReplicaRestartScheduledEvent'}
    }

    def __init__(self, **kwargs):
        super(ReplicaEvent, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.replica_id = kwargs.get('replica_id', None)
        self.kind = 'ReplicaEvent'


class ChaosReplicaRemovalScheduledEvent(ReplicaEvent):
    """Chaos Remove Replica Fault Scheduled event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param replica_id: Required. Id of a stateful service replica. ReplicaId
     is used by Service Fabric to uniquely identify a replica of a partition.
     It is unique within a partition and does not change for the lifetime of
     the replica. If a replica gets dropped and another replica gets created on
     the same node for the same partition, it will get a different value for
     the id. Sometimes the id of a stateless service instance is also referred
     as a replica id.
    :type replica_id: long
    :param fault_group_id: Required. Id of fault group.
    :type fault_group_id: str
    :param fault_id: Required. Id of fault.
    :type fault_id: str
    :param service_uri: Required. Service name.
    :type service_uri: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'replica_id': {'required': True},
        'fault_group_id': {'required': True},
        'fault_id': {'required': True},
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'long'},
        'fault_group_id': {'key': 'FaultGroupId', 'type': 'str'},
        'fault_id': {'key': 'FaultId', 'type': 'str'},
        'service_uri': {'key': 'ServiceUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ChaosReplicaRemovalScheduledEvent, self).__init__(**kwargs)
        self.fault_group_id = kwargs.get('fault_group_id', None)
        self.fault_id = kwargs.get('fault_id', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.kind = 'ChaosReplicaRemovalScheduled'


class ChaosReplicaRestartScheduledEvent(ReplicaEvent):
    """Chaos Restart Replica Fault Scheduled event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param replica_id: Required. Id of a stateful service replica. ReplicaId
     is used by Service Fabric to uniquely identify a replica of a partition.
     It is unique within a partition and does not change for the lifetime of
     the replica. If a replica gets dropped and another replica gets created on
     the same node for the same partition, it will get a different value for
     the id. Sometimes the id of a stateless service instance is also referred
     as a replica id.
    :type replica_id: long
    :param fault_group_id: Required. Id of fault group.
    :type fault_group_id: str
    :param fault_id: Required. Id of fault.
    :type fault_id: str
    :param service_uri: Required. Service name.
    :type service_uri: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'replica_id': {'required': True},
        'fault_group_id': {'required': True},
        'fault_id': {'required': True},
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'long'},
        'fault_group_id': {'key': 'FaultGroupId', 'type': 'str'},
        'fault_id': {'key': 'FaultId', 'type': 'str'},
        'service_uri': {'key': 'ServiceUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ChaosReplicaRestartScheduledEvent, self).__init__(**kwargs)
        self.fault_group_id = kwargs.get('fault_group_id', None)
        self.fault_id = kwargs.get('fault_id', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.kind = 'ChaosReplicaRestartScheduled'


class ChaosSchedule(Model):
    """Defines the schedule used by Chaos.

    :param start_date: The date and time Chaos will start using this schedule.
     Default value: "1601-01-01T00:00:00Z" .
    :type start_date: datetime
    :param expiry_date: The date and time Chaos will continue to use this
     schedule until. Default value: "9999-12-31T23:59:59.999Z" .
    :type expiry_date: datetime
    :param chaos_parameters_dictionary: A mapping of string names to Chaos
     Parameters to be referenced by Chaos Schedule Jobs.
    :type chaos_parameters_dictionary:
     list[~azure.servicefabric.models.ChaosParametersDictionaryItem]
    :param jobs: A list of all Chaos Schedule Jobs that will be automated by
     the schedule.
    :type jobs: list[~azure.servicefabric.models.ChaosScheduleJob]
    """

    _attribute_map = {
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'expiry_date': {'key': 'ExpiryDate', 'type': 'iso-8601'},
        'chaos_parameters_dictionary': {'key': 'ChaosParametersDictionary', 'type': '[ChaosParametersDictionaryItem]'},
        'jobs': {'key': 'Jobs', 'type': '[ChaosScheduleJob]'},
    }

    def __init__(self, **kwargs):
        super(ChaosSchedule, self).__init__(**kwargs)
        self.start_date = kwargs.get('start_date', "1601-01-01T00:00:00Z")
        self.expiry_date = kwargs.get('expiry_date', "9999-12-31T23:59:59.999Z")
        self.chaos_parameters_dictionary = kwargs.get('chaos_parameters_dictionary', None)
        self.jobs = kwargs.get('jobs', None)


class ChaosScheduleDescription(Model):
    """Defines the Chaos Schedule used by Chaos and the version of the Chaos
    Schedule. The version value wraps back to 0 after surpassing 2,147,483,647.

    :param version: The version number of the Schedule.
    :type version: int
    :param schedule: Defines the schedule used by Chaos.
    :type schedule: ~azure.servicefabric.models.ChaosSchedule
    """

    _validation = {
        'version': {'minimum': 0},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'int'},
        'schedule': {'key': 'Schedule', 'type': 'ChaosSchedule'},
    }

    def __init__(self, **kwargs):
        super(ChaosScheduleDescription, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.schedule = kwargs.get('schedule', None)


class ChaosScheduleJob(Model):
    """Defines a repetition rule and parameters of Chaos to be used with the Chaos
    Schedule.

    :param chaos_parameters: A reference to which Chaos Parameters of the
     Chaos Schedule to use.
    :type chaos_parameters: str
    :param days: Defines the days of the week that a Chaos Schedule Job will
     run for.
    :type days: ~azure.servicefabric.models.ChaosScheduleJobActiveDaysOfWeek
    :param times: A list of Time Ranges that specify when during active days
     that this job will run. The times are interpreted as UTC.
    :type times: list[~azure.servicefabric.models.TimeRange]
    """

    _attribute_map = {
        'chaos_parameters': {'key': 'ChaosParameters', 'type': 'str'},
        'days': {'key': 'Days', 'type': 'ChaosScheduleJobActiveDaysOfWeek'},
        'times': {'key': 'Times', 'type': '[TimeRange]'},
    }

    def __init__(self, **kwargs):
        super(ChaosScheduleJob, self).__init__(**kwargs)
        self.chaos_parameters = kwargs.get('chaos_parameters', None)
        self.days = kwargs.get('days', None)
        self.times = kwargs.get('times', None)


class ChaosScheduleJobActiveDaysOfWeek(Model):
    """Defines the days of the week that a Chaos Schedule Job will run for.

    :param sunday: Indicates if the Chaos Schedule Job will run on Sunday.
     Default value: False .
    :type sunday: bool
    :param monday: Indicates if the Chaos Schedule Job will run on Monday.
     Default value: False .
    :type monday: bool
    :param tuesday: Indicates if the Chaos Schedule Job will run on Tuesday.
     Default value: False .
    :type tuesday: bool
    :param wednesday: Indicates if the Chaos Schedule Job will run on
     Wednesday. Default value: False .
    :type wednesday: bool
    :param thursday: Indicates if the Chaos Schedule Job will run on Thursday.
     Default value: False .
    :type thursday: bool
    :param friday: Indicates if the Chaos Schedule Job will run on Friday.
     Default value: False .
    :type friday: bool
    :param saturday: Indicates if the Chaos Schedule Job will run on Saturday.
     Default value: False .
    :type saturday: bool
    """

    _attribute_map = {
        'sunday': {'key': 'Sunday', 'type': 'bool'},
        'monday': {'key': 'Monday', 'type': 'bool'},
        'tuesday': {'key': 'Tuesday', 'type': 'bool'},
        'wednesday': {'key': 'Wednesday', 'type': 'bool'},
        'thursday': {'key': 'Thursday', 'type': 'bool'},
        'friday': {'key': 'Friday', 'type': 'bool'},
        'saturday': {'key': 'Saturday', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ChaosScheduleJobActiveDaysOfWeek, self).__init__(**kwargs)
        self.sunday = kwargs.get('sunday', False)
        self.monday = kwargs.get('monday', False)
        self.tuesday = kwargs.get('tuesday', False)
        self.wednesday = kwargs.get('wednesday', False)
        self.thursday = kwargs.get('thursday', False)
        self.friday = kwargs.get('friday', False)
        self.saturday = kwargs.get('saturday', False)


class ClusterEvent(FabricEvent):
    """Represents the base for all Cluster Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ClusterNewHealthReportEvent,
    ClusterHealthReportExpiredEvent, ClusterUpgradeCompletedEvent,
    ClusterUpgradeDomainCompletedEvent, ClusterUpgradeRollbackCompletedEvent,
    ClusterUpgradeRollbackStartedEvent, ClusterUpgradeStartedEvent,
    ChaosStoppedEvent, ChaosStartedEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ClusterNewHealthReport': 'ClusterNewHealthReportEvent', 'ClusterHealthReportExpired': 'ClusterHealthReportExpiredEvent', 'ClusterUpgradeCompleted': 'ClusterUpgradeCompletedEvent', 'ClusterUpgradeDomainCompleted': 'ClusterUpgradeDomainCompletedEvent', 'ClusterUpgradeRollbackCompleted': 'ClusterUpgradeRollbackCompletedEvent', 'ClusterUpgradeRollbackStarted': 'ClusterUpgradeRollbackStartedEvent', 'ClusterUpgradeStarted': 'ClusterUpgradeStartedEvent', 'ChaosStopped': 'ChaosStoppedEvent', 'ChaosStarted': 'ChaosStartedEvent'}
    }

    def __init__(self, **kwargs):
        super(ClusterEvent, self).__init__(**kwargs)
        self.kind = 'ClusterEvent'


class ChaosStartedEvent(ClusterEvent):
    """Chaos Started event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param max_concurrent_faults: Required. Maximum number of concurrent
     faults.
    :type max_concurrent_faults: long
    :param time_to_run_in_seconds: Required. Time to run in seconds.
    :type time_to_run_in_seconds: float
    :param max_cluster_stabilization_timeout_in_seconds: Required. Maximum
     timeout for cluster stabilization in seconds.
    :type max_cluster_stabilization_timeout_in_seconds: float
    :param wait_time_between_iterations_in_seconds: Required. Wait time
     between iterations in seconds.
    :type wait_time_between_iterations_in_seconds: float
    :param wait_time_between_faults_in_seconds: Required. Wait time between
     faults in seconds.
    :type wait_time_between_faults_in_seconds: float
    :param move_replica_fault_enabled: Required. Indicates MoveReplica fault
     is enabled.
    :type move_replica_fault_enabled: bool
    :param included_node_type_list: Required. List of included Node types.
    :type included_node_type_list: str
    :param included_application_list: Required. List of included Applications.
    :type included_application_list: str
    :param cluster_health_policy: Required. Health policy.
    :type cluster_health_policy: str
    :param chaos_context: Required. Chaos Context.
    :type chaos_context: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'max_concurrent_faults': {'required': True},
        'time_to_run_in_seconds': {'required': True},
        'max_cluster_stabilization_timeout_in_seconds': {'required': True},
        'wait_time_between_iterations_in_seconds': {'required': True},
        'wait_time_between_faults_in_seconds': {'required': True},
        'move_replica_fault_enabled': {'required': True},
        'included_node_type_list': {'required': True},
        'included_application_list': {'required': True},
        'cluster_health_policy': {'required': True},
        'chaos_context': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'max_concurrent_faults': {'key': 'MaxConcurrentFaults', 'type': 'long'},
        'time_to_run_in_seconds': {'key': 'TimeToRunInSeconds', 'type': 'float'},
        'max_cluster_stabilization_timeout_in_seconds': {'key': 'MaxClusterStabilizationTimeoutInSeconds', 'type': 'float'},
        'wait_time_between_iterations_in_seconds': {'key': 'WaitTimeBetweenIterationsInSeconds', 'type': 'float'},
        'wait_time_between_faults_in_seconds': {'key': 'WaitTimeBetweenFaultsInSeconds', 'type': 'float'},
        'move_replica_fault_enabled': {'key': 'MoveReplicaFaultEnabled', 'type': 'bool'},
        'included_node_type_list': {'key': 'IncludedNodeTypeList', 'type': 'str'},
        'included_application_list': {'key': 'IncludedApplicationList', 'type': 'str'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'str'},
        'chaos_context': {'key': 'ChaosContext', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ChaosStartedEvent, self).__init__(**kwargs)
        self.max_concurrent_faults = kwargs.get('max_concurrent_faults', None)
        self.time_to_run_in_seconds = kwargs.get('time_to_run_in_seconds', None)
        self.max_cluster_stabilization_timeout_in_seconds = kwargs.get('max_cluster_stabilization_timeout_in_seconds', None)
        self.wait_time_between_iterations_in_seconds = kwargs.get('wait_time_between_iterations_in_seconds', None)
        self.wait_time_between_faults_in_seconds = kwargs.get('wait_time_between_faults_in_seconds', None)
        self.move_replica_fault_enabled = kwargs.get('move_replica_fault_enabled', None)
        self.included_node_type_list = kwargs.get('included_node_type_list', None)
        self.included_application_list = kwargs.get('included_application_list', None)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)
        self.chaos_context = kwargs.get('chaos_context', None)
        self.kind = 'ChaosStarted'


class ChaosStoppedEvent(ClusterEvent):
    """Chaos Stopped event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param reason: Required. Describes reason.
    :type reason: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'reason': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ChaosStoppedEvent, self).__init__(**kwargs)
        self.reason = kwargs.get('reason', None)
        self.kind = 'ChaosStopped'


class ChaosTargetFilter(Model):
    """Defines all filters for targeted Chaos faults, for example, faulting only
    certain node types or faulting only certain applications.
    If ChaosTargetFilter is not used, Chaos faults all cluster entities. If
    ChaosTargetFilter is used, Chaos faults only the entities that meet the
    ChaosTargetFilter
    specification. NodeTypeInclusionList and ApplicationInclusionList allow a
    union semantics only. It is not possible to specify an intersection
    of NodeTypeInclusionList and ApplicationInclusionList. For example, it is
    not possible to specify "fault this application only when it is on that
    node type."
    Once an entity is included in either NodeTypeInclusionList or
    ApplicationInclusionList, that entity cannot be excluded using
    ChaosTargetFilter. Even if
    applicationX does not appear in ApplicationInclusionList, in some Chaos
    iteration applicationX can be faulted because it happens to be on a node of
    nodeTypeY that is included
    in NodeTypeInclusionList. If both NodeTypeInclusionList and
    ApplicationInclusionList are null or empty, an ArgumentException is thrown.

    :param node_type_inclusion_list: A list of node types to include in Chaos
     faults.
     All types of faults (restart node, restart code package, remove replica,
     restart replica, move primary, and move secondary) are enabled for the
     nodes of these node types.
     If a node type (say NodeTypeX) does not appear in the
     NodeTypeInclusionList, then node level faults (like NodeRestart) will
     never be enabled for the nodes of
     NodeTypeX, but code package and replica faults can still be enabled for
     NodeTypeX if an application in the ApplicationInclusionList.
     happens to reside on a node of NodeTypeX.
     At most 100 node type names can be included in this list, to increase this
     number, a config upgrade is required for
     MaxNumberOfNodeTypesInChaosEntityFilter configuration.
    :type node_type_inclusion_list: list[str]
    :param application_inclusion_list: A list of application URIs to include
     in Chaos faults.
     All replicas belonging to services of these applications are amenable to
     replica faults (restart replica, remove replica, move primary, and move
     secondary) by Chaos.
     Chaos may restart a code package only if the code package hosts replicas
     of these applications only.
     If an application does not appear in this list, it can still be faulted in
     some Chaos iteration if the application ends up on a node of a node type
     that is included in NodeTypeInclusionList.
     However, if applicationX is tied to nodeTypeY through placement
     constraints and applicationX is absent from ApplicationInclusionList and
     nodeTypeY is absent from NodeTypeInclusionList, then applicationX will
     never be faulted.
     At most 1000 application names can be included in this list, to increase
     this number, a config upgrade is required for
     MaxNumberOfApplicationsInChaosEntityFilter configuration.
    :type application_inclusion_list: list[str]
    """

    _attribute_map = {
        'node_type_inclusion_list': {'key': 'NodeTypeInclusionList', 'type': '[str]'},
        'application_inclusion_list': {'key': 'ApplicationInclusionList', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ChaosTargetFilter, self).__init__(**kwargs)
        self.node_type_inclusion_list = kwargs.get('node_type_inclusion_list', None)
        self.application_inclusion_list = kwargs.get('application_inclusion_list', None)


class PropertyBatchOperation(Model):
    """Represents the base type for property operations that can be put into a
    batch and submitted.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CheckExistsPropertyBatchOperation,
    CheckSequencePropertyBatchOperation, CheckValuePropertyBatchOperation,
    DeletePropertyBatchOperation, GetPropertyBatchOperation,
    PutPropertyBatchOperation

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'CheckExists': 'CheckExistsPropertyBatchOperation', 'CheckSequence': 'CheckSequencePropertyBatchOperation', 'CheckValue': 'CheckValuePropertyBatchOperation', 'Delete': 'DeletePropertyBatchOperation', 'Get': 'GetPropertyBatchOperation', 'Put': 'PutPropertyBatchOperation'}
    }

    def __init__(self, **kwargs):
        super(PropertyBatchOperation, self).__init__(**kwargs)
        self.property_name = kwargs.get('property_name', None)
        self.kind = None


class CheckExistsPropertyBatchOperation(PropertyBatchOperation):
    """Represents a PropertyBatchOperation that compares the Boolean existence of
    a property with the Exists argument.
    The PropertyBatchOperation operation fails if the property's existence is
    not equal to the Exists argument.
    The CheckExistsPropertyBatchOperation is generally used as a precondition
    for the write operations in the batch.
    Note that if one PropertyBatchOperation in a PropertyBatch fails,
    the entire batch fails and cannot be committed in a transactional manner.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param exists: Required. Whether or not the property should exist for the
     operation to pass.
    :type exists: bool
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
        'exists': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'exists': {'key': 'Exists', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CheckExistsPropertyBatchOperation, self).__init__(**kwargs)
        self.exists = kwargs.get('exists', None)
        self.kind = 'CheckExists'


class CheckSequencePropertyBatchOperation(PropertyBatchOperation):
    """Compares the Sequence Number of a property with the SequenceNumber
    argument.
    A property's sequence number can be thought of as that property's version.
    Every time the property is modified, its sequence number is increased.
    The sequence number can be found in a property's metadata.
    The comparison fails if the sequence numbers are not equal.
    CheckSequencePropertyBatchOperation is generally used as a precondition for
    the write operations in the batch.
    Note that if one PropertyBatchOperation in a PropertyBatch fails,
    the entire batch fails and cannot be committed in a transactional manner.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param sequence_number: Required. The expected sequence number.
    :type sequence_number: str
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
        'sequence_number': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckSequencePropertyBatchOperation, self).__init__(**kwargs)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.kind = 'CheckSequence'


class CheckValuePropertyBatchOperation(PropertyBatchOperation):
    """Represents a PropertyBatchOperation that compares the value of the property
    with the expected value.
    The CheckValuePropertyBatchOperation is generally used as a precondition
    for the write operations in the batch.
    Note that if one PropertyBatchOperation in a PropertyBatch fails,
    the entire batch fails and cannot be committed in a transactional manner.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param value: Required. The expected property value.
    :type value: ~azure.servicefabric.models.PropertyValue
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
    }

    def __init__(self, **kwargs):
        super(CheckValuePropertyBatchOperation, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.kind = 'CheckValue'


class ClusterConfiguration(Model):
    """Information about the standalone cluster configuration.

    :param cluster_configuration: The contents of the cluster configuration
     file.
    :type cluster_configuration: str
    """

    _attribute_map = {
        'cluster_configuration': {'key': 'ClusterConfiguration', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterConfiguration, self).__init__(**kwargs)
        self.cluster_configuration = kwargs.get('cluster_configuration', None)


class ClusterConfigurationUpgradeDescription(Model):
    """Describes the parameters for a standalone cluster configuration upgrade.

    All required parameters must be populated in order to send to Azure.

    :param cluster_config: Required. The cluster configuration as a JSON
     string. For example, [this
     file](https://github.com/Azure-Samples/service-fabric-dotnet-standalone-cluster-configuration/blob/master/Samples/ClusterConfig.Unsecure.DevCluster.json)
     contains JSON describing the [nodes and other properties of the
     cluster](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-manifest).
    :type cluster_config: str
    :param health_check_retry_timeout: The length of time between attempts to
     perform health checks if the application or cluster is not healthy.
     Default value: "PT0H0M0S" .
    :type health_check_retry_timeout: timedelta
    :param health_check_wait_duration_in_seconds: The length of time to wait
     after completing an upgrade domain before starting the health checks
     process. Default value: "PT0H0M0S" .
    :type health_check_wait_duration_in_seconds: timedelta
    :param health_check_stable_duration_in_seconds: The length of time that
     the application or cluster must remain healthy before the upgrade proceeds
     to the next upgrade domain. Default value: "PT0H0M0S" .
    :type health_check_stable_duration_in_seconds: timedelta
    :param upgrade_domain_timeout_in_seconds: The timeout for the upgrade
     domain. Default value: "PT0H0M0S" .
    :type upgrade_domain_timeout_in_seconds: timedelta
    :param upgrade_timeout_in_seconds: The upgrade timeout. Default value:
     "PT0H0M0S" .
    :type upgrade_timeout_in_seconds: timedelta
    :param max_percent_unhealthy_applications: The maximum allowed percentage
     of unhealthy applications during the upgrade. Allowed values are integer
     values from zero to 100. Default value: 0 .
    :type max_percent_unhealthy_applications: int
    :param max_percent_unhealthy_nodes: The maximum allowed percentage of
     unhealthy nodes during the upgrade. Allowed values are integer values from
     zero to 100. Default value: 0 .
    :type max_percent_unhealthy_nodes: int
    :param max_percent_delta_unhealthy_nodes: The maximum allowed percentage
     of delta health degradation during the upgrade. Allowed values are integer
     values from zero to 100. Default value: 0 .
    :type max_percent_delta_unhealthy_nodes: int
    :param max_percent_upgrade_domain_delta_unhealthy_nodes: The maximum
     allowed percentage of upgrade domain delta health degradation during the
     upgrade. Allowed values are integer values from zero to 100. Default
     value: 0 .
    :type max_percent_upgrade_domain_delta_unhealthy_nodes: int
    :param application_health_policies: Defines the application health policy
     map used to evaluate the health of an application or one of its children
     entities.
    :type application_health_policies:
     ~azure.servicefabric.models.ApplicationHealthPolicies
    """

    _validation = {
        'cluster_config': {'required': True},
    }

    _attribute_map = {
        'cluster_config': {'key': 'ClusterConfig', 'type': 'str'},
        'health_check_retry_timeout': {'key': 'HealthCheckRetryTimeout', 'type': 'duration'},
        'health_check_wait_duration_in_seconds': {'key': 'HealthCheckWaitDurationInSeconds', 'type': 'duration'},
        'health_check_stable_duration_in_seconds': {'key': 'HealthCheckStableDurationInSeconds', 'type': 'duration'},
        'upgrade_domain_timeout_in_seconds': {'key': 'UpgradeDomainTimeoutInSeconds', 'type': 'duration'},
        'upgrade_timeout_in_seconds': {'key': 'UpgradeTimeoutInSeconds', 'type': 'duration'},
        'max_percent_unhealthy_applications': {'key': 'MaxPercentUnhealthyApplications', 'type': 'int'},
        'max_percent_unhealthy_nodes': {'key': 'MaxPercentUnhealthyNodes', 'type': 'int'},
        'max_percent_delta_unhealthy_nodes': {'key': 'MaxPercentDeltaUnhealthyNodes', 'type': 'int'},
        'max_percent_upgrade_domain_delta_unhealthy_nodes': {'key': 'MaxPercentUpgradeDomainDeltaUnhealthyNodes', 'type': 'int'},
        'application_health_policies': {'key': 'ApplicationHealthPolicies', 'type': 'ApplicationHealthPolicies'},
    }

    def __init__(self, **kwargs):
        super(ClusterConfigurationUpgradeDescription, self).__init__(**kwargs)
        self.cluster_config = kwargs.get('cluster_config', None)
        self.health_check_retry_timeout = kwargs.get('health_check_retry_timeout', "PT0H0M0S")
        self.health_check_wait_duration_in_seconds = kwargs.get('health_check_wait_duration_in_seconds', "PT0H0M0S")
        self.health_check_stable_duration_in_seconds = kwargs.get('health_check_stable_duration_in_seconds', "PT0H0M0S")
        self.upgrade_domain_timeout_in_seconds = kwargs.get('upgrade_domain_timeout_in_seconds', "PT0H0M0S")
        self.upgrade_timeout_in_seconds = kwargs.get('upgrade_timeout_in_seconds', "PT0H0M0S")
        self.max_percent_unhealthy_applications = kwargs.get('max_percent_unhealthy_applications', 0)
        self.max_percent_unhealthy_nodes = kwargs.get('max_percent_unhealthy_nodes', 0)
        self.max_percent_delta_unhealthy_nodes = kwargs.get('max_percent_delta_unhealthy_nodes', 0)
        self.max_percent_upgrade_domain_delta_unhealthy_nodes = kwargs.get('max_percent_upgrade_domain_delta_unhealthy_nodes', 0)
        self.application_health_policies = kwargs.get('application_health_policies', None)


class ClusterConfigurationUpgradeStatusInfo(Model):
    """Information about a standalone cluster configuration upgrade status.

    :param upgrade_state: The state of the upgrade domain. Possible values
     include: 'Invalid', 'RollingBackInProgress', 'RollingBackCompleted',
     'RollingForwardPending', 'RollingForwardInProgress',
     'RollingForwardCompleted', 'Failed'
    :type upgrade_state: str or ~azure.servicefabric.models.UpgradeState
    :param progress_status: The cluster manifest version.
    :type progress_status: int
    :param config_version: The cluster configuration version.
    :type config_version: str
    :param details: The cluster upgrade status details.
    :type details: str
    """

    _attribute_map = {
        'upgrade_state': {'key': 'UpgradeState', 'type': 'str'},
        'progress_status': {'key': 'ProgressStatus', 'type': 'int'},
        'config_version': {'key': 'ConfigVersion', 'type': 'str'},
        'details': {'key': 'Details', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterConfigurationUpgradeStatusInfo, self).__init__(**kwargs)
        self.upgrade_state = kwargs.get('upgrade_state', None)
        self.progress_status = kwargs.get('progress_status', None)
        self.config_version = kwargs.get('config_version', None)
        self.details = kwargs.get('details', None)


class ClusterHealth(EntityHealth):
    """Represents the health of the cluster.
    Contains the cluster aggregated health state, the cluster application and
    node health states as well as the health events and the unhealthy
    evaluations.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param node_health_states: Cluster node health states as found in the
     health store.
    :type node_health_states:
     list[~azure.servicefabric.models.NodeHealthState]
    :param application_health_states: Cluster application health states as
     found in the health store.
    :type application_health_states:
     list[~azure.servicefabric.models.ApplicationHealthState]
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'node_health_states': {'key': 'NodeHealthStates', 'type': '[NodeHealthState]'},
        'application_health_states': {'key': 'ApplicationHealthStates', 'type': '[ApplicationHealthState]'},
    }

    def __init__(self, **kwargs):
        super(ClusterHealth, self).__init__(**kwargs)
        self.node_health_states = kwargs.get('node_health_states', None)
        self.application_health_states = kwargs.get('application_health_states', None)


class ClusterHealthChunk(Model):
    """Represents the health chunk of the cluster.
    Contains the cluster aggregated health state, and the cluster entities that
    respect the input filter.

    :param health_state: The HealthState representing the aggregated health
     state of the cluster computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired cluster health policy and
     the application health policies. Possible values include: 'Invalid', 'Ok',
     'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param node_health_state_chunks: The list of node health state chunks in
     the cluster that respect the filters in the cluster health chunk query
     description.
    :type node_health_state_chunks:
     ~azure.servicefabric.models.NodeHealthStateChunkList
    :param application_health_state_chunks: The list of application health
     state chunks in the cluster that respect the filters in the cluster health
     chunk query description.
    :type application_health_state_chunks:
     ~azure.servicefabric.models.ApplicationHealthStateChunkList
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_health_state_chunks': {'key': 'NodeHealthStateChunks', 'type': 'NodeHealthStateChunkList'},
        'application_health_state_chunks': {'key': 'ApplicationHealthStateChunks', 'type': 'ApplicationHealthStateChunkList'},
    }

    def __init__(self, **kwargs):
        super(ClusterHealthChunk, self).__init__(**kwargs)
        self.health_state = kwargs.get('health_state', None)
        self.node_health_state_chunks = kwargs.get('node_health_state_chunks', None)
        self.application_health_state_chunks = kwargs.get('application_health_state_chunks', None)


class ClusterHealthChunkQueryDescription(Model):
    """The cluster health chunk query description, which can specify the health
    policies to evaluate cluster health and very expressive filters to select
    which cluster entities to include in response.

    :param node_filters: Defines a list of filters that specify which nodes to
     be included in the returned cluster health chunk.
     If no filters are specified, no nodes are returned. All the nodes are used
     to evaluate the cluster's aggregated health state, regardless of the input
     filters.
     The cluster health chunk query may specify multiple node filters.
     For example, it can specify a filter to return all nodes with health state
     Error and another filter to always include a node identified by its
     NodeName.
    :type node_filters:
     list[~azure.servicefabric.models.NodeHealthStateFilter]
    :param application_filters: Defines a list of filters that specify which
     applications to be included in the returned cluster health chunk.
     If no filters are specified, no applications are returned. All the
     applications are used to evaluate the cluster's aggregated health state,
     regardless of the input filters.
     The cluster health chunk query may specify multiple application filters.
     For example, it can specify a filter to return all applications with
     health state Error and another filter to always include applications of a
     specified application type.
    :type application_filters:
     list[~azure.servicefabric.models.ApplicationHealthStateFilter]
    :param cluster_health_policy: Defines a health policy used to evaluate the
     health of the cluster or of a cluster node.
    :type cluster_health_policy:
     ~azure.servicefabric.models.ClusterHealthPolicy
    :param application_health_policies: Defines the application health policy
     map used to evaluate the health of an application or one of its children
     entities.
    :type application_health_policies:
     ~azure.servicefabric.models.ApplicationHealthPolicies
    """

    _attribute_map = {
        'node_filters': {'key': 'NodeFilters', 'type': '[NodeHealthStateFilter]'},
        'application_filters': {'key': 'ApplicationFilters', 'type': '[ApplicationHealthStateFilter]'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'ClusterHealthPolicy'},
        'application_health_policies': {'key': 'ApplicationHealthPolicies', 'type': 'ApplicationHealthPolicies'},
    }

    def __init__(self, **kwargs):
        super(ClusterHealthChunkQueryDescription, self).__init__(**kwargs)
        self.node_filters = kwargs.get('node_filters', None)
        self.application_filters = kwargs.get('application_filters', None)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)
        self.application_health_policies = kwargs.get('application_health_policies', None)


class ClusterHealthPolicies(Model):
    """Health policies to evaluate cluster health.

    :param application_health_policy_map: Defines a map that contains specific
     application health policies for different applications.
     Each entry specifies as key the application name and as value an
     ApplicationHealthPolicy used to evaluate the application health.
     If an application is not specified in the map, the application health
     evaluation uses the ApplicationHealthPolicy found in its application
     manifest or the default application health policy (if no health policy is
     defined in the manifest).
     The map is empty by default.
    :type application_health_policy_map:
     list[~azure.servicefabric.models.ApplicationHealthPolicyMapItem]
    :param cluster_health_policy: Defines a health policy used to evaluate the
     health of the cluster or of a cluster node.
    :type cluster_health_policy:
     ~azure.servicefabric.models.ClusterHealthPolicy
    """

    _attribute_map = {
        'application_health_policy_map': {'key': 'ApplicationHealthPolicyMap', 'type': '[ApplicationHealthPolicyMapItem]'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'ClusterHealthPolicy'},
    }

    def __init__(self, **kwargs):
        super(ClusterHealthPolicies, self).__init__(**kwargs)
        self.application_health_policy_map = kwargs.get('application_health_policy_map', None)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)


class ClusterHealthPolicy(Model):
    """Defines a health policy used to evaluate the health of the cluster or of a
    cluster node.

    :param consider_warning_as_error: Indicates whether warnings are treated
     with the same severity as errors. Default value: False .
    :type consider_warning_as_error: bool
    :param max_percent_unhealthy_nodes: The maximum allowed percentage of
     unhealthy nodes before reporting an error. For example, to allow 10% of
     nodes to be unhealthy, this value would be 10.
     The percentage represents the maximum tolerated percentage of nodes that
     can be unhealthy before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy node,
     the health is evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy nodes
     over the total number of nodes in the cluster.
     The computation rounds up to tolerate one failure on small numbers of
     nodes. Default percentage is zero.
     In large clusters, some nodes will always be down or out for repairs, so
     this percentage should be configured to tolerate that. Default value: 0 .
    :type max_percent_unhealthy_nodes: int
    :param max_percent_unhealthy_applications: The maximum allowed percentage
     of unhealthy applications before reporting an error. For example, to allow
     10% of applications to be unhealthy, this value would be 10.
     The percentage represents the maximum tolerated percentage of applications
     that can be unhealthy before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy
     application, the health is evaluated as Warning.
     This is calculated by dividing the number of unhealthy applications over
     the total number of application instances in the cluster, excluding
     applications of application types that are included in the
     ApplicationTypeHealthPolicyMap.
     The computation rounds up to tolerate one failure on small numbers of
     applications. Default percentage is zero. Default value: 0 .
    :type max_percent_unhealthy_applications: int
    :param application_type_health_policy_map: Defines a map with max
     percentage unhealthy applications for specific application types.
     Each entry specifies as key the application type name and as value an
     integer that represents the MaxPercentUnhealthyApplications percentage
     used to evaluate the applications of the specified application type.
     The application type health policy map can be used during cluster health
     evaluation to describe special application types.
     The application types included in the map are evaluated against the
     percentage specified in the map, and not with the global
     MaxPercentUnhealthyApplications defined in the cluster health policy.
     The applications of application types specified in the map are not counted
     against the global pool of applications.
     For example, if some applications of a type are critical, the cluster
     administrator can add an entry to the map for that application type
     and assign it a value of 0% (that is, do not tolerate any failures).
     All other applications can be evaluated with
     MaxPercentUnhealthyApplications set to 20% to tolerate some failures out
     of the thousands of application instances.
     The application type health policy map is used only if the cluster
     manifest enables application type health evaluation using the
     configuration entry for
     HealthManager/EnableApplicationTypeHealthEvaluation.
    :type application_type_health_policy_map:
     list[~azure.servicefabric.models.ApplicationTypeHealthPolicyMapItem]
    """

    _attribute_map = {
        'consider_warning_as_error': {'key': 'ConsiderWarningAsError', 'type': 'bool'},
        'max_percent_unhealthy_nodes': {'key': 'MaxPercentUnhealthyNodes', 'type': 'int'},
        'max_percent_unhealthy_applications': {'key': 'MaxPercentUnhealthyApplications', 'type': 'int'},
        'application_type_health_policy_map': {'key': 'ApplicationTypeHealthPolicyMap', 'type': '[ApplicationTypeHealthPolicyMapItem]'},
    }

    def __init__(self, **kwargs):
        super(ClusterHealthPolicy, self).__init__(**kwargs)
        self.consider_warning_as_error = kwargs.get('consider_warning_as_error', False)
        self.max_percent_unhealthy_nodes = kwargs.get('max_percent_unhealthy_nodes', 0)
        self.max_percent_unhealthy_applications = kwargs.get('max_percent_unhealthy_applications', 0)
        self.application_type_health_policy_map = kwargs.get('application_type_health_policy_map', None)


class ClusterHealthReportExpiredEvent(ClusterEvent):
    """Cluster Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ClusterHealthReportExpiredEvent, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'ClusterHealthReportExpired'


class ClusterLoadInfo(Model):
    """Information about load in a Service Fabric cluster. It holds a summary of
    all metrics and their load in a cluster.

    :param last_balancing_start_time_utc: The starting time of last resource
     balancing run.
    :type last_balancing_start_time_utc: datetime
    :param last_balancing_end_time_utc: The end time of last resource
     balancing run.
    :type last_balancing_end_time_utc: datetime
    :param load_metric_information: List that contains metrics and their load
     information in this cluster.
    :type load_metric_information:
     list[~azure.servicefabric.models.LoadMetricInformation]
    """

    _attribute_map = {
        'last_balancing_start_time_utc': {'key': 'LastBalancingStartTimeUtc', 'type': 'iso-8601'},
        'last_balancing_end_time_utc': {'key': 'LastBalancingEndTimeUtc', 'type': 'iso-8601'},
        'load_metric_information': {'key': 'LoadMetricInformation', 'type': '[LoadMetricInformation]'},
    }

    def __init__(self, **kwargs):
        super(ClusterLoadInfo, self).__init__(**kwargs)
        self.last_balancing_start_time_utc = kwargs.get('last_balancing_start_time_utc', None)
        self.last_balancing_end_time_utc = kwargs.get('last_balancing_end_time_utc', None)
        self.load_metric_information = kwargs.get('load_metric_information', None)


class ClusterManifest(Model):
    """Information about the cluster manifest.

    :param manifest: The contents of the cluster manifest file.
    :type manifest: str
    """

    _attribute_map = {
        'manifest': {'key': 'Manifest', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterManifest, self).__init__(**kwargs)
        self.manifest = kwargs.get('manifest', None)


class ClusterNewHealthReportEvent(ClusterEvent):
    """Cluster Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ClusterNewHealthReportEvent, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'ClusterNewHealthReport'


class ClusterUpgradeCompletedEvent(ClusterEvent):
    """Cluster Upgrade Completed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param target_cluster_version: Required. Target Cluster version.
    :type target_cluster_version: str
    :param overall_upgrade_elapsed_time_in_ms: Required. Overall duration of
     upgrade in milli-seconds.
    :type overall_upgrade_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'target_cluster_version': {'required': True},
        'overall_upgrade_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'target_cluster_version': {'key': 'TargetClusterVersion', 'type': 'str'},
        'overall_upgrade_elapsed_time_in_ms': {'key': 'OverallUpgradeElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeCompletedEvent, self).__init__(**kwargs)
        self.target_cluster_version = kwargs.get('target_cluster_version', None)
        self.overall_upgrade_elapsed_time_in_ms = kwargs.get('overall_upgrade_elapsed_time_in_ms', None)
        self.kind = 'ClusterUpgradeCompleted'


class ClusterUpgradeDescriptionObject(Model):
    """Represents a ServiceFabric cluster upgrade.

    :param config_version: The cluster configuration version (specified in the
     cluster manifest).
    :type config_version: str
    :param code_version: The ServiceFabric code version of the cluster.
    :type code_version: str
    :param upgrade_kind: The kind of upgrade out of the following possible
     values. Possible values include: 'Invalid', 'Rolling'. Default value:
     "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeKind
    :param rolling_upgrade_mode: The mode used to monitor health during a
     rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and
     Monitored. Possible values include: 'Invalid', 'UnmonitoredAuto',
     'UnmonitoredManual', 'Monitored'. Default value: "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param upgrade_replica_set_check_timeout_in_seconds: The maximum amount of
     time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires,
     processing of the upgrade domain will proceed regardless of availability
     loss issues. The timeout is reset at the start of each upgrade domain.
     Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit
     integer).
    :type upgrade_replica_set_check_timeout_in_seconds: long
    :param force_restart: If true, then processes are forcefully restarted
     during upgrade even when the code version has not changed (the upgrade
     only changes configuration or data).
    :type force_restart: bool
    :param sort_order: Defines the order in which an upgrade proceeds through
     the cluster. Possible values include: 'Invalid', 'Default', 'Numeric',
     'Lexicographical', 'ReverseNumeric', 'ReverseLexicographical'. Default
     value: "Default" .
    :type sort_order: str or ~azure.servicefabric.models.UpgradeSortOrder
    :param enable_delta_health_evaluation: When true, enables delta health
     evaluation rather than absolute health evaluation after completion of each
     upgrade domain.
    :type enable_delta_health_evaluation: bool
    :param monitoring_policy: Describes the parameters for monitoring an
     upgrade in Monitored mode.
    :type monitoring_policy:
     ~azure.servicefabric.models.MonitoringPolicyDescription
    :param cluster_health_policy: Defines a health policy used to evaluate the
     health of the cluster or of a cluster node.
    :type cluster_health_policy:
     ~azure.servicefabric.models.ClusterHealthPolicy
    :param cluster_upgrade_health_policy: Defines a health policy used to
     evaluate the health of the cluster during a cluster upgrade.
    :type cluster_upgrade_health_policy:
     ~azure.servicefabric.models.ClusterUpgradeHealthPolicyObject
    :param application_health_policy_map: Defines a map that contains specific
     application health policies for different applications.
     Each entry specifies as key the application name and as value an
     ApplicationHealthPolicy used to evaluate the application health.
     If an application is not specified in the map, the application health
     evaluation uses the ApplicationHealthPolicy found in its application
     manifest or the default application health policy (if no health policy is
     defined in the manifest).
     The map is empty by default.
    :type application_health_policy_map:
     list[~azure.servicefabric.models.ApplicationHealthPolicyMapItem]
    """

    _attribute_map = {
        'config_version': {'key': 'ConfigVersion', 'type': 'str'},
        'code_version': {'key': 'CodeVersion', 'type': 'str'},
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'upgrade_replica_set_check_timeout_in_seconds': {'key': 'UpgradeReplicaSetCheckTimeoutInSeconds', 'type': 'long'},
        'force_restart': {'key': 'ForceRestart', 'type': 'bool'},
        'sort_order': {'key': 'SortOrder', 'type': 'str'},
        'enable_delta_health_evaluation': {'key': 'EnableDeltaHealthEvaluation', 'type': 'bool'},
        'monitoring_policy': {'key': 'MonitoringPolicy', 'type': 'MonitoringPolicyDescription'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'ClusterHealthPolicy'},
        'cluster_upgrade_health_policy': {'key': 'ClusterUpgradeHealthPolicy', 'type': 'ClusterUpgradeHealthPolicyObject'},
        'application_health_policy_map': {'key': 'ApplicationHealthPolicyMap', 'type': '[ApplicationHealthPolicyMapItem]'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeDescriptionObject, self).__init__(**kwargs)
        self.config_version = kwargs.get('config_version', None)
        self.code_version = kwargs.get('code_version', None)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.upgrade_replica_set_check_timeout_in_seconds = kwargs.get('upgrade_replica_set_check_timeout_in_seconds', None)
        self.force_restart = kwargs.get('force_restart', None)
        self.sort_order = kwargs.get('sort_order', "Default")
        self.enable_delta_health_evaluation = kwargs.get('enable_delta_health_evaluation', None)
        self.monitoring_policy = kwargs.get('monitoring_policy', None)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)
        self.cluster_upgrade_health_policy = kwargs.get('cluster_upgrade_health_policy', None)
        self.application_health_policy_map = kwargs.get('application_health_policy_map', None)


class ClusterUpgradeDomainCompletedEvent(ClusterEvent):
    """Cluster Upgrade Domain Completed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param target_cluster_version: Required. Target Cluster version.
    :type target_cluster_version: str
    :param upgrade_state: Required. State of upgrade.
    :type upgrade_state: str
    :param upgrade_domains: Required. Upgrade domains.
    :type upgrade_domains: str
    :param upgrade_domain_elapsed_time_in_ms: Required. Duration of domain
     upgrade in milli-seconds.
    :type upgrade_domain_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'target_cluster_version': {'required': True},
        'upgrade_state': {'required': True},
        'upgrade_domains': {'required': True},
        'upgrade_domain_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'target_cluster_version': {'key': 'TargetClusterVersion', 'type': 'str'},
        'upgrade_state': {'key': 'UpgradeState', 'type': 'str'},
        'upgrade_domains': {'key': 'UpgradeDomains', 'type': 'str'},
        'upgrade_domain_elapsed_time_in_ms': {'key': 'UpgradeDomainElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeDomainCompletedEvent, self).__init__(**kwargs)
        self.target_cluster_version = kwargs.get('target_cluster_version', None)
        self.upgrade_state = kwargs.get('upgrade_state', None)
        self.upgrade_domains = kwargs.get('upgrade_domains', None)
        self.upgrade_domain_elapsed_time_in_ms = kwargs.get('upgrade_domain_elapsed_time_in_ms', None)
        self.kind = 'ClusterUpgradeDomainCompleted'


class ClusterUpgradeHealthPolicyObject(Model):
    """Defines a health policy used to evaluate the health of the cluster during a
    cluster upgrade.

    :param max_percent_delta_unhealthy_nodes: The maximum allowed percentage
     of nodes health degradation allowed during cluster upgrades. The delta is
     measured between the state of the nodes at the beginning of upgrade and
     the state of the nodes at the time of the health evaluation. The check is
     performed after every upgrade domain upgrade completion to make sure the
     global state of the cluster is within tolerated limits. The default value
     is 10%.
    :type max_percent_delta_unhealthy_nodes: int
    :param max_percent_upgrade_domain_delta_unhealthy_nodes: The maximum
     allowed percentage of upgrade domain nodes health degradation allowed
     during cluster upgrades. The delta is measured between the state of the
     upgrade domain nodes at the beginning of upgrade and the state of the
     upgrade domain nodes at the time of the health evaluation. The check is
     performed after every upgrade domain upgrade completion for all completed
     upgrade domains to make sure the state of the upgrade domains is within
     tolerated limits. The default value is 15%.
    :type max_percent_upgrade_domain_delta_unhealthy_nodes: int
    """

    _validation = {
        'max_percent_delta_unhealthy_nodes': {'maximum': 100, 'minimum': 0},
        'max_percent_upgrade_domain_delta_unhealthy_nodes': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_delta_unhealthy_nodes': {'key': 'MaxPercentDeltaUnhealthyNodes', 'type': 'int'},
        'max_percent_upgrade_domain_delta_unhealthy_nodes': {'key': 'MaxPercentUpgradeDomainDeltaUnhealthyNodes', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeHealthPolicyObject, self).__init__(**kwargs)
        self.max_percent_delta_unhealthy_nodes = kwargs.get('max_percent_delta_unhealthy_nodes', None)
        self.max_percent_upgrade_domain_delta_unhealthy_nodes = kwargs.get('max_percent_upgrade_domain_delta_unhealthy_nodes', None)


class ClusterUpgradeProgressObject(Model):
    """Information about a cluster upgrade.

    :param code_version: The ServiceFabric code version of the cluster.
    :type code_version: str
    :param config_version: The cluster configuration version (specified in the
     cluster manifest).
    :type config_version: str
    :param upgrade_domains: List of upgrade domains and their statuses.
    :type upgrade_domains: list[~azure.servicefabric.models.UpgradeDomainInfo]
    :param upgrade_state: The state of the upgrade domain. Possible values
     include: 'Invalid', 'RollingBackInProgress', 'RollingBackCompleted',
     'RollingForwardPending', 'RollingForwardInProgress',
     'RollingForwardCompleted', 'Failed'
    :type upgrade_state: str or ~azure.servicefabric.models.UpgradeState
    :param next_upgrade_domain: The name of the next upgrade domain to be
     processed.
    :type next_upgrade_domain: str
    :param rolling_upgrade_mode: The mode used to monitor health during a
     rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and
     Monitored. Possible values include: 'Invalid', 'UnmonitoredAuto',
     'UnmonitoredManual', 'Monitored'. Default value: "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param upgrade_description: Represents a ServiceFabric cluster upgrade
    :type upgrade_description:
     ~azure.servicefabric.models.ClusterUpgradeDescriptionObject
    :param upgrade_duration_in_milliseconds: The estimated elapsed time spent
     processing the current overall upgrade.
    :type upgrade_duration_in_milliseconds: str
    :param upgrade_domain_duration_in_milliseconds: The estimated elapsed time
     spent processing the current upgrade domain.
    :type upgrade_domain_duration_in_milliseconds: str
    :param unhealthy_evaluations: List of health evaluations that resulted in
     the current aggregated health state.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param current_upgrade_domain_progress: Information about the current
     in-progress upgrade domain.
    :type current_upgrade_domain_progress:
     ~azure.servicefabric.models.CurrentUpgradeDomainProgressInfo
    :param start_timestamp_utc: The start time of the upgrade in UTC.
    :type start_timestamp_utc: str
    :param failure_timestamp_utc: The failure time of the upgrade in UTC.
    :type failure_timestamp_utc: str
    :param failure_reason: The cause of an upgrade failure that resulted in
     FailureAction being executed. Possible values include: 'None',
     'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout',
     'OverallUpgradeTimeout'
    :type failure_reason: str or ~azure.servicefabric.models.FailureReason
    :param upgrade_domain_progress_at_failure: The detailed upgrade progress
     for nodes in the current upgrade domain at the point of failure.
    :type upgrade_domain_progress_at_failure:
     ~azure.servicefabric.models.FailedUpgradeDomainProgressObject
    """

    _attribute_map = {
        'code_version': {'key': 'CodeVersion', 'type': 'str'},
        'config_version': {'key': 'ConfigVersion', 'type': 'str'},
        'upgrade_domains': {'key': 'UpgradeDomains', 'type': '[UpgradeDomainInfo]'},
        'upgrade_state': {'key': 'UpgradeState', 'type': 'str'},
        'next_upgrade_domain': {'key': 'NextUpgradeDomain', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'upgrade_description': {'key': 'UpgradeDescription', 'type': 'ClusterUpgradeDescriptionObject'},
        'upgrade_duration_in_milliseconds': {'key': 'UpgradeDurationInMilliseconds', 'type': 'str'},
        'upgrade_domain_duration_in_milliseconds': {'key': 'UpgradeDomainDurationInMilliseconds', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'current_upgrade_domain_progress': {'key': 'CurrentUpgradeDomainProgress', 'type': 'CurrentUpgradeDomainProgressInfo'},
        'start_timestamp_utc': {'key': 'StartTimestampUtc', 'type': 'str'},
        'failure_timestamp_utc': {'key': 'FailureTimestampUtc', 'type': 'str'},
        'failure_reason': {'key': 'FailureReason', 'type': 'str'},
        'upgrade_domain_progress_at_failure': {'key': 'UpgradeDomainProgressAtFailure', 'type': 'FailedUpgradeDomainProgressObject'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeProgressObject, self).__init__(**kwargs)
        self.code_version = kwargs.get('code_version', None)
        self.config_version = kwargs.get('config_version', None)
        self.upgrade_domains = kwargs.get('upgrade_domains', None)
        self.upgrade_state = kwargs.get('upgrade_state', None)
        self.next_upgrade_domain = kwargs.get('next_upgrade_domain', None)
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.upgrade_description = kwargs.get('upgrade_description', None)
        self.upgrade_duration_in_milliseconds = kwargs.get('upgrade_duration_in_milliseconds', None)
        self.upgrade_domain_duration_in_milliseconds = kwargs.get('upgrade_domain_duration_in_milliseconds', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.current_upgrade_domain_progress = kwargs.get('current_upgrade_domain_progress', None)
        self.start_timestamp_utc = kwargs.get('start_timestamp_utc', None)
        self.failure_timestamp_utc = kwargs.get('failure_timestamp_utc', None)
        self.failure_reason = kwargs.get('failure_reason', None)
        self.upgrade_domain_progress_at_failure = kwargs.get('upgrade_domain_progress_at_failure', None)


class ClusterUpgradeRollbackCompletedEvent(ClusterEvent):
    """Cluster Upgrade Rollback Completed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param target_cluster_version: Required. Target Cluster version.
    :type target_cluster_version: str
    :param failure_reason: Required. Describes failure.
    :type failure_reason: str
    :param overall_upgrade_elapsed_time_in_ms: Required. Overall duration of
     upgrade in milli-seconds.
    :type overall_upgrade_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'target_cluster_version': {'required': True},
        'failure_reason': {'required': True},
        'overall_upgrade_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'target_cluster_version': {'key': 'TargetClusterVersion', 'type': 'str'},
        'failure_reason': {'key': 'FailureReason', 'type': 'str'},
        'overall_upgrade_elapsed_time_in_ms': {'key': 'OverallUpgradeElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeRollbackCompletedEvent, self).__init__(**kwargs)
        self.target_cluster_version = kwargs.get('target_cluster_version', None)
        self.failure_reason = kwargs.get('failure_reason', None)
        self.overall_upgrade_elapsed_time_in_ms = kwargs.get('overall_upgrade_elapsed_time_in_ms', None)
        self.kind = 'ClusterUpgradeRollbackCompleted'


class ClusterUpgradeRollbackStartedEvent(ClusterEvent):
    """Cluster Upgrade Rollback Started event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param target_cluster_version: Required. Target Cluster version.
    :type target_cluster_version: str
    :param failure_reason: Required. Describes failure.
    :type failure_reason: str
    :param overall_upgrade_elapsed_time_in_ms: Required. Overall duration of
     upgrade in milli-seconds.
    :type overall_upgrade_elapsed_time_in_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'target_cluster_version': {'required': True},
        'failure_reason': {'required': True},
        'overall_upgrade_elapsed_time_in_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'target_cluster_version': {'key': 'TargetClusterVersion', 'type': 'str'},
        'failure_reason': {'key': 'FailureReason', 'type': 'str'},
        'overall_upgrade_elapsed_time_in_ms': {'key': 'OverallUpgradeElapsedTimeInMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeRollbackStartedEvent, self).__init__(**kwargs)
        self.target_cluster_version = kwargs.get('target_cluster_version', None)
        self.failure_reason = kwargs.get('failure_reason', None)
        self.overall_upgrade_elapsed_time_in_ms = kwargs.get('overall_upgrade_elapsed_time_in_ms', None)
        self.kind = 'ClusterUpgradeRollbackStarted'


class ClusterUpgradeStartedEvent(ClusterEvent):
    """Cluster Upgrade Started event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param current_cluster_version: Required. Current Cluster version.
    :type current_cluster_version: str
    :param target_cluster_version: Required. Target Cluster version.
    :type target_cluster_version: str
    :param upgrade_type: Required. Type of upgrade.
    :type upgrade_type: str
    :param rolling_upgrade_mode: Required. Mode of upgrade.
    :type rolling_upgrade_mode: str
    :param failure_action: Required. Action if failed.
    :type failure_action: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'current_cluster_version': {'required': True},
        'target_cluster_version': {'required': True},
        'upgrade_type': {'required': True},
        'rolling_upgrade_mode': {'required': True},
        'failure_action': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'current_cluster_version': {'key': 'CurrentClusterVersion', 'type': 'str'},
        'target_cluster_version': {'key': 'TargetClusterVersion', 'type': 'str'},
        'upgrade_type': {'key': 'UpgradeType', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'failure_action': {'key': 'FailureAction', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpgradeStartedEvent, self).__init__(**kwargs)
        self.current_cluster_version = kwargs.get('current_cluster_version', None)
        self.target_cluster_version = kwargs.get('target_cluster_version', None)
        self.upgrade_type = kwargs.get('upgrade_type', None)
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', None)
        self.failure_action = kwargs.get('failure_action', None)
        self.kind = 'ClusterUpgradeStarted'


class ClusterVersion(Model):
    """The cluster version.

    :param version: The Service Fabric cluster runtime version.
    :type version: str
    """

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterVersion, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)


class CodePackageEntryPoint(Model):
    """Information about setup or main entry point of a code package deployed on a
    Service Fabric node.

    :param entry_point_location: The location of entry point executable on the
     node.
    :type entry_point_location: str
    :param process_id: The process ID of the entry point.
    :type process_id: str
    :param run_as_user_name: The user name under which entry point executable
     is run on the node.
    :type run_as_user_name: str
    :param code_package_entry_point_statistics: Statistics about setup or main
     entry point  of a code package deployed on a Service Fabric node.
    :type code_package_entry_point_statistics:
     ~azure.servicefabric.models.CodePackageEntryPointStatistics
    :param status: Specifies the status of the code package entry point
     deployed on a Service Fabric node. Possible values include: 'Invalid',
     'Pending', 'Starting', 'Started', 'Stopping', 'Stopped'
    :type status: str or ~azure.servicefabric.models.EntryPointStatus
    :param next_activation_time: The time (in UTC) when the entry point
     executable will be run next.
    :type next_activation_time: datetime
    :param instance_id: The instance ID for current running entry point. For a
     code package setup entry point (if specified) runs first and after it
     finishes main entry point is started. Each time entry point executable is
     run, its instance id will change.
    :type instance_id: str
    """

    _attribute_map = {
        'entry_point_location': {'key': 'EntryPointLocation', 'type': 'str'},
        'process_id': {'key': 'ProcessId', 'type': 'str'},
        'run_as_user_name': {'key': 'RunAsUserName', 'type': 'str'},
        'code_package_entry_point_statistics': {'key': 'CodePackageEntryPointStatistics', 'type': 'CodePackageEntryPointStatistics'},
        'status': {'key': 'Status', 'type': 'str'},
        'next_activation_time': {'key': 'NextActivationTime', 'type': 'iso-8601'},
        'instance_id': {'key': 'InstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CodePackageEntryPoint, self).__init__(**kwargs)
        self.entry_point_location = kwargs.get('entry_point_location', None)
        self.process_id = kwargs.get('process_id', None)
        self.run_as_user_name = kwargs.get('run_as_user_name', None)
        self.code_package_entry_point_statistics = kwargs.get('code_package_entry_point_statistics', None)
        self.status = kwargs.get('status', None)
        self.next_activation_time = kwargs.get('next_activation_time', None)
        self.instance_id = kwargs.get('instance_id', None)


class CodePackageEntryPointStatistics(Model):
    """Statistics about setup or main entry point  of a code package deployed on a
    Service Fabric node.

    :param last_exit_code: The last exit code of the entry point.
    :type last_exit_code: str
    :param last_activation_time: The last time (in UTC) when Service Fabric
     attempted to run the entry point.
    :type last_activation_time: datetime
    :param last_exit_time: The last time (in UTC) when the entry point
     finished running.
    :type last_exit_time: datetime
    :param last_successful_activation_time: The last time (in UTC) when the
     entry point ran successfully.
    :type last_successful_activation_time: datetime
    :param last_successful_exit_time: The last time (in UTC) when the entry
     point finished running gracefully.
    :type last_successful_exit_time: datetime
    :param activation_count: Number of times the entry point has run.
    :type activation_count: str
    :param activation_failure_count: Number of times the entry point failed to
     run.
    :type activation_failure_count: str
    :param continuous_activation_failure_count: Number of times the entry
     point continuously failed to run.
    :type continuous_activation_failure_count: str
    :param exit_count: Number of times the entry point finished running.
    :type exit_count: str
    :param exit_failure_count: Number of times the entry point failed to exit
     gracefully.
    :type exit_failure_count: str
    :param continuous_exit_failure_count: Number of times the entry point
     continuously failed to exit gracefully.
    :type continuous_exit_failure_count: str
    """

    _attribute_map = {
        'last_exit_code': {'key': 'LastExitCode', 'type': 'str'},
        'last_activation_time': {'key': 'LastActivationTime', 'type': 'iso-8601'},
        'last_exit_time': {'key': 'LastExitTime', 'type': 'iso-8601'},
        'last_successful_activation_time': {'key': 'LastSuccessfulActivationTime', 'type': 'iso-8601'},
        'last_successful_exit_time': {'key': 'LastSuccessfulExitTime', 'type': 'iso-8601'},
        'activation_count': {'key': 'ActivationCount', 'type': 'str'},
        'activation_failure_count': {'key': 'ActivationFailureCount', 'type': 'str'},
        'continuous_activation_failure_count': {'key': 'ContinuousActivationFailureCount', 'type': 'str'},
        'exit_count': {'key': 'ExitCount', 'type': 'str'},
        'exit_failure_count': {'key': 'ExitFailureCount', 'type': 'str'},
        'continuous_exit_failure_count': {'key': 'ContinuousExitFailureCount', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CodePackageEntryPointStatistics, self).__init__(**kwargs)
        self.last_exit_code = kwargs.get('last_exit_code', None)
        self.last_activation_time = kwargs.get('last_activation_time', None)
        self.last_exit_time = kwargs.get('last_exit_time', None)
        self.last_successful_activation_time = kwargs.get('last_successful_activation_time', None)
        self.last_successful_exit_time = kwargs.get('last_successful_exit_time', None)
        self.activation_count = kwargs.get('activation_count', None)
        self.activation_failure_count = kwargs.get('activation_failure_count', None)
        self.continuous_activation_failure_count = kwargs.get('continuous_activation_failure_count', None)
        self.exit_count = kwargs.get('exit_count', None)
        self.exit_failure_count = kwargs.get('exit_failure_count', None)
        self.continuous_exit_failure_count = kwargs.get('continuous_exit_failure_count', None)


class ComposeDeploymentStatusInfo(Model):
    """Information about a Service Fabric compose deployment.

    :param name: The name of the deployment.
    :type name: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param status: The status of the compose deployment. Possible values
     include: 'Invalid', 'Provisioning', 'Creating', 'Ready', 'Unprovisioning',
     'Deleting', 'Failed', 'Upgrading'
    :type status: str or ~azure.servicefabric.models.ComposeDeploymentStatus
    :param status_details: The status details of compose deployment including
     failure message.
    :type status_details: str
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'status_details': {'key': 'StatusDetails', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ComposeDeploymentStatusInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.application_name = kwargs.get('application_name', None)
        self.status = kwargs.get('status', None)
        self.status_details = kwargs.get('status_details', None)


class ComposeDeploymentUpgradeDescription(Model):
    """Describes the parameters for a compose deployment upgrade.

    All required parameters must be populated in order to send to Azure.

    :param deployment_name: Required. The name of the deployment.
    :type deployment_name: str
    :param compose_file_content: Required. The content of the compose file
     that describes the deployment to create.
    :type compose_file_content: str
    :param registry_credential: Credential information to connect to container
     registry.
    :type registry_credential: ~azure.servicefabric.models.RegistryCredential
    :param upgrade_kind: Required. The kind of upgrade out of the following
     possible values. Possible values include: 'Invalid', 'Rolling'. Default
     value: "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeKind
    :param rolling_upgrade_mode: The mode used to monitor health during a
     rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and
     Monitored. Possible values include: 'Invalid', 'UnmonitoredAuto',
     'UnmonitoredManual', 'Monitored'. Default value: "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param upgrade_replica_set_check_timeout_in_seconds: The maximum amount of
     time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires,
     processing of the upgrade domain will proceed regardless of availability
     loss issues. The timeout is reset at the start of each upgrade domain.
     Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit
     integer).
    :type upgrade_replica_set_check_timeout_in_seconds: long
    :param force_restart: If true, then processes are forcefully restarted
     during upgrade even when the code version has not changed (the upgrade
     only changes configuration or data).
    :type force_restart: bool
    :param monitoring_policy: Describes the parameters for monitoring an
     upgrade in Monitored mode.
    :type monitoring_policy:
     ~azure.servicefabric.models.MonitoringPolicyDescription
    :param application_health_policy: Defines a health policy used to evaluate
     the health of an application or one of its children entities.
    :type application_health_policy:
     ~azure.servicefabric.models.ApplicationHealthPolicy
    """

    _validation = {
        'deployment_name': {'required': True},
        'compose_file_content': {'required': True},
        'upgrade_kind': {'required': True},
    }

    _attribute_map = {
        'deployment_name': {'key': 'DeploymentName', 'type': 'str'},
        'compose_file_content': {'key': 'ComposeFileContent', 'type': 'str'},
        'registry_credential': {'key': 'RegistryCredential', 'type': 'RegistryCredential'},
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'upgrade_replica_set_check_timeout_in_seconds': {'key': 'UpgradeReplicaSetCheckTimeoutInSeconds', 'type': 'long'},
        'force_restart': {'key': 'ForceRestart', 'type': 'bool'},
        'monitoring_policy': {'key': 'MonitoringPolicy', 'type': 'MonitoringPolicyDescription'},
        'application_health_policy': {'key': 'ApplicationHealthPolicy', 'type': 'ApplicationHealthPolicy'},
    }

    def __init__(self, **kwargs):
        super(ComposeDeploymentUpgradeDescription, self).__init__(**kwargs)
        self.deployment_name = kwargs.get('deployment_name', None)
        self.compose_file_content = kwargs.get('compose_file_content', None)
        self.registry_credential = kwargs.get('registry_credential', None)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.upgrade_replica_set_check_timeout_in_seconds = kwargs.get('upgrade_replica_set_check_timeout_in_seconds', None)
        self.force_restart = kwargs.get('force_restart', None)
        self.monitoring_policy = kwargs.get('monitoring_policy', None)
        self.application_health_policy = kwargs.get('application_health_policy', None)


class ComposeDeploymentUpgradeProgressInfo(Model):
    """Describes the parameters for a compose deployment upgrade.

    :param deployment_name: The name of the target deployment.
    :type deployment_name: str
    :param application_name: The name of the target application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param upgrade_state: The state of the compose deployment upgrade.
     Possible values include: 'Invalid', 'ProvisioningTarget',
     'RollingForwardInProgress', 'RollingForwardPending',
     'UnprovisioningCurrent', 'RollingForwardCompleted',
     'RollingBackInProgress', 'UnprovisioningTarget', 'RollingBackCompleted',
     'Failed'
    :type upgrade_state: str or
     ~azure.servicefabric.models.ComposeDeploymentUpgradeState
    :param upgrade_status_details: Additional detailed information about the
     status of the pending upgrade.
    :type upgrade_status_details: str
    :param upgrade_kind: The kind of upgrade out of the following possible
     values. Possible values include: 'Invalid', 'Rolling'. Default value:
     "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeKind
    :param rolling_upgrade_mode: The mode used to monitor health during a
     rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and
     Monitored. Possible values include: 'Invalid', 'UnmonitoredAuto',
     'UnmonitoredManual', 'Monitored'. Default value: "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param force_restart: If true, then processes are forcefully restarted
     during upgrade even when the code version has not changed (the upgrade
     only changes configuration or data).
    :type force_restart: bool
    :param upgrade_replica_set_check_timeout_in_seconds: The maximum amount of
     time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires,
     processing of the upgrade domain will proceed regardless of availability
     loss issues. The timeout is reset at the start of each upgrade domain.
     Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit
     integer).
    :type upgrade_replica_set_check_timeout_in_seconds: long
    :param monitoring_policy: Describes the parameters for monitoring an
     upgrade in Monitored mode.
    :type monitoring_policy:
     ~azure.servicefabric.models.MonitoringPolicyDescription
    :param application_health_policy: Defines a health policy used to evaluate
     the health of an application or one of its children entities.
    :type application_health_policy:
     ~azure.servicefabric.models.ApplicationHealthPolicy
    :param target_application_type_version: The target application type
     version (found in the application manifest) for the application upgrade.
    :type target_application_type_version: str
    :param upgrade_duration: The estimated amount of time that the overall
     upgrade elapsed. It is first interpreted as a string representing an ISO
     8601 duration. If that fails, then it is interpreted as a number
     representing the total number of milliseconds.
    :type upgrade_duration: str
    :param current_upgrade_domain_duration: The estimated amount of time spent
     processing current Upgrade Domain. It is first interpreted as a string
     representing an ISO 8601 duration. If that fails, then it is interpreted
     as a number representing the total number of milliseconds.
    :type current_upgrade_domain_duration: str
    :param application_unhealthy_evaluations: List of health evaluations that
     resulted in the current aggregated health state.
    :type application_unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param current_upgrade_domain_progress: Information about the current
     in-progress upgrade domain.
    :type current_upgrade_domain_progress:
     ~azure.servicefabric.models.CurrentUpgradeDomainProgressInfo
    :param start_timestamp_utc: The estimated UTC datetime when the upgrade
     started.
    :type start_timestamp_utc: str
    :param failure_timestamp_utc: The estimated UTC datetime when the upgrade
     failed and FailureAction was executed.
    :type failure_timestamp_utc: str
    :param failure_reason: The cause of an upgrade failure that resulted in
     FailureAction being executed. Possible values include: 'None',
     'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout',
     'OverallUpgradeTimeout'
    :type failure_reason: str or ~azure.servicefabric.models.FailureReason
    :param upgrade_domain_progress_at_failure: Information about the upgrade
     domain progress at the time of upgrade failure.
    :type upgrade_domain_progress_at_failure:
     ~azure.servicefabric.models.FailureUpgradeDomainProgressInfo
    :param application_upgrade_status_details: Additional details of
     application upgrade including failure message.
    :type application_upgrade_status_details: str
    """

    _attribute_map = {
        'deployment_name': {'key': 'DeploymentName', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'upgrade_state': {'key': 'UpgradeState', 'type': 'str'},
        'upgrade_status_details': {'key': 'UpgradeStatusDetails', 'type': 'str'},
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'force_restart': {'key': 'ForceRestart', 'type': 'bool'},
        'upgrade_replica_set_check_timeout_in_seconds': {'key': 'UpgradeReplicaSetCheckTimeoutInSeconds', 'type': 'long'},
        'monitoring_policy': {'key': 'MonitoringPolicy', 'type': 'MonitoringPolicyDescription'},
        'application_health_policy': {'key': 'ApplicationHealthPolicy', 'type': 'ApplicationHealthPolicy'},
        'target_application_type_version': {'key': 'TargetApplicationTypeVersion', 'type': 'str'},
        'upgrade_duration': {'key': 'UpgradeDuration', 'type': 'str'},
        'current_upgrade_domain_duration': {'key': 'CurrentUpgradeDomainDuration', 'type': 'str'},
        'application_unhealthy_evaluations': {'key': 'ApplicationUnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'current_upgrade_domain_progress': {'key': 'CurrentUpgradeDomainProgress', 'type': 'CurrentUpgradeDomainProgressInfo'},
        'start_timestamp_utc': {'key': 'StartTimestampUtc', 'type': 'str'},
        'failure_timestamp_utc': {'key': 'FailureTimestampUtc', 'type': 'str'},
        'failure_reason': {'key': 'FailureReason', 'type': 'str'},
        'upgrade_domain_progress_at_failure': {'key': 'UpgradeDomainProgressAtFailure', 'type': 'FailureUpgradeDomainProgressInfo'},
        'application_upgrade_status_details': {'key': 'ApplicationUpgradeStatusDetails', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ComposeDeploymentUpgradeProgressInfo, self).__init__(**kwargs)
        self.deployment_name = kwargs.get('deployment_name', None)
        self.application_name = kwargs.get('application_name', None)
        self.upgrade_state = kwargs.get('upgrade_state', None)
        self.upgrade_status_details = kwargs.get('upgrade_status_details', None)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.force_restart = kwargs.get('force_restart', None)
        self.upgrade_replica_set_check_timeout_in_seconds = kwargs.get('upgrade_replica_set_check_timeout_in_seconds', None)
        self.monitoring_policy = kwargs.get('monitoring_policy', None)
        self.application_health_policy = kwargs.get('application_health_policy', None)
        self.target_application_type_version = kwargs.get('target_application_type_version', None)
        self.upgrade_duration = kwargs.get('upgrade_duration', None)
        self.current_upgrade_domain_duration = kwargs.get('current_upgrade_domain_duration', None)
        self.application_unhealthy_evaluations = kwargs.get('application_unhealthy_evaluations', None)
        self.current_upgrade_domain_progress = kwargs.get('current_upgrade_domain_progress', None)
        self.start_timestamp_utc = kwargs.get('start_timestamp_utc', None)
        self.failure_timestamp_utc = kwargs.get('failure_timestamp_utc', None)
        self.failure_reason = kwargs.get('failure_reason', None)
        self.upgrade_domain_progress_at_failure = kwargs.get('upgrade_domain_progress_at_failure', None)
        self.application_upgrade_status_details = kwargs.get('application_upgrade_status_details', None)


class ContainerApiRequestBody(Model):
    """parameters for making container API call.

    All required parameters must be populated in order to send to Azure.

    :param http_verb: HTTP verb of container REST API, defaults to "GET"
    :type http_verb: str
    :param uri_path: Required. URI path of container REST API
    :type uri_path: str
    :param content_type: Content type of container REST API request, defaults
     to "application/json"
    :type content_type: str
    :param body: HTTP request body of container REST API
    :type body: str
    """

    _validation = {
        'uri_path': {'required': True},
    }

    _attribute_map = {
        'http_verb': {'key': 'HttpVerb', 'type': 'str'},
        'uri_path': {'key': 'UriPath', 'type': 'str'},
        'content_type': {'key': 'Content-Type', 'type': 'str'},
        'body': {'key': 'Body', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerApiRequestBody, self).__init__(**kwargs)
        self.http_verb = kwargs.get('http_verb', None)
        self.uri_path = kwargs.get('uri_path', None)
        self.content_type = kwargs.get('content_type', None)
        self.body = kwargs.get('body', None)


class ContainerApiResponse(Model):
    """Response body that wraps container API result.

    All required parameters must be populated in order to send to Azure.

    :param container_api_result: Required. Container API result.
    :type container_api_result: ~azure.servicefabric.models.ContainerApiResult
    """

    _validation = {
        'container_api_result': {'required': True},
    }

    _attribute_map = {
        'container_api_result': {'key': 'ContainerApiResult', 'type': 'ContainerApiResult'},
    }

    def __init__(self, **kwargs):
        super(ContainerApiResponse, self).__init__(**kwargs)
        self.container_api_result = kwargs.get('container_api_result', None)


class ContainerApiResult(Model):
    """Container API result.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. HTTP status code returned by the target container
     API
    :type status: int
    :param content_type: HTTP content type
    :type content_type: str
    :param content_encoding: HTTP content encoding
    :type content_encoding: str
    :param body: container API result body
    :type body: str
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'int'},
        'content_type': {'key': 'Content-Type', 'type': 'str'},
        'content_encoding': {'key': 'Content-Encoding', 'type': 'str'},
        'body': {'key': 'Body', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerApiResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.content_type = kwargs.get('content_type', None)
        self.content_encoding = kwargs.get('content_encoding', None)
        self.body = kwargs.get('body', None)


class ContainerCodePackageProperties(Model):
    """Describes a container and its runtime properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the code package.
    :type name: str
    :param image: Required. The Container image to use.
    :type image: str
    :param image_registry_credential: Image registry credential.
    :type image_registry_credential:
     ~azure.servicefabric.models.ImageRegistryCredential
    :param entrypoint: Override for the default entry point in the container.
    :type entrypoint: str
    :param commands: Command array to execute within the container in exec
     form.
    :type commands: list[str]
    :param environment_variables: The environment variables to set in this
     container
    :type environment_variables:
     list[~azure.servicefabric.models.EnvironmentVariable]
    :param settings: The settings to set in this container. The setting file
     path can be fetched from environment variable "Fabric_SettingPath". The
     path for Windows container is "C:\\\\secrets". The path for Linux
     container is "/var/secrets".
    :type settings: list[~azure.servicefabric.models.Setting]
    :param labels: The labels to set in this container.
    :type labels: list[~azure.servicefabric.models.ContainerLabel]
    :param endpoints: The endpoints exposed by this container.
    :type endpoints: list[~azure.servicefabric.models.EndpointProperties]
    :param resources: Required. The resources required by this container.
    :type resources: ~azure.servicefabric.models.ResourceRequirements
    :param volume_refs: Volumes to be attached to the container. The lifetime
     of these volumes is independent of the application's lifetime.
    :type volume_refs: list[~azure.servicefabric.models.VolumeReference]
    :param volumes: Volumes to be attached to the container. The lifetime of
     these volumes is scoped to the application's lifetime.
    :type volumes: list[~azure.servicefabric.models.ApplicationScopedVolume]
    :param diagnostics: Reference to sinks in DiagnosticsDescription.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsRef
    :param reliable_collections_refs: A list of ReliableCollection resources
     used by this particular code package. Please refer to
     ReliableCollectionsRef for more details.
    :type reliable_collections_refs:
     list[~azure.servicefabric.models.ReliableCollectionsRef]
    :ivar instance_view: Runtime information of a container instance.
    :vartype instance_view: ~azure.servicefabric.models.ContainerInstanceView
    """

    _validation = {
        'name': {'required': True},
        'image': {'required': True},
        'resources': {'required': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
        'image_registry_credential': {'key': 'imageRegistryCredential', 'type': 'ImageRegistryCredential'},
        'entrypoint': {'key': 'entrypoint', 'type': 'str'},
        'commands': {'key': 'commands', 'type': '[str]'},
        'environment_variables': {'key': 'environmentVariables', 'type': '[EnvironmentVariable]'},
        'settings': {'key': 'settings', 'type': '[Setting]'},
        'labels': {'key': 'labels', 'type': '[ContainerLabel]'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointProperties]'},
        'resources': {'key': 'resources', 'type': 'ResourceRequirements'},
        'volume_refs': {'key': 'volumeRefs', 'type': '[VolumeReference]'},
        'volumes': {'key': 'volumes', 'type': '[ApplicationScopedVolume]'},
        'diagnostics': {'key': 'diagnostics', 'type': 'DiagnosticsRef'},
        'reliable_collections_refs': {'key': 'reliableCollectionsRefs', 'type': '[ReliableCollectionsRef]'},
        'instance_view': {'key': 'instanceView', 'type': 'ContainerInstanceView'},
    }

    def __init__(self, **kwargs):
        super(ContainerCodePackageProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.image = kwargs.get('image', None)
        self.image_registry_credential = kwargs.get('image_registry_credential', None)
        self.entrypoint = kwargs.get('entrypoint', None)
        self.commands = kwargs.get('commands', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.settings = kwargs.get('settings', None)
        self.labels = kwargs.get('labels', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.resources = kwargs.get('resources', None)
        self.volume_refs = kwargs.get('volume_refs', None)
        self.volumes = kwargs.get('volumes', None)
        self.diagnostics = kwargs.get('diagnostics', None)
        self.reliable_collections_refs = kwargs.get('reliable_collections_refs', None)
        self.instance_view = None


class ContainerEvent(Model):
    """A container event.

    :param name: The name of the container event.
    :type name: str
    :param count: The count of the event.
    :type count: int
    :param first_timestamp: Date/time of the first event.
    :type first_timestamp: str
    :param last_timestamp: Date/time of the last event.
    :type last_timestamp: str
    :param message: The event message
    :type message: str
    :param type: The event type.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'first_timestamp': {'key': 'firstTimestamp', 'type': 'str'},
        'last_timestamp': {'key': 'lastTimestamp', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerEvent, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.count = kwargs.get('count', None)
        self.first_timestamp = kwargs.get('first_timestamp', None)
        self.last_timestamp = kwargs.get('last_timestamp', None)
        self.message = kwargs.get('message', None)
        self.type = kwargs.get('type', None)


class ContainerInstanceEvent(FabricEvent):
    """Represents the base for all Container Events.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerInstanceEvent, self).__init__(**kwargs)
        self.kind = 'ContainerInstanceEvent'


class ContainerInstanceView(Model):
    """Runtime information of a container instance.

    :param restart_count: The number of times the container has been
     restarted.
    :type restart_count: int
    :param current_state: Current container instance state.
    :type current_state: ~azure.servicefabric.models.ContainerState
    :param previous_state: Previous container instance state.
    :type previous_state: ~azure.servicefabric.models.ContainerState
    :param events: The events of this container instance.
    :type events: list[~azure.servicefabric.models.ContainerEvent]
    """

    _attribute_map = {
        'restart_count': {'key': 'restartCount', 'type': 'int'},
        'current_state': {'key': 'currentState', 'type': 'ContainerState'},
        'previous_state': {'key': 'previousState', 'type': 'ContainerState'},
        'events': {'key': 'events', 'type': '[ContainerEvent]'},
    }

    def __init__(self, **kwargs):
        super(ContainerInstanceView, self).__init__(**kwargs)
        self.restart_count = kwargs.get('restart_count', None)
        self.current_state = kwargs.get('current_state', None)
        self.previous_state = kwargs.get('previous_state', None)
        self.events = kwargs.get('events', None)


class ContainerLabel(Model):
    """Describes a container label.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the container label.
    :type name: str
    :param value: Required. The value of the container label.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerLabel, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ContainerLogs(Model):
    """Container logs.

    :param content: Container logs.
    :type content: str
    """

    _attribute_map = {
        'content': {'key': 'Content', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerLogs, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class ContainerState(Model):
    """The container state.

    :param state: The state of this container
    :type state: str
    :param start_time: Date/time when the container state started.
    :type start_time: datetime
    :param exit_code: The container exit code.
    :type exit_code: str
    :param finish_time: Date/time when the container state finished.
    :type finish_time: datetime
    :param detail_status: Human-readable status of this state.
    :type detail_status: str
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'str'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'detail_status': {'key': 'detailStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerState, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.start_time = kwargs.get('start_time', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.finish_time = kwargs.get('finish_time', None)
        self.detail_status = kwargs.get('detail_status', None)


class CreateComposeDeploymentDescription(Model):
    """Defines description for creating a Service Fabric compose deployment.

    All required parameters must be populated in order to send to Azure.

    :param deployment_name: Required. The name of the deployment.
    :type deployment_name: str
    :param compose_file_content: Required. The content of the compose file
     that describes the deployment to create.
    :type compose_file_content: str
    :param registry_credential: Credential information to connect to container
     registry.
    :type registry_credential: ~azure.servicefabric.models.RegistryCredential
    """

    _validation = {
        'deployment_name': {'required': True},
        'compose_file_content': {'required': True},
    }

    _attribute_map = {
        'deployment_name': {'key': 'DeploymentName', 'type': 'str'},
        'compose_file_content': {'key': 'ComposeFileContent', 'type': 'str'},
        'registry_credential': {'key': 'RegistryCredential', 'type': 'RegistryCredential'},
    }

    def __init__(self, **kwargs):
        super(CreateComposeDeploymentDescription, self).__init__(**kwargs)
        self.deployment_name = kwargs.get('deployment_name', None)
        self.compose_file_content = kwargs.get('compose_file_content', None)
        self.registry_credential = kwargs.get('registry_credential', None)


class CurrentUpgradeDomainProgressInfo(Model):
    """Information about the current in-progress upgrade domain.

    :param domain_name: The name of the upgrade domain
    :type domain_name: str
    :param node_upgrade_progress_list: List of upgrading nodes and their
     statuses
    :type node_upgrade_progress_list:
     list[~azure.servicefabric.models.NodeUpgradeProgressInfo]
    """

    _attribute_map = {
        'domain_name': {'key': 'DomainName', 'type': 'str'},
        'node_upgrade_progress_list': {'key': 'NodeUpgradeProgressList', 'type': '[NodeUpgradeProgressInfo]'},
    }

    def __init__(self, **kwargs):
        super(CurrentUpgradeDomainProgressInfo, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.node_upgrade_progress_list = kwargs.get('node_upgrade_progress_list', None)


class DeactivationIntentDescription(Model):
    """Describes the intent or reason for deactivating the node.

    :param deactivation_intent: Describes the intent or reason for
     deactivating the node. The possible values are following. Possible values
     include: 'Pause', 'Restart', 'RemoveData'
    :type deactivation_intent: str or
     ~azure.servicefabric.models.DeactivationIntent
    """

    _attribute_map = {
        'deactivation_intent': {'key': 'DeactivationIntent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeactivationIntentDescription, self).__init__(**kwargs)
        self.deactivation_intent = kwargs.get('deactivation_intent', None)


class DeletePropertyBatchOperation(PropertyBatchOperation):
    """Represents a PropertyBatchOperation that deletes a specified property if it
    exists.
    Note that if one PropertyBatchOperation in a PropertyBatch fails,
    the entire batch fails and cannot be committed in a transactional manner.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeletePropertyBatchOperation, self).__init__(**kwargs)
        self.kind = 'Delete'


class DeltaNodesCheckHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for delta nodes, containing health evaluations
    for each unhealthy node that impacted current aggregated health state.
    Can be returned during cluster upgrade when the aggregated health state of
    the cluster is Warning or Error.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param baseline_error_count: Number of nodes with aggregated heath state
     Error in the health store at the beginning of the cluster upgrade.
    :type baseline_error_count: long
    :param baseline_total_count: Total number of nodes in the health store at
     the beginning of the cluster upgrade.
    :type baseline_total_count: long
    :param max_percent_delta_unhealthy_nodes: Maximum allowed percentage of
     delta unhealthy nodes from the ClusterUpgradeHealthPolicy.
    :type max_percent_delta_unhealthy_nodes: int
    :param total_count: Total number of nodes in the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state.
     Includes all the unhealthy NodeHealthEvaluation that impacted the
     aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'baseline_error_count': {'key': 'BaselineErrorCount', 'type': 'long'},
        'baseline_total_count': {'key': 'BaselineTotalCount', 'type': 'long'},
        'max_percent_delta_unhealthy_nodes': {'key': 'MaxPercentDeltaUnhealthyNodes', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(DeltaNodesCheckHealthEvaluation, self).__init__(**kwargs)
        self.baseline_error_count = kwargs.get('baseline_error_count', None)
        self.baseline_total_count = kwargs.get('baseline_total_count', None)
        self.max_percent_delta_unhealthy_nodes = kwargs.get('max_percent_delta_unhealthy_nodes', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'DeltaNodesCheck'


class DeployedApplicationHealth(EntityHealth):
    """Information about the health of an application deployed on a Service Fabric
    node.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param name: Name of the application deployed on the node whose health
     information is described by this object.
    :type name: str
    :param node_name: Name of the node where this application is deployed.
    :type node_name: str
    :param deployed_service_package_health_states: Deployed service package
     health states for the current deployed application as found in the health
     store.
    :type deployed_service_package_health_states:
     list[~azure.servicefabric.models.DeployedServicePackageHealthState]
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'name': {'key': 'Name', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'deployed_service_package_health_states': {'key': 'DeployedServicePackageHealthStates', 'type': '[DeployedServicePackageHealthState]'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationHealth, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.node_name = kwargs.get('node_name', None)
        self.deployed_service_package_health_states = kwargs.get('deployed_service_package_health_states', None)


class DeployedApplicationHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for a deployed application, containing
    information about the data and the algorithm used by the health store to
    evaluate health.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Name of the node where the application is deployed to.
    :type node_name: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param unhealthy_evaluations: List of  unhealthy evaluations that led to
     the current aggregated health state of the deployed application.
     The types of the unhealthy evaluations can be
     DeployedServicePackagesHealthEvaluation or EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationHealthEvaluation, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.application_name = kwargs.get('application_name', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'DeployedApplication'


class DeployedApplicationHealthReportExpiredEvent(ApplicationEvent):
    """Deployed Application Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_instance_id: Required. Id of Application instance.
    :type application_instance_id: long
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_instance_id': {'required': True},
        'node_name': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_instance_id': {'key': 'ApplicationInstanceId', 'type': 'long'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationHealthReportExpiredEvent, self).__init__(**kwargs)
        self.application_instance_id = kwargs.get('application_instance_id', None)
        self.node_name = kwargs.get('node_name', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'DeployedApplicationHealthReportExpired'


class DeployedApplicationHealthState(EntityHealthState):
    """Represents the health state of a deployed application, which contains the
    entity identifier and the aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param node_name: Name of the node on which the service package is
     deployed.
    :type node_name: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationHealthState, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.application_name = kwargs.get('application_name', None)


class DeployedApplicationHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a deployed application, which contains
    the node where the application is deployed, the aggregated health state and
    any deployed service packages that respect the chunk query description
    filters.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param node_name: The name of node where the application is deployed.
    :type node_name: str
    :param deployed_service_package_health_state_chunks: The list of deployed
     service package health state chunks belonging to the deployed application
     that respect the filters in the cluster health chunk query description.
    :type deployed_service_package_health_state_chunks:
     ~azure.servicefabric.models.DeployedServicePackageHealthStateChunkList
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'deployed_service_package_health_state_chunks': {'key': 'DeployedServicePackageHealthStateChunks', 'type': 'DeployedServicePackageHealthStateChunkList'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationHealthStateChunk, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.deployed_service_package_health_state_chunks = kwargs.get('deployed_service_package_health_state_chunks', None)


class DeployedApplicationHealthStateChunkList(Model):
    """The list of deployed application health state chunks that respect the input
    filters in the chunk query. Returned by get cluster health state chunks
    query.

    :param items: The list of deployed application health state chunks that
     respect the input filters in the chunk query.
    :type items:
     list[~azure.servicefabric.models.DeployedApplicationHealthStateChunk]
    """

    _attribute_map = {
        'items': {'key': 'Items', 'type': '[DeployedApplicationHealthStateChunk]'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationHealthStateChunkList, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class DeployedApplicationHealthStateFilter(Model):
    """Defines matching criteria to determine whether a deployed application
    should be included as a child of an application in the cluster health
    chunk.
    The deployed applications are only returned if the parent application
    matches a filter specified in the cluster health chunk query description.
    One filter can match zero, one or multiple deployed applications, depending
    on its properties.

    :param node_name_filter: The name of the node where the application is
     deployed in order to match the filter.
     If specified, the filter is applied only to the application deployed on
     the specified node.
     If the application is not deployed on the node with the specified name, no
     deployed application is returned in the cluster health chunk based on this
     filter.
     Otherwise, the deployed application is included in the cluster health
     chunk if it respects the other filter properties.
     If not specified, all deployed applications that match the parent filters
     (if any) are taken into consideration and matched against the other filter
     members, like health state filter.
    :type node_name_filter: str
    :param health_state_filter: The filter for the health state of the
     deployed applications. It allows selecting deployed applications if they
     match the desired health states.
     The possible values are integer value of one of the following health
     states. Only deployed applications that match the filter are returned. All
     deployed applications are used to evaluate the cluster aggregated health
     state.
     If not specified, default value is None, unless the node name is
     specified. If the filter has default value and node name is specified, the
     matching deployed application is returned.
     The state values are flag-based enumeration, so the value could be a
     combination of these values obtained using bitwise 'OR' operator.
     For example, if the provided value is 6, it matches deployed applications
     with HealthState value of OK (2) and Warning (4).
     - Default - Default value. Matches any HealthState. The value is zero.
     - None - Filter that doesn't match any HealthState value. Used in order to
     return no results on a given collection of states. The value is 1.
     - Ok - Filter that matches input with HealthState value Ok. The value is
     2.
     - Warning - Filter that matches input with HealthState value Warning. The
     value is 4.
     - Error - Filter that matches input with HealthState value Error. The
     value is 8.
     - All - Filter that matches input with any HealthState value. The value is
     65535. Default value: 0 .
    :type health_state_filter: int
    :param deployed_service_package_filters: Defines a list of filters that
     specify which deployed service packages to be included in the returned
     cluster health chunk as children of the parent deployed application. The
     deployed service packages are returned only if the parent deployed
     application matches a filter.
     If the list is empty, no deployed service packages are returned. All the
     deployed service packages are used to evaluate the parent deployed
     application aggregated health state, regardless of the input filters.
     The deployed application filter may specify multiple deployed service
     package filters.
     For example, it can specify a filter to return all deployed service
     packages with health state Error and another filter to always include a
     deployed service package on a node.
    :type deployed_service_package_filters:
     list[~azure.servicefabric.models.DeployedServicePackageHealthStateFilter]
    """

    _attribute_map = {
        'node_name_filter': {'key': 'NodeNameFilter', 'type': 'str'},
        'health_state_filter': {'key': 'HealthStateFilter', 'type': 'int'},
        'deployed_service_package_filters': {'key': 'DeployedServicePackageFilters', 'type': '[DeployedServicePackageHealthStateFilter]'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationHealthStateFilter, self).__init__(**kwargs)
        self.node_name_filter = kwargs.get('node_name_filter', None)
        self.health_state_filter = kwargs.get('health_state_filter', 0)
        self.deployed_service_package_filters = kwargs.get('deployed_service_package_filters', None)


class DeployedApplicationInfo(Model):
    """Information about application deployed on the node.

    :param id: The identity of the application. This is an encoded
     representation of the application name. This is used in the REST APIs to
     identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type id: str
    :param name: The name of the application, including the 'fabric:' URI
     scheme.
    :type name: str
    :param type_name: The application type name as defined in the application
     manifest.
    :type type_name: str
    :param status: The status of the application deployed on the node.
     Following are the possible values. Possible values include: 'Invalid',
     'Downloading', 'Activating', 'Active', 'Upgrading', 'Deactivating'
    :type status: str or ~azure.servicefabric.models.DeployedApplicationStatus
    :param work_directory: The work directory of the application on the node.
     The work directory can be used to store application data.
    :type work_directory: str
    :param log_directory: The log directory of the application on the node.
     The log directory can be used to store application logs.
    :type log_directory: str
    :param temp_directory: The temp directory of the application on the node.
     The code packages belonging to the application are forked with this
     directory set as their temporary directory.
    :type temp_directory: str
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'work_directory': {'key': 'WorkDirectory', 'type': 'str'},
        'log_directory': {'key': 'LogDirectory', 'type': 'str'},
        'temp_directory': {'key': 'TempDirectory', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_name = kwargs.get('type_name', None)
        self.status = kwargs.get('status', None)
        self.work_directory = kwargs.get('work_directory', None)
        self.log_directory = kwargs.get('log_directory', None)
        self.temp_directory = kwargs.get('temp_directory', None)
        self.health_state = kwargs.get('health_state', None)


class DeployedApplicationNewHealthReportEvent(ApplicationEvent):
    """Deployed Application Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param application_instance_id: Required. Id of Application instance.
    :type application_instance_id: long
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'application_instance_id': {'required': True},
        'node_name': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'application_instance_id': {'key': 'ApplicationInstanceId', 'type': 'long'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationNewHealthReportEvent, self).__init__(**kwargs)
        self.application_instance_id = kwargs.get('application_instance_id', None)
        self.node_name = kwargs.get('node_name', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'DeployedApplicationNewHealthReport'


class DeployedApplicationsHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for deployed applications, containing health
    evaluations for each unhealthy deployed application that impacted current
    aggregated health state.
    Can be returned when evaluating application health and the aggregated
    health state is either Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param max_percent_unhealthy_deployed_applications: Maximum allowed
     percentage of unhealthy deployed applications from the
     ApplicationHealthPolicy.
    :type max_percent_unhealthy_deployed_applications: int
    :param total_count: Total number of deployed applications of the
     application in the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     DeployedApplicationHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'max_percent_unhealthy_deployed_applications': {'key': 'MaxPercentUnhealthyDeployedApplications', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(DeployedApplicationsHealthEvaluation, self).__init__(**kwargs)
        self.max_percent_unhealthy_deployed_applications = kwargs.get('max_percent_unhealthy_deployed_applications', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'DeployedApplications'


class DeployedCodePackageInfo(Model):
    """Information about code package deployed on a Service Fabric node.

    :param name: The name of the code package.
    :type name: str
    :param version: The version of the code package specified in service
     manifest.
    :type version: str
    :param service_manifest_name: The name of service manifest that specified
     this code package.
    :type service_manifest_name: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    :param host_type: Specifies the type of host for main entry point of a
     code package as specified in service manifest. Possible values include:
     'Invalid', 'ExeHost', 'ContainerHost'
    :type host_type: str or ~azure.servicefabric.models.HostType
    :param host_isolation_mode: Specifies the isolation mode of main entry
     point of a code package when it's host type is ContainerHost. This is
     specified as part of container host policies in application manifest while
     importing service manifest. Possible values include: 'None', 'Process',
     'HyperV'
    :type host_isolation_mode: str or
     ~azure.servicefabric.models.HostIsolationMode
    :param status: Specifies the status of a deployed application or service
     package on a Service Fabric node. Possible values include: 'Invalid',
     'Downloading', 'Activating', 'Active', 'Upgrading', 'Deactivating'
    :type status: str or ~azure.servicefabric.models.DeploymentStatus
    :param run_frequency_interval: The interval at which code package is run.
     This is used for periodic code package.
    :type run_frequency_interval: str
    :param setup_entry_point: Information about setup or main entry point of a
     code package deployed on a Service Fabric node.
    :type setup_entry_point: ~azure.servicefabric.models.CodePackageEntryPoint
    :param main_entry_point: Information about setup or main entry point of a
     code package deployed on a Service Fabric node.
    :type main_entry_point: ~azure.servicefabric.models.CodePackageEntryPoint
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'host_type': {'key': 'HostType', 'type': 'str'},
        'host_isolation_mode': {'key': 'HostIsolationMode', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'run_frequency_interval': {'key': 'RunFrequencyInterval', 'type': 'str'},
        'setup_entry_point': {'key': 'SetupEntryPoint', 'type': 'CodePackageEntryPoint'},
        'main_entry_point': {'key': 'MainEntryPoint', 'type': 'CodePackageEntryPoint'},
    }

    def __init__(self, **kwargs):
        super(DeployedCodePackageInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.host_type = kwargs.get('host_type', None)
        self.host_isolation_mode = kwargs.get('host_isolation_mode', None)
        self.status = kwargs.get('status', None)
        self.run_frequency_interval = kwargs.get('run_frequency_interval', None)
        self.setup_entry_point = kwargs.get('setup_entry_point', None)
        self.main_entry_point = kwargs.get('main_entry_point', None)


class DeployedServicePackageHealth(EntityHealth):
    """Information about the health of a service package for a specific
    application deployed on a Service Fabric node.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param service_manifest_name: Name of the service manifest.
    :type service_manifest_name: str
    :param node_name: Name of the node where this service package is deployed.
    :type node_name: str
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageHealth, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.node_name = kwargs.get('node_name', None)


class DeployedServicePackageHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for a deployed service package, containing
    information about the data and the algorithm used by health store to
    evaluate health. The evaluation is returned only when the aggregated health
    state is either Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param service_manifest_name: The name of the service manifest.
    :type service_manifest_name: str
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the current aggregated health state. The type of the unhealthy evaluations
     can be EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageHealthEvaluation, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.application_name = kwargs.get('application_name', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'DeployedServicePackage'


class DeployedServicePackageHealthReportExpiredEvent(ApplicationEvent):
    """Deployed Service Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param service_manifest: Required. Service manifest name.
    :type service_manifest: str
    :param service_package_instance_id: Required. Id of Service package
     instance.
    :type service_package_instance_id: long
    :param service_package_activation_id: Required. Id of Service package
     activation.
    :type service_package_activation_id: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'service_manifest': {'required': True},
        'service_package_instance_id': {'required': True},
        'service_package_activation_id': {'required': True},
        'node_name': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'service_manifest': {'key': 'ServiceManifest', 'type': 'str'},
        'service_package_instance_id': {'key': 'ServicePackageInstanceId', 'type': 'long'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageHealthReportExpiredEvent, self).__init__(**kwargs)
        self.service_manifest = kwargs.get('service_manifest', None)
        self.service_package_instance_id = kwargs.get('service_package_instance_id', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.node_name = kwargs.get('node_name', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'DeployedServicePackageHealthReportExpired'


class DeployedServicePackageHealthState(EntityHealthState):
    """Represents the health state of a deployed service package, containing the
    entity identifier and the aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param node_name: Name of the node on which the service package is
     deployed.
    :type node_name: str
    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param service_manifest_name: Name of the manifest describing the service
     package.
    :type service_manifest_name: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageHealthState, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.application_name = kwargs.get('application_name', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)


class DeployedServicePackageHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a deployed service package, which
    contains the service manifest name and the service package aggregated
    health state.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param service_manifest_name: The name of the service manifest.
    :type service_manifest_name: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageHealthStateChunk, self).__init__(**kwargs)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)


class DeployedServicePackageHealthStateChunkList(Model):
    """The list of deployed service package health state chunks that respect the
    input filters in the chunk query. Returned by get cluster health state
    chunks query.

    :param items: The list of deployed service package health state chunks
     that respect the input filters in the chunk query.
    :type items:
     list[~azure.servicefabric.models.DeployedServicePackageHealthStateChunk]
    """

    _attribute_map = {
        'items': {'key': 'Items', 'type': '[DeployedServicePackageHealthStateChunk]'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageHealthStateChunkList, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class DeployedServicePackageHealthStateFilter(Model):
    """Defines matching criteria to determine whether a deployed service package
    should be included as a child of a deployed application in the cluster
    health chunk.
    The deployed service packages are only returned if the parent entities
    match a filter specified in the cluster health chunk query description. The
    parent deployed application and its parent application must be included in
    the cluster health chunk.
    One filter can match zero, one or multiple deployed service packages,
    depending on its properties.

    :param service_manifest_name_filter: The name of the service manifest
     which identifies the deployed service packages that matches the filter.
     If specified, the filter is applied only to the specified deployed service
     packages, if any.
     If no deployed service packages with specified manifest name exist,
     nothing is returned in the cluster health chunk based on this filter.
     If any deployed service package exists, they are included in the cluster
     health chunk if it respects the other filter properties.
     If not specified, all deployed service packages that match the parent
     filters (if any) are taken into consideration and matched against the
     other filter members, like health state filter.
    :type service_manifest_name_filter: str
    :param service_package_activation_id_filter: The activation ID of a
     deployed service package that matches the filter.
     If not specified, the filter applies to all deployed service packages that
     match the other parameters.
     If specified, the filter matches only the deployed service package with
     the specified activation ID.
    :type service_package_activation_id_filter: str
    :param health_state_filter: The filter for the health state of the
     deployed service packages. It allows selecting deployed service packages
     if they match the desired health states.
     The possible values are integer value of one of the following health
     states. Only deployed service packages that match the filter are returned.
     All deployed service packages are used to evaluate the parent deployed
     application aggregated health state.
     If not specified, default value is None, unless the deployed service
     package ID is specified. If the filter has default value and deployed
     service package ID is specified, the matching deployed service package is
     returned.
     The state values are flag-based enumeration, so the value could be a
     combination of these values obtained using bitwise 'OR' operator.
     For example, if the provided value is 6, it matches deployed service
     packages with HealthState value of OK (2) and Warning (4).
     - Default - Default value. Matches any HealthState. The value is zero.
     - None - Filter that doesn't match any HealthState value. Used in order to
     return no results on a given collection of states. The value is 1.
     - Ok - Filter that matches input with HealthState value Ok. The value is
     2.
     - Warning - Filter that matches input with HealthState value Warning. The
     value is 4.
     - Error - Filter that matches input with HealthState value Error. The
     value is 8.
     - All - Filter that matches input with any HealthState value. The value is
     65535. Default value: 0 .
    :type health_state_filter: int
    """

    _attribute_map = {
        'service_manifest_name_filter': {'key': 'ServiceManifestNameFilter', 'type': 'str'},
        'service_package_activation_id_filter': {'key': 'ServicePackageActivationIdFilter', 'type': 'str'},
        'health_state_filter': {'key': 'HealthStateFilter', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageHealthStateFilter, self).__init__(**kwargs)
        self.service_manifest_name_filter = kwargs.get('service_manifest_name_filter', None)
        self.service_package_activation_id_filter = kwargs.get('service_package_activation_id_filter', None)
        self.health_state_filter = kwargs.get('health_state_filter', 0)


class DeployedServicePackageInfo(Model):
    """Information about service package deployed on a Service Fabric node.

    :param name: The name of the service package as specified in the service
     manifest.
    :type name: str
    :param version: The version of the service package specified in service
     manifest.
    :type version: str
    :param status: Specifies the status of a deployed application or service
     package on a Service Fabric node. Possible values include: 'Invalid',
     'Downloading', 'Activating', 'Active', 'Upgrading', 'Deactivating'
    :type status: str or ~azure.servicefabric.models.DeploymentStatus
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)
        self.status = kwargs.get('status', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)


class DeployedServicePackageNewHealthReportEvent(ApplicationEvent):
    """Deployed Service Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_id: Required. The identity of the application. This is
     an encoded representation of the application name. This is used in the
     REST APIs to identify the application resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the application name is "fabric:/myapp/app1",
     the application identity would be "myapp\\~app1" in 6.0+ and "myapp/app1"
     in previous versions.
    :type application_id: str
    :param service_manifest_name: Required. Service manifest name.
    :type service_manifest_name: str
    :param service_package_instance_id: Required. Id of Service package
     instance.
    :type service_package_instance_id: long
    :param service_package_activation_id: Required. Id of Service package
     activation.
    :type service_package_activation_id: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'application_id': {'required': True},
        'service_manifest_name': {'required': True},
        'service_package_instance_id': {'required': True},
        'service_package_activation_id': {'required': True},
        'node_name': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_id': {'key': 'ApplicationId', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'service_package_instance_id': {'key': 'ServicePackageInstanceId', 'type': 'long'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackageNewHealthReportEvent, self).__init__(**kwargs)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.service_package_instance_id = kwargs.get('service_package_instance_id', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.node_name = kwargs.get('node_name', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'DeployedServicePackageNewHealthReport'


class DeployedServicePackagesHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for deployed service packages, containing
    health evaluations for each unhealthy deployed service package that
    impacted current aggregated health state. Can be returned when evaluating
    deployed application health and the aggregated health state is either Error
    or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param total_count: Total number of deployed service packages of the
     deployed application in the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     DeployedServicePackageHealthEvaluation that impacted the aggregated
     health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(DeployedServicePackagesHealthEvaluation, self).__init__(**kwargs)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'DeployedServicePackages'


class DeployedServiceReplicaDetailInfo(Model):
    """Information about a Service Fabric service replica deployed on a node.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeployedStatefulServiceReplicaDetailInfo,
    DeployedStatelessServiceInstanceDetailInfo

    All required parameters must be populated in order to send to Azure.

    :param service_name: Full hierarchical name of the service in URI format
     starting with `fabric:`.
    :type service_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition ID is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     IDs of its partitions would be different.
    :type partition_id: str
    :param current_service_operation: Specifies the current active life-cycle
     operation on a stateful service replica or stateless service instance.
     Possible values include: 'Unknown', 'None', 'Open', 'ChangeRole', 'Close',
     'Abort'
    :type current_service_operation: str or
     ~azure.servicefabric.models.ServiceOperationName
    :param current_service_operation_start_time_utc: The start time of the
     current service operation in UTC format.
    :type current_service_operation_start_time_utc: datetime
    :param reported_load: List of load reported by replica.
    :type reported_load:
     list[~azure.servicefabric.models.LoadMetricReportInfo]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'current_service_operation': {'key': 'CurrentServiceOperation', 'type': 'str'},
        'current_service_operation_start_time_utc': {'key': 'CurrentServiceOperationStartTimeUtc', 'type': 'iso-8601'},
        'reported_load': {'key': 'ReportedLoad', 'type': '[LoadMetricReportInfo]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'DeployedStatefulServiceReplicaDetailInfo', 'Stateless': 'DeployedStatelessServiceInstanceDetailInfo'}
    }

    def __init__(self, **kwargs):
        super(DeployedServiceReplicaDetailInfo, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.partition_id = kwargs.get('partition_id', None)
        self.current_service_operation = kwargs.get('current_service_operation', None)
        self.current_service_operation_start_time_utc = kwargs.get('current_service_operation_start_time_utc', None)
        self.reported_load = kwargs.get('reported_load', None)
        self.service_kind = None


class DeployedServiceReplicaInfo(Model):
    """Information about a Service Fabric service replica deployed on a node.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeployedStatefulServiceReplicaInfo,
    DeployedStatelessServiceInstanceInfo

    All required parameters must be populated in order to send to Azure.

    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param service_manifest_name: The name of the service manifest in which
     this service type is defined.
    :type service_manifest_name: str
    :param code_package_name: The name of the code package that hosts this
     replica.
    :type code_package_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition ID is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     IDs of its partitions would be different.
    :type partition_id: str
    :param replica_status: The status of a replica of a service. Possible
     values include: 'Invalid', 'InBuild', 'Standby', 'Ready', 'Down',
     'Dropped'
    :type replica_status: str or ~azure.servicefabric.models.ReplicaStatus
    :param address: The last address returned by the replica in Open or
     ChangeRole.
    :type address: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    :param host_process_id: Host process ID of the process that is hosting the
     replica. This will be zero if the replica is down. In hyper-v containers
     this host process ID will be from different kernel.
    :type host_process_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'host_process_id': {'key': 'HostProcessId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'DeployedStatefulServiceReplicaInfo', 'Stateless': 'DeployedStatelessServiceInstanceInfo'}
    }

    def __init__(self, **kwargs):
        super(DeployedServiceReplicaInfo, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.code_package_name = kwargs.get('code_package_name', None)
        self.partition_id = kwargs.get('partition_id', None)
        self.replica_status = kwargs.get('replica_status', None)
        self.address = kwargs.get('address', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.host_process_id = kwargs.get('host_process_id', None)
        self.service_kind = None


class DeployedServiceTypeInfo(Model):
    """Information about service type deployed on a node, information such as the
    status of the service type registration on a node.

    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param service_manifest_name: The name of the service manifest in which
     this service type is defined.
    :type service_manifest_name: str
    :param code_package_name: The name of the code package that registered the
     service type.
    :type code_package_name: str
    :param status: The status of the service type registration on the node.
     Possible values include: 'Invalid', 'Disabled', 'Enabled', 'Registered'
    :type status: str or
     ~azure.servicefabric.models.ServiceTypeRegistrationStatus
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    """

    _attribute_map = {
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedServiceTypeInfo, self).__init__(**kwargs)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.code_package_name = kwargs.get('code_package_name', None)
        self.status = kwargs.get('status', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)


class DeployedStatefulServiceReplicaDetailInfo(DeployedServiceReplicaDetailInfo):
    """Information about a stateful replica running in a code package. Note
    DeployedServiceReplicaQueryResult will contain duplicate data like
    ServiceKind, ServiceName, PartitionId and replicaId.

    All required parameters must be populated in order to send to Azure.

    :param service_name: Full hierarchical name of the service in URI format
     starting with `fabric:`.
    :type service_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition ID is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     IDs of its partitions would be different.
    :type partition_id: str
    :param current_service_operation: Specifies the current active life-cycle
     operation on a stateful service replica or stateless service instance.
     Possible values include: 'Unknown', 'None', 'Open', 'ChangeRole', 'Close',
     'Abort'
    :type current_service_operation: str or
     ~azure.servicefabric.models.ServiceOperationName
    :param current_service_operation_start_time_utc: The start time of the
     current service operation in UTC format.
    :type current_service_operation_start_time_utc: datetime
    :param reported_load: List of load reported by replica.
    :type reported_load:
     list[~azure.servicefabric.models.LoadMetricReportInfo]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param replica_id: Id of a stateful service replica. ReplicaId is used by
     Service Fabric to uniquely identify a replica of a partition. It is unique
     within a partition and does not change for the lifetime of the replica. If
     a replica gets dropped and another replica gets created on the same node
     for the same partition, it will get a different value for the id.
     Sometimes the id of a stateless service instance is also referred as a
     replica id.
    :type replica_id: str
    :param current_replicator_operation: Specifies the operation currently
     being executed by the Replicator. Possible values include: 'Invalid',
     'None', 'Open', 'ChangeRole', 'UpdateEpoch', 'Close', 'Abort',
     'OnDataLoss', 'WaitForCatchup', 'Build'
    :type current_replicator_operation: str or
     ~azure.servicefabric.models.ReplicatorOperationName
    :param read_status: Specifies the access status of the partition. Possible
     values include: 'Invalid', 'Granted', 'ReconfigurationPending',
     'NotPrimary', 'NoWriteQuorum'
    :type read_status: str or
     ~azure.servicefabric.models.PartitionAccessStatus
    :param write_status: Specifies the access status of the partition.
     Possible values include: 'Invalid', 'Granted', 'ReconfigurationPending',
     'NotPrimary', 'NoWriteQuorum'
    :type write_status: str or
     ~azure.servicefabric.models.PartitionAccessStatus
    :param replicator_status: Represents a base class for primary or secondary
     replicator status.
     Contains information about the service fabric replicator like the
     replication/copy queue utilization, last acknowledgement received
     timestamp, etc.
    :type replicator_status: ~azure.servicefabric.models.ReplicatorStatus
    :param replica_status: Key value store related information for the
     replica.
    :type replica_status:
     ~azure.servicefabric.models.KeyValueStoreReplicaStatus
    :param deployed_service_replica_query_result: Information about a stateful
     service replica deployed on a node.
    :type deployed_service_replica_query_result:
     ~azure.servicefabric.models.DeployedStatefulServiceReplicaInfo
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'current_service_operation': {'key': 'CurrentServiceOperation', 'type': 'str'},
        'current_service_operation_start_time_utc': {'key': 'CurrentServiceOperationStartTimeUtc', 'type': 'iso-8601'},
        'reported_load': {'key': 'ReportedLoad', 'type': '[LoadMetricReportInfo]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
        'current_replicator_operation': {'key': 'CurrentReplicatorOperation', 'type': 'str'},
        'read_status': {'key': 'ReadStatus', 'type': 'str'},
        'write_status': {'key': 'WriteStatus', 'type': 'str'},
        'replicator_status': {'key': 'ReplicatorStatus', 'type': 'ReplicatorStatus'},
        'replica_status': {'key': 'ReplicaStatus', 'type': 'KeyValueStoreReplicaStatus'},
        'deployed_service_replica_query_result': {'key': 'DeployedServiceReplicaQueryResult', 'type': 'DeployedStatefulServiceReplicaInfo'},
    }

    def __init__(self, **kwargs):
        super(DeployedStatefulServiceReplicaDetailInfo, self).__init__(**kwargs)
        self.replica_id = kwargs.get('replica_id', None)
        self.current_replicator_operation = kwargs.get('current_replicator_operation', None)
        self.read_status = kwargs.get('read_status', None)
        self.write_status = kwargs.get('write_status', None)
        self.replicator_status = kwargs.get('replicator_status', None)
        self.replica_status = kwargs.get('replica_status', None)
        self.deployed_service_replica_query_result = kwargs.get('deployed_service_replica_query_result', None)
        self.service_kind = 'Stateful'


class DeployedStatefulServiceReplicaInfo(DeployedServiceReplicaInfo):
    """Information about a stateful service replica deployed on a node.

    All required parameters must be populated in order to send to Azure.

    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param service_manifest_name: The name of the service manifest in which
     this service type is defined.
    :type service_manifest_name: str
    :param code_package_name: The name of the code package that hosts this
     replica.
    :type code_package_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition ID is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     IDs of its partitions would be different.
    :type partition_id: str
    :param replica_status: The status of a replica of a service. Possible
     values include: 'Invalid', 'InBuild', 'Standby', 'Ready', 'Down',
     'Dropped'
    :type replica_status: str or ~azure.servicefabric.models.ReplicaStatus
    :param address: The last address returned by the replica in Open or
     ChangeRole.
    :type address: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    :param host_process_id: Host process ID of the process that is hosting the
     replica. This will be zero if the replica is down. In hyper-v containers
     this host process ID will be from different kernel.
    :type host_process_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param replica_id: Id of a stateful service replica. ReplicaId is used by
     Service Fabric to uniquely identify a replica of a partition. It is unique
     within a partition and does not change for the lifetime of the replica. If
     a replica gets dropped and another replica gets created on the same node
     for the same partition, it will get a different value for the id.
     Sometimes the id of a stateless service instance is also referred as a
     replica id.
    :type replica_id: str
    :param replica_role: The role of a replica of a stateful service. Possible
     values include: 'Unknown', 'None', 'Primary', 'IdleSecondary',
     'ActiveSecondary'
    :type replica_role: str or ~azure.servicefabric.models.ReplicaRole
    :param reconfiguration_information: Information about current
     reconfiguration like phase, type, previous configuration role of replica
     and reconfiguration start date time.
    :type reconfiguration_information:
     ~azure.servicefabric.models.ReconfigurationInformation
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'host_process_id': {'key': 'HostProcessId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
        'replica_role': {'key': 'ReplicaRole', 'type': 'str'},
        'reconfiguration_information': {'key': 'ReconfigurationInformation', 'type': 'ReconfigurationInformation'},
    }

    def __init__(self, **kwargs):
        super(DeployedStatefulServiceReplicaInfo, self).__init__(**kwargs)
        self.replica_id = kwargs.get('replica_id', None)
        self.replica_role = kwargs.get('replica_role', None)
        self.reconfiguration_information = kwargs.get('reconfiguration_information', None)
        self.service_kind = 'Stateful'


class DeployedStatelessServiceInstanceDetailInfo(DeployedServiceReplicaDetailInfo):
    """Information about a stateless instance running in a code package. Note that
    DeployedServiceReplicaQueryResult will contain duplicate data like
    ServiceKind, ServiceName, PartitionId and InstanceId.

    All required parameters must be populated in order to send to Azure.

    :param service_name: Full hierarchical name of the service in URI format
     starting with `fabric:`.
    :type service_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition ID is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     IDs of its partitions would be different.
    :type partition_id: str
    :param current_service_operation: Specifies the current active life-cycle
     operation on a stateful service replica or stateless service instance.
     Possible values include: 'Unknown', 'None', 'Open', 'ChangeRole', 'Close',
     'Abort'
    :type current_service_operation: str or
     ~azure.servicefabric.models.ServiceOperationName
    :param current_service_operation_start_time_utc: The start time of the
     current service operation in UTC format.
    :type current_service_operation_start_time_utc: datetime
    :param reported_load: List of load reported by replica.
    :type reported_load:
     list[~azure.servicefabric.models.LoadMetricReportInfo]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param instance_id: Id of a stateless service instance. InstanceId is used
     by Service Fabric to uniquely identify an instance of a partition of a
     stateless service. It is unique within a partition and does not change for
     the lifetime of the instance. If the instance has failed over on the same
     or different node, it will get a different value for the InstanceId.
    :type instance_id: str
    :param deployed_service_replica_query_result: Information about a
     stateless service instance deployed on a node.
    :type deployed_service_replica_query_result:
     ~azure.servicefabric.models.DeployedStatelessServiceInstanceInfo
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'current_service_operation': {'key': 'CurrentServiceOperation', 'type': 'str'},
        'current_service_operation_start_time_utc': {'key': 'CurrentServiceOperationStartTimeUtc', 'type': 'iso-8601'},
        'reported_load': {'key': 'ReportedLoad', 'type': '[LoadMetricReportInfo]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_id': {'key': 'InstanceId', 'type': 'str'},
        'deployed_service_replica_query_result': {'key': 'DeployedServiceReplicaQueryResult', 'type': 'DeployedStatelessServiceInstanceInfo'},
    }

    def __init__(self, **kwargs):
        super(DeployedStatelessServiceInstanceDetailInfo, self).__init__(**kwargs)
        self.instance_id = kwargs.get('instance_id', None)
        self.deployed_service_replica_query_result = kwargs.get('deployed_service_replica_query_result', None)
        self.service_kind = 'Stateless'


class DeployedStatelessServiceInstanceInfo(DeployedServiceReplicaInfo):
    """Information about a stateless service instance deployed on a node.

    All required parameters must be populated in order to send to Azure.

    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param service_manifest_name: The name of the service manifest in which
     this service type is defined.
    :type service_manifest_name: str
    :param code_package_name: The name of the code package that hosts this
     replica.
    :type code_package_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition ID is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     IDs of its partitions would be different.
    :type partition_id: str
    :param replica_status: The status of a replica of a service. Possible
     values include: 'Invalid', 'InBuild', 'Standby', 'Ready', 'Down',
     'Dropped'
    :type replica_status: str or ~azure.servicefabric.models.ReplicaStatus
    :param address: The last address returned by the replica in Open or
     ChangeRole.
    :type address: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    :param host_process_id: Host process ID of the process that is hosting the
     replica. This will be zero if the replica is down. In hyper-v containers
     this host process ID will be from different kernel.
    :type host_process_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param instance_id: Id of a stateless service instance. InstanceId is used
     by Service Fabric to uniquely identify an instance of a partition of a
     stateless service. It is unique within a partition and does not change for
     the lifetime of the instance. If the instance has failed over on the same
     or different node, it will get a different value for the InstanceId.
    :type instance_id: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'host_process_id': {'key': 'HostProcessId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_id': {'key': 'InstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeployedStatelessServiceInstanceInfo, self).__init__(**kwargs)
        self.instance_id = kwargs.get('instance_id', None)
        self.service_kind = 'Stateless'


class DeployServicePackageToNodeDescription(Model):
    """Defines description for downloading packages associated with a service
    manifest to image cache on a Service Fabric node.

    All required parameters must be populated in order to send to Azure.

    :param service_manifest_name: Required. The name of service manifest whose
     packages need to be downloaded.
    :type service_manifest_name: str
    :param application_type_name: Required. The application type name as
     defined in the application manifest.
    :type application_type_name: str
    :param application_type_version: Required. The version of the application
     type as defined in the application manifest.
    :type application_type_version: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param package_sharing_policy: List of package sharing policy information.
    :type package_sharing_policy:
     list[~azure.servicefabric.models.PackageSharingPolicyInfo]
    """

    _validation = {
        'service_manifest_name': {'required': True},
        'application_type_name': {'required': True},
        'application_type_version': {'required': True},
        'node_name': {'required': True},
    }

    _attribute_map = {
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'package_sharing_policy': {'key': 'PackageSharingPolicy', 'type': '[PackageSharingPolicyInfo]'},
    }

    def __init__(self, **kwargs):
        super(DeployServicePackageToNodeDescription, self).__init__(**kwargs)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.node_name = kwargs.get('node_name', None)
        self.package_sharing_policy = kwargs.get('package_sharing_policy', None)


class DiagnosticsDescription(Model):
    """Describes the diagnostics options available.

    :param sinks: List of supported sinks that can be referenced.
    :type sinks: list[~azure.servicefabric.models.DiagnosticsSinkProperties]
    :param enabled: Status of whether or not sinks are enabled.
    :type enabled: bool
    :param default_sink_refs: The sinks to be used if diagnostics is enabled.
     Sink choices can be overridden at the service and code package level.
    :type default_sink_refs: list[str]
    """

    _attribute_map = {
        'sinks': {'key': 'sinks', 'type': '[DiagnosticsSinkProperties]'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'default_sink_refs': {'key': 'defaultSinkRefs', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DiagnosticsDescription, self).__init__(**kwargs)
        self.sinks = kwargs.get('sinks', None)
        self.enabled = kwargs.get('enabled', None)
        self.default_sink_refs = kwargs.get('default_sink_refs', None)


class DiagnosticsRef(Model):
    """Reference to sinks in DiagnosticsDescription.

    :param enabled: Status of whether or not sinks are enabled.
    :type enabled: bool
    :param sink_refs: List of sinks to be used if enabled. References the list
     of sinks in DiagnosticsDescription.
    :type sink_refs: list[str]
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'sink_refs': {'key': 'sinkRefs', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DiagnosticsRef, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.sink_refs = kwargs.get('sink_refs', None)


class DisableBackupDescription(Model):
    """It describes the body parameters while disabling backup of a backup
    entity(Application/Service/Partition).

    All required parameters must be populated in order to send to Azure.

    :param clean_backup: Required. Boolean flag to delete backups. It can be
     set to true for deleting all the backups which were created for the backup
     entity that is getting disabled for backup.
    :type clean_backup: bool
    """

    _validation = {
        'clean_backup': {'required': True},
    }

    _attribute_map = {
        'clean_backup': {'key': 'CleanBackup', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(DisableBackupDescription, self).__init__(**kwargs)
        self.clean_backup = kwargs.get('clean_backup', None)


class DoublePropertyValue(PropertyValue):
    """Describes a Service Fabric property value of type Double.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param data: Required. The data of the property value.
    :type data: float
    """

    _validation = {
        'kind': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'data': {'key': 'Data', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(DoublePropertyValue, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.kind = 'Double'


class EnableBackupDescription(Model):
    """Specifies the parameters needed to enable periodic backup.

    All required parameters must be populated in order to send to Azure.

    :param backup_policy_name: Required. Name of the backup policy to be used
     for enabling periodic backups.
    :type backup_policy_name: str
    """

    _validation = {
        'backup_policy_name': {'required': True},
    }

    _attribute_map = {
        'backup_policy_name': {'key': 'BackupPolicyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnableBackupDescription, self).__init__(**kwargs)
        self.backup_policy_name = kwargs.get('backup_policy_name', None)


class EndpointProperties(Model):
    """Describes a container endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the endpoint.
    :type name: str
    :param port: Port used by the container.
    :type port: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(EndpointProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.port = kwargs.get('port', None)


class EndpointRef(Model):
    """Describes a reference to a service endpoint.

    :param name: Name of the endpoint.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EndpointRef, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class SafetyCheck(Model):
    """Represents a safety check performed by service fabric before continuing
    with the operations. These checks ensure the availability of the service
    and the reliability of the state.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartitionSafetyCheck, SeedNodeSafetyCheck

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'PartitionSafetyCheck': 'PartitionSafetyCheck', 'EnsureSeedNodeQuorum': 'SeedNodeSafetyCheck'}
    }

    def __init__(self, **kwargs):
        super(SafetyCheck, self).__init__(**kwargs)
        self.kind = None


class PartitionSafetyCheck(SafetyCheck):
    """Represents a safety check for the service partition being performed by
    service fabric before continuing with operations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EnsureAvailabilitySafetyCheck,
    EnsurePartitionQuorumSafetyCheck, WaitForInbuildReplicaSafetyCheck,
    WaitForPrimaryPlacementSafetyCheck, WaitForPrimarySwapSafetyCheck,
    WaitForReconfigurationSafetyCheck

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition which is undergoing the safety
     check.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'EnsureAvailability': 'EnsureAvailabilitySafetyCheck', 'EnsurePartitionQuorum': 'EnsurePartitionQuorumSafetyCheck', 'WaitForInbuildReplica': 'WaitForInbuildReplicaSafetyCheck', 'WaitForPrimaryPlacement': 'WaitForPrimaryPlacementSafetyCheck', 'WaitForPrimarySwap': 'WaitForPrimarySwapSafetyCheck', 'WaitForReconfiguration': 'WaitForReconfigurationSafetyCheck'}
    }

    def __init__(self, **kwargs):
        super(PartitionSafetyCheck, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.kind = 'PartitionSafetyCheck'


class EnsureAvailabilitySafetyCheck(PartitionSafetyCheck):
    """Safety check that waits to ensure the availability of the partition. It
    waits until there are replicas available such that bringing down this
    replica will not cause availability loss for the partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition which is undergoing the safety
     check.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnsureAvailabilitySafetyCheck, self).__init__(**kwargs)
        self.kind = 'EnsureAvailability'


class EnsurePartitionQuorumSafetyCheck(PartitionSafetyCheck):
    """Safety check that ensures that a quorum of replicas are not lost for a
    partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition which is undergoing the safety
     check.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnsurePartitionQuorumSafetyCheck, self).__init__(**kwargs)
        self.kind = 'EnsurePartitionQuorum'


class EntityKindHealthStateCount(Model):
    """Represents health state count for entities of the specified entity kind.

    :param entity_kind: The entity kind for which health states are evaluated.
     Possible values include: 'Invalid', 'Node', 'Partition', 'Service',
     'Application', 'Replica', 'DeployedApplication', 'DeployedServicePackage',
     'Cluster'
    :type entity_kind: str or ~azure.servicefabric.models.EntityKind
    :param health_state_count: The health state count for the entities of the
     specified kind.
    :type health_state_count: ~azure.servicefabric.models.HealthStateCount
    """

    _attribute_map = {
        'entity_kind': {'key': 'EntityKind', 'type': 'str'},
        'health_state_count': {'key': 'HealthStateCount', 'type': 'HealthStateCount'},
    }

    def __init__(self, **kwargs):
        super(EntityKindHealthStateCount, self).__init__(**kwargs)
        self.entity_kind = kwargs.get('entity_kind', None)
        self.health_state_count = kwargs.get('health_state_count', None)


class EnvironmentVariable(Model):
    """Describes an environment variable for the container.

    :param name: The name of the environment variable.
    :type name: str
    :param value: The value of the environment variable.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentVariable, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class Epoch(Model):
    """An Epoch is a configuration number for the partition as a whole. When the
    configuration of the replica set changes, for example when the Primary
    replica changes, the operations that are replicated from the new Primary
    replica are said to be a new Epoch from the ones which were sent by the old
    Primary replica.

    :param configuration_version: The current configuration number of this
     Epoch. The configuration number is an increasing value that is updated
     whenever the configuration of this replica set changes.
    :type configuration_version: str
    :param data_loss_version: The current data loss number of this Epoch. The
     data loss number property is an increasing value which is updated whenever
     data loss is suspected, as when loss of a quorum of replicas in the
     replica set that includes the Primary replica.
    :type data_loss_version: str
    """

    _attribute_map = {
        'configuration_version': {'key': 'ConfigurationVersion', 'type': 'str'},
        'data_loss_version': {'key': 'DataLossVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Epoch, self).__init__(**kwargs)
        self.configuration_version = kwargs.get('configuration_version', None)
        self.data_loss_version = kwargs.get('data_loss_version', None)


class EventHealthEvaluation(HealthEvaluation):
    """Represents health evaluation of a HealthEvent that was reported on the
    entity.
    The health evaluation is returned when evaluating health of an entity
    results in Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param consider_warning_as_error: Indicates whether warnings are treated
     with the same severity as errors. The field is specified in the health
     policy used to evaluate the entity.
    :type consider_warning_as_error: bool
    :param unhealthy_event: Represents health information reported on a health
     entity, such as cluster, application or node, with additional metadata
     added by the Health Manager.
    :type unhealthy_event: ~azure.servicefabric.models.HealthEvent
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'consider_warning_as_error': {'key': 'ConsiderWarningAsError', 'type': 'bool'},
        'unhealthy_event': {'key': 'UnhealthyEvent', 'type': 'HealthEvent'},
    }

    def __init__(self, **kwargs):
        super(EventHealthEvaluation, self).__init__(**kwargs)
        self.consider_warning_as_error = kwargs.get('consider_warning_as_error', None)
        self.unhealthy_event = kwargs.get('unhealthy_event', None)
        self.kind = 'Event'


class ExecutingFaultsChaosEvent(ChaosEvent):
    """Describes a Chaos event that gets generated when Chaos has decided on the
    faults for an iteration. This Chaos event contains the details of the
    faults as a list of strings.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp_utc: Required. The UTC timestamp when this Chaos event
     was generated.
    :type time_stamp_utc: datetime
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param faults: List of string description of the faults that Chaos decided
     to execute in an iteration.
    :type faults: list[str]
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'faults': {'key': 'Faults', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ExecutingFaultsChaosEvent, self).__init__(**kwargs)
        self.faults = kwargs.get('faults', None)
        self.kind = 'ExecutingFaults'


class ProvisionApplicationTypeDescriptionBase(Model):
    """Represents the type of registration or provision requested, and if the
    operation needs to be asynchronous or not. Supported types of provision
    operations are from either image store or external store.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ProvisionApplicationTypeDescription,
    ExternalStoreProvisionApplicationTypeDescription

    All required parameters must be populated in order to send to Azure.

    :param async_property: Required. Indicates whether or not provisioning
     should occur asynchronously. When set to true, the provision operation
     returns when the request is accepted by the system, and the provision
     operation continues without any timeout limit. The default value is false.
     For large application packages, we recommend setting the value to true.
    :type async_property: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'async_property': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'async_property': {'key': 'Async', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ImageStorePath': 'ProvisionApplicationTypeDescription', 'ExternalStore': 'ExternalStoreProvisionApplicationTypeDescription'}
    }

    def __init__(self, **kwargs):
        super(ProvisionApplicationTypeDescriptionBase, self).__init__(**kwargs)
        self.async_property = kwargs.get('async_property', None)
        self.kind = None


class ExternalStoreProvisionApplicationTypeDescription(ProvisionApplicationTypeDescriptionBase):
    """Describes the operation to register or provision an application type using
    an application package from an external store instead of a package uploaded
    to the Service Fabric image store.

    All required parameters must be populated in order to send to Azure.

    :param async_property: Required. Indicates whether or not provisioning
     should occur asynchronously. When set to true, the provision operation
     returns when the request is accepted by the system, and the provision
     operation continues without any timeout limit. The default value is false.
     For large application packages, we recommend setting the value to true.
    :type async_property: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_package_download_uri: Required. The path to the
     '.sfpkg' application package from where the application package can be
     downloaded using HTTP or HTTPS protocols. The application package can be
     stored in an external store that provides GET operation to download the
     file. Supported protocols are HTTP and HTTPS, and the path must allow READ
     access.
    :type application_package_download_uri: str
    :param application_type_name: Required. The application type name
     represents the name of the application type found in the application
     manifest.
    :type application_type_name: str
    :param application_type_version: Required. The application type version
     represents the version of the application type found in the application
     manifest.
    :type application_type_version: str
    """

    _validation = {
        'async_property': {'required': True},
        'kind': {'required': True},
        'application_package_download_uri': {'required': True},
        'application_type_name': {'required': True},
        'application_type_version': {'required': True},
    }

    _attribute_map = {
        'async_property': {'key': 'Async', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_package_download_uri': {'key': 'ApplicationPackageDownloadUri', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExternalStoreProvisionApplicationTypeDescription, self).__init__(**kwargs)
        self.application_package_download_uri = kwargs.get('application_package_download_uri', None)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.kind = 'ExternalStore'


class FabricCodeVersionInfo(Model):
    """Information about a Service Fabric code version.

    :param code_version: The product version of Service Fabric.
    :type code_version: str
    """

    _attribute_map = {
        'code_version': {'key': 'CodeVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FabricCodeVersionInfo, self).__init__(**kwargs)
        self.code_version = kwargs.get('code_version', None)


class FabricConfigVersionInfo(Model):
    """Information about a Service Fabric config version.

    :param config_version: The config version of Service Fabric.
    :type config_version: str
    """

    _attribute_map = {
        'config_version': {'key': 'ConfigVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FabricConfigVersionInfo, self).__init__(**kwargs)
        self.config_version = kwargs.get('config_version', None)


class FabricError(Model):
    """The REST API operations for Service Fabric return standard HTTP status
    codes. This type defines the additional information returned from the
    Service Fabric API operations that are not successful.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. Error object containing error code and error
     message.
    :type error: ~azure.servicefabric.models.FabricErrorError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'Error', 'type': 'FabricErrorError'},
    }

    def __init__(self, **kwargs):
        super(FabricError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class FabricErrorException(HttpOperationError):
    """Server responsed with exception of type: 'FabricError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(FabricErrorException, self).__init__(deserialize, response, 'FabricError', *args)


class FabricErrorError(Model):
    """Error object containing error code and error message.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Defines the fabric error codes that be returned as
     part of the error object in response to Service Fabric API operations that
     are not successful. Following are the error code values that can be
     returned for a specific HTTP status code.
     - Possible values of the error code for HTTP status code 400 (Bad Request)
     - "FABRIC_E_INVALID_PARTITION_KEY"
     - "FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR"
     - "FABRIC_E_INVALID_ADDRESS"
     - "FABRIC_E_APPLICATION_NOT_UPGRADING"
     - "FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR"
     - "FABRIC_E_FABRIC_NOT_UPGRADING"
     - "FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR"
     - "FABRIC_E_INVALID_CONFIGURATION"
     - "FABRIC_E_INVALID_NAME_URI"
     - "FABRIC_E_PATH_TOO_LONG"
     - "FABRIC_E_KEY_TOO_LARGE"
     - "FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED"
     - "FABRIC_E_INVALID_ATOMIC_GROUP"
     - "FABRIC_E_VALUE_EMPTY"
     - "FABRIC_E_BACKUP_IS_ENABLED"
     - "FABRIC_E_RESTORE_SOURCE_TARGET_PARTITION_MISMATCH"
     - "FABRIC_E_INVALID_FOR_STATELESS_SERVICES"
     - "FABRIC_E_INVALID_SERVICE_SCALING_POLICY"
     - "E_INVALIDARG"
     - Possible values of the error code for HTTP status code 404 (Not Found)
     - "FABRIC_E_NODE_NOT_FOUND"
     - "FABRIC_E_APPLICATION_TYPE_NOT_FOUND"
     - "FABRIC_E_APPLICATION_NOT_FOUND"
     - "FABRIC_E_SERVICE_TYPE_NOT_FOUND"
     - "FABRIC_E_SERVICE_DOES_NOT_EXIST"
     - "FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND"
     - "FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND"
     - "FABRIC_E_PARTITION_NOT_FOUND"
     - "FABRIC_E_REPLICA_DOES_NOT_EXIST"
     - "FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST"
     - "FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND"
     - "FABRIC_E_DIRECTORY_NOT_FOUND"
     - "FABRIC_E_FABRIC_VERSION_NOT_FOUND"
     - "FABRIC_E_FILE_NOT_FOUND"
     - "FABRIC_E_NAME_DOES_NOT_EXIST"
     - "FABRIC_E_PROPERTY_DOES_NOT_EXIST"
     - "FABRIC_E_ENUMERATION_COMPLETED"
     - "FABRIC_E_SERVICE_MANIFEST_NOT_FOUND"
     - "FABRIC_E_KEY_NOT_FOUND"
     - "FABRIC_E_HEALTH_ENTITY_NOT_FOUND"
     - "FABRIC_E_BACKUP_NOT_ENABLED"
     - "FABRIC_E_BACKUP_POLICY_NOT_EXISTING"
     - "FABRIC_E_FAULT_ANALYSIS_SERVICE_NOT_EXISTING"
     - "FABRIC_E_IMAGEBUILDER_RESERVED_DIRECTORY_ERROR"
     - Possible values of the error code for HTTP status code 409 (Conflict)
     - "FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS"
     - "FABRIC_E_APPLICATION_ALREADY_EXISTS"
     - "FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION"
     - "FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS"
     - "FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS"
     - "FABRIC_E_SERVICE_ALREADY_EXISTS"
     - "FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS"
     - "FABRIC_E_APPLICATION_TYPE_IN_USE"
     - "FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION"
     - "FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS"
     - "FABRIC_E_FABRIC_VERSION_IN_USE"
     - "FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS"
     - "FABRIC_E_NAME_ALREADY_EXISTS"
     - "FABRIC_E_NAME_NOT_EMPTY"
     - "FABRIC_E_PROPERTY_CHECK_FAILED"
     - "FABRIC_E_SERVICE_METADATA_MISMATCH"
     - "FABRIC_E_SERVICE_TYPE_MISMATCH"
     - "FABRIC_E_HEALTH_STALE_REPORT"
     - "FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED"
     - "FABRIC_E_NODE_HAS_NOT_STOPPED_YET"
     - "FABRIC_E_INSTANCE_ID_MISMATCH"
     - "FABRIC_E_BACKUP_IN_PROGRESS"
     - "FABRIC_E_RESTORE_IN_PROGRESS"
     - "FABRIC_E_BACKUP_POLICY_ALREADY_EXISTING"
     - Possible values of the error code for HTTP status code 413 (Request
     Entity Too Large)
     - "FABRIC_E_VALUE_TOO_LARGE"
     - Possible values of the error code for HTTP status code 500 (Internal
     Server Error)
     - "FABRIC_E_NODE_IS_UP"
     - "E_FAIL"
     - "FABRIC_E_SINGLE_INSTANCE_APPLICATION_ALREADY_EXISTS"
     - "FABRIC_E_SINGLE_INSTANCE_APPLICATION_NOT_FOUND"
     - "FABRIC_E_VOLUME_ALREADY_EXISTS"
     - "FABRIC_E_VOLUME_NOT_FOUND"
     - "SerializationError"
     - Possible values of the error code for HTTP status code 503 (Service
     Unavailable)
     - "FABRIC_E_NO_WRITE_QUORUM"
     - "FABRIC_E_NOT_PRIMARY"
     - "FABRIC_E_NOT_READY"
     - "FABRIC_E_RECONFIGURATION_PENDING"
     - "FABRIC_E_SERVICE_OFFLINE"
     - "E_ABORT"
     - "FABRIC_E_VALUE_TOO_LARGE"
     - Possible values of the error code for HTTP status code 504 (Gateway
     Timeout)
     - "FABRIC_E_COMMUNICATION_ERROR"
     - "FABRIC_E_OPERATION_NOT_COMPLETE"
     - "FABRIC_E_TIMEOUT". Possible values include:
     'FABRIC_E_INVALID_PARTITION_KEY',
     'FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR', 'FABRIC_E_INVALID_ADDRESS',
     'FABRIC_E_APPLICATION_NOT_UPGRADING',
     'FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR',
     'FABRIC_E_FABRIC_NOT_UPGRADING',
     'FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR',
     'FABRIC_E_INVALID_CONFIGURATION', 'FABRIC_E_INVALID_NAME_URI',
     'FABRIC_E_PATH_TOO_LONG', 'FABRIC_E_KEY_TOO_LARGE',
     'FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED',
     'FABRIC_E_INVALID_ATOMIC_GROUP', 'FABRIC_E_VALUE_EMPTY',
     'FABRIC_E_NODE_NOT_FOUND', 'FABRIC_E_APPLICATION_TYPE_NOT_FOUND',
     'FABRIC_E_APPLICATION_NOT_FOUND', 'FABRIC_E_SERVICE_TYPE_NOT_FOUND',
     'FABRIC_E_SERVICE_DOES_NOT_EXIST',
     'FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND',
     'FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND',
     'FABRIC_E_PARTITION_NOT_FOUND', 'FABRIC_E_REPLICA_DOES_NOT_EXIST',
     'FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST',
     'FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND',
     'FABRIC_E_DIRECTORY_NOT_FOUND', 'FABRIC_E_FABRIC_VERSION_NOT_FOUND',
     'FABRIC_E_FILE_NOT_FOUND', 'FABRIC_E_NAME_DOES_NOT_EXIST',
     'FABRIC_E_PROPERTY_DOES_NOT_EXIST', 'FABRIC_E_ENUMERATION_COMPLETED',
     'FABRIC_E_SERVICE_MANIFEST_NOT_FOUND', 'FABRIC_E_KEY_NOT_FOUND',
     'FABRIC_E_HEALTH_ENTITY_NOT_FOUND',
     'FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS',
     'FABRIC_E_APPLICATION_ALREADY_EXISTS',
     'FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION',
     'FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS',
     'FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS',
     'FABRIC_E_SERVICE_ALREADY_EXISTS',
     'FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS',
     'FABRIC_E_APPLICATION_TYPE_IN_USE',
     'FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION',
     'FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS',
     'FABRIC_E_FABRIC_VERSION_IN_USE', 'FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS',
     'FABRIC_E_NAME_ALREADY_EXISTS', 'FABRIC_E_NAME_NOT_EMPTY',
     'FABRIC_E_PROPERTY_CHECK_FAILED', 'FABRIC_E_SERVICE_METADATA_MISMATCH',
     'FABRIC_E_SERVICE_TYPE_MISMATCH', 'FABRIC_E_HEALTH_STALE_REPORT',
     'FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED',
     'FABRIC_E_NODE_HAS_NOT_STOPPED_YET', 'FABRIC_E_INSTANCE_ID_MISMATCH',
     'FABRIC_E_VALUE_TOO_LARGE', 'FABRIC_E_NO_WRITE_QUORUM',
     'FABRIC_E_NOT_PRIMARY', 'FABRIC_E_NOT_READY',
     'FABRIC_E_RECONFIGURATION_PENDING', 'FABRIC_E_SERVICE_OFFLINE', 'E_ABORT',
     'FABRIC_E_COMMUNICATION_ERROR', 'FABRIC_E_OPERATION_NOT_COMPLETE',
     'FABRIC_E_TIMEOUT', 'FABRIC_E_NODE_IS_UP', 'E_FAIL',
     'FABRIC_E_BACKUP_IS_ENABLED',
     'FABRIC_E_RESTORE_SOURCE_TARGET_PARTITION_MISMATCH',
     'FABRIC_E_INVALID_FOR_STATELESS_SERVICES', 'FABRIC_E_BACKUP_NOT_ENABLED',
     'FABRIC_E_BACKUP_POLICY_NOT_EXISTING',
     'FABRIC_E_FAULT_ANALYSIS_SERVICE_NOT_EXISTING',
     'FABRIC_E_BACKUP_IN_PROGRESS', 'FABRIC_E_RESTORE_IN_PROGRESS',
     'FABRIC_E_BACKUP_POLICY_ALREADY_EXISTING',
     'FABRIC_E_INVALID_SERVICE_SCALING_POLICY', 'E_INVALIDARG',
     'FABRIC_E_SINGLE_INSTANCE_APPLICATION_ALREADY_EXISTS',
     'FABRIC_E_SINGLE_INSTANCE_APPLICATION_NOT_FOUND',
     'FABRIC_E_VOLUME_ALREADY_EXISTS', 'FABRIC_E_VOLUME_NOT_FOUND',
     'SerializationError', 'FABRIC_E_IMAGEBUILDER_RESERVED_DIRECTORY_ERROR'
    :type code: str or ~azure.servicefabric.models.FabricErrorCodes
    :param message: Error message.
    :type message: str
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FabricErrorError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class PropertyBatchInfo(Model):
    """Information about the results of a property batch.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SuccessfulPropertyBatchInfo, FailedPropertyBatchInfo

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Successful': 'SuccessfulPropertyBatchInfo', 'Failed': 'FailedPropertyBatchInfo'}
    }

    def __init__(self, **kwargs):
        super(PropertyBatchInfo, self).__init__(**kwargs)
        self.kind = None


class FailedPropertyBatchInfo(PropertyBatchInfo):
    """Derived from PropertyBatchInfo. Represents the property batch failing.
    Contains information about the specific batch failure.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param error_message: The error message of the failed operation. Describes
     the exception thrown due to the first unsuccessful operation in the
     property batch.
    :type error_message: str
    :param operation_index: The index of the unsuccessful operation in the
     property batch.
    :type operation_index: int
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'error_message': {'key': 'ErrorMessage', 'type': 'str'},
        'operation_index': {'key': 'OperationIndex', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(FailedPropertyBatchInfo, self).__init__(**kwargs)
        self.error_message = kwargs.get('error_message', None)
        self.operation_index = kwargs.get('operation_index', None)
        self.kind = 'Failed'


class FailedUpgradeDomainProgressObject(Model):
    """The detailed upgrade progress for nodes in the current upgrade domain at
    the point of failure.

    :param domain_name: The name of the upgrade domain
    :type domain_name: str
    :param node_upgrade_progress_list: List of upgrading nodes and their
     statuses
    :type node_upgrade_progress_list:
     list[~azure.servicefabric.models.NodeUpgradeProgressInfo]
    """

    _attribute_map = {
        'domain_name': {'key': 'DomainName', 'type': 'str'},
        'node_upgrade_progress_list': {'key': 'NodeUpgradeProgressList', 'type': '[NodeUpgradeProgressInfo]'},
    }

    def __init__(self, **kwargs):
        super(FailedUpgradeDomainProgressObject, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.node_upgrade_progress_list = kwargs.get('node_upgrade_progress_list', None)


class FailureUpgradeDomainProgressInfo(Model):
    """Information about the upgrade domain progress at the time of upgrade
    failure.

    :param domain_name: The name of the upgrade domain
    :type domain_name: str
    :param node_upgrade_progress_list: List of upgrading nodes and their
     statuses
    :type node_upgrade_progress_list:
     list[~azure.servicefabric.models.NodeUpgradeProgressInfo]
    """

    _attribute_map = {
        'domain_name': {'key': 'DomainName', 'type': 'str'},
        'node_upgrade_progress_list': {'key': 'NodeUpgradeProgressList', 'type': '[NodeUpgradeProgressInfo]'},
    }

    def __init__(self, **kwargs):
        super(FailureUpgradeDomainProgressInfo, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.node_upgrade_progress_list = kwargs.get('node_upgrade_progress_list', None)


class FileInfo(Model):
    """Information about a image store file.

    :param file_size: The size of file in bytes.
    :type file_size: str
    :param file_version: Information about the version of image store file.
    :type file_version: ~azure.servicefabric.models.FileVersion
    :param modified_date: The date and time when the image store file was last
     modified.
    :type modified_date: datetime
    :param store_relative_path: The file path relative to the image store root
     path.
    :type store_relative_path: str
    """

    _attribute_map = {
        'file_size': {'key': 'FileSize', 'type': 'str'},
        'file_version': {'key': 'FileVersion', 'type': 'FileVersion'},
        'modified_date': {'key': 'ModifiedDate', 'type': 'iso-8601'},
        'store_relative_path': {'key': 'StoreRelativePath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileInfo, self).__init__(**kwargs)
        self.file_size = kwargs.get('file_size', None)
        self.file_version = kwargs.get('file_version', None)
        self.modified_date = kwargs.get('modified_date', None)
        self.store_relative_path = kwargs.get('store_relative_path', None)


class FileShareBackupStorageDescription(BackupStorageDescription):
    """Describes the parameters for file share storage used for storing or
    enumerating backups.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Friendly name for this backup storage.
    :type friendly_name: str
    :param storage_kind: Required. Constant filled by server.
    :type storage_kind: str
    :param path: Required. UNC path of the file share where to store or
     enumerate backups from.
    :type path: str
    :param primary_user_name: Primary user name to access the file share.
    :type primary_user_name: str
    :param primary_password: Primary password to access the share location.
    :type primary_password: str
    :param secondary_user_name: Secondary user name to access the file share.
    :type secondary_user_name: str
    :param secondary_password: Secondary password to access the share location
    :type secondary_password: str
    """

    _validation = {
        'storage_kind': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'FriendlyName', 'type': 'str'},
        'storage_kind': {'key': 'StorageKind', 'type': 'str'},
        'path': {'key': 'Path', 'type': 'str'},
        'primary_user_name': {'key': 'PrimaryUserName', 'type': 'str'},
        'primary_password': {'key': 'PrimaryPassword', 'type': 'str'},
        'secondary_user_name': {'key': 'SecondaryUserName', 'type': 'str'},
        'secondary_password': {'key': 'SecondaryPassword', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileShareBackupStorageDescription, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.primary_user_name = kwargs.get('primary_user_name', None)
        self.primary_password = kwargs.get('primary_password', None)
        self.secondary_user_name = kwargs.get('secondary_user_name', None)
        self.secondary_password = kwargs.get('secondary_password', None)
        self.storage_kind = 'FileShare'


class FileVersion(Model):
    """Information about the version of image store file.

    :param version_number: The current image store version number for the file
     is used in image store for checking whether it need to be updated.
    :type version_number: str
    :param epoch_data_loss_number: The epoch data loss number of image store
     replica when this file entry was updated or created.
    :type epoch_data_loss_number: str
    :param epoch_configuration_number: The epoch configuration version number
     of the image store replica when this file entry was created or updated.
    :type epoch_configuration_number: str
    """

    _attribute_map = {
        'version_number': {'key': 'VersionNumber', 'type': 'str'},
        'epoch_data_loss_number': {'key': 'EpochDataLossNumber', 'type': 'str'},
        'epoch_configuration_number': {'key': 'EpochConfigurationNumber', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileVersion, self).__init__(**kwargs)
        self.version_number = kwargs.get('version_number', None)
        self.epoch_data_loss_number = kwargs.get('epoch_data_loss_number', None)
        self.epoch_configuration_number = kwargs.get('epoch_configuration_number', None)


class FolderInfo(Model):
    """Information about a image store folder. It includes how many files this
    folder contains and its image store relative path.

    :param store_relative_path: The remote location within image store. This
     path is relative to the image store root.
    :type store_relative_path: str
    :param file_count: The number of files from within the image store folder.
    :type file_count: str
    """

    _attribute_map = {
        'store_relative_path': {'key': 'StoreRelativePath', 'type': 'str'},
        'file_count': {'key': 'FileCount', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FolderInfo, self).__init__(**kwargs)
        self.store_relative_path = kwargs.get('store_relative_path', None)
        self.file_count = kwargs.get('file_count', None)


class FolderSizeInfo(Model):
    """Information of a image store folder size.

    :param store_relative_path: The remote location within image store. This
     path is relative to the image store root.
    :type store_relative_path: str
    :param folder_size: The size of folder in bytes.
    :type folder_size: str
    """

    _attribute_map = {
        'store_relative_path': {'key': 'StoreRelativePath', 'type': 'str'},
        'folder_size': {'key': 'FolderSize', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FolderSizeInfo, self).__init__(**kwargs)
        self.store_relative_path = kwargs.get('store_relative_path', None)
        self.folder_size = kwargs.get('folder_size', None)


class FrequencyBasedBackupScheduleDescription(BackupScheduleDescription):
    """Describes the frequency based backup schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_kind: Required. Constant filled by server.
    :type schedule_kind: str
    :param interval: Required. Defines the interval with which backups are
     periodically taken. It should be specified in ISO8601 format. Timespan in
     seconds is not supported and will be ignored while creating the policy.
    :type interval: timedelta
    """

    _validation = {
        'schedule_kind': {'required': True},
        'interval': {'required': True},
    }

    _attribute_map = {
        'schedule_kind': {'key': 'ScheduleKind', 'type': 'str'},
        'interval': {'key': 'Interval', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(FrequencyBasedBackupScheduleDescription, self).__init__(**kwargs)
        self.interval = kwargs.get('interval', None)
        self.schedule_kind = 'FrequencyBased'


class GatewayDestination(Model):
    """Describes destination endpoint for routing traffic.

    All required parameters must be populated in order to send to Azure.

    :param application_name: Required. Name of the service fabric Mesh
     application.
    :type application_name: str
    :param service_name: Required. service that contains the endpoint.
    :type service_name: str
    :param endpoint_name: Required. name of the endpoint in the service.
    :type endpoint_name: str
    """

    _validation = {
        'application_name': {'required': True},
        'service_name': {'required': True},
        'endpoint_name': {'required': True},
    }

    _attribute_map = {
        'application_name': {'key': 'applicationName', 'type': 'str'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'endpoint_name': {'key': 'endpointName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GatewayDestination, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.service_name = kwargs.get('service_name', None)
        self.endpoint_name = kwargs.get('endpoint_name', None)


class GatewayResourceDescription(Model):
    """This type describes a gateway resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Gateway resource.
    :type name: str
    :param description: User readable description of the gateway.
    :type description: str
    :param source_network: Required. Network the gateway should listen on for
     requests.
    :type source_network: ~azure.servicefabric.models.NetworkRef
    :param destination_network: Required. Network that the Application is
     using.
    :type destination_network: ~azure.servicefabric.models.NetworkRef
    :param tcp: Configuration for tcp connectivity for this gateway.
    :type tcp: list[~azure.servicefabric.models.TcpConfig]
    :param http: Configuration for http connectivity for this gateway.
    :type http: list[~azure.servicefabric.models.HttpConfig]
    :ivar status: Status of the resource. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the gateway.
    :vartype status_details: str
    :ivar ip_address: IP address of the gateway. This is populated in the
     response and is ignored for incoming requests.
    :vartype ip_address: str
    """

    _validation = {
        'name': {'required': True},
        'source_network': {'required': True},
        'destination_network': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'source_network': {'key': 'properties.sourceNetwork', 'type': 'NetworkRef'},
        'destination_network': {'key': 'properties.destinationNetwork', 'type': 'NetworkRef'},
        'tcp': {'key': 'properties.tcp', 'type': '[TcpConfig]'},
        'http': {'key': 'properties.http', 'type': '[HttpConfig]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GatewayResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.source_network = kwargs.get('source_network', None)
        self.destination_network = kwargs.get('destination_network', None)
        self.tcp = kwargs.get('tcp', None)
        self.http = kwargs.get('http', None)
        self.status = None
        self.status_details = None
        self.ip_address = None


class GetBackupByStorageQueryDescription(Model):
    """Describes additional filters to be applied, while listing backups, and
    backup storage details from where to fetch the backups.

    All required parameters must be populated in order to send to Azure.

    :param start_date_time_filter: Specifies the start date time in ISO8601
     from which to enumerate backups. If not specified, backups are enumerated
     from the beginning.
    :type start_date_time_filter: datetime
    :param end_date_time_filter: Specifies the end date time in ISO8601 till
     which to enumerate backups. If not specified, backups are enumerated till
     the end.
    :type end_date_time_filter: datetime
    :param latest: If specified as true, gets the most recent backup (within
     the specified time range) for every partition under the specified backup
     entity. Default value: False .
    :type latest: bool
    :param storage: Required. Describes the parameters for the backup storage
     from where to enumerate backups. This is optional and by default backups
     are enumerated from the backup storage where this backup entity is
     currently being backed up (as specified in backup policy). This parameter
     is useful to be able to enumerate backups from another cluster where you
     may intend to restore.
    :type storage: ~azure.servicefabric.models.BackupStorageDescription
    :param backup_entity: Required. Indicates the entity for which to
     enumerate backups.
    :type backup_entity: ~azure.servicefabric.models.BackupEntity
    """

    _validation = {
        'storage': {'required': True},
        'backup_entity': {'required': True},
    }

    _attribute_map = {
        'start_date_time_filter': {'key': 'StartDateTimeFilter', 'type': 'iso-8601'},
        'end_date_time_filter': {'key': 'EndDateTimeFilter', 'type': 'iso-8601'},
        'latest': {'key': 'Latest', 'type': 'bool'},
        'storage': {'key': 'Storage', 'type': 'BackupStorageDescription'},
        'backup_entity': {'key': 'BackupEntity', 'type': 'BackupEntity'},
    }

    def __init__(self, **kwargs):
        super(GetBackupByStorageQueryDescription, self).__init__(**kwargs)
        self.start_date_time_filter = kwargs.get('start_date_time_filter', None)
        self.end_date_time_filter = kwargs.get('end_date_time_filter', None)
        self.latest = kwargs.get('latest', False)
        self.storage = kwargs.get('storage', None)
        self.backup_entity = kwargs.get('backup_entity', None)


class GetPropertyBatchOperation(PropertyBatchOperation):
    """Represents a PropertyBatchOperation that gets the specified property if it
    exists.
    Note that if one PropertyBatchOperation in a PropertyBatch fails,
    the entire batch fails and cannot be committed in a transactional manner.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param include_value: Whether or not to return the property value with the
     metadata.
     True if values should be returned with the metadata; False to return only
     property metadata. Default value: False .
    :type include_value: bool
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'include_value': {'key': 'IncludeValue', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(GetPropertyBatchOperation, self).__init__(**kwargs)
        self.include_value = kwargs.get('include_value', False)
        self.kind = 'Get'


class GuidPropertyValue(PropertyValue):
    """Describes a Service Fabric property value of type Guid.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param data: Required. The data of the property value.
    :type data: str
    """

    _validation = {
        'kind': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'data': {'key': 'Data', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GuidPropertyValue, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.kind = 'Guid'


class HealthEvaluationWrapper(Model):
    """Wrapper object for health evaluation.

    :param health_evaluation: Represents a health evaluation which describes
     the data and the algorithm used by health manager to evaluate the health
     of an entity.
    :type health_evaluation: ~azure.servicefabric.models.HealthEvaluation
    """

    _attribute_map = {
        'health_evaluation': {'key': 'HealthEvaluation', 'type': 'HealthEvaluation'},
    }

    def __init__(self, **kwargs):
        super(HealthEvaluationWrapper, self).__init__(**kwargs)
        self.health_evaluation = kwargs.get('health_evaluation', None)


class HealthInformation(Model):
    """Represents common health report information. It is included in all health
    reports sent to health store and in all health events returned by health
    queries.

    All required parameters must be populated in order to send to Azure.

    :param source_id: Required. The source name that identifies the
     client/watchdog/system component that generated the health information.
    :type source_id: str
    :param property: Required. The property of the health information. An
     entity can have health reports for different properties.
     The property is a string and not a fixed enumeration to allow the reporter
     flexibility to categorize the state condition that triggers the report.
     For example, a reporter with SourceId "LocalWatchdog" can monitor the
     state of the available disk on a node,
     so it can report "AvailableDisk" property on that node.
     The same reporter can monitor the node connectivity, so it can report a
     property "Connectivity" on the same node.
     In the health store, these reports are treated as separate health events
     for the specified node.
     Together with the SourceId, the property uniquely identifies the health
     information.
    :type property: str
    :param health_state: Required. The health state of a Service Fabric entity
     such as Cluster, Node, Application, Service, Partition, Replica etc.
     Possible values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param time_to_live_in_milli_seconds: The duration for which this health
     report is valid. This field uses ISO8601 format for specifying the
     duration.
     When clients report periodically, they should send reports with higher
     frequency than time to live.
     If clients report on transition, they can set the time to live to
     infinite.
     When time to live expires, the health event that contains the health
     information
     is either removed from health store, if RemoveWhenExpired is true, or
     evaluated at error, if RemoveWhenExpired false.
     If not specified, time to live defaults to infinite value.
    :type time_to_live_in_milli_seconds: timedelta
    :param description: The description of the health information. It
     represents free text used to add human readable information about the
     report.
     The maximum string length for the description is 4096 characters.
     If the provided string is longer, it will be automatically truncated.
     When truncated, the last characters of the description contain a marker
     "[Truncated]", and total string size is 4096 characters.
     The presence of the marker indicates to users that truncation occurred.
     Note that when truncated, the description has less than 4096 characters
     from the original string.
    :type description: str
    :param sequence_number: The sequence number for this health report as a
     numeric string.
     The report sequence number is used by the health store to detect stale
     reports.
     If not specified, a sequence number is auto-generated by the health client
     when a report is added.
    :type sequence_number: str
    :param remove_when_expired: Value that indicates whether the report is
     removed from health store when it expires.
     If set to true, the report is removed from the health store after it
     expires.
     If set to false, the report is treated as an error when expired. The value
     of this property is false by default.
     When clients report periodically, they should set RemoveWhenExpired false
     (default).
     This way, if the reporter has issues (e.g. deadlock) and can't report, the
     entity is evaluated at error when the health report expires.
     This flags the entity as being in Error health state.
    :type remove_when_expired: bool
    """

    _validation = {
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
    }

    _attribute_map = {
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_in_milli_seconds': {'key': 'TimeToLiveInMilliSeconds', 'type': 'duration'},
        'description': {'key': 'Description', 'type': 'str'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(HealthInformation, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_in_milli_seconds = kwargs.get('time_to_live_in_milli_seconds', None)
        self.description = kwargs.get('description', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)


class HealthEvent(HealthInformation):
    """Represents health information reported on a health entity, such as cluster,
    application or node, with additional metadata added by the Health Manager.

    All required parameters must be populated in order to send to Azure.

    :param source_id: Required. The source name that identifies the
     client/watchdog/system component that generated the health information.
    :type source_id: str
    :param property: Required. The property of the health information. An
     entity can have health reports for different properties.
     The property is a string and not a fixed enumeration to allow the reporter
     flexibility to categorize the state condition that triggers the report.
     For example, a reporter with SourceId "LocalWatchdog" can monitor the
     state of the available disk on a node,
     so it can report "AvailableDisk" property on that node.
     The same reporter can monitor the node connectivity, so it can report a
     property "Connectivity" on the same node.
     In the health store, these reports are treated as separate health events
     for the specified node.
     Together with the SourceId, the property uniquely identifies the health
     information.
    :type property: str
    :param health_state: Required. The health state of a Service Fabric entity
     such as Cluster, Node, Application, Service, Partition, Replica etc.
     Possible values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param time_to_live_in_milli_seconds: The duration for which this health
     report is valid. This field uses ISO8601 format for specifying the
     duration.
     When clients report periodically, they should send reports with higher
     frequency than time to live.
     If clients report on transition, they can set the time to live to
     infinite.
     When time to live expires, the health event that contains the health
     information
     is either removed from health store, if RemoveWhenExpired is true, or
     evaluated at error, if RemoveWhenExpired false.
     If not specified, time to live defaults to infinite value.
    :type time_to_live_in_milli_seconds: timedelta
    :param description: The description of the health information. It
     represents free text used to add human readable information about the
     report.
     The maximum string length for the description is 4096 characters.
     If the provided string is longer, it will be automatically truncated.
     When truncated, the last characters of the description contain a marker
     "[Truncated]", and total string size is 4096 characters.
     The presence of the marker indicates to users that truncation occurred.
     Note that when truncated, the description has less than 4096 characters
     from the original string.
    :type description: str
    :param sequence_number: The sequence number for this health report as a
     numeric string.
     The report sequence number is used by the health store to detect stale
     reports.
     If not specified, a sequence number is auto-generated by the health client
     when a report is added.
    :type sequence_number: str
    :param remove_when_expired: Value that indicates whether the report is
     removed from health store when it expires.
     If set to true, the report is removed from the health store after it
     expires.
     If set to false, the report is treated as an error when expired. The value
     of this property is false by default.
     When clients report periodically, they should set RemoveWhenExpired false
     (default).
     This way, if the reporter has issues (e.g. deadlock) and can't report, the
     entity is evaluated at error when the health report expires.
     This flags the entity as being in Error health state.
    :type remove_when_expired: bool
    :param is_expired: Returns true if the health event is expired, otherwise
     false.
    :type is_expired: bool
    :param source_utc_timestamp: The date and time when the health report was
     sent by the source.
    :type source_utc_timestamp: datetime
    :param last_modified_utc_timestamp: The date and time when the health
     report was last modified by the health store.
    :type last_modified_utc_timestamp: datetime
    :param last_ok_transition_at: If the current health state is 'Ok', this
     property returns the time at which the health report was first reported
     with 'Ok'.
     For periodic reporting, many reports with the same state may have been
     generated.
     This property returns the date and time when the first 'Ok' health report
     was received.
     If the current health state is 'Error' or 'Warning', returns the date and
     time at which the health state was last in 'Ok', before transitioning to a
     different state.
     If the health state was never 'Ok', the value will be zero date-time.
    :type last_ok_transition_at: datetime
    :param last_warning_transition_at: If the current health state is
     'Warning', this property returns the time at which the health report was
     first reported with 'Warning'. For periodic reporting, many reports with
     the same state may have been generated however, this property returns only
     the date and time at the first 'Warning' health report was received.
     If the current health state is 'Ok' or 'Error', returns the date and time
     at which the health state was last in 'Warning', before transitioning to a
     different state.
     If the health state was never 'Warning', the value will be zero date-time.
    :type last_warning_transition_at: datetime
    :param last_error_transition_at: If the current health state is 'Error',
     this property returns the time at which the health report was first
     reported with 'Error'. For periodic reporting, many reports with the same
     state may have been generated however, this property returns only the date
     and time at the first 'Error' health report was received.
     If the current health state is 'Ok' or 'Warning', returns the date and
     time at which the health state was last in 'Error', before transitioning
     to a different state.
     If the health state was never 'Error', the value will be zero date-time.
    :type last_error_transition_at: datetime
    """

    _validation = {
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
    }

    _attribute_map = {
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_in_milli_seconds': {'key': 'TimeToLiveInMilliSeconds', 'type': 'duration'},
        'description': {'key': 'Description', 'type': 'str'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'is_expired': {'key': 'IsExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
        'last_modified_utc_timestamp': {'key': 'LastModifiedUtcTimestamp', 'type': 'iso-8601'},
        'last_ok_transition_at': {'key': 'LastOkTransitionAt', 'type': 'iso-8601'},
        'last_warning_transition_at': {'key': 'LastWarningTransitionAt', 'type': 'iso-8601'},
        'last_error_transition_at': {'key': 'LastErrorTransitionAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(HealthEvent, self).__init__(**kwargs)
        self.is_expired = kwargs.get('is_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.last_modified_utc_timestamp = kwargs.get('last_modified_utc_timestamp', None)
        self.last_ok_transition_at = kwargs.get('last_ok_transition_at', None)
        self.last_warning_transition_at = kwargs.get('last_warning_transition_at', None)
        self.last_error_transition_at = kwargs.get('last_error_transition_at', None)


class HealthStateCount(Model):
    """Represents information about how many health entities are in Ok, Warning
    and Error health state.

    :param ok_count: The number of health entities with aggregated health
     state Ok.
    :type ok_count: long
    :param warning_count: The number of health entities with aggregated health
     state Warning.
    :type warning_count: long
    :param error_count: The number of health entities with aggregated health
     state Error.
    :type error_count: long
    """

    _validation = {
        'ok_count': {'minimum': 0},
        'warning_count': {'minimum': 0},
        'error_count': {'minimum': 0},
    }

    _attribute_map = {
        'ok_count': {'key': 'OkCount', 'type': 'long'},
        'warning_count': {'key': 'WarningCount', 'type': 'long'},
        'error_count': {'key': 'ErrorCount', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(HealthStateCount, self).__init__(**kwargs)
        self.ok_count = kwargs.get('ok_count', None)
        self.warning_count = kwargs.get('warning_count', None)
        self.error_count = kwargs.get('error_count', None)


class HealthStatistics(Model):
    """The health statistics of an entity, returned as part of the health query
    result when the query description is configured to include statistics.
    The statistics include health state counts for all children types of the
    current entity.
    For example, for cluster, the health statistics include health state counts
    for nodes, applications, services, partitions, replicas, deployed
    applications and deployed service packages.
    For partition, the health statistics include health counts for replicas.

    :param health_state_count_list: List of health state counts per entity
     kind, which keeps track of how many children of the queried entity are in
     Ok, Warning and Error state.
    :type health_state_count_list:
     list[~azure.servicefabric.models.EntityKindHealthStateCount]
    """

    _attribute_map = {
        'health_state_count_list': {'key': 'HealthStateCountList', 'type': '[EntityKindHealthStateCount]'},
    }

    def __init__(self, **kwargs):
        super(HealthStatistics, self).__init__(**kwargs)
        self.health_state_count_list = kwargs.get('health_state_count_list', None)


class HttpConfig(Model):
    """Describes the http configuration for external connectivity for this
    network.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. http gateway config name.
    :type name: str
    :param port: Required. Specifies the port at which the service endpoint
     below needs to be exposed.
    :type port: int
    :param hosts: Required. description for routing.
    :type hosts: list[~azure.servicefabric.models.HttpHostConfig]
    """

    _validation = {
        'name': {'required': True},
        'port': {'required': True},
        'hosts': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'hosts': {'key': 'hosts', 'type': '[HttpHostConfig]'},
    }

    def __init__(self, **kwargs):
        super(HttpConfig, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.port = kwargs.get('port', None)
        self.hosts = kwargs.get('hosts', None)


class HttpHostConfig(Model):
    """Describes the hostname properties for http routing.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. http hostname config name.
    :type name: str
    :param routes: Required. Route information to use for routing. Routes are
     processed in the order they are specified. Specify routes that are more
     specific before routes that can handle general cases.
    :type routes: list[~azure.servicefabric.models.HttpRouteConfig]
    """

    _validation = {
        'name': {'required': True},
        'routes': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'routes': {'key': 'routes', 'type': '[HttpRouteConfig]'},
    }

    def __init__(self, **kwargs):
        super(HttpHostConfig, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.routes = kwargs.get('routes', None)


class HttpRouteConfig(Model):
    """Describes the hostname properties for http routing.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. http route name.
    :type name: str
    :param match: Required. Describes a rule for http route matching.
    :type match: ~azure.servicefabric.models.HttpRouteMatchRule
    :param destination: Required. Describes destination endpoint for routing
     traffic.
    :type destination: ~azure.servicefabric.models.GatewayDestination
    """

    _validation = {
        'name': {'required': True},
        'match': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'match': {'key': 'match', 'type': 'HttpRouteMatchRule'},
        'destination': {'key': 'destination', 'type': 'GatewayDestination'},
    }

    def __init__(self, **kwargs):
        super(HttpRouteConfig, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.match = kwargs.get('match', None)
        self.destination = kwargs.get('destination', None)


class HttpRouteMatchHeader(Model):
    """Describes header information for http route matching.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of header to match in request.
    :type name: str
    :param value: Value of header to match in request.
    :type value: str
    :param type: how to match header value. Possible values include: 'exact'
    :type type: str or ~azure.servicefabric.models.HeaderMatchType
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HttpRouteMatchHeader, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.type = kwargs.get('type', None)


class HttpRouteMatchPath(Model):
    """Path to match for routing.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Uri path to match for request.
    :type value: str
    :param rewrite: replacement string for matched part of the Uri.
    :type rewrite: str
    :ivar type: Required. how to match value in the Uri. Default value:
     "prefix" .
    :vartype type: str
    """

    _validation = {
        'value': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'rewrite': {'key': 'rewrite', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "prefix"

    def __init__(self, **kwargs):
        super(HttpRouteMatchPath, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.rewrite = kwargs.get('rewrite', None)


class HttpRouteMatchRule(Model):
    """Describes a rule for http route matching.

    All required parameters must be populated in order to send to Azure.

    :param path: Required. Path to match for routing.
    :type path: ~azure.servicefabric.models.HttpRouteMatchPath
    :param headers: headers and their values to match in request.
    :type headers: list[~azure.servicefabric.models.HttpRouteMatchHeader]
    """

    _validation = {
        'path': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'HttpRouteMatchPath'},
        'headers': {'key': 'headers', 'type': '[HttpRouteMatchHeader]'},
    }

    def __init__(self, **kwargs):
        super(HttpRouteMatchRule, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.headers = kwargs.get('headers', None)


class IdentityDescription(Model):
    """Information describing the identities associated with this application.

    All required parameters must be populated in order to send to Azure.

    :param token_service_endpoint: the endpoint for the token service managing
     this identity
    :type token_service_endpoint: str
    :param type: Required. the types of identities associated with this
     resource; currently restricted to 'SystemAssigned and UserAssigned'
    :type type: str
    :param tenant_id: the identifier of the tenant containing the
     application's identity.
    :type tenant_id: str
    :param principal_id: the object identifier of the Service Principal of the
     identity associated with this resource.
    :type principal_id: str
    :param user_assigned_identities: represents user assigned identities map.
    :type user_assigned_identities: dict[str,
     ~azure.servicefabric.models.IdentityItemDescription]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'token_service_endpoint': {'key': 'tokenServiceEndpoint', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{IdentityItemDescription}'},
    }

    def __init__(self, **kwargs):
        super(IdentityDescription, self).__init__(**kwargs)
        self.token_service_endpoint = kwargs.get('token_service_endpoint', None)
        self.type = kwargs.get('type', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class IdentityItemDescription(Model):
    """Describes a single user-assigned identity associated with the application.

    :param principal_id: the object identifier of the Service Principal which
     this identity represents.
    :type principal_id: str
    :param client_id: the client identifier of the Service Principal which
     this identity represents.
    :type client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IdentityItemDescription, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.client_id = kwargs.get('client_id', None)


class ImageRegistryCredential(Model):
    """Image registry credential.

    All required parameters must be populated in order to send to Azure.

    :param server: Required. Docker image registry server, without protocol
     such as `http` and `https`.
    :type server: str
    :param username: Required. The username for the private registry.
    :type username: str
    :param password: The password for the private registry. The password is
     required for create or update operations, however it is not returned in
     the get or list operations.
    :type password: str
    """

    _validation = {
        'server': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageRegistryCredential, self).__init__(**kwargs)
        self.server = kwargs.get('server', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class ImageStoreContent(Model):
    """Information about the image store content.

    :param store_files: The list of image store file info objects represents
     files found under the given image store relative path.
    :type store_files: list[~azure.servicefabric.models.FileInfo]
    :param store_folders: The list of image store folder info objects
     represents subfolders found under the given image store relative path.
    :type store_folders: list[~azure.servicefabric.models.FolderInfo]
    """

    _attribute_map = {
        'store_files': {'key': 'StoreFiles', 'type': '[FileInfo]'},
        'store_folders': {'key': 'StoreFolders', 'type': '[FolderInfo]'},
    }

    def __init__(self, **kwargs):
        super(ImageStoreContent, self).__init__(**kwargs)
        self.store_files = kwargs.get('store_files', None)
        self.store_folders = kwargs.get('store_folders', None)


class ImageStoreCopyDescription(Model):
    """Information about how to copy image store content from one image store
    relative path to another image store relative path.

    All required parameters must be populated in order to send to Azure.

    :param remote_source: Required. The relative path of source image store
     content to be copied from.
    :type remote_source: str
    :param remote_destination: Required. The relative path of destination
     image store content to be copied to.
    :type remote_destination: str
    :param skip_files: The list of the file names to be skipped for copying.
    :type skip_files: list[str]
    :param check_mark_file: Indicates whether to check mark file during
     copying. The property is true if checking mark file is required, false
     otherwise. The mark file is used to check whether the folder is well
     constructed. If the property is true and mark file does not exist, the
     copy is skipped.
    :type check_mark_file: bool
    """

    _validation = {
        'remote_source': {'required': True},
        'remote_destination': {'required': True},
    }

    _attribute_map = {
        'remote_source': {'key': 'RemoteSource', 'type': 'str'},
        'remote_destination': {'key': 'RemoteDestination', 'type': 'str'},
        'skip_files': {'key': 'SkipFiles', 'type': '[str]'},
        'check_mark_file': {'key': 'CheckMarkFile', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ImageStoreCopyDescription, self).__init__(**kwargs)
        self.remote_source = kwargs.get('remote_source', None)
        self.remote_destination = kwargs.get('remote_destination', None)
        self.skip_files = kwargs.get('skip_files', None)
        self.check_mark_file = kwargs.get('check_mark_file', None)


class SecretResourcePropertiesBase(Model):
    """This type describes the properties of a secret resource, including its
    kind.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecretResourceProperties

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'SecretResourceProperties': 'SecretResourceProperties'}
    }

    def __init__(self, **kwargs):
        super(SecretResourcePropertiesBase, self).__init__(**kwargs)
        self.kind = None


class SecretResourceProperties(SecretResourcePropertiesBase):
    """Describes the properties of a secret resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: InlinedValueSecretResourceProperties

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param description: User readable description of the secret.
    :type description: str
    :ivar status: Status of the resource. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the secret.
    :vartype status_details: str
    :param content_type: The type of the content stored in the secret value.
     The value of this property is opaque to Service Fabric. Once set, the
     value of this property cannot be changed.
    :type content_type: str
    """

    _validation = {
        'kind': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'inlinedValue': 'InlinedValueSecretResourceProperties'}
    }

    def __init__(self, **kwargs):
        super(SecretResourceProperties, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.status = None
        self.status_details = None
        self.content_type = kwargs.get('content_type', None)
        self.kind = 'SecretResourceProperties'


class InlinedValueSecretResourceProperties(SecretResourceProperties):
    """Describes the properties of a secret resource whose value is provided
    explicitly as plaintext. The secret resource may have multiple values, each
    being uniquely versioned. The secret value of each version is stored
    encrypted, and delivered as plaintext into the context of applications
    referencing it.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param description: User readable description of the secret.
    :type description: str
    :ivar status: Status of the resource. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the secret.
    :vartype status_details: str
    :param content_type: The type of the content stored in the secret value.
     The value of this property is opaque to Service Fabric. Once set, the
     value of this property cannot be changed.
    :type content_type: str
    """

    _validation = {
        'kind': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InlinedValueSecretResourceProperties, self).__init__(**kwargs)
        self.kind = 'inlinedValue'


class Int64PropertyValue(PropertyValue):
    """Describes a Service Fabric property value of type Int64.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param data: Required. The data of the property value.
    :type data: str
    """

    _validation = {
        'kind': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'data': {'key': 'Data', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Int64PropertyValue, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.kind = 'Int64'


class PartitionInformation(Model):
    """Information about the partition identity, partitioning scheme and keys
    supported by it.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Int64RangePartitionInformation, NamedPartitionInformation,
    SingletonPartitionInformation

    All required parameters must be populated in order to send to Azure.

    :param id: An internal ID used by Service Fabric to uniquely identify a
     partition. This is a randomly generated GUID when the service was created.
     The partition ID is unique and does not change for the lifetime of the
     service. If the same service was deleted and recreated the IDs of its
     partitions would be different.
    :type id: str
    :param service_partition_kind: Required. Constant filled by server.
    :type service_partition_kind: str
    """

    _validation = {
        'service_partition_kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'service_partition_kind': {'key': 'ServicePartitionKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_partition_kind': {'Int64Range': 'Int64RangePartitionInformation', 'Named': 'NamedPartitionInformation', 'Singleton': 'SingletonPartitionInformation'}
    }

    def __init__(self, **kwargs):
        super(PartitionInformation, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.service_partition_kind = None


class Int64RangePartitionInformation(PartitionInformation):
    """Describes the partition information for the integer range that is based on
    partition schemes.

    All required parameters must be populated in order to send to Azure.

    :param id: An internal ID used by Service Fabric to uniquely identify a
     partition. This is a randomly generated GUID when the service was created.
     The partition ID is unique and does not change for the lifetime of the
     service. If the same service was deleted and recreated the IDs of its
     partitions would be different.
    :type id: str
    :param service_partition_kind: Required. Constant filled by server.
    :type service_partition_kind: str
    :param low_key: Specifies the minimum key value handled by this partition.
    :type low_key: str
    :param high_key: Specifies the maximum key value handled by this
     partition.
    :type high_key: str
    """

    _validation = {
        'service_partition_kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'service_partition_kind': {'key': 'ServicePartitionKind', 'type': 'str'},
        'low_key': {'key': 'LowKey', 'type': 'str'},
        'high_key': {'key': 'HighKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Int64RangePartitionInformation, self).__init__(**kwargs)
        self.low_key = kwargs.get('low_key', None)
        self.high_key = kwargs.get('high_key', None)
        self.service_partition_kind = 'Int64Range'


class InvokeDataLossResult(Model):
    """Represents information about an operation in a terminal state (Completed or
    Faulted).

    :param error_code: If OperationState is Completed, this is 0.  If
     OperationState is Faulted, this is an error code indicating the reason.
    :type error_code: int
    :param selected_partition: This class returns information about the
     partition that the user-induced operation acted upon.
    :type selected_partition: ~azure.servicefabric.models.SelectedPartition
    """

    _attribute_map = {
        'error_code': {'key': 'ErrorCode', 'type': 'int'},
        'selected_partition': {'key': 'SelectedPartition', 'type': 'SelectedPartition'},
    }

    def __init__(self, **kwargs):
        super(InvokeDataLossResult, self).__init__(**kwargs)
        self.error_code = kwargs.get('error_code', None)
        self.selected_partition = kwargs.get('selected_partition', None)


class InvokeQuorumLossResult(Model):
    """Represents information about an operation in a terminal state (Completed or
    Faulted).

    :param error_code: If OperationState is Completed, this is 0.  If
     OperationState is Faulted, this is an error code indicating the reason.
    :type error_code: int
    :param selected_partition: This class returns information about the
     partition that the user-induced operation acted upon.
    :type selected_partition: ~azure.servicefabric.models.SelectedPartition
    """

    _attribute_map = {
        'error_code': {'key': 'ErrorCode', 'type': 'int'},
        'selected_partition': {'key': 'SelectedPartition', 'type': 'SelectedPartition'},
    }

    def __init__(self, **kwargs):
        super(InvokeQuorumLossResult, self).__init__(**kwargs)
        self.error_code = kwargs.get('error_code', None)
        self.selected_partition = kwargs.get('selected_partition', None)


class ReplicaStatusBase(Model):
    """Information about the replica.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: KeyValueStoreReplicaStatus

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'KeyValueStore': 'KeyValueStoreReplicaStatus'}
    }

    def __init__(self, **kwargs):
        super(ReplicaStatusBase, self).__init__(**kwargs)
        self.kind = None


class KeyValueStoreReplicaStatus(ReplicaStatusBase):
    """Key value store related information for the replica.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param database_row_count_estimate: Value indicating the estimated number
     of rows in the underlying database.
    :type database_row_count_estimate: str
    :param database_logical_size_estimate: Value indicating the estimated size
     of the underlying database.
    :type database_logical_size_estimate: str
    :param copy_notification_current_key_filter: Value indicating the latest
     key-prefix filter applied to enumeration during the callback. Null if
     there is no pending callback.
    :type copy_notification_current_key_filter: str
    :param copy_notification_current_progress: Value indicating the latest
     number of keys enumerated during the callback. 0 if there is no pending
     callback.
    :type copy_notification_current_progress: str
    :param status_details: Value indicating the current status details of the
     replica.
    :type status_details: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'database_row_count_estimate': {'key': 'DatabaseRowCountEstimate', 'type': 'str'},
        'database_logical_size_estimate': {'key': 'DatabaseLogicalSizeEstimate', 'type': 'str'},
        'copy_notification_current_key_filter': {'key': 'CopyNotificationCurrentKeyFilter', 'type': 'str'},
        'copy_notification_current_progress': {'key': 'CopyNotificationCurrentProgress', 'type': 'str'},
        'status_details': {'key': 'StatusDetails', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(KeyValueStoreReplicaStatus, self).__init__(**kwargs)
        self.database_row_count_estimate = kwargs.get('database_row_count_estimate', None)
        self.database_logical_size_estimate = kwargs.get('database_logical_size_estimate', None)
        self.copy_notification_current_key_filter = kwargs.get('copy_notification_current_key_filter', None)
        self.copy_notification_current_progress = kwargs.get('copy_notification_current_progress', None)
        self.status_details = kwargs.get('status_details', None)
        self.kind = 'KeyValueStore'


class LoadMetricInformation(Model):
    """Represents data structure that contains load information for a certain
    metric in a cluster.

    :param name: Name of the metric for which this load information is
     provided.
    :type name: str
    :param is_balanced_before: Value that indicates whether the metrics is
     balanced or not before resource balancer run
    :type is_balanced_before: bool
    :param is_balanced_after: Value that indicates whether the metrics is
     balanced or not after resource balancer run.
    :type is_balanced_after: bool
    :param deviation_before: The standard average deviation of the metrics
     before resource balancer run.
    :type deviation_before: str
    :param deviation_after: The standard average deviation of the metrics
     after resource balancer run.
    :type deviation_after: str
    :param balancing_threshold: The balancing threshold for a certain metric.
    :type balancing_threshold: str
    :param action: The current action being taken with regard to this metric
    :type action: str
    :param activity_threshold: The Activity Threshold specified for this
     metric in the system Cluster Manifest.
    :type activity_threshold: str
    :param cluster_capacity: The total cluster capacity for a given metric
    :type cluster_capacity: str
    :param cluster_load: The total cluster load. In future releases of Service
     Fabric this parameter will be deprecated in favor of CurrentClusterLoad.
    :type cluster_load: str
    :param current_cluster_load: The total cluster load.
    :type current_cluster_load: str
    :param cluster_remaining_capacity: The remaining capacity for the metric
     in the cluster. In future releases of Service Fabric this parameter will
     be deprecated in favor of ClusterCapacityRemaining.
    :type cluster_remaining_capacity: str
    :param cluster_capacity_remaining: The remaining capacity for the metric
     in the cluster.
    :type cluster_capacity_remaining: str
    :param is_cluster_capacity_violation: Indicates that the metric is
     currently over capacity in the cluster.
    :type is_cluster_capacity_violation: bool
    :param node_buffer_percentage: The reserved percentage of total node
     capacity for this metric.
    :type node_buffer_percentage: str
    :param cluster_buffered_capacity: Remaining capacity in the cluster
     excluding the reserved space. In future releases of Service Fabric this
     parameter will be deprecated in favor of BufferedClusterCapacityRemaining.
    :type cluster_buffered_capacity: str
    :param buffered_cluster_capacity_remaining: Remaining capacity in the
     cluster excluding the reserved space.
    :type buffered_cluster_capacity_remaining: str
    :param cluster_remaining_buffered_capacity: The remaining percentage of
     cluster total capacity for this metric.
    :type cluster_remaining_buffered_capacity: str
    :param min_node_load_value: The minimum load on any node for this metric.
     In future releases of Service Fabric this parameter will be deprecated in
     favor of MinimumNodeLoad.
    :type min_node_load_value: str
    :param minimum_node_load: The minimum load on any node for this metric.
    :type minimum_node_load: str
    :param min_node_load_node_id: The node id of the node with the minimum
     load for this metric.
    :type min_node_load_node_id: ~azure.servicefabric.models.NodeId
    :param max_node_load_value: The maximum load on any node for this metric.
     In future releases of Service Fabric this parameter will be deprecated in
     favor of MaximumNodeLoad.
    :type max_node_load_value: str
    :param maximum_node_load: The maximum load on any node for this metric.
    :type maximum_node_load: str
    :param max_node_load_node_id: The node id of the node with the maximum
     load for this metric.
    :type max_node_load_node_id: ~azure.servicefabric.models.NodeId
    :param planned_load_removal: This value represents the load of the
     replicas that are planned to be removed in the future within the cluster.
     This kind of load is reported for replicas that are currently being moving
     to other nodes and for replicas that are currently being dropped but still
     use the load on the source node.
    :type planned_load_removal: str
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'is_balanced_before': {'key': 'IsBalancedBefore', 'type': 'bool'},
        'is_balanced_after': {'key': 'IsBalancedAfter', 'type': 'bool'},
        'deviation_before': {'key': 'DeviationBefore', 'type': 'str'},
        'deviation_after': {'key': 'DeviationAfter', 'type': 'str'},
        'balancing_threshold': {'key': 'BalancingThreshold', 'type': 'str'},
        'action': {'key': 'Action', 'type': 'str'},
        'activity_threshold': {'key': 'ActivityThreshold', 'type': 'str'},
        'cluster_capacity': {'key': 'ClusterCapacity', 'type': 'str'},
        'cluster_load': {'key': 'ClusterLoad', 'type': 'str'},
        'current_cluster_load': {'key': 'CurrentClusterLoad', 'type': 'str'},
        'cluster_remaining_capacity': {'key': 'ClusterRemainingCapacity', 'type': 'str'},
        'cluster_capacity_remaining': {'key': 'ClusterCapacityRemaining', 'type': 'str'},
        'is_cluster_capacity_violation': {'key': 'IsClusterCapacityViolation', 'type': 'bool'},
        'node_buffer_percentage': {'key': 'NodeBufferPercentage', 'type': 'str'},
        'cluster_buffered_capacity': {'key': 'ClusterBufferedCapacity', 'type': 'str'},
        'buffered_cluster_capacity_remaining': {'key': 'BufferedClusterCapacityRemaining', 'type': 'str'},
        'cluster_remaining_buffered_capacity': {'key': 'ClusterRemainingBufferedCapacity', 'type': 'str'},
        'min_node_load_value': {'key': 'MinNodeLoadValue', 'type': 'str'},
        'minimum_node_load': {'key': 'MinimumNodeLoad', 'type': 'str'},
        'min_node_load_node_id': {'key': 'MinNodeLoadNodeId', 'type': 'NodeId'},
        'max_node_load_value': {'key': 'MaxNodeLoadValue', 'type': 'str'},
        'maximum_node_load': {'key': 'MaximumNodeLoad', 'type': 'str'},
        'max_node_load_node_id': {'key': 'MaxNodeLoadNodeId', 'type': 'NodeId'},
        'planned_load_removal': {'key': 'PlannedLoadRemoval', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LoadMetricInformation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_balanced_before = kwargs.get('is_balanced_before', None)
        self.is_balanced_after = kwargs.get('is_balanced_after', None)
        self.deviation_before = kwargs.get('deviation_before', None)
        self.deviation_after = kwargs.get('deviation_after', None)
        self.balancing_threshold = kwargs.get('balancing_threshold', None)
        self.action = kwargs.get('action', None)
        self.activity_threshold = kwargs.get('activity_threshold', None)
        self.cluster_capacity = kwargs.get('cluster_capacity', None)
        self.cluster_load = kwargs.get('cluster_load', None)
        self.current_cluster_load = kwargs.get('current_cluster_load', None)
        self.cluster_remaining_capacity = kwargs.get('cluster_remaining_capacity', None)
        self.cluster_capacity_remaining = kwargs.get('cluster_capacity_remaining', None)
        self.is_cluster_capacity_violation = kwargs.get('is_cluster_capacity_violation', None)
        self.node_buffer_percentage = kwargs.get('node_buffer_percentage', None)
        self.cluster_buffered_capacity = kwargs.get('cluster_buffered_capacity', None)
        self.buffered_cluster_capacity_remaining = kwargs.get('buffered_cluster_capacity_remaining', None)
        self.cluster_remaining_buffered_capacity = kwargs.get('cluster_remaining_buffered_capacity', None)
        self.min_node_load_value = kwargs.get('min_node_load_value', None)
        self.minimum_node_load = kwargs.get('minimum_node_load', None)
        self.min_node_load_node_id = kwargs.get('min_node_load_node_id', None)
        self.max_node_load_value = kwargs.get('max_node_load_value', None)
        self.maximum_node_load = kwargs.get('maximum_node_load', None)
        self.max_node_load_node_id = kwargs.get('max_node_load_node_id', None)
        self.planned_load_removal = kwargs.get('planned_load_removal', None)


class LoadMetricReport(Model):
    """Represents the load metric report which contains the time metric was
    reported, its name and value.

    :param last_reported_utc: Gets the UTC time when the load was reported.
    :type last_reported_utc: datetime
    :param name: The name of the load metric.
    :type name: str
    :param value: The value of the load metric. In future releases of Service
     Fabric this parameter will be deprecated in favor of CurrentValue.
    :type value: str
    :param current_value: The value of the load metric.
    :type current_value: str
    """

    _attribute_map = {
        'last_reported_utc': {'key': 'LastReportedUtc', 'type': 'iso-8601'},
        'name': {'key': 'Name', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
        'current_value': {'key': 'CurrentValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LoadMetricReport, self).__init__(**kwargs)
        self.last_reported_utc = kwargs.get('last_reported_utc', None)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.current_value = kwargs.get('current_value', None)


class LoadMetricReportInfo(Model):
    """Information about load reported by replica.

    :param name: The name of the metric.
    :type name: str
    :param value: The value of the load for the metric. In future releases of
     Service Fabric this parameter will be deprecated in favor of CurrentValue.
    :type value: int
    :param current_value: The double value of the load for the metric.
    :type current_value: str
    :param last_reported_utc: The UTC time when the load is reported.
    :type last_reported_utc: datetime
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'int'},
        'current_value': {'key': 'CurrentValue', 'type': 'str'},
        'last_reported_utc': {'key': 'LastReportedUtc', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(LoadMetricReportInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.current_value = kwargs.get('current_value', None)
        self.last_reported_utc = kwargs.get('last_reported_utc', None)


class NetworkResourcePropertiesBase(Model):
    """This type describes the properties of a network resource, including its
    kind.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NetworkResourceProperties

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'NetworkResourceProperties': 'NetworkResourceProperties'}
    }

    def __init__(self, **kwargs):
        super(NetworkResourcePropertiesBase, self).__init__(**kwargs)
        self.kind = None


class NetworkResourceProperties(NetworkResourcePropertiesBase):
    """Describes properties of a network resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LocalNetworkResourceProperties

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param description: User readable description of the network.
    :type description: str
    :ivar status: Status of the network. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the network.
    :vartype status_details: str
    """

    _validation = {
        'kind': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Local': 'LocalNetworkResourceProperties'}
    }

    def __init__(self, **kwargs):
        super(NetworkResourceProperties, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.status = None
        self.status_details = None
        self.kind = 'NetworkResourceProperties'


class LocalNetworkResourceProperties(NetworkResourceProperties):
    """Information about a Service Fabric container network local to a single
    Service Fabric cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param description: User readable description of the network.
    :type description: str
    :ivar status: Status of the network. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the network.
    :vartype status_details: str
    :param network_address_prefix: Address space for the local container
     network.
    :type network_address_prefix: str
    """

    _validation = {
        'kind': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'network_address_prefix': {'key': 'networkAddressPrefix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LocalNetworkResourceProperties, self).__init__(**kwargs)
        self.network_address_prefix = kwargs.get('network_address_prefix', None)
        self.kind = 'Local'


class ManagedApplicationIdentity(Model):
    """Describes a managed application identity.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the identity.
    :type name: str
    :param principal_id: The identity's PrincipalId.
    :type principal_id: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'principal_id': {'key': 'PrincipalId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedApplicationIdentity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.principal_id = kwargs.get('principal_id', None)


class ManagedApplicationIdentityDescription(Model):
    """Managed application identity description.

    :param token_service_endpoint: Token service endpoint.
    :type token_service_endpoint: str
    :param managed_identities: A list of managed application identity objects.
    :type managed_identities:
     list[~azure.servicefabric.models.ManagedApplicationIdentity]
    """

    _attribute_map = {
        'token_service_endpoint': {'key': 'TokenServiceEndpoint', 'type': 'str'},
        'managed_identities': {'key': 'ManagedIdentities', 'type': '[ManagedApplicationIdentity]'},
    }

    def __init__(self, **kwargs):
        super(ManagedApplicationIdentityDescription, self).__init__(**kwargs)
        self.token_service_endpoint = kwargs.get('token_service_endpoint', None)
        self.managed_identities = kwargs.get('managed_identities', None)


class MonitoringPolicyDescription(Model):
    """Describes the parameters for monitoring an upgrade in Monitored mode.

    :param failure_action: The compensating action to perform when a Monitored
     upgrade encounters monitoring policy or health policy violations.
     Invalid indicates the failure action is invalid. Rollback specifies that
     the upgrade will start rolling back automatically.
     Manual indicates that the upgrade will switch to UnmonitoredManual upgrade
     mode. Possible values include: 'Invalid', 'Rollback', 'Manual'
    :type failure_action: str or ~azure.servicefabric.models.FailureAction
    :param health_check_wait_duration_in_milliseconds: The amount of time to
     wait after completing an upgrade domain before applying health policies.
     It is first interpreted as a string representing an ISO 8601 duration. If
     that fails, then it is interpreted as a number representing the total
     number of milliseconds.
    :type health_check_wait_duration_in_milliseconds: str
    :param health_check_stable_duration_in_milliseconds: The amount of time
     that the application or cluster must remain healthy before the upgrade
     proceeds to the next upgrade domain. It is first interpreted as a string
     representing an ISO 8601 duration. If that fails, then it is interpreted
     as a number representing the total number of milliseconds.
    :type health_check_stable_duration_in_milliseconds: str
    :param health_check_retry_timeout_in_milliseconds: The amount of time to
     retry health evaluation when the application or cluster is unhealthy
     before FailureAction is executed. It is first interpreted as a string
     representing an ISO 8601 duration. If that fails, then it is interpreted
     as a number representing the total number of milliseconds.
    :type health_check_retry_timeout_in_milliseconds: str
    :param upgrade_timeout_in_milliseconds: The amount of time the overall
     upgrade has to complete before FailureAction is executed. It is first
     interpreted as a string representing an ISO 8601 duration. If that fails,
     then it is interpreted as a number representing the total number of
     milliseconds.
    :type upgrade_timeout_in_milliseconds: str
    :param upgrade_domain_timeout_in_milliseconds: The amount of time each
     upgrade domain has to complete before FailureAction is executed. It is
     first interpreted as a string representing an ISO 8601 duration. If that
     fails, then it is interpreted as a number representing the total number of
     milliseconds.
    :type upgrade_domain_timeout_in_milliseconds: str
    """

    _attribute_map = {
        'failure_action': {'key': 'FailureAction', 'type': 'str'},
        'health_check_wait_duration_in_milliseconds': {'key': 'HealthCheckWaitDurationInMilliseconds', 'type': 'str'},
        'health_check_stable_duration_in_milliseconds': {'key': 'HealthCheckStableDurationInMilliseconds', 'type': 'str'},
        'health_check_retry_timeout_in_milliseconds': {'key': 'HealthCheckRetryTimeoutInMilliseconds', 'type': 'str'},
        'upgrade_timeout_in_milliseconds': {'key': 'UpgradeTimeoutInMilliseconds', 'type': 'str'},
        'upgrade_domain_timeout_in_milliseconds': {'key': 'UpgradeDomainTimeoutInMilliseconds', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MonitoringPolicyDescription, self).__init__(**kwargs)
        self.failure_action = kwargs.get('failure_action', None)
        self.health_check_wait_duration_in_milliseconds = kwargs.get('health_check_wait_duration_in_milliseconds', None)
        self.health_check_stable_duration_in_milliseconds = kwargs.get('health_check_stable_duration_in_milliseconds', None)
        self.health_check_retry_timeout_in_milliseconds = kwargs.get('health_check_retry_timeout_in_milliseconds', None)
        self.upgrade_timeout_in_milliseconds = kwargs.get('upgrade_timeout_in_milliseconds', None)
        self.upgrade_domain_timeout_in_milliseconds = kwargs.get('upgrade_domain_timeout_in_milliseconds', None)


class NameDescription(Model):
    """Describes a Service Fabric name.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The Service Fabric name, including the 'fabric:'
     URI scheme.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class NamedPartitionInformation(PartitionInformation):
    """Describes the partition information for the name as a string that is based
    on partition schemes.

    All required parameters must be populated in order to send to Azure.

    :param id: An internal ID used by Service Fabric to uniquely identify a
     partition. This is a randomly generated GUID when the service was created.
     The partition ID is unique and does not change for the lifetime of the
     service. If the same service was deleted and recreated the IDs of its
     partitions would be different.
    :type id: str
    :param service_partition_kind: Required. Constant filled by server.
    :type service_partition_kind: str
    :param name: Name of the partition.
    :type name: str
    """

    _validation = {
        'service_partition_kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'service_partition_kind': {'key': 'ServicePartitionKind', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NamedPartitionInformation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.service_partition_kind = 'Named'


class PartitionSchemeDescription(Model):
    """Describes how the service is partitioned.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NamedPartitionSchemeDescription,
    SingletonPartitionSchemeDescription,
    UniformInt64RangePartitionSchemeDescription

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Constant filled by server.
    :type partition_scheme: str
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'PartitionScheme', 'type': 'str'},
    }

    _subtype_map = {
        'partition_scheme': {'Named': 'NamedPartitionSchemeDescription', 'Singleton': 'SingletonPartitionSchemeDescription', 'UniformInt64Range': 'UniformInt64RangePartitionSchemeDescription'}
    }

    def __init__(self, **kwargs):
        super(PartitionSchemeDescription, self).__init__(**kwargs)
        self.partition_scheme = None


class NamedPartitionSchemeDescription(PartitionSchemeDescription):
    """Describes the named partition scheme of the service.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Constant filled by server.
    :type partition_scheme: str
    :param count: Required. The number of partitions.
    :type count: int
    :param names: Required. Array of size specified by the ‘Count’ parameter,
     for the names of the partitions.
    :type names: list[str]
    """

    _validation = {
        'partition_scheme': {'required': True},
        'count': {'required': True},
        'names': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'PartitionScheme', 'type': 'str'},
        'count': {'key': 'Count', 'type': 'int'},
        'names': {'key': 'Names', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(NamedPartitionSchemeDescription, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.names = kwargs.get('names', None)
        self.partition_scheme = 'Named'


class NetworkRef(Model):
    """Describes a network reference in a service.

    :param name: Name of the network
    :type name: str
    :param endpoint_refs: A list of endpoints that are exposed on this
     network.
    :type endpoint_refs: list[~azure.servicefabric.models.EndpointRef]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'endpoint_refs': {'key': 'endpointRefs', 'type': '[EndpointRef]'},
    }

    def __init__(self, **kwargs):
        super(NetworkRef, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.endpoint_refs = kwargs.get('endpoint_refs', None)


class NetworkResourceDescription(Model):
    """This type describes a network resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Network resource.
    :type name: str
    :param properties: Required. Describes properties of a network resource.
    :type properties: ~azure.servicefabric.models.NetworkResourceProperties
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'NetworkResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(NetworkResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.properties = kwargs.get('properties', None)


class NodeAbortedEvent(NodeEvent):
    """Node Aborted event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param node_id: Required. Id of Node.
    :type node_id: str
    :param upgrade_domain: Required. Upgrade domain of Node.
    :type upgrade_domain: str
    :param fault_domain: Required. Fault domain of Node.
    :type fault_domain: str
    :param ip_address_or_fqdn: Required. IP address or FQDN.
    :type ip_address_or_fqdn: str
    :param hostname: Required. Name of Host.
    :type hostname: str
    :param is_seed_node: Required. Indicates if it is seed node.
    :type is_seed_node: bool
    :param node_version: Required. Version of Node.
    :type node_version: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance': {'required': True},
        'node_id': {'required': True},
        'upgrade_domain': {'required': True},
        'fault_domain': {'required': True},
        'ip_address_or_fqdn': {'required': True},
        'hostname': {'required': True},
        'is_seed_node': {'required': True},
        'node_version': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'node_id': {'key': 'NodeId', 'type': 'str'},
        'upgrade_domain': {'key': 'UpgradeDomain', 'type': 'str'},
        'fault_domain': {'key': 'FaultDomain', 'type': 'str'},
        'ip_address_or_fqdn': {'key': 'IpAddressOrFQDN', 'type': 'str'},
        'hostname': {'key': 'Hostname', 'type': 'str'},
        'is_seed_node': {'key': 'IsSeedNode', 'type': 'bool'},
        'node_version': {'key': 'NodeVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeAbortedEvent, self).__init__(**kwargs)
        self.node_instance = kwargs.get('node_instance', None)
        self.node_id = kwargs.get('node_id', None)
        self.upgrade_domain = kwargs.get('upgrade_domain', None)
        self.fault_domain = kwargs.get('fault_domain', None)
        self.ip_address_or_fqdn = kwargs.get('ip_address_or_fqdn', None)
        self.hostname = kwargs.get('hostname', None)
        self.is_seed_node = kwargs.get('is_seed_node', None)
        self.node_version = kwargs.get('node_version', None)
        self.kind = 'NodeAborted'


class NodeAddedToClusterEvent(NodeEvent):
    """Node Added event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_id: Required. Id of Node.
    :type node_id: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param node_type: Required. Type of Node.
    :type node_type: str
    :param fabric_version: Required. Fabric version.
    :type fabric_version: str
    :param ip_address_or_fqdn: Required. IP address or FQDN.
    :type ip_address_or_fqdn: str
    :param node_capacities: Required. Capacities.
    :type node_capacities: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_id': {'required': True},
        'node_instance': {'required': True},
        'node_type': {'required': True},
        'fabric_version': {'required': True},
        'ip_address_or_fqdn': {'required': True},
        'node_capacities': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_id': {'key': 'NodeId', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'node_type': {'key': 'NodeType', 'type': 'str'},
        'fabric_version': {'key': 'FabricVersion', 'type': 'str'},
        'ip_address_or_fqdn': {'key': 'IpAddressOrFQDN', 'type': 'str'},
        'node_capacities': {'key': 'NodeCapacities', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeAddedToClusterEvent, self).__init__(**kwargs)
        self.node_id = kwargs.get('node_id', None)
        self.node_instance = kwargs.get('node_instance', None)
        self.node_type = kwargs.get('node_type', None)
        self.fabric_version = kwargs.get('fabric_version', None)
        self.ip_address_or_fqdn = kwargs.get('ip_address_or_fqdn', None)
        self.node_capacities = kwargs.get('node_capacities', None)
        self.kind = 'NodeAddedToCluster'


class NodeClosedEvent(NodeEvent):
    """Node Closed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_id: Required. Id of Node.
    :type node_id: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param error: Required. Describes error.
    :type error: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_id': {'required': True},
        'node_instance': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_id': {'key': 'NodeId', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'error': {'key': 'Error', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeClosedEvent, self).__init__(**kwargs)
        self.node_id = kwargs.get('node_id', None)
        self.node_instance = kwargs.get('node_instance', None)
        self.error = kwargs.get('error', None)
        self.kind = 'NodeClosed'


class NodeDeactivateCompletedEvent(NodeEvent):
    """Node Deactivate Completed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param effective_deactivate_intent: Required. Describes deactivate intent.
    :type effective_deactivate_intent: str
    :param batch_ids_with_deactivate_intent: Required. Batch Ids.
    :type batch_ids_with_deactivate_intent: str
    :param start_time: Required. Start time.
    :type start_time: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance': {'required': True},
        'effective_deactivate_intent': {'required': True},
        'batch_ids_with_deactivate_intent': {'required': True},
        'start_time': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'effective_deactivate_intent': {'key': 'EffectiveDeactivateIntent', 'type': 'str'},
        'batch_ids_with_deactivate_intent': {'key': 'BatchIdsWithDeactivateIntent', 'type': 'str'},
        'start_time': {'key': 'StartTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(NodeDeactivateCompletedEvent, self).__init__(**kwargs)
        self.node_instance = kwargs.get('node_instance', None)
        self.effective_deactivate_intent = kwargs.get('effective_deactivate_intent', None)
        self.batch_ids_with_deactivate_intent = kwargs.get('batch_ids_with_deactivate_intent', None)
        self.start_time = kwargs.get('start_time', None)
        self.kind = 'NodeDeactivateCompleted'


class NodeDeactivateStartedEvent(NodeEvent):
    """Node Deactivate Started event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param batch_id: Required. Batch Id.
    :type batch_id: str
    :param deactivate_intent: Required. Describes deactivate intent.
    :type deactivate_intent: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance': {'required': True},
        'batch_id': {'required': True},
        'deactivate_intent': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'batch_id': {'key': 'BatchId', 'type': 'str'},
        'deactivate_intent': {'key': 'DeactivateIntent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeDeactivateStartedEvent, self).__init__(**kwargs)
        self.node_instance = kwargs.get('node_instance', None)
        self.batch_id = kwargs.get('batch_id', None)
        self.deactivate_intent = kwargs.get('deactivate_intent', None)
        self.kind = 'NodeDeactivateStarted'


class NodeDeactivationInfo(Model):
    """Information about the node deactivation. This information is valid for a
    node that is undergoing deactivation or has already been deactivated.

    :param node_deactivation_intent: The intent or the reason for deactivating
     the node. Following are the possible values for it. Possible values
     include: 'Invalid', 'Pause', 'Restart', 'RemoveData', 'RemoveNode'
    :type node_deactivation_intent: str or
     ~azure.servicefabric.models.NodeDeactivationIntent
    :param node_deactivation_status: The status of node deactivation
     operation. Following are the possible values. Possible values include:
     'None', 'SafetyCheckInProgress', 'SafetyCheckComplete', 'Completed'
    :type node_deactivation_status: str or
     ~azure.servicefabric.models.NodeDeactivationStatus
    :param node_deactivation_task: List of tasks representing the deactivation
     operation on the node.
    :type node_deactivation_task:
     list[~azure.servicefabric.models.NodeDeactivationTask]
    :param pending_safety_checks: List of pending safety checks
    :type pending_safety_checks:
     list[~azure.servicefabric.models.SafetyCheckWrapper]
    """

    _attribute_map = {
        'node_deactivation_intent': {'key': 'NodeDeactivationIntent', 'type': 'str'},
        'node_deactivation_status': {'key': 'NodeDeactivationStatus', 'type': 'str'},
        'node_deactivation_task': {'key': 'NodeDeactivationTask', 'type': '[NodeDeactivationTask]'},
        'pending_safety_checks': {'key': 'PendingSafetyChecks', 'type': '[SafetyCheckWrapper]'},
    }

    def __init__(self, **kwargs):
        super(NodeDeactivationInfo, self).__init__(**kwargs)
        self.node_deactivation_intent = kwargs.get('node_deactivation_intent', None)
        self.node_deactivation_status = kwargs.get('node_deactivation_status', None)
        self.node_deactivation_task = kwargs.get('node_deactivation_task', None)
        self.pending_safety_checks = kwargs.get('pending_safety_checks', None)


class NodeDeactivationTask(Model):
    """The task representing the deactivation operation on the node.

    :param node_deactivation_task_id: Identity of the task related to
     deactivation operation on the node.
    :type node_deactivation_task_id:
     ~azure.servicefabric.models.NodeDeactivationTaskId
    :param node_deactivation_intent: The intent or the reason for deactivating
     the node. Following are the possible values for it. Possible values
     include: 'Invalid', 'Pause', 'Restart', 'RemoveData', 'RemoveNode'
    :type node_deactivation_intent: str or
     ~azure.servicefabric.models.NodeDeactivationIntent
    """

    _attribute_map = {
        'node_deactivation_task_id': {'key': 'NodeDeactivationTaskId', 'type': 'NodeDeactivationTaskId'},
        'node_deactivation_intent': {'key': 'NodeDeactivationIntent', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeDeactivationTask, self).__init__(**kwargs)
        self.node_deactivation_task_id = kwargs.get('node_deactivation_task_id', None)
        self.node_deactivation_intent = kwargs.get('node_deactivation_intent', None)


class NodeDeactivationTaskId(Model):
    """Identity of the task related to deactivation operation on the node.

    :param id: Value of the task id.
    :type id: str
    :param node_deactivation_task_type: The type of the task that performed
     the node deactivation. Following are the possible values. Possible values
     include: 'Invalid', 'Infrastructure', 'Repair', 'Client'
    :type node_deactivation_task_type: str or
     ~azure.servicefabric.models.NodeDeactivationTaskType
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'node_deactivation_task_type': {'key': 'NodeDeactivationTaskType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeDeactivationTaskId, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.node_deactivation_task_type = kwargs.get('node_deactivation_task_type', None)


class NodeDownEvent(NodeEvent):
    """Node Down event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param last_node_up_at: Required. Time when Node was last up.
    :type last_node_up_at: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance': {'required': True},
        'last_node_up_at': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'last_node_up_at': {'key': 'LastNodeUpAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(NodeDownEvent, self).__init__(**kwargs)
        self.node_instance = kwargs.get('node_instance', None)
        self.last_node_up_at = kwargs.get('last_node_up_at', None)
        self.kind = 'NodeDown'


class NodeHealth(EntityHealth):
    """Information about the health of a Service Fabric node.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param name: Name of the node whose health information is described by
     this object.
    :type name: str
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeHealth, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class NodeHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for a node, containing information about the
    data and the algorithm used by health store to evaluate health. The
    evaluation is returned only when the aggregated health state is either
    Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the current aggregated health state of the node. The types of the
     unhealthy evaluations can be EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(NodeHealthEvaluation, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Node'


class NodeHealthReportExpiredEvent(NodeEvent):
    """Node Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance_id: Required. Id of Node instance.
    :type node_instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance_id': {'key': 'NodeInstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(NodeHealthReportExpiredEvent, self).__init__(**kwargs)
        self.node_instance_id = kwargs.get('node_instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'NodeHealthReportExpired'


class NodeHealthState(EntityHealthState):
    """Represents the health state of a node, which contains the node identifier
    and its aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param name: The name of a Service Fabric node.
    :type name: str
    :param id: An internal ID used by Service Fabric to uniquely identify a
     node. Node Id is deterministically generated from node name.
    :type id: ~azure.servicefabric.models.NodeId
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'NodeId'},
    }

    def __init__(self, **kwargs):
        super(NodeHealthState, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)


class NodeHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a node, which contains the node name
    and its aggregated health state.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeHealthStateChunk, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)


class NodeHealthStateChunkList(EntityHealthStateChunkList):
    """The list of node health state chunks in the cluster that respect the input
    filters in the chunk query. Returned by get cluster health state chunks
    query.

    :param total_count: Total number of entity health state objects that match
     the specified filters from the cluster health chunk query description.
    :type total_count: long
    :param items: The list of node health state chunks that respect the input
     filters in the chunk query.
    :type items: list[~azure.servicefabric.models.NodeHealthStateChunk]
    """

    _attribute_map = {
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'items': {'key': 'Items', 'type': '[NodeHealthStateChunk]'},
    }

    def __init__(self, **kwargs):
        super(NodeHealthStateChunkList, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class NodeHealthStateFilter(Model):
    """Defines matching criteria to determine whether a node should be included in
    the returned cluster health chunk.
    One filter can match zero, one or multiple nodes, depending on its
    properties.
    Can be specified in the cluster health chunk query description.

    :param node_name_filter: Name of the node that matches the filter. The
     filter is applied only to the specified node, if it exists.
     If the node doesn't exist, no node is returned in the cluster health chunk
     based on this filter.
     If the node exists, it is included in the cluster health chunk if the
     health state matches the other filter properties.
     If not specified, all nodes that match the parent filters (if any) are
     taken into consideration and matched against the other filter members,
     like health state filter.
    :type node_name_filter: str
    :param health_state_filter: The filter for the health state of the nodes.
     It allows selecting nodes if they match the desired health states.
     The possible values are integer value of one of the following health
     states. Only nodes that match the filter are returned. All nodes are used
     to evaluate the cluster aggregated health state.
     If not specified, default value is None, unless the node name is
     specified. If the filter has default value and node name is specified, the
     matching node is returned.
     The state values are flag-based enumeration, so the value could be a
     combination of these values obtained using bitwise 'OR' operator.
     For example, if the provided value is 6, it matches nodes with HealthState
     value of OK (2) and Warning (4).
     - Default - Default value. Matches any HealthState. The value is zero.
     - None - Filter that doesn't match any HealthState value. Used in order to
     return no results on a given collection of states. The value is 1.
     - Ok - Filter that matches input with HealthState value Ok. The value is
     2.
     - Warning - Filter that matches input with HealthState value Warning. The
     value is 4.
     - Error - Filter that matches input with HealthState value Error. The
     value is 8.
     - All - Filter that matches input with any HealthState value. The value is
     65535. Default value: 0 .
    :type health_state_filter: int
    """

    _attribute_map = {
        'node_name_filter': {'key': 'NodeNameFilter', 'type': 'str'},
        'health_state_filter': {'key': 'HealthStateFilter', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(NodeHealthStateFilter, self).__init__(**kwargs)
        self.node_name_filter = kwargs.get('node_name_filter', None)
        self.health_state_filter = kwargs.get('health_state_filter', 0)


class NodeId(Model):
    """An internal ID used by Service Fabric to uniquely identify a node. Node Id
    is deterministically generated from node name.

    :param id: Value of the node Id. This is a 128 bit integer.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeId, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class NodeImpact(Model):
    """Describes the expected impact of a repair to a particular node.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param node_name: Required. The name of the impacted node.
    :type node_name: str
    :param impact_level: The level of impact expected. Possible values
     include: 'Invalid', 'None', 'Restart', 'RemoveData', 'RemoveNode'
    :type impact_level: str or ~azure.servicefabric.models.ImpactLevel
    """

    _validation = {
        'node_name': {'required': True},
    }

    _attribute_map = {
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'impact_level': {'key': 'ImpactLevel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeImpact, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.impact_level = kwargs.get('impact_level', None)


class NodeInfo(Model):
    """Information about a node in Service Fabric cluster.

    :param name: The name of a Service Fabric node.
    :type name: str
    :param ip_address_or_fqdn: The IP address or fully qualified domain name
     of the node.
    :type ip_address_or_fqdn: str
    :param type: The type of the node.
    :type type: str
    :param code_version: The version of Service Fabric binaries that the node
     is running.
    :type code_version: str
    :param config_version: The version of Service Fabric cluster manifest that
     the node is using.
    :type config_version: str
    :param node_status: The status of the node. Possible values include:
     'Invalid', 'Up', 'Down', 'Enabling', 'Disabling', 'Disabled', 'Unknown',
     'Removed'
    :type node_status: str or ~azure.servicefabric.models.NodeStatus
    :param node_up_time_in_seconds: Time in seconds since the node has been in
     NodeStatus Up. Value zero indicates that the node is not Up.
    :type node_up_time_in_seconds: str
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param is_seed_node: Indicates if the node is a seed node or not. Returns
     true if the node is a seed node, otherwise false. A quorum of seed nodes
     are required for proper operation of Service Fabric cluster.
    :type is_seed_node: bool
    :param upgrade_domain: The upgrade domain of the node.
    :type upgrade_domain: str
    :param fault_domain: The fault domain of the node.
    :type fault_domain: str
    :param id: An internal ID used by Service Fabric to uniquely identify a
     node. Node Id is deterministically generated from node name.
    :type id: ~azure.servicefabric.models.NodeId
    :param instance_id: The ID representing the node instance. While the ID of
     the node is deterministically generated from the node name and remains
     same across restarts, the InstanceId changes every time node restarts.
    :type instance_id: str
    :param node_deactivation_info: Information about the node deactivation.
     This information is valid for a node that is undergoing deactivation or
     has already been deactivated.
    :type node_deactivation_info:
     ~azure.servicefabric.models.NodeDeactivationInfo
    :param is_stopped: Indicates if the node is stopped by calling stop node
     API or not. Returns true if the node is stopped, otherwise false.
    :type is_stopped: bool
    :param node_down_time_in_seconds: Time in seconds since the node has been
     in NodeStatus Down. Value zero indicates node is not NodeStatus Down.
    :type node_down_time_in_seconds: str
    :param node_up_at: Date time in UTC when the node came up. If the node has
     never been up then this value will be zero date time.
    :type node_up_at: datetime
    :param node_down_at: Date time in UTC when the node went down. If node has
     never been down then this value will be zero date time.
    :type node_down_at: datetime
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'ip_address_or_fqdn': {'key': 'IpAddressOrFQDN', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'code_version': {'key': 'CodeVersion', 'type': 'str'},
        'config_version': {'key': 'ConfigVersion', 'type': 'str'},
        'node_status': {'key': 'NodeStatus', 'type': 'str'},
        'node_up_time_in_seconds': {'key': 'NodeUpTimeInSeconds', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'is_seed_node': {'key': 'IsSeedNode', 'type': 'bool'},
        'upgrade_domain': {'key': 'UpgradeDomain', 'type': 'str'},
        'fault_domain': {'key': 'FaultDomain', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'NodeId'},
        'instance_id': {'key': 'InstanceId', 'type': 'str'},
        'node_deactivation_info': {'key': 'NodeDeactivationInfo', 'type': 'NodeDeactivationInfo'},
        'is_stopped': {'key': 'IsStopped', 'type': 'bool'},
        'node_down_time_in_seconds': {'key': 'NodeDownTimeInSeconds', 'type': 'str'},
        'node_up_at': {'key': 'NodeUpAt', 'type': 'iso-8601'},
        'node_down_at': {'key': 'NodeDownAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(NodeInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.ip_address_or_fqdn = kwargs.get('ip_address_or_fqdn', None)
        self.type = kwargs.get('type', None)
        self.code_version = kwargs.get('code_version', None)
        self.config_version = kwargs.get('config_version', None)
        self.node_status = kwargs.get('node_status', None)
        self.node_up_time_in_seconds = kwargs.get('node_up_time_in_seconds', None)
        self.health_state = kwargs.get('health_state', None)
        self.is_seed_node = kwargs.get('is_seed_node', None)
        self.upgrade_domain = kwargs.get('upgrade_domain', None)
        self.fault_domain = kwargs.get('fault_domain', None)
        self.id = kwargs.get('id', None)
        self.instance_id = kwargs.get('instance_id', None)
        self.node_deactivation_info = kwargs.get('node_deactivation_info', None)
        self.is_stopped = kwargs.get('is_stopped', None)
        self.node_down_time_in_seconds = kwargs.get('node_down_time_in_seconds', None)
        self.node_up_at = kwargs.get('node_up_at', None)
        self.node_down_at = kwargs.get('node_down_at', None)


class NodeLoadInfo(Model):
    """Information about load on a Service Fabric node. It holds a summary of all
    metrics and their load on a node.

    :param node_name: Name of the node for which the load information is
     provided by this object.
    :type node_name: str
    :param node_load_metric_information: List that contains metrics and their
     load information on this node.
    :type node_load_metric_information:
     list[~azure.servicefabric.models.NodeLoadMetricInformation]
    """

    _attribute_map = {
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_load_metric_information': {'key': 'NodeLoadMetricInformation', 'type': '[NodeLoadMetricInformation]'},
    }

    def __init__(self, **kwargs):
        super(NodeLoadInfo, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.node_load_metric_information = kwargs.get('node_load_metric_information', None)


class NodeLoadMetricInformation(Model):
    """Represents data structure that contains load information for a certain
    metric on a node.

    :param name: Name of the metric for which this load information is
     provided.
    :type name: str
    :param node_capacity: Total capacity on the node for this metric.
    :type node_capacity: str
    :param node_load: Current load on the node for this metric. In future
     releases of Service Fabric this parameter will be deprecated in favor of
     CurrentNodeLoad.
    :type node_load: str
    :param node_remaining_capacity: The remaining capacity on the node for
     this metric. In future releases of Service Fabric this parameter will be
     deprecated in favor of NodeCapacityRemaining.
    :type node_remaining_capacity: str
    :param is_capacity_violation: Indicates if there is a capacity violation
     for this metric on the node.
    :type is_capacity_violation: bool
    :param node_buffered_capacity: The value that indicates the reserved
     capacity for this metric on the node.
    :type node_buffered_capacity: str
    :param node_remaining_buffered_capacity: The remaining reserved capacity
     for this metric on the node. In future releases of Service Fabric this
     parameter will be deprecated in favor of BufferedNodeCapacityRemaining.
    :type node_remaining_buffered_capacity: str
    :param current_node_load: Current load on the node for this metric.
    :type current_node_load: str
    :param node_capacity_remaining: The remaining capacity on the node for the
     metric.
    :type node_capacity_remaining: str
    :param buffered_node_capacity_remaining: The remaining capacity which is
     not reserved by NodeBufferPercentage for this metric on the node.
    :type buffered_node_capacity_remaining: str
    :param planned_node_load_removal: This value represents the load of the
     replicas that are planned to be removed in the future.
     This kind of load is reported for replicas that are currently being moving
     to other nodes and for replicas that are currently being dropped but still
     use the load on the source node.
    :type planned_node_load_removal: str
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'node_capacity': {'key': 'NodeCapacity', 'type': 'str'},
        'node_load': {'key': 'NodeLoad', 'type': 'str'},
        'node_remaining_capacity': {'key': 'NodeRemainingCapacity', 'type': 'str'},
        'is_capacity_violation': {'key': 'IsCapacityViolation', 'type': 'bool'},
        'node_buffered_capacity': {'key': 'NodeBufferedCapacity', 'type': 'str'},
        'node_remaining_buffered_capacity': {'key': 'NodeRemainingBufferedCapacity', 'type': 'str'},
        'current_node_load': {'key': 'CurrentNodeLoad', 'type': 'str'},
        'node_capacity_remaining': {'key': 'NodeCapacityRemaining', 'type': 'str'},
        'buffered_node_capacity_remaining': {'key': 'BufferedNodeCapacityRemaining', 'type': 'str'},
        'planned_node_load_removal': {'key': 'PlannedNodeLoadRemoval', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeLoadMetricInformation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.node_capacity = kwargs.get('node_capacity', None)
        self.node_load = kwargs.get('node_load', None)
        self.node_remaining_capacity = kwargs.get('node_remaining_capacity', None)
        self.is_capacity_violation = kwargs.get('is_capacity_violation', None)
        self.node_buffered_capacity = kwargs.get('node_buffered_capacity', None)
        self.node_remaining_buffered_capacity = kwargs.get('node_remaining_buffered_capacity', None)
        self.current_node_load = kwargs.get('current_node_load', None)
        self.node_capacity_remaining = kwargs.get('node_capacity_remaining', None)
        self.buffered_node_capacity_remaining = kwargs.get('buffered_node_capacity_remaining', None)
        self.planned_node_load_removal = kwargs.get('planned_node_load_removal', None)


class NodeNewHealthReportEvent(NodeEvent):
    """Node Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance_id: Required. Id of Node instance.
    :type node_instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance_id': {'key': 'NodeInstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(NodeNewHealthReportEvent, self).__init__(**kwargs)
        self.node_instance_id = kwargs.get('node_instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'NodeNewHealthReport'


class NodeOpenFailedEvent(NodeEvent):
    """Node Open Failed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param node_id: Required. Id of Node.
    :type node_id: str
    :param upgrade_domain: Required. Upgrade domain of Node.
    :type upgrade_domain: str
    :param fault_domain: Required. Fault domain of Node.
    :type fault_domain: str
    :param ip_address_or_fqdn: Required. IP address or FQDN.
    :type ip_address_or_fqdn: str
    :param hostname: Required. Name of Host.
    :type hostname: str
    :param is_seed_node: Required. Indicates if it is seed node.
    :type is_seed_node: bool
    :param node_version: Required. Version of Node.
    :type node_version: str
    :param error: Required. Describes the error.
    :type error: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance': {'required': True},
        'node_id': {'required': True},
        'upgrade_domain': {'required': True},
        'fault_domain': {'required': True},
        'ip_address_or_fqdn': {'required': True},
        'hostname': {'required': True},
        'is_seed_node': {'required': True},
        'node_version': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'node_id': {'key': 'NodeId', 'type': 'str'},
        'upgrade_domain': {'key': 'UpgradeDomain', 'type': 'str'},
        'fault_domain': {'key': 'FaultDomain', 'type': 'str'},
        'ip_address_or_fqdn': {'key': 'IpAddressOrFQDN', 'type': 'str'},
        'hostname': {'key': 'Hostname', 'type': 'str'},
        'is_seed_node': {'key': 'IsSeedNode', 'type': 'bool'},
        'node_version': {'key': 'NodeVersion', 'type': 'str'},
        'error': {'key': 'Error', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeOpenFailedEvent, self).__init__(**kwargs)
        self.node_instance = kwargs.get('node_instance', None)
        self.node_id = kwargs.get('node_id', None)
        self.upgrade_domain = kwargs.get('upgrade_domain', None)
        self.fault_domain = kwargs.get('fault_domain', None)
        self.ip_address_or_fqdn = kwargs.get('ip_address_or_fqdn', None)
        self.hostname = kwargs.get('hostname', None)
        self.is_seed_node = kwargs.get('is_seed_node', None)
        self.node_version = kwargs.get('node_version', None)
        self.error = kwargs.get('error', None)
        self.kind = 'NodeOpenFailed'


class NodeOpenSucceededEvent(NodeEvent):
    """Node Opened Succeeded event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param node_id: Required. Id of Node.
    :type node_id: str
    :param upgrade_domain: Required. Upgrade domain of Node.
    :type upgrade_domain: str
    :param fault_domain: Required. Fault domain of Node.
    :type fault_domain: str
    :param ip_address_or_fqdn: Required. IP address or FQDN.
    :type ip_address_or_fqdn: str
    :param hostname: Required. Name of Host.
    :type hostname: str
    :param is_seed_node: Required. Indicates if it is seed node.
    :type is_seed_node: bool
    :param node_version: Required. Version of Node.
    :type node_version: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance': {'required': True},
        'node_id': {'required': True},
        'upgrade_domain': {'required': True},
        'fault_domain': {'required': True},
        'ip_address_or_fqdn': {'required': True},
        'hostname': {'required': True},
        'is_seed_node': {'required': True},
        'node_version': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'node_id': {'key': 'NodeId', 'type': 'str'},
        'upgrade_domain': {'key': 'UpgradeDomain', 'type': 'str'},
        'fault_domain': {'key': 'FaultDomain', 'type': 'str'},
        'ip_address_or_fqdn': {'key': 'IpAddressOrFQDN', 'type': 'str'},
        'hostname': {'key': 'Hostname', 'type': 'str'},
        'is_seed_node': {'key': 'IsSeedNode', 'type': 'bool'},
        'node_version': {'key': 'NodeVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeOpenSucceededEvent, self).__init__(**kwargs)
        self.node_instance = kwargs.get('node_instance', None)
        self.node_id = kwargs.get('node_id', None)
        self.upgrade_domain = kwargs.get('upgrade_domain', None)
        self.fault_domain = kwargs.get('fault_domain', None)
        self.ip_address_or_fqdn = kwargs.get('ip_address_or_fqdn', None)
        self.hostname = kwargs.get('hostname', None)
        self.is_seed_node = kwargs.get('is_seed_node', None)
        self.node_version = kwargs.get('node_version', None)
        self.kind = 'NodeOpenSucceeded'


class NodeRemovedFromClusterEvent(NodeEvent):
    """Node Removed event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_id: Required. Id of Node.
    :type node_id: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param node_type: Required. Type of Node.
    :type node_type: str
    :param fabric_version: Required. Fabric version.
    :type fabric_version: str
    :param ip_address_or_fqdn: Required. IP address or FQDN.
    :type ip_address_or_fqdn: str
    :param node_capacities: Required. Capacities.
    :type node_capacities: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_id': {'required': True},
        'node_instance': {'required': True},
        'node_type': {'required': True},
        'fabric_version': {'required': True},
        'ip_address_or_fqdn': {'required': True},
        'node_capacities': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_id': {'key': 'NodeId', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'node_type': {'key': 'NodeType', 'type': 'str'},
        'fabric_version': {'key': 'FabricVersion', 'type': 'str'},
        'ip_address_or_fqdn': {'key': 'IpAddressOrFQDN', 'type': 'str'},
        'node_capacities': {'key': 'NodeCapacities', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeRemovedFromClusterEvent, self).__init__(**kwargs)
        self.node_id = kwargs.get('node_id', None)
        self.node_instance = kwargs.get('node_instance', None)
        self.node_type = kwargs.get('node_type', None)
        self.fabric_version = kwargs.get('fabric_version', None)
        self.ip_address_or_fqdn = kwargs.get('ip_address_or_fqdn', None)
        self.node_capacities = kwargs.get('node_capacities', None)
        self.kind = 'NodeRemovedFromCluster'


class RepairImpactDescriptionBase(Model):
    """Describes the expected impact of executing a repair task.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NodeRepairImpactDescription

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Node': 'NodeRepairImpactDescription'}
    }

    def __init__(self, **kwargs):
        super(RepairImpactDescriptionBase, self).__init__(**kwargs)
        self.kind = None


class NodeRepairImpactDescription(RepairImpactDescriptionBase):
    """Describes the expected impact of a repair on a set of nodes.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_impact_list: The list of nodes impacted by a repair action and
     their respective expected impact.
    :type node_impact_list: list[~azure.servicefabric.models.NodeImpact]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_impact_list': {'key': 'NodeImpactList', 'type': '[NodeImpact]'},
    }

    def __init__(self, **kwargs):
        super(NodeRepairImpactDescription, self).__init__(**kwargs)
        self.node_impact_list = kwargs.get('node_impact_list', None)
        self.kind = 'Node'


class RepairTargetDescriptionBase(Model):
    """Describes the entities targeted by a repair action.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NodeRepairTargetDescription

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Node': 'NodeRepairTargetDescription'}
    }

    def __init__(self, **kwargs):
        super(RepairTargetDescriptionBase, self).__init__(**kwargs)
        self.kind = None


class NodeRepairTargetDescription(RepairTargetDescriptionBase):
    """Describes the list of nodes targeted by a repair action.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_names: The list of nodes targeted by a repair action.
    :type node_names: list[str]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_names': {'key': 'NodeNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(NodeRepairTargetDescription, self).__init__(**kwargs)
        self.node_names = kwargs.get('node_names', None)
        self.kind = 'Node'


class NodeResult(Model):
    """Contains information about a node that was targeted by a user-induced
    operation.

    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    :param node_instance_id: The node instance id.
    :type node_instance_id: str
    """

    _attribute_map = {
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance_id': {'key': 'NodeInstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeResult, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.node_instance_id = kwargs.get('node_instance_id', None)


class NodesHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for nodes, containing health evaluations for
    each unhealthy node that impacted current aggregated health state. Can be
    returned when evaluating cluster health and the aggregated health state is
    either Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param max_percent_unhealthy_nodes: Maximum allowed percentage of
     unhealthy nodes from the ClusterHealthPolicy.
    :type max_percent_unhealthy_nodes: int
    :param total_count: Total number of nodes found in the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     NodeHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'max_percent_unhealthy_nodes': {'key': 'MaxPercentUnhealthyNodes', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(NodesHealthEvaluation, self).__init__(**kwargs)
        self.max_percent_unhealthy_nodes = kwargs.get('max_percent_unhealthy_nodes', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Nodes'


class NodeTransitionProgress(Model):
    """Information about an NodeTransition operation.  This class contains an
    OperationState and a NodeTransitionResult.  The NodeTransitionResult is not
    valid until OperationState
    is Completed or Faulted.

    :param state: The state of the operation. Possible values include:
     'Invalid', 'Running', 'RollingBack', 'Completed', 'Faulted', 'Cancelled',
     'ForceCancelled'
    :type state: str or ~azure.servicefabric.models.OperationState
    :param node_transition_result: Represents information about an operation
     in a terminal state (Completed or Faulted).
    :type node_transition_result:
     ~azure.servicefabric.models.NodeTransitionResult
    """

    _attribute_map = {
        'state': {'key': 'State', 'type': 'str'},
        'node_transition_result': {'key': 'NodeTransitionResult', 'type': 'NodeTransitionResult'},
    }

    def __init__(self, **kwargs):
        super(NodeTransitionProgress, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.node_transition_result = kwargs.get('node_transition_result', None)


class NodeTransitionResult(Model):
    """Represents information about an operation in a terminal state (Completed or
    Faulted).

    :param error_code: If OperationState is Completed, this is 0.  If
     OperationState is Faulted, this is an error code indicating the reason.
    :type error_code: int
    :param node_result: Contains information about a node that was targeted by
     a user-induced operation.
    :type node_result: ~azure.servicefabric.models.NodeResult
    """

    _attribute_map = {
        'error_code': {'key': 'ErrorCode', 'type': 'int'},
        'node_result': {'key': 'NodeResult', 'type': 'NodeResult'},
    }

    def __init__(self, **kwargs):
        super(NodeTransitionResult, self).__init__(**kwargs)
        self.error_code = kwargs.get('error_code', None)
        self.node_result = kwargs.get('node_result', None)


class NodeUpEvent(NodeEvent):
    """Node Up event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance: Required. Id of Node instance.
    :type node_instance: long
    :param last_node_down_at: Required. Time when Node was last down.
    :type last_node_down_at: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'node_name': {'required': True},
        'node_instance': {'required': True},
        'last_node_down_at': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance': {'key': 'NodeInstance', 'type': 'long'},
        'last_node_down_at': {'key': 'LastNodeDownAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(NodeUpEvent, self).__init__(**kwargs)
        self.node_instance = kwargs.get('node_instance', None)
        self.last_node_down_at = kwargs.get('last_node_down_at', None)
        self.kind = 'NodeUp'


class NodeUpgradeProgressInfo(Model):
    """Information about the upgrading node and its status.

    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    :param upgrade_phase: The state of the upgrading node. Possible values
     include: 'Invalid', 'PreUpgradeSafetyCheck', 'Upgrading',
     'PostUpgradeSafetyCheck'
    :type upgrade_phase: str or ~azure.servicefabric.models.NodeUpgradePhase
    :param pending_safety_checks: List of pending safety checks
    :type pending_safety_checks:
     list[~azure.servicefabric.models.SafetyCheckWrapper]
    """

    _attribute_map = {
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'upgrade_phase': {'key': 'UpgradePhase', 'type': 'str'},
        'pending_safety_checks': {'key': 'PendingSafetyChecks', 'type': '[SafetyCheckWrapper]'},
    }

    def __init__(self, **kwargs):
        super(NodeUpgradeProgressInfo, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.upgrade_phase = kwargs.get('upgrade_phase', None)
        self.pending_safety_checks = kwargs.get('pending_safety_checks', None)


class OperationStatus(Model):
    """Contains the OperationId, OperationState, and OperationType for
    user-induced operations.

    :param operation_id: A GUID that identifies a call to this API.  This is
     also passed into the corresponding GetProgress API.
    :type operation_id: str
    :param state: The state of the operation. Possible values include:
     'Invalid', 'Running', 'RollingBack', 'Completed', 'Faulted', 'Cancelled',
     'ForceCancelled'
    :type state: str or ~azure.servicefabric.models.OperationState
    :param type: The type of the operation. Possible values include:
     'Invalid', 'PartitionDataLoss', 'PartitionQuorumLoss', 'PartitionRestart',
     'NodeTransition'
    :type type: str or ~azure.servicefabric.models.OperationType
    """

    _attribute_map = {
        'operation_id': {'key': 'OperationId', 'type': 'str'},
        'state': {'key': 'State', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationStatus, self).__init__(**kwargs)
        self.operation_id = kwargs.get('operation_id', None)
        self.state = kwargs.get('state', None)
        self.type = kwargs.get('type', None)


class PackageSharingPolicyInfo(Model):
    """Represents a policy for the package sharing.

    :param shared_package_name: The name of code, configuration or data
     package that should be shared.
    :type shared_package_name: str
    :param package_sharing_scope: Represents the scope for
     PackageSharingPolicy. This is specified during DeployServicePackageToNode
     operation. Possible values include: 'None', 'All', 'Code', 'Config',
     'Data'
    :type package_sharing_scope: str or
     ~azure.servicefabric.models.PackageSharingPolicyScope
    """

    _attribute_map = {
        'shared_package_name': {'key': 'SharedPackageName', 'type': 'str'},
        'package_sharing_scope': {'key': 'PackageSharingScope', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PackageSharingPolicyInfo, self).__init__(**kwargs)
        self.shared_package_name = kwargs.get('shared_package_name', None)
        self.package_sharing_scope = kwargs.get('package_sharing_scope', None)


class PagedApplicationInfoList(Model):
    """The list of applications in the cluster. The list is paged when all of the
    results cannot fit in a single message. The next set of results can be
    obtained by executing the same query with the continuation token provided
    in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of application information.
    :type items: list[~azure.servicefabric.models.ApplicationInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ApplicationInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedApplicationInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedApplicationResourceDescriptionList(Model):
    """The list of application resources. The list is paged when all of the
    results cannot fit in a single message. The next set of results can be
    obtained by executing the same query with the continuation token provided
    in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items:
     list[~azure.servicefabric.models.ApplicationResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ApplicationResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedApplicationResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedApplicationTypeInfoList(Model):
    """The list of application types that are provisioned or being provisioned in
    the cluster. The list is paged when all of the results cannot fit in a
    single message. The next set of results can be obtained by executing the
    same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of application type information.
    :type items: list[~azure.servicefabric.models.ApplicationTypeInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ApplicationTypeInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedApplicationTypeInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedBackupConfigurationInfoList(Model):
    """The list of backup configuration information. The list is paged when all of
    the results cannot fit in a single message. The next set of results can be
    obtained by executing the same query with the continuation token provided
    in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of backup configuration information.
    :type items: list[~azure.servicefabric.models.BackupConfigurationInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[BackupConfigurationInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedBackupConfigurationInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedBackupEntityList(Model):
    """The list of backup entities that are being periodically backed. The list is
    paged when all of the results cannot fit in a single message. The next set
    of results can be obtained by executing the same query with the
    continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of backup entity information.
    :type items: list[~azure.servicefabric.models.BackupEntity]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[BackupEntity]'},
    }

    def __init__(self, **kwargs):
        super(PagedBackupEntityList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedBackupInfoList(Model):
    """The list of backups. The list is paged when all of the results cannot fit
    in a single message. The next set of results can be obtained by executing
    the same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of backup information.
    :type items: list[~azure.servicefabric.models.BackupInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[BackupInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedBackupInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedBackupPolicyDescriptionList(Model):
    """The list of backup policies configured in the cluster. The list is paged
    when all of the results cannot fit in a single message. The next set of
    results can be obtained by executing the same query with the continuation
    token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: The list of backup policies information.
    :type items: list[~azure.servicefabric.models.BackupPolicyDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[BackupPolicyDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedBackupPolicyDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedComposeDeploymentStatusInfoList(Model):
    """The list of compose deployments in the cluster. The list is paged when all
    of the results cannot fit in a single message. The next set of results can
    be obtained by executing the same query with the continuation token
    provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of compose deployment status information.
    :type items: list[~azure.servicefabric.models.ComposeDeploymentStatusInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ComposeDeploymentStatusInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedComposeDeploymentStatusInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedDeployedApplicationInfoList(Model):
    """The list of deployed applications in activating, downloading, or active
    states on a node.
    The list is paged when all of the results cannot fit in a single message.
    The next set of results can be obtained by executing the same query with
    the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of deployed application information.
    :type items: list[~azure.servicefabric.models.DeployedApplicationInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[DeployedApplicationInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedDeployedApplicationInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedGatewayResourceDescriptionList(Model):
    """The list of gateway resources. The list is paged when all of the results
    cannot fit in a single message. The next set of results can be obtained by
    executing the same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items: list[~azure.servicefabric.models.GatewayResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[GatewayResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedGatewayResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedNetworkResourceDescriptionList(Model):
    """The list of network resources. The list is paged when all of the results
    cannot fit in a single message. The next set of results can be obtained by
    executing the same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items: list[~azure.servicefabric.models.NetworkResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[NetworkResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedNetworkResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedNodeInfoList(Model):
    """The list of nodes in the cluster. The list is paged when all of the results
    cannot fit in a single message. The next set of results can be obtained by
    executing the same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of node information.
    :type items: list[~azure.servicefabric.models.NodeInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[NodeInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedNodeInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedPropertyInfoList(Model):
    """The paged list of Service Fabric properties under a given name. The list is
    paged when all of the results cannot fit in a single message. The next set
    of results can be obtained by executing the same query with the
    continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param is_consistent: Indicates whether any property under the given name
     has been modified during the enumeration. If there was a modification,
     this property value is false.
    :type is_consistent: bool
    :param properties: List of property information.
    :type properties: list[~azure.servicefabric.models.PropertyInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'is_consistent': {'key': 'IsConsistent', 'type': 'bool'},
        'properties': {'key': 'Properties', 'type': '[PropertyInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedPropertyInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.is_consistent = kwargs.get('is_consistent', None)
        self.properties = kwargs.get('properties', None)


class PagedReplicaInfoList(Model):
    """The list of replicas in the cluster for a given partition. The list is
    paged when all of the results cannot fit in a single message. The next set
    of results can be obtained by executing the same query with the
    continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of replica information.
    :type items: list[~azure.servicefabric.models.ReplicaInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ReplicaInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedReplicaInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedSecretResourceDescriptionList(Model):
    """The list of secret resources. The list is paged when all of the results
    cannot fit in a single message. The next set of results can be obtained by
    executing the same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items: list[~azure.servicefabric.models.SecretResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[SecretResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedSecretResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedSecretValueResourceDescriptionList(Model):
    """The list of values of a secret resource, paged if the number of results
    exceeds the limits of a single message. The next set of results can be
    obtained by executing the same query with the continuation token provided
    in the previous page.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items:
     list[~azure.servicefabric.models.SecretValueResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[SecretValueResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedSecretValueResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedServiceInfoList(Model):
    """The list of services in the cluster for an application. The list is paged
    when all of the results cannot fit in a single message. The next set of
    results can be obtained by executing the same query with the continuation
    token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of service information.
    :type items: list[~azure.servicefabric.models.ServiceInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ServiceInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedServiceInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedServicePartitionInfoList(Model):
    """The list of partition in the cluster for a service. The list is paged when
    all of the results cannot fit in a single message. The next set of results
    can be obtained by executing the same query with the continuation token
    provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of service partition information.
    :type items: list[~azure.servicefabric.models.ServicePartitionInfo]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ServicePartitionInfo]'},
    }

    def __init__(self, **kwargs):
        super(PagedServicePartitionInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedServiceReplicaDescriptionList(Model):
    """The list of service resource replicas in the cluster. The list is paged
    when all of the results cannot fit in a single message. The next set of
    results can be obtained by executing the same query with the continuation
    token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: List of service resource replica description.
    :type items: list[~azure.servicefabric.models.ServiceReplicaDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ServiceReplicaDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedServiceReplicaDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedServiceResourceDescriptionList(Model):
    """The list of service resources. The list is paged when all of the results
    cannot fit in a single message. The next set of results can be obtained by
    executing the same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items: list[~azure.servicefabric.models.ServiceResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[ServiceResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedServiceResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PagedSubNameInfoList(Model):
    """A paged list of Service Fabric names. The list is paged when all of the
    results cannot fit in a single message. The next set of results can be
    obtained by executing the same query with the continuation token provided
    in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param is_consistent: Indicates whether any name under the given name has
     been modified during the enumeration. If there was a modification, this
     property value is false.
    :type is_consistent: bool
    :param sub_names: List of the child names.
    :type sub_names: list[str]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'is_consistent': {'key': 'IsConsistent', 'type': 'bool'},
        'sub_names': {'key': 'SubNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PagedSubNameInfoList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.is_consistent = kwargs.get('is_consistent', None)
        self.sub_names = kwargs.get('sub_names', None)


class PagedVolumeResourceDescriptionList(Model):
    """The list of volume resources. The list is paged when all of the results
    cannot fit in a single message. The next set of results can be obtained by
    executing the same query with the continuation token provided in this list.

    :param continuation_token: The continuation token parameter is used to
     obtain next set of results. The continuation token is included in the
     response of the API when the results from the system do not fit in a
     single response. When this value is passed to the next API call, the API
     returns next set of results. If there are no further results, then the
     continuation token is not included in the response.
    :type continuation_token: str
    :param items: One page of the list.
    :type items: list[~azure.servicefabric.models.VolumeResourceDescription]
    """

    _attribute_map = {
        'continuation_token': {'key': 'ContinuationToken', 'type': 'str'},
        'items': {'key': 'Items', 'type': '[VolumeResourceDescription]'},
    }

    def __init__(self, **kwargs):
        super(PagedVolumeResourceDescriptionList, self).__init__(**kwargs)
        self.continuation_token = kwargs.get('continuation_token', None)
        self.items = kwargs.get('items', None)


class PartitionAnalysisEvent(PartitionEvent):
    """Represents the base for all Partition Analysis Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartitionPrimaryMoveAnalysisEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param metadata: Required. Metadata about an Analysis Event.
    :type metadata: ~azure.servicefabric.models.AnalysisEventMetadata
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'metadata': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': 'AnalysisEventMetadata'},
    }

    _subtype_map = {
        'kind': {'PartitionPrimaryMoveAnalysis': 'PartitionPrimaryMoveAnalysisEvent'}
    }

    def __init__(self, **kwargs):
        super(PartitionAnalysisEvent, self).__init__(**kwargs)
        self.metadata = kwargs.get('metadata', None)
        self.kind = 'PartitionAnalysisEvent'


class PartitionBackupConfigurationInfo(BackupConfigurationInfo):
    """Backup configuration information, for a specific partition, specifying what
    backup policy is being applied and suspend description, if any.

    All required parameters must be populated in order to send to Azure.

    :param policy_name: The name of the backup policy which is applicable to
     this Service Fabric application or service or partition.
    :type policy_name: str
    :param policy_inherited_from: Specifies the scope at which the backup
     policy is applied. Possible values include: 'Invalid', 'Partition',
     'Service', 'Application'
    :type policy_inherited_from: str or
     ~azure.servicefabric.models.BackupPolicyScope
    :param suspension_info: Describes the backup suspension details.
    :type suspension_info: ~azure.servicefabric.models.BackupSuspensionInfo
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    :param partition_id: The partition ID identifying the partition.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'policy_name': {'key': 'PolicyName', 'type': 'str'},
        'policy_inherited_from': {'key': 'PolicyInheritedFrom', 'type': 'str'},
        'suspension_info': {'key': 'SuspensionInfo', 'type': 'BackupSuspensionInfo'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartitionBackupConfigurationInfo, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.partition_id = kwargs.get('partition_id', None)
        self.kind = 'Partition'


class PartitionBackupEntity(BackupEntity):
    """Identifies the Service Fabric stateful partition which is being backed up.

    All required parameters must be populated in order to send to Azure.

    :param entity_kind: Required. Constant filled by server.
    :type entity_kind: str
    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    :param partition_id: The partition ID identifying the partition.
    :type partition_id: str
    """

    _validation = {
        'entity_kind': {'required': True},
    }

    _attribute_map = {
        'entity_kind': {'key': 'EntityKind', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartitionBackupEntity, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.partition_id = kwargs.get('partition_id', None)
        self.entity_kind = 'Partition'


class PartitionDataLossProgress(Model):
    """Information about a partition data loss user-induced operation.

    :param state: The state of the operation. Possible values include:
     'Invalid', 'Running', 'RollingBack', 'Completed', 'Faulted', 'Cancelled',
     'ForceCancelled'
    :type state: str or ~azure.servicefabric.models.OperationState
    :param invoke_data_loss_result: Represents information about an operation
     in a terminal state (Completed or Faulted).
    :type invoke_data_loss_result:
     ~azure.servicefabric.models.InvokeDataLossResult
    """

    _attribute_map = {
        'state': {'key': 'State', 'type': 'str'},
        'invoke_data_loss_result': {'key': 'InvokeDataLossResult', 'type': 'InvokeDataLossResult'},
    }

    def __init__(self, **kwargs):
        super(PartitionDataLossProgress, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.invoke_data_loss_result = kwargs.get('invoke_data_loss_result', None)


class PartitionHealth(EntityHealth):
    """Information about the health of a Service Fabric partition.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param partition_id: ID of the partition whose health information is
     described by this object.
    :type partition_id: str
    :param replica_health_states: The list of replica health states associated
     with the partition.
    :type replica_health_states:
     list[~azure.servicefabric.models.ReplicaHealthState]
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_health_states': {'key': 'ReplicaHealthStates', 'type': '[ReplicaHealthState]'},
    }

    def __init__(self, **kwargs):
        super(PartitionHealth, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.replica_health_states = kwargs.get('replica_health_states', None)


class PartitionHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for a partition, containing information about
    the data and the algorithm used by health store to evaluate health. The
    evaluation is returned only when the aggregated health state is either
    Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition whose health evaluation is
     described by this object.
    :type partition_id: str
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the current aggregated health state of the partition. The types of the
     unhealthy evaluations can be ReplicasHealthEvaluation or
     EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(PartitionHealthEvaluation, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Partition'


class PartitionHealthReportExpiredEvent(PartitionEvent):
    """Partition Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(PartitionHealthReportExpiredEvent, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'PartitionHealthReportExpired'


class PartitionHealthState(EntityHealthState):
    """Represents the health state of a partition, which contains the partition
    identifier and its aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param partition_id: Id of the partition whose health state is described
     by this object.
    :type partition_id: str
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartitionHealthState, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)


class PartitionHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a partition, which contains the
    partition ID, its aggregated health state and any replicas that respect the
    filters in the cluster health chunk query description.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param partition_id: The Id of the partition.
    :type partition_id: str
    :param replica_health_state_chunks: The list of replica health state
     chunks belonging to the partition that respect the filters in the cluster
     health chunk query description.
    :type replica_health_state_chunks:
     ~azure.servicefabric.models.ReplicaHealthStateChunkList
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_health_state_chunks': {'key': 'ReplicaHealthStateChunks', 'type': 'ReplicaHealthStateChunkList'},
    }

    def __init__(self, **kwargs):
        super(PartitionHealthStateChunk, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.replica_health_state_chunks = kwargs.get('replica_health_state_chunks', None)


class PartitionHealthStateChunkList(Model):
    """The list of partition health state chunks that respect the input filters in
    the chunk query description.
    Returned by get cluster health state chunks query as part of the parent
    application hierarchy.

    :param items: The list of partition health state chunks that respect the
     input filters in the chunk query.
    :type items: list[~azure.servicefabric.models.PartitionHealthStateChunk]
    """

    _attribute_map = {
        'items': {'key': 'Items', 'type': '[PartitionHealthStateChunk]'},
    }

    def __init__(self, **kwargs):
        super(PartitionHealthStateChunkList, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class PartitionHealthStateFilter(Model):
    """Defines matching criteria to determine whether a partition should be
    included as a child of a service in the cluster health chunk.
    The partitions are only returned if the parent entities match a filter
    specified in the cluster health chunk query description. The parent service
    and application must be included in the cluster health chunk.
    One filter can match zero, one or multiple partitions, depending on its
    properties.

    :param partition_id_filter: ID of the partition that matches the filter.
     The filter is applied only to the specified partition, if it exists.
     If the partition doesn't exist, no partition is returned in the cluster
     health chunk based on this filter.
     If the partition exists, it is included in the cluster health chunk if it
     respects the other filter properties.
     If not specified, all partitions that match the parent filters (if any)
     are taken into consideration and matched against the other filter members,
     like health state filter.
    :type partition_id_filter: str
    :param health_state_filter: The filter for the health state of the
     partitions. It allows selecting partitions if they match the desired
     health states.
     The possible values are integer value of one of the following health
     states. Only partitions that match the filter are returned. All partitions
     are used to evaluate the cluster aggregated health state.
     If not specified, default value is None, unless the partition ID is
     specified. If the filter has default value and partition ID is specified,
     the matching partition is returned.
     The state values are flag-based enumeration, so the value could be a
     combination of these values obtained using bitwise 'OR' operator.
     For example, if the provided value is 6, it matches partitions with
     HealthState value of OK (2) and Warning (4).
     - Default - Default value. Matches any HealthState. The value is zero.
     - None - Filter that doesn't match any HealthState value. Used in order to
     return no results on a given collection of states. The value is 1.
     - Ok - Filter that matches input with HealthState value Ok. The value is
     2.
     - Warning - Filter that matches input with HealthState value Warning. The
     value is 4.
     - Error - Filter that matches input with HealthState value Error. The
     value is 8.
     - All - Filter that matches input with any HealthState value. The value is
     65535. Default value: 0 .
    :type health_state_filter: int
    :param replica_filters: Defines a list of filters that specify which
     replicas to be included in the returned cluster health chunk as children
     of the parent partition. The replicas are returned only if the parent
     partition matches a filter.
     If the list is empty, no replicas are returned. All the replicas are used
     to evaluate the parent partition aggregated health state, regardless of
     the input filters.
     The partition filter may specify multiple replica filters.
     For example, it can specify a filter to return all replicas with health
     state Error and another filter to always include a replica identified by
     its replica id.
    :type replica_filters:
     list[~azure.servicefabric.models.ReplicaHealthStateFilter]
    """

    _attribute_map = {
        'partition_id_filter': {'key': 'PartitionIdFilter', 'type': 'str'},
        'health_state_filter': {'key': 'HealthStateFilter', 'type': 'int'},
        'replica_filters': {'key': 'ReplicaFilters', 'type': '[ReplicaHealthStateFilter]'},
    }

    def __init__(self, **kwargs):
        super(PartitionHealthStateFilter, self).__init__(**kwargs)
        self.partition_id_filter = kwargs.get('partition_id_filter', None)
        self.health_state_filter = kwargs.get('health_state_filter', 0)
        self.replica_filters = kwargs.get('replica_filters', None)


class PartitionInstanceCountScaleMechanism(ScalingMechanismDescription):
    """Represents a scaling mechanism for adding or removing instances of
    stateless service partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param min_instance_count: Required. Minimum number of instances of the
     partition.
    :type min_instance_count: int
    :param max_instance_count: Required. Maximum number of instances of the
     partition.
    :type max_instance_count: int
    :param scale_increment: Required. The number of instances to add or remove
     during a scaling operation.
    :type scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_instance_count': {'required': True},
        'max_instance_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'min_instance_count': {'key': 'MinInstanceCount', 'type': 'int'},
        'max_instance_count': {'key': 'MaxInstanceCount', 'type': 'int'},
        'scale_increment': {'key': 'ScaleIncrement', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(PartitionInstanceCountScaleMechanism, self).__init__(**kwargs)
        self.min_instance_count = kwargs.get('min_instance_count', None)
        self.max_instance_count = kwargs.get('max_instance_count', None)
        self.scale_increment = kwargs.get('scale_increment', None)
        self.kind = 'PartitionInstanceCount'


class PartitionLoadInformation(Model):
    """Represents load information for a partition, which contains the primary and
    secondary reported load metrics.
    In case there is no load reported, PartitionLoadInformation will contain
    the default load for the service of the partition.
    For default loads, LoadMetricReport's LastReportedUtc is set to 0.

    :param partition_id: Id of the partition.
    :type partition_id: str
    :param primary_load_metric_reports: Array of load reports from the primary
     replica for this partition.
    :type primary_load_metric_reports:
     list[~azure.servicefabric.models.LoadMetricReport]
    :param secondary_load_metric_reports: Array of aggregated load reports
     from all secondary replicas for this partition.
     Array only contains the latest reported load for each metric.
    :type secondary_load_metric_reports:
     list[~azure.servicefabric.models.LoadMetricReport]
    """

    _attribute_map = {
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'primary_load_metric_reports': {'key': 'PrimaryLoadMetricReports', 'type': '[LoadMetricReport]'},
        'secondary_load_metric_reports': {'key': 'SecondaryLoadMetricReports', 'type': '[LoadMetricReport]'},
    }

    def __init__(self, **kwargs):
        super(PartitionLoadInformation, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.primary_load_metric_reports = kwargs.get('primary_load_metric_reports', None)
        self.secondary_load_metric_reports = kwargs.get('secondary_load_metric_reports', None)


class PartitionNewHealthReportEvent(PartitionEvent):
    """Partition Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(PartitionNewHealthReportEvent, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'PartitionNewHealthReport'


class PartitionPrimaryMoveAnalysisEvent(PartitionAnalysisEvent):
    """Partition Primary Move Analysis event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param metadata: Required. Metadata about an Analysis Event.
    :type metadata: ~azure.servicefabric.models.AnalysisEventMetadata
    :param when_move_completed: Required. Time when the move was completed.
    :type when_move_completed: datetime
    :param previous_node: Required. The name of a Service Fabric node.
    :type previous_node: str
    :param current_node: Required. The name of a Service Fabric node.
    :type current_node: str
    :param move_reason: Required. Move reason.
    :type move_reason: str
    :param relevant_traces: Required. Relevant traces.
    :type relevant_traces: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'metadata': {'required': True},
        'when_move_completed': {'required': True},
        'previous_node': {'required': True},
        'current_node': {'required': True},
        'move_reason': {'required': True},
        'relevant_traces': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': 'AnalysisEventMetadata'},
        'when_move_completed': {'key': 'WhenMoveCompleted', 'type': 'iso-8601'},
        'previous_node': {'key': 'PreviousNode', 'type': 'str'},
        'current_node': {'key': 'CurrentNode', 'type': 'str'},
        'move_reason': {'key': 'MoveReason', 'type': 'str'},
        'relevant_traces': {'key': 'RelevantTraces', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartitionPrimaryMoveAnalysisEvent, self).__init__(**kwargs)
        self.when_move_completed = kwargs.get('when_move_completed', None)
        self.previous_node = kwargs.get('previous_node', None)
        self.current_node = kwargs.get('current_node', None)
        self.move_reason = kwargs.get('move_reason', None)
        self.relevant_traces = kwargs.get('relevant_traces', None)
        self.kind = 'PartitionPrimaryMoveAnalysis'


class PartitionQuorumLossProgress(Model):
    """Information about a partition quorum loss user-induced operation.

    :param state: The state of the operation. Possible values include:
     'Invalid', 'Running', 'RollingBack', 'Completed', 'Faulted', 'Cancelled',
     'ForceCancelled'
    :type state: str or ~azure.servicefabric.models.OperationState
    :param invoke_quorum_loss_result: Represents information about an
     operation in a terminal state (Completed or Faulted).
    :type invoke_quorum_loss_result:
     ~azure.servicefabric.models.InvokeQuorumLossResult
    """

    _attribute_map = {
        'state': {'key': 'State', 'type': 'str'},
        'invoke_quorum_loss_result': {'key': 'InvokeQuorumLossResult', 'type': 'InvokeQuorumLossResult'},
    }

    def __init__(self, **kwargs):
        super(PartitionQuorumLossProgress, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.invoke_quorum_loss_result = kwargs.get('invoke_quorum_loss_result', None)


class PartitionReconfiguredEvent(PartitionEvent):
    """Partition Reconfiguration event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param node_name: Required. The name of a Service Fabric node.
    :type node_name: str
    :param node_instance_id: Required. Id of Node instance.
    :type node_instance_id: str
    :param service_type: Required. Type of Service.
    :type service_type: str
    :param cc_epoch_data_loss_version: Required. CcEpochDataLoss version.
    :type cc_epoch_data_loss_version: long
    :param cc_epoch_config_version: Required. CcEpochConfig version.
    :type cc_epoch_config_version: long
    :param reconfig_type: Required. Type of reconfiguration.
    :type reconfig_type: str
    :param result: Required. Describes reconfiguration result.
    :type result: str
    :param phase0_duration_ms: Required. Duration of Phase0 in milli-seconds.
    :type phase0_duration_ms: float
    :param phase1_duration_ms: Required. Duration of Phase1 in milli-seconds.
    :type phase1_duration_ms: float
    :param phase2_duration_ms: Required. Duration of Phase2 in milli-seconds.
    :type phase2_duration_ms: float
    :param phase3_duration_ms: Required. Duration of Phase3 in milli-seconds.
    :type phase3_duration_ms: float
    :param phase4_duration_ms: Required. Duration of Phase4 in milli-seconds.
    :type phase4_duration_ms: float
    :param total_duration_ms: Required. Total duration in milli-seconds.
    :type total_duration_ms: float
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'node_name': {'required': True},
        'node_instance_id': {'required': True},
        'service_type': {'required': True},
        'cc_epoch_data_loss_version': {'required': True},
        'cc_epoch_config_version': {'required': True},
        'reconfig_type': {'required': True},
        'result': {'required': True},
        'phase0_duration_ms': {'required': True},
        'phase1_duration_ms': {'required': True},
        'phase2_duration_ms': {'required': True},
        'phase3_duration_ms': {'required': True},
        'phase4_duration_ms': {'required': True},
        'total_duration_ms': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'node_instance_id': {'key': 'NodeInstanceId', 'type': 'str'},
        'service_type': {'key': 'ServiceType', 'type': 'str'},
        'cc_epoch_data_loss_version': {'key': 'CcEpochDataLossVersion', 'type': 'long'},
        'cc_epoch_config_version': {'key': 'CcEpochConfigVersion', 'type': 'long'},
        'reconfig_type': {'key': 'ReconfigType', 'type': 'str'},
        'result': {'key': 'Result', 'type': 'str'},
        'phase0_duration_ms': {'key': 'Phase0DurationMs', 'type': 'float'},
        'phase1_duration_ms': {'key': 'Phase1DurationMs', 'type': 'float'},
        'phase2_duration_ms': {'key': 'Phase2DurationMs', 'type': 'float'},
        'phase3_duration_ms': {'key': 'Phase3DurationMs', 'type': 'float'},
        'phase4_duration_ms': {'key': 'Phase4DurationMs', 'type': 'float'},
        'total_duration_ms': {'key': 'TotalDurationMs', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(PartitionReconfiguredEvent, self).__init__(**kwargs)
        self.node_name = kwargs.get('node_name', None)
        self.node_instance_id = kwargs.get('node_instance_id', None)
        self.service_type = kwargs.get('service_type', None)
        self.cc_epoch_data_loss_version = kwargs.get('cc_epoch_data_loss_version', None)
        self.cc_epoch_config_version = kwargs.get('cc_epoch_config_version', None)
        self.reconfig_type = kwargs.get('reconfig_type', None)
        self.result = kwargs.get('result', None)
        self.phase0_duration_ms = kwargs.get('phase0_duration_ms', None)
        self.phase1_duration_ms = kwargs.get('phase1_duration_ms', None)
        self.phase2_duration_ms = kwargs.get('phase2_duration_ms', None)
        self.phase3_duration_ms = kwargs.get('phase3_duration_ms', None)
        self.phase4_duration_ms = kwargs.get('phase4_duration_ms', None)
        self.total_duration_ms = kwargs.get('total_duration_ms', None)
        self.kind = 'PartitionReconfigured'


class PartitionRestartProgress(Model):
    """Information about a partition restart user-induced operation.

    :param state: The state of the operation. Possible values include:
     'Invalid', 'Running', 'RollingBack', 'Completed', 'Faulted', 'Cancelled',
     'ForceCancelled'
    :type state: str or ~azure.servicefabric.models.OperationState
    :param restart_partition_result: Represents information about an operation
     in a terminal state (Completed or Faulted).
    :type restart_partition_result:
     ~azure.servicefabric.models.RestartPartitionResult
    """

    _attribute_map = {
        'state': {'key': 'State', 'type': 'str'},
        'restart_partition_result': {'key': 'RestartPartitionResult', 'type': 'RestartPartitionResult'},
    }

    def __init__(self, **kwargs):
        super(PartitionRestartProgress, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.restart_partition_result = kwargs.get('restart_partition_result', None)


class PartitionsHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for the partitions of a service, containing
    health evaluations for each unhealthy partition that impacts current
    aggregated health state. Can be returned when evaluating service health and
    the aggregated health state is either Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param max_percent_unhealthy_partitions_per_service: Maximum allowed
     percentage of unhealthy partitions per service from the
     ServiceTypeHealthPolicy.
    :type max_percent_unhealthy_partitions_per_service: int
    :param total_count: Total number of partitions of the service from the
     health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     PartitionHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'max_percent_unhealthy_partitions_per_service': {'key': 'MaxPercentUnhealthyPartitionsPerService', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(PartitionsHealthEvaluation, self).__init__(**kwargs)
        self.max_percent_unhealthy_partitions_per_service = kwargs.get('max_percent_unhealthy_partitions_per_service', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Partitions'


class ReplicatorStatus(Model):
    """Represents a base class for primary or secondary replicator status.
    Contains information about the service fabric replicator like the
    replication/copy queue utilization, last acknowledgement received
    timestamp, etc.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PrimaryReplicatorStatus, SecondaryReplicatorStatus

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Primary': 'PrimaryReplicatorStatus', 'SecondaryReplicatorStatus': 'SecondaryReplicatorStatus'}
    }

    def __init__(self, **kwargs):
        super(ReplicatorStatus, self).__init__(**kwargs)
        self.kind = None


class PrimaryReplicatorStatus(ReplicatorStatus):
    """Provides statistics about the Service Fabric Replicator, when it is
    functioning in a Primary role.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param replication_queue_status: Details about the replication queue on
     the primary replicator.
    :type replication_queue_status:
     ~azure.servicefabric.models.ReplicatorQueueStatus
    :param remote_replicators: The status of all the active and idle secondary
     replicators that the primary is aware of.
    :type remote_replicators:
     list[~azure.servicefabric.models.RemoteReplicatorStatus]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'replication_queue_status': {'key': 'ReplicationQueueStatus', 'type': 'ReplicatorQueueStatus'},
        'remote_replicators': {'key': 'RemoteReplicators', 'type': '[RemoteReplicatorStatus]'},
    }

    def __init__(self, **kwargs):
        super(PrimaryReplicatorStatus, self).__init__(**kwargs)
        self.replication_queue_status = kwargs.get('replication_queue_status', None)
        self.remote_replicators = kwargs.get('remote_replicators', None)
        self.kind = 'Primary'


class PropertyBatchDescriptionList(Model):
    """Describes a list of property batch operations to be executed. Either all or
    none of the operations will be committed.

    :param operations: A list of the property batch operations to be executed.
    :type operations: list[~azure.servicefabric.models.PropertyBatchOperation]
    """

    _attribute_map = {
        'operations': {'key': 'Operations', 'type': '[PropertyBatchOperation]'},
    }

    def __init__(self, **kwargs):
        super(PropertyBatchDescriptionList, self).__init__(**kwargs)
        self.operations = kwargs.get('operations', None)


class PropertyDescription(Model):
    """Description of a Service Fabric property.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param custom_type_id: The property's custom type ID. Using this property,
     the user is able to tag the type of the value of the property.
    :type custom_type_id: str
    :param value: Required. Describes a Service Fabric property value.
    :type value: ~azure.servicefabric.models.PropertyValue
    """

    _validation = {
        'property_name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'custom_type_id': {'key': 'CustomTypeId', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
    }

    def __init__(self, **kwargs):
        super(PropertyDescription, self).__init__(**kwargs)
        self.property_name = kwargs.get('property_name', None)
        self.custom_type_id = kwargs.get('custom_type_id', None)
        self.value = kwargs.get('value', None)


class PropertyInfo(Model):
    """Information about a Service Fabric property.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the Service Fabric property.
    :type name: str
    :param value: Describes a Service Fabric property value.
    :type value: ~azure.servicefabric.models.PropertyValue
    :param metadata: Required. The metadata associated with a property,
     including the property's name.
    :type metadata: ~azure.servicefabric.models.PropertyMetadata
    """

    _validation = {
        'name': {'required': True},
        'metadata': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
        'metadata': {'key': 'Metadata', 'type': 'PropertyMetadata'},
    }

    def __init__(self, **kwargs):
        super(PropertyInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.metadata = kwargs.get('metadata', None)


class PropertyMetadata(Model):
    """The metadata associated with a property, including the property's name.

    :param type_id: The kind of property, determined by the type of data.
     Following are the possible values. Possible values include: 'Invalid',
     'Binary', 'Int64', 'Double', 'String', 'Guid'
    :type type_id: str or ~azure.servicefabric.models.PropertyValueKind
    :param custom_type_id: The property's custom type ID.
    :type custom_type_id: str
    :param parent: The name of the parent Service Fabric Name for the
     property. It could be thought of as the name-space/table under which the
     property exists.
    :type parent: str
    :param size_in_bytes: The length of the serialized property value.
    :type size_in_bytes: int
    :param last_modified_utc_timestamp: Represents when the Property was last
     modified. Only write operations will cause this field to be updated.
    :type last_modified_utc_timestamp: datetime
    :param sequence_number: The version of the property. Every time a property
     is modified, its sequence number is increased.
    :type sequence_number: str
    """

    _attribute_map = {
        'type_id': {'key': 'TypeId', 'type': 'str'},
        'custom_type_id': {'key': 'CustomTypeId', 'type': 'str'},
        'parent': {'key': 'Parent', 'type': 'str'},
        'size_in_bytes': {'key': 'SizeInBytes', 'type': 'int'},
        'last_modified_utc_timestamp': {'key': 'LastModifiedUtcTimestamp', 'type': 'iso-8601'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PropertyMetadata, self).__init__(**kwargs)
        self.type_id = kwargs.get('type_id', None)
        self.custom_type_id = kwargs.get('custom_type_id', None)
        self.parent = kwargs.get('parent', None)
        self.size_in_bytes = kwargs.get('size_in_bytes', None)
        self.last_modified_utc_timestamp = kwargs.get('last_modified_utc_timestamp', None)
        self.sequence_number = kwargs.get('sequence_number', None)


class ProvisionApplicationTypeDescription(ProvisionApplicationTypeDescriptionBase):
    """Describes the operation to register or provision an application type using
    an application package uploaded to the Service Fabric image store.

    All required parameters must be populated in order to send to Azure.

    :param async_property: Required. Indicates whether or not provisioning
     should occur asynchronously. When set to true, the provision operation
     returns when the request is accepted by the system, and the provision
     operation continues without any timeout limit. The default value is false.
     For large application packages, we recommend setting the value to true.
    :type async_property: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param application_type_build_path: Required. The relative path for the
     application package in the image store specified during the prior upload
     operation.
    :type application_type_build_path: str
    :param application_package_cleanup_policy: The kind of action that needs
     to be taken for cleaning up the application package after successful
     provision. Possible values include: 'Invalid', 'Default', 'Automatic',
     'Manual'
    :type application_package_cleanup_policy: str or
     ~azure.servicefabric.models.ApplicationPackageCleanupPolicy
    """

    _validation = {
        'async_property': {'required': True},
        'kind': {'required': True},
        'application_type_build_path': {'required': True},
    }

    _attribute_map = {
        'async_property': {'key': 'Async', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'application_type_build_path': {'key': 'ApplicationTypeBuildPath', 'type': 'str'},
        'application_package_cleanup_policy': {'key': 'ApplicationPackageCleanupPolicy', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProvisionApplicationTypeDescription, self).__init__(**kwargs)
        self.application_type_build_path = kwargs.get('application_type_build_path', None)
        self.application_package_cleanup_policy = kwargs.get('application_package_cleanup_policy', None)
        self.kind = 'ImageStorePath'


class ProvisionFabricDescription(Model):
    """Describes the parameters for provisioning a cluster.

    :param code_file_path: The cluster code package file path.
    :type code_file_path: str
    :param cluster_manifest_file_path: The cluster manifest file path.
    :type cluster_manifest_file_path: str
    """

    _attribute_map = {
        'code_file_path': {'key': 'CodeFilePath', 'type': 'str'},
        'cluster_manifest_file_path': {'key': 'ClusterManifestFilePath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProvisionFabricDescription, self).__init__(**kwargs)
        self.code_file_path = kwargs.get('code_file_path', None)
        self.cluster_manifest_file_path = kwargs.get('cluster_manifest_file_path', None)


class PutPropertyBatchOperation(PropertyBatchOperation):
    """Puts the specified property under the specified name.
    Note that if one PropertyBatchOperation in a PropertyBatch fails,
    the entire batch fails and cannot be committed in a transactional manner.

    All required parameters must be populated in order to send to Azure.

    :param property_name: Required. The name of the Service Fabric property.
    :type property_name: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param value: Required. Describes a Service Fabric property value.
    :type value: ~azure.servicefabric.models.PropertyValue
    :param custom_type_id: The property's custom type ID. Using this property,
     the user is able to tag the type of the value of the property.
    :type custom_type_id: str
    """

    _validation = {
        'property_name': {'required': True},
        'kind': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'PropertyValue'},
        'custom_type_id': {'key': 'CustomTypeId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PutPropertyBatchOperation, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.custom_type_id = kwargs.get('custom_type_id', None)
        self.kind = 'Put'


class ReconfigurationInformation(Model):
    """Information about current reconfiguration like phase, type, previous
    configuration role of replica and reconfiguration start date time.

    :param previous_configuration_role: Replica role before reconfiguration
     started. Possible values include: 'Unknown', 'None', 'Primary',
     'IdleSecondary', 'ActiveSecondary'
    :type previous_configuration_role: str or
     ~azure.servicefabric.models.ReplicaRole
    :param reconfiguration_phase: Current phase of ongoing reconfiguration. If
     no reconfiguration is taking place then this value will be "None".
     Possible values include: 'Unknown', 'None', 'Phase0', 'Phase1', 'Phase2',
     'Phase3', 'Phase4', 'AbortPhaseZero'
    :type reconfiguration_phase: str or
     ~azure.servicefabric.models.ReconfigurationPhase
    :param reconfiguration_type: Type of current ongoing reconfiguration. If
     no reconfiguration is taking place then this value will be "None".
     Possible values include: 'Unknown', 'SwapPrimary', 'Failover', 'Other'
    :type reconfiguration_type: str or
     ~azure.servicefabric.models.ReconfigurationType
    :param reconfiguration_start_time_utc: Start time (in UTC) of the ongoing
     reconfiguration. If no reconfiguration is taking place then this value
     will be zero date-time.
    :type reconfiguration_start_time_utc: datetime
    """

    _attribute_map = {
        'previous_configuration_role': {'key': 'PreviousConfigurationRole', 'type': 'str'},
        'reconfiguration_phase': {'key': 'ReconfigurationPhase', 'type': 'str'},
        'reconfiguration_type': {'key': 'ReconfigurationType', 'type': 'str'},
        'reconfiguration_start_time_utc': {'key': 'ReconfigurationStartTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ReconfigurationInformation, self).__init__(**kwargs)
        self.previous_configuration_role = kwargs.get('previous_configuration_role', None)
        self.reconfiguration_phase = kwargs.get('reconfiguration_phase', None)
        self.reconfiguration_type = kwargs.get('reconfiguration_type', None)
        self.reconfiguration_start_time_utc = kwargs.get('reconfiguration_start_time_utc', None)


class RegistryCredential(Model):
    """Credential information to connect to container registry.

    :param registry_user_name: The user name to connect to container registry.
    :type registry_user_name: str
    :param registry_password: The password for supplied username to connect to
     container registry.
    :type registry_password: str
    :param password_encrypted: Indicates that supplied container registry
     password is encrypted.
    :type password_encrypted: bool
    """

    _attribute_map = {
        'registry_user_name': {'key': 'RegistryUserName', 'type': 'str'},
        'registry_password': {'key': 'RegistryPassword', 'type': 'str'},
        'password_encrypted': {'key': 'PasswordEncrypted', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RegistryCredential, self).__init__(**kwargs)
        self.registry_user_name = kwargs.get('registry_user_name', None)
        self.registry_password = kwargs.get('registry_password', None)
        self.password_encrypted = kwargs.get('password_encrypted', None)


class ReliableCollectionsRef(Model):
    """Specifying this parameter adds support for reliable collections.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of ReliableCollection resource. Right now it's
     not used and you can use any string.
    :type name: str
    :param do_not_persist_state: False (the default) if ReliableCollections
     state is persisted to disk as usual. True if you do not want to persist
     state, in which case replication is still enabled and you can use
     ReliableCollections as distributed cache.
    :type do_not_persist_state: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'do_not_persist_state': {'key': 'doNotPersistState', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ReliableCollectionsRef, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.do_not_persist_state = kwargs.get('do_not_persist_state', None)


class RemoteReplicatorAcknowledgementDetail(Model):
    """Provides various statistics of the acknowledgements that are being received
    from the remote replicator.

    :param average_receive_duration: Represents the average duration it takes
     for the remote replicator to receive an operation.
    :type average_receive_duration: str
    :param average_apply_duration: Represents the average duration it takes
     for the remote replicator to apply an operation. This usually entails
     writing the operation to disk.
    :type average_apply_duration: str
    :param not_received_count: Represents the number of operations not yet
     received by a remote replicator.
    :type not_received_count: str
    :param received_and_not_applied_count: Represents the number of operations
     received and not yet applied by a remote replicator.
    :type received_and_not_applied_count: str
    """

    _attribute_map = {
        'average_receive_duration': {'key': 'AverageReceiveDuration', 'type': 'str'},
        'average_apply_duration': {'key': 'AverageApplyDuration', 'type': 'str'},
        'not_received_count': {'key': 'NotReceivedCount', 'type': 'str'},
        'received_and_not_applied_count': {'key': 'ReceivedAndNotAppliedCount', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RemoteReplicatorAcknowledgementDetail, self).__init__(**kwargs)
        self.average_receive_duration = kwargs.get('average_receive_duration', None)
        self.average_apply_duration = kwargs.get('average_apply_duration', None)
        self.not_received_count = kwargs.get('not_received_count', None)
        self.received_and_not_applied_count = kwargs.get('received_and_not_applied_count', None)


class RemoteReplicatorAcknowledgementStatus(Model):
    """Provides details about the remote replicators from the primary replicator's
    point of view.

    :param replication_stream_acknowledgement_detail: Details about the
     acknowledgements for operations that are part of the replication stream
     data.
    :type replication_stream_acknowledgement_detail:
     ~azure.servicefabric.models.RemoteReplicatorAcknowledgementDetail
    :param copy_stream_acknowledgement_detail: Details about the
     acknowledgements for operations that are part of the copy stream data.
    :type copy_stream_acknowledgement_detail:
     ~azure.servicefabric.models.RemoteReplicatorAcknowledgementDetail
    """

    _attribute_map = {
        'replication_stream_acknowledgement_detail': {'key': 'ReplicationStreamAcknowledgementDetail', 'type': 'RemoteReplicatorAcknowledgementDetail'},
        'copy_stream_acknowledgement_detail': {'key': 'CopyStreamAcknowledgementDetail', 'type': 'RemoteReplicatorAcknowledgementDetail'},
    }

    def __init__(self, **kwargs):
        super(RemoteReplicatorAcknowledgementStatus, self).__init__(**kwargs)
        self.replication_stream_acknowledgement_detail = kwargs.get('replication_stream_acknowledgement_detail', None)
        self.copy_stream_acknowledgement_detail = kwargs.get('copy_stream_acknowledgement_detail', None)


class RemoteReplicatorStatus(Model):
    """Represents the state of the secondary replicator from the primary
    replicator’s point of view.

    :param replica_id: Represents the replica ID of the remote secondary
     replicator.
    :type replica_id: str
    :param last_acknowledgement_processed_time_utc: The last timestamp (in
     UTC) when an acknowledgement from the secondary replicator was processed
     on the primary.
     UTC 0 represents an invalid value, indicating that no acknowledgement
     messages were ever processed.
    :type last_acknowledgement_processed_time_utc: datetime
    :param last_received_replication_sequence_number: The highest replication
     operation sequence number that the secondary has received from the
     primary.
    :type last_received_replication_sequence_number: str
    :param last_applied_replication_sequence_number: The highest replication
     operation sequence number that the secondary has applied to its state.
    :type last_applied_replication_sequence_number: str
    :param is_in_build: A value that indicates whether the secondary replica
     is in the process of being built.
    :type is_in_build: bool
    :param last_received_copy_sequence_number: The highest copy operation
     sequence number that the secondary has received from the primary.
     A value of -1 implies that the secondary has received all copy operations.
    :type last_received_copy_sequence_number: str
    :param last_applied_copy_sequence_number: The highest copy operation
     sequence number that the secondary has applied to its state.
     A value of -1 implies that the secondary has applied all copy operations
     and the copy process is complete.
    :type last_applied_copy_sequence_number: str
    :param remote_replicator_acknowledgement_status: Represents the
     acknowledgment status for the remote secondary replicator.
    :type remote_replicator_acknowledgement_status:
     ~azure.servicefabric.models.RemoteReplicatorAcknowledgementStatus
    """

    _attribute_map = {
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
        'last_acknowledgement_processed_time_utc': {'key': 'LastAcknowledgementProcessedTimeUtc', 'type': 'iso-8601'},
        'last_received_replication_sequence_number': {'key': 'LastReceivedReplicationSequenceNumber', 'type': 'str'},
        'last_applied_replication_sequence_number': {'key': 'LastAppliedReplicationSequenceNumber', 'type': 'str'},
        'is_in_build': {'key': 'IsInBuild', 'type': 'bool'},
        'last_received_copy_sequence_number': {'key': 'LastReceivedCopySequenceNumber', 'type': 'str'},
        'last_applied_copy_sequence_number': {'key': 'LastAppliedCopySequenceNumber', 'type': 'str'},
        'remote_replicator_acknowledgement_status': {'key': 'RemoteReplicatorAcknowledgementStatus', 'type': 'RemoteReplicatorAcknowledgementStatus'},
    }

    def __init__(self, **kwargs):
        super(RemoteReplicatorStatus, self).__init__(**kwargs)
        self.replica_id = kwargs.get('replica_id', None)
        self.last_acknowledgement_processed_time_utc = kwargs.get('last_acknowledgement_processed_time_utc', None)
        self.last_received_replication_sequence_number = kwargs.get('last_received_replication_sequence_number', None)
        self.last_applied_replication_sequence_number = kwargs.get('last_applied_replication_sequence_number', None)
        self.is_in_build = kwargs.get('is_in_build', None)
        self.last_received_copy_sequence_number = kwargs.get('last_received_copy_sequence_number', None)
        self.last_applied_copy_sequence_number = kwargs.get('last_applied_copy_sequence_number', None)
        self.remote_replicator_acknowledgement_status = kwargs.get('remote_replicator_acknowledgement_status', None)


class RepairTask(Model):
    """Represents a repair task, which includes information about what kind of
    repair was requested, what its progress is, and what its final result was.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param task_id: Required. The ID of the repair task.
    :type task_id: str
    :param version: The version of the repair task.
     When creating a new repair task, the version must be set to zero.  When
     updating a repair task,
     the version is used for optimistic concurrency checks.  If the version is
     set to zero, the update will not check for write conflicts.  If the
     version is set to a non-zero value, then the
     update will only succeed if the actual current version of the repair task
     matches this value.
    :type version: str
    :param description: A description of the purpose of the repair task, or
     other informational details.
     May be set when the repair task is created, and is immutable once set.
    :type description: str
    :param state: Required. The workflow state of the repair task. Valid
     initial states are Created, Claimed, and Preparing. Possible values
     include: 'Invalid', 'Created', 'Claimed', 'Preparing', 'Approved',
     'Executing', 'Restoring', 'Completed'
    :type state: str or ~azure.servicefabric.models.State
    :param flags: A bitwise-OR of the following values, which gives additional
     details about the status of the repair task.
     - 1 - Cancellation of the repair has been requested
     - 2 - Abort of the repair has been requested
     - 4 - Approval of the repair was forced via client request
    :type flags: int
    :param action: Required. The requested repair action. Must be specified
     when the repair task is created, and is immutable once set.
    :type action: str
    :param target: The target object determines what actions the system will
     take to prepare for the impact of the repair, prior to approving execution
     of the repair.
     May be set when the repair task is created, and is immutable once set.
    :type target: ~azure.servicefabric.models.RepairTargetDescriptionBase
    :param executor: The name of the repair executor. Must be specified in
     Claimed and later states, and is immutable once set.
    :type executor: str
    :param executor_data: A data string that the repair executor can use to
     store its internal state.
    :type executor_data: str
    :param impact: The impact object determines what actions the system will
     take to prepare for the impact of the repair, prior to approving execution
     of the repair.
     Impact must be specified by the repair executor when transitioning to the
     Preparing state, and is immutable once set.
    :type impact: ~azure.servicefabric.models.RepairImpactDescriptionBase
    :param result_status: A value describing the overall result of the repair
     task execution. Must be specified in the Restoring and later states, and
     is immutable once set. Possible values include: 'Invalid', 'Succeeded',
     'Cancelled', 'Interrupted', 'Failed', 'Pending'
    :type result_status: str or ~azure.servicefabric.models.ResultStatus
    :param result_code: A numeric value providing additional details about the
     result of the repair task execution.
     May be specified in the Restoring and later states, and is immutable once
     set.
    :type result_code: int
    :param result_details: A string providing additional details about the
     result of the repair task execution.
     May be specified in the Restoring and later states, and is immutable once
     set.
    :type result_details: str
    :param history: An object that contains timestamps of the repair task's
     state transitions.
     These timestamps are updated by the system, and cannot be directly
     modified.
    :type history: ~azure.servicefabric.models.RepairTaskHistory
    :param preparing_health_check_state: The workflow state of the health
     check when the repair task is in the Preparing state. Possible values
     include: 'NotStarted', 'InProgress', 'Succeeded', 'Skipped', 'TimedOut'
    :type preparing_health_check_state: str or
     ~azure.servicefabric.models.RepairTaskHealthCheckState
    :param restoring_health_check_state: The workflow state of the health
     check when the repair task is in the Restoring state. Possible values
     include: 'NotStarted', 'InProgress', 'Succeeded', 'Skipped', 'TimedOut'
    :type restoring_health_check_state: str or
     ~azure.servicefabric.models.RepairTaskHealthCheckState
    :param perform_preparing_health_check: A value to determine if health
     checks will be performed when the repair task enters the Preparing state.
    :type perform_preparing_health_check: bool
    :param perform_restoring_health_check: A value to determine if health
     checks will be performed when the repair task enters the Restoring state.
    :type perform_restoring_health_check: bool
    """

    _validation = {
        'task_id': {'required': True},
        'state': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'task_id': {'key': 'TaskId', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'state': {'key': 'State', 'type': 'str'},
        'flags': {'key': 'Flags', 'type': 'int'},
        'action': {'key': 'Action', 'type': 'str'},
        'target': {'key': 'Target', 'type': 'RepairTargetDescriptionBase'},
        'executor': {'key': 'Executor', 'type': 'str'},
        'executor_data': {'key': 'ExecutorData', 'type': 'str'},
        'impact': {'key': 'Impact', 'type': 'RepairImpactDescriptionBase'},
        'result_status': {'key': 'ResultStatus', 'type': 'str'},
        'result_code': {'key': 'ResultCode', 'type': 'int'},
        'result_details': {'key': 'ResultDetails', 'type': 'str'},
        'history': {'key': 'History', 'type': 'RepairTaskHistory'},
        'preparing_health_check_state': {'key': 'PreparingHealthCheckState', 'type': 'str'},
        'restoring_health_check_state': {'key': 'RestoringHealthCheckState', 'type': 'str'},
        'perform_preparing_health_check': {'key': 'PerformPreparingHealthCheck', 'type': 'bool'},
        'perform_restoring_health_check': {'key': 'PerformRestoringHealthCheck', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RepairTask, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.version = kwargs.get('version', None)
        self.description = kwargs.get('description', None)
        self.state = kwargs.get('state', None)
        self.flags = kwargs.get('flags', None)
        self.action = kwargs.get('action', None)
        self.target = kwargs.get('target', None)
        self.executor = kwargs.get('executor', None)
        self.executor_data = kwargs.get('executor_data', None)
        self.impact = kwargs.get('impact', None)
        self.result_status = kwargs.get('result_status', None)
        self.result_code = kwargs.get('result_code', None)
        self.result_details = kwargs.get('result_details', None)
        self.history = kwargs.get('history', None)
        self.preparing_health_check_state = kwargs.get('preparing_health_check_state', None)
        self.restoring_health_check_state = kwargs.get('restoring_health_check_state', None)
        self.perform_preparing_health_check = kwargs.get('perform_preparing_health_check', None)
        self.perform_restoring_health_check = kwargs.get('perform_restoring_health_check', None)


class RepairTaskApproveDescription(Model):
    """Describes a request for forced approval of a repair task.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param task_id: Required. The ID of the repair task.
    :type task_id: str
    :param version: The current version number of the repair task. If
     non-zero, then the request will only succeed if this value matches the
     actual current version of the repair task. If zero, then no version check
     is performed.
    :type version: str
    """

    _validation = {
        'task_id': {'required': True},
    }

    _attribute_map = {
        'task_id': {'key': 'TaskId', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RepairTaskApproveDescription, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.version = kwargs.get('version', None)


class RepairTaskCancelDescription(Model):
    """Describes a request to cancel a repair task.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param task_id: Required. The ID of the repair task.
    :type task_id: str
    :param version: The current version number of the repair task. If
     non-zero, then the request will only succeed if this value matches the
     actual current version of the repair task. If zero, then no version check
     is performed.
    :type version: str
    :param request_abort: _True_ if the repair should be stopped as soon as
     possible even if it has already started executing. _False_ if the repair
     should be cancelled only if execution has not yet started.
    :type request_abort: bool
    """

    _validation = {
        'task_id': {'required': True},
    }

    _attribute_map = {
        'task_id': {'key': 'TaskId', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'request_abort': {'key': 'RequestAbort', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RepairTaskCancelDescription, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.version = kwargs.get('version', None)
        self.request_abort = kwargs.get('request_abort', None)


class RepairTaskDeleteDescription(Model):
    """Describes a request to delete a completed repair task.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param task_id: Required. The ID of the completed repair task to be
     deleted.
    :type task_id: str
    :param version: The current version number of the repair task. If
     non-zero, then the request will only succeed if this value matches the
     actual current version of the repair task. If zero, then no version check
     is performed.
    :type version: str
    """

    _validation = {
        'task_id': {'required': True},
    }

    _attribute_map = {
        'task_id': {'key': 'TaskId', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RepairTaskDeleteDescription, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.version = kwargs.get('version', None)


class RepairTaskHistory(Model):
    """A record of the times when the repair task entered each state.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    :param created_utc_timestamp: The time when the repair task entered the
     Created state.
    :type created_utc_timestamp: datetime
    :param claimed_utc_timestamp: The time when the repair task entered the
     Claimed state.
    :type claimed_utc_timestamp: datetime
    :param preparing_utc_timestamp: The time when the repair task entered the
     Preparing state.
    :type preparing_utc_timestamp: datetime
    :param approved_utc_timestamp: The time when the repair task entered the
     Approved state
    :type approved_utc_timestamp: datetime
    :param executing_utc_timestamp: The time when the repair task entered the
     Executing state
    :type executing_utc_timestamp: datetime
    :param restoring_utc_timestamp: The time when the repair task entered the
     Restoring state
    :type restoring_utc_timestamp: datetime
    :param completed_utc_timestamp: The time when the repair task entered the
     Completed state
    :type completed_utc_timestamp: datetime
    :param preparing_health_check_start_utc_timestamp: The time when the
     repair task started the health check in the Preparing state.
    :type preparing_health_check_start_utc_timestamp: datetime
    :param preparing_health_check_end_utc_timestamp: The time when the repair
     task completed the health check in the Preparing state.
    :type preparing_health_check_end_utc_timestamp: datetime
    :param restoring_health_check_start_utc_timestamp: The time when the
     repair task started the health check in the Restoring state.
    :type restoring_health_check_start_utc_timestamp: datetime
    :param restoring_health_check_end_utc_timestamp: The time when the repair
     task completed the health check in the Restoring state.
    :type restoring_health_check_end_utc_timestamp: datetime
    """

    _attribute_map = {
        'created_utc_timestamp': {'key': 'CreatedUtcTimestamp', 'type': 'iso-8601'},
        'claimed_utc_timestamp': {'key': 'ClaimedUtcTimestamp', 'type': 'iso-8601'},
        'preparing_utc_timestamp': {'key': 'PreparingUtcTimestamp', 'type': 'iso-8601'},
        'approved_utc_timestamp': {'key': 'ApprovedUtcTimestamp', 'type': 'iso-8601'},
        'executing_utc_timestamp': {'key': 'ExecutingUtcTimestamp', 'type': 'iso-8601'},
        'restoring_utc_timestamp': {'key': 'RestoringUtcTimestamp', 'type': 'iso-8601'},
        'completed_utc_timestamp': {'key': 'CompletedUtcTimestamp', 'type': 'iso-8601'},
        'preparing_health_check_start_utc_timestamp': {'key': 'PreparingHealthCheckStartUtcTimestamp', 'type': 'iso-8601'},
        'preparing_health_check_end_utc_timestamp': {'key': 'PreparingHealthCheckEndUtcTimestamp', 'type': 'iso-8601'},
        'restoring_health_check_start_utc_timestamp': {'key': 'RestoringHealthCheckStartUtcTimestamp', 'type': 'iso-8601'},
        'restoring_health_check_end_utc_timestamp': {'key': 'RestoringHealthCheckEndUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(RepairTaskHistory, self).__init__(**kwargs)
        self.created_utc_timestamp = kwargs.get('created_utc_timestamp', None)
        self.claimed_utc_timestamp = kwargs.get('claimed_utc_timestamp', None)
        self.preparing_utc_timestamp = kwargs.get('preparing_utc_timestamp', None)
        self.approved_utc_timestamp = kwargs.get('approved_utc_timestamp', None)
        self.executing_utc_timestamp = kwargs.get('executing_utc_timestamp', None)
        self.restoring_utc_timestamp = kwargs.get('restoring_utc_timestamp', None)
        self.completed_utc_timestamp = kwargs.get('completed_utc_timestamp', None)
        self.preparing_health_check_start_utc_timestamp = kwargs.get('preparing_health_check_start_utc_timestamp', None)
        self.preparing_health_check_end_utc_timestamp = kwargs.get('preparing_health_check_end_utc_timestamp', None)
        self.restoring_health_check_start_utc_timestamp = kwargs.get('restoring_health_check_start_utc_timestamp', None)
        self.restoring_health_check_end_utc_timestamp = kwargs.get('restoring_health_check_end_utc_timestamp', None)


class RepairTaskUpdateHealthPolicyDescription(Model):
    """Describes a request to update the health policy of a repair task.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param task_id: Required. The ID of the repair task to be updated.
    :type task_id: str
    :param version: The current version number of the repair task. If
     non-zero, then the request will only succeed if this value matches the
     actual current value of the repair task. If zero, then no version check is
     performed.
    :type version: str
    :param perform_preparing_health_check: A boolean indicating if health
     check is to be performed in the Preparing stage of the repair task. If not
     specified the existing value should not be altered. Otherwise, specify the
     desired new value.
    :type perform_preparing_health_check: bool
    :param perform_restoring_health_check: A boolean indicating if health
     check is to be performed in the Restoring stage of the repair task. If not
     specified the existing value should not be altered. Otherwise, specify the
     desired new value.
    :type perform_restoring_health_check: bool
    """

    _validation = {
        'task_id': {'required': True},
    }

    _attribute_map = {
        'task_id': {'key': 'TaskId', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'perform_preparing_health_check': {'key': 'PerformPreparingHealthCheck', 'type': 'bool'},
        'perform_restoring_health_check': {'key': 'PerformRestoringHealthCheck', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RepairTaskUpdateHealthPolicyDescription, self).__init__(**kwargs)
        self.task_id = kwargs.get('task_id', None)
        self.version = kwargs.get('version', None)
        self.perform_preparing_health_check = kwargs.get('perform_preparing_health_check', None)
        self.perform_restoring_health_check = kwargs.get('perform_restoring_health_check', None)


class RepairTaskUpdateInfo(Model):
    """Describes the result of an operation that created or updated a repair task.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The new version of the repair task.
    :type version: str
    """

    _validation = {
        'version': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RepairTaskUpdateInfo, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)


class ReplicaHealth(EntityHealth):
    """Represents a base class for stateful service replica or stateless service
    instance health.
    Contains the replica aggregated health state, the health events and the
    unhealthy evaluations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceReplicaHealth,
    StatelessServiceInstanceHealth

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param partition_id: Id of the partition to which this replica belongs.
    :type partition_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceReplicaHealth', 'Stateless': 'StatelessServiceInstanceHealth'}
    }

    def __init__(self, **kwargs):
        super(ReplicaHealth, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.service_kind = None
        self.service_kind = 'ReplicaHealth'


class ReplicaHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for a replica, containing information about
    the data and the algorithm used by health store to evaluate health. The
    evaluation is returned only when the aggregated health state is either
    Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition to which the replica belongs.
    :type partition_id: str
    :param replica_or_instance_id: Id of a stateful service replica or a
     stateless service instance. This ID is used in the queries that apply to
     both stateful and stateless services. It is used by Service Fabric to
     uniquely identify a replica of a partition of a stateful service or an
     instance of a stateless service partition. It is unique within a partition
     and does not change for the lifetime of the replica or the instance. If a
     stateful replica gets dropped and another replica gets created on the same
     node for the same partition, it will get a different value for the ID. If
     a stateless instance is failed over on the same or different node it will
     get a different value for the ID.
    :type replica_or_instance_id: str
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the current aggregated health state of the replica. The types of the
     unhealthy evaluations can be EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_or_instance_id': {'key': 'ReplicaOrInstanceId', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ReplicaHealthEvaluation, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.replica_or_instance_id = kwargs.get('replica_or_instance_id', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Replica'


class ReplicaHealthState(EntityHealthState):
    """Represents a base class for stateful service replica or stateless service
    instance health state.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceReplicaHealthState,
    StatelessServiceInstanceHealthState

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param partition_id: The ID of the partition to which this replica
     belongs.
    :type partition_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceReplicaHealthState', 'Stateless': 'StatelessServiceInstanceHealthState'}
    }

    def __init__(self, **kwargs):
        super(ReplicaHealthState, self).__init__(**kwargs)
        self.partition_id = kwargs.get('partition_id', None)
        self.service_kind = None
        self.service_kind = 'ReplicaHealthState'


class ReplicaHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a stateful service replica or a
    stateless service instance.
    The replica health state contains the replica ID and its aggregated health
    state.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param replica_or_instance_id: Id of a stateful service replica or a
     stateless service instance. This ID is used in the queries that apply to
     both stateful and stateless services. It is used by Service Fabric to
     uniquely identify a replica of a partition of a stateful service or an
     instance of a stateless service partition. It is unique within a partition
     and does not change for the lifetime of the replica or the instance. If a
     stateful replica gets dropped and another replica gets created on the same
     node for the same partition, it will get a different value for the ID. If
     a stateless instance is failed over on the same or different node it will
     get a different value for the ID.
    :type replica_or_instance_id: str
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'replica_or_instance_id': {'key': 'ReplicaOrInstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReplicaHealthStateChunk, self).__init__(**kwargs)
        self.replica_or_instance_id = kwargs.get('replica_or_instance_id', None)


class ReplicaHealthStateChunkList(Model):
    """The list of replica health state chunks that respect the input filters in
    the chunk query. Returned by get cluster health state chunks query.

    :param items: The list of replica health state chunks that respect the
     input filters in the chunk query.
    :type items: list[~azure.servicefabric.models.ReplicaHealthStateChunk]
    """

    _attribute_map = {
        'items': {'key': 'Items', 'type': '[ReplicaHealthStateChunk]'},
    }

    def __init__(self, **kwargs):
        super(ReplicaHealthStateChunkList, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class ReplicaHealthStateFilter(Model):
    """Defines matching criteria to determine whether a replica should be included
    as a child of a partition in the cluster health chunk.
    The replicas are only returned if the parent entities match a filter
    specified in the cluster health chunk query description. The parent
    partition, service and application must be included in the cluster health
    chunk.
    One filter can match zero, one or multiple replicas, depending on its
    properties.

    :param replica_or_instance_id_filter: Id of the stateful service replica
     or stateless service instance that matches the filter. The filter is
     applied only to the specified replica, if it exists.
     If the replica doesn't exist, no replica is returned in the cluster health
     chunk based on this filter.
     If the replica exists, it is included in the cluster health chunk if it
     respects the other filter properties.
     If not specified, all replicas that match the parent filters (if any) are
     taken into consideration and matched against the other filter members,
     like health state filter.
    :type replica_or_instance_id_filter: str
    :param health_state_filter: The filter for the health state of the
     replicas. It allows selecting replicas if they match the desired health
     states.
     The possible values are integer value of one of the following health
     states. Only replicas that match the filter are returned. All replicas are
     used to evaluate the parent partition aggregated health state.
     If not specified, default value is None, unless the replica ID is
     specified. If the filter has default value and replica ID is specified,
     the matching replica is returned.
     The state values are flag-based enumeration, so the value could be a
     combination of these values obtained using bitwise 'OR' operator.
     For example, if the provided value is 6, it matches replicas with
     HealthState value of OK (2) and Warning (4).
     - Default - Default value. Matches any HealthState. The value is zero.
     - None - Filter that doesn't match any HealthState value. Used in order to
     return no results on a given collection of states. The value is 1.
     - Ok - Filter that matches input with HealthState value Ok. The value is
     2.
     - Warning - Filter that matches input with HealthState value Warning. The
     value is 4.
     - Error - Filter that matches input with HealthState value Error. The
     value is 8.
     - All - Filter that matches input with any HealthState value. The value is
     65535. Default value: 0 .
    :type health_state_filter: int
    """

    _attribute_map = {
        'replica_or_instance_id_filter': {'key': 'ReplicaOrInstanceIdFilter', 'type': 'str'},
        'health_state_filter': {'key': 'HealthStateFilter', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ReplicaHealthStateFilter, self).__init__(**kwargs)
        self.replica_or_instance_id_filter = kwargs.get('replica_or_instance_id_filter', None)
        self.health_state_filter = kwargs.get('health_state_filter', 0)


class ReplicaInfo(Model):
    """Information about the identity, status, health, node name, uptime, and
    other details about the replica.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceReplicaInfo, StatelessServiceInstanceInfo

    All required parameters must be populated in order to send to Azure.

    :param replica_status: The status of a replica of a service. Possible
     values include: 'Invalid', 'InBuild', 'Standby', 'Ready', 'Down',
     'Dropped'
    :type replica_status: str or ~azure.servicefabric.models.ReplicaStatus
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    :param address: The address the replica is listening on.
    :type address: str
    :param last_in_build_duration_in_seconds: The last in build duration of
     the replica in seconds.
    :type last_in_build_duration_in_seconds: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'last_in_build_duration_in_seconds': {'key': 'LastInBuildDurationInSeconds', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceReplicaInfo', 'Stateless': 'StatelessServiceInstanceInfo'}
    }

    def __init__(self, **kwargs):
        super(ReplicaInfo, self).__init__(**kwargs)
        self.replica_status = kwargs.get('replica_status', None)
        self.health_state = kwargs.get('health_state', None)
        self.node_name = kwargs.get('node_name', None)
        self.address = kwargs.get('address', None)
        self.last_in_build_duration_in_seconds = kwargs.get('last_in_build_duration_in_seconds', None)
        self.service_kind = None


class ReplicasHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for replicas, containing health evaluations
    for each unhealthy replica that impacted current aggregated health state.
    Can be returned when evaluating partition health and the aggregated health
    state is either Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param max_percent_unhealthy_replicas_per_partition: Maximum allowed
     percentage of unhealthy replicas per partition from the
     ApplicationHealthPolicy.
    :type max_percent_unhealthy_replicas_per_partition: int
    :param total_count: Total number of replicas in the partition from the
     health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     ReplicaHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'max_percent_unhealthy_replicas_per_partition': {'key': 'MaxPercentUnhealthyReplicasPerPartition', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ReplicasHealthEvaluation, self).__init__(**kwargs)
        self.max_percent_unhealthy_replicas_per_partition = kwargs.get('max_percent_unhealthy_replicas_per_partition', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Replicas'


class ReplicatorQueueStatus(Model):
    """Provides various statistics of the queue used in the service fabric
    replicator.
    Contains information about the service fabric replicator like the
    replication/copy queue utilization, last acknowledgement received
    timestamp, etc.
    Depending on the role of the replicator, the properties in this type imply
    different meanings.

    :param queue_utilization_percentage: Represents the utilization of the
     queue. A value of 0 indicates that the queue is empty and a value of 100
     indicates the queue is full.
    :type queue_utilization_percentage: int
    :param queue_memory_size: Represents the virtual memory consumed by the
     queue in bytes.
    :type queue_memory_size: str
    :param first_sequence_number: On a primary replicator, this is
     semantically the sequence number of the operation for which all the
     secondary replicas have sent an acknowledgement.
     On a secondary replicator, this is the smallest sequence number of the
     operation that is present in the queue.
    :type first_sequence_number: str
    :param completed_sequence_number: On a primary replicator, this is
     semantically the highest sequence number of the operation for which all
     the secondary replicas have sent an acknowledgement.
     On a secondary replicator, this is semantically the highest sequence
     number that has been applied to the persistent state.
    :type completed_sequence_number: str
    :param committed_sequence_number: On a primary replicator, this is
     semantically the highest sequence number of the operation for which a
     write quorum of the secondary replicas have sent an acknowledgement.
     On a secondary replicator, this is semantically the highest sequence
     number of the in-order operation received from the primary.
    :type committed_sequence_number: str
    :param last_sequence_number: Represents the latest sequence number of the
     operation that is available in the queue.
    :type last_sequence_number: str
    """

    _attribute_map = {
        'queue_utilization_percentage': {'key': 'QueueUtilizationPercentage', 'type': 'int'},
        'queue_memory_size': {'key': 'QueueMemorySize', 'type': 'str'},
        'first_sequence_number': {'key': 'FirstSequenceNumber', 'type': 'str'},
        'completed_sequence_number': {'key': 'CompletedSequenceNumber', 'type': 'str'},
        'committed_sequence_number': {'key': 'CommittedSequenceNumber', 'type': 'str'},
        'last_sequence_number': {'key': 'LastSequenceNumber', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReplicatorQueueStatus, self).__init__(**kwargs)
        self.queue_utilization_percentage = kwargs.get('queue_utilization_percentage', None)
        self.queue_memory_size = kwargs.get('queue_memory_size', None)
        self.first_sequence_number = kwargs.get('first_sequence_number', None)
        self.completed_sequence_number = kwargs.get('completed_sequence_number', None)
        self.committed_sequence_number = kwargs.get('committed_sequence_number', None)
        self.last_sequence_number = kwargs.get('last_sequence_number', None)


class ResolvedServiceEndpoint(Model):
    """Endpoint of a resolved service partition.

    :param kind: The role of the replica where the endpoint is reported.
     Possible values include: 'Invalid', 'Stateless', 'StatefulPrimary',
     'StatefulSecondary'
    :type kind: str or ~azure.servicefabric.models.ServiceEndpointRole
    :param address: The address of the endpoint. If the endpoint has multiple
     listeners the address is a JSON object with one property per listener with
     the value as the address of that listener.
    :type address: str
    """

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResolvedServiceEndpoint, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.address = kwargs.get('address', None)


class ResolvedServicePartition(Model):
    """Information about a service partition and its associated endpoints.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The full name of the service with 'fabric:' URI
     scheme.
    :type name: str
    :param partition_information: Required. A representation of the resolved
     partition.
    :type partition_information:
     ~azure.servicefabric.models.PartitionInformation
    :param endpoints: Required. List of resolved service endpoints of a
     service partition.
    :type endpoints: list[~azure.servicefabric.models.ResolvedServiceEndpoint]
    :param version: Required. The version of this resolved service partition
     result. This version should be passed in the next time the ResolveService
     call is made via the PreviousRspVersion query parameter.
    :type version: str
    """

    _validation = {
        'name': {'required': True},
        'partition_information': {'required': True},
        'endpoints': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'endpoints': {'key': 'Endpoints', 'type': '[ResolvedServiceEndpoint]'},
        'version': {'key': 'Version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResolvedServicePartition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.partition_information = kwargs.get('partition_information', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.version = kwargs.get('version', None)


class ResourceLimits(Model):
    """This type describes the resource limits for a given container. It describes
    the most amount of resources a container is allowed to use before being
    restarted.

    :param memory_in_gb: The memory limit in GB.
    :type memory_in_gb: float
    :param cpu: CPU limits in cores. At present, only full cores are
     supported.
    :type cpu: float
    """

    _attribute_map = {
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'cpu': {'key': 'cpu', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ResourceLimits, self).__init__(**kwargs)
        self.memory_in_gb = kwargs.get('memory_in_gb', None)
        self.cpu = kwargs.get('cpu', None)


class ResourceRequests(Model):
    """This type describes the requested resources for a given container. It
    describes the least amount of resources required for the container. A
    container can consume more than requested resources up to the specified
    limits before being restarted. Currently, the requested resources are
    treated as limits.

    All required parameters must be populated in order to send to Azure.

    :param memory_in_gb: Required. The memory request in GB for this
     container.
    :type memory_in_gb: float
    :param cpu: Required. Requested number of CPU cores. At present, only full
     cores are supported.
    :type cpu: float
    """

    _validation = {
        'memory_in_gb': {'required': True},
        'cpu': {'required': True},
    }

    _attribute_map = {
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'cpu': {'key': 'cpu', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ResourceRequests, self).__init__(**kwargs)
        self.memory_in_gb = kwargs.get('memory_in_gb', None)
        self.cpu = kwargs.get('cpu', None)


class ResourceRequirements(Model):
    """This type describes the resource requirements for a container or a service.

    All required parameters must be populated in order to send to Azure.

    :param requests: Required. Describes the requested resources for a given
     container.
    :type requests: ~azure.servicefabric.models.ResourceRequests
    :param limits: Describes the maximum limits on the resources for a given
     container.
    :type limits: ~azure.servicefabric.models.ResourceLimits
    """

    _validation = {
        'requests': {'required': True},
    }

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'ResourceRequests'},
        'limits': {'key': 'limits', 'type': 'ResourceLimits'},
    }

    def __init__(self, **kwargs):
        super(ResourceRequirements, self).__init__(**kwargs)
        self.requests = kwargs.get('requests', None)
        self.limits = kwargs.get('limits', None)


class RestartDeployedCodePackageDescription(Model):
    """Defines description for restarting a deployed code package on Service
    Fabric node.

    All required parameters must be populated in order to send to Azure.

    :param service_manifest_name: Required. The name of service manifest that
     specified this code package.
    :type service_manifest_name: str
    :param service_package_activation_id: The ActivationId of a deployed
     service package. If ServicePackageActivationMode specified at the time of
     creating the service
     is 'SharedProcess' (or if it is not specified, in which case it defaults
     to 'SharedProcess'), then value of ServicePackageActivationId
     is always an empty string.
    :type service_package_activation_id: str
    :param code_package_name: Required. The name of the code package defined
     in the service manifest.
    :type code_package_name: str
    :param code_package_instance_id: Required. The instance ID for currently
     running entry point. For a code package setup entry point (if specified)
     runs first and after it finishes main entry point is started.
     Each time entry point executable is run, its instance ID will change. If 0
     is passed in as the code package instance ID, the API will restart the
     code package with whatever instance ID it is currently running.
     If an instance ID other than 0 is passed in, the API will restart the code
     package only if the current Instance ID matches the passed in instance ID.
     Note, passing in the exact instance ID (not 0) in the API is safer,
     because if ensures at most one restart of the code package.
    :type code_package_instance_id: str
    """

    _validation = {
        'service_manifest_name': {'required': True},
        'code_package_name': {'required': True},
        'code_package_instance_id': {'required': True},
    }

    _attribute_map = {
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'service_package_activation_id': {'key': 'ServicePackageActivationId', 'type': 'str'},
        'code_package_name': {'key': 'CodePackageName', 'type': 'str'},
        'code_package_instance_id': {'key': 'CodePackageInstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RestartDeployedCodePackageDescription, self).__init__(**kwargs)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.service_package_activation_id = kwargs.get('service_package_activation_id', None)
        self.code_package_name = kwargs.get('code_package_name', None)
        self.code_package_instance_id = kwargs.get('code_package_instance_id', None)


class RestartNodeDescription(Model):
    """Describes the parameters to restart a Service Fabric node.

    All required parameters must be populated in order to send to Azure.

    :param node_instance_id: Required. The instance ID of the target node. If
     instance ID is specified the node is restarted only if it matches with the
     current instance of the node. A default value of "0" would match any
     instance ID. The instance ID can be obtained using get node query. Default
     value: "0" .
    :type node_instance_id: str
    :param create_fabric_dump: Specify True to create a dump of the fabric
     node process. This is case-sensitive. Possible values include: 'False',
     'True'. Default value: "False" .
    :type create_fabric_dump: str or
     ~azure.servicefabric.models.CreateFabricDump
    """

    _validation = {
        'node_instance_id': {'required': True},
    }

    _attribute_map = {
        'node_instance_id': {'key': 'NodeInstanceId', 'type': 'str'},
        'create_fabric_dump': {'key': 'CreateFabricDump', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RestartNodeDescription, self).__init__(**kwargs)
        self.node_instance_id = kwargs.get('node_instance_id', "0")
        self.create_fabric_dump = kwargs.get('create_fabric_dump', "False")


class RestartPartitionResult(Model):
    """Represents information about an operation in a terminal state (Completed or
    Faulted).

    :param error_code: If OperationState is Completed, this is 0.  If
     OperationState is Faulted, this is an error code indicating the reason.
    :type error_code: int
    :param selected_partition: This class returns information about the
     partition that the user-induced operation acted upon.
    :type selected_partition: ~azure.servicefabric.models.SelectedPartition
    """

    _attribute_map = {
        'error_code': {'key': 'ErrorCode', 'type': 'int'},
        'selected_partition': {'key': 'SelectedPartition', 'type': 'SelectedPartition'},
    }

    def __init__(self, **kwargs):
        super(RestartPartitionResult, self).__init__(**kwargs)
        self.error_code = kwargs.get('error_code', None)
        self.selected_partition = kwargs.get('selected_partition', None)


class RestorePartitionDescription(Model):
    """Specifies the parameters needed to trigger a restore of a specific
    partition.

    All required parameters must be populated in order to send to Azure.

    :param backup_id: Required. Unique backup ID.
    :type backup_id: str
    :param backup_location: Required. Location of the backup relative to the
     backup storage specified/ configured.
    :type backup_location: str
    :param backup_storage: Location of the backup from where the partition
     will be restored.
    :type backup_storage: ~azure.servicefabric.models.BackupStorageDescription
    """

    _validation = {
        'backup_id': {'required': True},
        'backup_location': {'required': True},
    }

    _attribute_map = {
        'backup_id': {'key': 'BackupId', 'type': 'str'},
        'backup_location': {'key': 'BackupLocation', 'type': 'str'},
        'backup_storage': {'key': 'BackupStorage', 'type': 'BackupStorageDescription'},
    }

    def __init__(self, **kwargs):
        super(RestorePartitionDescription, self).__init__(**kwargs)
        self.backup_id = kwargs.get('backup_id', None)
        self.backup_location = kwargs.get('backup_location', None)
        self.backup_storage = kwargs.get('backup_storage', None)


class RestoreProgressInfo(Model):
    """Describes the progress of a restore operation on a partition.

    :param restore_state: Represents the current state of the partition
     restore operation. Possible values include: 'Invalid', 'Accepted',
     'RestoreInProgress', 'Success', 'Failure', 'Timeout'
    :type restore_state: str or ~azure.servicefabric.models.RestoreState
    :param time_stamp_utc: Timestamp when operation succeeded or failed.
    :type time_stamp_utc: datetime
    :param restored_epoch: Describes the epoch at which the partition is
     restored.
    :type restored_epoch: ~azure.servicefabric.models.Epoch
    :param restored_lsn: Restored LSN.
    :type restored_lsn: str
    :param failure_error: Denotes the failure encountered in performing
     restore operation.
    :type failure_error: ~azure.servicefabric.models.FabricErrorError
    """

    _attribute_map = {
        'restore_state': {'key': 'RestoreState', 'type': 'str'},
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'restored_epoch': {'key': 'RestoredEpoch', 'type': 'Epoch'},
        'restored_lsn': {'key': 'RestoredLsn', 'type': 'str'},
        'failure_error': {'key': 'FailureError', 'type': 'FabricErrorError'},
    }

    def __init__(self, **kwargs):
        super(RestoreProgressInfo, self).__init__(**kwargs)
        self.restore_state = kwargs.get('restore_state', None)
        self.time_stamp_utc = kwargs.get('time_stamp_utc', None)
        self.restored_epoch = kwargs.get('restored_epoch', None)
        self.restored_lsn = kwargs.get('restored_lsn', None)
        self.failure_error = kwargs.get('failure_error', None)


class ResumeApplicationUpgradeDescription(Model):
    """Describes the parameters for resuming an unmonitored manual Service Fabric
    application upgrade.

    All required parameters must be populated in order to send to Azure.

    :param upgrade_domain_name: Required. The name of the upgrade domain in
     which to resume the upgrade.
    :type upgrade_domain_name: str
    """

    _validation = {
        'upgrade_domain_name': {'required': True},
    }

    _attribute_map = {
        'upgrade_domain_name': {'key': 'UpgradeDomainName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResumeApplicationUpgradeDescription, self).__init__(**kwargs)
        self.upgrade_domain_name = kwargs.get('upgrade_domain_name', None)


class ResumeClusterUpgradeDescription(Model):
    """Describes the parameters for resuming a cluster upgrade.

    All required parameters must be populated in order to send to Azure.

    :param upgrade_domain: Required. The next upgrade domain for this cluster
     upgrade.
    :type upgrade_domain: str
    """

    _validation = {
        'upgrade_domain': {'required': True},
    }

    _attribute_map = {
        'upgrade_domain': {'key': 'UpgradeDomain', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResumeClusterUpgradeDescription, self).__init__(**kwargs)
        self.upgrade_domain = kwargs.get('upgrade_domain', None)


class RollingUpgradeUpdateDescription(Model):
    """Describes the parameters for updating a rolling upgrade of application or
    cluster.

    All required parameters must be populated in order to send to Azure.

    :param rolling_upgrade_mode: Required. The mode used to monitor health
     during a rolling upgrade. The values are UnmonitoredAuto,
     UnmonitoredManual, and Monitored. Possible values include: 'Invalid',
     'UnmonitoredAuto', 'UnmonitoredManual', 'Monitored'. Default value:
     "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param force_restart: If true, then processes are forcefully restarted
     during upgrade even when the code version has not changed (the upgrade
     only changes configuration or data).
    :type force_restart: bool
    :param replica_set_check_timeout_in_milliseconds: The maximum amount of
     time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires,
     processing of the upgrade domain will proceed regardless of availability
     loss issues. The timeout is reset at the start of each upgrade domain.
     Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit
     integer).
    :type replica_set_check_timeout_in_milliseconds: long
    :param failure_action: The compensating action to perform when a Monitored
     upgrade encounters monitoring policy or health policy violations.
     Invalid indicates the failure action is invalid. Rollback specifies that
     the upgrade will start rolling back automatically.
     Manual indicates that the upgrade will switch to UnmonitoredManual upgrade
     mode. Possible values include: 'Invalid', 'Rollback', 'Manual'
    :type failure_action: str or ~azure.servicefabric.models.FailureAction
    :param health_check_wait_duration_in_milliseconds: The amount of time to
     wait after completing an upgrade domain before applying health policies.
     It is first interpreted as a string representing an ISO 8601 duration. If
     that fails, then it is interpreted as a number representing the total
     number of milliseconds.
    :type health_check_wait_duration_in_milliseconds: str
    :param health_check_stable_duration_in_milliseconds: The amount of time
     that the application or cluster must remain healthy before the upgrade
     proceeds to the next upgrade domain. It is first interpreted as a string
     representing an ISO 8601 duration. If that fails, then it is interpreted
     as a number representing the total number of milliseconds.
    :type health_check_stable_duration_in_milliseconds: str
    :param health_check_retry_timeout_in_milliseconds: The amount of time to
     retry health evaluation when the application or cluster is unhealthy
     before FailureAction is executed. It is first interpreted as a string
     representing an ISO 8601 duration. If that fails, then it is interpreted
     as a number representing the total number of milliseconds.
    :type health_check_retry_timeout_in_milliseconds: str
    :param upgrade_timeout_in_milliseconds: The amount of time the overall
     upgrade has to complete before FailureAction is executed. It is first
     interpreted as a string representing an ISO 8601 duration. If that fails,
     then it is interpreted as a number representing the total number of
     milliseconds.
    :type upgrade_timeout_in_milliseconds: str
    :param upgrade_domain_timeout_in_milliseconds: The amount of time each
     upgrade domain has to complete before FailureAction is executed. It is
     first interpreted as a string representing an ISO 8601 duration. If that
     fails, then it is interpreted as a number representing the total number of
     milliseconds.
    :type upgrade_domain_timeout_in_milliseconds: str
    """

    _validation = {
        'rolling_upgrade_mode': {'required': True},
    }

    _attribute_map = {
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'force_restart': {'key': 'ForceRestart', 'type': 'bool'},
        'replica_set_check_timeout_in_milliseconds': {'key': 'ReplicaSetCheckTimeoutInMilliseconds', 'type': 'long'},
        'failure_action': {'key': 'FailureAction', 'type': 'str'},
        'health_check_wait_duration_in_milliseconds': {'key': 'HealthCheckWaitDurationInMilliseconds', 'type': 'str'},
        'health_check_stable_duration_in_milliseconds': {'key': 'HealthCheckStableDurationInMilliseconds', 'type': 'str'},
        'health_check_retry_timeout_in_milliseconds': {'key': 'HealthCheckRetryTimeoutInMilliseconds', 'type': 'str'},
        'upgrade_timeout_in_milliseconds': {'key': 'UpgradeTimeoutInMilliseconds', 'type': 'str'},
        'upgrade_domain_timeout_in_milliseconds': {'key': 'UpgradeDomainTimeoutInMilliseconds', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RollingUpgradeUpdateDescription, self).__init__(**kwargs)
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.force_restart = kwargs.get('force_restart', None)
        self.replica_set_check_timeout_in_milliseconds = kwargs.get('replica_set_check_timeout_in_milliseconds', None)
        self.failure_action = kwargs.get('failure_action', None)
        self.health_check_wait_duration_in_milliseconds = kwargs.get('health_check_wait_duration_in_milliseconds', None)
        self.health_check_stable_duration_in_milliseconds = kwargs.get('health_check_stable_duration_in_milliseconds', None)
        self.health_check_retry_timeout_in_milliseconds = kwargs.get('health_check_retry_timeout_in_milliseconds', None)
        self.upgrade_timeout_in_milliseconds = kwargs.get('upgrade_timeout_in_milliseconds', None)
        self.upgrade_domain_timeout_in_milliseconds = kwargs.get('upgrade_domain_timeout_in_milliseconds', None)


class SafetyCheckWrapper(Model):
    """A wrapper for the safety check object. Safety checks are performed by
    service fabric before continuing with the operations. These checks ensure
    the availability of the service and the reliability of the state.

    :param safety_check: Represents a safety check performed by service fabric
     before continuing with the operations. These checks ensure the
     availability of the service and the reliability of the state.
    :type safety_check: ~azure.servicefabric.models.SafetyCheck
    """

    _attribute_map = {
        'safety_check': {'key': 'SafetyCheck', 'type': 'SafetyCheck'},
    }

    def __init__(self, **kwargs):
        super(SafetyCheckWrapper, self).__init__(**kwargs)
        self.safety_check = kwargs.get('safety_check', None)


class ScalingPolicyDescription(Model):
    """Describes how the scaling should be performed.

    All required parameters must be populated in order to send to Azure.

    :param scaling_trigger: Required. Specifies the trigger associated with
     this scaling policy
    :type scaling_trigger:
     ~azure.servicefabric.models.ScalingTriggerDescription
    :param scaling_mechanism: Required. Specifies the mechanism associated
     with this scaling policy
    :type scaling_mechanism:
     ~azure.servicefabric.models.ScalingMechanismDescription
    """

    _validation = {
        'scaling_trigger': {'required': True},
        'scaling_mechanism': {'required': True},
    }

    _attribute_map = {
        'scaling_trigger': {'key': 'ScalingTrigger', 'type': 'ScalingTriggerDescription'},
        'scaling_mechanism': {'key': 'ScalingMechanism', 'type': 'ScalingMechanismDescription'},
    }

    def __init__(self, **kwargs):
        super(ScalingPolicyDescription, self).__init__(**kwargs)
        self.scaling_trigger = kwargs.get('scaling_trigger', None)
        self.scaling_mechanism = kwargs.get('scaling_mechanism', None)


class SecondaryReplicatorStatus(ReplicatorStatus):
    """Provides statistics about the Service Fabric Replicator, when it is
    functioning in a ActiveSecondary role.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecondaryActiveReplicatorStatus,
    SecondaryIdleReplicatorStatus

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param replication_queue_status: Details about the replication queue on
     the secondary replicator.
    :type replication_queue_status:
     ~azure.servicefabric.models.ReplicatorQueueStatus
    :param last_replication_operation_received_time_utc: The last time-stamp
     (UTC) at which a replication operation was received from the primary.
     UTC 0 represents an invalid value, indicating that a replication operation
     message was never received.
    :type last_replication_operation_received_time_utc: datetime
    :param is_in_build: Value that indicates whether the replica is currently
     being built.
    :type is_in_build: bool
    :param copy_queue_status: Details about the copy queue on the secondary
     replicator.
    :type copy_queue_status: ~azure.servicefabric.models.ReplicatorQueueStatus
    :param last_copy_operation_received_time_utc: The last time-stamp (UTC) at
     which a copy operation was received from the primary.
     UTC 0 represents an invalid value, indicating that a copy operation
     message was never received.
    :type last_copy_operation_received_time_utc: datetime
    :param last_acknowledgement_sent_time_utc: The last time-stamp (UTC) at
     which an acknowledgment was sent to the primary replicator.
     UTC 0 represents an invalid value, indicating that an acknowledgment
     message was never sent.
    :type last_acknowledgement_sent_time_utc: datetime
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'replication_queue_status': {'key': 'ReplicationQueueStatus', 'type': 'ReplicatorQueueStatus'},
        'last_replication_operation_received_time_utc': {'key': 'LastReplicationOperationReceivedTimeUtc', 'type': 'iso-8601'},
        'is_in_build': {'key': 'IsInBuild', 'type': 'bool'},
        'copy_queue_status': {'key': 'CopyQueueStatus', 'type': 'ReplicatorQueueStatus'},
        'last_copy_operation_received_time_utc': {'key': 'LastCopyOperationReceivedTimeUtc', 'type': 'iso-8601'},
        'last_acknowledgement_sent_time_utc': {'key': 'LastAcknowledgementSentTimeUtc', 'type': 'iso-8601'},
    }

    _subtype_map = {
        'kind': {'ActiveSecondary': 'SecondaryActiveReplicatorStatus', 'IdleSecondary': 'SecondaryIdleReplicatorStatus'}
    }

    def __init__(self, **kwargs):
        super(SecondaryReplicatorStatus, self).__init__(**kwargs)
        self.replication_queue_status = kwargs.get('replication_queue_status', None)
        self.last_replication_operation_received_time_utc = kwargs.get('last_replication_operation_received_time_utc', None)
        self.is_in_build = kwargs.get('is_in_build', None)
        self.copy_queue_status = kwargs.get('copy_queue_status', None)
        self.last_copy_operation_received_time_utc = kwargs.get('last_copy_operation_received_time_utc', None)
        self.last_acknowledgement_sent_time_utc = kwargs.get('last_acknowledgement_sent_time_utc', None)
        self.kind = 'SecondaryReplicatorStatus'


class SecondaryActiveReplicatorStatus(SecondaryReplicatorStatus):
    """Status of the secondary replicator when it is in active mode and is part of
    the replica set.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param replication_queue_status: Details about the replication queue on
     the secondary replicator.
    :type replication_queue_status:
     ~azure.servicefabric.models.ReplicatorQueueStatus
    :param last_replication_operation_received_time_utc: The last time-stamp
     (UTC) at which a replication operation was received from the primary.
     UTC 0 represents an invalid value, indicating that a replication operation
     message was never received.
    :type last_replication_operation_received_time_utc: datetime
    :param is_in_build: Value that indicates whether the replica is currently
     being built.
    :type is_in_build: bool
    :param copy_queue_status: Details about the copy queue on the secondary
     replicator.
    :type copy_queue_status: ~azure.servicefabric.models.ReplicatorQueueStatus
    :param last_copy_operation_received_time_utc: The last time-stamp (UTC) at
     which a copy operation was received from the primary.
     UTC 0 represents an invalid value, indicating that a copy operation
     message was never received.
    :type last_copy_operation_received_time_utc: datetime
    :param last_acknowledgement_sent_time_utc: The last time-stamp (UTC) at
     which an acknowledgment was sent to the primary replicator.
     UTC 0 represents an invalid value, indicating that an acknowledgment
     message was never sent.
    :type last_acknowledgement_sent_time_utc: datetime
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'replication_queue_status': {'key': 'ReplicationQueueStatus', 'type': 'ReplicatorQueueStatus'},
        'last_replication_operation_received_time_utc': {'key': 'LastReplicationOperationReceivedTimeUtc', 'type': 'iso-8601'},
        'is_in_build': {'key': 'IsInBuild', 'type': 'bool'},
        'copy_queue_status': {'key': 'CopyQueueStatus', 'type': 'ReplicatorQueueStatus'},
        'last_copy_operation_received_time_utc': {'key': 'LastCopyOperationReceivedTimeUtc', 'type': 'iso-8601'},
        'last_acknowledgement_sent_time_utc': {'key': 'LastAcknowledgementSentTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SecondaryActiveReplicatorStatus, self).__init__(**kwargs)
        self.kind = 'ActiveSecondary'


class SecondaryIdleReplicatorStatus(SecondaryReplicatorStatus):
    """Status of the secondary replicator when it is in idle mode and is being
    built by the primary.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param replication_queue_status: Details about the replication queue on
     the secondary replicator.
    :type replication_queue_status:
     ~azure.servicefabric.models.ReplicatorQueueStatus
    :param last_replication_operation_received_time_utc: The last time-stamp
     (UTC) at which a replication operation was received from the primary.
     UTC 0 represents an invalid value, indicating that a replication operation
     message was never received.
    :type last_replication_operation_received_time_utc: datetime
    :param is_in_build: Value that indicates whether the replica is currently
     being built.
    :type is_in_build: bool
    :param copy_queue_status: Details about the copy queue on the secondary
     replicator.
    :type copy_queue_status: ~azure.servicefabric.models.ReplicatorQueueStatus
    :param last_copy_operation_received_time_utc: The last time-stamp (UTC) at
     which a copy operation was received from the primary.
     UTC 0 represents an invalid value, indicating that a copy operation
     message was never received.
    :type last_copy_operation_received_time_utc: datetime
    :param last_acknowledgement_sent_time_utc: The last time-stamp (UTC) at
     which an acknowledgment was sent to the primary replicator.
     UTC 0 represents an invalid value, indicating that an acknowledgment
     message was never sent.
    :type last_acknowledgement_sent_time_utc: datetime
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'replication_queue_status': {'key': 'ReplicationQueueStatus', 'type': 'ReplicatorQueueStatus'},
        'last_replication_operation_received_time_utc': {'key': 'LastReplicationOperationReceivedTimeUtc', 'type': 'iso-8601'},
        'is_in_build': {'key': 'IsInBuild', 'type': 'bool'},
        'copy_queue_status': {'key': 'CopyQueueStatus', 'type': 'ReplicatorQueueStatus'},
        'last_copy_operation_received_time_utc': {'key': 'LastCopyOperationReceivedTimeUtc', 'type': 'iso-8601'},
        'last_acknowledgement_sent_time_utc': {'key': 'LastAcknowledgementSentTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SecondaryIdleReplicatorStatus, self).__init__(**kwargs)
        self.kind = 'IdleSecondary'


class SecretResourceDescription(Model):
    """This type describes a secret resource.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Describes the properties of a secret
     resource.
    :type properties: ~azure.servicefabric.models.SecretResourceProperties
    :param name: Required. Name of the Secret resource.
    :type name: str
    """

    _validation = {
        'properties': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SecretResourceProperties'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecretResourceDescription, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.name = kwargs.get('name', None)


class SecretValue(Model):
    """This type represents the unencrypted value of the secret.

    :param value: The actual value of the secret.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecretValue, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SecretValueProperties(Model):
    """This type describes properties of secret value resource.

    :param value: The actual value of the secret.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecretValueProperties, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SecretValueResourceDescription(Model):
    """This type describes a value of a secret resource. The name of this resource
    is the version identifier corresponding to this secret value.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Version identifier of the secret value.
    :type name: str
    :param value: The actual value of the secret.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecretValueResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class SeedNodeSafetyCheck(SafetyCheck):
    """Represents a safety check for the seed nodes being performed by service
    fabric before continuing with node level operations.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SeedNodeSafetyCheck, self).__init__(**kwargs)
        self.kind = 'EnsureSeedNodeQuorum'


class SelectedPartition(Model):
    """This class returns information about the partition that the user-induced
    operation acted upon.

    :param service_name: The name of the service the partition belongs to.
    :type service_name: str
    :param partition_id: An internal ID used by Service Fabric to uniquely
     identify a partition. This is a randomly generated GUID when the service
     was created. The partition ID is unique and does not change for the
     lifetime of the service. If the same service was deleted and recreated the
     IDs of its partitions would be different.
    :type partition_id: str
    """

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SelectedPartition, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.partition_id = kwargs.get('partition_id', None)


class ServiceBackupConfigurationInfo(BackupConfigurationInfo):
    """Backup configuration information for a specific Service Fabric service
    specifying what backup policy is being applied and suspend description, if
    any.

    All required parameters must be populated in order to send to Azure.

    :param policy_name: The name of the backup policy which is applicable to
     this Service Fabric application or service or partition.
    :type policy_name: str
    :param policy_inherited_from: Specifies the scope at which the backup
     policy is applied. Possible values include: 'Invalid', 'Partition',
     'Service', 'Application'
    :type policy_inherited_from: str or
     ~azure.servicefabric.models.BackupPolicyScope
    :param suspension_info: Describes the backup suspension details.
    :type suspension_info: ~azure.servicefabric.models.BackupSuspensionInfo
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'policy_name': {'key': 'PolicyName', 'type': 'str'},
        'policy_inherited_from': {'key': 'PolicyInheritedFrom', 'type': 'str'},
        'suspension_info': {'key': 'SuspensionInfo', 'type': 'BackupSuspensionInfo'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceBackupConfigurationInfo, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.kind = 'Service'


class ServiceBackupEntity(BackupEntity):
    """Identifies the Service Fabric stateful service which is being backed up.

    All required parameters must be populated in order to send to Azure.

    :param entity_kind: Required. Constant filled by server.
    :type entity_kind: str
    :param service_name: The full name of the service with 'fabric:' URI
     scheme.
    :type service_name: str
    """

    _validation = {
        'entity_kind': {'required': True},
    }

    _attribute_map = {
        'entity_kind': {'key': 'EntityKind', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceBackupEntity, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.entity_kind = 'Service'


class ServiceCorrelationDescription(Model):
    """Creates a particular correlation between services.

    All required parameters must be populated in order to send to Azure.

    :param scheme: Required. The ServiceCorrelationScheme which describes the
     relationship between this service and the service specified via
     ServiceName. Possible values include: 'Invalid', 'Affinity',
     'AlignedAffinity', 'NonAlignedAffinity'
    :type scheme: str or ~azure.servicefabric.models.ServiceCorrelationScheme
    :param service_name: Required. The name of the service that the
     correlation relationship is established with.
    :type service_name: str
    """

    _validation = {
        'scheme': {'required': True},
        'service_name': {'required': True},
    }

    _attribute_map = {
        'scheme': {'key': 'Scheme', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceCorrelationDescription, self).__init__(**kwargs)
        self.scheme = kwargs.get('scheme', None)
        self.service_name = kwargs.get('service_name', None)


class ServiceEvent(FabricEvent):
    """Represents the base for all Service Events.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServiceCreatedEvent, ServiceDeletedEvent,
    ServiceNewHealthReportEvent, ServiceHealthReportExpiredEvent

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_id: Required. The identity of the service. This ID is an
     encoded representation of the service name. This is used in the REST APIs
     to identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type service_id: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'service_id': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_id': {'key': 'ServiceId', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ServiceCreated': 'ServiceCreatedEvent', 'ServiceDeleted': 'ServiceDeletedEvent', 'ServiceNewHealthReport': 'ServiceNewHealthReportEvent', 'ServiceHealthReportExpired': 'ServiceHealthReportExpiredEvent'}
    }

    def __init__(self, **kwargs):
        super(ServiceEvent, self).__init__(**kwargs)
        self.service_id = kwargs.get('service_id', None)
        self.kind = 'ServiceEvent'


class ServiceCreatedEvent(ServiceEvent):
    """Service Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_id: Required. The identity of the service. This ID is an
     encoded representation of the service name. This is used in the REST APIs
     to identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type service_id: str
    :param service_type_name: Required. Service type name.
    :type service_type_name: str
    :param application_name: Required. Application name.
    :type application_name: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param service_instance: Required. Id of Service instance.
    :type service_instance: long
    :param is_stateful: Required. Indicates if Service is stateful.
    :type is_stateful: bool
    :param partition_count: Required. Number of partitions.
    :type partition_count: int
    :param target_replica_set_size: Required. Size of target replicas set.
    :type target_replica_set_size: int
    :param min_replica_set_size: Required. Minimum size of replicas set.
    :type min_replica_set_size: int
    :param service_package_version: Required. Version of Service package.
    :type service_package_version: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'service_id': {'required': True},
        'service_type_name': {'required': True},
        'application_name': {'required': True},
        'application_type_name': {'required': True},
        'service_instance': {'required': True},
        'is_stateful': {'required': True},
        'partition_count': {'required': True},
        'target_replica_set_size': {'required': True},
        'min_replica_set_size': {'required': True},
        'service_package_version': {'required': True},
        'partition_id': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_id': {'key': 'ServiceId', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'service_instance': {'key': 'ServiceInstance', 'type': 'long'},
        'is_stateful': {'key': 'IsStateful', 'type': 'bool'},
        'partition_count': {'key': 'PartitionCount', 'type': 'int'},
        'target_replica_set_size': {'key': 'TargetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'MinReplicaSetSize', 'type': 'int'},
        'service_package_version': {'key': 'ServicePackageVersion', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceCreatedEvent, self).__init__(**kwargs)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.application_name = kwargs.get('application_name', None)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.service_instance = kwargs.get('service_instance', None)
        self.is_stateful = kwargs.get('is_stateful', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.target_replica_set_size = kwargs.get('target_replica_set_size', None)
        self.min_replica_set_size = kwargs.get('min_replica_set_size', None)
        self.service_package_version = kwargs.get('service_package_version', None)
        self.partition_id = kwargs.get('partition_id', None)
        self.kind = 'ServiceCreated'


class ServiceDeletedEvent(ServiceEvent):
    """Service Deleted event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_id: Required. The identity of the service. This ID is an
     encoded representation of the service name. This is used in the REST APIs
     to identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type service_id: str
    :param service_type_name: Required. Service type name.
    :type service_type_name: str
    :param application_name: Required. Application name.
    :type application_name: str
    :param application_type_name: Required. Application type name.
    :type application_type_name: str
    :param service_instance: Required. Id of Service instance.
    :type service_instance: long
    :param is_stateful: Required. Indicates if Service is stateful.
    :type is_stateful: bool
    :param partition_count: Required. Number of partitions.
    :type partition_count: int
    :param target_replica_set_size: Required. Size of target replicas set.
    :type target_replica_set_size: int
    :param min_replica_set_size: Required. Minimum size of replicas set.
    :type min_replica_set_size: int
    :param service_package_version: Required. Version of Service package.
    :type service_package_version: str
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'service_id': {'required': True},
        'service_type_name': {'required': True},
        'application_name': {'required': True},
        'application_type_name': {'required': True},
        'service_instance': {'required': True},
        'is_stateful': {'required': True},
        'partition_count': {'required': True},
        'target_replica_set_size': {'required': True},
        'min_replica_set_size': {'required': True},
        'service_package_version': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_id': {'key': 'ServiceId', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'service_instance': {'key': 'ServiceInstance', 'type': 'long'},
        'is_stateful': {'key': 'IsStateful', 'type': 'bool'},
        'partition_count': {'key': 'PartitionCount', 'type': 'int'},
        'target_replica_set_size': {'key': 'TargetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'MinReplicaSetSize', 'type': 'int'},
        'service_package_version': {'key': 'ServicePackageVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceDeletedEvent, self).__init__(**kwargs)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.application_name = kwargs.get('application_name', None)
        self.application_type_name = kwargs.get('application_type_name', None)
        self.service_instance = kwargs.get('service_instance', None)
        self.is_stateful = kwargs.get('is_stateful', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.target_replica_set_size = kwargs.get('target_replica_set_size', None)
        self.min_replica_set_size = kwargs.get('min_replica_set_size', None)
        self.service_package_version = kwargs.get('service_package_version', None)
        self.kind = 'ServiceDeleted'


class ServiceDescription(Model):
    """A ServiceDescription contains all of the information necessary to create a
    service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceDescription, StatelessServiceDescription

    All required parameters must be populated in order to send to Azure.

    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param service_name: Required. The full name of the service with 'fabric:'
     URI scheme.
    :type service_name: str
    :param service_type_name: Required. Name of the service type as specified
     in the service manifest.
    :type service_type_name: str
    :param initialization_data: The initialization data as an array of bytes.
     Initialization data is passed to service instances or replicas when they
     are created.
    :type initialization_data: list[int]
    :param partition_description: Required. The partition description as an
     object.
    :type partition_description:
     ~azure.servicefabric.models.PartitionSchemeDescription
    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: The correlation scheme.
    :type correlation_scheme:
     list[~azure.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics.
    :type service_load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: The service placement policies.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: The move cost for the service. Possible values
     include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.servicefabric.models.MoveCost
    :param is_default_move_cost_specified: Indicates if the DefaultMoveCost
     property is specified.
    :type is_default_move_cost_specified: bool
    :param service_package_activation_mode: The activation mode of service
     package to be used for a service. Possible values include:
     'SharedProcess', 'ExclusiveProcess'
    :type service_package_activation_mode: str or
     ~azure.servicefabric.models.ServicePackageActivationMode
    :param service_dns_name: The DNS name of the service. It requires the DNS
     system service to be enabled in Service Fabric cluster.
    :type service_dns_name: str
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~azure.servicefabric.models.ScalingPolicyDescription]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_name': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'initialization_data': {'key': 'InitializationData', 'type': '[int]'},
        'partition_description': {'key': 'PartitionDescription', 'type': 'PartitionSchemeDescription'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'CorrelationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'ServiceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'DefaultMoveCost', 'type': 'str'},
        'is_default_move_cost_specified': {'key': 'IsDefaultMoveCostSpecified', 'type': 'bool'},
        'service_package_activation_mode': {'key': 'ServicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'ServiceDnsName', 'type': 'str'},
        'scaling_policies': {'key': 'ScalingPolicies', 'type': '[ScalingPolicyDescription]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceDescription', 'Stateless': 'StatelessServiceDescription'}
    }

    def __init__(self, **kwargs):
        super(ServiceDescription, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.service_name = kwargs.get('service_name', None)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.initialization_data = kwargs.get('initialization_data', None)
        self.partition_description = kwargs.get('partition_description', None)
        self.placement_constraints = kwargs.get('placement_constraints', None)
        self.correlation_scheme = kwargs.get('correlation_scheme', None)
        self.service_load_metrics = kwargs.get('service_load_metrics', None)
        self.service_placement_policies = kwargs.get('service_placement_policies', None)
        self.default_move_cost = kwargs.get('default_move_cost', None)
        self.is_default_move_cost_specified = kwargs.get('is_default_move_cost_specified', None)
        self.service_package_activation_mode = kwargs.get('service_package_activation_mode', None)
        self.service_dns_name = kwargs.get('service_dns_name', None)
        self.scaling_policies = kwargs.get('scaling_policies', None)
        self.service_kind = None


class ServiceFromTemplateDescription(Model):
    """Defines description for creating a Service Fabric service from a template
    defined in the application manifest.

    All required parameters must be populated in order to send to Azure.

    :param application_name: Required. The name of the application, including
     the 'fabric:' URI scheme.
    :type application_name: str
    :param service_name: Required. The full name of the service with 'fabric:'
     URI scheme.
    :type service_name: str
    :param service_type_name: Required. Name of the service type as specified
     in the service manifest.
    :type service_type_name: str
    :param initialization_data: The initialization data for the newly created
     service instance.
    :type initialization_data: list[int]
    :param service_package_activation_mode: The activation mode of service
     package to be used for a service. Possible values include:
     'SharedProcess', 'ExclusiveProcess'
    :type service_package_activation_mode: str or
     ~azure.servicefabric.models.ServicePackageActivationMode
    :param service_dns_name: The DNS name of the service. It requires the DNS
     system service to be enabled in Service Fabric cluster.
    :type service_dns_name: str
    """

    _validation = {
        'application_name': {'required': True},
        'service_name': {'required': True},
        'service_type_name': {'required': True},
    }

    _attribute_map = {
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'initialization_data': {'key': 'InitializationData', 'type': '[int]'},
        'service_package_activation_mode': {'key': 'ServicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'ServiceDnsName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceFromTemplateDescription, self).__init__(**kwargs)
        self.application_name = kwargs.get('application_name', None)
        self.service_name = kwargs.get('service_name', None)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.initialization_data = kwargs.get('initialization_data', None)
        self.service_package_activation_mode = kwargs.get('service_package_activation_mode', None)
        self.service_dns_name = kwargs.get('service_dns_name', None)


class ServiceHealth(EntityHealth):
    """Information about the health of a Service Fabric service.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param name: The name of the service whose health information is described
     by this object.
    :type name: str
    :param partition_health_states: The list of partition health states
     associated with the service.
    :type partition_health_states:
     list[~azure.servicefabric.models.PartitionHealthState]
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'name': {'key': 'Name', 'type': 'str'},
        'partition_health_states': {'key': 'PartitionHealthStates', 'type': '[PartitionHealthState]'},
    }

    def __init__(self, **kwargs):
        super(ServiceHealth, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.partition_health_states = kwargs.get('partition_health_states', None)


class ServiceHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for a service, containing information about
    the data and the algorithm used by health store to evaluate health. The
    evaluation is returned only when the aggregated health state is either
    Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_name: Name of the service whose health evaluation is
     described by this object.
    :type service_name: str
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the current aggregated health state of the service. The types of the
     unhealthy evaluations can be PartitionsHealthEvaluation or
     EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ServiceHealthEvaluation, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Service'


class ServiceHealthReportExpiredEvent(ServiceEvent):
    """Service Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_id: Required. The identity of the service. This ID is an
     encoded representation of the service name. This is used in the REST APIs
     to identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type service_id: str
    :param instance_id: Required. Id of Service instance.
    :type instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'service_id': {'required': True},
        'instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_id': {'key': 'ServiceId', 'type': 'str'},
        'instance_id': {'key': 'InstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ServiceHealthReportExpiredEvent, self).__init__(**kwargs)
        self.instance_id = kwargs.get('instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'ServiceHealthReportExpired'


class ServiceHealthState(EntityHealthState):
    """Represents the health state of a service, which contains the service
    identifier and its aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param service_name: Name of the service whose health state is represented
     by this object.
    :type service_name: str
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceHealthState, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)


class ServiceHealthStateChunk(EntityHealthStateChunk):
    """Represents the health state chunk of a service, which contains the service
    name, its aggregated health state and any partitions that respect the
    filters in the cluster health chunk query description.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param service_name: The name of the service whose health state chunk is
     provided in this object.
    :type service_name: str
    :param partition_health_state_chunks: The list of partition health state
     chunks belonging to the service that respect the filters in the cluster
     health chunk query description.
    :type partition_health_state_chunks:
     ~azure.servicefabric.models.PartitionHealthStateChunkList
    """

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_health_state_chunks': {'key': 'PartitionHealthStateChunks', 'type': 'PartitionHealthStateChunkList'},
    }

    def __init__(self, **kwargs):
        super(ServiceHealthStateChunk, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.partition_health_state_chunks = kwargs.get('partition_health_state_chunks', None)


class ServiceHealthStateChunkList(Model):
    """The list of service health state chunks that respect the input filters in
    the chunk query. Returned by get cluster health state chunks query.

    :param items: The list of service health state chunks that respect the
     input filters in the chunk query.
    :type items: list[~azure.servicefabric.models.ServiceHealthStateChunk]
    """

    _attribute_map = {
        'items': {'key': 'Items', 'type': '[ServiceHealthStateChunk]'},
    }

    def __init__(self, **kwargs):
        super(ServiceHealthStateChunkList, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)


class ServiceHealthStateFilter(Model):
    """Defines matching criteria to determine whether a service should be included
    as a child of an application in the cluster health chunk.
    The services are only returned if the parent application matches a filter
    specified in the cluster health chunk query description.
    One filter can match zero, one or multiple services, depending on its
    properties.

    :param service_name_filter: The name of the service that matches the
     filter. The filter is applied only to the specified service, if it exists.
     If the service doesn't exist, no service is returned in the cluster health
     chunk based on this filter.
     If the service exists, it is included as the application's child if the
     health state matches the other filter properties.
     If not specified, all services that match the parent filters (if any) are
     taken into consideration and matched against the other filter members,
     like health state filter.
    :type service_name_filter: str
    :param health_state_filter: The filter for the health state of the
     services. It allows selecting services if they match the desired health
     states.
     The possible values are integer value of one of the following health
     states. Only services that match the filter are returned. All services are
     used to evaluate the cluster aggregated health state.
     If not specified, default value is None, unless the service name is
     specified. If the filter has default value and service name is specified,
     the matching service is returned.
     The state values are flag-based enumeration, so the value could be a
     combination of these values obtained using bitwise 'OR' operator.
     For example, if the provided value is 6, it matches services with
     HealthState value of OK (2) and Warning (4).
     - Default - Default value. Matches any HealthState. The value is zero.
     - None - Filter that doesn't match any HealthState value. Used in order to
     return no results on a given collection of states. The value is 1.
     - Ok - Filter that matches input with HealthState value Ok. The value is
     2.
     - Warning - Filter that matches input with HealthState value Warning. The
     value is 4.
     - Error - Filter that matches input with HealthState value Error. The
     value is 8.
     - All - Filter that matches input with any HealthState value. The value is
     65535. Default value: 0 .
    :type health_state_filter: int
    :param partition_filters: Defines a list of filters that specify which
     partitions to be included in the returned cluster health chunk as children
     of the service. The partitions are returned only if the parent service
     matches a filter.
     If the list is empty, no partitions are returned. All the partitions are
     used to evaluate the parent service aggregated health state, regardless of
     the input filters.
     The service filter may specify multiple partition filters.
     For example, it can specify a filter to return all partitions with health
     state Error and another filter to always include a partition identified by
     its partition ID.
    :type partition_filters:
     list[~azure.servicefabric.models.PartitionHealthStateFilter]
    """

    _attribute_map = {
        'service_name_filter': {'key': 'ServiceNameFilter', 'type': 'str'},
        'health_state_filter': {'key': 'HealthStateFilter', 'type': 'int'},
        'partition_filters': {'key': 'PartitionFilters', 'type': '[PartitionHealthStateFilter]'},
    }

    def __init__(self, **kwargs):
        super(ServiceHealthStateFilter, self).__init__(**kwargs)
        self.service_name_filter = kwargs.get('service_name_filter', None)
        self.health_state_filter = kwargs.get('health_state_filter', 0)
        self.partition_filters = kwargs.get('partition_filters', None)


class ServiceIdentity(Model):
    """Map service identity friendly name to an application identity.

    :param name: The identity friendly name.
    :type name: str
    :param identity_ref: The application identity name.
    :type identity_ref: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'identity_ref': {'key': 'identityRef', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceIdentity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.identity_ref = kwargs.get('identity_ref', None)


class ServiceInfo(Model):
    """Information about a Service Fabric service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceInfo, StatelessServiceInfo

    All required parameters must be populated in order to send to Azure.

    :param id: The identity of the service. This ID is an encoded
     representation of the service name. This is used in the REST APIs to
     identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type id: str
    :param name: The full name of the service with 'fabric:' URI scheme.
    :type name: str
    :param type_name: Name of the service type as specified in the service
     manifest.
    :type type_name: str
    :param manifest_version: The version of the service manifest.
    :type manifest_version: str
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param service_status: The status of the application. Possible values
     include: 'Unknown', 'Active', 'Upgrading', 'Deleting', 'Creating',
     'Failed'
    :type service_status: str or ~azure.servicefabric.models.ServiceStatus
    :param is_service_group: Whether the service is in a service group.
    :type is_service_group: bool
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'manifest_version': {'key': 'ManifestVersion', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'service_status': {'key': 'ServiceStatus', 'type': 'str'},
        'is_service_group': {'key': 'IsServiceGroup', 'type': 'bool'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceInfo', 'Stateless': 'StatelessServiceInfo'}
    }

    def __init__(self, **kwargs):
        super(ServiceInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type_name = kwargs.get('type_name', None)
        self.manifest_version = kwargs.get('manifest_version', None)
        self.health_state = kwargs.get('health_state', None)
        self.service_status = kwargs.get('service_status', None)
        self.is_service_group = kwargs.get('is_service_group', None)
        self.service_kind = None


class ServiceLoadMetricDescription(Model):
    """Specifies a metric to load balance a service during runtime.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the metric. If the service chooses to
     report load during runtime, the load metric name should match the name
     that is specified in Name exactly. Note that metric names are
     case-sensitive.
    :type name: str
    :param weight: The service load metric relative weight, compared to other
     metrics configured for this service, as a number. Possible values include:
     'Zero', 'Low', 'Medium', 'High'
    :type weight: str or ~azure.servicefabric.models.ServiceLoadMetricWeight
    :param primary_default_load: Used only for Stateful services. The default
     amount of load, as a number, that this service creates for this metric
     when it is a Primary replica.
    :type primary_default_load: int
    :param secondary_default_load: Used only for Stateful services. The
     default amount of load, as a number, that this service creates for this
     metric when it is a Secondary replica.
    :type secondary_default_load: int
    :param default_load: Used only for Stateless services. The default amount
     of load, as a number, that this service creates for this metric.
    :type default_load: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'weight': {'key': 'Weight', 'type': 'str'},
        'primary_default_load': {'key': 'PrimaryDefaultLoad', 'type': 'int'},
        'secondary_default_load': {'key': 'SecondaryDefaultLoad', 'type': 'int'},
        'default_load': {'key': 'DefaultLoad', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ServiceLoadMetricDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.weight = kwargs.get('weight', None)
        self.primary_default_load = kwargs.get('primary_default_load', None)
        self.secondary_default_load = kwargs.get('secondary_default_load', None)
        self.default_load = kwargs.get('default_load', None)


class ServiceNameInfo(Model):
    """Information about the service name.

    :param id: The identity of the service. This ID is an encoded
     representation of the service name. This is used in the REST APIs to
     identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type id: str
    :param name: The full name of the service with 'fabric:' URI scheme.
    :type name: str
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceNameInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)


class ServiceNewHealthReportEvent(ServiceEvent):
    """Service Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_id: Required. The identity of the service. This ID is an
     encoded representation of the service name. This is used in the REST APIs
     to identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type service_id: str
    :param instance_id: Required. Id of Service instance.
    :type instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'service_id': {'required': True},
        'instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_id': {'key': 'ServiceId', 'type': 'str'},
        'instance_id': {'key': 'InstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ServiceNewHealthReportEvent, self).__init__(**kwargs)
        self.instance_id = kwargs.get('instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'ServiceNewHealthReport'


class ServicePartitionInfo(Model):
    """Information about a partition of a Service Fabric service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServicePartitionInfo,
    StatelessServicePartitionInfo

    All required parameters must be populated in order to send to Azure.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param partition_status: The status of the service fabric service
     partition. Possible values include: 'Invalid', 'Ready', 'NotReady',
     'InQuorumLoss', 'Reconfiguring', 'Deleting'
    :type partition_status: str or
     ~azure.servicefabric.models.ServicePartitionStatus
    :param partition_information: Information about the partition identity,
     partitioning scheme and keys supported by it.
    :type partition_information:
     ~azure.servicefabric.models.PartitionInformation
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'partition_status': {'key': 'PartitionStatus', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServicePartitionInfo', 'Stateless': 'StatelessServicePartitionInfo'}
    }

    def __init__(self, **kwargs):
        super(ServicePartitionInfo, self).__init__(**kwargs)
        self.health_state = kwargs.get('health_state', None)
        self.partition_status = kwargs.get('partition_status', None)
        self.partition_information = kwargs.get('partition_information', None)
        self.service_kind = None


class ServicePlacementPolicyDescription(Model):
    """Describes the policy to be used for placement of a Service Fabric service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServicePlacementInvalidDomainPolicyDescription,
    ServicePlacementNonPartiallyPlaceServicePolicyDescription,
    ServicePlacementPreferPrimaryDomainPolicyDescription,
    ServicePlacementRequiredDomainPolicyDescription,
    ServicePlacementRequireDomainDistributionPolicyDescription

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'InvalidDomain': 'ServicePlacementInvalidDomainPolicyDescription', 'NonPartiallyPlaceService': 'ServicePlacementNonPartiallyPlaceServicePolicyDescription', 'PreferPrimaryDomain': 'ServicePlacementPreferPrimaryDomainPolicyDescription', 'RequireDomain': 'ServicePlacementRequiredDomainPolicyDescription', 'RequireDomainDistribution': 'ServicePlacementRequireDomainDistributionPolicyDescription'}
    }

    def __init__(self, **kwargs):
        super(ServicePlacementPolicyDescription, self).__init__(**kwargs)
        self.type = None


class ServicePlacementInvalidDomainPolicyDescription(ServicePlacementPolicyDescription):
    """Describes the policy to be used for placement of a Service Fabric service
    where a particular fault or upgrade domain should not be used for placement
    of the instances or replicas of that service.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param domain_name: The name of the domain that should not be used for
     placement.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'domain_name': {'key': 'DomainName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServicePlacementInvalidDomainPolicyDescription, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.type = 'InvalidDomain'


class ServicePlacementNonPartiallyPlaceServicePolicyDescription(ServicePlacementPolicyDescription):
    """Describes the policy to be used for placement of a Service Fabric service
    where all replicas must be able to be placed in order for any replicas to
    be created.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServicePlacementNonPartiallyPlaceServicePolicyDescription, self).__init__(**kwargs)
        self.type = 'NonPartiallyPlaceService'


class ServicePlacementPreferPrimaryDomainPolicyDescription(ServicePlacementPolicyDescription):
    """Describes the policy to be used for placement of a Service Fabric service
    where the service's Primary replicas should optimally be placed in a
    particular domain.
    This placement policy is usually used with fault domains in scenarios where
    the Service Fabric cluster is geographically distributed in order to
    indicate that a service's primary replica should be located in a particular
    fault domain, which in geo-distributed scenarios usually aligns with
    regional or datacenter boundaries. Note that since this is an optimization
    it is possible that the Primary replica may not end up located in this
    domain due to failures, capacity limits, or other constraints.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param domain_name: The name of the domain that should used for placement
     as per this policy.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'domain_name': {'key': 'DomainName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServicePlacementPreferPrimaryDomainPolicyDescription, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.type = 'PreferPrimaryDomain'


class ServicePlacementRequiredDomainPolicyDescription(ServicePlacementPolicyDescription):
    """Describes the policy to be used for placement of a Service Fabric service
    where the instances or replicas of that service must be placed in a
    particular domain.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param domain_name: The name of the domain that should used for placement
     as per this policy.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'domain_name': {'key': 'DomainName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServicePlacementRequiredDomainPolicyDescription, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.type = 'RequireDomain'


class ServicePlacementRequireDomainDistributionPolicyDescription(ServicePlacementPolicyDescription):
    """Describes the policy to be used for placement of a Service Fabric service
    where two replicas from the same partition should never be placed in the
    same fault or upgrade domain.
    While this is not common it can expose the service to an increased risk of
    concurrent failures due to unplanned outages or other cases of
    subsequent/concurrent failures. As an example, consider a case where
    replicas are deployed across different data center, with one replica per
    location. In the event that one of the datacenters goes offline, normally
    the replica that was placed in that datacenter will be packed into one of
    the remaining datacenters. If this is not desirable then this policy should
    be set.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param domain_name: The name of the domain that should used for placement
     as per this policy.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'domain_name': {'key': 'DomainName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServicePlacementRequireDomainDistributionPolicyDescription, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.type = 'RequireDomainDistribution'


class ServiceProperties(Model):
    """Describes properties of a service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param description: User readable description of the service.
    :type description: str
    :param replica_count: The number of replicas of the service to create.
     Defaults to 1 if not specified.
    :type replica_count: int
    :param auto_scaling_policies: Auto scaling policies
    :type auto_scaling_policies:
     list[~azure.servicefabric.models.AutoScalingPolicy]
    :ivar status: Status of the service. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the service.
    :vartype status_details: str
    :ivar health_state: Describes the health state of an application resource.
     Possible values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :vartype health_state: str or ~azure.servicefabric.models.HealthState
    :ivar unhealthy_evaluation: When the service's health state is not 'Ok',
     this additional details from service fabric Health Manager for the user to
     know why the service is marked unhealthy.
    :vartype unhealthy_evaluation: str
    :param identity_refs: The service identity list.
    :type identity_refs: list[~azure.servicefabric.models.ServiceIdentity]
    """

    _validation = {
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'health_state': {'readonly': True},
        'unhealthy_evaluation': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'auto_scaling_policies': {'key': 'autoScalingPolicies', 'type': '[AutoScalingPolicy]'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'health_state': {'key': 'healthState', 'type': 'str'},
        'unhealthy_evaluation': {'key': 'unhealthyEvaluation', 'type': 'str'},
        'identity_refs': {'key': 'identityRefs', 'type': '[ServiceIdentity]'},
    }

    def __init__(self, **kwargs):
        super(ServiceProperties, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.replica_count = kwargs.get('replica_count', None)
        self.auto_scaling_policies = kwargs.get('auto_scaling_policies', None)
        self.status = None
        self.status_details = None
        self.health_state = None
        self.unhealthy_evaluation = None
        self.identity_refs = kwargs.get('identity_refs', None)


class ServiceReplicaProperties(Model):
    """Describes the properties of a service replica.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. The operation system required by the code in
     service. Possible values include: 'Linux', 'Windows'
    :type os_type: str or ~azure.servicefabric.models.OperatingSystemType
    :param code_packages: Required. Describes the set of code packages that
     forms the service. A code package describes the container and the
     properties for running it. All the code packages are started together on
     the same host and share the same context (network, process etc.).
    :type code_packages:
     list[~azure.servicefabric.models.ContainerCodePackageProperties]
    :param network_refs: The names of the private networks that this service
     needs to be part of.
    :type network_refs: list[~azure.servicefabric.models.NetworkRef]
    :param diagnostics: Reference to sinks in DiagnosticsDescription.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsRef
    """

    _validation = {
        'os_type': {'required': True},
        'code_packages': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'code_packages': {'key': 'codePackages', 'type': '[ContainerCodePackageProperties]'},
        'network_refs': {'key': 'networkRefs', 'type': '[NetworkRef]'},
        'diagnostics': {'key': 'diagnostics', 'type': 'DiagnosticsRef'},
    }

    def __init__(self, **kwargs):
        super(ServiceReplicaProperties, self).__init__(**kwargs)
        self.os_type = kwargs.get('os_type', None)
        self.code_packages = kwargs.get('code_packages', None)
        self.network_refs = kwargs.get('network_refs', None)
        self.diagnostics = kwargs.get('diagnostics', None)


class ServiceReplicaDescription(ServiceReplicaProperties):
    """Describes a replica of a service resource.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. The operation system required by the code in
     service. Possible values include: 'Linux', 'Windows'
    :type os_type: str or ~azure.servicefabric.models.OperatingSystemType
    :param code_packages: Required. Describes the set of code packages that
     forms the service. A code package describes the container and the
     properties for running it. All the code packages are started together on
     the same host and share the same context (network, process etc.).
    :type code_packages:
     list[~azure.servicefabric.models.ContainerCodePackageProperties]
    :param network_refs: The names of the private networks that this service
     needs to be part of.
    :type network_refs: list[~azure.servicefabric.models.NetworkRef]
    :param diagnostics: Reference to sinks in DiagnosticsDescription.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsRef
    :param replica_name: Required. Name of the replica.
    :type replica_name: str
    """

    _validation = {
        'os_type': {'required': True},
        'code_packages': {'required': True},
        'replica_name': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'code_packages': {'key': 'codePackages', 'type': '[ContainerCodePackageProperties]'},
        'network_refs': {'key': 'networkRefs', 'type': '[NetworkRef]'},
        'diagnostics': {'key': 'diagnostics', 'type': 'DiagnosticsRef'},
        'replica_name': {'key': 'replicaName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceReplicaDescription, self).__init__(**kwargs)
        self.replica_name = kwargs.get('replica_name', None)


class ServiceResourceDescription(Model):
    """This type describes a service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Service resource.
    :type name: str
    :param os_type: Required. The operation system required by the code in
     service. Possible values include: 'Linux', 'Windows'
    :type os_type: str or ~azure.servicefabric.models.OperatingSystemType
    :param code_packages: Required. Describes the set of code packages that
     forms the service. A code package describes the container and the
     properties for running it. All the code packages are started together on
     the same host and share the same context (network, process etc.).
    :type code_packages:
     list[~azure.servicefabric.models.ContainerCodePackageProperties]
    :param network_refs: The names of the private networks that this service
     needs to be part of.
    :type network_refs: list[~azure.servicefabric.models.NetworkRef]
    :param diagnostics: Reference to sinks in DiagnosticsDescription.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsRef
    :param description: User readable description of the service.
    :type description: str
    :param replica_count: The number of replicas of the service to create.
     Defaults to 1 if not specified.
    :type replica_count: int
    :param auto_scaling_policies: Auto scaling policies
    :type auto_scaling_policies:
     list[~azure.servicefabric.models.AutoScalingPolicy]
    :ivar status: Status of the service. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the service.
    :vartype status_details: str
    :ivar health_state: Describes the health state of an application resource.
     Possible values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :vartype health_state: str or ~azure.servicefabric.models.HealthState
    :ivar unhealthy_evaluation: When the service's health state is not 'Ok',
     this additional details from service fabric Health Manager for the user to
     know why the service is marked unhealthy.
    :vartype unhealthy_evaluation: str
    :param identity_refs: The service identity list.
    :type identity_refs: list[~azure.servicefabric.models.ServiceIdentity]
    """

    _validation = {
        'name': {'required': True},
        'os_type': {'required': True},
        'code_packages': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'health_state': {'readonly': True},
        'unhealthy_evaluation': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'code_packages': {'key': 'properties.codePackages', 'type': '[ContainerCodePackageProperties]'},
        'network_refs': {'key': 'properties.networkRefs', 'type': '[NetworkRef]'},
        'diagnostics': {'key': 'properties.diagnostics', 'type': 'DiagnosticsRef'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'replica_count': {'key': 'properties.replicaCount', 'type': 'int'},
        'auto_scaling_policies': {'key': 'properties.autoScalingPolicies', 'type': '[AutoScalingPolicy]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'health_state': {'key': 'properties.healthState', 'type': 'str'},
        'unhealthy_evaluation': {'key': 'properties.unhealthyEvaluation', 'type': 'str'},
        'identity_refs': {'key': 'properties.identityRefs', 'type': '[ServiceIdentity]'},
    }

    def __init__(self, **kwargs):
        super(ServiceResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.os_type = kwargs.get('os_type', None)
        self.code_packages = kwargs.get('code_packages', None)
        self.network_refs = kwargs.get('network_refs', None)
        self.diagnostics = kwargs.get('diagnostics', None)
        self.description = kwargs.get('description', None)
        self.replica_count = kwargs.get('replica_count', None)
        self.auto_scaling_policies = kwargs.get('auto_scaling_policies', None)
        self.status = None
        self.status_details = None
        self.health_state = None
        self.unhealthy_evaluation = None
        self.identity_refs = kwargs.get('identity_refs', None)


class ServicesHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for services of a certain service type
    belonging to an application, containing health evaluations for each
    unhealthy service that impacted current aggregated health state. Can be
    returned when evaluating application health and the aggregated health state
    is either Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param service_type_name: Name of the service type of the services.
    :type service_type_name: str
    :param max_percent_unhealthy_services: Maximum allowed percentage of
     unhealthy services from the ServiceTypeHealthPolicy.
    :type max_percent_unhealthy_services: int
    :param total_count: Total number of services of the current service type
     in the application from the health store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     ServiceHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'max_percent_unhealthy_services': {'key': 'MaxPercentUnhealthyServices', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(ServicesHealthEvaluation, self).__init__(**kwargs)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.max_percent_unhealthy_services = kwargs.get('max_percent_unhealthy_services', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'Services'


class ServiceTypeDescription(Model):
    """Describes a service type defined in the service manifest of a provisioned
    application type. The properties the ones defined in the service manifest.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceTypeDescription,
    StatelessServiceTypeDescription

    All required parameters must be populated in order to send to Azure.

    :param is_stateful: Indicates whether the service type is a stateful
     service type or a stateless service type. This property is true if the
     service type is a stateful service type, false otherwise.
    :type is_stateful: bool
    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param placement_constraints: The placement constraint to be used when
     instantiating this service in a Service Fabric cluster.
    :type placement_constraints: str
    :param load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: List of service placement policy
     descriptions.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param extensions: List of service type extensions.
    :type extensions:
     list[~azure.servicefabric.models.ServiceTypeExtensionDescription]
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'is_stateful': {'key': 'IsStateful', 'type': 'bool'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'load_metrics': {'key': 'LoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'extensions': {'key': 'Extensions', 'type': '[ServiceTypeExtensionDescription]'},
        'kind': {'key': 'Kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Stateful': 'StatefulServiceTypeDescription', 'Stateless': 'StatelessServiceTypeDescription'}
    }

    def __init__(self, **kwargs):
        super(ServiceTypeDescription, self).__init__(**kwargs)
        self.is_stateful = kwargs.get('is_stateful', None)
        self.service_type_name = kwargs.get('service_type_name', None)
        self.placement_constraints = kwargs.get('placement_constraints', None)
        self.load_metrics = kwargs.get('load_metrics', None)
        self.service_placement_policies = kwargs.get('service_placement_policies', None)
        self.extensions = kwargs.get('extensions', None)
        self.kind = None


class ServiceTypeExtensionDescription(Model):
    """Describes extension of a service type defined in the service manifest.

    :param key: The name of the extension.
    :type key: str
    :param value: The extension value.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceTypeExtensionDescription, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ServiceTypeHealthPolicy(Model):
    """Represents the health policy used to evaluate the health of services
    belonging to a service type.

    :param max_percent_unhealthy_partitions_per_service: The maximum allowed
     percentage of unhealthy partitions per service. Allowed values are Byte
     values from zero to 100
     The percentage represents the maximum tolerated percentage of partitions
     that can be unhealthy before the service is considered in error.
     If the percentage is respected but there is at least one unhealthy
     partition, the health is evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy
     partitions over the total number of partitions in the service.
     The computation rounds up to tolerate one failure on small numbers of
     partitions. Default percentage is zero. Default value: 0 .
    :type max_percent_unhealthy_partitions_per_service: int
    :param max_percent_unhealthy_replicas_per_partition: The maximum allowed
     percentage of unhealthy replicas per partition. Allowed values are Byte
     values from zero to 100.
     The percentage represents the maximum tolerated percentage of replicas
     that can be unhealthy before the partition is considered in error.
     If the percentage is respected but there is at least one unhealthy
     replica, the health is evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy replicas
     over the total number of replicas in the partition.
     The computation rounds up to tolerate one failure on small numbers of
     replicas. Default percentage is zero. Default value: 0 .
    :type max_percent_unhealthy_replicas_per_partition: int
    :param max_percent_unhealthy_services: The maximum allowed percentage of
     unhealthy services. Allowed values are Byte values from zero to 100.
     The percentage represents the maximum tolerated percentage of services
     that can be unhealthy before the application is considered in error.
     If the percentage is respected but there is at least one unhealthy
     service, the health is evaluated as Warning.
     This is calculated by dividing the number of unhealthy services of the
     specific service type over the total number of services of the specific
     service type.
     The computation rounds up to tolerate one failure on small numbers of
     services. Default percentage is zero. Default value: 0 .
    :type max_percent_unhealthy_services: int
    """

    _attribute_map = {
        'max_percent_unhealthy_partitions_per_service': {'key': 'MaxPercentUnhealthyPartitionsPerService', 'type': 'int'},
        'max_percent_unhealthy_replicas_per_partition': {'key': 'MaxPercentUnhealthyReplicasPerPartition', 'type': 'int'},
        'max_percent_unhealthy_services': {'key': 'MaxPercentUnhealthyServices', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ServiceTypeHealthPolicy, self).__init__(**kwargs)
        self.max_percent_unhealthy_partitions_per_service = kwargs.get('max_percent_unhealthy_partitions_per_service', 0)
        self.max_percent_unhealthy_replicas_per_partition = kwargs.get('max_percent_unhealthy_replicas_per_partition', 0)
        self.max_percent_unhealthy_services = kwargs.get('max_percent_unhealthy_services', 0)


class ServiceTypeHealthPolicyMapItem(Model):
    """Defines an item in ServiceTypeHealthPolicyMap.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key of the service type health policy map item.
     This is the name of the service type.
    :type key: str
    :param value: Required. The value of the service type health policy map
     item. This is the ServiceTypeHealthPolicy for this service type.
    :type value: ~azure.servicefabric.models.ServiceTypeHealthPolicy
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'ServiceTypeHealthPolicy'},
    }

    def __init__(self, **kwargs):
        super(ServiceTypeHealthPolicyMapItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ServiceTypeInfo(Model):
    """Information about a service type that is defined in a service manifest of a
    provisioned application type.

    :param service_type_description: Describes a service type defined in the
     service manifest of a provisioned application type. The properties the
     ones defined in the service manifest.
    :type service_type_description:
     ~azure.servicefabric.models.ServiceTypeDescription
    :param service_manifest_name: The name of the service manifest in which
     this service type is defined.
    :type service_manifest_name: str
    :param service_manifest_version: The version of the service manifest in
     which this service type is defined.
    :type service_manifest_version: str
    :param is_service_group: Indicates whether the service is a service group.
     If it is, the property value is true otherwise false.
    :type is_service_group: bool
    """

    _attribute_map = {
        'service_type_description': {'key': 'ServiceTypeDescription', 'type': 'ServiceTypeDescription'},
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'service_manifest_version': {'key': 'ServiceManifestVersion', 'type': 'str'},
        'is_service_group': {'key': 'IsServiceGroup', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ServiceTypeInfo, self).__init__(**kwargs)
        self.service_type_description = kwargs.get('service_type_description', None)
        self.service_manifest_name = kwargs.get('service_manifest_name', None)
        self.service_manifest_version = kwargs.get('service_manifest_version', None)
        self.is_service_group = kwargs.get('is_service_group', None)


class ServiceTypeManifest(Model):
    """Contains the manifest describing a service type registered as part of an
    application in a Service Fabric cluster.

    :param manifest: The XML manifest as a string.
    :type manifest: str
    """

    _attribute_map = {
        'manifest': {'key': 'Manifest', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceTypeManifest, self).__init__(**kwargs)
        self.manifest = kwargs.get('manifest', None)


class ServiceUpdateDescription(Model):
    """A ServiceUpdateDescription contains all of the information necessary to
    update a service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceUpdateDescription,
    StatelessServiceUpdateDescription

    All required parameters must be populated in order to send to Azure.

    :param flags: Flags indicating whether other properties are set. Each of
     the associated properties corresponds to a flag, specified below, which,
     if set, indicate that the property is specified.
     This property can be a combination of those flags obtained using bitwise
     'OR' operator.
     For example, if the provided value is 6 then the flags for
     ReplicaRestartWaitDuration (2) and QuorumLossWaitDuration (4) are set.
     - None - Does not indicate any other properties are set. The value is
     zero.
     - TargetReplicaSetSize/InstanceCount - Indicates whether the
     TargetReplicaSetSize property (for Stateful services) or the InstanceCount
     property (for Stateless services) is set. The value is 1.
     - ReplicaRestartWaitDuration - Indicates the ReplicaRestartWaitDuration
     property is set. The value is  2.
     - QuorumLossWaitDuration - Indicates the QuorumLossWaitDuration property
     is set. The value is 4.
     - StandByReplicaKeepDuration - Indicates the StandByReplicaKeepDuration
     property is set. The value is 8.
     - MinReplicaSetSize - Indicates the MinReplicaSetSize property is set. The
     value is 16.
     - PlacementConstraints - Indicates the PlacementConstraints property is
     set. The value is 32.
     - PlacementPolicyList - Indicates the ServicePlacementPolicies property is
     set. The value is 64.
     - Correlation - Indicates the CorrelationScheme property is set. The value
     is 128.
     - Metrics - Indicates the ServiceLoadMetrics property is set. The value is
     256.
     - DefaultMoveCost - Indicates the DefaultMoveCost property is set. The
     value is 512.
     - ScalingPolicy - Indicates the ScalingPolicies property is set. The value
     is 1024.
    :type flags: str
    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: The correlation scheme.
    :type correlation_scheme:
     list[~azure.servicefabric.models.ServiceCorrelationDescription]
    :param load_metrics: The service load metrics.
    :type load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: The service placement policies.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: The move cost for the service. Possible values
     include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.servicefabric.models.MoveCost
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~azure.servicefabric.models.ScalingPolicyDescription]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'flags': {'key': 'Flags', 'type': 'str'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'CorrelationScheme', 'type': '[ServiceCorrelationDescription]'},
        'load_metrics': {'key': 'LoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'DefaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'ScalingPolicies', 'type': '[ScalingPolicyDescription]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceUpdateDescription', 'Stateless': 'StatelessServiceUpdateDescription'}
    }

    def __init__(self, **kwargs):
        super(ServiceUpdateDescription, self).__init__(**kwargs)
        self.flags = kwargs.get('flags', None)
        self.placement_constraints = kwargs.get('placement_constraints', None)
        self.correlation_scheme = kwargs.get('correlation_scheme', None)
        self.load_metrics = kwargs.get('load_metrics', None)
        self.service_placement_policies = kwargs.get('service_placement_policies', None)
        self.default_move_cost = kwargs.get('default_move_cost', None)
        self.scaling_policies = kwargs.get('scaling_policies', None)
        self.service_kind = None


class Setting(Model):
    """Describes a setting for the container. The setting file path can be fetched
    from environment variable "Fabric_SettingPath". The path for Windows
    container is "C:\\secrets". The path for Linux container is "/var/secrets".

    :param name: The name of the setting.
    :type name: str
    :param value: The value of the setting.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Setting, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class SingletonPartitionInformation(PartitionInformation):
    """Information about a partition that is singleton. The services with
    singleton partitioning scheme are effectively non-partitioned. They only
    have one partition.

    All required parameters must be populated in order to send to Azure.

    :param id: An internal ID used by Service Fabric to uniquely identify a
     partition. This is a randomly generated GUID when the service was created.
     The partition ID is unique and does not change for the lifetime of the
     service. If the same service was deleted and recreated the IDs of its
     partitions would be different.
    :type id: str
    :param service_partition_kind: Required. Constant filled by server.
    :type service_partition_kind: str
    """

    _validation = {
        'service_partition_kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'service_partition_kind': {'key': 'ServicePartitionKind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SingletonPartitionInformation, self).__init__(**kwargs)
        self.service_partition_kind = 'Singleton'


class SingletonPartitionSchemeDescription(PartitionSchemeDescription):
    """Describes the partition scheme of a singleton-partitioned, or
    non-partitioned service.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Constant filled by server.
    :type partition_scheme: str
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'PartitionScheme', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SingletonPartitionSchemeDescription, self).__init__(**kwargs)
        self.partition_scheme = 'Singleton'


class StartClusterUpgradeDescription(Model):
    """Describes the parameters for starting a cluster upgrade.

    :param code_version: The cluster code version.
    :type code_version: str
    :param config_version: The cluster configuration version.
    :type config_version: str
    :param upgrade_kind: The kind of upgrade out of the following possible
     values. Possible values include: 'Invalid', 'Rolling'. Default value:
     "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeKind
    :param rolling_upgrade_mode: The mode used to monitor health during a
     rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and
     Monitored. Possible values include: 'Invalid', 'UnmonitoredAuto',
     'UnmonitoredManual', 'Monitored'. Default value: "UnmonitoredAuto" .
    :type rolling_upgrade_mode: str or ~azure.servicefabric.models.UpgradeMode
    :param upgrade_replica_set_check_timeout_in_seconds: The maximum amount of
     time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires,
     processing of the upgrade domain will proceed regardless of availability
     loss issues. The timeout is reset at the start of each upgrade domain.
     Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit
     integer).
    :type upgrade_replica_set_check_timeout_in_seconds: long
    :param force_restart: If true, then processes are forcefully restarted
     during upgrade even when the code version has not changed (the upgrade
     only changes configuration or data).
    :type force_restart: bool
    :param sort_order: Defines the order in which an upgrade proceeds through
     the cluster. Possible values include: 'Invalid', 'Default', 'Numeric',
     'Lexicographical', 'ReverseNumeric', 'ReverseLexicographical'. Default
     value: "Default" .
    :type sort_order: str or ~azure.servicefabric.models.UpgradeSortOrder
    :param monitoring_policy: Describes the parameters for monitoring an
     upgrade in Monitored mode.
    :type monitoring_policy:
     ~azure.servicefabric.models.MonitoringPolicyDescription
    :param cluster_health_policy: Defines a health policy used to evaluate the
     health of the cluster or of a cluster node.
    :type cluster_health_policy:
     ~azure.servicefabric.models.ClusterHealthPolicy
    :param enable_delta_health_evaluation: When true, enables delta health
     evaluation rather than absolute health evaluation after completion of each
     upgrade domain.
    :type enable_delta_health_evaluation: bool
    :param cluster_upgrade_health_policy: Defines a health policy used to
     evaluate the health of the cluster during a cluster upgrade.
    :type cluster_upgrade_health_policy:
     ~azure.servicefabric.models.ClusterUpgradeHealthPolicyObject
    :param application_health_policy_map: Defines the application health
     policy map used to evaluate the health of an application or one of its
     children entities.
    :type application_health_policy_map:
     ~azure.servicefabric.models.ApplicationHealthPolicies
    """

    _attribute_map = {
        'code_version': {'key': 'CodeVersion', 'type': 'str'},
        'config_version': {'key': 'ConfigVersion', 'type': 'str'},
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'rolling_upgrade_mode': {'key': 'RollingUpgradeMode', 'type': 'str'},
        'upgrade_replica_set_check_timeout_in_seconds': {'key': 'UpgradeReplicaSetCheckTimeoutInSeconds', 'type': 'long'},
        'force_restart': {'key': 'ForceRestart', 'type': 'bool'},
        'sort_order': {'key': 'SortOrder', 'type': 'str'},
        'monitoring_policy': {'key': 'MonitoringPolicy', 'type': 'MonitoringPolicyDescription'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'ClusterHealthPolicy'},
        'enable_delta_health_evaluation': {'key': 'EnableDeltaHealthEvaluation', 'type': 'bool'},
        'cluster_upgrade_health_policy': {'key': 'ClusterUpgradeHealthPolicy', 'type': 'ClusterUpgradeHealthPolicyObject'},
        'application_health_policy_map': {'key': 'ApplicationHealthPolicyMap', 'type': 'ApplicationHealthPolicies'},
    }

    def __init__(self, **kwargs):
        super(StartClusterUpgradeDescription, self).__init__(**kwargs)
        self.code_version = kwargs.get('code_version', None)
        self.config_version = kwargs.get('config_version', None)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.rolling_upgrade_mode = kwargs.get('rolling_upgrade_mode', "UnmonitoredAuto")
        self.upgrade_replica_set_check_timeout_in_seconds = kwargs.get('upgrade_replica_set_check_timeout_in_seconds', None)
        self.force_restart = kwargs.get('force_restart', None)
        self.sort_order = kwargs.get('sort_order', "Default")
        self.monitoring_policy = kwargs.get('monitoring_policy', None)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)
        self.enable_delta_health_evaluation = kwargs.get('enable_delta_health_evaluation', None)
        self.cluster_upgrade_health_policy = kwargs.get('cluster_upgrade_health_policy', None)
        self.application_health_policy_map = kwargs.get('application_health_policy_map', None)


class StartedChaosEvent(ChaosEvent):
    """Describes a Chaos event that gets generated when Chaos is started.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp_utc: Required. The UTC timestamp when this Chaos event
     was generated.
    :type time_stamp_utc: datetime
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param chaos_parameters: Defines all the parameters to configure a Chaos
     run.
    :type chaos_parameters: ~azure.servicefabric.models.ChaosParameters
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'chaos_parameters': {'key': 'ChaosParameters', 'type': 'ChaosParameters'},
    }

    def __init__(self, **kwargs):
        super(StartedChaosEvent, self).__init__(**kwargs)
        self.chaos_parameters = kwargs.get('chaos_parameters', None)
        self.kind = 'Started'


class StatefulReplicaHealthReportExpiredEvent(ReplicaEvent):
    """Stateful Replica Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param replica_id: Required. Id of a stateful service replica. ReplicaId
     is used by Service Fabric to uniquely identify a replica of a partition.
     It is unique within a partition and does not change for the lifetime of
     the replica. If a replica gets dropped and another replica gets created on
     the same node for the same partition, it will get a different value for
     the id. Sometimes the id of a stateless service instance is also referred
     as a replica id.
    :type replica_id: long
    :param replica_instance_id: Required. Id of Replica instance.
    :type replica_instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'replica_id': {'required': True},
        'replica_instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'long'},
        'replica_instance_id': {'key': 'ReplicaInstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(StatefulReplicaHealthReportExpiredEvent, self).__init__(**kwargs)
        self.replica_instance_id = kwargs.get('replica_instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'StatefulReplicaHealthReportExpired'


class StatefulReplicaNewHealthReportEvent(ReplicaEvent):
    """Stateful Replica Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param replica_id: Required. Id of a stateful service replica. ReplicaId
     is used by Service Fabric to uniquely identify a replica of a partition.
     It is unique within a partition and does not change for the lifetime of
     the replica. If a replica gets dropped and another replica gets created on
     the same node for the same partition, it will get a different value for
     the id. Sometimes the id of a stateless service instance is also referred
     as a replica id.
    :type replica_id: long
    :param replica_instance_id: Required. Id of Replica instance.
    :type replica_instance_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'replica_id': {'required': True},
        'replica_instance_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'long'},
        'replica_instance_id': {'key': 'ReplicaInstanceId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(StatefulReplicaNewHealthReportEvent, self).__init__(**kwargs)
        self.replica_instance_id = kwargs.get('replica_instance_id', None)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'StatefulReplicaNewHealthReport'


class StatefulServiceDescription(ServiceDescription):
    """Describes a stateful service.

    All required parameters must be populated in order to send to Azure.

    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param service_name: Required. The full name of the service with 'fabric:'
     URI scheme.
    :type service_name: str
    :param service_type_name: Required. Name of the service type as specified
     in the service manifest.
    :type service_type_name: str
    :param initialization_data: The initialization data as an array of bytes.
     Initialization data is passed to service instances or replicas when they
     are created.
    :type initialization_data: list[int]
    :param partition_description: Required. The partition description as an
     object.
    :type partition_description:
     ~azure.servicefabric.models.PartitionSchemeDescription
    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: The correlation scheme.
    :type correlation_scheme:
     list[~azure.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics.
    :type service_load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: The service placement policies.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: The move cost for the service. Possible values
     include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.servicefabric.models.MoveCost
    :param is_default_move_cost_specified: Indicates if the DefaultMoveCost
     property is specified.
    :type is_default_move_cost_specified: bool
    :param service_package_activation_mode: The activation mode of service
     package to be used for a service. Possible values include:
     'SharedProcess', 'ExclusiveProcess'
    :type service_package_activation_mode: str or
     ~azure.servicefabric.models.ServicePackageActivationMode
    :param service_dns_name: The DNS name of the service. It requires the DNS
     system service to be enabled in Service Fabric cluster.
    :type service_dns_name: str
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~azure.servicefabric.models.ScalingPolicyDescription]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param target_replica_set_size: Required. The target replica set size as a
     number.
    :type target_replica_set_size: int
    :param min_replica_set_size: Required. The minimum replica set size as a
     number.
    :type min_replica_set_size: int
    :param has_persisted_state: Required. A flag indicating whether this is a
     persistent service which stores states on the local disk. If it is then
     the value of this property is true, if not it is false.
    :type has_persisted_state: bool
    :param flags: Flags indicating whether other properties are set. Each of
     the associated properties corresponds to a flag, specified below, which,
     if set, indicate that the property is specified.
     This property can be a combination of those flags obtained using bitwise
     'OR' operator.
     For example, if the provided value is 6 then the flags for
     QuorumLossWaitDuration (2) and StandByReplicaKeepDuration(4) are set.
     - None - Does not indicate any other properties are set. The value is
     zero.
     - ReplicaRestartWaitDuration - Indicates the ReplicaRestartWaitDuration
     property is set. The value is 1.
     - QuorumLossWaitDuration - Indicates the QuorumLossWaitDuration property
     is set. The value is 2.
     - StandByReplicaKeepDuration - Indicates the StandByReplicaKeepDuration
     property is set. The value is 4.
    :type flags: int
    :param replica_restart_wait_duration_seconds: The duration, in seconds,
     between when a replica goes down and when a new replica is created.
    :type replica_restart_wait_duration_seconds: long
    :param quorum_loss_wait_duration_seconds: The maximum duration, in
     seconds, for which a partition is allowed to be in a state of quorum loss.
    :type quorum_loss_wait_duration_seconds: long
    :param stand_by_replica_keep_duration_seconds: The definition on how long
     StandBy replicas should be maintained before being removed.
    :type stand_by_replica_keep_duration_seconds: long
    """

    _validation = {
        'service_name': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
        'service_kind': {'required': True},
        'target_replica_set_size': {'required': True, 'minimum': 1},
        'min_replica_set_size': {'required': True, 'minimum': 1},
        'has_persisted_state': {'required': True},
        'replica_restart_wait_duration_seconds': {'maximum': 4294967295, 'minimum': 0},
        'quorum_loss_wait_duration_seconds': {'maximum': 4294967295, 'minimum': 0},
        'stand_by_replica_keep_duration_seconds': {'maximum': 4294967295, 'minimum': 0},
    }

    _attribute_map = {
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'initialization_data': {'key': 'InitializationData', 'type': '[int]'},
        'partition_description': {'key': 'PartitionDescription', 'type': 'PartitionSchemeDescription'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'CorrelationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'ServiceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'DefaultMoveCost', 'type': 'str'},
        'is_default_move_cost_specified': {'key': 'IsDefaultMoveCostSpecified', 'type': 'bool'},
        'service_package_activation_mode': {'key': 'ServicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'ServiceDnsName', 'type': 'str'},
        'scaling_policies': {'key': 'ScalingPolicies', 'type': '[ScalingPolicyDescription]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'target_replica_set_size': {'key': 'TargetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'MinReplicaSetSize', 'type': 'int'},
        'has_persisted_state': {'key': 'HasPersistedState', 'type': 'bool'},
        'flags': {'key': 'Flags', 'type': 'int'},
        'replica_restart_wait_duration_seconds': {'key': 'ReplicaRestartWaitDurationSeconds', 'type': 'long'},
        'quorum_loss_wait_duration_seconds': {'key': 'QuorumLossWaitDurationSeconds', 'type': 'long'},
        'stand_by_replica_keep_duration_seconds': {'key': 'StandByReplicaKeepDurationSeconds', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(StatefulServiceDescription, self).__init__(**kwargs)
        self.target_replica_set_size = kwargs.get('target_replica_set_size', None)
        self.min_replica_set_size = kwargs.get('min_replica_set_size', None)
        self.has_persisted_state = kwargs.get('has_persisted_state', None)
        self.flags = kwargs.get('flags', None)
        self.replica_restart_wait_duration_seconds = kwargs.get('replica_restart_wait_duration_seconds', None)
        self.quorum_loss_wait_duration_seconds = kwargs.get('quorum_loss_wait_duration_seconds', None)
        self.stand_by_replica_keep_duration_seconds = kwargs.get('stand_by_replica_keep_duration_seconds', None)
        self.service_kind = 'Stateful'


class StatefulServiceInfo(ServiceInfo):
    """Information about a stateful Service Fabric service.

    All required parameters must be populated in order to send to Azure.

    :param id: The identity of the service. This ID is an encoded
     representation of the service name. This is used in the REST APIs to
     identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type id: str
    :param name: The full name of the service with 'fabric:' URI scheme.
    :type name: str
    :param type_name: Name of the service type as specified in the service
     manifest.
    :type type_name: str
    :param manifest_version: The version of the service manifest.
    :type manifest_version: str
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param service_status: The status of the application. Possible values
     include: 'Unknown', 'Active', 'Upgrading', 'Deleting', 'Creating',
     'Failed'
    :type service_status: str or ~azure.servicefabric.models.ServiceStatus
    :param is_service_group: Whether the service is in a service group.
    :type is_service_group: bool
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param has_persisted_state: Whether the service has persisted state.
    :type has_persisted_state: bool
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'manifest_version': {'key': 'ManifestVersion', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'service_status': {'key': 'ServiceStatus', 'type': 'str'},
        'is_service_group': {'key': 'IsServiceGroup', 'type': 'bool'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'has_persisted_state': {'key': 'HasPersistedState', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(StatefulServiceInfo, self).__init__(**kwargs)
        self.has_persisted_state = kwargs.get('has_persisted_state', None)
        self.service_kind = 'Stateful'


class StatefulServicePartitionInfo(ServicePartitionInfo):
    """Information about a partition of a stateful Service Fabric service..

    All required parameters must be populated in order to send to Azure.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param partition_status: The status of the service fabric service
     partition. Possible values include: 'Invalid', 'Ready', 'NotReady',
     'InQuorumLoss', 'Reconfiguring', 'Deleting'
    :type partition_status: str or
     ~azure.servicefabric.models.ServicePartitionStatus
    :param partition_information: Information about the partition identity,
     partitioning scheme and keys supported by it.
    :type partition_information:
     ~azure.servicefabric.models.PartitionInformation
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param target_replica_set_size: The target replica set size as a number.
    :type target_replica_set_size: long
    :param min_replica_set_size: The minimum replica set size as a number.
    :type min_replica_set_size: long
    :param last_quorum_loss_duration: The duration for which this partition
     was in quorum loss. If the partition is currently in quorum loss, it
     returns the duration since it has been in that state. This field is using
     ISO8601 format for specifying the duration.
    :type last_quorum_loss_duration: timedelta
    :param primary_epoch: An Epoch is a configuration number for the partition
     as a whole. When the configuration of the replica set changes, for example
     when the Primary replica changes, the operations that are replicated from
     the new Primary replica are said to be a new Epoch from the ones which
     were sent by the old Primary replica.
    :type primary_epoch: ~azure.servicefabric.models.Epoch
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'partition_status': {'key': 'PartitionStatus', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'target_replica_set_size': {'key': 'TargetReplicaSetSize', 'type': 'long'},
        'min_replica_set_size': {'key': 'MinReplicaSetSize', 'type': 'long'},
        'last_quorum_loss_duration': {'key': 'LastQuorumLossDuration', 'type': 'duration'},
        'primary_epoch': {'key': 'PrimaryEpoch', 'type': 'Epoch'},
    }

    def __init__(self, **kwargs):
        super(StatefulServicePartitionInfo, self).__init__(**kwargs)
        self.target_replica_set_size = kwargs.get('target_replica_set_size', None)
        self.min_replica_set_size = kwargs.get('min_replica_set_size', None)
        self.last_quorum_loss_duration = kwargs.get('last_quorum_loss_duration', None)
        self.primary_epoch = kwargs.get('primary_epoch', None)
        self.service_kind = 'Stateful'


class StatefulServiceReplicaHealth(ReplicaHealth):
    """Represents the health of the stateful service replica.
    Contains the replica aggregated health state, the health events and the
    unhealthy evaluations.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param partition_id: Id of the partition to which this replica belongs.
    :type partition_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param replica_id: Id of a stateful service replica. ReplicaId is used by
     Service Fabric to uniquely identify a replica of a partition. It is unique
     within a partition and does not change for the lifetime of the replica. If
     a replica gets dropped and another replica gets created on the same node
     for the same partition, it will get a different value for the id.
     Sometimes the id of a stateless service instance is also referred as a
     replica id.
    :type replica_id: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatefulServiceReplicaHealth, self).__init__(**kwargs)
        self.replica_id = kwargs.get('replica_id', None)
        self.service_kind = 'Stateful'


class StatefulServiceReplicaHealthState(ReplicaHealthState):
    """Represents the health state of the stateful service replica, which contains
    the replica ID and the aggregated health state.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param partition_id: The ID of the partition to which this replica
     belongs.
    :type partition_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param replica_id: Id of a stateful service replica. ReplicaId is used by
     Service Fabric to uniquely identify a replica of a partition. It is unique
     within a partition and does not change for the lifetime of the replica. If
     a replica gets dropped and another replica gets created on the same node
     for the same partition, it will get a different value for the id.
     Sometimes the id of a stateless service instance is also referred as a
     replica id.
    :type replica_id: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatefulServiceReplicaHealthState, self).__init__(**kwargs)
        self.replica_id = kwargs.get('replica_id', None)
        self.service_kind = 'Stateful'


class StatefulServiceReplicaInfo(ReplicaInfo):
    """Represents a stateful service replica. This includes information about the
    identity, role, status, health, node name, uptime, and other details about
    the replica.

    All required parameters must be populated in order to send to Azure.

    :param replica_status: The status of a replica of a service. Possible
     values include: 'Invalid', 'InBuild', 'Standby', 'Ready', 'Down',
     'Dropped'
    :type replica_status: str or ~azure.servicefabric.models.ReplicaStatus
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    :param address: The address the replica is listening on.
    :type address: str
    :param last_in_build_duration_in_seconds: The last in build duration of
     the replica in seconds.
    :type last_in_build_duration_in_seconds: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param replica_role: The role of a replica of a stateful service. Possible
     values include: 'Unknown', 'None', 'Primary', 'IdleSecondary',
     'ActiveSecondary'
    :type replica_role: str or ~azure.servicefabric.models.ReplicaRole
    :param replica_id: Id of a stateful service replica. ReplicaId is used by
     Service Fabric to uniquely identify a replica of a partition. It is unique
     within a partition and does not change for the lifetime of the replica. If
     a replica gets dropped and another replica gets created on the same node
     for the same partition, it will get a different value for the id.
     Sometimes the id of a stateless service instance is also referred as a
     replica id.
    :type replica_id: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'last_in_build_duration_in_seconds': {'key': 'LastInBuildDurationInSeconds', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'replica_role': {'key': 'ReplicaRole', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatefulServiceReplicaInfo, self).__init__(**kwargs)
        self.replica_role = kwargs.get('replica_role', None)
        self.replica_id = kwargs.get('replica_id', None)
        self.service_kind = 'Stateful'


class StatefulServiceTypeDescription(ServiceTypeDescription):
    """Describes a stateful service type defined in the service manifest of a
    provisioned application type.

    All required parameters must be populated in order to send to Azure.

    :param is_stateful: Indicates whether the service type is a stateful
     service type or a stateless service type. This property is true if the
     service type is a stateful service type, false otherwise.
    :type is_stateful: bool
    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param placement_constraints: The placement constraint to be used when
     instantiating this service in a Service Fabric cluster.
    :type placement_constraints: str
    :param load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: List of service placement policy
     descriptions.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param extensions: List of service type extensions.
    :type extensions:
     list[~azure.servicefabric.models.ServiceTypeExtensionDescription]
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param has_persisted_state: A flag indicating whether this is a persistent
     service which stores states on the local disk. If it is then the value of
     this property is true, if not it is false.
    :type has_persisted_state: bool
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'is_stateful': {'key': 'IsStateful', 'type': 'bool'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'load_metrics': {'key': 'LoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'extensions': {'key': 'Extensions', 'type': '[ServiceTypeExtensionDescription]'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'has_persisted_state': {'key': 'HasPersistedState', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(StatefulServiceTypeDescription, self).__init__(**kwargs)
        self.has_persisted_state = kwargs.get('has_persisted_state', None)
        self.kind = 'Stateful'


class StatefulServiceUpdateDescription(ServiceUpdateDescription):
    """Describes an update for a stateful service.

    All required parameters must be populated in order to send to Azure.

    :param flags: Flags indicating whether other properties are set. Each of
     the associated properties corresponds to a flag, specified below, which,
     if set, indicate that the property is specified.
     This property can be a combination of those flags obtained using bitwise
     'OR' operator.
     For example, if the provided value is 6 then the flags for
     ReplicaRestartWaitDuration (2) and QuorumLossWaitDuration (4) are set.
     - None - Does not indicate any other properties are set. The value is
     zero.
     - TargetReplicaSetSize/InstanceCount - Indicates whether the
     TargetReplicaSetSize property (for Stateful services) or the InstanceCount
     property (for Stateless services) is set. The value is 1.
     - ReplicaRestartWaitDuration - Indicates the ReplicaRestartWaitDuration
     property is set. The value is  2.
     - QuorumLossWaitDuration - Indicates the QuorumLossWaitDuration property
     is set. The value is 4.
     - StandByReplicaKeepDuration - Indicates the StandByReplicaKeepDuration
     property is set. The value is 8.
     - MinReplicaSetSize - Indicates the MinReplicaSetSize property is set. The
     value is 16.
     - PlacementConstraints - Indicates the PlacementConstraints property is
     set. The value is 32.
     - PlacementPolicyList - Indicates the ServicePlacementPolicies property is
     set. The value is 64.
     - Correlation - Indicates the CorrelationScheme property is set. The value
     is 128.
     - Metrics - Indicates the ServiceLoadMetrics property is set. The value is
     256.
     - DefaultMoveCost - Indicates the DefaultMoveCost property is set. The
     value is 512.
     - ScalingPolicy - Indicates the ScalingPolicies property is set. The value
     is 1024.
    :type flags: str
    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: The correlation scheme.
    :type correlation_scheme:
     list[~azure.servicefabric.models.ServiceCorrelationDescription]
    :param load_metrics: The service load metrics.
    :type load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: The service placement policies.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: The move cost for the service. Possible values
     include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.servicefabric.models.MoveCost
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~azure.servicefabric.models.ScalingPolicyDescription]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param target_replica_set_size: The target replica set size as a number.
    :type target_replica_set_size: int
    :param min_replica_set_size: The minimum replica set size as a number.
    :type min_replica_set_size: int
    :param replica_restart_wait_duration_seconds: The duration, in seconds,
     between when a replica goes down and when a new replica is created.
    :type replica_restart_wait_duration_seconds: str
    :param quorum_loss_wait_duration_seconds: The maximum duration, in
     seconds, for which a partition is allowed to be in a state of quorum loss.
    :type quorum_loss_wait_duration_seconds: str
    :param stand_by_replica_keep_duration_seconds: The definition on how long
     StandBy replicas should be maintained before being removed.
    :type stand_by_replica_keep_duration_seconds: str
    """

    _validation = {
        'service_kind': {'required': True},
        'target_replica_set_size': {'minimum': 1},
        'min_replica_set_size': {'minimum': 1},
    }

    _attribute_map = {
        'flags': {'key': 'Flags', 'type': 'str'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'CorrelationScheme', 'type': '[ServiceCorrelationDescription]'},
        'load_metrics': {'key': 'LoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'DefaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'ScalingPolicies', 'type': '[ScalingPolicyDescription]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'target_replica_set_size': {'key': 'TargetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'MinReplicaSetSize', 'type': 'int'},
        'replica_restart_wait_duration_seconds': {'key': 'ReplicaRestartWaitDurationSeconds', 'type': 'str'},
        'quorum_loss_wait_duration_seconds': {'key': 'QuorumLossWaitDurationSeconds', 'type': 'str'},
        'stand_by_replica_keep_duration_seconds': {'key': 'StandByReplicaKeepDurationSeconds', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatefulServiceUpdateDescription, self).__init__(**kwargs)
        self.target_replica_set_size = kwargs.get('target_replica_set_size', None)
        self.min_replica_set_size = kwargs.get('min_replica_set_size', None)
        self.replica_restart_wait_duration_seconds = kwargs.get('replica_restart_wait_duration_seconds', None)
        self.quorum_loss_wait_duration_seconds = kwargs.get('quorum_loss_wait_duration_seconds', None)
        self.stand_by_replica_keep_duration_seconds = kwargs.get('stand_by_replica_keep_duration_seconds', None)
        self.service_kind = 'Stateful'


class StatelessReplicaHealthReportExpiredEvent(ReplicaEvent):
    """Stateless Replica Health Report Expired event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param replica_id: Required. Id of a stateful service replica. ReplicaId
     is used by Service Fabric to uniquely identify a replica of a partition.
     It is unique within a partition and does not change for the lifetime of
     the replica. If a replica gets dropped and another replica gets created on
     the same node for the same partition, it will get a different value for
     the id. Sometimes the id of a stateless service instance is also referred
     as a replica id.
    :type replica_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'replica_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(StatelessReplicaHealthReportExpiredEvent, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'StatelessReplicaHealthReportExpired'


class StatelessReplicaNewHealthReportEvent(ReplicaEvent):
    """Stateless Replica Health Report Created event.

    All required parameters must be populated in order to send to Azure.

    :param event_instance_id: Required. The identifier for the FabricEvent
     instance.
    :type event_instance_id: str
    :param category: The category of event.
    :type category: str
    :param time_stamp: Required. The time event was logged.
    :type time_stamp: datetime
    :param has_correlated_events: Shows there is existing related events
     available.
    :type has_correlated_events: bool
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Required. An internal ID used by Service Fabric to
     uniquely identify a partition. This is a randomly generated GUID when the
     service was created. The partition ID is unique and does not change for
     the lifetime of the service. If the same service was deleted and recreated
     the IDs of its partitions would be different.
    :type partition_id: str
    :param replica_id: Required. Id of a stateful service replica. ReplicaId
     is used by Service Fabric to uniquely identify a replica of a partition.
     It is unique within a partition and does not change for the lifetime of
     the replica. If a replica gets dropped and another replica gets created on
     the same node for the same partition, it will get a different value for
     the id. Sometimes the id of a stateless service instance is also referred
     as a replica id.
    :type replica_id: long
    :param source_id: Required. Id of report source.
    :type source_id: str
    :param property: Required. Describes the property.
    :type property: str
    :param health_state: Required. Describes the property health state.
    :type health_state: str
    :param time_to_live_ms: Required. Time to live in milli-seconds.
    :type time_to_live_ms: long
    :param sequence_number: Required. Sequence number of report.
    :type sequence_number: long
    :param description: Required. Description of report.
    :type description: str
    :param remove_when_expired: Required. Indicates the removal when it
     expires.
    :type remove_when_expired: bool
    :param source_utc_timestamp: Required. Source time.
    :type source_utc_timestamp: datetime
    """

    _validation = {
        'event_instance_id': {'required': True},
        'time_stamp': {'required': True},
        'kind': {'required': True},
        'partition_id': {'required': True},
        'replica_id': {'required': True},
        'source_id': {'required': True},
        'property': {'required': True},
        'health_state': {'required': True},
        'time_to_live_ms': {'required': True},
        'sequence_number': {'required': True},
        'description': {'required': True},
        'remove_when_expired': {'required': True},
        'source_utc_timestamp': {'required': True},
    }

    _attribute_map = {
        'event_instance_id': {'key': 'EventInstanceId', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'time_stamp': {'key': 'TimeStamp', 'type': 'iso-8601'},
        'has_correlated_events': {'key': 'HasCorrelatedEvents', 'type': 'bool'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'long'},
        'source_id': {'key': 'SourceId', 'type': 'str'},
        'property': {'key': 'Property', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'time_to_live_ms': {'key': 'TimeToLiveMs', 'type': 'long'},
        'sequence_number': {'key': 'SequenceNumber', 'type': 'long'},
        'description': {'key': 'Description', 'type': 'str'},
        'remove_when_expired': {'key': 'RemoveWhenExpired', 'type': 'bool'},
        'source_utc_timestamp': {'key': 'SourceUtcTimestamp', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(StatelessReplicaNewHealthReportEvent, self).__init__(**kwargs)
        self.source_id = kwargs.get('source_id', None)
        self.property = kwargs.get('property', None)
        self.health_state = kwargs.get('health_state', None)
        self.time_to_live_ms = kwargs.get('time_to_live_ms', None)
        self.sequence_number = kwargs.get('sequence_number', None)
        self.description = kwargs.get('description', None)
        self.remove_when_expired = kwargs.get('remove_when_expired', None)
        self.source_utc_timestamp = kwargs.get('source_utc_timestamp', None)
        self.kind = 'StatelessReplicaNewHealthReport'


class StatelessServiceDescription(ServiceDescription):
    """Describes a stateless service.

    All required parameters must be populated in order to send to Azure.

    :param application_name: The name of the application, including the
     'fabric:' URI scheme.
    :type application_name: str
    :param service_name: Required. The full name of the service with 'fabric:'
     URI scheme.
    :type service_name: str
    :param service_type_name: Required. Name of the service type as specified
     in the service manifest.
    :type service_type_name: str
    :param initialization_data: The initialization data as an array of bytes.
     Initialization data is passed to service instances or replicas when they
     are created.
    :type initialization_data: list[int]
    :param partition_description: Required. The partition description as an
     object.
    :type partition_description:
     ~azure.servicefabric.models.PartitionSchemeDescription
    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: The correlation scheme.
    :type correlation_scheme:
     list[~azure.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics.
    :type service_load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: The service placement policies.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: The move cost for the service. Possible values
     include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.servicefabric.models.MoveCost
    :param is_default_move_cost_specified: Indicates if the DefaultMoveCost
     property is specified.
    :type is_default_move_cost_specified: bool
    :param service_package_activation_mode: The activation mode of service
     package to be used for a service. Possible values include:
     'SharedProcess', 'ExclusiveProcess'
    :type service_package_activation_mode: str or
     ~azure.servicefabric.models.ServicePackageActivationMode
    :param service_dns_name: The DNS name of the service. It requires the DNS
     system service to be enabled in Service Fabric cluster.
    :type service_dns_name: str
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~azure.servicefabric.models.ScalingPolicyDescription]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param instance_count: Required. The instance count.
    :type instance_count: int
    """

    _validation = {
        'service_name': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
        'service_kind': {'required': True},
        'instance_count': {'required': True, 'minimum': -1},
    }

    _attribute_map = {
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'initialization_data': {'key': 'InitializationData', 'type': '[int]'},
        'partition_description': {'key': 'PartitionDescription', 'type': 'PartitionSchemeDescription'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'CorrelationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'ServiceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'DefaultMoveCost', 'type': 'str'},
        'is_default_move_cost_specified': {'key': 'IsDefaultMoveCostSpecified', 'type': 'bool'},
        'service_package_activation_mode': {'key': 'ServicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'ServiceDnsName', 'type': 'str'},
        'scaling_policies': {'key': 'ScalingPolicies', 'type': '[ScalingPolicyDescription]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_count': {'key': 'InstanceCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(StatelessServiceDescription, self).__init__(**kwargs)
        self.instance_count = kwargs.get('instance_count', None)
        self.service_kind = 'Stateless'


class StatelessServiceInfo(ServiceInfo):
    """Information about a stateless Service Fabric service.

    All required parameters must be populated in order to send to Azure.

    :param id: The identity of the service. This ID is an encoded
     representation of the service name. This is used in the REST APIs to
     identify the service resource.
     Starting in version 6.0, hierarchical names are delimited with the "\\~"
     character. For example, if the service name is "fabric:/myapp/app1/svc1",
     the service identity would be "myapp~app1\\~svc1" in 6.0+ and
     "myapp/app1/svc1" in previous versions.
    :type id: str
    :param name: The full name of the service with 'fabric:' URI scheme.
    :type name: str
    :param type_name: Name of the service type as specified in the service
     manifest.
    :type type_name: str
    :param manifest_version: The version of the service manifest.
    :type manifest_version: str
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param service_status: The status of the application. Possible values
     include: 'Unknown', 'Active', 'Upgrading', 'Deleting', 'Creating',
     'Failed'
    :type service_status: str or ~azure.servicefabric.models.ServiceStatus
    :param is_service_group: Whether the service is in a service group.
    :type is_service_group: bool
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'manifest_version': {'key': 'ManifestVersion', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'service_status': {'key': 'ServiceStatus', 'type': 'str'},
        'is_service_group': {'key': 'IsServiceGroup', 'type': 'bool'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatelessServiceInfo, self).__init__(**kwargs)
        self.service_kind = 'Stateless'


class StatelessServiceInstanceHealth(ReplicaHealth):
    """Represents the health of the stateless service instance.
    Contains the instance aggregated health state, the health events and the
    unhealthy evaluations.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The HealthState representing the
     aggregated health state of the entity computed by Health Manager.
     The health evaluation of the entity reflects all events reported on the
     entity and its children (if any).
     The aggregation is done by applying the desired health policy. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param health_events: The list of health events reported on the entity.
    :type health_events: list[~azure.servicefabric.models.HealthEvent]
    :param unhealthy_evaluations: The unhealthy evaluations that show why the
     current aggregated health state was returned by Health Manager.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    :param health_statistics: Shows the health statistics for all children
     types of the queried entity.
    :type health_statistics: ~azure.servicefabric.models.HealthStatistics
    :param partition_id: Id of the partition to which this replica belongs.
    :type partition_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param instance_id: Id of a stateless service instance. InstanceId is used
     by Service Fabric to uniquely identify an instance of a partition of a
     stateless service. It is unique within a partition and does not change for
     the lifetime of the instance. If the instance has failed over on the same
     or different node, it will get a different value for the InstanceId.
    :type instance_id: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'health_events': {'key': 'HealthEvents', 'type': '[HealthEvent]'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
        'health_statistics': {'key': 'HealthStatistics', 'type': 'HealthStatistics'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_id': {'key': 'InstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatelessServiceInstanceHealth, self).__init__(**kwargs)
        self.instance_id = kwargs.get('instance_id', None)
        self.service_kind = 'Stateless'


class StatelessServiceInstanceHealthState(ReplicaHealthState):
    """Represents the health state of the stateless service instance, which
    contains the instance ID and the aggregated health state.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param partition_id: The ID of the partition to which this replica
     belongs.
    :type partition_id: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param replica_id: Id of the stateless service instance on the wire this
     field is called ReplicaId.
    :type replica_id: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'replica_id': {'key': 'ReplicaId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatelessServiceInstanceHealthState, self).__init__(**kwargs)
        self.replica_id = kwargs.get('replica_id', None)
        self.service_kind = 'Stateless'


class StatelessServiceInstanceInfo(ReplicaInfo):
    """Represents a stateless service instance. This includes information about
    the identity, status, health, node name, uptime, and other details about
    the instance.

    All required parameters must be populated in order to send to Azure.

    :param replica_status: The status of a replica of a service. Possible
     values include: 'Invalid', 'InBuild', 'Standby', 'Ready', 'Down',
     'Dropped'
    :type replica_status: str or ~azure.servicefabric.models.ReplicaStatus
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param node_name: The name of a Service Fabric node.
    :type node_name: str
    :param address: The address the replica is listening on.
    :type address: str
    :param last_in_build_duration_in_seconds: The last in build duration of
     the replica in seconds.
    :type last_in_build_duration_in_seconds: str
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param instance_id: Id of a stateless service instance. InstanceId is used
     by Service Fabric to uniquely identify an instance of a partition of a
     stateless service. It is unique within a partition and does not change for
     the lifetime of the instance. If the instance has failed over on the same
     or different node, it will get a different value for the InstanceId.
    :type instance_id: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'replica_status': {'key': 'ReplicaStatus', 'type': 'str'},
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'address': {'key': 'Address', 'type': 'str'},
        'last_in_build_duration_in_seconds': {'key': 'LastInBuildDurationInSeconds', 'type': 'str'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_id': {'key': 'InstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StatelessServiceInstanceInfo, self).__init__(**kwargs)
        self.instance_id = kwargs.get('instance_id', None)
        self.service_kind = 'Stateless'


class StatelessServicePartitionInfo(ServicePartitionInfo):
    """Information about a partition of a stateless Service Fabric service.

    All required parameters must be populated in order to send to Azure.

    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :param partition_status: The status of the service fabric service
     partition. Possible values include: 'Invalid', 'Ready', 'NotReady',
     'InQuorumLoss', 'Reconfiguring', 'Deleting'
    :type partition_status: str or
     ~azure.servicefabric.models.ServicePartitionStatus
    :param partition_information: Information about the partition identity,
     partitioning scheme and keys supported by it.
    :type partition_information:
     ~azure.servicefabric.models.PartitionInformation
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param instance_count: Number of instances of this partition.
    :type instance_count: long
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'health_state': {'key': 'HealthState', 'type': 'str'},
        'partition_status': {'key': 'PartitionStatus', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_count': {'key': 'InstanceCount', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(StatelessServicePartitionInfo, self).__init__(**kwargs)
        self.instance_count = kwargs.get('instance_count', None)
        self.service_kind = 'Stateless'


class StatelessServiceTypeDescription(ServiceTypeDescription):
    """Describes a stateless service type defined in the service manifest of a
    provisioned application type.

    All required parameters must be populated in order to send to Azure.

    :param is_stateful: Indicates whether the service type is a stateful
     service type or a stateless service type. This property is true if the
     service type is a stateful service type, false otherwise.
    :type is_stateful: bool
    :param service_type_name: Name of the service type as specified in the
     service manifest.
    :type service_type_name: str
    :param placement_constraints: The placement constraint to be used when
     instantiating this service in a Service Fabric cluster.
    :type placement_constraints: str
    :param load_metrics: The service load metrics is given as an array of
     ServiceLoadMetricDescription objects.
    :type load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: List of service placement policy
     descriptions.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param extensions: List of service type extensions.
    :type extensions:
     list[~azure.servicefabric.models.ServiceTypeExtensionDescription]
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param use_implicit_host: A flag indicating if this type is not
     implemented and hosted by a user service process, but is implicitly hosted
     by a system created process. This value is true for services using the
     guest executable services, false otherwise.
    :type use_implicit_host: bool
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'is_stateful': {'key': 'IsStateful', 'type': 'bool'},
        'service_type_name': {'key': 'ServiceTypeName', 'type': 'str'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'load_metrics': {'key': 'LoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'extensions': {'key': 'Extensions', 'type': '[ServiceTypeExtensionDescription]'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'use_implicit_host': {'key': 'UseImplicitHost', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(StatelessServiceTypeDescription, self).__init__(**kwargs)
        self.use_implicit_host = kwargs.get('use_implicit_host', None)
        self.kind = 'Stateless'


class StatelessServiceUpdateDescription(ServiceUpdateDescription):
    """Describes an update for a stateless service.

    All required parameters must be populated in order to send to Azure.

    :param flags: Flags indicating whether other properties are set. Each of
     the associated properties corresponds to a flag, specified below, which,
     if set, indicate that the property is specified.
     This property can be a combination of those flags obtained using bitwise
     'OR' operator.
     For example, if the provided value is 6 then the flags for
     ReplicaRestartWaitDuration (2) and QuorumLossWaitDuration (4) are set.
     - None - Does not indicate any other properties are set. The value is
     zero.
     - TargetReplicaSetSize/InstanceCount - Indicates whether the
     TargetReplicaSetSize property (for Stateful services) or the InstanceCount
     property (for Stateless services) is set. The value is 1.
     - ReplicaRestartWaitDuration - Indicates the ReplicaRestartWaitDuration
     property is set. The value is  2.
     - QuorumLossWaitDuration - Indicates the QuorumLossWaitDuration property
     is set. The value is 4.
     - StandByReplicaKeepDuration - Indicates the StandByReplicaKeepDuration
     property is set. The value is 8.
     - MinReplicaSetSize - Indicates the MinReplicaSetSize property is set. The
     value is 16.
     - PlacementConstraints - Indicates the PlacementConstraints property is
     set. The value is 32.
     - PlacementPolicyList - Indicates the ServicePlacementPolicies property is
     set. The value is 64.
     - Correlation - Indicates the CorrelationScheme property is set. The value
     is 128.
     - Metrics - Indicates the ServiceLoadMetrics property is set. The value is
     256.
     - DefaultMoveCost - Indicates the DefaultMoveCost property is set. The
     value is 512.
     - ScalingPolicy - Indicates the ScalingPolicies property is set. The value
     is 1024.
    :type flags: str
    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: The correlation scheme.
    :type correlation_scheme:
     list[~azure.servicefabric.models.ServiceCorrelationDescription]
    :param load_metrics: The service load metrics.
    :type load_metrics:
     list[~azure.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: The service placement policies.
    :type service_placement_policies:
     list[~azure.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: The move cost for the service. Possible values
     include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.servicefabric.models.MoveCost
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~azure.servicefabric.models.ScalingPolicyDescription]
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    :param instance_count: The instance count.
    :type instance_count: int
    """

    _validation = {
        'service_kind': {'required': True},
        'instance_count': {'minimum': -1},
    }

    _attribute_map = {
        'flags': {'key': 'Flags', 'type': 'str'},
        'placement_constraints': {'key': 'PlacementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'CorrelationScheme', 'type': '[ServiceCorrelationDescription]'},
        'load_metrics': {'key': 'LoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'ServicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'DefaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'ScalingPolicies', 'type': '[ScalingPolicyDescription]'},
        'service_kind': {'key': 'ServiceKind', 'type': 'str'},
        'instance_count': {'key': 'InstanceCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(StatelessServiceUpdateDescription, self).__init__(**kwargs)
        self.instance_count = kwargs.get('instance_count', None)
        self.service_kind = 'Stateless'


class StoppedChaosEvent(ChaosEvent):
    """Describes a Chaos event that gets generated when Chaos stops because either
    the user issued a stop or the time to run was up.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp_utc: Required. The UTC timestamp when this Chaos event
     was generated.
    :type time_stamp_utc: datetime
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param reason: Describes why Chaos stopped. Chaos can stop because of
     StopChaos API call or the timeToRun provided in ChaosParameters is over.
    :type reason: str
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StoppedChaosEvent, self).__init__(**kwargs)
        self.reason = kwargs.get('reason', None)
        self.kind = 'Stopped'


class StringPropertyValue(PropertyValue):
    """Describes a Service Fabric property value of type String.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param data: Required. The data of the property value.
    :type data: str
    """

    _validation = {
        'kind': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'data': {'key': 'Data', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StringPropertyValue, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.kind = 'String'


class SuccessfulPropertyBatchInfo(PropertyBatchInfo):
    """Derived from PropertyBatchInfo. Represents the property batch succeeding.
    Contains the results of any "Get" operations in the batch.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param properties: A map containing the properties that were requested
     through any "Get" property batch operations. The key represents the index
     of the "Get" operation in the original request, in string form. The value
     is the property. If a property is not found, it will not be in the map.
    :type properties: dict[str, ~azure.servicefabric.models.PropertyInfo]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': '{PropertyInfo}'},
    }

    def __init__(self, **kwargs):
        super(SuccessfulPropertyBatchInfo, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.kind = 'Successful'


class SystemApplicationHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for the fabric:/System application, containing
    information about the data and the algorithm used by health store to
    evaluate health. The evaluation is returned only when the aggregated health
    state of the cluster is either Error or Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the current aggregated health state of the system application. The types
     of the unhealthy evaluations can be DeployedApplicationsHealthEvaluation,
     ServicesHealthEvaluation or EventHealthEvaluation.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(SystemApplicationHealthEvaluation, self).__init__(**kwargs)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'SystemApplication'


class TcpConfig(Model):
    """Describes the tcp configuration for external connectivity for this network.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. tcp gateway config name.
    :type name: str
    :param port: Required. Specifies the port at which the service endpoint
     below needs to be exposed.
    :type port: int
    :param destination: Required. Describes destination endpoint for routing
     traffic.
    :type destination: ~azure.servicefabric.models.GatewayDestination
    """

    _validation = {
        'name': {'required': True},
        'port': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'destination': {'key': 'destination', 'type': 'GatewayDestination'},
    }

    def __init__(self, **kwargs):
        super(TcpConfig, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.port = kwargs.get('port', None)
        self.destination = kwargs.get('destination', None)


class TestErrorChaosEvent(ChaosEvent):
    """Describes a Chaos event that gets generated when an unexpected event occurs
    in the Chaos engine.
    For example, due to the cluster snapshot being inconsistent, while faulting
    an entity, Chaos found that the entity was already faulted -- which would
    be an unexpected event.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp_utc: Required. The UTC timestamp when this Chaos event
     was generated.
    :type time_stamp_utc: datetime
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param reason: Describes why TestErrorChaosEvent was generated. For
     example, Chaos tries to fault a partition but finds that the partition is
     no longer fault tolerant, then a TestErrorEvent gets generated with the
     reason stating that the partition is not fault tolerant.
    :type reason: str
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TestErrorChaosEvent, self).__init__(**kwargs)
        self.reason = kwargs.get('reason', None)
        self.kind = 'TestError'


class TimeBasedBackupScheduleDescription(BackupScheduleDescription):
    """Describes the time based backup schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule_kind: Required. Constant filled by server.
    :type schedule_kind: str
    :param schedule_frequency_type: Required. Describes the frequency with
     which to run the time based backup schedule. Possible values include:
     'Invalid', 'Daily', 'Weekly'
    :type schedule_frequency_type: str or
     ~azure.servicefabric.models.BackupScheduleFrequencyType
    :param run_days: List of days of a week when to trigger the periodic
     backup. This is valid only when the backup schedule frequency type is
     weekly.
    :type run_days: list[str or ~azure.servicefabric.models.DayOfWeek]
    :param run_times: Required. Represents the list of exact time during the
     day in ISO8601 format. Like '19:00:00' will represent '7PM' during the
     day. Date specified along with time will be ignored.
    :type run_times: list[datetime]
    """

    _validation = {
        'schedule_kind': {'required': True},
        'schedule_frequency_type': {'required': True},
        'run_times': {'required': True},
    }

    _attribute_map = {
        'schedule_kind': {'key': 'ScheduleKind', 'type': 'str'},
        'schedule_frequency_type': {'key': 'ScheduleFrequencyType', 'type': 'str'},
        'run_days': {'key': 'RunDays', 'type': '[str]'},
        'run_times': {'key': 'RunTimes', 'type': '[iso-8601]'},
    }

    def __init__(self, **kwargs):
        super(TimeBasedBackupScheduleDescription, self).__init__(**kwargs)
        self.schedule_frequency_type = kwargs.get('schedule_frequency_type', None)
        self.run_days = kwargs.get('run_days', None)
        self.run_times = kwargs.get('run_times', None)
        self.schedule_kind = 'TimeBased'


class TimeOfDay(Model):
    """Defines an hour and minute of the day specified in 24 hour time.

    :param hour: Represents the hour of the day. Value must be between 0 and
     23 inclusive.
    :type hour: int
    :param minute: Represents the minute of the hour. Value must be between 0
     to 59 inclusive.
    :type minute: int
    """

    _validation = {
        'hour': {'maximum': 23, 'minimum': 0},
        'minute': {'maximum': 59, 'minimum': 0},
    }

    _attribute_map = {
        'hour': {'key': 'Hour', 'type': 'int'},
        'minute': {'key': 'Minute', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(TimeOfDay, self).__init__(**kwargs)
        self.hour = kwargs.get('hour', None)
        self.minute = kwargs.get('minute', None)


class TimeRange(Model):
    """Defines a time range in a 24 hour day specified by a start and end time.

    :param start_time: Defines an hour and minute of the day specified in 24
     hour time.
    :type start_time: ~azure.servicefabric.models.TimeOfDay
    :param end_time: Defines an hour and minute of the day specified in 24
     hour time.
    :type end_time: ~azure.servicefabric.models.TimeOfDay
    """

    _attribute_map = {
        'start_time': {'key': 'StartTime', 'type': 'TimeOfDay'},
        'end_time': {'key': 'EndTime', 'type': 'TimeOfDay'},
    }

    def __init__(self, **kwargs):
        super(TimeRange, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)


class UniformInt64RangePartitionSchemeDescription(PartitionSchemeDescription):
    """Describes a partitioning scheme where an integer range is allocated evenly
    across a number of partitions.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Constant filled by server.
    :type partition_scheme: str
    :param count: Required. The number of partitions.
    :type count: int
    :param low_key: Required. String indicating the lower bound of the
     partition key range that
     should be split between the partitions.
    :type low_key: str
    :param high_key: Required. String indicating the upper bound of the
     partition key range that
     should be split between the partitions.
    :type high_key: str
    """

    _validation = {
        'partition_scheme': {'required': True},
        'count': {'required': True},
        'low_key': {'required': True},
        'high_key': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'PartitionScheme', 'type': 'str'},
        'count': {'key': 'Count', 'type': 'int'},
        'low_key': {'key': 'LowKey', 'type': 'str'},
        'high_key': {'key': 'HighKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UniformInt64RangePartitionSchemeDescription, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.low_key = kwargs.get('low_key', None)
        self.high_key = kwargs.get('high_key', None)
        self.partition_scheme = 'UniformInt64Range'


class UnplacedReplicaInformation(Model):
    """Contains information for an unplaced replica.

    :param service_name: The name of the service.
    :type service_name: str
    :param partition_id: The ID of the partition.
    :type partition_id: str
    :param unplaced_replica_details: List of reasons due to which a replica
     cannot be placed.
    :type unplaced_replica_details: list[str]
    """

    _attribute_map = {
        'service_name': {'key': 'ServiceName', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
        'unplaced_replica_details': {'key': 'UnplacedReplicaDetails', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(UnplacedReplicaInformation, self).__init__(**kwargs)
        self.service_name = kwargs.get('service_name', None)
        self.partition_id = kwargs.get('partition_id', None)
        self.unplaced_replica_details = kwargs.get('unplaced_replica_details', None)


class UnprovisionApplicationTypeDescriptionInfo(Model):
    """Describes the operation to unregister or unprovision an application type
    and its version that was registered with the Service Fabric.

    All required parameters must be populated in order to send to Azure.

    :param application_type_version: Required. The version of the application
     type as defined in the application manifest.
    :type application_type_version: str
    :param async_property: The flag indicating whether or not unprovision
     should occur asynchronously. When set to true, the unprovision operation
     returns when the request is accepted by the system, and the unprovision
     operation continues without any timeout limit. The default value is false.
     However, we recommend setting it to true for large application packages
     that were provisioned.
    :type async_property: bool
    """

    _validation = {
        'application_type_version': {'required': True},
    }

    _attribute_map = {
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'async_property': {'key': 'Async', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(UnprovisionApplicationTypeDescriptionInfo, self).__init__(**kwargs)
        self.application_type_version = kwargs.get('application_type_version', None)
        self.async_property = kwargs.get('async_property', None)


class UnprovisionFabricDescription(Model):
    """Describes the parameters for unprovisioning a cluster.

    :param code_version: The cluster code package version.
    :type code_version: str
    :param config_version: The cluster manifest version.
    :type config_version: str
    """

    _attribute_map = {
        'code_version': {'key': 'CodeVersion', 'type': 'str'},
        'config_version': {'key': 'ConfigVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UnprovisionFabricDescription, self).__init__(**kwargs)
        self.code_version = kwargs.get('code_version', None)
        self.config_version = kwargs.get('config_version', None)


class UpdateClusterUpgradeDescription(Model):
    """Parameters for updating a cluster upgrade.

    :param upgrade_kind: The type of upgrade out of the following possible
     values. Possible values include: 'Invalid', 'Rolling',
     'Rolling_ForceRestart'. Default value: "Rolling" .
    :type upgrade_kind: str or ~azure.servicefabric.models.UpgradeType
    :param update_description: Describes the parameters for updating a rolling
     upgrade of application or cluster.
    :type update_description:
     ~azure.servicefabric.models.RollingUpgradeUpdateDescription
    :param cluster_health_policy: Defines a health policy used to evaluate the
     health of the cluster or of a cluster node.
    :type cluster_health_policy:
     ~azure.servicefabric.models.ClusterHealthPolicy
    :param enable_delta_health_evaluation: When true, enables delta health
     evaluation rather than absolute health evaluation after completion of each
     upgrade domain.
    :type enable_delta_health_evaluation: bool
    :param cluster_upgrade_health_policy: Defines a health policy used to
     evaluate the health of the cluster during a cluster upgrade.
    :type cluster_upgrade_health_policy:
     ~azure.servicefabric.models.ClusterUpgradeHealthPolicyObject
    :param application_health_policy_map: Defines the application health
     policy map used to evaluate the health of an application or one of its
     children entities.
    :type application_health_policy_map:
     ~azure.servicefabric.models.ApplicationHealthPolicies
    """

    _attribute_map = {
        'upgrade_kind': {'key': 'UpgradeKind', 'type': 'str'},
        'update_description': {'key': 'UpdateDescription', 'type': 'RollingUpgradeUpdateDescription'},
        'cluster_health_policy': {'key': 'ClusterHealthPolicy', 'type': 'ClusterHealthPolicy'},
        'enable_delta_health_evaluation': {'key': 'EnableDeltaHealthEvaluation', 'type': 'bool'},
        'cluster_upgrade_health_policy': {'key': 'ClusterUpgradeHealthPolicy', 'type': 'ClusterUpgradeHealthPolicyObject'},
        'application_health_policy_map': {'key': 'ApplicationHealthPolicyMap', 'type': 'ApplicationHealthPolicies'},
    }

    def __init__(self, **kwargs):
        super(UpdateClusterUpgradeDescription, self).__init__(**kwargs)
        self.upgrade_kind = kwargs.get('upgrade_kind', "Rolling")
        self.update_description = kwargs.get('update_description', None)
        self.cluster_health_policy = kwargs.get('cluster_health_policy', None)
        self.enable_delta_health_evaluation = kwargs.get('enable_delta_health_evaluation', None)
        self.cluster_upgrade_health_policy = kwargs.get('cluster_upgrade_health_policy', None)
        self.application_health_policy_map = kwargs.get('application_health_policy_map', None)


class UpgradeDomainDeltaNodesCheckHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for delta unhealthy cluster nodes in an
    upgrade domain, containing health evaluations for each unhealthy node that
    impacted current aggregated health state.
    Can be returned during cluster upgrade when cluster aggregated health state
    is Warning or Error.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param upgrade_domain_name: Name of the upgrade domain where nodes health
     is currently evaluated.
    :type upgrade_domain_name: str
    :param baseline_error_count: Number of upgrade domain nodes with
     aggregated heath state Error in the health store at the beginning of the
     cluster upgrade.
    :type baseline_error_count: long
    :param baseline_total_count: Total number of upgrade domain nodes in the
     health store at the beginning of the cluster upgrade.
    :type baseline_total_count: long
    :param max_percent_delta_unhealthy_nodes: Maximum allowed percentage of
     upgrade domain delta unhealthy nodes from the ClusterUpgradeHealthPolicy.
    :type max_percent_delta_unhealthy_nodes: int
    :param total_count: Total number of upgrade domain nodes in the health
     store.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     NodeHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'upgrade_domain_name': {'key': 'UpgradeDomainName', 'type': 'str'},
        'baseline_error_count': {'key': 'BaselineErrorCount', 'type': 'long'},
        'baseline_total_count': {'key': 'BaselineTotalCount', 'type': 'long'},
        'max_percent_delta_unhealthy_nodes': {'key': 'MaxPercentDeltaUnhealthyNodes', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(UpgradeDomainDeltaNodesCheckHealthEvaluation, self).__init__(**kwargs)
        self.upgrade_domain_name = kwargs.get('upgrade_domain_name', None)
        self.baseline_error_count = kwargs.get('baseline_error_count', None)
        self.baseline_total_count = kwargs.get('baseline_total_count', None)
        self.max_percent_delta_unhealthy_nodes = kwargs.get('max_percent_delta_unhealthy_nodes', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'UpgradeDomainDeltaNodesCheck'


class UpgradeDomainInfo(Model):
    """Information about an upgrade domain.

    :param name: The name of the upgrade domain
    :type name: str
    :param state: The state of the upgrade domain. Possible values include:
     'Invalid', 'Pending', 'InProgress', 'Completed'
    :type state: str or ~azure.servicefabric.models.UpgradeDomainState
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'state': {'key': 'State', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpgradeDomainInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.state = kwargs.get('state', None)


class UpgradeDomainNodesHealthEvaluation(HealthEvaluation):
    """Represents health evaluation for cluster nodes in an upgrade domain,
    containing health evaluations for each unhealthy node that impacted current
    aggregated health state. Can be returned when evaluating cluster health
    during cluster upgrade and the aggregated health state is either Error or
    Warning.

    All required parameters must be populated in order to send to Azure.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param description: Description of the health evaluation, which represents
     a summary of the evaluation process.
    :type description: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param upgrade_domain_name: Name of the upgrade domain where nodes health
     is currently evaluated.
    :type upgrade_domain_name: str
    :param max_percent_unhealthy_nodes: Maximum allowed percentage of
     unhealthy nodes from the ClusterHealthPolicy.
    :type max_percent_unhealthy_nodes: int
    :param total_count: Total number of nodes in the current upgrade domain.
    :type total_count: long
    :param unhealthy_evaluations: List of unhealthy evaluations that led to
     the aggregated health state. Includes all the unhealthy
     NodeHealthEvaluation that impacted the aggregated health.
    :type unhealthy_evaluations:
     list[~azure.servicefabric.models.HealthEvaluationWrapper]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'upgrade_domain_name': {'key': 'UpgradeDomainName', 'type': 'str'},
        'max_percent_unhealthy_nodes': {'key': 'MaxPercentUnhealthyNodes', 'type': 'int'},
        'total_count': {'key': 'TotalCount', 'type': 'long'},
        'unhealthy_evaluations': {'key': 'UnhealthyEvaluations', 'type': '[HealthEvaluationWrapper]'},
    }

    def __init__(self, **kwargs):
        super(UpgradeDomainNodesHealthEvaluation, self).__init__(**kwargs)
        self.upgrade_domain_name = kwargs.get('upgrade_domain_name', None)
        self.max_percent_unhealthy_nodes = kwargs.get('max_percent_unhealthy_nodes', None)
        self.total_count = kwargs.get('total_count', None)
        self.unhealthy_evaluations = kwargs.get('unhealthy_evaluations', None)
        self.kind = 'UpgradeDomainNodes'


class UpgradeOrchestrationServiceState(Model):
    """Service state of Service Fabric Upgrade Orchestration Service.

    :param service_state: The state of Service Fabric Upgrade Orchestration
     Service.
    :type service_state: str
    """

    _attribute_map = {
        'service_state': {'key': 'ServiceState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpgradeOrchestrationServiceState, self).__init__(**kwargs)
        self.service_state = kwargs.get('service_state', None)


class UpgradeOrchestrationServiceStateSummary(Model):
    """Service state summary of Service Fabric Upgrade Orchestration Service.

    :param current_code_version: The current code version of the cluster.
    :type current_code_version: str
    :param current_manifest_version: The current manifest version of the
     cluster.
    :type current_manifest_version: str
    :param target_code_version: The target code version of  the cluster.
    :type target_code_version: str
    :param target_manifest_version: The target manifest version of the
     cluster.
    :type target_manifest_version: str
    :param pending_upgrade_type: The type of the pending upgrade of the
     cluster.
    :type pending_upgrade_type: str
    """

    _attribute_map = {
        'current_code_version': {'key': 'CurrentCodeVersion', 'type': 'str'},
        'current_manifest_version': {'key': 'CurrentManifestVersion', 'type': 'str'},
        'target_code_version': {'key': 'TargetCodeVersion', 'type': 'str'},
        'target_manifest_version': {'key': 'TargetManifestVersion', 'type': 'str'},
        'pending_upgrade_type': {'key': 'PendingUpgradeType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpgradeOrchestrationServiceStateSummary, self).__init__(**kwargs)
        self.current_code_version = kwargs.get('current_code_version', None)
        self.current_manifest_version = kwargs.get('current_manifest_version', None)
        self.target_code_version = kwargs.get('target_code_version', None)
        self.target_manifest_version = kwargs.get('target_manifest_version', None)
        self.pending_upgrade_type = kwargs.get('pending_upgrade_type', None)


class UploadChunkRange(Model):
    """Information about which portion of the file to upload.

    :param start_position: The start position of the portion of the file. It's
     represented by the number of bytes.
    :type start_position: str
    :param end_position: The end position of the portion of the file. It's
     represented by the number of bytes.
    :type end_position: str
    """

    _attribute_map = {
        'start_position': {'key': 'StartPosition', 'type': 'str'},
        'end_position': {'key': 'EndPosition', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UploadChunkRange, self).__init__(**kwargs)
        self.start_position = kwargs.get('start_position', None)
        self.end_position = kwargs.get('end_position', None)


class UploadSession(Model):
    """Information about a image store upload session.

    :param upload_sessions: When querying upload session by upload session ID,
     the result contains only one upload session. When querying upload session
     by image store relative path, the result might contain multiple upload
     sessions.
    :type upload_sessions: list[~azure.servicefabric.models.UploadSessionInfo]
    """

    _attribute_map = {
        'upload_sessions': {'key': 'UploadSessions', 'type': '[UploadSessionInfo]'},
    }

    def __init__(self, **kwargs):
        super(UploadSession, self).__init__(**kwargs)
        self.upload_sessions = kwargs.get('upload_sessions', None)


class UploadSessionInfo(Model):
    """Information about an image store upload session. A session is associated
    with a relative path in the image store.

    :param store_relative_path: The remote location within image store. This
     path is relative to the image store root.
    :type store_relative_path: str
    :param session_id: A unique ID of the upload session. A session ID can be
     reused only if the session was committed or removed.
    :type session_id: str
    :param modified_date: The date and time when the upload session was last
     modified.
    :type modified_date: datetime
    :param file_size: The size in bytes of the uploading file.
    :type file_size: str
    :param expected_ranges: List of chunk ranges that image store has not
     received yet.
    :type expected_ranges: list[~azure.servicefabric.models.UploadChunkRange]
    """

    _attribute_map = {
        'store_relative_path': {'key': 'StoreRelativePath', 'type': 'str'},
        'session_id': {'key': 'SessionId', 'type': 'str'},
        'modified_date': {'key': 'ModifiedDate', 'type': 'iso-8601'},
        'file_size': {'key': 'FileSize', 'type': 'str'},
        'expected_ranges': {'key': 'ExpectedRanges', 'type': '[UploadChunkRange]'},
    }

    def __init__(self, **kwargs):
        super(UploadSessionInfo, self).__init__(**kwargs)
        self.store_relative_path = kwargs.get('store_relative_path', None)
        self.session_id = kwargs.get('session_id', None)
        self.modified_date = kwargs.get('modified_date', None)
        self.file_size = kwargs.get('file_size', None)
        self.expected_ranges = kwargs.get('expected_ranges', None)


class ValidationFailedChaosEvent(ChaosEvent):
    """Chaos event corresponding to a failure during validation.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp_utc: Required. The UTC timestamp when this Chaos event
     was generated.
    :type time_stamp_utc: datetime
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param reason: Describes why the ValidationFailedChaosEvent was generated.
     This may happen because more than MaxPercentUnhealthyNodes are unhealthy
     for more than MaxClusterStabilizationTimeout. This reason will be in the
     Reason property of the ValidationFailedChaosEvent as a string.
    :type reason: str
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ValidationFailedChaosEvent, self).__init__(**kwargs)
        self.reason = kwargs.get('reason', None)
        self.kind = 'ValidationFailed'


class VolumeProviderParametersAzureFile(Model):
    """This type describes a volume provided by an Azure Files file share.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. Name of the Azure storage account for the
     File Share.
    :type account_name: str
    :param account_key: Access key of the Azure storage account for the File
     Share.
    :type account_key: str
    :param share_name: Required. Name of the Azure Files file share that
     provides storage for the volume.
    :type share_name: str
    """

    _validation = {
        'account_name': {'required': True},
        'share_name': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VolumeProviderParametersAzureFile, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.account_key = kwargs.get('account_key', None)
        self.share_name = kwargs.get('share_name', None)


class VolumeResourceDescription(Model):
    """This type describes a volume resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Volume resource.
    :type name: str
    :param description: User readable description of the volume.
    :type description: str
    :ivar status: Status of the volume. Possible values include: 'Unknown',
     'Ready', 'Upgrading', 'Creating', 'Deleting', 'Failed'
    :vartype status: str or ~azure.servicefabric.models.ResourceStatus
    :ivar status_details: Gives additional information about the current
     status of the volume.
    :vartype status_details: str
    :ivar provider: Required. Provider of the volume. Default value:
     "SFAzureFile" .
    :vartype provider: str
    :param azure_file_parameters: This type describes a volume provided by an
     Azure Files file share.
    :type azure_file_parameters:
     ~azure.servicefabric.models.VolumeProviderParametersAzureFile
    """

    _validation = {
        'name': {'required': True},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'provider': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'azure_file_parameters': {'key': 'properties.azureFileParameters', 'type': 'VolumeProviderParametersAzureFile'},
    }

    provider = "SFAzureFile"

    def __init__(self, **kwargs):
        super(VolumeResourceDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.status = None
        self.status_details = None
        self.azure_file_parameters = kwargs.get('azure_file_parameters', None)


class WaitForInbuildReplicaSafetyCheck(PartitionSafetyCheck):
    """Safety check that waits for the replica build operation to finish. This
    indicates that there is a replica that is going through the copy or is
    providing data for building another replica. Bring the node down will abort
    this copy operation which are typically expensive involving data movements.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition which is undergoing the safety
     check.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WaitForInbuildReplicaSafetyCheck, self).__init__(**kwargs)
        self.kind = 'WaitForInbuildReplica'


class WaitForPrimaryPlacementSafetyCheck(PartitionSafetyCheck):
    """Safety check that waits for the primary replica that was moved out of the
    node due to upgrade to be placed back again on that node.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition which is undergoing the safety
     check.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WaitForPrimaryPlacementSafetyCheck, self).__init__(**kwargs)
        self.kind = 'WaitForPrimaryPlacement'


class WaitForPrimarySwapSafetyCheck(PartitionSafetyCheck):
    """Safety check that waits for the primary replica to be moved out of the node
    before starting an upgrade to ensure the availability of the primary
    replica for the partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition which is undergoing the safety
     check.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WaitForPrimarySwapSafetyCheck, self).__init__(**kwargs)
        self.kind = 'WaitForPrimarySwap'


class WaitForReconfigurationSafetyCheck(PartitionSafetyCheck):
    """Safety check that waits for the current reconfiguration of the partition to
    be completed before starting an upgrade.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param partition_id: Id of the partition which is undergoing the safety
     check.
    :type partition_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'partition_id': {'key': 'PartitionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WaitForReconfigurationSafetyCheck, self).__init__(**kwargs)
        self.kind = 'WaitForReconfiguration'


class WaitingChaosEvent(ChaosEvent):
    """Describes a Chaos event that gets generated when Chaos is waiting for the
    cluster to become ready for faulting, for example, Chaos may be waiting for
    the on-going upgrade to finish.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp_utc: Required. The UTC timestamp when this Chaos event
     was generated.
    :type time_stamp_utc: datetime
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param reason: Describes why the WaitingChaosEvent was generated, for
     example, due to a cluster upgrade.
    :type reason: str
    """

    _validation = {
        'time_stamp_utc': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'kind': {'key': 'Kind', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WaitingChaosEvent, self).__init__(**kwargs)
        self.reason = kwargs.get('reason', None)
        self.kind = 'Waiting'
