if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part;parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
    } else {
      return null;
    }
  }
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
goog.forwardDeclare("Document");
goog.forwardDeclare("HTMLScriptElement");
goog.forwardDeclare("XMLHttpRequest");
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part;part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_isModule) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for (var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      deps.pathIsModule[path] = !!opt_isModule;
    }
    for (var j = 0;require = requires[j];j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      } else {
        return null;
      }
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.writeScripts_(path);
        return null;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    goog.logToConsole_(errorMessage);
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
if (goog.DEPENDENCIES_ENABLED) {
  goog.dependencies_ = {pathIsModule:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return doc != null && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.isDef(goog.global.CLOSURE_BASE_PATH)) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("SCRIPT");
    for (var i = scripts.length - 1;i >= 0;--i) {
      var script = (scripts[i]);
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !!(!goog.global.atob && goog.global.document && goog.global.document.all);
  goog.importModule_ = function(src) {
    var bootstrap = 'goog.retrieveAndExecModule_("' + src + '");';
    if (goog.importScript_("", bootstrap)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0;i < count;i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && goog.dependencies_.pathIsModule[path]) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModuleFromUrl = function(url) {
    goog.retrieveAndExecModule_(url);
  };
  goog.loadModule = function(moduleDef) {
    var previousState = goog.moduleLoaderState_;
    try {
      goog.moduleLoaderState_ = {moduleName:undefined, declareLegacyNamespace:false};
      var exports;
      if (goog.isFunction(moduleDef)) {
        exports = moduleDef.call(goog.global, {});
      } else {
        if (goog.isString(moduleDef)) {
          exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
        } else {
          throw Error("Invalid module definition");
        }
      }
      var moduleName = goog.moduleLoaderState_.moduleName;
      if (!goog.isString(moduleName) || !moduleName) {
        throw Error('Invalid module name "' + moduleName + '"');
      }
      if (goog.moduleLoaderState_.declareLegacyNamespace) {
        goog.constructNamespace_(moduleName, exports);
      } else {
        if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
          Object.seal(exports);
        }
      }
      goog.loadedModules_[moduleName] = exports;
    } finally {
      goog.moduleLoaderState_ = previousState;
    }
  };
  goog.loadModuleFromSource_ = function() {
    var exports = {};
    eval(arguments[0]);
    return exports;
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = (doc.createElement("script"));
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      var isOldIE = goog.IS_OLD_IE_;
      if (opt_sourceText === undefined) {
        if (!isOldIE) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + opt_sourceText + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function(pathToLoad) {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    visitNode(pathToLoad);
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    for (var i = 0;i < scripts.length;i++) {
      var path = scripts[i];
      if (path) {
        if (!deps.pathIsModule[path]) {
          goog.importScript_(goog.basePath + path);
        } else {
          goog.importModule_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    var xhr = new goog.global["XMLHttpRequest"];
    xhr.open("get", src, false);
    xhr.send();
    return xhr.responseText;
  }
};
goog.retrieveAndExecModule_ = function(src) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText != null) {
      var execModuleScript = goog.wrapModule_(src, scriptText);
      var isOldIE = goog.IS_OLD_IE_;
      if (isOldIE) {
        goog.dependencies_.deferred[originalPath] = execModuleScript;
        goog.queuedModules_.push(originalPath);
      } else {
        importScript(src, execModuleScript);
      }
    } else {
      throw new Error("load of " + src + "failed");
    }
  }
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if ("removeAttribute" in (obj)) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1E9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return (fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _evalTest_ \x3d 1;");
        if (typeof goog.global["_evalTest_"] != "undefined") {
          try {
            delete goog.global["_evalTest_"];
          } catch (ignore) {
          }
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = (doc.createElement("SCRIPT"));
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return opt_values != null && key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2;i < arguments.length;i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1;i < arguments.length;i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2;i < arguments.length;i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (goog.defineClass.SEAL_CLASS_INSTANCES && Object.seal instanceof Function) {
    if (superClass && superClass.prototype && superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) {
      return ctr;
    }
    var wrappedCtr = function() {
      var instance = ctr.apply(this, arguments) || this;
      instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
      if (this.constructor === wrappedCtr) {
        Object.seal(instance);
      }
      return instance;
    };
    return wrappedCtr;
  }
  return ctr;
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0;i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numberAwareCompare_ = function(str1, str2, tokenizerRegExp) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(tokenizerRegExp);
  var tokens2 = str2.toLowerCase().match(tokenizerRegExp);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.intAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\D+/g);
};
goog.string.floatAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\.\d+|\D+/g);
};
goog.string.numerateCompare = goog.string.floatAwareCompare;
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\", "\x3c":"\x3c"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  var sb = ['"'];
  for (var i = 0;i < s.length;i++) {
    var ch = s.charAt(i);
    var cc = ch.charCodeAt(0);
    sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
  }
  sb.push('"');
  return sb.join("");
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = String.prototype.repeat ? function(string, length) {
  return string.repeat(length);
} : function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i) >>> 0;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0;i < b.length + 1;i++) {
    v0[i] = i;
  }
  for (var i = 0;i < a.length;i++) {
    v1[0] = i + 1;
    for (var j = 0;j < b.length;j++) {
      var cost = a[i] != b[j];
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0;j < v0.length;j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return (value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i < arr.length;i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i >= 0;i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;--i) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call(opt_obj, element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1;i >= 0;i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call(opt_obj, val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.join = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0;i < length;i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0;j < len2;j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start);
  } else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(item) ? "o" + goog.getUid(item) : (typeof item).charAt(0) + item;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = compareFn(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for (var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(arr, stableCompareFn);
  for (var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0;i < l;i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter.call(opt_obj, value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start;i < end;i += step) {
      array.push(i);
    }
  } else {
    for (var i = start;i > end;i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0;i < n;i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0;c < element.length;c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0;r < recurseResult.length;r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = goog.array.ARRAY_PROTOTYPE_.splice.call(arr, fromIndex, 1);
  goog.array.ARRAY_PROTOTYPE_.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  var minLen = arguments[0].length;
  for (var i = 1;i < arguments.length;i++) {
    if (arguments[i].length < minLen) {
      minLen = arguments[i].length;
    }
  }
  for (var i = 0;i < minLen;i++) {
    var value = [];
    for (var j = 0;j < arguments.length;j++) {
      value.push(arguments[j][i]);
    }
    result.push(value);
  }
  return result;
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.provide("goog.labs.userAgent.util");
goog.require("goog.string");
goog.labs.userAgent.util.getNativeUserAgentString_ = function() {
  var navigator = goog.labs.userAgent.util.getNavigator_();
  if (navigator) {
    var userAgent = navigator.userAgent;
    if (userAgent) {
      return userAgent;
    }
  }
  return "";
};
goog.labs.userAgent.util.getNavigator_ = function() {
  return goog.global.navigator;
};
goog.labs.userAgent.util.userAgent_ = goog.labs.userAgent.util.getNativeUserAgentString_();
goog.labs.userAgent.util.setUserAgent = function(opt_userAgent) {
  goog.labs.userAgent.util.userAgent_ = opt_userAgent || goog.labs.userAgent.util.getNativeUserAgentString_();
};
goog.labs.userAgent.util.getUserAgent = function() {
  return goog.labs.userAgent.util.userAgent_;
};
goog.labs.userAgent.util.matchUserAgent = function(str) {
  var userAgent = goog.labs.userAgent.util.getUserAgent();
  return goog.string.contains(userAgent, str);
};
goog.labs.userAgent.util.matchUserAgentIgnoreCase = function(str) {
  var userAgent = goog.labs.userAgent.util.getUserAgent();
  return goog.string.caseInsensitiveContains(userAgent, str);
};
goog.labs.userAgent.util.extractVersionTuples = function(userAgent) {
  var versionRegExp = new RegExp("(\\w[\\w ]+)" + "/" + "([^\\s]+)" + "\\s*" + "(?:\\((.*?)\\))?", "g");
  var data = [];
  var match;
  while (match = versionRegExp.exec(userAgent)) {
    data.push([match[1], match[2], match[3] || undefined]);
  }
  return data;
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return obj !== null && key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in (obj)) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (obj !== null && key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (obj !== null && key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in (obj) ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (goog.isFunction(obj.clone)) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.labs.userAgent.browser");
goog.require("goog.array");
goog.require("goog.labs.userAgent.util");
goog.require("goog.object");
goog.require("goog.string");
goog.labs.userAgent.browser.matchOpera_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Opera") || goog.labs.userAgent.util.matchUserAgent("OPR");
};
goog.labs.userAgent.browser.matchIE_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE");
};
goog.labs.userAgent.browser.matchEdge_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Edge");
};
goog.labs.userAgent.browser.matchFirefox_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Firefox");
};
goog.labs.userAgent.browser.matchSafari_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Safari") && !(goog.labs.userAgent.browser.matchChrome_() || goog.labs.userAgent.browser.matchCoast_() || goog.labs.userAgent.browser.matchOpera_() || goog.labs.userAgent.browser.matchEdge_() || goog.labs.userAgent.browser.isSilk() || goog.labs.userAgent.util.matchUserAgent("Android"));
};
goog.labs.userAgent.browser.matchCoast_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Coast");
};
goog.labs.userAgent.browser.matchIosWebview_ = function() {
  return (goog.labs.userAgent.util.matchUserAgent("iPad") || goog.labs.userAgent.util.matchUserAgent("iPhone")) && !goog.labs.userAgent.browser.matchSafari_() && !goog.labs.userAgent.browser.matchChrome_() && !goog.labs.userAgent.browser.matchCoast_() && goog.labs.userAgent.util.matchUserAgent("AppleWebKit");
};
goog.labs.userAgent.browser.matchChrome_ = function() {
  return (goog.labs.userAgent.util.matchUserAgent("Chrome") || goog.labs.userAgent.util.matchUserAgent("CriOS")) && !goog.labs.userAgent.browser.matchOpera_() && !goog.labs.userAgent.browser.matchEdge_();
};
goog.labs.userAgent.browser.matchAndroidBrowser_ = function() {
  return goog.labs.userAgent.util.matchUserAgent("Android") && !(goog.labs.userAgent.browser.isChrome() || goog.labs.userAgent.browser.isFirefox() || goog.labs.userAgent.browser.isOpera() || goog.labs.userAgent.browser.isSilk());
};
goog.labs.userAgent.browser.isOpera = goog.labs.userAgent.browser.matchOpera_;
goog.labs.userAgent.browser.isIE = goog.labs.userAgent.browser.matchIE_;
goog.labs.userAgent.browser.isEdge = goog.labs.userAgent.browser.matchEdge_;
goog.labs.userAgent.browser.isFirefox = goog.labs.userAgent.browser.matchFirefox_;
goog.labs.userAgent.browser.isSafari = goog.labs.userAgent.browser.matchSafari_;
goog.labs.userAgent.browser.isCoast = goog.labs.userAgent.browser.matchCoast_;
goog.labs.userAgent.browser.isIosWebview = goog.labs.userAgent.browser.matchIosWebview_;
goog.labs.userAgent.browser.isChrome = goog.labs.userAgent.browser.matchChrome_;
goog.labs.userAgent.browser.isAndroidBrowser = goog.labs.userAgent.browser.matchAndroidBrowser_;
goog.labs.userAgent.browser.isSilk = function() {
  return goog.labs.userAgent.util.matchUserAgent("Silk");
};
goog.labs.userAgent.browser.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  if (goog.labs.userAgent.browser.isIE()) {
    return goog.labs.userAgent.browser.getIEVersion_(userAgentString);
  }
  var versionTuples = goog.labs.userAgent.util.extractVersionTuples(userAgentString);
  var versionMap = {};
  goog.array.forEach(versionTuples, function(tuple) {
    var key = tuple[0];
    var value = tuple[1];
    versionMap[key] = value;
  });
  var versionMapHasKey = goog.partial(goog.object.containsKey, versionMap);
  function lookUpValueWithKeys(keys) {
    var key = goog.array.find(keys, versionMapHasKey);
    return versionMap[key] || "";
  }
  if (goog.labs.userAgent.browser.isOpera()) {
    return lookUpValueWithKeys(["Version", "Opera", "OPR"]);
  }
  if (goog.labs.userAgent.browser.isEdge()) {
    return lookUpValueWithKeys(["Edge"]);
  }
  if (goog.labs.userAgent.browser.isChrome()) {
    return lookUpValueWithKeys(["Chrome", "CriOS"]);
  }
  var tuple = versionTuples[2];
  return tuple && tuple[1] || "";
};
goog.labs.userAgent.browser.isVersionOrHigher = function(version) {
  return goog.string.compareVersions(goog.labs.userAgent.browser.getVersion(), version) >= 0;
};
goog.labs.userAgent.browser.getIEVersion_ = function(userAgent) {
  var rv = /rv: *([\d\.]*)/.exec(userAgent);
  if (rv && rv[1]) {
    return rv[1];
  }
  var version = "";
  var msie = /MSIE +([\d\.]+)/.exec(userAgent);
  if (msie && msie[1]) {
    var tridentVersion = /Trident\/(\d.\d)/.exec(userAgent);
    if (msie[1] == "7.0") {
      if (tridentVersion && tridentVersion[1]) {
        switch(tridentVersion[1]) {
          case "4.0":
            version = "8.0";
            break;
          case "5.0":
            version = "9.0";
            break;
          case "6.0":
            version = "10.0";
            break;
          case "7.0":
            version = "11.0";
            break;
        }
      } else {
        version = "7.0";
      }
    } else {
      version = msie[1];
    }
  }
  return version;
};
goog.provide("goog.labs.userAgent.engine");
goog.require("goog.array");
goog.require("goog.labs.userAgent.util");
goog.require("goog.string");
goog.labs.userAgent.engine.isPresto = function() {
  return goog.labs.userAgent.util.matchUserAgent("Presto");
};
goog.labs.userAgent.engine.isTrident = function() {
  return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE");
};
goog.labs.userAgent.engine.isEdge = function() {
  return goog.labs.userAgent.util.matchUserAgent("Edge");
};
goog.labs.userAgent.engine.isWebKit = function() {
  return goog.labs.userAgent.util.matchUserAgentIgnoreCase("WebKit") && !goog.labs.userAgent.engine.isEdge();
};
goog.labs.userAgent.engine.isGecko = function() {
  return goog.labs.userAgent.util.matchUserAgent("Gecko") && !goog.labs.userAgent.engine.isWebKit() && !goog.labs.userAgent.engine.isTrident() && !goog.labs.userAgent.engine.isEdge();
};
goog.labs.userAgent.engine.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  if (userAgentString) {
    var tuples = goog.labs.userAgent.util.extractVersionTuples(userAgentString);
    var engineTuple = goog.labs.userAgent.engine.getEngineTuple_(tuples);
    if (engineTuple) {
      if (engineTuple[0] == "Gecko") {
        return goog.labs.userAgent.engine.getVersionForKey_(tuples, "Firefox");
      }
      return engineTuple[1];
    }
    var browserTuple = tuples[0];
    var info;
    if (browserTuple && (info = browserTuple[2])) {
      var match = /Trident\/([^\s;]+)/.exec(info);
      if (match) {
        return match[1];
      }
    }
  }
  return "";
};
goog.labs.userAgent.engine.getEngineTuple_ = function(tuples) {
  if (!goog.labs.userAgent.engine.isEdge()) {
    return tuples[1];
  }
  for (var i = 0;i < tuples.length;i++) {
    var tuple = tuples[i];
    if (tuple[0] == "Edge") {
      return tuple;
    }
  }
};
goog.labs.userAgent.engine.isVersionOrHigher = function(version) {
  return goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(), version) >= 0;
};
goog.labs.userAgent.engine.getVersionForKey_ = function(tuples, key) {
  var pair = goog.array.find(tuples, function(pair) {
    return key == pair[0];
  });
  return pair && pair[1] || "";
};
goog.provide("goog.labs.userAgent.platform");
goog.require("goog.labs.userAgent.util");
goog.require("goog.string");
goog.labs.userAgent.platform.isAndroid = function() {
  return goog.labs.userAgent.util.matchUserAgent("Android");
};
goog.labs.userAgent.platform.isIpod = function() {
  return goog.labs.userAgent.util.matchUserAgent("iPod");
};
goog.labs.userAgent.platform.isIphone = function() {
  return goog.labs.userAgent.util.matchUserAgent("iPhone") && !goog.labs.userAgent.util.matchUserAgent("iPod") && !goog.labs.userAgent.util.matchUserAgent("iPad");
};
goog.labs.userAgent.platform.isIpad = function() {
  return goog.labs.userAgent.util.matchUserAgent("iPad");
};
goog.labs.userAgent.platform.isIos = function() {
  return goog.labs.userAgent.platform.isIphone() || goog.labs.userAgent.platform.isIpad() || goog.labs.userAgent.platform.isIpod();
};
goog.labs.userAgent.platform.isMacintosh = function() {
  return goog.labs.userAgent.util.matchUserAgent("Macintosh");
};
goog.labs.userAgent.platform.isLinux = function() {
  return goog.labs.userAgent.util.matchUserAgent("Linux");
};
goog.labs.userAgent.platform.isWindows = function() {
  return goog.labs.userAgent.util.matchUserAgent("Windows");
};
goog.labs.userAgent.platform.isChromeOS = function() {
  return goog.labs.userAgent.util.matchUserAgent("CrOS");
};
goog.labs.userAgent.platform.getVersion = function() {
  var userAgentString = goog.labs.userAgent.util.getUserAgent();
  var version = "", re;
  if (goog.labs.userAgent.platform.isWindows()) {
    re = /Windows (?:NT|Phone) ([0-9.]+)/;
    var match = re.exec(userAgentString);
    if (match) {
      version = match[1];
    } else {
      version = "0.0";
    }
  } else {
    if (goog.labs.userAgent.platform.isIos()) {
      re = /(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/;
      var match = re.exec(userAgentString);
      version = match && match[1].replace(/_/g, ".");
    } else {
      if (goog.labs.userAgent.platform.isMacintosh()) {
        re = /Mac OS X ([0-9_.]+)/;
        var match = re.exec(userAgentString);
        version = match ? match[1].replace(/_/g, ".") : "10";
      } else {
        if (goog.labs.userAgent.platform.isAndroid()) {
          re = /Android\s+([^\);]+)(\)|;)/;
          var match = re.exec(userAgentString);
          version = match && match[1];
        } else {
          if (goog.labs.userAgent.platform.isChromeOS()) {
            re = /(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/;
            var match = re.exec(userAgentString);
            version = match && match[1];
          }
        }
      }
    }
  }
  return version || "";
};
goog.labs.userAgent.platform.isVersionOrHigher = function(version) {
  return goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(), version) >= 0;
};
goog.provide("goog.userAgent");
goog.require("goog.labs.userAgent.browser");
goog.require("goog.labs.userAgent.engine");
goog.require("goog.labs.userAgent.platform");
goog.require("goog.labs.userAgent.util");
goog.require("goog.string");
goog.define("goog.userAgent.ASSUME_IE", false);
goog.define("goog.userAgent.ASSUME_EDGE", false);
goog.define("goog.userAgent.ASSUME_GECKO", false);
goog.define("goog.userAgent.ASSUME_WEBKIT", false);
goog.define("goog.userAgent.ASSUME_MOBILE_WEBKIT", false);
goog.define("goog.userAgent.ASSUME_OPERA", false);
goog.define("goog.userAgent.ASSUME_ANY_VERSION", false);
goog.userAgent.BROWSER_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_EDGE || goog.userAgent.ASSUME_GECKO || goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_OPERA;
goog.userAgent.getUserAgentString = function() {
  return goog.labs.userAgent.util.getUserAgent();
};
goog.userAgent.getNavigator = function() {
  return goog.global["navigator"] || null;
};
goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_OPERA : goog.labs.userAgent.browser.isOpera();
goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_IE : goog.labs.userAgent.browser.isIE();
goog.userAgent.EDGE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_EDGE : goog.labs.userAgent.engine.isEdge();
goog.userAgent.EDGE_OR_IE = goog.userAgent.EDGE || goog.userAgent.IE;
goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_GECKO : goog.labs.userAgent.engine.isGecko();
goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT : goog.labs.userAgent.engine.isWebKit();
goog.userAgent.isMobile_ = function() {
  return goog.userAgent.WEBKIT && goog.labs.userAgent.util.matchUserAgent("Mobile");
};
goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.isMobile_();
goog.userAgent.SAFARI = goog.userAgent.WEBKIT;
goog.userAgent.determinePlatform_ = function() {
  var navigator = goog.userAgent.getNavigator();
  return navigator && navigator.platform || "";
};
goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_();
goog.define("goog.userAgent.ASSUME_MAC", false);
goog.define("goog.userAgent.ASSUME_WINDOWS", false);
goog.define("goog.userAgent.ASSUME_LINUX", false);
goog.define("goog.userAgent.ASSUME_X11", false);
goog.define("goog.userAgent.ASSUME_ANDROID", false);
goog.define("goog.userAgent.ASSUME_IPHONE", false);
goog.define("goog.userAgent.ASSUME_IPAD", false);
goog.userAgent.PLATFORM_KNOWN_ = goog.userAgent.ASSUME_MAC || goog.userAgent.ASSUME_WINDOWS || goog.userAgent.ASSUME_LINUX || goog.userAgent.ASSUME_X11 || goog.userAgent.ASSUME_ANDROID || goog.userAgent.ASSUME_IPHONE || goog.userAgent.ASSUME_IPAD;
goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_MAC : goog.labs.userAgent.platform.isMacintosh();
goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_WINDOWS : goog.labs.userAgent.platform.isWindows();
goog.userAgent.isLegacyLinux_ = function() {
  return goog.labs.userAgent.platform.isLinux() || goog.labs.userAgent.platform.isChromeOS();
};
goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_LINUX : goog.userAgent.isLegacyLinux_();
goog.userAgent.isX11_ = function() {
  var navigator = goog.userAgent.getNavigator();
  return !!navigator && goog.string.contains(navigator["appVersion"] || "", "X11");
};
goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_X11 : goog.userAgent.isX11_();
goog.userAgent.ANDROID = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_ANDROID : goog.labs.userAgent.platform.isAndroid();
goog.userAgent.IPHONE = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPHONE : goog.labs.userAgent.platform.isIphone();
goog.userAgent.IPAD = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPAD : goog.labs.userAgent.platform.isIpad();
goog.userAgent.operaVersion_ = function() {
  var version = goog.global.opera.version;
  try {
    return version();
  } catch (e) {
    return version;
  }
};
goog.userAgent.determineVersion_ = function() {
  if (goog.userAgent.OPERA && goog.global["opera"]) {
    return goog.userAgent.operaVersion_();
  }
  var version = "";
  var arr = goog.userAgent.getVersionRegexResult_();
  if (arr) {
    version = arr ? arr[1] : "";
  }
  if (goog.userAgent.IE) {
    var docMode = goog.userAgent.getDocumentMode_();
    if (docMode > parseFloat(version)) {
      return String(docMode);
    }
  }
  return version;
};
goog.userAgent.getVersionRegexResult_ = function() {
  var userAgent = goog.userAgent.getUserAgentString();
  if (goog.userAgent.GECKO) {
    return /rv\:([^\);]+)(\)|;)/.exec(userAgent);
  }
  if (goog.userAgent.EDGE) {
    return /Edge\/([\d\.]+)/.exec(userAgent);
  }
  if (goog.userAgent.IE) {
    return /\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(userAgent);
  }
  if (goog.userAgent.WEBKIT) {
    return /WebKit\/(\S+)/.exec(userAgent);
  }
};
goog.userAgent.getDocumentMode_ = function() {
  var doc = goog.global["document"];
  return doc ? doc["documentMode"] : undefined;
};
goog.userAgent.VERSION = goog.userAgent.determineVersion_();
goog.userAgent.compare = function(v1, v2) {
  return goog.string.compareVersions(v1, v2);
};
goog.userAgent.isVersionOrHigherCache_ = {};
goog.userAgent.isVersionOrHigher = function(version) {
  return goog.userAgent.ASSUME_ANY_VERSION || goog.userAgent.isVersionOrHigherCache_[version] || (goog.userAgent.isVersionOrHigherCache_[version] = goog.string.compareVersions(goog.userAgent.VERSION, version) >= 0);
};
goog.userAgent.isVersion = goog.userAgent.isVersionOrHigher;
goog.userAgent.isDocumentModeOrHigher = function(documentMode) {
  return goog.userAgent.DOCUMENT_MODE >= documentMode;
};
goog.userAgent.isDocumentMode = goog.userAgent.isDocumentModeOrHigher;
goog.userAgent.DOCUMENT_MODE = function() {
  var doc = goog.global["document"];
  var mode = goog.userAgent.getDocumentMode_();
  if (!doc || !goog.userAgent.IE) {
    return undefined;
  }
  return mode || (doc["compatMode"] == "CSS1Compat" ? parseInt(goog.userAgent.VERSION, 10) : 5);
}();
goog.provide("goog.dom.BrowserFeature");
goog.require("goog.userAgent");
goog.dom.BrowserFeature = {CAN_ADD_NAME_OR_TYPE_ATTRIBUTES:!goog.userAgent.IE || goog.userAgent.isDocumentModeOrHigher(9), CAN_USE_CHILDREN_ATTRIBUTE:!goog.userAgent.GECKO && !goog.userAgent.IE || goog.userAgent.IE && goog.userAgent.isDocumentModeOrHigher(9) || goog.userAgent.GECKO && goog.userAgent.isVersionOrHigher("1.9.1"), CAN_USE_INNER_TEXT:goog.userAgent.IE && !goog.userAgent.isVersionOrHigher("9"), CAN_USE_PARENT_ELEMENT_PROPERTY:goog.userAgent.IE || goog.userAgent.OPERA || goog.userAgent.WEBKIT, 
INNER_HTML_NEEDS_SCOPED_ELEMENT:goog.userAgent.IE, LEGACY_IE_RANGES:goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9)};
goog.provide("goog.dom.TagName");
goog.dom.TagName = {A:"A", ABBR:"ABBR", ACRONYM:"ACRONYM", ADDRESS:"ADDRESS", APPLET:"APPLET", AREA:"AREA", ARTICLE:"ARTICLE", ASIDE:"ASIDE", AUDIO:"AUDIO", B:"B", BASE:"BASE", BASEFONT:"BASEFONT", BDI:"BDI", BDO:"BDO", BIG:"BIG", BLOCKQUOTE:"BLOCKQUOTE", BODY:"BODY", BR:"BR", BUTTON:"BUTTON", CANVAS:"CANVAS", CAPTION:"CAPTION", CENTER:"CENTER", CITE:"CITE", CODE:"CODE", COL:"COL", COLGROUP:"COLGROUP", COMMAND:"COMMAND", DATA:"DATA", DATALIST:"DATALIST", DD:"DD", DEL:"DEL", DETAILS:"DETAILS", DFN:"DFN", 
DIALOG:"DIALOG", DIR:"DIR", DIV:"DIV", DL:"DL", DT:"DT", EM:"EM", EMBED:"EMBED", FIELDSET:"FIELDSET", FIGCAPTION:"FIGCAPTION", FIGURE:"FIGURE", FONT:"FONT", FOOTER:"FOOTER", FORM:"FORM", FRAME:"FRAME", FRAMESET:"FRAMESET", H1:"H1", H2:"H2", H3:"H3", H4:"H4", H5:"H5", H6:"H6", HEAD:"HEAD", HEADER:"HEADER", HGROUP:"HGROUP", HR:"HR", HTML:"HTML", I:"I", IFRAME:"IFRAME", IMG:"IMG", INPUT:"INPUT", INS:"INS", ISINDEX:"ISINDEX", KBD:"KBD", KEYGEN:"KEYGEN", LABEL:"LABEL", LEGEND:"LEGEND", LI:"LI", LINK:"LINK", 
MAP:"MAP", MARK:"MARK", MATH:"MATH", MENU:"MENU", META:"META", METER:"METER", NAV:"NAV", NOFRAMES:"NOFRAMES", NOSCRIPT:"NOSCRIPT", OBJECT:"OBJECT", OL:"OL", OPTGROUP:"OPTGROUP", OPTION:"OPTION", OUTPUT:"OUTPUT", P:"P", PARAM:"PARAM", PRE:"PRE", PROGRESS:"PROGRESS", Q:"Q", RP:"RP", RT:"RT", RUBY:"RUBY", S:"S", SAMP:"SAMP", SCRIPT:"SCRIPT", SECTION:"SECTION", SELECT:"SELECT", SMALL:"SMALL", SOURCE:"SOURCE", SPAN:"SPAN", STRIKE:"STRIKE", STRONG:"STRONG", STYLE:"STYLE", SUB:"SUB", SUMMARY:"SUMMARY", 
SUP:"SUP", SVG:"SVG", TABLE:"TABLE", TBODY:"TBODY", TD:"TD", TEMPLATE:"TEMPLATE", TEXTAREA:"TEXTAREA", TFOOT:"TFOOT", TH:"TH", THEAD:"THEAD", TIME:"TIME", TITLE:"TITLE", TR:"TR", TRACK:"TRACK", TT:"TT", U:"U", UL:"UL", VAR:"VAR", VIDEO:"VIDEO", WBR:"WBR"};
goog.provide("goog.dom.tags");
goog.require("goog.object");
goog.dom.tags.VOID_TAGS_ = goog.object.createSet("area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr");
goog.dom.tags.isVoidTag = function(tagName) {
  return goog.dom.tags.VOID_TAGS_[tagName] === true;
};
goog.provide("goog.string.TypedString");
goog.string.TypedString = function() {
};
goog.string.TypedString.prototype.implementsGoogStringTypedString;
goog.string.TypedString.prototype.getTypedStringValue;
goog.provide("goog.string.Const");
goog.require("goog.asserts");
goog.require("goog.string.TypedString");
goog.string.Const = function() {
  this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ = "";
  this.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ = goog.string.Const.TYPE_MARKER_;
};
goog.string.Const.prototype.implementsGoogStringTypedString = true;
goog.string.Const.prototype.getTypedStringValue = function() {
  return this.stringConstValueWithSecurityContract__googStringSecurityPrivate_;
};
goog.string.Const.prototype.toString = function() {
  return "Const{" + this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ + "}";
};
goog.string.Const.unwrap = function(stringConst) {
  if (stringConst instanceof goog.string.Const && stringConst.constructor === goog.string.Const && stringConst.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ === goog.string.Const.TYPE_MARKER_) {
    return stringConst.stringConstValueWithSecurityContract__googStringSecurityPrivate_;
  } else {
    goog.asserts.fail("expected object of type Const, got '" + stringConst + "'");
    return "type_error:Const";
  }
};
goog.string.Const.from = function(s) {
  return goog.string.Const.create__googStringSecurityPrivate_(s);
};
goog.string.Const.TYPE_MARKER_ = {};
goog.string.Const.create__googStringSecurityPrivate_ = function(s) {
  var stringConst = new goog.string.Const;
  stringConst.stringConstValueWithSecurityContract__googStringSecurityPrivate_ = s;
  return stringConst;
};
goog.provide("goog.html.SafeStyle");
goog.require("goog.array");
goog.require("goog.asserts");
goog.require("goog.string");
goog.require("goog.string.Const");
goog.require("goog.string.TypedString");
goog.html.SafeStyle = function() {
  this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = "";
  this.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeStyle.prototype.implementsGoogStringTypedString = true;
goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeStyle.fromConstant = function(style) {
  var styleString = goog.string.Const.unwrap(style);
  if (styleString.length === 0) {
    return goog.html.SafeStyle.EMPTY;
  }
  goog.html.SafeStyle.checkStyle_(styleString);
  goog.asserts.assert(goog.string.endsWith(styleString, ";"), "Last character of style string is not ';': " + styleString);
  goog.asserts.assert(goog.string.contains(styleString, ":"), "Style string must contain at least one ':', to " + 'specify a "name: value" pair: ' + styleString);
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(styleString);
};
goog.html.SafeStyle.checkStyle_ = function(style) {
  goog.asserts.assert(!/[<>]/.test(style), "Forbidden characters in style string: " + style);
};
goog.html.SafeStyle.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeStyleWrappedValue_;
};
if (goog.DEBUG) {
  goog.html.SafeStyle.prototype.toString = function() {
    return "SafeStyle{" + this.privateDoNotAccessOrElseSafeStyleWrappedValue_ + "}";
  };
}
goog.html.SafeStyle.unwrap = function(safeStyle) {
  if (safeStyle instanceof goog.html.SafeStyle && safeStyle.constructor === goog.html.SafeStyle && safeStyle.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeStyle.privateDoNotAccessOrElseSafeStyleWrappedValue_;
  } else {
    goog.asserts.fail("expected object of type SafeStyle, got '" + safeStyle + "'");
    return "type_error:SafeStyle";
  }
};
goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse = function(style) {
  return (new goog.html.SafeStyle).initSecurityPrivateDoNotAccessOrElse_(style);
};
goog.html.SafeStyle.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(style) {
  this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = style;
  return this;
};
goog.html.SafeStyle.EMPTY = goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse("");
goog.html.SafeStyle.INNOCUOUS_STRING = "zClosurez";
goog.html.SafeStyle.PropertyMap;
goog.html.SafeStyle.create = function(map) {
  var style = "";
  for (var name in map) {
    if (!/^[-_a-zA-Z0-9]+$/.test(name)) {
      throw Error("Name allows only [-_a-zA-Z0-9], got: " + name);
    }
    var value = map[name];
    if (value == null) {
      continue;
    }
    if (value instanceof goog.string.Const) {
      value = goog.string.Const.unwrap(value);
      goog.asserts.assert(!/[{;}]/.test(value), "Value does not allow [{;}].");
    } else {
      if (!goog.html.SafeStyle.VALUE_RE_.test(value)) {
        goog.asserts.fail("String value allows only [-,.\"'%_!# a-zA-Z0-9], got: " + value);
        value = goog.html.SafeStyle.INNOCUOUS_STRING;
      } else {
        if (!goog.html.SafeStyle.hasBalancedQuotes_(value)) {
          goog.asserts.fail("String value requires balanced quotes, got: " + value);
          value = goog.html.SafeStyle.INNOCUOUS_STRING;
        }
      }
    }
    style += name + ":" + value + ";";
  }
  if (!style) {
    return goog.html.SafeStyle.EMPTY;
  }
  goog.html.SafeStyle.checkStyle_(style);
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style);
};
goog.html.SafeStyle.hasBalancedQuotes_ = function(value) {
  var outsideSingle = true;
  var outsideDouble = true;
  for (var i = 0;i < value.length;i++) {
    var c = value.charAt(i);
    if (c == "'" && outsideDouble) {
      outsideSingle = !outsideSingle;
    } else {
      if (c == '"' && outsideSingle) {
        outsideDouble = !outsideDouble;
      }
    }
  }
  return outsideSingle && outsideDouble;
};
goog.html.SafeStyle.VALUE_RE_ = /^[-,."'%_!# a-zA-Z0-9]+$/;
goog.html.SafeStyle.concat = function(var_args) {
  var style = "";
  var addArgument = function(argument) {
    if (goog.isArray(argument)) {
      goog.array.forEach(argument, addArgument);
    } else {
      style += goog.html.SafeStyle.unwrap(argument);
    }
  };
  goog.array.forEach(arguments, addArgument);
  if (!style) {
    return goog.html.SafeStyle.EMPTY;
  }
  return goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(style);
};
goog.provide("goog.html.SafeStyleSheet");
goog.require("goog.array");
goog.require("goog.asserts");
goog.require("goog.string");
goog.require("goog.string.Const");
goog.require("goog.string.TypedString");
goog.html.SafeStyleSheet = function() {
  this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = "";
  this.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeStyleSheet.prototype.implementsGoogStringTypedString = true;
goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeStyleSheet.concat = function(var_args) {
  var result = "";
  var addArgument = function(argument) {
    if (goog.isArray(argument)) {
      goog.array.forEach(argument, addArgument);
    } else {
      result += goog.html.SafeStyleSheet.unwrap(argument);
    }
  };
  goog.array.forEach(arguments, addArgument);
  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(result);
};
goog.html.SafeStyleSheet.fromConstant = function(styleSheet) {
  var styleSheetString = goog.string.Const.unwrap(styleSheet);
  if (styleSheetString.length === 0) {
    return goog.html.SafeStyleSheet.EMPTY;
  }
  goog.asserts.assert(!goog.string.contains(styleSheetString, "\x3c"), "Forbidden '\x3c' character in style sheet string: " + styleSheetString);
  return goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(styleSheetString);
};
goog.html.SafeStyleSheet.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;
};
if (goog.DEBUG) {
  goog.html.SafeStyleSheet.prototype.toString = function() {
    return "SafeStyleSheet{" + this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ + "}";
  };
}
goog.html.SafeStyleSheet.unwrap = function(safeStyleSheet) {
  if (safeStyleSheet instanceof goog.html.SafeStyleSheet && safeStyleSheet.constructor === goog.html.SafeStyleSheet && safeStyleSheet.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeStyleSheet.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;
  } else {
    goog.asserts.fail("expected object of type SafeStyleSheet, got '" + safeStyleSheet + "'");
    return "type_error:SafeStyleSheet";
  }
};
goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse = function(styleSheet) {
  return (new goog.html.SafeStyleSheet).initSecurityPrivateDoNotAccessOrElse_(styleSheet);
};
goog.html.SafeStyleSheet.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(styleSheet) {
  this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = styleSheet;
  return this;
};
goog.html.SafeStyleSheet.EMPTY = goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse("");
goog.provide("goog.fs.url");
goog.fs.url.createObjectUrl = function(blob) {
  return goog.fs.url.getUrlObject_().createObjectURL(blob);
};
goog.fs.url.revokeObjectUrl = function(url) {
  goog.fs.url.getUrlObject_().revokeObjectURL(url);
};
goog.fs.url.UrlObject_;
goog.fs.url.getUrlObject_ = function() {
  var urlObject = goog.fs.url.findUrlObject_();
  if (urlObject != null) {
    return urlObject;
  } else {
    throw Error("This browser doesn't seem to support blob URLs");
  }
};
goog.fs.url.findUrlObject_ = function() {
  if (goog.isDef(goog.global.URL) && goog.isDef(goog.global.URL.createObjectURL)) {
    return (goog.global.URL);
  } else {
    if (goog.isDef(goog.global.webkitURL) && goog.isDef(goog.global.webkitURL.createObjectURL)) {
      return (goog.global.webkitURL);
    } else {
      if (goog.isDef(goog.global.createObjectURL)) {
        return (goog.global);
      } else {
        return null;
      }
    }
  }
};
goog.fs.url.browserSupportsObjectUrls = function() {
  return goog.fs.url.findUrlObject_() != null;
};
goog.provide("goog.i18n.bidi");
goog.provide("goog.i18n.bidi.Dir");
goog.provide("goog.i18n.bidi.DirectionalString");
goog.provide("goog.i18n.bidi.Format");
goog.define("goog.i18n.bidi.FORCE_RTL", false);
goog.i18n.bidi.IS_RTL = goog.i18n.bidi.FORCE_RTL || (goog.LOCALE.substring(0, 2).toLowerCase() == "ar" || goog.LOCALE.substring(0, 2).toLowerCase() == "fa" || goog.LOCALE.substring(0, 2).toLowerCase() == "he" || goog.LOCALE.substring(0, 2).toLowerCase() == "iw" || goog.LOCALE.substring(0, 2).toLowerCase() == "ps" || goog.LOCALE.substring(0, 2).toLowerCase() == "sd" || goog.LOCALE.substring(0, 2).toLowerCase() == "ug" || goog.LOCALE.substring(0, 2).toLowerCase() == "ur" || goog.LOCALE.substring(0, 
2).toLowerCase() == "yi") && (goog.LOCALE.length == 2 || goog.LOCALE.substring(2, 3) == "-" || goog.LOCALE.substring(2, 3) == "_") || goog.LOCALE.length >= 3 && goog.LOCALE.substring(0, 3).toLowerCase() == "ckb" && (goog.LOCALE.length == 3 || goog.LOCALE.substring(3, 4) == "-" || goog.LOCALE.substring(3, 4) == "_");
goog.i18n.bidi.Format = {LRE:"\u202a", RLE:"\u202b", PDF:"\u202c", LRM:"\u200e", RLM:"\u200f"};
goog.i18n.bidi.Dir = {LTR:1, RTL:-1, NEUTRAL:0};
goog.i18n.bidi.RIGHT = "right";
goog.i18n.bidi.LEFT = "left";
goog.i18n.bidi.I18N_RIGHT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.LEFT : goog.i18n.bidi.RIGHT;
goog.i18n.bidi.I18N_LEFT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;
goog.i18n.bidi.toDir = function(givenDir, opt_noNeutral) {
  if (typeof givenDir == "number") {
    return givenDir > 0 ? goog.i18n.bidi.Dir.LTR : givenDir < 0 ? goog.i18n.bidi.Dir.RTL : opt_noNeutral ? null : goog.i18n.bidi.Dir.NEUTRAL;
  } else {
    if (givenDir == null) {
      return null;
    } else {
      return givenDir ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
    }
  }
};
goog.i18n.bidi.ltrChars_ = "A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff" + "\u200e\u2c00-\ufb1c\ufe00-\ufe6f\ufefd-\uffff";
goog.i18n.bidi.rtlChars_ = "\u0591-\u06ef\u06fa-\u07ff\u200f\ufb1d-\ufdff\ufe70-\ufefc";
goog.i18n.bidi.htmlSkipReg_ = /<[^>]*>|&[^;]+;/g;
goog.i18n.bidi.stripHtmlIfNeeded_ = function(str, opt_isStripNeeded) {
  return opt_isStripNeeded ? str.replace(goog.i18n.bidi.htmlSkipReg_, "") : str;
};
goog.i18n.bidi.rtlCharReg_ = new RegExp("[" + goog.i18n.bidi.rtlChars_ + "]");
goog.i18n.bidi.ltrCharReg_ = new RegExp("[" + goog.i18n.bidi.ltrChars_ + "]");
goog.i18n.bidi.hasAnyRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.hasRtlChar = goog.i18n.bidi.hasAnyRtl;
goog.i18n.bidi.hasAnyLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.ltrRe_ = new RegExp("^[" + goog.i18n.bidi.ltrChars_ + "]");
goog.i18n.bidi.rtlRe_ = new RegExp("^[" + goog.i18n.bidi.rtlChars_ + "]");
goog.i18n.bidi.isRtlChar = function(str) {
  return goog.i18n.bidi.rtlRe_.test(str);
};
goog.i18n.bidi.isLtrChar = function(str) {
  return goog.i18n.bidi.ltrRe_.test(str);
};
goog.i18n.bidi.isNeutralChar = function(str) {
  return !goog.i18n.bidi.isLtrChar(str) && !goog.i18n.bidi.isRtlChar(str);
};
goog.i18n.bidi.ltrDirCheckRe_ = new RegExp("^[^" + goog.i18n.bidi.rtlChars_ + "]*[" + goog.i18n.bidi.ltrChars_ + "]");
goog.i18n.bidi.rtlDirCheckRe_ = new RegExp("^[^" + goog.i18n.bidi.ltrChars_ + "]*[" + goog.i18n.bidi.rtlChars_ + "]");
goog.i18n.bidi.startsWithRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isRtlText = goog.i18n.bidi.startsWithRtl;
goog.i18n.bidi.startsWithLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isLtrText = goog.i18n.bidi.startsWithLtr;
goog.i18n.bidi.isRequiredLtrRe_ = /^http:\/\/.*/;
goog.i18n.bidi.isNeutralText = function(str, opt_isHtml) {
  str = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml);
  return goog.i18n.bidi.isRequiredLtrRe_.test(str) || !goog.i18n.bidi.hasAnyLtr(str) && !goog.i18n.bidi.hasAnyRtl(str);
};
goog.i18n.bidi.ltrExitDirCheckRe_ = new RegExp("[" + goog.i18n.bidi.ltrChars_ + "][^" + goog.i18n.bidi.rtlChars_ + "]*$");
goog.i18n.bidi.rtlExitDirCheckRe_ = new RegExp("[" + goog.i18n.bidi.rtlChars_ + "][^" + goog.i18n.bidi.ltrChars_ + "]*$");
goog.i18n.bidi.endsWithLtr = function(str, opt_isHtml) {
  return goog.i18n.bidi.ltrExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isLtrExitText = goog.i18n.bidi.endsWithLtr;
goog.i18n.bidi.endsWithRtl = function(str, opt_isHtml) {
  return goog.i18n.bidi.rtlExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
};
goog.i18n.bidi.isRtlExitText = goog.i18n.bidi.endsWithRtl;
goog.i18n.bidi.rtlLocalesRe_ = new RegExp("^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|" + ".*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))" + "(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)", "i");
goog.i18n.bidi.isRtlLanguage = function(lang) {
  return goog.i18n.bidi.rtlLocalesRe_.test(lang);
};
goog.i18n.bidi.bracketGuardHtmlRe_ = /(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(&lt;.*?(&gt;)+)/g;
goog.i18n.bidi.bracketGuardTextRe_ = /(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(<.*?>+)/g;
goog.i18n.bidi.guardBracketInHtml = function(s, opt_isRtlContext) {
  var useRtl = opt_isRtlContext === undefined ? goog.i18n.bidi.hasAnyRtl(s) : opt_isRtlContext;
  if (useRtl) {
    return s.replace(goog.i18n.bidi.bracketGuardHtmlRe_, "\x3cspan dir\x3drtl\x3e$\x26\x3c/span\x3e");
  }
  return s.replace(goog.i18n.bidi.bracketGuardHtmlRe_, "\x3cspan dir\x3dltr\x3e$\x26\x3c/span\x3e");
};
goog.i18n.bidi.guardBracketInText = function(s, opt_isRtlContext) {
  var useRtl = opt_isRtlContext === undefined ? goog.i18n.bidi.hasAnyRtl(s) : opt_isRtlContext;
  var mark = useRtl ? goog.i18n.bidi.Format.RLM : goog.i18n.bidi.Format.LRM;
  return s.replace(goog.i18n.bidi.bracketGuardTextRe_, mark + "$\x26" + mark);
};
goog.i18n.bidi.enforceRtlInHtml = function(html) {
  if (html.charAt(0) == "\x3c") {
    return html.replace(/<\w+/, "$\x26 dir\x3drtl");
  }
  return "\n\x3cspan dir\x3drtl\x3e" + html + "\x3c/span\x3e";
};
goog.i18n.bidi.enforceRtlInText = function(text) {
  return goog.i18n.bidi.Format.RLE + text + goog.i18n.bidi.Format.PDF;
};
goog.i18n.bidi.enforceLtrInHtml = function(html) {
  if (html.charAt(0) == "\x3c") {
    return html.replace(/<\w+/, "$\x26 dir\x3dltr");
  }
  return "\n\x3cspan dir\x3dltr\x3e" + html + "\x3c/span\x3e";
};
goog.i18n.bidi.enforceLtrInText = function(text) {
  return goog.i18n.bidi.Format.LRE + text + goog.i18n.bidi.Format.PDF;
};
goog.i18n.bidi.dimensionsRe_ = /:\s*([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)/g;
goog.i18n.bidi.leftRe_ = /left/gi;
goog.i18n.bidi.rightRe_ = /right/gi;
goog.i18n.bidi.tempRe_ = /%%%%/g;
goog.i18n.bidi.mirrorCSS = function(cssStr) {
  return cssStr.replace(goog.i18n.bidi.dimensionsRe_, ":$1 $4 $3 $2").replace(goog.i18n.bidi.leftRe_, "%%%%").replace(goog.i18n.bidi.rightRe_, goog.i18n.bidi.LEFT).replace(goog.i18n.bidi.tempRe_, goog.i18n.bidi.RIGHT);
};
goog.i18n.bidi.doubleQuoteSubstituteRe_ = /([\u0591-\u05f2])"/g;
goog.i18n.bidi.singleQuoteSubstituteRe_ = /([\u0591-\u05f2])'/g;
goog.i18n.bidi.normalizeHebrewQuote = function(str) {
  return str.replace(goog.i18n.bidi.doubleQuoteSubstituteRe_, "$1\u05f4").replace(goog.i18n.bidi.singleQuoteSubstituteRe_, "$1\u05f3");
};
goog.i18n.bidi.wordSeparatorRe_ = /\s+/;
goog.i18n.bidi.hasNumeralsRe_ = /[\d\u06f0-\u06f9]/;
goog.i18n.bidi.rtlDetectionThreshold_ = .4;
goog.i18n.bidi.estimateDirection = function(str, opt_isHtml) {
  var rtlCount = 0;
  var totalCount = 0;
  var hasWeaklyLtr = false;
  var tokens = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml).split(goog.i18n.bidi.wordSeparatorRe_);
  for (var i = 0;i < tokens.length;i++) {
    var token = tokens[i];
    if (goog.i18n.bidi.startsWithRtl(token)) {
      rtlCount++;
      totalCount++;
    } else {
      if (goog.i18n.bidi.isRequiredLtrRe_.test(token)) {
        hasWeaklyLtr = true;
      } else {
        if (goog.i18n.bidi.hasAnyLtr(token)) {
          totalCount++;
        } else {
          if (goog.i18n.bidi.hasNumeralsRe_.test(token)) {
            hasWeaklyLtr = true;
          }
        }
      }
    }
  }
  return totalCount == 0 ? hasWeaklyLtr ? goog.i18n.bidi.Dir.LTR : goog.i18n.bidi.Dir.NEUTRAL : rtlCount / totalCount > goog.i18n.bidi.rtlDetectionThreshold_ ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
};
goog.i18n.bidi.detectRtlDirectionality = function(str, opt_isHtml) {
  return goog.i18n.bidi.estimateDirection(str, opt_isHtml) == goog.i18n.bidi.Dir.RTL;
};
goog.i18n.bidi.setElementDirAndAlign = function(element, dir) {
  if (element) {
    dir = goog.i18n.bidi.toDir(dir);
    if (dir) {
      element.style.textAlign = dir == goog.i18n.bidi.Dir.RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;
      element.dir = dir == goog.i18n.bidi.Dir.RTL ? "rtl" : "ltr";
    }
  }
};
goog.i18n.bidi.setElementDirByTextDirectionality = function(element, text) {
  switch(goog.i18n.bidi.estimateDirection(text)) {
    case goog.i18n.bidi.Dir.LTR:
      element.dir = "ltr";
      break;
    case goog.i18n.bidi.Dir.RTL:
      element.dir = "rtl";
      break;
    default:
      element.removeAttribute("dir");
  }
};
goog.i18n.bidi.DirectionalString = function() {
};
goog.i18n.bidi.DirectionalString.prototype.implementsGoogI18nBidiDirectionalString;
goog.i18n.bidi.DirectionalString.prototype.getDirection;
goog.provide("goog.html.SafeUrl");
goog.require("goog.asserts");
goog.require("goog.fs.url");
goog.require("goog.i18n.bidi.Dir");
goog.require("goog.i18n.bidi.DirectionalString");
goog.require("goog.string.Const");
goog.require("goog.string.TypedString");
goog.html.SafeUrl = function() {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = "";
  this.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.SafeUrl.INNOCUOUS_STRING = "about:invalid#zClosurez";
goog.html.SafeUrl.prototype.implementsGoogStringTypedString = true;
goog.html.SafeUrl.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
};
goog.html.SafeUrl.prototype.implementsGoogI18nBidiDirectionalString = true;
goog.html.SafeUrl.prototype.getDirection = function() {
  return goog.i18n.bidi.Dir.LTR;
};
if (goog.DEBUG) {
  goog.html.SafeUrl.prototype.toString = function() {
    return "SafeUrl{" + this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ + "}";
  };
}
goog.html.SafeUrl.unwrap = function(safeUrl) {
  if (safeUrl instanceof goog.html.SafeUrl && safeUrl.constructor === goog.html.SafeUrl && safeUrl.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeUrl.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
  } else {
    goog.asserts.fail("expected object of type SafeUrl, got '" + safeUrl + "'");
    return "type_error:SafeUrl";
  }
};
goog.html.SafeUrl.fromConstant = function(url) {
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(url));
};
goog.html.SAFE_MIME_TYPE_PATTERN_ = /^(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm))$/i;
goog.html.SafeUrl.fromBlob = function(blob) {
  var url = goog.html.SAFE_MIME_TYPE_PATTERN_.test(blob.type) ? goog.fs.url.createObjectUrl(blob) : goog.html.SafeUrl.INNOCUOUS_STRING;
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.DATA_URL_PATTERN_ = /^data:([^;,]*);base64,[a-z0-9+\/]+=*$/i;
goog.html.SafeUrl.fromDataUrl = function(dataUrl) {
  var match = dataUrl.match(goog.html.DATA_URL_PATTERN_);
  var valid = match && goog.html.SAFE_MIME_TYPE_PATTERN_.test(match[1]);
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(valid ? dataUrl : goog.html.SafeUrl.INNOCUOUS_STRING);
};
goog.html.SAFE_URL_PATTERN_ = /^(?:(?:https?|mailto|ftp):|[^&:/?#]*(?:[/?#]|$))/i;
goog.html.SafeUrl.sanitize = function(url) {
  if (url instanceof goog.html.SafeUrl) {
    return url;
  } else {
    if (url.implementsGoogStringTypedString) {
      url = url.getTypedStringValue();
    } else {
      url = String(url);
    }
  }
  if (!goog.html.SAFE_URL_PATTERN_.test(url)) {
    url = goog.html.SafeUrl.INNOCUOUS_STRING;
  }
  return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(url);
};
goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse = function(url) {
  var safeUrl = new goog.html.SafeUrl;
  safeUrl.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = url;
  return safeUrl;
};
goog.provide("goog.html.TrustedResourceUrl");
goog.require("goog.asserts");
goog.require("goog.i18n.bidi.Dir");
goog.require("goog.i18n.bidi.DirectionalString");
goog.require("goog.string.Const");
goog.require("goog.string.TypedString");
goog.html.TrustedResourceUrl = function() {
  this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ = "";
  this.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
};
goog.html.TrustedResourceUrl.prototype.implementsGoogStringTypedString = true;
goog.html.TrustedResourceUrl.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_;
};
goog.html.TrustedResourceUrl.prototype.implementsGoogI18nBidiDirectionalString = true;
goog.html.TrustedResourceUrl.prototype.getDirection = function() {
  return goog.i18n.bidi.Dir.LTR;
};
if (goog.DEBUG) {
  goog.html.TrustedResourceUrl.prototype.toString = function() {
    return "TrustedResourceUrl{" + this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ + "}";
  };
}
goog.html.TrustedResourceUrl.unwrap = function(trustedResourceUrl) {
  if (trustedResourceUrl instanceof goog.html.TrustedResourceUrl && trustedResourceUrl.constructor === goog.html.TrustedResourceUrl && trustedResourceUrl.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return trustedResourceUrl.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_;
  } else {
    goog.asserts.fail("expected object of type TrustedResourceUrl, got '" + trustedResourceUrl + "'");
    return "type_error:TrustedResourceUrl";
  }
};
goog.html.TrustedResourceUrl.fromConstant = function(url) {
  return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(url));
};
goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse = function(url) {
  var trustedResourceUrl = new goog.html.TrustedResourceUrl;
  trustedResourceUrl.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ = url;
  return trustedResourceUrl;
};
goog.provide("goog.html.SafeHtml");
goog.require("goog.array");
goog.require("goog.asserts");
goog.require("goog.dom.TagName");
goog.require("goog.dom.tags");
goog.require("goog.html.SafeStyle");
goog.require("goog.html.SafeStyleSheet");
goog.require("goog.html.SafeUrl");
goog.require("goog.html.TrustedResourceUrl");
goog.require("goog.i18n.bidi.Dir");
goog.require("goog.i18n.bidi.DirectionalString");
goog.require("goog.object");
goog.require("goog.string");
goog.require("goog.string.Const");
goog.require("goog.string.TypedString");
goog.html.SafeHtml = function() {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = "";
  this.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  this.dir_ = null;
};
goog.html.SafeHtml.prototype.implementsGoogI18nBidiDirectionalString = true;
goog.html.SafeHtml.prototype.getDirection = function() {
  return this.dir_;
};
goog.html.SafeHtml.prototype.implementsGoogStringTypedString = true;
goog.html.SafeHtml.prototype.getTypedStringValue = function() {
  return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
};
if (goog.DEBUG) {
  goog.html.SafeHtml.prototype.toString = function() {
    return "SafeHtml{" + this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ + "}";
  };
}
goog.html.SafeHtml.unwrap = function(safeHtml) {
  if (safeHtml instanceof goog.html.SafeHtml && safeHtml.constructor === goog.html.SafeHtml && safeHtml.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_) {
    return safeHtml.privateDoNotAccessOrElseSafeHtmlWrappedValue_;
  } else {
    goog.asserts.fail("expected object of type SafeHtml, got '" + safeHtml + "'");
    return "type_error:SafeHtml";
  }
};
goog.html.SafeHtml.TextOrHtml_;
goog.html.SafeHtml.htmlEscape = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var dir = null;
  if (textOrHtml.implementsGoogI18nBidiDirectionalString) {
    dir = textOrHtml.getDirection();
  }
  var textAsString;
  if (textOrHtml.implementsGoogStringTypedString) {
    textAsString = textOrHtml.getTypedStringValue();
  } else {
    textAsString = String(textOrHtml);
  }
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.htmlEscape(textAsString), dir);
};
goog.html.SafeHtml.htmlEscapePreservingNewlines = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var html = goog.html.SafeHtml.htmlEscape(textOrHtml);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.newLineToBr(goog.html.SafeHtml.unwrap(html)), html.getDirection());
};
goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces = function(textOrHtml) {
  if (textOrHtml instanceof goog.html.SafeHtml) {
    return textOrHtml;
  }
  var html = goog.html.SafeHtml.htmlEscape(textOrHtml);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.whitespaceEscape(goog.html.SafeHtml.unwrap(html)), html.getDirection());
};
goog.html.SafeHtml.from = goog.html.SafeHtml.htmlEscape;
goog.html.SafeHtml.VALID_NAMES_IN_TAG_ = /^[a-zA-Z0-9-]+$/;
goog.html.SafeHtml.URL_ATTRIBUTES_ = goog.object.createSet("action", "cite", "data", "formaction", "href", "manifest", "poster", "src");
goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_ = goog.object.createSet(goog.dom.TagName.EMBED, goog.dom.TagName.IFRAME, goog.dom.TagName.LINK, goog.dom.TagName.OBJECT, goog.dom.TagName.SCRIPT, goog.dom.TagName.STYLE, goog.dom.TagName.TEMPLATE);
goog.html.SafeHtml.AttributeValue_;
goog.html.SafeHtml.create = function(tagName, opt_attributes, opt_content) {
  if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(tagName)) {
    throw Error("Invalid tag name \x3c" + tagName + "\x3e.");
  }
  if (tagName.toUpperCase() in goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_) {
    throw Error("Tag name \x3c" + tagName + "\x3e is not allowed for SafeHtml.");
  }
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(tagName, opt_attributes, opt_content);
};
goog.html.SafeHtml.createIframe = function(opt_src, opt_srcdoc, opt_attributes, opt_content) {
  var fixedAttributes = {};
  fixedAttributes["src"] = opt_src || null;
  fixedAttributes["srcdoc"] = opt_srcdoc || null;
  var defaultAttributes = {"sandbox":""};
  var attributes = goog.html.SafeHtml.combineAttributes(fixedAttributes, defaultAttributes, opt_attributes);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("iframe", attributes, opt_content);
};
goog.html.SafeHtml.createStyle = function(styleSheet, opt_attributes) {
  var fixedAttributes = {"type":"text/css"};
  var defaultAttributes = {};
  var attributes = goog.html.SafeHtml.combineAttributes(fixedAttributes, defaultAttributes, opt_attributes);
  var content = "";
  styleSheet = goog.array.concat(styleSheet);
  for (var i = 0;i < styleSheet.length;i++) {
    content += goog.html.SafeStyleSheet.unwrap(styleSheet[i]);
  }
  var htmlContent = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content, goog.i18n.bidi.Dir.NEUTRAL);
  return goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("style", attributes, htmlContent);
};
goog.html.SafeHtml.getAttrNameAndValue_ = function(tagName, name, value) {
  if (value instanceof goog.string.Const) {
    value = goog.string.Const.unwrap(value);
  } else {
    if (name.toLowerCase() == "style") {
      value = goog.html.SafeHtml.getStyleValue_(value);
    } else {
      if (/^on/i.test(name)) {
        throw Error('Attribute "' + name + '" requires goog.string.Const value, "' + value + '" given.');
      } else {
        if (name.toLowerCase() in goog.html.SafeHtml.URL_ATTRIBUTES_) {
          if (value instanceof goog.html.TrustedResourceUrl) {
            value = goog.html.TrustedResourceUrl.unwrap(value);
          } else {
            if (value instanceof goog.html.SafeUrl) {
              value = goog.html.SafeUrl.unwrap(value);
            } else {
              if (goog.isString(value)) {
                value = goog.html.SafeUrl.sanitize(value).getTypedStringValue();
              } else {
                throw Error('Attribute "' + name + '" on tag "' + tagName + '" requires goog.html.SafeUrl, goog.string.Const, or string,' + ' value "' + value + '" given.');
              }
            }
          }
        }
      }
    }
  }
  if (value.implementsGoogStringTypedString) {
    value = value.getTypedStringValue();
  }
  goog.asserts.assert(goog.isString(value) || goog.isNumber(value), "String or number value expected, got " + typeof value + " with value: " + value);
  return name + '\x3d"' + goog.string.htmlEscape(String(value)) + '"';
};
goog.html.SafeHtml.getStyleValue_ = function(value) {
  if (!goog.isObject(value)) {
    throw Error('The "style" attribute requires goog.html.SafeStyle or map ' + "of style properties, " + typeof value + " given: " + value);
  }
  if (!(value instanceof goog.html.SafeStyle)) {
    value = goog.html.SafeStyle.create(value);
  }
  return goog.html.SafeStyle.unwrap(value);
};
goog.html.SafeHtml.createWithDir = function(dir, tagName, opt_attributes, opt_content) {
  var html = goog.html.SafeHtml.create(tagName, opt_attributes, opt_content);
  html.dir_ = dir;
  return html;
};
goog.html.SafeHtml.concat = function(var_args) {
  var dir = goog.i18n.bidi.Dir.NEUTRAL;
  var content = "";
  var addArgument = function(argument) {
    if (goog.isArray(argument)) {
      goog.array.forEach(argument, addArgument);
    } else {
      var html = goog.html.SafeHtml.htmlEscape(argument);
      content += goog.html.SafeHtml.unwrap(html);
      var htmlDir = html.getDirection();
      if (dir == goog.i18n.bidi.Dir.NEUTRAL) {
        dir = htmlDir;
      } else {
        if (htmlDir != goog.i18n.bidi.Dir.NEUTRAL && dir != htmlDir) {
          dir = null;
        }
      }
    }
  };
  goog.array.forEach(arguments, addArgument);
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(content, dir);
};
goog.html.SafeHtml.concatWithDir = function(dir, var_args) {
  var html = goog.html.SafeHtml.concat(goog.array.slice(arguments, 1));
  html.dir_ = dir;
  return html;
};
goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {};
goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse = function(html, dir) {
  return (new goog.html.SafeHtml).initSecurityPrivateDoNotAccessOrElse_(html, dir);
};
goog.html.SafeHtml.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(html, dir) {
  this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = html;
  this.dir_ = dir;
  return this;
};
goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse = function(tagName, opt_attributes, opt_content) {
  var dir = null;
  var result = "\x3c" + tagName;
  if (opt_attributes) {
    for (var name in opt_attributes) {
      if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(name)) {
        throw Error('Invalid attribute name "' + name + '".');
      }
      var value = opt_attributes[name];
      if (!goog.isDefAndNotNull(value)) {
        continue;
      }
      result += " " + goog.html.SafeHtml.getAttrNameAndValue_(tagName, name, value);
    }
  }
  var content = opt_content;
  if (!goog.isDefAndNotNull(content)) {
    content = [];
  } else {
    if (!goog.isArray(content)) {
      content = [content];
    }
  }
  if (goog.dom.tags.isVoidTag(tagName.toLowerCase())) {
    goog.asserts.assert(!content.length, "Void tag \x3c" + tagName + "\x3e does not allow content.");
    result += "\x3e";
  } else {
    var html = goog.html.SafeHtml.concat(content);
    result += "\x3e" + goog.html.SafeHtml.unwrap(html) + "\x3c/" + tagName + "\x3e";
    dir = html.getDirection();
  }
  var dirAttribute = opt_attributes && opt_attributes["dir"];
  if (dirAttribute) {
    if (/^(ltr|rtl|auto)$/i.test(dirAttribute)) {
      dir = goog.i18n.bidi.Dir.NEUTRAL;
    } else {
      dir = null;
    }
  }
  return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(result, dir);
};
goog.html.SafeHtml.combineAttributes = function(fixedAttributes, defaultAttributes, opt_attributes) {
  var combinedAttributes = {};
  var name;
  for (name in fixedAttributes) {
    goog.asserts.assert(name.toLowerCase() == name, "Must be lower case");
    combinedAttributes[name] = fixedAttributes[name];
  }
  for (name in defaultAttributes) {
    goog.asserts.assert(name.toLowerCase() == name, "Must be lower case");
    combinedAttributes[name] = defaultAttributes[name];
  }
  for (name in opt_attributes) {
    var nameLower = name.toLowerCase();
    if (nameLower in fixedAttributes) {
      throw Error('Cannot override "' + nameLower + '" attribute, got "' + name + '" with value "' + opt_attributes[name] + '"');
    }
    if (nameLower in defaultAttributes) {
      delete combinedAttributes[nameLower];
    }
    combinedAttributes[name] = opt_attributes[name];
  }
  return combinedAttributes;
};
goog.html.SafeHtml.DOCTYPE_HTML = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("\x3c!DOCTYPE html\x3e", goog.i18n.bidi.Dir.NEUTRAL);
goog.html.SafeHtml.EMPTY = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("", goog.i18n.bidi.Dir.NEUTRAL);
goog.provide("goog.dom.safe");
goog.provide("goog.dom.safe.InsertAdjacentHtmlPosition");
goog.require("goog.asserts");
goog.require("goog.html.SafeHtml");
goog.require("goog.html.SafeUrl");
goog.require("goog.html.TrustedResourceUrl");
goog.require("goog.string");
goog.require("goog.string.Const");
goog.dom.safe.InsertAdjacentHtmlPosition = {AFTERBEGIN:"afterbegin", AFTEREND:"afterend", BEFOREBEGIN:"beforebegin", BEFOREEND:"beforeend"};
goog.dom.safe.insertAdjacentHtml = function(node, position, html) {
  node.insertAdjacentHTML(position, goog.html.SafeHtml.unwrap(html));
};
goog.dom.safe.setInnerHtml = function(elem, html) {
  elem.innerHTML = goog.html.SafeHtml.unwrap(html);
};
goog.dom.safe.setOuterHtml = function(elem, html) {
  elem.outerHTML = goog.html.SafeHtml.unwrap(html);
};
goog.dom.safe.documentWrite = function(doc, html) {
  doc.write(goog.html.SafeHtml.unwrap(html));
};
goog.dom.safe.setAnchorHref = function(anchor, url) {
  var safeUrl;
  if (url instanceof goog.html.SafeUrl) {
    safeUrl = url;
  } else {
    safeUrl = goog.html.SafeUrl.sanitize(url);
  }
  anchor.href = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.setEmbedSrc = function(embed, url) {
  embed.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setFrameSrc = function(frame, url) {
  frame.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setIframeSrc = function(iframe, url) {
  iframe.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setLinkHrefAndRel = function(link, url, rel) {
  link.rel = rel;
  if (goog.string.caseInsensitiveContains(rel, "stylesheet")) {
    goog.asserts.assert(url instanceof goog.html.TrustedResourceUrl, 'URL must be TrustedResourceUrl because "rel" contains "stylesheet"');
    link.href = goog.html.TrustedResourceUrl.unwrap(url);
  } else {
    if (url instanceof goog.html.TrustedResourceUrl) {
      link.href = goog.html.TrustedResourceUrl.unwrap(url);
    } else {
      if (url instanceof goog.html.SafeUrl) {
        link.href = goog.html.SafeUrl.unwrap(url);
      } else {
        link.href = goog.html.SafeUrl.sanitize(url).getTypedStringValue();
      }
    }
  }
};
goog.dom.safe.setObjectData = function(object, url) {
  object.data = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setScriptSrc = function(script, url) {
  script.src = goog.html.TrustedResourceUrl.unwrap(url);
};
goog.dom.safe.setLocationHref = function(loc, url) {
  var safeUrl;
  if (url instanceof goog.html.SafeUrl) {
    safeUrl = url;
  } else {
    safeUrl = goog.html.SafeUrl.sanitize(url);
  }
  loc.href = goog.html.SafeUrl.unwrap(safeUrl);
};
goog.dom.safe.openInWindow = function(url, opt_openerWin, opt_name, opt_specs, opt_replace) {
  var safeUrl;
  if (url instanceof goog.html.SafeUrl) {
    safeUrl = url;
  } else {
    safeUrl = goog.html.SafeUrl.sanitize(url);
  }
  var win = opt_openerWin || window;
  return win.open(goog.html.SafeUrl.unwrap(safeUrl), opt_name ? goog.string.Const.unwrap(opt_name) : "", opt_specs, opt_replace);
};
goog.provide("goog.math");
goog.require("goog.array");
goog.require("goog.asserts");
goog.math.randomInt = function(a) {
  return Math.floor(Math.random() * a);
};
goog.math.uniformRandom = function(a, b) {
  return a + Math.random() * (b - a);
};
goog.math.clamp = function(value, min, max) {
  return Math.min(Math.max(value, min), max);
};
goog.math.modulo = function(a, b) {
  var r = a % b;
  return r * b < 0 ? r + b : r;
};
goog.math.lerp = function(a, b, x) {
  return a + x * (b - a);
};
goog.math.nearlyEquals = function(a, b, opt_tolerance) {
  return Math.abs(a - b) <= (opt_tolerance || 1E-6);
};
goog.math.standardAngle = function(angle) {
  return goog.math.modulo(angle, 360);
};
goog.math.standardAngleInRadians = function(angle) {
  return goog.math.modulo(angle, 2 * Math.PI);
};
goog.math.toRadians = function(angleDegrees) {
  return angleDegrees * Math.PI / 180;
};
goog.math.toDegrees = function(angleRadians) {
  return angleRadians * 180 / Math.PI;
};
goog.math.angleDx = function(degrees, radius) {
  return radius * Math.cos(goog.math.toRadians(degrees));
};
goog.math.angleDy = function(degrees, radius) {
  return radius * Math.sin(goog.math.toRadians(degrees));
};
goog.math.angle = function(x1, y1, x2, y2) {
  return goog.math.standardAngle(goog.math.toDegrees(Math.atan2(y2 - y1, x2 - x1)));
};
goog.math.angleDifference = function(startAngle, endAngle) {
  var d = goog.math.standardAngle(endAngle) - goog.math.standardAngle(startAngle);
  if (d > 180) {
    d = d - 360;
  } else {
    if (d <= -180) {
      d = 360 + d;
    }
  }
  return d;
};
goog.math.sign = Math.sign || function(x) {
  if (x > 0) {
    return 1;
  }
  if (x < 0) {
    return -1;
  }
  return x;
};
goog.math.longestCommonSubsequence = function(array1, array2, opt_compareFn, opt_collectorFn) {
  var compare = opt_compareFn || function(a, b) {
    return a == b;
  };
  var collect = opt_collectorFn || function(i1, i2) {
    return array1[i1];
  };
  var length1 = array1.length;
  var length2 = array2.length;
  var arr = [];
  for (var i = 0;i < length1 + 1;i++) {
    arr[i] = [];
    arr[i][0] = 0;
  }
  for (var j = 0;j < length2 + 1;j++) {
    arr[0][j] = 0;
  }
  for (i = 1;i <= length1;i++) {
    for (j = 1;j <= length2;j++) {
      if (compare(array1[i - 1], array2[j - 1])) {
        arr[i][j] = arr[i - 1][j - 1] + 1;
      } else {
        arr[i][j] = Math.max(arr[i - 1][j], arr[i][j - 1]);
      }
    }
  }
  var result = [];
  var i = length1, j = length2;
  while (i > 0 && j > 0) {
    if (compare(array1[i - 1], array2[j - 1])) {
      result.unshift(collect(i - 1, j - 1));
      i--;
      j--;
    } else {
      if (arr[i - 1][j] > arr[i][j - 1]) {
        i--;
      } else {
        j--;
      }
    }
  }
  return result;
};
goog.math.sum = function(var_args) {
  return (goog.array.reduce(arguments, function(sum, value) {
    return sum + value;
  }, 0));
};
goog.math.average = function(var_args) {
  return goog.math.sum.apply(null, arguments) / arguments.length;
};
goog.math.sampleVariance = function(var_args) {
  var sampleSize = arguments.length;
  if (sampleSize < 2) {
    return 0;
  }
  var mean = goog.math.average.apply(null, arguments);
  var variance = goog.math.sum.apply(null, goog.array.map(arguments, function(val) {
    return Math.pow(val - mean, 2);
  })) / (sampleSize - 1);
  return variance;
};
goog.math.standardDeviation = function(var_args) {
  return Math.sqrt(goog.math.sampleVariance.apply(null, arguments));
};
goog.math.isInt = function(num) {
  return isFinite(num) && num % 1 == 0;
};
goog.math.isFiniteNumber = function(num) {
  return isFinite(num) && !isNaN(num);
};
goog.math.isNegativeZero = function(num) {
  return num == 0 && 1 / num < 0;
};
goog.math.log10Floor = function(num) {
  if (num > 0) {
    var x = Math.round(Math.log(num) * Math.LOG10E);
    return x - (parseFloat("1e" + x) > num ? 1 : 0);
  }
  return num == 0 ? -Infinity : NaN;
};
goog.math.safeFloor = function(num, opt_epsilon) {
  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon > 0);
  return Math.floor(num + (opt_epsilon || 2E-15));
};
goog.math.safeCeil = function(num, opt_epsilon) {
  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon > 0);
  return Math.ceil(num - (opt_epsilon || 2E-15));
};
goog.provide("goog.math.Coordinate");
goog.require("goog.math");
goog.math.Coordinate = function(opt_x, opt_y) {
  this.x = goog.isDef(opt_x) ? opt_x : 0;
  this.y = goog.isDef(opt_y) ? opt_y : 0;
};
goog.math.Coordinate.prototype.clone = function() {
  return new goog.math.Coordinate(this.x, this.y);
};
if (goog.DEBUG) {
  goog.math.Coordinate.prototype.toString = function() {
    return "(" + this.x + ", " + this.y + ")";
  };
}
goog.math.Coordinate.equals = function(a, b) {
  if (a == b) {
    return true;
  }
  if (!a || !b) {
    return false;
  }
  return a.x == b.x && a.y == b.y;
};
goog.math.Coordinate.distance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return Math.sqrt(dx * dx + dy * dy);
};
goog.math.Coordinate.magnitude = function(a) {
  return Math.sqrt(a.x * a.x + a.y * a.y);
};
goog.math.Coordinate.azimuth = function(a) {
  return goog.math.angle(0, 0, a.x, a.y);
};
goog.math.Coordinate.squaredDistance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return dx * dx + dy * dy;
};
goog.math.Coordinate.difference = function(a, b) {
  return new goog.math.Coordinate(a.x - b.x, a.y - b.y);
};
goog.math.Coordinate.sum = function(a, b) {
  return new goog.math.Coordinate(a.x + b.x, a.y + b.y);
};
goog.math.Coordinate.prototype.ceil = function() {
  this.x = Math.ceil(this.x);
  this.y = Math.ceil(this.y);
  return this;
};
goog.math.Coordinate.prototype.floor = function() {
  this.x = Math.floor(this.x);
  this.y = Math.floor(this.y);
  return this;
};
goog.math.Coordinate.prototype.round = function() {
  this.x = Math.round(this.x);
  this.y = Math.round(this.y);
  return this;
};
goog.math.Coordinate.prototype.translate = function(tx, opt_ty) {
  if (tx instanceof goog.math.Coordinate) {
    this.x += tx.x;
    this.y += tx.y;
  } else {
    this.x += tx;
    if (goog.isNumber(opt_ty)) {
      this.y += opt_ty;
    }
  }
  return this;
};
goog.math.Coordinate.prototype.scale = function(sx, opt_sy) {
  var sy = goog.isNumber(opt_sy) ? opt_sy : sx;
  this.x *= sx;
  this.y *= sy;
  return this;
};
goog.math.Coordinate.prototype.rotateRadians = function(radians, opt_center) {
  var center = opt_center || new goog.math.Coordinate(0, 0);
  var x = this.x;
  var y = this.y;
  var cos = Math.cos(radians);
  var sin = Math.sin(radians);
  this.x = (x - center.x) * cos - (y - center.y) * sin + center.x;
  this.y = (x - center.x) * sin + (y - center.y) * cos + center.y;
};
goog.math.Coordinate.prototype.rotateDegrees = function(degrees, opt_center) {
  this.rotateRadians(goog.math.toRadians(degrees), opt_center);
};
goog.provide("goog.math.Size");
goog.math.Size = function(width, height) {
  this.width = width;
  this.height = height;
};
goog.math.Size.equals = function(a, b) {
  if (a == b) {
    return true;
  }
  if (!a || !b) {
    return false;
  }
  return a.width == b.width && a.height == b.height;
};
goog.math.Size.prototype.clone = function() {
  return new goog.math.Size(this.width, this.height);
};
if (goog.DEBUG) {
  goog.math.Size.prototype.toString = function() {
    return "(" + this.width + " x " + this.height + ")";
  };
}
goog.math.Size.prototype.getLongest = function() {
  return Math.max(this.width, this.height);
};
goog.math.Size.prototype.getShortest = function() {
  return Math.min(this.width, this.height);
};
goog.math.Size.prototype.area = function() {
  return this.width * this.height;
};
goog.math.Size.prototype.perimeter = function() {
  return (this.width + this.height) * 2;
};
goog.math.Size.prototype.aspectRatio = function() {
  return this.width / this.height;
};
goog.math.Size.prototype.isEmpty = function() {
  return !this.area();
};
goog.math.Size.prototype.ceil = function() {
  this.width = Math.ceil(this.width);
  this.height = Math.ceil(this.height);
  return this;
};
goog.math.Size.prototype.fitsInside = function(target) {
  return this.width <= target.width && this.height <= target.height;
};
goog.math.Size.prototype.floor = function() {
  this.width = Math.floor(this.width);
  this.height = Math.floor(this.height);
  return this;
};
goog.math.Size.prototype.round = function() {
  this.width = Math.round(this.width);
  this.height = Math.round(this.height);
  return this;
};
goog.math.Size.prototype.scale = function(sx, opt_sy) {
  var sy = goog.isNumber(opt_sy) ? opt_sy : sx;
  this.width *= sx;
  this.height *= sy;
  return this;
};
goog.math.Size.prototype.scaleToCover = function(target) {
  var s = this.aspectRatio() <= target.aspectRatio() ? target.width / this.width : target.height / this.height;
  return this.scale(s);
};
goog.math.Size.prototype.scaleToFit = function(target) {
  var s = this.aspectRatio() > target.aspectRatio() ? target.width / this.width : target.height / this.height;
  return this.scale(s);
};
goog.provide("goog.dom");
goog.provide("goog.dom.Appendable");
goog.provide("goog.dom.DomHelper");
goog.require("goog.array");
goog.require("goog.asserts");
goog.require("goog.dom.BrowserFeature");
goog.require("goog.dom.NodeType");
goog.require("goog.dom.TagName");
goog.require("goog.dom.safe");
goog.require("goog.html.SafeHtml");
goog.require("goog.math.Coordinate");
goog.require("goog.math.Size");
goog.require("goog.object");
goog.require("goog.string");
goog.require("goog.string.Unicode");
goog.require("goog.userAgent");
goog.define("goog.dom.ASSUME_QUIRKS_MODE", false);
goog.define("goog.dom.ASSUME_STANDARDS_MODE", false);
goog.dom.COMPAT_MODE_KNOWN_ = goog.dom.ASSUME_QUIRKS_MODE || goog.dom.ASSUME_STANDARDS_MODE;
goog.dom.getDomHelper = function(opt_element) {
  return opt_element ? new goog.dom.DomHelper(goog.dom.getOwnerDocument(opt_element)) : goog.dom.defaultDomHelper_ || (goog.dom.defaultDomHelper_ = new goog.dom.DomHelper);
};
goog.dom.defaultDomHelper_;
goog.dom.getDocument = function() {
  return document;
};
goog.dom.getElement = function(element) {
  return goog.dom.getElementHelper_(document, element);
};
goog.dom.getElementHelper_ = function(doc, element) {
  return goog.isString(element) ? doc.getElementById(element) : element;
};
goog.dom.getRequiredElement = function(id) {
  return goog.dom.getRequiredElementHelper_(document, id);
};
goog.dom.getRequiredElementHelper_ = function(doc, id) {
  goog.asserts.assertString(id);
  var element = goog.dom.getElementHelper_(doc, id);
  element = goog.asserts.assertElement(element, "No element found with id: " + id);
  return element;
};
goog.dom.$ = goog.dom.getElement;
goog.dom.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(document, opt_tag, opt_class, opt_el);
};
goog.dom.getElementsByClass = function(className, opt_el) {
  var parent = opt_el || document;
  if (goog.dom.canUseQuerySelector_(parent)) {
    return parent.querySelectorAll("." + className);
  }
  return goog.dom.getElementsByTagNameAndClass_(document, "*", className, opt_el);
};
goog.dom.getElementByClass = function(className, opt_el) {
  var parent = opt_el || document;
  var retVal = null;
  if (parent.getElementsByClassName) {
    retVal = parent.getElementsByClassName(className)[0];
  } else {
    if (goog.dom.canUseQuerySelector_(parent)) {
      retVal = parent.querySelector("." + className);
    } else {
      retVal = goog.dom.getElementsByTagNameAndClass_(document, "*", className, opt_el)[0];
    }
  }
  return retVal || null;
};
goog.dom.getRequiredElementByClass = function(className, opt_root) {
  var retValue = goog.dom.getElementByClass(className, opt_root);
  return goog.asserts.assert(retValue, "No element found with className: " + className);
};
goog.dom.canUseQuerySelector_ = function(parent) {
  return !!(parent.querySelectorAll && parent.querySelector);
};
goog.dom.getElementsByTagNameAndClass_ = function(doc, opt_tag, opt_class, opt_el) {
  var parent = opt_el || doc;
  var tagName = opt_tag && opt_tag != "*" ? opt_tag.toUpperCase() : "";
  if (goog.dom.canUseQuerySelector_(parent) && (tagName || opt_class)) {
    var query = tagName + (opt_class ? "." + opt_class : "");
    return parent.querySelectorAll(query);
  }
  if (opt_class && parent.getElementsByClassName) {
    var els = parent.getElementsByClassName(opt_class);
    if (tagName) {
      var arrayLike = {};
      var len = 0;
      for (var i = 0, el;el = els[i];i++) {
        if (tagName == el.nodeName) {
          arrayLike[len++] = el;
        }
      }
      arrayLike.length = len;
      return arrayLike;
    } else {
      return els;
    }
  }
  var els = parent.getElementsByTagName(tagName || "*");
  if (opt_class) {
    var arrayLike = {};
    var len = 0;
    for (var i = 0, el;el = els[i];i++) {
      var className = el.className;
      if (typeof className.split == "function" && goog.array.contains(className.split(/\s+/), opt_class)) {
        arrayLike[len++] = el;
      }
    }
    arrayLike.length = len;
    return arrayLike;
  } else {
    return els;
  }
};
goog.dom.$$ = goog.dom.getElementsByTagNameAndClass;
goog.dom.setProperties = function(element, properties) {
  goog.object.forEach(properties, function(val, key) {
    if (key == "style") {
      element.style.cssText = val;
    } else {
      if (key == "class") {
        element.className = val;
      } else {
        if (key == "for") {
          element.htmlFor = val;
        } else {
          if (goog.dom.DIRECT_ATTRIBUTE_MAP_.hasOwnProperty(key)) {
            element.setAttribute(goog.dom.DIRECT_ATTRIBUTE_MAP_[key], val);
          } else {
            if (goog.string.startsWith(key, "aria-") || goog.string.startsWith(key, "data-")) {
              element.setAttribute(key, val);
            } else {
              element[key] = val;
            }
          }
        }
      }
    }
  });
};
goog.dom.DIRECT_ATTRIBUTE_MAP_ = {"cellpadding":"cellPadding", "cellspacing":"cellSpacing", "colspan":"colSpan", "frameborder":"frameBorder", "height":"height", "maxlength":"maxLength", "role":"role", "rowspan":"rowSpan", "type":"type", "usemap":"useMap", "valign":"vAlign", "width":"width"};
goog.dom.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize_(opt_window || window);
};
goog.dom.getViewportSize_ = function(win) {
  var doc = win.document;
  var el = goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body;
  return new goog.math.Size(el.clientWidth, el.clientHeight);
};
goog.dom.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(window);
};
goog.dom.getDocumentHeight_ = function(win) {
  var doc = win.document;
  var height = 0;
  if (doc) {
    var body = doc.body;
    var docEl = (doc.documentElement);
    if (!(docEl && body)) {
      return 0;
    }
    var vh = goog.dom.getViewportSize_(win).height;
    if (goog.dom.isCss1CompatMode_(doc) && docEl.scrollHeight) {
      height = docEl.scrollHeight != vh ? docEl.scrollHeight : docEl.offsetHeight;
    } else {
      var sh = docEl.scrollHeight;
      var oh = docEl.offsetHeight;
      if (docEl.clientHeight != oh) {
        sh = body.scrollHeight;
        oh = body.offsetHeight;
      }
      if (sh > vh) {
        height = sh > oh ? sh : oh;
      } else {
        height = sh < oh ? sh : oh;
      }
    }
  }
  return height;
};
goog.dom.getPageScroll = function(opt_window) {
  var win = opt_window || goog.global || window;
  return goog.dom.getDomHelper(win.document).getDocumentScroll();
};
goog.dom.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(document);
};
goog.dom.getDocumentScroll_ = function(doc) {
  var el = goog.dom.getDocumentScrollElement_(doc);
  var win = goog.dom.getWindow_(doc);
  if (goog.userAgent.IE && goog.userAgent.isVersionOrHigher("10") && win.pageYOffset != el.scrollTop) {
    return new goog.math.Coordinate(el.scrollLeft, el.scrollTop);
  }
  return new goog.math.Coordinate(win.pageXOffset || el.scrollLeft, win.pageYOffset || el.scrollTop);
};
goog.dom.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(document);
};
goog.dom.getDocumentScrollElement_ = function(doc) {
  if (doc.scrollingElement) {
    return doc.scrollingElement;
  }
  if (!goog.userAgent.WEBKIT && goog.dom.isCss1CompatMode_(doc)) {
    return doc.documentElement;
  }
  return doc.body || doc.documentElement;
};
goog.dom.getWindow = function(opt_doc) {
  return opt_doc ? goog.dom.getWindow_(opt_doc) : window;
};
goog.dom.getWindow_ = function(doc) {
  return doc.parentWindow || doc.defaultView;
};
goog.dom.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(document, arguments);
};
goog.dom.createDom_ = function(doc, args) {
  var tagName = args[0];
  var attributes = args[1];
  if (!goog.dom.BrowserFeature.CAN_ADD_NAME_OR_TYPE_ATTRIBUTES && attributes && (attributes.name || attributes.type)) {
    var tagNameArr = ["\x3c", tagName];
    if (attributes.name) {
      tagNameArr.push(' name\x3d"', goog.string.htmlEscape(attributes.name), '"');
    }
    if (attributes.type) {
      tagNameArr.push(' type\x3d"', goog.string.htmlEscape(attributes.type), '"');
      var clone = {};
      goog.object.extend(clone, attributes);
      delete clone["type"];
      attributes = clone;
    }
    tagNameArr.push("\x3e");
    tagName = tagNameArr.join("");
  }
  var element = doc.createElement(tagName);
  if (attributes) {
    if (goog.isString(attributes)) {
      element.className = attributes;
    } else {
      if (goog.isArray(attributes)) {
        element.className = attributes.join(" ");
      } else {
        goog.dom.setProperties(element, attributes);
      }
    }
  }
  if (args.length > 2) {
    goog.dom.append_(doc, element, args, 2);
  }
  return element;
};
goog.dom.append_ = function(doc, parent, args, startIndex) {
  function childHandler(child) {
    if (child) {
      parent.appendChild(goog.isString(child) ? doc.createTextNode(child) : child);
    }
  }
  for (var i = startIndex;i < args.length;i++) {
    var arg = args[i];
    if (goog.isArrayLike(arg) && !goog.dom.isNodeLike(arg)) {
      goog.array.forEach(goog.dom.isNodeList(arg) ? goog.array.toArray(arg) : arg, childHandler);
    } else {
      childHandler(arg);
    }
  }
};
goog.dom.$dom = goog.dom.createDom;
goog.dom.createElement = function(name) {
  return document.createElement(name);
};
goog.dom.createTextNode = function(content) {
  return document.createTextNode(String(content));
};
goog.dom.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(document, rows, columns, !!opt_fillWithNbsp);
};
goog.dom.createTable_ = function(doc, rows, columns, fillWithNbsp) {
  var table = (doc.createElement(goog.dom.TagName.TABLE));
  var tbody = table.appendChild(doc.createElement(goog.dom.TagName.TBODY));
  for (var i = 0;i < rows;i++) {
    var tr = doc.createElement(goog.dom.TagName.TR);
    for (var j = 0;j < columns;j++) {
      var td = doc.createElement(goog.dom.TagName.TD);
      if (fillWithNbsp) {
        goog.dom.setTextContent(td, goog.string.Unicode.NBSP);
      }
      tr.appendChild(td);
    }
    tbody.appendChild(tr);
  }
  return table;
};
goog.dom.safeHtmlToNode = function(html) {
  return goog.dom.safeHtmlToNode_(document, html);
};
goog.dom.safeHtmlToNode_ = function(doc, html) {
  var tempDiv = doc.createElement(goog.dom.TagName.DIV);
  if (goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT) {
    goog.dom.safe.setInnerHtml(tempDiv, goog.html.SafeHtml.concat(goog.html.SafeHtml.create("br"), html));
    tempDiv.removeChild(tempDiv.firstChild);
  } else {
    goog.dom.safe.setInnerHtml(tempDiv, html);
  }
  return goog.dom.childrenToNode_(doc, tempDiv);
};
goog.dom.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(document, htmlString);
};
goog.dom.htmlToDocumentFragment_ = function(doc, htmlString) {
  var tempDiv = doc.createElement(goog.dom.TagName.DIV);
  if (goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT) {
    tempDiv.innerHTML = "\x3cbr\x3e" + htmlString;
    tempDiv.removeChild(tempDiv.firstChild);
  } else {
    tempDiv.innerHTML = htmlString;
  }
  return goog.dom.childrenToNode_(doc, tempDiv);
};
goog.dom.childrenToNode_ = function(doc, tempDiv) {
  if (tempDiv.childNodes.length == 1) {
    return tempDiv.removeChild(tempDiv.firstChild);
  } else {
    var fragment = doc.createDocumentFragment();
    while (tempDiv.firstChild) {
      fragment.appendChild(tempDiv.firstChild);
    }
    return fragment;
  }
};
goog.dom.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(document);
};
goog.dom.isCss1CompatMode_ = function(doc) {
  if (goog.dom.COMPAT_MODE_KNOWN_) {
    return goog.dom.ASSUME_STANDARDS_MODE;
  }
  return doc.compatMode == "CSS1Compat";
};
goog.dom.canHaveChildren = function(node) {
  if (node.nodeType != goog.dom.NodeType.ELEMENT) {
    return false;
  }
  switch((node).tagName) {
    case goog.dom.TagName.APPLET:
    ;
    case goog.dom.TagName.AREA:
    ;
    case goog.dom.TagName.BASE:
    ;
    case goog.dom.TagName.BR:
    ;
    case goog.dom.TagName.COL:
    ;
    case goog.dom.TagName.COMMAND:
    ;
    case goog.dom.TagName.EMBED:
    ;
    case goog.dom.TagName.FRAME:
    ;
    case goog.dom.TagName.HR:
    ;
    case goog.dom.TagName.IMG:
    ;
    case goog.dom.TagName.INPUT:
    ;
    case goog.dom.TagName.IFRAME:
    ;
    case goog.dom.TagName.ISINDEX:
    ;
    case goog.dom.TagName.KEYGEN:
    ;
    case goog.dom.TagName.LINK:
    ;
    case goog.dom.TagName.NOFRAMES:
    ;
    case goog.dom.TagName.NOSCRIPT:
    ;
    case goog.dom.TagName.META:
    ;
    case goog.dom.TagName.OBJECT:
    ;
    case goog.dom.TagName.PARAM:
    ;
    case goog.dom.TagName.SCRIPT:
    ;
    case goog.dom.TagName.SOURCE:
    ;
    case goog.dom.TagName.STYLE:
    ;
    case goog.dom.TagName.TRACK:
    ;
    case goog.dom.TagName.WBR:
      return false;
  }
  return true;
};
goog.dom.appendChild = function(parent, child) {
  parent.appendChild(child);
};
goog.dom.append = function(parent, var_args) {
  goog.dom.append_(goog.dom.getOwnerDocument(parent), parent, arguments, 1);
};
goog.dom.removeChildren = function(node) {
  var child;
  while (child = node.firstChild) {
    node.removeChild(child);
  }
};
goog.dom.insertSiblingBefore = function(newNode, refNode) {
  if (refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode);
  }
};
goog.dom.insertSiblingAfter = function(newNode, refNode) {
  if (refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode.nextSibling);
  }
};
goog.dom.insertChildAt = function(parent, child, index) {
  parent.insertBefore(child, parent.childNodes[index] || null);
};
goog.dom.removeNode = function(node) {
  return node && node.parentNode ? node.parentNode.removeChild(node) : null;
};
goog.dom.replaceNode = function(newNode, oldNode) {
  var parent = oldNode.parentNode;
  if (parent) {
    parent.replaceChild(newNode, oldNode);
  }
};
goog.dom.flattenElement = function(element) {
  var child, parent = element.parentNode;
  if (parent && parent.nodeType != goog.dom.NodeType.DOCUMENT_FRAGMENT) {
    if (element.removeNode) {
      return (element.removeNode(false));
    } else {
      while (child = element.firstChild) {
        parent.insertBefore(child, element);
      }
      return (goog.dom.removeNode(element));
    }
  }
};
goog.dom.getChildren = function(element) {
  if (goog.dom.BrowserFeature.CAN_USE_CHILDREN_ATTRIBUTE && element.children != undefined) {
    return element.children;
  }
  return goog.array.filter(element.childNodes, function(node) {
    return node.nodeType == goog.dom.NodeType.ELEMENT;
  });
};
goog.dom.getFirstElementChild = function(node) {
  if (goog.isDef(node.firstElementChild)) {
    return (node).firstElementChild;
  }
  return goog.dom.getNextElementNode_(node.firstChild, true);
};
goog.dom.getLastElementChild = function(node) {
  if (goog.isDef(node.lastElementChild)) {
    return (node).lastElementChild;
  }
  return goog.dom.getNextElementNode_(node.lastChild, false);
};
goog.dom.getNextElementSibling = function(node) {
  if (goog.isDef(node.nextElementSibling)) {
    return (node).nextElementSibling;
  }
  return goog.dom.getNextElementNode_(node.nextSibling, true);
};
goog.dom.getPreviousElementSibling = function(node) {
  if (goog.isDef(node.previousElementSibling)) {
    return (node).previousElementSibling;
  }
  return goog.dom.getNextElementNode_(node.previousSibling, false);
};
goog.dom.getNextElementNode_ = function(node, forward) {
  while (node && node.nodeType != goog.dom.NodeType.ELEMENT) {
    node = forward ? node.nextSibling : node.previousSibling;
  }
  return (node);
};
goog.dom.getNextNode = function(node) {
  if (!node) {
    return null;
  }
  if (node.firstChild) {
    return node.firstChild;
  }
  while (node && !node.nextSibling) {
    node = node.parentNode;
  }
  return node ? node.nextSibling : null;
};
goog.dom.getPreviousNode = function(node) {
  if (!node) {
    return null;
  }
  if (!node.previousSibling) {
    return node.parentNode;
  }
  node = node.previousSibling;
  while (node && node.lastChild) {
    node = node.lastChild;
  }
  return node;
};
goog.dom.isNodeLike = function(obj) {
  return goog.isObject(obj) && obj.nodeType > 0;
};
goog.dom.isElement = function(obj) {
  return goog.isObject(obj) && obj.nodeType == goog.dom.NodeType.ELEMENT;
};
goog.dom.isWindow = function(obj) {
  return goog.isObject(obj) && obj["window"] == obj;
};
goog.dom.getParentElement = function(element) {
  var parent;
  if (goog.dom.BrowserFeature.CAN_USE_PARENT_ELEMENT_PROPERTY) {
    var isIe9 = goog.userAgent.IE && goog.userAgent.isVersionOrHigher("9") && !goog.userAgent.isVersionOrHigher("10");
    if (!(isIe9 && goog.global["SVGElement"] && element instanceof goog.global["SVGElement"])) {
      parent = element.parentElement;
      if (parent) {
        return parent;
      }
    }
  }
  parent = element.parentNode;
  return goog.dom.isElement(parent) ? (parent) : null;
};
goog.dom.contains = function(parent, descendant) {
  if (parent.contains && descendant.nodeType == goog.dom.NodeType.ELEMENT) {
    return parent == descendant || parent.contains(descendant);
  }
  if (typeof parent.compareDocumentPosition != "undefined") {
    return parent == descendant || Boolean(parent.compareDocumentPosition(descendant) & 16);
  }
  while (descendant && parent != descendant) {
    descendant = descendant.parentNode;
  }
  return descendant == parent;
};
goog.dom.compareNodeOrder = function(node1, node2) {
  if (node1 == node2) {
    return 0;
  }
  if (node1.compareDocumentPosition) {
    return node1.compareDocumentPosition(node2) & 2 ? 1 : -1;
  }
  if (goog.userAgent.IE && !goog.userAgent.isDocumentModeOrHigher(9)) {
    if (node1.nodeType == goog.dom.NodeType.DOCUMENT) {
      return -1;
    }
    if (node2.nodeType == goog.dom.NodeType.DOCUMENT) {
      return 1;
    }
  }
  if ("sourceIndex" in node1 || node1.parentNode && "sourceIndex" in node1.parentNode) {
    var isElement1 = node1.nodeType == goog.dom.NodeType.ELEMENT;
    var isElement2 = node2.nodeType == goog.dom.NodeType.ELEMENT;
    if (isElement1 && isElement2) {
      return node1.sourceIndex - node2.sourceIndex;
    } else {
      var parent1 = node1.parentNode;
      var parent2 = node2.parentNode;
      if (parent1 == parent2) {
        return goog.dom.compareSiblingOrder_(node1, node2);
      }
      if (!isElement1 && goog.dom.contains(parent1, node2)) {
        return -1 * goog.dom.compareParentsDescendantNodeIe_(node1, node2);
      }
      if (!isElement2 && goog.dom.contains(parent2, node1)) {
        return goog.dom.compareParentsDescendantNodeIe_(node2, node1);
      }
      return (isElement1 ? node1.sourceIndex : parent1.sourceIndex) - (isElement2 ? node2.sourceIndex : parent2.sourceIndex);
    }
  }
  var doc = goog.dom.getOwnerDocument(node1);
  var range1, range2;
  range1 = doc.createRange();
  range1.selectNode(node1);
  range1.collapse(true);
  range2 = doc.createRange();
  range2.selectNode(node2);
  range2.collapse(true);
  return range1.compareBoundaryPoints(goog.global["Range"].START_TO_END, range2);
};
goog.dom.compareParentsDescendantNodeIe_ = function(textNode, node) {
  var parent = textNode.parentNode;
  if (parent == node) {
    return -1;
  }
  var sibling = node;
  while (sibling.parentNode != parent) {
    sibling = sibling.parentNode;
  }
  return goog.dom.compareSiblingOrder_(sibling, textNode);
};
goog.dom.compareSiblingOrder_ = function(node1, node2) {
  var s = node2;
  while (s = s.previousSibling) {
    if (s == node1) {
      return -1;
    }
  }
  return 1;
};
goog.dom.findCommonAncestor = function(var_args) {
  var i, count = arguments.length;
  if (!count) {
    return null;
  } else {
    if (count == 1) {
      return arguments[0];
    }
  }
  var paths = [];
  var minLength = Infinity;
  for (i = 0;i < count;i++) {
    var ancestors = [];
    var node = arguments[i];
    while (node) {
      ancestors.unshift(node);
      node = node.parentNode;
    }
    paths.push(ancestors);
    minLength = Math.min(minLength, ancestors.length);
  }
  var output = null;
  for (i = 0;i < minLength;i++) {
    var first = paths[0][i];
    for (var j = 1;j < count;j++) {
      if (first != paths[j][i]) {
        return output;
      }
    }
    output = first;
  }
  return output;
};
goog.dom.getOwnerDocument = function(node) {
  goog.asserts.assert(node, "Node cannot be null or undefined.");
  return (node.nodeType == goog.dom.NodeType.DOCUMENT ? node : node.ownerDocument || node.document);
};
goog.dom.getFrameContentDocument = function(frame) {
  var doc = frame.contentDocument || frame.contentWindow.document;
  return doc;
};
goog.dom.getFrameContentWindow = function(frame) {
  return frame.contentWindow || goog.dom.getWindow(goog.dom.getFrameContentDocument(frame));
};
goog.dom.setTextContent = function(node, text) {
  goog.asserts.assert(node != null, "goog.dom.setTextContent expects a non-null value for node");
  if ("textContent" in node) {
    node.textContent = text;
  } else {
    if (node.nodeType == goog.dom.NodeType.TEXT) {
      node.data = text;
    } else {
      if (node.firstChild && node.firstChild.nodeType == goog.dom.NodeType.TEXT) {
        while (node.lastChild != node.firstChild) {
          node.removeChild(node.lastChild);
        }
        node.firstChild.data = text;
      } else {
        goog.dom.removeChildren(node);
        var doc = goog.dom.getOwnerDocument(node);
        node.appendChild(doc.createTextNode(String(text)));
      }
    }
  }
};
goog.dom.getOuterHtml = function(element) {
  if ("outerHTML" in element) {
    return element.outerHTML;
  } else {
    var doc = goog.dom.getOwnerDocument(element);
    var div = doc.createElement(goog.dom.TagName.DIV);
    div.appendChild(element.cloneNode(true));
    return div.innerHTML;
  }
};
goog.dom.findNode = function(root, p) {
  var rv = [];
  var found = goog.dom.findNodes_(root, p, rv, true);
  return found ? rv[0] : undefined;
};
goog.dom.findNodes = function(root, p) {
  var rv = [];
  goog.dom.findNodes_(root, p, rv, false);
  return rv;
};
goog.dom.findNodes_ = function(root, p, rv, findOne) {
  if (root != null) {
    var child = root.firstChild;
    while (child) {
      if (p(child)) {
        rv.push(child);
        if (findOne) {
          return true;
        }
      }
      if (goog.dom.findNodes_(child, p, rv, findOne)) {
        return true;
      }
      child = child.nextSibling;
    }
  }
  return false;
};
goog.dom.TAGS_TO_IGNORE_ = {"SCRIPT":1, "STYLE":1, "HEAD":1, "IFRAME":1, "OBJECT":1};
goog.dom.PREDEFINED_TAG_VALUES_ = {"IMG":" ", "BR":"\n"};
goog.dom.isFocusableTabIndex = function(element) {
  return goog.dom.hasSpecifiedTabIndex_(element) && goog.dom.isTabIndexFocusable_(element);
};
goog.dom.setFocusableTabIndex = function(element, enable) {
  if (enable) {
    element.tabIndex = 0;
  } else {
    element.tabIndex = -1;
    element.removeAttribute("tabIndex");
  }
};
goog.dom.isFocusable = function(element) {
  var focusable;
  if (goog.dom.nativelySupportsFocus_(element)) {
    focusable = !element.disabled && (!goog.dom.hasSpecifiedTabIndex_(element) || goog.dom.isTabIndexFocusable_(element));
  } else {
    focusable = goog.dom.isFocusableTabIndex(element);
  }
  return focusable && goog.userAgent.IE ? goog.dom.hasNonZeroBoundingRect_(element) : focusable;
};
goog.dom.hasSpecifiedTabIndex_ = function(element) {
  var attrNode = element.getAttributeNode("tabindex");
  return goog.isDefAndNotNull(attrNode) && attrNode.specified;
};
goog.dom.isTabIndexFocusable_ = function(element) {
  var index = element.tabIndex;
  return goog.isNumber(index) && index >= 0 && index < 32768;
};
goog.dom.nativelySupportsFocus_ = function(element) {
  return element.tagName == goog.dom.TagName.A || element.tagName == goog.dom.TagName.INPUT || element.tagName == goog.dom.TagName.TEXTAREA || element.tagName == goog.dom.TagName.SELECT || element.tagName == goog.dom.TagName.BUTTON;
};
goog.dom.hasNonZeroBoundingRect_ = function(element) {
  var rect = goog.isFunction(element["getBoundingClientRect"]) ? element.getBoundingClientRect() : {"height":element.offsetHeight, "width":element.offsetWidth};
  return goog.isDefAndNotNull(rect) && rect.height > 0 && rect.width > 0;
};
goog.dom.getTextContent = function(node) {
  var textContent;
  if (goog.dom.BrowserFeature.CAN_USE_INNER_TEXT && "innerText" in node) {
    textContent = goog.string.canonicalizeNewlines(node.innerText);
  } else {
    var buf = [];
    goog.dom.getTextContent_(node, buf, true);
    textContent = buf.join("");
  }
  textContent = textContent.replace(/ \xAD /g, " ").replace(/\xAD/g, "");
  textContent = textContent.replace(/\u200B/g, "");
  if (!goog.dom.BrowserFeature.CAN_USE_INNER_TEXT) {
    textContent = textContent.replace(/ +/g, " ");
  }
  if (textContent != " ") {
    textContent = textContent.replace(/^\s*/, "");
  }
  return textContent;
};
goog.dom.getRawTextContent = function(node) {
  var buf = [];
  goog.dom.getTextContent_(node, buf, false);
  return buf.join("");
};
goog.dom.getTextContent_ = function(node, buf, normalizeWhitespace) {
  if (node.nodeName in goog.dom.TAGS_TO_IGNORE_) {
  } else {
    if (node.nodeType == goog.dom.NodeType.TEXT) {
      if (normalizeWhitespace) {
        buf.push(String(node.nodeValue).replace(/(\r\n|\r|\n)/g, ""));
      } else {
        buf.push(node.nodeValue);
      }
    } else {
      if (node.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
        buf.push(goog.dom.PREDEFINED_TAG_VALUES_[node.nodeName]);
      } else {
        var child = node.firstChild;
        while (child) {
          goog.dom.getTextContent_(child, buf, normalizeWhitespace);
          child = child.nextSibling;
        }
      }
    }
  }
};
goog.dom.getNodeTextLength = function(node) {
  return goog.dom.getTextContent(node).length;
};
goog.dom.getNodeTextOffset = function(node, opt_offsetParent) {
  var root = opt_offsetParent || goog.dom.getOwnerDocument(node).body;
  var buf = [];
  while (node && node != root) {
    var cur = node;
    while (cur = cur.previousSibling) {
      buf.unshift(goog.dom.getTextContent(cur));
    }
    node = node.parentNode;
  }
  return goog.string.trimLeft(buf.join("")).replace(/ +/g, " ").length;
};
goog.dom.getNodeAtOffset = function(parent, offset, opt_result) {
  var stack = [parent], pos = 0, cur = null;
  while (stack.length > 0 && pos < offset) {
    cur = stack.pop();
    if (cur.nodeName in goog.dom.TAGS_TO_IGNORE_) {
    } else {
      if (cur.nodeType == goog.dom.NodeType.TEXT) {
        var text = cur.nodeValue.replace(/(\r\n|\r|\n)/g, "").replace(/ +/g, " ");
        pos += text.length;
      } else {
        if (cur.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
          pos += goog.dom.PREDEFINED_TAG_VALUES_[cur.nodeName].length;
        } else {
          for (var i = cur.childNodes.length - 1;i >= 0;i--) {
            stack.push(cur.childNodes[i]);
          }
        }
      }
    }
  }
  if (goog.isObject(opt_result)) {
    opt_result.remainder = cur ? cur.nodeValue.length + offset - pos - 1 : 0;
    opt_result.node = cur;
  }
  return cur;
};
goog.dom.isNodeList = function(val) {
  if (val && typeof val.length == "number") {
    if (goog.isObject(val)) {
      return typeof val.item == "function" || typeof val.item == "string";
    } else {
      if (goog.isFunction(val)) {
        return typeof val.item == "function";
      }
    }
  }
  return false;
};
goog.dom.getAncestorByTagNameAndClass = function(element, opt_tag, opt_class, opt_maxSearchSteps) {
  if (!opt_tag && !opt_class) {
    return null;
  }
  var tagName = opt_tag ? opt_tag.toUpperCase() : null;
  return (goog.dom.getAncestor(element, function(node) {
    return (!tagName || node.nodeName == tagName) && (!opt_class || goog.isString(node.className) && goog.array.contains(node.className.split(/\s+/), opt_class));
  }, true, opt_maxSearchSteps));
};
goog.dom.getAncestorByClass = function(element, className, opt_maxSearchSteps) {
  return goog.dom.getAncestorByTagNameAndClass(element, null, className, opt_maxSearchSteps);
};
goog.dom.getAncestor = function(element, matcher, opt_includeNode, opt_maxSearchSteps) {
  if (!opt_includeNode) {
    element = element.parentNode;
  }
  var ignoreSearchSteps = opt_maxSearchSteps == null;
  var steps = 0;
  while (element && (ignoreSearchSteps || steps <= opt_maxSearchSteps)) {
    goog.asserts.assert(element.name != "parentNode");
    if (matcher(element)) {
      return element;
    }
    element = element.parentNode;
    steps++;
  }
  return null;
};
goog.dom.getActiveElement = function(doc) {
  try {
    return doc && doc.activeElement;
  } catch (e) {
  }
  return null;
};
goog.dom.getPixelRatio = function() {
  var win = goog.dom.getWindow();
  if (goog.isDef(win.devicePixelRatio)) {
    return win.devicePixelRatio;
  } else {
    if (win.matchMedia) {
      return goog.dom.matchesPixelRatio_(.75) || goog.dom.matchesPixelRatio_(1.5) || goog.dom.matchesPixelRatio_(2) || goog.dom.matchesPixelRatio_(3) || 1;
    }
  }
  return 1;
};
goog.dom.matchesPixelRatio_ = function(pixelRatio) {
  var win = goog.dom.getWindow();
  var query = "(-webkit-min-device-pixel-ratio: " + pixelRatio + ")," + "(min--moz-device-pixel-ratio: " + pixelRatio + ")," + "(min-resolution: " + pixelRatio + "dppx)";
  return win.matchMedia(query).matches ? pixelRatio : 0;
};
goog.dom.DomHelper = function(opt_document) {
  this.document_ = opt_document || goog.global.document || document;
};
goog.dom.DomHelper.prototype.getDomHelper = goog.dom.getDomHelper;
goog.dom.DomHelper.prototype.setDocument = function(document) {
  this.document_ = document;
};
goog.dom.DomHelper.prototype.getDocument = function() {
  return this.document_;
};
goog.dom.DomHelper.prototype.getElement = function(element) {
  return goog.dom.getElementHelper_(this.document_, element);
};
goog.dom.DomHelper.prototype.getRequiredElement = function(id) {
  return goog.dom.getRequiredElementHelper_(this.document_, id);
};
goog.dom.DomHelper.prototype.$ = goog.dom.DomHelper.prototype.getElement;
goog.dom.DomHelper.prototype.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(this.document_, opt_tag, opt_class, opt_el);
};
goog.dom.DomHelper.prototype.getElementsByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementsByClass(className, doc);
};
goog.dom.DomHelper.prototype.getElementByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementByClass(className, doc);
};
goog.dom.DomHelper.prototype.getRequiredElementByClass = function(className, opt_root) {
  var root = opt_root || this.document_;
  return goog.dom.getRequiredElementByClass(className, root);
};
goog.dom.DomHelper.prototype.$$ = goog.dom.DomHelper.prototype.getElementsByTagNameAndClass;
goog.dom.DomHelper.prototype.setProperties = goog.dom.setProperties;
goog.dom.DomHelper.prototype.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize(opt_window || this.getWindow());
};
goog.dom.DomHelper.prototype.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(this.getWindow());
};
goog.dom.Appendable;
goog.dom.DomHelper.prototype.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(this.document_, arguments);
};
goog.dom.DomHelper.prototype.$dom = goog.dom.DomHelper.prototype.createDom;
goog.dom.DomHelper.prototype.createElement = function(name) {
  return this.document_.createElement(name);
};
goog.dom.DomHelper.prototype.createTextNode = function(content) {
  return this.document_.createTextNode(String(content));
};
goog.dom.DomHelper.prototype.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(this.document_, rows, columns, !!opt_fillWithNbsp);
};
goog.dom.DomHelper.prototype.safeHtmlToNode = function(html) {
  return goog.dom.safeHtmlToNode_(this.document_, html);
};
goog.dom.DomHelper.prototype.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(this.document_, htmlString);
};
goog.dom.DomHelper.prototype.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(this.document_);
};
goog.dom.DomHelper.prototype.getWindow = function() {
  return goog.dom.getWindow_(this.document_);
};
goog.dom.DomHelper.prototype.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(this.document_);
};
goog.dom.DomHelper.prototype.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(this.document_);
};
goog.dom.DomHelper.prototype.getActiveElement = function(opt_doc) {
  return goog.dom.getActiveElement(opt_doc || this.document_);
};
goog.dom.DomHelper.prototype.appendChild = goog.dom.appendChild;
goog.dom.DomHelper.prototype.append = goog.dom.append;
goog.dom.DomHelper.prototype.canHaveChildren = goog.dom.canHaveChildren;
goog.dom.DomHelper.prototype.removeChildren = goog.dom.removeChildren;
goog.dom.DomHelper.prototype.insertSiblingBefore = goog.dom.insertSiblingBefore;
goog.dom.DomHelper.prototype.insertSiblingAfter = goog.dom.insertSiblingAfter;
goog.dom.DomHelper.prototype.insertChildAt = goog.dom.insertChildAt;
goog.dom.DomHelper.prototype.removeNode = goog.dom.removeNode;
goog.dom.DomHelper.prototype.replaceNode = goog.dom.replaceNode;
goog.dom.DomHelper.prototype.flattenElement = goog.dom.flattenElement;
goog.dom.DomHelper.prototype.getChildren = goog.dom.getChildren;
goog.dom.DomHelper.prototype.getFirstElementChild = goog.dom.getFirstElementChild;
goog.dom.DomHelper.prototype.getLastElementChild = goog.dom.getLastElementChild;
goog.dom.DomHelper.prototype.getNextElementSibling = goog.dom.getNextElementSibling;
goog.dom.DomHelper.prototype.getPreviousElementSibling = goog.dom.getPreviousElementSibling;
goog.dom.DomHelper.prototype.getNextNode = goog.dom.getNextNode;
goog.dom.DomHelper.prototype.getPreviousNode = goog.dom.getPreviousNode;
goog.dom.DomHelper.prototype.isNodeLike = goog.dom.isNodeLike;
goog.dom.DomHelper.prototype.isElement = goog.dom.isElement;
goog.dom.DomHelper.prototype.isWindow = goog.dom.isWindow;
goog.dom.DomHelper.prototype.getParentElement = goog.dom.getParentElement;
goog.dom.DomHelper.prototype.contains = goog.dom.contains;
goog.dom.DomHelper.prototype.compareNodeOrder = goog.dom.compareNodeOrder;
goog.dom.DomHelper.prototype.findCommonAncestor = goog.dom.findCommonAncestor;
goog.dom.DomHelper.prototype.getOwnerDocument = goog.dom.getOwnerDocument;
goog.dom.DomHelper.prototype.getFrameContentDocument = goog.dom.getFrameContentDocument;
goog.dom.DomHelper.prototype.getFrameContentWindow = goog.dom.getFrameContentWindow;
goog.dom.DomHelper.prototype.setTextContent = goog.dom.setTextContent;
goog.dom.DomHelper.prototype.getOuterHtml = goog.dom.getOuterHtml;
goog.dom.DomHelper.prototype.findNode = goog.dom.findNode;
goog.dom.DomHelper.prototype.findNodes = goog.dom.findNodes;
goog.dom.DomHelper.prototype.isFocusableTabIndex = goog.dom.isFocusableTabIndex;
goog.dom.DomHelper.prototype.setFocusableTabIndex = goog.dom.setFocusableTabIndex;
goog.dom.DomHelper.prototype.isFocusable = goog.dom.isFocusable;
goog.dom.DomHelper.prototype.getTextContent = goog.dom.getTextContent;
goog.dom.DomHelper.prototype.getNodeTextLength = goog.dom.getNodeTextLength;
goog.dom.DomHelper.prototype.getNodeTextOffset = goog.dom.getNodeTextOffset;
goog.dom.DomHelper.prototype.getNodeAtOffset = goog.dom.getNodeAtOffset;
goog.dom.DomHelper.prototype.isNodeList = goog.dom.isNodeList;
goog.dom.DomHelper.prototype.getAncestorByTagNameAndClass = goog.dom.getAncestorByTagNameAndClass;
goog.dom.DomHelper.prototype.getAncestorByClass = goog.dom.getAncestorByClass;
goog.dom.DomHelper.prototype.getAncestor = goog.dom.getAncestor;
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += a1;
  if (opt_a2 != null) {
    for (var i = 1;i < arguments.length;i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("cljs.core");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "1.7.228";
cljs.core._STAR_unchecked_if_STAR_ = false;
goog.define("cljs.core._STAR_target_STAR_", "default");
cljs.core._STAR_ns_STAR_ = null;
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
if (typeof cljs.core._STAR_print_err_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_err_fn_STAR_ = function cljs$core$_STAR_print_err_fn_STAR_(_) {
    throw new Error("No *print-err-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core.set_print_err_fn_BANG_ = function cljs$core$set_print_err_fn_BANG_(f) {
  return cljs.core._STAR_print_err_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  cljs.core._STAR_print_fn_STAR_ = function() {
    var G__16103__delegate = function(args) {
      return console.log.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__16103 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__16104__i = 0, G__16104__a = new Array(arguments.length - 0);
        while (G__16104__i < G__16104__a.length) {
          G__16104__a[G__16104__i] = arguments[G__16104__i + 0];
          ++G__16104__i;
        }
        args = new cljs.core.IndexedSeq(G__16104__a, 0);
      }
      return G__16103__delegate.call(this, args);
    };
    G__16103.cljs$lang$maxFixedArity = 0;
    G__16103.cljs$lang$applyTo = function(arglist__16105) {
      var args = cljs.core.seq(arglist__16105);
      return G__16103__delegate(args);
    };
    G__16103.cljs$core$IFn$_invoke$arity$variadic = G__16103__delegate;
    return G__16103;
  }();
  cljs.core._STAR_print_err_fn_STAR_ = function() {
    var G__16106__delegate = function(args) {
      return console.error.apply(console, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null, args));
    };
    var G__16106 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__16107__i = 0, G__16107__a = new Array(arguments.length - 0);
        while (G__16107__i < G__16107__a.length) {
          G__16107__a[G__16107__i] = arguments[G__16107__i + 0];
          ++G__16107__i;
        }
        args = new cljs.core.IndexedSeq(G__16107__a, 0);
      }
      return G__16106__delegate.call(this, args);
    };
    G__16106.cljs$lang$maxFixedArity = 0;
    G__16106.cljs$lang$applyTo = function(arglist__16108) {
      var args = cljs.core.seq(arglist__16108);
      return G__16106__delegate(args);
    };
    G__16106.cljs$core$IFn$_invoke$arity$variadic = G__16106__delegate;
    return G__16106;
  }();
  return null;
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (x == null) {
    return true;
  } else {
    if (x === false) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  return goog.isString(x);
};
cljs.core.char_QMARK_ = function cljs$core$char_QMARK_(x) {
  return goog.string.isUnicodeChar(x);
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[goog.typeOf(x__$1)]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__6130__auto__ = ty;
    if (cljs.core.truth_(and__6130__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__6130__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : goog.typeOf(obj);
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__4423__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__4423__auto__)) {
    var s = temp__4423__auto__;
    return s;
  } else {
    return [cljs.core.str(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && goog.typeOf(Symbol) === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.CHAR_MAP = {"]":"_RBRACK_", "'":"_SINGLEQUOTE_", "\x3d":"_EQ_", '"':"_DOUBLEQUOTE_", "!":"_BANG_", "*":"_STAR_", "%":"_PERCENT_", "|":"_BAR_", "~":"_TILDE_", "/":"_SLASH_", "\\":"_BSLASH_", "-":"_", "?":"_QMARK_", "\x26":"_AMPERSAND_", ":":"_COLON_", "\x3c":"_LT_", "{":"_LBRACE_", "}":"_RBRACE_", "[":"_LBRACK_", "#":"_SHARP_", "^":"_CARET_", "+":"_PLUS_", "@":"_CIRCA_", "\x3e":"_GT_"};
cljs.core.DEMUNGE_MAP = {"_RBRACE_":"}", "_COLON_":":", "_BANG_":"!", "_QMARK_":"?", "_BSLASH_":"\\\\", "_SLASH_":"/", "_PERCENT_":"%", "_PLUS_":"+", "_SHARP_":"#", "_LBRACE_":"{", "_BAR_":"|", "_LBRACK_":"[", "_EQ_":"\x3d", "_":"-", "_TILDE_":"~", "_RBRACK_":"]", "_GT_":"\x3e", "_SINGLEQUOTE_":"'", "_CIRCA_":"@", "_AMPERSAND_":"\x26", "_DOUBLEQUOTE_":'\\"', "_CARET_":"^", "_LT_":"\x3c", "_STAR_":"*"};
cljs.core.DEMUNGE_PATTERN = null;
cljs.core.system_time = function cljs$core$system_time() {
  if (typeof performance !== "undefined" && !(performance.now == null)) {
    return performance.now();
  } else {
    if (typeof process !== "undefined" && !(process.hrtime == null)) {
      var t = process.hrtime();
      return (t[0] * 1E9 + t[1]) / 1E6;
    } else {
      return (new Date).getTime();
    }
  }
};
cljs.core.make_array = function cljs$core$make_array(var_args) {
  var args16109 = [];
  var len__7200__auto___16112 = arguments.length;
  var i__7201__auto___16113 = 0;
  while (true) {
    if (i__7201__auto___16113 < len__7200__auto___16112) {
      args16109.push(arguments[i__7201__auto___16113]);
      var G__16114 = i__7201__auto___16113 + 1;
      i__7201__auto___16113 = G__16114;
      continue;
    } else {
    }
    break;
  }
  var G__16111 = args16109.length;
  switch(G__16111) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16109.length)].join(""));;
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__7045__auto___16116 = len;
  var i_16117 = 0;
  while (true) {
    if (i_16117 < n__7045__auto___16116) {
      new_arr[i_16117] = arr[i_16117];
      var G__16118 = i_16117 + 1;
      i_16117 = G__16118;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__16119 = i + 1;
      i = G__16119;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget(var_args) {
  var args16120 = [];
  var len__7200__auto___16129 = arguments.length;
  var i__7201__auto___16130 = 0;
  while (true) {
    if (i__7201__auto___16130 < len__7200__auto___16129) {
      args16120.push(arguments[i__7201__auto___16130]);
      var G__16131 = i__7201__auto___16130 + 1;
      i__7201__auto___16130 = G__16131;
      continue;
    } else {
    }
    break;
  }
  var G__16125 = args16120.length;
  switch(G__16125) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16120.slice(2), 0);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__16126 = cljs.core.aget;
  var G__16127 = array[i];
  var G__16128 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__16126, G__16127, G__16128) : cljs.core.apply.call(null, G__16126, G__16127, G__16128);
};
cljs.core.aget.cljs$lang$applyTo = function(seq16121) {
  var G__16122 = cljs.core.first(seq16121);
  var seq16121__$1 = cljs.core.next(seq16121);
  var G__16123 = cljs.core.first(seq16121__$1);
  var seq16121__$2 = cljs.core.next(seq16121__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__16122, G__16123, seq16121__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset(var_args) {
  var args16133 = [];
  var len__7200__auto___16144 = arguments.length;
  var i__7201__auto___16145 = 0;
  while (true) {
    if (i__7201__auto___16145 < len__7200__auto___16144) {
      args16133.push(arguments[i__7201__auto___16145]);
      var G__16146 = i__7201__auto___16145 + 1;
      i__7201__auto___16145 = G__16146;
      continue;
    } else {
    }
    break;
  }
  var G__16139 = args16133.length;
  switch(G__16139) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16133.slice(3), 0);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7219__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__16140 = cljs.core.aset;
  var G__16141 = array[idx];
  var G__16142 = idx2;
  var G__16143 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__16140, G__16141, G__16142, G__16143) : cljs.core.apply.call(null, G__16140, G__16141, G__16142, G__16143);
};
cljs.core.aset.cljs$lang$applyTo = function(seq16134) {
  var G__16135 = cljs.core.first(seq16134);
  var seq16134__$1 = cljs.core.next(seq16134);
  var G__16136 = cljs.core.first(seq16134__$1);
  var seq16134__$2 = cljs.core.next(seq16134__$1);
  var G__16137 = cljs.core.first(seq16134__$2);
  var seq16134__$3 = cljs.core.next(seq16134__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__16135, G__16136, G__16137, seq16134__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array(var_args) {
  var args16148 = [];
  var len__7200__auto___16154 = arguments.length;
  var i__7201__auto___16155 = 0;
  while (true) {
    if (i__7201__auto___16155 < len__7200__auto___16154) {
      args16148.push(arguments[i__7201__auto___16155]);
      var G__16156 = i__7201__auto___16155 + 1;
      i__7201__auto___16155 = G__16156;
      continue;
    } else {
    }
    break;
  }
  var G__16150 = args16148.length;
  switch(G__16150) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16148.length)].join(""));;
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__16151 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__16152 = [];
  var G__16153 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__16151, G__16152, G__16153) : cljs.core.reduce.call(null, G__16151, G__16152, G__16153);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke(var_args) {
  var args__7207__auto__ = [];
  var len__7200__auto___16161 = arguments.length;
  var i__7201__auto___16162 = 0;
  while (true) {
    if (i__7201__auto___16162 < len__7200__auto___16161) {
      args__7207__auto__.push(arguments[i__7201__auto___16162]);
      var G__16163 = i__7201__auto___16162 + 1;
      i__7201__auto___16162 = G__16163;
      continue;
    } else {
    }
    break;
  }
  var argseq__7208__auto__ = 2 < args__7207__auto__.length ? new cljs.core.IndexedSeq(args__7207__auto__.slice(2), 0) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7208__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq16158) {
  var G__16159 = cljs.core.first(seq16158);
  var seq16158__$1 = cljs.core.next(seq16158);
  var G__16160 = cljs.core.first(seq16158__$1);
  var seq16158__$2 = cljs.core.next(seq16158__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__16159, G__16160, seq16158__$2);
};
cljs.core.Fn = function() {
};
cljs.core.IFn = function() {
};
cljs.core._invoke = function cljs$core$_invoke(var_args) {
  var args16164 = [];
  var len__7200__auto___16167 = arguments.length;
  var i__7201__auto___16168 = 0;
  while (true) {
    if (i__7201__auto___16168 < len__7200__auto___16167) {
      args16164.push(arguments[i__7201__auto___16168]);
      var G__16169 = i__7201__auto___16168 + 1;
      i__7201__auto___16168 = G__16169;
      continue;
    } else {
    }
    break;
  }
  var G__16166 = args16164.length;
  switch(G__16166) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16164.length)].join(""));;
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$1 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__6798__auto__.call(null, this$);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__6798__auto____$1.call(null, this$);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$2 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(this$, a) : m__6798__auto__.call(null, this$, a);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, a) : m__6798__auto____$1.call(null, this$, a);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$3 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__6798__auto__.call(null, this$, a, b);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__6798__auto____$1.call(null, this$, a, b);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$4 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__6798__auto__.call(null, this$, a, b, c);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__6798__auto____$1.call(null, this$, a, b, c);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$5 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$5 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__6798__auto__.call(null, this$, a, b, c, d);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__6798__auto____$1.call(null, this$, a, b, c, d);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$6 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$6 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__6798__auto__.call(null, this$, a, b, c, d, e);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__6798__auto____$1.call(null, this$, a, b, c, d, e);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$7 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$7 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__6798__auto__.call(null, this$, a, b, c, d, e, f);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$8 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$8 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$9 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$9 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$10 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$10 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$11 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$11 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$12 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$12 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$13 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$13 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$14 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$14 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$15 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$15 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$16 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$16 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$17 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$17 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$18 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$18 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$19 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$19 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$20 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$20 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$21 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$21 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$22 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._invoke[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$22 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__6798__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    } else {
      var m__6798__auto____$1 = cljs.core._invoke["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__6798__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
};
cljs.core._clone = function cljs$core$_clone(value) {
  if (!(value == null) && !(value.cljs$core$ICloneable$_clone$arity$1 == null)) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__6797__auto__ = value == null ? null : value;
    var m__6798__auto__ = cljs.core._clone[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__6798__auto__.call(null, value);
    } else {
      var m__6798__auto____$1 = cljs.core._clone["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__6798__auto____$1.call(null, value);
      } else {
        throw cljs.core.missing_protocol("ICloneable.-clone", value);
      }
    }
  }
};
cljs.core.ICounted = function() {
};
cljs.core._count = function cljs$core$_count(coll) {
  if (!(coll == null) && !(coll.cljs$core$ICounted$_count$arity$1 == null)) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._count[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._count["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ICounted.-count", coll);
      }
    }
  }
};
cljs.core.IEmptyableCollection = function() {
};
cljs.core._empty = function cljs$core$_empty(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._empty[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._empty["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
      }
    }
  }
};
cljs.core.ICollection = function() {
};
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (!(coll == null) && !(coll.cljs$core$ICollection$_conj$arity$2 == null)) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._conj[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, o) : m__6798__auto__.call(null, coll, o);
    } else {
      var m__6798__auto____$1 = cljs.core._conj["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, o) : m__6798__auto____$1.call(null, coll, o);
      } else {
        throw cljs.core.missing_protocol("ICollection.-conj", coll);
      }
    }
  }
};
cljs.core.IIndexed = function() {
};
cljs.core._nth = function cljs$core$_nth(var_args) {
  var args16171 = [];
  var len__7200__auto___16174 = arguments.length;
  var i__7201__auto___16175 = 0;
  while (true) {
    if (i__7201__auto___16175 < len__7200__auto___16174) {
      args16171.push(arguments[i__7201__auto___16175]);
      var G__16176 = i__7201__auto___16175 + 1;
      i__7201__auto___16175 = G__16176;
      continue;
    } else {
    }
    break;
  }
  var G__16173 = args16171.length;
  switch(G__16173) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16171.length)].join(""));;
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$2 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._nth[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, n) : m__6798__auto__.call(null, coll, n);
    } else {
      var m__6798__auto____$1 = cljs.core._nth["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, n) : m__6798__auto____$1.call(null, coll, n);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$3 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._nth[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__6798__auto__.call(null, coll, n, not_found);
    } else {
      var m__6798__auto____$1 = cljs.core._nth["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__6798__auto____$1.call(null, coll, n, not_found);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
};
cljs.core.ISeq = function() {
};
cljs.core._first = function cljs$core$_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_first$arity$1 == null)) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._first[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._first["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-first", coll);
      }
    }
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_rest$arity$1 == null)) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._rest[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._rest["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-rest", coll);
      }
    }
  }
};
cljs.core.INext = function() {
};
cljs.core._next = function cljs$core$_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$INext$_next$arity$1 == null)) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._next[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._next["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("INext.-next", coll);
      }
    }
  }
};
cljs.core.ILookup = function() {
};
cljs.core._lookup = function cljs$core$_lookup(var_args) {
  var args16178 = [];
  var len__7200__auto___16181 = arguments.length;
  var i__7201__auto___16182 = 0;
  while (true) {
    if (i__7201__auto___16182 < len__7200__auto___16181) {
      args16178.push(arguments[i__7201__auto___16182]);
      var G__16183 = i__7201__auto___16182 + 1;
      i__7201__auto___16182 = G__16183;
      continue;
    } else {
    }
    break;
  }
  var G__16180 = args16178.length;
  switch(G__16180) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16178.length)].join(""));;
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$2 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._lookup[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(o, k) : m__6798__auto__.call(null, o, k);
    } else {
      var m__6798__auto____$1 = cljs.core._lookup["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(o, k) : m__6798__auto____$1.call(null, o, k);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$3 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._lookup[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__6798__auto__.call(null, o, k, not_found);
    } else {
      var m__6798__auto____$1 = cljs.core._lookup["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__6798__auto____$1.call(null, o, k, not_found);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
};
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._contains_key_QMARK_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__6798__auto__.call(null, coll, k);
    } else {
      var m__6798__auto____$1 = cljs.core._contains_key_QMARK_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__6798__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
      }
    }
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_assoc$arity$3 == null)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._assoc[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__6798__auto__.call(null, coll, k, v);
    } else {
      var m__6798__auto____$1 = cljs.core._assoc["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__6798__auto____$1.call(null, coll, k, v);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
      }
    }
  }
};
cljs.core.IMap = function() {
};
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IMap$_dissoc$arity$2 == null)) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._dissoc[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__6798__auto__.call(null, coll, k);
    } else {
      var m__6798__auto____$1 = cljs.core._dissoc["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__6798__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IMap.-dissoc", coll);
      }
    }
  }
};
cljs.core.IMapEntry = function() {
};
cljs.core._key = function cljs$core$_key(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_key$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._key[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._key["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-key", coll);
      }
    }
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_val$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._val[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._val["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-val", coll);
      }
    }
  }
};
cljs.core.ISet = function() {
};
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (!(coll == null) && !(coll.cljs$core$ISet$_disjoin$arity$2 == null)) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._disjoin[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, v) : m__6798__auto__.call(null, coll, v);
    } else {
      var m__6798__auto____$1 = cljs.core._disjoin["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, v) : m__6798__auto____$1.call(null, coll, v);
      } else {
        throw cljs.core.missing_protocol("ISet.-disjoin", coll);
      }
    }
  }
};
cljs.core.IStack = function() {
};
cljs.core._peek = function cljs$core$_peek(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_peek$arity$1 == null)) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._peek[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._peek["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-peek", coll);
      }
    }
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_pop$arity$1 == null)) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._pop[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._pop["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-pop", coll);
      }
    }
  }
};
cljs.core.IVector = function() {
};
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (!(coll == null) && !(coll.cljs$core$IVector$_assoc_n$arity$3 == null)) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._assoc_n[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__6798__auto__.call(null, coll, n, val);
    } else {
      var m__6798__auto____$1 = cljs.core._assoc_n["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__6798__auto____$1.call(null, coll, n, val);
      } else {
        throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
      }
    }
  }
};
cljs.core.IDeref = function() {
};
cljs.core._deref = function cljs$core$_deref(o) {
  if (!(o == null) && !(o.cljs$core$IDeref$_deref$arity$1 == null)) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._deref[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto__.call(null, o);
    } else {
      var m__6798__auto____$1 = cljs.core._deref["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IDeref.-deref", o);
      }
    }
  }
};
cljs.core.IDerefWithTimeout = function() {
};
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (!(o == null) && !(o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._deref_with_timeout[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__6798__auto__.call(null, o, msec, timeout_val);
    } else {
      var m__6798__auto____$1 = cljs.core._deref_with_timeout["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__6798__auto____$1.call(null, o, msec, timeout_val);
      } else {
        throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
      }
    }
  }
};
cljs.core.IMeta = function() {
};
cljs.core._meta = function cljs$core$_meta(o) {
  if (!(o == null) && !(o.cljs$core$IMeta$_meta$arity$1 == null)) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._meta[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto__.call(null, o);
    } else {
      var m__6798__auto____$1 = cljs.core._meta["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IMeta.-meta", o);
      }
    }
  }
};
cljs.core.IWithMeta = function() {
};
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (!(o == null) && !(o.cljs$core$IWithMeta$_with_meta$arity$2 == null)) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._with_meta[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(o, meta) : m__6798__auto__.call(null, o, meta);
    } else {
      var m__6798__auto____$1 = cljs.core._with_meta["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(o, meta) : m__6798__auto____$1.call(null, o, meta);
      } else {
        throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
      }
    }
  }
};
cljs.core.IReduce = function() {
};
cljs.core._reduce = function cljs$core$_reduce(var_args) {
  var args16185 = [];
  var len__7200__auto___16188 = arguments.length;
  var i__7201__auto___16189 = 0;
  while (true) {
    if (i__7201__auto___16189 < len__7200__auto___16188) {
      args16185.push(arguments[i__7201__auto___16189]);
      var G__16190 = i__7201__auto___16189 + 1;
      i__7201__auto___16189 = G__16190;
      continue;
    } else {
    }
    break;
  }
  var G__16187 = args16185.length;
  switch(G__16187) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16185.length)].join(""));;
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$2 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._reduce[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, f) : m__6798__auto__.call(null, coll, f);
    } else {
      var m__6798__auto____$1 = cljs.core._reduce["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, f) : m__6798__auto____$1.call(null, coll, f);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$3 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._reduce[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__6798__auto__.call(null, coll, f, start);
    } else {
      var m__6798__auto____$1 = cljs.core._reduce["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__6798__auto____$1.call(null, coll, f, start);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
};
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (!(coll == null) && !(coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._kv_reduce[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__6798__auto__.call(null, coll, f, init);
    } else {
      var m__6798__auto____$1 = cljs.core._kv_reduce["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__6798__auto____$1.call(null, coll, f, init);
      } else {
        throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
      }
    }
  }
};
cljs.core.IEquiv = function() {
};
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (!(o == null) && !(o.cljs$core$IEquiv$_equiv$arity$2 == null)) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._equiv[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(o, other) : m__6798__auto__.call(null, o, other);
    } else {
      var m__6798__auto____$1 = cljs.core._equiv["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(o, other) : m__6798__auto____$1.call(null, o, other);
      } else {
        throw cljs.core.missing_protocol("IEquiv.-equiv", o);
      }
    }
  }
};
cljs.core.IHash = function() {
};
cljs.core._hash = function cljs$core$_hash(o) {
  if (!(o == null) && !(o.cljs$core$IHash$_hash$arity$1 == null)) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._hash[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto__.call(null, o);
    } else {
      var m__6798__auto____$1 = cljs.core._hash["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IHash.-hash", o);
      }
    }
  }
};
cljs.core.ISeqable = function() {
};
cljs.core._seq = function cljs$core$_seq(o) {
  if (!(o == null) && !(o.cljs$core$ISeqable$_seq$arity$1 == null)) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._seq[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto__.call(null, o);
    } else {
      var m__6798__auto____$1 = cljs.core._seq["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6798__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("ISeqable.-seq", o);
      }
    }
  }
};
cljs.core.ISequential = function() {
};
cljs.core.IList = function() {
};
cljs.core.IRecord = function() {
};
cljs.core.IReversible = function() {
};
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (!(coll == null) && !(coll.cljs$core$IReversible$_rseq$arity$1 == null)) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._rseq[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._rseq["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IReversible.-rseq", coll);
      }
    }
  }
};
cljs.core.ISorted = function() {
};
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._sorted_seq[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__6798__auto__.call(null, coll, ascending_QMARK_);
    } else {
      var m__6798__auto____$1 = cljs.core._sorted_seq["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__6798__auto____$1.call(null, coll, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
      }
    }
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._sorted_seq_from[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__6798__auto__.call(null, coll, k, ascending_QMARK_);
    } else {
      var m__6798__auto____$1 = cljs.core._sorted_seq_from["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__6798__auto____$1.call(null, coll, k, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
      }
    }
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_entry_key$arity$2 == null)) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._entry_key[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__6798__auto__.call(null, coll, entry);
    } else {
      var m__6798__auto____$1 = cljs.core._entry_key["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__6798__auto____$1.call(null, coll, entry);
      } else {
        throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
      }
    }
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_comparator$arity$1 == null)) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._comparator[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._comparator["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISorted.-comparator", coll);
      }
    }
  }
};
cljs.core.IWriter = function() {
};
cljs.core._write = function cljs$core$_write(writer, s) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_write$arity$2 == null)) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__6797__auto__ = writer == null ? null : writer;
    var m__6798__auto__ = cljs.core._write[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(writer, s) : m__6798__auto__.call(null, writer, s);
    } else {
      var m__6798__auto____$1 = cljs.core._write["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(writer, s) : m__6798__auto____$1.call(null, writer, s);
      } else {
        throw cljs.core.missing_protocol("IWriter.-write", writer);
      }
    }
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_flush$arity$1 == null)) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__6797__auto__ = writer == null ? null : writer;
    var m__6798__auto__ = cljs.core._flush[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__6798__auto__.call(null, writer);
    } else {
      var m__6798__auto____$1 = cljs.core._flush["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__6798__auto____$1.call(null, writer);
      } else {
        throw cljs.core.missing_protocol("IWriter.-flush", writer);
      }
    }
  }
};
cljs.core.IPrintWithWriter = function() {
};
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (!(o == null) && !(o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._pr_writer[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__6798__auto__.call(null, o, writer, opts);
    } else {
      var m__6798__auto____$1 = cljs.core._pr_writer["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__6798__auto____$1.call(null, o, writer, opts);
      } else {
        throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
      }
    }
  }
};
cljs.core.IPending = function() {
};
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(x) {
  if (!(x == null) && !(x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)) {
    return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
  } else {
    var x__6797__auto__ = x == null ? null : x;
    var m__6798__auto__ = cljs.core._realized_QMARK_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6798__auto__.call(null, x);
    } else {
      var m__6798__auto____$1 = cljs.core._realized_QMARK_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6798__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("IPending.-realized?", x);
      }
    }
  }
};
cljs.core.IWatchable = function() {
};
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._notify_watches[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__6798__auto__.call(null, this$, oldval, newval);
    } else {
      var m__6798__auto____$1 = cljs.core._notify_watches["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__6798__auto____$1.call(null, this$, oldval, newval);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
      }
    }
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_add_watch$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._add_watch[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__6798__auto__.call(null, this$, key, f);
    } else {
      var m__6798__auto____$1 = cljs.core._add_watch["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__6798__auto____$1.call(null, this$, key, f);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
      }
    }
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__6797__auto__ = this$ == null ? null : this$;
    var m__6798__auto__ = cljs.core._remove_watch[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(this$, key) : m__6798__auto__.call(null, this$, key);
    } else {
      var m__6798__auto____$1 = cljs.core._remove_watch["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, key) : m__6798__auto____$1.call(null, this$, key);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
      }
    }
  }
};
cljs.core.IEditableCollection = function() {
};
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._as_transient[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._as_transient["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
      }
    }
  }
};
cljs.core.ITransientCollection = function() {
};
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__6797__auto__ = tcoll == null ? null : tcoll;
    var m__6798__auto__ = cljs.core._conj_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__6798__auto__.call(null, tcoll, val);
    } else {
      var m__6798__auto____$1 = cljs.core._conj_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__6798__auto____$1.call(null, tcoll, val);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
      }
    }
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__6797__auto__ = tcoll == null ? null : tcoll;
    var m__6798__auto__ = cljs.core._persistent_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6798__auto__.call(null, tcoll);
    } else {
      var m__6798__auto____$1 = cljs.core._persistent_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6798__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
      }
    }
  }
};
cljs.core.ITransientAssociative = function() {
};
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__6797__auto__ = tcoll == null ? null : tcoll;
    var m__6798__auto__ = cljs.core._assoc_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__6798__auto__.call(null, tcoll, key, val);
    } else {
      var m__6798__auto____$1 = cljs.core._assoc_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__6798__auto____$1.call(null, tcoll, key, val);
      } else {
        throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientMap = function() {
};
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__6797__auto__ = tcoll == null ? null : tcoll;
    var m__6798__auto__ = cljs.core._dissoc_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__6798__auto__.call(null, tcoll, key);
    } else {
      var m__6798__auto____$1 = cljs.core._dissoc_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__6798__auto____$1.call(null, tcoll, key);
      } else {
        throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientVector = function() {
};
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__6797__auto__ = tcoll == null ? null : tcoll;
    var m__6798__auto__ = cljs.core._assoc_n_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__6798__auto__.call(null, tcoll, n, val);
    } else {
      var m__6798__auto____$1 = cljs.core._assoc_n_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__6798__auto____$1.call(null, tcoll, n, val);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
      }
    }
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__6797__auto__ = tcoll == null ? null : tcoll;
    var m__6798__auto__ = cljs.core._pop_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6798__auto__.call(null, tcoll);
    } else {
      var m__6798__auto____$1 = cljs.core._pop_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6798__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
      }
    }
  }
};
cljs.core.ITransientSet = function() {
};
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__6797__auto__ = tcoll == null ? null : tcoll;
    var m__6798__auto__ = cljs.core._disjoin_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__6798__auto__.call(null, tcoll, v);
    } else {
      var m__6798__auto____$1 = cljs.core._disjoin_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__6798__auto____$1.call(null, tcoll, v);
      } else {
        throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
      }
    }
  }
};
cljs.core.IComparable = function() {
};
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (!(x == null) && !(x.cljs$core$IComparable$_compare$arity$2 == null)) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__6797__auto__ = x == null ? null : x;
    var m__6798__auto__ = cljs.core._compare[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(x, y) : m__6798__auto__.call(null, x, y);
    } else {
      var m__6798__auto____$1 = cljs.core._compare["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(x, y) : m__6798__auto____$1.call(null, x, y);
      } else {
        throw cljs.core.missing_protocol("IComparable.-compare", x);
      }
    }
  }
};
cljs.core.IChunk = function() {
};
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunk$_drop_first$arity$1 == null)) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._drop_first[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._drop_first["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
      }
    }
  }
};
cljs.core.IChunkedSeq = function() {
};
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._chunked_first[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._chunked_first["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
      }
    }
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._chunked_rest[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._chunked_rest["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
      }
    }
  }
};
cljs.core.IChunkedNext = function() {
};
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._chunked_next[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._chunked_next["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
      }
    }
  }
};
cljs.core.INamed = function() {
};
cljs.core._name = function cljs$core$_name(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_name$arity$1 == null)) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__6797__auto__ = x == null ? null : x;
    var m__6798__auto__ = cljs.core._name[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6798__auto__.call(null, x);
    } else {
      var m__6798__auto____$1 = cljs.core._name["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6798__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-name", x);
      }
    }
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_namespace$arity$1 == null)) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__6797__auto__ = x == null ? null : x;
    var m__6798__auto__ = cljs.core._namespace[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6798__auto__.call(null, x);
    } else {
      var m__6798__auto____$1 = cljs.core._namespace["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6798__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-namespace", x);
      }
    }
  }
};
cljs.core.IAtom = function() {
};
cljs.core.IReset = function() {
};
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IReset$_reset_BANG_$arity$2 == null)) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._reset_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__6798__auto__.call(null, o, new_value);
    } else {
      var m__6798__auto____$1 = cljs.core._reset_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__6798__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IReset.-reset!", o);
      }
    }
  }
};
cljs.core.ISwap = function() {
};
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_(var_args) {
  var args16192 = [];
  var len__7200__auto___16195 = arguments.length;
  var i__7201__auto___16196 = 0;
  while (true) {
    if (i__7201__auto___16196 < len__7200__auto___16195) {
      args16192.push(arguments[i__7201__auto___16196]);
      var G__16197 = i__7201__auto___16196 + 1;
      i__7201__auto___16196 = G__16197;
      continue;
    } else {
    }
    break;
  }
  var G__16194 = args16192.length;
  switch(G__16194) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16192.length)].join(""));;
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(o, f) : m__6798__auto__.call(null, o, f);
    } else {
      var m__6798__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(o, f) : m__6798__auto____$1.call(null, o, f);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__6798__auto__.call(null, o, f, a);
    } else {
      var m__6798__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__6798__auto____$1.call(null, o, f, a);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__6798__auto__.call(null, o, f, a, b);
    } else {
      var m__6798__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__6798__auto____$1.call(null, o, f, a, b);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$5 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__6798__auto__.call(null, o, f, a, b, xs);
    } else {
      var m__6798__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__6798__auto____$1.call(null, o, f, a, b, xs);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
};
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__6797__auto__ = o == null ? null : o;
    var m__6798__auto__ = cljs.core._vreset_BANG_[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__6798__auto__.call(null, o, new_value);
    } else {
      var m__6798__auto____$1 = cljs.core._vreset_BANG_["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__6798__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
      }
    }
  }
};
cljs.core.IIterable = function() {
};
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (!(coll == null) && !(coll.cljs$core$IIterable$_iterator$arity$1 == null)) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__6797__auto__ = coll == null ? null : coll;
    var m__6798__auto__ = cljs.core._iterator[goog.typeOf(x__6797__auto__)];
    if (!(m__6798__auto__ == null)) {
      return m__6798__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto__.call(null, coll);
    } else {
      var m__6798__auto____$1 = cljs.core._iterator["_"];
      if (!(m__6798__auto____$1 == null)) {
        return m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6798__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6798__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IIterable.-iterator", coll);
      }
    }
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(Math.imul(4294967295, 5) === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    return Math.imul(a, b);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  var h1__$7 = h1__$6 ^ h1__$6 >>> 16;
  return h1__$7;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__16199 = i + 2;
        var G__16200 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__16199;
        h1 = G__16200;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__16203 = i + 1;
          var G__16204 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__16203;
          hash = G__16204;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  var h = cljs.core.string_hash_cache[k];
  if (typeof h === "number") {
    return h;
  } else {
    return cljs.core.add_to_string_hash_cache(k);
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 4194304 || o.cljs$core$IHash$ ? true : false : false) {
    return o.cljs$core$IHash$_hash$arity$1(null);
  } else {
    if (typeof o === "number") {
      return Math.floor(o) % 2147483647;
    } else {
      if (o === true) {
        return 1;
      } else {
        if (o === false) {
          return 0;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf();
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o);
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(c, x) {
  return x instanceof c;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__6130__auto__ = cljs.core.not(a.ns);
      if (and__6130__auto__) {
        return b.ns;
      } else {
        return and__6130__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__16217 = a.ns;
            var G__16218 = b.ns;
            return goog.array.defaultCompare(G__16217, G__16218);
          }();
          if (0 === nsc) {
            var G__16219 = a.name;
            var G__16220 = b.name;
            return goog.array.defaultCompare(G__16219, G__16220);
          } else {
            return nsc;
          }
        }
      } else {
        var G__16221 = a.name;
        var G__16222 = b.name;
        return goog.array.defaultCompare(G__16221, G__16222);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__16224 = null;
  var G__16224__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
  };
  var G__16224__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
  };
  G__16224 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16224__2.call(this, self__, coll);
      case 3:
        return G__16224__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16224.cljs$core$IFn$_invoke$arity$2 = G__16224__2;
  G__16224.cljs$core$IFn$_invoke$arity$3 = G__16224__3;
  return G__16224;
}();
cljs.core.Symbol.prototype.apply = function(self__, args16223) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16223)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym) : cljs.core.get.call(null, coll, sym);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found) : cljs.core.get.call(null, coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__6577__auto__ = self__._hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, 
  "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol(var_args) {
  var args16225 = [];
  var len__7200__auto___16228 = arguments.length;
  var i__7201__auto___16229 = 0;
  while (true) {
    if (i__7201__auto___16229 < len__7200__auto___16228) {
      args16225.push(arguments[i__7201__auto___16229]);
      var G__16230 = i__7201__auto___16229 + 1;
      i__7201__auto___16229 = G__16230;
      continue;
    } else {
    }
    break;
  }
  var G__16227 = args16225.length;
  switch(G__16227) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16225.length)].join(""));;
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    var idx = name.indexOf("/");
    if (idx === -1) {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
    } else {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring(0, idx), name.substring(idx + 1, name.length));
    }
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str(ns), cljs.core.str("/"), cljs.core.str(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2523137;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.isMacro = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Var(self__.val, self__.sym, new_meta);
};
cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  if (other instanceof cljs.core.Var) {
    var G__16233 = this$__$1.sym;
    var G__16234 = other.sym;
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__16233, G__16234) : cljs.core._EQ_.call(null, G__16233, G__16234);
  } else {
    return false;
  }
};
cljs.core.Var.prototype.cljs$core$Fn$ = true;
cljs.core.Var.prototype.call = function() {
  var G__16279 = null;
  var G__16279__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
  };
  var G__16279__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
  };
  var G__16279__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
  };
  var G__16279__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
  };
  var G__16279__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
  };
  var G__16279__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
  };
  var G__16279__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
  };
  var G__16279__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
  };
  var G__16279__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
  };
  var G__16279__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__16279__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__16279__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__16279__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__16279__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__16279__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__16279__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__16279__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__16279__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__16279__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__16279__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__16279__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__16279__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__16235 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    var G__16236 = a;
    var G__16237 = b;
    var G__16238 = c;
    var G__16239 = d;
    var G__16240 = e;
    var G__16241 = f;
    var G__16242 = g;
    var G__16243 = h;
    var G__16244 = i;
    var G__16245 = j;
    var G__16246 = k;
    var G__16247 = l;
    var G__16248 = m;
    var G__16249 = n;
    var G__16250 = o;
    var G__16251 = p;
    var G__16252 = q;
    var G__16253 = r;
    var G__16254 = s;
    var G__16255 = t;
    var G__16256 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__16235, G__16236, G__16237, G__16238, G__16239, G__16240, G__16241, G__16242, G__16243, G__16244, G__16245, G__16246, G__16247, G__16248, G__16249, G__16250, G__16251, G__16252, G__16253, G__16254, G__16255, G__16256) : cljs.core.apply.call(null, G__16235, G__16236, G__16237, G__16238, G__16239, G__16240, G__16241, G__16242, G__16243, G__16244, G__16245, G__16246, G__16247, G__16248, G__16249, 
    G__16250, G__16251, G__16252, G__16253, G__16254, G__16255, G__16256);
  };
  G__16279 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__16279__1.call(this, self__);
      case 2:
        return G__16279__2.call(this, self__, a);
      case 3:
        return G__16279__3.call(this, self__, a, b);
      case 4:
        return G__16279__4.call(this, self__, a, b, c);
      case 5:
        return G__16279__5.call(this, self__, a, b, c, d);
      case 6:
        return G__16279__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__16279__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__16279__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__16279__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__16279__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__16279__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__16279__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__16279__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__16279__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__16279__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__16279__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__16279__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__16279__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__16279__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__16279__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__16279__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__16279__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16279.cljs$core$IFn$_invoke$arity$1 = G__16279__1;
  G__16279.cljs$core$IFn$_invoke$arity$2 = G__16279__2;
  G__16279.cljs$core$IFn$_invoke$arity$3 = G__16279__3;
  G__16279.cljs$core$IFn$_invoke$arity$4 = G__16279__4;
  G__16279.cljs$core$IFn$_invoke$arity$5 = G__16279__5;
  G__16279.cljs$core$IFn$_invoke$arity$6 = G__16279__6;
  G__16279.cljs$core$IFn$_invoke$arity$7 = G__16279__7;
  G__16279.cljs$core$IFn$_invoke$arity$8 = G__16279__8;
  G__16279.cljs$core$IFn$_invoke$arity$9 = G__16279__9;
  G__16279.cljs$core$IFn$_invoke$arity$10 = G__16279__10;
  G__16279.cljs$core$IFn$_invoke$arity$11 = G__16279__11;
  G__16279.cljs$core$IFn$_invoke$arity$12 = G__16279__12;
  G__16279.cljs$core$IFn$_invoke$arity$13 = G__16279__13;
  G__16279.cljs$core$IFn$_invoke$arity$14 = G__16279__14;
  G__16279.cljs$core$IFn$_invoke$arity$15 = G__16279__15;
  G__16279.cljs$core$IFn$_invoke$arity$16 = G__16279__16;
  G__16279.cljs$core$IFn$_invoke$arity$17 = G__16279__17;
  G__16279.cljs$core$IFn$_invoke$arity$18 = G__16279__18;
  G__16279.cljs$core$IFn$_invoke$arity$19 = G__16279__19;
  G__16279.cljs$core$IFn$_invoke$arity$20 = G__16279__20;
  G__16279.cljs$core$IFn$_invoke$arity$21 = G__16279__21;
  G__16279.cljs$core$IFn$_invoke$arity$22 = G__16279__22;
  return G__16279;
}();
cljs.core.Var.prototype.apply = function(self__, args16232) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16232)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__16257 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  var G__16258 = a;
  var G__16259 = b;
  var G__16260 = c;
  var G__16261 = d;
  var G__16262 = e;
  var G__16263 = f;
  var G__16264 = g;
  var G__16265 = h;
  var G__16266 = i;
  var G__16267 = j;
  var G__16268 = k;
  var G__16269 = l;
  var G__16270 = m;
  var G__16271 = n;
  var G__16272 = o;
  var G__16273 = p;
  var G__16274 = q;
  var G__16275 = r;
  var G__16276 = s;
  var G__16277 = t;
  var G__16278 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__16257, G__16258, G__16259, G__16260, G__16261, G__16262, G__16263, G__16264, G__16265, G__16266, G__16267, G__16268, G__16269, G__16270, G__16271, G__16272, G__16273, G__16274, G__16275, G__16276, G__16277, G__16278) : cljs.core.apply.call(null, G__16257, G__16258, G__16259, G__16260, G__16261, G__16262, G__16263, G__16264, G__16265, G__16266, G__16267, G__16268, G__16269, G__16270, G__16271, 
  G__16272, G__16273, G__16274, G__16275, G__16276, G__16277, G__16278);
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  if (!(x == null)) {
    if (false || x.cljs$core$IIterable$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  if (!(value == null)) {
    if (value.cljs$lang$protocol_mask$partition1$ & 8192 || value.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!value.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || coll.cljs$core$ISeqable$ ? true : false : false) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str(coll), cljs.core.str(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 128 || coll.cljs$core$INext$ ? true : false : false) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_(var_args) {
  var args16292 = [];
  var len__7200__auto___16298 = arguments.length;
  var i__7201__auto___16299 = 0;
  while (true) {
    if (i__7201__auto___16299 < len__7200__auto___16298) {
      args16292.push(arguments[i__7201__auto___16299]);
      var G__16300 = i__7201__auto___16299 + 1;
      i__7201__auto___16299 = G__16300;
      continue;
    } else {
    }
    break;
  }
  var G__16297 = args16292.length;
  switch(G__16297) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16292.slice(2), 0);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__16302 = y;
        var G__16303 = cljs.core.first(more);
        var G__16304 = cljs.core.next(more);
        x = G__16302;
        y = G__16303;
        more = G__16304;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq16293) {
  var G__16294 = cljs.core.first(seq16293);
  var seq16293__$1 = cljs.core.next(seq16293);
  var G__16295 = cljs.core.first(seq16293__$1);
  var seq16293__$2 = cljs.core.next(seq16293__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16294, G__16295, seq16293__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null, self__.iter);
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__16305 = n + 1;
      var G__16306 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__16307 = cljs.core.next(coll__$1);
      n = G__16305;
      hash_code = G__16306;
      coll__$1 = G__16307;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__16308 = n + 1;
      var G__16309 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__16310 = cljs.core.next(coll__$1);
      n = G__16308;
      hash_code = G__16309;
      coll__$1 = G__16310;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = true;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__16311 = this$__$1.valueOf();
    var G__16312 = other.valueOf();
    return goog.array.defaultCompare(G__16311, G__16312);
  } else {
    throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(this$__$1), cljs.core.str(" to "), cljs.core.str(other)].join(""));
  }
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.Fn["function"] = true;
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  return goog.getUid(o);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null, x);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce(var_args) {
  var args16313 = [];
  var len__7200__auto___16322 = arguments.length;
  var i__7201__auto___16323 = 0;
  while (true) {
    if (i__7201__auto___16323 < len__7200__auto___16322) {
      args16313.push(arguments[i__7201__auto___16323]);
      var G__16324 = i__7201__auto___16323 + 1;
      i__7201__auto___16323 = G__16324;
      continue;
    } else {
    }
    break;
  }
  var G__16315 = args16313.length;
  switch(G__16315) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16313.length)].join(""));;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__16316 = val;
          var G__16317 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16316, G__16317) : f.call(null, G__16316, G__16317);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__16326 = nval;
          var G__16327 = n + 1;
          val = G__16326;
          n = G__16327;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__16318 = val__$1;
        var G__16319 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16318, G__16319) : f.call(null, G__16318, G__16319);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__16328 = nval;
        var G__16329 = n + 1;
        val__$1 = G__16328;
        n = G__16329;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__16320 = val__$1;
        var G__16321 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16320, G__16321) : f.call(null, G__16320, G__16321);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__16330 = nval;
        var G__16331 = n + 1;
        val__$1 = G__16330;
        n = G__16331;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce(var_args) {
  var args16332 = [];
  var len__7200__auto___16341 = arguments.length;
  var i__7201__auto___16342 = 0;
  while (true) {
    if (i__7201__auto___16342 < len__7200__auto___16341) {
      args16332.push(arguments[i__7201__auto___16342]);
      var G__16343 = i__7201__auto___16342 + 1;
      i__7201__auto___16342 = G__16343;
      continue;
    } else {
    }
    break;
  }
  var G__16334 = args16332.length;
  switch(G__16334) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16332.length)].join(""));;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__16335 = val;
          var G__16336 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16335, G__16336) : f.call(null, G__16335, G__16336);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__16345 = nval;
          var G__16346 = n + 1;
          val = G__16345;
          n = G__16346;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__16337 = val__$1;
        var G__16338 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16337, G__16338) : f.call(null, G__16337, G__16338);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__16347 = nval;
        var G__16348 = n + 1;
        val__$1 = G__16347;
        n = G__16348;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__16339 = val__$1;
        var G__16340 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16339, G__16340) : f.call(null, G__16339, G__16340);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__16349 = nval;
        var G__16350 = n + 1;
        val__$1 = G__16349;
        n = G__16350;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 2 || x.cljs$core$ICounted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16 || x.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
  }
};
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i) {
  this.arr = arr;
  this.i = i;
  this.cljs$lang$protocol_mask$partition0$ = 166199550;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__6473__auto__ = 0;
  var y__6474__auto__ = self__.arr.length - self__.i;
  return x__6473__auto__ > y__6474__auto__ ? x__6473__auto__ : y__6474__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = cljs.core._count(coll__$1);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i) {
  return new cljs.core.IndexedSeq(arr, i);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq(var_args) {
  var args16355 = [];
  var len__7200__auto___16358 = arguments.length;
  var i__7201__auto___16359 = 0;
  while (true) {
    if (i__7201__auto___16359 < len__7200__auto___16358) {
      args16355.push(arguments[i__7201__auto___16359]);
      var G__16360 = i__7201__auto___16359 + 1;
      i__7201__auto___16359 = G__16360;
      continue;
    } else {
    }
    break;
  }
  var G__16357 = args16355.length;
  switch(G__16357) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16355.length)].join(""));;
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq(var_args) {
  var args16362 = [];
  var len__7200__auto___16365 = arguments.length;
  var i__7201__auto___16366 = 0;
  while (true) {
    if (i__7201__auto___16366 < len__7200__auto___16365) {
      args16362.push(arguments[i__7201__auto___16366]);
      var G__16367 = i__7201__auto___16366 + 1;
      i__7201__auto___16366 = G__16367;
      continue;
    } else {
    }
    break;
  }
  var G__16364 = args16362.length;
  switch(G__16364) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16362.length)].join(""));;
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1, other) : cljs.core.equiv_sequential.call(null, coll__$1, other);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__16369 = cljs.core.List.EMPTY;
  var G__16370 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__16369, G__16370) : cljs.core.with_meta.call(null, G__16369, G__16370);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, col__$1) : cljs.core.seq_reduce.call(null, f, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, col__$1) : cljs.core.seq_reduce.call(null, f, start, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o, coll__$1) : cljs.core.cons.call(null, o, coll__$1);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__16371 = sn;
      s = G__16371;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj(var_args) {
  var args16372 = [];
  var len__7200__auto___16378 = arguments.length;
  var i__7201__auto___16379 = 0;
  while (true) {
    if (i__7201__auto___16379 < len__7200__auto___16378) {
      args16372.push(arguments[i__7201__auto___16379]);
      var G__16380 = i__7201__auto___16379 + 1;
      i__7201__auto___16379 = G__16380;
      continue;
    } else {
    }
    break;
  }
  var G__16377 = args16372.length;
  switch(G__16377) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16372.slice(2), 0);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    return cljs.core._conj(cljs.core.List.EMPTY, x);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__16382 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__16383 = cljs.core.first(xs);
      var G__16384 = cljs.core.next(xs);
      coll = G__16382;
      x = G__16383;
      xs = G__16384;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq16373) {
  var G__16374 = cljs.core.first(seq16373);
  var seq16373__$1 = cljs.core.next(seq16373);
  var G__16375 = cljs.core.first(seq16373__$1);
  var seq16373__$2 = cljs.core.next(seq16373__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__16374, G__16375, seq16373__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__16385 = cljs.core.next(s);
      var G__16386 = acc + 1;
      s = G__16385;
      acc = G__16386;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 2 || coll.cljs$core$ICounted$ ? true : false : false) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || coll.cljs$core$ISeqable$ ? true : false : false) {
            return cljs.core.accumulating_seq_count(coll);
          } else {
            return cljs.core._count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth(var_args) {
  var args16391 = [];
  var len__7200__auto___16394 = arguments.length;
  var i__7201__auto___16395 = 0;
  while (true) {
    if (i__7201__auto___16395 < len__7200__auto___16394) {
      args16391.push(arguments[i__7201__auto___16395]);
      var G__16396 = i__7201__auto___16395 + 1;
      i__7201__auto___16395 = G__16396;
      continue;
    } else {
    }
    break;
  }
  var G__16393 = args16391.length;
  switch(G__16393) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16391.length)].join(""));;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__16398 = cljs.core.next(coll);
            var G__16399 = n - 1;
            coll = G__16398;
            n = G__16399;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__16400 = cljs.core.next(coll);
            var G__16401 = n - 1;
            var G__16402 = not_found;
            coll = G__16400;
            n = G__16401;
            not_found = G__16402;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth(var_args) {
  var args16403 = [];
  var len__7200__auto___16410 = arguments.length;
  var i__7201__auto___16411 = 0;
  while (true) {
    if (i__7201__auto___16411 < len__7200__auto___16410) {
      args16403.push(arguments[i__7201__auto___16411]);
      var G__16412 = i__7201__auto___16411 + 1;
      i__7201__auto___16411 = G__16412;
      continue;
    } else {
    }
    break;
  }
  var G__16405 = args16403.length;
  switch(G__16405) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16403.length)].join(""));;
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return null;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll.charAt(n);
            } else {
              return null;
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll.charAt(n);
            } else {
              return not_found;
            }
          } else {
            if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$ ? true : false : false) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__16414 = n__$1 - 1;
      var G__16415 = cljs.core.rest(xs);
      n__$1 = G__16414;
      xs = G__16415;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get(var_args) {
  var args16416 = [];
  var len__7200__auto___16421 = arguments.length;
  var i__7201__auto___16422 = 0;
  while (true) {
    if (i__7201__auto___16422 < len__7200__auto___16421) {
      args16416.push(arguments[i__7201__auto___16422]);
      var G__16423 = i__7201__auto___16422 + 1;
      i__7201__auto___16422 = G__16423;
      continue;
    } else {
    }
    break;
  }
  var G__16418 = args16416.length;
  switch(G__16418) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16416.length)].join(""));;
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k | 0];
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k];
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc(var_args) {
  var args16425 = [];
  var len__7200__auto___16432 = arguments.length;
  var i__7201__auto___16433 = 0;
  while (true) {
    if (i__7201__auto___16433 < len__7200__auto___16432) {
      args16425.push(arguments[i__7201__auto___16433]);
      var G__16434 = i__7201__auto___16433 + 1;
      i__7201__auto___16433 = G__16434;
      continue;
    } else {
    }
    break;
  }
  var G__16431 = args16425.length;
  switch(G__16431) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16425.slice(3), 0);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7219__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentHashMap.fromArrays([k], [v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__16436 = ret;
      var G__16437 = cljs.core.first(kvs);
      var G__16438 = cljs.core.second(kvs);
      var G__16439 = cljs.core.nnext(kvs);
      coll = G__16436;
      k = G__16437;
      v = G__16438;
      kvs = G__16439;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq16426) {
  var G__16427 = cljs.core.first(seq16426);
  var seq16426__$1 = cljs.core.next(seq16426);
  var G__16428 = cljs.core.first(seq16426__$1);
  var seq16426__$2 = cljs.core.next(seq16426__$1);
  var G__16429 = cljs.core.first(seq16426__$2);
  var seq16426__$3 = cljs.core.next(seq16426__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__16427, G__16428, G__16429, seq16426__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc(var_args) {
  var args16440 = [];
  var len__7200__auto___16446 = arguments.length;
  var i__7201__auto___16447 = 0;
  while (true) {
    if (i__7201__auto___16447 < len__7200__auto___16446) {
      args16440.push(arguments[i__7201__auto___16447]);
      var G__16448 = i__7201__auto___16447 + 1;
      i__7201__auto___16447 = G__16448;
      continue;
    } else {
    }
    break;
  }
  var G__16445 = args16440.length;
  switch(G__16445) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16440.slice(2), 0);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__16450 = ret;
        var G__16451 = cljs.core.first(ks);
        var G__16452 = cljs.core.next(ks);
        coll = G__16450;
        k = G__16451;
        ks = G__16452;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq16441) {
  var G__16442 = cljs.core.first(seq16441);
  var seq16441__$1 = cljs.core.next(seq16441);
  var G__16443 = cljs.core.first(seq16441__$1);
  var seq16441__$2 = cljs.core.next(seq16441__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__16442, G__16443, seq16441__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__6142__auto__ = goog.isFunction(f);
  if (or__6142__auto__) {
    return or__6142__auto__;
  } else {
    if (!(f == null)) {
      if (false || f.cljs$core$Fn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;
cljs.core.MetaFn.prototype.call = function() {
  var G__16458 = null;
  var G__16458__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__16458__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
  };
  var G__16458__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
  };
  var G__16458__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
  };
  var G__16458__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
  };
  var G__16458__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
  };
  var G__16458__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
  };
  var G__16458__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
  };
  var G__16458__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
  };
  var G__16458__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__16458__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__16458__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__16458__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__16458__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__16458__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__16458__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__16458__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__16458__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__16458__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__16458__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__16458__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__16458__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  };
  G__16458 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__16458__1.call(this, self__);
      case 2:
        return G__16458__2.call(this, self__, a);
      case 3:
        return G__16458__3.call(this, self__, a, b);
      case 4:
        return G__16458__4.call(this, self__, a, b, c);
      case 5:
        return G__16458__5.call(this, self__, a, b, c, d);
      case 6:
        return G__16458__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__16458__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__16458__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__16458__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__16458__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__16458__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__16458__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__16458__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__16458__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__16458__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__16458__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__16458__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__16458__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__16458__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__16458__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__16458__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__16458__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16458.cljs$core$IFn$_invoke$arity$1 = G__16458__1;
  G__16458.cljs$core$IFn$_invoke$arity$2 = G__16458__2;
  G__16458.cljs$core$IFn$_invoke$arity$3 = G__16458__3;
  G__16458.cljs$core$IFn$_invoke$arity$4 = G__16458__4;
  G__16458.cljs$core$IFn$_invoke$arity$5 = G__16458__5;
  G__16458.cljs$core$IFn$_invoke$arity$6 = G__16458__6;
  G__16458.cljs$core$IFn$_invoke$arity$7 = G__16458__7;
  G__16458.cljs$core$IFn$_invoke$arity$8 = G__16458__8;
  G__16458.cljs$core$IFn$_invoke$arity$9 = G__16458__9;
  G__16458.cljs$core$IFn$_invoke$arity$10 = G__16458__10;
  G__16458.cljs$core$IFn$_invoke$arity$11 = G__16458__11;
  G__16458.cljs$core$IFn$_invoke$arity$12 = G__16458__12;
  G__16458.cljs$core$IFn$_invoke$arity$13 = G__16458__13;
  G__16458.cljs$core$IFn$_invoke$arity$14 = G__16458__14;
  G__16458.cljs$core$IFn$_invoke$arity$15 = G__16458__15;
  G__16458.cljs$core$IFn$_invoke$arity$16 = G__16458__16;
  G__16458.cljs$core$IFn$_invoke$arity$17 = G__16458__17;
  G__16458.cljs$core$IFn$_invoke$arity$18 = G__16458__18;
  G__16458.cljs$core$IFn$_invoke$arity$19 = G__16458__19;
  G__16458.cljs$core$IFn$_invoke$arity$20 = G__16458__20;
  G__16458.cljs$core$IFn$_invoke$arity$21 = G__16458__21;
  G__16458.cljs$core$IFn$_invoke$arity$22 = G__16458__22;
  return G__16458;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args16457) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16457)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : cljs.core.apply.call(null, self__.afn, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (goog.isFunction(o)) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__6130__auto__ = !(o == null);
    if (and__6130__auto__) {
      if (!(o == null)) {
        if (o.cljs$lang$protocol_mask$partition0$ & 131072 || o.cljs$core$IMeta$) {
          return true;
        } else {
          if (!o.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
      }
    } else {
      return and__6130__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj(var_args) {
  var args16463 = [];
  var len__7200__auto___16469 = arguments.length;
  var i__7201__auto___16470 = 0;
  while (true) {
    if (i__7201__auto___16470 < len__7200__auto___16469) {
      args16463.push(arguments[i__7201__auto___16470]);
      var G__16471 = i__7201__auto___16470 + 1;
      i__7201__auto___16470 = G__16471;
      continue;
    } else {
    }
    break;
  }
  var G__16468 = args16463.length;
  switch(G__16468) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16463.slice(2), 0);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__16473 = ret;
        var G__16474 = cljs.core.first(ks);
        var G__16475 = cljs.core.next(ks);
        coll = G__16473;
        k = G__16474;
        ks = G__16475;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq16464) {
  var G__16465 = cljs.core.first(seq16464);
  var seq16464__$1 = cljs.core.next(seq16464);
  var G__16466 = cljs.core.first(seq16464__$1);
  var seq16464__$2 = cljs.core.next(seq16464__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__16465, G__16466, seq16464__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 8 || x.cljs$core$ICollection$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 4096 || x.cljs$core$ISet$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 512 || x.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16777216 || x.cljs$core$ISequential$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 268435456 || x.cljs$core$ISorted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 524288 || x.cljs$core$IReduce$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 1024 || x.cljs$core$IMap$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 67108864 || x.cljs$core$IRecord$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16384 || x.cljs$core$IVector$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition1$ & 512 || x.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj(var_args) {
  var args16496 = [];
  var len__7200__auto___16502 = arguments.length;
  var i__7201__auto___16503 = 0;
  while (true) {
    if (i__7201__auto___16503 < len__7200__auto___16502) {
      args16496.push(arguments[i__7201__auto___16503]);
      var G__16504 = i__7201__auto___16503 + 1;
      i__7201__auto___16503 = G__16504;
      continue;
    } else {
    }
    break;
  }
  var G__16499 = args16496.length;
  switch(G__16499) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16496.slice(0), 0);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  return {};
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create, keyvals) : cljs.core.apply.call(null, goog.object.create, keyvals);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq16497) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16497));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__16508_16510 = obj;
  var G__16509_16511 = function(G__16508_16510, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__16508_16510, keys);
  goog.object.forEach(G__16508_16510, G__16509_16511);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__16512 = i__$1 + 1;
      var G__16513 = j__$1 + 1;
      var G__16514 = len__$1 - 1;
      i__$1 = G__16512;
      j__$1 = G__16513;
      len__$1 = G__16514;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__16515 = i__$1 - 1;
      var G__16516 = j__$1 - 1;
      var G__16517 = len__$1 - 1;
      i__$1 = G__16515;
      j__$1 = G__16516;
      len__$1 = G__16517;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    if (!(s == null)) {
      if (s.cljs$lang$protocol_mask$partition0$ & 64 || s.cljs$core$ISeq$) {
        return true;
      } else {
        if (!s.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  if (!(s == null)) {
    if (s.cljs$lang$protocol_mask$partition0$ & 8388608 || s.cljs$core$ISeqable$) {
      return true;
    } else {
      if (!s.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (x == null) {
    return false;
  } else {
    if (x === false) {
      return false;
    } else {
      return true;
    }
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__6142__auto__ = cljs.core.fn_QMARK_(f);
  if (or__6142__auto__) {
    return or__6142__auto__;
  } else {
    if (!(f == null)) {
      if (f.cljs$lang$protocol_mask$partition0$ & 1 || f.cljs$core$IFn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && !isNaN(n) && !(n === Infinity) && parseFloat(n) === parseInt(n, 10);
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_(var_args) {
  var args16528 = [];
  var len__7200__auto___16534 = arguments.length;
  var i__7201__auto___16535 = 0;
  while (true) {
    if (i__7201__auto___16535 < len__7200__auto___16534) {
      args16528.push(arguments[i__7201__auto___16535]);
      var G__16536 = i__7201__auto___16535 + 1;
      i__7201__auto___16535 = G__16536;
      continue;
    } else {
    }
    break;
  }
  var G__16533 = args16528.length;
  switch(G__16533) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16528.slice(2), 0);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.fromArray([x, y], true);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__16538 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__16539 = etc;
          s = G__16538;
          xs = G__16539;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq16529) {
  var G__16530 = cljs.core.first(seq16529);
  var seq16529__$1 = cljs.core.next(seq16529);
  var G__16531 = cljs.core.first(seq16529__$1);
  var seq16529__$2 = cljs.core.next(seq16529__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__16530, G__16531, seq16529__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            return goog.array.defaultCompare(x, y);
          } else {
            throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
          }
        } else {
          if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 2048 || x.cljs$core$IComparable$ ? true : !x.cljs$lang$protocol_mask$partition1$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x)) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              return goog.array.defaultCompare(x, y);
            } else {
              throw new Error([cljs.core.str("Cannot compare "), cljs.core.str(x), cljs.core.str(" to "), cljs.core.str(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed(var_args) {
  var args16542 = [];
  var len__7200__auto___16545 = arguments.length;
  var i__7201__auto___16546 = 0;
  while (true) {
    if (i__7201__auto___16546 < len__7200__auto___16545) {
      args16542.push(arguments[i__7201__auto___16546]);
      var G__16547 = i__7201__auto___16546 + 1;
      i__7201__auto___16546 = G__16547;
      continue;
    } else {
    }
    break;
  }
  var G__16544 = args16542.length;
  switch(G__16544) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16542.length)].join(""));;
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__16549 = xs;
      var G__16550 = ys;
      var G__16551 = len;
      var G__16552 = n + 1;
      xs = G__16549;
      ys = G__16550;
      len = G__16551;
      n = G__16552;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y, x) : f.call(null, y, x))) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort(var_args) {
  var args16553 = [];
  var len__7200__auto___16558 = arguments.length;
  var i__7201__auto___16559 = 0;
  while (true) {
    if (i__7201__auto___16559 < len__7200__auto___16558) {
      args16553.push(arguments[i__7201__auto___16559]);
      var G__16560 = i__7201__auto___16559 + 1;
      i__7201__auto___16559 = G__16560;
      continue;
    } else {
    }
    break;
  }
  var G__16555 = args16553.length;
  switch(G__16555) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16553.length)].join(""));;
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
    var G__16556_16562 = a;
    var G__16557_16563 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__16556_16562, G__16557_16563);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by(var_args) {
  var args16564 = [];
  var len__7200__auto___16567 = arguments.length;
  var i__7201__auto___16568 = 0;
  while (true) {
    if (i__7201__auto___16568 < len__7200__auto___16567) {
      args16564.push(arguments[i__7201__auto___16568]);
      var G__16569 = i__7201__auto___16568 + 1;
      i__7201__auto___16568 = G__16569;
      continue;
    } else {
    }
    break;
  }
  var G__16566 = args16564.length;
  switch(G__16566) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16564.length)].join(""));;
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null, x), keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null, y));
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce(var_args) {
  var args16571 = [];
  var len__7200__auto___16579 = arguments.length;
  var i__7201__auto___16580 = 0;
  while (true) {
    if (i__7201__auto___16580 < len__7200__auto___16579) {
      args16571.push(arguments[i__7201__auto___16580]);
      var G__16581 = i__7201__auto___16580 + 1;
      i__7201__auto___16580 = G__16581;
      continue;
    } else {
    }
    break;
  }
  var G__16573 = args16571.length;
  switch(G__16573) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16571.length)].join(""));;
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__4423__auto__ = cljs.core.seq(coll);
  if (temp__4423__auto__) {
    var s = temp__4423__auto__;
    var G__16574 = f;
    var G__16575 = cljs.core.first(s);
    var G__16576 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__16574, G__16575, G__16576) : cljs.core.reduce.call(null, G__16574, G__16575, G__16576);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__16577 = val__$1;
        var G__16578 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16577, G__16578) : f.call(null, G__16577, G__16578);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__16583 = nval;
        var G__16584 = cljs.core.next(coll__$1);
        val__$1 = G__16583;
        coll__$1 = G__16584;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null, coll);
  goog.array.shuffle(a);
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null, a);
};
cljs.core.reduce = function cljs$core$reduce(var_args) {
  var args16585 = [];
  var len__7200__auto___16590 = arguments.length;
  var i__7201__auto___16591 = 0;
  while (true) {
    if (i__7201__auto___16591 < len__7200__auto___16590) {
      args16585.push(arguments[i__7201__auto___16591]);
      var G__16592 = i__7201__auto___16591 + 1;
      i__7201__auto___16591 = G__16592;
      continue;
    } else {
    }
    break;
  }
  var G__16587 = args16585.length;
  switch(G__16587) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16585.length)].join(""));;
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing(var_args) {
  var args16594 = [];
  var len__7200__auto___16597 = arguments.length;
  var i__7201__auto___16598 = 0;
  while (true) {
    if (i__7201__auto___16598 < len__7200__auto___16597) {
      args16594.push(arguments[i__7201__auto___16598]);
      var G__16599 = i__7201__auto___16598 + 1;
      i__7201__auto___16598 = G__16599;
      continue;
    } else {
    }
    break;
  }
  var G__16596 = args16594.length;
  switch(G__16596) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16594.length)].join(""));;
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__16601 = null;
    var G__16601__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__16601__1 = function(x) {
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null, x);
    };
    var G__16601__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
    };
    G__16601 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__16601__0.call(this);
        case 1:
          return G__16601__1.call(this, x);
        case 2:
          return G__16601__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__16601.cljs$core$IFn$_invoke$arity$0 = G__16601__0;
    G__16601.cljs$core$IFn$_invoke$arity$1 = G__16601__1;
    G__16601.cljs$core$IFn$_invoke$arity$2 = G__16601__2;
    return G__16601;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce(var_args) {
  var args16602 = [];
  var len__7200__auto___16605 = arguments.length;
  var i__7201__auto___16606 = 0;
  while (true) {
    if (i__7201__auto___16606 < len__7200__auto___16605) {
      args16602.push(arguments[i__7201__auto___16606]);
      var G__16607 = i__7201__auto___16606 + 1;
      i__7201__auto___16606 = G__16607;
      continue;
    } else {
    }
    break;
  }
  var G__16604 = args16602.length;
  switch(G__16604) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16602.length)].join(""));;
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f);
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null, ret);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_(var_args) {
  var args16609 = [];
  var len__7200__auto___16615 = arguments.length;
  var i__7201__auto___16616 = 0;
  while (true) {
    if (i__7201__auto___16616 < len__7200__auto___16615) {
      args16609.push(arguments[i__7201__auto___16616]);
      var G__16617 = i__7201__auto___16616 + 1;
      i__7201__auto___16616 = G__16617;
      continue;
    } else {
    }
    break;
  }
  var G__16614 = args16609.length;
  switch(G__16614) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16609.slice(2), 0);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq16610) {
  var G__16611 = cljs.core.first(seq16610);
  var seq16610__$1 = cljs.core.next(seq16610);
  var G__16612 = cljs.core.first(seq16610__$1);
  var seq16610__$2 = cljs.core.next(seq16610__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__16611, G__16612, seq16610__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_(var_args) {
  var args16619 = [];
  var len__7200__auto___16625 = arguments.length;
  var i__7201__auto___16626 = 0;
  while (true) {
    if (i__7201__auto___16626 < len__7200__auto___16625) {
      args16619.push(arguments[i__7201__auto___16626]);
      var G__16627 = i__7201__auto___16626 + 1;
      i__7201__auto___16626 = G__16627;
      continue;
    } else {
    }
    break;
  }
  var G__16624 = args16619.length;
  switch(G__16624) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16619.slice(2), 0);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq16620) {
  var G__16621 = cljs.core.first(seq16620);
  var seq16620__$1 = cljs.core.next(seq16620);
  var G__16622 = cljs.core.first(seq16620__$1);
  var seq16620__$2 = cljs.core.next(seq16620__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__16621, G__16622, seq16620__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_(var_args) {
  var args16629 = [];
  var len__7200__auto___16635 = arguments.length;
  var i__7201__auto___16636 = 0;
  while (true) {
    if (i__7201__auto___16636 < len__7200__auto___16635) {
      args16629.push(arguments[i__7201__auto___16636]);
      var G__16637 = i__7201__auto___16636 + 1;
      i__7201__auto___16636 = G__16637;
      continue;
    } else {
    }
    break;
  }
  var G__16634 = args16629.length;
  switch(G__16634) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16629.slice(2), 0);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq16630) {
  var G__16631 = cljs.core.first(seq16630);
  var seq16630__$1 = cljs.core.next(seq16630);
  var G__16632 = cljs.core.first(seq16630__$1);
  var seq16630__$2 = cljs.core.next(seq16630__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__16631, G__16632, seq16630__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_(var_args) {
  var args16639 = [];
  var len__7200__auto___16645 = arguments.length;
  var i__7201__auto___16646 = 0;
  while (true) {
    if (i__7201__auto___16646 < len__7200__auto___16645) {
      args16639.push(arguments[i__7201__auto___16646]);
      var G__16647 = i__7201__auto___16646 + 1;
      i__7201__auto___16646 = G__16647;
      continue;
    } else {
    }
    break;
  }
  var G__16644 = args16639.length;
  switch(G__16644) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16639.slice(2), 0);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq16640) {
  var G__16641 = cljs.core.first(seq16640);
  var seq16640__$1 = cljs.core.next(seq16640);
  var G__16642 = cljs.core.first(seq16640__$1);
  var seq16640__$2 = cljs.core.next(seq16640__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__16641, G__16642, seq16640__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_(var_args) {
  var args16649 = [];
  var len__7200__auto___16655 = arguments.length;
  var i__7201__auto___16656 = 0;
  while (true) {
    if (i__7201__auto___16656 < len__7200__auto___16655) {
      args16649.push(arguments[i__7201__auto___16656]);
      var G__16657 = i__7201__auto___16656 + 1;
      i__7201__auto___16656 = G__16657;
      continue;
    } else {
    }
    break;
  }
  var G__16654 = args16649.length;
  switch(G__16654) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16649.slice(2), 0);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__16659 = y;
        var G__16660 = cljs.core.first(more);
        var G__16661 = cljs.core.next(more);
        x = G__16659;
        y = G__16660;
        more = G__16661;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq16650) {
  var G__16651 = cljs.core.first(seq16650);
  var seq16650__$1 = cljs.core.next(seq16650);
  var G__16652 = cljs.core.first(seq16650__$1);
  var seq16650__$2 = cljs.core.next(seq16650__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__16651, G__16652, seq16650__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_(var_args) {
  var args16662 = [];
  var len__7200__auto___16668 = arguments.length;
  var i__7201__auto___16669 = 0;
  while (true) {
    if (i__7201__auto___16669 < len__7200__auto___16668) {
      args16662.push(arguments[i__7201__auto___16669]);
      var G__16670 = i__7201__auto___16669 + 1;
      i__7201__auto___16669 = G__16670;
      continue;
    } else {
    }
    break;
  }
  var G__16667 = args16662.length;
  switch(G__16667) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16662.slice(2), 0);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__16672 = y;
        var G__16673 = cljs.core.first(more);
        var G__16674 = cljs.core.next(more);
        x = G__16672;
        y = G__16673;
        more = G__16674;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq16663) {
  var G__16664 = cljs.core.first(seq16663);
  var seq16663__$1 = cljs.core.next(seq16663);
  var G__16665 = cljs.core.first(seq16663__$1);
  var seq16663__$2 = cljs.core.next(seq16663__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16664, G__16665, seq16663__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_(var_args) {
  var args16675 = [];
  var len__7200__auto___16681 = arguments.length;
  var i__7201__auto___16682 = 0;
  while (true) {
    if (i__7201__auto___16682 < len__7200__auto___16681) {
      args16675.push(arguments[i__7201__auto___16682]);
      var G__16683 = i__7201__auto___16682 + 1;
      i__7201__auto___16682 = G__16683;
      continue;
    } else {
    }
    break;
  }
  var G__16680 = args16675.length;
  switch(G__16680) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16675.slice(2), 0);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__16685 = y;
        var G__16686 = cljs.core.first(more);
        var G__16687 = cljs.core.next(more);
        x = G__16685;
        y = G__16686;
        more = G__16687;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq16676) {
  var G__16677 = cljs.core.first(seq16676);
  var seq16676__$1 = cljs.core.next(seq16676);
  var G__16678 = cljs.core.first(seq16676__$1);
  var seq16676__$2 = cljs.core.next(seq16676__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__16677, G__16678, seq16676__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_(var_args) {
  var args16688 = [];
  var len__7200__auto___16694 = arguments.length;
  var i__7201__auto___16695 = 0;
  while (true) {
    if (i__7201__auto___16695 < len__7200__auto___16694) {
      args16688.push(arguments[i__7201__auto___16695]);
      var G__16696 = i__7201__auto___16695 + 1;
      i__7201__auto___16695 = G__16696;
      continue;
    } else {
    }
    break;
  }
  var G__16693 = args16688.length;
  switch(G__16693) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16688.slice(2), 0);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__16698 = y;
        var G__16699 = cljs.core.first(more);
        var G__16700 = cljs.core.next(more);
        x = G__16698;
        y = G__16699;
        more = G__16700;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq16689) {
  var G__16690 = cljs.core.first(seq16689);
  var seq16689__$1 = cljs.core.next(seq16689);
  var G__16691 = cljs.core.first(seq16689__$1);
  var seq16689__$2 = cljs.core.next(seq16689__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16690, G__16691, seq16689__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max(var_args) {
  var args16701 = [];
  var len__7200__auto___16707 = arguments.length;
  var i__7201__auto___16708 = 0;
  while (true) {
    if (i__7201__auto___16708 < len__7200__auto___16707) {
      args16701.push(arguments[i__7201__auto___16708]);
      var G__16709 = i__7201__auto___16708 + 1;
      i__7201__auto___16708 = G__16709;
      continue;
    } else {
    }
    break;
  }
  var G__16706 = args16701.length;
  switch(G__16706) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16701.slice(2), 0);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__6473__auto__ = x;
  var y__6474__auto__ = y;
  return x__6473__auto__ > y__6474__auto__ ? x__6473__auto__ : y__6474__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__6473__auto__ = x;
    var y__6474__auto__ = y;
    return x__6473__auto__ > y__6474__auto__ ? x__6473__auto__ : y__6474__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq16702) {
  var G__16703 = cljs.core.first(seq16702);
  var seq16702__$1 = cljs.core.next(seq16702);
  var G__16704 = cljs.core.first(seq16702__$1);
  var seq16702__$2 = cljs.core.next(seq16702__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__16703, G__16704, seq16702__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min(var_args) {
  var args16711 = [];
  var len__7200__auto___16717 = arguments.length;
  var i__7201__auto___16718 = 0;
  while (true) {
    if (i__7201__auto___16718 < len__7200__auto___16717) {
      args16711.push(arguments[i__7201__auto___16718]);
      var G__16719 = i__7201__auto___16718 + 1;
      i__7201__auto___16718 = G__16719;
      continue;
    } else {
    }
    break;
  }
  var G__16716 = args16711.length;
  switch(G__16716) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16711.slice(2), 0);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__6480__auto__ = x;
  var y__6481__auto__ = y;
  return x__6480__auto__ < y__6481__auto__ ? x__6480__auto__ : y__6481__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__6480__auto__ = x;
    var y__6481__auto__ = y;
    return x__6480__auto__ < y__6481__auto__ ? x__6480__auto__ : y__6481__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq16712) {
  var G__16713 = cljs.core.first(seq16712);
  var seq16712__$1 = cljs.core.next(seq16712);
  var G__16714 = cljs.core.first(seq16712__$1);
  var seq16712__$2 = cljs.core.next(seq16712__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__16713, G__16714, seq16712__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add(var_args) {
  var args16721 = [];
  var len__7200__auto___16727 = arguments.length;
  var i__7201__auto___16728 = 0;
  while (true) {
    if (i__7201__auto___16728 < len__7200__auto___16727) {
      args16721.push(arguments[i__7201__auto___16728]);
      var G__16729 = i__7201__auto___16728 + 1;
      i__7201__auto___16728 = G__16729;
      continue;
    } else {
    }
    break;
  }
  var G__16726 = args16721.length;
  switch(G__16726) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16721.slice(2), 0);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq16722) {
  var G__16723 = cljs.core.first(seq16722);
  var seq16722__$1 = cljs.core.next(seq16722);
  var G__16724 = cljs.core.first(seq16722__$1);
  var seq16722__$2 = cljs.core.next(seq16722__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__16723, G__16724, seq16722__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int(var_args) {
  var args16731 = [];
  var len__7200__auto___16737 = arguments.length;
  var i__7201__auto___16738 = 0;
  while (true) {
    if (i__7201__auto___16738 < len__7200__auto___16737) {
      args16731.push(arguments[i__7201__auto___16738]);
      var G__16739 = i__7201__auto___16738 + 1;
      i__7201__auto___16738 = G__16739;
      continue;
    } else {
    }
    break;
  }
  var G__16736 = args16731.length;
  switch(G__16736) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16731.slice(2), 0);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq16732) {
  var G__16733 = cljs.core.first(seq16732);
  var seq16732__$1 = cljs.core.next(seq16732);
  var G__16734 = cljs.core.first(seq16732__$1);
  var seq16732__$2 = cljs.core.next(seq16732__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__16733, G__16734, seq16732__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int(var_args) {
  var args16741 = [];
  var len__7200__auto___16747 = arguments.length;
  var i__7201__auto___16748 = 0;
  while (true) {
    if (i__7201__auto___16748 < len__7200__auto___16747) {
      args16741.push(arguments[i__7201__auto___16748]);
      var G__16749 = i__7201__auto___16748 + 1;
      i__7201__auto___16748 = G__16749;
      continue;
    } else {
    }
    break;
  }
  var G__16746 = args16741.length;
  switch(G__16746) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16741.slice(2), 0);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq16742) {
  var G__16743 = cljs.core.first(seq16742);
  var seq16742__$1 = cljs.core.next(seq16742);
  var G__16744 = cljs.core.first(seq16742__$1);
  var seq16742__$2 = cljs.core.next(seq16742__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__16743, G__16744, seq16742__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply(var_args) {
  var args16751 = [];
  var len__7200__auto___16757 = arguments.length;
  var i__7201__auto___16758 = 0;
  while (true) {
    if (i__7201__auto___16758 < len__7200__auto___16757) {
      args16751.push(arguments[i__7201__auto___16758]);
      var G__16759 = i__7201__auto___16758 + 1;
      i__7201__auto___16758 = G__16759;
      continue;
    } else {
    }
    break;
  }
  var G__16756 = args16751.length;
  switch(G__16756) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16751.slice(2), 0);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq16752) {
  var G__16753 = cljs.core.first(seq16752);
  var seq16752__$1 = cljs.core.next(seq16752);
  var G__16754 = cljs.core.first(seq16752__$1);
  var seq16752__$2 = cljs.core.next(seq16752__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__16753, G__16754, seq16752__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int(var_args) {
  var args16761 = [];
  var len__7200__auto___16767 = arguments.length;
  var i__7201__auto___16768 = 0;
  while (true) {
    if (i__7201__auto___16768 < len__7200__auto___16767) {
      args16761.push(arguments[i__7201__auto___16768]);
      var G__16769 = i__7201__auto___16768 + 1;
      i__7201__auto___16768 = G__16769;
      continue;
    } else {
    }
    break;
  }
  var G__16766 = args16761.length;
  switch(G__16766) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16761.slice(2), 0);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq16762) {
  var G__16763 = cljs.core.first(seq16762);
  var seq16762__$1 = cljs.core.next(seq16762);
  var G__16764 = cljs.core.first(seq16762__$1);
  var seq16762__$2 = cljs.core.next(seq16762__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__16763, G__16764, seq16762__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x, n) : cljs.core.mod.call(null, x, n);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract(var_args) {
  var args16771 = [];
  var len__7200__auto___16777 = arguments.length;
  var i__7201__auto___16778 = 0;
  while (true) {
    if (i__7201__auto___16778 < len__7200__auto___16777) {
      args16771.push(arguments[i__7201__auto___16778]);
      var G__16779 = i__7201__auto___16778 + 1;
      i__7201__auto___16778 = G__16779;
      continue;
    } else {
    }
    break;
  }
  var G__16776 = args16771.length;
  switch(G__16776) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16771.slice(2), 0);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq16772) {
  var G__16773 = cljs.core.first(seq16772);
  var seq16772__$1 = cljs.core.next(seq16772);
  var G__16774 = cljs.core.first(seq16772__$1);
  var seq16772__$2 = cljs.core.next(seq16772__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__16773, G__16774, seq16772__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int(var_args) {
  var args16781 = [];
  var len__7200__auto___16787 = arguments.length;
  var i__7201__auto___16788 = 0;
  while (true) {
    if (i__7201__auto___16788 < len__7200__auto___16787) {
      args16781.push(arguments[i__7201__auto___16788]);
      var G__16789 = i__7201__auto___16788 + 1;
      i__7201__auto___16788 = G__16789;
      continue;
    } else {
    }
    break;
  }
  var G__16786 = args16781.length;
  switch(G__16786) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16781.slice(2), 0);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq16782) {
  var G__16783 = cljs.core.first(seq16782);
  var seq16782__$1 = cljs.core.next(seq16782);
  var G__16784 = cljs.core.first(seq16782__$1);
  var seq16782__$2 = cljs.core.next(seq16782__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__16783, G__16784, seq16782__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    return Math.floor(q);
  } else {
    return Math.ceil(q);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor(var_args) {
  var args16791 = [];
  var len__7200__auto___16797 = arguments.length;
  var i__7201__auto___16798 = 0;
  while (true) {
    if (i__7201__auto___16798 < len__7200__auto___16797) {
      args16791.push(arguments[i__7201__auto___16798]);
      var G__16799 = i__7201__auto___16798 + 1;
      i__7201__auto___16798 = G__16799;
      continue;
    } else {
    }
    break;
  }
  var G__16796 = args16791.length;
  switch(G__16796) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16791.slice(2), 0);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq16792) {
  var G__16793 = cljs.core.first(seq16792);
  var seq16792__$1 = cljs.core.next(seq16792);
  var G__16794 = cljs.core.first(seq16792__$1);
  var seq16792__$2 = cljs.core.next(seq16792__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__16793, G__16794, seq16792__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and(var_args) {
  var args16801 = [];
  var len__7200__auto___16807 = arguments.length;
  var i__7201__auto___16808 = 0;
  while (true) {
    if (i__7201__auto___16808 < len__7200__auto___16807) {
      args16801.push(arguments[i__7201__auto___16808]);
      var G__16809 = i__7201__auto___16808 + 1;
      i__7201__auto___16808 = G__16809;
      continue;
    } else {
    }
    break;
  }
  var G__16806 = args16801.length;
  switch(G__16806) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16801.slice(2), 0);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq16802) {
  var G__16803 = cljs.core.first(seq16802);
  var seq16802__$1 = cljs.core.next(seq16802);
  var G__16804 = cljs.core.first(seq16802__$1);
  var seq16802__$2 = cljs.core.next(seq16802__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__16803, G__16804, seq16802__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or(var_args) {
  var args16811 = [];
  var len__7200__auto___16817 = arguments.length;
  var i__7201__auto___16818 = 0;
  while (true) {
    if (i__7201__auto___16818 < len__7200__auto___16817) {
      args16811.push(arguments[i__7201__auto___16818]);
      var G__16819 = i__7201__auto___16818 + 1;
      i__7201__auto___16818 = G__16819;
      continue;
    } else {
    }
    break;
  }
  var G__16816 = args16811.length;
  switch(G__16816) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16811.slice(2), 0);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq16812) {
  var G__16813 = cljs.core.first(seq16812);
  var seq16812__$1 = cljs.core.next(seq16812);
  var G__16814 = cljs.core.first(seq16812__$1);
  var seq16812__$2 = cljs.core.next(seq16812__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__16813, G__16814, seq16812__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not(var_args) {
  var args16821 = [];
  var len__7200__auto___16827 = arguments.length;
  var i__7201__auto___16828 = 0;
  while (true) {
    if (i__7201__auto___16828 < len__7200__auto___16827) {
      args16821.push(arguments[i__7201__auto___16828]);
      var G__16829 = i__7201__auto___16828 + 1;
      i__7201__auto___16828 = G__16829;
      continue;
    } else {
    }
    break;
  }
  var G__16826 = args16821.length;
  switch(G__16826) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16821.slice(2), 0);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq16822) {
  var G__16823 = cljs.core.first(seq16822);
  var seq16822__$1 = cljs.core.next(seq16822);
  var G__16824 = cljs.core.first(seq16822__$1);
  var seq16822__$2 = cljs.core.next(seq16822__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__16823, G__16824, seq16822__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_(var_args) {
  var args16831 = [];
  var len__7200__auto___16837 = arguments.length;
  var i__7201__auto___16838 = 0;
  while (true) {
    if (i__7201__auto___16838 < len__7200__auto___16837) {
      args16831.push(arguments[i__7201__auto___16838]);
      var G__16839 = i__7201__auto___16838 + 1;
      i__7201__auto___16838 = G__16839;
      continue;
    } else {
    }
    break;
  }
  var G__16836 = args16831.length;
  switch(G__16836) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16831.slice(2), 0);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__16841 = y;
        var G__16842 = cljs.core.first(more);
        var G__16843 = cljs.core.next(more);
        x = G__16841;
        y = G__16842;
        more = G__16843;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq16832) {
  var G__16833 = cljs.core.first(seq16832);
  var seq16832__$1 = cljs.core.next(seq16832);
  var G__16834 = cljs.core.first(seq16832__$1);
  var seq16832__$2 = cljs.core.next(seq16832__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16833, G__16834, seq16832__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(n) {
  return n > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(n) {
  return n === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__16844 = n__$1 - 1;
      var G__16845 = cljs.core.next(xs);
      n__$1 = G__16844;
      xs = G__16845;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str(var_args) {
  var args16846 = [];
  var len__7200__auto___16851 = arguments.length;
  var i__7201__auto___16852 = 0;
  while (true) {
    if (i__7201__auto___16852 < len__7200__auto___16851) {
      args16846.push(arguments[i__7201__auto___16852]);
      var G__16853 = i__7201__auto___16852 + 1;
      i__7201__auto___16852 = G__16853;
      continue;
    } else {
    }
    break;
  }
  var G__16850 = args16846.length;
  switch(G__16850) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args16846.slice(1), 0);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__7219__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    return [x].join("");
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__16855 = sb.append([cljs.core.str(cljs.core.first(more))].join(""));
      var G__16856 = cljs.core.next(more);
      sb = G__16855;
      more = G__16856;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq16847) {
  var G__16848 = cljs.core.first(seq16847);
  var seq16847__$1 = cljs.core.next(seq16847);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__16848, seq16847__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs(var_args) {
  var args16857 = [];
  var len__7200__auto___16860 = arguments.length;
  var i__7201__auto___16861 = 0;
  while (true) {
    if (i__7201__auto___16861 < len__7200__auto___16860) {
      args16857.push(arguments[i__7201__auto___16861]);
      var G__16862 = i__7201__auto___16861 + 1;
      i__7201__auto___16861 = G__16862;
      continue;
    } else {
    }
    break;
  }
  var G__16859 = args16857.length;
  switch(G__16859) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16857.length)].join(""));;
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__16864 = cljs.core.next(xs);
            var G__16865 = cljs.core.next(ys);
            xs = G__16864;
            ys = G__16865;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__16866 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__16867 = cljs.core.next(s);
        res = G__16866;
        s = G__16867;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__16868 = (h + (cljs.core.hash(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e)) ^ cljs.core.hash(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e)))) % 4503599627370496;
      var G__16869 = cljs.core.next(s);
      h = G__16868;
      s = G__16869;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__16870 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__16871 = cljs.core.next(s__$1);
      h = G__16870;
      s__$1 = G__16871;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__16878_16884 = cljs.core.seq(fn_map);
  var chunk__16879_16885 = null;
  var count__16880_16886 = 0;
  var i__16881_16887 = 0;
  while (true) {
    if (i__16881_16887 < count__16880_16886) {
      var vec__16882_16888 = chunk__16879_16885.cljs$core$IIndexed$_nth$arity$2(null, i__16881_16887);
      var key_name_16889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16882_16888, 0, null);
      var f_16890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16882_16888, 1, null);
      var str_name_16891 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_16889) : cljs.core.name.call(null, key_name_16889);
      obj[str_name_16891] = f_16890;
      var G__16892 = seq__16878_16884;
      var G__16893 = chunk__16879_16885;
      var G__16894 = count__16880_16886;
      var G__16895 = i__16881_16887 + 1;
      seq__16878_16884 = G__16892;
      chunk__16879_16885 = G__16893;
      count__16880_16886 = G__16894;
      i__16881_16887 = G__16895;
      continue;
    } else {
      var temp__4425__auto___16896 = cljs.core.seq(seq__16878_16884);
      if (temp__4425__auto___16896) {
        var seq__16878_16897__$1 = temp__4425__auto___16896;
        if (cljs.core.chunked_seq_QMARK_(seq__16878_16897__$1)) {
          var c__6945__auto___16898 = cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__16878_16897__$1) : cljs.core.chunk_first.call(null, seq__16878_16897__$1);
          var G__16899 = cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__16878_16897__$1) : cljs.core.chunk_rest.call(null, seq__16878_16897__$1);
          var G__16900 = c__6945__auto___16898;
          var G__16901 = cljs.core.count(c__6945__auto___16898);
          var G__16902 = 0;
          seq__16878_16884 = G__16899;
          chunk__16879_16885 = G__16900;
          count__16880_16886 = G__16901;
          i__16881_16887 = G__16902;
          continue;
        } else {
          var vec__16883_16903 = cljs.core.first(seq__16878_16897__$1);
          var key_name_16904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16883_16903, 0, null);
          var f_16905 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16883_16903, 1, null);
          var str_name_16906 = cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_16904) : cljs.core.name.call(null, key_name_16904);
          obj[str_name_16906] = f_16905;
          var G__16907 = cljs.core.next(seq__16878_16897__$1);
          var G__16908 = null;
          var G__16909 = 0;
          var G__16910 = 0;
          seq__16878_16884 = G__16907;
          chunk__16879_16885 = G__16908;
          count__16880_16886 = G__16909;
          i__16881_16887 = G__16910;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._rest(coll__$1);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 33554432 || x.cljs$core$IList$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
  }
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.list_QMARK_(other) || cljs.core.sequential_QMARK_(other)) {
    return cljs.core.seq(other) == null;
  } else {
    return false;
  }
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  if (!(coll == null)) {
    if (coll.cljs$lang$protocol_mask$partition0$ & 134217728 || coll.cljs$core$IReversible$) {
      return true;
    } else {
      if (!coll.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
  }
};
cljs.core.rseq = function cljs$core$rseq(rev) {
  return cljs.core._rseq(rev);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list(var_args) {
  var args__7207__auto__ = [];
  var len__7200__auto___16916 = arguments.length;
  var i__7201__auto___16917 = 0;
  while (true) {
    if (i__7201__auto___16917 < len__7200__auto___16916) {
      args__7207__auto__.push(arguments[i__7201__auto___16917]);
      var G__16918 = i__7201__auto___16917 + 1;
      i__7201__auto___16917 = G__16918;
      continue;
    } else {
    }
    break;
  }
  var argseq__7208__auto__ = 0 < args__7207__auto__.length ? new cljs.core.IndexedSeq(args__7207__auto__.slice(0), 0) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7208__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__16919 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__16919;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__16920 = i - 1;
      var G__16921 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__16920;
      r = G__16921;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq16915) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16915));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, null);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__6142__auto__ = coll == null;
    if (or__6142__auto__) {
      return or__6142__auto__;
    } else {
      if (!(coll == null)) {
        if (coll.cljs$lang$protocol_mask$partition0$ & 64 || coll.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__6130__auto__ = cljs.core.not(a.ns);
      if (and__6130__auto__) {
        return b.ns;
      } else {
        return and__6130__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__16932 = a.ns;
            var G__16933 = b.ns;
            return goog.array.defaultCompare(G__16932, G__16933);
          }();
          if (0 === nsc) {
            var G__16934 = a.name;
            var G__16935 = b.name;
            return goog.array.defaultCompare(G__16934, G__16935);
          } else {
            return nsc;
          }
        }
      } else {
        var G__16936 = a.name;
        var G__16937 = b.name;
        return goog.array.defaultCompare(G__16936, G__16937);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [cljs.core.str(":"), cljs.core.str(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__16939 = null;
  var G__16939__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__16939__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__16939 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16939__2.call(this, self__, coll);
      case 3:
        return G__16939__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16939.cljs$core$IFn$_invoke$arity$2 = G__16939__2;
  G__16939.cljs$core$IFn$_invoke$arity$3 = G__16939__3;
  return G__16939;
}();
cljs.core.Keyword.prototype.apply = function(self__, args16938) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16938)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__6577__auto__ = self__._hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str(":"), cljs.core.str(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.symbol_identical_QMARK_ = function cljs$core$symbol_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Symbol && y instanceof cljs.core.Symbol) {
      return x.str === y.str;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 4096 || x.cljs$core$INamed$ ? true : false : false) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.keyword = function cljs$core$keyword(var_args) {
  var args16942 = [];
  var len__7200__auto___16945 = arguments.length;
  var i__7201__auto___16946 = 0;
  while (true) {
    if (i__7201__auto___16946 < len__7200__auto___16945) {
      args16942.push(arguments[i__7201__auto___16946]);
      var G__16947 = i__7201__auto___16946 + 1;
      i__7201__auto___16946 = G__16947;
      continue;
    } else {
    }
    break;
  }
  var G__16944 = args16942.length;
  switch(G__16944) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16942.length)].join(""));;
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null, name), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  return new cljs.core.Keyword(ns, name, [cljs.core.str(cljs.core.truth_(ns) ? [cljs.core.str(ns), cljs.core.str("/")].join("") : null), cljs.core.str(name)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(x) {
  var self__ = this;
  var x__$1 = this;
  return cljs.core.not(self__.fn);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__16949 = ls.sval();
        ls = G__16949;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk(var_args) {
  var args16950 = [];
  var len__7200__auto___16953 = arguments.length;
  var i__7201__auto___16954 = 0;
  while (true) {
    if (i__7201__auto___16954 < len__7200__auto___16953) {
      args16950.push(arguments[i__7201__auto___16954]);
      var G__16955 = i__7201__auto___16954 + 1;
      i__7201__auto___16954 = G__16955;
      continue;
    } else {
    }
    break;
  }
  var G__16952 = args16950.length;
  switch(G__16952) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16950.length)].join(""));;
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (!(s == null) ? s.cljs$lang$protocol_mask$partition1$ & 1024 || s.cljs$core$IChunkedNext$ ? true : false : false) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__16959 = cljs.core.next(s__$1);
      s__$1 = G__16959;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_16960 = 0;
  var xs_16961 = cljs.core.seq(coll);
  while (true) {
    if (xs_16961) {
      ret[i_16960] = cljs.core.to_array(cljs.core.first(xs_16961));
      var G__16962 = i_16960 + 1;
      var G__16963 = cljs.core.next(xs_16961);
      i_16960 = G__16962;
      xs_16961 = G__16963;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array(var_args) {
  var args16964 = [];
  var len__7200__auto___16967 = arguments.length;
  var i__7201__auto___16968 = 0;
  while (true) {
    if (i__7201__auto___16968 < len__7200__auto___16967) {
      args16964.push(arguments[i__7201__auto___16968]);
      var G__16969 = i__7201__auto___16968 + 1;
      i__7201__auto___16968 = G__16969;
      continue;
    } else {
    }
    break;
  }
  var G__16966 = args16964.length;
  switch(G__16966) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16964.length)].join(""));;
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__16971 = i + 1;
        var G__16972 = cljs.core.next(s__$1);
        i = G__16971;
        s__$1 = G__16972;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7045__auto___16973 = size;
    var i_16974 = 0;
    while (true) {
      if (i_16974 < n__7045__auto___16973) {
        a[i_16974] = init_val_or_seq;
        var G__16975 = i_16974 + 1;
        i_16974 = G__16975;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array(var_args) {
  var args16976 = [];
  var len__7200__auto___16979 = arguments.length;
  var i__7201__auto___16980 = 0;
  while (true) {
    if (i__7201__auto___16980 < len__7200__auto___16979) {
      args16976.push(arguments[i__7201__auto___16980]);
      var G__16981 = i__7201__auto___16980 + 1;
      i__7201__auto___16980 = G__16981;
      continue;
    } else {
    }
    break;
  }
  var G__16978 = args16976.length;
  switch(G__16978) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16976.length)].join(""));;
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__16983 = i + 1;
        var G__16984 = cljs.core.next(s__$1);
        i = G__16983;
        s__$1 = G__16984;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7045__auto___16985 = size;
    var i_16986 = 0;
    while (true) {
      if (i_16986 < n__7045__auto___16985) {
        a[i_16986] = init_val_or_seq;
        var G__16987 = i_16986 + 1;
        i_16986 = G__16987;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array(var_args) {
  var args16988 = [];
  var len__7200__auto___16991 = arguments.length;
  var i__7201__auto___16992 = 0;
  while (true) {
    if (i__7201__auto___16992 < len__7200__auto___16991) {
      args16988.push(arguments[i__7201__auto___16992]);
      var G__16993 = i__7201__auto___16992 + 1;
      i__7201__auto___16992 = G__16993;
      continue;
    } else {
    }
    break;
  }
  var G__16990 = args16988.length;
  switch(G__16990) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args16988.length)].join(""));;
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__16995 = i + 1;
        var G__16996 = cljs.core.next(s__$1);
        i = G__16995;
        s__$1 = G__16996;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7045__auto___16997 = size;
    var i_16998 = 0;
    while (true) {
      if (i_16998 < n__7045__auto___16997) {
        a[i_16998] = init_val_or_seq;
        var G__16999 = i_16998 + 1;
        i_16998 = G__16999;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array(var_args) {
  var args17000 = [];
  var len__7200__auto___17003 = arguments.length;
  var i__7201__auto___17004 = 0;
  while (true) {
    if (i__7201__auto___17004 < len__7200__auto___17003) {
      args17000.push(arguments[i__7201__auto___17004]);
      var G__17005 = i__7201__auto___17004 + 1;
      i__7201__auto___17004 = G__17005;
      continue;
    } else {
    }
    break;
  }
  var G__17002 = args17000.length;
  switch(G__17002) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17000.length)].join(""));;
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__17007 = i + 1;
        var G__17008 = cljs.core.next(s__$1);
        i = G__17007;
        s__$1 = G__17008;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__7045__auto___17009 = size;
    var i_17010 = 0;
    while (true) {
      if (i_17010 < n__7045__auto___17009) {
        a[i_17010] = init_val_or_seq;
        var G__17011 = i_17010 + 1;
        i_17010 = G__17011;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(s, n) {
  if (cljs.core.counted_QMARK_(s)) {
    return cljs.core.count(s);
  } else {
    var s__$1 = s;
    var i = n;
    var sum = 0;
    while (true) {
      if (i > 0 && cljs.core.seq(s__$1)) {
        var G__17012 = cljs.core.next(s__$1);
        var G__17013 = i - 1;
        var G__17014 = sum + 1;
        s__$1 = G__17012;
        i = G__17013;
        sum = G__17014;
        continue;
      } else {
        return sum;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), cljs$core$spread(cljs.core.next(arglist)));
    }
  }
};
cljs.core.concat = function cljs$core$concat(var_args) {
  var args17016 = [];
  var len__7200__auto___17028 = arguments.length;
  var i__7201__auto___17029 = 0;
  while (true) {
    if (i__7201__auto___17029 < len__7200__auto___17028) {
      args17016.push(arguments[i__7201__auto___17029]);
      var G__17030 = i__7201__auto___17029 + 1;
      i__7201__auto___17029 = G__17030;
      continue;
    } else {
    }
    break;
  }
  var G__17021 = args17016.length;
  switch(G__17021) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17016.slice(2), 0);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq17017) {
  var G__17018 = cljs.core.first(seq17017);
  var seq17017__$1 = cljs.core.next(seq17017);
  var G__17019 = cljs.core.first(seq17017__$1);
  var seq17017__$2 = cljs.core.next(seq17017__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__17018, G__17019, seq17017__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_(var_args) {
  var args17032 = [];
  var len__7200__auto___17040 = arguments.length;
  var i__7201__auto___17041 = 0;
  while (true) {
    if (i__7201__auto___17041 < len__7200__auto___17040) {
      args17032.push(arguments[i__7201__auto___17041]);
      var G__17042 = i__7201__auto___17041 + 1;
      i__7201__auto___17041 = G__17042;
      continue;
    } else {
    }
    break;
  }
  var G__17039 = args17032.length;
  switch(G__17039) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17032.slice(4), 0);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7219__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq17033) {
  var G__17034 = cljs.core.first(seq17033);
  var seq17033__$1 = cljs.core.next(seq17033);
  var G__17035 = cljs.core.first(seq17033__$1);
  var seq17033__$2 = cljs.core.next(seq17033__$1);
  var G__17036 = cljs.core.first(seq17033__$2);
  var seq17033__$3 = cljs.core.next(seq17033__$2);
  var G__17037 = cljs.core.first(seq17033__$3);
  var seq17033__$4 = cljs.core.next(seq17033__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__17034, G__17035, G__17036, G__17037, seq17033__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_(var_args) {
  var args17044 = [];
  var len__7200__auto___17050 = arguments.length;
  var i__7201__auto___17051 = 0;
  while (true) {
    if (i__7201__auto___17051 < len__7200__auto___17050) {
      args17044.push(arguments[i__7201__auto___17051]);
      var G__17052 = i__7201__auto___17051 + 1;
      i__7201__auto___17051 = G__17052;
      continue;
    } else {
    }
    break;
  }
  var G__17049 = args17044.length;
  switch(G__17049) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17044.slice(2), 0);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__17054 = ntcoll;
      var G__17055 = cljs.core.first(vals);
      var G__17056 = cljs.core.next(vals);
      tcoll = G__17054;
      val = G__17055;
      vals = G__17056;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq17045) {
  var G__17046 = cljs.core.first(seq17045);
  var seq17045__$1 = cljs.core.next(seq17045);
  var G__17047 = cljs.core.first(seq17045__$1);
  var seq17045__$2 = cljs.core.next(seq17045__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17046, G__17047, seq17045__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_(var_args) {
  var args17057 = [];
  var len__7200__auto___17064 = arguments.length;
  var i__7201__auto___17065 = 0;
  while (true) {
    if (i__7201__auto___17065 < len__7200__auto___17064) {
      args17057.push(arguments[i__7201__auto___17065]);
      var G__17066 = i__7201__auto___17065 + 1;
      i__7201__auto___17065 = G__17066;
      continue;
    } else {
    }
    break;
  }
  var G__17063 = args17057.length;
  switch(G__17063) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17057.slice(3), 0);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7219__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__17068 = ntcoll;
      var G__17069 = cljs.core.first(kvs);
      var G__17070 = cljs.core.second(kvs);
      var G__17071 = cljs.core.nnext(kvs);
      tcoll = G__17068;
      key = G__17069;
      val = G__17070;
      kvs = G__17071;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq17058) {
  var G__17059 = cljs.core.first(seq17058);
  var seq17058__$1 = cljs.core.next(seq17058);
  var G__17060 = cljs.core.first(seq17058__$1);
  var seq17058__$2 = cljs.core.next(seq17058__$1);
  var G__17061 = cljs.core.first(seq17058__$2);
  var seq17058__$3 = cljs.core.next(seq17058__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17059, G__17060, G__17061, seq17058__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_(var_args) {
  var args17072 = [];
  var len__7200__auto___17078 = arguments.length;
  var i__7201__auto___17079 = 0;
  while (true) {
    if (i__7201__auto___17079 < len__7200__auto___17078) {
      args17072.push(arguments[i__7201__auto___17079]);
      var G__17080 = i__7201__auto___17079 + 1;
      i__7201__auto___17079 = G__17080;
      continue;
    } else {
    }
    break;
  }
  var G__17077 = args17072.length;
  switch(G__17077) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17072.slice(2), 0);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__17082 = ntcoll;
      var G__17083 = cljs.core.first(ks);
      var G__17084 = cljs.core.next(ks);
      tcoll = G__17082;
      key = G__17083;
      ks = G__17084;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq17073) {
  var G__17074 = cljs.core.first(seq17073);
  var seq17073__$1 = cljs.core.next(seq17073);
  var G__17075 = cljs.core.first(seq17073__$1);
  var seq17073__$2 = cljs.core.next(seq17073__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17074, G__17075, seq17073__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_(var_args) {
  var args17085 = [];
  var len__7200__auto___17091 = arguments.length;
  var i__7201__auto___17092 = 0;
  while (true) {
    if (i__7201__auto___17092 < len__7200__auto___17091) {
      args17085.push(arguments[i__7201__auto___17092]);
      var G__17093 = i__7201__auto___17092 + 1;
      i__7201__auto___17092 = G__17093;
      continue;
    } else {
    }
    break;
  }
  var G__17090 = args17085.length;
  switch(G__17090) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17085.slice(2), 0);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__17095 = ntcoll;
      var G__17096 = cljs.core.first(vals);
      var G__17097 = cljs.core.next(vals);
      tcoll = G__17095;
      val = G__17096;
      vals = G__17097;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq17086) {
  var G__17087 = cljs.core.first(seq17086);
  var seq17086__$1 = cljs.core.next(seq17086);
  var G__17088 = cljs.core.first(seq17086__$1);
  var seq17086__$2 = cljs.core.next(seq17086__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17087, G__17088, seq17086__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a7089 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a7089);
      } else {
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a7089) : f.call(null, a7089);
      }
    } else {
      var b7090 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a7089, b7090);
        } else {
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a7089, b7090) : f.call(null, a7089, b7090);
        }
      } else {
        var c7091 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a7089, b7090, c7091);
          } else {
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a7089, b7090, c7091) : f.call(null, a7089, b7090, c7091);
          }
        } else {
          var d7092 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a7089, b7090, c7091, d7092);
            } else {
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a7089, b7090, c7091, d7092) : f.call(null, a7089, b7090, c7091, d7092);
            }
          } else {
            var e7093 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a7089, b7090, c7091, d7092, e7093);
              } else {
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a7089, b7090, c7091, d7092, e7093) : f.call(null, a7089, b7090, c7091, d7092, e7093);
              }
            } else {
              var f7094 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a7089, b7090, c7091, d7092, e7093, f7094);
                } else {
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a7089, b7090, c7091, d7092, e7093, f7094) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094);
                }
              } else {
                var g7095 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a7089, b7090, c7091, d7092, e7093, f7094, g7095);
                  } else {
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a7089, b7090, c7091, d7092, e7093, f7094, g7095) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095);
                  }
                } else {
                  var h7096 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096);
                    } else {
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096);
                    }
                  } else {
                    var i7097 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097);
                      } else {
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097);
                      }
                    } else {
                      var j7098 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098);
                        } else {
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098);
                        }
                      } else {
                        var k7099 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099);
                          } else {
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099);
                          }
                        } else {
                          var l7100 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100);
                            } else {
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100);
                            }
                          } else {
                            var m7101 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101);
                              } else {
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101);
                              }
                            } else {
                              var n7102 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102);
                                } else {
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102);
                                }
                              } else {
                                var o7103 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103);
                                  } else {
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103);
                                  }
                                } else {
                                  var p7104 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104);
                                    } else {
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104);
                                    }
                                  } else {
                                    var q7105 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105);
                                      } else {
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105);
                                      }
                                    } else {
                                      var r7106 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106);
                                        } else {
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106);
                                        }
                                      } else {
                                        var s7107 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106, s7107);
                                          } else {
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106, s7107) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106, s7107);
                                          }
                                        } else {
                                          var t7108 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106, s7107, t7108);
                                            } else {
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106, s7107, t7108) : f.call(null, a7089, b7090, c7091, d7092, e7093, f7094, g7095, h7096, i7097, j7098, k7099, l7100, m7101, n7102, o7103, p7104, q7105, r7106, s7107, t7108);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply(var_args) {
  var args17098 = [];
  var len__7200__auto___17107 = arguments.length;
  var i__7201__auto___17108 = 0;
  while (true) {
    if (i__7201__auto___17108 < len__7200__auto___17107) {
      args17098.push(arguments[i__7201__auto___17108]);
      var G__17109 = i__7201__auto___17108 + 1;
      i__7201__auto___17108 = G__17109;
      continue;
    } else {
    }
    break;
  }
  var G__17106 = args17098.length;
  switch(G__17106) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17098.slice(5), 0);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__7219__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(args, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq17099) {
  var G__17100 = cljs.core.first(seq17099);
  var seq17099__$1 = cljs.core.next(seq17099);
  var G__17101 = cljs.core.first(seq17099__$1);
  var seq17099__$2 = cljs.core.next(seq17099__$1);
  var G__17102 = cljs.core.first(seq17099__$2);
  var seq17099__$3 = cljs.core.next(seq17099__$2);
  var G__17103 = cljs.core.first(seq17099__$3);
  var seq17099__$4 = cljs.core.next(seq17099__$3);
  var G__17104 = cljs.core.first(seq17099__$4);
  var seq17099__$5 = cljs.core.next(seq17099__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__17100, G__17101, G__17102, G__17103, G__17104, seq17099__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta(var_args) {
  var args17111 = [];
  var len__7200__auto___17136 = arguments.length;
  var i__7201__auto___17137 = 0;
  while (true) {
    if (i__7201__auto___17137 < len__7200__auto___17136) {
      args17111.push(arguments[i__7201__auto___17137]);
      var G__17138 = i__7201__auto___17137 + 1;
      i__7201__auto___17137 = G__17138;
      continue;
    } else {
    }
    break;
  }
  var G__17120 = args17111.length;
  switch(G__17120) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17111.slice(6), 0);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__7219__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__17121 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17121) : f.call(null, G__17121);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__17122 = cljs.core.meta(obj);
    var G__17123 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17122, G__17123) : f.call(null, G__17122, G__17123);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__17124 = cljs.core.meta(obj);
    var G__17125 = a;
    var G__17126 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17124, G__17125, G__17126) : f.call(null, G__17124, G__17125, G__17126);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__17127 = cljs.core.meta(obj);
    var G__17128 = a;
    var G__17129 = b;
    var G__17130 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17127, G__17128, G__17129, G__17130) : f.call(null, G__17127, G__17128, G__17129, G__17130);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__17131 = cljs.core.meta(obj);
    var G__17132 = a;
    var G__17133 = b;
    var G__17134 = c;
    var G__17135 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17131, G__17132, G__17133, G__17134, G__17135) : f.call(null, G__17131, G__17132, G__17133, G__17134, G__17135);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq17112) {
  var G__17113 = cljs.core.first(seq17112);
  var seq17112__$1 = cljs.core.next(seq17112);
  var G__17114 = cljs.core.first(seq17112__$1);
  var seq17112__$2 = cljs.core.next(seq17112__$1);
  var G__17115 = cljs.core.first(seq17112__$2);
  var seq17112__$3 = cljs.core.next(seq17112__$2);
  var G__17116 = cljs.core.first(seq17112__$3);
  var seq17112__$4 = cljs.core.next(seq17112__$3);
  var G__17117 = cljs.core.first(seq17112__$4);
  var seq17112__$5 = cljs.core.next(seq17112__$4);
  var G__17118 = cljs.core.first(seq17112__$5);
  var seq17112__$6 = cljs.core.next(seq17112__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__17113, G__17114, G__17115, G__17116, G__17117, G__17118, seq17112__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_(var_args) {
  var args17140 = [];
  var len__7200__auto___17146 = arguments.length;
  var i__7201__auto___17147 = 0;
  while (true) {
    if (i__7201__auto___17147 < len__7200__auto___17146) {
      args17140.push(arguments[i__7201__auto___17147]);
      var G__17148 = i__7201__auto___17147 + 1;
      i__7201__auto___17147 = G__17148;
      continue;
    } else {
    }
    break;
  }
  var G__17145 = args17140.length;
  switch(G__17145) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17140.slice(2), 0);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq17141) {
  var G__17142 = cljs.core.first(seq17141);
  var seq17141__$1 = cljs.core.next(seq17141);
  var G__17143 = cljs.core.first(seq17141__$1);
  var seq17141__$2 = cljs.core.next(seq17141__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__17142, G__17143, seq17141__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t_cljs$core17153 !== "undefined") {
  } else {
    cljs.core.t_cljs$core17153 = function(nil_iter, meta17154) {
      this.nil_iter = nil_iter;
      this.meta17154 = meta17154;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t_cljs$core17153.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_17155, meta17154__$1) {
      var self__ = this;
      var _17155__$1 = this;
      return new cljs.core.t_cljs$core17153(self__.nil_iter, meta17154__$1);
    };
    cljs.core.t_cljs$core17153.prototype.cljs$core$IMeta$_meta$arity$1 = function(_17155) {
      var self__ = this;
      var _17155__$1 = this;
      return self__.meta17154;
    };
    cljs.core.t_cljs$core17153.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t_cljs$core17153.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t_cljs$core17153.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t_cljs$core17153.getBasis = function() {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "nil-iter", "nil-iter", 1101030523, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "arglists", "arglists", 1661989754), cljs.core.list(new cljs.core.Symbol(null, "quote", "quote", 1377916282, null), cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)), new cljs.core.Symbol(null, "meta17154", "meta17154", 450558472, null)], 
      null);
    };
    cljs.core.t_cljs$core17153.cljs$lang$type = true;
    cljs.core.t_cljs$core17153.cljs$lang$ctorStr = "cljs.core/t_cljs$core17153";
    cljs.core.t_cljs$core17153.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
      return cljs.core._write(writer__6741__auto__, "cljs.core/t_cljs$core17153");
    };
    cljs.core.__GT_t_cljs$core17153 = function cljs$core$nil_iter_$___GT_t_cljs$core17153(nil_iter__$1, meta17154) {
      return new cljs.core.t_cljs$core17153(nil_iter__$1, meta17154);
    };
  }
  return new cljs.core.t_cljs$core17153(cljs$core$nil_iter, cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.not(this$.hasNext())) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "_next", "_next", 101877036, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.iterable_QMARK_(coll)) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str("Cannot create iterator from "), cljs.core.str(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__6130__auto__ = !(lt.stepper == null);
      if (and__6130__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__6130__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__17156 = lt;
        var G__17157 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__17156, G__17157) : self__.xform.call(null, G__17156, G__17157);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.Stepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null)], null);
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (cljs.core.not(iter.hasNext())) {
        return false;
      } else {
        var G__17158 = cljs.core.next(iters__$1);
        iters__$1 = G__17158;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__7045__auto___17159 = self__.iters.length;
  var i_17160 = 0;
  while (true) {
    if (i_17160 < n__7045__auto___17159) {
      self__.nexts[i_17160] = self__.iters[i_17160].next();
      var G__17161 = i_17160 + 1;
      i_17160 = G__17161;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__6130__auto__ = !(lt.stepper == null);
      if (and__6130__auto__) {
        return this$.hasNext();
      } else {
        return and__6130__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null, lt);
  }
};
cljs.core.MultiStepper.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "xform", "xform", -85179481, null), new cljs.core.Symbol(null, "iters", "iters", 719353031, null), new cljs.core.Symbol(null, "nexts", "nexts", -1683579407, null)], null);
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper(var_args) {
  var args17162 = [];
  var len__7200__auto___17165 = arguments.length;
  var i__7201__auto___17166 = 0;
  while (true) {
    if (i__7201__auto___17166 < len__7200__auto___17165) {
      args17162.push(arguments[i__7201__auto___17166]);
      var G__17167 = i__7201__auto___17166 + 1;
      i__7201__auto___17166 = G__17167;
      continue;
    } else {
    }
    break;
  }
  var G__17164 = args17162.length;
  switch(G__17164) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17162.length)].join(""));;
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null, stepfn), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 31719628;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, cljs.core._seq(this$__$1));
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = cljs.core._seq(this$__$1);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "stepper", "stepper", 1159163296, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  cljs.core.with_meta(new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__17169_17173 = cljs.core.seq(colls);
  var chunk__17170_17174 = null;
  var count__17171_17175 = 0;
  var i__17172_17176 = 0;
  while (true) {
    if (i__17172_17176 < count__17171_17175) {
      var coll_17177 = chunk__17170_17174.cljs$core$IIndexed$_nth$arity$2(null, i__17172_17176);
      iters.push(cljs.core.iter(coll_17177));
      var G__17178 = seq__17169_17173;
      var G__17179 = chunk__17170_17174;
      var G__17180 = count__17171_17175;
      var G__17181 = i__17172_17176 + 1;
      seq__17169_17173 = G__17178;
      chunk__17170_17174 = G__17179;
      count__17171_17175 = G__17180;
      i__17172_17176 = G__17181;
      continue;
    } else {
      var temp__4425__auto___17182 = cljs.core.seq(seq__17169_17173);
      if (temp__4425__auto___17182) {
        var seq__17169_17183__$1 = temp__4425__auto___17182;
        if (cljs.core.chunked_seq_QMARK_(seq__17169_17183__$1)) {
          var c__6945__auto___17184 = cljs.core.chunk_first(seq__17169_17183__$1);
          var G__17185 = cljs.core.chunk_rest(seq__17169_17183__$1);
          var G__17186 = c__6945__auto___17184;
          var G__17187 = cljs.core.count(c__6945__auto___17184);
          var G__17188 = 0;
          seq__17169_17173 = G__17185;
          chunk__17170_17174 = G__17186;
          count__17171_17175 = G__17187;
          i__17172_17176 = G__17188;
          continue;
        } else {
          var coll_17189 = cljs.core.first(seq__17169_17183__$1);
          iters.push(cljs.core.iter(coll_17189));
          var G__17190 = cljs.core.next(seq__17169_17183__$1);
          var G__17191 = null;
          var G__17192 = 0;
          var G__17193 = 0;
          seq__17169_17173 = G__17190;
          chunk__17170_17174 = G__17191;
          count__17171_17175 = G__17192;
          i__17172_17176 = G__17193;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence(var_args) {
  var args17194 = [];
  var len__7200__auto___17200 = arguments.length;
  var i__7201__auto___17201 = 0;
  while (true) {
    if (i__7201__auto___17201 < len__7200__auto___17200) {
      args17194.push(arguments[i__7201__auto___17201]);
      var G__17202 = i__7201__auto___17201 + 1;
      i__7201__auto___17201 = G__17202;
      continue;
    } else {
    }
    break;
  }
  var G__17199 = args17194.length;
  switch(G__17199) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17194.slice(2), 0);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__6142__auto__ = cljs.core.seq(coll);
    if (or__6142__auto__) {
      return or__6142__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq17195) {
  var G__17196 = cljs.core.first(seq17195);
  var seq17195__$1 = cljs.core.next(seq17195);
  var G__17197 = cljs.core.first(seq17195__$1);
  var seq17195__$2 = cljs.core.next(seq17195__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__17196, G__17197, seq17195__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__17205 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17205) : pred.call(null, G__17205);
      }())) {
        var G__17206 = pred;
        var G__17207 = cljs.core.next(coll);
        pred = G__17206;
        coll = G__17207;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__6142__auto__ = function() {
        var G__17211 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17211) : pred.call(null, G__17211);
      }();
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        var G__17212 = pred;
        var G__17213 = cljs.core.next(coll);
        pred = G__17212;
        coll = G__17213;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__17214 = null;
    var G__17214__0 = function() {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
    };
    var G__17214__1 = function(x) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x));
    };
    var G__17214__2 = function(x, y) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y));
    };
    var G__17214__3 = function() {
      var G__17215__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__17215 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__17216__i = 0, G__17216__a = new Array(arguments.length - 2);
          while (G__17216__i < G__17216__a.length) {
            G__17216__a[G__17216__i] = arguments[G__17216__i + 2];
            ++G__17216__i;
          }
          zs = new cljs.core.IndexedSeq(G__17216__a, 0);
        }
        return G__17215__delegate.call(this, x, y, zs);
      };
      G__17215.cljs$lang$maxFixedArity = 2;
      G__17215.cljs$lang$applyTo = function(arglist__17217) {
        var x = cljs.core.first(arglist__17217);
        arglist__17217 = cljs.core.next(arglist__17217);
        var y = cljs.core.first(arglist__17217);
        var zs = cljs.core.rest(arglist__17217);
        return G__17215__delegate(x, y, zs);
      };
      G__17215.cljs$core$IFn$_invoke$arity$variadic = G__17215__delegate;
      return G__17215;
    }();
    G__17214 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__17214__0.call(this);
        case 1:
          return G__17214__1.call(this, x);
        case 2:
          return G__17214__2.call(this, x, y);
        default:
          var G__17218 = null;
          if (arguments.length > 2) {
            var G__17219__i = 0, G__17219__a = new Array(arguments.length - 2);
            while (G__17219__i < G__17219__a.length) {
              G__17219__a[G__17219__i] = arguments[G__17219__i + 2];
              ++G__17219__i;
            }
            G__17218 = new cljs.core.IndexedSeq(G__17219__a, 0);
          }
          return G__17214__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__17218);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17214.cljs$lang$maxFixedArity = 2;
    G__17214.cljs$lang$applyTo = G__17214__3.cljs$lang$applyTo;
    G__17214.cljs$core$IFn$_invoke$arity$0 = G__17214__0;
    G__17214.cljs$core$IFn$_invoke$arity$1 = G__17214__1;
    G__17214.cljs$core$IFn$_invoke$arity$2 = G__17214__2;
    G__17214.cljs$core$IFn$_invoke$arity$variadic = G__17214__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__17214;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__17220__delegate = function(args) {
      return x;
    };
    var G__17220 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__17221__i = 0, G__17221__a = new Array(arguments.length - 0);
        while (G__17221__i < G__17221__a.length) {
          G__17221__a[G__17221__i] = arguments[G__17221__i + 0];
          ++G__17221__i;
        }
        args = new cljs.core.IndexedSeq(G__17221__a, 0);
      }
      return G__17220__delegate.call(this, args);
    };
    G__17220.cljs$lang$maxFixedArity = 0;
    G__17220.cljs$lang$applyTo = function(arglist__17222) {
      var args = cljs.core.seq(arglist__17222);
      return G__17220__delegate(args);
    };
    G__17220.cljs$core$IFn$_invoke$arity$variadic = G__17220__delegate;
    return G__17220;
  }();
};
cljs.core.comp = function cljs$core$comp(var_args) {
  var args17223 = [];
  var len__7200__auto___17250 = arguments.length;
  var i__7201__auto___17251 = 0;
  while (true) {
    if (i__7201__auto___17251 < len__7200__auto___17250) {
      args17223.push(arguments[i__7201__auto___17251]);
      var G__17252 = i__7201__auto___17251 + 1;
      i__7201__auto___17251 = G__17252;
      continue;
    } else {
    }
    break;
  }
  var G__17229 = args17223.length;
  switch(G__17229) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17223.slice(3), 0);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7219__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__17254 = null;
    var G__17254__0 = function() {
      var G__17230 = g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17230) : f.call(null, G__17230);
    };
    var G__17254__1 = function(x) {
      var G__17231 = g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null, x);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17231) : f.call(null, G__17231);
    };
    var G__17254__2 = function(x, y) {
      var G__17232 = g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x, y) : g.call(null, x, y);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17232) : f.call(null, G__17232);
    };
    var G__17254__3 = function(x, y, z) {
      var G__17233 = g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x, y, z) : g.call(null, x, y, z);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17233) : f.call(null, G__17233);
    };
    var G__17254__4 = function() {
      var G__17255__delegate = function(x, y, z, args) {
        var G__17234 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17234) : f.call(null, G__17234);
      };
      var G__17255 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17256__i = 0, G__17256__a = new Array(arguments.length - 3);
          while (G__17256__i < G__17256__a.length) {
            G__17256__a[G__17256__i] = arguments[G__17256__i + 3];
            ++G__17256__i;
          }
          args = new cljs.core.IndexedSeq(G__17256__a, 0);
        }
        return G__17255__delegate.call(this, x, y, z, args);
      };
      G__17255.cljs$lang$maxFixedArity = 3;
      G__17255.cljs$lang$applyTo = function(arglist__17257) {
        var x = cljs.core.first(arglist__17257);
        arglist__17257 = cljs.core.next(arglist__17257);
        var y = cljs.core.first(arglist__17257);
        arglist__17257 = cljs.core.next(arglist__17257);
        var z = cljs.core.first(arglist__17257);
        var args = cljs.core.rest(arglist__17257);
        return G__17255__delegate(x, y, z, args);
      };
      G__17255.cljs$core$IFn$_invoke$arity$variadic = G__17255__delegate;
      return G__17255;
    }();
    G__17254 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17254__0.call(this);
        case 1:
          return G__17254__1.call(this, x);
        case 2:
          return G__17254__2.call(this, x, y);
        case 3:
          return G__17254__3.call(this, x, y, z);
        default:
          var G__17258 = null;
          if (arguments.length > 3) {
            var G__17259__i = 0, G__17259__a = new Array(arguments.length - 3);
            while (G__17259__i < G__17259__a.length) {
              G__17259__a[G__17259__i] = arguments[G__17259__i + 3];
              ++G__17259__i;
            }
            G__17258 = new cljs.core.IndexedSeq(G__17259__a, 0);
          }
          return G__17254__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17258);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17254.cljs$lang$maxFixedArity = 3;
    G__17254.cljs$lang$applyTo = G__17254__4.cljs$lang$applyTo;
    G__17254.cljs$core$IFn$_invoke$arity$0 = G__17254__0;
    G__17254.cljs$core$IFn$_invoke$arity$1 = G__17254__1;
    G__17254.cljs$core$IFn$_invoke$arity$2 = G__17254__2;
    G__17254.cljs$core$IFn$_invoke$arity$3 = G__17254__3;
    G__17254.cljs$core$IFn$_invoke$arity$variadic = G__17254__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17254;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__17260 = null;
    var G__17260__0 = function() {
      var G__17236 = function() {
        var G__17237 = h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17237) : g.call(null, G__17237);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17236) : f.call(null, G__17236);
    };
    var G__17260__1 = function(x) {
      var G__17239 = function() {
        var G__17240 = h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null, x);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17240) : g.call(null, G__17240);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17239) : f.call(null, G__17239);
    };
    var G__17260__2 = function(x, y) {
      var G__17242 = function() {
        var G__17243 = h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x, y) : h.call(null, x, y);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17243) : g.call(null, G__17243);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17242) : f.call(null, G__17242);
    };
    var G__17260__3 = function(x, y, z) {
      var G__17245 = function() {
        var G__17246 = h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x, y, z) : h.call(null, x, y, z);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17246) : g.call(null, G__17246);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17245) : f.call(null, G__17245);
    };
    var G__17260__4 = function() {
      var G__17261__delegate = function(x, y, z, args) {
        var G__17248 = function() {
          var G__17249 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17249) : g.call(null, G__17249);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17248) : f.call(null, G__17248);
      };
      var G__17261 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17262__i = 0, G__17262__a = new Array(arguments.length - 3);
          while (G__17262__i < G__17262__a.length) {
            G__17262__a[G__17262__i] = arguments[G__17262__i + 3];
            ++G__17262__i;
          }
          args = new cljs.core.IndexedSeq(G__17262__a, 0);
        }
        return G__17261__delegate.call(this, x, y, z, args);
      };
      G__17261.cljs$lang$maxFixedArity = 3;
      G__17261.cljs$lang$applyTo = function(arglist__17263) {
        var x = cljs.core.first(arglist__17263);
        arglist__17263 = cljs.core.next(arglist__17263);
        var y = cljs.core.first(arglist__17263);
        arglist__17263 = cljs.core.next(arglist__17263);
        var z = cljs.core.first(arglist__17263);
        var args = cljs.core.rest(arglist__17263);
        return G__17261__delegate(x, y, z, args);
      };
      G__17261.cljs$core$IFn$_invoke$arity$variadic = G__17261__delegate;
      return G__17261;
    }();
    G__17260 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17260__0.call(this);
        case 1:
          return G__17260__1.call(this, x);
        case 2:
          return G__17260__2.call(this, x, y);
        case 3:
          return G__17260__3.call(this, x, y, z);
        default:
          var G__17264 = null;
          if (arguments.length > 3) {
            var G__17265__i = 0, G__17265__a = new Array(arguments.length - 3);
            while (G__17265__i < G__17265__a.length) {
              G__17265__a[G__17265__i] = arguments[G__17265__i + 3];
              ++G__17265__i;
            }
            G__17264 = new cljs.core.IndexedSeq(G__17265__a, 0);
          }
          return G__17260__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17264);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17260.cljs$lang$maxFixedArity = 3;
    G__17260.cljs$lang$applyTo = G__17260__4.cljs$lang$applyTo;
    G__17260.cljs$core$IFn$_invoke$arity$0 = G__17260__0;
    G__17260.cljs$core$IFn$_invoke$arity$1 = G__17260__1;
    G__17260.cljs$core$IFn$_invoke$arity$2 = G__17260__2;
    G__17260.cljs$core$IFn$_invoke$arity$3 = G__17260__3;
    G__17260.cljs$core$IFn$_invoke$arity$variadic = G__17260__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17260;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__17266__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__17267 = cljs.core.first(fs__$2).call(null, ret);
            var G__17268 = cljs.core.next(fs__$2);
            ret = G__17267;
            fs__$2 = G__17268;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__17266 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__17269__i = 0, G__17269__a = new Array(arguments.length - 0);
          while (G__17269__i < G__17269__a.length) {
            G__17269__a[G__17269__i] = arguments[G__17269__i + 0];
            ++G__17269__i;
          }
          args = new cljs.core.IndexedSeq(G__17269__a, 0);
        }
        return G__17266__delegate.call(this, args);
      };
      G__17266.cljs$lang$maxFixedArity = 0;
      G__17266.cljs$lang$applyTo = function(arglist__17270) {
        var args = cljs.core.seq(arglist__17270);
        return G__17266__delegate(args);
      };
      G__17266.cljs$core$IFn$_invoke$arity$variadic = G__17266__delegate;
      return G__17266;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq17224) {
  var G__17225 = cljs.core.first(seq17224);
  var seq17224__$1 = cljs.core.next(seq17224);
  var G__17226 = cljs.core.first(seq17224__$1);
  var seq17224__$2 = cljs.core.next(seq17224__$1);
  var G__17227 = cljs.core.first(seq17224__$2);
  var seq17224__$3 = cljs.core.next(seq17224__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__17225, G__17226, G__17227, seq17224__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial(var_args) {
  var args17271 = [];
  var len__7200__auto___17279 = arguments.length;
  var i__7201__auto___17280 = 0;
  while (true) {
    if (i__7201__auto___17280 < len__7200__auto___17279) {
      args17271.push(arguments[i__7201__auto___17280]);
      var G__17281 = i__7201__auto___17280 + 1;
      i__7201__auto___17280 = G__17281;
      continue;
    } else {
    }
    break;
  }
  var G__17278 = args17271.length;
  switch(G__17278) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17271.slice(4), 0);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7219__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__17283 = null;
    var G__17283__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null, arg1);
    };
    var G__17283__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, x) : f.call(null, arg1, x);
    };
    var G__17283__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, x, y) : f.call(null, arg1, x, y);
    };
    var G__17283__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, x, y, z) : f.call(null, arg1, x, y, z);
    };
    var G__17283__4 = function() {
      var G__17284__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__17284 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17285__i = 0, G__17285__a = new Array(arguments.length - 3);
          while (G__17285__i < G__17285__a.length) {
            G__17285__a[G__17285__i] = arguments[G__17285__i + 3];
            ++G__17285__i;
          }
          args = new cljs.core.IndexedSeq(G__17285__a, 0);
        }
        return G__17284__delegate.call(this, x, y, z, args);
      };
      G__17284.cljs$lang$maxFixedArity = 3;
      G__17284.cljs$lang$applyTo = function(arglist__17286) {
        var x = cljs.core.first(arglist__17286);
        arglist__17286 = cljs.core.next(arglist__17286);
        var y = cljs.core.first(arglist__17286);
        arglist__17286 = cljs.core.next(arglist__17286);
        var z = cljs.core.first(arglist__17286);
        var args = cljs.core.rest(arglist__17286);
        return G__17284__delegate(x, y, z, args);
      };
      G__17284.cljs$core$IFn$_invoke$arity$variadic = G__17284__delegate;
      return G__17284;
    }();
    G__17283 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17283__0.call(this);
        case 1:
          return G__17283__1.call(this, x);
        case 2:
          return G__17283__2.call(this, x, y);
        case 3:
          return G__17283__3.call(this, x, y, z);
        default:
          var G__17287 = null;
          if (arguments.length > 3) {
            var G__17288__i = 0, G__17288__a = new Array(arguments.length - 3);
            while (G__17288__i < G__17288__a.length) {
              G__17288__a[G__17288__i] = arguments[G__17288__i + 3];
              ++G__17288__i;
            }
            G__17287 = new cljs.core.IndexedSeq(G__17288__a, 0);
          }
          return G__17283__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17287);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17283.cljs$lang$maxFixedArity = 3;
    G__17283.cljs$lang$applyTo = G__17283__4.cljs$lang$applyTo;
    G__17283.cljs$core$IFn$_invoke$arity$0 = G__17283__0;
    G__17283.cljs$core$IFn$_invoke$arity$1 = G__17283__1;
    G__17283.cljs$core$IFn$_invoke$arity$2 = G__17283__2;
    G__17283.cljs$core$IFn$_invoke$arity$3 = G__17283__3;
    G__17283.cljs$core$IFn$_invoke$arity$variadic = G__17283__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17283;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__17289 = null;
    var G__17289__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, arg2) : f.call(null, arg1, arg2);
    };
    var G__17289__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, x) : f.call(null, arg1, arg2, x);
    };
    var G__17289__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, x, y) : f.call(null, arg1, arg2, x, y);
    };
    var G__17289__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, x, y, z) : f.call(null, arg1, arg2, x, y, z);
    };
    var G__17289__4 = function() {
      var G__17290__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__17290 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17291__i = 0, G__17291__a = new Array(arguments.length - 3);
          while (G__17291__i < G__17291__a.length) {
            G__17291__a[G__17291__i] = arguments[G__17291__i + 3];
            ++G__17291__i;
          }
          args = new cljs.core.IndexedSeq(G__17291__a, 0);
        }
        return G__17290__delegate.call(this, x, y, z, args);
      };
      G__17290.cljs$lang$maxFixedArity = 3;
      G__17290.cljs$lang$applyTo = function(arglist__17292) {
        var x = cljs.core.first(arglist__17292);
        arglist__17292 = cljs.core.next(arglist__17292);
        var y = cljs.core.first(arglist__17292);
        arglist__17292 = cljs.core.next(arglist__17292);
        var z = cljs.core.first(arglist__17292);
        var args = cljs.core.rest(arglist__17292);
        return G__17290__delegate(x, y, z, args);
      };
      G__17290.cljs$core$IFn$_invoke$arity$variadic = G__17290__delegate;
      return G__17290;
    }();
    G__17289 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17289__0.call(this);
        case 1:
          return G__17289__1.call(this, x);
        case 2:
          return G__17289__2.call(this, x, y);
        case 3:
          return G__17289__3.call(this, x, y, z);
        default:
          var G__17293 = null;
          if (arguments.length > 3) {
            var G__17294__i = 0, G__17294__a = new Array(arguments.length - 3);
            while (G__17294__i < G__17294__a.length) {
              G__17294__a[G__17294__i] = arguments[G__17294__i + 3];
              ++G__17294__i;
            }
            G__17293 = new cljs.core.IndexedSeq(G__17294__a, 0);
          }
          return G__17289__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17293);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17289.cljs$lang$maxFixedArity = 3;
    G__17289.cljs$lang$applyTo = G__17289__4.cljs$lang$applyTo;
    G__17289.cljs$core$IFn$_invoke$arity$0 = G__17289__0;
    G__17289.cljs$core$IFn$_invoke$arity$1 = G__17289__1;
    G__17289.cljs$core$IFn$_invoke$arity$2 = G__17289__2;
    G__17289.cljs$core$IFn$_invoke$arity$3 = G__17289__3;
    G__17289.cljs$core$IFn$_invoke$arity$variadic = G__17289__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17289;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__17295 = null;
    var G__17295__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, arg3) : f.call(null, arg1, arg2, arg3);
    };
    var G__17295__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, arg3, x) : f.call(null, arg1, arg2, arg3, x);
    };
    var G__17295__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, arg3, x, y) : f.call(null, arg1, arg2, arg3, x, y);
    };
    var G__17295__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1, arg2, arg3, x, y, z) : f.call(null, arg1, arg2, arg3, x, y, z);
    };
    var G__17295__4 = function() {
      var G__17296__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__17296 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17297__i = 0, G__17297__a = new Array(arguments.length - 3);
          while (G__17297__i < G__17297__a.length) {
            G__17297__a[G__17297__i] = arguments[G__17297__i + 3];
            ++G__17297__i;
          }
          args = new cljs.core.IndexedSeq(G__17297__a, 0);
        }
        return G__17296__delegate.call(this, x, y, z, args);
      };
      G__17296.cljs$lang$maxFixedArity = 3;
      G__17296.cljs$lang$applyTo = function(arglist__17298) {
        var x = cljs.core.first(arglist__17298);
        arglist__17298 = cljs.core.next(arglist__17298);
        var y = cljs.core.first(arglist__17298);
        arglist__17298 = cljs.core.next(arglist__17298);
        var z = cljs.core.first(arglist__17298);
        var args = cljs.core.rest(arglist__17298);
        return G__17296__delegate(x, y, z, args);
      };
      G__17296.cljs$core$IFn$_invoke$arity$variadic = G__17296__delegate;
      return G__17296;
    }();
    G__17295 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17295__0.call(this);
        case 1:
          return G__17295__1.call(this, x);
        case 2:
          return G__17295__2.call(this, x, y);
        case 3:
          return G__17295__3.call(this, x, y, z);
        default:
          var G__17299 = null;
          if (arguments.length > 3) {
            var G__17300__i = 0, G__17300__a = new Array(arguments.length - 3);
            while (G__17300__i < G__17300__a.length) {
              G__17300__a[G__17300__i] = arguments[G__17300__i + 3];
              ++G__17300__i;
            }
            G__17299 = new cljs.core.IndexedSeq(G__17300__a, 0);
          }
          return G__17295__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17299);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17295.cljs$lang$maxFixedArity = 3;
    G__17295.cljs$lang$applyTo = G__17295__4.cljs$lang$applyTo;
    G__17295.cljs$core$IFn$_invoke$arity$0 = G__17295__0;
    G__17295.cljs$core$IFn$_invoke$arity$1 = G__17295__1;
    G__17295.cljs$core$IFn$_invoke$arity$2 = G__17295__2;
    G__17295.cljs$core$IFn$_invoke$arity$3 = G__17295__3;
    G__17295.cljs$core$IFn$_invoke$arity$variadic = G__17295__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17295;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__17301__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__17301 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__17302__i = 0, G__17302__a = new Array(arguments.length - 0);
        while (G__17302__i < G__17302__a.length) {
          G__17302__a[G__17302__i] = arguments[G__17302__i + 0];
          ++G__17302__i;
        }
        args = new cljs.core.IndexedSeq(G__17302__a, 0);
      }
      return G__17301__delegate.call(this, args);
    };
    G__17301.cljs$lang$maxFixedArity = 0;
    G__17301.cljs$lang$applyTo = function(arglist__17303) {
      var args = cljs.core.seq(arglist__17303);
      return G__17301__delegate(args);
    };
    G__17301.cljs$core$IFn$_invoke$arity$variadic = G__17301__delegate;
    return G__17301;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq17272) {
  var G__17273 = cljs.core.first(seq17272);
  var seq17272__$1 = cljs.core.next(seq17272);
  var G__17274 = cljs.core.first(seq17272__$1);
  var seq17272__$2 = cljs.core.next(seq17272__$1);
  var G__17275 = cljs.core.first(seq17272__$2);
  var seq17272__$3 = cljs.core.next(seq17272__$2);
  var G__17276 = cljs.core.first(seq17272__$3);
  var seq17272__$4 = cljs.core.next(seq17272__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__17273, G__17274, G__17275, G__17276, seq17272__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil(var_args) {
  var args17304 = [];
  var len__7200__auto___17323 = arguments.length;
  var i__7201__auto___17324 = 0;
  while (true) {
    if (i__7201__auto___17324 < len__7200__auto___17323) {
      args17304.push(arguments[i__7201__auto___17324]);
      var G__17325 = i__7201__auto___17324 + 1;
      i__7201__auto___17324 = G__17325;
      continue;
    } else {
    }
    break;
  }
  var G__17306 = args17304.length;
  switch(G__17306) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17304.length)].join(""));;
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__17327 = null;
    var G__17327__1 = function(a) {
      var G__17307 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17307) : f.call(null, G__17307);
    };
    var G__17327__2 = function(a, b) {
      var G__17308 = a == null ? x : a;
      var G__17309 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17308, G__17309) : f.call(null, G__17308, G__17309);
    };
    var G__17327__3 = function(a, b, c) {
      var G__17310 = a == null ? x : a;
      var G__17311 = b;
      var G__17312 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17310, G__17311, G__17312) : f.call(null, G__17310, G__17311, G__17312);
    };
    var G__17327__4 = function() {
      var G__17328__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__17328 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__17329__i = 0, G__17329__a = new Array(arguments.length - 3);
          while (G__17329__i < G__17329__a.length) {
            G__17329__a[G__17329__i] = arguments[G__17329__i + 3];
            ++G__17329__i;
          }
          ds = new cljs.core.IndexedSeq(G__17329__a, 0);
        }
        return G__17328__delegate.call(this, a, b, c, ds);
      };
      G__17328.cljs$lang$maxFixedArity = 3;
      G__17328.cljs$lang$applyTo = function(arglist__17330) {
        var a = cljs.core.first(arglist__17330);
        arglist__17330 = cljs.core.next(arglist__17330);
        var b = cljs.core.first(arglist__17330);
        arglist__17330 = cljs.core.next(arglist__17330);
        var c = cljs.core.first(arglist__17330);
        var ds = cljs.core.rest(arglist__17330);
        return G__17328__delegate(a, b, c, ds);
      };
      G__17328.cljs$core$IFn$_invoke$arity$variadic = G__17328__delegate;
      return G__17328;
    }();
    G__17327 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__17327__1.call(this, a);
        case 2:
          return G__17327__2.call(this, a, b);
        case 3:
          return G__17327__3.call(this, a, b, c);
        default:
          var G__17331 = null;
          if (arguments.length > 3) {
            var G__17332__i = 0, G__17332__a = new Array(arguments.length - 3);
            while (G__17332__i < G__17332__a.length) {
              G__17332__a[G__17332__i] = arguments[G__17332__i + 3];
              ++G__17332__i;
            }
            G__17331 = new cljs.core.IndexedSeq(G__17332__a, 0);
          }
          return G__17327__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__17331);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17327.cljs$lang$maxFixedArity = 3;
    G__17327.cljs$lang$applyTo = G__17327__4.cljs$lang$applyTo;
    G__17327.cljs$core$IFn$_invoke$arity$1 = G__17327__1;
    G__17327.cljs$core$IFn$_invoke$arity$2 = G__17327__2;
    G__17327.cljs$core$IFn$_invoke$arity$3 = G__17327__3;
    G__17327.cljs$core$IFn$_invoke$arity$variadic = G__17327__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17327;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__17333 = null;
    var G__17333__2 = function(a, b) {
      var G__17313 = a == null ? x : a;
      var G__17314 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17313, G__17314) : f.call(null, G__17313, G__17314);
    };
    var G__17333__3 = function(a, b, c) {
      var G__17315 = a == null ? x : a;
      var G__17316 = b == null ? y : b;
      var G__17317 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17315, G__17316, G__17317) : f.call(null, G__17315, G__17316, G__17317);
    };
    var G__17333__4 = function() {
      var G__17334__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__17334 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__17335__i = 0, G__17335__a = new Array(arguments.length - 3);
          while (G__17335__i < G__17335__a.length) {
            G__17335__a[G__17335__i] = arguments[G__17335__i + 3];
            ++G__17335__i;
          }
          ds = new cljs.core.IndexedSeq(G__17335__a, 0);
        }
        return G__17334__delegate.call(this, a, b, c, ds);
      };
      G__17334.cljs$lang$maxFixedArity = 3;
      G__17334.cljs$lang$applyTo = function(arglist__17336) {
        var a = cljs.core.first(arglist__17336);
        arglist__17336 = cljs.core.next(arglist__17336);
        var b = cljs.core.first(arglist__17336);
        arglist__17336 = cljs.core.next(arglist__17336);
        var c = cljs.core.first(arglist__17336);
        var ds = cljs.core.rest(arglist__17336);
        return G__17334__delegate(a, b, c, ds);
      };
      G__17334.cljs$core$IFn$_invoke$arity$variadic = G__17334__delegate;
      return G__17334;
    }();
    G__17333 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__17333__2.call(this, a, b);
        case 3:
          return G__17333__3.call(this, a, b, c);
        default:
          var G__17337 = null;
          if (arguments.length > 3) {
            var G__17338__i = 0, G__17338__a = new Array(arguments.length - 3);
            while (G__17338__i < G__17338__a.length) {
              G__17338__a[G__17338__i] = arguments[G__17338__i + 3];
              ++G__17338__i;
            }
            G__17337 = new cljs.core.IndexedSeq(G__17338__a, 0);
          }
          return G__17333__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__17337);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17333.cljs$lang$maxFixedArity = 3;
    G__17333.cljs$lang$applyTo = G__17333__4.cljs$lang$applyTo;
    G__17333.cljs$core$IFn$_invoke$arity$2 = G__17333__2;
    G__17333.cljs$core$IFn$_invoke$arity$3 = G__17333__3;
    G__17333.cljs$core$IFn$_invoke$arity$variadic = G__17333__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17333;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__17339 = null;
    var G__17339__2 = function(a, b) {
      var G__17318 = a == null ? x : a;
      var G__17319 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17318, G__17319) : f.call(null, G__17318, G__17319);
    };
    var G__17339__3 = function(a, b, c) {
      var G__17320 = a == null ? x : a;
      var G__17321 = b == null ? y : b;
      var G__17322 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17320, G__17321, G__17322) : f.call(null, G__17320, G__17321, G__17322);
    };
    var G__17339__4 = function() {
      var G__17340__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__17340 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__17341__i = 0, G__17341__a = new Array(arguments.length - 3);
          while (G__17341__i < G__17341__a.length) {
            G__17341__a[G__17341__i] = arguments[G__17341__i + 3];
            ++G__17341__i;
          }
          ds = new cljs.core.IndexedSeq(G__17341__a, 0);
        }
        return G__17340__delegate.call(this, a, b, c, ds);
      };
      G__17340.cljs$lang$maxFixedArity = 3;
      G__17340.cljs$lang$applyTo = function(arglist__17342) {
        var a = cljs.core.first(arglist__17342);
        arglist__17342 = cljs.core.next(arglist__17342);
        var b = cljs.core.first(arglist__17342);
        arglist__17342 = cljs.core.next(arglist__17342);
        var c = cljs.core.first(arglist__17342);
        var ds = cljs.core.rest(arglist__17342);
        return G__17340__delegate(a, b, c, ds);
      };
      G__17340.cljs$core$IFn$_invoke$arity$variadic = G__17340__delegate;
      return G__17340;
    }();
    G__17339 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__17339__2.call(this, a, b);
        case 3:
          return G__17339__3.call(this, a, b, c);
        default:
          var G__17343 = null;
          if (arguments.length > 3) {
            var G__17344__i = 0, G__17344__a = new Array(arguments.length - 3);
            while (G__17344__i < G__17344__a.length) {
              G__17344__a[G__17344__i] = arguments[G__17344__i + 3];
              ++G__17344__i;
            }
            G__17343 = new cljs.core.IndexedSeq(G__17344__a, 0);
          }
          return G__17339__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__17343);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17339.cljs$lang$maxFixedArity = 3;
    G__17339.cljs$lang$applyTo = G__17339__4.cljs$lang$applyTo;
    G__17339.cljs$core$IFn$_invoke$arity$2 = G__17339__2;
    G__17339.cljs$core$IFn$_invoke$arity$3 = G__17339__3;
    G__17339.cljs$core$IFn$_invoke$arity$variadic = G__17339__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17339;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed(var_args) {
  var args17345 = [];
  var len__7200__auto___17378 = arguments.length;
  var i__7201__auto___17379 = 0;
  while (true) {
    if (i__7201__auto___17379 < len__7200__auto___17378) {
      args17345.push(arguments[i__7201__auto___17379]);
      var G__17380 = i__7201__auto___17379 + 1;
      i__7201__auto___17379 = G__17380;
      continue;
    } else {
    }
    break;
  }
  var G__17347 = args17345.length;
  switch(G__17347) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17345.length)].join(""));;
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(-1) : cljs.core.volatile_BANG_.call(null, -1);
    return function(i) {
      return function() {
        var G__17382 = null;
        var G__17382__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17382__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__17382__2 = function(result, input) {
          var G__17350 = result;
          var G__17351 = function() {
            var G__17352 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__17353 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17352, G__17353) : f.call(null, G__17352, G__17353);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17350, G__17351) : rf.call(null, G__17350, G__17351);
        };
        G__17382 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17382__0.call(this);
            case 1:
              return G__17382__1.call(this, result);
            case 2:
              return G__17382__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17382.cljs$core$IFn$_invoke$arity$0 = G__17382__0;
        G__17382.cljs$core$IFn$_invoke$arity$1 = G__17382__1;
        G__17382.cljs$core$IFn$_invoke$arity$2 = G__17382__2;
        return G__17382;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__7045__auto___17383 = size;
          var i_17384 = 0;
          while (true) {
            if (i_17384 < n__7045__auto___17383) {
              cljs.core.chunk_append(b, function() {
                var G__17374 = idx + i_17384;
                var G__17375 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17384);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17374, G__17375) : f.call(null, G__17374, G__17375);
              }());
              var G__17385 = i_17384 + 1;
              i_17384 = G__17385;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__17376 = idx;
            var G__17377 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17376, G__17377) : f.call(null, G__17376, G__17377);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep(var_args) {
  var args17386 = [];
  var len__7200__auto___17391 = arguments.length;
  var i__7201__auto___17392 = 0;
  while (true) {
    if (i__7201__auto___17392 < len__7200__auto___17391) {
      args17386.push(arguments[i__7201__auto___17392]);
      var G__17393 = i__7201__auto___17392 + 1;
      i__7201__auto___17392 = G__17393;
      continue;
    } else {
    }
    break;
  }
  var G__17388 = args17386.length;
  switch(G__17388) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17386.length)].join(""));;
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__17395 = null;
      var G__17395__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__17395__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__17395__2 = function(result, input) {
        var v = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        if (v == null) {
          return result;
        } else {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
        }
      };
      G__17395 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__17395__0.call(this);
          case 1:
            return G__17395__1.call(this, result);
          case 2:
            return G__17395__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__17395.cljs$core$IFn$_invoke$arity$0 = G__17395__0;
      G__17395.cljs$core$IFn$_invoke$arity$1 = G__17395__1;
      G__17395.cljs$core$IFn$_invoke$arity$2 = G__17395__2;
      return G__17395;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__7045__auto___17396 = size;
        var i_17397 = 0;
        while (true) {
          if (i_17397 < n__7045__auto___17396) {
            var x_17398 = function() {
              var G__17389 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17397);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17389) : f.call(null, G__17389);
            }();
            if (x_17398 == null) {
            } else {
              cljs.core.chunk_append(b, x_17398);
            }
            var G__17399 = i_17397 + 1;
            i_17397 = G__17399;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__17390 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17390) : f.call(null, G__17390);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__17400 = cljs.core.seq(self__.watches);
  var chunk__17401 = null;
  var count__17402 = 0;
  var i__17403 = 0;
  while (true) {
    if (i__17403 < count__17402) {
      var vec__17404 = chunk__17401.cljs$core$IIndexed$_nth$arity$2(null, i__17403);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17404, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17404, 1, null);
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
      var G__17406 = seq__17400;
      var G__17407 = chunk__17401;
      var G__17408 = count__17402;
      var G__17409 = i__17403 + 1;
      seq__17400 = G__17406;
      chunk__17401 = G__17407;
      count__17402 = G__17408;
      i__17403 = G__17409;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__17400);
      if (temp__4425__auto__) {
        var seq__17400__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__17400__$1)) {
          var c__6945__auto__ = cljs.core.chunk_first(seq__17400__$1);
          var G__17410 = cljs.core.chunk_rest(seq__17400__$1);
          var G__17411 = c__6945__auto__;
          var G__17412 = cljs.core.count(c__6945__auto__);
          var G__17413 = 0;
          seq__17400 = G__17410;
          chunk__17401 = G__17411;
          count__17402 = G__17412;
          i__17403 = G__17413;
          continue;
        } else {
          var vec__17405 = cljs.core.first(seq__17400__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17405, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17405, 1, null);
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
          var G__17414 = cljs.core.next(seq__17400__$1);
          var G__17415 = null;
          var G__17416 = 0;
          var G__17417 = 0;
          seq__17400 = G__17414;
          chunk__17401 = G__17415;
          count__17402 = G__17416;
          i__17403 = G__17417;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return goog.getUid(this$__$1);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom(var_args) {
  var args17418 = [];
  var len__7200__auto___17426 = arguments.length;
  var i__7201__auto___17427 = 0;
  while (true) {
    if (i__7201__auto___17427 < len__7200__auto___17426) {
      args17418.push(arguments[i__7201__auto___17427]);
      var G__17428 = i__7201__auto___17427 + 1;
      i__7201__auto___17427 = G__17428;
      continue;
    } else {
    }
    break;
  }
  var G__17422 = args17418.length;
  switch(G__17422) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17418.slice(1), 0);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__7219__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__17423) {
  var map__17424 = p__17423;
  var map__17424__$1 = (!(map__17424 == null) ? map__17424.cljs$lang$protocol_mask$partition0$ & 64 || map__17424.cljs$core$ISeq$ ? true : false : false) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__17424) : map__17424;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17424__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17424__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq17419) {
  var G__17420 = cljs.core.first(seq17419);
  var seq17419__$1 = cljs.core.next(seq17419);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__17420, seq17419__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value))) {
      } else {
        throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(function() {
          var G__17431 = cljs.core.list(new cljs.core.Symbol(null, "validate", "validate", 1439230700, null), new cljs.core.Symbol(null, "new-value", "new-value", -1567397401, null));
          return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17431) : cljs.core.pr_str.call(null, G__17431);
        }())].join(""));
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_(var_args) {
  var args17432 = [];
  var len__7200__auto___17446 = arguments.length;
  var i__7201__auto___17447 = 0;
  while (true) {
    if (i__7201__auto___17447 < len__7200__auto___17446) {
      args17432.push(arguments[i__7201__auto___17447]);
      var G__17448 = i__7201__auto___17447 + 1;
      i__7201__auto___17447 = G__17448;
      continue;
    } else {
    }
    break;
  }
  var G__17439 = args17432.length;
  switch(G__17439) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17432.slice(4), 0);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7219__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__17440 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17440) : f.call(null, G__17440);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__17441 = a.state;
      var G__17442 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17441, G__17442) : f.call(null, G__17441, G__17442);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__17443 = a.state;
      var G__17444 = x;
      var G__17445 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17443, G__17444, G__17445) : f.call(null, G__17443, G__17444, G__17445);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq17433) {
  var G__17434 = cljs.core.first(seq17433);
  var seq17433__$1 = cljs.core.next(seq17433);
  var G__17435 = cljs.core.first(seq17433__$1);
  var seq17433__$2 = cljs.core.next(seq17433__$1);
  var G__17436 = cljs.core.first(seq17433__$2);
  var seq17433__$3 = cljs.core.next(seq17433__$2);
  var G__17437 = cljs.core.first(seq17433__$3);
  var seq17433__$4 = cljs.core.next(seq17433__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17434, G__17435, G__17436, G__17437, seq17433__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed(var_args) {
  var args17450 = [];
  var len__7200__auto___17481 = arguments.length;
  var i__7201__auto___17482 = 0;
  while (true) {
    if (i__7201__auto___17482 < len__7200__auto___17481) {
      args17450.push(arguments[i__7201__auto___17482]);
      var G__17483 = i__7201__auto___17482 + 1;
      i__7201__auto___17482 = G__17483;
      continue;
    } else {
    }
    break;
  }
  var G__17452 = args17450.length;
  switch(G__17452) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17450.length)].join(""));;
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__17485 = null;
        var G__17485__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17485__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__17485__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i, input) : f.call(null, i, input);
          if (v == null) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
          }
        };
        G__17485 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17485__0.call(this);
            case 1:
              return G__17485__1.call(this, result);
            case 2:
              return G__17485__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17485.cljs$core$IFn$_invoke$arity$0 = G__17485__0;
        G__17485.cljs$core$IFn$_invoke$arity$1 = G__17485__1;
        G__17485.cljs$core$IFn$_invoke$arity$2 = G__17485__2;
        return G__17485;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4425__auto__ = cljs.core.seq(coll__$1);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__7045__auto___17486 = size;
          var i_17487 = 0;
          while (true) {
            if (i_17487 < n__7045__auto___17486) {
              var x_17488 = function() {
                var G__17477 = idx + i_17487;
                var G__17478 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17487);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17477, G__17478) : f.call(null, G__17477, G__17478);
              }();
              if (x_17488 == null) {
              } else {
                cljs.core.chunk_append(b, x_17488);
              }
              var G__17489 = i_17487 + 1;
              i_17487 = G__17489;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__17479 = idx;
            var G__17480 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17479, G__17480) : f.call(null, G__17479, G__17480);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred(var_args) {
  var args17496 = [];
  var len__7200__auto___17503 = arguments.length;
  var i__7201__auto___17504 = 0;
  while (true) {
    if (i__7201__auto___17504 < len__7200__auto___17503) {
      args17496.push(arguments[i__7201__auto___17504]);
      var G__17505 = i__7201__auto___17504 + 1;
      i__7201__auto___17504 = G__17505;
      continue;
    } else {
    }
    break;
  }
  var G__17502 = args17496.length;
  switch(G__17502) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17496.slice(3), 0);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7219__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          var and__6130__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
          if (cljs.core.truth_(and__6130__auto____$1)) {
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
          } else {
            return and__6130__auto____$1;
          }
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__17507__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__6130__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__6130__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__6130__auto__;
          }
        }());
      };
      var G__17507 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17508__i = 0, G__17508__a = new Array(arguments.length - 3);
          while (G__17508__i < G__17508__a.length) {
            G__17508__a[G__17508__i] = arguments[G__17508__i + 3];
            ++G__17508__i;
          }
          args = new cljs.core.IndexedSeq(G__17508__a, 0);
        }
        return G__17507__delegate.call(this, x, y, z, args);
      };
      G__17507.cljs$lang$maxFixedArity = 3;
      G__17507.cljs$lang$applyTo = function(arglist__17509) {
        var x = cljs.core.first(arglist__17509);
        arglist__17509 = cljs.core.next(arglist__17509);
        var y = cljs.core.first(arglist__17509);
        arglist__17509 = cljs.core.next(arglist__17509);
        var z = cljs.core.first(arglist__17509);
        var args = cljs.core.rest(arglist__17509);
        return G__17507__delegate(x, y, z, args);
      };
      G__17507.cljs$core$IFn$_invoke$arity$variadic = G__17507__delegate;
      return G__17507;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__17510 = null;
          if (arguments.length > 3) {
            var G__17511__i = 0, G__17511__a = new Array(arguments.length - 3);
            while (G__17511__i < G__17511__a.length) {
              G__17511__a[G__17511__i] = arguments[G__17511__i + 3];
              ++G__17511__i;
            }
            G__17510 = new cljs.core.IndexedSeq(G__17511__a, 0);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17510);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          var and__6130__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__6130__auto____$1)) {
            var and__6130__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(and__6130__auto____$2)) {
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
            } else {
              return and__6130__auto____$2;
            }
          } else {
            return and__6130__auto____$1;
          }
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          var and__6130__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__6130__auto____$1)) {
            var and__6130__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
            if (cljs.core.truth_(and__6130__auto____$2)) {
              var and__6130__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
              if (cljs.core.truth_(and__6130__auto____$3)) {
                var and__6130__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__6130__auto____$4)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                } else {
                  return and__6130__auto____$4;
                }
              } else {
                return and__6130__auto____$3;
              }
            } else {
              return and__6130__auto____$2;
            }
          } else {
            return and__6130__auto____$1;
          }
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__17512__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__6130__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__6130__auto__)) {
            return cljs.core.every_QMARK_(function(and__6130__auto__) {
              return function(p1__17490_SHARP_) {
                var and__6130__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__17490_SHARP_) : p1.call(null, p1__17490_SHARP_);
                if (cljs.core.truth_(and__6130__auto____$1)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__17490_SHARP_) : p2.call(null, p1__17490_SHARP_);
                } else {
                  return and__6130__auto____$1;
                }
              };
            }(and__6130__auto__), args);
          } else {
            return and__6130__auto__;
          }
        }());
      };
      var G__17512 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17513__i = 0, G__17513__a = new Array(arguments.length - 3);
          while (G__17513__i < G__17513__a.length) {
            G__17513__a[G__17513__i] = arguments[G__17513__i + 3];
            ++G__17513__i;
          }
          args = new cljs.core.IndexedSeq(G__17513__a, 0);
        }
        return G__17512__delegate.call(this, x, y, z, args);
      };
      G__17512.cljs$lang$maxFixedArity = 3;
      G__17512.cljs$lang$applyTo = function(arglist__17514) {
        var x = cljs.core.first(arglist__17514);
        arglist__17514 = cljs.core.next(arglist__17514);
        var y = cljs.core.first(arglist__17514);
        arglist__17514 = cljs.core.next(arglist__17514);
        var z = cljs.core.first(arglist__17514);
        var args = cljs.core.rest(arglist__17514);
        return G__17512__delegate(x, y, z, args);
      };
      G__17512.cljs$core$IFn$_invoke$arity$variadic = G__17512__delegate;
      return G__17512;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__17515 = null;
          if (arguments.length > 3) {
            var G__17516__i = 0, G__17516__a = new Array(arguments.length - 3);
            while (G__17516__i < G__17516__a.length) {
              G__17516__a[G__17516__i] = arguments[G__17516__i + 3];
              ++G__17516__i;
            }
            G__17515 = new cljs.core.IndexedSeq(G__17516__a, 0);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17515);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          var and__6130__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__6130__auto____$1)) {
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          } else {
            return and__6130__auto____$1;
          }
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          var and__6130__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__6130__auto____$1)) {
            var and__6130__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__6130__auto____$2)) {
              var and__6130__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__6130__auto____$3)) {
                var and__6130__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__6130__auto____$4)) {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                } else {
                  return and__6130__auto____$4;
                }
              } else {
                return and__6130__auto____$3;
              }
            } else {
              return and__6130__auto____$2;
            }
          } else {
            return and__6130__auto____$1;
          }
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__6130__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__6130__auto__)) {
          var and__6130__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__6130__auto____$1)) {
            var and__6130__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__6130__auto____$2)) {
              var and__6130__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__6130__auto____$3)) {
                var and__6130__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__6130__auto____$4)) {
                  var and__6130__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                  if (cljs.core.truth_(and__6130__auto____$5)) {
                    var and__6130__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                    if (cljs.core.truth_(and__6130__auto____$6)) {
                      var and__6130__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                      if (cljs.core.truth_(and__6130__auto____$7)) {
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                      } else {
                        return and__6130__auto____$7;
                      }
                    } else {
                      return and__6130__auto____$6;
                    }
                  } else {
                    return and__6130__auto____$5;
                  }
                } else {
                  return and__6130__auto____$4;
                }
              } else {
                return and__6130__auto____$3;
              }
            } else {
              return and__6130__auto____$2;
            }
          } else {
            return and__6130__auto____$1;
          }
        } else {
          return and__6130__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__17517__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__6130__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__6130__auto__)) {
            return cljs.core.every_QMARK_(function(and__6130__auto__) {
              return function(p1__17491_SHARP_) {
                var and__6130__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__17491_SHARP_) : p1.call(null, p1__17491_SHARP_);
                if (cljs.core.truth_(and__6130__auto____$1)) {
                  var and__6130__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__17491_SHARP_) : p2.call(null, p1__17491_SHARP_);
                  if (cljs.core.truth_(and__6130__auto____$2)) {
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__17491_SHARP_) : p3.call(null, p1__17491_SHARP_);
                  } else {
                    return and__6130__auto____$2;
                  }
                } else {
                  return and__6130__auto____$1;
                }
              };
            }(and__6130__auto__), args);
          } else {
            return and__6130__auto__;
          }
        }());
      };
      var G__17517 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17518__i = 0, G__17518__a = new Array(arguments.length - 3);
          while (G__17518__i < G__17518__a.length) {
            G__17518__a[G__17518__i] = arguments[G__17518__i + 3];
            ++G__17518__i;
          }
          args = new cljs.core.IndexedSeq(G__17518__a, 0);
        }
        return G__17517__delegate.call(this, x, y, z, args);
      };
      G__17517.cljs$lang$maxFixedArity = 3;
      G__17517.cljs$lang$applyTo = function(arglist__17519) {
        var x = cljs.core.first(arglist__17519);
        arglist__17519 = cljs.core.next(arglist__17519);
        var y = cljs.core.first(arglist__17519);
        arglist__17519 = cljs.core.next(arglist__17519);
        var z = cljs.core.first(arglist__17519);
        var args = cljs.core.rest(arglist__17519);
        return G__17517__delegate(x, y, z, args);
      };
      G__17517.cljs$core$IFn$_invoke$arity$variadic = G__17517__delegate;
      return G__17517;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__17520 = null;
          if (arguments.length > 3) {
            var G__17521__i = 0, G__17521__a = new Array(arguments.length - 3);
            while (G__17521__i < G__17521__a.length) {
              G__17521__a[G__17521__i] = arguments[G__17521__i + 3];
              ++G__17521__i;
            }
            G__17520 = new cljs.core.IndexedSeq(G__17521__a, 0);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17520);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__17492_SHARP_) {
            return p1__17492_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17492_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__17492_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__17493_SHARP_) {
            var and__6130__auto__ = p1__17493_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17493_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__17493_SHARP_.call(null, x);
            if (cljs.core.truth_(and__6130__auto__)) {
              return p1__17493_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17493_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__17493_SHARP_.call(null, y);
            } else {
              return and__6130__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__17494_SHARP_) {
            var and__6130__auto__ = p1__17494_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17494_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__17494_SHARP_.call(null, x);
            if (cljs.core.truth_(and__6130__auto__)) {
              var and__6130__auto____$1 = p1__17494_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17494_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__17494_SHARP_.call(null, y);
              if (cljs.core.truth_(and__6130__auto____$1)) {
                return p1__17494_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17494_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__17494_SHARP_.call(null, z);
              } else {
                return and__6130__auto____$1;
              }
            } else {
              return and__6130__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__17522__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__6130__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__6130__auto__)) {
              return cljs.core.every_QMARK_(function(and__6130__auto__, ps__$1) {
                return function(p1__17495_SHARP_) {
                  return cljs.core.every_QMARK_(p1__17495_SHARP_, args);
                };
              }(and__6130__auto__, ps__$1), ps__$1);
            } else {
              return and__6130__auto__;
            }
          }());
        };
        var G__17522 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__17523__i = 0, G__17523__a = new Array(arguments.length - 3);
            while (G__17523__i < G__17523__a.length) {
              G__17523__a[G__17523__i] = arguments[G__17523__i + 3];
              ++G__17523__i;
            }
            args = new cljs.core.IndexedSeq(G__17523__a, 0);
          }
          return G__17522__delegate.call(this, x, y, z, args);
        };
        G__17522.cljs$lang$maxFixedArity = 3;
        G__17522.cljs$lang$applyTo = function(arglist__17524) {
          var x = cljs.core.first(arglist__17524);
          arglist__17524 = cljs.core.next(arglist__17524);
          var y = cljs.core.first(arglist__17524);
          arglist__17524 = cljs.core.next(arglist__17524);
          var z = cljs.core.first(arglist__17524);
          var args = cljs.core.rest(arglist__17524);
          return G__17522__delegate(x, y, z, args);
        };
        G__17522.cljs$core$IFn$_invoke$arity$variadic = G__17522__delegate;
        return G__17522;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__17525 = null;
            if (arguments.length > 3) {
              var G__17526__i = 0, G__17526__a = new Array(arguments.length - 3);
              while (G__17526__i < G__17526__a.length) {
                G__17526__a[G__17526__i] = arguments[G__17526__i + 3];
                ++G__17526__i;
              }
              G__17525 = new cljs.core.IndexedSeq(G__17526__a, 0);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17525);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq17497) {
  var G__17498 = cljs.core.first(seq17497);
  var seq17497__$1 = cljs.core.next(seq17497);
  var G__17499 = cljs.core.first(seq17497__$1);
  var seq17497__$2 = cljs.core.next(seq17497__$1);
  var G__17500 = cljs.core.first(seq17497__$2);
  var seq17497__$3 = cljs.core.next(seq17497__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__17498, G__17499, G__17500, seq17497__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn(var_args) {
  var args17533 = [];
  var len__7200__auto___17540 = arguments.length;
  var i__7201__auto___17541 = 0;
  while (true) {
    if (i__7201__auto___17541 < len__7200__auto___17540) {
      args17533.push(arguments[i__7201__auto___17541]);
      var G__17542 = i__7201__auto___17541 + 1;
      i__7201__auto___17541 = G__17542;
      continue;
    } else {
    }
    break;
  }
  var G__17539 = args17533.length;
  switch(G__17539) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17533.slice(3), 0);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__7219__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__6142__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__6142__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        var or__6142__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        if (cljs.core.truth_(or__6142__auto____$1)) {
          return or__6142__auto____$1;
        } else {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__17544__delegate = function(x, y, z, args) {
        var or__6142__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__6142__auto__)) {
          return or__6142__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__17544 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17545__i = 0, G__17545__a = new Array(arguments.length - 3);
          while (G__17545__i < G__17545__a.length) {
            G__17545__a[G__17545__i] = arguments[G__17545__i + 3];
            ++G__17545__i;
          }
          args = new cljs.core.IndexedSeq(G__17545__a, 0);
        }
        return G__17544__delegate.call(this, x, y, z, args);
      };
      G__17544.cljs$lang$maxFixedArity = 3;
      G__17544.cljs$lang$applyTo = function(arglist__17546) {
        var x = cljs.core.first(arglist__17546);
        arglist__17546 = cljs.core.next(arglist__17546);
        var y = cljs.core.first(arglist__17546);
        arglist__17546 = cljs.core.next(arglist__17546);
        var z = cljs.core.first(arglist__17546);
        var args = cljs.core.rest(arglist__17546);
        return G__17544__delegate(x, y, z, args);
      };
      G__17544.cljs$core$IFn$_invoke$arity$variadic = G__17544__delegate;
      return G__17544;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__17547 = null;
          if (arguments.length > 3) {
            var G__17548__i = 0, G__17548__a = new Array(arguments.length - 3);
            while (G__17548__i < G__17548__a.length) {
              G__17548__a[G__17548__i] = arguments[G__17548__i + 3];
              ++G__17548__i;
            }
            G__17547 = new cljs.core.IndexedSeq(G__17548__a, 0);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17547);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__6142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__6142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        var or__6142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__6142__auto____$1)) {
          return or__6142__auto____$1;
        } else {
          var or__6142__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(or__6142__auto____$2)) {
            return or__6142__auto____$2;
          } else {
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__6142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        var or__6142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__6142__auto____$1)) {
          return or__6142__auto____$1;
        } else {
          var or__6142__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
          if (cljs.core.truth_(or__6142__auto____$2)) {
            return or__6142__auto____$2;
          } else {
            var or__6142__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(or__6142__auto____$3)) {
              return or__6142__auto____$3;
            } else {
              var or__6142__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__6142__auto____$4)) {
                return or__6142__auto____$4;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__17549__delegate = function(x, y, z, args) {
        var or__6142__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__6142__auto__)) {
          return or__6142__auto__;
        } else {
          return cljs.core.some(function(or__6142__auto__) {
            return function(p1__17527_SHARP_) {
              var or__6142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__17527_SHARP_) : p1.call(null, p1__17527_SHARP_);
              if (cljs.core.truth_(or__6142__auto____$1)) {
                return or__6142__auto____$1;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__17527_SHARP_) : p2.call(null, p1__17527_SHARP_);
              }
            };
          }(or__6142__auto__), args);
        }
      };
      var G__17549 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17550__i = 0, G__17550__a = new Array(arguments.length - 3);
          while (G__17550__i < G__17550__a.length) {
            G__17550__a[G__17550__i] = arguments[G__17550__i + 3];
            ++G__17550__i;
          }
          args = new cljs.core.IndexedSeq(G__17550__a, 0);
        }
        return G__17549__delegate.call(this, x, y, z, args);
      };
      G__17549.cljs$lang$maxFixedArity = 3;
      G__17549.cljs$lang$applyTo = function(arglist__17551) {
        var x = cljs.core.first(arglist__17551);
        arglist__17551 = cljs.core.next(arglist__17551);
        var y = cljs.core.first(arglist__17551);
        arglist__17551 = cljs.core.next(arglist__17551);
        var z = cljs.core.first(arglist__17551);
        var args = cljs.core.rest(arglist__17551);
        return G__17549__delegate(x, y, z, args);
      };
      G__17549.cljs$core$IFn$_invoke$arity$variadic = G__17549__delegate;
      return G__17549;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__17552 = null;
          if (arguments.length > 3) {
            var G__17553__i = 0, G__17553__a = new Array(arguments.length - 3);
            while (G__17553__i < G__17553__a.length) {
              G__17553__a[G__17553__i] = arguments[G__17553__i + 3];
              ++G__17553__i;
            }
            G__17552 = new cljs.core.IndexedSeq(G__17553__a, 0);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17552);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__6142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        var or__6142__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__6142__auto____$1)) {
          return or__6142__auto____$1;
        } else {
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__6142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        var or__6142__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__6142__auto____$1)) {
          return or__6142__auto____$1;
        } else {
          var or__6142__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__6142__auto____$2)) {
            return or__6142__auto____$2;
          } else {
            var or__6142__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__6142__auto____$3)) {
              return or__6142__auto____$3;
            } else {
              var or__6142__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__6142__auto____$4)) {
                return or__6142__auto____$4;
              } else {
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__6142__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        var or__6142__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__6142__auto____$1)) {
          return or__6142__auto____$1;
        } else {
          var or__6142__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__6142__auto____$2)) {
            return or__6142__auto____$2;
          } else {
            var or__6142__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__6142__auto____$3)) {
              return or__6142__auto____$3;
            } else {
              var or__6142__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__6142__auto____$4)) {
                return or__6142__auto____$4;
              } else {
                var or__6142__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                if (cljs.core.truth_(or__6142__auto____$5)) {
                  return or__6142__auto____$5;
                } else {
                  var or__6142__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                  if (cljs.core.truth_(or__6142__auto____$6)) {
                    return or__6142__auto____$6;
                  } else {
                    var or__6142__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                    if (cljs.core.truth_(or__6142__auto____$7)) {
                      return or__6142__auto____$7;
                    } else {
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__17554__delegate = function(x, y, z, args) {
        var or__6142__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__6142__auto__)) {
          return or__6142__auto__;
        } else {
          return cljs.core.some(function(or__6142__auto__) {
            return function(p1__17528_SHARP_) {
              var or__6142__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__17528_SHARP_) : p1.call(null, p1__17528_SHARP_);
              if (cljs.core.truth_(or__6142__auto____$1)) {
                return or__6142__auto____$1;
              } else {
                var or__6142__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__17528_SHARP_) : p2.call(null, p1__17528_SHARP_);
                if (cljs.core.truth_(or__6142__auto____$2)) {
                  return or__6142__auto____$2;
                } else {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__17528_SHARP_) : p3.call(null, p1__17528_SHARP_);
                }
              }
            };
          }(or__6142__auto__), args);
        }
      };
      var G__17554 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17555__i = 0, G__17555__a = new Array(arguments.length - 3);
          while (G__17555__i < G__17555__a.length) {
            G__17555__a[G__17555__i] = arguments[G__17555__i + 3];
            ++G__17555__i;
          }
          args = new cljs.core.IndexedSeq(G__17555__a, 0);
        }
        return G__17554__delegate.call(this, x, y, z, args);
      };
      G__17554.cljs$lang$maxFixedArity = 3;
      G__17554.cljs$lang$applyTo = function(arglist__17556) {
        var x = cljs.core.first(arglist__17556);
        arglist__17556 = cljs.core.next(arglist__17556);
        var y = cljs.core.first(arglist__17556);
        arglist__17556 = cljs.core.next(arglist__17556);
        var z = cljs.core.first(arglist__17556);
        var args = cljs.core.rest(arglist__17556);
        return G__17554__delegate(x, y, z, args);
      };
      G__17554.cljs$core$IFn$_invoke$arity$variadic = G__17554__delegate;
      return G__17554;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__17557 = null;
          if (arguments.length > 3) {
            var G__17558__i = 0, G__17558__a = new Array(arguments.length - 3);
            while (G__17558__i < G__17558__a.length) {
              G__17558__a[G__17558__i] = arguments[G__17558__i + 3];
              ++G__17558__i;
            }
            G__17557 = new cljs.core.IndexedSeq(G__17558__a, 0);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17557);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__17529_SHARP_) {
            return p1__17529_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17529_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__17529_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__17530_SHARP_) {
            var or__6142__auto__ = p1__17530_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17530_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__17530_SHARP_.call(null, x);
            if (cljs.core.truth_(or__6142__auto__)) {
              return or__6142__auto__;
            } else {
              return p1__17530_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17530_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__17530_SHARP_.call(null, y);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__17531_SHARP_) {
            var or__6142__auto__ = p1__17531_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17531_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__17531_SHARP_.call(null, x);
            if (cljs.core.truth_(or__6142__auto__)) {
              return or__6142__auto__;
            } else {
              var or__6142__auto____$1 = p1__17531_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17531_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__17531_SHARP_.call(null, y);
              if (cljs.core.truth_(or__6142__auto____$1)) {
                return or__6142__auto____$1;
              } else {
                return p1__17531_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17531_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__17531_SHARP_.call(null, z);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__17559__delegate = function(x, y, z, args) {
          var or__6142__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__6142__auto__)) {
            return or__6142__auto__;
          } else {
            return cljs.core.some(function(or__6142__auto__, ps__$1) {
              return function(p1__17532_SHARP_) {
                return cljs.core.some(p1__17532_SHARP_, args);
              };
            }(or__6142__auto__, ps__$1), ps__$1);
          }
        };
        var G__17559 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__17560__i = 0, G__17560__a = new Array(arguments.length - 3);
            while (G__17560__i < G__17560__a.length) {
              G__17560__a[G__17560__i] = arguments[G__17560__i + 3];
              ++G__17560__i;
            }
            args = new cljs.core.IndexedSeq(G__17560__a, 0);
          }
          return G__17559__delegate.call(this, x, y, z, args);
        };
        G__17559.cljs$lang$maxFixedArity = 3;
        G__17559.cljs$lang$applyTo = function(arglist__17561) {
          var x = cljs.core.first(arglist__17561);
          arglist__17561 = cljs.core.next(arglist__17561);
          var y = cljs.core.first(arglist__17561);
          arglist__17561 = cljs.core.next(arglist__17561);
          var z = cljs.core.first(arglist__17561);
          var args = cljs.core.rest(arglist__17561);
          return G__17559__delegate(x, y, z, args);
        };
        G__17559.cljs$core$IFn$_invoke$arity$variadic = G__17559__delegate;
        return G__17559;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__17562 = null;
            if (arguments.length > 3) {
              var G__17563__i = 0, G__17563__a = new Array(arguments.length - 3);
              while (G__17563__i < G__17563__a.length) {
                G__17563__a[G__17563__i] = arguments[G__17563__i + 3];
                ++G__17563__i;
              }
              G__17562 = new cljs.core.IndexedSeq(G__17563__a, 0);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17562);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq17534) {
  var G__17535 = cljs.core.first(seq17534);
  var seq17534__$1 = cljs.core.next(seq17534);
  var G__17536 = cljs.core.first(seq17534__$1);
  var seq17534__$2 = cljs.core.next(seq17534__$1);
  var G__17537 = cljs.core.first(seq17534__$2);
  var seq17534__$3 = cljs.core.next(seq17534__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__17535, G__17536, G__17537, seq17534__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map(var_args) {
  var args17565 = [];
  var len__7200__auto___17585 = arguments.length;
  var i__7201__auto___17586 = 0;
  while (true) {
    if (i__7201__auto___17586 < len__7200__auto___17585) {
      args17565.push(arguments[i__7201__auto___17586]);
      var G__17587 = i__7201__auto___17586 + 1;
      i__7201__auto___17586 = G__17587;
      continue;
    } else {
    }
    break;
  }
  var G__17572 = args17565.length;
  switch(G__17572) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17565.slice(4), 0);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7219__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__17589 = null;
      var G__17589__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__17589__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__17589__2 = function(result, input) {
        var G__17573 = result;
        var G__17574 = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17573, G__17574) : rf.call(null, G__17573, G__17574);
      };
      var G__17589__3 = function() {
        var G__17590__delegate = function(result, input, inputs) {
          var G__17575 = result;
          var G__17576 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17575, G__17576) : rf.call(null, G__17575, G__17576);
        };
        var G__17590 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__17591__i = 0, G__17591__a = new Array(arguments.length - 2);
            while (G__17591__i < G__17591__a.length) {
              G__17591__a[G__17591__i] = arguments[G__17591__i + 2];
              ++G__17591__i;
            }
            inputs = new cljs.core.IndexedSeq(G__17591__a, 0);
          }
          return G__17590__delegate.call(this, result, input, inputs);
        };
        G__17590.cljs$lang$maxFixedArity = 2;
        G__17590.cljs$lang$applyTo = function(arglist__17592) {
          var result = cljs.core.first(arglist__17592);
          arglist__17592 = cljs.core.next(arglist__17592);
          var input = cljs.core.first(arglist__17592);
          var inputs = cljs.core.rest(arglist__17592);
          return G__17590__delegate(result, input, inputs);
        };
        G__17590.cljs$core$IFn$_invoke$arity$variadic = G__17590__delegate;
        return G__17590;
      }();
      G__17589 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__17589__0.call(this);
          case 1:
            return G__17589__1.call(this, result);
          case 2:
            return G__17589__2.call(this, result, input);
          default:
            var G__17593 = null;
            if (arguments.length > 2) {
              var G__17594__i = 0, G__17594__a = new Array(arguments.length - 2);
              while (G__17594__i < G__17594__a.length) {
                G__17594__a[G__17594__i] = arguments[G__17594__i + 2];
                ++G__17594__i;
              }
              G__17593 = new cljs.core.IndexedSeq(G__17594__a, 0);
            }
            return G__17589__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__17593);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__17589.cljs$lang$maxFixedArity = 2;
      G__17589.cljs$lang$applyTo = G__17589__3.cljs$lang$applyTo;
      G__17589.cljs$core$IFn$_invoke$arity$0 = G__17589__0;
      G__17589.cljs$core$IFn$_invoke$arity$1 = G__17589__1;
      G__17589.cljs$core$IFn$_invoke$arity$2 = G__17589__2;
      G__17589.cljs$core$IFn$_invoke$arity$variadic = G__17589__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__17589;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__7045__auto___17595 = size;
        var i_17596 = 0;
        while (true) {
          if (i_17596 < n__7045__auto___17595) {
            cljs.core.chunk_append(b, function() {
              var G__17577 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17596);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17577) : f.call(null, G__17577);
            }());
            var G__17597 = i_17596 + 1;
            i_17596 = G__17597;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__17578 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17578) : f.call(null, G__17578);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__17579 = cljs.core.first(s1);
        var G__17580 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17579, G__17580) : f.call(null, G__17579, G__17580);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__17581 = cljs.core.first(s1);
        var G__17582 = cljs.core.first(s2);
        var G__17583 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17581, G__17582, G__17583) : f.call(null, G__17581, G__17582, G__17583);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__17564_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__17564_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq17566) {
  var G__17567 = cljs.core.first(seq17566);
  var seq17566__$1 = cljs.core.next(seq17566);
  var G__17568 = cljs.core.first(seq17566__$1);
  var seq17566__$2 = cljs.core.next(seq17566__$1);
  var G__17569 = cljs.core.first(seq17566__$2);
  var seq17566__$3 = cljs.core.next(seq17566__$2);
  var G__17570 = cljs.core.first(seq17566__$3);
  var seq17566__$4 = cljs.core.next(seq17566__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__17567, G__17568, G__17569, G__17570, seq17566__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take(var_args) {
  var args17598 = [];
  var len__7200__auto___17603 = arguments.length;
  var i__7201__auto___17604 = 0;
  while (true) {
    if (i__7201__auto___17604 < len__7200__auto___17603) {
      args17598.push(arguments[i__7201__auto___17604]);
      var G__17605 = i__7201__auto___17604 + 1;
      i__7201__auto___17604 = G__17605;
      continue;
    } else {
    }
    break;
  }
  var G__17600 = args17598.length;
  switch(G__17600) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17598.length)].join(""));;
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(function() {
      var G__17601 = cljs.core.list(new cljs.core.Symbol(null, "number?", "number?", -1747282210, null), new cljs.core.Symbol(null, "n", "n", -2092305744, null));
      return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17601) : cljs.core.pr_str.call(null, G__17601);
    }())].join(""));
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__17607 = null;
        var G__17607__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17607__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__17607__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input) : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__17607 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17607__0.call(this);
            case 1:
              return G__17607__1.call(this, result);
            case 2:
              return G__17607__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17607.cljs$core$IFn$_invoke$arity$0 = G__17607__0;
        G__17607.cljs$core$IFn$_invoke$arity$1 = G__17607__1;
        G__17607.cljs$core$IFn$_invoke$arity$2 = G__17607__2;
        return G__17607;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(function() {
      var G__17602 = cljs.core.list(new cljs.core.Symbol(null, "number?", "number?", -1747282210, null), new cljs.core.Symbol(null, "n", "n", -2092305744, null));
      return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17602) : cljs.core.pr_str.call(null, G__17602);
    }())].join(""));
  }
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__4425__auto__ = cljs.core.seq(coll);
      if (temp__4425__auto__) {
        var s = temp__4425__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop(var_args) {
  var args17608 = [];
  var len__7200__auto___17613 = arguments.length;
  var i__7201__auto___17614 = 0;
  while (true) {
    if (i__7201__auto___17614 < len__7200__auto___17613) {
      args17608.push(arguments[i__7201__auto___17614]);
      var G__17615 = i__7201__auto___17614 + 1;
      i__7201__auto___17614 = G__17615;
      continue;
    } else {
    }
    break;
  }
  var G__17610 = args17608.length;
  switch(G__17610) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17608.length)].join(""));;
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(function() {
      var G__17611 = cljs.core.list(new cljs.core.Symbol(null, "number?", "number?", -1747282210, null), new cljs.core.Symbol(null, "n", "n", -2092305744, null));
      return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17611) : cljs.core.pr_str.call(null, G__17611);
    }())].join(""));
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__17617 = null;
        var G__17617__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17617__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__17617__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__17617 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17617__0.call(this);
            case 1:
              return G__17617__1.call(this, result);
            case 2:
              return G__17617__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17617.cljs$core$IFn$_invoke$arity$0 = G__17617__0;
        G__17617.cljs$core$IFn$_invoke$arity$1 = G__17617__1;
        G__17617.cljs$core$IFn$_invoke$arity$2 = G__17617__2;
        return G__17617;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(function() {
      var G__17612 = cljs.core.list(new cljs.core.Symbol(null, "number?", "number?", -1747282210, null), new cljs.core.Symbol(null, "n", "n", -2092305744, null));
      return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17612) : cljs.core.pr_str.call(null, G__17612);
    }())].join(""));
  }
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__17618 = n__$1 - 1;
        var G__17619 = cljs.core.rest(s);
        n__$1 = G__17618;
        coll__$1 = G__17619;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last(var_args) {
  var args17620 = [];
  var len__7200__auto___17623 = arguments.length;
  var i__7201__auto___17624 = 0;
  while (true) {
    if (i__7201__auto___17624 < len__7200__auto___17623) {
      args17620.push(arguments[i__7201__auto___17624]);
      var G__17625 = i__7201__auto___17624 + 1;
      i__7201__auto___17624 = G__17625;
      continue;
    } else {
    }
    break;
  }
  var G__17622 = args17620.length;
  switch(G__17622) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17620.length)].join(""));;
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__17627 = cljs.core.next(s);
      var G__17628 = cljs.core.next(lead);
      s = G__17627;
      lead = G__17628;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while(var_args) {
  var args17629 = [];
  var len__7200__auto___17634 = arguments.length;
  var i__7201__auto___17635 = 0;
  while (true) {
    if (i__7201__auto___17635 < len__7200__auto___17634) {
      args17629.push(arguments[i__7201__auto___17635]);
      var G__17636 = i__7201__auto___17635 + 1;
      i__7201__auto___17635 = G__17636;
      continue;
    } else {
    }
    break;
  }
  var G__17631 = args17629.length;
  switch(G__17631) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17629.length)].join(""));;
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__17638 = null;
        var G__17638__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17638__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__17638__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__6130__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__6130__auto__)) {
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input);
            } else {
              return and__6130__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__17638 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17638__0.call(this);
            case 1:
              return G__17638__1.call(this, result);
            case 2:
              return G__17638__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17638.cljs$core$IFn$_invoke$arity$0 = G__17638__0;
        G__17638.cljs$core$IFn$_invoke$arity$1 = G__17638__1;
        G__17638.cljs$core$IFn$_invoke$arity$2 = G__17638__2;
        return G__17638;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__6130__auto__ = s;
        if (and__6130__auto__) {
          var G__17633 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__17633) : pred__$1.call(null, G__17633);
        } else {
          return and__6130__auto__;
        }
      }())) {
        var G__17639 = pred__$1;
        var G__17640 = cljs.core.rest(s);
        pred__$1 = G__17639;
        coll__$1 = G__17640;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs$core$cycle(s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat(var_args) {
  var args17641 = [];
  var len__7200__auto___17644 = arguments.length;
  var i__7201__auto___17645 = 0;
  while (true) {
    if (i__7201__auto___17645 < len__7200__auto___17644) {
      args17641.push(arguments[i__7201__auto___17645]);
      var G__17646 = i__7201__auto___17645 + 1;
      i__7201__auto___17645 = G__17646;
      continue;
    } else {
    }
    break;
  }
  var G__17643 = args17641.length;
  switch(G__17643) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17641.length)].join(""));;
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly(var_args) {
  var args17648 = [];
  var len__7200__auto___17651 = arguments.length;
  var i__7201__auto___17652 = 0;
  while (true) {
    if (i__7201__auto___17652 < len__7200__auto___17651) {
      args17648.push(arguments[i__7201__auto___17652]);
      var G__17653 = i__7201__auto___17652 + 1;
      i__7201__auto___17652 = G__17653;
      continue;
    } else {
    }
    break;
  }
  var G__17650 = args17648.length;
  switch(G__17650) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17648.length)].join(""));;
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    return cljs$core$iterate(f, f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x));
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave(var_args) {
  var args17657 = [];
  var len__7200__auto___17663 = arguments.length;
  var i__7201__auto___17664 = 0;
  while (true) {
    if (i__7201__auto___17664 < len__7200__auto___17663) {
      args17657.push(arguments[i__7201__auto___17664]);
      var G__17665 = i__7201__auto___17664 + 1;
      i__7201__auto___17664 = G__17665;
      continue;
    } else {
    }
    break;
  }
  var G__17662 = args17657.length;
  switch(G__17662) {
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17657.slice(2), 0);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__7219__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq17658) {
  var G__17659 = cljs.core.first(seq17658);
  var seq17658__$1 = cljs.core.next(seq17658);
  var G__17660 = cljs.core.first(seq17658__$1);
  var seq17658__$2 = cljs.core.next(seq17658__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__17659, G__17660, seq17658__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose(var_args) {
  var args17667 = [];
  var len__7200__auto___17670 = arguments.length;
  var i__7201__auto___17671 = 0;
  while (true) {
    if (i__7201__auto___17671 < len__7200__auto___17670) {
      args17667.push(arguments[i__7201__auto___17671]);
      var G__17672 = i__7201__auto___17671 + 1;
      i__7201__auto___17671 = G__17672;
      continue;
    } else {
    }
    break;
  }
  var G__17669 = args17667.length;
  switch(G__17669) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17667.length)].join(""));;
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__17674 = null;
        var G__17674__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17674__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__17674__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, sep) : rf.call(null, result, sep);
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr, input) : rf.call(null, sepr, input);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__17674 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17674__0.call(this);
            case 1:
              return G__17674__1.call(this, result);
            case 2:
              return G__17674__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17674.cljs$core$IFn$_invoke$arity$0 = G__17674__0;
        G__17674.cljs$core$IFn$_invoke$arity$1 = G__17674__1;
        G__17674.cljs$core$IFn$_invoke$arity$2 = G__17674__2;
        return G__17674;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4423__auto__ = cljs.core.seq(coll);
      if (temp__4423__auto__) {
        var coll__$1 = temp__4423__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat(var_args) {
  var args17683 = [];
  var len__7200__auto___17688 = arguments.length;
  var i__7201__auto___17689 = 0;
  while (true) {
    if (i__7201__auto___17689 < len__7200__auto___17688) {
      args17683.push(arguments[i__7201__auto___17689]);
      var G__17690 = i__7201__auto___17689 + 1;
      i__7201__auto___17689 = G__17690;
      continue;
    } else {
    }
    break;
  }
  var G__17687 = args17683.length;
  switch(G__17687) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17683.slice(1), 0);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__7219__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq17684) {
  var G__17685 = cljs.core.first(seq17684);
  var seq17684__$1 = cljs.core.next(seq17684);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__17685, seq17684__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter(var_args) {
  var args17692 = [];
  var len__7200__auto___17696 = arguments.length;
  var i__7201__auto___17697 = 0;
  while (true) {
    if (i__7201__auto___17697 < len__7200__auto___17696) {
      args17692.push(arguments[i__7201__auto___17697]);
      var G__17698 = i__7201__auto___17697 + 1;
      i__7201__auto___17697 = G__17698;
      continue;
    } else {
    }
    break;
  }
  var G__17694 = args17692.length;
  switch(G__17694) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17692.length)].join(""));;
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__17700 = null;
      var G__17700__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__17700__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__17700__2 = function(result, input) {
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input))) {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
        } else {
          return result;
        }
      };
      G__17700 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__17700__0.call(this);
          case 1:
            return G__17700__1.call(this, result);
          case 2:
            return G__17700__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__17700.cljs$core$IFn$_invoke$arity$0 = G__17700__0;
      G__17700.cljs$core$IFn$_invoke$arity$1 = G__17700__1;
      G__17700.cljs$core$IFn$_invoke$arity$2 = G__17700__2;
      return G__17700;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__7045__auto___17701 = size;
        var i_17702 = 0;
        while (true) {
          if (i_17702 < n__7045__auto___17701) {
            if (cljs.core.truth_(function() {
              var G__17695 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17702);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17695) : pred.call(null, G__17695);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17702));
            } else {
            }
            var G__17703 = i_17702 + 1;
            i_17702 = G__17703;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null, f))) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove(var_args) {
  var args17704 = [];
  var len__7200__auto___17707 = arguments.length;
  var i__7201__auto___17708 = 0;
  while (true) {
    if (i__7201__auto___17708 < len__7200__auto___17707) {
      args17704.push(arguments[i__7201__auto___17708]);
      var G__17709 = i__7201__auto___17708 + 1;
      i__7201__auto___17708 = G__17709;
      continue;
    } else {
    }
    break;
  }
  var G__17706 = args17704.length;
  switch(G__17706) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17704.length)].join(""));;
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null, node)) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null, node)], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__17711_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__17711_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into(var_args) {
  var args17712 = [];
  var len__7200__auto___17717 = arguments.length;
  var i__7201__auto___17718 = 0;
  while (true) {
    if (i__7201__auto___17718 < len__7200__auto___17717) {
      args17712.push(arguments[i__7201__auto___17718]);
      var G__17719 = i__7201__auto___17718 + 1;
      i__7201__auto___17718 = G__17719;
      continue;
    } else {
    }
    break;
  }
  var G__17714 = args17712.length;
  switch(G__17714) {
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17712.length)].join(""));;
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || to.cljs$core$IEditableCollection$ ? true : false : false) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || to.cljs$core$IEditableCollection$ ? true : false : false) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv(var_args) {
  var args17721 = [];
  var len__7200__auto___17729 = arguments.length;
  var i__7201__auto___17730 = 0;
  while (true) {
    if (i__7201__auto___17730 < len__7200__auto___17729) {
      args17721.push(arguments[i__7201__auto___17730]);
      var G__17731 = i__7201__auto___17730 + 1;
      i__7201__auto___17730 = G__17731;
      continue;
    } else {
    }
    break;
  }
  var G__17728 = args17721.length;
  switch(G__17728) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17721.slice(4), 0);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__7219__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null, o));
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq17722) {
  var G__17723 = cljs.core.first(seq17722);
  var seq17722__$1 = cljs.core.next(seq17722);
  var G__17724 = cljs.core.first(seq17722__$1);
  var seq17722__$2 = cljs.core.next(seq17722__$1);
  var G__17725 = cljs.core.first(seq17722__$2);
  var seq17722__$3 = cljs.core.next(seq17722__$2);
  var G__17726 = cljs.core.first(seq17722__$3);
  var seq17722__$4 = cljs.core.next(seq17722__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__17723, G__17724, G__17725, G__17726, seq17722__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null, o))) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition(var_args) {
  var args17733 = [];
  var len__7200__auto___17736 = arguments.length;
  var i__7201__auto___17737 = 0;
  while (true) {
    if (i__7201__auto___17737 < len__7200__auto___17736) {
      args17733.push(arguments[i__7201__auto___17737]);
      var G__17738 = i__7201__auto___17737 + 1;
      i__7201__auto___17737 = G__17738;
      continue;
    } else {
    }
    break;
  }
  var G__17735 = args17733.length;
  switch(G__17735) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17733.length)].join(""));;
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4425__auto__ = cljs.core.seq(coll);
    if (temp__4425__auto__) {
      var s = temp__4425__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return cljs.core._conj(cljs.core.List.EMPTY, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in(var_args) {
  var args17740 = [];
  var len__7200__auto___17744 = arguments.length;
  var i__7201__auto___17745 = 0;
  while (true) {
    if (i__7201__auto___17745 < len__7200__auto___17744) {
      args17740.push(arguments[i__7201__auto___17745]);
      var G__17746 = i__7201__auto___17745 + 1;
      i__7201__auto___17745 = G__17746;
      continue;
    } else {
    }
    break;
  }
  var G__17742 = args17740.length;
  switch(G__17742) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17740.length)].join(""));;
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m, ks, null);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (ks__$1) {
      if (!(!(m__$1 == null) ? m__$1.cljs$lang$protocol_mask$partition0$ & 256 || m__$1.cljs$core$ILookup$ ? true : !m__$1.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, m__$1) : false : cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, m__$1))) {
        return not_found;
      } else {
        var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
        if (sentinel === m__$2) {
          return not_found;
        } else {
          var G__17748 = sentinel;
          var G__17749 = m__$2;
          var G__17750 = cljs.core.next(ks__$1);
          sentinel = G__17748;
          m__$1 = G__17749;
          ks__$1 = G__17750;
          continue;
        }
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__17751, v) {
  var vec__17756 = p__17751;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17756, 0, null);
  var ks = cljs.core.nthnext(vec__17756, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, v));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in(var_args) {
  var args17757 = [];
  var len__7200__auto___17787 = arguments.length;
  var i__7201__auto___17788 = 0;
  while (true) {
    if (i__7201__auto___17788 < len__7200__auto___17787) {
      args17757.push(arguments[i__7201__auto___17788]);
      var G__17789 = i__7201__auto___17788 + 1;
      i__7201__auto___17788 = G__17789;
      continue;
    } else {
    }
    break;
  }
  var G__17766 = args17757.length;
  switch(G__17766) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17757.slice(6), 0);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__7219__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__17767, f) {
  var vec__17768 = p__17767;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17768, 0, null);
  var ks = cljs.core.nthnext(vec__17768, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__17769 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17769) : f.call(null, G__17769);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__17770, f, a) {
  var vec__17771 = p__17770;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17771, 0, null);
  var ks = cljs.core.nthnext(vec__17771, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__17772 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__17773 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17772, G__17773) : f.call(null, G__17772, G__17773);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__17774, f, a, b) {
  var vec__17775 = p__17774;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17775, 0, null);
  var ks = cljs.core.nthnext(vec__17775, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__17776 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__17777 = a;
      var G__17778 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17776, G__17777, G__17778) : f.call(null, G__17776, G__17777, G__17778);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__17779, f, a, b, c) {
  var vec__17780 = p__17779;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17780, 0, null);
  var ks = cljs.core.nthnext(vec__17780, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__17781 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__17782 = a;
      var G__17783 = b;
      var G__17784 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17781, G__17782, G__17783, G__17784) : f.call(null, G__17781, G__17782, G__17783, G__17784);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__17785, f, a, b, c, args) {
  var vec__17786 = p__17785;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17786, 0, null);
  var ks = cljs.core.nthnext(vec__17786, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq17758) {
  var G__17759 = cljs.core.first(seq17758);
  var seq17758__$1 = cljs.core.next(seq17758);
  var G__17760 = cljs.core.first(seq17758__$1);
  var seq17758__$2 = cljs.core.next(seq17758__$1);
  var G__17761 = cljs.core.first(seq17758__$2);
  var seq17758__$3 = cljs.core.next(seq17758__$2);
  var G__17762 = cljs.core.first(seq17758__$3);
  var seq17758__$4 = cljs.core.next(seq17758__$3);
  var G__17763 = cljs.core.first(seq17758__$4);
  var seq17758__$5 = cljs.core.next(seq17758__$4);
  var G__17764 = cljs.core.first(seq17758__$5);
  var seq17758__$6 = cljs.core.next(seq17758__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__17759, G__17760, G__17761, G__17762, G__17763, G__17764, seq17758__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update(var_args) {
  var args17791 = [];
  var len__7200__auto___17811 = arguments.length;
  var i__7201__auto___17812 = 0;
  while (true) {
    if (i__7201__auto___17812 < len__7200__auto___17811) {
      args17791.push(arguments[i__7201__auto___17812]);
      var G__17813 = i__7201__auto___17812 + 1;
      i__7201__auto___17812 = G__17813;
      continue;
    } else {
    }
    break;
  }
  var G__17800 = args17791.length;
  switch(G__17800) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__7219__auto__ = new cljs.core.IndexedSeq(args17791.slice(6), 0);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__7219__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__17801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17801) : f.call(null, G__17801);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__17802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__17803 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17802, G__17803) : f.call(null, G__17802, G__17803);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__17804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__17805 = x;
    var G__17806 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17804, G__17805, G__17806) : f.call(null, G__17804, G__17805, G__17806);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__17807 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__17808 = x;
    var G__17809 = y;
    var G__17810 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17807, G__17808, G__17809, G__17810) : f.call(null, G__17807, G__17808, G__17809, G__17810);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq17792) {
  var G__17793 = cljs.core.first(seq17792);
  var seq17792__$1 = cljs.core.next(seq17792);
  var G__17794 = cljs.core.first(seq17792__$1);
  var seq17792__$2 = cljs.core.next(seq17792__$1);
  var G__17795 = cljs.core.first(seq17792__$2);
  var seq17792__$3 = cljs.core.next(seq17792__$2);
  var G__17796 = cljs.core.first(seq17792__$3);
  var seq17792__$4 = cljs.core.next(seq17792__$3);
  var G__17797 = cljs.core.first(seq17792__$4);
  var seq17792__$5 = cljs.core.next(seq17792__$4);
  var G__17798 = cljs.core.first(seq17792__$5);
  var seq17792__$6 = cljs.core.next(seq17792__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__17793, G__17794, G__17795, G__17796, G__17797, G__17798, seq17792__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__17815 = ll - 5;
      var G__17816 = r;
      ll = G__17815;
      ret = G__17816;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = cljs$core$push_tail(pv, level - 5, child, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__17821 = cljs.core.pv_aget(node, 0);
      var G__17822 = level - 5;
      node = G__17821;
      level = G__17822;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__17823 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__17824 = level - 5;
        node = G__17823;
        level = G__17824;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, cljs$core$do_assoc(pv, level - 5, cljs.core.pv_aget(node, subidx), i, val));
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$pop_tail(pv, level - 5, cljs.core.pv_aget(node, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__17834 = init__$2;
              var G__17835 = j + i;
              var G__17836 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17834, G__17835, G__17836) : f.call(null, G__17834, G__17835, G__17836);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__17843 = j + 1;
              var G__17844 = init__$3;
              j = G__17843;
              init__$2 = G__17844;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__17845 = i + len;
        var G__17846 = init__$2;
        i = G__17845;
        init__$1 = G__17846;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return cljs.core._conj(coll__$1, val);
    } else {
      throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds  [0,"), cljs.core.str(self__.cnt), cljs.core.str("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = cljs.core._iterator(coll__$1);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (cljs.core.truth_(me_iter.hasNext())) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null, self__.root), cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null, self__.tail));
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__17837 = init__$2;
              var G__17838 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17837, G__17838) : f.call(null, G__17837, G__17838);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__17847 = j + 1;
              var G__17848 = init__$3;
              j = G__17847;
              init__$2 = G__17848;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__17849 = i + len;
        var G__17850 = init__$2;
        i = G__17849;
        init__$1 = G__17850;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._assoc_n(coll__$1, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0);
    } else {
      var G__17839 = coll__$1;
      var G__17840 = cljs.core.first_array_for_longvec(coll__$1);
      var G__17841 = 0;
      var G__17842 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__17839, G__17840, G__17841, G__17842) : cljs.core.chunked_seq.call(null, G__17839, G__17840, G__17841, G__17842);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__7045__auto___17851 = len;
    var i_17852 = 0;
    while (true) {
      if (i_17852 < n__7045__auto___17851) {
        new_tail[i_17852] = self__.tail[i_17852];
        var G__17853 = i_17852 + 1;
        i_17852 = G__17853;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__17854 = null;
  var G__17854__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__17854__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__17854 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17854__2.call(this, self__, k);
      case 3:
        return G__17854__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17854.cljs$core$IFn$_invoke$arity$2 = G__17854__2;
  G__17854.cljs$core$IFn$_invoke$arity$3 = G__17854__3;
  return G__17854;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args17833) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17833)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__17855 = i + 1;
        var G__17856 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__17855;
        out = G__17856;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector(var_args) {
  var args__7207__auto__ = [];
  var len__7200__auto___17858 = arguments.length;
  var i__7201__auto___17859 = 0;
  while (true) {
    if (i__7201__auto___17859 < len__7200__auto___17858) {
      args__7207__auto__.push(arguments[i__7201__auto___17859]);
      var G__17860 = i__7201__auto___17859 + 1;
      i__7201__auto___17859 = G__17860;
      continue;
    } else {
    }
    break;
  }
  var argseq__7208__auto__ = 0 < args__7207__auto__.length ? new cljs.core.IndexedSeq(args__7207__auto__.slice(0), 0) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__7208__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq17857) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17857));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__17861 = self__.vec;
      var G__17862 = self__.node;
      var G__17863 = self__.i;
      var G__17864 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__17861, G__17862, G__17863, G__17864) : cljs.core.chunked_seq.call(null, G__17861, G__17862, G__17863, G__17864);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_next(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__17865 = self__.vec;
    var G__17866 = self__.i + self__.off;
    var G__17867 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__17865, G__17866, G__17867) : cljs.core.subvec.call(null, G__17865, G__17866, G__17867);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__17868 = self__.vec;
    var G__17869 = self__.i + self__.off;
    var G__17870 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__17868, G__17869, G__17870) : cljs.core.subvec.call(null, G__17868, G__17869, G__17870);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__17871 = self__.vec;
      var G__17872 = self__.node;
      var G__17873 = self__.i;
      var G__17874 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__17871, G__17872, G__17873, G__17874) : cljs.core.chunked_seq.call(null, G__17871, G__17872, G__17873, G__17874);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_rest(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__17875 = self__.vec;
    var G__17876 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__17877 = end;
    var G__17878 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__17875, G__17876, G__17877, G__17878) : cljs.core.chunked_seq.call(null, G__17875, G__17876, G__17877, G__17878);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec, self__.node, self__.i, self__.off, m) : cljs.core.chunked_seq.call(null, self__.vec, self__.node, self__.i, self__.off, m);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__17879 = self__.vec;
    var G__17880 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__17881 = end;
    var G__17882 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__17879, G__17880, G__17881, G__17882) : cljs.core.chunked_seq.call(null, G__17879, G__17880, G__17881, G__17882);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq(var_args) {
  var args17883 = [];
  var len__7200__auto___17886 = arguments.length;
  var i__7201__auto___17887 = 0;
  while (true) {
    if (i__7201__auto___17887 < len__7200__auto___17886) {
      args17883.push(arguments[i__7201__auto___17887]);
      var G__17888 = i__7201__auto___17887 + 1;
      i__7201__auto___17887 = G__17888;
      continue;
    } else {
    }
    break;
  }
  var G__17885 = args17883.length;
  switch(G__17885) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17883.length)].join(""));;
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__17891 = init__$1;
        var G__17892 = j;
        var G__17893 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17891, G__17892, G__17893) : f.call(null, G__17891, G__17892, G__17893);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__17910 = i + 1;
        var G__17911 = j + 1;
        var G__17912 = init__$2;
        i = G__17910;
        j = G__17911;
        init__$1 = G__17912;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  var G__17894 = self__.meta;
  var G__17895 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
  var G__17896 = self__.start;
  var G__17897 = function() {
    var x__6473__auto__ = self__.end;
    var y__6474__auto__ = v_pos + 1;
    return x__6473__auto__ > y__6474__auto__ ? x__6473__auto__ : y__6474__auto__;
  }();
  var G__17898 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__17894, G__17895, G__17896, G__17897, G__17898) : cljs.core.build_subvec.call(null, G__17894, G__17895, G__17896, G__17897, G__17898);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__17899 = self__.meta;
    var G__17900 = self__.v;
    var G__17901 = self__.start;
    var G__17902 = self__.end - 1;
    var G__17903 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__17899, G__17900, G__17901, G__17902, G__17903) : cljs.core.build_subvec.call(null, G__17899, G__17900, G__17901, G__17902, G__17903);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n(coll__$1, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1, self__.v, self__.start, self__.end, self__.__hash) : cljs.core.build_subvec.call(null, meta__$1, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__17905 = self__.meta;
  var G__17906 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__17907 = self__.start;
  var G__17908 = self__.end + 1;
  var G__17909 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__17905, G__17906, G__17907, G__17908, G__17909) : cljs.core.build_subvec.call(null, G__17905, G__17906, G__17907, G__17908, G__17909);
};
cljs.core.Subvec.prototype.call = function() {
  var G__17913 = null;
  var G__17913__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__17913__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__17913 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17913__2.call(this, self__, k);
      case 3:
        return G__17913__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17913.cljs$core$IFn$_invoke$arity$2 = G__17913__2;
  G__17913.cljs$core$IFn$_invoke$arity$3 = G__17913__3;
  return G__17913;
}();
cljs.core.Subvec.prototype.apply = function(self__, args17890) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17890)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__17914 = meta;
      var G__17915 = v.v;
      var G__17916 = v.start + start;
      var G__17917 = v.start + end;
      var G__17918 = __hash;
      meta = G__17914;
      v = G__17915;
      start = G__17916;
      end = G__17917;
      __hash = G__17918;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec(var_args) {
  var args17919 = [];
  var len__7200__auto___17922 = arguments.length;
  var i__7201__auto___17923 = 0;
  while (true) {
    if (i__7201__auto___17923 < len__7200__auto___17922) {
      args17919.push(arguments[i__7201__auto___17923]);
      var G__17924 = i__7201__auto___17923 + 1;
      i__7201__auto___17923 = G__17924;
      continue;
    } else {
    }
    break;
  }
  var G__17921 = args17919.length;
  switch(G__17921) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args17919.length)].join(""));;
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      return cljs$core$tv_push_tail(tv, level - 5, child, tail_node);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$tv_pop_tail(tv, level - 5, cljs.core.pv_aget(node__$1, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__17937 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__17938 = level - 5;
        node = G__17937;
        level = G__17938;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n_BANG_(tcoll__$1, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return cljs.core._conj_BANG_(tcoll__$1, val);
      } else {
        throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__17942 = null;
  var G__17942__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17942__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17942 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17942__2.call(this, self__, k);
      case 3:
        return G__17942__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17942.cljs$core$IFn$_invoke$arity$2 = G__17942__2;
  G__17942.cljs$core$IFn$_invoke$arity$3 = G__17942__3;
  return G__17942;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args17939) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17939)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueIter = function(fseq, riter) {
  this.fseq = fseq;
  this.riter = riter;
};
cljs.core.PersistentQueueIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__6142__auto__ = cljs.core.some_QMARK_(self__.fseq) && cljs.core.seq(self__.fseq);
  if (or__6142__auto__) {
    return or__6142__auto__;
  } else {
    var and__6130__auto__ = cljs.core.some_QMARK_(self__.riter);
    if (and__6130__auto__) {
      return self__.riter.hasNext();
    } else {
      return and__6130__auto__;
    }
  }
};
cljs.core.PersistentQueueIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (cljs.core.some_QMARK_(self__.fseq)) {
    var ret = cljs.core.first(self__.fseq);
    self__.fseq = cljs.core.next(self__.fseq);
    return ret;
  } else {
    if (cljs.core.some_QMARK_(self__.riter) && self__.riter.hasNext()) {
      return self__.riter.next();
    } else {
      throw new Error("No such element");
    }
  }
};
cljs.core.PersistentQueueIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.PersistentQueueIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "fseq", "fseq", -1466412450, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "riter", "riter", -237834262, null)], null);
};
cljs.core.PersistentQueueIter.cljs$lang$type = true;
cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";
cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentQueueIter");
};
cljs.core.__GT_PersistentQueueIter = function cljs$core$__GT_PersistentQueueIter(fseq, riter) {
  return new cljs.core.PersistentQueueIter(fseq, riter);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__4423__auto__ = cljs.core.next(self__.front);
  if (temp__4423__auto__) {
    var f1 = temp__4423__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return cljs.core._empty(coll__$1);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueIter(self__.front, cljs.core._iterator(self__.rear));
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__4423__auto__ = cljs.core.next(self__.front);
    if (temp__4423__auto__) {
      var f1 = temp__4423__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__6142__auto__ = self__.front;
    if (cljs.core.truth_(or__6142__auto__)) {
      return or__6142__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__6142__auto__ = self__.rear;
      if (cljs.core.truth_(or__6142__auto__)) {
        return or__6142__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(cljs.core.identity, cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x)) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__17943 = i + incr;
        i = G__17943;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__17944 = i + 1;
      var G__17945 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__17944;
      out = G__17945;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = {};
  var l = ks.length;
  var i_17950 = 0;
  while (true) {
    if (i_17950 < l) {
      var k_17951 = ks[i_17950];
      new_obj[k_17951] = obj[k_17951];
      var G__17952 = i_17950 + 1;
      i_17950 = G__17952;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__17955 = init__$1;
        var G__17956 = k;
        var G__17957 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17955, G__17956, G__17957) : f.call(null, G__17955, G__17956, G__17957);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__17958 = cljs.core.rest(keys__$1);
        var G__17959 = init__$2;
        keys__$1 = G__17958;
        init__$1 = G__17959;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k)) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__17953_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17953_SHARP_, self__.strobj[p1__17953_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__17960 = null;
  var G__17960__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__17960__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__17960 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__17960__2.call(this, self__, k);
      case 3:
        return G__17960__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__17960.cljs$core$IFn$_invoke$arity$2 = G__17960__2;
  G__17960.cljs$core$IFn$_invoke$arity$3 = G__17960__3;
  return G__17960;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args17954) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17954)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.RecordIter = function(i, record, base_count, fields, ext_map_iter) {
  this.i = i;
  this.record = record;
  this.base_count = base_count;
  this.fields = fields;
  this.ext_map_iter = ext_map_iter;
};
cljs.core.RecordIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__6142__auto__ = self__.i < self__.base_count;
  if (or__6142__auto__) {
    return or__6142__auto__;
  } else {
    return self__.ext_map_iter.hasNext();
  }
};
cljs.core.RecordIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (self__.i < self__.base_count) {
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields, self__.i);
    self__.i = self__.i + 1;
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record, k)], null);
  } else {
    return self__.ext_map_iter.next();
  }
};
cljs.core.RecordIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.RecordIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "record", "record", 861424668, null), new cljs.core.Symbol(null, "base-count", "base-count", -1180647182, null), new cljs.core.Symbol(null, "fields", "fields", -291534703, null), new cljs.core.Symbol(null, 
  "ext-map-iter", "ext-map-iter", -1215982757, null)], null);
};
cljs.core.RecordIter.cljs$lang$type = true;
cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";
cljs.core.RecordIter.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/RecordIter");
};
cljs.core.__GT_RecordIter = function cljs$core$__GT_RecordIter(i, record, base_count, fields, ext_map_iter) {
  return new cljs.core.RecordIter(i, record, base_count, fields, ext_map_iter);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__17963 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17963, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17963, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__17964 = i + 2;
        i = G__17964;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Keyword && kstr === arr[i].fqn) {
        return i;
      } else {
        var G__17965 = i + 2;
        i = G__17965;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Symbol && kstr === arr[i].str) {
        return i;
      } else {
        var G__17966 = i + 2;
        i = G__17966;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__17967 = i + 2;
        i = G__17967;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__17968 = i + 2;
        i = G__17968;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (goog.isString(k) || typeof k === "number") {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_17969 = 0;
  while (true) {
    if (i_17969 < l) {
      narr[i_17969] = arr[i_17969];
      var G__17970 = i_17969 + 1;
      i_17969 = G__17970;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__17972 = cljs.core.seq(coll);
  var chunk__17973 = null;
  var count__17974 = 0;
  var i__17975 = 0;
  while (true) {
    if (i__17975 < count__17974) {
      var vec__17976 = chunk__17973.cljs$core$IIndexed$_nth$arity$2(null, i__17975);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17976, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17976, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__17985 = seq__17972;
      var G__17986 = chunk__17973;
      var G__17987 = count__17974;
      var G__17988 = i__17975 + 1;
      seq__17972 = G__17985;
      chunk__17973 = G__17986;
      count__17974 = G__17987;
      i__17975 = G__17988;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__17972);
      if (temp__4425__auto__) {
        var seq__17972__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__17972__$1)) {
          var c__6945__auto__ = cljs.core.chunk_first(seq__17972__$1);
          var G__17989 = cljs.core.chunk_rest(seq__17972__$1);
          var G__17990 = c__6945__auto__;
          var G__17991 = cljs.core.count(c__6945__auto__);
          var G__17992 = 0;
          seq__17972 = G__17989;
          chunk__17973 = G__17990;
          count__17974 = G__17991;
          i__17975 = G__17992;
          continue;
        } else {
          var vec__17977 = cljs.core.first(seq__17972__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17977, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17977, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__17993 = cljs.core.next(seq__17972__$1);
          var G__17994 = null;
          var G__17995 = 0;
          var G__17996 = 0;
          seq__17972 = G__17993;
          chunk__17973 = G__17994;
          count__17974 = G__17995;
          i__17975 = G__17996;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__17978 = init__$1;
        var G__17979 = self__.arr[i];
        var G__17980 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17978, G__17979, G__17980) : f.call(null, G__17978, G__17979, G__17980);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__17997 = i + 2;
        var G__17998 = init__$2;
        i = G__17997;
        init__$1 = G__17998;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (!(other == null) ? other.cljs$lang$protocol_mask$partition0$ & 1024 || other.cljs$core$IMap$ ? true : false : false) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__17999 = i + 2;
              i = G__17999;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap({}, self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return cljs.core._empty(coll__$1);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__18000 = s + 2;
            var G__18001 = d;
            s = G__18000;
            d = G__18001;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__18002 = s + 2;
            var G__18003 = d + 2;
            s = G__18002;
            d = G__18003;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__17984 = cljs.core.aclone(self__.arr);
        G__17984[idx + 1] = v;
        return G__17984;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__18004 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__18005 = cljs.core.next(es);
          ret = G__18004;
          es = G__18005;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__18006 = null;
  var G__18006__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18006__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18006 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18006__2.call(this, self__, k);
      case 3:
        return G__18006__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18006.cljs$core$IFn$_invoke$arity$2 = G__18006__2;
  G__18006.cljs$core$IFn$_invoke$arity$3 = G__18006__3;
  return G__18006;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args17971) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args17971)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_18007 = 0;
    while (true) {
      if (i_18007 < arr__$1.length) {
        var k_18008 = arr__$1[i_18007];
        var v_18009 = arr__$1[i_18007 + 1];
        var idx_18010 = cljs.core.array_index_of(ret, k_18008);
        if (idx_18010 === -1) {
          ret.push(k_18008);
          ret.push(v_18009);
        } else {
        }
        var G__18011 = i_18007 + 2;
        i_18007 = G__18011;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var arr__$3 = function() {
    var cnt = arr__$2.length / 2;
    return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
  }();
  return arr__$3;
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return cljs.core._assoc_BANG_(tcoll__$1, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__18014 = cljs.core.next(es);
          var G__18015 = cljs.core._assoc_BANG_(tcoll__$2, cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__18014;
          tcoll__$2 = G__18015;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len, self__.arr) : cljs.core.array__GT_transient_hash_map.call(null, self__.len, self__.arr), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__18013_18016 = self__.arr;
      G__18013_18016.pop();
      G__18013_18016.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__18017 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__18018 = i + 2;
      out = G__18017;
      i = G__18018;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set(var_args) {
  var args18019 = [];
  var len__7200__auto___18024 = arguments.length;
  var i__7201__auto___18025 = 0;
  while (true) {
    if (i__7201__auto___18025 < len__7200__auto___18024) {
      args18019.push(arguments[i__7201__auto___18025]);
      var G__18026 = i__7201__auto___18025 + 1;
      i__7201__auto___18025 = G__18026;
      continue;
    } else {
    }
    break;
  }
  var G__18021 = args18019.length;
  switch(G__18021) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args18019.length)].join(""));;
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__18022 = cljs.core.aclone(arr);
  G__18022[i] = a;
  return G__18022;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__18023 = cljs.core.aclone(arr);
  G__18023[i] = a;
  G__18023[j] = b;
  return G__18023;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set(var_args) {
  var args18028 = [];
  var len__7200__auto___18031 = arguments.length;
  var i__7201__auto___18032 = 0;
  while (true) {
    if (i__7201__auto___18032 < len__7200__auto___18031) {
      args18028.push(arguments[i__7201__auto___18032]);
      var G__18033 = i__7201__auto___18032 + 1;
      i__7201__auto___18032 = G__18033;
      continue;
    } else {
    }
    break;
  }
  var G__18030 = args18028.length;
  switch(G__18030) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args18028.length)].join(""));;
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__18038 = init__$1;
          var G__18039 = k;
          var G__18040 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18038, G__18039, G__18040) : f.call(null, G__18038, G__18039, G__18040);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
      } else {
        var G__18041 = i + 2;
        var G__18042 = init__$2;
        i = G__18041;
        init__$1 = G__18042;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.NodeIterator = function(arr, i, next_entry, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_entry = next_entry;
  this.next_iter = next_iter;
};
cljs.core.NodeIterator.prototype.advance = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (self__.i < len) {
      var key = self__.arr[self__.i];
      var node_or_val = self__.arr[self__.i + 1];
      var found = cljs.core.some_QMARK_(key) ? self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key, node_or_val], null) : cljs.core.some_QMARK_(node_or_val) ? function() {
        var new_iter = cljs.core._iterator(node_or_val);
        if (new_iter.hasNext()) {
          return self__.next_iter = new_iter;
        } else {
          return false;
        }
      }() : false;
      self__.i = self__.i + 2;
      if (found) {
        return true;
      } else {
        continue;
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core.NodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var or__6142__auto__ = cljs.core.some_QMARK_(self__.next_entry);
  if (or__6142__auto__) {
    return or__6142__auto__;
  } else {
    var or__6142__auto____$1 = cljs.core.some_QMARK_(self__.next_iter);
    if (or__6142__auto____$1) {
      return or__6142__auto____$1;
    } else {
      return this$.advance();
    }
  }
};
cljs.core.NodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.some_QMARK_(self__.next_entry)) {
    var ret = self__.next_entry;
    self__.next_entry = null;
    return ret;
  } else {
    if (cljs.core.some_QMARK_(self__.next_iter)) {
      var ret = self__.next_iter.next();
      if (self__.next_iter.hasNext()) {
      } else {
        self__.next_iter = null;
      }
      return ret;
    } else {
      if (this$.advance()) {
        return this$.next();
      } else {
        throw new Error("No such element");
      }
    }
  }
};
cljs.core.NodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.NodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-entry", "next-entry", 1091342476, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.NodeIterator.cljs$lang$type = true;
cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";
cljs.core.NodeIterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/NodeIterator");
};
cljs.core.__GT_NodeIterator = function cljs$core$__GT_NodeIterator(arr, i, next_entry, next_iter) {
  return new cljs.core.NodeIterator(arr, i, next_entry, next_iter);
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_[0] = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_18056 = 0;
        var j_18057 = 0;
        while (true) {
          if (i_18056 < 32) {
            if ((self__.bitmap >>> i_18056 & 1) === 0) {
              var G__18058 = i_18056 + 1;
              var G__18059 = j_18057;
              i_18056 = G__18058;
              j_18057 = G__18059;
              continue;
            } else {
              nodes[i_18056] = !(self__.arr[j_18057] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_18057]), self__.arr[j_18057], self__.arr[j_18057 + 1], added_leaf_QMARK_) : self__.arr[j_18057 + 1];
              var G__18060 = i_18056 + 1;
              var G__18061 = j_18057 + 2;
              i_18056 = G__18060;
              j_18057 = G__18061;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__18043 = edit__$1;
          var G__18044 = shift + 5;
          var G__18045 = key_or_nil;
          var G__18046 = val_or_node;
          var G__18047 = hash;
          var G__18048 = key;
          var G__18049 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__18043, G__18044, G__18045, G__18046, G__18047, G__18048, G__18049) : cljs.core.create_node.call(null, G__18043, G__18044, G__18045, G__18046, G__18047, G__18048, G__18049);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_18062 = 0;
      var j_18063 = 0;
      while (true) {
        if (i_18062 < 32) {
          if ((self__.bitmap >>> i_18062 & 1) === 0) {
            var G__18064 = i_18062 + 1;
            var G__18065 = j_18063;
            i_18062 = G__18064;
            j_18063 = G__18065;
            continue;
          } else {
            nodes[i_18062] = !(self__.arr[j_18063] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_18063]), self__.arr[j_18063], self__.arr[j_18063 + 1], added_leaf_QMARK_) : self__.arr[j_18063 + 1];
            var G__18066 = i_18062 + 1;
            var G__18067 = j_18063 + 2;
            i_18062 = G__18066;
            j_18063 = G__18067;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__18050 = shift + 5;
          var G__18051 = key_or_nil;
          var G__18052 = val_or_node;
          var G__18053 = hash;
          var G__18054 = key;
          var G__18055 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__18050, G__18051, G__18052, G__18053, G__18054, G__18055) : cljs.core.create_node.call(null, G__18050, G__18051, G__18052, G__18053, G__18054, G__18055);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = true;
cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.BitmapIndexedNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "bitmap", "bitmap", 501334601, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__18068 = i + 1;
        var G__18069 = j + 2;
        var G__18070 = bitmap | 1 << i;
        i = G__18068;
        j = G__18069;
        bitmap = G__18070;
        continue;
      } else {
        var G__18071 = i + 1;
        var G__18072 = j;
        var G__18073 = bitmap;
        i = G__18071;
        j = G__18072;
        bitmap = G__18073;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNodeIterator = function(arr, i, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_iter = next_iter;
};
cljs.core.ArrayNodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (!(cljs.core.some_QMARK_(self__.next_iter) && self__.next_iter.hasNext())) {
      if (self__.i < len) {
        var node = self__.arr[self__.i];
        self__.i = self__.i + 1;
        if (cljs.core.some_QMARK_(node)) {
          self__.next_iter = cljs.core._iterator(node);
        } else {
        }
        continue;
      } else {
        return false;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.ArrayNodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (this$.hasNext()) {
    return self__.next_iter.next();
  } else {
    throw new Error("No such element");
  }
};
cljs.core.ArrayNodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayNodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNodeIterator.cljs$lang$type = true;
cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";
cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ArrayNodeIterator");
};
cljs.core.__GT_ArrayNodeIterator = function cljs$core$__GT_ArrayNodeIterator(arr, i, next_iter) {
  return new cljs.core.ArrayNodeIterator(arr, i, next_iter);
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null, self__.arr);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
        } else {
          var G__18074 = i + 1;
          var G__18075 = init__$2;
          i = G__18074;
          init__$1 = G__18075;
          continue;
        }
      } else {
        var G__18076 = i + 1;
        var G__18077 = init__$1;
        i = G__18076;
        init__$1 = G__18077;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = true;
cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeIterator(self__.arr, 0, null);
};
cljs.core.ArrayNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__18078 = i + 2;
        i = G__18078;
        continue;
      }
    } else {
      return -1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_[0] = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null, self__.arr);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return (new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = true;
cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeIterator(self__.arr, 0, null, null);
};
cljs.core.HashCollisionNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), cljs.core.with_meta(new cljs.core.Symbol(null, "collision-hash", "collision-hash", -35831342, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node(var_args) {
  var args18079 = [];
  var len__7200__auto___18082 = arguments.length;
  var i__7201__auto___18083 = 0;
  while (true) {
    if (i__7201__auto___18083 < len__7200__auto___18082) {
      args18079.push(arguments[i__7201__auto___18083]);
      var G__18084 = i__7201__auto___18083 + 1;
      i__7201__auto___18083 = G__18084;
      continue;
    } else {
    }
    break;
  }
  var G__18081 = args18079.length;
  switch(G__18081) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args18079.length)].join(""));;
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    var G__18086 = self__.nodes;
    var G__18087 = self__.i + 2;
    var G__18088 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18086, G__18087, G__18088) : cljs.core.create_inode_seq.call(null, G__18086, G__18087, G__18088);
  } else {
    var G__18089 = self__.nodes;
    var G__18090 = self__.i;
    var G__18091 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18089, G__18090, G__18091) : cljs.core.create_inode_seq.call(null, G__18089, G__18090, G__18091);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq(var_args) {
  var args18092 = [];
  var len__7200__auto___18095 = arguments.length;
  var i__7201__auto___18096 = 0;
  while (true) {
    if (i__7201__auto___18096 < len__7200__auto___18095) {
      args18092.push(arguments[i__7201__auto___18096]);
      var G__18097 = i__7201__auto___18096 + 1;
      i__7201__auto___18096 = G__18097;
      continue;
    } else {
    }
    break;
  }
  var G__18094 = args18092.length;
  switch(G__18094) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args18092.length)].join(""));;
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__4423__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__4423__auto__)) {
            var node = temp__4423__auto__;
            var temp__4423__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__4423__auto____$1)) {
              var node_seq = temp__4423__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__18099 = j + 2;
              j = G__18099;
              continue;
            }
          } else {
            var G__18100 = j + 2;
            j = G__18100;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__18101 = null;
  var G__18102 = self__.nodes;
  var G__18103 = self__.i;
  var G__18104 = cljs.core.next(self__.s);
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__18101, G__18102, G__18103, G__18104) : cljs.core.create_array_node_seq.call(null, G__18101, G__18102, G__18103, G__18104);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "nodes", "nodes", -459054278, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 
  875778266), true], null))], null);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq(var_args) {
  var args18105 = [];
  var len__7200__auto___18108 = arguments.length;
  var i__7201__auto___18109 = 0;
  while (true) {
    if (i__7201__auto___18109 < len__7200__auto___18108) {
      args18105.push(arguments[i__7201__auto___18109]);
      var G__18110 = i__7201__auto___18109 + 1;
      i__7201__auto___18109 = G__18110;
      continue;
    } else {
    }
    break;
  }
  var G__18107 = args18105.length;
  switch(G__18107) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(args18105.length)].join(""));;
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__4423__auto__ = nodes[j];
        if (cljs.core.truth_(temp__4423__auto__)) {
          var nj = temp__4423__auto__;
          var temp__4423__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__4423__auto____$1)) {
            var ns = temp__4423__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__18112 = j + 1;
            j = G__18112;
            continue;
          }
        } else {
          var G__18113 = j + 1;
          j = G__18113;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.HashMapIter = function(nil_val, root_iter, seen) {
  this.nil_val = nil_val;
  this.root_iter = root_iter;
  this.seen = seen;
};
cljs.core.HashMapIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.seen && self__.root_iter.hasNext();
};
cljs.core.HashMapIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!self__.seen) {
    self__.seen = true;
    return self__.nil_val;
  } else {
    return self__.root_iter.next();
  }
};
cljs.core.HashMapIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.HashMapIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.Symbol(null, "root-iter", "root-iter", 1974672108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "seen", "seen", 1121531738, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.HashMapIter.cljs$lang$type = true;
cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";
cljs.core.HashMapIter.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/HashMapIter");
};
cljs.core.__GT_HashMapIter = function cljs$core$__GT_HashMapIter(nil_val, root_iter, seen) {
  return new cljs.core.HashMapIter(nil_val, root_iter, seen);
};
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null, coll));
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__18115 = cljs.core.seq(coll);
  var chunk__18116 = null;
  var count__18117 = 0;
  var i__18118 = 0;
  while (true) {
    if (i__18118 < count__18117) {
      var vec__18119 = chunk__18116.cljs$core$IIndexed$_nth$arity$2(null, i__18118);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18119, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18119, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__18123 = seq__18115;
      var G__18124 = chunk__18116;
      var G__18125 = count__18117;
      var G__18126 = i__18118 + 1;
      seq__18115 = G__18123;
      chunk__18116 = G__18124;
      count__18117 = G__18125;
      i__18118 = G__18126;
      continue;
    } else {
      var temp__4425__auto__ = cljs.core.seq(seq__18115);
      if (temp__4425__auto__) {
        var seq__18115__$1 = temp__4425__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__18115__$1)) {
          var c__6945__auto__ = cljs.core.chunk_first(seq__18115__$1);
          var G__18127 = cljs.core.chunk_rest(seq__18115__$1);
          var G__18128 = c__6945__auto__;
          var G__18129 = cljs.core.count(c__6945__auto__);
          var G__18130 = 0;
          seq__18115 = G__18127;
          chunk__18116 = G__18128;
          count__18117 = G__18129;
          i__18118 = G__18130;
          continue;
        } else {
          var vec__18120 = cljs.core.first(seq__18115__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18120, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18120, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__18131 = cljs.core.next(seq__18115__$1);
          var G__18132 = null;
          var G__18133 = 0;
          var G__18134 = 0;
          seq__18115 = G__18131;
          chunk__18116 = G__18132;
          count__18117 = G__18133;
          i__18118 = G__18134;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init, null, self__.nil_val) : f.call(null, init, null, self__.nil_val) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var root_iter = self__.root ? cljs.core._iterator(self__.root) : cljs.core.nil_iter;
  if (self__.has_nil_QMARK_) {
    return new cljs.core.HashMapIter(self__.nil_val, root_iter, false);
  } else {
    return root_iter;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap({}, self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return !(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__18135 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__18136 = cljs.core.next(es);
          ret = G__18135;
          es = G__18136;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__18137 = null;
  var G__18137__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18137__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18137 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18137__2.call(this, self__, k);
      case 3:
        return G__18137__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18137.cljs$core$IFn$_invoke$arity$2 = G__18137__2;
  G__18137.cljs$core$IFn$_invoke$arity$3 = G__18137__3;
  return G__18137;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args18114) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18114)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", 
  "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__18138 = i + 2;
      var G__18139 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__18138;
      ret = G__18139;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__18140 = i + 1;
      var G__18141 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__18140;
      out = G__18141;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition0$ = 258;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 2048 || o.cljs$core$IMapEntry$ ? true : !o.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, o)) {
      return tcoll.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null, o), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null, o));
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__4423__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4423__auto__)) {
          var e = temp__4423__auto__;
          var G__18143 = cljs.core.next(es);
          var G__18144 = tcoll__$1.assoc_BANG_(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null, e), cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null, e));
          es = G__18143;
          tcoll__$1 = G__18144;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (cljs.core.truth_(removed_leaf_QMARK_[0])) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "has-nil?", "has-nil?", 825886722, null), new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, 
  "boolean", "boolean", -278886877, null), new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "nil-val", "nil-val", -513933559, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__18145 = ascending_QMARK_ ? t.left : t.right;
      var G__18146 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__18145;
      stack__$1 = G__18146;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__6577__auto__ = self__.__hash;
  if (!(h__6577__auto__ == null)) {
    return h__6577__auto__;
  } else {
    var h__6577__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__6577__auto____$1;
    return h__6577__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "stack", "stack", 847125597, null), cljs.core.with_meta(new cljs.core.Symbol(null, "ascending?", "ascending?", -1938452653, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "tag", "tag", -1290361223), new cljs.core.Symbol(null, "boolean", "boolean", -278886877, null)], null)), new cljs.core.Symbol(null, 
  "cnt", "cnt", 1924510325, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__6740__auto__, writer__6741__auto__, opt__6742__auto__) {
  return cljs.core._write(writer__6741__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__7136__auto__ = this;
  return cljs.core.es6_iterator(this__7136__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? cljs$core$tree_map_kv_reduce(node.left, f, init) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null, init__$1);
  } else {
    var init__$2 = function() {
      var G__18156 = init__$1;
      var G__18157 = node.key;
      var G__18158 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18156, G__18157, G__18158) : f.call(null, G__18156, G__18157, G__18158);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null, init__$2);
    } else {
      var init__$3 = !(node.right == null) ? cljs$core$tree_map_kv_reduce(node.right, f, init__$2) : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null, init__$3);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.Black