from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

nxp_armmcu = SchLib(tool=SKIDL).add_parts(*[
        Part(name='LPC1102UK',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 32kB Flash, 8kB SRAM, UART, SPI, ADC 5ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='A1',name='PIO0_8/MISO/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='XTALIN',do_erc=True),
            Pin(num='C2',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='A3',name='PIO0_9/MOSI/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PIO1_0/AD1/CT32B1_CAP0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PIO1_2/AD3/CT32B1_MAT1/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PIO0_10/SCK/CT16B0_MAT2/SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PIO0_11/AD0/CT32B0_MAT3/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PIO1_1/AD2/CT32B1_MAT0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PIO1_3/AD4/CT32B1_MAT2/SWDIO',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC1111FHN33/101',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 8kB Flash, 2k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1111FHN33/102',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 8kB Flash, 2k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1111FHN33/201',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 8kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1111FHN33/202',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 8kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1112FHN33/101',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 16kB Flash, 2k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1112FHN33/102',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 16kB Flash, 2k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1112FHN33/201',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 16kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1112FHN33/202',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 16kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1113FBD48/301',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 24kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO2_0/~DTR~/SSEL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='XTALIN',do_erc=True),
            Pin(num='7',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO2_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO2_7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO2_11/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PIO2_8',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO0_11/AD0/CT32B0_MAT3/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO2_1/~DSR~/SCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PIO1_0/AD1/CT32B1_CAP0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PIO3_2/~DCD~',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO2_9',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PIO1_1/AD2/CT32B1_MAT0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO2_10',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PIO1_2/AD3/CT32B1_MAT1/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO2_2/~DCD~/MISO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PIO3_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PIO3_1/~DSR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PIO2_3/~RI~/MOSI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PIO3_3/~RI~',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO2_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PIO0_10/SCK0/CT16B0_MAT2/SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='SWDIO/PIO1_3/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC1113FBD48/302',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 24kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO2_0/~DTR~/SSEL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='XTALIN',do_erc=True),
            Pin(num='7',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO2_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO2_7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO2_11/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PIO2_8',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO0_11/AD0/CT32B0_MAT3/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO2_1/~DSR~/SCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PIO1_0/AD1/CT32B1_CAP0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PIO3_2/~DCD~',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO2_9',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PIO1_1/AD2/CT32B1_MAT0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO2_10',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PIO1_2/AD3/CT32B1_MAT1/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO2_2/~DCD~/MISO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PIO3_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PIO3_1/~DSR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PIO2_3/~RI~/MOSI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PIO3_3/~RI~',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO2_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PIO0_10/SCK0/CT16B0_MAT2/SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='SWDIO/PIO1_3/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC1113FHN33/201',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 24kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1113FHN33/202',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 24kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1113FHN33/301',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 24kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1113FHN33/302',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 24kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1114FBD48/301',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 32kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO2_0/~DTR~/SSEL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='XTALIN',do_erc=True),
            Pin(num='7',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO2_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO2_7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO2_11/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PIO2_8',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO0_11/AD0/CT32B0_MAT3/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO2_1/~DSR~/SCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PIO1_0/AD1/CT32B1_CAP0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PIO3_2/~DCD~',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO2_9',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PIO1_1/AD2/CT32B1_MAT0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO2_10',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PIO1_2/AD3/CT32B1_MAT1/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO2_2/~DCD~/MISO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PIO3_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PIO3_1/~DSR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PIO2_3/~RI~/MOSI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PIO3_3/~RI~',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO2_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PIO0_10/SCK0/CT16B0_MAT2/SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='SWDIO/PIO1_3/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC1114FBD48/302',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 32kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO2_0/~DTR~/SSEL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='XTALIN',do_erc=True),
            Pin(num='7',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO2_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO2_7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO2_11/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PIO2_8',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO0_11/AD0/CT32B0_MAT3/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO2_1/~DSR~/SCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PIO1_0/AD1/CT32B1_CAP0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PIO3_2/~DCD~',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO2_9',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PIO1_1/AD2/CT32B1_MAT0/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO2_10',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PIO1_2/AD3/CT32B1_MAT1/R',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO2_2/~DCD~/MISO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PIO3_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PIO3_1/~DSR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PIO2_3/~RI~/MOSI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PIO3_3/~RI~',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO2_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PIO0_10/SCK0/CT16B0_MAT2/SWCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='SWDIO/PIO1_3/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC1114FHN33/201',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 32kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1114FHN33/202',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 32kB Flash, 4k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1114FHN33/301',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 32kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC1114FHN33/302',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM0, M0, NXP, Microcontroller',description='32-bit ARM Cortex-M0 microcontroller, 32kB Flash, 8k SRAM, UART, I2C, SPI, ADC 8ch, Power Profile',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PIO2_0/~DTR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_0/~RESET~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTALIN',do_erc=True),
            Pin(num='5',name='XTALOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PIO1_8/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO1_10/AD6/CT16B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PIO1_5/~RTS~/CT32B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO0_11/R/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_6/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO1_9/CT16B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO1_0/R/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO1_7/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO3_4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO1_1/R/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VSS(BOTPAD)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PIO3_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_2/R/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_3/SWDIO/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PIO1_4/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO1_11/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_10/SWCLK/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LPC11E12FBD48/201',dest=TEMPLATE,tool=SKIDL,keywords='nxp lpc arm microcontroller cortex',description='LPC11E1x, 50MHz Cortex-M0 MCU, 32kB Flash, 4kB EEPROM, 10kB SRAM, USART, I2C, SSP, ADC, Power Profile, LQFP48',ref_prefix='U',num_units=1,fplist=['LQFP*7x7mm*Pitch0.5mm*'],do_erc=True,aliases=['LPC11E13FBD48/301', 'LPC11E14FBD48/401'],pins=[
            Pin(num='1',name='PIO1_25/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO1_19/~DTR~/SSEL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~RESET~/PIO0_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PIO0_1/CLKOUT/CT32B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='XTALIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='XTALOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PIO0_20/CT16B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_2/SSEL0/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='30',name='PIO0_22/AD6/CT16B1_MAT1/MISO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PIO0_16/AD5/CT32B1_MAT3/WAKEUP',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO1_26/CT32B0_MAT2/RXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PIO1_24/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PIO1_29/SCK0/CT32B0_CAP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PIO1_27/CT32B0_MAT3/TXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO0_6/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDI/PIO0_11/AD0/CT32B0_MAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PIO0_23/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO1_20/~DSR~/SCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO0_7/~CTS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TMS/PIO0_12/AD1/CT32B1_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PIO1_15/~DCD~/CT16B0_MAT2/SCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PIO1_28/CT32B0_CAP0/SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TDO/PIO0_13/AD2/CT32B1_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='PIO0_4/SCL',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='25',name='PIO1_31',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~TRST~/PIO0_14/AD3/CT32B1_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PIO0_17/~RTS~/CT32B0_CAP0/SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_5/SDA',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='26',name='PIO1_21/~DCD~/MISO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PIO1_13/~DTR~/CT16B0_MAT0/TXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PIO0_18/RXD/CT32B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_21/CT16B1_MAT0/MOSI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO0_8/MISO0/CT16B0_MAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PIO1_14/DSR/CT16B0_MAT1/RXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PIO0_19/TXD/CT32B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO1_23/CT16B1_MAT1/SSEL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO0_9/MOSI0/CT16B0_MAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PIO1_22/~RI~/MOSI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PIO1_16/~RI~/CT16B0_CAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='29',name='SWCLK/PIO0_10/SCK0/CT16B0_MAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='SWDIO/PIO0_15/AD4/CT32B1_MAT2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC11U12FBD48',dest=TEMPLATE,tool=SKIDL,keywords='nxp lpc arm microcontroller cortex',description='LPC11U00 USB series, 50MHz Cortex-M0 MCU, USB, ADC, USART, I2C, SPI, LQFP48 package',ref_prefix='U',num_units=1,do_erc=True,aliases=['LPC11U13FBD48', 'LPC11U14FBD48', 'LPC11U22FBD48', 'LPC11U23FBD48', 'LPC11U24FBD48', 'LPC11U34FBD48', 'LPC11U35FBD48', 'LPC11U36FBD48', 'LPC11U37FBD48'],pins=[
            Pin(num='1',name='C32B0_M1/PIO1_25',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='~DTR~/SSEL1/PIO1_19',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_0/~RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PIO0_1/C32B0_M2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='XTALIN',do_erc=True),
            Pin(num='7',name='XTALOUT',do_erc=True),
            Pin(num='8',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PIO0_20/CT16B1_C0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PIO0_2/SSEL0/CT16B0_C0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='USB_DP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='PIO0_22/MISO1/ADC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PIO0_16/AD5/CT32B1_M3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='CT32B0_M2/RXD/PIO1_26',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CT32B0_M0/PIO1_24',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='SCK0/CT32B0_C1/PIO1_29',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TC32B0_M3/TXD/PIO1_27',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PIO0_6/~USB_Connect~/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PIO0_11/TDI/AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PIO0_23/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SCK1/PIO1_20',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PIO0_7/~CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PIO0_12/TMS/AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='SCK1/PIO1_15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_3/USB_Vbus',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='CT32B0_C0/SCLK/PIO1_28',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PIO0_13/TDO/AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='PIO0_4/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PIO1_31',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PIO0_14/~TRST~/AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PIO0_17/CT32B0_C0/SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PIO0_5/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='MISO1/PIO1_21',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TXD/PIO1_13',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PIO0_18/RXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PIO0_21/CT16B1_M0/MOSI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PIO0_8/MISO0/CT16B0_M0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RXD/PIO1_14',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PIO0_19/TXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='CT16B1_M1/SSEL1/PIO1_23',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PIO0_9/MOSI0/CT16B0_M1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='MOSI1/PIO1_22',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='CT16B0_C0/PIO1_16',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='USB_DM',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='PIO0_10/SWCLK/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PIO0_15/SWDIO/AD4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC1763FBD100',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM3, M3, NXP, Microcontroller',description='LPC1769, 32-bit ARM Cortex-M3 microcontroller, 256 kB Flash, 64 kB SRAM, I2S, DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TDO/SWO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TDI',do_erc=True),
            Pin(num='3',name='TMS/SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~TRST~',do_erc=True),
            Pin(num='5',name='TCK/SWDCLK',do_erc=True),
            Pin(num='6',name='P0[26]/AD0[3]/AOUT/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P0[25]/AD0[2]/I2SRX_SDA/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P0[24]/AD0[1]/I2SRX_WS/CAP3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P0[23]/AD0[0]/I2SRX_CLK/CAP3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VDDA',do_erc=True),
            Pin(num='20',name='P1[31]/SCK1/AD0[5]',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P0[30]',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P1[26]/MCOB1/PWM1[6]/CAP0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P2[13]/~EINT3~/I2STX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P0[18]/DCD1/MOSI0/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P2[3]/PWM1[4]/DCD1/TRACEDATA[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P0[5]/I2SRX_WS/CAP2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='P1[10]',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P1[30]/VBUS/AD0[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='P2[12]/~EINT2~/I2STX_WS',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P0[17]/CTS1/MISO0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='P0[4]/I2SRX_CLK/CAP2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P1[9]',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VREFP',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='XTAL1',do_erc=True),
            Pin(num='32',name='P1[18]/PWM1[1]/CAP1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P2[11]/~EINT1~/I2STX_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P0[15]/TXD1/SCK0/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P4[28]/MAT2[0]/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P1[8]',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',do_erc=True),
            Pin(num='33',name='P1[19]/MCOA0/CAP1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P1[27]/CLKOUT/CAP0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P2[10]/~EINT0~/NMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P0[16]/RXD1/SSEL0/SSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P2[2]/PWM1[3]/CTS1/TRACEDATA[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='P1[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~RSTOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='P0[28]/SCL0/USB_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1[20]/MCI0/PWM1[2]/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P1[28]/MCOA2/PCAP1[0]/MAT0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='P2[9]/RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P2[1]/PWM1[2]/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VREFN',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P0[27]/SDA0/USB_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P1[21]/~MCABORT~/PWM1[3]/SSEL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P1[29]/MCOB2/PCAP1[1]/MAT0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='P2[8]/TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P2[0]/PWM1[1]/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P4[29]/MAT2[1]/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RTCX1',do_erc=True),
            Pin(num='26',name='P3[26]/STCLK/MAT0[1]/PWM1[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1[22]/MCOB0/MAT1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P0[0]/TXD3/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P0[22]/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P2[7]/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P0[9]/I2STX_SDA/MOSI1/MAT2[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P1[17]',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~RESET~',do_erc=True),
            Pin(num='27',name='P3[25]/MAT0[0]/PWM1[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P1[23]/MCI1/PWM1[4]/MISO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P0[1]/RXD3/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P0[21]/RI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P2[6]/PCAP1[0]/RI1/TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P0[8]/I2STX_WS/MISO1/MAT2[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P1[16]',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RTCX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P1[24]/MCI2/PWM1[5]/MOSI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P0[10]/TXD2/SDA2/MAT3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P0[20]/DTR1/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P2[5]/PWM1[6]/DTR1/TRACEDATA[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P0[7]/I2STX_CLK/SCK1/MAT2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P1[15]',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P0[2]/TXD0/AD0[7]',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VBAT',do_erc=True),
            Pin(num='29',name='P0[29]',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P1[25]/MCOA1/MAT1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P0[11]/RXD2/SCL2/MAT3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P0[19]/DSR1/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P2[4]/PWM1[5]/DSR1/TRACEDATA[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P0[6]/I2SRX_SDA/SSEL1/MAT2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P1[14]',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='P0[3]/RXD0/AD0[6]',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RTCK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LPC1764FBD100',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM3, M3, NXP, Microcontroller',description='LPC1769, 32-bit ARM Cortex-M3 microcontroller, 128 kB Flash, 32 kB SRAM, Ethernet, USB 2.0 Device, CAN',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TDO/SWO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TDI',do_erc=True),
            Pin(num='3',name='TMS/SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~TRST~',do_erc=True),
            Pin(num='5',name='TCK/SWDCLK',do_erc=True),
            Pin(num='6',name='P0[26]/AD0[3]/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P0[25]/AD0[2]/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P0[24]/AD0[1]/CAP3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P0[23]/AD0[0]/CAP3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VDDA',do_erc=True),
            Pin(num='20',name='P1[31]/SCK1/AD0[5]',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P0[30]/USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P1[26]/MCOB1/PWM1[6]/CAP0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P2[13]/~EINT3~',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P0[18]/DCD1/MOSI0/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P2[3]/PWM1[4]/DCD1/TRACEDATA[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P0[5]/I2SRX_WS/TD2/CAP2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='P1[10]/ENET_RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P1[30]/VBUS/AD0[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='P2[12]/~EINT2~',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P0[17]/CTS1/MISO0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='P0[4]/I2SRX_CLK/RD2/CAP2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P1[9]/ENET_RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VREFP',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='XTAL1',do_erc=True),
            Pin(num='32',name='P1[18]/USB_UP_LED/PWM1[1]/CAP1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P2[11]/~EINT1~',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P0[15]/TXD1/SCK0/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P4[28]/MAT2[0]/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P1[8]/ENET_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',do_erc=True),
            Pin(num='33',name='P1[19]/MCOA0/CAP1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P1[27]/CLKOUT/CAP0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P2[10]/~EINT0~/NMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P0[16]/RXD1/SSEL0/SSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P2[2]/PWM1[3]/CTS1/TRACEDATA[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='P1[4]/ENET_TX_EN',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~RSTOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='P0[28]/SCL0/USB_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1[20]/MCI0/PWM1[2]/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P1[28]/MCOA2/PCAP1[0]/MAT0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='P2[9]/USB_CONNECT/RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P2[1]/PWM1[2]/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P1[1]/ENET_TDX1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VREFN',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P0[27]/SDA0/USB_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P1[21]/~MCABORT~/PWM1[3]/SSEL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P1[29]/MCOB2/PCAP1[1]/MAT0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='P2[8]/TD2/TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P2[0]/PWM1[1]/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P4[29]/MAT2[1]/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P1[0]/ENET_TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RTCX1',do_erc=True),
            Pin(num='26',name='P3[26]/STCLK/MAT0[1]/PWM1[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1[22]/MCOB0/MAT1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P0[0]/RD1/TXD3/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P0[22]/RTS1/TD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P2[7]/RD2/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P0[9]/MOSI1/MAT2[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P1[17]/ENET_MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~RESET~',do_erc=True),
            Pin(num='27',name='P3[25]/MAT0[0]/PWM1[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P1[23]/MCI1/PWM1[4]/MISO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P0[1]/TD1/RXD3/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P0[21]/RI1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P2[6]/PCAP1[0]/RI1/TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P0[8]/MISO1/MAT2[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P1[16]/ENET_MDC',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RTCX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P1[24]/MCI2/PWM1[5]/MOSI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P0[10]/TXD2/SDA2/MAT3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P0[20]/DTR1/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P2[5]/PWM1[6]/DTR1/TRACEDATA[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P0[7]/SCK1/MAT2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P1[15]/ENET_REF_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P0[2]/TXD0/AD0[7]',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VBAT',do_erc=True),
            Pin(num='29',name='P0[29]/USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P1[25]/MCOA1/MAT1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P0[11]/RXD2/SCL2/MAT3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P0[19]/DSR1/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P2[4]/PWM1[5]/DSR1/TRACEDATA[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P0[6]/SSEL1/MAT2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P1[14]/ENET_RX_ER',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='P0[3]/RXD0/AD0[6]',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RTCK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LPC1765FBD100',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM3, M3, NXP, Microcontroller',description='LPC1769, 32-bit ARM Cortex-M3 microcontroller, 256 kB Flash, 64 kB SRAM, USB 2.0 Host/Device/OTG, CAN, I2S, DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TDO/SWO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TDI',do_erc=True),
            Pin(num='3',name='TMS/SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~TRST~',do_erc=True),
            Pin(num='5',name='TCK/SWDCLK',do_erc=True),
            Pin(num='6',name='P0[26]/AD0[3]/AOUT/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P0[25]/AD0[2]/I2SRX_SDA/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P0[24]/AD0[1]/I2SRX_WS/CAP3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P0[23]/AD0[0]/I2SRX_CLK/CAP3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VDDA',do_erc=True),
            Pin(num='20',name='P1[31]/SCK1/AD0[5]',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P0[30]/USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P1[26]/MCOB1/PWM1[6]/CAP0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P2[13]/~EINT3~/I2STX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P0[18]/DCD1/MOSI0/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P2[3]/PWM1[4]/DCD1/TRACEDATA[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P0[5]/I2SRX_WS/TD2/CAP2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='P1[10]',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P1[30]/VBUS/AD0[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='P2[12]/~EINT2~/I2STX_WS',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P0[17]/CTS1/MISO0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='P0[4]/I2SRX_CLK/RD2/CAP2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P1[9]',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VREFP',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='XTAL1',do_erc=True),
            Pin(num='32',name='P1[18]/USB_UP_LED/PWM1[1]/CAP1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P2[11]/~EINT1~/I2STX_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P0[15]/TXD1/SCK0/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P4[28]/RX_MCLK/MAT2[0]/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P1[8]',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',do_erc=True),
            Pin(num='33',name='P1[19]/MCOA0/~USB_PPWR~/CAP1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P1[27]/CLKOUT/~USB_OVRCR~/CAP0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P2[10]/~EINT0~/NMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P0[16]/RXD1/SSEL0/SSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P2[2]/PWM1[3]/CTS1/TRACEDATA[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='P1[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~RSTOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='P0[28]/SCL0/USB_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1[20]/MCI0/PWM1[2]/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P1[28]/MCOA2/PCAP1[0]/MAT0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='P2[9]/USB_CONNECT/RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P2[1]/PWM1[2]/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VREFN',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P0[27]/SDA0/USB_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P1[21]/~MCABORT~/PWM1[3]/SSEL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P1[29]/MCOB2/PCAP1[1]/MAT0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='P2[8]/TD2/TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P2[0]/PWM1[1]/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P4[29]/TX_MCLK/MAT2[1]/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RTCX1',do_erc=True),
            Pin(num='26',name='P3[26]/STCLK/MAT0[1]/PWM1[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1[22]/MCOB0/USB_PWRD/MAT1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P0[0]/RD1/TXD3/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P0[22]/RTS1/TD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P2[7]/RD2/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P0[9]/I2STX_SDA/MOSI1/MAT2[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P1[17]',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~RESET~',do_erc=True),
            Pin(num='27',name='P3[25]/MAT0[0]/PWM1[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P1[23]/MCI1/PWM1[4]/MISO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P0[1]/TD1/RXD3/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P0[21]/RI1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P2[6]/PCAP1[0]/RI1/TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P0[8]/I2STX_WS/MISO1/MAT2[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P1[16]',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RTCX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P1[24]/MCI2/PWM1[5]/MOSI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P0[10]/TXD2/SDA2/MAT3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P0[20]/DTR1/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P2[5]/PWM1[6]/DTR1/TRACEDATA[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P0[7]/I2STX_CLK/SCK1/MAT2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P1[15]',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P0[2]/TXD0/AD0[7]',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VBAT',do_erc=True),
            Pin(num='29',name='P0[29]/USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P1[25]/MCOA1/MAT1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P0[11]/RXD2/SCL2/MAT3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P0[19]/DSR1/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P2[4]/PWM1[5]/DSR1/TRACEDATA[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P0[6]/I2SRX_SDA/SSEL1/MAT2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P1[14]',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='P0[3]/RXD0/AD0[6]',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RTCK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LPC1766FBD100',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM3, M3, NXP, Microcontroller',description='LPC1769, 32-bit ARM Cortex-M3 microcontroller, 256 kB Flash, 64 kB SRAM, Ethernet, USB 2.0 Host/Device/OTG, CAN, I2S, DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TDO/SWO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TDI',do_erc=True),
            Pin(num='3',name='TMS/SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~TRST~',do_erc=True),
            Pin(num='5',name='TCK/SWDCLK',do_erc=True),
            Pin(num='6',name='P0[26]/AD0[3]/AOUT/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P0[25]/AD0[2]/I2SRX_SDA/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P0[24]/AD0[1]/I2SRX_WS/CAP3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P0[23]/AD0[0]/I2SRX_CLK/CAP3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VDDA',do_erc=True),
            Pin(num='20',name='P1[31]/SCK1/AD0[5]',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P0[30]/USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P1[26]/MCOB1/PWM1[6]/CAP0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P2[13]/~EINT3~/I2STX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P0[18]/DCD1/MOSI0/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P2[3]/PWM1[4]/DCD1/TRACEDATA[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P0[5]/I2SRX_WS/TD2/CAP2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='P1[10]/ENET_RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P1[30]/VBUS/AD0[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='P2[12]/~EINT2~/I2STX_WS',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P0[17]/CTS1/MISO0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='P0[4]/I2SRX_CLK/RD2/CAP2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P1[9]/ENET_RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VREFP',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='XTAL1',do_erc=True),
            Pin(num='32',name='P1[18]/USB_UP_LED/PWM1[1]/CAP1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P2[11]/~EINT1~/I2STX_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P0[15]/TXD1/SCK0/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P4[28]/RX_MCLK/MAT2[0]/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P1[8]/ENET_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',do_erc=True),
            Pin(num='33',name='P1[19]/MCOA0/~USB_PPWR~/CAP1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P1[27]/CLKOUT/~USB_OVRCR~/CAP0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P2[10]/~EINT0~/NMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P0[16]/RXD1/SSEL0/SSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P2[2]/PWM1[3]/CTS1/TRACEDATA[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='P1[4]/ENET_TX_EN',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~RSTOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='P0[28]/SCL0/USB_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1[20]/MCI0/PWM1[2]/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P1[28]/MCOA2/PCAP1[0]/MAT0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='P2[9]/USB_CONNECT/RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P2[1]/PWM1[2]/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P1[1]/ENET_TDX1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VREFN',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P0[27]/SDA0/USB_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P1[21]/~MCABORT~/PWM1[3]/SSEL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P1[29]/MCOB2/PCAP1[1]/MAT0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='P2[8]/TD2/TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P2[0]/PWM1[1]/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P4[29]/TX_MCLK/MAT2[1]/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P1[0]/ENET_TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RTCX1',do_erc=True),
            Pin(num='26',name='P3[26]/STCLK/MAT0[1]/PWM1[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1[22]/MCOB0/USB_PWRD/MAT1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P0[0]/RD1/TXD3/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P0[22]/RTS1/TD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P2[7]/RD2/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P0[9]/I2STX_SDA/MOSI1/MAT2[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P1[17]/ENET_MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~RESET~',do_erc=True),
            Pin(num='27',name='P3[25]/MAT0[0]/PWM1[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P1[23]/MCI1/PWM1[4]/MISO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P0[1]/TD1/RXD3/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P0[21]/RI1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P2[6]/PCAP1[0]/RI1/TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P0[8]/I2STX_WS/MISO1/MAT2[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P1[16]/ENET_MDC',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RTCX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P1[24]/MCI2/PWM1[5]/MOSI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P0[10]/TXD2/SDA2/MAT3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P0[20]/DTR1/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P2[5]/PWM1[6]/DTR1/TRACEDATA[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P0[7]/I2STX_CLK/SCK1/MAT2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P1[15]/ENET_REF_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P0[2]/TXD0/AD0[7]',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VBAT',do_erc=True),
            Pin(num='29',name='P0[29]/USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P1[25]/MCOA1/MAT1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P0[11]/RXD2/SCL2/MAT3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P0[19]/DSR1/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P2[4]/PWM1[5]/DSR1/TRACEDATA[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P0[6]/I2SRX_SDA/SSEL1/MAT2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P1[14]/ENET_RX_ER',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='P0[3]/RXD0/AD0[6]',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RTCK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LPC1767FBD100',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM3, M3, NXP, Microcontroller',description='LPC1769, 32-bit ARM Cortex-M3 microcontroller, 512 kB Flash, 64 kB SRAM, Ethernet, I2S, DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TDO/SWO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TDI',do_erc=True),
            Pin(num='3',name='TMS/SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~TRST~',do_erc=True),
            Pin(num='5',name='TCK/SWDCLK',do_erc=True),
            Pin(num='6',name='P0[26]/AD0[3]/AOUT/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P0[25]/AD0[2]/I2SRX_SDA/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P0[24]/AD0[1]/I2SRX_WS/CAP3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P0[23]/AD0[0]/I2SRX_CLK/CAP3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VDDA',do_erc=True),
            Pin(num='20',name='P1[31]/SCK1/AD0[5]',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P0[30]',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P1[26]/MCOB1/PWM1[6]/CAP0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P2[13]/~EINT3~/I2STX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P0[18]/DCD1/MOSI0/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P2[3]/PWM1[4]/DCD1/TRACEDATA[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P0[5]/I2SRX_WS/CAP2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='P1[10]/ENET_RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P1[30]/AD0[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='P2[12]/~EINT2~/I2STX_WS',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P0[17]/CTS1/MISO0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='P0[4]/I2SRX_CLK/CAP2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P1[9]/ENET_RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VREFP',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='XTAL1',do_erc=True),
            Pin(num='32',name='P1[18]/PWM1[1]/CAP1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P2[11]/~EINT1~/I2STX_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P0[15]/TXD1/SCK0/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P4[28]/RX_MCLK/MAT2[0]/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P1[8]/ENET_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',do_erc=True),
            Pin(num='33',name='P1[19]/MCOA0/CAP1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P1[27]/CLKOUT/CAP0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P2[10]/~EINT0~/NMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P0[16]/RXD1/SSEL0/SSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P2[2]/PWM1[3]/CTS1/TRACEDATA[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='P1[4]/ENET_TX_EN',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~RSTOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='P0[28]/SCL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1[20]/MCI0/PWM1[2]/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P1[28]/MCOA2/PCAP1[0]/MAT0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='P2[9]/USB_CONNECT/RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P2[1]/PWM1[2]/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P1[1]/ENET_TDX1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VREFN',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P0[27]/SDA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P1[21]/~MCABORT~/PWM1[3]/SSEL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P1[29]/MCOB2/PCAP1[1]/MAT0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='P2[8]/TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P2[0]/PWM1[1]/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P4[29]/TX_MCLK/MAT2[1]/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P1[0]/ENET_TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RTCX1',do_erc=True),
            Pin(num='26',name='P3[26]/STCLK/MAT0[1]/PWM1[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1[22]/MCOB0/MAT1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P0[0]/TXD3/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P0[22]/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P2[7]/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P0[9]/I2STX_SDA/MOSI1/MAT2[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P1[17]/ENET_MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~RESET~',do_erc=True),
            Pin(num='27',name='P3[25]/MAT0[0]/PWM1[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P1[23]/MCI1/PWM1[4]/MISO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P0[1]/RXD3/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P0[21]/RI1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P2[6]/PCAP1[0]/RI1/TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P0[8]/I2STX_WS/MISO1/MAT2[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P1[16]/ENET_MDC',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RTCX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P1[24]/MCI2/PWM1[5]/MOSI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P0[10]/TXD2/SDA2/MAT3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P0[20]/DTR1/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P2[5]/PWM1[6]/DTR1/TRACEDATA[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P0[7]/I2STX_CLK/SCK1/MAT2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P1[15]/ENET_REF_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P0[2]/TXD0/AD0[7]',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VBAT',do_erc=True),
            Pin(num='29',name='P0[29]',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P1[25]/MCOA1/MAT1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P0[11]/RXD2/SCL2/MAT3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P0[19]/DSR1/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P2[4]/PWM1[5]/DSR1/TRACEDATA[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P0[6]/I2SRX_SDA/SSEL1/MAT2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P1[14]/ENET_RX_ER',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='P0[3]/RXD0/AD0[6]',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RTCK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LPC1769FBD100',dest=TEMPLATE,tool=SKIDL,keywords='ARM, 32bit, CortexM3, M3, NXP, Microcontroller',description='LPC1769, 32-bit ARM Cortex-M3 microcontroller, 512 kB Flash, 64 kB SRAM, Ethernet, USB 2.0 Host/Device/OTG, CAN, I2S, DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TDO/SWO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TDI',do_erc=True),
            Pin(num='3',name='TMS/SWDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~TRST~',do_erc=True),
            Pin(num='5',name='TCK/SWDCLK',do_erc=True),
            Pin(num='6',name='P0[26]/AD0[3]/AOUT/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P0[25]/AD0[2]/I2SRX_SDA/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P0[24]/AD0[1]/I2SRX_WS/CAP3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P0[23]/AD0[0]/I2SRX_CLK/CAP3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VDDA',do_erc=True),
            Pin(num='20',name='P1[31]/SCK1/AD0[5]',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P0[30]/USB_D-',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P1[26]/MCOB1/PWM1[6]/CAP0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P2[13]/~EINT3~/I2STX_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P0[18]/DCD1/MOSI0/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P2[3]/PWM1[4]/DCD1/TRACEDATA[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P0[5]/I2SRX_WS/TD2/CAP2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='P1[10]/ENET_RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P1[30]/VBUS/AD0[4]',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='P2[12]/~EINT2~/I2STX_WS',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P0[17]/CTS1/MISO0/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='P0[4]/I2SRX_CLK/RD2/CAP2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P1[9]/ENET_RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VREFP',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='XTAL1',do_erc=True),
            Pin(num='32',name='P1[18]/USB_UP_LED/PWM1[1]/CAP1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P2[11]/~EINT1~/I2STX_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P0[15]/TXD1/SCK0/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P4[28]/RX_MCLK/MAT2[0]/TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P1[8]/ENET_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='XTAL2',do_erc=True),
            Pin(num='33',name='P1[19]/MCOA0/~USB_PPWR~/CAP1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P1[27]/CLKOUT/~USB_OVRCR~/CAP0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P2[10]/~EINT0~/NMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P0[16]/RXD1/SSEL0/SSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P2[2]/PWM1[3]/CTS1/TRACEDATA[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='P1[4]/ENET_TX_EN',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~RSTOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='P0[28]/SCL0/USB_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1[20]/MCI0/PWM1[2]/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P1[28]/MCOA2/PCAP1[0]/MAT0[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='P2[9]/USB_CONNECT/RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P2[1]/PWM1[2]/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VDD(REG)(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P1[1]/ENET_TDX1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VREFN',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P0[27]/SDA0/USB_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P1[21]/~MCABORT~/PWM1[3]/SSEL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P1[29]/MCOB2/PCAP1[1]/MAT0[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='P2[8]/TD2/TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P2[0]/PWM1[1]/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P4[29]/TX_MCLK/MAT2[1]/RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P1[0]/ENET_TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RTCX1',do_erc=True),
            Pin(num='26',name='P3[26]/STCLK/MAT0[1]/PWM1[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1[22]/MCOB0/USB_PWRD/MAT1[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P0[0]/RD1/TXD3/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P0[22]/RTS1/TD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P2[7]/RD2/RTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P0[9]/I2STX_SDA/MOSI1/MAT2[3]',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P1[17]/ENET_MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~RESET~',do_erc=True),
            Pin(num='27',name='P3[25]/MAT0[0]/PWM1[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P1[23]/MCI1/PWM1[4]/MISO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P0[1]/TD1/RXD3/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P0[21]/RI1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P2[6]/PCAP1[0]/RI1/TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P0[8]/I2STX_WS/MISO1/MAT2[2]',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P1[16]/ENET_MDC',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RTCX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='VDD(3V3)',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P1[24]/MCI2/PWM1[5]/MOSI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P0[10]/TXD2/SDA2/MAT3[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P0[20]/DTR1/SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P2[5]/PWM1[6]/DTR1/TRACEDATA[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P0[7]/I2STX_CLK/SCK1/MAT2[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P1[15]/ENET_REF_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P0[2]/TXD0/AD0[7]',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VBAT',do_erc=True),
            Pin(num='29',name='P0[29]/USB_D+',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P1[25]/MCOA1/MAT1[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P0[11]/RXD2/SCL2/MAT3[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P0[19]/DSR1/SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P2[4]/PWM1[5]/DSR1/TRACEDATA[1]',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P0[6]/I2SRX_SDA/SSEL1/MAT2[0]',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P1[14]/ENET_RX_ER',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='P0[3]/RXD0/AD0[6]',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RTCK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LPC2148',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='LPC812M101JD20',dest=TEMPLATE,tool=SKIDL,keywords='nxp lpc arm microcontroller cortex',description='LPC81xM, 30MHz Cortex-M0+ MCU, 16kB Flash, 4kB SRAM, USART, I2C, SPI, ACMP, SOIC-20',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='PIO0_17',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_13',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_12',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RESET~/PIO0_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PIO0_4/WAKEUP/~TRST~',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SWCLK/PIO0_3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SWDIO/PIO0_2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PIO0_11',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='PIO0_10',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='PIO0_16',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PIO0_14',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_15',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO0_1/ACMP_2/CLKIN/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO0_9/XTALOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_8/XTALIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='PIO0_7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PIO0_6/VDDCMP',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PIO0_0/ACMP_I1/TDO',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LPC822M101JDH20',dest=TEMPLATE,tool=SKIDL,keywords='nxp lpc arm microcontroller cortex',description='LPC82x, 30MHz Cortex-M0+ MCU, 16kB Flash, 4kB SRAM, USART, I2C, SPI, ACMP, ADC, TSSOP20',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x6.5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='PIO0_23/ADC_3/ACMP_I4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PIO0_17/ADC_9',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PIO0_13/ADC_10',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PIO0_12',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='~RESET~/PIO0_5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PIO0_4/ADC_11/WAKEUP/~TRST~',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SWCLK/PIO0_3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SWDIO/PIO0_2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PIO0_11/I2C0_SDA',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='PIO0_10/I2C0_SCL',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='20',name='PIO0_14/ADC_2/ACMP_I3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PIO0_15',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PIO0_1/ACMP_I2/CLKIN/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PIO0_9/XTALOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PIO0_8/XTALIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VREFN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='VREFP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='PIO0_0/ACMP_I1/TDO',func=Pin.BIDIR,do_erc=True)])])