from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

microchip_pic32mcu = SchLib(tool=SKIDL).add_parts(*[
        Part(name='PIC32MX1XXFXXXD-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Microchip PIC32 Microcontroller',description='32-bit Microcontrollers (up to 256 KB Flash and 64 KB SRAM) with Audio and Graphics Interfaces, USB, and Advanced Analog',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC32MX110F016D-I/PT', 'PIC32MX120F032D-I/PT', 'PIC32MX130F064D-I/PT', 'PIC32MX150F128D-I/PT', 'PIC32MX170F256D-I/PT'],pins=[
            Pin(num='1',name='RB9/PMD3/CTED4/SDA1/RPB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RPC6/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RPC7/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RPC8/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RPC9/CTED7/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB10/PMD2/CTED11/RPB10/PGED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB11/PMD1/RPB11/PGEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB12/PMD0/AN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VREF-/CVREF-/AN1/RPA1/CTED2/RA1',do_erc=True),
            Pin(num='30',name='OSC1/CLKI/RPA2/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB13/PMRD/CTPLS/RPB13/AN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/RPB0/C3IND/C2INB/C1IND/AN2/PGED1',do_erc=True),
            Pin(num='31',name='OSC2/CLKO/RPA3/RA3',do_erc=True),
            Pin(num='41',name='RB5/PMD7/RPB5/PGED3',do_erc=True),
            Pin(num='12',name='PGED/TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/CTED12/RPB1/C2INA/C1INC/AN3/PGEC1',do_erc=True),
            Pin(num='32',name='TDO/RPA8/PMA8/RA8',do_erc=True),
            Pin(num='42',name='RB6/PMD6/RPB6/PGEC3',do_erc=True),
            Pin(num='13',name='PGEC/TCK/CTED8/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/CTED13/SDA2/RPB2/C2IND/C1INB/AN4',do_erc=True),
            Pin(num='33',name='RB4/RPB4/SOSCI',do_erc=True),
            Pin(num='43',name='RB7/INT0/PMD5/CTED3/RPB7',do_erc=True),
            Pin(num='14',name='RB14/PMWR/CTED5/SCK1/RPB14/C3INB/AN10/CVREFOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/SCL2/RPB3/RTCC/C2INC/C1INA/AN5',do_erc=True),
            Pin(num='34',name='SOSCO/RPA4/T1CK/CTED9/RA4',do_erc=True),
            Pin(num='44',name='RB8/PMD4/CTED10/SCL1/RPB8',do_erc=True),
            Pin(num='15',name='RB15/PMCS1/CTED6/SCK2/RPB15/C3INA/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RPC0/RC0',do_erc=True),
            Pin(num='35',name='TDI/RPA9/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RPC1/RC1',do_erc=True),
            Pin(num='36',name='RPC3/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/RPC2/PMA2/RC2',do_erc=True),
            Pin(num='37',name='RPC4/PMA4/RC4',do_erc=True),
            Pin(num='18',name='MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RPC5/PMA3/RC5',do_erc=True),
            Pin(num='19',name='VREF+/CVREF+/AN0/C3INC/RPA0/CTED1/RA0',do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC32MX2XXFXXXD-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Microchip PIC32 Microcontroller',description='32-bit Microcontrollers (up to 256 KB Flash and 64 KB SRAM) with Audio and Graphics Interfaces, USB, and Advanced Analog',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC32MX210F016D-I/PT', 'PIC32MX220F032D-I/PT', 'PIC32MX230F064D-I/PT', 'PIC32MX250F128D-I/PT', 'PIC32MX270F256D-I/PT'],pins=[
            Pin(num='1',name='RB9/PMD3/CTED4/SDA1/RPB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RPC6/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RPC7/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RPC8/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RPC9/CTED7/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB10/CTED11/D+/RPB10/PGED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB11/D-/RPB11/PGEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VUSB3V3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PGEC3/VREF-/CVREF-/AN1/RPA1/CTED2/PMD6/RA1',do_erc=True),
            Pin(num='30',name='OSC1/CLKI/RPA2/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB13/PMRD/CTPLS/RPB13/AN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/PMD0/RPB0/C3IND/C2INB/C1IND/AN2/PGED1',do_erc=True),
            Pin(num='31',name='OSC2/CLKO/RPA3/RA3',do_erc=True),
            Pin(num='41',name='RB5/USBID/RPB5',do_erc=True),
            Pin(num='12',name='PGED/TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/PMD1/CTED12/RPB1/C2INA/C1INC/AN3/PGEC1',do_erc=True),
            Pin(num='32',name='TDO/RPA8/PMA8/RA8',do_erc=True),
            Pin(num='42',name='VBUS',do_erc=True),
            Pin(num='13',name='PGEC/TCK/CTED8/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/PMD2/CTED13/SDA2/RPB2/C2IND/C1INB/AN4',do_erc=True),
            Pin(num='33',name='RB4/RPB4/SOSCI',do_erc=True),
            Pin(num='43',name='RB7/INT0/PMD5/CTED3/RPB7',do_erc=True),
            Pin(num='14',name='RB14/CTED5/SCK1/VBUSON/RPB14/C3INB/AN10/CVREFOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/PMWR/SCL2/RPB3/RTCC/C2INC/C1INA/AN5',do_erc=True),
            Pin(num='34',name='SOSCO/RPA4/T1CK/CTED9/RA4',do_erc=True),
            Pin(num='44',name='RB8/PMD4/CTED10/SCL1/RPB8',do_erc=True),
            Pin(num='15',name='RB15/PMCS1/CTED6/SCK2/RPB15/C3INA/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RPC0/RC0',do_erc=True),
            Pin(num='35',name='TDI/RPA9/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RPC1/RC1',do_erc=True),
            Pin(num='36',name='AN12/RPC3/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/RPC2/PMA2/RC2',do_erc=True),
            Pin(num='37',name='RPC4/PMA4/RC4',do_erc=True),
            Pin(num='18',name='MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RPC5/PMA3/RC5',do_erc=True),
            Pin(num='19',name='PGED3/VREF+/CVREF+/AN0/C3INC/RPA0/CTED1/PMD7/RA0',do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC32MX575F-TQFP64',dest=TEMPLATE,tool=SKIDL,keywords='PIC 32-bit Flash Microcontroller USB CAN',description='PIC32MX575F, 256/512KB + 12KB Flash, 64KB SRAM, USB, CAN, TQFP-64',ref_prefix='U',num_units=1,fplist=['TQFP*'],do_erc=True,pins=[
            Pin(num='1',name='PMD5/RE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PMD6/RE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PMD7/RE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SCK2A/U2BTX/U2ARTS/PMA5/CN8/RG6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SDA2A/SDI2A/U2ARX/PMA4/CN9/RG7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL2A/SDO2A/U2ATX/PMA3/CN10/RG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~MCLR~',do_erc=True),
            Pin(num='8',name='SS2A/U2BRX/U2ACTS/PMA2/CN11/RG9',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='RB15/AN15/OCFB/PMALL/PMA0/CN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RC15/OSC2/CLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='SDA1A/SDI1A/U1ARX/OC3/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PMD0/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB5/AN5/C1IN+/Vbuson/CN7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB8/AN8/C1OUT/SS3A/U3BRX/U3ACTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='AC1TX/SDA3A/SDI3A/U3ARX/PMA9/CN17/RF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='SCL1A/SDO1A/U1ATX/OC4/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PMD1/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB4/AN4/C1IN-/CN6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB9/AN9/C2OUT/PMA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AC1RX/SCL3A/SDO3A/U3AT/PMA8/CN18/RF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='RTCC/IC1/INT1/RD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='OC5/IC5/PMWR/CN13/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PMD2/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB3/AN3/C2IN+/CN5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB10/AN10/CVrefout/TSM/PMA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='USBID/RF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='SS1A/U1BRX/U1ACTS/SDA1/IC2/INT2/RD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PMRD/CN14/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PMD3/RE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB2/AN2/C2IN-/CN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB11/AN11/PMA12/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='VBUS',do_erc=True),
            Pin(num='44',name='SCL1/IC3/PMCS2/PMA15/INT3/RD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='CN15/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PMD4/RE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB1/AN1/Vref-/CVref-/PGEC1/CN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VUSB',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='IC4/PMCS1/PMA14/INT4/RD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='CN16/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB0/AN0/Vref+/CVref+/PGED1/PMA6/CN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='D-/RG3',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='OC1/INT0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VCAP/VDDCORE',func=Pin.PWROUT,do_erc=True),
            Pin(num='17',name='RB6/AN6/OCFA/PGEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RB12/AN12/PMA11/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='D+/RG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='RC13/SOSCI/CN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='RB7/AN7/PGED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RB13/AN13/PMA10/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='RC14/SOSCO/T1CK/CN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='C1RX/RF0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='RB14/AN14/SCK3A/U3BTX/U3ARTS/PMALH/PMA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RC12/OSC1/CLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SCK1A/U1BTX/U1ARTS/OC2/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='C1TX/RF1',func=Pin.BIDIR,do_erc=True)])])