from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

microchip_dspic33dsc = SchLib(tool=SKIDL).add_parts(*[
        Part(name='DSPIC33FJ128GP204',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC',description='40MIPS, 128k Flash, 8k SRAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/EMCD2/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AN12/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='AN11/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='AN10/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='AN9/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWROUT,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ128GP804',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC',description='40MIPS, 128k Flash, 16k SRAM, ECAN, Audio DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/EMCD2/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AN12/DAC1RP/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='AN11/DAC1RN/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='AN10/DAC1LP/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='AN9/DAC1LN/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/DAC1RM/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/DAC1LM/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ128MC204',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC Motor Control',description='40MIPS, 128k Flash, 8k SRAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PWM2H1/RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PWM2L1/RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/PWM1H3/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/PWM1L3/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PWM1H2/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='PWM1L2/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='PWM1H1/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='PWM1L/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ128MC804',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC Motor Control',description='40MIPS, 128k Flash, 16k SRAM, ECAN, 16-bit DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PWM2H1/RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PWM2L1/RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/PWM1H3/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/PWM1L3/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PWM1H2/DAC1RP/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='PWM1L2/DAC1RN/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='PWM1H1/DAC1LP/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='PWM1L/DAC1LN/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/DAC1RM/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/DAC1LM/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ32GP304',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC',description='40MIPS, 32k Flash, 4k SRAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/EMCD2/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AN12/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AN11/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='AN10/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='AN9/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ32MC304',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC Motor Control',description='40MIPS, 32k Flash, 8k SRAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PWM2H1/RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PWM2L1/RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/PWM1H3/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/PWM1L3/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PWM1H2/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='PWM1L2/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='PWM1H1/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='PWM1L/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ64GP204',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC',description='40MIPS, 64k Flash, 8k SRAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/EMCD2/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AN12/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AN11/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='AN10/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='AN9/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ64GP804',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC33',description='40MIPS, 64k Flash, 16k SRAM, ECAN, Audio DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/EMCD2/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AN12/DAC1RP/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AN11/DAC1RN/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='AN10/DAC1LP/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='AN9/DAC1LN/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/DAC1RM/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/DAC1LM/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ64MC204',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC Motor Control',description='40MIPS, 64k Flash, 8k SRAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PWM2H1/RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PWM2L1/RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/PWM1H3/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/PWM1L3/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PWM1H2/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='PWM1L2/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='PWM1H1/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='PWM1L/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='DSPIC33FJ64MC804',dest=TEMPLATE,tool=SKIDL,keywords='16-bit Digital Signal Controller Microchip dsPIC Motor Control',description='40MIPS, 64k Flash, 16k SRAM, ECAN, 16-bit DAC',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA1/RP9/CN21/PMD3/RB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PWM2H1/RP22/CN18/PMA1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PWM2L1/RP23/CN17/PMA0/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RP24/CN20/PMA5/RC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RP25/CN19/PMA6/RC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCAP',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PGED2/PWM1H3/RP10/CN16/PMD2/RB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PGEC2/PWM1L3/RP11/CN15/PMD1/RB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PWM1H2/DAC1RP/RP12/CN14/PMD0/RB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/VREF-/CN3/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI/CN30/RA2',do_erc=True),
            Pin(num='40',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='PWM1L2/DAC1RN/RP13/CN13/PMRD/RB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PGED1/AN2/C2IN-/RP0/CN4/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKO/CN29/RA3',do_erc=True),
            Pin(num='41',name='PGED3/ASDA1/RP5/CN27/PMD7/RB5',do_erc=True),
            Pin(num='12',name='TMS/PMA10/RA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PGEC1/AN3/C2IN+/RP1/CN5/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDO/PMA8/RA8',do_erc=True),
            Pin(num='42',name='PGEC3/ASCL1/RP6/CN24/PMD6/RB6',do_erc=True),
            Pin(num='13',name='TCK/PMA7/RA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN4/C1IN-/RP2/CN6/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SOSCI/RP4/CN1/RB4',do_erc=True),
            Pin(num='43',name='INT0/RP7/CN23/PMD5/RB7',do_erc=True),
            Pin(num='14',name='PWM1H1/DAC1LP/RTCC/RP14/CN12/PMWR/RB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN5/C1IN+/RP3/CN7/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SOSCO/T1CK/CN0/RA4',do_erc=True),
            Pin(num='44',name='SCL1/RP8/CN22/PMD4/RB8',do_erc=True),
            Pin(num='15',name='PWM1L/DAC1LN/RP15/CN11/PMCS1/RB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/DAC1RM/RP16/CN8/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/PMA9/RA9',do_erc=True),
            Pin(num='16',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='AN7/DAC1LM/RP17/CN9/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RP19/CN28/PMBE/RC3',do_erc=True),
            Pin(num='17',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='AN8/CVREF/RP18/PMA2/CN10/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RP20/CN25/PMA4/RC4',do_erc=True),
            Pin(num='18',name='~MCLR',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='38',name='RP21/CN26/PMA3/RC5',do_erc=True),
            Pin(num='19',name='AN0/VREF+/CN2/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)])])