from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

intel = SchLib(tool=SKIDL).add_parts(*[
        Part(name='16450',dest=TEMPLATE,tool=SKIDL,keywords='1ch UART',description='PC8250A, Universal Asynchronous Receiver/Transmitter, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['8250'],pins=[
            Pin(num='1',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCLK',do_erc=True),
            Pin(num='10',name='SIN',do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='INTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='~RD~',do_erc=True),
            Pin(num='31',name='~OUT2~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='CS0',do_erc=True),
            Pin(num='22',name='RD',do_erc=True),
            Pin(num='32',name='~RTS~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CS1',do_erc=True),
            Pin(num='23',name='DDIS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='33',name='~DTR~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~CS2~',do_erc=True),
            Pin(num='24',name='CSOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='~OUT1~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='~BAUDOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='~ADS~',do_erc=True),
            Pin(num='35',name='MR',do_erc=True),
            Pin(num='16',name='XIN',do_erc=True),
            Pin(num='26',name='A2',do_erc=True),
            Pin(num='36',name='~CTS~',do_erc=True),
            Pin(num='17',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='A1',do_erc=True),
            Pin(num='37',name='~DSR~',do_erc=True),
            Pin(num='18',name='~WR~',do_erc=True),
            Pin(num='28',name='A0',do_erc=True),
            Pin(num='38',name='~DCD~',do_erc=True),
            Pin(num='19',name='WR',do_erc=True),
            Pin(num='39',name='~RI~',do_erc=True)]),
        Part(name='16550',dest=TEMPLATE,tool=SKIDL,keywords='1ch UART FIFO',description='PC16550D, Universal Asynchronous Receiver/Transmitter with FIFOs, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCLK',do_erc=True),
            Pin(num='10',name='SIN',do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='INTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='~RD~',do_erc=True),
            Pin(num='31',name='~OUT2~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='CS0',do_erc=True),
            Pin(num='22',name='RD',do_erc=True),
            Pin(num='32',name='~RTS~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CS1',do_erc=True),
            Pin(num='23',name='DDIS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='33',name='~DTR~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~CS2~',do_erc=True),
            Pin(num='24',name='~TXRDY~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='~OUT1~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='~BAUDOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='~ADS~',do_erc=True),
            Pin(num='35',name='MR',do_erc=True),
            Pin(num='16',name='XIN',do_erc=True),
            Pin(num='26',name='A2',do_erc=True),
            Pin(num='36',name='~CTS~',do_erc=True),
            Pin(num='17',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='A1',do_erc=True),
            Pin(num='37',name='~DSR~',do_erc=True),
            Pin(num='18',name='~WR~',do_erc=True),
            Pin(num='28',name='A0',do_erc=True),
            Pin(num='38',name='~DCD~',do_erc=True),
            Pin(num='19',name='WR',do_erc=True),
            Pin(num='29',name='~RXRDY~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='~RI~',do_erc=True)]),
        Part(name='8035',dest=TEMPLATE,tool=SKIDL,keywords='MCS-48 uC Microcontroller',description='MCS-48 8-bit Microcontroller, 4KB Mask ROM, 256B RAM, DIP-40',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['8039', '8040', '8048', '8049', '8050'],pins=[
            Pin(num='1',name='T0',do_erc=True),
            Pin(num='2',name='X1',do_erc=True),
            Pin(num='3',name='X2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~RESET~',do_erc=True),
            Pin(num='5',name='~SS~',do_erc=True),
            Pin(num='6',name='~INT~',do_erc=True),
            Pin(num='7',name='EA',do_erc=True),
            Pin(num='8',name='~RD~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~PSEN~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~WR~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='DB.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DB.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DB.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DB.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PROG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DB.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='DB.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='DB.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DB.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='T1',do_erc=True)]),
        Part(name='8086_Max_Mode',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='8086 (maximum mode), 16-Bit HMOS Microprocessor, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='~RQ~/~GT1~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RESET',do_erc=True),
            Pin(num='31',name='~RQ~/~GT0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='READY',do_erc=True),
            Pin(num='32',name='~RD~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~TEST~',do_erc=True),
            Pin(num='33',name='MN/~MX~',do_erc=True),
            Pin(num='14',name='AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='QS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='~BHE~/S7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='QS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='A19/S6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~S0~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='A18/S5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='NMI',do_erc=True),
            Pin(num='27',name='~S1~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='A17/S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='INTR',do_erc=True),
            Pin(num='28',name='~S2~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='A16/S3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='CLK',do_erc=True),
            Pin(num='29',name='~LOCK~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='AD15',func=Pin.BIDIR,do_erc=True)]),
        Part(name='8086_Min_Mode',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='8086 (minimum mode), 16-Bit HMOS Microprocessor, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='HLDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RESET',do_erc=True),
            Pin(num='31',name='HOLD',do_erc=True),
            Pin(num='12',name='AD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='READY',do_erc=True),
            Pin(num='32',name='~RD~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~TEST~',do_erc=True),
            Pin(num='33',name='MN/~MX~',do_erc=True),
            Pin(num='14',name='AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~INTA~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='~BHE~/S7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='A19/S6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~DEN~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='A18/S5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='NMI',do_erc=True),
            Pin(num='27',name='DT/~R~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='A17/S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='INTR',do_erc=True),
            Pin(num='28',name='M/~IO~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='A16/S3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='CLK',do_erc=True),
            Pin(num='29',name='~WR~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='AD15',func=Pin.BIDIR,do_erc=True)]),
        Part(name='8087',dest=TEMPLATE,tool=SKIDL,keywords='FPU',description='Math Coprocessor for Intel 8086/8088/80186/80188 microprocessors, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='AD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RESET',do_erc=True),
            Pin(num='31',name='~RQ~/~GT0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='READY',do_erc=True),
            Pin(num='32',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='BUSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='33',name='~RQ~/~GT1~',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='QS1',do_erc=True),
            Pin(num='34',name='~BHE~/S7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='QS0',do_erc=True),
            Pin(num='35',name='A19/S6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~S0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='A18/S5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='27',name='~S1~',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='A17/S4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='28',name='~S2~',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='A16/S3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='CLK',do_erc=True),
            Pin(num='29',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='39',name='AD15',func=Pin.BIDIR,do_erc=True)]),
        Part(name='8088',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='8088 (minimum mode), 8-Bit HMOS Microprocessor, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['8088_Min_Mode'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='A13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='A12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='A11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='A10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='A9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='A8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='HLDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RESET',do_erc=True),
            Pin(num='31',name='HOLD',do_erc=True),
            Pin(num='12',name='AD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='READY',do_erc=True),
            Pin(num='32',name='~RD~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~TEST~',do_erc=True),
            Pin(num='33',name='MN/~MX~',do_erc=True),
            Pin(num='14',name='AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~INTA~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='~SSO~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='A19/S6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='DEN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='A18/S5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='NMI',do_erc=True),
            Pin(num='27',name='DT/~R~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='A17/S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='INTR',do_erc=True),
            Pin(num='28',name='IO/~M~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='A16/S3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='CLK',do_erc=True),
            Pin(num='29',name='WR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='A15',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='8088_Max_Mode',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='8088 (maximum mode), 8-Bit HMOS Microprocessor, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='A13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='A12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='A11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='A10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='A9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='A8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='~RQ~/~GT1~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RESET',do_erc=True),
            Pin(num='31',name='~RQ~/~GT0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='READY',do_erc=True),
            Pin(num='32',name='~RD~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~TEST~',do_erc=True),
            Pin(num='33',name='MN/~MX~',do_erc=True),
            Pin(num='14',name='AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='QS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='HIGH',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='QS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='A19/S6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~S0~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='A18/S5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='NMI',do_erc=True),
            Pin(num='27',name='~S1~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='A17/S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='INTR',do_erc=True),
            Pin(num='28',name='~S2~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='A16/S3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='CLK',do_erc=True),
            Pin(num='29',name='~LOCK~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='A15',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='8252',dest=TEMPLATE,tool=SKIDL,keywords='UART Serial Interface',description='Universal Asynchronous Receiver/Transmitter, PDIP-28',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='~RD~',do_erc=True),
            Pin(num='2',name='~WR~',do_erc=True),
            Pin(num='3',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='~RTS~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='A0',do_erc=True),
            Pin(num='21',name='CO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='A1',do_erc=True),
            Pin(num='22',name='TBRE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='IX',do_erc=True),
            Pin(num='23',name='RST',do_erc=True),
            Pin(num='14',name='OX',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='INTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='(TXD)SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='(RXD)SDI',do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='DR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='~CTS~',do_erc=True),
            Pin(num='27',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='~DSR~',do_erc=True),
            Pin(num='28',name='CS0',do_erc=True),
            Pin(num='19',name='~DTR~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='8255',dest=TEMPLATE,tool=SKIDL,keywords='8255 PPI',description='CHMOS Programmable Peripheral Interface, PDIP-40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['8255A', '82C55A'],pins=[
            Pin(num='1',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='~RD~',do_erc=True),
            Pin(num='6',name='~CS~',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='A1',do_erc=True),
            Pin(num='9',name='A0',do_erc=True),
            Pin(num='10',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RESET',do_erc=True),
            Pin(num='16',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='~WR~',do_erc=True),
            Pin(num='17',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PA5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='8259',dest=TEMPLATE,tool=SKIDL,keywords='PIC',description='8259, Programmable Interrupt Controller, PDIP-28',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['8259A', '8259A-2'],pins=[
            Pin(num='1',name='~CS~',do_erc=True),
            Pin(num='2',name='~RD~',do_erc=True),
            Pin(num='3',name='~WR~',do_erc=True),
            Pin(num='4',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IR2',do_erc=True),
            Pin(num='11',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IR3',do_erc=True),
            Pin(num='12',name='CAS0',do_erc=True),
            Pin(num='22',name='IR4',do_erc=True),
            Pin(num='13',name='CAS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='IR5',do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='IR6',do_erc=True),
            Pin(num='15',name='CAS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='IR7',do_erc=True),
            Pin(num='16',name='~SP~/~EN~',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~INTA~',do_erc=True),
            Pin(num='17',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='A0',do_erc=True),
            Pin(num='18',name='IR0',do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='IR1',do_erc=True)]),
        Part(name='82720',dest=TEMPLATE,tool=SKIDL,keywords='Graphics Controller',description='Graphics Display Controller, PDIP-40',ref_prefix='U',num_units=1,fplist=['PDIP*', 'DIP*'],do_erc=True,pins=[
            Pin(num='1',name='2xWCLK',do_erc=True),
            Pin(num='2',name='~DBIN',do_erc=True),
            Pin(num='3',name='HSYNC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VSYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='BLANK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='(ALE)~RAS~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='DREQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~DACK~',do_erc=True),
            Pin(num='9',name='~RD~',do_erc=True),
            Pin(num='10',name='~WR~',do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='AD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='A0',do_erc=True),
            Pin(num='21',name='LPEN',do_erc=True),
            Pin(num='31',name='AD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='DB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='AD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='AD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='AD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='AD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='AD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='AD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='DB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='AD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='DB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='AD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='A16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='DB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='A17',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='8284',dest=TEMPLATE,tool=SKIDL,keywords='Clock Generator',description='Clock Generator and Driver for i8086/88 Microcontrollers, PDIP-18',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'PDIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='CSYNC',do_erc=True),
            Pin(num='2',name='PCLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~AEN1~',do_erc=True),
            Pin(num='4',name='RDY1',do_erc=True),
            Pin(num='5',name='READY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='RDY2',do_erc=True),
            Pin(num='7',name='~AEN2~',do_erc=True),
            Pin(num='8',name='CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='RESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~RES~',do_erc=True),
            Pin(num='12',name='OSC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='F/~C~',do_erc=True),
            Pin(num='14',name='EFI',do_erc=True),
            Pin(num='15',name='~ASYNC~',do_erc=True),
            Pin(num='16',name='X2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='X1',do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='8288',dest=TEMPLATE,tool=SKIDL,keywords='Bus Controller',description='Bus Controller for Intel 8086/8088/80186/80188 microprocessors, DIP-20',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'PDIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='IOB',do_erc=True),
            Pin(num='2',name='CLK',do_erc=True),
            Pin(num='3',name='~S1~',do_erc=True),
            Pin(num='4',name='DT/~R~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~AEN~',do_erc=True),
            Pin(num='7',name='~MRDC~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~AMWC~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~MWTC~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~IOWC~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~AIOWC~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~IORC~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~INTA~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='CEN',do_erc=True),
            Pin(num='16',name='DEN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='MCE/~PDEN~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='~S2~',do_erc=True),
            Pin(num='19',name='~S0~',do_erc=True)]),
        Part(name='82C54_PLCC',dest=TEMPLATE,tool=SKIDL,keywords='Timer Counter',description='82C54, Triple Channel Timer/Counter, PLCC-28',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='D7',do_erc=True),
            Pin(num='3',name='D6',do_erc=True),
            Pin(num='4',name='D5',do_erc=True),
            Pin(num='5',name='D4',do_erc=True),
            Pin(num='6',name='D3',do_erc=True),
            Pin(num='7',name='D2',do_erc=True),
            Pin(num='8',name='D1',do_erc=True),
            Pin(num='9',name='D0',do_erc=True),
            Pin(num='10',name='CLK0',do_erc=True),
            Pin(num='20',name='OUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='CLK2',do_erc=True),
            Pin(num='12',name='OUT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='A0',do_erc=True),
            Pin(num='13',name='G0',do_erc=True),
            Pin(num='23',name='A1',do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='~CS~',do_erc=True),
            Pin(num='16',name='OUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='~RD~',do_erc=True),
            Pin(num='17',name='G1',do_erc=True),
            Pin(num='27',name='~WR~',do_erc=True),
            Pin(num='18',name='CLK1',do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='G2',do_erc=True)]),
        Part(name='82C55A_PLCC',dest=TEMPLATE,tool=SKIDL,keywords='8255 PPI',description='CHMOS Programmable Peripheral Interface, PLCC-44',ref_prefix='U',num_units=1,fplist=['*PLCC?44*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='~RD~',do_erc=True),
            Pin(num='7',name='~CS~',do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='~WR~',do_erc=True),
            Pin(num='11',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='22',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='33',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='44',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='RESET',do_erc=True)]),
        Part(name='8748',dest=TEMPLATE,tool=SKIDL,keywords='MCS-48 uC Microcontroller',description='i8748, MCS-48 8-bit Microcontroller with Internal EPROM, 2KB EPROM, 128B RAM, DIP-40',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['8749'],pins=[
            Pin(num='1',name='T0',do_erc=True),
            Pin(num='2',name='X1',do_erc=True),
            Pin(num='3',name='X2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~RESET~',do_erc=True),
            Pin(num='5',name='~SS~',do_erc=True),
            Pin(num='6',name='~INT~',do_erc=True),
            Pin(num='7',name='EA',do_erc=True),
            Pin(num='8',name='~RD~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~PSEN~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~WR~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='ALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='DB.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DB.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DB.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DB.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PROG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DB.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='Vpp/VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='DB.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='DB.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DB.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='T1',do_erc=True)]),
        Part(name='I386EX_PQFP',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Intel I386EX Embedded microprocessor, PQFP-132',ref_prefix='U',num_units=1,fplist=['PQFP*'],do_erc=True,pins=[
            Pin(num='1',name='UCS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='CS6/REFRESH',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='LBA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='D12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='WR/RD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='ADS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='A7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='60',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='70',name='A24',func=Pin.TRISTATE,do_erc=True),
            Pin(num='80',name='INT0/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='NMI',do_erc=True),
            Pin(num='11',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='D13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='NA',do_erc=True),
            Pin(num='51',name='A8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='61',name='A17/CAS1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='71',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='ERROR/TMROUT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='D14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='READY',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='A1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='52',name='A9',func=Pin.TRISTATE,do_erc=True),
            Pin(num='62',name='A18/CAS2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='72',name='A25',func=Pin.TRISTATE,do_erc=True),
            Pin(num='82',name='INT1/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='BUSY/TMRGATE2',do_erc=True),
            Pin(num='13',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='D15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='33',name='BS8',do_erc=True),
            Pin(num='43',name='A2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='53',name='A10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='63',name='A19',func=Pin.TRISTATE,do_erc=True),
            Pin(num='73',name='SMI',do_erc=True),
            Pin(num='83',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='INT4/TMRCLK0',do_erc=True),
            Pin(num='14',name='D8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='RD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='A3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='54',name='A11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='64',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='TMROUT0/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='INT2/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='INT5/TMRGATE0',do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='TDI',do_erc=True),
            Pin(num='35',name='WR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='A4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='55',name='A12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='65',name='A20',func=Pin.TRISTATE,do_erc=True),
            Pin(num='75',name='TMROUT1/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='INT3/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='INT6/TMRCLK1',do_erc=True),
            Pin(num='16',name='D9',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='TMS',do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='56',name='A13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='66',name='A21',func=Pin.TRISTATE,do_erc=True),
            Pin(num='76',name='TCK',do_erc=True),
            Pin(num='86',name='PWRDWN/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='INT7/TMRGATE1',do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='M/IO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='BLE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='A14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='67',name='A22',func=Pin.TRISTATE,do_erc=True),
            Pin(num='77',name='SRXCLK/DTR1',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='COMCLK/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='D10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='A5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='58',name='A15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='68',name='A23',func=Pin.TRISTATE,do_erc=True),
            Pin(num='78',name='SSIORX/RI1',do_erc=True),
            Pin(num='88',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='STXCLK/DSR1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='D11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='D/C',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='BHE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='A6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='59',name='A16/CAS0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='SSIOTX/RST1',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PEREQ/TMRCLK2',do_erc=True),
            Pin(num='99',name='FLT',do_erc=True),
            Pin(num='100',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='110',name='RESET',do_erc=True),
            Pin(num='120',name='SMIACT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='130',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='101',name='DCD0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='HLDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='TXD0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='RTS0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='DACK1/TXD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='122',name='CS0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='CTS0/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='EOP/CTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='CS1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='DTR0/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='WDTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='124',name='CS2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='DSR0/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='CLK2',do_erc=True),
            Pin(num='125',name='CS3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='RI0/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='126',name='CS4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='LOCK/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='DRQ0/DCD1',do_erc=True),
            Pin(num='127',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='HOLD/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='DRQ1/RXD1',do_erc=True),
            Pin(num='128',name='DACK0/CS5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='109',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='119',name='TRST',do_erc=True),
            Pin(num='129',name='RDX0/P2.5',func=Pin.BIDIR,do_erc=True)])])