from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

analog_devices = SchLib(tool=SKIDL).add_parts(*[
        Part(name='AD623AN',dest=TEMPLATE,tool=SKIDL,keywords='ad623 instumentation amplifier dip-8',description='Single Supply, Rail to Rail, Instumentation Amplifier, RoHS, DIP-8',ref_prefix='U',num_units=1,fplist=['DIP-8*'],do_erc=True,aliases=['AD623BN', 'AD623ANZ', 'AD623BNZ'],pins=[
            Pin(num='1',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='Vs-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Ref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Vs+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Rg',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD623AR',dest=TEMPLATE,tool=SKIDL,keywords='ad623 instumentation amplifier soic-8',description='Single Supply, Rail to Rail, Instumentation Amplifier, RoHS, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC-8*'],do_erc=True,aliases=['AD623ARZ', 'AD623BR', 'AD623BRZ'],pins=[
            Pin(num='1',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='Vs-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Ref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Vs+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Rg',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD623ARM',dest=TEMPLATE,tool=SKIDL,keywords='ad623 instumentation amplifier msop-8',description='Single Supply, Rail to Rail, Instumentation Amplifier, RoHS, MSOP-8',ref_prefix='U',num_units=1,fplist=['MSOP-8*'],do_erc=True,aliases=['AD623ARMZ'],pins=[
            Pin(num='1',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='-',do_erc=True),
            Pin(num='3',name='+',do_erc=True),
            Pin(num='4',name='Vs-',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Ref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Vs+',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Rg',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD8422ARMZ',dest=TEMPLATE,tool=SKIDL,keywords='ad8422 instumentation amplifier msop-8',description='Low Power, Rail to Rail, Instumentation Amplifier, MSOP-8',ref_prefix='U',num_units=1,fplist=['MSOP-8*'],do_erc=True,aliases=['AD8422BRMZ', 'AD8421ARMZ', 'AD8421BRMZ', 'AD8236ARMZ'],pins=[
            Pin(num='1',name='-',do_erc=True),
            Pin(num='2',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='+',do_erc=True),
            Pin(num='5',name='Vs-',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Ref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Vs+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AD8422ARZ',dest=TEMPLATE,tool=SKIDL,keywords='ad8429 instumentation amplifier soic-8',description='Low Noise, Instumentation Amplifier, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC-8*'],do_erc=True,aliases=['AD8422BRZ', 'AD8421ARZ', 'AD8421BRZ', 'AD8429ARZ', 'AD8429BRZ'],pins=[
            Pin(num='1',name='-',do_erc=True),
            Pin(num='2',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Rg',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='+',do_erc=True),
            Pin(num='5',name='Vs-',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Ref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Vs+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADE7758',dest=TEMPLATE,tool=SKIDL,keywords='Energy Metering',description='Poly Phase Multifunction Energy Metering, SO-24',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x15.4mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='APCF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='IAP',do_erc=True),
            Pin(num='6',name='IAN',do_erc=True),
            Pin(num='7',name='IBP',do_erc=True),
            Pin(num='8',name='IBN',do_erc=True),
            Pin(num='9',name='ICP',do_erc=True),
            Pin(num='10',name='ICN',do_erc=True),
            Pin(num='20',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='~CS',do_erc=True),
            Pin(num='12',name='REFIN/OUT',do_erc=True),
            Pin(num='22',name='DIN',do_erc=True),
            Pin(num='13',name='VN',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='SCLK',do_erc=True),
            Pin(num='14',name='VCP',do_erc=True),
            Pin(num='24',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='VBP',do_erc=True),
            Pin(num='16',name='VAP',do_erc=True),
            Pin(num='17',name='VARCF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='~IRQ',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='19',name='CLKIN',do_erc=True)]),
        Part(name='ADM2484E',dest=TEMPLATE,tool=SKIDL,keywords='RS485 Transceiver RS422 Transceiver',description='Isolated RS485/RS422 Transceiver, Half-/Full-Duplex, 500kbps,SOIC-16W',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x10.3mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='RxD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~RE',do_erc=True),
            Pin(num='5',name='DE',do_erc=True),
            Pin(num='6',name='TxD',do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='11',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Z',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='B',do_erc=True),
            Pin(num='14',name='A',do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADM2587E',dest=TEMPLATE,tool=SKIDL,keywords='RS485 Transciever,RS422 Transciever',description='Isolated RS485/RS422 Transciever,Integrated Isolated DC-DC Converter, 500kbps,SO-20',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x12.8mm*Pitch1.27mm*'],do_erc=True,aliases=['ADM2582E'],pins=[
            Pin(num='1',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RxD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~RE',do_erc=True),
            Pin(num='6',name='DE',do_erc=True),
            Pin(num='7',name='TxD',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='Visoout',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='Z',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='B',do_erc=True),
            Pin(num='18',name='A',do_erc=True),
            Pin(num='19',name='Visoin',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADuM1410',dest=TEMPLATE,tool=SKIDL,keywords='Digital Isolator',description='Quad Channel Digital Isolator,10Mbps,SO-16',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x10.3mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VIA',do_erc=True),
            Pin(num='4',name='VIB',do_erc=True),
            Pin(num='5',name='VIC',do_erc=True),
            Pin(num='6',name='VID',do_erc=True),
            Pin(num='7',name='DISABLE',do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='CTRL2',do_erc=True),
            Pin(num='11',name='VOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='VOC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='VOB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VOA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADuM1411',dest=TEMPLATE,tool=SKIDL,keywords='Digital Isolator',description='Quad Channel Digital Isolator,10Mbps,SO-16',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x10.3mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VIA',do_erc=True),
            Pin(num='4',name='VIB',do_erc=True),
            Pin(num='5',name='VIC',do_erc=True),
            Pin(num='6',name='VOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CTRL1',do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='CTRL2',do_erc=True),
            Pin(num='11',name='VID',do_erc=True),
            Pin(num='12',name='VOC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='VOB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VOA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADuM1412',dest=TEMPLATE,tool=SKIDL,keywords='Digital Isolator',description='Quad Channel Digital Isolator,10Mbps,SO-16',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x10.3mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VIA',do_erc=True),
            Pin(num='4',name='VIB',do_erc=True),
            Pin(num='5',name='VOC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CTRL1',do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='CTRL2',do_erc=True),
            Pin(num='11',name='VID',do_erc=True),
            Pin(num='12',name='VIC',do_erc=True),
            Pin(num='13',name='VOB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VOA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADuM6000',dest=TEMPLATE,tool=SKIDL,keywords='Isolated DC-to-DC Converter 5kV',description='Isolated 5 kV DC-to-DC Converter',ref_prefix='U',num_units=1,fplist=['SO-16-W*'],do_erc=True,pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='RC_IN',do_erc=True),
            Pin(num='5',name='RC_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='RC_SEL',do_erc=True),
            Pin(num='7',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND_ISO',func=Pin.PWROUT,do_erc=True),
            Pin(num='10',name='V_ISO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='V_SEL',do_erc=True),
            Pin(num='14',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='15',name='GND_ISO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='V_ISO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='ADuM7643',dest=TEMPLATE,tool=SKIDL,keywords='6Ch Quad Digital Isolator 25Mbps',description='Low Power Six-Channel 3/3 Digital Isolator, 25Mbps 6ns, Fail-Safe High, QSOP20',ref_prefix='U',num_units=1,fplist=['QSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD1A',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='INA',do_erc=True),
            Pin(num='4',name='INB',do_erc=True),
            Pin(num='5',name='OUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='OUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VDD1B',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUTE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='INF',do_erc=True),
            Pin(num='10',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VDD2A',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='OUTF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='INE',do_erc=True),
            Pin(num='14',name='VDD2B',do_erc=True),
            Pin(num='15',name='IND',do_erc=True),
            Pin(num='16',name='INC',do_erc=True),
            Pin(num='17',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='GND2',func=Pin.PWRIN,do_erc=True)])])