/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.core.lattice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.co.shineware.nlp.komoran.c.a;
import kr.co.shineware.nlp.komoran.core.lattice.model.LatticeNode;
import kr.co.shineware.nlp.komoran.modeler.model.PosTable;
import kr.co.shineware.nlp.komoran.modeler.model.Transition;
import kr.co.shineware.util.common.model.Pair;

public class Lattice {
    private Map lattice;
    private Transition transition;
    private PosTable table;
    private a unitParser;
    private int totalIdx = -1;
    private int prevStartIdx = 0;
    private int nbest = 1;
    private static final String ANSWER_SPLITER = " ";
    private static final String WORD_POS_SPLITER = "\\/";

    public Lattice(PosTable posTable) {
        this.table = posTable;
        this.init();
    }

    public void init() {
        this.lattice = null;
        this.lattice = new HashMap();
        HashMap<Integer, LatticeNode> hashMap = new HashMap<Integer, LatticeNode>();
        LatticeNode latticeNode = new LatticeNode();
        latticeNode.setMorph("<start>");
        latticeNode.setPosId(this.table.getId("<start>"));
        latticeNode.setScore(0.0);
        hashMap.put(latticeNode.hashCode(), latticeNode);
        this.lattice.put(0, hashMap);
        this.unitParser = new a();
        this.prevStartIdx = 0;
    }

    public void put(int n, int n2, List list2, String string) {
        for (List list2 : list2) {
            this.put(n, n2, string, (Integer)list2.getFirst(), (Double)list2.getSecond());
        }
    }

    public void put(int n, int n2, String string, int n3, double d) {
        this.put(n, n2, string, n3, n3, d);
    }

    public void put(int n, int n2, String string, int n3, int n4, double d) {
        Object object = (Map)this.lattice.get(n);
        if (object != null) {
            if (this.nbest > 1) {
                object = this.getNBestPrevNodes((Map)object, string, n3);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    LatticeNode latticeNode = (LatticeNode)iterator.next();
                    if (latticeNode == null) continue;
                    HashMap<Integer, LatticeNode> hashMap = (HashMap<Integer, LatticeNode>)this.lattice.get(n2);
                    if (hashMap == null) {
                        hashMap = new HashMap<Integer, LatticeNode>();
                    }
                    LatticeNode latticeNode2 = new LatticeNode();
                    latticeNode2.setMorph(string);
                    latticeNode2.setPosId(n4);
                    double d2 = latticeNode.getScore() + this.transition.get(latticeNode.getPosId(), n3) + d;
                    latticeNode2.setScore(d2);
                    latticeNode2.setPrevIdx(n);
                    latticeNode2.setPrevHashcode(latticeNode.hashCode());
                    hashMap.put(latticeNode2.hashCode(), latticeNode2);
                    this.lattice.put(n2, hashMap);
                    this.totalIdx = Math.max(this.totalIdx, n2);
                }
                return;
            }
            if ((object = this.getMaxPrevNode((Map)object, string, n3)) != null) {
                HashMap<Integer, LatticeNode> hashMap = (HashMap<Integer, LatticeNode>)this.lattice.get(n2);
                if (hashMap == null) {
                    hashMap = new HashMap<Integer, LatticeNode>();
                }
                LatticeNode latticeNode = new LatticeNode();
                latticeNode.setMorph(string);
                latticeNode.setPosId(n4);
                double d3 = ((LatticeNode)object).getScore() + this.transition.get(((LatticeNode)object).getPosId(), n3) + d;
                latticeNode.setScore(d3);
                latticeNode.setPrevIdx(n);
                latticeNode.setPrevHashcode(((LatticeNode)object).hashCode());
                hashMap.put(latticeNode.hashCode(), latticeNode);
                this.lattice.put(n2, hashMap);
                this.totalIdx = Math.max(this.totalIdx, n2);
            }
        }
    }

    private List getNBestPrevNodes(Map entry, String string, int n) {
        ArrayList<LatticeNode> arrayList = new ArrayList<LatticeNode>(this.nbest);
        entry = entry.entrySet();
        Iterator iterator = entry.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            double d = ((LatticeNode)entry.getValue()).getScore();
            int n2 = ((LatticeNode)entry.getValue()).getPosId();
            Double d2 = this.transition.get(n2, n);
            if (d2 == null || (n != this.table.getId("JKO") ? (n == this.table.getId("JKS") || n == this.table.getId("JKC")) && (!this.hasJongsung(((LatticeNode)entry.getValue()).getMorph()) ? string.equals("\u3147\u3163") : string.equals("\u3131\u314f")) : (this.hasJongsung(((LatticeNode)entry.getValue()).getMorph()) ? string.charAt(0) != '\u3147' : string.charAt(0) == '\u3147'))) continue;
            if (arrayList.size() < this.nbest) {
                arrayList.add((LatticeNode)entry.getValue());
                continue;
            }
            int n3 = 0;
            double d3 = ((LatticeNode)arrayList.get(0)).getScore();
            int n4 = 1;
            while (n4 < arrayList.size()) {
                if (d3 > ((LatticeNode)arrayList.get(n4)).getScore()) {
                    n3 = n4;
                    d3 = ((LatticeNode)arrayList.get(n4)).getScore();
                }
                ++n4;
            }
            if (!(d + d2 > d3)) continue;
            arrayList.set(n3, (LatticeNode)entry.getValue());
        }
        return arrayList;
    }

    private LatticeNode getMaxPrevNode(Map object, String string, int n) {
        object = object.entrySet();
        double d = Double.NEGATIVE_INFINITY;
        LatticeNode latticeNode = null;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            double d2 = ((LatticeNode)object.getValue()).getScore();
            int n2 = ((LatticeNode)object.getValue()).getPosId();
            Double d3 = this.transition.get(n2, n);
            if (d3 == null || (n != this.table.getId("JKO") ? (n == this.table.getId("JKS") || n == this.table.getId("JKC")) && (!this.hasJongsung(((LatticeNode)object.getValue()).getMorph()) ? string.equals("\u3147\u3163") : string.equals("\u3131\u314f")) : (this.hasJongsung(((LatticeNode)object.getValue()).getMorph()) ? string.charAt(0) != '\u3147' : string.charAt(0) == '\u3147'))) continue;
            if (!(d2 + d3 > d)) continue;
            d = d2 + d3;
            latticeNode = (LatticeNode)object.getValue();
        }
        return latticeNode;
    }

    private boolean hasJongsung(String string) {
        char c = string.charAt(string.length() - 1);
        if ('\u3131' <= c && c <= '\u314e') {
            return c != '\u3138' && c != '\u3143' && c != '\u3149';
        }
        return false;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public List getNbest(String string) {
        HashMap<Integer, LatticeNode> hashMap = (HashMap<Integer, LatticeNode>)this.lattice.get(this.totalIdx);
        if (hashMap == null) {
            hashMap = new HashMap<Integer, LatticeNode>();
            Object object = ((Map)this.lattice.get(this.getPrevStartIdx())).keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                LatticeNode latticeNode = new LatticeNode();
                latticeNode.setMorph(string.substring(this.getPrevStartIdx(), this.totalIdx));
                latticeNode.setPosId(this.table.getId("NA"));
                latticeNode.setPrevHashcode((Integer)object);
                latticeNode.setPrevIdx(this.getPrevStartIdx());
                latticeNode.setScore(-10000.0);
                hashMap.put(latticeNode.hashCode(), latticeNode);
            }
            this.lattice.put(this.totalIdx, hashMap);
        }
        this.updateEndTransition(hashMap, string);
        if (this.lattice.get(this.totalIdx + 1) == null) {
            return null;
        }
        return this.backTrackingNbest();
    }

    public List getMax(String string) {
        HashMap<Integer, LatticeNode> hashMap = (HashMap<Integer, LatticeNode>)this.lattice.get(this.totalIdx);
        if (hashMap == null) {
            hashMap = new HashMap<Integer, LatticeNode>();
            Object object = ((Map)this.lattice.get(this.getPrevStartIdx())).keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                LatticeNode latticeNode = new LatticeNode();
                latticeNode.setMorph(string.substring(this.getPrevStartIdx(), this.totalIdx));
                latticeNode.setPosId(this.table.getId("NA"));
                latticeNode.setPrevHashcode((Integer)object);
                latticeNode.setPrevIdx(this.getPrevStartIdx());
                latticeNode.setScore(-10000.0);
                hashMap.put(latticeNode.hashCode(), latticeNode);
            }
            this.lattice.put(this.totalIdx, hashMap);
        }
        this.updateEndTransition(hashMap, string);
        if (this.lattice.get(this.totalIdx + 1) == null) {
            return null;
        }
        return this.backTracking();
    }

    private List backTrackingNbest() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<LatticeNode> hashSet = new HashSet<LatticeNode>();
        int n = 0;
        while (n < this.nbest) {
            Object object;
            double d = Double.NEGATIVE_INFINITY;
            Object object2 = null;
            Map.Entry entry = (Map)this.lattice.get(this.totalIdx + 1);
            entry = entry.entrySet();
            Object object3 = entry.iterator();
            while (object3.hasNext()) {
                entry = object3.next();
                object = (LatticeNode)entry.getValue();
                if (hashSet.contains(object) || !(d < ((LatticeNode)object).getScore())) continue;
                d = ((LatticeNode)object).getScore();
                object2 = object;
            }
            if (object2 != null) {
                hashSet.add((LatticeNode)object2);
                entry = new ArrayList();
                object3 = object2;
                do {
                    object3 = (LatticeNode)((Map)this.lattice.get(((LatticeNode)object3).getPrevIdx())).get(((LatticeNode)object3).getPrevHashcode());
                    entry.add(object3);
                } while (((LatticeNode)object3).getPrevIdx() != 0);
                object = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                int n2 = entry.size() - 1;
                while (n2 >= 0) {
                    if (((LatticeNode)entry.get(n2)).getMorph().trim().equals("<sp>")) {
                        if (arrayList2.size() != 0) {
                            object.add(arrayList2);
                        }
                        arrayList2 = new ArrayList();
                    } else {
                        object2 = String.valueOf(((LatticeNode)entry.get(n2)).getMorph()) + "/" + this.table.getPos(((LatticeNode)entry.get(n2)).getPosId());
                        try {
                            this.parseAnswer((String)object2, arrayList2);
                        }
                        catch (kr.co.shineware.nlp.komoran.a.a a2) {
                            object2 = a2;
                            a2.printStackTrace();
                        }
                    }
                    --n2;
                }
                if (arrayList2.size() != 0) {
                    object.add(arrayList2);
                }
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    private List backTracking() {
        Object object;
        ArrayList arrayList = null;
        double d = Double.NEGATIVE_INFINITY;
        Map.Entry entry = (Map)this.lattice.get(this.totalIdx + 1);
        entry = entry.entrySet();
        Object object2 = entry.iterator();
        while (object2.hasNext()) {
            entry = object2.next();
            object = (LatticeNode)entry.getValue();
            if (!(d < ((LatticeNode)object).getScore())) continue;
            d = ((LatticeNode)object).getScore();
            arrayList = object;
        }
        if (arrayList != null) {
            entry = new ArrayList();
            object2 = arrayList;
            do {
                object2 = (LatticeNode)((Map)this.lattice.get(((LatticeNode)object2).getPrevIdx())).get(((LatticeNode)object2).getPrevHashcode());
                entry.add(object2);
            } while (((LatticeNode)object2).getPrevIdx() != 0);
            object = new ArrayList();
            arrayList = new ArrayList();
            int n = entry.size() - 1;
            while (n >= 0) {
                if (((LatticeNode)entry.get(n)).getMorph().trim().equals("<sp>")) {
                    if (arrayList.size() != 0) {
                        object.add(arrayList);
                    }
                    arrayList = new ArrayList();
                } else {
                    Object object3 = String.valueOf(((LatticeNode)entry.get(n)).getMorph()) + "/" + this.table.getPos(((LatticeNode)entry.get(n)).getPosId());
                    try {
                        this.parseAnswer((String)object3, arrayList);
                    }
                    catch (kr.co.shineware.nlp.komoran.a.a a2) {
                        object3 = a2;
                        a2.printStackTrace();
                    }
                }
                --n;
            }
            if (arrayList.size() != 0) {
                object.add(arrayList);
            }
            return object;
        }
        return null;
    }

    private void updateEndTransition(Map object, String string) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        object = object.entrySet();
        boolean bl = false;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            object = (LatticeNode)object.getValue();
            double d = ((LatticeNode)object).getScore();
            int n = ((LatticeNode)object).getPosId();
            Double d2 = this.transition.get(n, this.table.getId("<end>"));
            if (d2 == null) continue;
            if (n == this.table.getId("NA")) {
                d2 = -10000.0;
            }
            bl = true;
            LatticeNode latticeNode = new LatticeNode();
            latticeNode.setMorph("<end>");
            latticeNode.setPosId(this.table.getId("<end>"));
            latticeNode.setPrevIdx(this.totalIdx);
            latticeNode.setPrevHashcode(((LatticeNode)object).hashCode());
            latticeNode.setScore(d + d2);
            hashMap.put(latticeNode.hashCode(), latticeNode);
            this.lattice.put(this.totalIdx + 1, hashMap);
        }
        if (!bl) {
            object = new HashMap();
            object2 = new LatticeNode();
            ((LatticeNode)object2).setMorph(string.substring(this.prevStartIdx, this.totalIdx));
            ((LatticeNode)object2).setPosId(this.table.getId("NA"));
            ((LatticeNode)object2).setPrevHashcode((Integer)((Map)this.lattice.get(this.prevStartIdx)).keySet().iterator().next());
            ((LatticeNode)object2).setPrevIdx(this.prevStartIdx);
            ((LatticeNode)object2).setScore(-10000.0);
            object.put(((LatticeNode)object2).hashCode(), object2);
            this.lattice.put(this.totalIdx, object);
            object = new LatticeNode();
            ((LatticeNode)object).setMorph("<end>");
            ((LatticeNode)object).setPosId(this.table.getId("<end>"));
            ((LatticeNode)object).setPrevIdx(this.totalIdx);
            ((LatticeNode)object).setPrevHashcode(((LatticeNode)object2).hashCode());
            ((LatticeNode)object).setScore(0.0);
            hashMap.put(((LatticeNode)object).hashCode(), object);
            this.lattice.put(this.totalIdx + 1, hashMap);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseAnswer(String var1_1, List var2_2) {
        var1_1 = var1_1.trim().split(" ");
        var3_3 = "";
        var4_4 = 0;
        while (var4_4 < var1_1.length) {
            block5: {
                block4: {
                    var5_5 = var1_1[var4_4];
                    var6_6 = var5_5.split("\\/");
                    if (((String[])var6_6).length != 2) break block4;
                    var5_5 = var6_6[0];
                    var6_6 = var6_6[1];
                    ** GOTO lbl22
                }
                if (((String[])var6_6).length <= 2) break block5;
                var6_6 = var6_6[((String[])var6_6).length - 1];
                var5_5 = var5_5.substring(0, var5_5.length() - var6_6.length() - 1);
                ** GOTO lbl22
            }
            if (((String[])var6_6).length == 1) {
                var3_3 = String.valueOf(var3_3) + var5_5 + " ";
            } else {
                var5_5 = "";
                var6_6 = "";
lbl22:
                // 3 sources

                if (var5_5.trim().length() != 0 && var6_6.trim().length() != 0) {
                    var5_5 = String.valueOf(var3_3) + var5_5;
                    var2_2.add(new Pair((Object)this.unitParser.b(var5_5), var6_6));
                }
                var3_3 = "";
            }
            ++var4_4;
        }
    }

    public void setEndIdx(int n) {
        this.totalIdx = n;
    }

    public void bridgingSpace(String string, int n) {
        Object object = (Map)this.lattice.get(n);
        if (object == null) {
            HashMap<Integer, LatticeNode> hashMap = new HashMap<Integer, LatticeNode>();
            object = new HashMap();
            Set set = ((Map)this.lattice.get(this.getPrevStartIdx())).keySet();
            for (Integer n2 : set) {
                LatticeNode latticeNode = new LatticeNode();
                latticeNode.setMorph(string.substring(this.getPrevStartIdx(), n));
                latticeNode.setPosId(this.table.getId("NA"));
                latticeNode.setPrevHashcode(n2);
                latticeNode.setPrevIdx(this.getPrevStartIdx());
                latticeNode.setScore(-10000.0);
                hashMap.put(latticeNode.hashCode(), latticeNode);
                LatticeNode latticeNode2 = new LatticeNode();
                latticeNode2.setMorph("<sp>");
                latticeNode2.setPosId(this.table.getId("<start>"));
                latticeNode2.setPrevIdx(n);
                latticeNode2.setPrevHashcode(latticeNode.hashCode());
                latticeNode2.setScore(0.0);
                object.put(latticeNode2.hashCode(), latticeNode2);
            }
            this.lattice.put(n, hashMap);
            this.lattice.put(n + 1, object);
            return;
        }
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        object = object.entrySet();
        double d = Double.NEGATIVE_INFINITY;
        Object object2 = null;
        boolean bl = false;
        int n3 = 0;
        Object object3 = object.iterator();
        while (object3.hasNext()) {
            object = (Map.Entry)object3.next();
            object = (LatticeNode)object.getValue();
            double d2 = ((LatticeNode)object).getScore();
            int n4 = ((LatticeNode)object).getPosId();
            if (n4 == this.table.getId("<start>")) {
                bl = true;
                n3 = ((LatticeNode)object).hashCode();
                break;
            }
            Double d3 = this.transition.get(n4, this.table.getId("<end>"));
            if (d3 == null || !(d2 + d3 > d)) continue;
            d = d2 + d3;
            object2 = object;
        }
        if (object2 != null) {
            object = new LatticeNode();
            ((LatticeNode)object).setMorph("<sp>");
            ((LatticeNode)object).setPosId(this.table.getId("<start>"));
            ((LatticeNode)object).setPrevIdx(n);
            ((LatticeNode)object).setPrevHashcode(((LatticeNode)object2).hashCode());
            ((LatticeNode)object).setScore(d);
            hashMap.put(((LatticeNode)object).hashCode(), object);
            this.lattice.put(n + 1, hashMap);
            return;
        }
        if (bl) {
            object = new LatticeNode();
            ((LatticeNode)object).setMorph("<sp>");
            ((LatticeNode)object).setPosId(this.table.getId("<start>"));
            ((LatticeNode)object).setPrevIdx(n);
            ((LatticeNode)object).setPrevHashcode(n3);
            ((LatticeNode)object).setScore(0.0);
            hashMap.put(((LatticeNode)object).hashCode(), object);
            this.lattice.put(n + 1, hashMap);
            return;
        }
        object = new HashMap();
        object3 = new LatticeNode();
        ((LatticeNode)object3).setMorph(string.substring(this.prevStartIdx, n));
        ((LatticeNode)object3).setPosId(this.table.getId("NA"));
        ((LatticeNode)object3).setPrevHashcode((Integer)((Map)this.lattice.get(this.prevStartIdx)).keySet().iterator().next());
        ((LatticeNode)object3).setPrevIdx(this.prevStartIdx);
        ((LatticeNode)object3).setScore(-10000.0);
        object.put(((LatticeNode)object3).hashCode(), object3);
        this.lattice.put(n, object);
        object = new LatticeNode();
        ((LatticeNode)object).setMorph("<sp>");
        ((LatticeNode)object).setPosId(this.table.getId("<start>"));
        ((LatticeNode)object).setPrevIdx(n);
        ((LatticeNode)object).setPrevHashcode(((LatticeNode)object3).hashCode());
        ((LatticeNode)object).setScore(0.0);
        hashMap.put(((LatticeNode)object).hashCode(), object);
        this.lattice.put(n + 1, hashMap);
    }

    public int getPrevStartIdx() {
        return this.prevStartIdx;
    }

    public void setPrevStartIdx(int n) {
        this.prevStartIdx = n;
    }

    public void print() {
        int n = 0;
        while (n < this.totalIdx + 1) {
            System.out.println("[" + n + "]");
            Map map = (Map)this.lattice.get(n);
            if (map != null) {
                for (Integer n2 : map.keySet()) {
                    System.out.println(n2 + "=" + map.get(n2));
                }
            } else {
                System.out.println("null");
            }
            System.out.println();
            ++n;
        }
    }

    public void print(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.println("[" + n2 + "]");
            System.out.println(this.lattice.get(n2));
            System.out.println();
            ++n2;
        }
    }

    public void setNbest(int n) {
        this.nbest = n;
    }
}

