/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.ds.trie.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kr.co.shineware.ds.model.Node;

public class TrieNode<V>
extends Node<Character, V> {
    private TrieNode<V>[] children;

    public TrieNode() {
        this.setChildren(null);
    }

    public TrieNode<V>[] getChildren() {
        return this.children;
    }

    public void setChildren(TrieNode<V>[] children) {
        this.children = children;
    }

    public void save(String filename) {
        try {
            ObjectOutputStream dos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))));
            this.write(dos, true);
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void write(ObjectOutputStream dos, boolean isRoot) throws Exception {
        if (!isRoot) {
            dos.writeChar(((Character)this.getKey()).charValue());
            dos.writeObject(this.getValue());
        }
        if (this.children == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.children.length);
            int i = 0;
            while (i < this.children.length) {
                super.write(dos, false);
                ++i;
            }
        }
    }

    public void load(String filename) {
        try {
            ObjectInputStream dis = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(filename))));
            this.load(dis, true);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load(ObjectInputStream dis, boolean isRoot) throws Exception {
        int length;
        if (!isRoot) {
            this.setKey(Character.valueOf(dis.readChar()));
            this.setValue(dis.readObject());
        }
        if ((length = dis.readInt()) != 0) {
            this.children = new TrieNode[length];
        }
        int i = 0;
        while (i < length) {
            this.children[i] = new TrieNode<V>();
            super.load(dis, false);
            ++i;
        }
    }
}

