/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.util.common.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kr.co.shineware.util.common.model.Jaso;
import kr.co.shineware.util.common.model.Syllable;

public class StringUtil {
    public static char[] ChoSung = new char[]{'\u3131', '\u3132', '\u3134', '\u3137', '\u3138', '\u3139', '\u3141', '\u3142', '\u3143', '\u3145', '\u3146', '\u3147', '\u3148', '\u3149', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};
    public static char[] JungSung = new char[]{'\u314f', '\u3150', '\u3151', '\u3152', '\u3153', '\u3154', '\u3155', '\u3156', '\u3157', '\u3158', '\u3159', '\u315a', '\u315b', '\u315c', '\u315d', '\u315e', '\u315f', '\u3160', '\u3161', '\u3162', '\u3163'};
    public static char[] JongSung;

    static {
        char[] cArray = new char[28];
        cArray[1] = 12593;
        cArray[2] = 12594;
        cArray[3] = 12595;
        cArray[4] = 12596;
        cArray[5] = 12597;
        cArray[6] = 12598;
        cArray[7] = 12599;
        cArray[8] = 12601;
        cArray[9] = 12602;
        cArray[10] = 12603;
        cArray[11] = 12604;
        cArray[12] = 12605;
        cArray[13] = 12606;
        cArray[14] = 12607;
        cArray[15] = 12608;
        cArray[16] = 12609;
        cArray[17] = 12610;
        cArray[18] = 12612;
        cArray[19] = 12613;
        cArray[20] = 12614;
        cArray[21] = 12615;
        cArray[22] = 12616;
        cArray[23] = 12618;
        cArray[24] = 12619;
        cArray[25] = 12620;
        cArray[26] = 12621;
        cArray[27] = 12622;
        JongSung = cArray;
    }

    public static List<String> split(String source, String spliter) {
        ArrayList<String> splitedList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(source);
        int prevIndex = -1;
        int index = 0;
        while (true) {
            if ((index = sb.indexOf(spliter, prevIndex + 1)) == -1) break;
            splitedList.add(sb.substring(prevIndex + 1, index));
            prevIndex = index + spliter.length() - 1;
        }
        splitedList.add(sb.substring(prevIndex + 1));
        sb = null;
        return splitedList;
    }

    public static List<String> ngram(String str, int n, String begin, String end) {
        ArrayList<String> ngramList = new ArrayList<String>();
        int i = 0;
        while (i < n - 1) {
            if (begin != null) {
                str = String.valueOf(begin) + str;
            }
            if (end != null) {
                str = String.valueOf(str) + end;
            }
            ++i;
        }
        i = 0;
        while (i < str.length()) {
            if (i + n > str.length()) break;
            StringBuilder sb = new StringBuilder();
            int j = i;
            while (j < i + n) {
                sb.append(str.charAt(j));
                ++j;
            }
            ngramList.add(sb.toString());
            sb = null;
            ++i;
        }
        return ngramList;
    }

    public static List<Jaso> korean2JasoList(String str) {
        int length = str.length();
        ArrayList<Jaso> jasoList = new ArrayList<Jaso>();
        int i = 0;
        while (i < length) {
            Syllable syllable = StringUtil.hangul2Syllable(str.charAt(i));
            if (syllable == null) {
                jasoList.add(new Jaso(str.charAt(i), Jaso.TYPE.ETC, -1));
            } else {
                Jaso chosung = new Jaso(syllable.getChosung(), Jaso.TYPE.CHOSUNG, syllable.getChosungIndex());
                jasoList.add(chosung);
                Jaso jungsung = new Jaso(syllable.getJungsung(), Jaso.TYPE.JUNGSUNG, syllable.getJungsungIndex());
                jasoList.add(jungsung);
                Jaso jongsung = new Jaso(syllable.getJongsung(), Jaso.TYPE.JONGSUNG, syllable.getJongsungIndex());
                jasoList.add(jongsung);
                syllable = null;
                chosung = null;
                jungsung = null;
                jongsung = null;
            }
            ++i;
        }
        return jasoList;
    }

    public static String restoreJasoList2Korean(List<Jaso> jasoList) {
        return StringUtil.restoreJasoList2Korean(0, jasoList.size() - 1, jasoList);
    }

    public static String restoreJasoList2Korean(int begin, int end, List<Jaso> jasoList) {
        int cho = -1;
        int jung = -1;
        int jong = -1;
        StringBuffer koreanStr = new StringBuffer();
        int i = begin;
        while (i <= end) {
            Jaso jaso = jasoList.get(i);
            if (jaso.getType() == Jaso.TYPE.CHOSUNG) {
                cho = jaso.getIndex();
            } else if (jaso.getType() == Jaso.TYPE.JUNGSUNG) {
                jung = jaso.getIndex();
            } else {
                jong = jaso.getType() == Jaso.TYPE.JONGSUNG ? jaso.getIndex() : Arrays.binarySearch(JongSung, jaso.getJaso());
            }
            if (i + 1 > end || jasoList.get(i + 1).getType() == Jaso.TYPE.CHOSUNG || jasoList.get(i + 1).getType() == Jaso.TYPE.ETC || jasoList.get(i + 1).getType() == Jaso.TYPE.ETC) {
                if (jong != -1) {
                    if (cho != -1) {
                        koreanStr.append((char)(44032 + cho * 588 + jung * 28 + jong));
                    } else {
                        koreanStr.append(jaso.getJaso());
                    }
                } else if (jung != -1) {
                    koreanStr.append((char)(44032 + cho * 588 + jung * 28));
                } else {
                    koreanStr.append(jaso.getJaso());
                }
                jong = -1;
                jung = -1;
                cho = -1;
            }
            jaso = null;
            ++i;
        }
        return koreanStr.toString();
    }

    public static boolean isKorean(char ch) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(ch);
        return Character.UnicodeBlock.HANGUL_SYLLABLES == unicodeBlock || Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO == unicodeBlock || Character.UnicodeBlock.HANGUL_JAMO == unicodeBlock;
    }

    public static String getKorean(String in) {
        char[] charArray;
        StringBuffer sb = new StringBuffer();
        char[] cArray = charArray = in.toCharArray();
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(ch);
            if (Character.UnicodeBlock.HANGUL_SYLLABLES == unicodeBlock || Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO == unicodeBlock || Character.UnicodeBlock.HANGUL_JAMO == unicodeBlock) {
                sb.append(ch);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static boolean isEnglish(char ch) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(ch);
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z');
    }

    public static boolean isJapanese(char ch) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(ch);
        return Character.UnicodeBlock.KATAKANA.equals(unicodeBlock) || Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS.equals(unicodeBlock) || Character.UnicodeBlock.HIRAGANA.equals(unicodeBlock);
    }

    public static boolean isForeign(char ch) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(ch);
        return unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
    }

    public static boolean isChinese(char ch) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(ch);
        return Character.UnicodeBlock.CJK_COMPATIBILITY.equals(unicodeBlock) || Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS.equals(unicodeBlock) || Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT.equals(unicodeBlock) || Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT.equals(unicodeBlock) || Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B.equals(unicodeBlock) || Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS.equals(unicodeBlock);
    }

    public static Character.UnicodeBlock getUnicodeBlock(char ch) {
        return Character.UnicodeBlock.of(ch);
    }

    public static boolean isNumeric(char ch) {
        return Character.isDigit(ch);
    }

    public static String korean2JasoString(String word) {
        return StringUtil.korean2JasoString(word, false);
    }

    public static String korean2JasoString(String word, boolean fixJongsung) {
        String key = "";
        int j = 0;
        while (j < word.length()) {
            Syllable s = StringUtil.hangul2Syllable(word.charAt(j));
            if (s == null) {
                key = String.valueOf(key) + word.charAt(j);
            } else {
                key = String.valueOf(key) + s.getChosung();
                key = String.valueOf(key) + s.getJungsung();
                if (fixJongsung) {
                    key = String.valueOf(key) + s.getJongsung();
                } else if (s.getJongsung() != 'x') {
                    key = String.valueOf(key) + s.getJongsung();
                }
                s = null;
            }
            ++j;
        }
        return key;
    }

    public static Syllable hangul2Syllable(char ch) {
        if (ch >= '\uac00' && ch <= '\ud7a3') {
            int tmp = ch - 44032;
            int cho = tmp / 588;
            int jung = (tmp %= 588) / 28;
            int jong = tmp % 28;
            if (jong != 0) {
                return new Syllable(ChoSung[cho], cho, JungSung[jung], jung, JongSung[jong], jong);
            }
            return new Syllable(ChoSung[cho], cho, JungSung[jung], jung, 'x', jong);
        }
        return null;
    }

    public static String restoreJasoword2Korean(String jasoWord) {
        StringBuilder sb = new StringBuilder();
        int length = jasoWord.length();
        int jong = 32;
        int jung = 32;
        int cho = 32;
        int i = 0;
        while (i < length) {
            if (jasoWord.charAt(i) >= '\u3131' && jasoWord.charAt(i) <= '\u314e') {
                if (cho == 32) {
                    cho = jasoWord.charAt(i);
                } else if (jung == 32) {
                    sb.append((char)cho);
                    cho = jasoWord.charAt(i);
                } else if (i + 1 < length) {
                    if (jasoWord.charAt(i + 1) >= '\u3131' && jasoWord.charAt(i + 1) <= '\u314e') {
                        jong = jasoWord.charAt(i);
                        sb.append(StringUtil.combineJaso2Emjeol((char)cho, (char)jung, (char)jong));
                        jong = 32;
                        jung = 32;
                        cho = 32;
                    } else {
                        sb.append(StringUtil.combineJaso2Emjeol((char)cho, (char)jung, (char)jong));
                        cho = jasoWord.charAt(i);
                        jong = 32;
                        jung = 32;
                    }
                } else {
                    jong = jasoWord.charAt(i);
                    sb.append(StringUtil.combineJaso2Emjeol((char)cho, (char)jung, (char)jong));
                    jong = 32;
                    jung = 32;
                    cho = 32;
                }
            } else if (cho == 32) {
                sb.append(jasoWord.charAt(i));
            } else {
                jung = jasoWord.charAt(i);
            }
            ++i;
        }
        if (cho != 32 || jung != 32 || jong != 32) {
            sb.append(StringUtil.combineJaso2Emjeol((char)cho, (char)jung, (char)jong));
        }
        return sb.toString();
    }

    private static char combineJaso2Emjeol(char cho, char jung, char jong) {
        char emjeol = '\u0000';
        if (cho != ' ') {
            if (jung != ' ') {
                int choIndex = Arrays.binarySearch(ChoSung, cho);
                int jungIndex = jung - 12623;
                emjeol = (char)(44032 + choIndex * 588 + jungIndex * 28);
                if (jong != ' ') {
                    int jongIndex = Arrays.binarySearch(JongSung, jong);
                    emjeol = (char)(emjeol + jongIndex);
                }
            } else {
                emjeol = cho;
            }
        } else {
            emjeol = jong != ' ' ? jung : jong;
        }
        return emjeol;
    }
}

