﻿""" Unicode character maps

Thanks to: http://developer.mimer.com/charts/index.tml

"""
unicode_character_map = {
    'en':[
        (u'a', u'A'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'd', u'D'),
        (u'e', u'E'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'z', u'Z')],
    'en-US':[
        (u'a', u'A'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'd', u'D'),
        (u'e', u'E'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'z', u'Z')],
    'el':[
        (u"\u03B1", u"\u0391", u"\u03AC", u"\u0386"),
        (u"\u03B2", u"\u0392"),
        (u"\u03B3", u"\u0393"),
        (u"\u03B4", u"\u0394"),
        (u"\u03B5", u"\u0395", u"\u03AD", u"\u0388"),
        (u"\u03B6", u"\u0396"),
        (u"\u03B7", u"\u0397", u"\u03AE", u"\u0389"),
        (u"\u03B8", u"\u0398"),
        (u"\u03B9", u"\u0399", u"\u03AF", u"\u038A",
         u"\u03CA", u"\u03AA", u"\u0390"),
        (u"\u03BA", u"\u039A"),
        (u"\u03BB", u"\u039B"),
        (u"\u03BC", u"\u039C", u"\u00B5"),
        (u"\u03BD", u"\u039D"),
        (u"\u03BE", u"\u039E"),
        (u"\u03BF", u"\u039F", u"\u03CC", u"\u038C"),
        (u"\u03C0", u"\u03A0"),
        (u"\u03C1", u"\u03A1"),
        (u"\u03C3", u"\u03A3", u"\u03C2"),
        (u"\u03C4", u"\u03A4"),
        (u"\u03C5", u"\u03A5", u"\u03CD",
         u"\u038E", u"\u03CB", u"\u03AB", u"\u03B0"),
        (u"\u03C6", u"\u03A6"),
        (u"\u03C7", u"\u03A7"),
        (u"\u03C8", u"\u03A8"),
        (u"\u03C9", u"\u03A9", u"\u2126", u"\u03CE", u"\u038F")],
    'bg':[
        (u"\u0430", u"\u0410"),
        (u"\u0431", u"\u0411"),
        (u"\u0432", u"\u0412"),
        (u"\u0433", u"\u0413", u"\u0491", u"\u0490"),
        (u"\u0434", u"\u0414"),
        (u"\u0435", u"\u0415", u"\u0450", u"\u0400", u"\u0451", u"\u0401"),
        (u"\u0436", u"\u0416", u"\u04C2", u"\u04C1"),
        (u"\u0437", u"\u0417"),
        (u"\u0438", u"\u0418", u"\u045D", u"\u040D", u"\u04E3", u"\u04E2"),
        (u"\u0439", u"\u0419"),
        (u"\u043A", u"\u041A"),
        (u"\u043B", u"\u041B"),
        (u"\u043C", u"\u041C"),
        (u"\u043D", u"\u041D"),
        (u"\u043E", u"\u041E"),
        (u"\u043F", u"\u041F"),
        (u"\u0440", u"\u0420"),
        (u"\u0441", u"\u0421"),
        (u"\u0442", u"\u0422"),
        (u"\u0443", u"\u0423", u"\u04EF", u"\u04EE"),
        (u"\u0444", u"\u0424"),
        (u"\u0445", u"\u0425"),
        (u"\u0446", u"\u0426"),
        (u"\u0447", u"\u0427"),
        (u"\u0448", u"\u0428"),
        (u"\u0449", u"\u0429"),
        (u"\u044A", u"\u042A"),
        (u"\u044C", u"\u042C"),
        (u"\u044E", u"\u042E"),
        (u"\u044F", u"\u042F") ],
    'da':[
        (u'a', u'A'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'd', u'D'),
        (u'e', u'E'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'z', u'Z'),
        (u"\u00E6", u"\u00C6"),
        (u"\u00F8", u"\u00D8"),
        (u"\u00E5", u"\u00C5") ],
    'et':[
        (u"a",      u"\u0041"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0161", u"\u0160"),
        (u"\u007A", u"\u005A"),
        (u"\u017E", u"\u017D"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u00F5", u"\u00D5"),
        (u"\u00E4", u"\u00C4"),
        (u"\u00F6", u"\u00D6"),
        (u"\u00FC", u"\u00DC"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059") ],
    'fi':[
        (u"a",      u"\u0041"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055"),
        (u"\u0076", u"\u0056"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A"),
        (u"\u00E5", u"\u00C5"),
        (u"\u00E4", u"\u00C4"),
        (u"\u00F6", u"\u00D6") ],
    'hu':[
        (u"a",      u"\u0041"),
        (u"\u00E1", u"\u00C1"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"\u0063\u0073", u"\u0043\u0073"),
        (u"d",      u"\u0044"),
        (u"\u0064\u007A", u"\u0044\u007A", u"\u0044\u005A"),
        (u"\u0064\u007A\u0073", u"\u0044\u007A\u0073", u"\u0044\u005A\u0053"),
        (u"e",      u"\u0045"),
        (u"\u00E9", u"\u00C9"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0067\u0079", u"\u0047\u0079", u"\u0047\u0059"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u00ED", u"\u00CD"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006C\u0079", u"\u004C\u0079", u"\u004C\u0059"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006E\u0079", u"\u004E\u0079", u"\u004E\u0059"),
        (u"\u006F", u"\u004F"),
        (u"\u00F3", u"\u00D3"),
        (u"\u00F6", u"\u00D6"),
        (u"\u0151", u"\u0150"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0073\u007A", u"\u0053\u007A", u"\u0053\u005A"),
        (u"\u0074", u"\u0054"),
        (u"\u0074\u0079", u"\u0054\u0079", u"\u0054\u0059"),
        (u"\u0075", u"\u0055"),
        (u"\u00FA", u"\u00DA"),
        (u"\u00FC", u"\u00DC"),
        (u"\u0171", u"\u0170"),
        (u"\u0076", u"\u0056"),
        (u"\u007A", u"\u005A"),
        (u"\u007A\u0073", u"\u005A\u0073", u"\u005A\u0053") ],
    'ru':[
        (u"\u0430", u"\u0410"),
        (u"\u0431", u"\u0411"),
        (u"\u0432", u"\u0412"),
        (u"\u0433", u"\u0413"),
        (u"\u0434", u"\u0414"),
        (u"\u0435", u"\u0415"),
        (u"\u0451", u"\u0401"),
        (u"\u0436", u"\u0416"),
        (u"\u0437", u"\u0417"),
        (u"\u0438", u"\u0418"),
        (u"\u0439", u"\u0419"),
        (u"\u043A", u"\u041A"),
        (u"\u043B", u"\u041B"),
        (u"\u043C", u"\u041C"),
        (u"\u043D", u"\u041D"),
        (u"\u043E", u"\u041E"),
        (u"\u043F", u"\u041F"),
        (u"\u0440", u"\u0420"),
        (u"\u0441", u"\u0421"),
        (u"\u0442", u"\u0422"),
        (u"\u0443", u"\u0423"),
        (u"\u0444", u"\u0424"),
        (u"\u0445", u"\u0425"),
        (u"\u0446", u"\u0426"),
        (u"\u0447", u"\u0427"),
        (u"\u0448", u"\u0428"),
        (u"\u0449", u"\u0429"),
        (u"\u044A", u"\u042A"),
        (u"\u044B", u"\u042B"),
        (u"\u044C", u"\u042C"),
        (u"\u044D", u"\u042D"),
        (u"\u044E", u"\u042E"),
        (u"\u044F", u"\u042F") ],
    'eu':[
        (u"a",      u"\u0041"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006C\u006C", u"\u004C\u006C", u"\u004C\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u00F1", u"\u00D1"),
        (u"\u006F", u"\u004F"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0072\u0072", u"\u0052\u0072", u"\u0052\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0074", u"\u0054"),
        (u"\u0074\u0073", u"\u0054\u0073", u"\u0054\u0053"),
        (u"\u0074\u0078", u"\u0054\u0078", u"\u0054\u0058"),
        (u"\u0074\u007A", u"\u0054\u007A", u"\u0054\u005A"),
        (u"\u0075", u"\u0055"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A") ],
    'cs':[
        (u"a",      u"\u0041"),
        (u"\u00E1", u"\u00C1"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"\u010D", u"\u010C"),
        (u"d",      u"\u0044"),
        (u"\u010F", u"\u010E"),
        (u"e",      u"\u0045"),
        (u"\u00E9", u"\u00C9"),
        (u"\u011B", u"\u011A"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0063\u0068", u"\u0043\u0068", u"\u0043\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u00ED", u"\u00CD"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u0148", u"\u0147"),
        (u"\u006F", u"\u004F"),
        (u"\u00F3", u"\u00D3"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0159", u"\u0158"),
        (u"\u0073", u"\u0053"),
        (u"\u0161", u"\u0160"),
        (u"\u0074", u"\u0054"),
        (u"\u0165", u"\u0164"),
        (u"\u0075", u"\u0055"),
        (u"\u00FA", u"\u00DA"),
        (u"\u016F", u"\u016E"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u00FD", u"\u00DD"),
        (u"\u007A", u"\u005A"),
        (u"\u017E", u"\u017D") ],
    'fr':[
        (u"a",      u"A",      u"\u00E0", u"\u00C0", u"\u00E2", u"\u00C2"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043", u"\u00E7", u"\u00C7"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045", u"\u00E9", u"\u00C9",
         u"\u00E8", u"\u00C8", u"\u00EA", u"\u00CA", u"\u00EB", u"\u00CB"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049", u"\u00EE", u"\u00CE"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F", u"\u00F4", u"\u00D4", u"\u0153", u"\u0152"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055", u"\u00F9", u"\u00D9", u"\u00FB", u"\u00DB"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A") ],
    'it':[
        (u"a",      u"A",      u"\u00E0", u"\u00C0"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045", u"\u00E9", u"\u00C9", u"\u00E8", u"\u00C8"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049", u"\u00ED", u"\u00CD", u"\u00EC", u"\u00CC"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F", u"\u00F3", u"\u00D3", u"\u00F2", u"\u00D2"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055", u"\u00FA", u"\u00DA", u"\u00F9", u"\u00D9"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A") ],
    'de':[
        (u"a",      u"A",      u"\u00E4", u"\u00C4"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F", u"\u00F6", u"\u00D6"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053", u"\u00DF"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055", u"\u00FC", u"\u00DC"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A") ],
    'pt':[
        (u"a",      u"A",      u"\u00E1", u"\u00C1", u"\u00E0",
         u"\u00C0", u"\u00E2", u"\u00C2", u"\u00E3", u"\u00C3"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043", u"\u00E7", u"\u00C7"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045", u"\u00E9", u"\u00C9", u"\u00EA", u"\u00CA"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049", u"\u00ED", u"\u00CD"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F", u"\u00F3", u"\u00D3", u"\u00F4",
         u"\u00D4", u"\u00F5", u"\u00D5"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055", u"\u00FA", u"\u00DA"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A") ],
    'es':[
        (u"a",      u"A",      u"\u00E1", u"\u00C1"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045", u"\u00E9", u"\u00C9"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049", u"\u00ED", u"\u00CD"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u00F1", u"\u00D1"),
        (u"\u006F", u"\u004F", u"\u00F3", u"\u00D3"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055", u"\u00FA", u"\u00DA"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A") ],
    'nl':[
        (u"a",      u"A",      u"\u00E4", u"\u00C4"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045", u"\u00EB", u"\u00CB"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049", u"\u00EF", u"\u00CF"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F", u"\u00F6", u"\u00D6"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055", u"\u00FC", u"\u00DC"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A") ],
    'no':[
        (u'a', u'A'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'd', u'D'),
        (u'e', u'E'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'z', u'Z'),
        (u"\u00E6", u"\u00C6"),
        (u"\u00F8", u"\u00D8"),
        (u"\u00E5", u"\u00C5") ],
    'pl':[
        (u"a",      u"\u0041"),
        (u"\u0105", u"\u0104"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"\u0107", u"\u0106"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045"),
        (u"\u0119", u"\u0118"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u0142", u"\u0141"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u0144", u"\u0143"),
        (u"\u006F", u"\u004F"),
        (u"\u00F3", u"\u00D3"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u015B", u"\u015A"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A"),
        (u"\u017A", u"\u0179"),
        (u"\u017C", u"\u017B") ],
    'sk':[
        (u"a",      u"\u0041"),
        (u"\u00E1", u"\u00C1"),
        (u"\u00E4", u"\u00C4"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"\u010D", u"\u010C"),
        (u"d",      u"\u0044"),
        (u"\u010F", u"\u010E"),
        (u"\u0064\u007A", u"\u0044\u007A", u"\u0044\u005A"),
        (u"\u0064\u017E", u"\u0044\u017E", u"\u0044\u017D"),
        (u"e",      u"\u0045"),
        (u"\u00E9", u"\u00C9"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0063\u0068", u"\u0043\u0068", u"\u0043\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u00ED", u"\u00CD"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u013A", u"\u0139"),
        (u"\u013E", u"\u013D"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u0148", u"\u0147"),
        (u"\u006F", u"\u004F"),
        (u"\u00F3", u"\u00D3"),
        (u"\u00F4", u"\u00D4"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0155", u"\u0154"),
        (u"\u0073", u"\u0053"),
        (u"\u0161", u"\u0160"),
        (u"\u0074", u"\u0054"),
        (u"\u0165", u"\u0164"),
        (u"\u0075", u"\u0055"),
        (u"\u00FA", u"\u00DA"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u00FD", u"\u00DD"),
        (u"\u007A", u"\u005A"),
        (u"\u017E", u"\u017D") ],
    'sl':[
        (u"a",      u"\u0041"),
        (u"b",      u"B"     ),
        (u"c",      u"\u0043"),
        (u"\u010D", u"\u010C"),
        (u"d",      u"\u0044"),
        (u"e",      u"\u0045"),
        (u"\u0066", u"\u0046"),
        (u"\u0067", u"\u0047"),
        (u"\u0068", u"\u0048"),
        (u"\u0069", u"\u0049"),
        (u"\u006A", u"\u004A"),
        (u"\u006B", u"\u004B"),
        (u"\u006C", u"\u004C"),
        (u"\u006D", u"\u004D"),
        (u"\u006E", u"\u004E"),
        (u"\u006F", u"\u004F"),
        (u"\u0070", u"\u0050"),
        (u"\u0071", u"\u0051"),
        (u"\u0072", u"\u0052"),
        (u"\u0073", u"\u0053"),
        (u"\u0161", u"\u0160"),
        (u"\u0074", u"\u0054"),
        (u"\u0075", u"\u0055"),
        (u"\u0076", u"\u0056"),
        (u"\u0077", u"\u0057"),
        (u"\u0078", u"\u0058"),
        (u"\u0079", u"\u0059"),
        (u"\u007A", u"\u005A"),
        (u"\u017E", u"\u017D") ],
    'sv':[
        (u'a', u'A'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'd', u'D'),
        (u'e', u'E'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'z', u'Z'),
        (u"\u00E5", u"\u00C5"),
        (u"\u00E4", u"\u00C4"),
        (u"\u00F6", u"\u00D6") ],
    'lt':[
        (u'a', u'A', u'ą', u'Ą'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'č', u'Č'),
        (u'd', u'D'),
        (u'e', u'E', u'ę', u'Ę', u'ė', u'Ė'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I', u'į', u'Į', u'y', u'Y'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'r', u'R'),
        (u's', u'S'),
        (u'š', u'Š'),
        (u't', u'T'),
        (u'u', u'U', u'ų', u'Ų', u'ū', u'Ū'),
        (u'v', u'V'),
        (u'z', u'Z'),
        (u'ž', u'Ž'),],
    'lv':[
        (u'a', u'A', u'ā', u'Ā'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'č', u'Č'),
        (u'd', u'D'),
        (u'e', u'E', u'ē', u'Ē'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'ģ', u'Ģ'),
        (u'h', u'H'),
        (u'i', u'I', u'ī', u'Ī'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'ķ', u'Ķ'),
        (u'l', u'L'),
        (u'ļ', u'Ļ'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'ņ', u'Ņ'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'r', u'R'),
        (u's', u'S'),
        (u'š', u'Š'),
        (u't', u'T'),
        (u'u', u'U', u'ū', u'Ū'),
        (u'v', u'V'),
        (u'z', u'Z'),
        (u'ž', u'Ž'),],
    # mt:
    # A B Ċ D E F Ġ G GĦ H Ħ I IE J K L M N O P Q R S T U V W X Ż Z
    # A B Ċ D E F Ġ G Għ H Ħ I Ie J K L M N O P Q R S T U V W X Ż Z
    # a b ċ d e f ġ g għ h ħ i ie j k l m n o p q r s t u v w x ż z
    'mt':[
        (u"a", u"A"),
        (u"à", u"À"),
        (u"b", u"B"),
        (u"ċ", u"Ċ"),
        (u"d", u"D"),
        (u"e", u"E", u"è", u"È"),
        (u'f', u'F'),
        (u'ġ', u'Ġ'),
        (u'g', u'G'),
        (u'għ', u'Għ', u'GĦ'),
        (u'h', u'H'),
        (u'ħ', u'Ħ'),
        (u'i', u'I', u'ì', u'Ì'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O', u'ò', u'Ò'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U', u'ù', u'Ù'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'ż', u'Ż'),
        (u'z', u'Z'),],
    # ga:
    #a á b c d e é f g h i í l m n o ó p r s t u ú
    #Loan words: j k q v w x y z
    'ga':[
        (u"a", u"A", u"á", u"Á"),
        (u"b", u"B"),
        (u"c", u"C"),
        (u"d", u"D"),
        (u"e", u"E", u"é", u"É"),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I', u'í', u'Í'),
        (u'j', u'J'),
        #(u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O', u'ó', u'Ó'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U', u'ú', u'Ú'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'z', u'Z'),],
    # ro:
    # A a   Ă ă     Â â     B b     C c     D d     E e
    # F f   G g     H h     I i     Î î     J j     K k
    # L l   M m     N n     O o     P p     R r     S s
    # Ş ş   T t     Ţ ţ     U u     V v     X x     Z z
    'ro':[
        (u'a', u'A'),
        (u'ă', u'Ă'),
        (u'â', u'Â'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'd', u'D'),
        (u'e', u'E'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I'),
        (u'î', u'Î'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'p', u'P'),
        (u'q', u'Q'),
        (u'r', u'R'),
        (u's', u'S'),
        (u'ş', u'Ş', u'ș', u'Ș'),
        (u't', u'T'),
        (u'ţ', u'Ţ', u'ț', u'Ț'),
        (u'u', u'U'),
        (u'v', u'V'),
        (u'w', u'W'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'z', u'Z'),],
    'ar':[
        (u"\u0627", u"\uFE8E", u"\uFE8D", u"\uFD3C", u"\uFD3D",
         u"\u0675", u"\u0623", u"\uFE84", u"\uFE83", u"\u0625",
         u"\uFE88", u"\uFE87", u"\u0622", u"\uFE82", u"\uFE81"),
        (u"\u0628", u"\uFE91", u"\uFE92", u"\uFE90", u"\uFE8F"),
        (u"\u062A", u"\uFE97", u"\uFE98", u"\uFE96", u"\uFE95"),
        (u"\u062B", u"\uFE9B", u"\uFE9C", u"\uFE9A", u"\uFE99"),
        (u"\u062C", u"\uFE9F", u"\uFEA0", u"\uFE9E", u"\uFE9D",
         u"\u0686", u"\uFB7C", u"\uFB7D", u"\uFB7B", u"\uFB7A"),
        (u"\u062D", u"\uFEA3", u"\uFEA4", u"\uFEA2", u"\uFEA1"),
        (u"\u062E", u"\uFEA7", u"\uFEA8", u"\uFEA6", u"\uFEA5"),
        (u"\u062F", u"\uFEAA", u"\uFEA9"),
        (u"\u0630", u"\uFEAC", u"\uFEAB"),
        (u"\u0631", u"\uFEAE", u"\uFEAD"),
        (u"\u0632", u"\uFEB0", u"\uFEAF"),
        (u"\u0633", u"\uFEB3", u"\uFEB4", u"\uFEB2", u"\uFEB1"),
        (u"\u0634", u"\uFEB7", u"\uFEB8", u"\uFEB6", u"\uFEB5"),
        (u"\u0635", u"\uFEBB", u"\uFEBA", u"\uFEBC", u"\uFEB9"),
        (u"\u0636", u"\uFEBF", u"\uFEC0", u"\uFEC0", u"\uFEBD"),
        (u"\u0637", u"\uFEC3", u"\uFEC4", u"\uFEC2", u"\uFEC1"),
        (u"\u0638", u"\uFEC7", u"\uFEC8", u"\uFEC6", u"\uFEC5"),
        (u"\u0639", u"\uFECB", u"\uFECC", u"\uFECA", u"\uFEC9"),
        (u"\u063A", u"\uFECF", u"\uFED0", u"\uFECE", u"\uFECD"),
        (u"\u0641", u"\uFED3", u"\uFED4", u"\uFED2", u"\uFED1", u"\u06A8"),
        (u"\u0642", u"\uFED7", u"\uFED8", u"\uFED6", u"\uFED5"),
        (u"\u0643", u"\uFEDB", u"\uFEDC", u"\uFEDA", u"\uFED9"),
        (u"\u0644", u"\uFEDF", u"\uFEE0", u"\uFEDE", u"\uFEDD"),
        (u"\u0645", u"\uFEE3", u"\uFEE4", u"\uFEE2", u"\uFEE1", u"\u06FE"),
        (u"\u0646", u"\uFEE7", u"\uFEE8", u"\uFEE6", u"\uFEE5"),
        (u"\u0647", u"\uFEEB", u"\uFEEC", u"\uFEEA", u"\uFEE9"),
        (u"\u0648", u"\u06E5", u"\uFEEE", u"\uFEED", u"\u0676"),
        (u"\u0649", u"\uFEF0", u"\uFEEF", u"\u064A", u"\u06E6",
         u"\uFEF3", u"\uFEF4", u"\uFEF2", u"\uFEF1", u"\u0678") ],
    'is':[
        (u'a', u'A'),
        (u'á', u'Á'),
        (u'b', u'B'),
        (u'd', u'D'),
        (u'ð', u'Ð'),
        (u'e', u'E'),
        (u'é', u'É'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'h', u'H'),
        (u'i', u'I'),
        (u'í', u'Í'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'ó', u'Ó'),
        (u'p', u'P'),
        (u'r', u'R'),
        (u's', u'S'),
        (u't', u'T'),
        (u'u', u'U'),
        (u'ú', u'Ú'),
        (u'v', u'V'),
        (u'x', u'X'),
        (u'y', u'Y'),
        (u'ý', u'Ý'),
        (u'þ', u'Þ'),
        (u'æ', u'Æ'),
        (u'ö', u'Ö') ],
    'tr':[
        (u'a', u'A', u'â', u'Â'),
        (u'b', u'B'),
        (u'c', u'C'),
        (u'ç', u'Ç'),
        (u'd', u'D'),
        (u'e', u'E'),
        (u'f', u'F'),
        (u'g', u'G'),
        (u'ğ', u'Ğ'),
        (u'h', u'H'),
        (u'ı', u'I'),
        (u'i', u'İ', u'î', u'Î'),
        (u'j', u'J'),
        (u'k', u'K'),
        (u'l', u'L'),
        (u'm', u'M'),
        (u'n', u'N'),
        (u'o', u'O'),
        (u'ö', u'Ö'),
        (u'p', u'P'),
        (u'r', u'R'),
        (u's', u'S'),
        (u'ş', u'Ş'),
        (u't', u'T'),
        (u'u', u'U', u'û', u'Û'),
        (u'ü', u'Ü'),
        (u'v', u'V'),
        (u'y', u'Y'),
        (u'z', u'Z')]
}
