# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PolicyDetails(Model):
    """The policy details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar policy_definition_id: The ID of the policy definition.
    :vartype policy_definition_id: str
    :ivar policy_assignment_id: The ID of the policy assignment.
    :vartype policy_assignment_id: str
    :ivar policy_assignment_display_name: The display name of the policy
     assignment.
    :vartype policy_assignment_display_name: str
    :ivar policy_assignment_scope: The scope of the policy assignment.
    :vartype policy_assignment_scope: str
    :ivar policy_set_definition_id: The ID of the policy set definition.
    :vartype policy_set_definition_id: str
    :ivar policy_definition_reference_id: The policy definition reference ID
     within the policy set definition.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        'policy_definition_id': {'readonly': True},
        'policy_assignment_id': {'readonly': True},
        'policy_assignment_display_name': {'readonly': True},
        'policy_assignment_scope': {'readonly': True},
        'policy_set_definition_id': {'readonly': True},
        'policy_definition_reference_id': {'readonly': True},
    }

    _attribute_map = {
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_assignment_display_name': {'key': 'policyAssignmentDisplayName', 'type': 'str'},
        'policy_assignment_scope': {'key': 'policyAssignmentScope', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PolicyDetails, self).__init__(**kwargs)
        self.policy_definition_id = None
        self.policy_assignment_id = None
        self.policy_assignment_display_name = None
        self.policy_assignment_scope = None
        self.policy_set_definition_id = None
        self.policy_definition_reference_id = None
