// **********************************************************************
//
// Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.1
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICE_API_EXPORTS
#   define ICE_API_EXPORTS
#endif
#include <Ice/RemoteLogger.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ObjectFactory.h>
#include <Ice/Outgoing.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/BasicStream.h>
#include <IceUtil/Iterator.h>
#include <IceUtil/PopDisableWarnings.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 306
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 1
#       error Ice patch level mismatch!
#   endif
#endif

namespace
{

const ::std::string __Ice__RemoteLogger__init_name = "init";

const ::std::string __Ice__RemoteLogger__log_name = "log";

const ::std::string __Ice__LoggerAdmin__attachRemoteLogger_name = "attachRemoteLogger";

const ::std::string __Ice__LoggerAdmin__detachRemoteLogger_name = "detachRemoteLogger";

const ::std::string __Ice__LoggerAdmin__getLog_name = "getLog";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::RemoteLoggerAlreadyAttachedException> __Ice__RemoteLoggerAlreadyAttachedException_init("::Ice::RemoteLoggerAlreadyAttachedException");

}

Ice::RemoteLoggerAlreadyAttachedException::~RemoteLoggerAlreadyAttachedException() throw()
{
}

::std::string
Ice::RemoteLoggerAlreadyAttachedException::ice_name() const
{
    return "Ice::RemoteLoggerAlreadyAttachedException";
}

Ice::RemoteLoggerAlreadyAttachedException*
Ice::RemoteLoggerAlreadyAttachedException::ice_clone() const
{
    return new RemoteLoggerAlreadyAttachedException(*this);
}

void
Ice::RemoteLoggerAlreadyAttachedException::ice_throw() const
{
    throw *this;
}

void
Ice::RemoteLoggerAlreadyAttachedException::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice("::Ice::RemoteLoggerAlreadyAttachedException", -1, true);
    __os->endWriteSlice();
}

void
Ice::RemoteLoggerAlreadyAttachedException::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

namespace Ice
{
#if defined(ICE_HAS_DECLSPEC_IMPORT_EXPORT) && !defined(ICE_STATIC_LIBS)
template struct ICE_API StreamWriter< ::Ice::LogMessage, ::IceInternal::BasicStream>;
template struct ICE_API StreamReader< ::Ice::LogMessage, ::IceInternal::BasicStream>;
#endif
}
#ifdef __SUNPRO_CC
class ICE_API IceProxy::Ice::RemoteLogger;
#endif
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(::IceProxy::Ice::RemoteLogger* p) { return p; }

void
::IceProxy::Ice::__read(::IceInternal::BasicStream* __is, ::IceInternal::ProxyHandle< ::IceProxy::Ice::RemoteLogger>& v)
{
    ::Ice::ObjectPrx proxy;
    __is->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ::IceProxy::Ice::RemoteLogger;
        v->__copyFrom(proxy);
    }
}

void
IceProxy::Ice::RemoteLogger::init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context* __ctx)
{
    ::IceInternal::Outgoing __og(this, __Ice__RemoteLogger__init_name, ::Ice::Normal, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_prefix);
        __os->write(__p_logMessages);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    __invoke(__og);
}

::Ice::AsyncResultPtr
IceProxy::Ice::RemoteLogger::begin_init(const ::std::string& __p_prefix, const ::Ice::LogMessageSeq& __p_logMessages, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__RemoteLogger__init_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__RemoteLogger__init_name, ::Ice::Normal, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_prefix);
        __os->write(__p_logMessages);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

void
IceProxy::Ice::RemoteLogger::end_init(const ::Ice::AsyncResultPtr& __result)
{
    __end(__result, __Ice__RemoteLogger__init_name);
}

void
IceProxy::Ice::RemoteLogger::log(const ::Ice::LogMessage& __p_message, const ::Ice::Context* __ctx)
{
    ::IceInternal::Outgoing __og(this, __Ice__RemoteLogger__log_name, ::Ice::Normal, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_message);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    __invoke(__og);
}

::Ice::AsyncResultPtr
IceProxy::Ice::RemoteLogger::begin_log(const ::Ice::LogMessage& __p_message, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__RemoteLogger__log_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__RemoteLogger__log_name, ::Ice::Normal, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_message);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

void
IceProxy::Ice::RemoteLogger::end_log(const ::Ice::AsyncResultPtr& __result)
{
    __end(__result, __Ice__RemoteLogger__log_name);
}

const ::std::string&
IceProxy::Ice::RemoteLogger::ice_staticId()
{
    return ::Ice::RemoteLogger::ice_staticId();
}

::IceProxy::Ice::Object*
IceProxy::Ice::RemoteLogger::__newInstance() const
{
    return new RemoteLogger;
}
#ifdef __SUNPRO_CC
class ICE_API IceProxy::Ice::LoggerAdmin;
#endif
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(::IceProxy::Ice::LoggerAdmin* p) { return p; }

void
::IceProxy::Ice::__read(::IceInternal::BasicStream* __is, ::IceInternal::ProxyHandle< ::IceProxy::Ice::LoggerAdmin>& v)
{
    ::Ice::ObjectPrx proxy;
    __is->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ::IceProxy::Ice::LoggerAdmin;
        v->__copyFrom(proxy);
    }
}

void
IceProxy::Ice::LoggerAdmin::attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__LoggerAdmin__attachRemoteLogger_name);
    ::IceInternal::Outgoing __og(this, __Ice__LoggerAdmin__attachRemoteLogger_name, ::Ice::Normal, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_prx);
        __os->write(__p_messageTypes);
        __os->write(__p_traceCategories);
        __os->write(__p_messageMax);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::RemoteLoggerAlreadyAttachedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
}

::Ice::AsyncResultPtr
IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__LoggerAdmin__attachRemoteLogger_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__LoggerAdmin__attachRemoteLogger_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__LoggerAdmin__attachRemoteLogger_name, ::Ice::Normal, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_prx);
        __os->write(__p_messageTypes);
        __os->write(__p_traceCategories);
        __os->write(__p_messageMax);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::LoggerAdmin::__begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context* __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void ()>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
            try
            {
                __proxy->end_attachRemoteLogger(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response();
            }
        }
    
    private:
        
        ::std::function<void ()> _response;
    };
    return begin_attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

void
IceProxy::Ice::LoggerAdmin::end_attachRemoteLogger(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__LoggerAdmin__attachRemoteLogger_name);
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::RemoteLoggerAlreadyAttachedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    __result->__readEmptyParams();
}

bool
IceProxy::Ice::LoggerAdmin::detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__LoggerAdmin__detachRemoteLogger_name);
    ::IceInternal::Outgoing __og(this, __Ice__LoggerAdmin__detachRemoteLogger_name, ::Ice::Normal, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_prx);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
    bool __ret;
    ::IceInternal::BasicStream* __is = __og.startReadParams();
    __is->read(__ret);
    __og.endReadParams();
    return __ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__LoggerAdmin__detachRemoteLogger_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__LoggerAdmin__detachRemoteLogger_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__LoggerAdmin__detachRemoteLogger_name, ::Ice::Normal, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_prx);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::LoggerAdmin::__begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& __p_prx, const ::Ice::Context* __ctx, const ::IceInternal::Function<void (bool)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void (bool)>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
            bool __ret;
            try
            {
                __ret = __proxy->end_detachRemoteLogger(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response(__ret);
            }
        }
    
    private:
        
        ::std::function<void (bool)> _response;
    };
    return begin_detachRemoteLogger(__p_prx, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

bool
IceProxy::Ice::LoggerAdmin::end_detachRemoteLogger(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__LoggerAdmin__detachRemoteLogger_name);
    bool __ret;
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    ::IceInternal::BasicStream* __is = __result->__startReadParams();
    __is->read(__ret);
    __result->__endReadParams();
    return __ret;
}

::Ice::LogMessageSeq
IceProxy::Ice::LoggerAdmin::getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, ::std::string& __p_prefix, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__LoggerAdmin__getLog_name);
    ::IceInternal::Outgoing __og(this, __Ice__LoggerAdmin__getLog_name, ::Ice::Normal, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_messageTypes);
        __os->write(__p_traceCategories);
        __os->write(__p_messageMax);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
    ::Ice::LogMessageSeq __ret;
    ::IceInternal::BasicStream* __is = __og.startReadParams();
    __is->read(__p_prefix);
    __is->read(__ret);
    __og.endReadParams();
    return __ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::LoggerAdmin::begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__LoggerAdmin__getLog_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__LoggerAdmin__getLog_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__LoggerAdmin__getLog_name, ::Ice::Normal, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_messageTypes);
        __os->write(__p_traceCategories);
        __os->write(__p_messageMax);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::LoggerAdmin::__begin_getLog(const ::Ice::LogMessageTypeSeq& __p_messageTypes, const ::Ice::StringSeq& __p_traceCategories, ::Ice::Int __p_messageMax, const ::Ice::Context* __ctx, const ::IceInternal::Function<void (const ::Ice::LogMessageSeq&, const ::std::string&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void (const ::Ice::LogMessageSeq&, const ::std::string&)>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LoggerAdminPrx __proxy = ::Ice::LoggerAdminPrx::uncheckedCast(__result->getProxy());
            ::std::string __p_prefix;
            ::Ice::LogMessageSeq __ret;
            try
            {
                __ret = __proxy->end_getLog(__p_prefix, __result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response(__ret, __p_prefix);
            }
        }
    
    private:
        
        ::std::function<void (const ::Ice::LogMessageSeq&, const ::std::string&)> _response;
    };
    return begin_getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

::Ice::LogMessageSeq
IceProxy::Ice::LoggerAdmin::end_getLog(::std::string& __p_prefix, const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__LoggerAdmin__getLog_name);
    ::Ice::LogMessageSeq __ret;
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    ::IceInternal::BasicStream* __is = __result->__startReadParams();
    __is->read(__p_prefix);
    __is->read(__ret);
    __result->__endReadParams();
    return __ret;
}

const ::std::string&
IceProxy::Ice::LoggerAdmin::ice_staticId()
{
    return ::Ice::LoggerAdmin::ice_staticId();
}

::IceProxy::Ice::Object*
IceProxy::Ice::LoggerAdmin::__newInstance() const
{
    return new LoggerAdmin;
}

ICE_API ::Ice::Object* Ice::upCast(::Ice::RemoteLogger* p) { return p; }

namespace
{
const ::std::string __Ice__RemoteLogger_ids[2] =
{
    "::Ice::Object",
    "::Ice::RemoteLogger"
};

}

bool
Ice::RemoteLogger::ice_isA(const ::std::string& _s, const ::Ice::Current&) const
{
    return ::std::binary_search(__Ice__RemoteLogger_ids, __Ice__RemoteLogger_ids + 2, _s);
}

::std::vector< ::std::string>
Ice::RemoteLogger::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&__Ice__RemoteLogger_ids[0], &__Ice__RemoteLogger_ids[2]);
}

const ::std::string&
Ice::RemoteLogger::ice_id(const ::Ice::Current&) const
{
    return __Ice__RemoteLogger_ids[1];
}

const ::std::string&
Ice::RemoteLogger::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::RemoteLogger";
    return typeId;
#else
    return __Ice__RemoteLogger_ids[1];
#endif
}

::Ice::DispatchStatus
Ice::RemoteLogger::___init(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::std::string __p_prefix;
    ::Ice::LogMessageSeq __p_logMessages;
    __is->read(__p_prefix);
    __is->read(__p_logMessages);
    __inS.endReadParams();
    init(__p_prefix, __p_logMessages, __current);
    __inS.__writeEmptyParams();
    return ::Ice::DispatchOK;
}

::Ice::DispatchStatus
Ice::RemoteLogger::___log(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::Ice::LogMessage __p_message;
    __is->read(__p_message);
    __inS.endReadParams();
    log(__p_message, __current);
    __inS.__writeEmptyParams();
    return ::Ice::DispatchOK;
}

namespace
{
const ::std::string __Ice__RemoteLogger_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "init",
    "log"
};

}

::Ice::DispatchStatus
Ice::RemoteLogger::__dispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair< const ::std::string*, const ::std::string*> r = ::std::equal_range(__Ice__RemoteLogger_all, __Ice__RemoteLogger_all + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - __Ice__RemoteLogger_all)
    {
        case 0:
        {
            return ___ice_id(in, current);
        }
        case 1:
        {
            return ___ice_ids(in, current);
        }
        case 2:
        {
            return ___ice_isA(in, current);
        }
        case 3:
        {
            return ___ice_ping(in, current);
        }
        case 4:
        {
            return ___init(in, current);
        }
        case 5:
        {
            return ___log(in, current);
        }
    }

    assert(false);
    throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
}

void
Ice::RemoteLogger::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice(ice_staticId(), -1, true);
    __os->endWriteSlice();
}

void
Ice::RemoteLogger::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

void ICE_API 
Ice::__patch(RemoteLoggerPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ::Ice::RemoteLoggerPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(::Ice::RemoteLogger::ice_staticId(), v);
    }
}

ICE_API ::Ice::Object* Ice::upCast(::Ice::LoggerAdmin* p) { return p; }

namespace
{
const ::std::string __Ice__LoggerAdmin_ids[2] =
{
    "::Ice::LoggerAdmin",
    "::Ice::Object"
};

}

bool
Ice::LoggerAdmin::ice_isA(const ::std::string& _s, const ::Ice::Current&) const
{
    return ::std::binary_search(__Ice__LoggerAdmin_ids, __Ice__LoggerAdmin_ids + 2, _s);
}

::std::vector< ::std::string>
Ice::LoggerAdmin::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&__Ice__LoggerAdmin_ids[0], &__Ice__LoggerAdmin_ids[2]);
}

const ::std::string&
Ice::LoggerAdmin::ice_id(const ::Ice::Current&) const
{
    return __Ice__LoggerAdmin_ids[0];
}

const ::std::string&
Ice::LoggerAdmin::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::LoggerAdmin";
    return typeId;
#else
    return __Ice__LoggerAdmin_ids[0];
#endif
}

::Ice::DispatchStatus
Ice::LoggerAdmin::___attachRemoteLogger(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::Ice::RemoteLoggerPrx __p_prx;
    ::Ice::LogMessageTypeSeq __p_messageTypes;
    ::Ice::StringSeq __p_traceCategories;
    ::Ice::Int __p_messageMax;
    __is->read(__p_prx);
    __is->read(__p_messageTypes);
    __is->read(__p_traceCategories);
    __is->read(__p_messageMax);
    __inS.endReadParams();
    try
    {
        attachRemoteLogger(__p_prx, __p_messageTypes, __p_traceCategories, __p_messageMax, __current);
        __inS.__writeEmptyParams();
        return ::Ice::DispatchOK;
    }
    catch(const ::Ice::RemoteLoggerAlreadyAttachedException& __ex)
    {
        __inS.__writeUserException(__ex, ::Ice::DefaultFormat);
    }
    return ::Ice::DispatchUserException;
}

::Ice::DispatchStatus
Ice::LoggerAdmin::___detachRemoteLogger(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::Ice::RemoteLoggerPrx __p_prx;
    __is->read(__p_prx);
    __inS.endReadParams();
    bool __ret = detachRemoteLogger(__p_prx, __current);
    ::IceInternal::BasicStream* __os = __inS.__startWriteParams(::Ice::DefaultFormat);
    __os->write(__ret);
    __inS.__endWriteParams(true);
    return ::Ice::DispatchOK;
}

::Ice::DispatchStatus
Ice::LoggerAdmin::___getLog(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::Ice::LogMessageTypeSeq __p_messageTypes;
    ::Ice::StringSeq __p_traceCategories;
    ::Ice::Int __p_messageMax;
    __is->read(__p_messageTypes);
    __is->read(__p_traceCategories);
    __is->read(__p_messageMax);
    __inS.endReadParams();
    ::std::string __p_prefix;
    ::Ice::LogMessageSeq __ret = getLog(__p_messageTypes, __p_traceCategories, __p_messageMax, __p_prefix, __current);
    ::IceInternal::BasicStream* __os = __inS.__startWriteParams(::Ice::DefaultFormat);
    __os->write(__p_prefix);
    __os->write(__ret);
    __inS.__endWriteParams(true);
    return ::Ice::DispatchOK;
}

namespace
{
const ::std::string __Ice__LoggerAdmin_all[] =
{
    "attachRemoteLogger",
    "detachRemoteLogger",
    "getLog",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

::Ice::DispatchStatus
Ice::LoggerAdmin::__dispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair< const ::std::string*, const ::std::string*> r = ::std::equal_range(__Ice__LoggerAdmin_all, __Ice__LoggerAdmin_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - __Ice__LoggerAdmin_all)
    {
        case 0:
        {
            return ___attachRemoteLogger(in, current);
        }
        case 1:
        {
            return ___detachRemoteLogger(in, current);
        }
        case 2:
        {
            return ___getLog(in, current);
        }
        case 3:
        {
            return ___ice_id(in, current);
        }
        case 4:
        {
            return ___ice_ids(in, current);
        }
        case 5:
        {
            return ___ice_isA(in, current);
        }
        case 6:
        {
            return ___ice_ping(in, current);
        }
    }

    assert(false);
    throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
}

void
Ice::LoggerAdmin::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice(ice_staticId(), -1, true);
    __os->endWriteSlice();
}

void
Ice::LoggerAdmin::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

void ICE_API 
Ice::__patch(LoggerAdminPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ::Ice::LoggerAdminPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(::Ice::LoggerAdmin::ice_staticId(), v);
    }
}
