# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.1
#
# <auto-generated>
#
# Generated from file `UserAccountMapper.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy

# Start of module IceGrid
_M_IceGrid = Ice.openModule('IceGrid')
__name__ = 'IceGrid'

if 'UserAccountNotFoundException' not in _M_IceGrid.__dict__:
    _M_IceGrid.UserAccountNotFoundException = Ice.createTempClass()
    class UserAccountNotFoundException(Ice.UserException):
        '''This exception is raised if a user account for a given session
identifier can't be found.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceGrid::UserAccountNotFoundException'

    _M_IceGrid._t_UserAccountNotFoundException = IcePy.defineException('::IceGrid::UserAccountNotFoundException', UserAccountNotFoundException, (), False, None, ())
    UserAccountNotFoundException._ice_type = _M_IceGrid._t_UserAccountNotFoundException

    _M_IceGrid.UserAccountNotFoundException = UserAccountNotFoundException
    del UserAccountNotFoundException

if 'UserAccountMapper' not in _M_IceGrid.__dict__:
    _M_IceGrid.UserAccountMapper = Ice.createTempClass()
    class UserAccountMapper(Ice.Object):
        '''A user account mapper object is used by IceGrid nodes to map
session identifiers to user accounts.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.UserAccountMapper:
                raise RuntimeError('IceGrid.UserAccountMapper is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::UserAccountMapper')

        def ice_id(self, current=None):
            return '::IceGrid::UserAccountMapper'

        def ice_staticId():
            return '::IceGrid::UserAccountMapper'
        ice_staticId = staticmethod(ice_staticId)

        def getUserAccount(self, user, current=None):
            '''Get the name of the user account for the given user. This is
used by IceGrid nodes to figure out the user account to use
to run servers.

Arguments:
    user The value of the server descriptor's user
attribute. If this attribute is not defined, and the server's
activation mode is session, the default value of
user is the session identifier.

Returns:
    The user account name.

Exceptions:
    UserAccountNotFoundException Raised if no user account
is found for the given user.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_UserAccountMapper)

        __repr__ = __str__

    _M_IceGrid.UserAccountMapperPrx = Ice.createTempClass()
    class UserAccountMapperPrx(Ice.ObjectPrx):

        '''Get the name of the user account for the given user. This is
used by IceGrid nodes to figure out the user account to use
to run servers.

Arguments:
    user The value of the server descriptor's user
attribute. If this attribute is not defined, and the server's
activation mode is session, the default value of
user is the session identifier.

Returns:
    The user account name.

Exceptions:
    UserAccountNotFoundException Raised if no user account
is found for the given user.'''
        def getUserAccount(self, user, _ctx=None):
            return _M_IceGrid.UserAccountMapper._op_getUserAccount.invoke(self, ((user, ), _ctx))

        '''Get the name of the user account for the given user. This is
used by IceGrid nodes to figure out the user account to use
to run servers.

Arguments:
    user The value of the server descriptor's user
attribute. If this attribute is not defined, and the server's
activation mode is session, the default value of
user is the session identifier.

Returns:
    The user account name.

Exceptions:
    UserAccountNotFoundException Raised if no user account
is found for the given user.'''
        def begin_getUserAccount(self, user, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.UserAccountMapper._op_getUserAccount.begin(self, ((user, ), _response, _ex, _sent, _ctx))

        '''Get the name of the user account for the given user. This is
used by IceGrid nodes to figure out the user account to use
to run servers.

Arguments:
    user The value of the server descriptor's user
attribute. If this attribute is not defined, and the server's
activation mode is session, the default value of
user is the session identifier.

Returns:
    The user account name.

Exceptions:
    UserAccountNotFoundException Raised if no user account
is found for the given user.'''
        def end_getUserAccount(self, _r):
            return _M_IceGrid.UserAccountMapper._op_getUserAccount.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.UserAccountMapperPrx.ice_checkedCast(proxy, '::IceGrid::UserAccountMapper', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.UserAccountMapperPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::UserAccountMapper'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_UserAccountMapperPrx = IcePy.defineProxy('::IceGrid::UserAccountMapper', UserAccountMapperPrx)

    _M_IceGrid._t_UserAccountMapper = IcePy.defineClass('::IceGrid::UserAccountMapper', UserAccountMapper, -1, (), True, False, None, (), ())
    UserAccountMapper._ice_type = _M_IceGrid._t_UserAccountMapper

    UserAccountMapper._op_getUserAccount = IcePy.Operation('getUserAccount', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_string, False, 0), (_M_IceGrid._t_UserAccountNotFoundException,))

    _M_IceGrid.UserAccountMapper = UserAccountMapper
    del UserAccountMapper

    _M_IceGrid.UserAccountMapperPrx = UserAccountMapperPrx
    del UserAccountMapperPrx

# End of module IceGrid

Ice.sliceChecksums["::IceGrid::UserAccountMapper"] = "779fd561878e199444e04cdebaf9ffd4"
Ice.sliceChecksums["::IceGrid::UserAccountNotFoundException"] = "fe2dc4d87f21b9b2cf6f1339d1666281"
