# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IndexingPolicy(Model):
    """Cosmos DB indexing policy.

    :param automatic: Indicates if the indexing policy is automatic
    :type automatic: bool
    :param indexing_mode: Indicates the indexing mode. Possible values
     include: 'Consistent', 'Lazy', 'None'. Default value: "Consistent" .
    :type indexing_mode: str or ~azure.mgmt.cosmosdb.models.IndexingMode
    :param included_paths: List of paths to include in the indexing
    :type included_paths: list[~azure.mgmt.cosmosdb.models.IncludedPath]
    :param excluded_paths: List of paths to exclude from indexing
    :type excluded_paths: list[~azure.mgmt.cosmosdb.models.ExcludedPath]
    """

    _attribute_map = {
        'automatic': {'key': 'automatic', 'type': 'bool'},
        'indexing_mode': {'key': 'indexingMode', 'type': 'str'},
        'included_paths': {'key': 'includedPaths', 'type': '[IncludedPath]'},
        'excluded_paths': {'key': 'excludedPaths', 'type': '[ExcludedPath]'},
    }

    def __init__(self, **kwargs):
        super(IndexingPolicy, self).__init__(**kwargs)
        self.automatic = kwargs.get('automatic', None)
        self.indexing_mode = kwargs.get('indexing_mode', "Consistent")
        self.included_paths = kwargs.get('included_paths', None)
        self.excluded_paths = kwargs.get('excluded_paths', None)
