/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scripting.helper.selection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scripting.helper.selection.Condition;
import org.ow2.proactive.scripting.helper.selection.Conditions;

@PublicAPI
public class SelectionUtils {
    public static final int LESS_THAN = 1;
    public static final int GREATER_THAN = 2;
    public static final int EQUAL = 3;
    public static final int CONTAINS = 4;
    private static final String winTestCuda = "deviceQueryWin.exe";
    private static final String unixTestCuda = "deviceQueryUnix";
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private static boolean isJ6 = !System.getProperty("java.version").contains("1.5");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkProperties(String configFilePath, Conditions conditions) {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(configFilePath);){
            Condition condition;
            properties.load(fis);
            Iterator iterator = conditions.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while (SelectionUtils.checkProperty(properties, condition = (Condition)iterator.next()));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkProperty(Properties props, Condition condition) {
        String key = condition.getName();
        try {
            switch (condition.getOperator()) {
                case 1: {
                    return Double.parseDouble(props.getProperty(key)) < Double.parseDouble(condition.getValue());
                }
                case 2: {
                    return Double.parseDouble(props.getProperty(key)) > Double.parseDouble(condition.getValue());
                }
                case 3: {
                    return props.getProperty(key).equals(condition.getValue());
                }
                case 4: {
                    return props.getProperty(key).contains(condition.getValue());
                }
            }
            System.out.println("Invalid operator, please use INFERIOR, SUPERIOR, MATCH or EQUAL");
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean checkProperty(String configFilePath, Condition condition) {
        Properties props = new Properties();
        try (FileInputStream stream = new FileInputStream(configFilePath);){
            props.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return SelectionUtils.checkProperty(props, condition);
    }

    public static boolean checkHostName(String hostName) {
        if (hostName == null) {
            System.err.println("Given HOST name was NULL");
            return false;
        }
        try {
            String localHost = InetAddress.getLocalHost().getHostName();
            Pattern regex = Pattern.compile(hostName, 2);
            Matcher regexMatcher = regex.matcher(localHost);
            return regexMatcher.find();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean checkIp(String network) {
        String[] networkClasses = network.trim().split("\\.");
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(networks)) {
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    try {
                        String ip = inetAddress.getHostAddress();
                        String[] ipClasses = ip.trim().split("\\.");
                        boolean res = true;
                        for (int i = 0; i < ipClasses.length; ++i) {
                            networkClasses[i] = networkClasses[i].replaceAll("\\*", ".*");
                            Pattern regex = Pattern.compile(networkClasses[i], 2);
                            Matcher regexMatcher = regex.matcher(ipClasses[i]);
                            if (regexMatcher.find()) continue;
                            res = false;
                        }
                        if (!res) continue;
                        return true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean checkFileExist(String filePath) {
        return new File(filePath).exists();
    }

    public static boolean checkOSName(String exp) {
        if (exp == null) {
            System.err.println("Given OS name was NULL");
            return false;
        }
        String localOS = System.getProperty("os.name");
        try {
            Pattern regex = Pattern.compile(exp, 2);
            Matcher regexMatcher = regex.matcher(localOS);
            return regexMatcher.find();
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean checkOSArch(String osArch) {
        if (osArch == null) {
            System.err.println("Given OS architecture was NULL");
            return false;
        }
        String localOSArch = System.getProperty("os.arch");
        return localOSArch.toUpperCase().contains(osArch.toUpperCase());
    }

    public static boolean checkOSVersion(String osVersion) {
        if (osVersion == null) {
            System.err.println("Given OS version was NULL");
            return false;
        }
        String localOSVersion = System.getProperty("os.version");
        return localOSVersion.contains(osVersion);
    }

    public static boolean checkJavaProperty(String propertyName, String propertyValue) {
        if (propertyName == null) {
            System.err.println("Given property Name was NULL");
            return false;
        }
        if (propertyValue == null) {
            System.err.println("Given property Value was NULL");
            return false;
        }
        try {
            String vmPropValue = System.getProperty(propertyName);
            Pattern regex = Pattern.compile(propertyValue, 2);
            Matcher regexMatcher = regex.matcher(vmPropValue);
            return regexMatcher.find();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkCudaWin() {
        if (!isWindows) {
            System.err.println("Error trying to check Cuda library : the system must be under Windows.");
            return false;
        }
        File tmp = null;
        try {
            int len;
            InputStream is = SelectionUtils.class.getResourceAsStream(winTestCuda);
            tmp = File.createTempFile("wcuda", ".exe");
            FileOutputStream fos = new FileOutputStream(tmp);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            is.close();
            fos.close();
            Process p = Runtime.getRuntime().exec(tmp.getAbsolutePath());
            p.waitFor();
            boolean bl = p.exitValue() > 0;
            return bl;
        }
        catch (IllegalMonitorStateException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException in) {
            in.printStackTrace();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
        return false;
    }

    public static boolean checkFreeMemory(long requiredMemory) {
        return Runtime.getRuntime().freeMemory() >= requiredMemory;
    }

    public static boolean checkExec(String fileName) {
        String[] tokens;
        String path = System.getenv("PATH");
        for (String folder : tokens = path.split(File.pathSeparator)) {
            File directory = new File(folder);
            if (!directory.exists()) {
                System.err.println(folder + " doesn't exist");
                continue;
            }
            if (!directory.isDirectory()) {
                System.err.println(folder + "' is not a directory");
                continue;
            }
            File[] subfiles = directory.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                if (!subfiles[i].getName().equals(fileName)) continue;
                return true;
            }
        }
        System.err.println(fileName + " is not in PATH environment variable.");
        return false;
    }

    public static boolean checkWifi() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface currentInterface = interfaces.nextElement();
                if (!currentInterface.getName().contains("wlan")) continue;
                return true;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean checkFreeSpaceDiskAvailable(Long space, String path) {
        if (!isJ6) {
            System.err.println("Check only available with java 6 or later.");
            return false;
        }
        if (path == null || space == null) {
            return false;
        }
        try {
            File file = new File(path);
            Method m = File.class.getDeclaredMethod("getFreeSpace", new Class[0]);
            return space <= (Long)m.invoke((Object)file, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean checkFreeSpaceDiskAvailableForTmpDir(Long space) {
        return SelectionUtils.checkFreeSpaceDiskAvailable(space, System.getProperty("java.io.tmpdir"));
    }
}

