/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.ArrayCommand;
import py4j.CallCommand;
import py4j.Command;
import py4j.ConstructorCommand;
import py4j.FieldCommand;
import py4j.Gateway;
import py4j.GatewayServer;
import py4j.HelpPageCommand;
import py4j.ListCommand;
import py4j.MemoryCommand;
import py4j.NetworkUtil;
import py4j.ReflectionCommand;
import py4j.ShutdownGatewayServerCommand;

public class GatewayConnection
implements Runnable {
    private final Gateway gateway;
    private final GatewayServer gatewayServer;
    private final Socket socket;
    private final BufferedWriter writer;
    private final BufferedReader reader;
    private final Map<String, Command> commands;
    private final Logger logger = Logger.getLogger(GatewayConnection.class.getName());

    public GatewayConnection(GatewayServer gatewayServer, Gateway gateway, Socket socket) throws IOException {
        this.gateway = gateway;
        this.gatewayServer = gatewayServer;
        this.socket = socket;
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), Charset.forName("UTF-8")));
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charset.forName("UTF-8")));
        this.commands = new HashMap<String, Command>();
        this.initCommands(gateway);
        Thread t = new Thread(this);
        t.start();
    }

    protected void initCommands(Gateway gateway) {
        CallCommand callCommand = new CallCommand();
        FieldCommand fieldCommand = new FieldCommand();
        ConstructorCommand constructorCommand = new ConstructorCommand();
        MemoryCommand memoryCommand = new MemoryCommand();
        ListCommand listCommand = new ListCommand();
        ReflectionCommand reflectionCommand = new ReflectionCommand();
        ShutdownGatewayServerCommand shutdownCommand = new ShutdownGatewayServerCommand(this.gatewayServer);
        HelpPageCommand helpCommand = new HelpPageCommand();
        ArrayCommand arrayCommand = new ArrayCommand();
        callCommand.init(gateway);
        fieldCommand.init(gateway);
        constructorCommand.init(gateway);
        memoryCommand.init(gateway);
        listCommand.init(gateway);
        reflectionCommand.init(gateway);
        shutdownCommand.init(gateway);
        helpCommand.init(gateway);
        arrayCommand.init(gateway);
        this.commands.put("c", callCommand);
        this.commands.put("f", fieldCommand);
        this.commands.put("i", constructorCommand);
        this.commands.put("m", memoryCommand);
        this.commands.put("l", listCommand);
        this.commands.put("r", reflectionCommand);
        this.commands.put("s", shutdownCommand);
        this.commands.put("h", helpCommand);
        this.commands.put("a", arrayCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logger.info("Gateway Connection ready to receive messages");
            String commandLine = null;
            do {
                commandLine = this.reader.readLine();
                this.logger.info("Received command: " + commandLine);
                Command command = this.commands.get(commandLine);
                if (command == null) continue;
                command.execute(commandLine, this.reader, this.writer);
            } while (commandLine != null && !commandLine.equals(Character.valueOf('q')));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error occurred while waiting for a command.", e);
        }
        finally {
            this.logger.log(Level.INFO, "Closing connection.");
            NetworkUtil.quietlyClose(this.socket);
            this.gateway.closeConnection();
        }
    }
}

