import sys
from flopy.mbase import Package

class ModflowGmg(Package):
    '''GMG package
    Only programmed to work with the default values; may need work for other options'''
    def __init__(self, model, mxiter=50, iiter=30, iadamp=0, \
                 hclose=1e-5, rclose=1e-5, relax=1.0, ioutgmg=0, \
                 ism=0, isc=0, damp=1.0,dup=0.75,dlow=0.01,\
                 chglimit=1.0,extension='gmg', unitnumber=27):
        Package.__init__(self, model, extension, 'GMG', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# GMG for MODFLOW, generated by Flopy.'
        self.url = 'gmg.htm'
        self.mxiter = mxiter
        self.iiter = iiter
        self.iadamp = iadamp
        self.hclose = hclose
        self.rclose = rclose
        self.relax = relax
        self.ism = ism
        self.isc = isc
        self.dup = dup
        self.dlow = dlow
        self.chglimit = chglimit
        self.damp = damp
        self.ioutgmg = ioutgmg
        self.iunitmhc = 0
        self.parent.add_package(self)

    def __repr__( self ):
        return 'Geometric multigrid solver package class'

    def write_file(self):
        # Open file for writing
        f_gmg = open(self.fn_path, 'w')
        f_gmg.write('%s\n' % self.heading)        
        #--ds0
        f_gmg.write('{0:9.3e} {1:9d} {2:9.3e} {3:9d}\n'\
             .format(self.rclose,self.iiter,self.hclose,self.mxiter))        
        #--ds1
        f_gmg.write('{0:9.3e} {1:9d} {2:9d} {3:9d}\n'\
             .format(self.damp,self.iadamp,self.ioutgmg,self.iunitmhc))
        #--ds2
        f_gmg.write('{0:9d} {1:9d} {2:9.3e} {3:9.3e} {4:9.3e}\n'\
             .format(self.ism,self.isc,self.dup,self.dlow,self.chglimit))
        #--ds3
        f_gmg.write('{0:10.3e}\n'.format(self.relax))
        f_gmg.close()


    @staticmethod
    def load(f, model, ext_unit_dict=None):
        """
        Load an existing package.

        Parameters
        ----------
        f : filename or file handle
            File to load.
        model : model object
            The model object (of type :class:`flopy.modflow.mf.Modflow`) to
            which this package will be added.
        ext_unit_dict : dictionary, optional
            If the arrays in the file are specified using EXTERNAL,
            or older style array control records, then `f` should be a file
            handle.  In this case ext_unit_dict is required, which can be
            constructed using the function
            :class:`flopy.utils.mfreadnam.parsenamefile`.

        Returns
        -------
        gmg : ModflowGmg object

        Examples
        --------

        >>> import flopy
        >>> m = flopy.modflow.Modflow()
        >>> gmg = flopy.modflow.ModflowGmg.load('test.gmg', m)

        """

        if model.verbose:
            sys.stdout.write('loading gmg package file...\n')

        if type(f) is not file:
            filename = f
            f = open(filename, 'r')
        #dataset 0 -- header

        print '   Warning: load method not completed. default gmg object created.'

        #--close the open file
        f.close()

        gmg = ModflowGmg(model)
        return gmg
