# -*- coding: utf-8 -*-
import os
import json
import addict


class EasyConfig(object):
    __config_data = None
    __config_path = None
    __wipe_old_data = False

    def __init__(self, config_path, wipe_old_data=False):
        """
        :param config_path: 配置文件路径
        :param wipe_old_data: 如果存在配置文件， 是否清空旧的内容
        :return:
        """
        EasyConfig.__config_path = config_path
        EasyConfig.__wipe_old_data = wipe_old_data
        self.__load_config()

    def __load_config(self):
        if os.path.exists(EasyConfig.__config_path) and not EasyConfig.__wipe_old_data:
            with open(EasyConfig.__config_path) as f:
                data = f.read().strip()
                EasyConfig.__config_data = addict.Dict(eval(data)) if data else addict.Dict()
        else:
            EasyConfig.__config_data = addict.Dict()

    def __save_config(self):
        with open(EasyConfig.__config_path, "w") as f:
            format_data = json.dumps(EasyConfig.__config_data, sort_keys=False, indent=4)
            f.write(format_data)

    def __setattr__(self, name, value):
        self.__setitem__(name, value)

    def __setitem__(self, name, value):
        EasyConfig.__config_data[name] = value

    def __getattr__(self, item):
        return self.__getitem__(item)

    def __getitem__(self, name):
        item = EasyConfig.__config_data[name]
        if not item:
            EasyConfig.__config_data[name] = {}
        return EasyConfig.__config_data[name]

    def __delattr__(self, name):
        self.__delitem__(name)

    def __delitem__(self, key):
        del EasyConfig.__config_data[key]
        self.__save_config()

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.__save_config()

    def __str__(self):
        return str(EasyConfig.__config_data)

    def save(self):
        self.__save_config()

