#   Copyright (C) 2006 Ludovic Rousseau (ludovic.rousseau@free.fr)
#
# This file is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import PyKCS11.LowLevel
import os

# redefine PKCS#11 constants
CK_TRUE = PyKCS11.LowLevel.CK_TRUE
CK_FALSE = PyKCS11.LowLevel.CK_FALSE
CK_UNAVAILABLE_INFORMATION = PyKCS11.LowLevel.CK_UNAVAILABLE_INFORMATION
CK_EFFECTIVELY_INFINITE = PyKCS11.LowLevel.CK_EFFECTIVELY_INFINITE
CK_INVALID_HANDLE = PyKCS11.LowLevel.CK_INVALID_HANDLE

CKU_SO = PyKCS11.LowLevel.CKU_SO
CKU_USER = PyKCS11.LowLevel.CKU_USER

CKF_SERIAL_SESSION = PyKCS11.LowLevel.CKF_SERIAL_SESSION
CKF_RW_SESSION = PyKCS11.LowLevel.CKF_RW_SESSION

CKF_RNG = PyKCS11.LowLevel.CKF_RNG
CKF_WRITE_PROTECTED = PyKCS11.LowLevel.CKF_WRITE_PROTECTED
CKF_LOGIN_REQUIRED = PyKCS11.LowLevel.CKF_LOGIN_REQUIRED
CKF_USER_PIN_INITIALIZED = PyKCS11.LowLevel.CKF_USER_PIN_INITIALIZED
CKF_RESTORE_KEY_NOT_NEEDED = PyKCS11.LowLevel.CKF_RESTORE_KEY_NOT_NEEDED
CKF_CLOCK_ON_TOKEN = PyKCS11.LowLevel.CKF_CLOCK_ON_TOKEN
CKF_PROTECTED_AUTHENTICATION_PATH = PyKCS11.LowLevel.CKF_PROTECTED_AUTHENTICATION_PATH
CKF_DUAL_CRYPTO_OPERATIONS = PyKCS11.LowLevel.CKF_DUAL_CRYPTO_OPERATIONS
CKF_TOKEN_INITIALIZED = PyKCS11.LowLevel.CKF_TOKEN_INITIALIZED
CKF_SECONDARY_AUTHENTICATION = PyKCS11.LowLevel.CKF_SECONDARY_AUTHENTICATION
CKF_USER_PIN_COUNT_LOW = PyKCS11.LowLevel.CKF_USER_PIN_COUNT_LOW
CKF_USER_PIN_FINAL_TRY = PyKCS11.LowLevel.CKF_USER_PIN_FINAL_TRY
CKF_USER_PIN_LOCKED = PyKCS11.LowLevel.CKF_USER_PIN_LOCKED
CKF_USER_PIN_TO_BE_CHANGED = PyKCS11.LowLevel.CKF_USER_PIN_TO_BE_CHANGED
CKF_SO_PIN_COUNT_LOW = PyKCS11.LowLevel.CKF_SO_PIN_COUNT_LOW
CKF_SO_PIN_FINAL_TRY = PyKCS11.LowLevel.CKF_SO_PIN_FINAL_TRY
CKF_SO_PIN_LOCKED = PyKCS11.LowLevel.CKF_SO_PIN_LOCKED
CKF_SO_PIN_TO_BE_CHANGED = PyKCS11.LowLevel.CKF_SO_PIN_TO_BE_CHANGED

CKF_TOKEN_PRESENT = PyKCS11.LowLevel.CKF_TOKEN_PRESENT
CKF_REMOVABLE_DEVICE = PyKCS11.LowLevel.CKF_REMOVABLE_DEVICE
CKF_HW_SLOT = PyKCS11.LowLevel.CKF_HW_SLOT

CKR_OK = PyKCS11.LowLevel.CKR_OK
CKR_CANCEL = PyKCS11.LowLevel.CKR_CANCEL
CKR_HOST_MEMORY = PyKCS11.LowLevel.CKR_HOST_MEMORY
CKR_SLOT_ID_INVALID = PyKCS11.LowLevel.CKR_SLOT_ID_INVALID
CKR_GENERAL_ERROR = PyKCS11.LowLevel.CKR_GENERAL_ERROR
CKR_FUNCTION_FAILED = PyKCS11.LowLevel.CKR_FUNCTION_FAILED
CKR_ARGUMENTS_BAD = PyKCS11.LowLevel.CKR_ARGUMENTS_BAD
CKR_NO_EVENT = PyKCS11.LowLevel.CKR_NO_EVENT
CKR_NEED_TO_CREATE_THREADS = PyKCS11.LowLevel.CKR_NEED_TO_CREATE_THREADS
CKR_CANT_LOCK = PyKCS11.LowLevel.CKR_CANT_LOCK
CKR_ATTRIBUTE_READ_ONLY = PyKCS11.LowLevel.CKR_ATTRIBUTE_READ_ONLY
CKR_ATTRIBUTE_SENSITIVE = PyKCS11.LowLevel.CKR_ATTRIBUTE_SENSITIVE
CKR_ATTRIBUTE_TYPE_INVALID = PyKCS11.LowLevel.CKR_ATTRIBUTE_TYPE_INVALID
CKR_ATTRIBUTE_VALUE_INVALID = PyKCS11.LowLevel.CKR_ATTRIBUTE_VALUE_INVALID
CKR_DATA_INVALID = PyKCS11.LowLevel.CKR_DATA_INVALID
CKR_DATA_LEN_RANGE = PyKCS11.LowLevel.CKR_DATA_LEN_RANGE
CKR_DEVICE_ERROR = PyKCS11.LowLevel.CKR_DEVICE_ERROR
CKR_DEVICE_MEMORY = PyKCS11.LowLevel.CKR_DEVICE_MEMORY
CKR_DEVICE_REMOVED = PyKCS11.LowLevel.CKR_DEVICE_REMOVED
CKR_ENCRYPTED_DATA_INVALID = PyKCS11.LowLevel.CKR_ENCRYPTED_DATA_INVALID
CKR_ENCRYPTED_DATA_LEN_RANGE = PyKCS11.LowLevel.CKR_ENCRYPTED_DATA_LEN_RANGE
CKR_FUNCTION_CANCELED = PyKCS11.LowLevel.CKR_FUNCTION_CANCELED
CKR_FUNCTION_NOT_PARALLEL = PyKCS11.LowLevel.CKR_FUNCTION_NOT_PARALLEL
CKR_FUNCTION_NOT_SUPPORTED = PyKCS11.LowLevel.CKR_FUNCTION_NOT_SUPPORTED
CKR_KEY_HANDLE_INVALID = PyKCS11.LowLevel.CKR_KEY_HANDLE_INVALID
CKR_KEY_SIZE_RANGE = PyKCS11.LowLevel.CKR_KEY_SIZE_RANGE
CKR_KEY_TYPE_INCONSISTENT = PyKCS11.LowLevel.CKR_KEY_TYPE_INCONSISTENT
CKR_KEY_NOT_NEEDED = PyKCS11.LowLevel.CKR_KEY_NOT_NEEDED
CKR_KEY_CHANGED = PyKCS11.LowLevel.CKR_KEY_CHANGED
CKR_KEY_NEEDED = PyKCS11.LowLevel.CKR_KEY_NEEDED
CKR_KEY_INDIGESTIBLE = PyKCS11.LowLevel.CKR_KEY_INDIGESTIBLE
CKR_KEY_FUNCTION_NOT_PERMITTED = PyKCS11.LowLevel.CKR_KEY_FUNCTION_NOT_PERMITTED
CKR_KEY_NOT_WRAPPABLE = PyKCS11.LowLevel.CKR_KEY_NOT_WRAPPABLE
CKR_KEY_UNEXTRACTABLE = PyKCS11.LowLevel.CKR_KEY_UNEXTRACTABLE
CKR_MECHANISM_INVALID = PyKCS11.LowLevel.CKR_MECHANISM_INVALID
CKR_MECHANISM_PARAM_INVALID = PyKCS11.LowLevel.CKR_MECHANISM_PARAM_INVALID
CKR_OBJECT_HANDLE_INVALID = PyKCS11.LowLevel.CKR_OBJECT_HANDLE_INVALID
CKR_OPERATION_ACTIVE = PyKCS11.LowLevel.CKR_OPERATION_ACTIVE
CKR_OPERATION_NOT_INITIALIZED = PyKCS11.LowLevel.CKR_OPERATION_NOT_INITIALIZED
CKR_PIN_INCORRECT = PyKCS11.LowLevel.CKR_PIN_INCORRECT
CKR_PIN_INVALID = PyKCS11.LowLevel.CKR_PIN_INVALID
CKR_PIN_LEN_RANGE = PyKCS11.LowLevel.CKR_PIN_LEN_RANGE
CKR_PIN_EXPIRED = PyKCS11.LowLevel.CKR_PIN_EXPIRED
CKR_PIN_LOCKED = PyKCS11.LowLevel.CKR_PIN_LOCKED
CKR_SESSION_CLOSED = PyKCS11.LowLevel.CKR_SESSION_CLOSED
CKR_SESSION_COUNT = PyKCS11.LowLevel.CKR_SESSION_COUNT
CKR_SESSION_HANDLE_INVALID = PyKCS11.LowLevel.CKR_SESSION_HANDLE_INVALID
CKR_SESSION_PARALLEL_NOT_SUPPORTED = PyKCS11.LowLevel.CKR_SESSION_PARALLEL_NOT_SUPPORTED
CKR_SESSION_READ_ONLY = PyKCS11.LowLevel.CKR_SESSION_READ_ONLY
CKR_SESSION_EXISTS = PyKCS11.LowLevel.CKR_SESSION_EXISTS
CKR_SESSION_READ_ONLY_EXISTS = PyKCS11.LowLevel.CKR_SESSION_READ_ONLY_EXISTS
CKR_SESSION_READ_WRITE_SO_EXISTS = PyKCS11.LowLevel.CKR_SESSION_READ_WRITE_SO_EXISTS
CKR_SIGNATURE_INVALID = PyKCS11.LowLevel.CKR_SIGNATURE_INVALID
CKR_SIGNATURE_LEN_RANGE = PyKCS11.LowLevel.CKR_SIGNATURE_LEN_RANGE
CKR_TEMPLATE_INCOMPLETE = PyKCS11.LowLevel.CKR_TEMPLATE_INCOMPLETE
CKR_TEMPLATE_INCONSISTENT = PyKCS11.LowLevel.CKR_TEMPLATE_INCONSISTENT
CKR_TOKEN_NOT_PRESENT = PyKCS11.LowLevel.CKR_TOKEN_NOT_PRESENT
CKR_TOKEN_NOT_RECOGNIZED = PyKCS11.LowLevel.CKR_TOKEN_NOT_RECOGNIZED
CKR_TOKEN_WRITE_PROTECTED = PyKCS11.LowLevel.CKR_TOKEN_WRITE_PROTECTED
CKR_UNWRAPPING_KEY_HANDLE_INVALID = PyKCS11.LowLevel.CKR_UNWRAPPING_KEY_HANDLE_INVALID
CKR_UNWRAPPING_KEY_SIZE_RANGE = PyKCS11.LowLevel.CKR_UNWRAPPING_KEY_SIZE_RANGE
CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT = PyKCS11.LowLevel.CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT
CKR_USER_ALREADY_LOGGED_IN = PyKCS11.LowLevel.CKR_USER_ALREADY_LOGGED_IN
CKR_USER_NOT_LOGGED_IN = PyKCS11.LowLevel.CKR_USER_NOT_LOGGED_IN
CKR_USER_PIN_NOT_INITIALIZED = PyKCS11.LowLevel.CKR_USER_PIN_NOT_INITIALIZED
CKR_USER_TYPE_INVALID = PyKCS11.LowLevel.CKR_USER_TYPE_INVALID
CKR_USER_ANOTHER_ALREADY_LOGGED_IN = PyKCS11.LowLevel.CKR_USER_ANOTHER_ALREADY_LOGGED_IN
CKR_USER_TOO_MANY_TYPES = PyKCS11.LowLevel.CKR_USER_TOO_MANY_TYPES
CKR_WRAPPED_KEY_INVALID = PyKCS11.LowLevel.CKR_WRAPPED_KEY_INVALID
CKR_WRAPPED_KEY_LEN_RANGE = PyKCS11.LowLevel.CKR_WRAPPED_KEY_LEN_RANGE
CKR_WRAPPING_KEY_HANDLE_INVALID = PyKCS11.LowLevel.CKR_WRAPPING_KEY_HANDLE_INVALID
CKR_WRAPPING_KEY_SIZE_RANGE = PyKCS11.LowLevel.CKR_WRAPPING_KEY_SIZE_RANGE
CKR_WRAPPING_KEY_TYPE_INCONSISTENT = PyKCS11.LowLevel.CKR_WRAPPING_KEY_TYPE_INCONSISTENT
CKR_RANDOM_SEED_NOT_SUPPORTED = PyKCS11.LowLevel.CKR_RANDOM_SEED_NOT_SUPPORTED
CKR_RANDOM_NO_RNG = PyKCS11.LowLevel.CKR_RANDOM_NO_RNG
CKR_DOMAIN_PARAMS_INVALID = PyKCS11.LowLevel.CKR_DOMAIN_PARAMS_INVALID
CKR_BUFFER_TOO_SMALL = PyKCS11.LowLevel.CKR_BUFFER_TOO_SMALL
CKR_SAVED_STATE_INVALID = PyKCS11.LowLevel.CKR_SAVED_STATE_INVALID
CKR_INFORMATION_SENSITIVE = PyKCS11.LowLevel.CKR_INFORMATION_SENSITIVE
CKR_STATE_UNSAVEABLE = PyKCS11.LowLevel.CKR_STATE_UNSAVEABLE
CKR_CRYPTOKI_NOT_INITIALIZED = PyKCS11.LowLevel.CKR_CRYPTOKI_NOT_INITIALIZED
CKR_CRYPTOKI_ALREADY_INITIALIZED = PyKCS11.LowLevel.CKR_CRYPTOKI_ALREADY_INITIALIZED
CKR_MUTEX_BAD = PyKCS11.LowLevel.CKR_MUTEX_BAD
CKR_MUTEX_NOT_LOCKED = PyKCS11.LowLevel.CKR_MUTEX_NOT_LOCKED
CKR_VENDOR_DEFINED = PyKCS11.LowLevel.CKR_VENDOR_DEFINED

CKA_CLASS = PyKCS11.LowLevel.CKA_CLASS
CKA_TOKEN = PyKCS11.LowLevel.CKA_TOKEN
CKA_PRIVATE = PyKCS11.LowLevel.CKA_PRIVATE
CKA_LABEL = PyKCS11.LowLevel.CKA_LABEL
CKA_APPLICATION = PyKCS11.LowLevel.CKA_APPLICATION
CKA_VALUE = PyKCS11.LowLevel.CKA_VALUE
CKA_OBJECT_ID = PyKCS11.LowLevel.CKA_OBJECT_ID
CKA_CERTIFICATE_TYPE = PyKCS11.LowLevel.CKA_CERTIFICATE_TYPE
CKA_ISSUER = PyKCS11.LowLevel.CKA_ISSUER
CKA_SERIAL_NUMBER = PyKCS11.LowLevel.CKA_SERIAL_NUMBER
CKA_AC_ISSUER = PyKCS11.LowLevel.CKA_AC_ISSUER
CKA_OWNER = PyKCS11.LowLevel.CKA_OWNER
CKA_ATTR_TYPES = PyKCS11.LowLevel.CKA_ATTR_TYPES
CKA_TRUSTED = PyKCS11.LowLevel.CKA_TRUSTED
CKA_KEY_TYPE = PyKCS11.LowLevel.CKA_KEY_TYPE
CKA_SUBJECT = PyKCS11.LowLevel.CKA_SUBJECT
CKA_ID = PyKCS11.LowLevel.CKA_ID
CKA_SENSITIVE = PyKCS11.LowLevel.CKA_SENSITIVE
CKA_ENCRYPT = PyKCS11.LowLevel.CKA_ENCRYPT
CKA_DECRYPT = PyKCS11.LowLevel.CKA_DECRYPT
CKA_WRAP = PyKCS11.LowLevel.CKA_WRAP
CKA_UNWRAP = PyKCS11.LowLevel.CKA_UNWRAP
CKA_SIGN = PyKCS11.LowLevel.CKA_SIGN
CKA_SIGN_RECOVER = PyKCS11.LowLevel.CKA_SIGN_RECOVER
CKA_VERIFY = PyKCS11.LowLevel.CKA_VERIFY
CKA_VERIFY_RECOVER = PyKCS11.LowLevel.CKA_VERIFY_RECOVER
CKA_DERIVE = PyKCS11.LowLevel.CKA_DERIVE
CKA_START_DATE = PyKCS11.LowLevel.CKA_START_DATE
CKA_END_DATE = PyKCS11.LowLevel.CKA_END_DATE
CKA_MODULUS = PyKCS11.LowLevel.CKA_MODULUS
CKA_MODULUS_BITS = PyKCS11.LowLevel.CKA_MODULUS_BITS
CKA_PUBLIC_EXPONENT = PyKCS11.LowLevel.CKA_PUBLIC_EXPONENT
CKA_PRIVATE_EXPONENT = PyKCS11.LowLevel.CKA_PRIVATE_EXPONENT
CKA_PRIME_1 = PyKCS11.LowLevel.CKA_PRIME_1
CKA_PRIME_2 = PyKCS11.LowLevel.CKA_PRIME_2
CKA_EXPONENT_1 = PyKCS11.LowLevel.CKA_EXPONENT_1
CKA_EXPONENT_2 = PyKCS11.LowLevel.CKA_EXPONENT_2
CKA_COEFFICIENT = PyKCS11.LowLevel.CKA_COEFFICIENT
CKA_PRIME = PyKCS11.LowLevel.CKA_PRIME
CKA_SUBPRIME = PyKCS11.LowLevel.CKA_SUBPRIME
CKA_BASE = PyKCS11.LowLevel.CKA_BASE
CKA_PRIME_BITS = PyKCS11.LowLevel.CKA_PRIME_BITS
CKA_SUBPRIME_BITS = PyKCS11.LowLevel.CKA_SUBPRIME_BITS
CKA_SUB_PRIME_BITS = PyKCS11.LowLevel.CKA_SUB_PRIME_BITS
CKA_VALUE_BITS = PyKCS11.LowLevel.CKA_VALUE_BITS
CKA_VALUE_LEN = PyKCS11.LowLevel.CKA_VALUE_LEN
CKA_EXTRACTABLE = PyKCS11.LowLevel.CKA_EXTRACTABLE
CKA_LOCAL = PyKCS11.LowLevel.CKA_LOCAL
CKA_NEVER_EXTRACTABLE = PyKCS11.LowLevel.CKA_NEVER_EXTRACTABLE
CKA_ALWAYS_SENSITIVE = PyKCS11.LowLevel.CKA_ALWAYS_SENSITIVE
CKA_KEY_GEN_MECHANISM = PyKCS11.LowLevel.CKA_KEY_GEN_MECHANISM
CKA_MODIFIABLE = PyKCS11.LowLevel.CKA_MODIFIABLE
CKA_ECDSA_PARAMS = PyKCS11.LowLevel.CKA_ECDSA_PARAMS
CKA_EC_PARAMS = PyKCS11.LowLevel.CKA_EC_PARAMS
CKA_EC_POINT = PyKCS11.LowLevel.CKA_EC_POINT
CKA_SECONDARY_AUTH = PyKCS11.LowLevel.CKA_SECONDARY_AUTH
CKA_AUTH_PIN_FLAGS = PyKCS11.LowLevel.CKA_AUTH_PIN_FLAGS
CKA_HW_FEATURE_TYPE = PyKCS11.LowLevel.CKA_HW_FEATURE_TYPE
CKA_RESET_ON_INIT = PyKCS11.LowLevel.CKA_RESET_ON_INIT
CKA_HAS_RESET = PyKCS11.LowLevel.CKA_HAS_RESET
CKA_VENDOR_DEFINED = PyKCS11.LowLevel.CKA_VENDOR_DEFINED

CKO_DATA = PyKCS11.LowLevel.CKO_DATA
CKO_CERTIFICATE = PyKCS11.LowLevel.CKO_CERTIFICATE
CKO_PUBLIC_KEY = PyKCS11.LowLevel.CKO_PUBLIC_KEY
CKO_PRIVATE_KEY = PyKCS11.LowLevel.CKO_PRIVATE_KEY
CKO_SECRET_KEY = PyKCS11.LowLevel.CKO_SECRET_KEY
CKO_HW_FEATURE = PyKCS11.LowLevel.CKO_HW_FEATURE
CKO_DOMAIN_PARAMETERS = PyKCS11.LowLevel.CKO_DOMAIN_PARAMETERS
CKO_MECHANISM = PyKCS11.LowLevel.CKO_MECHANISM
CKO_VENDOR_DEFINED = PyKCS11.LowLevel.CKO_VENDOR_DEFINED

CKC_X_509 = PyKCS11.LowLevel.CKC_X_509
CKC_X_509_ATTR_CERT = PyKCS11.LowLevel.CKC_X_509_ATTR_CERT
CKC_WTLS = PyKCS11.LowLevel.CKC_WTLS
CKC_VENDOR_DEFINED = PyKCS11.LowLevel.CKC_VENDOR_DEFINED

CKK_RSA = PyKCS11.LowLevel.CKK_RSA
CKK_DSA = PyKCS11.LowLevel.CKK_DSA
CKK_DH = PyKCS11.LowLevel.CKK_DH
CKK_ECDSA = PyKCS11.LowLevel.CKK_ECDSA
CKK_EC = PyKCS11.LowLevel.CKK_EC
CKK_X9_42_DH = PyKCS11.LowLevel.CKK_X9_42_DH
CKK_KEA = PyKCS11.LowLevel.CKK_KEA
CKK_GENERIC_SECRET = PyKCS11.LowLevel.CKK_GENERIC_SECRET
CKK_RC2 = PyKCS11.LowLevel.CKK_RC2
CKK_RC4 = PyKCS11.LowLevel.CKK_RC4
CKK_DES = PyKCS11.LowLevel.CKK_DES
CKK_DES2 = PyKCS11.LowLevel.CKK_DES2
CKK_DES3 = PyKCS11.LowLevel.CKK_DES3
CKK_CAST = PyKCS11.LowLevel.CKK_CAST
CKK_CAST3 = PyKCS11.LowLevel.CKK_CAST3
CKK_CAST5 = PyKCS11.LowLevel.CKK_CAST5
CKK_CAST128 = PyKCS11.LowLevel.CKK_CAST128
CKK_RC5 = PyKCS11.LowLevel.CKK_RC5
CKK_IDEA = PyKCS11.LowLevel.CKK_IDEA
CKK_SKIPJACK = PyKCS11.LowLevel.CKK_SKIPJACK
CKK_BATON = PyKCS11.LowLevel.CKK_BATON
CKK_JUNIPER = PyKCS11.LowLevel.CKK_JUNIPER
CKK_CDMF = PyKCS11.LowLevel.CKK_CDMF
CKK_AES = PyKCS11.LowLevel.CKK_AES
CKK_BLOWFISH = PyKCS11.LowLevel.CKK_BLOWFISH
CKK_TWOFISH = PyKCS11.LowLevel.CKK_TWOFISH
CKK_VENDOR_DEFINED = PyKCS11.LowLevel.CKK_VENDOR_DEFINED

CKM_RSA_PKCS_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_RSA_PKCS_KEY_PAIR_GEN
CKM_RSA_PKCS = PyKCS11.LowLevel.CKM_RSA_PKCS
CKM_RSA_9796 = PyKCS11.LowLevel.CKM_RSA_9796
CKM_RSA_X_509 = PyKCS11.LowLevel.CKM_RSA_X_509
CKM_MD2_RSA_PKCS = PyKCS11.LowLevel.CKM_MD2_RSA_PKCS
CKM_MD5_RSA_PKCS = PyKCS11.LowLevel.CKM_MD5_RSA_PKCS
CKM_SHA1_RSA_PKCS = PyKCS11.LowLevel.CKM_SHA1_RSA_PKCS
CKM_RIPEMD128_RSA_PKCS = PyKCS11.LowLevel.CKM_RIPEMD128_RSA_PKCS
CKM_RIPEMD160_RSA_PKCS = PyKCS11.LowLevel.CKM_RIPEMD160_RSA_PKCS
CKM_RSA_PKCS_OAEP = PyKCS11.LowLevel.CKM_RSA_PKCS_OAEP
CKM_RSA_X9_31_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_RSA_X9_31_KEY_PAIR_GEN
CKM_RSA_X9_31 = PyKCS11.LowLevel.CKM_RSA_X9_31
CKM_SHA1_RSA_X9_31 = PyKCS11.LowLevel.CKM_SHA1_RSA_X9_31
CKM_RSA_PKCS_PSS = PyKCS11.LowLevel.CKM_RSA_PKCS_PSS
CKM_SHA1_RSA_PKCS_PSS = PyKCS11.LowLevel.CKM_SHA1_RSA_PKCS_PSS
CKM_DSA_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_DSA_KEY_PAIR_GEN
CKM_DSA = PyKCS11.LowLevel.CKM_DSA
CKM_DSA_SHA1 = PyKCS11.LowLevel.CKM_DSA_SHA1
CKM_DH_PKCS_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_DH_PKCS_KEY_PAIR_GEN
CKM_DH_PKCS_DERIVE = PyKCS11.LowLevel.CKM_DH_PKCS_DERIVE
CKM_X9_42_DH_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_X9_42_DH_KEY_PAIR_GEN
CKM_X9_42_DH_DERIVE = PyKCS11.LowLevel.CKM_X9_42_DH_DERIVE
CKM_X9_42_DH_HYBRID_DERIVE = PyKCS11.LowLevel.CKM_X9_42_DH_HYBRID_DERIVE
CKM_X9_42_MQV_DERIVE = PyKCS11.LowLevel.CKM_X9_42_MQV_DERIVE
CKM_SHA256_RSA_PKCS = PyKCS11.LowLevel.CKM_SHA256_RSA_PKCS
CKM_SHA384_RSA_PKCS = PyKCS11.LowLevel.CKM_SHA384_RSA_PKCS
CKM_SHA512_RSA_PKCS = PyKCS11.LowLevel.CKM_SHA512_RSA_PKCS
CKM_SHA256_RSA_PKCS_PSS = PyKCS11.LowLevel.CKM_SHA256_RSA_PKCS_PSS
CKM_SHA384_RSA_PKCS_PSS = PyKCS11.LowLevel.CKM_SHA384_RSA_PKCS_PSS
CKM_SHA512_RSA_PKCS_PSS = PyKCS11.LowLevel.CKM_SHA512_RSA_PKCS_PSS
CKM_RC2_KEY_GEN = PyKCS11.LowLevel.CKM_RC2_KEY_GEN
CKM_RC2_ECB = PyKCS11.LowLevel.CKM_RC2_ECB
CKM_RC2_CBC = PyKCS11.LowLevel.CKM_RC2_CBC
CKM_RC2_MAC = PyKCS11.LowLevel.CKM_RC2_MAC
CKM_RC2_MAC_GENERAL = PyKCS11.LowLevel.CKM_RC2_MAC_GENERAL
CKM_RC2_CBC_PAD = PyKCS11.LowLevel.CKM_RC2_CBC_PAD
CKM_RC4_KEY_GEN = PyKCS11.LowLevel.CKM_RC4_KEY_GEN
CKM_RC4 = PyKCS11.LowLevel.CKM_RC4
CKM_DES_KEY_GEN = PyKCS11.LowLevel.CKM_DES_KEY_GEN
CKM_DES_ECB = PyKCS11.LowLevel.CKM_DES_ECB
CKM_DES_CBC = PyKCS11.LowLevel.CKM_DES_CBC
CKM_DES_MAC = PyKCS11.LowLevel.CKM_DES_MAC
CKM_DES_MAC_GENERAL = PyKCS11.LowLevel.CKM_DES_MAC_GENERAL
CKM_DES_CBC_PAD = PyKCS11.LowLevel.CKM_DES_CBC_PAD
CKM_DES2_KEY_GEN = PyKCS11.LowLevel.CKM_DES2_KEY_GEN
CKM_DES3_KEY_GEN = PyKCS11.LowLevel.CKM_DES3_KEY_GEN
CKM_DES3_ECB = PyKCS11.LowLevel.CKM_DES3_ECB
CKM_DES3_CBC = PyKCS11.LowLevel.CKM_DES3_CBC
CKM_DES3_MAC = PyKCS11.LowLevel.CKM_DES3_MAC
CKM_DES3_MAC_GENERAL = PyKCS11.LowLevel.CKM_DES3_MAC_GENERAL
CKM_DES3_CBC_PAD = PyKCS11.LowLevel.CKM_DES3_CBC_PAD
CKM_CDMF_KEY_GEN = PyKCS11.LowLevel.CKM_CDMF_KEY_GEN
CKM_CDMF_ECB = PyKCS11.LowLevel.CKM_CDMF_ECB
CKM_CDMF_CBC = PyKCS11.LowLevel.CKM_CDMF_CBC
CKM_CDMF_MAC = PyKCS11.LowLevel.CKM_CDMF_MAC
CKM_CDMF_MAC_GENERAL = PyKCS11.LowLevel.CKM_CDMF_MAC_GENERAL
CKM_CDMF_CBC_PAD = PyKCS11.LowLevel.CKM_CDMF_CBC_PAD
CKM_DES_OFB64 = PyKCS11.LowLevel.CKM_DES_OFB64
CKM_DES_OFB8 = PyKCS11.LowLevel.CKM_DES_OFB8
CKM_DES_CFB64 = PyKCS11.LowLevel.CKM_DES_CFB64
CKM_DES_CFB8 = PyKCS11.LowLevel.CKM_DES_CFB8
CKM_MD2 = PyKCS11.LowLevel.CKM_MD2
CKM_MD2_HMAC = PyKCS11.LowLevel.CKM_MD2_HMAC
CKM_MD2_HMAC_GENERAL = PyKCS11.LowLevel.CKM_MD2_HMAC_GENERAL
CKM_MD5 = PyKCS11.LowLevel.CKM_MD5
CKM_MD5_HMAC = PyKCS11.LowLevel.CKM_MD5_HMAC
CKM_MD5_HMAC_GENERAL = PyKCS11.LowLevel.CKM_MD5_HMAC_GENERAL
CKM_SHA_1 = PyKCS11.LowLevel.CKM_SHA_1
CKM_SHA_1_HMAC = PyKCS11.LowLevel.CKM_SHA_1_HMAC
CKM_SHA_1_HMAC_GENERAL = PyKCS11.LowLevel.CKM_SHA_1_HMAC_GENERAL
CKM_RIPEMD128 = PyKCS11.LowLevel.CKM_RIPEMD128
CKM_RIPEMD128_HMAC = PyKCS11.LowLevel.CKM_RIPEMD128_HMAC
CKM_RIPEMD128_HMAC_GENERAL = PyKCS11.LowLevel.CKM_RIPEMD128_HMAC_GENERAL
CKM_RIPEMD160 = PyKCS11.LowLevel.CKM_RIPEMD160
CKM_RIPEMD160_HMAC = PyKCS11.LowLevel.CKM_RIPEMD160_HMAC
CKM_RIPEMD160_HMAC_GENERAL = PyKCS11.LowLevel.CKM_RIPEMD160_HMAC_GENERAL
CKM_SHA256 = PyKCS11.LowLevel.CKM_SHA256
CKM_SHA256_HMAC = PyKCS11.LowLevel.CKM_SHA256_HMAC
CKM_SHA256_HMAC_GENERAL = PyKCS11.LowLevel.CKM_SHA256_HMAC_GENERAL
CKM_SHA384 = PyKCS11.LowLevel.CKM_SHA384
CKM_SHA384_HMAC = PyKCS11.LowLevel.CKM_SHA384_HMAC
CKM_SHA384_HMAC_GENERAL = PyKCS11.LowLevel.CKM_SHA384_HMAC_GENERAL
CKM_SHA512 = PyKCS11.LowLevel.CKM_SHA512
CKM_SHA512_HMAC = PyKCS11.LowLevel.CKM_SHA512_HMAC
CKM_SHA512_HMAC_GENERAL = PyKCS11.LowLevel.CKM_SHA512_HMAC_GENERAL
CKM_CAST_KEY_GEN = PyKCS11.LowLevel.CKM_CAST_KEY_GEN
CKM_CAST_ECB = PyKCS11.LowLevel.CKM_CAST_ECB
CKM_CAST_CBC = PyKCS11.LowLevel.CKM_CAST_CBC
CKM_CAST_MAC = PyKCS11.LowLevel.CKM_CAST_MAC
CKM_CAST_MAC_GENERAL = PyKCS11.LowLevel.CKM_CAST_MAC_GENERAL
CKM_CAST_CBC_PAD = PyKCS11.LowLevel.CKM_CAST_CBC_PAD
CKM_CAST3_KEY_GEN = PyKCS11.LowLevel.CKM_CAST3_KEY_GEN
CKM_CAST3_ECB = PyKCS11.LowLevel.CKM_CAST3_ECB
CKM_CAST3_CBC = PyKCS11.LowLevel.CKM_CAST3_CBC
CKM_CAST3_MAC = PyKCS11.LowLevel.CKM_CAST3_MAC
CKM_CAST3_MAC_GENERAL = PyKCS11.LowLevel.CKM_CAST3_MAC_GENERAL
CKM_CAST3_CBC_PAD = PyKCS11.LowLevel.CKM_CAST3_CBC_PAD
CKM_CAST5_KEY_GEN = PyKCS11.LowLevel.CKM_CAST5_KEY_GEN
CKM_CAST128_KEY_GEN = PyKCS11.LowLevel.CKM_CAST128_KEY_GEN
CKM_CAST5_ECB = PyKCS11.LowLevel.CKM_CAST5_ECB
CKM_CAST128_ECB = PyKCS11.LowLevel.CKM_CAST128_ECB
CKM_CAST5_CBC = PyKCS11.LowLevel.CKM_CAST5_CBC
CKM_CAST128_CBC = PyKCS11.LowLevel.CKM_CAST128_CBC
CKM_CAST5_MAC = PyKCS11.LowLevel.CKM_CAST5_MAC
CKM_CAST128_MAC = PyKCS11.LowLevel.CKM_CAST128_MAC
CKM_CAST5_MAC_GENERAL = PyKCS11.LowLevel.CKM_CAST5_MAC_GENERAL
CKM_CAST128_MAC_GENERAL = PyKCS11.LowLevel.CKM_CAST128_MAC_GENERAL
CKM_CAST5_CBC_PAD = PyKCS11.LowLevel.CKM_CAST5_CBC_PAD
CKM_CAST128_CBC_PAD = PyKCS11.LowLevel.CKM_CAST128_CBC_PAD
CKM_RC5_KEY_GEN = PyKCS11.LowLevel.CKM_RC5_KEY_GEN
CKM_RC5_ECB = PyKCS11.LowLevel.CKM_RC5_ECB
CKM_RC5_CBC = PyKCS11.LowLevel.CKM_RC5_CBC
CKM_RC5_MAC = PyKCS11.LowLevel.CKM_RC5_MAC
CKM_RC5_MAC_GENERAL = PyKCS11.LowLevel.CKM_RC5_MAC_GENERAL
CKM_RC5_CBC_PAD = PyKCS11.LowLevel.CKM_RC5_CBC_PAD
CKM_IDEA_KEY_GEN = PyKCS11.LowLevel.CKM_IDEA_KEY_GEN
CKM_IDEA_ECB = PyKCS11.LowLevel.CKM_IDEA_ECB
CKM_IDEA_CBC = PyKCS11.LowLevel.CKM_IDEA_CBC
CKM_IDEA_MAC = PyKCS11.LowLevel.CKM_IDEA_MAC
CKM_IDEA_MAC_GENERAL = PyKCS11.LowLevel.CKM_IDEA_MAC_GENERAL
CKM_IDEA_CBC_PAD = PyKCS11.LowLevel.CKM_IDEA_CBC_PAD
CKM_GENERIC_SECRET_KEY_GEN = PyKCS11.LowLevel.CKM_GENERIC_SECRET_KEY_GEN
CKM_CONCATENATE_BASE_AND_KEY = PyKCS11.LowLevel.CKM_CONCATENATE_BASE_AND_KEY
CKM_CONCATENATE_BASE_AND_DATA = PyKCS11.LowLevel.CKM_CONCATENATE_BASE_AND_DATA
CKM_CONCATENATE_DATA_AND_BASE = PyKCS11.LowLevel.CKM_CONCATENATE_DATA_AND_BASE
CKM_XOR_BASE_AND_DATA = PyKCS11.LowLevel.CKM_XOR_BASE_AND_DATA
CKM_EXTRACT_KEY_FROM_KEY = PyKCS11.LowLevel.CKM_EXTRACT_KEY_FROM_KEY
CKM_SSL3_PRE_MASTER_KEY_GEN = PyKCS11.LowLevel.CKM_SSL3_PRE_MASTER_KEY_GEN
CKM_SSL3_MASTER_KEY_DERIVE = PyKCS11.LowLevel.CKM_SSL3_MASTER_KEY_DERIVE
CKM_SSL3_KEY_AND_MAC_DERIVE = PyKCS11.LowLevel.CKM_SSL3_KEY_AND_MAC_DERIVE
CKM_SSL3_MASTER_KEY_DERIVE_DH = PyKCS11.LowLevel.CKM_SSL3_MASTER_KEY_DERIVE_DH
CKM_TLS_PRE_MASTER_KEY_GEN = PyKCS11.LowLevel.CKM_TLS_PRE_MASTER_KEY_GEN
CKM_TLS_MASTER_KEY_DERIVE = PyKCS11.LowLevel.CKM_TLS_MASTER_KEY_DERIVE
CKM_TLS_KEY_AND_MAC_DERIVE = PyKCS11.LowLevel.CKM_TLS_KEY_AND_MAC_DERIVE
CKM_TLS_MASTER_KEY_DERIVE_DH = PyKCS11.LowLevel.CKM_TLS_MASTER_KEY_DERIVE_DH
CKM_TLS_PRF = PyKCS11.LowLevel.CKM_TLS_PRF
CKM_SSL3_MD5_MAC = PyKCS11.LowLevel.CKM_SSL3_MD5_MAC
CKM_SSL3_SHA1_MAC = PyKCS11.LowLevel.CKM_SSL3_SHA1_MAC
CKM_MD5_KEY_DERIVATION = PyKCS11.LowLevel.CKM_MD5_KEY_DERIVATION
CKM_MD2_KEY_DERIVATION = PyKCS11.LowLevel.CKM_MD2_KEY_DERIVATION
CKM_SHA1_KEY_DERIVATION = PyKCS11.LowLevel.CKM_SHA1_KEY_DERIVATION
CKM_SHA256_KEY_DERIVATION = PyKCS11.LowLevel.CKM_SHA256_KEY_DERIVATION
CKM_SHA384_KEY_DERIVATION = PyKCS11.LowLevel.CKM_SHA384_KEY_DERIVATION
CKM_SHA512_KEY_DERIVATION = PyKCS11.LowLevel.CKM_SHA512_KEY_DERIVATION
CKM_PBE_MD2_DES_CBC = PyKCS11.LowLevel.CKM_PBE_MD2_DES_CBC
CKM_PBE_MD5_DES_CBC = PyKCS11.LowLevel.CKM_PBE_MD5_DES_CBC
CKM_PBE_MD5_CAST_CBC = PyKCS11.LowLevel.CKM_PBE_MD5_CAST_CBC
CKM_PBE_MD5_CAST3_CBC = PyKCS11.LowLevel.CKM_PBE_MD5_CAST3_CBC
CKM_PBE_MD5_CAST5_CBC = PyKCS11.LowLevel.CKM_PBE_MD5_CAST5_CBC
CKM_PBE_MD5_CAST128_CBC = PyKCS11.LowLevel.CKM_PBE_MD5_CAST128_CBC
CKM_PBE_SHA1_CAST5_CBC = PyKCS11.LowLevel.CKM_PBE_SHA1_CAST5_CBC
CKM_PBE_SHA1_CAST128_CBC = PyKCS11.LowLevel.CKM_PBE_SHA1_CAST128_CBC
CKM_PBE_SHA1_RC4_128 = PyKCS11.LowLevel.CKM_PBE_SHA1_RC4_128
CKM_PBE_SHA1_RC4_40 = PyKCS11.LowLevel.CKM_PBE_SHA1_RC4_40
CKM_PBE_SHA1_DES3_EDE_CBC = PyKCS11.LowLevel.CKM_PBE_SHA1_DES3_EDE_CBC
CKM_PBE_SHA1_DES2_EDE_CBC = PyKCS11.LowLevel.CKM_PBE_SHA1_DES2_EDE_CBC
CKM_PBE_SHA1_RC2_128_CBC = PyKCS11.LowLevel.CKM_PBE_SHA1_RC2_128_CBC
CKM_PBE_SHA1_RC2_40_CBC = PyKCS11.LowLevel.CKM_PBE_SHA1_RC2_40_CBC
CKM_PKCS5_PBKD2 = PyKCS11.LowLevel.CKM_PKCS5_PBKD2
CKM_PBA_SHA1_WITH_SHA1_HMAC = PyKCS11.LowLevel.CKM_PBA_SHA1_WITH_SHA1_HMAC
CKM_WTLS_PRE_MASTER_KEY_GEN = PyKCS11.LowLevel.CKM_WTLS_PRE_MASTER_KEY_GEN
CKM_WTLS_MASTER_KEY_DERIVE = PyKCS11.LowLevel.CKM_WTLS_MASTER_KEY_DERIVE
CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC = PyKCS11.LowLevel.CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC
CKM_WTLS_PRF = PyKCS11.LowLevel.CKM_WTLS_PRF
CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE = PyKCS11.LowLevel.CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE
CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE = PyKCS11.LowLevel.CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE
CKM_KEY_WRAP_LYNKS = PyKCS11.LowLevel.CKM_KEY_WRAP_LYNKS
CKM_KEY_WRAP_SET_OAEP = PyKCS11.LowLevel.CKM_KEY_WRAP_SET_OAEP
CKM_CMS_SIG = PyKCS11.LowLevel.CKM_CMS_SIG
CKM_SKIPJACK_KEY_GEN = PyKCS11.LowLevel.CKM_SKIPJACK_KEY_GEN
CKM_SKIPJACK_ECB64 = PyKCS11.LowLevel.CKM_SKIPJACK_ECB64
CKM_SKIPJACK_CBC64 = PyKCS11.LowLevel.CKM_SKIPJACK_CBC64
CKM_SKIPJACK_OFB64 = PyKCS11.LowLevel.CKM_SKIPJACK_OFB64
CKM_SKIPJACK_CFB64 = PyKCS11.LowLevel.CKM_SKIPJACK_CFB64
CKM_SKIPJACK_CFB32 = PyKCS11.LowLevel.CKM_SKIPJACK_CFB32
CKM_SKIPJACK_CFB16 = PyKCS11.LowLevel.CKM_SKIPJACK_CFB16
CKM_SKIPJACK_CFB8 = PyKCS11.LowLevel.CKM_SKIPJACK_CFB8
CKM_SKIPJACK_WRAP = PyKCS11.LowLevel.CKM_SKIPJACK_WRAP
CKM_SKIPJACK_PRIVATE_WRAP = PyKCS11.LowLevel.CKM_SKIPJACK_PRIVATE_WRAP
CKM_SKIPJACK_RELAYX = PyKCS11.LowLevel.CKM_SKIPJACK_RELAYX
CKM_KEA_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_KEA_KEY_PAIR_GEN
CKM_KEA_KEY_DERIVE = PyKCS11.LowLevel.CKM_KEA_KEY_DERIVE
CKM_FORTEZZA_TIMESTAMP = PyKCS11.LowLevel.CKM_FORTEZZA_TIMESTAMP
CKM_BATON_KEY_GEN = PyKCS11.LowLevel.CKM_BATON_KEY_GEN
CKM_BATON_ECB128 = PyKCS11.LowLevel.CKM_BATON_ECB128
CKM_BATON_ECB96 = PyKCS11.LowLevel.CKM_BATON_ECB96
CKM_BATON_CBC128 = PyKCS11.LowLevel.CKM_BATON_CBC128
CKM_BATON_COUNTER = PyKCS11.LowLevel.CKM_BATON_COUNTER
CKM_BATON_SHUFFLE = PyKCS11.LowLevel.CKM_BATON_SHUFFLE
CKM_BATON_WRAP = PyKCS11.LowLevel.CKM_BATON_WRAP
CKM_ECDSA_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_ECDSA_KEY_PAIR_GEN
CKM_EC_KEY_PAIR_GEN = PyKCS11.LowLevel.CKM_EC_KEY_PAIR_GEN
CKM_ECDSA = PyKCS11.LowLevel.CKM_ECDSA
CKM_ECDSA_SHA1 = PyKCS11.LowLevel.CKM_ECDSA_SHA1
CKM_ECDH1_DERIVE = PyKCS11.LowLevel.CKM_ECDH1_DERIVE
CKM_ECDH1_COFACTOR_DERIVE = PyKCS11.LowLevel.CKM_ECDH1_COFACTOR_DERIVE
CKM_ECMQV_DERIVE = PyKCS11.LowLevel.CKM_ECMQV_DERIVE
CKM_JUNIPER_KEY_GEN = PyKCS11.LowLevel.CKM_JUNIPER_KEY_GEN
CKM_JUNIPER_ECB128 = PyKCS11.LowLevel.CKM_JUNIPER_ECB128
CKM_JUNIPER_CBC128 = PyKCS11.LowLevel.CKM_JUNIPER_CBC128
CKM_JUNIPER_COUNTER = PyKCS11.LowLevel.CKM_JUNIPER_COUNTER
CKM_JUNIPER_SHUFFLE = PyKCS11.LowLevel.CKM_JUNIPER_SHUFFLE
CKM_JUNIPER_WRAP = PyKCS11.LowLevel.CKM_JUNIPER_WRAP
CKM_FASTHASH = PyKCS11.LowLevel.CKM_FASTHASH
CKM_AES_KEY_GEN = PyKCS11.LowLevel.CKM_AES_KEY_GEN
CKM_AES_ECB = PyKCS11.LowLevel.CKM_AES_ECB
CKM_AES_CBC = PyKCS11.LowLevel.CKM_AES_CBC
CKM_AES_MAC = PyKCS11.LowLevel.CKM_AES_MAC
CKM_AES_MAC_GENERAL = PyKCS11.LowLevel.CKM_AES_MAC_GENERAL
CKM_AES_CBC_PAD = PyKCS11.LowLevel.CKM_AES_CBC_PAD
CKM_BLOWFISH_KEY_GEN = PyKCS11.LowLevel.CKM_BLOWFISH_KEY_GEN
CKM_BLOWFISH_CBC = PyKCS11.LowLevel.CKM_BLOWFISH_CBC
CKM_TWOFISH_KEY_GEN = PyKCS11.LowLevel.CKM_TWOFISH_KEY_GEN
CKM_TWOFISH_CBC = PyKCS11.LowLevel.CKM_TWOFISH_CBC
CKM_DES_ECB_ENCRYPT_DATA = PyKCS11.LowLevel.CKM_DES_ECB_ENCRYPT_DATA
CKM_DES_CBC_ENCRYPT_DATA = PyKCS11.LowLevel.CKM_DES_CBC_ENCRYPT_DATA
CKM_DES3_ECB_ENCRYPT_DATA = PyKCS11.LowLevel.CKM_DES3_ECB_ENCRYPT_DATA
CKM_DES3_CBC_ENCRYPT_DATA = PyKCS11.LowLevel.CKM_DES3_CBC_ENCRYPT_DATA
CKM_AES_ECB_ENCRYPT_DATA = PyKCS11.LowLevel.CKM_AES_ECB_ENCRYPT_DATA
CKM_AES_CBC_ENCRYPT_DATA = PyKCS11.LowLevel.CKM_AES_CBC_ENCRYPT_DATA
CKM_DSA_PARAMETER_GEN = PyKCS11.LowLevel.CKM_DSA_PARAMETER_GEN
CKM_DH_PKCS_PARAMETER_GEN = PyKCS11.LowLevel.CKM_DH_PKCS_PARAMETER_GEN
CKM_X9_42_DH_PARAMETER_GEN = PyKCS11.LowLevel.CKM_X9_42_DH_PARAMETER_GEN
CKM_VENDOR_DEFINED = PyKCS11.LowLevel.CKM_VENDOR_DEFINED

CKA = {
    CKA_CLASS: "CKA_CLASS",
    CKA_TOKEN: "CKA_TOKEN",
    CKA_PRIVATE: "CKA_PRIVATE",
    CKA_LABEL: "CKA_LABEL",
    CKA_APPLICATION: "CKA_APPLICATION",
    CKA_VALUE: "CKA_VALUE",
    CKA_OBJECT_ID: "CKA_OBJECT_ID",
    CKA_CERTIFICATE_TYPE: "CKA_CERTIFICATE_TYPE",
    CKA_ISSUER: "CKA_ISSUER",
    CKA_SERIAL_NUMBER: "CKA_SERIAL_NUMBER",
    CKA_AC_ISSUER: "CKA_AC_ISSUER",
    CKA_OWNER: "CKA_OWNER",
    CKA_ATTR_TYPES: "CKA_ATTR_TYPES",
    CKA_TRUSTED: "CKA_TRUSTED",
    CKA_KEY_TYPE: "CKA_KEY_TYPE",
    CKA_SUBJECT: "CKA_SUBJECT",
    CKA_ID: "CKA_ID",
    CKA_SENSITIVE: "CKA_SENSITIVE",
    CKA_ENCRYPT: "CKA_ENCRYPT",
    CKA_DECRYPT: "CKA_DECRYPT",
    CKA_WRAP: "CKA_WRAP",
    CKA_UNWRAP: "CKA_UNWRAP",
    CKA_SIGN: "CKA_SIGN",
    CKA_SIGN_RECOVER: "CKA_SIGN_RECOVER",
    CKA_VERIFY: "CKA_VERIFY",
    CKA_VERIFY_RECOVER: "CKA_VERIFY_RECOVER",
    CKA_DERIVE: "CKA_DERIVE",
    CKA_START_DATE: "CKA_START_DATE",
    CKA_END_DATE: "CKA_END_DATE",
    CKA_MODULUS: "CKA_MODULUS",
    CKA_MODULUS_BITS: "CKA_MODULUS_BITS",
    CKA_PUBLIC_EXPONENT: "CKA_PUBLIC_EXPONENT",
    CKA_PRIVATE_EXPONENT: "CKA_PRIVATE_EXPONENT",
    CKA_PRIME_1: "CKA_PRIME_1",
    CKA_PRIME_2: "CKA_PRIME_2",
    CKA_EXPONENT_1: "CKA_EXPONENT_1",
    CKA_EXPONENT_2: "CKA_EXPONENT_2",
    CKA_COEFFICIENT: "CKA_COEFFICIENT",
    CKA_PRIME: "CKA_PRIME",
    CKA_SUBPRIME: "CKA_SUBPRIME",
    CKA_BASE: "CKA_BASE",
    CKA_PRIME_BITS: "CKA_PRIME_BITS",
    CKA_SUBPRIME_BITS: "CKA_SUBPRIME_BITS",
    CKA_SUB_PRIME_BITS: "CKA_SUB_PRIME_BITS",
    CKA_VALUE_BITS: "CKA_VALUE_BITS",
    CKA_VALUE_LEN: "CKA_VALUE_LEN",
    CKA_EXTRACTABLE: "CKA_EXTRACTABLE",
    CKA_LOCAL: "CKA_LOCAL",
    CKA_NEVER_EXTRACTABLE: "CKA_NEVER_EXTRACTABLE",
    CKA_ALWAYS_SENSITIVE: "CKA_ALWAYS_SENSITIVE",
    CKA_KEY_GEN_MECHANISM: "CKA_KEY_GEN_MECHANISM",
    CKA_MODIFIABLE: "CKA_MODIFIABLE",
    CKA_ECDSA_PARAMS: "CKA_ECDSA_PARAMS",
    CKA_EC_PARAMS: "CKA_EC_PARAMS",
    CKA_EC_POINT: "CKA_EC_POINT",
    CKA_SECONDARY_AUTH: "CKA_SECONDARY_AUTH",
    CKA_AUTH_PIN_FLAGS: "CKA_AUTH_PIN_FLAGS",
    CKA_HW_FEATURE_TYPE: "CKA_HW_FEATURE_TYPE",
    CKA_RESET_ON_INIT: "CKA_RESET_ON_INIT",
    CKA_HAS_RESET: "CKA_HAS_RESET",
    #CKA_VENDOR_DEFINED: "CKA_VENDOR_DEFINED",
}

CKO = {
    CKO_DATA: "CKO_DATA",
    CKO_CERTIFICATE: "CKO_CERTIFICATE",
    CKO_PUBLIC_KEY: "CKO_PUBLIC_KEY",
    CKO_PRIVATE_KEY: "CKO_PRIVATE_KEY",
    CKO_SECRET_KEY: "CKO_SECRET_KEY",
    CKO_HW_FEATURE: "CKO_HW_FEATURE",
    CKO_DOMAIN_PARAMETERS: "CKO_DOMAIN_PARAMETERS",
    CKO_MECHANISM: "CKO_MECHANISM",
    CKO_VENDOR_DEFINED: "CKO_VENDOR_DEFINED",
}

CKC = {
    CKC_X_509: "CKC_X_509",
    CKC_X_509_ATTR_CERT: "CKC_X_509_ATTR_CERT",
    CKC_WTLS: "CKC_WTLS",
    CKC_VENDOR_DEFINED: "CKC_VENDOR_DEFINED",
}

CKK = {
    CKK_RSA: "CKK_RSA",
    CKK_DSA: "CKK_DSA",
    CKK_DH: "CKK_DH",
    CKK_ECDSA: "CKK_ECDSA",
    CKK_EC: "CKK_EC",
    CKK_X9_42_DH: "CKK_X9_42_DH",
    CKK_KEA: "CKK_KEA",
    CKK_GENERIC_SECRET: "CKK_GENERIC_SECRET",
    CKK_RC2: "CKK_RC2",
    CKK_RC4: "CKK_RC4",
    CKK_DES: "CKK_DES",
    CKK_DES2: "CKK_DES2",
    CKK_DES3: "CKK_DES3",
    CKK_CAST: "CKK_CAST",
    CKK_CAST3: "CKK_CAST3",
    CKK_CAST5: "CKK_CAST5",
    CKK_CAST128: "CKK_CAST128",
    CKK_RC5: "CKK_RC5",
    CKK_IDEA: "CKK_IDEA",
    CKK_SKIPJACK: "CKK_SKIPJACK",
    CKK_BATON: "CKK_BATON",
    CKK_JUNIPER: "CKK_JUNIPER",
    CKK_CDMF: "CKK_CDMF",
    CKK_AES: "CKK_AES",
    CKK_BLOWFISH: "CKK_BLOWFISH",
    CKK_TWOFISH: "CKK_TWOFISH",
    CKK_VENDOR_DEFINED: "CKK_VENDOR_DEFINED",
}

CKM = {
    CKM_RSA_PKCS_KEY_PAIR_GEN: "CKM_RSA_PKCS_KEY_PAIR_GEN",
    CKM_RSA_PKCS: "CKM_RSA_PKCS",
    CKM_RSA_9796: "CKM_RSA_9796",
    CKM_RSA_X_509: "CKM_RSA_X_509",
    CKM_MD2_RSA_PKCS: "CKM_MD2_RSA_PKCS",
    CKM_MD5_RSA_PKCS: "CKM_MD5_RSA_PKCS",
    CKM_SHA1_RSA_PKCS: "CKM_SHA1_RSA_PKCS",
    CKM_RIPEMD128_RSA_PKCS: "CKM_RIPEMD128_RSA_PKCS",
    CKM_RIPEMD160_RSA_PKCS: "CKM_RIPEMD160_RSA_PKCS",
    CKM_RSA_PKCS_OAEP: "CKM_RSA_PKCS_OAEP",
    CKM_RSA_X9_31_KEY_PAIR_GEN: "CKM_RSA_X9_31_KEY_PAIR_GEN",
    CKM_RSA_X9_31: "CKM_RSA_X9_31",
    CKM_SHA1_RSA_X9_31: "CKM_SHA1_RSA_X9_31",
    CKM_RSA_PKCS_PSS: "CKM_RSA_PKCS_PSS",
    CKM_SHA1_RSA_PKCS_PSS: "CKM_SHA1_RSA_PKCS_PSS",
    CKM_DSA_KEY_PAIR_GEN: "CKM_DSA_KEY_PAIR_GEN",
    CKM_DSA: "CKM_DSA",
    CKM_DSA_SHA1: "CKM_DSA_SHA1",
    CKM_DH_PKCS_KEY_PAIR_GEN: "CKM_DH_PKCS_KEY_PAIR_GEN",
    CKM_DH_PKCS_DERIVE: "CKM_DH_PKCS_DERIVE",
    CKM_X9_42_DH_KEY_PAIR_GEN: "CKM_X9_42_DH_KEY_PAIR_GEN",
    CKM_X9_42_DH_DERIVE: "CKM_X9_42_DH_DERIVE",
    CKM_X9_42_DH_HYBRID_DERIVE: "CKM_X9_42_DH_HYBRID_DERIVE",
    CKM_X9_42_MQV_DERIVE: "CKM_X9_42_MQV_DERIVE",
    CKM_SHA256_RSA_PKCS: "CKM_SHA256_RSA_PKCS",
    CKM_SHA384_RSA_PKCS: "CKM_SHA384_RSA_PKCS",
    CKM_SHA512_RSA_PKCS: "CKM_SHA512_RSA_PKCS",
    CKM_SHA256_RSA_PKCS_PSS: "CKM_SHA256_RSA_PKCS_PSS",
    CKM_SHA384_RSA_PKCS_PSS: "CKM_SHA384_RSA_PKCS_PSS",
    CKM_SHA512_RSA_PKCS_PSS: "CKM_SHA512_RSA_PKCS_PSS",
    CKM_RC2_KEY_GEN: "CKM_RC2_KEY_GEN",
    CKM_RC2_ECB: "CKM_RC2_ECB",
    CKM_RC2_CBC: "CKM_RC2_CBC",
    CKM_RC2_MAC: "CKM_RC2_MAC",
    CKM_RC2_MAC_GENERAL: "CKM_RC2_MAC_GENERAL",
    CKM_RC2_CBC_PAD: "CKM_RC2_CBC_PAD",
    CKM_RC4_KEY_GEN: "CKM_RC4_KEY_GEN",
    CKM_RC4: "CKM_RC4",
    CKM_DES_KEY_GEN: "CKM_DES_KEY_GEN",
    CKM_DES_ECB: "CKM_DES_ECB",
    CKM_DES_CBC: "CKM_DES_CBC",
    CKM_DES_MAC: "CKM_DES_MAC",
    CKM_DES_MAC_GENERAL: "CKM_DES_MAC_GENERAL",
    CKM_DES_CBC_PAD: "CKM_DES_CBC_PAD",
    CKM_DES2_KEY_GEN: "CKM_DES2_KEY_GEN",
    CKM_DES3_KEY_GEN: "CKM_DES3_KEY_GEN",
    CKM_DES3_ECB: "CKM_DES3_ECB",
    CKM_DES3_CBC: "CKM_DES3_CBC",
    CKM_DES3_MAC: "CKM_DES3_MAC",
    CKM_DES3_MAC_GENERAL: "CKM_DES3_MAC_GENERAL",
    CKM_DES3_CBC_PAD: "CKM_DES3_CBC_PAD",
    CKM_CDMF_KEY_GEN: "CKM_CDMF_KEY_GEN",
    CKM_CDMF_ECB: "CKM_CDMF_ECB",
    CKM_CDMF_CBC: "CKM_CDMF_CBC",
    CKM_CDMF_MAC: "CKM_CDMF_MAC",
    CKM_CDMF_MAC_GENERAL: "CKM_CDMF_MAC_GENERAL",
    CKM_CDMF_CBC_PAD: "CKM_CDMF_CBC_PAD",
    CKM_DES_OFB64: "CKM_DES_OFB64",
    CKM_DES_OFB8: "CKM_DES_OFB8",
    CKM_DES_CFB64: "CKM_DES_CFB64",
    CKM_DES_CFB8: "CKM_DES_CFB8",
    CKM_MD2: "CKM_MD2",
    CKM_MD2_HMAC: "CKM_MD2_HMAC",
    CKM_MD2_HMAC_GENERAL: "CKM_MD2_HMAC_GENERAL",
    CKM_MD5: "CKM_MD5",
    CKM_MD5_HMAC: "CKM_MD5_HMAC",
    CKM_MD5_HMAC_GENERAL: "CKM_MD5_HMAC_GENERAL",
    CKM_SHA_1: "CKM_SHA_1",
    CKM_SHA_1_HMAC: "CKM_SHA_1_HMAC",
    CKM_SHA_1_HMAC_GENERAL: "CKM_SHA_1_HMAC_GENERAL",
    CKM_RIPEMD128: "CKM_RIPEMD128",
    CKM_RIPEMD128_HMAC: "CKM_RIPEMD128_HMAC",
    CKM_RIPEMD128_HMAC_GENERAL: "CKM_RIPEMD128_HMAC_GENERAL",
    CKM_RIPEMD160: "CKM_RIPEMD160",
    CKM_RIPEMD160_HMAC: "CKM_RIPEMD160_HMAC",
    CKM_RIPEMD160_HMAC_GENERAL: "CKM_RIPEMD160_HMAC_GENERAL",
    CKM_SHA256: "CKM_SHA256",
    CKM_SHA256_HMAC: "CKM_SHA256_HMAC",
    CKM_SHA256_HMAC_GENERAL: "CKM_SHA256_HMAC_GENERAL",
    CKM_SHA384: "CKM_SHA384",
    CKM_SHA384_HMAC: "CKM_SHA384_HMAC",
    CKM_SHA384_HMAC_GENERAL: "CKM_SHA384_HMAC_GENERAL",
    CKM_SHA512: "CKM_SHA512",
    CKM_SHA512_HMAC: "CKM_SHA512_HMAC",
    CKM_SHA512_HMAC_GENERAL: "CKM_SHA512_HMAC_GENERAL",
    CKM_CAST_KEY_GEN: "CKM_CAST_KEY_GEN",
    CKM_CAST_ECB: "CKM_CAST_ECB",
    CKM_CAST_CBC: "CKM_CAST_CBC",
    CKM_CAST_MAC: "CKM_CAST_MAC",
    CKM_CAST_MAC_GENERAL: "CKM_CAST_MAC_GENERAL",
    CKM_CAST_CBC_PAD: "CKM_CAST_CBC_PAD",
    CKM_CAST3_KEY_GEN: "CKM_CAST3_KEY_GEN",
    CKM_CAST3_ECB: "CKM_CAST3_ECB",
    CKM_CAST3_CBC: "CKM_CAST3_CBC",
    CKM_CAST3_MAC: "CKM_CAST3_MAC",
    CKM_CAST3_MAC_GENERAL: "CKM_CAST3_MAC_GENERAL",
    CKM_CAST3_CBC_PAD: "CKM_CAST3_CBC_PAD",
    CKM_CAST5_KEY_GEN: "CKM_CAST5_KEY_GEN",
    CKM_CAST128_KEY_GEN: "CKM_CAST128_KEY_GEN",
    CKM_CAST5_ECB: "CKM_CAST5_ECB",
    CKM_CAST128_ECB: "CKM_CAST128_ECB",
    CKM_CAST5_CBC: "CKM_CAST5_CBC",
    CKM_CAST128_CBC: "CKM_CAST128_CBC",
    CKM_CAST5_MAC: "CKM_CAST5_MAC",
    CKM_CAST128_MAC: "CKM_CAST128_MAC",
    CKM_CAST5_MAC_GENERAL: "CKM_CAST5_MAC_GENERAL",
    CKM_CAST128_MAC_GENERAL: "CKM_CAST128_MAC_GENERAL",
    CKM_CAST5_CBC_PAD: "CKM_CAST5_CBC_PAD",
    CKM_CAST128_CBC_PAD: "CKM_CAST128_CBC_PAD",
    CKM_RC5_KEY_GEN: "CKM_RC5_KEY_GEN",
    CKM_RC5_ECB: "CKM_RC5_ECB",
    CKM_RC5_CBC: "CKM_RC5_CBC",
    CKM_RC5_MAC: "CKM_RC5_MAC",
    CKM_RC5_MAC_GENERAL: "CKM_RC5_MAC_GENERAL",
    CKM_RC5_CBC_PAD: "CKM_RC5_CBC_PAD",
    CKM_IDEA_KEY_GEN: "CKM_IDEA_KEY_GEN",
    CKM_IDEA_ECB: "CKM_IDEA_ECB",
    CKM_IDEA_CBC: "CKM_IDEA_CBC",
    CKM_IDEA_MAC: "CKM_IDEA_MAC",
    CKM_IDEA_MAC_GENERAL: "CKM_IDEA_MAC_GENERAL",
    CKM_IDEA_CBC_PAD: "CKM_IDEA_CBC_PAD",
    CKM_GENERIC_SECRET_KEY_GEN: "CKM_GENERIC_SECRET_KEY_GEN",
    CKM_CONCATENATE_BASE_AND_KEY: "CKM_CONCATENATE_BASE_AND_KEY",
    CKM_CONCATENATE_BASE_AND_DATA: "CKM_CONCATENATE_BASE_AND_DATA",
    CKM_CONCATENATE_DATA_AND_BASE: "CKM_CONCATENATE_DATA_AND_BASE",
    CKM_XOR_BASE_AND_DATA: "CKM_XOR_BASE_AND_DATA",
    CKM_EXTRACT_KEY_FROM_KEY: "CKM_EXTRACT_KEY_FROM_KEY",
    CKM_SSL3_PRE_MASTER_KEY_GEN: "CKM_SSL3_PRE_MASTER_KEY_GEN",
    CKM_SSL3_MASTER_KEY_DERIVE: "CKM_SSL3_MASTER_KEY_DERIVE",
    CKM_SSL3_KEY_AND_MAC_DERIVE: "CKM_SSL3_KEY_AND_MAC_DERIVE",
    CKM_SSL3_MASTER_KEY_DERIVE_DH: "CKM_SSL3_MASTER_KEY_DERIVE_DH",
    CKM_TLS_PRE_MASTER_KEY_GEN: "CKM_TLS_PRE_MASTER_KEY_GEN",
    CKM_TLS_MASTER_KEY_DERIVE: "CKM_TLS_MASTER_KEY_DERIVE",
    CKM_TLS_KEY_AND_MAC_DERIVE: "CKM_TLS_KEY_AND_MAC_DERIVE",
    CKM_TLS_MASTER_KEY_DERIVE_DH: "CKM_TLS_MASTER_KEY_DERIVE_DH",
    CKM_TLS_PRF: "CKM_TLS_PRF",
    CKM_SSL3_MD5_MAC: "CKM_SSL3_MD5_MAC",
    CKM_SSL3_SHA1_MAC: "CKM_SSL3_SHA1_MAC",
    CKM_MD5_KEY_DERIVATION: "CKM_MD5_KEY_DERIVATION",
    CKM_MD2_KEY_DERIVATION: "CKM_MD2_KEY_DERIVATION",
    CKM_SHA1_KEY_DERIVATION: "CKM_SHA1_KEY_DERIVATION",
    CKM_SHA256_KEY_DERIVATION: "CKM_SHA256_KEY_DERIVATION",
    CKM_SHA384_KEY_DERIVATION: "CKM_SHA384_KEY_DERIVATION",
    CKM_SHA512_KEY_DERIVATION: "CKM_SHA512_KEY_DERIVATION",
    CKM_PBE_MD2_DES_CBC: "CKM_PBE_MD2_DES_CBC",
    CKM_PBE_MD5_DES_CBC: "CKM_PBE_MD5_DES_CBC",
    CKM_PBE_MD5_CAST_CBC: "CKM_PBE_MD5_CAST_CBC",
    CKM_PBE_MD5_CAST3_CBC: "CKM_PBE_MD5_CAST3_CBC",
    CKM_PBE_MD5_CAST5_CBC: "CKM_PBE_MD5_CAST5_CBC",
    CKM_PBE_MD5_CAST128_CBC: "CKM_PBE_MD5_CAST128_CBC",
    CKM_PBE_SHA1_CAST5_CBC: "CKM_PBE_SHA1_CAST5_CBC",
    CKM_PBE_SHA1_CAST128_CBC: "CKM_PBE_SHA1_CAST128_CBC",
    CKM_PBE_SHA1_RC4_128: "CKM_PBE_SHA1_RC4_128",
    CKM_PBE_SHA1_RC4_40: "CKM_PBE_SHA1_RC4_40",
    CKM_PBE_SHA1_DES3_EDE_CBC: "CKM_PBE_SHA1_DES3_EDE_CBC",
    CKM_PBE_SHA1_DES2_EDE_CBC: "CKM_PBE_SHA1_DES2_EDE_CBC",
    CKM_PBE_SHA1_RC2_128_CBC: "CKM_PBE_SHA1_RC2_128_CBC",
    CKM_PBE_SHA1_RC2_40_CBC: "CKM_PBE_SHA1_RC2_40_CBC",
    CKM_PKCS5_PBKD2: "CKM_PKCS5_PBKD2",
    CKM_PBA_SHA1_WITH_SHA1_HMAC: "CKM_PBA_SHA1_WITH_SHA1_HMAC",
    CKM_WTLS_PRE_MASTER_KEY_GEN: "CKM_WTLS_PRE_MASTER_KEY_GEN",
    CKM_WTLS_MASTER_KEY_DERIVE: "CKM_WTLS_MASTER_KEY_DERIVE",
    CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC: "CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC",
    CKM_WTLS_PRF: "CKM_WTLS_PRF",
    CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE: "CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE",
    CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE: "CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE",
    CKM_KEY_WRAP_LYNKS: "CKM_KEY_WRAP_LYNKS",
    CKM_KEY_WRAP_SET_OAEP: "CKM_KEY_WRAP_SET_OAEP",
    CKM_CMS_SIG: "CKM_CMS_SIG",
    CKM_SKIPJACK_KEY_GEN: "CKM_SKIPJACK_KEY_GEN",
    CKM_SKIPJACK_ECB64: "CKM_SKIPJACK_ECB64",
    CKM_SKIPJACK_CBC64: "CKM_SKIPJACK_CBC64",
    CKM_SKIPJACK_OFB64: "CKM_SKIPJACK_OFB64",
    CKM_SKIPJACK_CFB64: "CKM_SKIPJACK_CFB64",
    CKM_SKIPJACK_CFB32: "CKM_SKIPJACK_CFB32",
    CKM_SKIPJACK_CFB16: "CKM_SKIPJACK_CFB16",
    CKM_SKIPJACK_CFB8: "CKM_SKIPJACK_CFB8",
    CKM_SKIPJACK_WRAP: "CKM_SKIPJACK_WRAP",
    CKM_SKIPJACK_PRIVATE_WRAP: "CKM_SKIPJACK_PRIVATE_WRAP",
    CKM_SKIPJACK_RELAYX: "CKM_SKIPJACK_RELAYX",
    CKM_KEA_KEY_PAIR_GEN: "CKM_KEA_KEY_PAIR_GEN",
    CKM_KEA_KEY_DERIVE: "CKM_KEA_KEY_DERIVE",
    CKM_FORTEZZA_TIMESTAMP: "CKM_FORTEZZA_TIMESTAMP",
    CKM_BATON_KEY_GEN: "CKM_BATON_KEY_GEN",
    CKM_BATON_ECB128: "CKM_BATON_ECB128",
    CKM_BATON_ECB96: "CKM_BATON_ECB96",
    CKM_BATON_CBC128: "CKM_BATON_CBC128",
    CKM_BATON_COUNTER: "CKM_BATON_COUNTER",
    CKM_BATON_SHUFFLE: "CKM_BATON_SHUFFLE",
    CKM_BATON_WRAP: "CKM_BATON_WRAP",
    CKM_ECDSA_KEY_PAIR_GEN: "CKM_ECDSA_KEY_PAIR_GEN",
    CKM_EC_KEY_PAIR_GEN: "CKM_EC_KEY_PAIR_GEN",
    CKM_ECDSA: "CKM_ECDSA",
    CKM_ECDSA_SHA1: "CKM_ECDSA_SHA1",
    CKM_ECDH1_DERIVE: "CKM_ECDH1_DERIVE",
    CKM_ECDH1_COFACTOR_DERIVE: "CKM_ECDH1_COFACTOR_DERIVE",
    CKM_ECMQV_DERIVE: "CKM_ECMQV_DERIVE",
    CKM_JUNIPER_KEY_GEN: "CKM_JUNIPER_KEY_GEN",
    CKM_JUNIPER_ECB128: "CKM_JUNIPER_ECB128",
    CKM_JUNIPER_CBC128: "CKM_JUNIPER_CBC128",
    CKM_JUNIPER_COUNTER: "CKM_JUNIPER_COUNTER",
    CKM_JUNIPER_SHUFFLE: "CKM_JUNIPER_SHUFFLE",
    CKM_JUNIPER_WRAP: "CKM_JUNIPER_WRAP",
    CKM_FASTHASH: "CKM_FASTHASH",
    CKM_AES_KEY_GEN: "CKM_AES_KEY_GEN",
    CKM_AES_ECB: "CKM_AES_ECB",
    CKM_AES_CBC: "CKM_AES_CBC",
    CKM_AES_MAC: "CKM_AES_MAC",
    CKM_AES_MAC_GENERAL: "CKM_AES_MAC_GENERAL",
    CKM_AES_CBC_PAD: "CKM_AES_CBC_PAD",
    CKM_BLOWFISH_KEY_GEN: "CKM_BLOWFISH_KEY_GEN",
    CKM_BLOWFISH_CBC: "CKM_BLOWFISH_CBC",
    CKM_TWOFISH_KEY_GEN: "CKM_TWOFISH_KEY_GEN",
    CKM_TWOFISH_CBC: "CKM_TWOFISH_CBC",
    CKM_DES_ECB_ENCRYPT_DATA: "CKM_DES_ECB_ENCRYPT_DATA",
    CKM_DES_CBC_ENCRYPT_DATA: "CKM_DES_CBC_ENCRYPT_DATA",
    CKM_DES3_ECB_ENCRYPT_DATA: "CKM_DES3_ECB_ENCRYPT_DATA",
    CKM_DES3_CBC_ENCRYPT_DATA: "CKM_DES3_CBC_ENCRYPT_DATA",
    CKM_AES_ECB_ENCRYPT_DATA: "CKM_AES_ECB_ENCRYPT_DATA",
    CKM_AES_CBC_ENCRYPT_DATA: "CKM_AES_CBC_ENCRYPT_DATA",
    CKM_DSA_PARAMETER_GEN: "CKM_DSA_PARAMETER_GEN",
    CKM_DH_PKCS_PARAMETER_GEN: "CKM_DH_PKCS_PARAMETER_GEN",
    CKM_X9_42_DH_PARAMETER_GEN: "CKM_X9_42_DH_PARAMETER_GEN",
    CKM_VENDOR_DEFINED: "CKM_VENDOR_DEFINED",
}

class CK_SLOT_INFO:
    """
    matches the PKCS#11 CK_SLOT_INFO structure

    @ivar slotDescription: blank padded
    @type slotDescription: string
    @ivar manufacturerID: blank padded
    @type manufacturerID: string
    @ivar flags: See L{flags2text}
    @type flags: integer
    @ivar hardwareVersion: 2 elements list
    @type hardwareVersion: list
    @ivar firmwareVersion: 2 elements list
    @type firmwareVersion: list
    """

    flags_dict = {
        CKF_TOKEN_PRESENT: "CKF_TOKEN_PRESENT",
        CKF_REMOVABLE_DEVICE: "CKF_REMOVABLE_DEVICE",
        CKF_HW_SLOT: "CKF_HW_SLOT"
    }

    def flags2text(self):
        """
        parse the L{self.flags} field and create a list of "CKF_*" strings
        corresponding to bits set in flags

        @return: a list of strings
        @rtype: list
        """
        r = []
        for v in CK_SLOT_INFO.flags_dict.keys():
            if self.flags & v:
                r.append(CK_SLOT_INFO.flags_dict[v])
        return r

class CK_INFO:
    """
    matches the PKCS#11 CK_INFO structure

    @ivar cryptokiVersion: Cryptoki interface version
    @type cryptokiVersion: integer
    @ivar manufacturerID: blank padded
    @type manufacturerID: string
    @ivar flags: must be zero
    @type flags: integer
    @ivar libraryDescription: blank padded
    @type libraryDescription: string
    @ivar libraryVersion: 2 elements list
    @type libraryVersion: list
    """

class CK_TOKEN_INFO:
    """
    matches the PKCS#11 CK_TOKEN_INFO structure

    @ivar label: blank padded
    @type label: string
    @ivar manufacturerID: blank padded
    @type manufacturerID: string
    @ivar model: string blank padded
    @type model: string
    @ivar serialNumber: string blank padded
    @type serialNumber: string
    @ivar flags:
    @type flags: integer
    @ivar ulMaxSessionCount:
    @type ulMaxSessionCount: integer
    @ivar ulSessionCount:
    @type ulSessionCount: integer
    @ivar ulMaxRwSessionCount:
    @type ulMaxRwSessionCount: integer
    @ivar ulRwSessionCount:
    @type ulRwSessionCount: integer
    @ivar ulMaxPinLen:
    @type ulMaxPinLen: integer
    @ivar ulMinPinLen:
    @type ulMinPinLen: integer
    @ivar ulTotalPublicMemory:
    @type ulTotalPublicMemory: integer
    @ivar ulFreePublicMemory:
    @type ulFreePublicMemory: integer
    @ivar ulTotalPrivateMemory:
    @type ulTotalPrivateMemory: integer
    @ivar ulFreePrivateMemory:
    @type ulFreePrivateMemory: integer
    @ivar hardwareVersion: 2 elements list
    @type hardwareVersion: list
    @ivar firmwareVersion: 2 elements list
    @type firmwareVersion: list
    @ivar utcTime: string
    @type utcTime: string
    """

    flags_dict = {
        CKF_RNG: "CKF_RNG",
        CKF_WRITE_PROTECTED: "CKF_WRITE_PROTECTED",
        CKF_LOGIN_REQUIRED: "CKF_LOGIN_REQUIRED",
        CKF_USER_PIN_INITIALIZED: "CKF_USER_PIN_INITIALIZED",
        CKF_RESTORE_KEY_NOT_NEEDED: "CKF_RESTORE_KEY_NOT_NEEDED",
        CKF_CLOCK_ON_TOKEN: "CKF_CLOCK_ON_TOKEN",
        CKF_PROTECTED_AUTHENTICATION_PATH: "CKF_PROTECTED_AUTHENTICATION_PATH",
        CKF_DUAL_CRYPTO_OPERATIONS: "CKF_DUAL_CRYPTO_OPERATIONS",
        CKF_TOKEN_INITIALIZED: "CKF_TOKEN_INITIALIZED",
        CKF_SECONDARY_AUTHENTICATION: "CKF_SECONDARY_AUTHENTICATION",
        CKF_USER_PIN_COUNT_LOW: "CKF_USER_PIN_COUNT_LOW",
        CKF_USER_PIN_FINAL_TRY: "CKF_USER_PIN_FINAL_TRY",
        CKF_USER_PIN_LOCKED: "CKF_USER_PIN_LOCKED",
        CKF_USER_PIN_TO_BE_CHANGED: "CKF_USER_PIN_TO_BE_CHANGED",
        CKF_SO_PIN_COUNT_LOW: "CKF_SO_PIN_COUNT_LOW",
        CKF_SO_PIN_FINAL_TRY: "CKF_SO_PIN_FINAL_TRY",
        CKF_SO_PIN_LOCKED: "CKF_SO_PIN_LOCKED",
        CKF_SO_PIN_TO_BE_CHANGED: "CKF_SO_PIN_TO_BE_CHANGED",
    }

    def flags2text(self):
        """
        parse the L{flags} field and create a list of "CKF_*" strings
        corresponding to bits set in flags

        @return: a list of strings
        @rtype: list
        """
        r = []
        for v in CK_TOKEN_INFO.flags_dict.keys():
            if self.flags & v:
                r.append(CK_TOKEN_INFO.flags_dict[v])
        return r

class PyKCS11Error:
    """ define the possible PKCS#11 error codes """

    errors = {
        -2: "Unkown PKCS#11 type",
        -1: "Load",
        CKR_OK: "CKR_OK",
        CKR_CANCEL: "CKR_CANCEL",
        CKR_HOST_MEMORY: "CKR_HOST_MEMORY",
        CKR_SLOT_ID_INVALID: "CKR_SLOT_ID_INVALID",
        CKR_GENERAL_ERROR: "CKR_GENERAL_ERROR",
        CKR_FUNCTION_FAILED: "CKR_FUNCTION_FAILED",
        CKR_ARGUMENTS_BAD: "CKR_ARGUMENTS_BAD",
        CKR_NO_EVENT: "CKR_NO_EVENT",
        CKR_NEED_TO_CREATE_THREADS: "CKR_NEED_TO_CREATE_THREADS",
        CKR_CANT_LOCK: "CKR_CANT_LOCK",
        CKR_ATTRIBUTE_READ_ONLY: "CKR_ATTRIBUTE_READ_ONLY",
        CKR_ATTRIBUTE_SENSITIVE: "CKR_ATTRIBUTE_SENSITIVE",
        CKR_ATTRIBUTE_TYPE_INVALID: "CKR_ATTRIBUTE_TYPE_INVALID",
        CKR_ATTRIBUTE_VALUE_INVALID: "CKR_ATTRIBUTE_VALUE_INVALID",
        CKR_DATA_INVALID: "CKR_DATA_INVALID",
        CKR_DATA_LEN_RANGE: "CKR_DATA_LEN_RANGE",
        CKR_DEVICE_ERROR: "CKR_DEVICE_ERROR",
        CKR_DEVICE_MEMORY: "CKR_DEVICE_MEMORY",
        CKR_DEVICE_REMOVED: "CKR_DEVICE_REMOVED",
        CKR_ENCRYPTED_DATA_INVALID: "CKR_ENCRYPTED_DATA_INVALID",
        CKR_ENCRYPTED_DATA_LEN_RANGE: "CKR_ENCRYPTED_DATA_LEN_RANGE",
        CKR_FUNCTION_CANCELED: "CKR_FUNCTION_CANCELED",
        CKR_FUNCTION_NOT_PARALLEL: "CKR_FUNCTION_NOT_PARALLEL",
        CKR_FUNCTION_NOT_SUPPORTED: "CKR_FUNCTION_NOT_SUPPORTED",
        CKR_KEY_HANDLE_INVALID: "CKR_KEY_HANDLE_INVALID",
        CKR_KEY_SIZE_RANGE: "CKR_KEY_SIZE_RANGE",
        CKR_KEY_TYPE_INCONSISTENT: "CKR_KEY_TYPE_INCONSISTENT",
        CKR_KEY_NOT_NEEDED: "CKR_KEY_NOT_NEEDED",
        CKR_KEY_CHANGED: "CKR_KEY_CHANGED",
        CKR_KEY_NEEDED: "CKR_KEY_NEEDED",
        CKR_KEY_INDIGESTIBLE: "CKR_KEY_INDIGESTIBLE",
        CKR_KEY_FUNCTION_NOT_PERMITTED: "CKR_KEY_FUNCTION_NOT_PERMITTED",
        CKR_KEY_NOT_WRAPPABLE: "CKR_KEY_NOT_WRAPPABLE",
        CKR_KEY_UNEXTRACTABLE: "CKR_KEY_UNEXTRACTABLE",
        CKR_MECHANISM_INVALID: "CKR_MECHANISM_INVALID",
        CKR_MECHANISM_PARAM_INVALID: "CKR_MECHANISM_PARAM_INVALID",
        CKR_OBJECT_HANDLE_INVALID: "CKR_OBJECT_HANDLE_INVALID",
        CKR_OPERATION_ACTIVE: "CKR_OPERATION_ACTIVE",
        CKR_OPERATION_NOT_INITIALIZED: "CKR_OPERATION_NOT_INITIALIZED",
        CKR_PIN_INCORRECT: "CKR_PIN_INCORRECT",
        CKR_PIN_INVALID: "CKR_PIN_INVALID",
        CKR_PIN_LEN_RANGE: "CKR_PIN_LEN_RANGE",
        CKR_PIN_EXPIRED: "CKR_PIN_EXPIRED",
        CKR_PIN_LOCKED: "CKR_PIN_LOCKED",
        CKR_SESSION_CLOSED: "CKR_SESSION_CLOSED",
        CKR_SESSION_COUNT: "CKR_SESSION_COUNT",
        CKR_SESSION_HANDLE_INVALID: "CKR_SESSION_HANDLE_INVALID",
        CKR_SESSION_PARALLEL_NOT_SUPPORTED: "CKR_SESSION_PARALLEL_NOT_SUPPORTED",
        CKR_SESSION_READ_ONLY: "CKR_SESSION_READ_ONLY",
        CKR_SESSION_EXISTS: "CKR_SESSION_EXISTS",
        CKR_SESSION_READ_ONLY_EXISTS: "CKR_SESSION_READ_ONLY_EXISTS",
        CKR_SESSION_READ_WRITE_SO_EXISTS: "CKR_SESSION_READ_WRITE_SO_EXISTS",
        CKR_SIGNATURE_INVALID: "CKR_SIGNATURE_INVALID",
        CKR_SIGNATURE_LEN_RANGE: "CKR_SIGNATURE_LEN_RANGE",
        CKR_TEMPLATE_INCOMPLETE: "CKR_TEMPLATE_INCOMPLETE",
        CKR_TEMPLATE_INCONSISTENT: "CKR_TEMPLATE_INCONSISTENT",
        CKR_TOKEN_NOT_PRESENT: "CKR_TOKEN_NOT_PRESENT",
        CKR_TOKEN_NOT_RECOGNIZED: "CKR_TOKEN_NOT_RECOGNIZED",
        CKR_TOKEN_WRITE_PROTECTED: "CKR_TOKEN_WRITE_PROTECTED",
        CKR_UNWRAPPING_KEY_HANDLE_INVALID: "CKR_UNWRAPPING_KEY_HANDLE_INVALID",
        CKR_UNWRAPPING_KEY_SIZE_RANGE: "CKR_UNWRAPPING_KEY_SIZE_RANGE",
        CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT: "CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT",
        CKR_USER_ALREADY_LOGGED_IN: "CKR_USER_ALREADY_LOGGED_IN",
        CKR_USER_NOT_LOGGED_IN: "CKR_USER_NOT_LOGGED_IN",
        CKR_USER_PIN_NOT_INITIALIZED: "CKR_USER_PIN_NOT_INITIALIZED",
        CKR_USER_TYPE_INVALID: "CKR_USER_TYPE_INVALID",
        CKR_USER_ANOTHER_ALREADY_LOGGED_IN: "CKR_USER_ANOTHER_ALREADY_LOGGED_IN",
        CKR_USER_TOO_MANY_TYPES: "CKR_USER_TOO_MANY_TYPES",
        CKR_WRAPPED_KEY_INVALID: "CKR_WRAPPED_KEY_INVALID",
        CKR_WRAPPED_KEY_LEN_RANGE: "CKR_WRAPPED_KEY_LEN_RANGE",
        CKR_WRAPPING_KEY_HANDLE_INVALID: "CKR_WRAPPING_KEY_HANDLE_INVALID",
        CKR_WRAPPING_KEY_SIZE_RANGE: "CKR_WRAPPING_KEY_SIZE_RANGE",
        CKR_WRAPPING_KEY_TYPE_INCONSISTENT: "CKR_WRAPPING_KEY_TYPE_INCONSISTENT",
        CKR_RANDOM_SEED_NOT_SUPPORTED: "CKR_RANDOM_SEED_NOT_SUPPORTED",
        CKR_RANDOM_NO_RNG: "CKR_RANDOM_NO_RNG",
        CKR_DOMAIN_PARAMS_INVALID: "CKR_DOMAIN_PARAMS_INVALID",
        CKR_BUFFER_TOO_SMALL: "CKR_BUFFER_TOO_SMALL",
        CKR_SAVED_STATE_INVALID: "CKR_SAVED_STATE_INVALID",
        CKR_INFORMATION_SENSITIVE: "CKR_INFORMATION_SENSITIVE",
        CKR_STATE_UNSAVEABLE: "CKR_STATE_UNSAVEABLE",
        CKR_CRYPTOKI_NOT_INITIALIZED: "CKR_CRYPTOKI_NOT_INITIALIZED",
        CKR_CRYPTOKI_ALREADY_INITIALIZED: "CKR_CRYPTOKI_ALREADY_INITIALIZED",
        CKR_MUTEX_BAD: "CKR_MUTEX_BAD",
        CKR_MUTEX_NOT_LOCKED: "CKR_MUTEX_NOT_LOCKED",
        CKR_VENDOR_DEFINED: "CKR_VENDOR_DEFINED"
        }

    def __init__(self, value, text = ""):
        self.value = value
        self.text = text

    def __str__(self):
        """
        The text representation of a PKCS#11 error is something like:
        "CKR_DEVICE_ERROR (0x00000030)"
        """
        if (self.value < 0):
            return PyKCS11Error.errors[self.value] + " (%s)" % self.text
        else:
            return PyKCS11Error.errors[self.value] + " (0x%08X)" % self.value

class PyKCS11Lib:
    """ high level PKCS#11 binding """

    def __init__(self):
        self.lib = PyKCS11.LowLevel.CPKCS11Lib()

    def __del__(self):
        self.lib.Unload()

    def load(self, pkcs11dll_filename = None, *init_string):
        """
        load a PKCS#11 library

        @type pkcs11dll_filename: string
        @param pkcs11dll_filename: the library name. If this parameter
        is not set the environment variable PYKCS11LIB is used instead
        @return: a L{PyKCS11Lib} object
        @raise PyKCS11Error(-1): when the load fails
        """
        if pkcs11dll_filename == None:
            pkcs11dll_filename = os.getenv("PYKCS11LIB")
            if pkcs11dll_filename == None:
                raise PyKCS11Error(-1, "No PKCS11 library specified (set PYKCS11LIB env variable)")
        rv = self.lib.Load(pkcs11dll_filename, 1)
        if rv == 0:
            raise PyKCS11Error(-1, pkcs11dll_filename)

    def getInfo(self):
        """
        C_GetInfo

        @return: a L{CK_INFO} object
        """
        info = PyKCS11.LowLevel.CK_INFO()
        rv = self.lib.C_GetInfo(info)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

        i = CK_INFO()
        i.cryptokiVersion = (info.cryptokiVersion.major, info.cryptokiVersion.minor)
        i.manufacturerID = info.GetManufacturerID()
        i.flags = info.flags
        i.libraryDescription = info.GetLibraryDescription()
        i.libraryVersion = (info.libraryVersion.major, info.libraryVersion.minor)
        return i

    def getSlotList(self):
        """
        C_GetSlotList

        @return: a list of available slots
        @rtype: list
        """
        slotList = PyKCS11.LowLevel.ckintlist()
        rv = self.lib.C_GetSlotList(0, slotList)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

        s = []
        for x in xrange(len(slotList)):
            s.append(slotList[x])
        return s

    def getSlotInfo(self, slot):
        """
        C_GetSlotInfo

        @param slot: slot number returned by L{getSlotList}
        @type slot: integer
        @return: a L{CK_SLOT_INFO} object
        """
        slotInfo = PyKCS11.LowLevel.CK_SLOT_INFO()
        rv = self.lib.C_GetSlotInfo(slot, slotInfo)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

        s = CK_SLOT_INFO()
        s.slotDescription = slotInfo.GetSlotDescription()
        s.manufacturerID = slotInfo.GetManufacturerID()
        s.flags = slotInfo.flags
        s.hardwareVersion = slotInfo.GetHardwareVersion()
        s.firmwareVersion = slotInfo.GetFirmwareVersion()

        return s

    def getTokenInfo(self, slot):
        """
        C_GetTokenInfo

        @param slot: slot number returned by L{getSlotList}
        @type slot: integer
        @return: a L{CK_TOKEN_INFO} object
        """
        tokeninfo =  PyKCS11.LowLevel.CK_TOKEN_INFO()
        rv = self.lib.C_GetTokenInfo(slot, tokeninfo)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

        t = CK_TOKEN_INFO()
        t.label = tokeninfo.GetLabel()
        t.manufacturerID = tokeninfo.GetManufacturerID()
        t.model = tokeninfo.GetModel()
        t.serialNumber = tokeninfo.GetSerialNumber()
        t.flags = tokeninfo.flags
        t.ulMaxSessionCount = tokeninfo.ulMaxSessionCount
        if t.ulMaxSessionCount == CK_UNAVAILABLE_INFORMATION:
            t.ulMaxSessionCount = -1
        t.ulSessionCount = tokeninfo.ulSessionCount
        if t.ulSessionCount == CK_UNAVAILABLE_INFORMATION:
            t.ulSessionCount = -1
        t.ulMaxRwSessionCount = tokeninfo.ulMaxRwSessionCount
        if t.ulMaxRwSessionCount == CK_UNAVAILABLE_INFORMATION:
            t.ulMaxRwSessionCount = -1
        t.ulRwSessionCount = tokeninfo.ulRwSessionCount
        if t.ulRwSessionCount == CK_UNAVAILABLE_INFORMATION:
            t.ulRwSessionCount = -1
        t.ulMaxPinLen = tokeninfo.ulMaxPinLen
        t.ulMinPinLen = tokeninfo.ulMinPinLen
        t.ulTotalPublicMemory = tokeninfo.ulTotalPublicMemory
        CKU_SO = PyKCS11.LowLevel.CKU_SO
        CKU_USER = PyKCS11.LowLevel.CKU_USER

        if t.ulTotalPublicMemory == CK_UNAVAILABLE_INFORMATION:
            t.ulTotalPublicMemory = -1
        t.ulFreePublicMemory = tokeninfo.ulFreePublicMemory
        if t.ulFreePublicMemory == CK_UNAVAILABLE_INFORMATION:
            t.ulFreePublicMemory = -1
        t.ulTotalPrivateMemory = tokeninfo.ulTotalPrivateMemory
        if t.ulTotalPrivateMemory == CK_UNAVAILABLE_INFORMATION:
            t.ulTotalPrivateMemory = -1
        t.ulFreePrivateMemory = tokeninfo.ulFreePrivateMemory
        if t.ulFreePrivateMemory == CK_UNAVAILABLE_INFORMATION:
            t.ulFreePrivateMemory = -1
        t.hardwareVersion = (tokeninfo.hardwareVersion.major, tokeninfo.hardwareVersion.minor)
        t.firmwareVersion = (tokeninfo.firmwareVersion.major, tokeninfo.firmwareVersion.minor)
        t.utcTime = tokeninfo.GetUtcTime()

        return t

    def openSession(self, slot, flags = 0):
        """
        C_OpenSession

        @param slot: slot number returned by L{getSlotList}
        @type slot: integer
        @return: a L{Session} object
        """
        se = PyKCS11.LowLevel.CK_SESSION_HANDLE()
        flags |= CKF_SERIAL_SESSION
        rv = self.lib.C_OpenSession(slot, flags, se)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

        s = Session()
        s.lib = self.lib
        s.slot = slot
        s.session = se
        return s

class Mechanism:
    """Wraps CK_MECHANISM"""
    def __init__(self, mechanism, param):
        """
        @param mechanism: the mechanism to be used
        @type mechanism: integer, any CKM_* value
        @param param: data to be used as crypto operation parameter
        (i.e. the IV for some agorithms)
        @type param: string or list/tuple of bytes
        
        @see: L{Session.decrypt}, L{Session.sign}
        """
        self.mechanism = mechanism
        self.param = param

MechanismRSAPKCS1 = Mechanism(CKM_RSA_PKCS, None)

class Session:
    """ Manage L{PyKCS11Lib.openSession} objects """

    def closeSession(self):
        """
        C_CloseSession
        """
        rv = self.lib.C_CloseSession(self.session)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

    def closeAllSession(self):
        """
        C_CloseAllSession
        """
        rv = self.lib.C_CloseAllSession(self.slot)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

    def login(self, pin, user_type = CKU_USER):
        """
        C_Login

        @param pin: the user's PIN
        @type pin: string
        @param user_type: the user type. The default value is
        L{CKU_USER}. You may also use L{CKU_SO}
        @type user_type: integer
        """
        rv = self.lib.C_Login(self.session, user_type, pin)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

    def logout(self):
        """
        C_Logout
        """
        rv = self.lib.C_Logout(self.session)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

        del self

    def initToken(self, pin, label):
        """
        C_InitToken
        """
        rv = self.lib.C_InitToken(self.session, pin, label)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

    def initPin(self, new_pin):
        """
        C_InitPIN
        """
        rv = self.lib.C_InitPIN(self.session, new_pin)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

    def setPin(self, old_pin, new_pin):
        """
        C_SetPIN
        """
        rv = self.lib.C_SetPIN(self.session, old_pin, new_pin)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)
            
    def sign(self, key, data, mecha=MechanismRSAPKCS1):
        """
        C_SignInit/C_Sign
        
        @param key: a key handle, obtained calling L{findObjects}.
        @type key: integer
        @param data: the data to be signed
        @type data:  (binary) sring or list/tuple of bytes
        @param mecha: the signing mechanism to be used
        @type mecha: L{Mechanism} instance or L{MechanismRSAPKCS1} 
        for L{CKM_RSA_PKCS}
        @return: the computed signature
        @rtype: list of bytes
        
        @note: the returned value is an istance of L{LowLevel.ckbytelist}.
        You can easly convert it to a binary string with::
            ''.join(chr(i) for i in ckbytelistSignature)
        
        """
        m = PyKCS11.LowLevel.CK_MECHANISM()
        signature = PyKCS11.LowLevel.ckbytelist()
        ba = None # must be declared here or may be deallocated too early
        m.mechanism = mecha.mechanism
        if (mecha.param):
            ba = PyKCS11.LowLevel.byteArray(len(mecha.param))
            if type(mecha.param) is type(''):
                for c in xrange(len(mecha.param)):
                    ba[c] = ord(mecha.param[c])
            else:
                for c in xrange(len(mecha.param)):
                    ba[c] = mecha.param[c]
            # with cast() the ba object continue to own internal pointer (avoids a leak).
            # pParameter is an opaque pointer, never garbage collected.
            m.pParameter = ba.cast()
            m.ulParameterLen = len(mecha.param)
        data1 = PyKCS11.LowLevel.ckbytelist()
        data1.reserve(len(data))
        if type(data) is type(''):
            for x in data:
                data1.append(ord(x))
        else:
            for c in xrange(len(data)):
                data1.append(data[c])
        rv = self.lib.C_SignInit(self.session, m, key)
        if (rv != 0):
            raise PyKCS11Error(rv)
        #first call get signature size
        rv = self.lib.C_Sign(self.session, data1, signature);
        if (rv != 0):
            raise PyKCS11Error(rv)
        #second call get actual signature data
        rv = self.lib.C_Sign(self.session, data1, signature);
        if (rv != 0):
            raise PyKCS11Error(rv)
        return signature
        
    def decrypt(self, key, data, mecha=MechanismRSAPKCS1):
        """
        C_DecryptInit/C_Decrypt
        
        @param key: a key handle, obtained calling L{findObjects}.
        @type key: integer
        @param data: the data to be decrypted
        @type data:  (binary) sring or list/tuple of bytes
        @param mecha: the decrypt mechanism to be used
        @type mecha: L{Mechanism} instance or L{MechanismRSAPKCS1}
        for L{CKM_RSA_PKCS}
        @return: the decrypted data
        @rtype: list of bytes
        
        @note: the returned value is an istance of L{LowLevel.ckbytelist}.
        You can easly convert it to a binary string with::
            ''.join(chr(i) for i in ckbytelistData)
        
        """
        m = PyKCS11.LowLevel.CK_MECHANISM()
        decrypted = PyKCS11.LowLevel.ckbytelist()
        ba = None # must be declared here or may be deallocated too early
        m.mechanism = mecha.mechanism
        if (mecha.param):
            ba = PyKCS11.LowLevel.byteArray(len(mecha.param))
            if type(mecha.param) is type(''):
                for c in xrange(len(mecha.param)):
                    ba[c] = ord(mecha.param[c])
            else:
                for c in xrange(len(mecha.param)):
                    ba[c] = mecha.param[c]
            # with cast() the ba object continue to own internal pointer (avoids a leak).
            # pParameter is an opaque pointer, never garbage collected.
            m.pParameter = ba.cast()
            m.ulParameterLen = len(mecha.param)
        data1 = PyKCS11.LowLevel.ckbytelist()
        data1.reserve(len(data))
        if type(data) is type(''):
            for x in data:
                data1.append(ord(x))
        else:
            for c in xrange(len(data)):
                data1.append(data[c])
        rv = self.lib.C_DecryptInit(self.session, m, key)
        if (rv != 0):
            raise PyKCS11Error(rv)
        #first call get decrypted size
        rv = self.lib.C_Decrypt(self.session, data1, decrypted);
        if (rv != 0):
            raise PyKCS11Error(rv)
        #second call get actual decrypted data
        rv = self.lib.C_Decrypt(self.session, data1, decrypted);
        if (rv != 0):
            raise PyKCS11Error(rv)
        return decrypted
        
    def isNum(self, type):
        if type in (CKA_CERTIFICATE_TYPE,
            CKA_CLASS,
            CKA_KEY_GEN_MECHANISM,
            CKA_KEY_TYPE,
            CKA_VALUE_BITS,
            CKA_VALUE_LEN):
            return True
        return False

    def isString(self, type):
        if type in (CKA_LABEL,
            CKA_APPLICATION):
            return True
        return False

    def isBool(self, type):
        if type in (CKA_ALWAYS_SENSITIVE,
        CKA_DECRYPT,
            CKA_ENCRYPT,
            CKA_HAS_RESET,
            CKA_LOCAL,
            CKA_MODIFIABLE,
            CKA_NEVER_EXTRACTABLE,
            CKA_PRIVATE,
            CKA_RESET_ON_INIT,
            CKA_SECONDARY_AUTH,
            CKA_SENSITIVE,
            CKA_SIGN,
            CKA_SIGN_RECOVER,
            CKA_TOKEN,
            CKA_TRUSTED,
            CKA_UNWRAP,
            CKA_VERIFY,
            CKA_VERIFY_RECOVER,
            CKA_WRAP):
            return True
        return False

    def isBin(self, type):
        return (not self.isBool(type)) and (not self.isString(type)) and (not self.isNum(type))

    def findObjects(self, template = ()):
        """
        find the objects matching the template pattern

        @param template: list of attributes tuples (attribute,value).
        The default value is () and all the objects are returned
        @type template: list
        @return: a list of object ids
        @rtype: list
        """
        t = PyKCS11.LowLevel.ckattrlist(len(template))
        for x in xrange(len(template)):
            attr = template[x]
            if self.isNum(attr[0]):
                t[x].SetNum(attr[0], attr[1])
            elif self.isString(attr[0]):
                t[x].SetString(attr[0], attr[1])
            elif self.isBool(attr[0]):
                t[x].SetBool(attr[0], attr[1])
            elif self.isBin(attr[0]):
                t[x].SetBin(attr[0], attr[1])
            else:
                raise PyKCS11Error(-2)

        # we search for 10 objects by default. speed/memory tradeoff
        result = PyKCS11.LowLevel.ckobjlist(10)

        self.lib.C_FindObjectsInit(self.session, t)

        res = []
        while True:
            self.lib.C_FindObjects(self.session, result)
            for x in result:
                res.append(x)
            if len(result) == 0:
                break

        self.lib.C_FindObjectsFinal(self.session)
        return res

    def getAttributeValue(self, obj_id, attr, allAsBinary = False):
        """
        C_GetAttributeValue

        @param obj_id: object ID returned by L{findObjects}
        @type obj_id: integer
        @param attr: list of attributes
        @type attr: list
        @param allAsBinary: return all values as binary data; default is False.
        @type allAsBinary: Boolean
        @return: a list of values corresponding to the list of
        attributes
        @rtype: list
        
        @see: L{getAttributeValue_fragmented}
        
        @note: if allAsBinary is True the function don't converts results to
        Python types (i.e.: CKA_TOKEN to Bool, CKA_CLASS to int, ...).
        Binary data is returned as L{LowLevel.ckbytelist} type, usable
        as a list containing only bytes.
        You can easly convert it to a binary string with::
            ''.join(chr(i) for i in ckbytelistVariable)
        
        """
        valTemplate = PyKCS11.LowLevel.ckattrlist(len(attr))
        for x in xrange(len(attr)):
            valTemplate[x].SetType(attr[x])
        # first call to get the attribute size and reserve the memory
        rv = self.lib.C_GetAttributeValue(self.session, obj_id, valTemplate)
        if rv == CKR_ATTRIBUTE_TYPE_INVALID \
           or rv == CKR_ATTRIBUTE_SENSITIVE:
            return self.getAttributeValue_fragmented(obj_id, attr, allAsBinary)

        if rv != CKR_OK:
            raise PyKCS11Error(rv)
        # second call to get the attribute value
        rv = self.lib.C_GetAttributeValue(self.session, obj_id, valTemplate)
        if rv != CKR_OK:
            raise PyKCS11Error(rv)

        res = []
        for x in xrange(len(attr)):
            if (allAsBinary):
                res.append(valTemplate[x].GetBin())
            elif valTemplate[x].IsNum():
                res.append(valTemplate[x].GetNum())
            elif valTemplate[x].IsBool():
                res.append(valTemplate[x].GetBool())
            elif valTemplate[x].IsString():
                res.append(valTemplate[x].GetString())
            elif valTemplate[x].IsBin():
                res.append(valTemplate[x].GetBin())
            else:
                raise PyKCS11Error(-2)

        return res

    def getAttributeValue_fragmented(self, obj_id, attr, allAsBinary = False):
        """
        Same as L{getAttributeValue} except that when some attribute
        is sensitive or unknown an empty value (None) is retruned.
        
        Note: this is achived getting attributes one by one.
        
        @see: L{getAttributeValue}
        """
        # some attributes does not exists or is sensitive
        # but we don't know which ones. So try one by one
        valTemplate = PyKCS11.LowLevel.ckattrlist(1)
        res = []
        for x in xrange(len(attr)):
            valTemplate[0].Reset()
            valTemplate[0].SetType(attr[x])
            # first call to get the attribute size and reserve the memory
            rv = self.lib.C_GetAttributeValue(self.session, obj_id, valTemplate)
            if rv == CKR_ATTRIBUTE_TYPE_INVALID \
               or rv == CKR_ATTRIBUTE_SENSITIVE:
                # append an empty value
                res.append(None)
                continue

            if rv != CKR_OK:
                raise PyKCS11Error(rv)
            # second call to get the attribute value
            rv = self.lib.C_GetAttributeValue(self.session, obj_id, valTemplate)
            if rv != CKR_OK:
                raise PyKCS11Error(rv)
            
            if (allAsBinary):
                res.append(valTemplate[0].GetBin())
            elif valTemplate[0].IsNum():
                res.append(valTemplate[0].GetNum())
            elif valTemplate[0].IsBool():
                res.append(valTemplate[0].GetBool())
            elif valTemplate[0].IsString():
                res.append(valTemplate[0].GetString())
            elif valTemplate[0].IsBin():
                res.append(valTemplate[0].GetBin())
            else:
                raise PyKCS11Error(-2)

        return res

if __name__ == "__main__":
    # sample test/debug code
    p = PyKCS11Lib()
    p.load()

    print "getInfo"
    i = p.getInfo()
    print "cryptokiVersion: %d.%d" % i.cryptokiVersion
    print "manufacturerID:", i.manufacturerID
    print "flags:", i.flags
    print "libraryDescription:", i.libraryDescription
    print "libraryVersion: %d.%d" % i.libraryVersion

    print
    print "getSlotList"
    s = p.getSlotList()
    print "slots:", s

    print
    print "getSlotInfo"
    i = p.getSlotInfo(s[0])
    print "slotDescription:", i.slotDescription.strip()
    print "manufacturerID:", i.manufacturerID
    print "flags:", i.flags
    print "flags:", i.flags2text()
    print "hardwareVersion:", i.hardwareVersion
    print "firmwareVersion:", i.firmwareVersion

    print
    print "getTokenInfo"
    t = p.getTokenInfo(s[0])
    print "label:", t.label
    print "manufacturerID:", t.manufacturerID
    print "model:", t.model
    print "serialNumber:", t.serialNumber
    print "flags:", t.flags
    print "flags:", t.flags2text()
    print "ulMaxSessionCount:", t.ulMaxSessionCount
    print "ulSessionCount:", t.ulSessionCount
    print "ulMaxRwSessionCount:", t.ulMaxRwSessionCount
    print "ulRwSessionCount:", t.ulRwSessionCount
    print "ulMaxPinLen:", t.ulMaxPinLen
    print "ulMinPinLen:", t.ulMinPinLen
    print "ulTotalPublicMemory:", t.ulTotalPublicMemory
    print "ulFreePublicMemory:", t.ulFreePublicMemory
    print "ulTotalPrivateMemory:", t.ulTotalPrivateMemory
    print "ulFreePrivateMemory:", t.ulFreePrivateMemory
    print "hardwareVersion: %d.%d" % t.hardwareVersion
    print "firmwareVersion: %d.%d" % t.firmwareVersion
    print "utcTime:", t.utcTime

    print
    print "openSession"
    se = p.openSession(s[0])

    print
    print "login"
    se.login(pin = "1234")

    print
    print "findObjects"
    objs = se.findObjects([(CKA_CLASS, CKO_CERTIFICATE)])
    print objs

    print
    print "getAttributeValue"
    for o in objs:
        attr = se.getAttributeValue(o, [CKA_LABEL, CKA_CLASS])
        print attr

    print
    print "logout"
    se.logout()

    print
    print "closeSession"
    se.closeSession()

