import os
from setuptools import setup
import bloggerfs

def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()


setup(name='bloggerfs',
      version=bloggerfs.__version__,
      author='Marco Giusti',
      author_email='marco.giusti@gmail.com',
      url='http://bitbucket.org/gm/bloggerfs',
      description='Blogger filesystem using FUSE',
      long_description=read('README.txt'),
      license='LGPL',
      keywords='fuse blogger filesystem',
      platforms=['posix'],
      packages=['bloggerfs'],
      install_requires=['zope.interface', 'gdata', 'fuse-python'],
      test_suite='bloggerfs.test_bloggerfs',
      entry_points = {
          'console_scripts': [
              'bloggerfs = bloggerfs.bloggerfs:main'
          ],
          'pytest11': [
              'get_test_modules = bloggerfs.pytest_collect_modules',
          ],
      },
      classifiers=[
          'Development Status :: 4 - Beta',
          'Environment :: Console',
          'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)',
          'Operating System :: POSIX',
          'Topic :: System :: Filesystems',
      ]
     )

