# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LuisResult(Model):
    """Prediction, based on the input query, containing intent(s) and entities.

    :param query: The input utterance that was analyzed.
    :type query: str
    :param altered_query: The corrected utterance (when spell checking was
     enabled).
    :type altered_query: str
    :param top_scoring_intent:
    :type top_scoring_intent:
     ~azure.cognitiveservices.language.luis.runtime.models.IntentModel
    :param intents: All the intents (and their score) that were detected from
     utterance.
    :type intents:
     list[~azure.cognitiveservices.language.luis.runtime.models.IntentModel]
    :param entities: The entities extracted from the utterance.
    :type entities:
     list[~azure.cognitiveservices.language.luis.runtime.models.EntityModel]
    :param composite_entities: The composite entities extracted from the
     utterance.
    :type composite_entities:
     list[~azure.cognitiveservices.language.luis.runtime.models.CompositeEntityModel]
    :param sentiment_analysis:
    :type sentiment_analysis:
     ~azure.cognitiveservices.language.luis.runtime.models.Sentiment
    :param connected_service_result:
    :type connected_service_result:
     ~azure.cognitiveservices.language.luis.runtime.models.LuisResult
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'altered_query': {'key': 'alteredQuery', 'type': 'str'},
        'top_scoring_intent': {'key': 'topScoringIntent', 'type': 'IntentModel'},
        'intents': {'key': 'intents', 'type': '[IntentModel]'},
        'entities': {'key': 'entities', 'type': '[EntityModel]'},
        'composite_entities': {'key': 'compositeEntities', 'type': '[CompositeEntityModel]'},
        'sentiment_analysis': {'key': 'sentimentAnalysis', 'type': 'Sentiment'},
        'connected_service_result': {'key': 'connectedServiceResult', 'type': 'LuisResult'},
    }

    def __init__(self, **kwargs):
        super(LuisResult, self).__init__(**kwargs)
        self.query = kwargs.get('query', None)
        self.altered_query = kwargs.get('altered_query', None)
        self.top_scoring_intent = kwargs.get('top_scoring_intent', None)
        self.intents = kwargs.get('intents', None)
        self.entities = kwargs.get('entities', None)
        self.composite_entities = kwargs.get('composite_entities', None)
        self.sentiment_analysis = kwargs.get('sentiment_analysis', None)
        self.connected_service_result = kwargs.get('connected_service_result', None)
