# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OpenShiftManagedClusterMasterPoolProfile(Model):
    """OpenShiftManagedClusterMaterPoolProfile contains configuration for
    OpenShift master VMs.

    All required parameters must be populated in order to send to Azure.

    :param name: Unique name of the master pool profile in the context of the
     subscription and resource group.
    :type name: str
    :param count: Required. Number of masters (VMs) to host docker containers.
     The default value is 3.
    :type count: int
    :param vm_size: Required. Size of agent VMs. Possible values include:
     'Standard_D2s_v3', 'Standard_D4s_v3', 'Standard_D8s_v3',
     'Standard_D16s_v3', 'Standard_D32s_v3', 'Standard_D64s_v3',
     'Standard_DS4_v2', 'Standard_DS5_v2', 'Standard_F8s_v2',
     'Standard_F16s_v2', 'Standard_F32s_v2', 'Standard_F64s_v2',
     'Standard_F72s_v2', 'Standard_F8s', 'Standard_F16s', 'Standard_E4s_v3',
     'Standard_E8s_v3', 'Standard_E16s_v3', 'Standard_E20s_v3',
     'Standard_E32s_v3', 'Standard_E64s_v3', 'Standard_GS2', 'Standard_GS3',
     'Standard_GS4', 'Standard_GS5', 'Standard_DS12_v2', 'Standard_DS13_v2',
     'Standard_DS14_v2', 'Standard_DS15_v2', 'Standard_L4s', 'Standard_L8s',
     'Standard_L16s', 'Standard_L32s'
    :type vm_size: str or
     ~azure.mgmt.containerservice.v2019_04_30.models.OpenShiftContainerServiceVMSize
    :param subnet_cidr: Subnet CIDR for the peering.
    :type subnet_cidr: str
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux',
     'Windows'. Default value: "Linux" .
    :type os_type: str or
     ~azure.mgmt.containerservice.v2019_04_30.models.OSType
    """

    _validation = {
        'count': {'required': True},
        'vm_size': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'subnet_cidr': {'key': 'subnetCidr', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OpenShiftManagedClusterMasterPoolProfile, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.count = kwargs.get('count', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.subnet_cidr = kwargs.get('subnet_cidr', None)
        self.os_type = kwargs.get('os_type', "Linux")
