# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NetworkProfile(Model):
    """Represents the OpenShift networking configuration.

    :param vnet_cidr: CIDR for the OpenShift Vnet. Default value: "10.0.0.0/8"
     .
    :type vnet_cidr: str
    :param peer_vnet_id: CIDR of the Vnet to peer.
    :type peer_vnet_id: str
    :param vnet_id: ID of the Vnet created for OSA cluster.
    :type vnet_id: str
    """

    _attribute_map = {
        'vnet_cidr': {'key': 'vnetCidr', 'type': 'str'},
        'peer_vnet_id': {'key': 'peerVnetId', 'type': 'str'},
        'vnet_id': {'key': 'vnetId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkProfile, self).__init__(**kwargs)
        self.vnet_cidr = kwargs.get('vnet_cidr', "10.0.0.0/8")
        self.peer_vnet_id = kwargs.get('peer_vnet_id', None)
        self.vnet_id = kwargs.get('vnet_id', None)
