"""This module provides example data of various isotherms."""

import numpy as np
from . import util

def _sample( descr, Qads, Prel, Pabs ):
    return util.make_touple(
        "GasAdsSample", 
        descr = descr,
        Qads = Qads,
        Prel = Prel,
        Pabs = Pabs
    )

def carbon_black() :
    """Return carbon black isotherm data"""

    descr = "Carbon black - nitrogen : Carbon Reference Material analyzed with N2 at 77 K : Adsorption"
    Qads = np.array([4.39005, 4.67017, 4.79068, 4.9767, 5.14414, 5.31144,
                     5.47106, 5.63297, 5.80559, 5.96663, 6.13574, 6.31214,
                     6.49764, 6.67154, 6.85255, 7.04053, 7.22571, 7.40778,
                     7.59634, 7.7832, 7.96568, 8.1623, 8.34863, 8.54383,
                     8.74695, 8.94871, 9.16214, 9.38208, 9.61289, 9.8577,
                     10.12, 10.397, 10.6852, 11.0089, 11.3574, 11.7373,
                     12.1611, 12.6289, 13.1794, 13.819, 14.57, 15.4858,
                     16.6535, 18.2409])
    Prel = np.array([0.0433547, 0.0672921, 0.0796994, 0.0999331, 0.119912,
                     0.140374, 0.159884, 0.179697, 0.200356, 0.219646,
                     0.239691, 0.259671, 0.280475, 0.299907, 0.320048,
                     0.340746, 0.360882, 0.380708, 0.400956, 0.421168,
                     0.440603, 0.460924, 0.480902, 0.500572, 0.521144,
                     0.540715, 0.560852, 0.580887, 0.600803, 0.62089,
                     0.64084, 0.66093, 0.68071, 0.70082, 0.72096, 0.74084,
                     0.76081, 0.78045, 0.80084, 0.82107, 0.84075, 0.86069,
                     0.88041, 0.90023])

    return _sample( descr, Qads, Prel, Pabs=np.array([]) )

def silica_alumina():
    """Return Silica Alumina isotherm data"""

    descr = "Silica Alumina - nitrogen : Silica Alumina Reference Material analyzed with N2 at 77 K : Adsorption"

    Qads = np.array([21.5917, 42.9898, 46.1971, 49.4713, 50.6657, 
                     52.9288, 54.3606, 56.4905, 58.6398, 60.7813, 
                     62.9587, 65.181, 67.4606, 69.386, 71.3095, 
                     75.1355, 78.9989, 84.4172, 88.8839, 95.5225, 
                     102.672, 111.095, 121.707, 139.184, 157.984, 
                     179.096, 194.776, 218.024, 238.693, 254.364, 
                     278.122, 299.342, 319.894, 334.565, 355.256, 
                     363.273, 370.223, 374.043, 379.709, 383.603, 
                     387.249, 391.036, 392.934, 394.675, 396.266, 
                     397.77, 399.017, 400.118, 400.768, 401.384, 
                     401.832, 402.327, 402.796, 403.119, 403.285, 
                     403.793])

    Prel = np.array([0.0016015, 0.0464897, 0.0684736, 0.0969082, 
                     0.108629, 0.132342, 0.148152, 0.172548, 0.197676, 
                     0.22288, 0.248245, 0.273644, 0.298949, 0.319738, 
                     0.339909, 0.378098, 0.413883, 0.459512, 0.49335, 
                     0.537268, 0.577447, 0.615957, 0.654583, 0.700537, 
                     0.733928, 0.760074, 0.774668, 0.792476, 0.805294, 
                     0.814095, 0.82605, 0.836131, 0.847441, 0.855713, 
                     0.872834, 0.883623, 0.896659, 0.904157, 0.917128, 
                     0.927033, 0.936437, 0.947542, 0.952995, 0.958511, 
                     0.963535, 0.968913, 0.974107, 0.978857, 0.981679, 
                     0.984637, 0.986876, 0.989071, 0.991656, 0.993813, 
                     0.99456, 0.996251])

    return _sample( descr, Qads, Prel, Pabs=np.array([]) )

def mcm_41():
    """ Return MCM 41 isotherm data """

    descr = "MCM 41 - nitrogen : Silica Alumina Reference Material analyzed with N2 at 77 K : Adsorption"

    Prel = np.array([ 1.27641e-006, 2.60821e-006, 4.90191e-006, 8.64173e-006, 
                      1.45091e-005, 2.33148e-005, 3.60338e-005, 5.38433e-005, 
                      7.83685e-005, 0.000111531, 0.000157256, 0.00021559, 
                      0.000291904, 0.000390757, 0.000517742, 0.000678996, 
                      0.000881968, 0.00113459, 0.00144642, 0.00182666, 
                      0.0022887, 0.00283858, 0.00350246, 0.00427804, 
                      0.00517076, 0.00620341, 0.00733796, 0.00858089, 
                      0.00990753, 0.0113595, 0.0129506, 0.0148408, 
                      0.0169191, 0.0199903, 0.0253761, 0.0297686, 
                      0.0350414, 0.0399594, 0.0450015, 0.0500217, 
                      0.0537369, 0.0600049, 0.0649258, 0.0699835, 
                      0.0748965, 0.0799626, 0.0848824, 0.0898016, 
                      0.0948595, 0.0997775, 0.104695, 0.109606, 
                      0.114397, 0.119306, 0.124152, 0.128998, 
                      0.133899, 0.139087, 0.144013, 0.148937, 
                      0.153802, 0.158739, 0.163667, 0.168528, 
                      0.173449, 0.178367, 0.183289, 0.187876, 
                      0.193218, 0.198316, 0.203404, 0.208396, 
                      0.214517, 0.219644, 0.224649, 0.229764, 
                      0.234827, 0.23996, 0.245091, 0.250147, 
                      0.25529, 0.260364, 0.265496, 0.270625, 
                      0.2757, 0.280937, 0.285634, 0.290704, 
                      0.295775, 0.300847, 0.305917, 0.310929, 
                      0.315977, 0.32079, 0.325662, 0.330321, 
                      0.334718, 0.338905, 0.342682, 0.348696, 
                      0.354114, 0.356299, 0.359524, 0.360712, 
                      0.364091, 0.365702, 0.368652, 0.37062, 
                      0.373555, 0.375711, 0.378184, 0.380932, 
                      0.383973, 0.388738, 0.390225, 0.393932, 
                      0.400572, 0.404742, 0.40984, 0.414922, 
                      0.420089, 0.424828, 0.430426, 0.43507, 
                      0.440219, 0.445296, 0.450291, 0.455425, 
                      0.460296, 0.465437, 0.470468, 0.475444, 
                      0.48051, 0.485522, 0.490652, 0.495519, 
                      0.500608, 0.510497, 0.520012, 0.530254, 
                      0.540018, 0.550128, 0.560239, 0.570142, 
                      0.580156, 0.590136, 0.60013, 0.610172, 
                      0.6202, 0.630097, 0.640216, 0.650169, 
                      0.660246, 0.670081, 0.680263, 0.690237, 
                      0.700211, 0.710241, 0.720154, 0.730183, 
                      0.740088, 0.750138, 0.760161, 0.770058, 
                      0.780101, 0.790158, 0.800048, 0.810133, 
                      0.820023, 0.830163, 0.839963, 0.850068, 
                      0.860034, 0.870069, 0.880091, 0.889981, 
                      0.899967, 0.910016, 0.920154, 0.92987, 
                      0.939968, 0.949911, 0.959671, 0.968963, 
                      0.976962, 0.980556 ])


    Qads = np.array([5.10006, 10.2007, 15.3004, 20.3994, 
                     25.4971, 30.5928, 35.6855, 40.7753, 
                     45.8598, 50.9379, 56.0075, 61.0676, 
                     66.1098, 71.1339, 76.134, 81.1037, 
                     86.0355, 90.9209, 95.7505, 100.513, 
                     105.197, 109.792, 114.391, 118.867, 
                     123.204, 127.472, 131.639, 135.389, 
                     139.016, 142.494, 145.899, 149.6, 
                     153.147, 157.92, 164.83, 169.787, 
                     175.007, 179.388, 183.507, 187.332, 
                     189.955, 194.104, 197.25, 200.227, 
                     203.051, 205.831, 208.471, 211.05, 
                     213.507, 215.937, 218.249, 220.501, 
                     222.728, 224.928, 227.06, 229.167, 
                     231.204, 233.38, 235.439, 237.419, 
                     239.42, 241.408, 243.31, 245.252, 
                     247.176, 249.074, 251.044, 252.975, 
                     254.687, 256.402, 258.203, 259.929, 
                     262.201, 264.039, 266.002, 267.929, 
                     269.858, 271.8, 273.695, 275.681, 
                     277.673, 279.685, 281.72, 283.728, 
                     285.819, 287.919, 289.873, 292.07, 
                     294.263, 296.454, 298.753, 301.121, 
                     303.455, 306.156, 308.769, 311.745, 
                     315.04, 318.573, 322.608, 330.968, 
                     343.048, 348.282, 358.682, 362.142, 
                     374.384, 379.668, 391.762, 398.839, 
                     410.828, 417.118, 426.651, 434.31, 
                     442.319, 454.389, 457.022, 463.344, 
                     472.35, 476.533, 480.349, 483.223, 
                     485.337, 487.042, 488.534, 489.564, 
                     490.593, 491.479, 492.288, 493.009, 
                     493.694, 494.371, 494.997, 495.594, 
                     496.192, 496.808, 497.365, 497.917, 
                     498.498, 499.514, 500.527, 501.518, 
                     502.5, 503.563, 504.581, 505.57, 
                     506.543, 507.525, 508.507, 509.479, 
                     510.398, 511.346, 512.292, 513.262, 
                     514.176, 515.14, 516.114, 517.048, 
                     518.002, 518.94, 519.914, 520.913, 
                     521.924, 522.935, 523.908, 524.909, 
                     525.955, 526.992, 528.043, 529.104, 
                     530.231, 531.358, 532.517, 533.743, 
                     534.997, 536.329, 537.666, 539.048, 
                     540.603, 542.384, 544.177, 546.153, 
                     548.527, 551.334, 554.961, 560.795, 
                     573.044, 582.957 ])

    return _sample( descr, Qads, Prel, Pabs=np.array([]) )

def zsm_5():

    descr = "ZSM-5 with Argon at 87K : Adsorption"

    Pabs = np.array([0.000550944, 0.00125234, 0.00201943, 0.00287494, 
                     0.00374617, 0.00472216, 0.00575706, 0.00685686, 
                     0.00804227, 0.00927519, 0.010638, 0.0120906, 
                     0.0136739, 0.0155067, 0.0175036, 0.0199029, 
                     0.0226501, 0.0265841, 0.0308749, 0.0360806, 
                     0.0429855, 0.0529933, 0.0670164, 0.089222, 
                     0.125268, 0.189935, 0.318431, 0.569838, 
                     0.815439, 1.46403, 2.376, 2.8266, 
                     3.61817, 4.48518, 5.04938, 5.87721, 
                     6.62262, 7.37314, 14.7118, 21.7727, 
                     33.4041, 42.4915, 59.7287, 77.0977, 
                     127.816, 164.812, 201.933, 238.912, 
                     275.867, 312.942, 350.292, 387.293, 
                     424.591, 461.675, 498.507, 535.264, 
                     573.143, 610.215, 647.152, 682.824, 713.608])

    Qads = np.array([2.9699, 5.93056, 8.88141, 11.8228, 
                     14.7718, 17.7248, 20.6808, 23.6441, 
                     26.5963, 29.5645, 32.5343, 35.4813, 
                     38.4156, 41.359, 44.3211, 47.3002, 
                     50.2784, 53.2155, 56.1965, 59.1842, 
                     62.1928, 65.2315, 68.1664, 71.143, 
                     74.037, 76.9003, 79.6843, 82.3116, 
                     84.9194, 97.9929, 102.401, 103.788, 
                     105.827, 107.372, 108.134, 109.077, 
                     109.779, 110.401, 114.195, 116.124, 
                     118.146, 119.254, 120.904, 122.263, 
                     125.676, 127.947, 130.109, 132.219, 
                     134.311, 136.4, 138.474, 140.467, 
                     142.502, 144.518, 146.572, 148.659, 
                     150.868, 153.107, 155.701, 159.725, 169.679])

    return _sample( descr, Qads, Prel=np.array([]), Pabs=Pabs )
