﻿from skidl import SchLib, Pin, Part, Net, SubCircuit, ERC, generate_netlist, NC, POWER

xess_lib = SchLib('C:/xesscorp/KiCad/libraries/xess.lib')

psoc = Part('C:/xesscorp/KiCad/libraries/Cypress_cy8c5xlp.lib', 'CY8C58LP-QFN68', footprint='XESS:QFN68_PSoC5')
psoc[:] = NC
psoc.ref = 5

small_cap = Part(xess_lib, 'C-NONPOL', footprint='Capacitors_SMD:C_0402', value='0.1uF', dest='TEMPLATE')
med_cap = Part(xess_lib, 'C-NONPOL', footprint='Capacitors_SMD:C_0603', value='1uF', dest='TEMPLATE')
small_res = Part(xess_lib, 'R', footprint='Resistors_SMD:R_0402', dest='TEMPLATE')
med_res = Part(xess_lib, 'R', footprint='Resistors_SMD:R_0603', dest='TEMPLATE')

gnd = Net('GND', drive=POWER)
vin = Net('+5V', drive=POWER)      # Main power supply.
vin_usb = Net('+5V-USB', drive=POWER)      # Power from USB port.
v_digital = Net('+3.3V', drive=POWER)      # Digital supply.
v_analog = Net('+3.3V-A', drive=POWER)  # Analog supply.

# Voltage regulator converts +5V to +3.3V.
vreg = Part(xess_lib, '1117', footprint='XESS:SOT-223', value='NCV1117')
vreg['GND', 'IN', 'OUT'] = gnd, vin, Net()
vreg['HS'] = vreg['OUT']
# Filter caps on regulator input and output.
med_cap.copy()[1,2] = gnd, vreg['IN']
med_cap.copy()[1,2] = gnd, vreg['OUT']

# Jumpers on the voltage regulator input and output.
jmp = 2 * Part(xess_lib, 'JUMPER', footprint='XESS:xess-JP1', dest='TEMPLATE')
jmp[0].ref = 'JPA'
jmp[1].ref = 'JPA'

# Shorting traces that go in-parallel with the jumpers.
shrt = 2 * Part(xess_lib, 'JSHORTNORMAL', footprint='XESS:xess-JSHORT', dest='TEMPLATE')

# Connect a jumper between the USB power supply and the regulator input.
jmp[0][1,2] = vin_usb, vreg['IN']
shrt[0][1,2] = jmp[0][1,2] # Connect shorting trace in-parallel with jumper.

# Connect a jumper between the regulator output and the +3.3V supply line.
jmp[1][1,2] = vreg['OUT'], v_digital
shrt[1][1,2] = jmp[1][1,2] # Connect shorting trace in-parallel with jumper.

# The +3.3V analog supply is the +3.3V supply run through a ferrite bead.
ferrite = Part(xess_lib, 'FERRITE.*', value='10uH', footprint='Resistors_SMD:R_0805')
ferrite[1,2] = v_digital, v_analog

# PSoC PWR/GND connections.
psoc['VSSD.*', 'VSSA.*', 'VBAT', 'VSSB', 'VBOOST'] = gnd
psoc['VDDD.*', 'VDDIO.*'] = v_digital
psoc['VDDA.*'] = v_analog
#psoc['IND'] = OPEN

# Bypass caps on PSoC power pins.
for p in psoc['VDDD.*', 'VDDA.*']:
    small_cap.copy()[1,2] = gnd, p
    med_cap.copy()[1,2] = gnd,p
for p in psoc['VDDIO.*']:
    small_cap.copy()[1,2] = gnd, p

# Filter caps on voltage supplies generated by the PSoC.
for p in psoc['VCCD.*', 'VCCA.*']:
    med_cap.copy()[1,2] = gnd,p

# USB connections.
usb_port = Part(xess_lib, 'USBB', footprint='XESS:UX60SC-MB-5ST')
usb_port['VCC'] = vin_usb
usb_port['D-'] = psoc['.*D-.*']
usb_port['D\+'] = psoc['.*D\+.*']
#usb_port['NC'] = OPEN
# The USB connector shield attaches to ground through a res and cap in ||.
shield_cap = small_cap.copy(1, value='4.7nF')
shield_res = small_res.copy(1, value='1M')
usb_port['SHIELD'] = shield_cap[1]
shield_res[1] = usb_port['SH']
gnd += shield_cap[2], shield_res[2]

# LEDs.
# leds = 4 * Part(xess_lib, 'LED', footprint='LEDs:LED-0603')
# for i, led in zip(range(1,5), leds):
    # led.ref = 'D' + str(i)
# limit_res = Part(xess_lib, 'RN4', footprint='XESS:CTS_742C083')
# limit_res[5,6,7,8] = gnd
# limit_res[1,2,3,4] = leds[0]['C'], leds[1]['C'], leds[2]['C'], leds[3]['C']
# leds[0]['A'] = psoc['P12\[7\].*']
# leds[1]['A'] = psoc['P12\[6\].*']
# leds[2]['A'] = psoc['P1\[7\].*']
# leds[3]['A'] = psoc['P1\[6\].*']

ERC()
generate_netlist('xiota.net')



# psoc = Part('C:/xesscorp/KiCad/libraries/Cypress_cy8c5xlp.lib', 'CY8C52LP-QFN68')
# psoc.val = 'CY8C52LP-QFN68'
# psoc.ref = 'UPSOC1'
# psoc_u = (psoc.unit(i) for i in range(1,1+int(psoc.definition['unit_count'])))
# psoc_u = psoc.unit(6,slice(6,8))
# for p in psoc_u.pins:
    # print(p.unit, p.name, p.num, p.part.name, p.part.ref)

# psoc_uu = []
# for u in psoc_u:
    # psoc_uu.append(u)

# psoc_u1 = psoc_u1 * 10

# bypass_caps = 10 * Part(xess_lib,'C-NONPOL', val='1uF')
# bypass_caps[3].val = '0.1uF'
# bypass_caps[4].val = '0.1uF'
# bypass_caps[7].val = '0.1uF'

# ferr_bead = Part(xess_lib,'.*FERRITE.*')
# ferr_bead.val = '10uH'

# vreg = Part(xess_lib,'1117')
# usb_pwr_jumper, v33_pwr_jumper = [Part(xess_lib,'JUMPER') for i in range(2)]
# usb_pwr_jumper_shrt, v33_pwr_jumper_shrt = [Part(xess_lib,'JSHORTNORMAL') for i in range(2)]

# v_5 = Net('+5V')
# v_5_usb = Net('+5V-USB')
# v_3_3 = Net('+3.3V')
# v_3_3_a = Net('+3.3V-A')
# gnd = Net('GND')

# v_3_3 += psoc_u[0]['VDDD'], bypass_caps[3][1], bypass_caps[4][1], bypass_caps[5][1]
# v_3_3_a += psoc_u[0]['VDDA'], bypass_caps[6][1], bypass_caps[7][1]
# n = Net()
# n += psoc_u[0]['VCCD.*'], bypass_caps[0][1], bypass_caps[1][1]
# n = Net()
# n += psoc_u[0]['VCCA'], bypass_caps[2][1]
# psoc_u[0]['VSS.*'] = gnd

# vreg['GND'] = gnd
# v_5 += vreg['IN'], bypass_caps[8][1]
# v_5_usb += usb_pwr_jumper[1], usb_pwr_jumper_shrt[1]
# usb_pwr_jumper[1,2] = v_5_usb, v_5
# usb_pwr_jumper_shrt[1,2] = v_5_usb, v_5
# #vreg['OUT'].net = bypass_caps[9][1], v33_pwr_jumper[1], v33_pwr_jumper_shrt[1]
# v33_pwr_jumper.ref = 'V33'
# v33_pwr_jumper[1,2] = vreg['OUT'].net, v_3_3
# v33_pwr_jumper_shrt[1,2] = vreg['OUT'].net, v_3_3

# ferr_bead[1,2] = v_3_3, v_3_3_a

# v_3_3 += bypass_caps[3][1], bypass_caps[4][1], bypass_caps[5][1]
# v_3_3_a += bypass_caps[6][1], bypass_caps[7][1]

# for c in bypass_caps:
    # gnd += c[2]
