# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EncryptionConfig(Model):
    """The encryption configuration for the account.

    :param type: The type of encryption configuration being used. Currently
     the only supported types are 'UserManaged' and 'ServiceManaged'. Possible
     values include: 'UserManaged', 'ServiceManaged'
    :type type: str or :class:`EncryptionConfigType
     <azure.mgmt.datalake.store.models.EncryptionConfigType>`
    :param key_vault_meta_info: The Key vault information for connecting to
     user managed encryption keys.
    :type key_vault_meta_info: :class:`KeyVaultMetaInfo
     <azure.mgmt.datalake.store.models.KeyVaultMetaInfo>`
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'EncryptionConfigType'},
        'key_vault_meta_info': {'key': 'keyVaultMetaInfo', 'type': 'KeyVaultMetaInfo'},
    }

    def __init__(self, type, key_vault_meta_info=None):
        self.type = type
        self.key_vault_meta_info = key_vault_meta_info
