# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataLakeStoreAccountUpdateParameters(Model):
    """Data Lake Store account information to update.

    :param tags: Resource tags
    :type tags: dict
    :param firewall_state: The current state of the IP address firewall for
     this Data Lake store account. Disabling the firewall does not remove
     existing rules, they will just be ignored until the firewall is
     re-enabled. Possible values include: 'Enabled', 'Disabled'
    :type firewall_state: str or :class:`FirewallState
     <azure.mgmt.datalake.store.models.FirewallState>`
    :param trusted_id_provider_state: The current state of the trusted
     identity provider feature for this Data Lake store account. Disabling
     trusted identity provider functionality does not remove the providers,
     they will just be ignored until this feature is re-enabled. Possible
     values include: 'Enabled', 'Disabled'
    :type trusted_id_provider_state: str or :class:`TrustedIdProviderState
     <azure.mgmt.datalake.store.models.TrustedIdProviderState>`
    :param default_group: the default owner group for all new folders and
     files created in the Data Lake Store account.
    :type default_group: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'firewall_state': {'key': 'properties.firewallState', 'type': 'FirewallState'},
        'trusted_id_provider_state': {'key': 'properties.trustedIdProviderState', 'type': 'TrustedIdProviderState'},
        'default_group': {'key': 'properties.defaultGroup', 'type': 'str'},
    }

    def __init__(self, tags=None, firewall_state=None, trusted_id_provider_state=None, default_group=None):
        self.tags = tags
        self.firewall_state = firewall_state
        self.trusted_id_provider_state = trusted_id_provider_state
        self.default_group = default_group
