# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .service_resource_properties_base import ServiceResourcePropertiesBase


class ServiceResourceUpdateProperties(ServiceResourcePropertiesBase):
    """The service resource properties for patch operations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceUpdateProperties,
    StatelessServiceUpdateProperties

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the
     service with other services.
    :type correlation_scheme:
     list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array
     of ServiceLoadMetricDescription objects.
    :type service_load_metrics:
     list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation
     of the service with other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service.
     Possible values include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    :param service_kind: Required. Constant filled by server.
    :type service_kind: str
    """

    _validation = {
        'service_kind': {'required': True},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceUpdateProperties', 'Stateless': 'StatelessServiceUpdateProperties'}
    }

    def __init__(self, **kwargs):
        super(ServiceResourceUpdateProperties, self).__init__(**kwargs)
        self.service_kind = None
        self.service_kind = 'ServiceResourceUpdateProperties'
