# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PartitionSchemeDescription(Model):
    """Describes how the service is partitioned.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NamedPartitionSchemeDescription,
    SingletonPartitionSchemeDescription,
    UniformInt64RangePartitionSchemeDescription

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Constant filled by server.
    :type partition_scheme: str
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
    }

    _subtype_map = {
        'partition_scheme': {'Named': 'NamedPartitionSchemeDescription', 'Singleton': 'SingletonPartitionSchemeDescription', 'UniformInt64Range': 'UniformInt64RangePartitionSchemeDescription'}
    }

    def __init__(self, **kwargs) -> None:
        super(PartitionSchemeDescription, self).__init__(**kwargs)
        self.partition_scheme = None
