STOP_WORDS = {
  "TYPOGRAPHICAL SYMBOLS": [
    "-",
    ";",
    ":",
    "!",
    "?",
    "¿",
    ".",
    "(",
    ")",
    "[",
    "]",
    "{",
    "}",
    "§",
    "@",
    "*",
    "/",
    "&",
    "#",
    "%",
    "†",
    "^",
    "°",
    "+",
    "<",
    ">",
    "|",
    "$"
  ],
  "SINGLE LETTERS (LATIN)": [
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y",
    "z",
    "ɔ"
  ],
  "ARABIC NUMERALS (0-100)": [
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "10",
    "11",
    "12",
    "13",
    "14",
    "15",
    "16",
    "17",
    "18",
    "19",
    "20",
    "21",
    "22",
    "23",
    "24",
    "25",
    "26",
    "27",
    "28",
    "29",
    "30",
    "31",
    "32",
    "33",
    "34",
    "35",
    "36",
    "37",
    "38",
    "39",
    "40",
    "41",
    "42",
    "43",
    "44",
    "45",
    "46",
    "47",
    "48",
    "49",
    "50",
    "51",
    "52",
    "53",
    "54",
    "55",
    "56",
    "57",
    "58",
    "59",
    "60",
    "61",
    "62",
    "63",
    "64",
    "65",
    "66",
    "67",
    "68",
    "69",
    "70",
    "71",
    "72",
    "73",
    "74",
    "75",
    "76",
    "77",
    "78",
    "79",
    "80",
    "81",
    "82",
    "83",
    "84",
    "85",
    "86",
    "87",
    "88",
    "89",
    "90",
    "91",
    "92",
    "93",
    "94",
    "95",
    "96",
    "97",
    "98",
    "99",
    "100"
  ],
  "ROMAN NUMERALS (1-100 except for ambiguous 'vi')": [
    "i",
    "ii",
    "iii",
    "iiii",
    "iv",
    "v",
    "vii",
    "viii",
    "ix",
    "x",
    "xi",
    "xii",
    "xiii",
    "xiv",
    "xv",
    "xvi",
    "xvii",
    "xviii",
    "xix",
    "xx",
    "xxi",
    "xxii",
    "xxiii",
    "xxiv",
    "xxv",
    "xxvi",
    "xxvii",
    "xxviii",
    "xxix",
    "xxx",
    "xxxi",
    "xxxii",
    "xxxiii",
    "xxxiv",
    "xxxv",
    "xxxvi",
    "xxxvii",
    "xxxviii",
    "xxxix",
    "xl",
    "xli",
    "xlii",
    "xliii",
    "xliv",
    "xlv",
    "xlvi",
    "xlvii",
    "xlviii",
    "xlix",
    "l",
    "li",
    "lii",
    "liii",
    "liv",
    "lv",
    "lvi",
    "lvii",
    "lviii",
    "lix",
    "lx",
    "lxi",
    "lxii",
    "lxiii",
    "lxiv",
    "lxv",
    "lxvi",
    "lxvii",
    "lxviii",
    "lxix",
    "lxx",
    "lxxi",
    "lxxii",
    "lxxiii",
    "lxxiv",
    "lxxv",
    "lxxvi",
    "lxxvii",
    "lxxviii",
    "lxxix",
    "lxxx",
    "lxxxi",
    "lxxxii",
    "lxxxiii",
    "lxxxiv",
    "lxxxv",
    "lxxxvi",
    "lxxxvii",
    "lxxxviii",
    "lxxxix",
    "xc",
    "xci",
    "xcii",
    "xciii",
    "xciv",
    "xcv",
    "xcvi",
    "xcvii",
    "xcviii",
    "xcix",
    "c"
  ],
  "CRITICAL ABBREVIATIONS": [
    "abiud",
    "add",
    "adesp",
    "al",
    "ant",
    "antec",
    "anteced",
    "antecedent",
    "anth",
    "app",
    "arg",
    "argum",
    "argument",
    "art",
    "artic",
    "ca",
    "cap",
    "capit",
    "capitul",
    "cert",
    "cet",
    "cett",
    "cf",
    "ci",
    "cit",
    "cj",
    "cl",
    "cod",
    "codd",
    "col",
    "coll",
    "coni",
    "conj",
    "cont",
    "corp",
    "corr",
    "damn",
    "def",
    "del",
    "dett",
    "dist",
    "dist",
    "distin",
    "distinc",
    "distinct",
    "dub",
    "ead",
    "eadem",
    "ed",
    "edd",
    "eiusd",
    "ejusd",
    "em",
    "eod",
    "epist",
    "etc",
    "exp",
    "fg",
    "fgs",
    "fin",
    "fin",
    "fort",
    "fr",
    "frg",
    "gl",
    "gr",
    "ib",
    "ibid",
    "il",
    "ill",
    "indic",
    "inf",
    "inf",
    "infr",
    "init",
    "inscr",
    "interl",
    "lect",
    "lect",
    "lit",
    "litt",
    "ll",
    "loc",
    "loc",
    "marg",
    "mg",
    "ms",
    "mss",
    "mut",
    "od",
    "om",
    "pag",
    "pal",
    "pap",
    "papp",
    "penul",
    "penult",
    "pler",
    "plur",
    "pot",
    "pp",
    "pr",
    "praec",
    "praeced",
    "prob",
    "prolog",
    "prooem",
    "prop",
    "propos",
    "qq",
    "qu",
    "qu",
    "quaest",
    "quaestiunc",
    "quaestiuncul",
    "ras",
    "recc",
    "rell",
    "respons",
    "sc",
    "sc",
    "schol",
    "scholl",
    "scil",
    "secl",
    "seq",
    "seqq",
    "sim",
    "solut",
    "sq",
    "sq",
    "sqq",
    "ss",
    "subscr",
    "sup",
    "suppl",
    "susp",
    "tent",
    "text",
    "trai",
    "transp",
    "transt",
    "trib",
    "ud",
    "uers",
    "uersic",
    "uett",
    "uid",
    "uit",
    "ult",
    "ultim",
    "uu",
    "uu",
    "uulg",
    "vd",
    "vers",
    "versic",
    "vett",
    "vid",
    "vit",
    "vulg",
    "vv",
    "vv",
    "γρ"
  ],
  "ABBREVIATED PRAENOMINA": [
    "agr",
    "ap",
    "cn",
    "mam",
    "oct",
    "opet",
    "pro",
    "ser",
    "sert",
    "sex",
    "st",
    "ti",
    "uol",
    "uop",
    "vol",
    "vop"
  ],
  "CONJUNCTIONS": [
    "ac",
    "an",
    "antequam",
    "at",
    "atque",
    "aut",
    "autem",
    "donec",
    "dum",
    "enim",
    "ergo",
    "et",
    "etenim",
    "etiam",
    "etiamsi",
    "etsi",
    "igitur",
    "itaque",
    "licet",
    "nam",
    "namque",
    "ne",
    "nec",
    "necque",
    "neque",
    "ni",
    "nisi",
    "postquam",
    "proinde",
    "quamobrem",
    "quamquam",
    "quanquam",
    "quare",
    "que",
    "quia",
    "quomodo",
    "quoniam",
    "quoque",
    "sed",
    "seu",
    "si",
    "sin",
    "siue",
    "sive",
    "tamen",
    "tametsi",
    "ue",
    "uel",
    "ut",
    "utcunque",
    "uterque",
    "uti",
    "utlibet",
    "utne",
    "utque",
    "utraque",
    "utrum",
    "utrumque",
    "utue",
    "utve",
    "ve",
    "vel"
  ],
  "PREPOSITIONS": [
    "a",
    "ab",
    "abs",
    "ad",
    "aduersum",
    "aduersus",
    "adversum",
    "adversus",
    "ante",
    "apud",
    "circa",
    "circum",
    "contra",
    "coram",
    "cum",
    "de",
    "e",
    "erga",
    "ex",
    "extra",
    "in",
    "infra",
    "inter",
    "intra",
    "ob",
    "penes",
    "per",
    "post",
    "prae",
    "praeter",
    "pro",
    "prope",
    "propter",
    "secundum",
    "sine",
    "sub",
    "subter",
    "super",
    "supra",
    "tenus",
    "trans",
    "ultra"
  ],
  "ADVERBS": [
    "adeo",
    "adhuc",
    "aliquando",
    "aliter",
    "antea",
    "certe",
    "ceterum",
    "cur",
    "dein",
    "deinde",
    "demum",
    "denique",
    "diu",
    "ecce",
    "equidem",
    "fere",
    "forsitan",
    "fortasse",
    "forte",
    "frustra",
    "hactenus",
    "haud",
    "hinc",
    "hodie",
    "huc",
    "iam",
    "iamque",
    "ibi",
    "ideo",
    "illic",
    "immo",
    "inde",
    "interdum",
    "interim",
    "ita",
    "item",
    "iterum",
    "iuxta",
    "jam",
    "jamque",
    "juxta",
    "magis",
    "minime",
    "minus",
    "minusne",
    "minusque",
    "minusue",
    "minusve",
    "modo",
    "mox",
    "nihilo",
    "nimirum",
    "nimis",
    "non",
    "nondum",
    "nonne",
    "num",
    "numquam",
    "nunc",
    "olim",
    "omnino",
    "paene",
    "pariter",
    "plane",
    "plerumque",
    "plus",
    "plusne",
    "plusque",
    "plusue",
    "plusve",
    "postea",
    "potius",
    "praesertim",
    "praeterea",
    "primum",
    "prius",
    "priusquam",
    "procul",
    "profecto",
    "protinus",
    "qualibet",
    "quam",
    "quando",
    "quasi",
    "quatenus",
    "quemadmodum",
    "quidem",
    "quin",
    "quippe",
    "quodam",
    "quodammodo",
    "quolibet",
    "quondam",
    "quot",
    "quotiens",
    "repente",
    "rursum",
    "rursus",
    "saepe",
    "sane",
    "sat",
    "satis",
    "scilicet",
    "semel",
    "semper",
    "sic",
    "sicut",
    "sicuti",
    "simul",
    "solum",
    "sponte",
    "statim",
    "tam",
    "tamquam",
    "tandem",
    "tantum",
    "tantummodo",
    "tot",
    "totiens",
    "tum",
    "tunc",
    "ubi",
    "uelut",
    "uero",
    "uidelicet",
    "uix",
    "ultro",
    "umquam",
    "unde",
    "undique",
    "usque",
    "utique",
    "velut",
    "vero",
    "videlicet",
    "vix"
  ],
  "PRONOUNS": {
    "ego": [
      "ego",
      "egon",
      "egone",
      "egoque",
      "me",
      "mecum",
      "mecumque",
      "mecumst",
      "med",
      "medem",
      "mei",
      "mein",
      "meique",
      "meme",
      "memet",
      "men",
      "mene",
      "meque",
      "mest",
      "mi",
      "mihi",
      "mihin",
      "mihine",
      "mihique",
      "mihist",
      "min",
      "mine",
      "mist"
    ],
    "meus": [
      "mea",
      "meae",
      "meaeque",
      "meai",
      "meam",
      "meamne",
      "meamque",
      "mean",
      "meane",
      "meaque",
      "mearum",
      "mearumque",
      "meas",
      "measque",
      "meast",
      "mee",
      "mei",
      "mein",
      "meique",
      "meis",
      "meisque",
      "meo",
      "meon",
      "meone",
      "meoque",
      "meost",
      "meum",
      "meumque",
      "meumst",
      "meumve",
      "meus",
      "meusque",
      "meust",
      "mi",
      "min",
      "mine",
      "mist"
    ],
    "tu": [
      "te",
      "tecum",
      "tecumque",
      "ted",
      "temet",
      "ten",
      "tenve",
      "tenveque",
      "tenvis",
      "teque",
      "test",
      "teve",
      "tibi",
      "tibimet",
      "tibin",
      "tibique",
      "tibist",
      "tu",
      "tui",
      "tuin",
      "tuine",
      "tuique",
      "tun",
      "tune",
      "tuque",
      "tute",
      "tutemet"
    ],
    "tuus": [
      "tua",
      "tuae",
      "tuaen",
      "tuaeque",
      "tuaest",
      "tuaique",
      "tuam",
      "tuamne",
      "tuamque",
      "tuamst",
      "tuamve",
      "tuan",
      "tuane",
      "tuaque",
      "tuarum",
      "tuarumque",
      "tuas",
      "tuasne",
      "tuasque",
      "tuast",
      "tuasue",
      "tue",
      "tuest",
      "tui",
      "tuin",
      "tuine",
      "tuique",
      "tuis",
      "tuisne",
      "tuisque",
      "tuo",
      "tuom",
      "tuomque",
      "tuomst",
      "tuon",
      "tuoque",
      "tuorum",
      "tuorumque",
      "tuos",
      "tuosne",
      "tuosque",
      "tuost",
      "tuosve",
      "tuum",
      "tuumne",
      "tuumque",
      "tuus",
      "tuusque",
      "tuusue"
    ],
    "hic": [
      "hac",
      "hacne",
      "hae",
      "haec",
      "haecine",
      "haecinest",
      "haecne",
      "haeque",
      "haeve",
      "han",
      "hanc",
      "hancine",
      "hancne",
      "hancque",
      "hann",
      "harum",
      "harumque",
      "has",
      "hasce",
      "hascine",
      "hasne",
      "hasque",
      "hi",
      "hic",
      "hicine",
      "hicinest",
      "hicne",
      "hin",
      "hine",
      "hinn",
      "hique",
      "his",
      "hisce",
      "hisdem",
      "hisne",
      "hisque",
      "hoc",
      "hocin",
      "hocine",
      "hocinest",
      "hocne",
      "hocque",
      "hon",
      "horum",
      "horumque",
      "horunc",
      "hos",
      "hosce",
      "hosne",
      "hosque",
      "host",
      "huic",
      "huius",
      "huiusce",
      "huiusne",
      "huiusque",
      "huiusve",
      "hujus",
      "hujusce",
      "hujusne",
      "hujusque",
      "hujusve",
      "hum",
      "hunc",
      "huncne"
    ],
    "ille": [
      "illa",
      "illae",
      "illaeque",
      "illam",
      "illamne",
      "illan",
      "illane",
      "illaque",
      "illarum",
      "illas",
      "illasque",
      "illast",
      "illave",
      "ille",
      "illene",
      "illest",
      "illi",
      "illique",
      "illis",
      "illisque",
      "illist",
      "illisue",
      "illiue",
      "illius",
      "illiusque",
      "illiust",
      "illo",
      "illoque",
      "illorum",
      "illos",
      "illosque",
      "illost",
      "illud",
      "illudne",
      "illudque",
      "illum",
      "illumne",
      "illumque",
      "illumst",
      "illumve",
      "olla",
      "ollae",
      "ollam",
      "ollarum",
      "ollas",
      "olle",
      "olli",
      "ollique",
      "ollis",
      "ollisque",
      "ollius",
      "ollo",
      "ollos",
      "ollosque"
    ],
    "iste": [
      "ista",
      "istae",
      "istaec",
      "istam",
      "istamque",
      "istanc",
      "istane",
      "istaque",
      "istarum",
      "istas",
      "istast",
      "iste",
      "istest",
      "isti",
      "istimet",
      "istique",
      "istis",
      "istisne",
      "istisve",
      "istius",
      "isto",
      "iston",
      "istorum",
      "istos",
      "istuc",
      "istud",
      "istum",
      "istumne",
      "istunc"
    ],
    "ipse": [
      "ipsa",
      "ipsae",
      "ipsaeque",
      "ipsam",
      "ipsamque",
      "ipsane",
      "ipsaque",
      "ipsarum",
      "ipsarumque",
      "ipsas",
      "ipsasque",
      "ipsast",
      "ipse",
      "ipsemet",
      "ipsene",
      "ipseque",
      "ipsest",
      "ipsi",
      "ipsimet",
      "ipsine",
      "ipsique",
      "ipsis",
      "ipsisne",
      "ipsisque",
      "ipsist",
      "ipsius",
      "ipsiusque",
      "ipso",
      "ipson",
      "ipsoque",
      "ipsorum",
      "ipsorumque",
      "ipsos",
      "ipsosne",
      "ipsosque",
      "ipsost",
      "ipsum",
      "ipsumne",
      "ipsumque",
      "ipsus",
      "ipsusne",
      "ipsusque",
      "ipsust"
    ],
    "is": [
      "ea",
      "eae",
      "eaeque",
      "eam",
      "eamdem",
      "eamne",
      "eamque",
      "eamue",
      "ean",
      "eane",
      "eanest",
      "eaque",
      "earum",
      "earumne",
      "earumque",
      "earumue",
      "earumve",
      "eas",
      "easque",
      "east",
      "easue",
      "eaue",
      "eave",
      "ei",
      "ein",
      "eine",
      "eique",
      "eis",
      "eisne",
      "eisque",
      "eiue",
      "eius",
      "eiusque",
      "eiust",
      "eiusue",
      "eive",
      "ejus",
      "ejusque",
      "ejust",
      "ejusue",
      "eo",
      "eoque",
      "eorum",
      "eorumdem",
      "eorumne",
      "eorumque",
      "eorumue",
      "eorumve",
      "eos",
      "eosne",
      "eosque",
      "eost",
      "eosue",
      "eoue",
      "eum",
      "eumdem",
      "eumne",
      "eumque",
      "eumue",
      "eumve",
      "id",
      "idne",
      "idnest",
      "idque",
      "idue",
      "ii",
      "iidem",
      "iidemque",
      "iique",
      "iis",
      "iisne",
      "iisque",
      "iisue",
      "is",
      "isne",
      "isque"
    ],
    "idem": [
      "eadem",
      "eademne",
      "eademque",
      "eademst",
      "eademve",
      "eaedem",
      "eaedemque",
      "eandem",
      "eandemque",
      "earumdem",
      "easdem",
      "easdemne",
      "easdemque",
      "eidem",
      "eidemque",
      "eisdem",
      "eisdemque",
      "eiusdem",
      "eiusdemque",
      "ejusdem",
      "ejusdemque",
      "eodem",
      "eodemque",
      "eorundem",
      "eosdem",
      "eosdemne",
      "eosdemque",
      "eundem",
      "eundemne",
      "eundemque",
      "idem",
      "idemne",
      "idemque",
      "idemst",
      "iisdem",
      "iisdemque",
      "isdem",
      "isdemne",
      "isdemque"
    ],
    "suus": [
      "sua",
      "suae",
      "suaeque",
      "suai",
      "suam",
      "suamne",
      "suamque",
      "suane",
      "suaque",
      "suarum",
      "suarumque",
      "suas",
      "suasque",
      "suaue",
      "sue",
      "sui",
      "suique",
      "suis",
      "suisne",
      "suisque",
      "suist",
      "suo",
      "suom",
      "suone",
      "suoque",
      "suorum",
      "suorumque",
      "suorumue",
      "suos",
      "suosque",
      "suum",
      "suumque",
      "suus",
      "suusque"
    ],
    "sui": [
      "se",
      "secum",
      "secumque",
      "secumue",
      "secumve",
      "semet",
      "sen",
      "sese",
      "sest",
      "sibi",
      "sibimet",
      "sibine",
      "sibique",
      "sui",
      "suimet",
      "suique",
      "suist"
    ],
    "nos": [
      "nobis",
      "nobiscum",
      "nobiscumque",
      "nobismet",
      "nobisne",
      "nobisque",
      "nos",
      "nosmet",
      "nosne",
      "nosque",
      "nost",
      "nostri",
      "nostrique",
      "nostrive",
      "nostrum",
      "nostrumne",
      "nostrumque"
    ],
    "noster": [
      "noster",
      "nosterque",
      "nostra",
      "nostrae",
      "nostraeque",
      "nostrai",
      "nostram",
      "nostramne",
      "nostramque",
      "nostrane",
      "nostraque",
      "nostrarum",
      "nostrarumque",
      "nostras",
      "nostrasne",
      "nostrasque",
      "nostrast",
      "nostri",
      "nostrique",
      "nostris",
      "nostrisque",
      "nostrisve",
      "nostrive",
      "nostro",
      "nostrone",
      "nostroque",
      "nostrorum",
      "nostrorumque",
      "nostrorumst",
      "nostros",
      "nostrosque",
      "nostrost",
      "nostrum",
      "nostrumne",
      "nostrumque"
    ],
    "vos": [
      "uestri",
      "uestrique",
      "uobis",
      "uobiscum",
      "uobismet",
      "uobisne",
      "uobisque",
      "uon",
      "uos",
      "uosmet",
      "uosne",
      "uosque",
      "uostrum",
      "uostrumque",
      "uostrumst",
      "vestri",
      "vestrique",
      "vobis",
      "vobiscum",
      "vobismet",
      "vobisne",
      "vobisque",
      "von",
      "vos",
      "vosmet",
      "vosne",
      "vosque",
      "vostrum",
      "vostrumque",
      "vostrumst"
    ],
    "vester": [
      "uester",
      "uesterque",
      "uestra",
      "uestrae",
      "uestraene",
      "uestraeque",
      "uestram",
      "uestramne",
      "uestramque",
      "uestrane",
      "uestraque",
      "uestrarum",
      "uestras",
      "uestrasque",
      "uestri",
      "uestrique",
      "uestris",
      "uestrisne",
      "uestrisque",
      "uestrius",
      "uestro",
      "uestrone",
      "uestroque",
      "uestrorum",
      "uestrorumque",
      "uestros",
      "uestrosque",
      "uestrum",
      "uestrumque",
      "uestrumst",
      "uoster",
      "uostra",
      "uostrae",
      "uostraeque",
      "uostram",
      "uostraque",
      "uostrarum",
      "uostras",
      "uostrast",
      "uostri",
      "uostris",
      "uostrist",
      "uostro",
      "uostrorum",
      "uostros",
      "uostrosque",
      "uostrost",
      "uostrum",
      "uostrumque",
      "uostrumst",
      "vester",
      "vesterque",
      "vestra",
      "vestrae",
      "vestraene",
      "vestraeque",
      "vestram",
      "vestramne",
      "vestramque",
      "vestrane",
      "vestraque",
      "vestrarum",
      "vestras",
      "vestrasque",
      "vestri",
      "vestrique",
      "vestris",
      "vestrisne",
      "vestrisque",
      "vestrius",
      "vestro",
      "vestrone",
      "vestroque",
      "vestrorum",
      "vestrorumque",
      "vestros",
      "vestrosque",
      "vestrum",
      "vestrumque",
      "vestrumst",
      "voster",
      "vostra",
      "vostrae",
      "vostraeque",
      "vostram",
      "vostraque",
      "vostrarum",
      "vostras",
      "vostrast",
      "vostri",
      "vostris",
      "vostrist",
      "vostro",
      "vostrorum",
      "vostros",
      "vostrosque",
      "vostrost",
      "vostrum",
      "vostrumque",
      "vostrumst"
    ],
    "qui": [
      "cui",
      "cuilibet",
      "cuine",
      "cuipiam",
      "cuiue",
      "cuius",
      "cuiuslibet",
      "cuiuspiam",
      "cuiust",
      "cuiusue",
      "cuiusve",
      "cuive",
      "cujus",
      "cujuslibet",
      "cujuspiam",
      "cujust",
      "cujusue",
      "cujusve",
      "qua",
      "quae",
      "quaedem",
      "quaelibet",
      "quaen",
      "quaene",
      "quaepiam",
      "quaepiamst",
      "quaest",
      "quaestuis",
      "quaestuist",
      "quaeue",
      "quaeve",
      "quam",
      "quamne",
      "quampiam",
      "quamue",
      "quamve",
      "quan",
      "quapiam",
      "quarum",
      "quarumlibet",
      "quas",
      "quaslibet",
      "quast",
      "quasue",
      "quasve",
      "quaue",
      "quave",
      "quei",
      "quein",
      "queique",
      "quem",
      "quemlibet",
      "quemne",
      "quempiam",
      "quemue",
      "quemve",
      "qui",
      "quibus",
      "quibuscum",
      "quibuslibet",
      "quibusue",
      "quibusve",
      "quicum",
      "quicumuis",
      "quicumvis",
      "quilibet",
      "quiue",
      "quive",
      "quod",
      "quodlibet",
      "quodne",
      "quodpiam",
      "quodue",
      "quodve",
      "quoi",
      "quoicumque",
      "quoin",
      "quoique",
      "quoiuis",
      "quoivis",
      "quon",
      "quorum",
      "quorumlibet",
      "quorumst",
      "quos",
      "quoslibet",
      "quosne",
      "quospiam",
      "quost",
      "quosue",
      "quosve",
      "quum"
    ],
    "quis": [
      "quid",
      "quidlibet",
      "quidne",
      "quidni",
      "quidpiam",
      "quidue",
      "quidve",
      "quis",
      "quiscumque",
      "quisue",
      "quisve",
      "quo",
      "quon",
      "quone",
      "quost",
      "quoue",
      "quove"
    ],
    "quisquam": [
      "cuiquam",
      "cuiquamst",
      "cuiusquam",
      "cujusquam",
      "quamquam",
      "quamquamst",
      "quaquam",
      "quaquamst",
      "quemquam",
      "quemquamne",
      "quemquamst",
      "quicquam",
      "quicquamne",
      "quicquamst",
      "quidquam",
      "quiquam",
      "quisquam",
      "quisquamne",
      "quisquamst",
      "quoquam"
    ],
    "quisnam": [
      "cuinam",
      "cuiusnam",
      "cujusnam",
      "quaenam",
      "quaenamst",
      "quamnam",
      "quanam",
      "quarumnam",
      "quasnam",
      "quemnam",
      "quibusnam",
      "quidnam",
      "quidnamst",
      "quinam",
      "quisnam",
      "quodnam",
      "quosnam"
    ],
    "quisquis": [
      "quaqua",
      "quemquem",
      "quicquid",
      "quidquid",
      "quiqui",
      "quiquidem",
      "quisquis",
      "quoquo"
    ],
    "quisque": [
      "cuique",
      "cuiquest",
      "cuiusque",
      "cujusque",
      "quaeque",
      "quamque",
      "quaque",
      "quarumque",
      "quasque",
      "quemque",
      "quibusque",
      "quicque",
      "quidque",
      "quique",
      "quisque",
      "quodque",
      "quorumque",
      "quosque"
    ],
    "quicumque": [
      "cuicumque",
      "cuicunque",
      "cuiuscumque",
      "cuiuscunque",
      "cujuscumque",
      "cujuscunque",
      "quacumque",
      "quacunque",
      "quaecumque",
      "quaecunque",
      "quamcumque",
      "quamcunque",
      "quarumcumque",
      "quascumque",
      "quascunque",
      "quemcumque",
      "quemcunque",
      "quibuscumque",
      "quibuscunque",
      "quicumque",
      "quicumquest",
      "quicunque",
      "quocumque",
      "quodcumque",
      "quodcunque",
      "quorumcumque",
      "quoscumque",
      "quoscunque"
    ],
    "quivis": [
      "cuiuis",
      "cuiusuis",
      "cuiusvis",
      "cuivis",
      "cujusuis",
      "cujusvis",
      "quaeuis",
      "quaevis",
      "quamuis",
      "quamvis",
      "quarumuis",
      "quarumvis",
      "quasuis",
      "quasvis",
      "quauis",
      "quavis",
      "quemuis",
      "quemvis",
      "quibusuis",
      "quibusvis",
      "quiduis",
      "quidvis",
      "quiuis",
      "quivis",
      "quoduis",
      "quodvis",
      "quosuis",
      "quosvis"
    ],
    "quidam": [
      "cuidam",
      "cuiusdam",
      "cujusdam",
      "quadam",
      "quaedam",
      "quaedamque",
      "quaedamst",
      "quamdam",
      "quandam",
      "quandamque",
      "quarumdam",
      "quasdam",
      "quasdamque",
      "quemdam",
      "quendam",
      "quibusdam",
      "quidam",
      "quidamque",
      "quidamst",
      "quiddam",
      "quiddamst",
      "quoddam",
      "quorumdam",
      "quosdam",
      "quosdamque",
      "quosdamve"
    ],
    "aliqui": [
      "alicui",
      "alicuius",
      "alicujus",
      "aliqua",
      "aliquae",
      "aliqualibet",
      "aliquam",
      "aliquan",
      "aliquane",
      "aliquarum",
      "aliquas",
      "aliquast",
      "aliquaue",
      "alique",
      "aliquem",
      "aliquemque",
      "aliqui",
      "aliquibus",
      "aliquis",
      "aliquisne",
      "aliquisque",
      "aliquit",
      "aliquod",
      "aliquodue",
      "aliquorum",
      "aliquos"
    ],
    "aliquis": [
      "aliquid",
      "aliquidque",
      "aliquidue",
      "aliquis",
      "aliquisne",
      "aliquisque",
      "aliquo"
    ]
  },
  "NOUNS": {
    "res": [
      "re",
      "rebus",
      "rebusque",
      "rei",
      "reique",
      "reist",
      "rem",
      "remque",
      "remst",
      "remve",
      "reque",
      "rerum",
      "rerumne",
      "rerumque",
      "res",
      "resne",
      "resque",
      "rest",
      "resve"
    ],
    "nihil": [
      "nihil",
      "nihilne",
      "nihilque",
      "nil",
      "nilne",
      "nilque"
    ],
    "causa (ablative in prepositional turn)": [
      "causa"
    ],
    "nemo": [
      "nemine",
      "neminem",
      "neminemne",
      "nemini",
      "neminis",
      "neminisque",
      "nemo",
      "nemon",
      "nemone",
      "nemoque",
      "nemost"
    ]
  },
  "ADJECTIVES": {
    "omnis": [
      "omne",
      "omnem",
      "omnemque",
      "omnene",
      "omneque",
      "omnes",
      "omnesne",
      "omnesque",
      "omnest",
      "omni",
      "omnia",
      "omnian",
      "omniane",
      "omniaque",
      "omnibus",
      "omnibusne",
      "omnibusque",
      "omnibust",
      "omnibusue",
      "omnin",
      "omnique",
      "omnis",
      "omnisne",
      "omnisque",
      "omnist",
      "omnium",
      "omniumque",
      "omniumst"
    ],
    "nullus": [
      "nulla",
      "nullae",
      "nullaene",
      "nullaeque",
      "nullam",
      "nullamne",
      "nullamque",
      "nullan",
      "nullane",
      "nullaque",
      "nullarum",
      "nullas",
      "nullasne",
      "nullasque",
      "nullast",
      "nullave",
      "nulli",
      "nulline",
      "nullique",
      "nullis",
      "nullisne",
      "nullisque",
      "nullius",
      "nulliusque",
      "nullo",
      "nullon",
      "nullone",
      "nulloque",
      "nullorum",
      "nullorumque",
      "nullos",
      "nullosne",
      "nullosque",
      "nullum",
      "nullumne",
      "nullumque",
      "nullumst",
      "nullus",
      "nullusne",
      "nullusnest",
      "nullusque",
      "nullust"
    ],
    "ullus": [
      "ulla",
      "ullae",
      "ullam",
      "ullamve",
      "ullane",
      "ullarum",
      "ullas",
      "ullast",
      "ullave",
      "ulli",
      "ulline",
      "ullis",
      "ullius",
      "ullo",
      "ullorum",
      "ullos",
      "ullum",
      "ullumve",
      "ullus",
      "ullusne",
      "ullust"
    ],
    "multus": [
      "multa",
      "multae",
      "multaeque",
      "multaeve",
      "multam",
      "multamque",
      "multane",
      "multaque",
      "multarum",
      "multarumque",
      "multas",
      "multasque",
      "multi",
      "multique",
      "multis",
      "multisne",
      "multisque",
      "multisve",
      "multo",
      "multoque",
      "multorum",
      "multorumque",
      "multos",
      "multosque",
      "multost",
      "multosve",
      "multum",
      "multumque",
      "multumst",
      "multus",
      "multusque"
    ],
    "plus/plures": [
      "plura",
      "pluraque",
      "pluraue",
      "plurave",
      "plure",
      "plures",
      "pluresne",
      "pluresque",
      "pluresue",
      "pluresve",
      "pluribus",
      "pluribusne",
      "pluribusque",
      "pluribusue",
      "pluribusve",
      "plurima",
      "plurimae",
      "plurimaeque",
      "plurimam",
      "plurimaque",
      "plurimarum",
      "plurimas",
      "plurimasque",
      "plurime",
      "plurimi",
      "plurimique",
      "plurimis",
      "plurimisque",
      "plurimo",
      "plurimoque",
      "plurimorum",
      "plurimos",
      "plurimosque",
      "plurimum",
      "plurimumque",
      "plurimumst",
      "plurimus",
      "plurimusque",
      "pluris",
      "plurisne",
      "plurisque",
      "plurisue",
      "plurium",
      "pluriumue",
      "pluriumve",
      "plus",
      "plusne",
      "plusque",
      "plusve"
    ],
    "alius": [
      "alia",
      "aliae",
      "aliaeque",
      "aliaest",
      "aliaeue",
      "aliaeve",
      "aliam",
      "aliamne",
      "aliamque",
      "aliamue",
      "aliamve",
      "alian",
      "aliaque",
      "aliarum",
      "aliarumque",
      "aliarumue",
      "alias",
      "aliasque",
      "aliast",
      "aliaue",
      "aliave",
      "alii",
      "aliique",
      "aliis",
      "aliisne",
      "aliisque",
      "aliisue",
      "aliisve",
      "aliiue",
      "alio",
      "alione",
      "alioque",
      "aliorum",
      "aliorumque",
      "aliorumue",
      "aliorumve",
      "alios",
      "aliosque",
      "aliost",
      "aliosve",
      "alioue",
      "aliove",
      "aliud",
      "aliudque",
      "aliudue",
      "aliudve",
      "alium",
      "aliumque",
      "aliumue",
      "aliumve",
      "alius",
      "aliusne",
      "aliusque",
      "aliusue",
      "aliusve"
    ],
    "alter": [
      "alter",
      "altera",
      "alterae",
      "alteram",
      "alteramque",
      "alteramue",
      "alteraque",
      "alterarum",
      "alteras",
      "alterast",
      "alterave",
      "alteri",
      "alteris",
      "alterius",
      "alteriusque",
      "alteriusue",
      "alterive",
      "altero",
      "alteroque",
      "alterorum",
      "alteros",
      "alteroue",
      "alterove",
      "alterque",
      "alterue",
      "alterum",
      "alterumque",
      "alterumue",
      "alterumve",
      "alterve"
    ],
    "ceter/ceterus": [
      "caetera",
      "caeterae",
      "caeteram",
      "caeteras",
      "caeteri",
      "caeteris",
      "caeterisque",
      "caeteros",
      "caeterus",
      "cetera",
      "ceterae",
      "ceteraeque",
      "ceteraeve",
      "ceteram",
      "ceteramque",
      "ceteraque",
      "ceterarum",
      "ceterarumque",
      "ceteras",
      "ceterasque",
      "ceteri",
      "ceterique",
      "ceteris",
      "ceterisque",
      "ceterisue",
      "ceterive",
      "cetero",
      "ceteroque",
      "ceterorum",
      "ceterorumque",
      "ceterorumue",
      "ceteros",
      "ceterosque",
      "ceterum",
      "ceterus"
    ],
    "qualis": [
      "quale",
      "qualecumque",
      "qualecunque",
      "qualem",
      "qualemcunque",
      "qualemque",
      "qualemve",
      "quales",
      "qualescumque",
      "qualescunque",
      "qualeslibet",
      "qualesque",
      "qualest",
      "qualesve",
      "quali",
      "qualia",
      "qualiacunque",
      "qualiaque",
      "qualibus",
      "qualicumque",
      "qualicunque",
      "qualine",
      "qualique",
      "qualis",
      "qualiscunque",
      "qualislibet",
      "qualisque",
      "qualisve",
      "qualiter",
      "qualitercumque",
      "qualitercunque",
      "qualiterque",
      "qualium",
      "qualiumcumque"
    ],
    "talis": [
      "tale",
      "talem",
      "talemque",
      "taleque",
      "tales",
      "talesne",
      "talesque",
      "talest",
      "tali",
      "talia",
      "taliane",
      "taliaque",
      "talibus",
      "talibusque",
      "talin",
      "taline",
      "talique",
      "talis",
      "talisque",
      "talisve",
      "taliter",
      "talium",
      "taliumque"
    ],
    "quantus": [
      "quanta",
      "quantacumque",
      "quantacunque",
      "quantae",
      "quantaecumque",
      "quantaelibet",
      "quantaeque",
      "quantaeuis",
      "quantalibet",
      "quantam",
      "quantamcumque",
      "quantamque",
      "quantane",
      "quantaque",
      "quantarum",
      "quantas",
      "quantaslibet",
      "quantasque",
      "quantasuis",
      "quantasve",
      "quantasvis",
      "quantauis",
      "quantave",
      "quantavis",
      "quanti",
      "quanticumque",
      "quantilibet",
      "quantine",
      "quantique",
      "quantis",
      "quantiscumque",
      "quantislibet",
      "quantisque",
      "quantist",
      "quantiuis",
      "quantivis",
      "quanto",
      "quantocumque",
      "quantolibet",
      "quantoque",
      "quantorum",
      "quantos",
      "quantosne",
      "quantosque",
      "quantoue",
      "quantouis",
      "quantove",
      "quantovis",
      "quantum",
      "quantumcumque",
      "quantumlibet",
      "quantumque",
      "quantumst",
      "quantumue",
      "quantumuis",
      "quantumvis",
      "quantus",
      "quantuscumque",
      "quantusne",
      "quantusque"
    ],
    "tantus": [
      "tanta",
      "tantadem",
      "tantae",
      "tantaene",
      "tantaeque",
      "tantam",
      "tantamne",
      "tantamque",
      "tantan",
      "tantandem",
      "tantane",
      "tantaque",
      "tantarum",
      "tantarumque",
      "tantas",
      "tantasque",
      "tantast",
      "tante",
      "tanti",
      "tantidem",
      "tantidemst",
      "tantine",
      "tantique",
      "tantis",
      "tantisque",
      "tantist",
      "tanto",
      "tanton",
      "tantone",
      "tantoque",
      "tantorum",
      "tantorumque",
      "tantos",
      "tantosque",
      "tantove",
      "tantum",
      "tantumdem",
      "tantumdemst",
      "tantumne",
      "tantumque",
      "tantumst",
      "tantundem",
      "tantundemque",
      "tantundemst",
      "tantus",
      "tantusque"
    ]
  },
  "VERBS": {
    "sum": [
      "eram",
      "eramque",
      "eramus",
      "erant",
      "erantque",
      "eras",
      "erat",
      "eratis",
      "eratne",
      "eratque",
      "erimus",
      "erimusque",
      "erin",
      "eris",
      "erisque",
      "erit",
      "eritis",
      "eritisque",
      "eritne",
      "eritque",
      "eritue",
      "ero",
      "eroque",
      "erunt",
      "eruntque",
      "eruntue",
      "eruntve",
      "es",
      "esne",
      "esque",
      "esse",
      "essem",
      "essemque",
      "essemus",
      "essemusne",
      "essemusque",
      "essemusve",
      "essene",
      "essent",
      "essentne",
      "essentque",
      "essentve",
      "esseque",
      "esses",
      "essesne",
      "essesque",
      "essesve",
      "esset",
      "essetis",
      "essetisne",
      "essetisque",
      "essetisve",
      "essetne",
      "essetque",
      "essetve",
      "esseve",
      "est",
      "este",
      "estene",
      "esteque",
      "esteve",
      "estis",
      "estisne",
      "estisque",
      "estisve",
      "estne",
      "esto",
      "eston",
      "estote",
      "estque",
      "estve",
      "esve",
      "fore",
      "forem",
      "forent",
      "fores",
      "foresque",
      "foret",
      "fuam",
      "fuant",
      "fuas",
      "fuat",
      "fueram",
      "fueramque",
      "fueramus",
      "fuerant",
      "fueras",
      "fuerat",
      "fueratis",
      "fueratque",
      "fuere",
      "fuerim",
      "fuerimque",
      "fuerimus",
      "fuerint",
      "fuerintne",
      "fuerintque",
      "fueris",
      "fuerisne",
      "fuerit",
      "fueritis",
      "fueritne",
      "fueritque",
      "fueritue",
      "fueritve",
      "fuero",
      "fuerunt",
      "fueruntne",
      "fueruntque",
      "fui",
      "fuimus",
      "fuimusque",
      "fuimusve",
      "fuisse",
      "fuissem",
      "fuissemus",
      "fuissent",
      "fuisseque",
      "fuisses",
      "fuisset",
      "fuissetis",
      "fuissetque",
      "fuisti",
      "fuistin",
      "fuistique",
      "fuistis",
      "fuistisne",
      "fuit",
      "fuitne",
      "fuitque",
      "futura",
      "futurae",
      "futuraeque",
      "futuram",
      "futuramque",
      "futuraque",
      "futurarum",
      "futuras",
      "futurast",
      "futurave",
      "future",
      "futuri",
      "futurique",
      "futuris",
      "futurisque",
      "futuro",
      "futurorum",
      "futurorumque",
      "futuros",
      "futurosque",
      "futurove",
      "futurum",
      "futurumque",
      "futurumst",
      "futurumve",
      "futurus",
      "futurusne",
      "futurusque",
      "futurusve",
      "siem",
      "sient",
      "sies",
      "siet",
      "sim",
      "simne",
      "simque",
      "simus",
      "sint",
      "sintne",
      "sintque",
      "sis",
      "sisne",
      "sisque",
      "sist",
      "sit",
      "sitis",
      "sitisque",
      "sitne",
      "sitque",
      "sitve",
      "sum",
      "sumne",
      "sumque",
      "sumus",
      "sumusque",
      "sumusve",
      "sunt",
      "suntne",
      "sunto",
      "suntoque",
      "suntque"
    ],
    "possum": [
      "posse",
      "possem",
      "possemne",
      "possemque",
      "possemus",
      "possent",
      "possentne",
      "posseque",
      "posses",
      "possesne",
      "posset",
      "possetis",
      "possetisne",
      "possetne",
      "possetque",
      "possim",
      "possimne",
      "possimus",
      "possimusne",
      "possin",
      "possint",
      "possintne",
      "possintque",
      "possis",
      "possisne",
      "possisque",
      "possit",
      "possitis",
      "possitne",
      "possitque",
      "possum",
      "possumne",
      "possumus",
      "possumusne",
      "possunt",
      "possuntne",
      "possuntque",
      "potens",
      "potensque",
      "potentem",
      "potentemque",
      "potentes",
      "potentesque",
      "potenti",
      "potentia",
      "potentibus",
      "potentis",
      "potentisque",
      "potentium",
      "poteram",
      "poteramus",
      "poteramusne",
      "poterant",
      "poterantque",
      "poteras",
      "poterat",
      "poteratis",
      "poteratne",
      "poteratque",
      "poterimus",
      "poterin",
      "poteris",
      "poterisne",
      "poterisque",
      "poterit",
      "poteritis",
      "poteritisne",
      "poteritne",
      "poteritque",
      "potero",
      "poteron",
      "poterone",
      "poterunt",
      "poteruntque",
      "potes",
      "potesne",
      "potesque",
      "potest",
      "potestis",
      "potestisne",
      "potestne",
      "potestque",
      "potueram",
      "potueramus",
      "potuerant",
      "potueras",
      "potuerat",
      "potueratis",
      "potuere",
      "potuerim",
      "potuerimus",
      "potuerint",
      "potueris",
      "potuerit",
      "potueritis",
      "potueritne",
      "potueritque",
      "potuero",
      "potuerunt",
      "potueruntne",
      "potueruntque",
      "potui",
      "potuimus",
      "potuine",
      "potuique",
      "potuisse",
      "potuissem",
      "potuissemus",
      "potuissent",
      "potuisses",
      "potuisset",
      "potuissetis",
      "potuisti",
      "potuistine",
      "potuistis",
      "potuit",
      "potuitne",
      "potuitque",
      "potuitue"
    ],
    "do": [
      "da",
      "dabam",
      "dabamus",
      "dabant",
      "dabantque",
      "dabantur",
      "dabanturque",
      "dabar",
      "dabas",
      "dabat",
      "dabatque",
      "dabatur",
      "dabaturque",
      "daberis",
      "dabimus",
      "dabimusque",
      "dabin",
      "dabis",
      "dabisne",
      "dabisque",
      "dabit",
      "dabitis",
      "dabitque",
      "dabitur",
      "dabiturne",
      "dabiturque",
      "dabo",
      "daboque",
      "dabor",
      "dabunt",
      "dabuntque",
      "dabuntur",
      "damur",
      "damus",
      "damusque",
      "dan",
      "danda",
      "dandae",
      "dandam",
      "dandamque",
      "dandaque",
      "dandarum",
      "dandas",
      "dandi",
      "dandique",
      "dandis",
      "dando",
      "dandoque",
      "dandorum",
      "dandos",
      "dandosne",
      "dandosque",
      "dandum",
      "dandumque",
      "dandumst",
      "dandus",
      "dandusque",
      "dans",
      "dant",
      "dante",
      "dantem",
      "dantes",
      "danti",
      "dantia",
      "dantibus",
      "dantis",
      "danto",
      "dantque",
      "dantur",
      "daque",
      "dare",
      "darem",
      "daremus",
      "daren",
      "darent",
      "darentque",
      "darentur",
      "dareque",
      "darer",
      "dareris",
      "dares",
      "daret",
      "daretis",
      "daretque",
      "daretur",
      "dari",
      "darier",
      "darique",
      "daris",
      "dariue",
      "das",
      "dasne",
      "dasque",
      "dat",
      "data",
      "datae",
      "datam",
      "datamque",
      "dataque",
      "datarum",
      "datas",
      "datasque",
      "datast",
      "date",
      "dati",
      "datin",
      "datiores",
      "datique",
      "datis",
      "datisne",
      "datisque",
      "datne",
      "dato",
      "datoque",
      "datorum",
      "datos",
      "datosque",
      "datque",
      "datu",
      "datum",
      "datumque",
      "datumst",
      "datur",
      "datura",
      "daturae",
      "daturam",
      "daturas",
      "dature",
      "daturi",
      "daturin",
      "daturique",
      "daturis",
      "daturo",
      "daturos",
      "daturque",
      "daturum",
      "daturumque",
      "daturus",
      "daturust",
      "datus",
      "datusque",
      "datust",
      "daue",
      "dave",
      "dederam",
      "dederamque",
      "dederamus",
      "dederant",
      "dederas",
      "dederat",
      "dederatque",
      "dedere",
      "dederim",
      "dederimus",
      "dederint",
      "dederis",
      "dederisque",
      "dederit",
      "dederitis",
      "dederitque",
      "dedero",
      "dederunt",
      "dederuntque",
      "dedi",
      "dedimus",
      "dedin",
      "dedique",
      "dedisse",
      "dedissem",
      "dedissemus",
      "dedissent",
      "dedisses",
      "dedisset",
      "dedissetis",
      "dedissetue",
      "dedisti",
      "dedistin",
      "dedistique",
      "dedistis",
      "dedit",
      "deditque",
      "dem",
      "demque",
      "demus",
      "demusque",
      "den",
      "dent",
      "dentque",
      "dentur",
      "der",
      "dere",
      "deris",
      "des",
      "desque",
      "det",
      "detis",
      "detisque",
      "detque",
      "detur",
      "deturque",
      "do",
      "don",
      "doque",
      "dor",
      "duim",
      "duint",
      "duis",
      "duisque",
      "duit"
    ],
    "video": [
      "uide",
      "uideam",
      "uideamini",
      "uideamque",
      "uideamur",
      "uideamus",
      "uideamusque",
      "uideant",
      "uideantur",
      "uidear",
      "uideare",
      "uidearis",
      "uideas",
      "uideasque",
      "uideat",
      "uideatis",
      "uideatque",
      "uideatur",
      "uideaturne",
      "uideaturque",
      "uidebam",
      "uidebamini",
      "uidebamque",
      "uidebamur",
      "uidebamus",
      "uidebant",
      "uidebantque",
      "uidebantur",
      "uidebanturque",
      "uidebar",
      "uidebare",
      "uidebaris",
      "uidebarque",
      "uidebas",
      "uidebat",
      "uidebatis",
      "uidebatque",
      "uidebatur",
      "uidebaturque",
      "uidebere",
      "uideberis",
      "uidebimur",
      "uidebimus",
      "uidebis",
      "uidebit",
      "uidebitis",
      "uidebitur",
      "uidebo",
      "uidebor",
      "uidebunt",
      "uidebuntque",
      "uidebuntur",
      "uidemini",
      "uidemur",
      "uidemurne",
      "uidemus",
      "uidemusne",
      "uidemusque",
      "uiden",
      "uidenda",
      "uidendae",
      "uidendam",
      "uidendaque",
      "uidendi",
      "uidendique",
      "uidendis",
      "uidendo",
      "uidendos",
      "uidendum",
      "uidendumque",
      "uidendumst",
      "uidendus",
      "uidens",
      "uidensque",
      "uident",
      "uidente",
      "uidentem",
      "uidentes",
      "uidenti",
      "uidentibus",
      "uidentique",
      "uidentis",
      "uidentium",
      "uidento",
      "uidentque",
      "uidentur",
      "uidenturne",
      "uidenturque",
      "uideo",
      "uideon",
      "uideone",
      "uideoque",
      "uideor",
      "uideorne",
      "uideorque",
      "uideram",
      "uideramus",
      "uiderant",
      "uideras",
      "uiderat",
      "uideratis",
      "uidere",
      "uiderem",
      "uideremini",
      "uideremur",
      "uideremus",
      "uiderent",
      "uiderentque",
      "uiderentur",
      "uiderenturne",
      "uidereque",
      "uiderer",
      "uiderere",
      "uidereris",
      "uideres",
      "uideret",
      "uideretis",
      "uideretque",
      "uideretur",
      "uidereturne",
      "uidereturque",
      "uideri",
      "uiderier",
      "uiderim",
      "uiderimus",
      "uiderint",
      "uiderintne",
      "uiderintue",
      "uiderique",
      "uideris",
      "uiderisque",
      "uiderit",
      "uideritis",
      "uideritne",
      "uideritque",
      "uidero",
      "uiderunt",
      "uideruntque",
      "uides",
      "uidesne",
      "uidesque",
      "uidet",
      "uidete",
      "uidetin",
      "uidetis",
      "uidetisne",
      "uideto",
      "uidetote",
      "uidetque",
      "uidetur",
      "uideturne",
      "uideturque",
      "uidi",
      "uidimus",
      "uidimusque",
      "uidin",
      "uidique",
      "uidisse",
      "uidissem",
      "uidissemque",
      "uidissemus",
      "uidissent",
      "uidissentque",
      "uidisses",
      "uidisset",
      "uidissetis",
      "uidissetque",
      "uidissetve",
      "uidisti",
      "uidistin",
      "uidistine",
      "uidistis",
      "uidit",
      "uiditque",
      "uisa",
      "uisae",
      "uisaeque",
      "uisam",
      "uisamque",
      "uisanest",
      "uisaque",
      "uisas",
      "uisast",
      "uise",
      "uisen",
      "uisi",
      "uisique",
      "uisis",
      "uisisque",
      "uiso",
      "uison",
      "uisoque",
      "uisorum",
      "uisos",
      "uisosque",
      "uisu",
      "uisum",
      "uisumque",
      "uisumst",
      "uisun",
      "uisuque",
      "uisura",
      "uisurae",
      "uisuram",
      "uisuraque",
      "uisuras",
      "uisure",
      "uisuri",
      "uisuris",
      "uisuros",
      "uisurum",
      "uisurus",
      "uisurusne",
      "uisus",
      "uisusque",
      "uisust",
      "uisuve",
      "vide",
      "videam",
      "videamini",
      "videamque",
      "videamur",
      "videamus",
      "videamusque",
      "videant",
      "videantur",
      "videar",
      "videare",
      "videaris",
      "videas",
      "videasque",
      "videat",
      "videatis",
      "videatque",
      "videatur",
      "videaturne",
      "videaturque",
      "videbam",
      "videbamini",
      "videbamque",
      "videbamur",
      "videbamus",
      "videbant",
      "videbantque",
      "videbantur",
      "videbanturque",
      "videbar",
      "videbare",
      "videbaris",
      "videbarque",
      "videbas",
      "videbat",
      "videbatis",
      "videbatque",
      "videbatur",
      "videbaturque",
      "videbere",
      "videberis",
      "videbimur",
      "videbimus",
      "videbis",
      "videbit",
      "videbitis",
      "videbitur",
      "videbo",
      "videbor",
      "videbunt",
      "videbuntque",
      "videbuntur",
      "videmini",
      "videmur",
      "videmurne",
      "videmus",
      "videmusne",
      "videmusque",
      "viden",
      "videnda",
      "videndae",
      "videndam",
      "videndaque",
      "videndi",
      "videndique",
      "videndis",
      "videndo",
      "videndos",
      "videndum",
      "videndumque",
      "videndumst",
      "videndus",
      "videns",
      "vidensque",
      "vident",
      "vidente",
      "videntem",
      "videntes",
      "videnti",
      "videntibus",
      "videntique",
      "videntis",
      "videntium",
      "vidento",
      "videntque",
      "videntur",
      "videnturne",
      "videnturque",
      "video",
      "videon",
      "videone",
      "videoque",
      "videor",
      "videorne",
      "videorque",
      "videram",
      "videramus",
      "viderant",
      "videras",
      "viderat",
      "videratis",
      "videre",
      "viderem",
      "videremini",
      "videremur",
      "videremus",
      "viderent",
      "viderentque",
      "viderentur",
      "viderenturne",
      "videreque",
      "viderer",
      "viderere",
      "videreris",
      "videres",
      "videret",
      "videretis",
      "videretque",
      "videretur",
      "videreturne",
      "videreturque",
      "videri",
      "viderier",
      "viderim",
      "viderimus",
      "viderint",
      "viderintne",
      "viderintue",
      "viderique",
      "videris",
      "viderisque",
      "viderit",
      "videritis",
      "videritne",
      "videritque",
      "videro",
      "viderunt",
      "videruntque",
      "vides",
      "videsne",
      "videsque",
      "videt",
      "videte",
      "videtin",
      "videtis",
      "videtisne",
      "videto",
      "videtote",
      "videtque",
      "videtur",
      "videturne",
      "videturque",
      "vidi",
      "vidimus",
      "vidimusque",
      "vidin",
      "vidique",
      "vidisse",
      "vidissem",
      "vidissemque",
      "vidissemus",
      "vidissent",
      "vidissentque",
      "vidisses",
      "vidisset",
      "vidissetis",
      "vidissetque",
      "vidissetve",
      "vidisti",
      "vidistin",
      "vidistine",
      "vidistis",
      "vidit",
      "viditque",
      "visa",
      "visae",
      "visaeque",
      "visam",
      "visamque",
      "visanest",
      "visaque",
      "visas",
      "visast",
      "vise",
      "visen",
      "visi",
      "visique",
      "visis",
      "visisque",
      "viso",
      "vison",
      "visoque",
      "visorum",
      "visos",
      "visosque",
      "visu",
      "visum",
      "visumque",
      "visumst",
      "visun",
      "visuque",
      "visura",
      "visurae",
      "visuram",
      "visuraque",
      "visuras",
      "visure",
      "visuri",
      "visuris",
      "visuros",
      "visurum",
      "visurus",
      "visurusne",
      "visus",
      "visusque",
      "visust",
      "visuve"
    ],
    "facio": [
      "fac",
      "face",
      "facere",
      "facerem",
      "faceremque",
      "faceremus",
      "faceren",
      "facerent",
      "facerentque",
      "faceres",
      "facerest",
      "faceret",
      "faceretis",
      "faceretne",
      "faceretque",
      "facereve",
      "faci",
      "faciam",
      "faciamque",
      "faciamus",
      "faciant",
      "faciantque",
      "faciantur",
      "facias",
      "faciasne",
      "faciasque",
      "faciat",
      "faciatis",
      "faciatque",
      "faciatur",
      "faciebam",
      "faciebamus",
      "faciebant",
      "faciebantque",
      "faciebas",
      "faciebat",
      "faciebatis",
      "faciebatque",
      "faciemus",
      "faciemusque",
      "facienda",
      "faciendae",
      "faciendai",
      "faciendam",
      "faciendarum",
      "faciendas",
      "faciendi",
      "faciendique",
      "faciendis",
      "faciendiue",
      "faciendive",
      "faciendo",
      "faciendoque",
      "faciendorum",
      "faciendos",
      "faciendosque",
      "faciendum",
      "faciendumne",
      "faciendumque",
      "faciendumst",
      "faciendumve",
      "faciendus",
      "faciens",
      "facient",
      "faciente",
      "facientem",
      "facientes",
      "facienti",
      "facientia",
      "facientibus",
      "facientibusque",
      "facientis",
      "facientium",
      "facientque",
      "facientur",
      "facies",
      "faciesque",
      "faciesve",
      "faciet",
      "facietis",
      "facietisque",
      "facietque",
      "facimus",
      "facio",
      "facioque",
      "facis",
      "facisne",
      "facisque",
      "facit",
      "facite",
      "facitis",
      "facitne",
      "facito",
      "facitoque",
      "facitote",
      "facitque",
      "facitur",
      "faciunda",
      "faciundae",
      "faciundam",
      "faciundas",
      "faciundi",
      "faciundis",
      "faciundisque",
      "faciundo",
      "faciundorum",
      "faciundos",
      "faciundum",
      "faciundumst",
      "faciundus",
      "faciunt",
      "faciuntne",
      "faciunto",
      "faciuntque",
      "facque",
      "facta",
      "factae",
      "factaeque",
      "factam",
      "factamque",
      "factaque",
      "factarum",
      "factas",
      "factast",
      "factaue",
      "facte",
      "facti",
      "factique",
      "factis",
      "factisque",
      "factius",
      "facto",
      "factoque",
      "factorum",
      "factorumque",
      "factos",
      "factost",
      "factoue",
      "factu",
      "factum",
      "factumne",
      "factumque",
      "factumst",
      "factumue",
      "factumve",
      "factuque",
      "factura",
      "facturae",
      "facturam",
      "facturas",
      "facturave",
      "facturi",
      "facturis",
      "facturo",
      "facturos",
      "facturosque",
      "facturum",
      "facturumque",
      "facturumue",
      "facturus",
      "facturusne",
      "facturusque",
      "facturust",
      "facturusue",
      "factus",
      "factusne",
      "factusque",
      "factust",
      "faxim",
      "faxint",
      "faxis",
      "faxit",
      "faxo",
      "feceram",
      "feceramus",
      "fecerant",
      "fecerantque",
      "feceras",
      "fecerat",
      "feceratis",
      "feceratque",
      "fecere",
      "fecerim",
      "fecerimque",
      "fecerimus",
      "fecerint",
      "feceris",
      "fecerisne",
      "fecerit",
      "feceritis",
      "feceritque",
      "feceritue",
      "fecero",
      "fecerunt",
      "feceruntque",
      "feci",
      "fecimus",
      "fecique",
      "fecisse",
      "fecissem",
      "fecissemus",
      "fecissent",
      "fecissentque",
      "fecisseque",
      "fecisses",
      "fecisset",
      "fecissetis",
      "fecissetue",
      "fecisti",
      "fecistique",
      "fecistis",
      "fecit",
      "fecitne",
      "fecitque"
    ],
    "dico": [
      "dic",
      "dicam",
      "dicamini",
      "dicamne",
      "dicamque",
      "dicamur",
      "dicamus",
      "dicamve",
      "dicant",
      "dicantur",
      "dicar",
      "dicare",
      "dicaris",
      "dicarque",
      "dicas",
      "dicasque",
      "dicasve",
      "dicat",
      "dicatis",
      "dicatque",
      "dicatur",
      "dicaturque",
      "dice",
      "dicebam",
      "dicebamini",
      "dicebamque",
      "dicebamus",
      "dicebant",
      "dicebantque",
      "dicebantur",
      "dicebanturque",
      "dicebar",
      "dicebare",
      "dicebas",
      "dicebat",
      "dicebatis",
      "dicebatque",
      "dicebatur",
      "dicemur",
      "dicemus",
      "dicemusque",
      "dicen",
      "dicenda",
      "dicendae",
      "dicendaeque",
      "dicendaeve",
      "dicendam",
      "dicendamue",
      "dicendane",
      "dicendarum",
      "dicendas",
      "dicendast",
      "dicende",
      "dicendi",
      "dicendique",
      "dicendis",
      "dicendo",
      "dicendoque",
      "dicendos",
      "dicendove",
      "dicendum",
      "dicendumque",
      "dicendumst",
      "dicendus",
      "dicens",
      "dicensque",
      "dicensve",
      "dicent",
      "dicente",
      "dicentem",
      "dicentemque",
      "dicentes",
      "dicenti",
      "dicentia",
      "dicentibus",
      "dicentis",
      "dicentium",
      "dicentque",
      "dicentur",
      "dicere",
      "dicerem",
      "diceremus",
      "dicerent",
      "dicerentque",
      "dicerentur",
      "dicereque",
      "dicerer",
      "dicereris",
      "diceres",
      "diceresne",
      "diceret",
      "diceretis",
      "diceretque",
      "diceretur",
      "dicereturue",
      "diceris",
      "dices",
      "dicesne",
      "dicesque",
      "dicet",
      "dicetis",
      "dicetne",
      "dicetque",
      "dicetur",
      "diceturque",
      "dici",
      "dicier",
      "dicimini",
      "dicimur",
      "dicimus",
      "dicin",
      "dicique",
      "dicis",
      "dicisne",
      "dicisque",
      "dicit",
      "dicite",
      "dicitis",
      "dicito",
      "dicitque",
      "dicitur",
      "diciturne",
      "dico",
      "dicta",
      "dictae",
      "dictaeque",
      "dictam",
      "dictamque",
      "dictaque",
      "dictarum",
      "dictas",
      "dictasque",
      "dictast",
      "dicte",
      "dicti",
      "dictique",
      "dictis",
      "dictisque",
      "dictiue",
      "dicto",
      "dictoque",
      "dictorum",
      "dictorumque",
      "dictos",
      "dictoue",
      "dictove",
      "dictu",
      "dictum",
      "dictumque",
      "dictumst",
      "dictumue",
      "dictumve",
      "dictuque",
      "dictura",
      "dicturam",
      "dicturas",
      "dicturi",
      "dicturis",
      "dicturo",
      "dicturos",
      "dicturosque",
      "dicturum",
      "dicturumque",
      "dicturus",
      "dicturusne",
      "dicturusque",
      "dicturusve",
      "dictus",
      "dictusque",
      "dictust",
      "dicunda",
      "dicundae",
      "dicundi",
      "dicundis",
      "dicundo",
      "dicundum",
      "dicundumst",
      "dicunt",
      "dicunto",
      "dicuntque",
      "dicuntur",
      "dixe",
      "dixeram",
      "dixeramus",
      "dixerant",
      "dixeras",
      "dixerat",
      "dixeratis",
      "dixere",
      "dixerim",
      "dixerimus",
      "dixerin",
      "dixerint",
      "dixeris",
      "dixerisne",
      "dixerit",
      "dixeritis",
      "dixeritne",
      "dixeritque",
      "dixero",
      "dixerunt",
      "dixeruntque",
      "dixi",
      "diximus",
      "dixin",
      "dixique",
      "dixisse",
      "dixissem",
      "dixissemus",
      "dixissent",
      "dixisses",
      "dixisset",
      "dixissetque",
      "dixisti",
      "dixistique",
      "dixistis",
      "dixit",
      "dixitne",
      "dixitque"
    ],
    "habeo": [
      "habe",
      "habeam",
      "habeamini",
      "habeamus",
      "habeant",
      "habeantne",
      "habeantque",
      "habeantur",
      "habear",
      "habeare",
      "habearis",
      "habeas",
      "habeasne",
      "habeasque",
      "habeat",
      "habeatis",
      "habeatque",
      "habeatur",
      "habeaturque",
      "habebam",
      "habebamus",
      "habebant",
      "habebantque",
      "habebantur",
      "habebas",
      "habebat",
      "habebatis",
      "habebatque",
      "habebatur",
      "habebaturque",
      "habebere",
      "habeberis",
      "habebimur",
      "habebimus",
      "habebis",
      "habebit",
      "habebitis",
      "habebitque",
      "habebitur",
      "habebo",
      "habebor",
      "habebunt",
      "habebuntque",
      "habebuntur",
      "habemur",
      "habemus",
      "haben",
      "habenda",
      "habendae",
      "habendaeque",
      "habendam",
      "habendamque",
      "habendarum",
      "habendas",
      "habendast",
      "habendi",
      "habendique",
      "habendis",
      "habendo",
      "habendoque",
      "habendorum",
      "habendos",
      "habendum",
      "habendumque",
      "habendumst",
      "habendus",
      "habendusve",
      "habens",
      "habensque",
      "habent",
      "habente",
      "habentem",
      "habentes",
      "habenti",
      "habentia",
      "habentibus",
      "habentis",
      "habentium",
      "habentne",
      "habento",
      "habentque",
      "habentur",
      "habeo",
      "habeon",
      "habeoque",
      "habeor",
      "habere",
      "haberem",
      "haberemque",
      "haberemus",
      "haberent",
      "haberentque",
      "haberentue",
      "haberentur",
      "habereque",
      "haberes",
      "haberet",
      "haberetis",
      "haberetne",
      "haberetque",
      "haberetur",
      "habereturque",
      "haberi",
      "haberier",
      "haberique",
      "haberis",
      "habes",
      "habesne",
      "habet",
      "habete",
      "habetin",
      "habetis",
      "habetisque",
      "habeto",
      "habetote",
      "habetque",
      "habetur",
      "habeturque",
      "habita",
      "habitae",
      "habitam",
      "habitaque",
      "habitas",
      "habitasque",
      "habitast",
      "habite",
      "habiti",
      "habitior",
      "habitis",
      "habitissimum",
      "habito",
      "habitoque",
      "habitorum",
      "habitos",
      "habitosque",
      "habitu",
      "habitum",
      "habitumque",
      "habitune",
      "habituque",
      "habitura",
      "habiturae",
      "habituram",
      "habituras",
      "habituri",
      "habiturine",
      "habituris",
      "habituro",
      "habituros",
      "habiturum",
      "habiturumue",
      "habiturus",
      "habiturusque",
      "habiturust",
      "habiturusue",
      "habitus",
      "habitusque",
      "habitust",
      "habueram",
      "habueramus",
      "habuerant",
      "habueras",
      "habuerat",
      "habuere",
      "habuerim",
      "habuerimus",
      "habuerint",
      "habueris",
      "habuerisque",
      "habuerit",
      "habueritis",
      "habueritne",
      "habueritque",
      "habuero",
      "habuerunt",
      "habueruntque",
      "habui",
      "habuimus",
      "habuique",
      "habuisse",
      "habuissem",
      "habuissemus",
      "habuissent",
      "habuisseque",
      "habuisses",
      "habuisset",
      "habuissetis",
      "habuissetque",
      "habuisti",
      "habuistis",
      "habuit",
      "habuitne",
      "habuitque"
    ],
    "fero": [
      "fer",
      "feram",
      "feramque",
      "feramur",
      "feramus",
      "ferant",
      "ferantur",
      "feranturque",
      "ferar",
      "ferare",
      "feraris",
      "feras",
      "ferasque",
      "ferasue",
      "ferat",
      "feratis",
      "feratque",
      "feratur",
      "feraturque",
      "ferebam",
      "ferebamur",
      "ferebamus",
      "ferebant",
      "ferebantque",
      "ferebantur",
      "ferebanturque",
      "ferebar",
      "ferebare",
      "ferebaris",
      "ferebas",
      "ferebat",
      "ferebatis",
      "ferebatque",
      "ferebatur",
      "ferebaturque",
      "feremur",
      "feremus",
      "feren",
      "ferenda",
      "ferendae",
      "ferendam",
      "ferendaque",
      "ferendarum",
      "ferendas",
      "ferendi",
      "ferendine",
      "ferendis",
      "ferendo",
      "ferendos",
      "ferendum",
      "ferendus",
      "ferens",
      "ferent",
      "ferente",
      "ferentem",
      "ferentes",
      "ferenti",
      "ferentia",
      "ferentibus",
      "ferentis",
      "ferentium",
      "ferentur",
      "ferere",
      "fereris",
      "feres",
      "feresne",
      "feret",
      "feretis",
      "feretque",
      "feretur",
      "fero",
      "feroque",
      "feror",
      "ferorque",
      "ferque",
      "ferre",
      "ferrem",
      "ferremus",
      "ferrent",
      "ferrentur",
      "ferreque",
      "ferres",
      "ferret",
      "ferretis",
      "ferretne",
      "ferretque",
      "ferretur",
      "ferri",
      "ferrique",
      "ferrist",
      "ferriue",
      "ferrive",
      "fers",
      "fersne",
      "fersque",
      "fert",
      "ferte",
      "fertis",
      "fertne",
      "ferto",
      "fertor",
      "fertque",
      "fertur",
      "ferturque",
      "ferue",
      "ferundae",
      "ferundam",
      "ferundast",
      "ferundi",
      "ferundis",
      "ferundo",
      "ferundum",
      "ferunt",
      "ferunto",
      "feruntque",
      "feruntur",
      "lata",
      "latae",
      "latam",
      "latamque",
      "lataque",
      "latarum",
      "latarumque",
      "latas",
      "late",
      "lateque",
      "latest",
      "lati",
      "latin",
      "latine",
      "latineque",
      "latior",
      "latiora",
      "latiore",
      "latiorem",
      "latioremque",
      "latiores",
      "latioribus",
      "latioribusque",
      "latioris",
      "latiorque",
      "latiorum",
      "latique",
      "latis",
      "latisque",
      "latissima",
      "latissimae",
      "latissimam",
      "latissimarum",
      "latissimas",
      "latissime",
      "latissimeque",
      "latissimi",
      "latissimis",
      "latissimo",
      "latissimos",
      "latissimum",
      "latissimus",
      "latius",
      "latiusque",
      "lato",
      "laton",
      "latone",
      "latoque",
      "latorum",
      "latorumque",
      "latos",
      "latosque",
      "latu",
      "latum",
      "latumque",
      "latumst",
      "latura",
      "laturam",
      "laturas",
      "laturi",
      "laturique",
      "laturis",
      "laturo",
      "laturos",
      "laturum",
      "laturumque",
      "laturus",
      "latus",
      "latusque",
      "tetulere",
      "tetulerit",
      "tetulero",
      "tetulerunt",
      "tetuli",
      "tetulisse",
      "tetulissem",
      "tetulissent",
      "tetulisset",
      "tetulisti",
      "tetulit",
      "tuleram",
      "tuleramus",
      "tulerant",
      "tuleras",
      "tulerat",
      "tulere",
      "tulerim",
      "tulerimus",
      "tulerint",
      "tulerintque",
      "tuleris",
      "tulerit",
      "tuleritis",
      "tulero",
      "tulerunt",
      "tuleruntque",
      "tuli",
      "tulimus",
      "tulimusque",
      "tulique",
      "tulisse",
      "tulissem",
      "tulissemus",
      "tulissent",
      "tulisses",
      "tulisset",
      "tulissetis",
      "tulisti",
      "tulistis",
      "tulit",
      "tulitque"
    ],
    "fio": [
      "fi",
      "fiam",
      "fiamque",
      "fiamus",
      "fiant",
      "fiantque",
      "fias",
      "fiat",
      "fiatque",
      "ficumque",
      "fiebam",
      "fiebant",
      "fiebat",
      "fient",
      "fientque",
      "fierem",
      "fierent",
      "fieres",
      "fieret",
      "fieretque",
      "fieretue",
      "fieri",
      "fierine",
      "fierique",
      "fieriue",
      "fies",
      "fiet",
      "fietque",
      "fimus",
      "fin",
      "fio",
      "fis",
      "fit",
      "fite",
      "fitque",
      "fiunt",
      "fiuntque"
    ],
    "inquam": [
      "inquam",
      "inquamst",
      "inque",
      "inquiebat",
      "inquies",
      "inquiet",
      "inquii",
      "inquimus",
      "inquin",
      "inquis",
      "inquisti",
      "inquit",
      "inquito",
      "inquiunt"
    ],
    "aio": [
      "aiant",
      "aias",
      "aiat",
      "aibant",
      "aibas",
      "aibat",
      "aiebam",
      "aiebamus",
      "aiebant",
      "aiebas",
      "aiebat",
      "aiebatis",
      "ain",
      "aio",
      "ais",
      "aisne",
      "ait",
      "aitque",
      "aiunt",
      "aiuntque"
    ]
  }
}
