def get(hit, meta, fragment):
    if 'line' in meta['meta'] and len(meta['meta'].split('-')) <= 2:
        cite = '.'.join([meta['start'][div]
                         for div in meta['meta'].split('-')
                         ]).replace('t1', '')
    else:
        cite = '.'.join([meta['start'][div]
                         for div in meta['meta'].split('-')
                         if div != 'line'
                         ]).replace('t1', '')

AUTHOR_TAB = {'phi2000': {'author': 'Ablabius',
          'works': {'phi001': {'title': 'epigramma',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0400': {'author': 'L. Accius',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'praetextae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi003': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi0402': {'author': 'Valerius Aedituus',
          'works': {'phi001': {'title': 'epigrammata',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi2300': {'author': 'Aemilius Sura',
          'works': {'phi001': {'title': 'De Annis Populi Romani',
                            'source': 'Historicorum Romanorum Reliquiae, Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0404': {'author': 'L. Afranius',
          'works': {'phi001': {'title': 'togatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0902': {'author': 'Iulius Africanus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'M. Fabi Quintiliani Institutionis Oratoriae Libri Duodecim, Tomus II: Libri VII-XII, ed. M. Winterbottom, 1970',
                            'meta': 'line'}}},
 'phi0301': {'author': 'Cn. Domitius Ahenobarbus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae, I: Textus, ed. E. Malcovati, 1953',
                            'meta': 'line'}}},
 'phi2002': {'author': 'Albinus',
          'works': {'phi001': {'title': 'Rerum Romanarum Liber I',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi002': {'title': 'De Metris',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0406': {'author': 'P. Alfenus Varus',
          'works': {'phi002': {'title': 'iurisprudentia, fragmenta',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi1500': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Altercatio Hadriani Augusti et Epicteti Philosophi',
                            'source': 'Altercatio Hadriani Augusti et Epicteti Philosophi, ed. L. W. Daly; W. Suchier, 1939',
                            'meta': 'section-line'}}},
 'phi1206': {'author': 'L. Ampelius',
          'works': {'phi001': {'title': 'Liber Memorialis',
                            'source': 'Lucii Ampelii Liber Memorialis, ed. E. Assmann, 1935',
                            'meta': 'chapter-section-line'}}},
 'phi0094': {'author': 'L. Livius Andronicus',
          'works': {'phi001': {'title': 'Odyssia',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi003': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi1209': {'author': 'Annianus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0002': {'author': 'T. Annius Luscus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae, I: Textus, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi9505': {'author': 'Anonymi Comici et Tragici',
          'works': {'phi001': {'title': 'togatae poetarum incertorum',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'},
                    'phi002': {'title': 'Atellanae poetarum incertorum',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta, Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'},
                    'phi003': {'title': 'palliatae poetarum incertorum',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'},
                    'phi004': {'title': 'tragoediae poetarum incertorum',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'section-verse'}}},
 'phi9500': {'author': 'Anonymi Epici et Lyrici',
          'works': {'phi001': {'title': 'carmen Saliare',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'versus sacrorum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi003': {'title': 'sententia',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi004': {'title': 'A. Atilii Calatini elogium',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi005': {'title': 'carmen Priami',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi006': {'title': 'saturnius(?)',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi007': {'title': 'Acilii Glabrionis tabula',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi008': {'title': 'M. Aemilii cos. a. 179 tabula',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi009': {'title': 'versiculi populares et pueriles',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricoru W. Morel, 1927). 1927',
                            'meta': 'fragment-verse'},
                    'phi010': {'title': 'praecepta rustica et medica',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi011': {'title': 'epigramma a Varrone Plauto attributum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi012': {'title': 'epigramma Pacuvi',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi013': {'title': 'Ardeatis templi inscriptio',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi014': {'title': 'templi Tarracinensis inscriptio',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi015': {'title': 'in Carbonem versus popularis',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi016': {'title': 'carmina Marciana et similia',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi017': {'title': 'versus populares in Caesarem et similia',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi018': {'title': 'epigrammata et populares versus in Augustum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi019': {'title': 'obtrectatoris Vergilii versiculus',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi020': {'title': 'de Crassitio epigramma',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi021': {'title': 'populares versus in Sarmentum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi022': {'title': 'versus populares in Tiberium et Germanicum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi023': {'title': 'populares versus in Caligulam',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi024': {'title': 'artificia metrica',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi025': {'title': 'versus populares in Neronem et eiusque successores',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi026': {'title': 'I 10 praemissi',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi027': {'title': 'versus de VII sapientibus',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi028': {'title': 'odarium',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi029': {'title': 'versus fortasse Clementis(?)',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi030': {'title': 'versus in Caesares Romanos ex Historia Augusta',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi031': {'title': 'versus Orphici ab Arnobio conversi',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi032': {'title': 'Tarentinus senarius',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi033': {'title': 'De Venere et Amoribus',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi034': {'title': 'De Metris',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi035': {'title': 'versus fortasse Enniani',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi036': {'title': 'versus fortasse Luciliani',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi037': {'title': 'versus aevi Catulliani',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi038': {'title': 'versus aevi Catulliani a Morel omissi',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. C. Büchner, 1982',
                            'meta': 'fragment-verse'},
                    'phi039': {'title': 'versus aevi Augustei',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi040': {'title': 'serioris aetatis versus',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi041': {'title': 'versus reciproci',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi9510': {'author': 'Anonymi Grammatici',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0426': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Bellum Africum',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'chapter-section-line'}}},
 'phi0428': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Bellum Alexandrinum',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'chapter-section-line'}}},
 'phi0430': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Bellum Hispaniense',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'chapter-section-line'}}},
 'phi1908': {'author': 'Gallus Antipater',
          'works': {'phi001': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae, Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0302': {'author': 'M. Antonius',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae, Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0721': {'author': 'Antonius Panurgus',
          'works': {'phi001': {'title': 'grammatica, fragmentum',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0408': {'author': 'M. Antonius triumvir',
          'works': {'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae, Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi2003': {'author': 'Caelius Apicius',
          'works': {'phi001': {'title': 'De Re Coquinaria',
                            'source': 'Apicii Decem Libri Qui Dicuntur De Re Coquinaria et Excerpta a Vinidario Conscripta, ed. M. E. Milham, 1969',
                            'meta': 'book-chapter-section-line'},
                    'phi002': {'title': 'Brevis Ciborum, excerpta',
                            'source': 'Apicii Decem Libri Qui Dicuntur De Re Coquinaria et Excerpta a Vinidario Conscripta, ed. M. E. Milham, 1969',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'Brevis Pimentorum, excerpta',
                            'source': 'Apicii Decem Libri Qui Dicuntur De Re Coquinaria et Excerpta a Vinidario Conscripta, ed. M. E. Milham, 1969',
                            'meta': 'line'}}},
 'phi0004': {'author': 'App. Claudius Caecus',
          'works': {'phi001': {'title': 'Sententiae',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0410': {'author': 'Aprissius (?)',
          'works': {'phi001': {'title': 'fragmentum',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi1212': {'author': 'Apuleius Madaurensis',
          'works': {'phi001': {'title': 'Apologia',
                            'source': 'Apulei Platonici Madaurensis Opera Quae Supersunt. Vol. 2, Fasc. 1, ed. R. Helm, 1959',
                            'meta': 'section-line'},
                    'phi002': {'title': 'Metamorphoses 1-11',
                            'source': 'Apulée: Les Métamorphoses. Vols. 1-3, ed. D. S. Robertson; P. Vallette, 1940-1946',
                            'meta': 'book-chapter-line'},
                    'phi003': {'title': 'Florida',
                            'source': 'Apulei Platonici Madaurensis Opera Quae Supersunt, Vol. 2, Fasc. 2, ed. R. Helm, 1959',
                            'meta': 'section-line'},
                    'phi004': {'title': 'De Deo Socratis (Apulée: Opuscules Philosophiques',
                            'source': 'Du Dieu de Socrate, Platon et sa Doctrine, Du Monde) et Fragments, ed. J. Beaujeu, 1973',
                            'meta': 'section-line'},
                    'phi005': {'title': 'Anechomenos (Apulée: Opuscules Philosophiques',
                            'source': 'Du Dieu de Socrate, Platon et sa Doctrine, Du Monde) et Fragments, ed. J. Beaujeu, 1973',
                            'meta': 'verse'},
                    'phi006': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi007': {'title': 'fragmenta (Apulée: Opuscules Philosophiques',
                            'source': 'Du Dieu de Socrate, Platon et sa Doctrine, Du Monde) et Fragments, ed. J. Beaujeu, 1973',
                            'meta': 'fragment-line'},
                    'phi008': {'title': 'De Mundo (Apulée: Opuscules Philosophiques',
                            'source': 'Du Dieu de Socrate, Platon et sa Doctrine, Du Monde) et Fragments, ed. J. Beaujeu, 1973',
                            'meta': 'chapter-line'},
                    'phi009': {'title': 'De Platone et Eius Dogmate (Apulée: Opuscules Philosophiques',
                            'source': 'Du Dieu de Socrate, Platon et sa Doctrine, Du Monde) et Fragments, ed. J. Beaujeu, 1973',
                            'meta': 'book-chapter-line'},
                    'phi010': {'title': '[sp.] (Apulée: Opuscules Philosophiques',
                            'source': 'Du Dieu de Socrate, Platon et sa Doctrine, Du Monde) et Fragments, ed. J. Beaujeu, 1973',
                            'meta': 'section-line'}}},
 'phi0412': {'author': 'C. Aquilius Gallus',
          'works': {'phi001': {'title': 'iurisprudentia, fragmenta',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0005': {'author': 'Aquilius',
          'works': {'phi001': {'title': 'palliata, fragmenta',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'fragment-line'}}},
 'phi0703': {'author': 'Arbonius Silo',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi3211': {'author': 'Argumenta Aeneidis et Tetrasticha in cunctis libris Vergilii',
          'works': {'phi001': {'title': 'Argumenta Aeneidis, Decasticha',
                            'source': 'Anthologia Latina. Vol. 1, Fasc. 1, ed. D. R. Shackleton Bailey, 1982',
                            'meta': 'book-verse'},
                    'phi002': {'title': 'Argumenta Aeneidis, Monosticha',
                            'source': 'Anthologia Latina. Vol. 1, Fasc. 1, ed. D. R. Shackleton Bailey, 1982',
                            'meta': 'verse'},
                    'phi003': {'title': 'Tetrasticha in Vergilii Bucolica et Georgica',
                            'source': 'Anthologia Latina. Vol. 1, Fasc. 1, ed. D. R. Shackleton Bailey, 1982',
                            'meta': 'verse'},
                    'phi004': {'title': 'Tetrasticha in Vergilii Aeneida',
                            'source': 'Anthologia Latina. Vol. 1, Fasc. 1, ed. D. R. Shackleton Bailey, 1982',
                            'meta': 'verse'}}},
 'phi0414': {'author': 'L. Arruntius',
          'works': {'phi001': {'title': 'Historiae Belli Punici',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0803': {'author': 'Q. Asconius Pedianus',
          'works': {'phi001': {'title': 'Pisonem',
                            'source': 'Q. Asconii Pediani Orationum Ciceronis Quinque Enarratio, ed. A. C. Clark, [1907]',
                            'meta': 'page-line'},
                    'phi002': {'title': 'Pro Scauro',
                            'source': 'Q. Asconii Pediani Orationum Ciceronis Quinque Enarratio, ed. A. C. Clark, [1907]',
                            'meta': 'page-line'},
                    'phi003': {'title': 'Pro Milone',
                            'source': 'Q. Asconii Pediani Orationum Ciceronis Quinque Enarratio, ed. A. C. Clark, [1907]',
                            'meta': 'page-line'},
                    'phi004': {'title': 'Pro Cornelio',
                            'source': 'Q. Asconii Pediani Orationum Ciceronis Quinque Enarratio, ed. A. C. Clark, [1907]',
                            'meta': 'page-line'},
                    'phi005': {'title': 'In Toga Candida',
                            'source': 'Q. Asconii Pediani Orationum Ciceronis Quinque Enarratio, ed. A. C. Clark, [1907]',
                            'meta': 'page-line'}}},
 'phi0300': {'author': 'Sempronius Asellio',
          'works': {'phi001': {'title': 'Rerum Gestarum Libri',
                            'source': 'Historicorum Romanorum Reliquiae, Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi1363': {'author': 'Aemilius Asper',
          'works': {'phi001': {'title': 'commentum in Terentium Sallustium Vergilium',
                            'source': 'Aemilius Asper: Ein Beitrag zur römischen Literaturgeschichte, ed. P. Wessner, 1905',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'Vergilius',
                            'source': 'Servii Grammatici Qui Feruntur in Vergilii Carmina Commentarii. Vol. 3, Fasc. 2, ed. H. Hagen, 1902',
                            'meta': 'page-line'}}},
 'phi0416': {'author': 'L. Ateius Praetextatus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi1604': {'author': 'Iulius Atherianus',
          'works': {'phi001': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0007': {'author': 'Atilius',
          'works': {'phi001': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0418': {'author': 'T. Quinctius Atta',
          'works': {'phi001': {'title': 'epigramma',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi002': {'title': 'togatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0809': {'author': 'Aufidius Bassus',
          'works': {'phi001': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0401': {'author': 'Aufustius',
          'works': {'phi001': {'title': 'grammatica, fragmenta',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi1218': {'author': 'Sentius Augurinus',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi2468': {'author': 'Aurelius Augustinus',
          'works': {'phi001': {'title': 'Laus Cerei',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi1221': {'author': 'C. Iulius Caesar Augustus Octavianus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'dicta et apophthegmata',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'dictum-line'},
                    'phi003': {'title': 'edicta',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'edict-line'},
                    'phi004': {'title': 'epistulae',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'fragment-line'},
                    'phi005': {'title': 'fragmentum incertae sedis',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'fragment-line'},
                    'phi006': {'title': 'opera historica',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'fragment-line'},
                    'phi007': {'title': 'Res Gestae',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'section-line'},
                    'phi008': {'title': 'oratio',
                            'source': 'Imperatoris Caesaris Augusti Operum Fragmenta, ed. E. Malcovati, 1962',
                            'meta': 'fragment-line'}}},
 'phi2305': {'author': 'Caelius Aurelianus',
          'works': {'phi001': {'title': 'E Parmenide de natura',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi1224': {'author': 'M. Aurelius',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0303': {'author': 'Aurelius Opillus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi1203': {'author': 'Alfius Avitus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0423': {'author': 'L. Herennius Balbus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae, Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1227': {'author': 'Balbus',
          'works': {'phi001': {'title': 'Expositio et Ratio Omnium Formarum',
                            'source': 'Die Schriften der Römischen Feldmesser, Vol. 1, ed. F. Blume; K. Lachmann; A. Rudorff, 1848',
                            'meta': 'page-line'}}},
 'phi0812': {'author': 'C. Caesius Bassus. Poeticae Species Lat',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'De Metris, fragmenta',
                            'source': 'Grammaticae Romanae Fragmenta Aetatis Caesareae. Vol. 1, ed. A. Mazzarino, 1955',
                            'meta': 'fragment-line'},
                    'phi003': {'title': 'De Metris Horatii [sp.]',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'},
                    'phi004': {'title': 'Breviatio Pedum [sp.]',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'},
                    'phi005': {'title': 'De Compositionibus [sp.]',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'},
                    'phi006': {'title': 'Genera Versuum [sp.]',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'},
                    'phi007': {'title': '[sp.]',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'}}},
 'phi0432': {'author': 'M. Furius Bibaculus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0815': {'author': 'Bruttedius Niger',
          'works': {'phi001': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0010': {'author': 'M. Iunius Brutus [iur.]',
          'works': {'phi001': {'title': 'iurisprudentia',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0436': {'author': 'M. Iunius Brutus [tyr.]',
          'works': {'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0821': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Bucolica Einsidlensia',
                            'source': 'Calpurnii et Nemesiani Bucolica, Accedunt Einsidlensia Quae Dicuntur Carmina, ed. C. Giarratano, 1943',
                            'meta': 'poem-verse'}}},
 'phi0013': {'author': 'Caecilius Statius',
          'works': {'phi001': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0442': {'author': 'A. Caecina. fragmentum',
          'works': {'phi002': {'title': 'Scholiorum Veronensium in Vergilii Bucolica Georgica Aeneidem Fragmenta',
                            'source': 'Servii Grammatici Qui Feruntur in Vergilii Carmina Commentarii, Vol. 3, Fasc. 2, ed. H. Hagen, 1902',
                            'meta': 'line'}}},
 'phi0444': {'author': 'M. Caelius Rufus',
          'works': {'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0824': {'author': 'Cn. Arulenus Caelius Sabinus',
          'works': {'phi001': {'title': 'iurisprudentia, fragmenta',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0445': {'author': 'C. et L. Caepasii fratres',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0446': {'author': 'Q. Servilius Caepio',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0448': {'author': 'C. Iulius Caesar',
          'works': {'phi001': {'title': 'De Bello Gallico',
                            'source': 'C. Iulii Caesaris: Commentarii Rerum Gestarum. Vol. 1, ed. O. Seel, 1961',
                            'meta': 'book-chapter-section-line'},
                    'phi002': {'title': 'Bellum Civile',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 2, ed. A. Klotz, 1950',
                            'meta': 'book-chapter-section-line'},
                    'phi003': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'},
                    'phi004': {'title': 'De Analogia',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi005': {'title': 'Anticato',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'fragment-line'},
                    'phi006': {'title': 'carmina',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'fragment-verse'},
                    'phi007': {'title': 'epistulae ad Ciceronem',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'fragment-line'},
                    'phi008': {'title': 'epistulae ad familiares',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'fragment-line'}}},
 'phi0450': {'author': 'L. Iulius Caesar',
          'works': {'phi001': {'title': 'Auspiciorum Liber, fragmenta',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0827': {'author': 'Caesellius Vindex',
          'works': {'phi001': {'title': 'grammatica, fragmenta 1-7',
                            'source': 'A. Gelli Noctes Atticae. Vols. 1-2, ed. P. K. Marshall, 1968',
                            'meta': 'fragment-line'}}},
 'phi0454': {'author': 'M. Calidius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1100': {'author': 'Calpurnius Flaccus',
          'works': {'phi001': {'title': 'Declamationes, excerpta',
                            'source': 'Calpurnii Flacci Declamationum Excerpta, ed. L. Håkanson, 1978',
                            'meta': 'declamation-line'}}},
 'phi0016': {'author': 'L. Calpurnius Piso Censorinus Frugi',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi0455': {'author': 'C. Calpurnius Piso',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0830': {'author': 'T. Calpurnius Siculus',
          'works': {'phi001': {'title': 'Eclogae',
                            'source': 'Calpurnii et Nemesiani Bucolica, Accedunt Einsidlensia Quae Dicuntur Carmina, ed. C. Giarratano, 1943',
                            'meta': 'poem-verse'}}},
 'phi0456': {'author': 'C. Licinius Macer Calvus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0458': {'author': 'P. Cannutius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1229': {'author': 'Flavius Caper',
          'works': {'phi001': {'title': 'De Orthographia',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi002': {'title': 'De Verbis Dubiis',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'}}},
 'phi0806': {'author': 'C. Ateius Capito',
          'works': {'phi001': {'title': 'iurisprudentia',
                            'source': 'C. Atei Capitonis Fragmenta, ed. W. Strzelecki, 1967',
                            'meta': 'fragment-line'}}},
 'phi0019': {'author': 'C. Papirius Carbo',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0460': {'author': 'C. Papirius Carbo Arvina',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0149': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Carmen Arvale',
                            'source': 'Anthologia Latina sive Poesis Latinae Supplementum. Part 2, Fasc. 1, ed. F. Bücheler, 1895',
                            'meta': 'verse'}}},
 'phi0706': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Carmen de Bello Aegyptiaco',
                            'source': 'C. Rabirius, Bellum Actiacum e Papiro Herculanense 817, ed. G. Garuti, 1958',
                            'meta': 'fragment-verse'}}},
 'phi0306': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Carmen Devotionis',
                            'source': 'Ambrosii Theodosii Macrobii Saturnalia, ed. J. Willis, 1970',
                            'meta': 'line'}}},
 'phi0309': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Carmen Evocationis',
                            'source': 'Ambrosii Theodosii Macrobii Saturnalia, ed. J. Willis, 1970',
                            'meta': 'line'}}},
 'phi0466': {'author': 'A. Cascellius. Liber Bene Dictorum, frr',
          'works': {'phi001': {'title': 'duo',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0469': {'author': 'L. Cassius Longinus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0022': {'author': 'M. Porcius Cato',
          'works': {'phi001': {'title': 'De Agri Cultura',
                            'source': 'M. Porci Catonis De Agri Cultura ad Fidem Florentini Codicis Deperditi, ed. A. Mazzarino, 1982',
                            'meta': 'chapter-section-line'},
                    'phi002': {'title': 'de agri cultura fragmenta',
                            'source': 'Scriptorum Romanorum De Re Rustica Reliquiae. Vol. 1, ed. F. Speranza, 1974',
                            'meta': 'fragment-line'},
                    'phi003': {'title': 'Dicta Memorabilia',
                            'source': 'M. Catonis praeter Librum De Re Rustica Quae Extant, ed. H. Jordan, 1860',
                            'meta': 'dictum-line'},
                    'phi004': {'title': 'epistulae',
                            'source': 'M. Catonis praeter Librum De Re Rustica Quae Extant, ed. H. Jordan, 1860',
                            'meta': 'fragment-line'},
                    'phi005': {'title': 'De Medicina',
                            'source': 'M. Catonis praeter Librum De Re Rustica Quae Extant, ed. H. Jordan, 1860',
                            'meta': 'fragment-line'},
                    'phi006': {'title': 'incertorum librorum fragmenta',
                            'source': 'M. Catonis praeter Librum De Re Rustica Quae Extant, ed. H. Jordan, 1860',
                            'meta': 'work-fragment-line'},
                    'phi007': {'title': 'iurisprudentia',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol.1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'},
                    'phi008': {'title': 'De Re Militari',
                            'source': 'M. Catonis praeter Librum De Re Rustica Quae Extant, ed. H. Jordan, 1860',
                            'meta': 'fragment-line'},
                    'phi009': {'title': 'Carmen De Moribus',
                            'source': 'M. Catonis praeter Librum De Re Rustica Quae Extant, ed. H. Jordan, 1860',
                            'meta': 'fragment-line'},
                    'phi010': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'},
                    'phi011': {'title': 'Origines',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'},
                    'phi012': {'title': 'De Rhetorica',
                            'source': 'M. Catonis praeter Librum De Re Rustica Quae Extant, ed. H. Jordan, 1860',
                            'meta': 'fragment-line'}}},
 'phi0025': {'author': 'M. Porcius M. f. M. n. Cato',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0470': {'author': 'M. Porcius Cato Uticensis',
          'works': {'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0472': {'author': 'C. Valerius Catullus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Catullus, ed. G. P. Goold, 1983',
                            'meta': 'poem-verse'},
                    'phi002': {'title': 'carminum fragmenta',
                            'source': 'C. Valerii Catulli Carmina, ed. R. A. B. Mynors, 1958',
                            'meta': 'fragment-verse'}}},
 'phi0473': {'author': 'Q. Lutatius Catulus iunior',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0836': {'author': 'A. Cornelius Celsus',
          'works': {'phi001': {'title': 'De Agricultura',
                            'source': 'Corpus Medicorum Latinorum. Vol. 1, ed. F. Marx, 1915',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'De Medicina',
                            'source': 'Corpus Medicorum Latinorum. Vol. 1, ed. F. Marx, 1915; 4.27.1d [fr.1]: ed. Umberto Capitani [Maia 26(1974)]; 4.27.1d [fr.2]: ed. Dionisio Ollero Granados [Emerita 41(1973)]',
                            'meta': 'book-chapter-section-line'},
                    'phi003': {'title': 'De Rhetorica',
                            'source': 'Corpus Medicorum Latinorum. Vol. 1, ed. F. Marx, 1915',
                            'meta': 'fragment-line'}}},
 'phi2028': {'author': 'Chalcidius',
          'works': {'phi001': {'title': 'Ex Graecis Conversiones',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0474': {'author': 'M. Tullius Cicero',
          'works': {'phi001': {'title': 'Pro Quinctio',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'section-line'},
                    'phi002': {'title': 'Roscio Amerino',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 1, ed. A. C. Clark, 1905',
                            'meta': 'section-line'},
                    'phi003': {'title': 'Roscio Comoedo',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'section-line'},
                    'phi004': {'title': 'Caecilium',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 3, ed. W. Peterson, 1917',
                            'meta': 'section-line'},
                    'phi005': {'title': 'In Verrem',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 3, ed. W. Peterson, 1917',
                            'meta': 'actio-book-section-line'},
                    'phi006': {'title': 'Pro Tullio',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 6, ed. A. C. Clark, 1911',
                            'meta': 'section-line'},
                    'phi007': {'title': 'Pro Fonteio',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 6, ed. A. C. Clark, 1911',
                            'meta': 'section-line'},
                    'phi008': {'title': 'Pro Caecina',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'section-line'},
                    'phi009': {'title': 'Pro Lege Manilia',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 1, ed. A. C. Clark, 1905',
                            'meta': 'section-line'},
                    'phi010': {'title': 'Pro Cluentio',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 1, ed. A. C. Clark, 1905',
                            'meta': 'section-line'},
                    'phi011': {'title': 'De Lege Agraria',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'oration-section-line'},
                    'phi012': {'title': 'Reo',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'section-line'},
                    'phi013': {'title': 'In Catilinam',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 1, ed. A. C. Clark, 1905',
                            'meta': 'oration-section-line'},
                    'phi014': {'title': 'Pro Murena',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 1, ed. A. C. Clark, 1905',
                            'meta': 'section-line'},
                    'phi015': {'title': 'Pro Sulla',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 6, ed. A. C. Clark, 1911',
                            'meta': 'section-line'},
                    'phi016': {'title': 'Pro Archia',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 6, ed. A. C. Clark, 1911',
                            'meta': 'section-line'},
                    'phi017': {'title': 'Pro Flacco',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'section-line'},
                    'phi018': {'title': 'Post Reditum ad Populum',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi019': {'title': 'Post Reditum in Senatu',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi020': {'title': 'De Domo Sua',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi021': {'title': 'De Haruspicum Responso',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi022': {'title': 'Pro Sestio',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi023': {'title': 'In Vatinium',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi024': {'title': 'Pro Caelio',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 1, ed. A. C. Clark, 1905',
                            'meta': 'section-line'},
                    'phi025': {'title': 'De Provinciis Consularibus',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi026': {'title': 'Pro Balbo',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 5, ed. W. Peterson, 1911',
                            'meta': 'section-line'},
                    'phi027': {'title': 'In Pisonem',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'section-line'},
                    'phi028': {'title': 'Pro Plancio',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 6, ed. A. C. Clark, 1911',
                            'meta': 'section-line'},
                    'phi029': {'title': 'Pro Scauro',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 6, ed. A. C. Clark, 1911',
                            'meta': 'section-line'},
                    'phi030': {'title': 'Pro Rabirio Postumo',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 4, ed. A. C. Clark, 1909',
                            'meta': 'section-line'},
                    'phi031': {'title': 'Pro Milone',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 2, ed. A. C. Clark, 1918',
                            'meta': 'section-line'},
                    'phi032': {'title': 'Pro Marcello',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 2, ed. A. C. Clark, 1918',
                            'meta': 'section-line'},
                    'phi033': {'title': 'Pro Ligario',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 2, ed. A. C. Clark, 1918',
                            'meta': 'section-line'},
                    'phi034': {'title': 'Pro Rege Deiotaro',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 2, ed. A. C. Clark, 1918',
                            'meta': 'section-line'},
                    'phi035': {'title': 'Philippicae',
                            'source': 'M. Tulli Ciceronis Orationes. Vol. 2, ed. A. C. Clark, 1918',
                            'meta': 'oration-section-line'},
                    'phi036': {'title': 'De Inventione',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 2, ed. E. Stroebel, 1915',
                            'meta': 'book-section-line'},
                    'phi037': {'title': 'De Oratore',
                            'source': 'M. Tulli Ciceronis Rhetorica. Vol.1, ed. A. S. Wilkins, 1902',
                            'meta': 'book-section-line'},
                    'phi038': {'title': 'De Partitione Oratoria',
                            'source': 'Cicero in Twenty-Eight Volumes. Vol. 4, ed. H. Rackham, 1942',
                            'meta': 'section-line'},
                    'phi039': {'title': 'Brutus',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 4, ed. E. Malcovati, 1970',
                            'meta': 'section-line'},
                    'phi040': {'title': 'Orator',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 5, ed. P. Reis, 1932',
                            'meta': 'section-line'},
                    'phi041': {'title': 'De Optimo Genere Oratorum',
                            'source': 'Cicero: De Inventione, De Optimo Genere Oratorum, Topica, ed. H. M. Hubbell, 1949',
                            'meta': 'section-line'},
                    'phi042': {'title': 'Topica',
                            'source': 'Cicero: De Inventione, De Optimo Genere Oratorum, Topica, ed. H. M. Hubbell, 1949',
                            'meta': 'section-line'},
                    'phi043': {'title': 'De Republica',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 2, ed. C. F. W. Mueller, 1890',
                            'meta': 'book-section-line'},
                    'phi044': {'title': 'De Legibus',
                            'source': 'Cicéron: Traité des Lois, ed. G. de Plinval, 1968',
                            'meta': 'book-section-line'},
                    'phi045': {'title': 'Academica',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 42, ed. O. Plasberg, 1922',
                            'meta': 'book-section-line'},
                    'phi046': {'title': 'Lucullus',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 42, ed. O. Plasberg, 1922',
                            'meta': 'section-line'},
                    'phi047': {'title': 'Paradoxa Stoicorum',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 3, ed. C. F. W. Mueller, 1890',
                            'meta': 'paradox-section-line'},
                    'phi048': {'title': 'De Finibus Bonorum et Malorum',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 43, ed. T. Schiche, 1915',
                            'meta': 'book-section-line'},
                    'phi049': {'title': 'Tusculanae Disputationes',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 44, ed. M. Pohlenz, 1918',
                            'meta': 'book-section-line'},
                    'phi050': {'title': 'De Natura Deorum',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 45, ed. W. Ax, 1933',
                            'meta': 'book-section-line'},
                    'phi051': {'title': 'Cato Maior de Senectute',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 47, ed. K. Simbeck, 1917',
                            'meta': 'section-line'},
                    'phi052': {'title': 'Laelius de Amicitia',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 3, ed. C. F. W. Mueller, 1890',
                            'meta': 'section-line'},
                    'phi053': {'title': 'De Divinatione',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 2, ed. C. F. W. Mueller, 1890',
                            'meta': 'book-section-line'},
                    'phi054': {'title': 'De Fato',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 2, ed. C. F. W. Mueller, 1890',
                            'meta': 'section-line'},
                    'phi055': {'title': 'De Officiis',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 48, ed. C. Atzert, 1932',
                            'meta': 'book-section-line'},
                    'phi056': {'title': 'Epistulae ad Familiares',
                            'source': 'Cicero: Epistulae ad Familiares. 2 vols., ed. D. R. Shackleton Bailey, 1977',
                            'meta': 'book-letter-section-line'},
                    'phi057': {'title': 'Epistulae ad Atticum',
                            'source': "Cicero's Letters to Atticus. 6 vols., ed. D. R. Shackleton Bailey, 1965-1968",
                            'meta': 'book-letter-section-line'},
                    'phi058': {'title': 'Epistulae ad Quintum Fratrem',
                            'source': 'Cicero: Epistulae ad Quintum Fratrem et M. Brutum, ed. D. R. Shackleton Bailey, 1980',
                            'meta': 'book-letter-section-line'},
                    'phi059': {'title': 'Epistulae ad Brutum',
                            'source': 'Cicero: Epistulae ad Quintum Fratrem et M. Brutum, ed. D. R. Shackleton Bailey, 1980',
                            'meta': 'letter-section-line'},
                    'phi060': {'title': 'Arati Phaenomena',
                            'source': 'Cicéron: Aratea, Fragments Poétiques, ed. J. Soubiran, 1972',
                            'meta': 'fragment-verse'},
                    'phi061': {'title': 'Facete Dicta',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 3, ed. C. F. W. Mueller, 1890',
                            'meta': 'fragment-line'},
                    'phi062': {'title': 'carmina, fragmenta',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. C. Büchner, 1982',
                            'meta': 'fragment-verse'},
                    'phi063': {'title': 'Commentarii Causarum',
                            'source': 'S. Hieronymi Presbyteri Opera, Part 3:1, ed. P. Lardet',
                            'meta': 'line'},
                    'phi064': {'title': 'epistulae, fragmenta',
                            'source': 'M. Tulli Ciceronis Epistulae. Vol. 3, ed. W. S. Watt, 1958',
                            'meta': 'addressee-fragment-line'},
                    'phi065': {'title': 'Hortensius',
                            'source': 'M. Tulli Ciceronis Hortensius, ed. A. Grilli, 1962',
                            'meta': 'fragment-line'},
                    'phi066': {'title': 'incertorum librorum fragmenta',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 3, ed. C. F. W. Mueller, 1890',
                            'meta': 'fragment-line'},
                    'phi067': {'title': 'in Artem Redig.',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'},
                    'phi068': {'title': 'orationum deperditarum frr.',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Vol. 8, ed. F. Schoell, 1918',
                            'meta': 'oration-fragment-line'},
                    'phi069': {'title': 'orationum incertarum frr.',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Vol. 8, ed. F. Schoell, 1918',
                            'meta': 'fragment-line'},
                    'phi070': {'title': 'philosophicorum librorum frr.',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 3, ed. C. F. W. Mueller, 1890',
                            'meta': 'work-fragment-line'},
                    'phi071': {'title': 'Arati Prognostica',
                            'source': 'Cicéron: Aratea, Fragments Poétiques, ed. J. Soubiran, 1972',
                            'meta': 'fragment-verse'},
                    'phi072': {'title': 'Timaeus',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Part 4, Vol. 3, ed. C. F. W. Mueller, 1890',
                            'meta': 'section-line'},
                    'phi073': {'title': 'Rhetorica ad Herennium [sp.]',
                            'source': 'M. Tulli Ciceronis Scripta Quae Manserunt Omnia. Fasc. 1, ed. F. Marx, 1923',
                            'meta': 'book-section-line'},
                    'phi074': {'title': 'In Sallustium Crispum [sp.]',
                            'source': 'Appendix Sallustiana. Fasc. 2, ed. A. Kurfess, 1970',
                            'meta': 'section-line'},
                    'phi075': {'title': 'epistula ad Octavianum [sp.]',
                            'source': 'M. Tulli Ciceronis Epistulae. Vol. 3, ed. W. S. Watt, 1958',
                            'meta': 'section-line'}}},
 'phi0478': {'author': 'Q. Tullius Cicero.',
          'works': {'phi002': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi003': {'title': 'Commentariolum Petitionis [sp.]',
                            'source': 'M. Tulli Ciceronis Epistulae. Vol. 3, ed. W. S. Watt, 1958',
                            'meta': 'section-line'}}},
 'phi0027': {'author': 'L. Cincius Alimentus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0484': {'author': 'L. Cincius',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'iurisprudentia',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0486': {'author': 'C. Helvius Cinna',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0724': {'author': 'Cloatius Verus',
          'works': {'phi001': {'title': 'grammatica fragmenta',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0842': {'author': 'C. Clodius Licinus',
          'works': {'phi001': {'title': 'Libri Rerum Romanarum',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0487': {'author': 'P. Clodius Pulcher',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0488': {'author': 'Ser. Clodius',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0405': {'author': 'Clodius Tuscus',
          'works': {'phi001': {'title': 'grammatica, fragmenta',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0028': {'author': 'L. Coelius Antipater',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi0845': {'author': 'L. Iunius Moderatus Columella',
          'works': {'phi001': {'title': 'De Arboribus',
                            'source': 'L. Iuni Moderati Columellae Opera Quae Extant, Fasciculus Primus Librum de Arboribus Qui Vocatur Continens, ed. V. Lundström, 1897',
                            'meta': 'chapter-section-line'},
                    'phi002': {'title': 'De Re Rustica',
                            'source': 'Bks. 1-2: L. Iuni Moderati Columellae Opera Quae Exstant. Vol. 2, ed. V. Lundström, 1917; Bks. 3-5: Ibid. Vol. 3, ed. V. Lundström, Å. Josephson, S. Hedberg, 1968; Bks. 6-7, Ibid. ed. V. Lundström, 1940; Bks. 8-9: Ibid. Vol. 5, ed. V. Lundström, Å. Josephson, 1955; Bks. 10-11: Ibid. Vols. 6-7, ed. V. Lundström, 1902-1906; Bk. 12: Ibid. Vol. 8, ed. S. Hedberg, 1958',
                            'meta': 'book-chapter-section-line'}}},
 'phi0490': {'author': 'P. Cominius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0492': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Commentarii Augurum',
                            'source': 'M. Terenti Varronis De Linguae Latinae Quae Supersunt, ed. G. Goetz; F. Schoell, 1910',
                            'meta': 'line'}}},
 'phi0494': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Commentarii Consulares',
                            'source': 'M. Terenti Varronis De Linguae Latinae Quae Supersunt, ed. G. Goetz; F. Schoell, 1910',
                            'meta': 'line'}}},
 'phi0496': {'author': 'Commentarius Anquisitionis',
          'works': {'phi001': {'title': "M'. Sergii M'. f. Quaestoris",
                            'source': 'M. Terenti Varronis De Linguae Latinae Quae Supersunt, ed. G. Goetz; F. Schoell, 1910',
                            'meta': 'fragment-line'}}},
 'phi0031': {'author': 'Cornelia, mater Gracchorum',
          'works': {'phi001': {'title': 'epistula, fragmenta',
                            'source': 'Cornelii Nepotis Vitae cum Fragmentis, ed. P. K. Marshall, 1977',
                            'meta': 'fragment-line'}}},
 'phi0851': {'author': 'Cornelius Severus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'fragmenta a Morel omissa',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. C. Büchner, 1982',
                            'meta': 'fragment-verse'}}},
 'phi0854': {'author': 'Cornificius Gallus',
          'works': {'phi001': {'title': 'versus in Vergilium',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0727': {'author': 'Cornificius Longus',
          'works': {'phi001': {'title': 'grammatica, fragmenta',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0409': {'author': 'Q. Cornificius',
          'works': {'phi001': {'title': 'carmina, fragmenta',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0857': {'author': 'L. Annaeus Cornutus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta Aetatis Caesareae. Vol. 1, ed. A. Mazzarino, 1955',
                            'meta': 'fragment-line'}}},
 'phi0498': {'author': 'C. Aurelius Cotta',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0500': {'author': 'L. Licinius Crassus',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0502': {'author': 'A. Cremutius Cordus',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0034': {'author': 'C. Scribonius Curio avus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0037': {'author': 'C. Scribonius Curio pater',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0860': {'author': 'Q. Curtius Rufus',
          'works': {'phi001': {'title': 'Historiae Alexandri Magni',
                            'source': 'Q. Curtius Rufus, Geschichte Alexanders des Grossen, ed. K. Müller, 1954',
                            'meta': 'book-chapter-section-line'}}},
 'phi1234': {'author': 'Didascaliae et Argumenta in Plautum',
          'works': {'phi001': {'title': 'Amphitruo',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi002': {'title': 'Asinaria',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi003': {'title': 'Aulularia',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi004': {'title': 'Captivi',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi005': {'title': 'Casina',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi006': {'title': 'Cistellaria',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi007': {'title': 'Curculio',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi008': {'title': 'Epidicus',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi009': {'title': 'Menaechmi',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi010': {'title': 'Mercator',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'argument-line'},
                    'phi011': {'title': 'Miles Gloriosus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi012': {'title': 'Mostellaria',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi013': {'title': 'Persa',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi014': {'title': 'Poenulus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi015': {'title': 'Pseudolus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi016': {'title': 'Rudens',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi017': {'title': 'Stichus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi018': {'title': 'Trinummus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'},
                    'phi019': {'title': 'Truculentus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'argument-line'}}},
 'phi1235': {'author': 'Didascaliae et Periochae in Terentium',
          'works': {'phi001': {'title': 'Andria',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'section-line'},
                    'phi002': {'title': 'Heauton Timorumenos',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'section-line'},
                    'phi003': {'title': 'Eunuchus',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'section-line'},
                    'phi004': {'title': 'Phormio',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'section-line'},
                    'phi005': {'title': 'Hecyra',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'section-line'},
                    'phi006': {'title': 'Adelphoe',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'section-line'}}},
 'phi0510': {'author': 'P. Cornelius Dolabella',
          'works': {'phi002': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0709': {'author': 'Domitius Marsus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'epigrammata ex Bobiensibus',
                            'source': 'Epigrammata Bobiensia, ed. W. Speyer, 1963',
                            'meta': 'epigram-verse'}}},
 'phi0863': {'author': 'Dorcatius',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0312': {'author': 'Fabius Dossennus',
          'works': {'phi001': {'title': 'carmina, fragmentum',
                            'source': 'C. Plini Secundi Naturalis Historiae Libri XXXVII, Vol. 2, ed. C. Mayhoff',
                            'meta': 'verse'}}},
 'phi0512': {'author': 'M. Duronius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0514': {'author': 'Egnatius',
          'works': {'phi001': {'title': 'De Rerum Natura',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0043': {'author': 'Q. Ennius',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'The Annals of Q. Ennius, ed. O. Skutsch, 1985',
                            'meta': 'book-verse'},
                    'phi002': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'},
                    'phi003': {'title': 'praetextae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi004': {'title': 'Saturae',
                            'source': 'Ennianae Poesis Reliquiae, ed. J. Vahlen, 1928',
                            'meta': 'verse'},
                    'phi005': {'title': 'tragoediae',
                            'source': 'The Tragedies of Ennius, ed. H. D. Jocelyn, 1967',
                            'meta': 'verse'},
                    'phi006': {'title': 'varia',
                            'source': 'Ennianae Poesis Reliquiae, ed. J. Vahlen, 1928',
                            'meta': 'verse'},
                    'phi007': {'title': 'incerta',
                            'source': 'Ennianae Poesis Reliquiae, ed. J. Vahlen, 1928',
                            'meta': 'verse'}}},
 'phi0515': {'author': 'Sex. (vel Sp.) Ennius',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0046': {'author': 'Cornelius Epicadus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0516': {'author': 'C. Erucius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0058': {'author': 'Q. Fabius Maximus Servilianus',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi0061': {'author': 'Fabius Pictor',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'Iuris Pontificis Libri',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0064': {'author': 'C. Fannius',
          'works': {'phi001': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0067': {'author': 'Favorinus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0866': {'author': 'Fenestella',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi1236': {'author': 'Sex. Pompeius Festus',
          'works': {'phi001': {'title': 'De Verborum Significatione',
                            'source': 'Sexti Pompei Festi De Verborum Significatu Quae Supersunt cum Pauli Epitome, ed. W. M. Lindsay, 1913',
                            'meta': 'page-line'}}},
 'phi1242': {'author': 'Annius Florus. epist. ad imperat',
          'works': {'phi001': {'title': 'DCC',
                            'source': 'L. Annaei Flori Quae Exstant, ed. E. Malcovati, 1972',
                            'meta': 'book-chapter-line'},
                    'phi002': {'title': 'Vergilius Orator an Poeta',
                            'source': 'L. Annaei Flori Quae Exstant, ed. E. Malcovati, 1972',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'carmina in Anthologia Latina',
                            'source': 'Anthologia Latina. Vol. 1, Fasc. 1, ed. D. R. Shackleton Bailey, 1982',
                            'meta': 'poem-verse'},
                    'phi004': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi005': {'title': 'Hadrianum',
                            'source': 'L. Annaei Flori Quae Exstant, ed. E. Malcovati, 1972',
                            'meta': 'fragment-line'}}},
 'phi1377': {'author': 'Fragmenta Bobiensia',
          'works': {'phi001': {'title': 'De Littera',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi002': {'title': 'De Accentibus',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi003': {'title': 'De Propriis Nominibus',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi004': {'title': 'De Nomine',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi005': {'title': 'De Versibus',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'},
                    'phi006': {'title': 'De Finalibus Syllabis',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'},
                    'phi007': {'title': 'De Structuris',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'},
                    'phi008': {'title': 'De Metris',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'page-line'}}},
 'phi1506': {'author': 'Anonymi Fragmenta de Iure Fisci',
          'works': {'phi001': {'title': 'fragmenta de iure fisci',
                            'source': 'Fontes Iuris Romani Antejustiniani. Part 2, ed. J. Baviera, 1940',
                            'meta': 'section-line'}}},
 'phi1245': {'author': 'Sex. Iulius Frontinus',
          'works': {'phi001': {'title': 'Strategemata',
                            'source': 'Frontin Kriegslisten, ed. G. Bendz, 1963',
                            'meta': 'book-chapter-section-line'},
                    'phi002': {'title': 'De Aquis Urbis Romae',
                            'source': 'Sex. Iulii Frontini De Aquaeductu Urbis Romae, ed. C. Kunderewicz, 1973',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'De Agrorum Qualitate',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'},
                    'phi004': {'title': 'De Controversiis',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'},
                    'phi005': {'title': 'De Limitibus',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'},
                    'phi006': {'title': 'De Arte Mensoria',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'}}},
 'phi2335': {'author': 'Anonymi de Differentiis',
          'works': {'phi001': {'title': '[Fronto] De Differentiis',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'}}},
 'phi1248': {'author': 'M. Cornelius Fronto',
          'works': {'phi001': {'title': 'Epist.',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'book-letter-section-line'},
                    'phi002': {'title': 'Epist.',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'book-letter-section-line'},
                    'phi003': {'title': 'Epistulae',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'book-letter-section-line'},
                    'phi004': {'title': 'De Eloquentia',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'letter-section-line'},
                    'phi005': {'title': 'De Orationibus',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'section-line'},
                    'phi006': {'title': 'Ad Antoninum Pium Epistulae',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'letter-section-line'},
                    'phi007': {'title': 'Ad Amicos Epistulae',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'book-letter-section-line'},
                    'phi008': {'title': 'Principia Historiae',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'letter-section-line'},
                    'phi009': {'title': 'Laudes Fumi et Pulveris',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'section-line'},
                    'phi010': {'title': 'Laudes Neglegentiae',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'section-line'},
                    'phi011': {'title': 'De Bello Parthico',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'section-line'},
                    'phi012': {'title': 'De Feriis Alsiensibus',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'letter-section-line'},
                    'phi013': {'title': 'De Nepote Amisso',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'letter-section-line'},
                    'phi014': {'title': 'Arion',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'section-line'},
                    'phi015': {'title': 'Aceph.',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'letter-section-line'},
                    'phi016': {'title': 'fragmenta',
                            'source': 'M. Cornelii Frontonis Epistulae. Vol. 1, ed. M. P. J. van den Hout, 1954',
                            'meta': 'fragment-line'},
                    'phi017': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0518': {'author': 'A. Furius Antias',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0875': {'author': 'Cn. Cornelius Lentulus Gaetulicus',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi1251': {'author': 'Gaius',
          'works': {'phi001': {'title': 'Institutiones',
                            'source': 'Gai Institutiones, ed. E. Seckel; B. Kübler, 1935',
                            'meta': 'book-chapter-line'},
                    'phi002': {'title': 'Institutionum frr. Aeg. et Oxyrh.',
                            'source': 'Fontes Iuris Romani Antejustiniani. Part 2, ed. J. Baviera, 1940',
                            'meta': 'book-section-line'},
                    'phi004': {'title': 'Gai Institutionum epitome',
                            'source': 'Fontes Iuris Romani Antejustiniani. Part 2, ed. J. Baviera, 1940',
                            'meta': 'book-title-section-line'}}},
 'phi0522': {'author': 'C. Aelius Gallus',
          'works': {'phi001': {'title': 'De Verbis ad Ius Civile',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'iurisprudentia, fragmenta',
                            'source': 'The Digest of Justinian. Vol. 4, ed. T. Mommsen, P. Krüger, A. Watson, 1985',
                            'meta': 'fragment-line'}}},
 'phi0878': {'author': 'C. Asinius Gallus',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi002': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta Aetatis Caesareae. Vol. 1, ed. A. Mazzarino, 1955',
                            'meta': 'line'}}},
 'phi0524': {'author': 'C. Cornelius Gallus. elegia in pap',
          'works': {'phi001': {'title': 'elegia',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi002': {'title': 'Qas?r Ibrîm',
                            'source': 'ed. R. D. Anderson, P. J. Parsons, R. G. M. Nisbet [JRS 69(1979)]',
                            'meta': 'column-verse'}}},
 'phi0527': {'author': 'Gannius',
          'works': {'phi001': {'title': 'sine nomine',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0413': {'author': 'Gavius Bassus',
          'works': {'phi001': {'title': 'De Origine Vocabulorum, frr.',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'fragmentum',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'line'}}},
 'phi1254': {'author': 'A. Gellius',
          'works': {'phi001': {'title': 'Noctes Atticae 1-20',
                            'source': 'A. Gelli Noctes Atticae. Vols. 1-2, ed. K. Marshall, 1968',
                            'meta': 'book-chapter-section-line'}}},
 'phi0070': {'author': 'Cn. Gellius',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi0881': {'author': 'Claudius Caesar Germanicus',
          'works': {'phi001': {'title': 'Aratea',
                            'source': 'The Aratus ascribed to Germanicus Caesar, ed. D. B. Gain, 1976',
                            'meta': 'verse'},
                    'phi002': {'title': 'fragmenta Aratea',
                            'source': 'The Aratus ascribed to Germanicus Caesar, ed. D. B. Gain, 1976',
                            'meta': 'fragment-verse'},
                    'phi003': {'title': 'epigrammata',
                            'source': 'Germanici Caesaris Aratea, ed. A. Breysig, 1899',
                            'meta': 'poem-verse'}}},
 'phi0526': {'author': 'C. Servilius Glaucia',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0315': {'author': 'M. Iunius Gracchanus',
          'works': {'phi001': {'title': 'commentarii',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0073': {'author': 'C. Sempronius Gracchus',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0884': {'author': 'Gracchus',
          'works': {'phi001': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi0528': {'author': 'Granius Flaccus',
          'works': {'phi001': {'title': 'iurisprudentia',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi1257': {'author': 'Granius Licinianus',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Grani Liciniani Reliquiae, ed. N. Criniti, 1981',
                            'meta': 'book-sentence-line'}}},
 'phi0887': {'author': 'Grattius',
          'works': {'phi001': {'title': 'Cynegetica',
                            'source': 'Gratti Cynegeticon Quae Supersunt. Part 1, ed. P. J. Enk, 1918',
                            'meta': 'verse'}}},
 'phi1260': {'author': 'Hadrianus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'orationes',
                            'source': 'Flavii Sosipatri Charisii Artis Grammaticae Libri V, ed. K. Barwick, 1964',
                            'meta': 'fragment-line'}}},
 'phi0076': {'author': 'C. Cassius Hemina',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi2434': {'author': 'Hilarius Arelatensis',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0530': {'author': 'A. Hirtius',
          'works': {'phi001': {'title': 'De Bello Gallico Liber VIII',
                            'source': 'C. Iulii Caesaris: Commentarii Rerum Gestarum. Vol. 1, ed. O. Seel, 1961',
                            'meta': 'book-chapter-section-line'},
                    'phi002': {'title': 'epistulae',
                            'source': 'C. Iuli Caesaris Commentarii. Vol. 3, ed. A. Klotz, 1927',
                            'meta': 'fragment-line'}}},
 'phi0890': {'author': 'Homerus Latinus',
          'works': {'phi001': {'title': 'Ilias Latina',
                            'source': 'Poetae Latini Minores. Vol. 2, Fasc. 3, ed. F. Vollmer, 1913',
                            'meta': 'verse'}}},
 'phi0893': {'author': 'Q. Horatius Flaccus',
          'works': {'phi001': {'title': 'Carmina',
                            'source': 'Q. Horati Flacci Opera, ed. F. Klingner, 1959',
                            'meta': 'book-poem-verse'},
                    'phi002': {'title': 'Carmen Saeculare',
                            'source': 'Q. Horati Flacci Opera, ed. F. Klingner, 1959',
                            'meta': 'verse'},
                    'phi003': {'title': 'Epodi',
                            'source': 'Q. Horati Flacci Opera, ed. F. Klingner, 1959',
                            'meta': 'poem-verse'},
                    'phi004': {'title': 'Sermones',
                            'source': 'Q. Horati Flacci Opera, ed. F. Klingner, 1959',
                            'meta': 'book-poem-verse'},
                    'phi005': {'title': 'Epistulae',
                            'source': 'Q. Horati Flacci Opera, ed. F. Klingner, 1959',
                            'meta': 'book-poem-verse'},
                    'phi006': {'title': 'Ars Poetica',
                            'source': 'Q. Horati Flacci Opera, ed. F. Klingner, 1959',
                            'meta': 'verse'}}},
 'phi0532': {'author': 'Q. Hortensius Hortalus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0079': {'author': 'Hostius',
          'works': {'phi001': {'title': 'Bellum Histricum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0899': {'author': 'Hyginus Astronomus',
          'works': {'phi001': {'title': 'Astronomica',
                            'source': "Hygin: L'Astronomie, ed. A. Le Boeuffle, 1983",
                            'meta': 'book-chapter-section-line'}}},
 'phi0533': {'author': 'C. Iulius Hyginus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi1266': {'author': 'Hyginus Gromaticus. De Munition',
          'works': {'phi001': {'title': 'De Limitibus',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'},
                    'phi002': {'title': 'De Condicionibus Agrorum',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'},
                    'phi003': {'title': 'De Generibus Controversiarum',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'},
                    'phi004': {'title': 'Constitutio Limitum [sp.]',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'},
                    'phi005': {'title': 'Castrorum [sp.]',
                            'source': 'Pseudo-Hygin: Des Fortifications du Camp, ed. M. Lenoir, 1979',
                            'meta': 'chapter-line'}}},
 'phi1263': {'author': 'Hyginus',
          'works': {'phi001': {'title': 'Fabulae',
                            'source': 'Hygini Fabulae, ed. H. J. Rose, 1933',
                            'meta': 'fable-section-line'}}},
 'phi0091': {'author': 'Licinius Imbrex',
          'works': {'phi001': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi2806': {'author': 'Iustinianus',
          'works': {'phi002': {'title': 'Digesta Iustiniani 1-50',
                            'source': 'The Digest of Justinian. Vols. 1-4, ed. T. Mommsen, P. Krüger, A. Watson, 1985',
                            'meta': 'book-chap-par-sect-line'}}},
 'phi1276': {'author': 'D. Iunius Iuvenalis',
          'works': {'phi001': {'title': 'Saturae',
                            'source': 'A. Persi Flacci et D. Iuni Iuvenalis Saturae, ed. W. V. Clausen, 1959',
                            'meta': 'poem-verse'}}},
 'phi0535': {'author': 'M. Iuventius Laterensis',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0534': {'author': 'Iuventius',
          'works': {'phi001': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0908': {'author': 'Attius Labeo',
          'works': {'phi001': {'title': 'versio Latina Iliados',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0905': {'author': 'M. Antistius Labeo',
          'works': {'phi002': {'title': 'iurisprudentia, fragmenta',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0536': {'author': 'D. Laberius',
          'works': {'phi001': {'title': 'mimi',
                            'source': 'I Mimi Romani, ed. M. Bonaria, 1965',
                            'meta': 'verse'}}},
 'phi0537': {'author': 'T. Labienus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1279': {'author': 'Laelius Felix',
          'works': {'phi001': {'title': 'iurisprudentia, fragmenta',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0085': {'author': 'C. Laelius Sapiens',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0538': {'author': 'Laevius. fr',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'dubium a Morel omissum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. C. Büchner, 1982',
                            'meta': 'fragment-verse'}}},
 'phi0100': {'author': 'Luscius Lanuvinus',
          'works': {'phi001': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi1011': {'author': 'Scribonius Largus',
          'works': {'phi001': {'title': 'Compositiones',
                            'source': 'Scribonii Largi Compositiones, ed. S. Sconocchia, 1983',
                            'meta': 'chapter-line'}}},
 'phi0540': {'author': 'Tullius Laurea',
          'works': {'phi001': {'title': 'epigramma in Ciceronis obitum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0911': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Laus Pisonis',
                            'source': 'Laus Pisonis: Text, Übersetzung, Kommentar: Inaugural-Dissertation der Philosophischen Fakultät der Friedrich-Alexander-Universität, Erlangen-Nürnberg, ed. A. Seel, 1969',
                            'meta': 'verse'}}},
 'phi0541': {'author': 'Cn. Cornelius Lentulus Marcellinus',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1282': {'author': 'Lentulus',
          'works': {'phi001': {'title': 'mimus',
                            'source': 'I Mimi Romani, ed. M. Bonaria, 1965',
                            'meta': 'verse'}}},
 'phi0088': {'author': 'M. Aemilius Lepidus Porcina',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0914': {'author': 'T. Livius. A.U.C. Perioch',
          'works': {'phi001': {'title': 'Ab Urbe Condita',
                            'source': 'Bks. 1-5: Titi Livi Ab Urbe Condita. Vol. 1, ed. R. S. Conway; C. F. Walters, 1955; Bks. 6-10, 21-25: Ibid. Vols. 2-3, ed. C. F. Walters; R. S. Conway, 1919-1950; Bks. 26-30: Ibid. Vol. 4, ed. R. S. Conway, S. K. Johnson, 1953; Bks. 31-35: Ibid. Vol. 5, ed. A. H. McDonald, 1969; Bks. 36-40: Ibid. Part 3, ed. W. Weissenborn; M. Mueller, n.d.; Bks. 41-45: Ibid. Part 4, ed. W. Weissenborn; W. Heraeus, 1908',
                            'meta': 'book-chapter-section-line'},
                    'phi002': {'title': 'C.',
                            'source': 'T. Livi Ab Urbe Condita. Part 4, Bks. 41-45, ed. O. Rossbach, 1910',
                            'meta': 'book-line'},
                    'phi003': {'title': 'fragmenta',
                            'source': 'Tite-Live: Histoire Romaine. Vol. 33, ed. P. Jal, 1979',
                            'meta': 'fragment-line'},
                    'phi004': {'title': 'ex P.Oxy.668',
                            'source': "Abrégés des Livres de l'Histoire Romaine de Tite-Live. Vol. 34, Part 2, ed. P. Jal, 1984",
                            'meta': 'book-line'}}},
 'phi0917': {'author': 'M. Annaeus Lucanus',
          'works': {'phi001': {'title': 'Bellum Civile',
                            'source': 'M. Annaei Lucani Belli Civilis Libri Decem, ed. A. E. Housman, 1927',
                            'meta': 'book-verse'},
                    'phi002': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0097': {'author': 'C. Lucilius',
          'works': {'phi001': {'title': 'Saturae, fragmenta',
                            'source': 'C. Lucilii Carminum Reliquiae. Vol. 1, ed. F. Marx, 1904',
                            'meta': 'satire-verse'}}},
 'phi0920': {'author': 'Lucilius iunior',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0550': {'author': 'T. Lucretius Carus',
          'works': {'phi001': {'title': 'De Rerum Natura',
                            'source': 'De Rerum Natura Libri Sex, ed. J. Martin, 1969',
                            'meta': 'book-verse'},
                    'phi002': {'title': 'fragmenta',
                            'source': 'De Rerum Natura Libri Sex, ed. J. Martin, 1969',
                            'meta': 'fragment-verse'},
                    'phi003': {'title': 'capitula',
                            'source': 'De Rerum Natura Libri Sex, ed. J. Martin, 1969',
                            'meta': 'book-line'}}},
 'phi0552': {'author': 'Q. Lutatius Catulus',
          'works': {'phi001': {'title': 'epigrammata',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'Communes Historiae',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0923': {'author': 'Aemilius Macer',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'fragmentum a Morel omissum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. C. Büchner, 1982',
                            'meta': 'fragment-verse'}}},
 'phi0556': {'author': 'C. Licinius Macer',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0558': {'author': 'C. Maecenas',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'fragmentum a Morel omissum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. C. Büchner, 1982',
                            'meta': 'fragment-verse'}}},
 'phi1285': {'author': 'L. Volusius Maecianus',
          'works': {'phi001': {'title': 'Assis Distributio ...',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'chapter-line'}}},
 'phi0560': {'author': 'Helvius Mancia',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0564': {'author': "M'. Manilius",
          'works': {'phi001': {'title': 'iurisprudentia',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0926': {'author': 'M. Manilius',
          'works': {'phi001': {'title': 'Astronomica',
                            'source': 'M. Manilii Astronomica, ed. G. P. Goold, 1985',
                            'meta': 'book-verse'}}},
 'phi0562': {'author': 'Manilius',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0103': {'author': 'Cn. Marcius vates',
          'works': {'phi001': {'title': 'Praecepta',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi1291': {'author': 'Marianus',
          'works': {'phi001': {'title': 'Lupercalia',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi1294': {'author': 'M. Valerius Martialis',
          'works': {'phi001': {'title': 'Spectacula',
                            'source': 'M. Valerii Martialis Epigrammaton Libri, ed. W. Heraeus; J. Borovskij',
                            'meta': 'poem-verse'},
                    'phi002': {'title': 'Epigrammata',
                            'source': 'M. Valerii Martialis Epigrammaton Libri, ed. W. Heraeus; J. Borovskij',
                            'meta': 'book-poem-verse'}}},
 'phi1297': {'author': 'Marullus',
          'works': {'phi001': {'title': 'mimi',
                            'source': 'I Mimi Romani, ed. M. Bonaria, 1965',
                            'meta': 'verse'}}},
 'phi0568': {'author': 'Cn. Matius',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi1518': {'author': 'Terentianus Maurus',
          'works': {'phi001': {'title': 'De Litt., De Syll., De Metr.',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 6, ed. H. Keil, 1874',
                            'meta': 'verse'}}},
 'phi0929': {'author': 'Pomponius Mela',
          'works': {'phi001': {'title': 'De Chorographia',
                            'source': 'Pomponii Melae De Chorographia Libri Tres una cum Indice Verborum, ed. G. Ranstrand, 1971',
                            'meta': 'book-section-line'}}},
 'phi0104': {'author': 'C. Memmius',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0574': {'author': 'C. Memmius L. f.',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0932': {'author': 'M. Valerius Messalla Corvinus',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'Commentarii de Bello Civili',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0576': {'author': 'M. Valerius Messalla Rufus',
          'works': {'phi001': {'title': 'De Familiis Romanis',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'De Auspiciis',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0106': {'author': 'Caecilius Metellus',
          'works': {'phi001': {'title': 'versus in Naevium',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0109': {'author': 'Q. Caecilius Metellus Macedonicus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0582': {'author': 'Q. Caecilius Metellus Numidicus',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0584': {'author': 'Mimi Poetarum Incertorum',
          'works': {'phi001': {'title': 'mimi',
                            'source': 'I Mimi Romani, ed. M. Bonaria, 1965',
                            'meta': 'verse'},
                    'phi002': {'title': 'fragmenta dubia',
                            'source': 'I Mimi Romani, ed. M. Bonaria, 1965',
                            'meta': 'verse'}}},
 'phi0935': {'author': 'Iulius Modestus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta Aetatis Caesareae. Vol. 1, ed. A. Mazzarino, 1955',
                            'meta': 'fragment-line'}}},
 'phi0938': {'author': 'Iulius Montanus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0546': {'author': 'C. Licinius Mucianus',
          'works': {'phi001': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0586': {'author': 'Mummius',
          'works': {'phi001': {'title': 'Atellanae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0112': {'author': 'Cn. Naevius',
          'works': {'phi001': {'title': 'Bellum Punicum',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'alia carmina epica',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi003': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'},
                    'phi004': {'title': 'praetextae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi005': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi006': {'title': 'a Morel omissa',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. C. Büchner, 1982',
                            'meta': 'fragment-verse'},
                    'phi007': {'title': 'versus in Metellos [sp.]',
                            'source': 'Ciceronis Orationum Scholiastae. Vol. 2, ed. T. Stangl, 1912',
                            'meta': 'verse'}}},
 'phi0587': {'author': 'Naevius',
          'works': {'phi001': {'title': 'Ilias',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0420': {'author': 'P. Aufidius Namusa',
          'works': {'phi001': {'title': 'iurisprudentia',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0588': {'author': 'Cornelius Nepos',
          'works': {'phi001': {'title': 'Vitae',
                            'source': 'Cornelii Nepotis Vitae cum Fragmentis, ed. P. K. Marshall, 1977',
                            'meta': 'life-chapter-section-line'},
                    'phi002': {'title': 'fragmenta',
                            'source': 'Cornelii Nepotis Vitae cum Fragmentis, ed. P. K. Marshall, 1977',
                            'meta': 'fragment-line'}}},
 'phi1306': {'author': 'L. Neratius Priscus. fr',
          'works': {'phi002': {'title': 'in fragmentis Vaticanis',
                            'source': 'Fontes Iuris Romani Antejustiniani. Part 2, ed. J. Baviera, 1940',
                            'meta': 'section-line'}}},
 'phi0944': {'author': 'Imperator Nero',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0590': {'author': 'P. Nigidius Figulus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0591': {'author': 'Ninnius Crassus',
          'works': {'phi001': {'title': 'Ilias',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0594': {'author': 'L. Novius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0592': {'author': 'Novius',
          'works': {'phi001': {'title': 'Atellanae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0596': {'author': 'Numitorius',
          'works': {'phi001': {'title': 'Antibucolica',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0600': {'author': 'C. Oppius',
          'works': {'phi001': {'title': 'de re rustica scripta',
                            'source': 'Scriptorum Romanorum De Re Rustica Reliquiae. Vol. 1, ed. F. Speranza, 1974',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'vitae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0419': {'author': 'L. Orbilius Pupillus',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0959': {'author': 'P. Ovidius Naso',
          'works': {'phi001': {'title': 'Amores',
                            'source': 'Ovid in Six Volumes. Vol. 1, ed. G. Showerman; G. P. Goold, 1977',
                            'meta': 'book-poem-verse'},
                    'phi002': {'title': 'Epistulae (vel Heroides)',
                            'source': 'Ovid in Six Volumes. Vol. 1, ed. G. Showerman; G. P. Goold, 1977',
                            'meta': 'poem-verse'},
                    'phi003': {'title': 'Medicamina Faciei Femineae',
                            'source': 'Ovid in Six Volumes.Vol. 2, ed. J. H. Mozley; G. P. Goold, 1979',
                            'meta': 'verse'},
                    'phi004': {'title': 'Ars Amatoria',
                            'source': 'Ovid in Six Volumes. Vol. 2, ed. J. H. Mozley; G. P. Goold, 1979',
                            'meta': 'book-verse'},
                    'phi005': {'title': 'Remedia Amoris',
                            'source': 'Ovid in Six Volumes. Vol. 2, ed. J. H. Mozley; G. P. Goold, 1979',
                            'meta': 'verse'},
                    'phi006': {'title': 'Metamorphoses',
                            'source': 'Ovid: Metamorphoses in Two Volumes. ed. F. J. Miller; G. P. Goold, 1977-1984',
                            'meta': 'book-verse'},
                    'phi007': {'title': 'Fasti',
                            'source': 'P. Ovidi Nasonis Fastorum Libri Sex, ed. E. H. Alton; D. E. W. Wormell; E. Courtney, 1978',
                            'meta': 'book-verse'},
                    'phi008': {'title': 'Tristia',
                            'source': 'P. Ovidius Naso: Tristia. Vol. 1, ed. G. Luck, 1967',
                            'meta': 'book-poem-verse'},
                    'phi009': {'title': 'Epistulae ex Ponto',
                            'source': 'Pontiques, ed. J. André, 1977',
                            'meta': 'book-poem-verse'},
                    'phi010': {'title': 'Ibis',
                            'source': 'Ovid in Six Volumes. Vol. 2, ed. J. H. Mozley; G. P. Goold, 1979',
                            'meta': 'verse'},
                    'phi011': {'title': 'Medea',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi012': {'title': 'carmina, fragmenta',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi013': {'title': 'Nux [sp.]',
                            'source': 'Ovid in Six Volumes. Vol. 2, ed. J. H. Mozley; G. P. Goold, 1979',
                            'meta': 'verse'},
                    'phi014': {'title': 'Halieutica [sp.]',
                            'source': 'Ovid in Six Volumes. Vol. 2, ed. J. H. Mozley; G. P. Goold, 1979',
                            'meta': 'verse'},
                    'phi015': {'title': 'Epicedion Drusi [sp.]',
                            'source': 'Ovid in Six Volumes. Vol. 2, ed. J. H. Mozley; G. P. Goold, 1979',
                            'meta': 'verse'}}},
 'phi2097': {'author': 'Sex. Paconianus',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0116': {'author': 'M. Pacuvius',
          'works': {'phi001': {'title': 'praetextae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi002': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi0963': {'author': 'Q. Remmius Palaemon',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta Aetatis Caesareae. Vol. 1, ed. A. Mazzarino, 1955',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'Ars [sp.]',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 5, ed. H. Keil, 1868',
                            'meta': 'page-line'}}},
 'phi0117': {'author': 'Papinius',
          'works': {'phi001': {'title': 'Epigrammation',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi2456': {'author': 'Parthenius Presbyter',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0966': {'author': 'Passienus Crispus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'M. Fabi Quintiliani Institutionis Oratoriae Libri Duodecim. Vol. 1, ed. M. Winterbottom, 1970',
                            'meta': 'line'}}},
 'phi0118': {'author': 'L. Aemilius L. f. M. n. Paulus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi9221': {'author': 'Paulus Quaestor',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0800': {'author': 'Albinovanus Pedo',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0969': {'author': 'A. Persius Flaccus',
          'works': {'phi001': {'title': 'Saturae',
                            'source': 'A. Persi Flacci et D. Iuni Iuvenalis Saturae, ed. W. V. Clausen, 1959',
                            'meta': 'poem-verse'}}},
 'phi0972': {'author': 'Petronius',
          'works': {'phi001': {'title': 'Satyrica',
                            'source': 'Petronius: Satyrica, ed. K. Müller; W. Ehlers, 1983',
                            'meta': 'chapter-section-line'},
                    'phi002': {'title': 'Satyrica, fragmenta',
                            'source': 'Petronius: Satyrica, ed. K. Müller; W. Ehlers, 1983',
                            'meta': 'fragment-line'}}},
 'phi0975': {'author': 'Phaedrus',
          'works': {'phi001': {'title': 'Fabulae Aesopiae',
                            'source': 'Phaedri Augusti Liberti Liber Fabularum, ed. A. Guaglianone, 1969',
                            'meta': 'book-poem-verse'},
                    'phi002': {'title': 'Fabularum Appendix',
                            'source': 'Phaedri Augusti Liberti Liber Fabularum, ed. A. Guaglianone, 1969',
                            'meta': 'poem-verse'}}},
 'phi0606': {'author': 'L. Marcius Philippus',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1380': {'author': 'Philumenus medicus',
          'works': {'phi001': {'title': 'De medicina, versio Latina',
                            'source': 'Die lateinischen Fragmente des Philumenus und Philagrius. ed. P. Mihaileanu, 1911',
                            'meta': 'chapter-page-line'}}},
 'phi0119': {'author': 'T. Maccius Plautus',
          'works': {'phi001': {'title': 'Amphitruo',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi002': {'title': 'Asinaria',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi003': {'title': 'Aulularia',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi004': {'title': 'Bacchides',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi005': {'title': 'Captivi',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi006': {'title': 'Casina',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi007': {'title': 'Cistellaria',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi008': {'title': 'Curculio',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi009': {'title': 'Epidicus',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi010': {'title': 'Menaechmi',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi011': {'title': 'Mercator',
                            'source': 'Plauti Comoediae. Vol. 1, ed. F. Leo, 1895',
                            'meta': 'verse'},
                    'phi012': {'title': 'Miles Gloriosus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi013': {'title': 'Mostellaria',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi014': {'title': 'Persa',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi015': {'title': 'Poenulus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi016': {'title': 'Pseudolus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi017': {'title': 'Rudens',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi018': {'title': 'Stichus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi019': {'title': 'Trinummus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi020': {'title': 'Truculentus',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi021': {'title': 'Vidularia',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'verse'},
                    'phi022': {'title': 'fragmenta',
                            'source': 'Plauti Comoediae. Vol. 2, ed. F. Leo, 1896',
                            'meta': 'play-fragment-verse'}}},
 'phi1318': {'author': 'C. Plinius Caecilius Secundus',
          'works': {'phi001': {'title': 'Epistulae',
                            'source': 'C. Plini Caecili Secundi Epistularum Libri Decem, ed. R. A. B. Mynors, 1966',
                            'meta': 'book-letter-section-line'},
                    'phi002': {'title': 'Panegyricus',
                            'source': 'XII Panegyrici Latini, ed. R. A. B. Mynors, 1964',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'versus',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0978': {'author': 'C. Plinius Secundus',
          'works': {'phi001': {'title': 'Naturalis Historia',
                            'source': 'C. Plini Secundi Naturalis Historiae Libri XXXVII. Vols. 1-5, ed. C. Mayhoff, 1892-1909',
                            'meta': 'book-section-line'},
                    'phi002': {'title': 'Dubius Sermo',
                            'source': 'Il Dubius Sermo di Plinio, ed. A. Della Casa, 1969',
                            'meta': 'fragment-line'}}},
 'phi0981': {'author': 'C. Asinius Pollio',
          'works': {'phi006': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi003': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'},
                    'phi004': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi005': {'title': 'historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0614': {'author': 'Q. Pompeius Q. f. A. n. Rufus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0615': {'author': 'Q. Pompeius Q. f. Q. n. Rufus',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0616': {'author': 'Pompilius',
          'works': {'phi001': {'title': 'epigramma',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi002': {'title': 'tragoedia',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi0618': {'author': 'L. Pomponius Bononiensis',
          'works': {'phi001': {'title': 'Atellanae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0987': {'author': 'P. Pomponius Secundus',
          'works': {'phi001': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi002': {'title': 'praetextae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi1321': {'author': 'Sex. Pomponius',
          'works': {'phi002': {'title': 'Liber Regularum, fragmentum',
                            'source': 'Fontes Iuris Romani Antejustiniani. Part 2, ed. J. Baviera, 1940',
                            'meta': 'line'}}},
 'phi0321': {'author': 'Porcius Licinus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi1512': {'author': 'Pomponius Porphyrio',
          'works': {'phi001': {'title': 'Commentum in Horati Carmina',
                            'source': 'Pomponi Porfyrionis Commentum in Horatium Flaccum, ed. A. Holder, 1894',
                            'meta': 'book-ode-lemma-line'},
                    'phi002': {'title': 'Artem Poet.',
                            'source': 'Pomponi Porfyrionis Commentum in Horatium Flaccum, ed. A. Holder, 1894',
                            'meta': 'lemma-line'},
                    'phi003': {'title': 'Saec.',
                            'source': 'Pomponi Porfyrionis Commentum in Horatium Flaccum, ed. A. Holder, 1894',
                            'meta': 'lemma-line'},
                    'phi004': {'title': 'Commentum in Horati Epodos',
                            'source': 'Pomponi Porfyrionis Commentum in Horatium Flaccum, ed. A. Holder, 1894',
                            'meta': 'epode-lemma-line'},
                    'phi005': {'title': 'Commentum in Horati Sermones',
                            'source': 'Pomponi Porfyrionis Commentum in Horatium Flaccum, ed. A. Holder, 1894',
                            'meta': 'book-poem-lemma-line'},
                    'phi006': {'title': 'Commentum in Horati Epistulas',
                            'source': 'Pomponi Porfyrionis Commentum in Horatium Flaccum, ed. A. Holder, 1894',
                            'meta': 'book-poem-lemma-line'},
                    'phi007': {'title': 'Vita Horati',
                            'source': 'Pomponi Porfyrionis Commentum in Horatium Flaccum, ed. A. Holder, 1894',
                            'meta': 'line'}}},
 'phi0122': {'author': 'A. Postumius Albinus',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi0990': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Precatio Omnium Herbarum',
                            'source': 'Anthologia Latina. Part 1, Vol. 1, ed. A. Riese, 1904',
                            'meta': 'verse'}}},
 'phi0993': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Precatio Terrae',
                            'source': 'Anthologia Latina. Part 1, Fasc. 1, ed. A. Riese, 1894',
                            'meta': 'verse'}}},
 'phi1103': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Priapea',
                            'source': 'Poetae Latini Minores. Vol. 2, Fasc. 2, ed. F. Vollmer, 1923',
                            'meta': 'poem-verse'}}},
 'phi0996': {'author': 'M. Valerius Probus',
          'works': {'phi001': {'title': 'Vita Persii',
                            'source': 'A. Persi Flacci et D. Iuni Iuvenalis Saturae, ed. W. V. Clausen, 1959',
                            'meta': 'line'},
                    'phi002': {'title': 'De Notis Iuris',
                            'source': 'Fontes Iuris Romani Antejustiniani. Part 2, ed. J. Baviera, 1940',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'fragmenta',
                            'source': 'De M. Valerio Probo Berytio Capita Quattuor, Accedit Reliquiarum Conlectio, ed. J. Aistermann, 1910',
                            'meta': 'fragment-line'}}},
 'phi0620': {'author': 'Sex. Propertius',
          'works': {'phi001': {'title': 'Elegiae',
                            'source': 'ed. G. P. Goold, forthcoming',
                            'meta': 'book-poem-verse'}}},
 'phi2123': {'author': 'Publilius Optatianus Porfyrius',
          'works': {'phi003': {'title': 'Epigrammata',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0622': {'author': 'Publilius Syrus',
          'works': {'phi001': {'title': 'Sententiae',
                            'source': 'Publilii Syri Mimi Sententiae, ed. W. Meyer, 1880',
                            'meta': 'letter-verse'},
                    'phi002': {'title': 'mimi',
                            'source': 'I Mimi Romani, ed. M. Bonaria, 1965',
                            'meta': 'verse'}}},
 'phi1000': {'author': 'Pupius (?)',
          'works': {'phi001': {'title': 'Versus Pupio Attributi',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0624': {'author': 'Q. Claudius Quadrigarius',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi0625': {'author': 'L. Quinctius',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1002': {'author': 'M. Fabius Quintilianus',
          'works': {'phi001': {'title': 'Institutio Oratoria',
                            'source': 'M. Fabi Quintiliani Institutionis Oratoriae Libri Duodecim. Vols. 1-2, ed. M. Winterbottom, 1970',
                            'meta': 'book-chapter-section-line'},
                    'phi002': {'title': 'Declamationes Minores',
                            'source': 'The Minor Declamations Ascribed to Quintilian, ed. M. Winterbottom, 1984',
                            'meta': 'oration-section-line'},
                    'phi003': {'title': 'Declamationes Maiores [sp.]',
                            'source': 'Declamationes XIX Maiores Quintiliano Falso Ascriptae, ed. L. Håkanson, 1982',
                            'meta': 'oration-section-line'}}},
 'phi1005': {'author': 'Rabirius',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0425': {'author': 'P. Rutilius Lupus',
          'works': {'phi001': {'title': 'Schemata Lexeos',
                            'source': 'Rhetores Latini Minores, ed. K. Halm, 1863',
                            'meta': 'book-chapter-line'}}},
 'phi0628': {'author': 'P. Rutilius Rufus',
          'works': {'phi001': {'title': 'De Vita Sua',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi1327': {'author': 'Sabidius',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'line'}}},
 'phi0630': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Sacra Argeorum',
                            'source': 'M. Terenti Varronis De Linguae Latinae Quae Supersunt, ed. G. Goetz; F. Schoell, 1910',
                            'meta': 'fragment-line'}}},
 'phi0631': {'author': 'C. Sallustius Crispus. In M',
          'works': {'phi001': {'title': 'Catilinae Coniuratio',
                            'source': 'C. Sallusti Crispi Catilina, Iugurtha, Fragmenta Ampliora, ed. A. Kurfess, 1957',
                            'meta': 'chapter-section-line'},
                    'phi002': {'title': 'Bellum Iugurthinum',
                            'source': 'C. Sallusti Crispi Catilina, Iugurtha, Fragmenta Ampliora, ed. A. Kurfess, 1957',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'Historiae',
                            'source': 'C. Sallusti Crispi Historiarum Reliquiae. Vol. 2, ed. B. Maurenbrecher, 1893',
                            'meta': 'book-fragment-line'},
                    'phi004': {'title': 'ampliora',
                            'source': 'C. Sallusti Crispi Catilina, Iugurtha, Fragmenta Ampliora, ed. A. Kurfess, 1957',
                            'meta': 'name-line'},
                    'phi005': {'title': 'e codicibus',
                            'source': 'C. Sallusti Crispi Catilina, Iugurtha, Fragmenta Ampliora, ed. A. Kurfess, 1957',
                            'meta': 'fragment-line'},
                    'phi006': {'title': 'e papyris',
                            'source': 'C. Sallusti Crispi Catilina, Iugurtha, Fragmenta Ampliora, ed. A. Kurfess, 1957',
                            'meta': 'fragment-line'},
                    'phi007': {'title': '[sp.]',
                            'source': 'Appendix Sallustiana. Fasc. 1, ed. A. Kurfess, 1970',
                            'meta': 'book-chapter-section-line'},
                    'phi008': {'title': 'Tullium Ciceronem [sp.]',
                            'source': 'Appendix Sallustiana. Fasc. 2, ed. A. Kurfess, 1970',
                            'meta': 'section-line'}}},
 'phi0634': {'author': 'Santra',
          'works': {'phi001': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'},
                    'phi002': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0324': {'author': 'Saserna',
          'works': {'phi001': {'title': 'de re rustica scripta',
                            'source': 'Scriptorum Romanorum De Re Rustica Reliquiae. Vol. 1, ed. F. Speranza, 1974',
                            'meta': 'fragment-line'}}},
 'phi0635': {'author': 'P. Saturius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0638': {'author': 'Q. Mucius Scaevola [pontifex]',
          'works': {'phi002': {'title': 'iurisprudentia, fragmenta',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0125': {'author': 'P. Mucius Scaevola',
          'works': {'phi001': {'title': 'fragmentum',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0636': {'author': 'Q. Mucius Scaevola',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi1336': {'author': 'Scaevus Memor',
          'works': {'phi001': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi0640': {'author': 'M. Aemilius Scaurus',
          'works': {'phi001': {'title': 'De Vita Sua',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi1370': {'author': 'Q. Terentius Scaurus. De ordinat. part. orat',
          'works': {'phi001': {'title': 'De Orthographia',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi002': {'title': 'De Adverbio et Praeposition.',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi003': {'title': 'in codice Parisino 7520',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'},
                    'phi004': {'title': '[sp.]',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'}}},
 'phi0128': {'author': 'P. Cornelius Scipio Aemilianus Africanus minor',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0127': {'author': 'P. Cornelius Scipio Africanus maior',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi0130': {'author': 'P. Cornelius Scipio Nasica Serapio',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi2331': {'author': 'Scriptores Historiae Augustae',
          'works': {'phi001': {'title': '<Aelii> Spartiani De Vita Hadriani',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi002': {'title': '<Aelii> Spartiani Aelius',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'Iuli Capitolini Antoninus Pius',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi004': {'title': 'Vita Marci Antonini Philosophi Iuli Capitolini',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi005': {'title': 'Iuli Capitolini Verus',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi006': {'title': 'Avidius <Cassius> Vulcacii Gallicani V.C.',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi007': {'title': '<Commodus> Antoninus Aeli Lampridii',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi008': {'title': '<Helvius> Pertinax Iuli Capitolini',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi009': {'title': 'Didius Iulianus Aeli Spartiani',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi010': {'title': 'Aeli Spartiani Severus',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi011': {'title': 'Pescennius Niger <Aeli Spartiani>',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi012': {'title': 'Vita Clodii Albini Iulii Capitolini',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi013': {'title': 'Antoninus Caracallus <Aeli Spartiani>',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi014': {'title': 'Antoninus Geta <Aeli Spartiani>',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi015': {'title': 'Opilius Macrinus Iuli Capitolini',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi016': {'title': 'Diadumenus Antoninus <Aelii> Lampridii',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi017': {'title': 'Aeli Lampridii Antoninus Heliogabalus',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi018': {'title': 'Alexander Severus Aeli Lampridii',
                            'source': 'Scriptores Historiae Augustae. Vol. 1, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi019': {'title': 'Maximini Duo Iuli Capitolini',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi020': {'title': 'Gordian<i Tr>es <Iuli Capitolini>',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi021': {'title': 'Maximus <et Balbinus Iuli Capitolini>',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi022': {'title': '<Trebelli Pollionis> Valeriani Duo',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi023': {'title': '<Trebelli Pollionis> Gallieni Duo',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi024': {'title': '<Trebelli Pollionis> Tyranni Triginta',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi025': {'title': '<Trebelli Pollionis> Divus Claudius',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi026': {'title': 'Flavi Vopisci Syracusii Divus Aurelianus',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi027': {'title': '<Flavi Vopisci Syracusii> Tacitus',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi028': {'title': '<Flavi Vopisci Syracusii> Probus',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi029': {'title': '<Flavi Vopisci Syracusii> Quadrigae Tyrannorum',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'},
                    'phi030': {'title': '<Flavi Vopisci Syracusii> Carus et Cari<nus> et Numerianus',
                            'source': 'Scriptores Historiae Augustae. Vol. 2, ed. E. Hohl, 1965',
                            'meta': 'chapter-section-line'}}},
 'phi1017': {'author': 'L. Annaeus Seneca iunior',
          'works': {'phi001': {'title': 'Hercules Furens',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi002': {'title': 'Troades',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi003': {'title': 'Phoenissae',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi004': {'title': 'Medea',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi005': {'title': 'Phaedra',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi006': {'title': 'Oedipus',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi007': {'title': 'Agamemnon',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi008': {'title': 'Thyestes',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi009': {'title': 'Hercules Oetaeus',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi010': {'title': 'Octavia [sp.]',
                            'source': 'L. Annaei Senecae Tragoediae, Incertorum Auctorum Hercules [Oetaeus], Octavia, ed. O. Zwierlein, 1987',
                            'meta': 'verse'},
                    'phi011': {'title': 'Apocolocyntosis',
                            'source': 'Seneca: Apocolocyntosis, ed. P. T. Eden, 1984',
                            'meta': 'chapter-section-line'},
                    'phi012': {'title': 'Dialogi',
                            'source': 'L. Annaei Senecae Dialogorum Libri Duodecim, ed. L. D. Reynolds, 1977',
                            'meta': 'book-chapter-section-line'},
                    'phi013': {'title': 'De Beneficiis',
                            'source': 'L. Annae Senecae Opera Quae Supersunt. Vol. 1, Fasc. 2, ed. C. Hosius, 1900',
                            'meta': 'book-chapter-section-line'},
                    'phi014': {'title': 'De Clementia',
                            'source': 'L. Annae Senecae Opera Quae Supersunt. Vol. 1, Fasc. 2, ed. C. Hosius, 1900',
                            'meta': 'book-chapter-section-line'},
                    'phi015': {'title': 'Epistulae Morales ad Lucilium',
                            'source': 'L. Annaei Senecae ad Lucilium Epistulae Morales. Vols. 1-2, ed. L. D. Reynolds, 1965',
                            'meta': 'letter-section-line'},
                    'phi016': {'title': 'Naturales Quaestiones',
                            'source': 'Sénèque, Questions Naturelles. Vols. 1-2, ed. P. Oltramare, 1929',
                            'meta': 'book-chapter-section-line'},
                    'phi017': {'title': 'E Cleanthe Versus',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi018': {'title': 'De Vita Patris',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi1014': {'author': 'L. Annaeus Seneca senior',
          'works': {'phi001': {'title': 'Controversiae',
                            'source': 'The Elder Seneca: Declamations in Two Volumes, ed. M. Winterbottom, 1974',
                            'meta': 'book-chapter-section-line'},
                    'phi002': {'title': 'Controversiae, excerpta',
                            'source': 'L. Annaei Senecae Oratorum et Rhetorum Sententiae Divisiones Colores, ed. H. J. Müller, 1887',
                            'meta': 'book-chapter-section-line'},
                    'phi003': {'title': 'Suasoriae',
                            'source': 'The Elder Seneca: Declamations in Two Volumes. Vol. 2, ed. M. Winterbottom, 1974',
                            'meta': 'chapter-section-line'},
                    'phi004': {'title': 'fragmenta',
                            'source': 'The Elder Seneca: Declamations in Two Volumes. Vol. 2, ed. M. Winterbottom, 1974',
                            'meta': 'fragment-line'}}},
 'phi1339': {'author': 'Septimius Serenus',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi1515': {'author': 'Q. Serenus (Sammonicus)',
          'works': {'phi001': {'title': 'Liber Medicinalis',
                            'source': 'Quinti Sereni Liber Medicinalis, ed. F. Vollmer, 1916',
                            'meta': 'chapter-verse'},
                    'phi002': {'title': 'Liber Medicinalis, capitula',
                            'source': 'Quinti Sereni Liber Medicinalis, ed. F. Vollmer, 1916',
                            'meta': 'line'}}},
 'phi2349': {'author': 'Maurus Servius Honoratus',
          'works': {'phi001': {'title': 'De Centum Metris',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 4, ed. H. Keil, 1864',
                            'meta': 'page-line'},
                    'phi002': {'title': 'Commentarius in Artem Donati',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 4, ed. H. Keil, 1864',
                            'meta': 'page-line'},
                    'phi003': {'title': 'De Finalibus',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 4, ed. H. Keil, 1864',
                            'meta': 'page-line'},
                    'phi004': {'title': 'De Metris Horatianis',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 4, ed. H. Keil, 1864',
                            'meta': 'page-line'},
                    'phi005': {'title': 'In Vergilii Aeneidos Libros',
                            'source': 'Servii Grammatici Qui Feruntur in Vergilii Carmina Commentarii. Vols. 1-2, ed. G. Thilo, 1878-1884',
                            'meta': 'book-verse-line'},
                    'phi006': {'title': 'In Vergilii Bucolicon Librum',
                            'source': 'Servii Grammatici Qui Feruntur in Vergilii Bucolica et Georgica Commentarii. Vol. 3:1, ed. G. Thilo, 1887',
                            'meta': 'poem-verse-line'},
                    'phi007': {'title': 'In Vergilii Georgicon Libros',
                            'source': 'Servii Grammatici Qui Feruntur in Vergilii Bucolica et Georgica Commentarii. Vol. 3:1, ed. G. Thilo, 1887',
                            'meta': 'book-verse-line'}}},
 'phi0642': {'author': 'Sevius Nicanor',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0644': {'author': 'Sextilius Ena',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi1342': {'author': 'Siculus Flaccus',
          'works': {'phi001': {'title': 'De Condicionibus Agrorum',
                            'source': 'Corpus Agrimensorum Romanorum, Opuscula Agrimensorum Veterum, ed. C. Thulin, 1971',
                            'meta': 'page-line'}}},
 'phi0082': {'author': 'D. Iunius Silanus',
          'works': {'phi001': {'title': 'versio Latina Magonis',
                            'source': 'Scriptorum Romanorum De Re Rustica Reliquiae. Vol. 1, ed. F. Speranza, 1974',
                            'meta': 'fragment-line'}}},
 'phi1345': {'author': 'Silius Italicus',
          'works': {'phi001': {'title': 'Punica',
                            'source': 'Corpus Poetarum Latinorum. Vol. 3, ed. W. C. Summers, 1905',
                            'meta': 'book-verse'}}},
 'phi0451': {'author': 'Sinnius Capito',
          'works': {'phi001': {'title': 'grammatica, fragmenta',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0646': {'author': 'L. Cornelius Sisenna',
          'works': {'phi001': {'title': 'Historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'Milesiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi0648': {'author': 'Staberius Eros',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'line'}}},
 'phi1020': {'author': 'P. Papinius Statius',
          'works': {'phi001': {'title': 'Thebais',
                            'source': 'P. Papini Stati Thebaidos Libri XII, ed. D. E. Hill, 1983',
                            'meta': 'book-verse'},
                    'phi002': {'title': 'Silvae',
                            'source': 'P. Papini Stati Silvae, ed. A. Marastoni, 1970',
                            'meta': 'book-poem-verse'},
                    'phi003': {'title': 'Achilleis',
                            'source': 'Statius: Achilleid, ed. O. A. W. Dilke, 1954',
                            'meta': 'book-verse'},
                    'phi004': {'title': 'De Bello Germanico, fragment',
                            'source': 'P. Papini Stati Silvae, ed. A. Marastoni, 1970',
                            'meta': 'verse'}}},
 'phi0327': {'author': 'L. Aelius Praeconinus Stilo',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0452': {'author': 'C. Iulius Caesar Strabo',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi0650': {'author': 'Sueius',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi1348': {'author': 'C. Suetonius Tranquillus',
          'works': {'phi001': {'title': 'De Vita Caesarum',
                            'source': 'C. Suetoni Tranquilli Opera. Vol. 1, ed. M. Ihm, 1908',
                            'meta': 'life-chapter-section-line'},
                    'phi002': {'title': 'De Poetis',
                            'source': 'C. Suetoni Tranquilli praeter Caesarum Libros Reliquiae, ed. A. Reifferscheid, 1860',
                            'meta': 'fragment-line'},
                    'phi003': {'title': 'De Historicis',
                            'source': 'C. Suetoni Tranquilli praeter Caesarum Libros Reliquiae, ed. A. Reifferscheid, 1860',
                            'meta': 'fragment-line'},
                    'phi004': {'title': 'De Grammaticis et Rhetoribus',
                            'source': 'C. Suetoni Tranquilli praeter Caesarum Libros Reliquiae. Part 1, ed. G. Brugnoli, 1960',
                            'meta': 'chapter-section-line'},
                    'phi005': {'title': 'Prata',
                            'source': 'C. Suetoni Tranquilli praeter Caesarum Libros Reliquiae, ed. A. Reifferscheid, 1860',
                            'meta': 'fragment-line'},
                    'phi006': {'title': 'fragmenta',
                            'source': 'C. Suetoni Tranquilli praeter Caesarum Libros Reliquiae, ed. A. Reifferscheid, 1860',
                            'meta': 'fragment-line'}}},
 'phi0652': {'author': 'L. Cornelius Sulla',
          'works': {'phi001': {'title': 'Commentarii Rerum Gestarum',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi1023': {'author': 'Sulpicia, Caleni uxor',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'},
                    'phi002': {'title': 'De Statu Rei Publicae [sp.]',
                            'source': 'Epigrammata Bobiensia, ed. W. Speyer, 1963',
                            'meta': 'verse'}}},
 'phi0656': {'author': 'Ser. Sulpicius Rufus',
          'works': {'phi002': {'title': 'iurisprudentia',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'},
                    'phi003': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi2302': {'author': 'L. Aurelius Avianius Symmachus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi2301': {'author': 'Q. Aurelius Memmius Symmachus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0658': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Tabulae Censoriae',
                            'source': 'M. Terenti Varronis De Linguae Latinae Quae Supersunt, ed. G. Goetz; F. Schoell, 1910',
                            'meta': 'line'}}},
 'phi1351': {'author': 'Cornelius Tacitus',
          'works': {'phi001': {'title': 'De Vita Iulii Agricolae',
                            'source': 'Cornelii Taciti Opera Minora, ed. J. G. C. Anderson, 1939',
                            'meta': 'chapter-section-line'},
                    'phi002': {'title': 'De Origine et Situ Germanorum',
                            'source': 'Cornelii Taciti Opera Minora, ed. J. G. C. Anderson, 1939',
                            'meta': 'chapter-section-line'},
                    'phi003': {'title': 'Dialogus de Oratoribus',
                            'source': 'Cornelii Taciti Opera Minora, ed. H. Furneaux, 1939',
                            'meta': 'chapter-section-line'},
                    'phi004': {'title': 'Historiae',
                            'source': 'Cornelii Taciti Historiarum Libri, ed. C. D. Fisher, 1911',
                            'meta': 'book-chapter-line'},
                    'phi005': {'title': 'Annales',
                            'source': 'Cornelii Taciti Annalium Ab Excessu Divi Augusti Libri, ed. C. D. Fisher, 1906',
                            'meta': 'book-section-line'}}},
 'phi0730': {'author': 'Tarquitius Priscus',
          'works': {'phi001': {'title': 'De Disciplina Etrusca, fragmentum',
                            'source': 'Ambrosii Theodosii Macrobii Saturnalia, ed. J. Willis, 1970',
                            'meta': 'fragment-line'}}},
 'phi0134': {'author': 'P. Terentius Afer',
          'works': {'phi001': {'title': 'Andria',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'verse'},
                    'phi002': {'title': 'Heauton Timorumenos',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'verse'},
                    'phi003': {'title': 'Eunuchus',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'verse'},
                    'phi004': {'title': 'Phormio',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'verse'},
                    'phi005': {'title': 'Hecyra',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'verse'},
                    'phi006': {'title': 'Adelphoe',
                            'source': 'P. Terenti Afri Comoediae, ed. R. Kauer; W. M. Lindsay; O. Skutsch, 1958',
                            'meta': 'verse'}}},
 'phi0660': {'author': 'Albius Tibullus',
          'works': {'phi001': {'title': 'Elegiae',
                            'source': 'Albii Tibulli Aliorumque Carminum Libri Tres, ed. F. W. Lenz; G. K. Galinsky, 1971',
                            'meta': 'book-poem-verse'},
                    'phi002': {'title': 'carmina Tibulliana [sp.]',
                            'source': 'Albii Tibulli Aliorumque Carminum Libri Tres, ed. F. W. Lenz; G. K. Galinsky, 1971',
                            'meta': 'book-poem-verse'}}},
 'phi0661': {'author': 'Ticidas',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0662': {'author': 'M. Tullius Tiro',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0137': {'author': 'Titinius',
          'works': {'phi001': {'title': 'togatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0140': {'author': 'C. Titius',
          'works': {'phi001': {'title': 'oratio',
                            'source': 'Oratorum Romanorum Fragmenta Liberae Rei Publicae. Vol. 1, ed. E. Malcovati, 1953',
                            'meta': 'fragment-line'}}},
 'phi9254': {'author': 'Titius',
          'works': {'phi001': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi0143': {'author': 'Trabea',
          'works': {'phi001': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi1357': {'author': 'Imperator M. Ulpius Traianus',
          'works': {'phi002': {'title': 'Dacica',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'}}},
 'phi0664': {'author': 'C. Trebatius Testa',
          'works': {'phi001': {'title': 'iurisprudentia et al.',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0668': {'author': 'Cn. Tremelius Scrofa',
          'works': {'phi001': {'title': 'de re rustica scripta',
                            'source': 'Scriptorum Romanorum De Re Rustica Reliquiae. Vol. 1, ed. F. Speranza, 1974',
                            'meta': 'line'}}},
 'phi0984': {'author': 'Pompeius Trogus',
          'works': {'phi001': {'title': 'De Animalibus, fragmentum',
                            'source': 'Pompei Trogi Fragmenta, ed. O. Seel, 1956',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'Historiae Philippicae',
                            'source': 'Pompei Trogi Fragmenta, ed. O. Seel, 1956',
                            'meta': 'book-fragment-line'}}},
 'phi0670': {'author': 'Q. Aelius Tubero. liber ad C',
          'works': {'phi001': {'title': 'Historiae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'Oppium, fr.',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi1029': {'author': 'Turnus',
          'works': {'phi001': {'title': 'satura',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0146': {'author': 'Sex. Turpilius',
          'works': {'phi001': {'title': 'palliatae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 2, ed. O. Ribbeck, 1898',
                            'meta': 'verse'}}},
 'phi0672': {'author': 'Turranius Niger',
          'works': {'phi001': {'title': 'de re rustica scripta',
                            'source': 'Scriptorum Romanorum De Re Rustica Reliquiae. Vol. 1, ed. F. Speranza, 1974',
                            'meta': 'line'}}},
 'phi1032': {'author': 'Vagellius',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0676': {'author': 'Valerius Antias',
          'works': {'phi001': {'title': 'Annales',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 1, ed. H. Peter, 1914',
                            'meta': 'fragment-line'}}},
 'phi1035': {'author': 'C. Valerius Flaccus',
          'works': {'phi001': {'title': 'Argonautica',
                            'source': 'Gai Valeri Flacci Setini Balbi Argonauticon Libros Octo, ed. W.-W. Ehlers, 1980',
                            'meta': 'book-verse'}}},
 'phi1672': {'author': 'Iulius Valerius',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-line'}}},
 'phi1038': {'author': 'Valerius Maximus',
          'works': {'phi001': {'title': 'Facta et Dicta Memorabilia',
                            'source': 'Valerii Maximi Factorum et Dictorum Memorabilium Libri Novem cum Iulii Paridis et Ianuarii Nepotiani Epitomis, ed. C. Kempf, 1888',
                            'meta': 'book-chapter-section-line'}}},
 'phi0678': {'author': 'Q. Valerius Soranus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0674': {'author': 'Valerius',
          'works': {'phi001': {'title': 'comoedia',
                            'source': 'I Mimi Romani, ed. M. Bonaria, 1965',
                            'meta': 'verse'}}},
 'phi0680': {'author': 'C. Valgius Rufus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0682': {'author': 'L. Varius Rufus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'},
                    'phi002': {'title': 'tragoediae',
                            'source': 'Scaenicae Romanorum Poesis Fragmenta. Vol. 1, ed. O. Ribbeck, 1897',
                            'meta': 'verse'}}},
 'phi0686': {'author': 'P. Terentius Varro Atacinus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0684': {'author': 'M. Terentius Varro',
          'works': {'phi001': {'title': 'De Lingua Latina',
                            'source': 'M. Terenti Varronis De Linguae Latinae Quae Supersunt, ed. G. Goetz; F. Schoell, 1910',
                            'meta': 'book-chapter-line'},
                    'phi002': {'title': 'Res Rusticae',
                            'source': 'M. Terenti Varronis Rerum Rusticarum Libri Tres, ed. G. Goetz, 1929',
                            'meta': 'book-chapter-section-line'},
                    'phi003': {'title': 'Antiquitates Rerum Humanarum',
                            'source': 'De M. Terenti Varronis Antiquitatum Rerum Humanarum Libris XXV, ed. P. Mirsch, 1882',
                            'meta': 'book-fragment-line'},
                    'phi004': {'title': 'Antiquitates Rerum Divinarum',
                            'source': 'M. Terentius Varro: Antiquitates Rerum Divinarum. Part 1, ed. B. Cardauns, 1976',
                            'meta': 'fragment-line'},
                    'phi005': {'title': 'Annales',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 1, ed. H. Keil, 1857',
                            'meta': 'line'},
                    'phi006': {'title': 'De Gente Populi Romani',
                            'source': 'Studi Varroniani: De Gente Populi Romani Libri IV, ed. P. Fraccaro, 1907',
                            'meta': 'fragment-line'},
                    'phi007': {'title': 'De Vita Populi Romani',
                            'source': 'M. Terenti Varronis De Vita Populi Romani: Fonti, Esegesi, Edizione Critica dei Frammenti, ed. B. Riposati, 1972',
                            'meta': 'fragment-line'},
                    'phi008': {'title': 'Res Urbanae',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'line'},
                    'phi009': {'title': 'Logistorici',
                            'source': 'I Logistorici, ed. E. Bolisani, 1937',
                            'meta': 'fragment-line'},
                    'phi010': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Romanorum, ed. E. Baehrens, 1886',
                            'meta': 'book-fragment-verse'},
                    'phi011': {'title': 'Menippeae',
                            'source': 'Petronii Saturae, Adiectae Sunt Varronis et Senecae Saturae Similesque Reliquiae, ed. F. Bücheler, 1963',
                            'meta': 'fragment-verse'},
                    'phi012': {'title': 'epistulae',
                            'source': 'M. Terenti Varronis Saturarum Menippearum Reliquiae, ed. A. Riese, 1865',
                            'meta': 'letter-fragment-line'},
                    'phi013': {'title': 'epistulae Latinae',
                            'source': 'Nonii Marcelli De Conpendiosa Doctrina Libros XX. Vols. 1-3, ed. W. M. Lindsay, 1903',
                            'meta': 'fragment-line'},
                    'phi014': {'title': 'fragmenta grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi015': {'title': 'fragmenta de historia litterarum',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi016': {'title': 'fragmenta varia',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'},
                    'phi017': {'title': 'incertae sedis fragmenta',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi1041': {'author': 'Pseudo-Varro',
          'works': {'phi001': {'title': 'Sententiae',
                            'source': 'Die sogenannten Sententiae Varronis, ed. P. Germann, 1910',
                            'meta': 'sententia-line'}}},
 'phi1374': {'author': 'Velius Longus',
          'works': {'phi001': {'title': 'De Orthographia',
                            'source': 'Grammatici Latini ex Recensione Henrici Keilii. Vol. 7, ed. H. Keil, 1880',
                            'meta': 'page-line'}}},
 'phi1044': {'author': 'Velleius Paterculus',
          'works': {'phi001': {'title': 'Historia Romana',
                            'source': "Velleius Paterculus: Histoire Romaine. Vols. 1-2, ed. J. Hellegouarc'h, 1982",
                            'meta': 'book-chapter-section-line'}}},
 'phi1047': {'author': 'Veranius',
          'works': {'phi001': {'title': 'libri de rebus sacris',
                            'source': 'Iurisprudentiae Anteiustinianae Reliquiae. Vol. 1, ed. P. E. Huschke; E. Seckel; B. Kübler, 1908',
                            'meta': 'fragment-line'}}},
 'phi0692': {'author': 'Appendix Vergiliana',
          'works': {'phi001': {'title': 'Dirae',
                            'source': 'Appendix Vergiliana, ed. E. J. Kenney, 1966',
                            'meta': 'verse'},
                    'phi002': {'title': 'Lydia',
                            'source': 'Appendix Vergiliana, ed. E. J. Kenney, 1966',
                            'meta': 'verse'},
                    'phi003': {'title': 'Culex',
                            'source': 'Appendix Vergiliana, ed. W. V. Clausen, 1966',
                            'meta': 'verse'},
                    'phi004': {'title': 'Aetna',
                            'source': 'Appendix Vergiliana, ed. F. R. D. Goodyear, 1966',
                            'meta': 'verse'},
                    'phi005': {'title': 'Copa',
                            'source': 'Appendix Vergiliana, ed. E. J. Kenney, 1966',
                            'meta': 'verse'},
                    'phi006': {'title': 'Elegiae in Maecenatem',
                            'source': 'Appendix Vergiliana, ed. E. J. Kenney, 1966',
                            'meta': 'poem-verse'},
                    'phi007': {'title': 'Ciris',
                            'source': 'Appendix Vergiliana, ed. F. R. D. Goodyear, 1966',
                            'meta': 'verse'},
                    'phi008': {'title': 'Priapea',
                            'source': 'Appendix Vergiliana, ed. J. A. Richmond, 1966',
                            'meta': 'poem-verse'},
                    'phi009': {'title': 'Catalepton',
                            'source': 'Appendix Vergiliana, ed. J. A. Richmond, 1966',
                            'meta': 'poem-verse'},
                    'phi010': {'title': "Priapeum 'Quid Hoc Novi Est?'",
                            'source': 'Appendix Vergiliana, ed. J. A. Richmond, 1966',
                            'meta': 'verse'},
                    'phi011': {'title': 'Moretum',
                            'source': 'Appendix Vergiliana, ed. E. J. Kenney, 1966',
                            'meta': 'verse'},
                    'phi012': {'title': 'De Institutione Viri Boni',
                            'source': 'Appendix Vergiliana, ed. W. V. Clausen, 1966',
                            'meta': 'verse'},
                    'phi013': {'title': 'De Est et Non',
                            'source': 'Appendix Vergiliana, ed. W. V. Clausen, 1966',
                            'meta': 'verse'},
                    'phi014': {'title': 'De Rosis Nascentibus',
                            'source': 'Appendix Vergiliana, ed. W. V. Clausen, 1966',
                            'meta': 'verse'}}},
 'phi0690': {'author': 'P. Vergilius Maro',
          'works': {'phi001': {'title': 'Eclogae',
                            'source': 'P. Vergili Maronis Opera, ed. R. A. B. Mynors, 1972',
                            'meta': 'poem-verse'},
                    'phi002': {'title': 'Georgica',
                            'source': 'P. Vergili Maronis Opera, ed. R. A. B. Mynors, 1972',
                            'meta': 'book-verse'},
                    'phi003': {'title': 'Aeneis',
                            'source': 'P. Vergili Maronis Opera, ed. R. A. B. Mynors, 1972',
                            'meta': 'book-verse'}}},
 'phi1050': {'author': 'L. Verginius Rufus',
          'works': {'phi001': {'title': 'epigramma',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi0869': {'author': 'M. Verrius Flaccus',
          'works': {'phi001': {'title': 'Etruscarum Rerum Libri',
                            'source': 'Historicorum Romanorum Reliquiae. Vol. 2, ed. H. Peter, 1906',
                            'meta': 'fragment-line'},
                    'phi002': {'title': 'grammatica',
                            'source': 'Grammaticae Romanae Fragmenta, ed. G. Funaioli, 1907',
                            'meta': 'fragment-line'}}},
 'phi1053': {'author': 'Q. Vibius Crispus',
          'works': {'phi001': {'title': 'orationes',
                            'source': 'M. Fabi Quintiliani Institutionis Oratoriae Libri Duodecim. Vols. 1-2, ed. M. Winterbottom, 1970',
                            'meta': 'fragment-line'}}},
 'phi9969': {'author': 'Anonymous',
          'works': {'phi001': {'title': 'Vita Iuvenalis',
                            'source': 'A. Persi Flacci et D. Iuni Iuvenalis Saturae, ed. W. V. Clausen, 1959',
                            'meta': 'line'}}},
 'phi1056': {'author': 'Vitruvius Pollio',
          'works': {'phi001': {'title': 'De Architectura',
                            'source': 'Vitruvii de Architectura, ed. F. Krohn, 1912',
                            'meta': 'book-chapter-section-line'}}},
 'phi0330': {'author': 'Volcacius Sedigitus',
          'works': {'phi001': {'title': 'carmina',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'fragment-verse'}}},
 'phi0694': {'author': 'Volumnius',
          'works': {'phi001': {'title': 'carmen',
                            'source': 'Fragmenta Poetarum Latinorum Epicorum et Lyricorum praeter Ennium et Lucilium, ed. W. Morel, 1927',
                            'meta': 'verse'}}},
 'phi2150': {'author': 'Zeno of Verona',
          'works': {'phi001': {'title': 'Tractatus',
                            'source': 'Zeno Veronensis Tractatus, ed. B. Löfstedt, 1971',
                            'meta': 'book-sermon-section-line'}}}}
