/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.TransformerException;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCollector
extends StandardErrorListener {
    private Set<String> errorCodes = new HashSet<String>();
    private boolean foundWarnings = false;
    public TransformerException lastException;

    public void warning(TransformerException exception) {
        this.foundWarnings = true;
        super.warning(exception);
    }

    public void error(TransformerException exception) {
        this.lastException = exception;
        this.addErrorCode(exception);
        super.error(exception);
    }

    public void fatalError(TransformerException exception) {
        this.addErrorCode(exception);
        super.fatalError(exception);
    }

    public StandardErrorListener makeAnother(int hostLanguage) {
        return this;
    }

    private void addErrorCode(TransformerException exception) {
        if (exception instanceof XPathException) {
            String errorCode = ((XPathException)((Object)exception)).getErrorCodeLocalPart();
            if (errorCode != null) {
                String ns = ((XPathException)((Object)exception)).getErrorCodeNamespace();
                if (ns != null && !"http://www.w3.org/2005/xqt-errors".equals(ns)) {
                    errorCode = "Q{" + ns + "}" + errorCode;
                }
                this.errorCodes.add(errorCode);
            } else {
                this.errorCodes.add("error-with-no-error-code");
            }
        }
    }

    public Set<String> getErrorCodes() {
        return this.errorCodes;
    }

    public boolean getFoundWarnings() {
        return this.foundWarnings;
    }
}

