/*
 * Decompiled with CFR 0.152.
 */
package com.github.rainmanwy.robotframework.sikulilib.keywords;

import com.github.rainmanwy.robotframework.sikulilib.exceptions.ScreenOperationException;
import com.github.rainmanwy.robotframework.sikulilib.exceptions.TimeoutException;
import com.github.rainmanwy.robotframework.sikulilib.utils.CaptureFolder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.sikuli.script.FindFailed;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;

@RobotKeywords
public class ScreenKeywords {
    private static double DEFAULT_TIMEOUT = 3.0;
    private final Screen screen = new Screen();
    private double timeout;
    private Map<String, Match> highlightMap = new HashMap<String, Match>();

    public ScreenKeywords() {
        this.timeout = DEFAULT_TIMEOUT;
    }

    @RobotKeyword(value="Set Sikuli timeout(seconds)")
    @ArgumentNames(value={"timeout"})
    public String setTimeout(String timeout) {
        double oldTimeout = this.timeout;
        this.timeout = Double.parseDouble(timeout);
        return Double.toString(oldTimeout);
    }

    @RobotKeyword(value="Add image path")
    @ArgumentNames(value={"path"})
    public boolean addImagePath(String path) {
        return ImagePath.add(path);
    }

    @RobotKeyword(value="Set folder for captured images")
    @ArgumentNames(value={"path"})
    public void setCaptureFolder(String path) {
        CaptureFolder.getInstance().setCaptureFolder(path);
    }

    @RobotKeyword(value="Click image")
    @ArgumentNames(value={"image"})
    public void click(String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        try {
            this.screen.click(image);
        }
        catch (FindFailed e) {
            this.capture();
            throw new ScreenOperationException("Click " + image + " failed" + e.getMessage(), e);
        }
    }

    @RobotKeyword(value="Double click image")
    @ArgumentNames(value={"image"})
    public void doubleClick(String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        try {
            this.screen.doubleClick(image);
        }
        catch (FindFailed e) {
            throw new ScreenOperationException("Click " + image + " failed" + e.getMessage(), e);
        }
    }

    @RobotKeyword(value="Right click image")
    @ArgumentNames(value={"image"})
    public void rightClick(String image) throws Exception {
        this.wait(image, Double.toString(this.timeout));
        try {
            this.screen.rightClick(image);
        }
        catch (FindFailed e) {
            throw new ScreenOperationException("Click " + image + " failed" + e.getMessage(), e);
        }
    }

    private Match wait(String image, String timeout) throws TimeoutException {
        try {
            Match match = this.screen.wait(image, Double.parseDouble(timeout));
            this.capture(match);
            return match;
        }
        catch (FindFailed e) {
            this.capture();
            throw new TimeoutException("Timeout happend, could not find " + image, e);
        }
    }

    private Match find(String image) {
        try {
            Match match = this.screen.find(image);
            this.capture(match);
            return match;
        }
        catch (FindFailed e) {
            System.out.println("Could not find " + image);
            return null;
        }
    }

    @RobotKeyword(value="Wait until image shown in screen")
    @ArgumentNames(value={"image", "timeout"})
    public void waitUntilScreenContain(String image, String timeout) throws TimeoutException {
        this.wait(image, timeout);
    }

    @RobotKeyword(value="Screen should contain image")
    @ArgumentNames(value={"image"})
    public void screenShouldContain(String image) throws ScreenOperationException {
        Match match = this.find(image);
        if (match == null) {
            throw new ScreenOperationException("Screen should contain " + image);
        }
    }

    @RobotKeyword(value="Screen should not contain image")
    @ArgumentNames(value={"image"})
    public void screenShouldNotContain(String image) throws ScreenOperationException {
        Match match = this.find(image);
        if (match != null) {
            throw new ScreenOperationException("Screen should not contain " + image);
        }
    }

    @RobotKeyword(value="Input text. Image could be empty")
    @ArgumentNames(value={"image", "text"})
    public void inputText(String image, String text) throws Exception {
        int result;
        System.out.println("Input Text:");
        System.out.println(text);
        if (!"".equals(image)) {
            this.click(image);
        }
        if ((result = this.screen.type(text)) == 0) {
            throw new ScreenOperationException("Input text failed");
        }
    }

    @RobotKeyword(value="Paste text. Image could be empty")
    @ArgumentNames(value={"image", "text"})
    public void pasteText(String image, String text) throws Exception {
        int result;
        System.out.println("Paste Text:");
        System.out.println(text);
        if (!"".equals(image)) {
            this.click(image);
        }
        if ((result = this.screen.paste(text)) == 0) {
            throw new ScreenOperationException("Paste text failed");
        }
    }

    @RobotKeyword(value="Click in. \nClick target image in area image.")
    @ArgumentNames(value={"areaImage", "targetImage"})
    public void clickIn(String areaImage, String targetImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.click(targetImage);
        this.capture(match.find(targetImage));
    }

    @RobotKeyword(value="Double click in. \nDouble click target image in area image.")
    @ArgumentNames(value={"areaImage", "targetImage"})
    public void doubleClickIn(String areaImage, String targetImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.doubleClick(targetImage);
        this.capture(match.find(targetImage));
    }

    @RobotKeyword(value="Right click in. \nRight click target image in area image.")
    @ArgumentNames(value={"areaImage", "targetImage"})
    public void rightClickIn(String areaImage, String targetImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.rightClick(targetImage);
        this.capture(match.find(targetImage));
    }

    private void capture() {
        ScreenImage image = this.screen.capture();
        String imagePath = image.save(CaptureFolder.getInstance().getCaptureFolder());
        System.out.println("*DEBUG* Saved path: " + imagePath);
        File file = new File(imagePath);
        String fileName = file.getName();
        System.out.println("*HTML* <img src='" + CaptureFolder.getInstance().getSubFolder() + "/" + fileName + "'/>");
    }

    private void capture(Region region) {
        ScreenImage image = this.screen.capture(region);
        String imagePath = image.save(CaptureFolder.getInstance().getCaptureFolder());
        System.out.println("*DEBUG* Saved path: " + imagePath);
        File file = new File(imagePath);
        String fileName = file.getName();
        System.out.println("*HTML* <img src='" + CaptureFolder.getInstance().getSubFolder() + "/" + fileName + "'/>");
    }

    @RobotKeyword(value="Capture whole screen")
    @ArgumentNames(value={})
    public void captureScreen() {
        this.capture();
    }

    @RobotKeyword(value="Highlight matched image")
    @ArgumentNames(value={"image"})
    public void highlight(String image) throws Exception {
        Match match = null;
        if (!this.highlightMap.containsKey(image)) {
            match = this.screen.find(image);
            this.highlightMap.put(image, match);
            match.highlight();
            this.capture();
        } else {
            System.out.println("*WARN* " + image + " was already highlighted");
        }
    }

    @RobotKeyword(value="Clear highlight from screen")
    @ArgumentNames(value={"image"})
    public void clearHighlight(String image) {
        if (this.highlightMap.containsKey(image)) {
            Match match = this.highlightMap.get(image);
            match.highlight();
            this.highlightMap.remove(image);
        } else {
            System.out.println("*WARN* " + image + " was not highlighted before");
        }
    }

    @RobotKeyword(value="Clear all highlights from screen")
    @ArgumentNames(value={})
    public void clearAllHighlights() {
        for (Match match : this.highlightMap.values()) {
            match.highlight();
        }
        this.highlightMap.clear();
    }
}

