import numpy as np

def mnist_data():
    """5000 samples from the MNIST handwritten digits datast.
    Data Source: http://yann.lecun.com/exdb/mnist/

    Returns
    --------
    X, y : [n_samples, n_features], [n_class_labels]
      X is the feature matrix with 5000 image samples as rows,
      each row consists of 28x28 pixels that were unrolled into
      784 pixel feature vectors.
      y contains the 10 unique class labels 0-9.

    """
    y = np.array([
    5,0,4,1,9,2,1,3,1,4,3,
    5,3,6,1,7,2,8,6,9,4,
    0,9,1,1,2,4,3,2,7,3,
    8,6,9,0,5,6,0,7,6,1,
    8,7,9,3,9,8,5,9,3,3,
    0,7,4,9,8,0,9,4,1,4,
    4,6,0,4,5,6,1,0,0,1,
    7,1,6,3,0,2,1,1,7,9,
    0,2,6,7,8,3,9,0,4,6,
    7,4,6,8,0,7,8,3,1,5,
    7,1,7,1,1,6,3,0,2,9,
    3,1,1,0,4,9,2,0,0,2,
    0,2,7,1,8,6,4,1,6,3,
    4,5,9,1,3,3,8,5,4,7,
    7,4,2,8,5,8,6,7,3,4,
    6,1,9,9,6,0,3,7,2,8,
    2,9,4,4,6,4,9,7,0,9,
    2,9,5,1,5,9,1,2,3,2,
    3,5,9,1,7,6,2,8,2,2,
    5,0,7,4,9,7,8,3,2,1,
    1,8,3,6,1,0,3,1,0,0,
    1,7,2,7,3,0,4,6,5,2,
    6,4,7,1,8,9,9,3,0,7,
    1,0,2,0,3,5,4,6,5,8,
    6,3,7,5,8,0,9,1,0,3,
    1,2,2,3,3,6,4,7,5,0,
    6,2,7,9,8,5,9,2,1,1,
    4,4,5,6,4,1,2,5,3,9,
    3,9,0,5,9,6,5,7,4,1,
    3,4,0,4,8,0,4,3,6,8,
    7,6,0,9,7,5,7,2,1,1,
    6,8,9,4,1,5,2,2,9,0,
    3,9,6,7,2,0,3,5,4,3,
    6,5,8,9,5,4,7,4,2,7,
    3,4,8,9,1,9,2,8,7,9,
    1,8,7,4,1,3,1,1,0,2,
    3,9,4,9,2,1,6,8,4,7,
    7,4,4,9,2,5,7,2,4,4,
    2,1,9,7,2,8,7,6,9,2,
    2,3,8,1,6,5,1,1,0,2,
    6,4,5,8,3,1,5,1,9,2,
    7,4,4,4,8,1,5,8,9,5,
    6,7,9,9,3,7,0,9,0,6,
    6,2,3,9,0,7,5,4,8,0,
    9,4,1,2,8,7,1,2,6,1,
    0,3,0,1,1,8,2,0,3,9,
    4,0,5,0,6,1,7,7,8,1,
    9,2,0,5,1,2,2,7,3,5,
    4,9,7,1,8,3,9,6,0,3,
    1,1,2,6,3,5,7,6,8,3,
    9,5,8,5,7,6,1,1,3,1,
    7,5,5,5,2,5,8,7,0,9,
    7,7,5,0,9,0,0,8,9,2,
    4,8,1,6,1,6,5,1,8,3,
    4,0,5,5,8,3,6,2,3,9,
    2,1,1,5,2,1,3,2,8,7,
    3,7,2,4,6,9,7,2,4,2,
    8,1,1,3,8,4,0,6,5,9,
    3,0,9,2,4,7,1,2,9,4,
    2,6,1,8,9,0,6,6,7,9,
    9,8,0,1,4,4,6,7,1,5,
    7,0,3,5,8,4,7,1,2,5,
    9,5,6,7,5,9,8,8,3,6,
    9,7,0,7,5,7,1,1,0,7,
    9,2,3,7,3,2,4,1,6,2,
    7,5,5,7,4,0,2,6,3,6,
    4,0,4,2,6,0,0,0,0,3,
    1,6,2,2,3,1,4,1,5,4,
    6,4,7,2,8,7,9,2,0,5,
    1,4,2,8,3,2,4,1,5,4,
    6,0,7,9,8,4,9,8,0,1,
    1,0,2,2,3,2,4,4,5,8,
    6,5,7,7,8,8,9,7,4,7,
    3,2,0,8,6,8,6,1,6,8,
    9,4,0,9,0,4,1,5,4,7,
    5,3,7,4,9,8,5,8,6,3,
    8,6,9,9,1,8,3,5,8,6,
    5,9,7,2,5,0,8,5,1,1,
    0,9,1,8,6,7,0,9,3,0,
    8,8,9,6,7,8,4,7,5,9,
    2,6,7,4,5,9,2,3,1,6,
    3,9,2,2,5,6,8,0,7,7,
    1,9,8,7,0,9,9,4,6,2,
    8,5,1,4,1,5,5,1,7,3,
    6,4,3,2,5,6,4,4,0,4,
    4,6,7,2,4,3,3,8,0,0,
    3,2,2,9,8,2,3,7,0,1,
    1,0,2,3,3,8,4,3,5,7,
    6,4,7,7,8,5,9,7,0,3,
    1,6,2,4,3,4,4,7,5,9,
    6,9,0,7,1,4,2,7,3,6,
    7,5,8,4,5,5,2,7,1,1,
    5,6,8,5,8,4,0,7,9,9,
    2,9,7,7,8,7,4,2,6,9,
    1,7,0,6,4,2,5,7,0,7,
    1,0,3,7,6,5,0,6,1,5,
    1,7,8,5,0,3,4,7,7,5,
    7,8,6,9,3,8,6,1,0,9,
    7,1,3,0,5,6,4,4,2,4,
    4,3,1,7,7,6,0,3,6,0,
    7,1,1,4,9,4,3,4,8,2,
    2,1,8,7,0,8,1,0,7,6,
    3,7,7,5,8,8,9,0,0,4,
    1,5,2,2,3,9,4,9,5,0,
    6,7,7,1,8,0,2,2,0,4,
    1,1,2,7,3,9,7,2,8,1,
    9,5,8,8,1,9,8,3,1,6,
    5,7,4,2,7,0,3,0,4,1,
    1,7,9,1,1,8,5,7,5,0,
    6,6,0,4,1,2,3,4,4,6,
    8,0,9,5,8,7,0,3,5,4,
    5,9,6,7,1,9,6,1,3,8,
    3,9,1,2,7,7,7,0,2,3,
    1,1,4,2,5,6,0,9,6,2,
    8,9,2,3,3,6,9,1,4,3,
    3,0,7,7,1,7,7,3,6,4,
    9,5,4,4,2,7,9,0,9,8,
    4,4,9,1,2,4,9,3,0,4,
    1,6,2,6,3,7,4,2,6,6,
    7,1,8,9,0,4,1,4,2,1,
    3,6,4,6,7,5,8,7,0,5,
    1,4,2,8,4,7,7,3,8,4,
    9,5,8,6,7,3,4,6,7,1,
    7,4,3,3,9,8,8,1,8,6,
    3,1,1,3,5,2,8,4,2,9,
    7,1,4,8,2,9,6,4,1,3,
    4,2,5,2,5,6,8,0,6,2,
    4,9,4,9,4,5,1,5,8,4,
    7,9,5,9,5,9,1,5,8,3,
    9,9,1,8,3,8,6,5,2,7,
    2,7,6,0,9,7,9,4,6,0,
    5,3,5,7,3,9,3,6,8,3,
    1,7,6,5,5,7,6,5,8,2,
    1,7,9,2,7,3,6,7,8,5,
    3,7,7,8,4,0,7,3,0,6,
    3,9,7,1,9,5,3,6,0,9,
    2,8,0,9,1,6,0,0,1,9,
    0,0,4,2,1,7,0,3,4,4,
    7,5,9,8,2,0,0,8,6,2,
    2,7,6,1,2,9,2,6,9,7,
    9,5,0,8,1,5,2,4,3,9,
    4,7,5,6,6,7,7,6,8,5,
    9,7,0,6,1,9,2,3,3,5,
    4,3,5,8,6,3,7,2,8,4,
    9,5,0,2,1,4,2,4,3,1,
    7,1,8,0,9,6,8,1,9,4,
    4,9,1,8,9,6,5,5,3,3,
    0,1,4,3,8,3,4,2,0,7,
    5,5,1,8,5,3,4,6,0,5,
    7,2,6,6,0,1,1,4,7,9,
    0,0,6,6,8,6,9,4,5,2,
    4,0,7,5,6,5,0,9,8,6,
    1,9,7,5,7,5,1,1,3,0,
    2,0,3,8,1,6,4,6,2,6,
    4,8,8,1,4,4,7,1,2,2,
    3,9,6,4,9,5,6,2,3,9,
    2,6,2,7,4,3,6,4,9,7,
    0,2,2,9,5,4,5,0,1,4,
    3,6,3,2,9,7,5,3,7,0,
    9,5,8,3,2,0,1,8,3,0,
    1,2,3,4,0,0,1,7,2,9,
    3,9,4,2,5,8,6,7,7,9,
    8,9,9,2,0,0,1,4,2,4,
    3,9,4,3,5,7,6,5,7,1,
    8,6,9,3,0,4,1,2,2,5,
    3,7,4,1,7,7,8,1,9,2,
    3,2,4,0,1,8,4,3,6,5,
    6,4,7,9,3,1,3,0,2,1,
    1,0,9,9,4,6,7,6,3,5,
    5,4,4,6,9,1,1,3,1,1,
    0,5,1,4,4,6,6,6,0,1,
    2,0,8,2,2,1,1,3,7,9,
    5,3,0,2,0,6,2,9,0,7,
    6,9,9,1,2,9,3,4,7,9,
    6,0,9,4,8,7,7,9,8,6,
    9,5,2,2,2,3,9,8,8,8,
    6,4,4,4,4,2,4,6,0,7,
    0,7,8,2,0,8,8,3,6,8,
    6,6,8,6,5,1,1,8,7,8,
    3,6,8,9,5,0,0,0,3,2,
    6,6,7,8,3,5,1,4,3,5,
    9,4,5,4,1,1,5,4,0,9,
    7,1,2,5,7,9,4,0,3,6,
    1,7,7,5,6,3,0,1,1,4,
    2,4,3,6,4,7,5,7,6,9,
    7,2,8,4,9,8,0,7,1,1,
    2,3,3,5,4,6,5,0,6,3,
    7,3,8,2,9,0,0,9,1,2,
    2,9,3,9,4,6,5,2,6,6,
    7,6,8,2,9,2,0,6,7,2,
    8,6,9,0,9,6,0,3,1,1,
    4,9,5,8,1,0,6,6,7,2,
    3,4,2,3,9,0,0,4,5,0,
    6,4,7,4,3,1,9,3,9,9,
    3,1,8,7,1,7,2,8,9,9,
    6,2,7,2,5,0,6,7,3,9,
    5,9,0,8,5,8,4,9,0,5,
    3,2,4,8,7,4,1,5,4,6,
    3,7,7,9,6,6,2,2,1,6,
    5,4,5,3,0,5,5,2,0,5,
    8,8,4,2,6,9,7,1,0,2,
    3,1,8,7,1,8,2,7,2,6,
    3,2,3,7,6,8,7,5,3,8,
    4,4,9,4,6,4,5,5,1,1,
    9,3,8,6,1,4,1,7,5,4,
    0,4,2,7,7,5,8,0,6,9,
    6,6,8,7,2,0,8,8,4,8,
    4,4,2,3,2,3,8,2,0,5,
    0,0,1,0,2,1,3,3,4,7,
    5,3,6,1,7,6,8,3,9,0,
    0,7,1,2,2,4,3,7,4,1,
    5,0,6,3,7,9,8,7,9,5,
    0,1,1,8,2,6,3,3,4,3,
    5,3,7,1,8,1,9,6,8,9,
    9,7,5,0,7,3,0,6,3,8,
    1,6,6,1,8,6,4,6,1,0,
    7,1,6,4,5,1,6,7,4,8,
    2,5,7,3,8,4,1,6,3,3,
    4,5,3,2,4,5,7,1,2,4,
    0,0,5,8,0,6,1,1,9,3,
    2,1,3,4,2,4,3,4,5,8,
    5,6,7,6,8,9,4,0,9,4,
    9,4,7,4,1,6,1,3,7,3,
    8,3,3,2,4,4,8,7,6,4,
    3,6,8,7,0,7,9,5,6,5,
    2,3,0,4,1,4,0,5,6,1,
    2,6,3,4,8,5,9,5,0,2,
    7,5,2,9,3,4,4,0,5,2,
    5,5,2,9,8,3,5,2,4,4,
    6,7,6,4,6,6,7,0,9,6,
    1,8,8,5,2,1,1,5,2,0,
    6,9,5,2,3,1,4,1,7,6,
    9,2,4,6,0,1,0,5,5,5,
    9,2,0,4,1,1,2,4,3,0,
    4,2,5,7,6,2,7,7,8,3,
    9,0,0,2,1,1,2,8,3,4,
    4,1,5,9,6,1,7,5,8,9,
    9,6,0,1,1,7,2,8,3,7,
    7,8,8,8,9,7,6,8,2,4,
    7,4,1,8,5,0,6,9,2,8,
    5,2,0,0,5,4,4,3,2,1,
    0,5,8,5,1,4,7,2,1,4,
    8,6,3,4,8,1,7,5,1,3,
    7,1,7,9,0,0,1,9,4,0,
    4,8,4,8,5,1,7,1,4,2,
    4,4,9,2,7,3,2,4,6,9,
    5,1,3,2,9,4,4,3,3,6,
    9,2,0,6,8,8,7,5,6,6,
    3,8,0,4,4,6,6,7,3,4,
    7,7,0,6,1,6,1,6,2,0,
    9,7,3,6,1,3,8,2,9,2,
    8,7,2,9,5,6,2,2,6,4,
    9,7,6,3,0,0,5,0,3,1,
    3,0,6,2,3,3,5,0,0,7,
    3,4,7,5,6,4,1,4,5,2,
    5,1,9,5,8,6,0,7,9,4,
    0,9,1,3,2,5,3,3,4,6,
    5,1,6,7,7,7,8,4,9,3,
    0,0,1,0,2,0,3,6,4,6,
    7,5,8,1,9,4,0,8,1,9,
    2,6,3,1,5,0,6,4,7,8,
    8,7,9,6,0,1,0,7,1,5,
    0,5,1,0,2,2,3,8,0,1,
    6,3,9,7,6,8,6,6,5,9,
    2,0,9,6,1,5,4,2,9,7,
    5,3,7,1,5,6,6,7,7,3,
    3,6,1,2,4,7,1,8,3,2,
    3,8,7,5,3,7,9,8,8,6,
    8,8,8,2,8,4,8,1,4,5,
    7,1,2,2,1,9,9,5,8,2,
    7,9,9,7,3,7,3,1,0,6,
    7,9,5,2,4,1,1,0,1,3,
    2,9,6,4,1,3,5,9,0,1,
    1,4,2,3,3,0,4,2,5,3,
    6,4,7,5,0,0,1,2,2,7,
    3,7,4,7,5,6,6,5,7,3,
    8,1,9,9,0,7,1,8,2,0,
    3,4,4,3,5,1,6,7,9,5,
    8,0,2,1,6,3,9,3,6,2,
    1,2,9,1,9,3,9,9,4,4,
    4,2,3,9,8,0,1,4,4,8,
    1,2,2,7,9,3,0,3,4,3,
    9,6,1,2,7,0,4,6,4,1,
    1,4,8,3,7,6,6,2,0,2,
    8,8,1,7,8,2,2,7,6,6,
    2,7,1,0,2,4,5,1,4,9,
    5,6,6,0,7,2,7,5,5,1,
    3,1,0,4,2,1,2,1,2,6,
    7,0,3,6,5,3,2,4,1,0,
    4,2,4,1,3,4,0,6,0,5,
    8,4,7,0,3,1,1,2,7,6,
    9,5,6,0,3,5,3,1,0,1,
    5,4,6,9,6,3,8,5,7,6,
    3,1,5,9,0,2,1,1,2,8,
    3,8,4,0,5,5,6,5,7,7,
    8,0,9,6,0,9,1,8,2,3,
    3,4,4,3,5,5,6,5,7,1,
    8,8,9,0,0,2,1,6,2,7,
    3,7,4,7,7,7,8,1,9,4,
    8,6,5,1,7,0,9,1,5,9,
    0,8,8,1,3,2,5,7,4,7,
    8,0,3,8,0,0,2,4,1,9,
    0,9,2,0,5,8,8,8,8,9,
    5,8,3,3,0,6,4,4,4,8,
    1,2,6,9,1,6,3,3,0,6,
    3,4,6,2,9,4,3,6,7,7,
    4,5,9,2,7,8,0,1,9,1,
    4,4,8,4,3,9,2,2,7,1,
    7,8,9,9,5,8,7,4,6,9,
    4,4,8,8,9,6,6,6,9,4,
    4,2,1,9,2,0,0,3,6,4,
    1,2,1,8,6,7,4,5,8,1,
    9,1,6,3,4,5,6,0,5,1,
    0,1,2,2,0,6,5,4,6,7,
    5,2,0,8,1,9,2,8,1,3,
    7,8,8,8,1,2,4,8,3,0,
    2,7,8,9,2,2,7,8,9,5,
    3,6,9,3,0,2,1,3,2,5,
    3,4,4,4,5,9,6,5,7,9,
    8,3,9,4,0,8,1,0,2,2,
    3,9,4,5,5,7,6,2,7,7,
    8,1,0,7,3,5,4,4,5,3,
    6,4,7,2,8,1,9,7,6,1,
    0,9,3,1,4,7,1,9,4,4,
    0,2,8,2,6,7,0,0,7,7,
    8,7,7,8,7,9,9,3,0,4,
    4,0,9,3,9,5,7,6,0,7,
    5,1,8,2,5,7,9,4,8,4,
    8,7,7,9,5,0,6,6,5,4,
    3,9,8,6,1,9,6,7,8,2,
    5,9,9,2,2,1,2,2,0,9,
    9,4,2,3,4,9,7,3,3,3,
    1,9,3,7,6,5,6,0,2,6,
    1,3,2,4,6,3,0,8,2,4,
    2,2,7,1,1,9,3,9,7,4,
    4,4,8,8,9,5,2,3,9,4,
    5,2,6,6,8,6,0,7,0,4,
    9,7,1,9,1,0,0,5,1,1,
    2,9,3,5,5,3,6,4,9,2,
    0,6,1,1,2,0,3,9,4,3,
    5,3,6,3,7,1,8,7,0,0,
    1,1,2,9,3,5,4,1,5,8,
    6,3,7,3,8,7,1,7,0,1,
    1,8,5,0,3,4,4,8,4,1,
    0,7,0,2,6,8,9,7,6,4,
    6,3,5,6,4,1,4,4,4,3,
    0,3,7,1,9,3,5,1,7,2,
    3,3,1,6,4,8,4,1,0,8,
    9,8,9,4,6,2,1,1,8,0,
    3,0,8,7,8,4,8,7,8,5,
    8,8,4,4,7,9,7,9,1,9,
    9,8,8,0,7,0,8,7,9,6,
    3,7,3,6,5,8,5,9,0,6,
    7,1,9,0,5,2,6,7,5,1,
    0,3,6,9,1,1,4,4,1,3,
    1,3,2,8,8,7,2,5,6,1,
    1,0,5,2,0,9,1,0,2,8,
    3,6,4,2,5,3,6,2,7,5,
    8,2,9,8,0,6,1,9,2,0,
    3,1,1,9,5,3,6,9,7,8,
    8,1,0,1,1,3,2,4,3,0,
    4,0,5,3,6,8,7,7,8,7,
    9,0,6,4,4,3,2,1,6,8,
    4,0,7,5,5,9,5,5,4,7,
    7,2,8,1,9,6,2,5,9,6,
    3,4,9,6,3,3,8,8,2,2,
    0,9,9,8,8,4,0,4,5,3,
    6,2,0,3,1,2,0,9,2,2,
    5,5,3,3,5,4,3,8,8,8,
    0,7,0,4,5,9,4,0,3,6,
    4,0,1,9,5,6,3,4,0,2,
    8,2,3,1,0,4,6,7,2,0,
    7,2,1,4,1,6,8,7,1,8,
    7,4,1,0,3,6,8,4,4,3,
    2,9,0,8,9,9,7,2,6,7,
    7,5,4,3,1,3,6,1,8,9,
    4,8,1,6,2,8,6,5,7,9,
    1,6,9,6,8,0,0,0,6,7,
    9,7,4,9,9,9,9,7,6,7,
    2,8,3,6,7,9,1,7,2,1,
    5,1,3,7,7,0,8,6,0,3,
    1,3,2,6,3,8,4,9,5,6,
    6,1,7,3,8,2,9,4,0,2,
    1,5,2,9,3,2,4,4,5,7,
    6,8,7,3,8,7,9,2,0,1,
    1,9,2,7,3,6,4,6,5,5,
    6,4,7,5,8,8,9,7,6,5,
    2,8,6,9,5,0,4,1,2,2,
    0,0,8,0,1,2,7,0,1,2,
    8,8,3,7,7,0,1,1,7,1,
    1,2,4,9,4,0,5,6,7,6,
    4,9,9,7,7,7,2,8,6,3,
    5,5,3,2,9,1,9,8,0,2,
    8,6,7,2,9,6,0,3,6,7,
    3,7,0,5,4,4,6,7,3,6,
    7,6,0,1,1,1,4,8,8,6,
    8,1,1,0,2,1,9,8,3,9,
    1,5,4,5,2,8,9,4,8,2,
    2,9,8,4,6,8,9,5,2,4,
    9,7,6,6,3,1,3,9,6,7,
    3,0,1,5,2,8,5,0,0,1,
    3,1,1,1,5,2,5,6,9,7,
    8,3,0,7,9,9,0,2,1,6,
    2,9,3,7,4,8,5,4,6,8,
    7,7,8,0,9,7,0,5,1,9,
    2,8,3,6,4,9,5,8,6,9,
    7,5,8,1,9,1,0,3,1,1,
    2,6,3,7,4,5,5,6,6,2,
    7,0,8,8,9,2,6,4,1,6,
    9,9,9,3,9,2,4,9,4,8,
    3,4,8,5,1,0,4,0,1,6,
    2,6,5,4,0,7,9,9,5,1,
    3,9,0,9,4,5,9,1,1,7,
    7,4,4,5,4,3,1,3,8,1,
    7,0,6,2,0,4,8,8,1,6,
    8,1,2,3,6,3,2,9,0,1,
    9,1,1,7,2,1,5,5,4,6,
    5,4,7,4,7,8,5,4,3,4,
    0,2,2,5,2,1,2,6,7,1,
    3,5,1,5,4,3,4,6,3,7,
    0,1,0,2,4,9,7,2,9,6,
    7,2,8,6,8,0,7,0,9,0,
    6,9,3,4,1,7,7,4,9,2,
    6,6,3,3,3,3,1,3,0,4,
    2,7,6,9,0,3,5,1,6,3,
    6,4,8,7,7,3,3,8,5,9,
    8,3,3,4,0,7,1,6,2,0,
    3,8,7,4,8,3,9,2,0,7,
    3,8,4,0,7,1,8,0,0,5,
    1,4,2,1,3,7,4,7,5,1,
    6,5,7,5,8,9,9,8,5,0,
    1,5,9,6,9,0,7,4,1,9,
    0,2,9,8,0,7,5,3,9,7,
    7,7,1,7,3,4,6,7,3,0,
    2,3,0,0,9,4,0,8,6,9,
    1,3,7,7,2,0,8,7,3,6,
    4,9,7,6,6,7,6,9,3,8,
    2,7,3,0,8,5,9,9,4,2,
    8,4,8,8,7,4,1,8,0,1,
    8,6,7,7,7,7,5,2,9,3,
    2,6,3,6,1,4,1,6,4,4,
    5,1,5,2,0,5,4,3,8,1,
    7,7,4,5,9,6,2,2,3,6,
    6,7,4,8,1,4,2,4,4,8,
    1,2,5,0,1,2,9,8,3,5,
    2,7,0,4,0,9,2,7,9,4,
    3,5,6,4,0,9,1,8,2,1,
    3,7,4,2,5,2,6,7,7,5,
    8,8,9,1,0,1,1,0,2,3,
    3,1,4,4,5,0,6,4,7,0,
    8,1,9,1,0,3,1,3,2,3,
    3,3,4,2,5,7,6,2,7,6,
    8,4,9,1,8,6,0,7,5,7,
    6,0,6,1,0,6,8,4,0,4,
    2,2,3,9,7,6,9,7,4,2,
    7,3,1,1,9,0,1,5,7,6,
    1,5,0,4,0,1,4,9,1,3,
    7,6,5,2,7,2,1,8,3,8,
    3,8,3,3,1,6,6,0,9,5,
    7,7,4,9,3,5,0,8,2,5,
    5,1,2,7,6,9,0,0,8,2,
    9,6,4,5,3,4,5,7,4,6,
    8,5,1,0,5,4,9,3,0,9,
    6,3,4,8,6,4,8,3,1,6,
    4,0,7,1,5,2,7,2,2,2,
    2,8,0,1,0,0,1,3,7,6,
    7,2,9,2,5,5,9,9,8,5,
    9,7,6,3,8,1,8,9,2,7,
    3,0,6,8,1,0,2,0,9,9,
    8,8,9,3,5,1,2,8,6,8,
    2,6,4,5,8,2,4,1,6,1,
    5,6,0,2,1,2,2,0,3,9,
    4,2,5,6,7,7,8,5,0,4,
    1,6,2,7,3,3,4,0,5,3,
    6,3,7,0,8,4,9,0,0,1,
    1,5,2,9,3,0,4,4,7,5,
    8,3,1,1,6,1,8,4,9,6,
    9,1,0,7,1,0,2,6,4,4,
    4,4,3,7,7,5,4,9,4,1,
    4,3,0,7,3,4,8,4,7,6,
    5,4,8,0,2,7,1,3,7,1,
    9,4,1,8,1,9,6,6,2,5,
    1,4,3,9,8,9,6,6,4,9,
    9,7,4,8,2,3,4,4,4,7,
    6,7,2,5,5,2,5,8,0,3,
    2,0,8,0,0,2,6,7,8,8,
    1,8,7,3,1,3,6,3,7,0,
    6,1,8,4,7,7,4,3,9,2,
    3,6,3,1,5,6,8,7,0,4,
    3,0,7,9,9,4,7,3,7,1,
    9,9,1,7,6,0,7,5,8,6,
    0,9,1,2,2,9,3,0,4,1,
    5,6,6,1,7,0,8,7,9,6,
    0,9,1,6,2,9,3,2,4,5,
    5,1,6,1,7,7,8,5,9,1,
    0,4,1,4,2,3,3,1,4,1,
    5,0,6,7,7,3,8,9,5,1,
    1,1,9,5,9,1,7,1,1,6,
    0,8,9,7,0,2,5,3,9,6,
    7,8,1,0,7,3,2,1,2,])
    
    X =  np.array([
[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,18,18,18,126,136,175,26,166,255,247,127,0,0,0,0,0,0,0,0,0,0,0,0,30,36,94,154,170,253,253,253,253,253,225,172,253,242,195,64,0,0,0,0,0,0,0,0,0,0,0,49,238,253,253,253,253,253,253,253,253,251,93,82,82,56,39,0,0,0,0,0,0,0,0,0,0,0,0,18,219,253,253,253,253,253,198,182,247,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,156,107,253,253,205,11,0,43,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,1,154,253,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,190,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,190,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,241,225,160,108,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,240,253,253,119,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,186,253,253,150,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,93,252,253,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,253,249,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,130,183,253,253,207,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,148,229,253,253,253,250,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,114,221,253,253,253,253,201,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,66,213,253,253,253,253,198,81,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,171,219,253,253,253,253,195,80,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,172,226,253,253,253,253,244,133,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,253,253,212,135,132,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,159,253,159,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,238,252,252,252,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,227,253,252,239,233,252,57,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,60,224,252,253,252,202,84,252,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,252,252,252,253,252,252,96,189,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,238,253,253,190,114,253,228,47,79,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,238,252,252,179,12,75,121,21,0,0,253,243,50,0,0,0,0,0,0,0,0,0,0,0,0,0,38,165,253,233,208,84,0,0,0,0,0,0,253,252,165,0,0,0,0,0,0,0,0,0,0,0,0,7,178,252,240,71,19,28,0,0,0,0,0,0,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,63,0,0,0,0,0,0,0,0,0,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,198,253,190,0,0,0,0,0,0,0,0,0,0,255,253,196,0,0,0,0,0,0,0,0,0,0,0,76,246,252,112,0,0,0,0,0,0,0,0,0,0,253,252,148,0,0,0,0,0,0,0,0,0,0,0,85,252,230,25,0,0,0,0,0,0,0,0,7,135,253,186,12,0,0,0,0,0,0,0,0,0,0,0,85,252,223,0,0,0,0,0,0,0,0,7,131,252,225,71,0,0,0,0,0,0,0,0,0,0,0,0,85,252,145,0,0,0,0,0,0,0,48,165,252,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,225,0,0,0,0,0,0,114,238,253,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,249,146,48,29,85,178,225,253,223,167,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,252,229,215,252,252,252,196,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,199,252,252,253,252,252,233,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,128,252,253,252,141,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,232,39,0,0,0,0,0,0,0,0,0,62,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,180,39,0,0,0,0,0,0,0,0,0,126,163,0,0,0,0,0,0,0,0,0,0,0,0,0,2,153,210,40,0,0,0,0,0,0,0,0,0,220,163,0,0,0,0,0,0,0,0,0,0,0,0,0,27,254,162,0,0,0,0,0,0,0,0,0,0,222,163,0,0,0,0,0,0,0,0,0,0,0,0,0,183,254,125,0,0,0,0,0,0,0,0,0,46,245,163,0,0,0,0,0,0,0,0,0,0,0,0,0,198,254,56,0,0,0,0,0,0,0,0,0,120,254,163,0,0,0,0,0,0,0,0,0,0,0,0,23,231,254,29,0,0,0,0,0,0,0,0,0,159,254,120,0,0,0,0,0,0,0,0,0,0,0,0,163,254,216,16,0,0,0,0,0,0,0,0,0,159,254,67,0,0,0,0,0,0,0,0,0,14,86,178,248,254,91,0,0,0,0,0,0,0,0,0,0,159,254,85,0,0,0,47,49,116,144,150,241,243,234,179,241,252,40,0,0,0,0,0,0,0,0,0,0,150,253,237,207,207,207,253,254,250,240,198,143,91,28,5,233,250,0,0,0,0,0,0,0,0,0,0,0,0,119,177,177,177,177,177,98,56,0,0,0,0,0,102,254,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,255,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,255,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,244,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,236,251,211,31,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,228,251,251,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,253,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,253,251,235,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,205,253,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,251,253,184,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,240,251,193,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,253,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,251,251,251,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,221,251,251,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,251,251,196,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,255,253,253,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,228,253,247,140,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,193,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,148,210,253,253,113,87,148,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,232,252,253,189,210,252,252,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,57,242,252,190,65,5,12,182,252,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,252,252,183,14,0,0,92,252,252,225,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,252,146,14,0,0,0,215,252,252,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,247,176,9,0,0,8,78,245,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,232,252,176,0,0,0,36,201,252,252,169,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,252,252,30,22,119,197,241,253,252,251,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,231,252,253,252,252,252,226,227,252,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,235,253,217,138,42,24,192,252,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,255,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,253,252,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,253,252,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,252,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,255,253,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,252,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,252,189,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,184,252,170,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,147,252,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,25,100,122,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,151,208,252,252,252,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,152,244,252,253,224,211,252,232,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,152,239,252,252,252,216,31,37,252,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,252,252,252,252,217,29,0,37,252,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,252,220,167,30,0,0,77,252,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,128,58,22,0,0,0,0,100,252,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,252,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,121,122,121,202,252,194,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,53,179,253,253,255,253,253,228,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,54,227,252,243,228,170,242,252,252,231,117,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,78,252,252,125,59,0,18,208,252,252,252,252,87,7,0,0,0,0,0,0,0,0,0,0,0,0,5,135,252,252,180,16,0,21,203,253,247,129,173,252,252,184,66,49,49,0,0,0,0,0,0,0,0,3,136,252,241,106,17,0,53,200,252,216,65,0,14,72,163,241,252,252,223,0,0,0,0,0,0,0,0,105,252,242,88,18,73,170,244,252,126,29,0,0,0,0,0,89,180,180,37,0,0,0,0,0,0,0,0,231,252,245,205,216,252,252,252,124,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,252,252,252,178,116,36,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,93,143,121,23,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,255,211,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,237,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,175,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,221,253,252,124,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,252,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,252,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,253,253,255,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,211,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,43,105,255,253,253,253,253,253,174,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,139,224,226,252,253,252,252,252,252,252,252,158,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,252,252,252,252,253,252,252,252,252,252,252,252,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,230,132,133,132,132,189,252,252,252,252,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,29,29,24,0,0,0,0,14,226,252,252,172,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,243,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,189,252,252,252,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,212,247,252,252,252,204,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,125,193,193,193,253,252,252,252,238,102,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,222,252,252,252,252,253,252,252,252,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,223,253,253,253,253,255,253,253,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,123,52,44,44,44,44,143,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,75,9,0,0,0,0,0,0,98,242,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,61,183,252,29,0,0,0,0,18,92,239,252,252,243,65,0,0,0,0,0,0,0,0,0,0,0,0,0,208,252,252,147,134,134,134,134,203,253,252,252,188,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,252,252,252,252,252,252,252,252,253,230,153,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,157,252,252,252,252,252,217,207,146,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,103,235,252,172,103,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,63,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,254,230,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,254,254,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,254,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,254,254,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,254,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,239,254,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,254,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,245,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,246,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,254,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,241,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,240,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,254,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,247,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,209,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,247,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,247,242,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,252,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,185,18,0,0,0,0,89,236,217,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,253,60,0,0,0,0,212,255,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,252,68,0,0,0,48,242,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,251,212,21,0,0,11,167,252,197,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,232,247,63,0,0,0,153,252,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,219,252,143,0,0,0,116,249,252,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,96,253,255,253,200,122,7,25,201,250,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,252,252,253,217,252,252,200,227,252,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,251,247,231,65,48,189,252,252,253,252,251,227,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,221,98,0,0,0,42,196,252,253,252,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,29,0,0,0,0,62,239,252,86,42,42,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,148,253,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,252,231,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,221,251,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,252,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,118,219,166,118,118,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,242,254,254,254,254,254,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,232,254,254,254,254,254,238,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,244,254,224,254,254,254,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,254,210,254,254,254,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,206,254,254,254,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,209,254,254,254,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,137,253,254,254,254,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,214,250,254,254,254,254,254,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,247,254,254,254,254,254,254,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,246,254,254,254,254,254,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,89,89,93,240,254,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,254,219,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,254,254,214,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,254,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,177,90,0,0,0,0,0,25,240,254,254,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,254,215,63,36,0,51,89,206,254,254,139,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,197,254,254,222,180,241,254,254,253,213,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,105,254,254,254,254,254,254,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,117,117,165,254,254,239,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,40,129,234,234,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,150,239,254,253,253,253,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,201,254,254,254,241,150,98,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,154,254,236,203,83,39,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,145,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,129,222,78,79,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,253,167,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,253,226,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,6,0,18,128,253,241,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,205,235,92,0,0,20,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,245,108,0,0,0,132,253,185,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,245,254,254,254,217,254,223,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,165,233,233,234,180,39,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,99,91,142,155,246,182,155,155,155,155,131,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,254,254,254,254,254,254,254,254,254,254,252,210,122,33,0,0,0,0,0,0,0,0,0,0,0,0,220,254,254,254,235,189,189,189,189,150,189,205,254,254,254,75,0,0,0,0,0,0,0,0,0,0,0,0,35,74,35,35,25,0,0,0,0,0,0,13,224,254,254,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,254,247,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,152,246,254,254,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,158,254,254,249,103,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,251,254,254,254,248,74,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,254,254,254,254,254,254,202,125,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,181,234,254,254,254,254,254,254,252,140,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,50,73,155,253,254,254,254,254,191,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,200,254,254,254,254,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,192,254,254,254,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,254,254,116,0,0,0,0,0,0,0,0,0,0,0,0,0,25,126,86,0,0,0,0,0,0,3,188,254,254,250,61,0,0,0,0,0,0,0,0,0,0,0,0,24,209,254,15,0,0,0,0,0,23,137,254,254,254,209,0,0,0,0,0,0,0,0,0,0,0,0,0,168,254,254,48,9,0,0,9,127,241,254,254,255,242,63,0,0,0,0,0,0,0,0,0,0,0,0,0,101,254,254,254,205,190,190,205,254,254,254,254,242,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,166,254,254,254,254,254,254,254,254,250,138,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,88,154,116,194,194,154,154,88,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,222,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,234,252,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,197,253,252,208,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,178,252,253,117,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,222,253,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,252,179,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,246,220,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,252,135,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,140,253,252,118,0,0,0,0,111,140,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,191,255,253,56,0,0,114,113,222,253,253,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,252,253,223,37,0,48,174,252,252,242,214,253,199,31,0,0,0,0,0,0,0,0,0,0,0,0,13,109,252,228,130,0,38,165,253,233,164,49,63,253,214,31,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,126,0,23,178,252,240,148,7,44,215,240,148,0,0,0,0,0,0,0,0,0,0,0,0,0,119,252,252,0,0,197,252,252,63,0,57,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,174,0,48,229,253,112,0,38,222,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,252,173,0,48,227,252,158,226,234,201,27,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,57,104,240,252,252,253,233,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,242,252,253,252,252,252,252,240,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,189,253,252,252,157,112,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,168,242,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,228,254,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,254,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,248,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,254,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,212,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,254,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,199,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,121,162,253,253,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,107,170,251,252,252,252,252,250,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,192,226,226,241,252,253,202,252,252,252,252,252,225,0,0,0,0,0,0,0,0,0,0,0,0,0,68,223,252,252,252,252,252,39,19,39,65,224,252,252,183,0,0,0,0,0,0,0,0,0,0,0,0,0,186,252,252,252,245,108,53,0,0,0,150,252,252,220,20,0,0,0,0,0,0,0,0,0,0,0,0,70,242,252,252,222,59,0,0,0,0,0,178,252,252,141,0,0,0,0,0,0,0,0,0,0,0,0,0,185,252,252,194,67,0,0,0,0,17,90,240,252,194,67,0,0,0,0,0,0,0,0,0,0,0,0,0,83,205,190,24,0,0,0,0,0,121,252,252,209,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,247,252,248,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,255,253,253,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,183,253,252,107,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,102,252,253,163,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,168,252,252,110,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,252,252,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,155,252,214,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,252,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,179,252,150,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,252,221,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,252,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,164,211,250,250,194,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,176,253,237,180,180,243,254,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,236,135,18,0,0,40,242,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,253,167,0,0,0,0,0,130,254,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,217,79,0,0,0,0,0,46,254,231,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,10,0,0,0,0,0,0,39,254,254,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,212,254,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,254,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,215,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,254,254,56,0,0,20,67,124,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,35,98,254,254,208,157,207,225,254,241,160,0,0,0,0,0,0,0,0,0,0,9,31,82,137,203,203,212,254,254,254,254,251,223,223,127,52,33,0,0,0,0,0,0,0,0,0,9,137,214,254,254,254,254,240,228,250,254,254,154,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,254,247,179,146,67,60,28,0,216,254,220,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,222,49,0,0,0,0,4,137,244,232,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,206,4,0,0,0,8,179,254,247,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,158,177,130,96,213,252,199,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,247,249,249,249,171,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,203,229,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,47,47,30,95,254,215,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,154,185,185,223,253,253,133,175,255,188,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,253,246,161,228,253,253,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,245,253,158,137,21,0,48,233,253,233,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,223,25,0,0,36,170,254,244,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,212,253,161,11,26,178,253,236,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,155,253,228,80,223,253,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,253,254,253,154,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,253,254,179,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,171,254,254,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,253,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,123,254,253,203,156,253,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,254,121,13,93,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,239,253,76,8,32,219,253,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,254,191,0,5,108,234,254,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,190,5,85,253,236,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,169,192,253,253,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,253,254,236,129,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,118,243,191,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,169,250,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,242,221,143,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,247,143,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,245,184,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,192,200,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,247,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,231,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,243,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,251,41,0,0,0,64,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,210,7,0,96,237,254,247,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,84,0,6,223,84,13,87,246,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,254,80,0,56,151,0,0,0,147,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,254,41,0,13,19,0,0,0,42,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,254,13,0,0,0,0,0,0,14,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,255,13,0,0,0,0,0,0,77,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,254,13,0,0,0,0,0,5,181,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,229,105,0,0,0,0,5,156,213,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,246,105,14,49,95,217,209,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,246,253,253,240,130,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,105,227,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,199,253,252,252,252,252,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,211,252,232,152,73,167,252,215,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,182,0,0,0,37,235,243,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,252,103,0,0,0,37,235,229,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,86,8,43,139,190,211,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,252,200,201,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,245,252,253,252,242,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,84,253,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,253,252,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,255,253,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,253,189,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,179,232,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,225,252,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,245,243,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,237,245,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,148,252,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,196,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,228,129,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,190,25,0,0,0,0,0,0,0,0,0,0,0,13,25,10,0,0,0,0,0,0,0,0,0,0,0,112,252,125,4,0,0,0,0,0,0,0,0,0,0,132,252,113,0,0,0,0,0,0,0,0,0,0,0,61,252,252,36,0,0,0,0,0,0,0,0,0,0,132,252,240,79,0,0,0,0,0,0,0,0,0,0,84,252,252,36,0,0,0,0,0,0,0,0,0,0,132,252,252,238,52,0,0,0,0,0,0,0,0,12,198,252,252,122,0,0,0,0,0,0,0,0,0,0,99,252,252,252,181,17,0,0,0,0,0,0,0,49,252,252,252,122,0,0,0,0,0,0,0,0,0,0,3,125,252,252,252,100,0,0,0,0,0,0,0,26,218,252,252,36,0,0,0,0,0,0,0,0,0,0,0,15,216,252,252,207,19,0,0,0,0,0,0,49,252,252,252,36,0,0,0,0,0,0,0,0,0,0,0,0,157,252,252,252,48,0,0,0,6,109,109,194,252,252,252,36,0,0,0,0,0,0,0,0,0,0,0,0,100,252,252,252,105,0,58,116,128,252,252,252,252,252,212,19,0,0,0,0,0,0,0,0,0,0,0,0,0,164,253,253,253,253,253,253,255,253,253,253,253,253,253,99,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,252,252,252,252,252,253,252,252,252,252,252,252,155,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,252,252,252,252,252,217,216,141,126,252,252,252,155,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,252,252,234,204,89,0,0,0,49,252,252,252,155,0,0,0,0,0,0,0,0,0,0,0,0,0,14,158,192,151,45,0,0,0,0,0,49,252,252,252,225,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,252,252,252,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,228,252,252,252,157,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,229,252,252,252,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,232,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,206,131,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,205,251,253,205,111,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,189,251,251,253,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,64,223,244,251,251,211,213,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,181,251,253,251,251,251,94,96,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,253,255,253,253,253,95,96,253,253,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,236,251,243,220,233,251,251,243,82,96,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,80,253,251,251,188,0,96,251,251,109,0,96,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,96,240,253,243,188,42,0,96,204,109,4,0,12,197,251,31,0,0,0,0,0,0,0,0,0,0,0,0,221,251,253,121,0,0,0,36,23,0,0,0,0,190,251,31,0,0,0,0,0,0,0,0,0,0,0,48,234,253,0,0,0,0,0,0,0,0,0,0,0,191,253,31,0,0,0,0,0,0,0,0,0,0,44,221,251,251,0,0,0,0,0,0,0,0,0,0,12,197,251,31,0,0,0,0,0,0,0,0,0,0,190,251,251,251,0,0,0,0,0,0,0,0,0,0,96,251,251,31,0,0,0,0,0,0,0,0,0,0,190,251,251,113,0,0,0,0,0,0,0,0,0,40,234,251,219,23,0,0,0,0,0,0,0,0,0,0,190,251,251,94,0,0,0,0,0,0,0,0,40,217,253,231,47,0,0,0,0,0,0,0,0,0,0,0,191,253,253,253,0,0,0,0,0,0,12,174,253,253,219,39,0,0,0,0,0,0,0,0,0,0,0,0,67,236,251,251,191,190,111,72,190,191,197,251,243,121,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,236,251,253,251,251,251,251,253,251,188,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,129,253,251,251,251,251,229,168,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,212,251,211,94,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,144,250,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,241,204,97,126,253,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,121,247,133,16,0,50,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,253,109,0,0,0,120,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,234,169,4,0,0,31,220,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,215,212,18,0,0,0,195,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,253,63,0,0,0,90,251,242,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,214,5,0,0,24,233,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,124,0,0,14,197,253,149,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,254,45,0,71,224,254,218,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,246,214,227,248,241,255,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,193,167,78,226,189,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,145,249,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,227,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,250,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,206,223,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,207,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,254,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,230,253,248,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,118,253,253,225,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,253,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,206,253,253,186,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,253,239,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,255,253,186,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,229,254,207,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,229,253,254,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,254,213,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,251,253,253,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,212,253,250,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,214,253,253,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,253,253,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,189,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,235,253,126,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,248,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,235,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,222,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,254,218,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,249,254,254,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,254,254,174,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,164,254,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,254,254,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,245,254,254,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,248,254,204,254,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,59,98,151,237,254,254,109,35,254,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,216,254,254,239,153,37,4,32,254,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,44,44,30,0,0,0,32,254,254,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,230,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,254,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,54,54,45,26,84,221,84,21,31,162,78,0,0,0,0,0,0,0,0,0,0,0,0,0,6,41,141,244,254,254,248,236,254,254,254,233,239,254,138,0,0,0,0,0,0,0,0,0,0,0,0,23,167,254,254,254,254,229,228,185,138,138,138,138,138,138,44,0,0,0,0,0,0,0,0,0,0,0,0,113,254,254,254,179,64,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,209,183,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,91,143,255,190,91,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,49,180,246,253,253,253,253,253,220,154,17,3,0,0,0,0,0,0,0,0,0,0,0,0,0,46,107,178,253,253,253,253,253,253,253,253,253,253,253,126,45,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,253,253,223,220,220,220,220,245,253,253,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,107,173,253,229,129,12,0,0,0,0,110,253,253,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,17,14,40,32,0,0,0,0,0,0,57,253,253,253,242,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,139,224,253,253,253,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,178,253,253,253,253,219,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,250,253,253,253,253,127,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,125,250,253,253,253,245,171,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,41,217,253,253,250,245,245,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,253,192,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,47,220,253,253,188,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,253,189,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,225,253,253,186,22,0,0,0,0,0,31,42,174,205,205,205,193,58,0,0,0,0,0,0,0,0,48,218,253,253,253,150,59,0,0,128,131,131,222,253,253,253,253,253,94,0,0,0,0,0,0,0,0,0,12,152,253,253,253,253,236,222,222,252,253,253,253,253,253,253,253,253,122,0,0,0,0,0,0,0,0,0,0,7,167,253,253,253,253,253,253,253,253,253,253,253,253,253,124,106,7,0,0,0,0,0,0,0,0,0,0,0,76,188,253,253,253,253,253,253,253,224,57,15,15,15,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,89,121,253,253,151,89,89,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,229,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,30,0,0,0,0,0,181,223,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,242,113,0,0,0,0,57,249,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,162,0,0,0,0,0,136,253,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,138,0,0,0,0,0,162,254,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,239,137,0,0,0,0,0,245,244,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,148,7,0,0,0,0,254,206,3,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,169,34,0,0,0,254,240,191,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,174,254,255,169,161,195,255,254,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,90,173,206,206,223,254,77,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,204,210,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,234,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,80,207,255,254,254,254,97,80,80,44,0,0,0,0,0,0,0,0,0,0,0,0,0,39,158,158,158,168,253,253,253,253,253,253,253,253,253,210,38,0,0,0,0,0,0,0,0,0,0,0,0,226,253,253,253,253,253,253,253,253,253,253,253,253,253,253,241,146,0,0,0,0,0,0,0,0,0,0,0,139,253,253,253,238,113,215,253,253,253,253,253,253,253,253,253,210,43,0,0,0,0,0,0,0,0,0,0,39,34,34,34,30,0,31,148,34,204,235,253,253,253,253,253,236,64,0,0,0,0,0,0,0,0,0,0,91,0,0,0,0,0,0,0,0,35,199,253,253,253,253,244,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,33,202,202,216,253,253,253,253,241,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,167,253,253,253,253,253,253,253,238,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,253,253,253,253,253,253,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,201,253,253,253,253,253,253,253,230,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,87,87,87,248,253,253,253,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,152,253,253,253,250,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,238,253,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,233,253,253,150,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,203,253,253,253,138,0,0,0,0,0,0,0,0,0,0,0,66,211,211,211,59,36,36,21,26,36,151,222,253,253,253,253,138,0,0,0,0,0,0,0,0,0,0,0,80,253,253,253,253,253,253,195,215,253,253,253,253,253,253,157,77,0,0,0,0,0,0,0,0,0,0,0,80,253,253,253,253,253,253,253,253,253,253,253,253,237,235,40,0,0,0,0,0,0,0,0,0,0,0,0,49,156,247,253,253,253,253,253,253,253,253,159,156,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,253,253,253,253,126,78,78,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,189,254,255,254,254,254,174,101,31,50,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,242,253,253,253,253,253,253,253,253,216,226,206,200,200,58,0,0,0,0,0,0,0,0,0,0,0,0,101,253,253,253,253,253,253,253,253,253,253,253,253,253,253,227,53,0,0,0,0,0,0,0,0,0,0,0,251,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,249,181,17,0,0,0,0,0,0,0,0,0,122,214,214,158,61,61,113,214,214,250,253,253,253,253,253,253,253,253,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,115,115,237,253,253,253,253,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,24,168,241,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,102,243,253,253,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,253,253,253,197,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,182,253,253,251,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,99,198,253,253,247,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,224,244,253,253,239,30,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,169,213,253,253,253,197,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,253,242,137,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,253,253,253,141,62,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,239,253,253,253,253,253,172,162,162,162,64,8,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,247,253,253,253,253,253,253,253,253,253,253,253,199,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,199,227,253,253,253,253,253,253,253,220,230,201,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,99,99,174,253,253,253,122,39,57,22,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,37,37,37,7,0,0,0,0,0,0,0,0,78,0,0,0,0,0,0,0,0,0,0,14,84,182,188,193,254,254,254,124,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,22,91,130,193,254,254,204,125,201,254,254,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,254,255,254,255,173,22,0,98,254,255,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,245,198,75,31,2,0,117,245,254,221,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,36,0,0,0,0,78,246,254,222,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,243,254,225,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,249,254,220,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,242,254,224,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,251,254,219,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,242,254,254,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,209,254,232,83,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,226,254,224,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,250,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,244,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,19,95,143,143,143,143,143,143,143,143,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,149,208,253,253,253,253,253,253,253,253,253,253,217,22,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,251,222,222,161,140,99,99,99,99,143,253,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,217,210,86,0,0,0,0,0,0,0,29,161,253,253,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,203,253,253,174,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,78,232,253,253,253,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,253,253,253,253,192,180,180,128,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,253,253,253,253,253,253,253,253,169,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,61,61,61,61,83,176,79,110,247,253,195,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,192,30,0,0,50,203,253,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,195,57,0,0,0,0,112,253,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,204,17,0,0,0,0,58,248,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,184,62,0,0,85,164,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,253,243,223,223,250,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,152,253,253,253,253,253,253,152,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,18,122,141,141,141,87,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,154,180,255,176,118,118,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,253,253,253,253,253,236,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,253,253,204,177,177,177,243,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,253,216,22,0,0,23,227,238,96,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,253,205,0,0,17,124,253,253,253,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,253,234,62,18,201,253,253,253,251,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,253,253,253,253,253,253,253,221,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,253,253,253,253,253,208,24,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,236,253,253,253,251,97,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,69,224,253,253,240,169,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,134,253,253,253,253,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,225,253,253,253,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,227,253,253,250,174,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,253,179,63,111,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,251,201,13,5,0,166,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,222,253,198,0,0,0,248,253,231,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,243,253,124,0,38,133,252,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,237,179,223,253,253,190,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,230,253,253,253,253,253,244,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,231,253,253,253,182,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,255,225,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,246,183,128,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,235,204,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,252,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,251,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,229,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,232,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,254,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,227,194,3,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,254,115,0,0,0,0,25,139,155,242,235,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,254,75,0,0,0,83,224,251,155,152,254,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,254,104,0,0,82,249,217,60,0,37,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,254,72,0,18,247,159,14,0,7,201,254,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,239,147,1,5,155,72,0,4,193,253,122,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,97,0,0,13,73,225,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,244,248,226,226,231,254,243,115,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,177,254,254,235,152,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,103,254,254,255,184,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,169,245,253,253,253,253,253,230,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,233,253,160,89,95,232,253,253,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,253,117,7,0,6,136,242,253,251,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,113,2,76,75,194,253,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,239,228,216,253,253,253,173,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,200,253,253,253,253,253,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,14,15,102,253,253,159,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,216,253,190,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,153,253,248,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,253,252,120,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,250,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,182,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,220,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,92,252,244,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,226,241,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,235,253,137,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,208,253,190,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,218,240,146,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,160,167,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,255,253,253,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,251,251,145,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,217,241,253,251,251,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,251,251,253,251,251,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,251,251,253,251,96,148,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,253,253,130,0,0,110,253,255,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,251,251,251,0,0,0,109,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,251,251,251,225,0,0,6,129,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,251,251,251,71,0,0,115,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,173,20,0,0,217,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,255,253,216,0,0,0,0,218,253,253,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,221,253,251,215,0,0,0,84,236,251,251,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,215,0,0,11,160,251,251,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,137,0,0,150,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,35,0,130,253,251,251,173,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,255,253,98,150,253,255,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,251,251,251,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,241,253,251,251,251,251,216,112,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,253,251,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,251,225,71,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,141,198,255,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,141,198,255,255,255,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,141,226,255,255,255,255,198,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,255,170,86,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,226,170,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,198,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,141,86,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,198,114,226,170,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,198,255,114,29,0,141,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,114,0,0,0,141,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,226,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,0,0,0,0,0,0,0,114,226,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,198,86,0,0,0,141,255,255,170,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,226,170,226,255,255,198,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,198,255,255,170,141,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,191,122,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,254,191,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,242,253,254,253,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,239,253,253,254,162,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,253,253,187,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,233,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,253,253,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,229,253,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,253,253,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,253,253,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,227,254,254,254,176,121,122,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,253,253,253,253,253,253,254,242,191,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,253,253,253,253,253,253,254,253,253,119,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,237,253,253,253,206,173,254,253,253,253,187,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,253,253,253,145,32,53,208,253,253,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,240,253,253,253,253,218,54,209,253,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,196,253,253,253,253,253,255,253,253,253,243,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,197,253,253,253,253,255,253,253,253,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,128,241,253,253,255,253,253,199,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,120,190,183,196,120,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,227,73,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,251,251,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,166,228,251,251,251,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,220,253,251,251,251,251,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,231,253,251,251,251,251,232,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,253,253,253,255,253,253,253,253,255,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,253,168,107,169,251,253,189,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,89,236,251,235,215,164,15,6,129,251,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,47,211,253,251,251,142,0,0,0,37,251,251,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,251,142,0,0,0,11,148,251,253,251,164,0,0,0,0,0,0,0,0,0,0,0,0,11,150,253,255,211,25,0,0,0,0,11,150,253,255,211,25,0,0,0,0,0,0,0,0,0,0,0,0,140,251,251,253,107,0,0,0,0,0,37,251,251,211,46,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,251,253,128,5,0,0,0,0,37,251,251,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,251,251,253,188,20,0,0,32,109,129,251,173,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,251,201,30,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,253,255,149,73,150,253,255,253,253,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,251,251,253,251,251,251,251,253,251,230,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,251,253,251,251,251,251,242,215,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,189,251,253,251,251,251,173,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,200,253,251,96,71,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,29,29,88,89,126,126,126,126,126,121,29,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,254,254,254,254,254,254,254,254,254,254,254,176,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,204,197,197,197,197,197,197,197,197,200,254,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,5,0,0,0,0,0,0,0,0,4,193,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,254,254,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,254,254,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,254,254,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,254,224,16,0,75,83,83,83,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,49,67,229,254,252,241,241,253,254,242,193,111,0,0,0,0,0,0,0,0,0,0,11,74,112,180,207,247,254,254,254,254,252,240,213,143,69,35,0,0,0,0,0,0,0,0,0,0,0,20,233,254,254,254,254,254,254,225,254,254,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,218,254,135,115,22,19,19,30,229,254,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,91,8,0,0,0,0,0,207,254,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,254,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,254,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,254,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,59,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,255,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,162,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,253,248,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,220,253,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,220,253,253,253,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,253,253,195,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,195,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,253,219,24,0,0,0,16,153,128,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,227,253,116,0,0,0,54,203,253,253,224,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,243,61,0,0,17,179,253,253,253,253,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,210,0,0,0,162,253,253,196,149,253,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,232,253,173,0,0,0,192,253,229,30,94,253,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,253,253,86,0,0,51,242,229,57,0,193,253,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,253,253,189,0,20,188,253,136,0,116,247,219,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,217,253,247,69,56,253,253,128,132,247,219,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,253,233,230,253,253,253,253,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,215,253,253,253,253,253,253,253,123,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,141,218,253,253,168,106,18,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,219,253,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,192,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,255,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,188,253,216,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,202,253,253,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,199,253,128,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,225,253,235,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,253,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,202,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,244,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,47,47,34,0,116,253,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,164,246,253,252,234,33,116,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,188,252,252,253,252,252,45,210,234,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,244,252,252,147,148,210,22,140,250,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,205,21,0,64,140,169,233,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,154,9,0,0,68,252,252,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,252,252,196,48,49,228,252,227,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,177,252,252,232,233,252,227,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,137,252,252,253,231,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,253,253,255,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,228,252,231,232,236,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,228,252,227,48,138,252,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,252,227,50,0,138,252,208,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,253,252,79,0,0,138,252,221,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,255,144,0,0,0,149,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,249,75,0,0,43,253,223,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,237,70,70,112,246,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,253,252,252,252,252,150,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,137,253,252,200,210,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,26,111,195,230,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,107,195,254,254,254,244,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,167,248,254,222,146,150,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,223,246,254,153,61,10,0,48,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,175,164,80,2,0,0,0,48,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,254,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,254,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,202,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,248,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,246,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,240,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,255,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,255,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,193,254,253,254,213,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,173,252,253,252,253,252,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,233,244,203,102,20,72,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,212,81,0,21,102,193,171,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,151,0,0,62,122,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,253,151,0,0,0,183,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,254,213,152,71,173,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,252,253,252,253,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,163,203,214,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,243,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,233,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,223,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,213,255,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,192,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,132,51,51,51,51,51,51,51,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,253,252,253,252,253,252,253,252,223,203,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,142,203,203,203,203,203,203,214,253,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,203,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,252,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,224,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,223,102,102,61,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,142,203,243,254,253,254,253,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,71,111,172,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,203,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,253,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,172,132,253,142,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,232,151,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,185,255,253,253,230,132,132,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,71,242,252,252,228,231,252,252,252,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,166,252,252,235,92,0,14,142,252,252,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,204,252,234,152,44,0,0,48,225,252,180,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,164,252,232,61,0,0,0,6,179,252,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,252,76,0,0,0,44,199,252,252,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,252,228,32,0,0,99,231,244,220,252,203,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,207,97,97,206,234,243,32,157,252,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,252,252,252,252,252,200,22,11,198,231,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,131,224,252,252,142,11,0,82,252,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,252,220,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,252,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,247,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,216,244,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,200,249,252,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,200,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,152,203,181,141,58,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,172,247,188,232,234,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,82,101,143,252,245,67,35,225,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,132,237,254,254,254,254,254,243,80,210,248,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,251,211,107,23,36,120,240,246,98,218,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,251,166,0,0,0,0,0,16,43,189,212,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,250,214,14,0,0,0,0,10,148,250,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,234,103,6,0,0,154,225,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,44,195,254,184,24,129,235,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,240,254,254,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,154,253,98,190,254,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,131,0,13,212,225,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,238,254,29,0,0,55,244,195,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,219,6,0,0,0,100,254,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,116,0,0,0,0,23,248,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,63,0,0,0,0,49,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,248,29,0,0,0,38,167,254,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,233,211,115,115,135,254,244,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,236,254,254,254,173,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,255,191,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,128,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,191,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,64,0,0,64,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,209,255,172,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,236,254,247,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,237,31,149,240,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,137,0,126,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,137,0,126,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,137,0,126,254,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,254,189,86,210,254,226,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,159,254,254,196,169,254,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,50,50,25,90,254,191,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,182,254,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,248,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,207,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,220,198,102,0,0,137,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,219,214,252,129,36,162,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,5,44,199,254,250,253,235,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,117,242,254,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,114,238,253,253,253,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,225,240,253,252,252,252,252,253,228,225,130,38,0,0,0,0,0,0,0,0,26,6,0,0,0,0,67,240,252,252,253,252,252,252,252,253,252,252,252,112,0,0,0,0,0,0,0,0,101,24,0,0,0,0,28,121,249,239,253,236,204,112,189,253,252,252,217,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,99,63,112,50,159,252,252,253,252,220,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,114,238,253,253,253,255,152,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,101,240,253,252,252,252,204,106,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,252,253,252,176,55,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,252,253,252,155,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,112,112,174,252,252,239,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,229,253,253,114,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,177,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,227,253,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,215,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,255,27,0,0,63,114,113,222,253,253,204,15,0,0,0,0,0,0,0,0,0,0,0,0,0,51,243,252,253,103,85,178,240,253,252,252,252,252,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,155,252,253,252,252,252,252,253,252,239,180,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,239,253,252,252,249,223,225,99,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,174,252,141,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,56,140,126,175,200,96,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,166,238,254,246,242,253,246,254,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,182,146,127,70,30,45,36,215,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,207,246,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,251,169,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,215,232,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,190,250,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,118,206,254,248,142,108,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,223,254,254,254,254,254,254,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,174,129,95,16,16,16,106,249,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,244,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,140,5,0,0,0,0,0,0,3,150,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,254,181,38,0,0,0,0,34,188,254,209,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,226,255,223,88,68,128,157,242,254,207,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,210,254,254,254,254,255,254,187,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,129,239,229,179,91,16,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,105,254,254,254,254,255,239,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,118,222,254,253,253,253,253,253,253,211,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,200,253,253,254,253,253,253,253,253,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,16,160,236,253,253,253,254,253,253,246,229,253,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,253,253,253,254,253,253,213,99,253,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,25,194,253,253,253,253,131,97,169,253,93,99,253,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,251,233,127,9,0,18,38,3,15,171,253,253,116,0,0,0,0,0,0,0,0,0,0,0,55,240,253,253,233,0,0,0,0,0,0,0,31,186,253,253,116,0,0,0,0,0,0,0,0,0,0,0,176,253,253,253,127,0,0,0,0,0,0,0,99,253,253,253,116,0,0,0,0,0,0,0,0,0,0,0,176,253,253,131,9,0,0,0,0,0,0,0,99,253,253,253,116,0,0,0,0,0,0,0,0,0,0,119,254,254,232,75,0,0,0,0,0,0,0,0,0,158,254,254,117,0,0,0,0,0,0,0,0,0,0,118,253,253,154,0,0,0,0,0,0,0,0,0,0,156,253,253,116,0,0,0,0,0,0,0,0,0,0,118,253,253,154,0,0,0,0,0,0,0,0,0,0,156,253,253,116,0,0,0,0,0,0,0,0,0,46,222,253,253,154,0,0,0,0,0,0,0,0,7,116,246,253,180,9,0,0,0,0,0,0,0,0,0,0,118,253,253,154,0,0,0,0,0,0,0,0,116,253,253,253,174,0,0,0,0,0,0,0,0,0,0,0,118,253,253,154,0,0,0,0,0,0,0,110,246,253,253,240,67,0,0,0,0,0,0,0,0,0,0,0,118,253,253,238,215,49,20,20,20,66,215,241,253,245,233,64,0,0,0,0,0,0,0,0,0,0,0,0,82,229,253,253,253,253,253,253,253,254,253,253,240,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,253,253,253,253,253,253,253,254,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,239,253,253,253,253,253,253,254,161,57,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,109,109,109,109,110,109,129,253,110,109,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,94,217,252,252,252,252,253,252,252,252,253,252,227,134,42,0,0,0,0,0,0,0,0,0,0,0,0,176,252,252,252,252,252,252,253,252,252,252,253,252,252,252,222,139,11,0,0,0,0,0,0,0,0,0,0,217,252,252,252,128,108,108,108,108,108,108,108,232,252,252,253,252,71,0,0,0,0,0,0,0,0,0,0,42,159,252,252,210,31,0,0,0,0,0,0,0,37,252,253,252,71,0,0,0,0,0,0,0,0,0,0,0,5,119,210,252,124,31,0,0,0,0,0,0,37,252,253,231,51,0,0,0,0,0,0,0,0,0,0,0,0,0,31,195,195,31,0,0,0,0,0,0,140,252,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,221,252,191,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,247,252,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,212,252,226,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,255,222,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,201,252,253,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,252,252,175,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,252,252,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,170,110,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,252,253,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,252,154,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,164,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,34,0,244,254,112,0,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,190,225,0,255,185,13,0,0,0,0,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,170,254,197,64,254,59,0,0,0,0,0,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,132,254,204,23,112,254,28,0,0,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,6,167,254,216,58,24,242,225,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,254,254,162,85,138,254,188,0,0,0,48,85,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,159,254,254,254,254,254,228,151,151,214,250,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,79,131,158,254,254,226,225,225,225,190,148,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,148,0,0,0,0,0,0,0,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,248,201,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,254,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,189,227,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,254,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,226,175,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,203,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,242,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,169,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,233,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,125,235,255,254,122,0,0,0,0,0,13,134,180,57,0,0,0,0,0,0,0,0,0,0,0,0,163,250,253,253,253,253,252,63,0,0,0,16,199,253,253,117,0,0,0,0,0,0,0,0,0,0,52,168,252,253,213,32,12,49,109,3,0,0,0,157,253,253,183,6,0,0,0,0,0,0,0,0,0,0,171,253,103,19,12,0,0,0,0,0,0,0,91,247,253,235,8,0,0,0,0,0,0,0,0,0,0,0,248,253,19,0,0,0,0,0,0,0,21,189,245,253,243,77,0,0,0,0,0,0,0,0,0,0,0,0,201,253,104,9,0,0,0,0,71,122,228,253,253,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,18,199,253,219,215,215,215,215,245,253,253,253,253,182,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,165,205,253,253,253,191,175,193,253,253,221,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,51,51,51,11,0,59,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,218,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,237,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,253,215,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,206,243,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,235,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,246,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,68,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,159,152,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,130,130,225,255,255,109,7,116,243,200,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,95,217,253,253,253,253,253,253,253,253,253,248,11,0,0,0,0,0,0,0,0,0,0,0,0,0,27,213,253,253,240,143,111,152,253,253,253,253,194,62,0,0,0,0,0,0,0,0,0,0,0,0,0,27,213,253,215,105,31,0,7,153,253,253,253,244,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,230,34,0,0,0,69,253,253,253,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,221,13,0,0,28,156,253,253,253,176,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,236,253,175,14,0,186,253,253,253,196,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,253,253,174,50,199,253,253,237,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,92,234,253,253,253,253,237,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,253,253,253,236,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,161,253,253,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,101,253,253,237,233,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,253,173,38,186,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,237,253,114,14,0,186,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,238,253,176,13,0,21,211,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,240,253,226,11,0,0,165,253,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,243,69,0,0,97,246,227,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,178,112,112,194,248,253,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,253,253,253,253,253,142,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,253,253,253,235,129,45,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,105,220,254,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,166,233,253,253,253,236,209,209,209,77,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,253,253,253,253,253,254,253,253,253,253,172,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,238,253,253,253,253,253,254,253,253,253,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,14,238,253,253,253,253,253,253,179,196,253,253,253,253,238,12,0,0,0,0,0,0,0,0,0,0,0,0,33,253,253,253,253,253,248,134,0,18,83,237,253,253,253,14,0,0,0,0,0,0,0,0,0,0,0,0,164,253,253,253,253,253,128,0,0,0,0,57,119,214,253,94,0,0,0,0,0,0,0,0,0,0,0,57,248,253,253,253,126,14,4,0,0,0,0,0,0,179,253,248,56,0,0,0,0,0,0,0,0,0,0,175,253,253,240,190,28,0,0,0,0,0,0,0,0,179,253,253,173,0,0,0,0,0,0,0,0,0,0,209,253,253,178,0,0,0,0,0,0,0,0,0,0,92,253,253,208,0,0,0,0,0,0,0,0,0,0,211,254,254,179,0,0,0,0,0,0,0,0,0,0,0,135,255,209,0,0,0,0,0,0,0,0,0,0,209,253,253,90,0,0,0,0,0,0,0,0,0,0,0,134,253,208,0,0,0,0,0,0,0,0,0,0,209,253,253,178,0,0,0,0,0,0,0,0,0,0,2,142,253,208,0,0,0,0,0,0,0,0,0,0,209,253,253,214,35,0,0,0,0,0,0,0,0,0,30,253,253,208,0,0,0,0,0,0,0,0,0,0,165,253,253,253,215,36,0,0,0,0,0,0,0,0,163,253,253,164,0,0,0,0,0,0,0,0,0,0,18,172,253,253,253,214,127,7,0,0,0,0,0,72,232,253,171,17,0,0,0,0,0,0,0,0,0,0,0,8,182,253,253,253,253,162,56,0,0,0,64,240,253,253,14,0,0,0,0,0,0,0,0,0,0,0,0,0,7,173,253,253,253,253,245,241,239,239,246,253,225,14,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,59,138,224,253,253,254,253,253,253,240,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,104,192,255,253,253,182,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,152,233,254,213,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,243,253,252,253,252,243,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,132,253,254,213,142,61,31,233,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,203,253,212,50,10,0,41,132,252,172,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,163,0,0,0,0,102,254,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,252,0,0,0,0,0,142,253,252,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,151,0,0,0,0,132,253,254,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,232,183,102,102,183,253,252,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,243,254,253,254,213,152,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,151,151,91,10,152,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,253,252,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,254,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,252,91,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,243,233,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,210,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,47,0,0,0,0,0,7,243,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,95,237,232,5,0,0,0,0,7,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,6,0,0,0,0,7,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,6,0,0,0,0,7,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,6,0,0,0,0,7,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,77,0,0,0,0,7,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,253,253,191,12,0,81,111,189,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,253,253,253,230,227,246,253,253,253,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,62,242,253,253,253,253,253,253,253,253,253,253,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,21,182,253,253,253,253,253,253,253,253,253,253,253,237,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,107,226,226,226,226,226,125,104,241,253,253,224,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,230,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,253,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,244,253,253,201,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,176,254,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,253,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,170,253,253,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,253,217,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,253,253,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,240,253,239,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,253,245,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,255,253,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,229,254,242,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,229,253,254,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,254,213,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,243,253,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,142,253,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,253,253,232,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,253,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,232,253,189,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,235,253,253,195,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,231,253,253,184,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,0,0,0,0,0,0,0,0,0,84,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,235,213,5,0,0,0,0,0,0,88,248,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,234,253,253,6,0,0,0,0,0,0,81,246,238,161,0,0,0,0,0,0,0,0,0,0,0,0,11,201,253,251,147,2,0,0,0,0,0,0,0,220,253,217,13,0,0,0,0,0,0,0,0,0,0,0,158,253,253,157,0,0,0,0,0,0,0,0,0,220,253,253,96,0,0,0,0,0,0,0,0,0,0,50,234,253,235,50,0,0,0,0,0,0,0,0,0,220,253,253,96,0,0,0,0,0,0,0,0,0,51,239,253,253,85,0,0,0,0,0,0,0,0,0,0,160,253,253,229,0,0,0,0,0,0,0,0,0,118,253,253,204,9,0,0,0,0,0,0,0,0,0,0,9,205,253,232,0,0,0,0,0,0,0,0,0,229,253,233,70,0,0,0,0,0,0,0,0,0,0,0,0,199,253,238,32,0,0,0,0,0,0,0,0,254,253,177,0,0,0,0,0,0,0,0,0,0,24,49,49,210,253,253,216,0,0,0,0,0,0,0,0,254,253,227,135,28,28,28,28,77,165,165,165,165,208,253,253,253,253,253,238,0,0,0,0,0,0,0,0,173,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,241,50,0,0,0,0,0,0,0,0,0,166,253,253,253,253,253,253,253,253,253,253,253,192,129,129,227,253,165,0,0,0,0,0,0,0,0,0,0,5,13,118,150,150,150,91,62,113,13,13,13,7,0,0,199,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,229,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,201,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,237,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,164,252,230,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,254,254,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,159,20,0,12,214,254,159,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,243,238,29,0,178,254,159,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,160,254,183,0,37,238,239,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,254,235,53,0,227,254,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,252,235,119,0,78,254,175,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,231,254,178,120,133,244,254,49,0,48,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,254,254,254,254,254,255,244,188,232,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,95,95,127,228,254,230,189,188,188,160,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,239,239,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,127,251,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,174,238,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,247,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,238,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,205,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,218,255,234,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,216,253,253,253,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,244,253,253,196,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,214,253,253,205,9,176,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,253,253,230,57,0,17,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,248,253,230,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,248,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,194,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,204,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,233,57,100,196,196,196,175,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,253,253,193,181,253,253,253,253,253,228,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,253,253,253,253,184,98,210,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,253,253,240,174,20,0,46,253,253,227,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,253,253,181,0,0,0,66,253,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,198,198,91,0,0,34,226,253,249,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,221,28,0,0,7,140,253,253,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,168,46,54,174,253,253,220,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,229,253,253,253,253,253,253,251,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,227,252,253,253,253,252,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,159,152,123,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,176,253,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,176,251,251,251,251,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,217,241,253,251,251,251,251,243,113,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,231,251,251,253,251,251,251,251,253,251,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,253,251,251,251,251,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,253,253,253,255,253,253,253,253,255,253,227,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,251,251,253,251,251,251,251,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,27,253,251,251,235,241,253,251,246,137,35,98,251,251,236,61,0,0,0,0,0,0,0,0,0,0,0,47,211,253,251,235,82,103,253,251,137,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,0,0,27,211,251,253,251,86,0,0,72,71,10,0,0,73,251,251,173,20,0,0,0,0,0,0,0,0,0,0,89,253,253,255,253,35,0,0,0,0,0,0,0,73,253,253,253,72,0,0,0,0,0,0,0,0,0,84,236,251,251,253,251,138,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,63,236,251,251,251,227,251,246,138,11,0,0,0,16,37,228,251,246,137,10,0,0,0,0,0,0,0,0,73,251,251,251,173,42,142,142,142,41,0,0,0,109,251,253,251,137,0,0,0,0,0,0,0,0,0,0,73,251,251,173,20,0,0,0,0,0,0,0,27,211,251,253,147,10,0,0,0,0,0,0,0,0,0,0,73,253,253,143,0,0,0,0,0,0,21,176,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,251,205,144,0,0,0,0,0,176,251,251,188,107,0,0,0,0,0,0,0,0,0,0,0,0,0,62,236,251,251,251,218,217,217,217,217,253,230,189,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,158,251,251,253,251,251,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,251,251,253,251,251,251,122,72,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,237,121,0,0,0,0,0,0,13,48,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,235,254,202,0,0,0,0,0,8,179,254,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,254,237,48,0,0,0,0,0,10,209,254,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,254,112,0,0,0,0,0,0,16,233,251,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,240,222,20,0,0,0,0,0,0,118,254,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,231,255,120,0,0,0,0,0,0,23,205,254,111,0,0,0,0,0,0,0,0,0,0,0,0,0,6,168,255,241,47,0,0,0,0,0,0,85,254,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,254,67,0,0,0,0,0,0,8,200,254,184,13,0,0,0,0,0,0,0,0,0,0,0,0,3,172,254,221,18,0,0,0,0,0,0,120,254,246,48,0,0,0,0,0,0,0,0,0,0,0,0,0,162,254,238,30,0,0,0,0,0,0,0,157,254,212,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,254,105,0,0,0,0,0,0,0,112,252,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,198,254,172,1,0,0,0,36,107,146,249,253,254,210,13,0,0,0,0,0,0,0,0,0,0,0,0,0,198,254,134,10,89,96,193,245,254,254,254,254,254,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,254,244,241,254,254,254,254,223,140,252,254,169,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,252,254,254,254,218,176,88,0,0,250,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,60,119,26,14,0,0,0,9,251,254,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,254,194,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,37,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,51,110,160,207,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,136,212,253,254,253,253,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,80,195,255,254,254,222,181,182,181,135,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,223,250,253,253,254,182,18,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,133,228,253,247,216,151,69,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,253,254,253,116,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,227,254,253,227,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,182,249,254,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,253,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,92,0,0,0,0,184,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,218,46,0,0,27,242,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,254,254,215,228,255,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,160,206,253,214,140,108,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,36,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,128,128,128,128,128,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,128,128,128,128,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,128,64,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,64,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,64,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,128,128,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,45,131,131,131,101,68,92,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,112,89,0,40,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,254,251,127,40,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,254,254,91,40,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,247,254,236,50,40,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,254,254,91,0,6,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,218,254,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,254,255,239,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,254,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,242,254,241,88,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,254,254,189,0,0,0,28,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,254,254,168,0,0,0,40,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,245,51,0,0,0,35,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,239,254,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,254,210,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,252,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,170,255,255,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,198,255,255,255,226,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,255,170,29,0,86,255,255,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,226,255,198,57,0,0,0,0,226,255,255,226,114,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,255,114,0,0,0,0,0,0,141,170,114,255,255,141,0,0,0,0,0,0,0,0,0,0,0,0,226,255,170,0,0,0,0,0,0,0,29,57,0,0,141,255,226,0,0,0,0,0,0,0,0,0,0,57,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,198,0,0,0,0,0,0,0,0,0,226,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,57,0,0,0,0,0,0,0,0,255,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,170,0,0,0,0,0,0,0,0,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,198,0,0,0,0,0,0,0,0,255,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,0,0,0,0,0,0,0,0,198,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,0,0,0,0,0,0,0,0,114,255,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,0,0,0,0,0,0,0,0,29,255,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,0,0,0,0,0,0,0,0,0,170,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,198,0,0,0,0,0,0,0,0,0,29,226,255,170,0,0,0,0,0,0,0,0,0,0,0,0,29,255,114,0,0,0,0,0,0,0,0,0,0,29,226,255,141,0,0,0,0,0,0,0,0,0,0,57,226,226,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,255,170,86,0,0,0,0,29,86,226,255,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,198,255,255,255,255,255,255,255,255,255,141,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,114,170,170,170,170,170,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,252,252,252,214,51,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,221,252,250,250,250,252,250,160,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,211,250,252,250,250,250,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,221,250,250,252,250,250,250,252,250,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,252,252,252,254,252,252,252,254,252,252,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,190,250,250,252,250,250,169,171,250,250,250,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,191,250,250,252,189,100,20,172,250,250,250,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,250,250,250,212,29,0,0,252,250,250,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,252,252,252,0,0,0,0,51,252,252,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,252,250,250,169,0,0,0,0,132,250,250,250,121,0,0,0,0,0,0,0,0,0,0,0,0,0,92,231,252,250,159,20,0,0,0,0,252,250,250,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,211,252,250,221,40,0,0,0,0,90,250,250,250,163,0,0,0,0,0,0,0,0,0,0,0,0,0,31,213,254,232,80,0,0,0,0,0,92,252,252,212,163,0,0,0,0,0,0,0,0,0,0,0,0,0,151,250,252,149,0,0,0,0,0,0,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,221,252,210,60,0,0,0,0,0,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,252,250,221,40,0,0,123,202,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,243,255,252,252,252,254,252,252,252,254,252,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,171,250,250,250,252,250,250,250,252,250,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,160,250,250,252,250,250,250,252,189,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,170,250,252,250,128,49,49,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,243,253,249,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,223,253,253,247,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,238,253,253,253,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,236,253,253,253,253,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,253,191,247,253,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,143,86,249,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,36,7,14,233,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,255,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,245,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,253,253,0,0,0,0,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,253,253,0,0,9,142,233,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,253,253,128,7,99,253,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,230,253,253,252,210,253,253,253,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,207,253,253,253,254,253,253,235,70,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,253,253,253,254,253,168,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,201,190,132,63,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,19,133,133,156,254,254,214,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,134,197,254,253,253,253,253,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,78,194,253,253,254,250,217,217,226,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,10,135,234,253,253,253,253,246,76,0,10,98,253,253,133,0,0,0,0,0,0,0,0,0,0,0,0,9,155,253,253,253,224,198,134,69,0,0,78,253,253,192,10,0,0,0,0,0,0,0,0,0,0,0,0,9,140,180,88,60,32,6,0,0,0,63,234,253,163,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,189,253,163,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,221,253,211,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,253,238,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,249,242,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,249,249,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,232,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,194,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,232,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,240,230,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,211,229,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,126,253,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,253,144,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,195,227,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,230,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,240,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,238,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,226,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,254,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,254,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,254,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,235,254,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,227,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,255,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,212,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,134,255,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,214,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,198,253,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,208,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,229,243,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,228,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,186,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,230,253,68,0,0,0,20,56,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,188,253,182,18,17,63,162,209,253,227,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,253,215,18,17,179,253,253,253,253,253,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,233,253,107,0,159,253,253,193,136,101,244,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,253,178,16,85,240,231,136,10,0,76,248,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,189,253,86,42,241,253,185,0,0,0,94,219,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,253,240,71,185,253,154,27,0,0,33,213,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,216,93,253,231,41,0,0,81,213,253,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,216,117,253,221,106,106,142,249,253,214,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,251,157,214,253,253,253,253,253,118,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,159,253,253,253,253,253,253,219,35,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,253,253,253,223,96,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,159,253,159,243,191,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,253,252,252,252,252,253,236,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,205,253,252,252,252,252,253,252,202,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,160,203,160,160,160,108,253,252,252,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,53,253,252,252,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,255,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,47,140,244,253,252,102,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,252,252,252,253,252,252,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,236,252,252,64,211,252,252,194,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,211,221,43,2,86,252,252,252,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,253,253,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,252,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,234,252,252,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,252,252,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,252,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,154,0,0,0,0,36,222,253,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,236,78,9,22,57,219,252,235,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,196,215,253,252,252,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,252,252,252,252,253,252,101,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,211,252,252,200,137,64,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,91,213,255,228,91,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,230,253,253,253,253,253,152,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,246,253,253,253,253,253,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,247,253,253,253,253,253,253,208,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,253,253,253,253,253,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,238,253,253,253,221,253,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,253,253,198,40,177,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,156,251,253,189,182,15,0,86,240,253,210,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,253,156,3,0,0,0,0,205,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,252,253,135,3,0,0,0,0,0,46,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,28,212,253,248,23,0,0,0,0,0,0,42,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,234,70,0,0,0,0,0,0,0,42,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,11,202,253,187,0,0,0,0,0,0,0,0,58,253,210,27,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,40,0,0,0,0,0,0,0,53,227,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,40,0,0,0,0,0,0,47,227,253,231,58,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,40,0,0,0,0,5,131,222,253,231,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,204,253,226,222,73,58,58,170,253,253,227,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,253,253,253,253,253,253,238,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,179,241,253,253,253,253,250,116,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,179,253,151,89,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,80,80,80,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,159,159,199,254,254,254,228,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,62,160,252,254,254,254,254,233,233,254,245,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,212,254,254,254,186,114,114,114,74,75,251,254,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,254,244,210,58,18,0,0,0,0,30,249,254,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,131,100,0,0,0,0,0,0,0,168,254,254,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,237,254,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,157,254,254,192,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,140,254,254,203,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,254,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,204,254,196,87,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,212,254,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,254,192,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,242,249,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,254,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,254,250,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,254,254,196,116,76,0,112,48,0,0,16,116,116,116,116,0,0,0,0,0,0,0,0,0,0,0,0,11,154,254,254,254,234,194,253,219,194,194,203,254,241,237,237,0,0,0,0,0,0,0,0,0,0,0,0,0,77,157,198,254,254,254,254,254,254,254,173,157,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,78,78,78,78,78,78,78,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,228,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,236,251,235,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,202,255,253,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,129,251,253,127,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,251,251,201,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,228,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,236,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,251,251,204,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,252,102,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,254,253,254,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,252,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,254,253,254,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,252,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,254,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,252,253,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,253,254,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,252,253,252,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,253,254,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,243,253,252,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,254,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,253,252,253,252,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,213,254,253,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,252,253,252,192,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,214,253,255,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,252,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,255,253,203,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,131,233,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,129,253,192,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,94,217,218,227,252,252,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,37,182,201,252,252,253,252,252,252,253,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,120,252,253,252,252,252,253,252,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,63,109,232,252,252,253,252,174,143,47,232,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,73,237,252,252,252,210,180,138,10,0,233,252,252,210,20,0,0,0,0,0,0,0,0,0,0,0,0,0,72,236,215,91,71,31,0,0,0,21,253,252,246,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0,0,0,0,21,206,253,210,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,208,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,242,252,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,242,252,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,252,231,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,255,222,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,232,252,175,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,237,252,252,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,253,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,252,231,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,221,252,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,189,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,138,201,253,255,232,107,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,219,252,252,210,207,214,252,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,233,89,6,0,13,202,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,253,252,183,0,0,0,0,159,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,252,79,0,0,0,0,63,43,220,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,232,38,0,0,0,0,7,212,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,252,154,30,0,0,9,155,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,252,252,227,184,132,197,252,252,252,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,119,160,236,252,253,252,227,160,244,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,0,0,61,85,75,22,16,0,178,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,128,11,0,0,0,0,0,0,0,0,231,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,116,0,0,0,0,0,0,0,0,157,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,116,0,0,0,0,0,0,0,0,116,237,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,252,63,0,0,0,0,0,0,0,0,116,234,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,252,116,0,0,0,0,0,0,0,0,220,241,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,244,61,0,0,0,0,0,38,233,253,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,217,253,236,129,9,0,0,30,155,252,231,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,253,252,252,196,80,185,228,252,227,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,219,252,252,252,253,252,252,119,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,54,179,147,190,117,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,195,254,254,254,254,254,255,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,191,253,253,253,253,253,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,190,253,253,253,253,240,191,242,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,187,253,253,253,253,253,200,0,211,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,66,253,253,253,253,241,209,44,23,218,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,253,253,253,182,0,0,131,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,217,253,253,244,111,37,0,0,131,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,253,165,0,0,0,22,182,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,240,45,0,0,0,53,253,253,249,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,168,253,216,45,0,0,0,0,53,253,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,253,253,147,0,0,0,0,0,53,253,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,252,253,227,5,0,0,0,0,0,53,253,243,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,253,124,0,0,0,0,0,0,156,253,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,164,253,142,5,0,0,0,0,0,32,233,253,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,253,130,0,0,0,0,0,37,203,253,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,253,147,36,36,36,36,151,222,253,245,127,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,202,253,253,253,253,253,253,253,253,253,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,253,253,253,253,253,253,248,235,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,173,253,253,253,253,253,253,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,78,96,253,253,253,137,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,78,156,209,165,43,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,157,252,252,252,252,253,205,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,252,252,252,252,253,252,225,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,252,252,252,252,227,252,252,196,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,252,252,226,59,42,182,252,252,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,254,222,106,0,0,0,36,224,253,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,63,16,0,0,0,0,0,48,252,252,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,210,252,215,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,252,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,218,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,85,85,85,85,85,57,0,0,211,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,2,92,127,192,252,252,252,252,253,246,232,232,249,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,92,252,252,253,252,252,252,252,253,252,252,252,252,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,215,252,252,253,252,252,252,252,253,252,252,252,252,253,203,9,0,0,0,0,0,0,0,0,0,0,0,85,253,253,253,194,106,53,0,0,62,120,156,253,253,255,253,188,0,0,0,0,0,0,0,0,0,0,0,85,252,252,252,129,57,71,0,71,146,211,252,252,252,160,231,231,0,0,0,0,0,0,0,0,0,0,0,85,252,252,252,253,246,249,232,249,253,252,252,252,244,53,51,72,0,0,0,0,0,0,0,0,0,0,0,64,247,252,252,253,252,252,252,252,253,252,252,236,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,252,252,253,252,252,252,252,253,252,235,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,64,0,0,0,64,128,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,191,0,0,0,128,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,64,0,0,128,255,255,255,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,128,0,0,128,255,255,191,0,0,128,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,64,0,0,191,255,191,0,0,0,64,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,191,0,0,64,255,255,0,0,0,0,64,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,64,0,0,128,255,191,0,0,0,0,191,255,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,0,0,0,128,255,64,0,0,64,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,0,0,0,0,255,255,128,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,128,128,128,128,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,191,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,214,253,152,152,152,152,152,152,152,152,254,253,254,172,152,71,0,0,0,0,0,0,0,0,0,0,0,61,213,252,253,252,253,252,253,252,253,252,213,252,253,252,253,252,82,0,0,0,0,0,0,0,0,0,0,0,0,41,102,102,102,102,82,0,0,0,0,0,0,0,52,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,253,252,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,243,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,233,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,223,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,254,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,213,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,233,30,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,254,213,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,232,253,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,211,254,254,255,254,133,8,0,36,98,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,157,253,253,243,173,100,250,123,7,147,186,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,253,225,82,57,0,0,249,244,187,240,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,236,54,0,0,0,0,249,253,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,238,33,0,0,34,197,252,253,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,199,0,0,200,253,253,253,211,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,251,252,160,215,252,253,245,61,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,253,253,253,243,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,253,253,218,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,168,244,236,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,199,49,87,253,187,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,144,205,70,0,10,204,253,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,129,0,0,0,88,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,229,248,13,0,0,0,78,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,133,0,0,0,0,91,242,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,201,195,10,0,0,0,0,195,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,253,134,0,0,0,11,148,237,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,198,253,86,0,41,84,111,253,153,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,221,253,241,219,236,253,237,126,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,223,253,253,195,69,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,77,142,254,254,254,254,254,163,98,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,252,241,241,243,253,253,253,253,219,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,229,111,100,0,0,19,111,111,141,249,253,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,56,228,253,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,141,253,253,208,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,253,253,226,161,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,231,210,243,253,253,224,123,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,0,61,117,219,253,253,183,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,117,245,253,135,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,246,253,169,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,235,253,167,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,248,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,26,0,0,0,0,0,0,163,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,219,206,112,112,112,112,112,224,252,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,195,253,253,253,253,253,253,201,78,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,5,5,51,129,17,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,125,225,254,254,255,254,170,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,101,250,253,253,253,253,253,253,253,250,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,246,247,253,253,196,227,116,56,253,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,253,180,19,9,15,0,4,55,253,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,238,253,253,125,0,0,0,21,189,232,253,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,253,220,165,34,92,21,52,228,253,253,241,82,13,0,0,0,0,0,0,0,0,0,0,0,0,0,38,241,170,25,20,12,75,39,59,253,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,236,67,0,0,0,0,100,253,253,221,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,239,253,235,202,135,99,173,240,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,200,253,253,253,253,253,253,253,241,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,112,244,253,237,142,253,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,71,51,159,253,188,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,150,236,212,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,243,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,237,253,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,219,253,195,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,171,253,207,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,198,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,242,253,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,253,206,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,76,202,254,255,163,37,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,182,253,253,253,253,253,253,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,179,253,253,212,91,218,253,253,179,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,253,160,35,156,253,253,253,253,250,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,212,253,253,88,121,253,233,128,91,245,253,248,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,253,253,110,2,142,253,90,0,0,26,199,253,248,63,0,0,0,0,0,0,0,0,0,0,0,0,1,173,253,253,29,0,84,228,39,0,0,0,72,251,253,215,29,0,0,0,0,0,0,0,0,0,0,0,36,253,253,203,13,0,0,0,0,0,0,0,0,82,253,253,170,0,0,0,0,0,0,0,0,0,0,0,36,253,253,164,0,0,0,0,0,0,0,0,0,11,198,253,184,6,0,0,0,0,0,0,0,0,0,0,36,253,253,82,0,0,0,0,0,0,0,0,0,0,138,253,253,35,0,0,0,0,0,0,0,0,0,0,128,253,253,47,0,0,0,0,0,0,0,0,0,0,48,253,253,35,0,0,0,0,0,0,0,0,0,0,154,253,253,47,0,0,0,0,0,0,0,0,0,0,48,253,253,35,0,0,0,0,0,0,0,0,0,0,102,253,253,99,0,0,0,0,0,0,0,0,0,0,48,253,253,35,0,0,0,0,0,0,0,0,0,0,36,253,253,164,0,0,0,0,0,0,0,0,0,16,208,253,211,17,0,0,0,0,0,0,0,0,0,0,32,244,253,175,4,0,0,0,0,0,0,0,0,44,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,29,0,0,0,0,0,0,0,30,217,253,188,19,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,59,0,0,0,0,0,0,60,217,253,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,253,231,48,0,0,0,26,128,249,253,244,94,15,0,0,0,0,0,0,0,0,0,0,0,0,0,8,151,253,253,234,101,121,219,229,253,253,201,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,232,253,253,253,253,253,253,253,201,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,86,46,0,0,0,0,0,0,91,246,252,232,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,252,187,13,0,0,0,0,22,219,252,252,175,0,0,0,0,0,0,0,0,0,10,0,0,0,0,8,181,252,246,30,0,0,0,0,65,252,237,197,64,0,0,0,0,0,0,0,0,0,87,0,0,0,13,172,252,252,104,0,0,0,0,5,184,252,67,103,0,0,0,0,0,0,0,0,0,0,0,0,0,8,172,252,248,145,14,0,0,0,0,109,252,183,137,64,0,0,0,0,0,0,0,0,0,0,0,0,5,224,252,248,134,0,0,0,0,0,53,238,252,245,86,0,0,0,0,0,0,0,0,0,0,0,0,12,174,252,223,88,0,0,0,0,0,0,209,252,252,179,9,0,0,0,0,0,0,0,0,0,0,0,11,171,252,246,61,0,0,0,0,0,0,83,241,252,211,14,0,0,0,0,0,0,0,0,0,0,0,0,129,252,252,249,220,220,215,111,192,220,221,243,252,252,149,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,253,253,253,253,253,253,253,253,255,253,226,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,77,77,77,77,77,77,77,77,153,253,235,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,214,240,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,221,243,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,180,252,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,252,153,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,136,251,226,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,252,246,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,175,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,214,225,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,145,212,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,253,246,188,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,164,254,253,223,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,236,253,252,124,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,217,253,218,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,175,225,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,217,241,248,114,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,201,253,253,114,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,213,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,254,254,169,0,0,0,0,0,2,13,100,133,89,0,0,0,0,0,0,0,0,0,0,0,0,0,18,210,253,253,100,0,0,0,19,76,116,253,253,253,176,4,0,0,0,0,0,0,0,0,0,0,0,0,41,222,253,208,18,0,0,93,209,232,217,224,253,253,241,31,0,0,0,0,0,0,0,0,0,0,0,0,157,253,253,229,32,0,154,250,246,36,0,49,253,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,253,253,195,125,247,166,69,0,0,37,236,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,253,253,253,253,135,32,0,7,130,73,202,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,7,185,253,253,253,253,64,0,10,210,253,253,253,153,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,253,253,253,238,218,221,253,253,235,156,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,111,228,253,253,253,253,254,253,168,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,110,178,253,253,249,63,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,121,240,253,218,121,121,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,107,184,240,253,252,252,252,252,252,252,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,122,230,252,252,252,253,252,252,252,252,252,252,239,56,0,0,0,0,0,0,0,0,0,0,77,129,213,244,252,252,252,252,252,253,252,252,209,252,252,252,225,0,0,0,0,0,0,0,0,0,0,0,240,252,252,252,252,252,252,213,185,53,53,53,89,252,252,252,120,0,0,0,0,0,0,0,0,0,0,0,240,232,198,93,164,108,66,28,0,0,0,0,81,252,252,222,24,0,0,0,0,0,0,0,0,0,0,0,76,50,0,0,0,0,0,0,0,0,0,0,171,252,243,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,238,252,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,70,241,248,133,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,252,252,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,253,209,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,246,253,207,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,172,252,209,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,168,252,252,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,208,252,241,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,166,252,204,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,166,243,191,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,168,231,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,172,241,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,202,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,49,0,0,0,0,0,0,34,244,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,135,0,0,0,0,0,0,40,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,150,0,0,0,0,0,0,40,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,233,0,0,0,0,0,0,77,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,136,0,0,0,0,0,0,77,254,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,135,0,0,0,0,0,0,123,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,135,0,0,0,0,0,0,136,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,254,135,0,0,0,0,0,0,136,237,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,135,0,0,38,99,98,98,219,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,255,208,186,254,254,255,254,254,254,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,253,239,180,135,39,39,39,237,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,92,24,0,0,0,0,0,234,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,237,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,242,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,248,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,236,255,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,231,253,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,193,253,253,230,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,156,253,253,149,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,190,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,175,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,253,138,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,244,253,230,34,0,9,24,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,253,249,123,0,69,195,253,249,146,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,231,253,202,0,70,236,253,253,253,253,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,139,253,213,26,13,200,253,253,183,252,253,220,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,253,129,0,86,253,253,129,4,105,253,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,253,77,22,245,253,183,4,0,2,105,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,253,11,24,253,253,116,0,0,1,150,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,241,10,24,253,253,59,0,0,82,253,212,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,147,0,24,253,253,150,30,44,208,212,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,174,3,7,185,253,253,227,247,184,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,253,145,95,234,253,253,253,126,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,253,253,253,253,253,253,169,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,114,240,253,253,234,135,44,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,139,212,253,159,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,89,203,253,252,252,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,184,234,252,252,184,110,100,208,252,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,233,252,252,176,56,0,0,0,17,234,249,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,253,178,54,4,0,0,0,0,43,240,243,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,255,180,55,5,0,0,0,7,160,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,252,252,67,0,0,0,91,252,231,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,190,252,252,185,38,0,119,234,252,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,177,252,252,179,155,236,227,119,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,221,252,252,253,252,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,229,253,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,236,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,234,252,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,236,252,252,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,181,252,168,43,232,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,255,218,32,93,253,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,244,239,33,0,114,252,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,237,70,153,240,252,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,253,252,252,252,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,242,253,252,168,96,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,254,255,254,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,176,230,253,253,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,197,253,253,253,253,253,229,107,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,253,253,253,253,253,253,253,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,241,253,253,253,253,241,186,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,161,253,253,253,246,40,57,231,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,253,253,253,154,0,25,253,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,253,253,135,8,0,3,128,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,238,253,253,253,7,0,0,0,116,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,165,253,253,231,70,1,0,0,0,78,237,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,253,253,253,182,0,0,0,0,0,0,200,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,253,253,253,24,0,0,0,0,0,0,42,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,253,24,0,0,0,0,0,0,163,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,189,13,0,0,0,0,0,53,227,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,114,0,0,0,0,0,21,227,253,231,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,114,0,0,0,5,131,143,253,231,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,236,73,58,217,223,253,253,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,253,253,253,253,253,253,253,253,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,253,253,253,253,253,253,253,182,15,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,168,253,253,253,253,253,248,89,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,67,141,205,255,255,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,57,121,188,253,253,254,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,198,241,253,254,253,253,215,179,253,253,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,242,253,253,253,191,116,28,16,79,253,253,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,114,114,13,0,0,0,0,142,254,207,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,217,253,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,254,234,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,242,252,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,241,253,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,180,254,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,177,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,254,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,254,253,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,254,253,235,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,228,103,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,29,29,66,28,0,0,10,179,242,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,144,253,252,252,215,170,82,28,209,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,252,253,252,252,252,253,240,72,210,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,246,252,178,28,28,28,253,151,91,252,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,179,253,178,0,0,0,0,166,91,229,253,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,196,252,103,0,0,0,0,16,215,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,252,228,38,0,0,0,204,252,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,228,252,226,38,38,213,253,252,127,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,255,203,253,253,214,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,184,253,252,252,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,184,253,252,252,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,159,252,253,252,252,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,114,194,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,225,233,96,0,131,252,252,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,252,80,0,13,206,252,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,225,253,102,6,0,13,206,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,251,75,0,0,104,253,206,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,252,244,144,95,169,253,252,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,252,253,252,252,252,244,93,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,128,253,252,202,102,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,108,233,253,255,180,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,219,252,252,252,253,252,227,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,222,252,233,141,69,79,227,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,235,64,0,0,0,161,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,128,18,0,0,0,22,244,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,99,253,244,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,153,240,252,253,240,101,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,252,252,252,253,252,252,215,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,221,210,137,23,96,221,252,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,253,253,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,223,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,248,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,138,253,253,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,47,34,0,0,5,136,252,252,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,252,234,90,70,191,252,252,227,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,252,252,252,252,253,235,128,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,211,252,252,252,137,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,255,103,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,253,253,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,253,253,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,233,253,244,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,253,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,240,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,208,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,253,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,110,253,235,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,223,235,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,235,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,145,253,231,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,220,231,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,205,253,176,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,125,253,185,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,214,231,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,253,225,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,205,207,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,249,233,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,18,46,136,136,244,255,241,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,94,163,253,253,253,253,238,218,204,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,253,253,253,237,200,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,246,253,247,108,65,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,253,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,253,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,250,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,231,249,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,253,231,213,213,123,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,253,253,253,253,253,190,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,116,72,124,209,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,219,253,206,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,246,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,226,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,209,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,7,7,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,13,120,137,186,254,254,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,53,143,179,254,254,254,255,254,254,193,0,0,0,0,0,0,0,0,0,0,0,0,0,4,25,50,149,175,254,254,254,254,254,254,255,254,254,108,0,0,0,0,0,0,0,0,0,0,0,0,96,170,254,254,254,254,254,245,183,99,99,147,252,254,196,3,0,0,0,0,0,0,0,0,4,145,162,162,219,254,254,254,246,186,93,66,0,0,0,125,246,254,119,2,0,0,0,0,0,0,0,0,87,215,254,254,254,254,204,87,68,0,0,0,0,0,46,197,254,180,47,0,0,0,0,0,0,0,0,0,168,254,156,80,80,80,28,0,0,0,0,0,0,0,126,245,255,57,0,0,0,0,0,0,0,0,0,0,2,74,33,0,0,0,0,0,0,0,0,0,0,43,200,254,91,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,245,205,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,244,254,85,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,217,254,121,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,254,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,245,215,58,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,246,254,185,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,254,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,237,254,126,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,254,254,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,254,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,6,6,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,250,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,254,250,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,253,252,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,251,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,254,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,250,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,255,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,13,88,156,254,162,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,145,145,145,151,253,253,253,253,253,217,21,0,0,0,0,0,0,0,0,0,0,0,0,0,25,66,157,235,253,253,253,254,253,248,217,243,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,106,226,253,253,253,253,253,149,142,84,72,10,195,253,196,12,0,0,0,0,0,0,0,0,0,0,0,0,128,253,253,207,193,146,72,4,0,0,0,49,253,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,9,60,60,14,0,0,0,0,0,0,0,84,253,232,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,242,230,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,199,232,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,243,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,254,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,203,251,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,244,246,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,248,160,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,247,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,114,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,228,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,236,251,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,232,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,251,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,251,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,242,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,255,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,181,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,236,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,254,255,254,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,253,228,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,227,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,188,253,253,253,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,253,253,157,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,107,253,253,245,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,253,240,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,248,253,253,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,102,242,253,253,110,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,253,253,214,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,253,240,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,253,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,217,253,253,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,219,253,140,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,151,237,73,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,254,254,254,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,169,254,254,219,246,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,168,254,237,130,2,193,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,126,254,254,139,0,0,137,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,255,254,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,245,254,150,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,254,244,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,251,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,240,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,181,54,203,203,203,203,101,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,254,223,240,254,254,254,254,254,251,195,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,254,254,254,254,180,166,166,253,254,254,203,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,254,178,51,3,0,0,15,94,247,254,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,254,31,0,0,0,0,0,0,240,254,240,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,255,31,0,0,0,0,4,179,253,254,253,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,249,254,175,24,0,0,27,184,254,254,254,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,247,254,231,131,179,233,254,254,249,137,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,185,235,254,254,254,254,211,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,195,254,254,152,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,191,255,253,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,73,115,242,252,253,252,252,252,238,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,221,253,252,252,252,253,252,252,252,253,190,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,253,210,108,108,108,108,128,252,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,83,0,0,0,0,0,37,252,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,181,252,253,189,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,252,252,237,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,237,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,255,253,253,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,115,222,252,253,252,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,252,252,252,217,215,241,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,231,108,0,0,181,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,145,104,0,0,0,0,182,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,201,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,237,252,252,62,0,0,0,0,0,0,0,0,0,0,0,0,0,79,109,0,0,0,0,110,109,109,191,255,253,237,62,0,0,0,0,0,0,0,0,0,0,0,0,0,187,242,252,217,217,217,217,253,252,252,252,253,231,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,252,252,252,252,252,252,253,220,215,215,217,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,211,252,189,108,108,108,108,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,192,254,250,147,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,247,253,254,253,253,196,79,176,175,175,124,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,247,247,176,95,102,117,243,237,192,232,253,253,245,152,6,0,0,0,0,0,0,0,0,0,0,0,23,229,253,138,0,0,0,0,219,58,0,95,118,80,230,254,196,30,0,0,0,0,0,0,0,0,0,0,120,254,205,8,0,0,0,0,114,0,0,0,0,0,38,255,254,155,5,0,0,0,0,0,0,0,0,0,156,253,92,0,0,0,0,0,0,0,0,0,0,0,0,61,235,253,102,0,0,0,0,0,0,0,0,0,224,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,117,253,196,18,0,0,0,0,0,0,0,0,254,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,9,211,253,73,0,0,0,0,0,0,0,0,254,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,155,0,0,0,0,0,0,0,0,194,254,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,155,0,0,0,0,0,0,0,0,112,253,211,9,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,200,0,0,0,0,0,0,0,0,41,241,253,87,0,0,0,0,0,0,0,0,0,0,0,0,0,25,240,253,0,0,0,0,0,0,0,0,0,147,253,227,47,0,0,0,0,0,0,0,0,0,0,0,0,94,253,200,0,0,0,0,0,0,0,0,0,5,193,253,230,76,0,0,0,0,0,0,0,0,0,0,0,175,253,155,0,0,0,0,0,0,0,0,0,0,31,219,254,255,126,18,0,0,0,0,0,0,0,14,149,254,244,45,0,0,0,0,0,0,0,0,0,0,0,21,158,254,253,226,162,118,96,20,20,73,118,224,253,247,85,0,0,0,0,0,0,0,0,0,0,0,0,0,30,155,253,253,253,253,254,253,253,253,253,254,247,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,117,206,244,229,213,213,213,176,117,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,152,152,152,86,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,190,247,254,254,254,254,233,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,244,195,135,216,244,254,254,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,254,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,180,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,119,247,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,74,192,254,244,163,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,142,254,254,251,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,184,254,233,151,26,0,0,0,0,0,0,0,0,0,0,0,13,22,13,0,0,0,0,0,0,0,0,64,254,249,0,0,0,0,0,0,0,0,0,40,60,72,168,168,216,254,218,0,0,0,0,0,0,0,0,147,254,253,141,67,0,0,76,99,167,207,207,238,254,254,254,254,254,227,111,0,0,0,0,0,0,0,0,6,187,254,254,251,245,245,252,254,254,254,254,248,227,227,153,119,59,8,0,0,0,0,0,0,0,0,0,0,59,129,228,254,254,254,254,254,213,189,88,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,124,151,151,151,144,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,133,254,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,81,226,253,253,253,228,44,50,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,253,215,111,204,253,253,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,244,253,163,14,0,9,212,253,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,246,253,196,19,0,0,0,183,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,246,253,198,17,0,0,1,117,250,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,69,0,0,0,78,253,253,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,225,4,0,0,63,245,253,222,253,250,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,253,223,0,15,132,229,252,135,25,253,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,253,253,249,250,253,204,63,0,15,253,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,253,253,253,253,212,22,0,0,15,253,239,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,94,184,193,138,22,0,0,0,16,253,254,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,230,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,248,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,232,253,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,185,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,91,47,77,91,133,254,254,254,254,254,254,255,254,255,254,101,32,0,0,0,0,0,0,0,0,0,2,117,253,218,242,253,253,253,253,253,253,253,253,253,253,253,253,253,100,0,0,0,0,0,0,0,0,0,17,253,253,253,253,253,253,253,253,253,253,242,195,253,253,253,253,253,253,0,0,0,0,0,0,0,0,0,4,126,220,236,253,253,202,56,56,162,56,51,26,56,56,228,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,64,129,198,108,0,0,0,0,0,0,0,0,222,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,9,0,0,0,0,0,23,50,134,248,253,253,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,11,0,0,0,55,139,191,253,253,253,253,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,56,66,215,230,230,230,239,253,253,253,253,253,214,33,9,0,0,0,0,0,0,0,0,0,0,0,0,77,238,253,253,253,253,253,253,253,253,253,253,217,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,253,253,253,253,253,253,253,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,81,171,245,143,81,86,245,245,245,246,253,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,218,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,162,253,215,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,186,253,253,15,0,0,0,0,0,0,0,0,0,15,42,42,36,0,0,0,0,0,0,0,0,0,0,68,253,253,253,15,0,0,0,0,0,0,0,0,0,91,253,253,237,131,21,0,0,0,0,0,0,99,131,230,253,253,176,8,0,0,0,0,0,0,0,0,0,197,253,253,253,253,226,222,222,222,62,63,222,245,253,253,253,165,13,0,0,0,0,0,0,0,0,0,0,91,253,253,253,253,253,253,253,253,253,253,253,253,253,229,106,13,0,0,0,0,0,0,0,0,0,0,0,6,26,179,179,215,253,253,253,253,253,202,179,179,179,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,89,89,89,89,89,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,247,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,253,156,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,227,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,189,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,252,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,253,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,255,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,230,252,221,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,230,252,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,247,255,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,221,252,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,252,252,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,252,252,223,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,252,252,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,236,252,235,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,148,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,135,252,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,252,252,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,252,252,252,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,252,252,252,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,200,252,252,252,105,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,218,252,252,252,105,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,252,252,240,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,237,252,252,228,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,218,252,252,225,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,208,252,252,252,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,252,252,252,225,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,252,252,244,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,252,252,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,77,145,253,190,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,77,193,252,252,253,252,238,157,71,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,78,193,252,252,252,252,253,252,252,252,252,228,128,49,5,0,0,0,0,0,0,0,0,0,0,6,78,194,252,252,252,252,252,252,253,217,192,232,252,252,252,252,135,3,0,0,0,0,0,0,0,0,4,147,252,252,252,252,252,252,252,252,175,26,0,40,145,235,252,252,252,104,0,0,0,0,0,0,0,0,208,252,252,252,252,252,252,133,48,48,0,0,0,0,0,71,236,252,252,230,0,0,0,0,0,0,0,0,253,185,170,252,252,252,173,22,0,0,0,0,0,0,0,0,102,252,252,252,0,0,0,0,0,0,0,0,24,141,243,252,252,186,5,0,0,0,0,0,0,0,0,0,8,220,252,252,0,0,0,0,0,0,0,0,70,247,252,252,165,37,0,0,0,0,0,0,0,0,0,0,81,251,252,194,0,0,0,0,0,0,0,0,255,253,253,251,69,0,0,0,0,0,0,0,0,0,0,39,231,253,253,127,0,0,0,0,0,0,0,0,253,252,249,127,0,0,0,0,0,0,0,0,0,0,6,147,252,252,190,5,0,0,0,0,0,0,0,0,253,252,216,0,0,0,0,0,0,0,0,0,0,7,145,252,252,252,69,0,0,0,0,0,0,0,0,0,253,252,223,16,0,0,0,0,0,0,0,0,25,185,252,252,252,107,8,0,0,0,0,0,0,0,0,0,167,252,252,181,18,0,0,0,0,0,0,105,191,252,252,235,151,10,0,0,0,0,0,0,0,0,0,0,37,221,252,252,210,193,96,73,130,188,194,227,252,252,235,128,0,0,0,0,0,0,0,0,0,0,0,0,0,97,220,252,252,252,252,252,252,252,253,252,252,236,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,174,252,252,252,252,252,252,253,197,138,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,23,116,143,143,143,143,24,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,107,247,171,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,238,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,0,0,0,0,0,26,210,252,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,188,38,0,0,0,57,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,234,252,150,0,0,0,13,169,252,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,234,252,164,25,0,0,0,13,206,252,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,163,253,227,103,15,0,0,0,0,76,243,214,28,0,0,0,0,0,0,0,0,0,0,0,0,0,7,154,253,255,134,10,29,29,22,23,29,204,253,178,4,0,0,0,0,0,0,0,0,0,0,0,0,0,82,252,252,253,196,197,252,253,234,234,252,253,252,170,9,0,0,0,0,0,0,0,0,0,0,0,0,0,63,196,252,253,252,252,252,253,233,234,252,253,233,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,28,91,139,139,139,28,22,97,252,241,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,204,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,150,252,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,252,224,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,243,159,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,197,202,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,209,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,192,192,139,139,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,131,162,245,254,253,253,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,156,253,253,253,255,241,184,241,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,234,253,253,167,161,99,37,0,38,235,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,254,253,222,35,0,0,0,0,137,251,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,254,254,136,0,0,0,0,15,139,254,254,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,246,59,0,0,22,111,220,253,253,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,254,188,102,185,216,254,219,203,253,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,245,254,253,253,253,253,204,159,241,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,254,253,253,253,200,63,57,253,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,85,0,0,0,47,254,254,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,253,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,253,253,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,237,253,135,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,253,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,216,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,173,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,47,47,47,47,47,47,47,47,47,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,146,205,253,253,253,253,253,253,253,253,253,227,53,0,0,0,0,0,0,0,0,0,0,0,0,102,247,253,253,253,253,253,253,253,253,253,253,253,253,253,241,0,0,0,0,0,0,0,0,0,0,0,0,200,253,253,247,214,238,214,214,214,214,214,248,253,253,244,115,0,0,0,0,0,0,0,0,0,0,0,0,200,253,253,130,0,154,0,0,0,0,68,240,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,133,168,112,4,0,9,0,0,26,100,246,253,253,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,112,206,253,253,253,251,151,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,253,253,253,217,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,247,253,253,246,176,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,47,177,249,253,241,230,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,250,253,253,253,238,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,241,253,253,253,230,68,0,0,0,0,0,0,0,0,3,70,163,28,0,0,0,0,0,0,0,0,68,236,253,253,241,153,56,0,0,5,16,16,7,16,87,169,172,253,253,202,0,0,0,0,0,0,0,0,171,253,253,253,61,0,0,85,116,157,253,253,169,253,253,253,253,253,253,182,0,0,0,0,0,0,0,0,255,253,253,253,225,216,216,243,253,253,253,253,253,253,253,253,251,191,158,15,0,0,0,0,0,0,0,0,152,245,250,253,253,253,253,253,253,253,253,253,246,245,245,208,89,0,0,0,0,0,0,0,0,0,0,0,0,0,85,145,227,253,253,253,197,145,145,145,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,45,45,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,164,254,233,148,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,164,254,234,225,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,235,48,32,166,251,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,111,214,205,49,0,0,24,216,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,217,254,254,211,0,0,0,0,87,237,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,216,254,254,252,243,61,0,0,0,38,248,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,254,184,205,175,36,0,0,0,0,0,171,227,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,234,190,13,193,157,0,0,0,0,0,0,124,238,26,0,0,0,0,0,0,0,0,0,0,0,0,0,140,254,131,0,129,157,0,0,0,0,0,0,124,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,201,238,56,0,70,103,0,0,0,0,0,0,124,254,148,0,0,0,0,0,0,0,0,0,0,0,0,62,255,210,0,0,0,0,0,0,0,0,0,0,150,254,122,0,0,0,0,0,0,0,0,0,0,0,0,86,254,201,15,0,0,0,0,0,0,0,0,28,237,246,44,0,0,0,0,0,0,0,0,0,0,0,0,128,254,143,0,0,0,0,0,0,0,0,0,34,243,227,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,210,0,0,0,0,0,0,0,0,0,58,249,179,0,0,0,0,0,0,0,0,0,0,0,0,0,30,240,210,0,0,0,0,0,0,0,0,0,207,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,231,34,0,0,0,0,0,0,0,129,248,170,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,254,170,0,0,0,0,0,17,129,248,225,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,245,245,184,106,106,106,133,231,254,244,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,249,254,254,254,254,254,251,193,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,157,248,166,166,139,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,255,219,67,67,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,181,253,253,253,253,226,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,129,206,253,253,253,253,253,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,141,253,253,253,253,253,253,253,253,166,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,253,253,253,253,253,253,253,253,253,253,65,0,0,0,0,0,0,0,0,0,0,0,0,0,2,83,207,246,253,253,253,253,253,249,234,247,253,253,65,0,0,0,0,0,0,0,0,0,0,0,0,0,83,253,253,253,253,253,189,253,253,205,0,179,253,253,65,0,0,0,0,0,0,0,0,0,0,0,0,85,234,253,253,253,253,157,26,164,151,83,0,179,253,253,65,0,0,0,0,0,0,0,0,0,0,0,65,237,253,253,253,67,36,14,0,15,12,0,0,179,253,253,65,0,0,0,0,0,0,0,0,0,0,4,141,253,253,221,158,23,0,0,0,0,0,0,0,179,253,253,65,0,0,0,0,0,0,0,0,0,0,129,253,253,241,62,0,0,0,0,0,0,0,0,72,226,253,175,24,0,0,0,0,0,0,0,0,0,119,247,253,253,206,0,0,0,0,0,0,0,0,8,134,253,253,130,0,0,0,0,0,0,0,0,0,0,132,253,253,194,27,0,0,0,0,0,0,0,0,125,253,253,253,130,0,0,0,0,0,0,0,0,0,45,213,253,253,112,0,0,0,0,0,0,0,70,170,247,253,253,89,43,0,0,0,0,0,0,0,0,0,67,253,253,196,55,9,0,0,0,0,0,8,131,253,253,253,86,1,0,0,0,0,0,0,0,0,0,0,67,253,253,253,253,129,0,0,0,43,114,134,253,253,231,139,41,0,0,0,0,0,0,0,0,0,0,0,20,167,253,253,253,247,179,179,179,206,253,253,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,240,253,253,253,253,253,253,253,253,244,119,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,253,253,253,253,253,175,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,121,253,253,253,253,253,182,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,7,13,117,191,76,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,83,100,145,223,167,173,253,253,253,203,133,145,65,7,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,253,253,253,253,253,253,253,253,254,253,253,253,184,38,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,253,253,253,253,254,253,253,253,253,140,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,253,253,198,193,254,253,253,253,253,180,0,0,0,0,0,0,0,0,0,0,0,0,220,253,243,123,94,60,60,60,6,0,60,118,88,253,253,236,37,0,0,0,0,0,0,0,0,0,0,0,25,48,41,0,0,0,0,0,0,0,0,0,7,144,253,253,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,253,253,201,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,253,253,217,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,253,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,59,254,254,116,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,89,88,212,253,253,253,253,160,145,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,203,254,253,253,253,253,253,253,253,253,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,246,253,254,253,253,253,253,253,253,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,253,253,254,253,253,253,253,253,253,253,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,245,253,253,254,253,253,253,236,88,60,118,60,32,0,0,0,0,0,0,0,0,0,0,0,0,0,25,222,253,253,253,254,253,253,214,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,253,253,254,253,239,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,253,253,254,243,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,150,149,242,253,11,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,183,252,254,252,252,252,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,168,250,250,252,250,250,250,250,71,0,43,85,14,0,0,0,0,0,0,0,0,0,0,0,0,107,252,250,250,250,250,252,250,250,250,250,210,0,127,250,146,0,0,0,0,0,0,0,0,0,0,0,114,237,252,250,250,250,250,252,250,250,250,250,210,0,127,250,250,0,0,0,0,0,0,0,0,0,0,107,237,250,252,250,250,250,74,41,41,41,41,217,34,0,127,250,250,0,0,0,0,0,0,0,0,0,15,148,252,252,254,238,105,0,0,0,0,0,0,0,0,0,128,252,252,0,0,0,0,0,0,0,0,15,140,250,250,250,167,111,0,0,0,0,0,0,0,0,0,0,127,250,250,0,0,0,0,0,0,0,0,43,250,250,250,250,0,0,0,0,0,0,0,0,0,0,0,0,127,250,250,0,0,0,0,0,0,0,0,183,250,250,250,110,0,0,0,0,0,0,0,0,0,0,0,57,210,250,250,0,0,0,0,0,0,0,0,252,250,250,110,7,0,0,0,0,0,0,0,0,0,0,0,85,250,250,250,0,0,0,0,0,0,0,0,254,252,252,83,0,0,0,0,0,0,0,0,0,0,0,0,86,252,252,217,0,0,0,0,0,0,0,0,252,250,250,138,14,0,0,0,0,0,0,0,0,0,0,15,140,250,250,41,0,0,0,0,0,0,0,0,252,250,250,250,41,0,0,0,0,0,0,0,0,0,0,43,250,250,250,41,0,0,0,0,0,0,0,0,252,250,250,250,181,0,0,0,0,0,0,0,0,0,0,183,250,250,250,41,0,0,0,0,0,0,0,0,76,250,250,250,250,0,0,0,0,0,0,0,0,0,177,252,250,250,110,7,0,0,0,0,0,0,0,0,36,224,252,252,252,219,43,43,43,7,0,15,43,183,252,255,252,126,0,0,0,0,0,0,0,0,0,0,0,85,250,250,250,252,250,250,250,111,86,140,250,250,250,252,222,83,0,0,0,0,0,0,0,0,0,0,0,42,188,250,250,252,250,250,250,250,252,250,250,250,250,126,83,0,0,0,0,0,0,0,0,0,0,0,0,0,127,250,250,252,250,250,250,250,252,250,250,137,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,41,217,252,250,250,250,250,217,41,41,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,228,254,224,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,253,222,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,106,46,142,222,251,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,221,250,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,253,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,253,231,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,244,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,196,253,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,253,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,83,234,253,225,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,245,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,234,253,253,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,74,235,253,253,203,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,169,253,253,246,227,64,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,9,140,150,240,253,253,253,193,20,6,0,0,13,34,203,66,0,0,0,0,0,0,0,0,0,0,0,0,185,253,253,253,253,253,253,253,253,174,143,143,214,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,241,253,253,251,247,247,247,248,253,253,253,253,253,253,239,51,0,0,0,0,0,0,0,0,0,0,0,0,118,244,135,79,0,0,0,32,153,253,253,253,253,172,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,113,113,113,114,238,253,253,253,255,206,88,0,0,0,0,0,0,0,0,0,0,0,0,0,57,85,147,234,252,252,252,253,252,252,252,252,253,252,246,75,0,0,0,0,0,0,0,0,0,0,67,197,234,252,253,252,252,252,252,196,195,195,195,195,253,252,252,84,0,0,0,0,0,0,0,0,0,0,85,252,252,252,225,223,114,84,84,0,0,0,0,16,253,252,214,28,0,0,0,0,0,0,0,0,0,0,38,221,157,112,0,0,0,0,0,0,0,0,16,203,253,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,207,253,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,252,252,215,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,240,252,220,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,181,252,217,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,191,255,215,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,196,252,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,209,252,252,56,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,181,252,217,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,191,255,215,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,252,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,187,252,133,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,206,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,176,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,233,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,195,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,234,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,233,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,241,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,13,13,108,137,137,137,238,254,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,254,254,254,254,254,254,254,254,103,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,149,222,254,248,229,237,254,246,184,105,241,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,254,248,134,75,0,91,254,91,0,0,90,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,143,0,0,63,235,224,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,254,238,71,11,204,205,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,238,254,237,194,254,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,237,254,254,178,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,254,254,203,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,235,254,254,254,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,167,254,201,198,254,238,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,214,15,12,205,254,239,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,239,254,162,0,0,193,254,254,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,238,51,0,0,193,254,225,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,194,254,101,0,0,0,193,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,254,220,9,0,0,109,249,186,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,217,20,113,201,250,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,250,254,253,245,254,254,254,131,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,91,255,255,255,255,166,39,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,79,192,216,216,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,209,252,253,252,252,227,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,147,209,252,252,244,168,80,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,175,253,252,214,139,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,255,209,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,234,252,234,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,234,252,252,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,252,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,253,253,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,233,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,252,168,0,0,76,113,113,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,254,253,216,191,254,253,253,253,242,141,53,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,252,252,252,253,252,252,252,253,252,252,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,214,156,56,56,106,178,252,252,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,252,252,139,0,0,0,0,4,78,252,252,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,231,253,253,76,0,0,0,4,128,253,253,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,190,252,244,94,57,57,179,252,252,252,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,193,253,252,252,252,253,252,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,153,252,252,252,253,177,52,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,130,173,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,162,254,231,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,215,244,159,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,175,72,0,0,0,79,245,254,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,254,117,0,0,14,247,254,104,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,185,251,254,59,0,0,161,254,163,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,70,233,254,232,61,1,17,128,252,243,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,254,254,254,38,0,0,142,255,249,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,141,252,254,197,71,1,0,109,254,243,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,133,254,254,180,15,0,0,2,192,254,216,16,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,254,254,247,160,39,0,10,133,254,253,96,108,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,252,254,254,254,234,215,222,254,254,254,254,251,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,85,171,184,220,254,254,254,227,198,161,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,254,254,122,18,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,226,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,133,253,195,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,196,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,241,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,138,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,237,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,255,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,237,253,252,252,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,207,255,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,221,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,190,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,255,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,252,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,236,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,229,252,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,51,221,252,247,219,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,252,252,252,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,236,252,252,216,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,222,253,252,135,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,224,252,253,220,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,252,252,154,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,172,248,252,252,53,81,193,193,62,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,203,252,252,252,192,252,252,252,207,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,253,253,253,253,255,253,185,149,241,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,252,252,252,252,253,237,155,0,135,239,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,183,252,252,252,252,247,216,53,0,135,239,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,217,252,252,252,252,198,21,0,0,223,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,243,252,252,252,207,29,5,58,223,182,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,240,252,252,252,132,30,13,153,226,181,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,252,252,252,231,134,183,252,252,188,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,252,252,252,252,252,253,252,193,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,239,252,252,252,252,253,216,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,103,103,129,252,253,252,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,198,91,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,254,254,251,176,164,93,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,248,254,254,254,254,254,251,207,160,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,157,99,99,172,243,254,254,254,235,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,17,207,254,254,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,143,250,254,249,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,144,242,254,254,230,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,254,254,247,163,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,254,254,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,248,254,212,91,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,234,254,254,183,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,219,254,254,116,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,203,254,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,134,254,239,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,133,254,246,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,61,116,242,254,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,90,174,244,254,254,254,249,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,199,254,255,254,254,254,239,120,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,248,230,244,251,191,206,122,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,102,0,46,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,7,0,0,0,0,9,105,231,253,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,201,70,0,0,0,124,252,252,197,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,243,252,104,0,0,7,191,252,240,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,241,252,252,0,0,0,129,252,252,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,239,252,252,136,0,0,27,229,252,171,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,238,252,252,134,3,0,7,156,252,206,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,108,239,252,252,133,5,0,5,158,252,236,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,176,252,252,224,58,5,0,0,162,252,238,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,252,252,252,211,109,109,10,53,253,252,164,0,27,78,0,0,0,0,0,0,0,0,0,0,0,0,0,30,252,252,252,252,252,252,242,246,253,252,245,160,152,249,201,75,0,0,0,0,0,0,0,0,0,0,0,0,76,121,149,241,247,252,253,253,255,253,253,253,253,253,243,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,93,239,252,241,159,108,108,108,108,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,243,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,184,252,206,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,205,252,174,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,182,252,190,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,252,252,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,252,173,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,246,221,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,223,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,229,254,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,148,254,253,249,130,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,253,254,253,248,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,253,254,253,175,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,178,254,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,243,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,253,154,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,227,253,253,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,254,254,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,127,253,239,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,143,213,178,255,253,248,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,132,251,253,253,254,216,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,117,128,247,253,164,105,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,135,255,189,106,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,166,254,254,254,254,184,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,201,254,236,167,254,254,254,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,249,165,9,1,22,240,254,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,143,0,0,26,197,254,245,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,254,115,87,141,240,254,254,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,254,254,254,254,233,254,254,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,155,191,138,121,46,254,250,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,251,254,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,249,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,254,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,246,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,254,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,228,254,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,210,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,238,201,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,254,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,248,166,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,132,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,241,251,251,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,251,251,251,245,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,204,251,251,251,245,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,251,251,251,251,167,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,155,251,251,251,251,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,157,248,251,251,251,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,251,251,251,212,78,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,251,251,253,251,170,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,57,162,251,253,251,251,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,239,255,253,253,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,251,251,230,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,251,221,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,251,251,251,251,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,199,251,251,251,155,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,204,251,251,251,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,249,251,251,248,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,251,251,251,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,251,251,251,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,131,251,251,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,121,233,218,121,121,121,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,241,251,252,252,252,252,252,252,238,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,94,171,240,253,252,252,252,252,252,252,252,252,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,252,252,252,253,218,172,172,136,39,185,252,252,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,185,185,185,53,31,0,0,0,15,194,252,252,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,200,252,252,249,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,166,252,252,233,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,77,238,252,252,212,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,147,191,252,252,248,210,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,253,252,252,252,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,255,253,253,253,218,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,145,146,145,241,252,252,249,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,237,252,252,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,252,252,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,223,252,252,79,0,0,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,23,197,252,252,252,79,0,0,0,0,0,0,0,0,0,0,0,20,167,215,131,30,0,0,0,0,22,41,200,252,252,241,184,25,0,0,0,0,0,0,0,0,0,0,0,121,252,252,252,227,160,160,160,160,208,253,252,252,229,96,0,0,0,0,0,0,0,0,0,0,0,0,0,51,161,250,252,252,252,252,252,252,252,253,239,189,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,161,252,252,252,252,252,252,120,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,164,217,255,212,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,218,250,254,254,254,254,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,239,252,174,53,95,26,86,254,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,230,62,0,0,0,0,32,254,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,80,0,0,0,0,0,32,254,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,254,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,240,248,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,208,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,235,254,243,89,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,253,254,254,254,254,253,223,114,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,221,222,207,175,222,223,254,254,144,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,86,244,254,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,239,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,238,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,254,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,69,0,0,0,1,128,252,245,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,243,190,117,123,206,254,247,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,237,254,254,254,254,249,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,123,196,164,163,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,191,255,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,128,64,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,128,0,0,0,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,64,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,64,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,79,150,255,224,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,36,135,244,253,253,253,244,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,73,191,253,253,253,253,247,200,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,253,253,222,177,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,233,253,253,226,121,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,253,145,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,196,253,251,207,81,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,233,253,253,253,100,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,176,244,253,253,144,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,253,253,195,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,59,200,253,253,215,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,205,253,253,194,20,0,0,0,0,0,0,0,0,0,0,0,0,0,85,209,231,231,102,0,0,0,0,0,18,206,253,253,105,0,0,0,0,0,0,0,0,0,0,0,0,168,252,253,248,183,55,0,0,0,0,0,0,32,253,253,170,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,209,21,0,0,0,0,0,0,0,44,253,253,170,0,0,0,0,0,0,0,0,0,0,0,0,85,241,253,253,152,21,0,0,0,0,0,30,217,253,241,84,0,0,0,0,0,0,0,0,0,0,0,0,0,86,241,253,253,203,66,20,20,66,66,217,253,253,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,244,253,253,253,217,217,253,253,253,244,94,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,95,253,253,253,253,253,253,201,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,28,135,218,217,135,28,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,202,253,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,193,253,202,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,252,236,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,230,21,0,0,64,248,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,170,253,253,128,0,5,191,253,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,252,252,235,18,0,47,252,252,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,252,202,44,0,0,130,252,153,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,248,253,235,64,0,0,62,236,252,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,252,243,60,0,0,0,138,252,221,25,106,221,42,0,0,0,0,0,0,0,0,0,0,0,0,0,32,229,253,233,24,24,24,24,255,253,222,138,243,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,253,252,252,252,252,253,252,252,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,215,253,252,252,252,252,253,252,252,227,183,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,161,160,185,252,252,253,193,128,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,232,252,128,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,253,243,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,197,252,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,252,185,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,194,227,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,252,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,141,141,141,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,133,133,203,252,252,252,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,56,171,252,247,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,128,253,246,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,252,224,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,224,252,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,179,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,196,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,209,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,247,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,246,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,188,246,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,253,194,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,157,253,240,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,140,252,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,243,252,252,78,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,205,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,118,205,251,253,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,144,241,244,253,253,253,253,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,145,240,253,253,253,253,253,253,253,235,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,145,249,253,253,253,253,233,173,253,253,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,221,253,253,253,227,162,131,44,188,253,253,183,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,245,179,168,128,28,0,20,120,253,253,182,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,6,0,0,0,0,100,253,253,221,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,240,253,180,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,210,253,240,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,181,253,209,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,240,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,240,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,241,241,177,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,242,253,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,253,231,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,243,246,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,236,248,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,182,247,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,232,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,231,24,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,235,235,27,0,0,0,0,0,0,88,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,253,195,0,0,0,0,0,0,13,237,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,83,0,0,0,0,0,0,116,237,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,246,254,0,0,0,0,0,0,20,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,0,0,0,0,0,5,150,253,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,0,0,0,0,0,59,253,198,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,250,253,68,0,0,0,0,164,242,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,253,240,68,0,0,76,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,173,255,246,127,59,134,255,114,0,0,0,37,104,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,250,253,253,253,254,213,118,118,118,201,191,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,145,247,253,254,253,253,253,253,205,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,215,117,109,19,110,41,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,248,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,244,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,229,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,49,49,49,158,170,174,253,201,89,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,61,84,199,253,253,253,253,253,254,253,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,137,199,253,253,253,253,253,225,180,65,60,60,180,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,237,168,168,168,47,0,0,0,61,235,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,157,212,253,101,0,0,0,0,0,0,161,238,253,235,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,24,8,0,0,0,0,0,162,255,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,253,254,242,57,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,255,255,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,124,238,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,156,253,239,107,5,0,0,0,0,9,37,37,141,157,157,0,0,0,0,0,0,0,0,0,0,0,33,155,253,253,151,49,3,0,5,49,129,190,253,253,253,232,147,0,0,0,0,0,0,0,0,0,0,27,230,253,253,253,219,253,185,183,188,253,253,253,253,204,146,41,0,0,0,0,0,0,0,0,0,0,0,37,253,253,253,253,253,253,253,220,246,180,180,151,60,12,0,0,0,0,0,0,0,0,0,0,0,0,0,7,128,139,48,89,168,168,53,25,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,62,146,182,254,254,181,176,139,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,186,253,217,208,136,136,136,166,232,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,242,208,111,3,0,0,0,0,0,18,32,107,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,242,23,0,0,0,0,0,0,0,13,191,181,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,255,98,3,0,0,0,0,0,8,194,225,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,120,3,0,0,0,0,128,247,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,111,244,169,19,0,14,131,249,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,241,235,72,142,229,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,218,254,231,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,221,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,237,111,196,217,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,138,0,23,193,204,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,224,0,0,0,25,218,169,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,138,0,0,0,0,86,253,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,97,0,0,0,0,3,162,214,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,97,0,0,0,0,0,118,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,157,0,0,0,0,0,40,254,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,244,61,0,0,0,0,112,244,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,251,142,59,83,167,244,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,133,253,253,253,169,61,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,65,101,164,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,66,147,219,244,253,253,253,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,173,174,224,253,253,253,253,184,143,79,48,0,0,0,0,0,0,0,0,0,0,0,0,0,4,103,185,248,253,241,223,218,124,36,24,2,0,0,0,0,0,0,0,0,0,0,0,0,4,149,137,27,30,253,240,168,71,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,253,253,157,14,114,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,253,253,144,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,168,247,253,253,216,95,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,248,249,253,253,216,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,128,227,253,235,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,66,0,0,0,0,0,22,204,253,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,143,0,0,0,0,0,55,234,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,194,26,26,18,23,98,235,253,160,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,253,253,232,247,253,253,192,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,106,241,253,253,236,218,109,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,64,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,63,160,255,254,254,149,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,167,240,254,254,254,254,254,254,252,130,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,254,254,254,254,167,157,132,162,235,254,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,220,145,4,1,0,0,0,7,180,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,245,23,0,0,0,0,0,0,0,11,55,48,78,138,0,0,0,0,0,0,0,0,0,0,0,0,0,216,134,0,0,0,0,0,0,0,0,25,102,211,209,201,0,0,0,0,0,0,0,0,0,0,0,0,0,124,92,0,0,0,0,0,0,0,46,215,254,253,201,66,0,0,0,0,0,0,0,0,0,0,0,0,0,41,206,4,0,0,0,2,115,211,245,254,185,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,231,77,0,0,34,182,254,254,219,109,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,187,46,80,238,254,254,227,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,236,254,254,247,115,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,254,254,155,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,206,254,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,115,239,254,205,179,225,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,252,254,229,161,47,24,244,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,248,254,235,70,0,25,173,254,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,225,254,254,62,38,157,223,254,234,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,254,254,219,254,254,254,254,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,254,254,254,254,254,225,122,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,254,254,254,221,102,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,240,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,156,252,253,201,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,240,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,252,242,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,243,252,208,0,0,0,23,123,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,220,37,0,0,126,227,252,252,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,196,0,63,176,253,253,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,252,195,10,178,253,252,252,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,195,138,252,253,233,176,205,252,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,202,178,252,253,74,73,252,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,252,252,252,190,137,227,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,253,253,253,253,255,253,253,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,206,252,252,252,252,253,252,233,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,246,252,252,252,253,201,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,246,252,236,84,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,173,254,187,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,236,187,222,237,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,248,241,66,0,42,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,141,244,58,0,0,21,246,250,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,253,119,0,0,0,0,166,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,33,0,0,0,0,166,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,186,5,0,0,0,1,170,211,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,175,13,0,0,0,23,253,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,253,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,34,34,34,48,144,187,255,254,81,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,67,171,253,253,253,254,253,253,253,239,187,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,220,253,253,236,154,154,154,223,253,235,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,83,121,20,9,0,0,3,184,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,188,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,254,253,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,213,254,139,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,234,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,144,253,253,255,253,253,253,253,255,128,25,0,0,0,0,0,0,0,0,0,0,0,0,0,57,163,226,249,252,252,252,253,252,252,252,252,253,252,103,0,0,0,0,0,0,0,0,0,0,0,19,166,234,252,253,252,252,214,195,196,70,133,71,227,253,252,195,0,0,0,0,0,0,0,0,0,0,0,76,246,252,252,225,99,84,28,0,0,0,0,0,140,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,88,112,112,0,0,0,0,0,0,0,0,95,203,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,255,215,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,210,246,252,252,215,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,222,252,252,252,173,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,60,169,215,253,252,252,252,252,169,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,240,252,252,252,253,252,252,252,252,253,214,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,190,141,94,0,0,141,255,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,167,167,74,12,0,0,0,0,94,253,252,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,85,9,0,0,0,0,0,67,178,240,253,223,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,203,165,57,135,198,197,240,252,252,228,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,237,252,252,252,252,253,252,252,249,145,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,237,252,252,252,253,252,220,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,221,254,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,227,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,254,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,138,252,254,253,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,138,253,253,254,253,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,144,253,253,253,254,230,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,216,253,247,127,224,254,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,219,253,247,39,0,221,254,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,78,246,253,188,63,0,58,245,254,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,196,253,253,157,21,0,0,127,253,254,77,0,0,0,0,0,68,111,15,0,0,0,0,0,0,0,0,193,254,254,245,72,34,34,13,189,254,227,34,34,34,58,144,197,255,244,77,0,0,0,0,0,0,0,0,107,204,253,253,253,253,253,207,234,253,254,253,253,253,253,253,253,213,82,0,0,0,0,0,0,0,0,0,0,12,87,154,219,253,253,253,253,253,254,253,253,245,154,154,53,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,10,112,144,253,253,223,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,211,253,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,219,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,148,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,241,254,219,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,246,253,253,225,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,164,241,253,253,131,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,254,219,53,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,231,253,223,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,180,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,253,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,133,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,253,252,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,254,254,94,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,253,215,5,0,0,0,0,217,247,241,213,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,220,233,64,0,0,0,45,221,251,253,253,253,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,199,0,0,0,0,163,253,253,228,237,253,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,199,0,0,11,201,254,253,143,100,242,253,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,199,0,0,14,253,254,230,40,188,253,115,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,208,34,0,14,253,255,93,190,253,186,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,248,253,238,161,165,253,255,253,243,184,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,253,253,253,253,253,255,253,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,218,253,253,253,253,121,120,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,200,255,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,254,254,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,254,254,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,237,254,221,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,254,231,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,254,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,254,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,254,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,232,254,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,229,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,254,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,217,254,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,254,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,254,254,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,233,254,212,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,254,254,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,215,254,254,116,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,254,254,254,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,254,254,254,254,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,163,254,185,58,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,170,255,254,215,159,73,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,225,239,216,201,125,215,250,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,227,248,119,0,0,0,0,231,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,68,0,0,0,3,138,184,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,247,148,3,0,0,7,90,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,103,0,0,5,89,253,253,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,187,85,120,198,253,253,253,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,208,253,253,253,197,247,251,106,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,128,86,37,67,249,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,255,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,238,202,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,250,165,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,193,198,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,234,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,222,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,196,92,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,18,131,136,136,164,255,248,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,167,253,253,253,211,100,100,63,0,0,0,29,154,104,0,0,0,0,0,0,0,0,0,0,0,0,12,203,253,253,199,82,31,0,0,0,0,53,123,187,253,145,0,0,0,0,0,0,0,0,0,0,0,10,164,253,228,78,3,0,0,0,0,27,179,252,253,253,235,38,0,0,0,0,0,0,0,0,0,0,0,36,253,253,68,0,0,0,0,21,180,224,253,166,161,253,147,0,0,0,0,0,0,0,0,0,0,0,0,36,253,253,97,0,0,60,127,231,253,213,95,6,192,211,8,0,0,0,0,0,0,0,0,0,0,0,0,2,116,252,250,243,243,249,252,220,38,7,0,183,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,208,230,230,163,94,0,0,0,0,249,251,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,249,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,238,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,243,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,187,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,206,253,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,185,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,158,37,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,240,234,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,163,135,83,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,245,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,170,253,216,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,237,253,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,238,253,249,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,173,253,253,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,253,253,157,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,253,223,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,160,253,253,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,253,253,180,9,0,0,2,69,69,69,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,226,253,253,63,0,36,64,187,253,253,253,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,253,166,10,8,193,253,252,226,252,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,218,253,253,6,0,73,253,253,242,0,159,252,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,189,3,44,229,253,240,56,0,51,236,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,123,0,90,253,253,169,0,0,159,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,241,17,0,209,253,211,12,3,150,252,136,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,239,0,27,233,253,217,78,201,223,61,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,249,179,211,253,253,253,253,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,253,253,253,253,251,229,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,134,253,253,253,253,253,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,57,57,57,57,57,57,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,185,229,252,252,252,253,252,252,252,185,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,188,246,252,253,252,252,252,241,139,177,252,253,246,187,13,0,0,0,0,0,0,0,0,0,0,0,26,255,253,244,175,101,0,0,0,0,0,0,0,126,244,253,153,0,0,0,0,0,0,0,0,0,0,82,243,253,214,81,0,0,0,0,0,0,0,0,0,0,169,252,252,0,0,0,0,0,0,0,0,0,19,215,252,206,56,0,0,0,0,0,0,0,0,0,0,0,169,252,252,0,0,0,0,0,0,0,0,0,157,252,252,13,0,0,0,0,0,0,0,0,0,0,0,0,169,252,151,0,0,0,0,0,0,0,0,41,253,253,128,0,0,0,0,0,0,0,0,0,0,0,0,92,253,206,13,0,0,0,0,0,0,0,0,166,252,196,9,0,0,0,0,0,0,0,0,0,0,0,0,216,252,142,0,0,0,0,0,0,0,0,0,253,252,168,0,0,0,0,0,0,0,0,0,0,0,0,89,253,208,13,0,0,0,0,0,0,0,0,0,253,252,68,0,0,0,0,0,0,0,0,0,0,0,38,225,253,96,0,0,0,0,0,0,0,0,0,0,254,253,56,0,0,0,0,0,0,0,0,0,0,45,229,253,151,0,0,0,0,0,0,0,0,0,0,0,253,252,81,0,0,0,0,0,0,0,0,0,70,225,252,227,0,0,0,0,0,0,0,0,0,0,0,0,216,252,168,0,0,0,0,0,0,0,29,134,253,252,186,31,0,0,0,0,0,0,0,0,0,0,0,0,91,252,243,125,0,0,0,51,114,113,210,252,253,151,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,253,253,254,253,253,253,254,253,244,175,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,122,196,197,221,196,196,197,121,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,118,184,254,255,146,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,197,246,253,253,253,253,253,239,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,199,253,253,251,177,208,253,253,253,250,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,253,253,217,119,0,25,61,212,253,237,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,203,228,77,0,0,0,75,236,253,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,62,240,253,251,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,248,253,253,253,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,90,179,242,253,253,224,56,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,203,206,219,253,253,253,253,197,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,253,253,253,253,253,253,253,149,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,226,226,226,125,89,93,253,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,179,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,187,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,253,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,45,0,0,0,0,0,0,0,0,16,98,221,253,253,181,8,0,0,0,0,0,0,0,0,0,0,0,93,229,158,49,9,63,63,63,63,174,210,253,253,253,138,37,0,0,0,0,0,0,0,0,0,0,0,0,35,239,253,237,189,253,253,253,253,253,253,253,226,75,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,253,253,253,253,253,253,248,232,143,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,156,253,253,253,253,253,130,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,253,255,213,41,0,0,0,0,0,0,0,0,82,132,10,0,0,0,0,0,0,0,0,0,0,0,0,51,252,213,252,243,203,142,61,0,0,0,82,163,243,253,50,0,0,0,0,0,0,0,0,0,0,0,0,52,253,203,0,102,102,163,243,254,172,254,253,224,223,224,20,0,0,0,0,0,0,0,0,0,0,0,0,51,252,203,0,0,0,0,40,50,50,151,70,20,102,223,20,0,0,0,0,0,0,0,0,0,0,0,0,0,203,214,10,0,0,0,0,0,0,0,0,0,102,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,253,50,0,0,0,0,0,0,0,0,0,183,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,254,151,0,0,0,0,0,0,0,0,0,203,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,253,151,0,0,0,0,0,0,0,0,21,223,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,61,0,0,0,0,0,0,0,0,51,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,232,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,213,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,112,112,151,241,241,241,147,112,112,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,158,242,253,253,253,253,253,253,253,253,253,225,94,0,0,0,0,0,0,0,0,0,0,0,0,162,228,252,253,253,253,253,172,155,155,155,155,223,253,253,237,40,0,0,0,0,0,0,0,0,0,0,0,255,253,42,86,162,48,32,6,0,0,0,0,39,210,253,230,13,0,0,0,0,0,0,0,0,0,0,0,211,253,12,0,0,0,0,0,0,0,0,18,116,253,253,183,0,0,0,0,0,0,0,0,0,0,0,0,22,45,3,0,0,0,0,0,0,0,19,181,253,253,243,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,214,253,253,205,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,240,253,253,184,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,189,240,253,240,101,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,166,243,253,238,167,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,206,253,253,215,82,0,0,0,0,0,0,0,28,46,46,46,0,0,0,0,0,0,0,0,0,19,163,247,253,239,170,15,0,11,40,40,40,127,169,170,219,253,253,233,0,0,0,0,0,0,0,0,17,202,253,253,253,107,143,163,163,186,253,253,253,253,253,250,221,220,150,44,0,0,0,0,0,0,0,0,125,253,253,253,253,253,253,253,253,253,234,227,227,227,143,87,0,0,0,0,0,0,0,0,0,0,0,0,115,234,234,242,253,253,253,237,129,104,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,110,110,110,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,239,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,251,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,240,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,227,254,66,0,0,0,2,82,181,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,207,193,40,0,0,0,169,250,147,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,247,229,31,7,0,0,0,195,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,254,231,37,0,0,0,0,143,254,218,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,254,254,205,178,178,102,76,246,254,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,164,234,254,254,254,254,254,254,162,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,52,109,133,230,254,254,198,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,254,254,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,232,224,121,254,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,254,102,4,240,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,225,14,0,239,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,75,0,26,245,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,52,0,102,254,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,52,10,216,254,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,52,166,254,195,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,254,184,251,237,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,188,255,212,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,105,105,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,87,209,229,253,253,232,209,209,209,68,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,188,253,253,254,253,253,253,253,253,253,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,253,253,253,254,253,182,253,253,253,253,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,199,245,253,253,240,90,29,29,25,253,253,253,253,129,7,0,0,0,0,0,0,0,0,0,0,0,0,0,110,244,237,170,61,0,0,61,184,253,253,249,143,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,56,0,0,0,0,209,253,253,213,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,152,251,253,210,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,72,229,254,242,199,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,253,253,254,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,184,254,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,215,253,232,79,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,87,243,253,245,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,253,253,239,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,243,253,186,69,0,0,0,0,0,0,0,0,0,9,75,75,75,75,0,0,0,0,0,0,0,0,75,240,253,253,56,13,30,30,30,30,31,30,30,30,163,188,253,253,253,235,0,0,0,0,0,0,0,0,184,253,253,253,253,183,253,253,253,253,254,253,253,253,253,253,253,253,149,49,0,0,0,0,0,0,0,0,255,253,253,253,253,253,253,253,253,253,255,253,253,253,226,163,84,14,4,0,0,0,0,0,0,0,0,0,139,253,253,253,253,253,253,237,181,147,209,208,199,59,42,0,0,0,0,0,0,0,0,0,0,0,0,0,43,104,104,104,104,104,104,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,214,253,234,152,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,243,253,252,253,252,203,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,253,123,0,21,183,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,223,253,130,0,0,0,0,253,252,203,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,244,40,0,0,0,0,92,253,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,162,0,0,0,0,0,51,252,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,102,0,0,0,0,0,132,253,254,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,183,0,0,0,123,203,253,252,172,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,254,172,152,233,254,253,254,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,172,253,252,253,252,233,151,253,252,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,102,102,61,0,102,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,203,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,254,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,254,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,255,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,252,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,255,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,213,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,29,128,251,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,252,252,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,234,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,241,252,177,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,141,241,242,47,10,179,255,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,187,252,252,209,41,172,252,222,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,229,252,252,77,25,95,252,252,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,237,253,227,103,3,76,243,252,202,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,229,253,226,88,0,0,204,253,244,25,0,7,66,28,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,194,57,57,82,253,252,187,157,170,187,252,215,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,252,252,228,253,252,252,252,253,252,224,118,0,0,0,0,0,0,0,0,0,0,0,0,0,7,116,240,253,252,252,252,253,252,252,202,140,65,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,207,253,253,226,113,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,187,252,227,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,252,224,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,227,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,237,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,122,174,95,0,0,0,0,0,0,0,15,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,254,247,30,0,0,0,0,0,0,177,217,157,13,0,0,0,0,0,0,0,0,0,0,0,0,0,8,254,254,254,95,0,0,0,0,0,0,207,254,254,137,0,0,0,0,0,0,0,0,0,0,0,0,0,115,254,254,225,0,0,0,0,0,0,0,207,254,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,115,254,254,135,0,0,0,0,0,0,0,207,254,254,228,4,0,0,0,0,0,0,0,0,0,0,0,0,120,254,254,130,0,0,0,0,0,0,3,209,254,254,254,5,0,0,0,0,0,0,0,0,0,0,0,15,229,254,254,27,0,0,0,0,0,0,60,254,254,254,235,4,0,0,0,0,0,0,0,0,0,0,0,18,230,254,254,27,0,0,0,0,0,0,35,234,254,254,231,4,0,0,0,0,0,0,0,0,0,0,0,0,223,254,254,41,17,101,126,195,234,234,239,254,254,254,254,114,5,0,0,0,0,0,0,0,0,0,0,17,230,254,254,254,254,254,254,254,254,254,254,254,254,254,254,248,60,0,0,0,0,0,0,0,0,0,0,77,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,136,0,0,0,0,0,0,0,0,0,0,0,77,254,254,254,254,254,254,254,254,247,177,201,254,254,254,157,7,0,0,0,0,0,0,0,0,0,0,0,59,247,254,254,254,254,234,195,171,55,0,35,234,254,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,139,213,223,106,48,32,0,0,0,0,37,236,254,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,1,6,7,0,0,0,0,0,0,0,0,207,254,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,254,255,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,254,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,254,254,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,180,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,202,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,194,253,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,202,253,252,167,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,254,253,238,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,241,254,235,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,236,253,242,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,253,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,169,252,253,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,245,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,253,253,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,254,254,217,35,63,167,254,254,254,122,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,184,175,235,254,253,253,253,253,204,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,253,253,253,254,241,238,238,251,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,253,253,253,205,23,0,0,224,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,250,253,253,253,240,90,17,0,0,36,233,244,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,253,253,102,0,0,8,39,214,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,253,253,138,80,135,163,253,253,213,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,226,253,253,253,251,247,255,253,253,210,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,240,253,253,253,253,254,242,199,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,253,253,255,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,166,250,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,254,254,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,151,107,0,0,0,0,0,105,254,231,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,254,235,0,0,0,0,21,213,254,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,254,235,0,0,0,0,113,254,230,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,254,235,0,0,0,0,196,254,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,243,254,155,0,0,0,72,251,254,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,254,237,58,0,0,0,173,254,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,201,0,0,0,82,219,254,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,248,254,118,0,0,124,246,254,230,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,254,195,3,72,173,250,254,254,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,254,248,236,251,254,254,254,241,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,254,254,249,238,148,212,254,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,173,86,36,0,24,245,250,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,237,254,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,223,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,71,198,255,255,231,220,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,128,192,253,254,251,229,245,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,189,253,253,236,218,138,0,65,209,226,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,234,253,235,152,44,0,0,0,0,182,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,199,253,204,62,0,0,0,0,0,12,199,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,198,12,0,0,0,0,42,91,205,253,232,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,205,57,177,60,0,86,181,253,253,253,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,241,248,238,218,254,207,253,253,155,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,170,253,253,253,253,201,24,87,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,46,132,132,22,6,12,249,253,207,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,235,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,255,251,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,249,254,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,195,253,223,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,192,253,224,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,191,253,222,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,191,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,253,66,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,247,253,176,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,219,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,255,253,143,113,113,114,50,113,113,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,214,253,252,252,252,252,253,237,252,252,237,86,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,252,252,252,252,253,252,252,252,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,84,115,223,223,237,252,252,252,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,252,252,252,190,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,252,252,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,252,245,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,215,253,252,252,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,153,252,253,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,255,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,200,252,252,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,252,252,252,253,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,252,252,253,242,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,240,252,252,252,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,253,253,253,253,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,252,252,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,246,252,252,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,252,252,252,240,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,221,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,235,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,132,208,253,253,171,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,177,253,253,253,253,253,242,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,253,253,253,253,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,208,253,253,253,253,253,253,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,253,253,253,236,156,184,253,148,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,141,253,253,253,253,27,0,170,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,253,253,253,253,253,27,0,170,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,186,253,253,253,242,105,4,0,170,253,253,94,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,253,242,100,0,0,0,170,253,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,253,224,0,0,0,0,170,253,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,12,158,253,253,230,51,0,0,0,0,18,237,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,218,61,0,0,0,0,0,0,236,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,168,0,0,0,0,0,0,0,110,253,132,3,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,168,0,0,0,0,0,20,174,239,147,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,155,253,253,168,0,0,0,0,102,170,253,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,253,253,228,179,179,179,179,245,253,253,219,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,253,253,253,253,253,253,253,253,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,199,253,253,253,253,253,253,253,253,170,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,219,253,253,253,253,253,224,65,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,87,254,255,240,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,105,228,253,253,230,249,252,100,73,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,149,253,253,224,56,21,99,230,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,253,253,187,13,0,0,0,134,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,241,253,237,14,0,0,0,7,131,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,249,251,86,0,0,0,37,168,253,253,253,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,202,0,0,0,63,226,253,221,253,237,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,140,0,34,102,226,239,99,71,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,233,236,181,238,253,197,28,0,114,253,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,200,253,197,114,17,0,14,218,253,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,254,254,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,253,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,222,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,247,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,227,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,242,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,47,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,58,146,146,146,146,179,253,201,146,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,253,249,253,253,253,253,253,253,253,253,239,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,253,253,253,225,214,214,218,253,253,253,225,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,250,147,115,115,31,0,0,11,182,253,253,253,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,4,0,0,0,0,0,8,167,253,253,253,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,145,253,253,253,239,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,168,253,253,253,245,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,97,243,253,253,253,232,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,108,203,253,253,253,237,154,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,222,253,253,253,253,140,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,159,234,253,253,230,165,30,3,0,0,0,0,0,0,3,70,70,70,0,0,0,0,0,0,0,0,68,185,253,253,241,237,64,0,0,0,2,16,16,16,16,147,172,253,250,238,0,0,0,0,0,0,0,0,171,253,253,253,61,0,110,116,116,116,128,253,253,253,253,253,253,253,199,0,0,0,0,0,0,0,0,0,255,253,253,253,225,216,251,253,253,253,253,253,253,253,253,200,191,191,57,0,0,0,0,0,0,0,0,0,152,247,253,253,253,253,253,253,253,246,245,245,245,236,92,14,0,0,0,0,0,0,0,0,0,0,0,0,0,27,145,250,253,253,253,174,145,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,45,45,45,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,238,143,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,85,85,0,0,0,57,85,253,252,233,56,0,0,0,0,0,0,0,0,0,0,0,0,38,57,198,197,240,214,195,0,19,88,234,252,253,252,164,0,0,0,0,0,0,0,0,0,0,0,0,7,178,252,253,242,223,74,0,92,196,252,252,252,253,195,19,0,0,0,0,0,0,0,0,0,0,0,0,135,252,252,190,74,0,95,140,253,252,252,252,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,253,51,113,144,253,253,255,152,31,169,253,255,106,0,0,0,0,0,0,0,0,0,0,0,0,9,155,252,252,238,252,252,195,167,27,3,0,169,252,215,18,0,0,0,0,0,0,0,0,0,0,0,0,0,13,149,195,253,201,164,19,0,0,0,76,234,252,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,9,0,0,0,0,10,203,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,252,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,246,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,214,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,215,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,227,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,239,253,224,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,253,127,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,49,123,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,90,174,223,238,254,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,176,166,149,241,254,254,254,195,137,53,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,230,254,254,253,226,169,137,79,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,254,239,115,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,140,254,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,199,255,194,94,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,254,254,254,191,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,108,28,28,162,254,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,213,239,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,230,56,0,0,0,0,4,115,254,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,187,37,88,172,182,182,210,254,135,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,254,254,254,254,254,254,232,127,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,129,129,129,110,72,102,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,253,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,231,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,255,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,234,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,232,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,244,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,173,252,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,232,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,135,165,165,147,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,121,58,0,13,111,219,236,253,254,254,254,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,254,179,117,224,253,253,254,253,184,143,79,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,254,253,253,254,222,124,115,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,157,250,254,203,167,69,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,253,185,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,248,254,223,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,253,253,250,230,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,200,248,248,252,253,249,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,80,0,0,0,0,0,73,227,254,131,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,229,183,0,0,0,0,0,0,111,253,250,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,89,0,0,0,0,0,0,149,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,254,235,130,26,26,26,26,63,201,254,241,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,240,253,253,253,253,253,253,253,253,252,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,144,249,254,254,254,254,240,199,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,64,64,64,64,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,197,254,130,25,28,130,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,224,253,224,255,233,240,253,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,222,253,223,39,167,253,253,253,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,220,36,0,19,220,253,251,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,211,246,35,0,25,178,253,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,246,35,66,209,254,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,199,253,241,248,253,166,183,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,250,253,240,161,0,177,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,156,46,0,25,234,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,220,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,250,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,253,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,253,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,253,144,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,163,253,253,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,235,195,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,251,251,251,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,180,253,251,251,173,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,255,253,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,253,255,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,251,251,253,168,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,246,251,251,190,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,221,251,251,251,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,253,253,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,251,251,188,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,235,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,128,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,128,64,0,0,128,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,191,64,0,0,0,0,128,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,128,0,0,0,0,0,128,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,64,0,0,0,0,0,191,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,0,0,0,0,0,0,0,0,0,255,191,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,191,0,0,0,0,0,0,128,255,64,0,0,0,0,0,0,0,0,0,0,0,0,191,255,0,0,191,191,255,255,191,128,0,0,64,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,128,64,0,191,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,0,0,0,0,0,0,0,0,0,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,64,0,0,0,0,0,0,64,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,191,64,0,0,0,128,64,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,255,191,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,125,125,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,118,154,248,248,249,253,253,253,248,248,174,115,0,0,0,0,0,0,0,0,0,0,0,0,0,43,158,251,253,253,253,253,253,253,253,253,253,253,253,253,174,0,0,0,0,0,0,0,0,0,0,46,225,242,253,253,253,253,253,253,178,149,149,149,149,211,253,253,253,0,0,0,0,0,0,0,0,0,0,69,246,203,167,155,116,25,25,25,7,0,0,0,0,33,253,253,203,0,0,0,0,0,0,0,0,0,0,0,30,16,4,0,0,0,0,0,0,0,0,0,71,224,253,253,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,215,239,253,253,251,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,106,209,239,253,253,247,168,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,113,202,202,240,253,253,253,253,195,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,245,253,253,253,253,253,253,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,253,208,194,128,128,234,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,71,71,71,17,0,0,0,76,253,232,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,19,23,0,0,0,0,0,0,0,0,0,0,40,253,253,104,0,0,0,0,0,0,0,0,0,0,0,33,202,199,10,0,0,0,0,0,0,0,0,6,134,253,253,104,0,0,0,0,0,0,0,0,0,0,0,255,253,211,36,3,0,0,0,0,0,20,27,134,253,253,224,40,0,0,0,0,0,0,0,0,0,0,0,244,253,253,253,160,150,150,150,150,150,227,253,253,250,234,90,0,0,0,0,0,0,0,0,0,0,0,0,54,170,253,253,253,253,253,253,253,253,253,250,149,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,237,247,247,247,247,247,247,216,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,102,243,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,254,254,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,183,254,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,247,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,254,225,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,254,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,229,254,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,215,254,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,254,145,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,234,254,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,254,244,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,237,254,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,60,230,255,200,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,254,22,67,0,67,7,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,254,213,237,209,237,176,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,255,254,254,179,100,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,47,129,253,255,253,232,109,110,78,0,0,0,0,0,0,0,0,0,0,0,0,0,1,73,73,94,217,233,232,252,252,253,252,252,252,253,242,196,31,0,0,0,0,0,0,0,0,0,0,0,21,252,252,252,252,253,252,252,252,253,252,252,252,253,252,252,128,0,0,0,0,0,0,0,0,0,0,21,206,252,252,252,252,253,252,252,168,108,108,108,108,253,252,252,252,0,0,0,0,0,0,0,0,0,0,21,205,205,143,123,0,0,0,0,0,0,0,0,0,47,232,252,189,0,0,0,0,0,0,0,0,0,0,0,20,20,0,0,0,0,0,0,0,0,0,53,73,233,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,78,232,252,253,252,205,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,144,191,252,252,252,253,210,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,253,253,253,255,253,253,191,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,252,252,253,231,76,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,217,174,71,175,253,231,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,255,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,253,189,10,0,0,0,0,0,0,0,0,0,0,0,0,0,79,181,51,0,0,0,0,0,0,11,150,252,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,252,71,0,0,0,0,0,0,155,252,252,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,109,109,109,191,255,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,252,252,252,252,252,252,253,231,158,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,71,175,215,215,226,252,231,217,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,108,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,192,109,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,181,252,253,252,227,217,156,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,181,252,252,253,252,252,252,253,231,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,252,252,252,108,232,252,252,253,252,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,252,252,236,62,0,0,0,0,0,42,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,252,252,247,134,73,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,71,215,247,252,252,253,190,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,108,190,253,252,236,144,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,176,253,253,192,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,56,179,253,242,114,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,252,252,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,148,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,222,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,201,252,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,99,46,0,0,0,0,0,0,16,181,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,252,179,0,0,0,0,0,0,191,252,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,253,253,72,0,0,0,79,191,255,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,210,252,227,217,73,197,242,252,253,252,179,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,206,252,252,253,252,252,252,217,91,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,211,252,253,252,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,255,255,128,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,191,255,255,128,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,0,0,0,0,191,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,64,0,0,0,0,0,0,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,191,0,0,0,0,0,64,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,191,0,0,0,0,0,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,128,191,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,64,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,253,237,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,217,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,253,238,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,225,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,237,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,253,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,253,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,248,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,98,98,101,235,235,235,235,235,148,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,35,126,225,254,254,254,254,254,254,254,254,254,233,0,0,0,0,0,0,0,0,0,52,56,160,194,194,225,221,254,254,254,254,254,254,254,254,254,254,254,149,0,0,0,0,0,0,0,0,81,248,254,254,254,254,254,254,254,254,229,205,82,82,82,138,254,254,254,117,0,0,0,0,0,0,0,0,186,253,254,254,254,254,247,241,117,103,28,0,0,0,63,185,254,252,154,47,0,0,0,0,0,0,0,0,0,114,124,124,124,124,60,0,0,0,0,0,0,0,104,254,254,234,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,169,254,254,176,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,195,254,254,221,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,74,230,254,232,151,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,56,0,0,0,8,55,175,254,254,228,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0,0,0,148,254,254,251,114,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,230,254,254,251,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,232,254,235,135,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,254,254,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,200,253,232,80,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,254,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,234,234,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,173,207,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,252,252,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,230,252,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,236,101,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,235,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,235,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,174,0,0,0,0,122,121,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,253,180,0,115,242,253,255,253,253,253,167,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,180,9,220,252,252,109,108,125,233,252,187,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,252,190,92,252,167,96,0,0,0,19,208,252,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,204,252,212,252,47,0,0,0,0,0,181,252,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,252,252,143,0,0,0,0,0,95,252,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,252,252,143,0,0,0,0,0,96,252,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,204,252,252,143,0,0,0,0,80,239,193,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,234,252,237,159,98,97,115,241,229,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,168,252,252,253,252,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,63,131,132,201,235,131,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,80,80,80,80,80,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,159,159,159,162,254,254,254,254,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,254,254,254,254,254,254,254,254,254,246,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,254,254,254,254,254,254,254,254,254,254,239,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,34,53,136,34,34,34,248,254,254,254,193,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,251,254,254,190,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,89,237,254,254,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,254,254,254,232,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,185,236,254,254,254,145,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,221,254,254,254,254,168,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,210,254,254,254,196,87,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,169,254,254,254,225,56,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,254,254,254,239,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,163,253,254,254,254,191,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,0,0,0,0,0,80,254,254,254,254,190,25,0,0,0,0,0,0,0,0,0,60,132,132,217,0,0,0,0,0,0,0,0,80,254,254,254,254,234,194,36,164,212,212,212,212,212,212,212,231,254,254,230,0,0,0,0,0,0,0,0,159,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,255,254,211,43,0,0,0,0,0,0,0,0,238,248,254,254,254,254,254,254,254,254,254,254,254,251,237,212,61,61,38,0,0,0,0,0,0,0,0,0,0,99,157,211,254,254,254,254,183,157,157,157,157,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,78,78,78,78,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,111,189,254,229,170,84,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,189,253,237,221,231,254,245,229,170,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,254,222,39,0,15,174,253,253,253,238,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,254,123,0,0,0,12,31,31,186,253,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,254,63,0,0,0,0,0,0,64,253,238,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,255,63,0,0,0,0,0,0,64,254,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,254,63,0,0,0,0,0,0,133,253,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,254,128,0,0,0,0,0,64,237,253,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,204,47,0,0,0,28,208,253,233,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,254,253,230,115,5,35,200,253,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,220,254,254,229,230,254,196,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,199,253,253,254,253,241,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,241,253,253,223,156,241,253,221,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,209,253,241,145,17,0,126,253,253,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,254,243,67,0,0,0,2,184,253,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,255,142,0,0,0,0,0,182,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,254,142,0,0,0,0,0,206,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,254,157,0,0,0,0,66,244,253,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,254,249,62,0,0,4,196,253,132,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,230,158,133,215,253,238,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,25,57,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,107,170,169,234,205,252,216,169,59,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,140,215,252,253,252,252,252,252,253,252,252,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,253,255,253,253,253,253,255,253,253,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,186,167,167,168,167,167,224,252,253,252,233,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,55,12,0,0,0,0,76,234,252,253,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,234,252,252,253,179,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,240,252,252,252,112,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,255,253,228,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,243,252,253,129,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,240,252,220,56,6,0,0,0,0,0,0,38,57,57,182,197,197,197,0,0,0,0,0,0,0,0,92,243,252,217,53,29,29,29,29,29,92,169,169,224,252,253,252,252,252,236,0,0,0,0,0,0,0,0,253,252,252,177,203,253,252,252,252,252,253,252,252,252,252,253,252,220,112,50,0,0,0,0,0,0,0,0,255,253,253,253,253,255,253,253,253,253,255,253,253,253,190,141,15,0,0,0,0,0,0,0,0,0,0,0,168,167,186,252,252,253,176,167,167,167,106,27,27,27,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,55,55,56,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,121,177,194,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,219,254,251,253,203,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,254,254,254,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,254,189,252,254,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,254,117,186,254,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,232,254,254,254,254,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,254,254,254,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,148,122,181,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,254,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,248,232,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,254,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,221,254,81,0,0,0,0,11,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,194,254,191,7,0,0,0,0,100,245,0,0,0,0,0,0,0,0,0,0,0,13,53,53,9,0,4,151,254,238,46,0,0,0,0,0,184,227,0,0,0,0,0,0,0,0,0,0,13,216,254,254,225,149,201,254,254,100,0,0,0,0,0,69,245,157,0,0,0,0,0,0,0,0,0,0,216,254,254,254,254,254,254,254,168,15,0,0,0,0,5,164,254,145,0,0,0,0,0,0,0,0,0,0,246,254,254,254,254,254,254,254,187,27,1,10,6,42,164,254,252,63,0,0,0,0,0,0,0,0,0,0,143,230,236,236,224,157,249,254,254,255,195,214,206,254,254,254,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,224,254,254,254,254,254,254,249,135,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,139,224,254,254,254,162,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,37,37,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,116,199,200,249,253,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,175,243,253,253,254,253,253,214,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,150,61,149,255,254,217,104,33,92,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,207,245,114,110,83,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,102,208,245,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,136,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,161,254,255,234,163,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,47,108,134,210,253,251,203,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,89,0,0,0,8,36,107,204,217,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,180,27,0,0,0,0,0,21,218,126,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,173,0,0,0,0,53,91,193,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,254,176,169,254,255,254,254,248,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,153,245,253,253,238,198,121,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,36,36,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,255,165,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,253,253,253,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,253,253,234,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,253,253,228,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,168,238,202,174,253,253,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,81,1,215,128,28,12,181,253,253,175,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,204,253,77,0,0,0,0,7,253,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,248,253,253,143,0,0,0,0,1,127,253,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,253,253,253,20,0,0,0,0,0,81,249,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,253,218,5,0,0,0,0,0,0,203,253,208,21,0,0,0,0,0,0,0,0,0,0,0,0,56,237,253,250,100,0,0,0,0,0,0,0,104,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,224,0,0,0,0,0,0,0,0,119,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,80,253,253,103,0,0,0,0,0,0,0,4,241,253,218,32,0,0,0,0,0,0,0,0,0,0,0,0,213,253,253,103,0,0,0,0,0,0,0,125,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,253,103,0,0,0,0,0,0,3,176,253,253,135,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,253,103,0,0,0,0,0,9,162,253,253,226,37,0,0,0,0,0,0,0,0,0,0,0,0,0,179,253,253,135,0,0,0,0,46,157,253,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,188,253,249,179,179,179,179,233,253,253,233,156,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,235,253,253,253,253,253,253,251,232,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,124,253,253,253,253,152,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,125,125,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,119,119,202,250,255,254,254,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,112,213,243,245,254,254,254,254,254,254,254,254,0,0,0,0,0,0,0,0,0,0,0,0,95,152,236,251,254,254,254,254,254,254,254,254,254,254,254,133,0,0,0,0,0,0,0,0,0,46,156,230,252,254,254,254,254,254,254,254,186,136,25,167,254,254,198,13,0,0,0,0,0,0,0,0,0,233,254,254,254,254,254,179,58,32,32,32,10,0,29,242,254,254,117,0,0,0,0,0,0,0,0,0,150,254,254,254,177,55,39,7,0,0,0,0,16,106,221,254,204,96,18,0,0,0,0,0,0,0,0,0,45,173,119,45,5,0,0,0,0,0,0,0,47,254,254,246,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,212,254,245,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,172,254,224,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,218,254,235,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,203,254,218,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,139,254,245,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,101,254,245,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,169,254,195,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,190,254,196,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,172,254,238,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,254,254,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,248,204,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,128,0,0,0,0,0,0,128,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,0,0,0,0,0,64,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,64,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,128,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,0,0,0,0,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,0,0,64,191,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,0,128,128,191,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,191,128,0,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,77,145,255,231,133,41,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,25,134,249,254,253,253,253,253,253,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,167,253,253,253,235,205,171,217,226,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,253,209,90,41,0,0,0,21,176,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,184,7,0,0,0,9,84,182,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,99,0,0,0,7,156,253,236,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,235,206,148,149,210,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,253,253,253,254,253,253,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,24,128,196,144,35,253,253,209,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,13,253,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,198,255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,255,251,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,198,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,253,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,165,247,224,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,133,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,125,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,184,245,253,124,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,253,253,125,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,126,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,109,109,109,109,129,253,255,253,253,253,255,253,232,191,110,15,0,0,0,0,0,0,0,0,0,0,0,73,252,252,252,252,252,252,253,252,252,252,253,252,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,63,241,252,252,252,246,215,217,215,215,215,217,226,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,98,252,252,252,215,1,0,0,0,0,0,31,211,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,37,252,252,252,252,108,0,0,0,0,0,42,221,252,253,98,0,0,0,0,0,0,0,0,0,0,0,0,5,119,252,252,241,77,0,0,0,0,0,0,181,252,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,1,71,195,184,0,0,0,0,0,0,0,181,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,212,253,255,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,255,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,119,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,242,252,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,246,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,190,92,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,41,166,253,203,129,10,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,206,253,252,252,252,253,159,0,0,19,187,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,206,93,56,56,119,81,0,38,154,208,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,13,0,0,0,0,0,89,225,228,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,63,0,0,0,16,166,253,241,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,188,0,0,76,179,252,208,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,252,225,0,154,222,244,168,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,240,250,225,246,252,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,254,253,244,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,243,253,240,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,110,240,252,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,252,252,202,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,255,209,25,63,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,243,234,28,0,113,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,100,0,0,150,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,246,151,0,0,126,249,228,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,253,140,4,54,229,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,165,79,252,252,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,252,252,253,252,186,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,116,240,253,227,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,222,159,113,114,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,163,226,249,252,252,252,253,228,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,234,252,253,252,252,220,252,253,252,239,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,225,99,84,37,84,146,249,252,180,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,227,252,173,0,0,0,0,0,0,225,252,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,228,47,0,0,0,0,0,0,0,163,253,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,21,0,0,0,0,0,0,0,0,85,252,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,104,252,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,191,252,252,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,255,253,253,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,152,253,252,252,252,252,241,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,56,55,55,155,252,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,177,253,224,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,140,126,0,0,0,0,0,63,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,84,0,0,0,0,0,0,192,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,234,146,85,57,0,0,48,159,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,208,252,252,253,233,197,197,227,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,99,223,237,252,252,252,252,253,226,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,237,252,252,252,190,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,23,23,28,133,133,229,230,133,133,75,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,253,253,253,253,253,253,254,253,253,253,196,128,5,0,0,0,0,0,0,0,0,0,0,0,0,0,44,248,253,253,253,253,226,165,165,165,238,253,253,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,131,180,79,22,15,0,0,0,18,196,253,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,253,199,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,107,242,253,236,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,178,253,253,244,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,53,178,254,251,221,129,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,171,253,253,253,178,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,172,225,253,253,179,58,0,0,0,44,66,100,100,100,100,196,0,0,0,0,0,0,0,0,0,45,176,249,253,253,195,33,25,120,148,243,243,248,250,253,253,250,231,134,0,0,0,0,0,0,0,0,71,227,253,253,253,253,253,253,253,253,255,253,253,253,241,198,145,73,0,0,0,0,0,0,0,0,0,0,159,253,253,253,253,253,211,145,136,203,151,131,122,55,43,0,0,0,0,0,0,0,0,0,0,0,0,0,195,242,242,233,131,94,11,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,197,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,251,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,196,253,251,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,254,253,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,83,196,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,210,253,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,252,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,86,242,252,252,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,252,252,252,188,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,242,252,252,225,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,252,252,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,231,252,252,212,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,252,252,252,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,132,253,252,252,230,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,252,253,252,154,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,55,0,0,0,0,107,253,255,228,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,24,23,0,0,0,110,242,252,228,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,83,0,0,0,88,247,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,189,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,252,252,238,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,252,252,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,217,252,252,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,252,252,252,85,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,239,252,156,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,252,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,180,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,25,25,25,25,7,19,159,244,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,198,254,253,253,253,184,231,241,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,96,246,253,252,193,166,253,253,239,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,253,253,166,69,0,124,253,239,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,242,253,78,32,4,142,231,239,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,214,253,134,5,0,53,253,200,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,180,5,0,151,238,244,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,212,253,168,0,100,247,249,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,185,253,209,122,241,253,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,254,254,254,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,253,253,202,140,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,231,183,96,148,234,254,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,230,239,39,0,0,122,254,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,155,253,94,0,0,0,150,254,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,172,14,0,28,183,251,251,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,235,214,14,25,126,224,253,213,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,170,253,223,98,200,253,253,165,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,253,253,253,253,253,217,99,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,81,207,230,132,98,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,125,125,125,125,125,125,125,125,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,226,249,253,254,254,255,254,254,255,255,254,248,58,0,0,0,0,0,0,0,0,0,0,0,0,44,159,247,254,254,254,254,254,254,254,254,254,254,254,254,248,0,0,0,0,0,0,0,0,0,0,0,0,126,241,254,254,254,173,149,149,127,19,36,149,157,254,254,187,0,0,0,0,0,0,0,0,0,0,0,0,0,22,136,116,25,6,0,0,0,0,64,99,178,254,201,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,113,243,254,254,254,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,216,243,254,254,254,248,96,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,117,210,243,254,254,202,176,95,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,254,254,254,254,114,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,189,206,254,254,191,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,95,238,254,211,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,239,254,228,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,254,249,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,189,254,239,51,0,0,0,0,0,0,0,0,0,0,0,0,17,161,164,43,4,0,0,0,0,0,39,183,254,249,126,0,0,0,0,0,0,0,0,0,0,0,0,0,138,255,254,254,25,0,14,0,22,128,180,254,250,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,254,254,254,161,151,204,151,234,255,254,250,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,242,254,254,254,254,254,254,251,241,143,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,117,117,167,248,248,207,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,192,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,166,254,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,223,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,243,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,245,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,254,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,254,113,0,0,0,0,55,60,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,235,254,113,0,0,60,122,249,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,254,113,0,23,218,255,254,254,250,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,249,10,19,146,254,254,254,254,227,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,249,18,151,254,251,247,254,254,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,252,208,254,255,108,110,254,234,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,254,254,254,193,148,240,254,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,254,254,235,115,238,254,225,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,254,254,254,254,254,254,179,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,182,254,254,254,254,176,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,249,254,254,227,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,255,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,228,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,236,251,205,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,158,251,251,178,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,253,253,253,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,251,251,211,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,174,251,251,140,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,181,253,251,219,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,251,204,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,253,255,233,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,174,244,251,253,109,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,189,251,251,126,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,106,251,235,188,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,251,251,228,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,213,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,253,251,251,85,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,127,253,235,126,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,251,253,240,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,193,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,191,178,253,242,141,104,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,253,252,252,252,253,252,252,252,108,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,123,222,253,252,252,252,168,224,252,252,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,243,252,252,253,252,252,252,0,19,153,252,253,209,25,0,0,0,0,0,0,0,0,0,0,0,10,128,255,253,244,225,114,194,253,178,0,0,0,163,254,253,168,0,0,0,0,0,0,0,0,0,0,0,85,252,253,189,56,0,0,19,133,9,0,0,0,38,253,252,168,0,0,0,0,0,0,0,0,0,0,19,191,252,194,19,0,0,0,0,0,0,0,0,0,0,253,252,234,22,0,0,0,0,0,0,0,0,0,107,252,252,13,0,0,0,0,0,0,0,0,0,0,0,253,252,252,128,0,0,0,0,0,0,0,0,0,169,253,241,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,140,0,0,0,0,0,0,0,0,19,225,252,139,0,0,0,0,0,0,0,0,0,0,0,0,66,252,252,139,0,0,0,0,0,0,0,0,29,252,252,52,0,0,0,0,0,0,0,0,0,0,0,0,29,252,252,139,0,0,0,0,0,0,0,0,29,252,252,28,0,0,0,0,0,0,0,0,0,0,0,0,29,252,252,40,0,0,0,0,0,0,0,0,141,253,253,91,0,0,0,0,0,0,0,0,0,0,0,0,154,253,168,0,0,0,0,0,0,0,0,0,66,252,252,165,0,0,0,0,0,0,0,0,0,0,0,0,253,252,168,0,0,0,0,0,0,0,0,0,19,224,252,252,0,0,0,0,0,0,0,0,0,0,0,126,253,252,80,0,0,0,0,0,0,0,0,0,0,169,252,252,214,38,0,0,0,0,0,0,0,0,126,249,253,151,6,0,0,0,0,0,0,0,0,0,0,26,223,253,254,253,128,29,0,0,0,13,41,216,253,253,226,38,0,0,0,0,0,0,0,0,0,0,0,0,122,252,253,252,252,252,169,169,169,206,253,252,252,202,38,0,0,0,0,0,0,0,0,0,0,0,0,0,19,56,168,224,252,252,253,252,252,252,253,233,130,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,139,190,153,252,164,139,28,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,118,118,118,118,118,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,112,222,253,253,253,253,253,251,225,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,222,251,253,253,253,253,253,253,253,253,253,242,235,161,48,0,0,0,0,0,0,0,0,0,0,0,0,65,244,253,127,25,129,155,126,25,49,155,218,253,253,253,236,48,0,0,0,0,0,0,0,0,0,0,0,0,79,48,5,0,0,0,0,0,0,0,21,45,169,253,253,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,99,253,253,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,79,163,253,253,248,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,96,210,253,253,253,253,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,169,196,196,208,253,253,253,246,188,115,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,215,253,253,253,253,244,194,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,201,201,239,253,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,176,9,0,0,0,0,0,0,0,0,183,253,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,193,6,0,0,0,0,0,0,0,0,183,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,12,0,0,0,0,0,0,9,64,228,247,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,161,103,27,13,27,27,27,152,253,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,231,252,253,253,200,253,253,253,253,253,212,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,253,253,253,253,249,240,206,110,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,117,117,117,117,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,250,255,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,123,247,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,253,180,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,253,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,253,253,228,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,253,253,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,251,253,253,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,238,253,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,253,253,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,253,253,253,253,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,253,253,253,177,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,253,253,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,253,253,219,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,253,247,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,176,253,253,159,113,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,252,252,252,241,100,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,227,253,252,252,252,252,253,252,239,181,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,224,252,253,226,246,252,252,253,252,252,252,252,108,3,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,27,88,112,112,112,112,142,252,252,253,152,31,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,79,0,0,0,0,0,0,32,153,253,255,253,196,0,0,0,0,0,0,0,0,0,0,0,76,246,252,127,0,0,0,0,0,0,0,0,3,106,253,252,214,28,0,0,0,0,0,0,0,0,0,0,194,252,252,112,0,0,0,0,0,0,0,0,0,0,143,252,252,193,0,0,0,0,0,0,0,0,0,0,225,252,217,37,0,0,0,0,0,0,0,0,0,0,38,234,252,223,0,0,0,0,0,0,0,0,0,63,240,252,84,0,0,0,0,0,0,0,0,0,0,0,0,146,252,223,0,0,0,0,0,0,0,0,0,114,253,228,47,0,0,0,0,0,0,0,0,0,0,0,0,147,253,253,112,0,0,0,0,0,0,0,0,159,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,252,112,0,0,0,0,0,0,0,0,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,230,25,0,0,0,0,0,0,0,0,159,252,202,10,0,0,0,0,0,0,0,0,0,0,0,92,243,252,208,0,0,0,0,0,0,0,0,0,113,252,252,161,0,0,0,0,0,0,0,0,0,0,79,253,252,220,37,0,0,0,0,0,0,0,0,0,114,253,253,253,174,63,0,0,0,0,0,0,26,128,253,255,253,133,0,0,0,0,0,0,0,0,0,0,12,228,252,252,252,241,100,85,76,0,85,131,231,252,252,253,129,6,0,0,0,0,0,0,0,0,0,0,0,97,208,252,252,253,252,252,246,197,253,252,252,252,220,133,6,0,0,0,0,0,0,0,0,0,0,0,0,0,19,99,239,253,252,252,252,252,253,252,245,223,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,112,112,221,252,252,253,127,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,136,254,255,195,115,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,175,253,196,160,252,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,234,4,0,27,205,232,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,246,253,68,0,0,0,24,243,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,134,235,99,4,0,0,0,0,132,247,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,62,0,0,0,0,0,0,23,233,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,183,4,0,0,0,0,0,0,0,182,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,232,59,0,0,0,0,0,0,0,0,95,232,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,183,0,0,0,0,0,0,0,0,0,0,228,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,124,0,0,0,0,0,0,0,0,0,0,228,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,124,0,0,0,0,0,0,0,0,0,0,228,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,124,0,0,0,0,0,0,0,0,0,0,169,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,124,0,0,0,0,0,0,0,0,0,0,203,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,124,0,0,0,0,0,0,0,0,0,10,220,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,155,0,0,0,0,0,0,0,0,0,111,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,228,7,0,0,0,0,0,0,0,12,181,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,166,9,0,0,0,0,0,24,209,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,250,167,11,2,11,11,129,227,90,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,247,253,178,253,253,244,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,175,253,232,149,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,225,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,253,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,251,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,253,251,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,253,226,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,251,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,255,255,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,253,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,221,253,253,253,218,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,220,253,217,138,248,253,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,220,253,231,108,0,199,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,220,253,246,63,0,0,199,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,165,188,70,0,0,0,199,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,205,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,169,211,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,155,253,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,72,228,253,251,251,251,212,131,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,189,251,251,253,251,251,251,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,251,251,211,189,69,110,244,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,211,35,0,0,0,221,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,158,119,0,0,0,0,223,253,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,244,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,169,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,205,251,251,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0,0,0,96,253,253,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,171,190,230,190,190,150,32,115,251,251,251,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,253,251,251,251,251,253,251,251,251,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,236,235,188,189,188,220,251,251,253,251,251,251,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,188,0,0,0,127,251,251,253,251,251,251,251,159,39,0,0,0,0,0,0,0,0,0,0,0,60,230,253,213,194,255,253,253,253,253,255,253,253,253,253,255,233,96,12,0,0,0,0,0,0,0,0,0,0,190,251,251,251,253,251,251,251,231,161,62,141,228,251,253,251,251,157,12,0,0,0,0,0,0,0,0,0,111,251,251,251,253,251,251,219,47,0,0,0,32,204,253,251,251,251,94,0,0,0,0,0,0,0,0,0,4,110,188,188,189,168,31,23,0,0,0,0,0,19,91,236,251,251,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,251,211,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,101,115,255,212,194,101,101,98,0,0,0,0,0,0,0,0,0,0,0,0,130,47,197,200,200,200,200,228,253,253,253,253,253,253,253,247,27,0,0,0,0,0,0,0,0,0,0,59,231,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,207,26,0,0,0,0,0,0,0,0,0,3,202,253,253,239,160,160,160,160,160,160,160,160,160,160,239,253,253,215,37,0,0,0,0,0,0,0,0,0,77,214,65,52,0,0,0,0,0,0,0,0,0,0,99,253,253,253,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,253,253,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,253,202,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,179,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,241,253,253,220,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,253,253,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,253,253,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,253,251,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,175,253,253,245,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,253,253,253,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,253,253,238,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,182,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,105,106,105,105,176,254,237,105,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,243,253,254,253,253,253,253,253,253,159,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,253,253,254,253,252,167,132,249,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,253,253,254,225,126,0,0,179,253,253,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,143,178,179,48,0,0,23,201,253,253,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,184,253,253,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,191,253,253,253,205,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,240,253,253,253,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,243,253,253,253,230,59,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,241,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,212,218,254,254,254,254,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,29,115,211,253,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,205,253,168,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,253,210,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,245,253,163,0,0,0,0,0,0,0,0,0,0,0,8,128,179,135,9,0,0,0,0,0,8,30,102,245,253,253,57,0,0,0,0,0,0,0,0,0,0,0,139,253,253,253,169,134,8,0,0,80,139,253,253,253,253,253,14,0,0,0,0,0,0,0,0,0,0,0,47,222,253,253,253,253,240,239,239,249,251,253,253,253,189,84,1,0,0,0,0,0,0,0,0,0,0,0,0,47,208,221,253,253,253,253,253,254,253,253,232,76,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,104,183,253,253,253,255,253,155,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,167,208,254,255,129,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,253,253,253,209,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,253,253,253,227,181,253,207,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,253,253,253,92,38,226,253,129,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,253,248,62,0,50,253,253,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,253,135,0,0,12,208,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,232,253,253,21,0,0,0,60,253,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,253,253,224,14,0,0,0,14,217,247,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,193,253,250,64,0,0,0,0,0,199,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,253,205,0,0,0,0,0,0,98,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,245,43,0,0,0,0,0,0,63,250,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,243,0,0,0,0,0,0,0,0,244,222,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,217,0,0,0,0,0,0,0,0,244,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,3,195,253,134,0,0,0,0,0,0,0,0,156,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,134,0,0,0,0,0,0,0,0,239,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,134,0,0,0,0,0,0,0,53,246,237,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,200,229,40,0,0,0,0,0,25,225,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,250,230,58,17,0,12,42,213,253,238,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,217,179,206,253,253,196,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,58,145,152,253,214,145,74,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,232,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,228,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,254,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,226,51,0,0,0,0,0,99,254,254,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,236,58,0,0,0,0,0,99,254,254,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,254,234,16,0,0,0,0,99,254,232,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,254,254,21,0,0,0,0,151,254,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,254,199,8,0,0,0,0,207,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,249,254,82,0,0,0,0,48,244,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,143,254,254,243,232,130,45,22,169,254,241,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,254,254,254,254,254,254,254,254,254,254,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,250,156,74,48,118,156,249,254,254,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,119,68,0,0,0,0,0,146,254,202,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,254,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,112,254,247,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,254,254,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,254,254,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,97,217,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,118,250,253,174,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,250,240,109,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,253,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,255,219,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,244,254,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,253,235,27,0,0,0,0,37,79,79,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,142,0,0,0,68,159,243,253,253,200,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,98,0,0,106,239,254,253,253,253,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,254,99,0,138,254,254,196,91,0,16,218,255,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,98,70,241,250,121,15,0,0,0,113,254,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,253,128,214,253,146,0,0,0,0,0,128,254,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,249,250,240,23,0,0,0,0,7,204,254,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,254,253,137,0,0,0,0,0,189,253,171,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,240,255,254,78,0,0,0,13,186,254,231,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,253,226,125,118,178,217,253,219,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,253,253,253,253,254,253,168,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,232,253,253,253,254,219,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,126,208,215,155,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,13,123,137,137,192,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,59,236,254,254,254,254,254,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,56,117,153,254,254,254,254,244,229,229,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,190,254,246,126,138,120,205,114,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,180,254,245,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,225,254,245,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,254,254,148,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,228,254,254,254,236,181,84,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,186,254,254,254,254,254,254,233,144,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,83,186,125,186,186,206,254,254,96,9,0,0,0,0,0,0,0,0,0,0,0,0,2,35,0,0,0,0,0,0,0,0,0,17,119,254,254,67,0,0,0,0,0,0,0,0,0,0,0,0,108,218,0,0,0,0,0,0,0,0,0,0,82,254,254,116,0,0,0,0,0,0,0,0,0,0,0,0,174,252,93,0,0,0,0,0,0,0,0,0,82,254,254,30,0,0,0,0,0,0,0,0,0,0,0,0,149,254,164,39,0,0,0,0,0,0,0,0,128,254,254,30,0,0,0,0,0,0,0,0,0,0,0,0,21,254,254,225,88,0,0,0,0,0,0,116,249,254,124,4,0,0,0,0,0,0,0,0,0,0,0,0,1,24,154,254,252,151,107,107,107,136,231,249,254,254,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,208,254,254,254,254,254,254,254,254,219,100,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,88,211,254,254,254,254,164,39,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,6,6,6,6,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,91,91,218,254,254,254,148,254,95,91,91,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,253,253,253,253,253,253,246,180,180,180,34,0,0,0,0,0,0,0,0,0,0,0,254,253,253,170,146,146,146,146,146,146,219,253,253,253,253,253,220,107,7,0,0,0,0,0,0,0,0,0,57,56,56,13,0,0,0,0,0,0,39,56,56,56,189,237,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,155,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,218,253,195,92,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,200,253,253,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,146,251,253,186,86,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,124,253,253,249,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,99,249,253,253,179,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,116,205,253,253,236,164,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,116,142,253,253,253,215,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,111,211,253,253,253,215,111,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,139,253,253,253,253,180,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,253,253,253,253,236,73,58,58,58,58,58,58,58,58,8,34,58,58,0,0,0,0,0,0,0,0,255,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,161,209,253,253,0,0,0,0,0,0,0,0,74,179,179,179,179,179,179,246,253,253,253,253,253,253,253,253,253,253,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,89,89,201,253,253,253,253,253,110,89,89,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,255,179,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,203,253,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,202,253,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,253,253,253,132,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,237,253,253,212,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,253,253,211,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,239,252,253,209,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,195,253,253,211,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,253,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,253,253,68,0,0,0,0,69,78,78,78,75,0,0,0,0,0,0,0,0,0,0,0,0,0,103,251,253,253,179,21,0,0,31,177,244,253,253,253,246,14,0,0,0,0,0,0,0,0,0,0,0,0,146,253,253,253,14,0,0,38,214,253,253,245,186,253,253,145,0,0,0,0,0,0,0,0,0,0,0,0,146,253,253,253,14,0,0,213,253,253,234,79,14,220,251,106,0,0,0,0,0,0,0,0,0,0,0,0,146,253,253,160,5,0,89,246,253,245,79,0,0,216,250,98,0,0,0,0,0,0,0,0,0,0,0,0,146,253,253,115,0,0,131,253,253,129,0,0,54,233,253,145,0,0,0,0,0,0,0,0,0,0,0,12,172,253,253,115,0,8,161,253,247,99,55,165,233,253,209,22,0,0,0,0,0,0,0,0,0,0,0,47,253,253,253,203,162,173,253,253,245,162,242,253,253,209,33,0,0,0,0,0,0,0,0,0,0,0,0,27,207,253,253,253,253,253,253,253,253,253,253,253,203,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,195,199,229,253,253,253,253,253,253,238,189,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,244,253,253,253,253,253,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,173,242,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,169,254,254,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,254,254,254,169,0,0,0,0,0,0,0,2,10,10,1,0,0,0,0,0,0,0,0,0,0,0,0,67,254,254,249,119,0,0,0,0,0,0,0,105,254,254,65,0,0,0,0,0,0,0,0,0,0,0,0,199,254,254,235,0,0,0,0,0,0,0,0,237,254,254,229,74,0,0,0,0,0,0,0,0,0,0,110,245,254,254,80,0,0,0,0,0,3,20,20,239,254,254,254,131,0,0,0,0,0,0,0,0,0,0,133,254,254,254,46,0,0,0,0,0,102,254,254,254,254,254,254,131,0,0,0,0,0,0,0,0,0,0,133,254,254,254,46,0,0,0,57,152,244,254,254,254,254,254,254,131,0,0,0,0,0,0,0,0,0,0,133,254,254,254,46,0,0,25,114,254,254,254,254,254,254,254,254,131,0,0,0,0,0,0,0,0,0,0,133,254,254,254,124,96,96,232,254,254,254,215,159,248,254,254,254,131,0,0,0,0,0,0,0,0,0,0,133,254,254,254,254,254,254,254,254,254,230,55,0,237,254,254,254,131,0,0,0,0,0,0,0,0,0,0,133,254,254,254,254,254,254,254,240,216,43,0,0,237,254,254,203,14,0,0,0,0,0,0,0,0,0,0,79,232,254,254,254,254,192,150,95,0,0,0,0,237,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,73,254,254,242,84,34,0,0,0,0,0,0,237,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,1,18,18,16,0,0,0,0,0,0,0,0,237,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,254,254,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,254,254,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,255,241,0,0,0,0,0,0,0,58,118,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,252,163,97,63,27,45,97,101,243,253,236,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,253,239,224,231,253,253,253,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,253,253,253,243,204,253,253,253,190,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,253,164,82,82,82,66,28,253,253,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,253,123,0,0,0,0,110,253,253,248,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,253,246,60,0,0,0,25,210,253,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,143,61,0,0,0,0,183,253,253,199,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,246,253,251,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,194,253,246,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,253,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,244,253,248,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,248,253,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,190,253,253,219,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,253,217,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,240,253,253,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,162,253,253,133,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,253,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,242,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,246,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,150,233,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,89,253,254,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,203,254,254,254,232,77,54,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,155,240,254,223,76,254,254,254,254,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,101,216,254,227,122,26,110,254,254,254,184,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,222,254,254,179,48,0,0,181,254,254,146,6,0,0,0,0,0,0,0,0,0,0,0,0,0,2,145,248,254,182,111,4,0,0,3,250,254,206,3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,144,254,254,171,0,0,0,0,0,125,254,252,80,0,0,0,0,0,0,0,0,0,0,0,0,0,6,142,254,179,95,4,0,0,0,0,61,246,254,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,254,177,14,0,0,0,0,0,0,124,254,246,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,97,15,0,0,0,0,0,0,24,226,254,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,255,254,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,254,99,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,199,254,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,254,254,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,192,8,3,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,198,254,128,66,130,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,202,106,84,84,84,112,254,254,254,254,212,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,254,254,254,254,254,254,254,254,162,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,106,177,254,254,254,235,135,100,17,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,151,255,234,125,125,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,252,253,253,253,253,253,240,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,251,253,253,253,253,253,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,214,253,229,55,19,106,149,213,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,253,203,194,0,0,0,0,39,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,253,203,48,0,0,0,0,140,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,253,65,0,0,14,102,239,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,190,39,103,216,253,253,207,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,212,253,253,227,253,253,244,181,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,173,242,253,253,253,241,101,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,107,211,253,253,253,253,226,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,197,253,253,210,164,118,253,253,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,248,253,237,97,14,0,20,209,253,239,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,167,54,0,0,0,0,189,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,249,240,22,0,0,0,0,0,189,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,159,3,0,0,0,0,0,189,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,253,43,13,0,0,0,0,189,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,253,253,214,143,77,143,143,225,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,249,253,253,253,253,253,253,253,252,156,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,123,237,253,253,253,253,155,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,54,43,185,254,255,227,150,3,75,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,165,253,253,253,237,238,253,253,206,253,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,253,221,100,65,2,3,156,253,253,253,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,253,114,0,0,0,0,9,213,253,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,228,253,128,0,0,0,0,0,41,253,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,196,253,225,29,0,0,0,0,136,253,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,253,234,95,2,0,52,245,253,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,109,245,253,253,230,230,246,253,253,216,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,145,224,253,251,147,213,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,8,8,0,188,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,181,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,111,180,255,255,71,6,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,176,253,242,253,253,254,180,10,0,0,0,0,122,0,0,0,0,0,0,0,0,0,0,0,0,0,106,226,253,183,51,96,96,237,253,176,13,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,7,186,253,181,16,0,0,0,133,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,239,46,0,0,0,0,133,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,193,0,0,0,0,0,168,253,225,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,193,0,0,0,0,197,254,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,216,98,19,0,89,247,255,186,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,177,253,253,235,230,251,253,191,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,132,225,253,253,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,255,255,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,253,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,253,253,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,220,253,222,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,216,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,248,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,225,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,120,202,254,254,255,160,79,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,253,249,246,244,243,253,253,208,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,89,47,27,9,0,85,165,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,250,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,181,253,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,103,237,253,204,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,207,93,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,252,253,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,235,253,244,157,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,176,231,253,231,148,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,163,249,253,242,121,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,135,208,253,191,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,253,234,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,170,253,227,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,179,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,253,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,13,0,0,12,214,237,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,213,189,124,91,206,254,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,96,229,253,254,253,254,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,121,203,253,187,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,131,246,252,252,203,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,252,252,252,252,166,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,107,253,252,252,252,252,253,224,137,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,253,252,220,128,252,253,252,252,239,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,255,168,0,0,79,192,253,253,253,253,255,90,0,0,0,0,0,0,0,0,0,0,0,0,0,51,243,252,215,33,0,0,0,12,74,233,252,252,253,195,19,0,0,0,0,0,0,0,0,0,0,0,0,166,252,252,31,0,0,0,0,0,0,43,149,195,253,252,177,19,0,0,0,0,0,0,0,0,0,0,57,234,252,252,0,0,0,0,0,0,0,0,0,0,237,252,252,180,13,0,0,0,0,0,0,0,0,0,85,252,252,173,0,0,0,0,0,0,0,0,0,0,50,237,252,252,112,0,0,0,0,0,0,0,0,0,226,253,240,63,0,0,0,0,0,0,0,0,0,0,0,163,253,253,112,0,0,0,0,0,0,0,0,38,234,252,176,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,158,0,0,0,0,0,0,0,0,113,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,19,209,252,252,0,0,0,0,0,0,0,0,207,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,10,203,252,236,0,0,0,0,0,0,0,0,253,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,112,0,0,0,0,0,0,0,0,114,253,253,146,0,0,0,0,0,0,0,0,0,0,0,51,159,253,240,63,0,0,0,0,0,0,0,0,75,243,252,249,146,0,0,0,0,0,0,0,0,57,85,238,252,252,99,0,0,0,0,0,0,0,0,0,0,116,252,252,252,198,197,165,57,57,57,182,197,234,252,253,233,164,19,0,0,0,0,0,0,0,0,0,0,28,84,180,252,253,252,252,252,252,253,252,252,252,252,225,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,112,253,252,252,252,252,253,252,252,157,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,13,117,133,133,197,254,254,173,133,99,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,147,253,253,253,253,254,253,253,253,253,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,226,253,223,216,216,101,97,96,96,126,253,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,181,16,0,0,0,0,0,0,72,253,239,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,72,17,0,0,0,0,0,0,9,189,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,156,253,235,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,238,253,165,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,253,220,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,254,241,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,255,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,180,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,223,253,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,174,253,232,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,225,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,242,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,253,220,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,212,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,253,183,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,141,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,131,253,251,235,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,255,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,251,253,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,236,251,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,158,251,251,169,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,251,251,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,253,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,251,251,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,251,251,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,127,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,58,20,14,217,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,146,247,253,235,27,84,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,164,19,15,0,0,156,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,222,34,0,0,0,0,234,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,254,116,0,0,0,0,0,235,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,251,72,0,0,0,0,0,151,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,233,0,0,0,0,0,0,136,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,218,0,0,0,0,0,0,136,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,135,0,0,0,0,0,0,136,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,255,114,0,0,0,0,0,0,137,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,122,0,0,0,0,0,0,136,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,106,0,0,0,0,0,0,166,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,128,0,0,0,0,0,0,234,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,135,0,0,0,0,0,61,248,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,238,18,0,0,0,13,224,254,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,253,128,2,0,5,150,253,167,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,226,253,49,31,156,253,228,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,243,241,254,227,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,126,245,253,231,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,128,253,255,206,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,131,246,252,252,253,252,199,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,57,222,252,252,214,195,222,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,226,114,28,0,113,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,112,112,12,0,0,0,113,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,135,253,252,208,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,252,253,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,204,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,255,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,85,85,85,163,85,215,252,252,152,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,135,198,246,252,252,252,253,252,252,252,252,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,131,252,253,226,223,227,252,253,252,252,252,252,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,190,12,0,29,252,253,252,252,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,190,0,0,89,207,253,255,253,190,253,253,255,27,0,0,0,0,0,0,0,0,0,0,0,0,76,246,226,12,85,210,246,252,252,215,42,12,52,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,85,252,246,197,253,252,252,245,195,31,0,0,7,55,56,6,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,252,253,252,198,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,112,205,252,190,112,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,141,156,156,194,194,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,132,239,253,253,253,253,254,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,172,253,235,167,78,93,174,254,247,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,210,253,237,90,0,0,0,0,201,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,237,58,0,0,0,0,0,156,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,235,53,0,0,0,19,5,0,156,254,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,254,253,92,0,0,0,17,226,217,49,148,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,254,239,24,0,0,0,20,253,253,58,18,115,24,0,0,0,0,0,0,0,0,0,0,0,0,0,37,248,254,91,0,0,0,0,2,117,250,163,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,253,254,39,0,0,0,0,0,0,196,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,254,218,15,0,0,0,0,0,0,77,254,255,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,113,0,0,0,0,0,0,0,21,226,254,135,0,0,0,0,0,0,0,0,0,0,0,0,0,25,240,253,68,0,0,0,0,0,0,0,0,195,254,135,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,0,0,0,0,0,0,0,0,0,195,254,135,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,76,0,0,0,0,0,0,0,0,195,254,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,254,209,9,0,0,0,0,0,0,10,209,196,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,253,254,137,36,0,0,0,2,20,168,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,235,254,253,199,124,79,79,167,253,253,185,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,117,217,253,253,253,254,253,240,109,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,126,208,253,193,147,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,105,106,140,254,254,254,255,254,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,243,253,254,253,253,253,253,253,253,238,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,253,253,254,249,140,89,132,240,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,232,133,134,102,0,0,0,31,253,253,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,24,0,0,0,0,0,0,163,253,253,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,163,232,253,242,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,191,253,253,253,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,126,248,253,253,253,205,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,253,253,253,240,102,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,222,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,236,254,254,254,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,56,253,253,230,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,166,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,183,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,226,14,0,0,0,0,0,0,0,0,0,0,0,75,179,179,109,31,9,0,0,0,0,0,25,175,253,253,205,0,0,0,0,0,0,0,0,0,0,0,0,50,230,253,253,253,153,0,0,0,0,56,233,253,253,213,35,0,0,0,0,0,0,0,0,0,0,0,0,0,47,222,253,253,251,239,240,239,239,247,253,253,210,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,129,221,253,253,253,253,253,254,253,215,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,210,253,253,253,253,105,104,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,51,150,155,255,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,129,207,126,248,253,253,232,52,0,0,0,0,0,0,0,0,0,0,0,0,45,140,140,98,98,140,223,249,253,253,253,253,253,237,126,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,253,253,253,253,253,253,253,253,253,253,197,52,0,0,0,0,0,0,0,0,0,0,0,0,0,35,242,253,253,253,253,253,253,253,244,215,124,73,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,253,253,253,253,253,195,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,252,212,134,113,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,253,242,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,252,253,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,229,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,146,253,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,186,251,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,253,241,110,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,160,253,253,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,88,4,0,0,0,0,0,35,253,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,167,21,21,13,7,10,47,128,253,253,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,253,253,220,196,210,253,253,253,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,224,253,253,253,253,253,253,253,253,249,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,253,253,253,253,253,253,218,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,226,168,253,253,211,164,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,255,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,253,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,253,238,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,253,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,253,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,203,76,0,0,0,0,0,0,0,12,253,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,2,191,253,147,0,0,0,0,0,0,0,15,253,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,24,217,253,157,1,0,0,0,0,0,0,130,253,227,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,253,11,0,0,0,0,0,0,205,253,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,178,4,0,0,0,0,0,79,252,253,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,239,253,179,76,0,0,0,0,0,113,253,253,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,253,253,253,252,213,194,95,67,0,212,253,228,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,225,253,201,253,253,253,253,246,175,251,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,3,5,72,198,244,253,253,253,242,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,150,253,253,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,253,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,210,253,224,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,209,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,88,211,219,151,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,210,254,254,222,106,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,63,229,254,185,97,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,254,182,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,219,248,181,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,255,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,245,241,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,254,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,235,253,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,118,0,0,0,0,0,0,19,66,156,106,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,78,0,0,0,0,0,57,196,254,254,254,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,254,78,0,0,1,64,229,253,254,249,243,254,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,254,78,0,22,135,254,254,254,151,55,146,254,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,254,142,81,165,254,254,254,147,4,4,185,254,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,248,254,254,254,254,254,224,3,0,32,254,254,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,129,129,160,254,250,58,0,0,134,254,219,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,132,0,0,88,250,234,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,168,115,174,246,236,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,254,254,254,254,234,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,152,190,150,91,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,25,25,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,107,157,157,71,129,189,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,253,253,253,253,253,253,253,232,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,250,254,253,253,253,253,207,193,146,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,248,253,216,180,163,60,60,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,230,253,253,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,253,253,98,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,238,253,253,254,251,213,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,122,132,254,253,253,251,155,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,255,254,181,0,0,0,0,0,0,0,0,0,0,0,0,140,11,0,0,0,0,0,0,0,0,0,0,16,205,253,180,0,0,0,0,0,0,0,0,0,0,0,0,254,198,78,0,0,0,0,0,0,0,0,0,6,182,253,163,0,0,0,0,0,0,0,0,0,0,0,0,148,233,241,146,37,0,0,0,0,0,0,0,60,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,111,230,253,236,90,12,0,0,0,0,47,226,253,181,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,194,253,253,205,194,194,194,195,228,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,134,233,253,253,253,253,254,253,241,88,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,133,156,156,156,36,36,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,241,192,66,29,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,227,97,208,252,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,139,0,13,209,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,240,51,0,197,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,250,229,10,38,63,16,104,104,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,109,82,169,216,240,196,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,240,240,252,206,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,253,252,252,151,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,241,255,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,172,252,253,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,252,127,128,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,206,177,3,29,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,168,0,29,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,252,168,0,29,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,252,168,0,66,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,168,0,141,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,147,253,233,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,224,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,212,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,250,254,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,250,254,172,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,215,254,242,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,254,254,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,254,197,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,208,254,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,201,254,242,27,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,254,254,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,254,248,84,0,0,0,0,0,0,0,0,0,16,49,15,0,0,0,0,0,0,0,0,0,0,0,64,241,254,220,0,0,0,0,0,0,0,0,0,83,195,254,169,26,0,0,0,0,0,0,0,0,0,0,176,254,254,141,0,0,0,0,0,0,0,1,75,249,254,254,254,234,0,0,0,0,0,0,0,0,0,0,235,254,254,82,0,0,0,0,0,0,0,75,254,254,254,254,254,234,0,0,0,0,0,0,0,0,0,0,235,254,254,82,0,0,0,0,0,0,83,249,254,156,65,225,254,177,0,0,0,0,0,0,0,0,0,0,190,254,254,127,0,0,0,0,0,43,243,254,254,13,84,254,241,65,0,0,0,0,0,0,0,0,0,0,74,245,254,247,115,0,0,0,0,83,254,254,187,122,218,254,105,0,0,0,0,0,0,0,0,0,0,0,0,117,254,254,250,180,180,180,180,235,254,254,254,254,254,188,22,0,0,0,0,0,0,0,0,0,0,0,0,29,126,234,246,254,254,254,254,254,254,254,254,246,189,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,254,254,254,254,254,254,187,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,92,92,198,92,198,92,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,108,248,254,254,254,254,254,254,243,182,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,254,254,254,254,254,254,254,254,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,254,254,254,62,57,57,179,236,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,199,142,130,4,0,0,0,60,231,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,4,0,0,0,0,21,215,247,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,254,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,130,249,254,254,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,160,254,254,254,254,254,232,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,254,254,254,254,254,254,254,251,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,254,254,238,82,110,254,254,254,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,223,216,140,0,42,254,254,254,15,0,0,0,0,0,0,0,0,0,0,2,95,190,190,30,0,0,0,0,45,40,0,0,42,254,254,254,15,0,0,0,0,0,0,0,0,0,0,92,254,254,198,22,0,0,0,0,0,0,0,0,117,254,254,254,15,0,0,0,0,0,0,0,0,0,0,182,254,249,110,0,0,0,0,0,0,0,5,42,214,254,254,230,13,0,0,0,0,0,0,0,0,0,0,182,254,239,68,0,0,0,0,0,0,0,25,254,254,254,254,106,0,0,0,0,0,0,0,0,0,0,0,182,254,254,239,84,58,58,58,112,223,223,226,254,255,254,204,14,0,0,0,0,0,0,0,0,0,0,0,86,254,254,254,254,254,254,254,254,254,254,254,254,230,106,82,0,0,0,0,0,0,0,0,0,0,0,0,1,85,238,254,254,254,254,254,254,254,225,180,180,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,90,229,254,211,90,90,90,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,255,240,115,0,0,0,0,103,121,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,108,209,253,253,253,241,242,241,170,251,253,244,132,0,0,0,0,0,0,0,0,0,0,0,0,0,35,229,253,253,253,243,159,159,205,253,169,209,234,253,213,0,0,0,0,0,0,0,0,0,0,0,0,0,94,253,253,253,253,114,0,0,19,39,4,47,217,253,213,0,0,0,0,0,0,0,0,0,0,0,0,0,94,253,253,253,221,20,0,0,0,0,0,81,253,253,177,0,0,0,0,0,0,0,0,0,0,0,0,0,75,245,253,242,98,0,0,0,0,0,0,109,253,253,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,213,168,0,0,0,0,0,0,86,241,253,216,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,242,253,250,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,247,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,254,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,253,253,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,164,254,253,120,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,254,253,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,175,253,254,132,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,165,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,175,253,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,133,253,252,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,253,253,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,253,239,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,255,253,254,253,198,197,254,253,86,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,251,253,251,253,251,253,251,253,251,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,197,254,253,254,253,254,253,254,253,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,196,253,251,253,251,253,251,253,251,253,251,196,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,84,0,0,0,57,85,85,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,83,0,0,169,224,253,251,225,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,253,254,139,141,253,254,253,254,253,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,253,251,253,251,253,251,253,251,253,251,225,56,0,0,0,0,0,0,0,0,0,0,0,0,29,197,254,253,254,253,254,253,226,168,0,0,254,253,254,84,0,0,0,0,0,0,0,0,0,0,0,0,28,196,253,251,253,251,196,83,56,0,0,0,253,251,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,114,254,253,226,56,0,0,0,0,0,169,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,83,56,0,0,0,0,0,57,224,253,251,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,254,253,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,168,253,251,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,254,253,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,168,253,251,253,251,253,251,253,251,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,254,253,254,253,254,253,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,251,196,83,84,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,128,128,128,128,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,128,0,0,0,0,0,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,191,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,128,0,0,64,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,128,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,64,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,64,0,0,191,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,128,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,191,128,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,134,218,254,254,254,217,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,208,215,156,35,119,236,246,136,91,69,151,249,246,78,0,0,0,0,0,0,0,0,0,0,0,0,44,230,254,254,254,254,254,196,48,0,0,0,0,60,224,210,24,0,0,0,0,0,0,0,0,0,0,0,118,254,202,19,201,254,181,9,0,0,0,0,0,0,35,233,168,0,0,0,0,0,0,0,0,0,0,0,193,223,34,0,59,163,236,15,0,0,0,0,0,0,0,140,205,8,0,0,0,0,0,0,0,0,0,60,254,176,0,0,0,0,38,0,0,0,0,0,0,0,0,54,237,80,0,0,0,0,0,0,0,0,0,59,254,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,200,0,0,0,0,0,0,0,0,0,59,240,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,214,0,0,0,0,0,0,0,0,0,59,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,248,54,0,0,0,0,0,0,0,0,59,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,58,0,0,0,0,0,0,0,0,60,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,255,59,0,0,0,0,0,0,0,0,59,251,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,250,54,0,0,0,0,0,0,0,0,59,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,214,0,0,0,0,0,0,0,0,0,5,203,187,3,0,0,0,0,0,0,0,0,0,0,0,0,4,188,199,0,0,0,0,0,0,0,0,0,0,118,254,57,0,0,0,0,0,0,0,0,0,0,0,0,96,254,117,0,0,0,0,0,0,0,0,0,0,16,237,224,14,0,0,0,0,0,0,0,0,0,0,14,187,206,8,0,0,0,0,0,0,0,0,0,0,0,88,252,186,16,0,0,0,0,0,0,0,0,16,187,252,125,0,0,0,0,0,0,0,0,0,0,0,0,0,100,254,237,94,24,0,0,0,0,0,13,214,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,57,215,248,241,235,197,137,137,137,231,238,155,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,155,246,254,254,254,254,147,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,136,136,219,254,255,87,0,0,4,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,249,253,231,135,100,212,209,3,0,48,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,244,252,133,31,0,0,31,189,4,0,16,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,242,253,126,0,0,0,0,0,118,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,166,2,0,0,0,0,120,249,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,147,0,0,0,0,0,213,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,149,1,0,0,2,133,252,145,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,253,253,144,24,44,168,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,135,229,253,253,247,241,253,193,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,76,76,74,195,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,224,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,245,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,197,253,223,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,253,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,253,246,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,253,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,253,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,188,253,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,252,252,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,250,250,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,250,250,232,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,250,250,212,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,252,252,254,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,250,250,252,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,250,250,252,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,250,250,252,231,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,254,252,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,250,252,250,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,250,252,250,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,250,252,250,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,243,254,252,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,252,250,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,252,250,190,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,252,252,252,214,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,250,250,250,252,190,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,160,250,250,252,250,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,170,250,212,49,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,121,197,253,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,200,252,252,252,184,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,197,252,252,252,252,253,228,107,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,196,252,252,252,252,252,253,252,252,219,178,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,252,238,94,67,224,217,53,109,245,252,252,213,63,0,0,0,0,0,0,0,0,0,0,0,0,0,98,242,252,101,0,0,39,31,0,0,109,128,241,252,207,97,0,0,0,0,0,0,0,0,0,0,0,17,230,252,241,56,0,0,0,0,0,0,0,0,109,252,252,229,17,0,0,0,0,0,0,0,0,0,13,192,252,243,96,0,0,0,0,0,0,0,0,0,25,127,252,252,120,0,0,0,0,0,0,0,0,0,121,252,252,165,0,0,0,0,0,0,0,0,0,0,0,125,252,252,246,70,0,0,0,0,0,0,0,0,190,252,252,39,0,0,0,0,0,0,0,0,0,0,0,26,210,252,252,119,0,0,0,0,0,0,0,0,255,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,22,209,253,183,0,0,0,0,0,0,0,0,253,252,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,252,252,0,0,0,0,0,0,0,0,253,252,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,252,252,0,0,0,0,0,0,0,0,253,252,168,13,0,0,0,0,0,0,0,0,0,0,0,0,0,70,252,209,0,0,0,0,0,0,0,0,147,252,252,75,0,0,0,0,0,0,0,0,0,0,0,0,68,233,252,119,0,0,0,0,0,0,0,0,121,252,252,189,40,0,0,0,0,0,0,0,0,0,15,82,231,252,214,31,0,0,0,0,0,0,0,0,38,135,248,252,231,145,41,41,41,41,20,24,37,83,194,252,252,212,33,0,0,0,0,0,0,0,0,0,0,0,83,213,252,252,252,252,252,252,204,213,243,252,252,252,212,34,0,0,0,0,0,0,0,0,0,0,0,0,0,34,140,238,248,252,252,252,253,252,252,241,238,238,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,119,119,119,120,119,119,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,21,86,121,121,171,147,121,83,21,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,254,254,254,254,254,254,254,254,254,222,175,175,109,39,0,0,0,0,0,0,0,0,0,0,0,0,0,244,238,125,125,125,125,125,179,224,242,254,254,254,254,233,99,15,0,0,0,0,0,0,0,0,0,0,0,104,97,0,0,0,0,0,0,0,41,72,145,159,254,254,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,42,238,254,225,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,96,19,23,180,195,248,254,241,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,252,254,251,251,254,254,254,254,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,251,249,249,251,210,249,254,254,215,31,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,38,0,0,133,237,254,254,107,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,194,254,254,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,107,0,0,0,0,0,0,0,12,172,254,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,206,106,26,49,41,26,75,126,139,247,255,245,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,254,254,254,254,254,254,254,254,254,240,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,57,178,219,219,174,186,219,219,206,120,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,254,255,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,253,253,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,253,253,246,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,223,253,253,243,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,237,253,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,253,118,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,148,253,253,253,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,253,253,253,253,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,253,253,253,173,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,253,253,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,253,253,239,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,234,0,0,0,0,0,0,0,0,0,0,0,140,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,73,73,115,114,73,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,150,252,252,252,252,252,222,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,237,252,252,252,252,252,252,253,221,125,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,252,236,143,143,143,143,205,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,159,195,0,0,0,0,20,253,252,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,0,0,232,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,120,253,252,246,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,253,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,212,253,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,207,252,252,119,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,129,252,252,252,0,0,0,0,0,0,27,37,37,26,27,37,0,0,0,0,0,0,0,0,0,0,21,144,252,252,252,252,145,144,144,144,145,144,221,252,253,221,221,252,0,0,0,0,0,0,0,0,0,0,99,253,253,253,253,253,255,253,253,253,255,253,253,253,255,159,62,62,0,0,0,0,0,0,0,0,0,0,46,221,252,252,252,252,253,252,252,252,253,231,179,97,35,5,0,0,0,0,0,0,0,0,0,0,0,0,0,125,215,215,215,215,217,215,112,71,72,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,96,96,96,96,96,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,190,253,251,251,251,251,253,205,111,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,111,64,236,251,253,251,251,172,251,253,251,251,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,248,236,251,251,189,168,31,12,31,91,236,251,244,83,0,0,0,0,0,0,0,0,0,0,0,0,0,36,114,172,94,94,0,0,0,0,0,0,91,251,251,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,251,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,228,251,251,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,48,84,96,96,24,0,0,60,255,253,253,189,0,0,0,0,0,0,0,0,0,0,0,0,8,32,191,236,220,244,251,253,205,95,8,170,253,251,251,69,0,0,0,0,0,0,0,0,0,0,16,127,158,251,253,251,251,251,251,253,251,188,158,251,253,251,188,15,0,0,0,0,0,0,0,0,0,0,171,251,251,211,189,69,31,31,31,213,251,251,251,251,253,85,15,0,0,0,0,0,0,0,0,0,0,60,228,251,211,35,0,0,0,0,0,194,251,251,251,251,253,62,0,0,0,0,0,0,0,0,0,0,0,155,253,253,31,0,0,12,96,96,194,255,253,253,253,253,255,63,0,0,0,0,0,0,0,0,0,0,0,253,251,251,197,190,191,197,251,251,251,253,247,236,251,251,253,62,0,0,0,0,0,0,0,0,0,0,0,253,251,251,251,251,253,251,251,251,251,205,110,63,156,251,205,31,0,0,0,0,0,0,0,0,0,0,0,91,188,220,251,251,253,243,188,148,31,19,0,0,8,31,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,94,94,95,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,161,174,181,160,143,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,177,236,231,216,216,241,254,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,231,238,80,21,0,0,69,247,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,237,58,0,0,0,0,138,254,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,18,0,0,0,0,149,248,157,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,83,243,248,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,254,219,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,78,151,221,254,254,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,81,164,229,254,254,254,254,254,225,189,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,232,254,254,254,254,162,66,66,149,163,254,241,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,254,218,181,95,4,0,0,0,0,0,64,219,254,134,0,0,0,0,0,0,0,0,0,0,0,0,0,2,28,13,0,0,0,0,0,0,0,0,0,33,229,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,235,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,132,0,0,0,0,0,0,0,207,254,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,151,144,0,0,0,0,0,0,0,207,206,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,216,22,0,0,0,0,0,0,81,245,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,169,0,0,0,0,0,0,26,179,254,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,251,168,51,0,0,9,96,216,254,179,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,207,254,249,217,218,222,254,235,173,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,87,159,194,255,240,156,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,92,0,131,254,254,254,255,189,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,127,216,248,178,241,253,253,253,253,253,177,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,253,253,253,129,95,107,107,142,253,253,253,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,253,253,253,129,0,0,0,25,197,253,233,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,214,214,107,31,0,0,0,86,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,139,236,253,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,189,253,253,250,103,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,139,185,245,253,253,245,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,194,253,253,253,253,245,123,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,253,253,253,253,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,230,251,253,253,253,239,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,129,129,239,253,194,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,253,253,80,0,0,0,0,0,0,0,0,0,0,0,0,68,169,81,1,0,0,0,0,0,0,0,0,224,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,7,0,0,0,0,0,0,0,0,224,253,253,121,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,160,15,0,0,0,0,0,58,216,249,253,225,29,0,0,0,0,0,0,0,0,0,0,0,0,37,219,253,253,160,8,8,8,8,8,180,253,253,252,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,207,253,253,253,253,253,253,253,253,253,253,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,248,253,253,253,253,253,253,253,253,205,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,123,253,253,253,253,113,99,99,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,231,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,247,222,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,217,247,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,183,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,254,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,183,254,209,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,254,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,219,253,171,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,149,254,254,254,134,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,175,253,250,233,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,196,253,183,0,223,247,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,253,210,16,0,156,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,137,0,0,156,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,255,219,30,0,0,255,254,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,254,135,0,19,154,254,183,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,254,105,109,187,253,235,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,254,245,253,247,213,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,253,222,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,225,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,185,241,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,93,254,220,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,205,254,178,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,48,0,0,0,0,0,7,210,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,186,60,0,0,0,0,3,128,250,228,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,173,254,102,0,0,0,0,61,252,254,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,251,53,0,0,0,16,136,254,230,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,219,254,165,0,0,0,0,124,254,252,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,254,254,129,0,0,0,0,214,254,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,214,254,254,235,214,194,96,96,229,254,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,198,254,254,254,254,254,254,254,254,254,254,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,212,254,250,243,243,176,143,251,254,255,249,65,0,23,33,0,0,0,0,0,0,0,0,0,0,0,0,0,72,107,69,0,0,0,39,223,254,185,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,254,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,254,254,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,191,254,190,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,131,254,231,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,202,254,167,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,77,105,221,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,155,242,242,242,242,242,252,254,254,254,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,254,238,205,205,174,205,167,116,208,254,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,209,211,2,0,0,0,0,0,170,254,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,142,3,0,0,0,0,1,178,249,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,254,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,229,232,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,254,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,207,254,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,254,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,227,248,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,254,249,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,198,254,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,254,248,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,234,254,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,254,177,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,254,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,252,182,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,19,19,19,135,250,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,8,65,186,254,254,254,254,254,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,140,127,185,254,254,254,254,254,254,225,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,130,254,254,188,93,196,217,217,105,93,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,146,254,244,177,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,254,254,235,141,50,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,254,254,254,254,254,231,138,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,192,131,192,192,241,254,254,151,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,162,209,254,91,7,0,0,0,0,0,0,0,0,0,0,0,139,93,0,0,0,0,0,0,0,0,0,0,0,62,244,254,24,0,0,0,0,0,0,0,0,0,0,0,94,228,191,0,0,0,0,0,0,0,0,0,0,111,248,223,17,0,0,0,0,0,0,0,0,0,0,0,25,214,251,200,77,0,0,0,0,0,0,0,68,247,254,154,0,0,0,0,0,0,0,0,0,0,0,0,0,26,214,254,250,139,32,0,0,0,0,74,206,254,254,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,164,254,254,235,139,100,130,224,248,254,254,124,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,101,164,254,254,254,254,254,254,254,124,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,39,142,222,254,254,166,42,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,12,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,37,0,7,77,137,136,136,136,136,40,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,135,254,233,0,152,215,96,140,155,118,230,254,158,68,0,0,0,0,0,0,0,0,0,0,0,0,19,164,254,114,0,0,235,140,0,0,0,0,0,99,230,254,186,14,0,0,0,0,0,0,0,0,0,70,226,242,121,0,0,0,104,195,38,0,0,0,0,0,33,179,253,140,0,0,0,0,0,0,0,0,41,241,198,43,0,0,0,0,0,0,0,0,0,0,0,0,0,24,209,223,0,0,0,0,0,0,0,0,164,250,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,0,0,0,0,0,0,0,0,254,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,215,0,0,0,0,0,0,0,0,255,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,127,246,133,0,0,0,0,0,0,0,0,254,122,0,0,0,0,0,0,0,0,0,0,0,0,0,5,150,247,91,9,0,0,0,0,0,0,0,0,254,165,0,0,0,0,0,0,0,0,0,0,0,13,79,194,216,84,0,0,0,0,0,0,0,0,0,0,111,251,87,0,0,0,0,0,0,16,25,40,107,186,213,117,25,0,0,0,0,0,0,0,0,0,0,0,14,185,235,142,23,0,0,0,91,157,231,207,126,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,195,255,254,254,244,157,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,39,39,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,232,231,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,217,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,252,220,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,221,253,241,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,208,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,73,207,252,210,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,252,252,252,108,0,0,0,0,0,73,181,181,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,252,252,231,46,0,0,0,0,63,237,252,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,253,222,125,0,0,0,0,63,171,253,253,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,161,252,252,179,0,0,0,21,176,237,253,231,231,252,207,20,0,0,0,0,0,0,0,0,0,0,0,0,181,252,252,76,0,0,0,176,252,252,175,61,191,252,125,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,252,35,0,0,0,217,252,252,207,175,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,253,211,94,0,171,253,253,253,255,253,237,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,221,252,252,247,217,253,252,252,252,253,231,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,215,247,252,252,253,252,252,231,217,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,128,252,108,232,231,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,79,104,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,252,224,119,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,168,205,243,210,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,175,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,179,255,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,252,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,197,240,252,244,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,252,252,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,154,253,254,253,194,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,252,222,121,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,234,252,214,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,227,103,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,253,214,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,209,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,110,252,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,166,177,3,0,0,0,0,51,0,0,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,216,28,4,10,48,241,41,60,10,117,192,84,51,38,13,0,0,0,0,0,0,0,0,0,0,0,0,82,240,215,79,122,97,252,159,178,197,215,166,196,206,243,194,44,0,0,0,0,0,0,0,0,0,0,0,0,159,252,253,252,177,252,223,177,168,168,216,214,214,240,253,240,81,0,0,0,0,0,0,0,0,0,0,0,10,28,153,177,139,139,28,9,0,0,16,15,28,78,153,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,113,25,0,0,0,0,0,31,123,174,6,0,0,0,0,0,0,0,0,0,0,0,0,13,208,221,252,252,252,218,121,148,60,60,130,221,252,252,49,0,0,0,0,0,0,0,0,0,0,0,0,112,252,252,252,252,252,252,252,253,252,252,252,252,252,252,66,0,0,0,0,0,0,0,0,0,0,0,29,205,252,252,237,132,132,153,252,253,252,252,252,252,252,188,8,0,0,0,0,0,0,0,0,0,0,0,60,252,252,252,178,0,0,6,29,29,29,42,252,252,181,14,0,0,0,0,0,0,0,0,0,0,0,0,53,241,252,199,22,0,0,0,0,0,8,131,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,118,83,0,0,0,0,0,0,60,252,252,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,216,252,252,181,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,252,252,230,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,192,255,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,252,253,237,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,197,252,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,252,252,253,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,225,252,252,117,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,217,252,252,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,252,252,228,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,248,252,252,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,252,252,236,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,252,252,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,113,167,228,197,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,225,251,153,97,249,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,146,244,170,41,0,0,142,228,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,246,152,7,0,0,0,71,254,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,249,142,0,0,0,0,0,71,254,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,232,38,0,0,0,0,0,37,246,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,248,210,0,0,0,0,0,0,0,237,225,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,243,243,70,0,0,0,0,0,0,170,254,228,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,254,196,5,0,0,0,0,0,182,254,254,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,242,254,209,21,0,0,0,25,243,254,254,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,254,254,242,77,0,0,98,254,255,254,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,94,239,254,253,215,158,217,254,199,254,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,171,215,254,254,237,90,91,254,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,26,114,22,0,24,235,238,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,254,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,254,229,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,254,244,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,224,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,212,253,255,211,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,73,73,125,252,252,253,252,247,217,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,252,252,252,253,252,252,252,222,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,210,128,168,108,232,252,252,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,179,0,0,0,0,37,252,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,252,253,200,21,0,0,0,37,252,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,236,253,252,92,0,0,11,68,252,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,252,236,62,63,175,252,252,191,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,253,253,255,253,237,144,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,253,189,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,120,212,252,252,252,191,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,221,252,253,252,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,253,145,73,253,253,255,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,232,252,200,179,20,31,211,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,221,252,241,61,0,0,73,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,252,97,0,0,0,73,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,253,35,0,0,0,73,253,253,208,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,252,222,134,217,135,227,252,252,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,236,252,252,252,252,253,252,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,169,252,252,252,253,210,108,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,121,121,121,64,0,0,0,96,121,211,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,121,240,242,252,252,252,247,240,121,219,249,252,235,131,6,0,0,0,0,0,0,0,0,0,0,0,0,122,247,252,252,192,158,89,253,252,252,222,158,60,22,0,0,0,0,0,0,0,0,0,0,0,0,0,80,246,252,136,39,15,0,0,140,218,123,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,252,252,198,0,0,0,0,25,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,195,252,238,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,195,252,239,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,196,252,242,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,199,252,246,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,203,252,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,253,253,255,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,96,252,253,247,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,97,204,252,180,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,248,252,197,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,85,35,0,0,0,0,0,107,245,252,238,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,242,185,0,0,0,0,0,0,0,109,244,252,175,17,0,0,0,0,0,0,0,0,0,0,0,0,74,244,252,160,145,41,41,41,19,0,0,0,122,252,252,170,0,0,0,0,0,0,0,0,0,0,0,0,39,222,252,252,252,252,252,252,203,161,160,160,189,252,252,212,0,0,0,0,0,0,0,0,0,0,0,0,0,89,238,246,238,238,247,252,252,253,252,252,252,252,249,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,0,76,119,119,253,252,252,252,146,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,39,125,249,230,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,114,219,254,254,254,254,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,188,254,245,140,55,51,253,242,14,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,254,184,53,0,0,0,168,254,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,237,239,40,0,0,0,0,168,254,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,109,0,0,0,0,20,246,254,232,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,97,0,0,0,0,90,254,254,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,246,218,113,8,56,173,226,254,254,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,238,251,235,244,152,193,254,254,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,138,72,0,130,254,192,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,254,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,247,224,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,230,252,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,254,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,239,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,186,254,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,254,254,159,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,254,254,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,73,115,160,115,115,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,126,244,254,254,254,254,254,193,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,130,229,254,254,239,173,166,134,237,254,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,206,254,248,209,130,22,0,0,0,201,254,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,163,39,0,0,0,0,0,0,134,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,228,21,0,0,0,0,0,0,0,93,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,170,14,0,0,0,0,0,0,0,146,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,254,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,116,243,254,219,201,189,93,93,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,97,247,254,254,254,254,254,254,254,254,246,239,146,0,0,0,0,0,0,0,0,0,0,0,0,0,3,144,254,251,233,254,168,87,87,87,115,195,195,119,87,0,0,0,0,0,0,0,0,0,0,0,0,0,53,254,221,61,198,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,254,167,28,254,205,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,254,227,213,255,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,254,254,248,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,72,114,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,255,187,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,191,253,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,253,253,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,169,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,189,253,249,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,253,253,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,253,253,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,231,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,241,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,228,253,252,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,253,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,249,253,193,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,160,253,253,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,253,253,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,253,186,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,253,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,199,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,254,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,254,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,234,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,230,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,255,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,255,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,251,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,245,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,254,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,254,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,225,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,234,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,238,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,254,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,255,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,206,239,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,254,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,254,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,88,3,0,0,0,0,185,254,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,254,67,0,0,0,22,243,235,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,254,143,0,0,0,133,254,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,243,254,41,0,0,9,205,254,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,254,230,25,0,0,83,254,242,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,254,253,163,146,146,208,254,137,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,250,254,254,254,254,254,254,254,254,247,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,246,174,187,223,180,248,254,254,251,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,73,52,0,0,0,38,240,254,117,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,254,251,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,160,254,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,254,254,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,254,214,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,8,0,0,0,0,0,0,0,26,104,255,200,8,0,0,0,0,0,0,0,0,0,0,0,0,0,32,244,183,0,0,0,0,0,0,19,143,164,253,153,0,0,0,0,0,0,0,0,0,0,0,0,0,86,244,253,149,0,0,0,0,0,0,30,206,183,253,153,0,0,0,0,0,0,0,0,0,0,0,0,54,242,253,216,29,0,0,0,0,0,0,119,241,236,253,120,0,0,0,0,0,0,0,0,0,0,0,61,190,253,253,129,0,0,0,0,0,0,0,148,253,253,185,7,0,0,0,0,0,0,0,0,0,0,15,206,253,253,110,15,0,0,0,0,0,0,55,192,253,253,121,0,0,0,0,0,0,0,0,0,0,9,198,253,253,111,2,1,18,125,125,125,168,243,248,253,253,219,27,0,0,0,0,0,0,0,0,0,0,85,253,253,253,66,24,128,253,253,248,230,230,251,253,253,249,64,0,0,0,0,0,0,0,0,0,0,0,117,253,253,253,253,253,210,230,212,108,0,0,231,253,253,186,0,0,0,0,0,0,0,0,0,0,0,0,6,156,253,237,194,144,76,34,0,0,0,0,231,253,233,27,0,0,0,0,0,0,0,0,0,0,0,0,0,9,59,42,0,0,0,0,0,0,0,0,231,253,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,250,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,250,253,190,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,196,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,253,187,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,232,253,253,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,253,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,125,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,135,154,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,22,22,110,128,127,135,232,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,232,252,252,252,253,252,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,252,252,252,252,253,173,147,77,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,236,254,253,206,106,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,232,252,239,89,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,252,252,232,127,127,57,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,252,252,253,252,252,252,182,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,147,147,147,147,200,252,252,194,0,0,0,0,0,0,0,0,0,0,0,0,87,113,4,0,0,0,0,0,0,0,0,0,0,71,194,255,95,4,0,0,0,0,0,0,0,0,0,0,192,217,48,0,0,0,0,0,0,0,0,0,0,0,45,253,217,12,0,0,0,0,0,0,0,0,0,0,183,252,233,42,0,0,0,0,0,0,0,0,0,6,198,253,166,2,0,0,0,0,0,0,0,0,0,0,14,120,247,196,126,0,0,0,0,0,0,0,0,134,252,225,21,0,0,0,0,0,0,0,0,0,0,0,0,0,56,252,252,212,131,9,0,0,0,0,98,204,252,185,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,229,254,253,245,148,148,148,183,253,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,125,231,252,252,252,253,252,210,98,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,29,126,126,127,126,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,76,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,240,252,215,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,209,252,210,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,193,252,168,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,253,252,187,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,240,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,248,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,228,252,232,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,138,253,243,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,252,252,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,228,252,252,168,185,184,184,184,184,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,252,252,253,252,252,252,252,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,252,221,43,22,23,43,54,107,252,251,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,249,63,0,0,0,0,0,93,253,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,206,0,0,0,0,0,0,114,252,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,246,253,123,0,0,0,0,0,83,240,252,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,245,58,0,0,0,0,60,209,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,230,0,0,0,53,127,244,252,116,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,205,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,206,29,0,0,0,0,0,0,182,253,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,36,0,0,0,0,0,0,182,253,180,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,36,0,0,0,0,0,45,247,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,222,253,36,0,0,0,0,0,164,253,184,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,254,150,133,76,6,0,43,254,254,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,188,253,253,253,253,253,198,76,167,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,136,253,253,224,217,217,234,254,253,253,253,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,204,16,0,0,41,150,253,253,253,253,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,239,80,0,0,0,0,42,253,253,213,106,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,140,80,0,0,0,0,0,168,253,225,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,244,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,254,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,220,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,221,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,221,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,191,254,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,255,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,254,195,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,202,254,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,254,254,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,248,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,172,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,254,254,254,255,169,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,17,70,230,253,253,253,253,253,199,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,240,253,253,253,253,253,253,253,253,253,167,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,253,62,162,56,56,56,194,253,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,141,129,4,0,0,0,0,42,253,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,4,0,0,0,0,0,0,42,253,253,253,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,253,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,1,0,0,1,84,238,253,251,148,5,0,0,0,0,0,0,0,0,0,0,0,0,13,99,99,99,99,194,103,96,0,25,253,253,253,195,0,0,0,0,0,0,0,0,0,0,0,0,0,11,161,253,253,253,237,253,253,251,189,195,253,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,83,173,253,253,230,138,49,138,250,253,253,253,253,253,253,32,0,0,0,0,0,0,0,0,0,0,0,74,239,253,94,48,39,0,0,0,60,201,253,253,253,253,253,32,0,0,0,0,0,0,0,0,0,0,0,91,253,197,27,0,0,0,0,0,167,253,253,253,253,253,253,117,0,0,0,0,0,0,0,0,0,0,0,91,253,170,58,30,0,0,53,159,252,253,253,210,221,253,253,246,93,0,0,0,0,0,0,0,0,0,0,91,253,253,253,202,148,148,243,253,253,248,106,27,48,225,253,253,191,9,0,0,0,0,0,0,0,0,0,91,253,253,253,253,253,253,253,253,181,173,0,0,0,157,253,253,210,11,0,0,0,0,0,0,0,0,0,32,206,253,253,253,253,253,210,89,3,0,0,0,0,15,174,215,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,155,179,210,155,155,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,254,254,254,254,241,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,254,254,225,207,222,158,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,202,19,10,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,195,254,204,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,254,254,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,245,254,253,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,249,254,241,146,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,254,254,225,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,5,0,0,0,0,0,18,79,230,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,139,247,70,0,0,0,0,0,0,75,245,254,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,254,252,63,0,0,0,0,0,2,178,254,254,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,254,234,22,0,0,0,0,0,118,254,254,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,254,254,167,41,36,36,38,135,236,254,254,198,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,254,254,254,254,254,254,254,254,254,254,200,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,110,205,237,254,254,254,254,254,252,142,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,126,254,254,253,92,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,255,255,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,128,128,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,191,0,0,0,0,64,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,64,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,128,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,0,0,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,128,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,128,128,191,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,255,255,255,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,105,255,142,117,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,151,253,203,198,235,150,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,230,253,149,6,0,170,253,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,238,254,152,6,0,13,207,253,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,254,242,102,0,0,0,105,254,217,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,226,253,65,0,0,0,51,254,253,253,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,253,225,19,0,0,105,247,254,253,253,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,168,0,64,138,247,203,153,253,215,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,195,254,254,240,201,76,0,205,254,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,84,84,38,0,0,26,254,215,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,254,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,250,179,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,230,254,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,235,253,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,177,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,248,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,110,233,253,253,255,253,253,253,255,211,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,237,253,252,231,66,98,200,252,252,253,252,206,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,252,237,215,132,92,0,21,71,71,217,247,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,108,62,0,0,0,0,0,0,0,1,217,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,155,253,252,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,78,232,252,253,200,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,252,252,252,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,255,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,252,252,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,215,232,252,252,252,120,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,108,211,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,255,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,35,0,0,0,0,0,0,0,0,0,0,37,26,0,0,0,0,0,0,0,0,0,0,0,11,191,252,253,138,0,0,0,0,0,0,0,0,0,0,253,179,0,0,0,0,0,0,0,0,0,0,0,155,252,252,253,97,0,0,0,0,0,0,0,0,0,0,255,253,133,0,0,0,0,0,0,0,16,109,171,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,253,252,247,217,217,93,73,73,135,217,222,252,253,252,252,210,0,0,0,0,0,0,0,0,0,0,0,0,133,226,252,252,252,252,252,252,253,252,252,252,237,215,112,31,0,0,0,0,0,0,0,0,0,0,0,0,0,31,108,190,252,252,252,252,253,252,231,108,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,119,172,254,254,255,254,232,118,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,246,253,248,183,183,183,183,248,253,251,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,128,250,190,65,16,0,0,0,0,16,66,233,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,213,5,0,0,0,0,0,0,0,0,68,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,224,247,164,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,212,253,209,87,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,136,229,253,251,201,174,30,27,3,0,0,21,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,97,148,208,241,253,253,198,117,118,240,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,70,121,156,156,236,253,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,253,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,227,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,247,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,253,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,223,110,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,254,254,58,60,59,59,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,233,253,253,148,254,253,253,232,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,253,253,253,117,255,253,253,253,223,176,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,116,246,253,180,18,4,18,109,241,253,253,253,236,28,0,0,0,0,0,0,0,0,0,0,0,0,0,235,253,253,245,107,0,0,0,0,109,170,253,253,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,235,253,253,233,0,0,0,0,0,0,15,156,253,253,223,72,0,0,0,0,0,0,0,0,0,0,10,156,250,253,253,67,0,0,0,0,0,0,0,99,253,253,253,127,5,0,0,0,0,0,0,0,0,0,118,253,253,253,204,26,0,0,0,0,0,0,0,68,223,253,253,253,57,0,0,0,0,0,0,0,0,32,191,253,253,253,97,0,0,0,0,0,0,0,0,0,156,253,253,253,57,0,0,0,0,0,0,0,0,59,253,253,253,253,97,0,0,0,0,0,0,0,0,0,36,224,253,253,57,0,0,0,0,0,0,0,0,60,254,255,254,156,0,0,0,0,0,0,0,0,0,0,37,226,254,254,58,0,0,0,0,0,0,0,0,59,253,253,253,154,0,0,0,0,0,0,0,0,0,0,156,253,253,253,57,0,0,0,0,0,0,0,0,59,253,253,253,154,0,0,0,0,0,0,0,0,0,0,156,253,253,253,57,0,0,0,0,0,0,0,0,59,253,253,253,246,90,0,0,0,0,0,0,0,0,16,171,253,253,231,49,0,0,0,0,0,0,0,0,59,253,253,253,253,156,91,0,0,0,0,0,0,0,99,253,253,222,71,0,0,0,0,0,0,0,0,0,59,253,253,253,253,253,245,109,0,0,0,0,0,145,194,253,253,174,0,0,0,0,0,0,0,0,0,0,9,38,174,251,253,253,253,241,215,215,217,215,215,250,253,253,221,26,0,0,0,0,0,0,0,0,0,0,0,0,0,235,253,253,253,253,253,253,254,253,253,253,253,204,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,116,200,253,253,253,253,254,253,253,253,199,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,57,118,253,253,58,57,57,57,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,255,255,163,7,7,7,95,130,130,130,130,130,130,19,0,0,0,0,0,0,0,0,0,0,0,0,0,12,248,253,253,253,253,253,253,253,253,253,253,253,253,203,12,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,251,235,152,196,235,235,140,111,150,235,235,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,253,225,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,189,253,239,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,239,253,192,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,237,253,236,167,167,167,167,167,126,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,236,253,253,253,253,253,253,253,224,126,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,236,186,74,74,74,114,197,245,253,135,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,20,0,0,0,0,0,104,246,253,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,253,226,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,253,253,12,0,0,0,0,0,0,0,0,0,0,44,81,34,0,0,0,0,0,0,0,0,0,0,0,20,234,253,112,0,0,0,0,0,0,0,0,0,0,136,253,147,0,0,0,0,0,0,0,0,0,0,0,0,230,253,135,0,0,0,0,0,0,0,0,0,0,92,253,250,191,0,0,0,0,0,0,0,0,0,0,37,238,253,29,0,0,0,0,0,0,0,0,0,0,2,108,253,222,0,0,0,0,0,0,0,0,0,0,209,253,209,7,0,0,0,0,0,0,0,0,0,0,0,2,159,250,135,0,0,0,0,0,0,0,37,212,250,209,22,0,0,0,0,0,0,0,0,0,0,0,0,0,11,108,251,154,36,0,0,0,0,130,181,253,253,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,135,213,246,242,181,242,242,251,253,152,26,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,91,156,253,253,253,153,87,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,93,164,254,255,254,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,163,253,253,243,231,253,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,207,253,245,200,85,31,158,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,247,98,0,0,0,113,250,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,188,0,0,0,0,21,245,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,253,112,0,0,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,253,225,3,0,0,0,3,243,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,252,253,183,60,24,124,191,252,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,235,253,253,253,253,253,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,76,159,194,244,253,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,244,253,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,244,253,211,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,124,253,199,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,253,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,239,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,203,254,254,220,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,243,253,253,254,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,125,237,253,253,253,254,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,254,253,253,253,103,69,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,254,254,254,254,239,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,253,254,210,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,253,254,203,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,254,253,253,253,254,228,238,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,254,254,254,254,254,254,152,70,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,254,253,253,253,254,253,253,253,254,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,240,254,253,253,253,254,253,253,253,254,244,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,254,253,253,253,254,253,253,253,254,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,235,254,254,254,254,254,254,254,254,254,254,254,186,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,254,253,253,253,254,253,219,253,254,253,253,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,253,253,253,254,253,220,253,254,253,253,253,216,53,0,0,0,0,0,0,0,0,0,0,0,0,0,25,254,253,253,253,254,253,253,253,254,253,253,253,254,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,254,254,254,254,254,254,254,254,254,254,254,255,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,216,253,253,254,253,253,253,254,253,253,253,190,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,96,230,230,251,253,253,254,253,242,196,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,253,195,143,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,40,137,196,196,137,136,136,174,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,253,253,253,253,254,253,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,255,254,213,180,98,76,76,0,91,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,50,244,254,145,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,245,253,254,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,240,253,253,254,251,166,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,223,253,177,155,238,253,169,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,0,0,0,0,0,0,83,183,238,96,0,0,0,0,0,0,0,0,0,0,0,0,0,35,160,68,0,0,0,0,0,0,0,0,0,48,245,193,0,0,0,0,0,0,0,0,0,0,0,0,0,186,173,0,0,0,0,0,0,0,0,0,0,79,245,162,0,0,0,0,0,0,0,0,0,0,0,0,0,216,161,57,0,0,0,0,0,0,0,0,49,247,247,49,0,0,0,0,0,0,0,0,0,0,0,0,0,216,253,235,180,98,0,0,0,0,38,121,244,253,191,23,0,0,0,0,0,0,0,0,0,0,0,0,0,23,106,236,254,254,255,254,254,254,254,255,226,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,91,135,158,233,233,233,233,151,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,255,203,146,110,38,38,38,94,146,146,146,119,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,253,253,253,253,253,253,253,253,253,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,248,248,249,249,248,248,248,192,139,139,200,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,24,0,0,0,0,0,0,154,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,250,241,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,250,252,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,235,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,203,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,242,253,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,205,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,236,137,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,194,253,212,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,203,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,203,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,255,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,78,0,0,0,0,0,84,242,222,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,242,42,0,0,0,11,211,252,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,232,252,84,0,0,0,48,252,252,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,252,235,14,0,0,0,127,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,255,253,170,0,0,0,0,189,253,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,199,253,252,125,85,50,0,64,247,252,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,158,252,253,252,252,252,244,233,239,252,252,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,231,226,128,84,84,84,172,253,252,252,183,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,24,0,0,0,0,0,165,252,235,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,210,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,236,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,222,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,246,208,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,240,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,252,253,154,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,178,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,204,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,252,252,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,209,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,252,252,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,242,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,236,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,118,118,173,255,221,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,234,246,253,253,253,253,253,142,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,253,253,251,214,181,243,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,243,183,60,30,3,220,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,66,0,0,0,33,225,253,206,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,248,253,250,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,190,253,210,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,251,253,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,230,253,253,160,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,204,253,253,253,234,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,94,205,205,228,253,231,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,252,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,125,247,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,104,183,253,253,54,0,0,0,0,0,0,0,0,0,0,0,0,0,70,83,27,0,0,0,0,0,16,176,253,253,253,62,8,0,0,0,0,0,0,0,0,0,0,0,0,24,223,253,217,118,31,61,63,63,173,253,251,191,135,8,0,0,0,0,0,0,0,0,0,0,0,0,0,29,202,253,253,253,215,252,253,253,253,253,250,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,199,232,245,253,253,253,253,253,150,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,116,250,204,153,152,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,255,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,251,254,45,5,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,212,18,173,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,202,254,52,0,210,243,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,201,254,107,0,210,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,254,50,13,222,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,203,254,135,2,45,254,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,254,239,46,0,77,254,250,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,226,254,96,0,0,56,254,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,145,254,250,46,18,18,142,254,212,108,108,108,108,108,21,0,0,0,0,0,0,0,0,0,0,0,0,83,254,254,251,183,253,254,254,254,254,254,252,249,249,158,14,0,0,0,0,0,0,0,0,0,0,0,0,111,254,254,254,254,231,192,254,254,153,85,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,9,48,32,9,6,18,232,254,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,206,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,254,254,157,34,34,218,255,206,34,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,238,252,252,252,252,252,252,252,252,252,162,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,220,252,252,252,209,153,223,252,252,252,252,252,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,252,252,252,141,0,85,230,252,252,252,252,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,252,252,252,141,0,0,73,102,252,252,252,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,252,252,191,30,0,0,0,5,97,252,252,220,51,0,0,0,0,0,0,0,0,0,0,0,0,123,245,252,252,202,14,0,0,0,0,0,56,252,252,252,65,0,0,0,0,0,0,0,0,0,0,0,18,154,252,252,241,0,0,0,0,0,0,0,56,252,252,252,65,0,0,0,0,0,0,0,0,0,0,21,146,252,252,252,241,0,0,0,0,0,0,0,56,252,252,252,65,0,0,0,0,0,0,0,0,0,0,67,252,252,252,252,241,0,0,0,0,0,0,0,56,252,252,252,65,0,0,0,0,0,0,0,0,0,0,67,252,252,252,252,116,0,0,0,0,0,0,0,56,252,252,252,65,0,0,0,0,0,0,0,0,0,0,67,252,252,252,252,20,0,0,0,0,0,0,0,56,252,252,252,65,0,0,0,0,0,0,0,0,0,0,67,252,252,252,87,4,0,0,0,0,0,0,0,56,252,252,124,11,0,0,0,0,0,0,0,0,0,0,67,252,252,252,54,0,0,0,0,0,0,19,236,245,252,252,98,0,0,0,0,0,0,0,0,0,0,0,67,252,252,252,97,5,0,0,0,0,39,219,252,252,252,252,98,0,0,0,0,0,0,0,0,0,0,0,67,252,252,252,252,102,89,89,89,89,203,252,252,252,252,209,64,0,0,0,0,0,0,0,0,0,0,0,67,252,252,252,252,252,252,252,252,252,252,252,252,226,130,68,0,0,0,0,0,0,0,0,0,0,0,0,67,252,252,252,252,252,252,252,252,252,252,252,239,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,65,163,252,252,252,252,252,252,252,252,96,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,176,252,252,252,252,155,32,32,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,118,25,0,0,0,0,0,0,0,0,0,0,0,109,234,193,76,0,0,0,0,0,0,0,0,0,0,104,253,204,29,0,0,0,0,0,0,0,0,0,0,118,253,253,244,110,0,0,0,0,0,0,0,0,0,104,253,253,190,0,0,0,0,0,0,0,0,0,0,118,253,253,253,219,0,0,0,0,0,0,0,0,0,104,253,253,243,73,0,0,0,0,0,0,0,0,0,118,253,253,253,219,0,0,0,0,0,0,0,0,0,104,253,253,253,96,0,0,0,0,0,0,0,0,0,125,253,253,253,211,0,0,0,0,0,0,0,0,0,104,253,253,253,96,0,0,0,0,0,0,0,0,0,254,253,253,253,82,0,0,0,0,0,0,0,0,65,180,253,253,253,96,0,0,0,0,0,0,0,0,0,254,253,253,229,46,0,0,0,0,0,21,126,248,250,253,253,253,253,96,0,0,0,0,0,0,0,0,0,206,253,253,247,227,145,90,90,213,227,232,253,253,253,253,253,253,253,96,0,0,0,0,0,0,0,0,0,118,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,96,0,0,0,0,0,0,0,0,0,95,249,253,253,253,253,253,253,253,253,253,248,205,137,68,229,253,253,96,0,0,0,0,0,0,0,0,0,0,133,249,253,253,253,253,253,253,246,226,127,0,0,0,220,253,253,96,0,0,0,0,0,0,0,0,0,0,0,92,138,246,239,109,109,109,80,0,0,0,0,0,220,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,211,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,253,207,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,118,232,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,137,137,137,253,242,60,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,225,254,254,254,254,254,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,254,213,145,201,195,83,195,233,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,177,15,0,0,0,0,166,224,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,14,0,0,0,0,0,166,254,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,108,40,0,0,0,0,6,122,245,196,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,95,0,0,0,3,128,254,251,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,164,8,0,65,192,254,241,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,184,254,133,160,240,254,227,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,254,255,254,255,147,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,95,254,254,254,90,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,154,254,254,255,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,252,141,87,221,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,206,254,182,0,0,178,254,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,148,254,178,5,0,0,178,254,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,238,24,0,0,28,228,254,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,165,0,0,0,128,254,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,236,62,44,202,235,254,154,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,199,254,240,237,254,254,203,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,233,254,254,254,179,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,247,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,242,245,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,253,253,104,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,253,253,254,221,120,120,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,75,36,11,56,222,254,253,253,253,245,207,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,245,249,105,0,0,44,224,230,253,253,253,253,214,10,0,0,0,0,0,0,0,0,0,0,0,0,8,191,253,143,0,0,0,0,0,29,119,119,158,253,253,94,0,0,0,0,0,0,0,0,0,0,0,0,15,253,226,48,0,0,0,0,0,0,0,0,4,183,253,248,56,0,0,0,0,0,0,0,0,0,0,0,42,253,178,0,0,0,0,0,0,0,0,0,0,179,253,184,14,0,0,0,0,0,0,0,0,0,0,0,164,253,178,0,0,0,0,0,0,0,0,0,0,179,253,163,0,0,0,0,0,0,0,0,0,0,0,61,254,254,179,0,0,0,0,0,0,0,0,0,76,254,254,164,0,0,0,0,0,0,0,0,0,0,0,60,253,253,178,0,0,0,0,0,0,0,0,29,206,253,253,40,0,0,0,0,0,0,0,0,0,0,0,60,253,253,178,0,0,0,0,0,0,0,0,120,253,253,245,13,0,0,0,0,0,0,0,0,0,0,0,60,253,253,178,0,0,0,0,0,0,0,0,120,253,239,63,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,178,0,0,0,0,0,0,0,14,238,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,18,190,253,231,70,0,0,0,0,0,43,184,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,239,134,8,0,0,56,163,253,253,213,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,253,253,253,253,240,239,239,247,253,253,210,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,59,204,253,253,253,253,253,254,253,250,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,122,253,253,253,253,255,217,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,254,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,204,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,236,253,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,243,230,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,244,228,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,131,23,0,0,0,0,0,25,199,249,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,234,42,0,0,0,0,0,100,249,243,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,202,253,109,0,0,0,0,14,176,253,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,240,46,0,0,0,0,57,253,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,209,249,119,0,0,0,0,0,181,253,166,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,216,254,243,0,0,0,0,0,57,250,255,103,0,0,0,0,0,0,0,0,0,0,0,0,0,18,67,213,253,253,250,177,96,67,59,0,177,253,215,17,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,253,253,253,253,253,253,253,249,210,246,253,220,22,0,0,0,0,0,0,0,0,0,0,0,0,0,110,188,112,10,49,121,102,93,121,187,253,253,232,97,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,182,230,122,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,118,254,211,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,239,229,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,217,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,125,168,254,254,254,254,160,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,250,253,253,253,253,253,253,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,252,253,253,253,253,253,253,253,253,251,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,246,253,253,218,149,149,176,253,253,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,155,42,17,0,0,116,253,253,235,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,246,253,253,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,215,246,253,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,253,253,253,253,199,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,253,253,253,253,219,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,253,253,253,253,253,253,253,246,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,65,65,65,95,194,235,253,253,247,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,166,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,190,253,247,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,175,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,27,18,0,0,0,0,0,5,128,253,253,251,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,219,150,150,50,20,47,169,253,253,253,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,253,253,253,253,253,253,253,253,253,253,232,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,117,227,249,253,253,253,253,253,252,162,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,159,253,253,253,230,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,173,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,72,190,253,207,62,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,236,251,251,129,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,228,251,251,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,253,253,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,214,251,172,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,253,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,217,253,231,62,4,0,0,0,0,16,162,64,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,217,253,132,47,0,0,0,0,80,181,251,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,253,195,24,0,0,0,155,253,253,253,253,255,233,48,0,0,0,0,0,0,0,0,0,0,0,0,16,225,251,253,62,0,0,20,253,251,251,243,220,233,251,126,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,205,31,0,112,205,253,235,126,94,0,96,251,126,0,0,0,0,0,0,0,0,0,0,0,28,236,251,251,19,68,221,248,251,229,66,0,16,64,234,223,15,0,0,0,0,0,0,0,0,0,0,0,12,173,251,251,100,190,251,251,251,218,39,0,64,251,253,240,79,0,0,0,0,0,0,0,0,0,0,0,20,206,253,253,155,253,253,253,253,0,191,253,253,253,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,253,251,251,251,251,191,236,251,251,231,161,16,0,0,0,0,0,0,0,0,0,0,0,0,0,63,156,251,253,251,251,251,251,253,251,251,219,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,188,253,251,251,251,211,189,168,31,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,114,251,251,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,238,217,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,254,254,254,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,224,254,145,254,240,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,160,253,254,254,187,254,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,254,184,207,254,254,248,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,252,206,17,47,254,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,254,43,0,165,254,159,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,237,23,42,235,218,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,254,105,212,247,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,249,254,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,163,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,254,243,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,249,177,49,235,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,213,249,50,0,212,247,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,254,158,0,0,212,254,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,254,30,0,0,212,254,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,235,213,8,0,37,243,241,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,240,200,4,5,193,254,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,254,212,218,254,195,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,216,254,254,166,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,84,6,167,253,253,237,234,234,159,234,234,115,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,248,215,253,253,185,177,233,253,253,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,253,253,229,21,0,45,61,61,155,253,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,253,253,50,0,0,0,0,5,212,253,242,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,241,245,168,3,0,0,0,17,154,253,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,50,0,0,0,0,0,99,253,253,200,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,203,253,199,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,241,253,210,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,233,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,237,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,168,253,252,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,253,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,250,253,188,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,237,253,175,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,223,253,235,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,223,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,182,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,255,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,230,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,241,253,253,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,190,253,253,180,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,253,253,251,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,219,253,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,253,200,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,234,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,207,253,242,114,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,169,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,253,252,90,8,124,130,130,130,57,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,253,253,165,39,176,253,253,253,253,253,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,249,253,253,42,162,253,253,230,193,253,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,113,1,162,253,253,97,115,253,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,206,253,253,59,0,134,253,253,219,253,253,237,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,253,253,253,59,0,76,231,253,253,253,242,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,253,253,250,249,252,253,253,253,241,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,178,253,253,253,253,253,253,247,157,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,196,253,253,253,230,60,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,164,253,255,253,118,59,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,251,251,253,251,251,251,199,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,198,251,251,253,251,251,251,251,204,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,117,251,251,243,212,239,251,251,251,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,251,251,251,120,0,175,251,251,251,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,237,251,251,251,0,0,67,240,251,251,243,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,163,251,251,240,81,0,0,0,68,251,251,251,179,9,0,0,0,0,0,0,0,0,0,0,0,0,13,145,251,251,226,80,0,0,0,0,39,251,251,251,251,115,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,173,0,0,0,0,0,18,167,251,251,251,115,0,0,0,0,0,0,0,0,0,0,0,0,233,251,251,251,173,0,0,0,0,0,0,98,251,251,251,115,0,0,0,0,0,0,0,0,0,0,0,176,253,253,216,179,0,0,0,0,0,0,0,99,253,253,253,116,0,0,0,0,0,0,0,0,0,0,55,210,251,251,96,0,0,0,0,0,0,0,0,98,251,251,214,62,0,0,0,0,0,0,0,0,0,0,117,251,251,251,96,0,0,0,0,0,0,0,28,204,251,237,53,0,0,0,0,0,0,0,0,0,0,55,241,251,251,160,7,0,0,0,0,0,0,28,222,251,251,231,0,0,0,0,0,0,0,0,0,0,0,59,251,251,251,153,0,0,0,0,0,23,98,204,251,251,251,156,0,0,0,0,0,0,0,0,0,0,0,59,251,251,251,153,0,0,0,85,155,179,251,251,251,251,154,15,0,0,0,0,0,0,0,0,0,0,0,59,251,251,251,236,214,214,214,234,251,253,251,251,248,156,15,0,0,0,0,0,0,0,0,0,0,0,0,41,209,251,251,251,251,251,251,251,251,253,251,196,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,115,241,251,251,251,251,251,251,253,187,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,251,251,251,251,251,101,57,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,141,226,255,255,170,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,170,255,198,141,86,86,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,170,57,0,0,0,57,255,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,170,0,0,0,0,114,226,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,170,170,170,255,255,255,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,170,170,170,86,29,29,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,159,50,0,0,0,76,113,114,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,234,252,252,237,226,225,225,243,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,233,195,195,195,196,195,208,252,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,7,123,169,253,151,0,0,0,0,0,25,205,252,240,71,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,27,0,0,0,0,0,135,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,255,27,0,0,0,0,85,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,167,106,3,0,0,0,38,219,252,242,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,252,252,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,253,252,214,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,203,253,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,207,253,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,122,252,252,215,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,252,252,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,252,249,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,240,252,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,228,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,223,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,227,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,189,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,55,0,0,0,18,67,67,67,153,177,158,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,246,210,210,211,221,253,253,253,253,253,253,66,0,0,0,0,0,0,0,0,0,0,0,0,0,5,196,253,253,253,253,232,231,231,231,231,192,121,54,3,0,0,0,0,0,0,0,0,0,0,0,0,5,147,253,253,200,105,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,253,253,253,220,216,206,137,89,89,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,253,253,253,253,253,253,254,253,253,223,50,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,99,185,204,99,99,99,100,176,209,252,253,180,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,227,253,251,121,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,120,244,253,147,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,242,254,96,0,0,0,0,0,0,0,0,82,177,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,172,0,0,0,0,0,0,0,0,254,253,174,4,0,0,0,0,0,0,0,0,0,0,0,0,0,45,253,253,0,0,0,0,0,0,0,0,135,247,253,176,18,0,0,0,0,0,0,0,0,0,0,0,1,112,253,253,0,0,0,0,0,0,0,0,0,91,220,253,234,80,5,0,0,0,0,0,0,0,0,20,113,253,253,181,0,0,0,0,0,0,0,0,0,0,65,211,253,253,204,131,89,12,0,0,0,86,161,218,253,253,188,45,0,0,0,0,0,0,0,0,0,0,0,21,204,246,253,253,253,235,185,232,232,253,253,253,238,113,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,151,209,223,253,255,253,253,250,209,170,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,66,115,66,66,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,235,147,228,254,254,160,38,84,125,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,214,172,253,253,253,253,250,251,253,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,252,205,24,117,76,142,142,162,253,253,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,253,218,27,0,0,0,0,100,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,253,119,0,0,0,0,48,246,253,173,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,48,5,0,0,0,0,166,253,253,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,253,240,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,241,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,181,253,217,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,253,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,209,253,184,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,213,253,241,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,253,241,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,239,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,253,246,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,253,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,240,253,209,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,251,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,237,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,133,255,254,254,254,254,180,91,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,147,253,253,253,253,253,253,253,253,215,180,85,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,253,253,253,253,180,146,156,253,253,253,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,146,177,56,56,18,0,6,56,56,141,249,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,239,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,242,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,235,253,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,160,253,253,143,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,100,172,172,172,172,172,232,253,252,245,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,229,253,253,253,253,253,253,253,253,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,47,220,253,253,253,253,253,253,253,253,253,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,253,253,253,253,253,253,253,253,253,230,116,15,0,0,0,0,0,0,0,0,0,0,0,0,30,130,253,253,253,253,253,253,253,225,212,216,253,253,253,174,18,0,0,0,0,0,0,0,0,0,0,48,218,253,253,253,253,253,253,253,210,39,0,12,122,228,253,253,182,8,0,0,0,0,0,0,0,0,0,91,253,253,253,253,253,221,153,32,22,0,0,0,0,168,253,253,253,53,0,0,0,0,0,0,0,0,0,38,115,253,137,106,106,48,0,0,0,0,0,0,0,18,106,235,253,179,0,0,0,0,0,0,0,0,0,0,1,15,4,0,0,0,0,0,0,0,0,0,0,0,0,222,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,184,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,255,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,244,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,249,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,233,253,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,253,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,232,253,182,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,160,253,231,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,245,253,183,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,147,253,251,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,253,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,253,226,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,253,244,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,128,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,254,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,254,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,235,254,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,254,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,202,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,255,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,241,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,222,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,224,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,255,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,237,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,207,253,230,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,169,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,176,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,186,253,221,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,197,253,252,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,253,249,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,244,253,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,253,248,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,247,253,138,0,0,0,0,0,4,132,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,251,70,0,0,0,0,0,155,253,224,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,249,253,195,0,0,0,0,43,113,251,253,253,217,24,0,0,0,0,0,0,0,0,0,0,0,0,0,187,253,248,13,0,0,0,4,213,253,253,253,253,253,53,0,0,0,0,0,0,0,0,0,0,0,0,7,197,253,147,0,0,0,7,153,253,253,109,192,253,253,53,0,0,0,0,0,0,0,0,0,0,0,0,44,241,253,147,0,0,8,151,253,253,180,54,217,253,211,19,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,224,69,0,42,253,253,253,222,252,253,253,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,253,252,201,210,253,253,253,253,253,253,177,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,166,253,253,253,253,253,253,253,253,249,84,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,135,137,198,253,253,253,253,201,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,51,51,132,214,253,234,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,213,252,253,252,253,252,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,173,253,255,253,224,162,102,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,253,252,233,151,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,233,255,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,212,253,252,223,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,214,253,254,253,193,51,0,0,0,0,31,51,51,51,51,31,0,0,0,0,0,0,0,0,0,0,0,0,10,91,253,252,253,232,183,102,123,203,233,252,253,252,253,232,123,0,0,0,0,0,0,0,0,0,0,0,0,0,21,183,234,253,254,253,254,253,254,253,254,233,255,253,255,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,232,253,252,253,252,192,111,50,30,50,212,213,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,254,253,254,253,21,0,0,0,0,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,233,252,253,212,253,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,233,254,233,82,102,254,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,252,253,151,0,102,253,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,254,151,0,163,254,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,252,253,151,41,243,253,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,253,255,172,214,253,255,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,232,253,252,253,252,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,253,255,253,142,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,172,252,233,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,62,232,255,229,146,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,209,253,253,253,253,253,205,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,208,253,225,55,133,165,252,253,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,173,253,219,0,0,0,0,206,237,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,253,226,42,0,0,0,45,241,235,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,240,251,114,0,0,0,0,111,253,236,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,205,0,0,0,0,35,221,253,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,245,242,112,8,0,0,167,253,220,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,253,253,234,233,233,252,224,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,158,241,253,253,253,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,54,97,253,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,203,253,242,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,253,253,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,253,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,253,244,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,247,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,246,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,183,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,254,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,254,35,0,0,0,0,0,0,0,0,85,114,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,254,31,0,0,0,0,0,0,0,26,238,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,254,31,0,0,0,0,0,0,0,79,254,181,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,31,0,0,0,0,0,0,0,109,254,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,244,184,4,0,0,0,0,0,0,0,182,236,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,248,59,0,0,0,0,0,0,0,21,230,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,189,228,0,5,6,6,3,0,0,0,6,194,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,254,234,126,243,254,254,173,11,0,0,20,227,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,254,254,254,254,254,254,214,45,0,115,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,250,183,103,5,7,172,246,252,135,155,254,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,166,107,0,0,0,0,0,50,179,254,254,254,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,196,254,200,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,212,245,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,251,194,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,254,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,215,245,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,170,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,255,184,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,247,253,182,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,253,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,171,253,253,140,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,253,253,251,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,219,253,253,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,253,244,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,243,253,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,168,253,253,215,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,253,253,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,242,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,204,253,253,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,253,201,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,253,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,251,253,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,212,253,252,165,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,253,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,253,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,201,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,226,226,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,170,170,226,170,255,255,255,255,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,255,255,226,170,141,114,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,114,0,0,57,86,86,57,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,226,114,226,255,255,255,255,255,170,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,255,198,170,86,29,114,141,226,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,170,57,0,0,0,0,0,0,86,255,198,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,170,0,0,0,0,0,0,57,255,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,170,57,0,0,0,57,226,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,226,255,226,170,170,226,226,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,114,198,255,255,198,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,222,253,253,255,206,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,225,225,163,140,252,252,252,253,252,214,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,252,253,201,195,180,55,119,246,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,236,84,9,0,0,0,0,225,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,112,50,0,0,0,0,0,0,225,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,249,252,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,253,252,208,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,153,253,252,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,255,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,163,226,225,225,225,146,85,85,200,252,252,152,3,0,0,0,0,0,0,0,0,0,0,0,0,0,13,156,252,253,233,208,252,252,253,252,252,252,220,31,0,0,0,0,0,0,0,0,0,0,0,0,0,10,156,252,252,240,71,19,99,239,253,252,252,233,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,252,252,173,63,0,32,140,203,253,252,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,240,63,0,0,120,253,253,255,253,253,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,38,234,252,223,0,0,123,246,252,252,215,195,252,252,237,163,9,0,0,0,0,0,0,0,0,0,0,0,113,252,252,246,197,198,246,252,245,118,31,19,209,252,220,133,6,0,0,0,0,0,0,0,0,0,0,0,101,249,252,252,252,253,252,230,121,0,0,0,66,84,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,142,252,252,190,112,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,118,200,255,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,80,231,254,254,254,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,226,254,254,202,202,254,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,148,251,254,205,128,7,132,254,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,191,253,251,197,78,7,0,51,247,217,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,142,167,79,0,0,0,0,177,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,0,0,0,0,0,0,135,253,183,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,241,224,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,254,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,251,189,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,249,240,43,0,0,5,7,7,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,231,254,73,0,44,119,197,209,206,200,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,254,177,127,206,246,254,240,210,228,254,229,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,246,254,254,254,247,189,70,37,0,22,143,253,211,38,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,254,239,138,26,0,0,0,0,0,0,176,254,136,8,0,0,0,0,0,0,0,0,0,0,0,98,253,250,182,22,0,0,0,0,0,0,0,0,4,136,254,94,0,0,0,0,0,0,0,0,0,0,61,239,252,117,0,0,0,0,0,0,0,0,0,0,0,2,144,228,24,0,0,0,0,0,0,0,0,17,195,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,254,159,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,195,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,110,191,244,255,241,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,55,224,253,240,234,237,253,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,253,176,52,37,44,182,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,225,242,154,15,0,0,9,227,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,225,253,170,0,0,0,40,207,253,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,224,253,182,11,0,0,0,162,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,250,57,0,0,5,95,252,253,167,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,192,0,4,107,228,253,253,236,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,251,160,175,253,253,253,253,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,194,251,253,253,226,253,253,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,59,59,49,226,253,166,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,222,253,218,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,253,153,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,207,253,246,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,253,246,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,245,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,210,253,207,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,192,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,255,253,198,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,253,251,169,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,254,253,254,253,254,253,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,251,253,251,253,251,253,251,225,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,255,253,226,56,0,114,254,253,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,224,253,251,56,0,0,0,139,251,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,255,84,0,0,0,0,57,225,254,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,83,0,0,0,0,0,168,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,253,169,0,0,0,0,0,0,169,254,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,56,0,0,0,0,0,0,168,253,251,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,84,0,0,0,0,0,0,0,0,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,83,0,0,0,0,0,0,0,0,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,197,254,84,0,0,0,0,0,0,0,169,254,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,251,253,83,0,0,0,0,0,0,57,224,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,225,254,139,0,0,0,0,0,57,141,253,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,253,251,169,56,0,114,169,224,253,251,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,254,253,254,253,254,253,254,253,254,253,226,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,251,253,251,253,251,253,251,253,251,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,225,254,253,254,253,254,253,226,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,251,253,251,84,83,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,118,248,255,146,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,133,234,219,112,253,253,253,253,224,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,235,253,253,253,210,177,177,202,253,234,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,158,253,213,109,27,0,0,113,253,234,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,82,22,0,0,0,33,225,253,234,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,241,253,250,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,186,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,188,250,253,172,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,230,253,253,197,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,222,253,253,253,253,193,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,205,130,205,251,208,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,247,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,141,248,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,187,253,213,98,0,0,0,0,0,0,0,0,0,0,0,0,40,219,58,0,0,0,0,0,0,0,68,189,253,211,102,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,198,27,0,0,0,0,0,16,120,253,253,206,18,0,0,0,0,0,0,0,0,0,0,0,0,0,45,231,253,217,118,31,0,0,51,99,253,253,223,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,128,253,253,253,215,179,179,239,253,253,230,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,129,253,253,253,253,253,253,249,217,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,116,198,182,190,239,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,56,115,157,232,155,89,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,84,212,251,244,203,168,205,244,214,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,254,203,56,0,0,0,0,0,200,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,189,241,128,16,0,0,0,0,0,0,126,212,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,254,56,0,0,0,0,0,0,0,0,194,254,190,0,0,0,0,0,0,0,0,0,0,0,0,0,60,251,135,3,0,0,0,0,0,0,0,88,240,245,66,0,0,0,0,0,0,0,0,0,0,0,0,0,66,254,80,0,0,0,0,0,0,0,45,232,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,254,80,0,0,0,0,0,1,64,231,254,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,254,80,0,0,0,0,0,81,254,168,190,254,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,201,222,34,0,28,88,209,253,141,17,170,254,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,254,229,205,232,253,230,108,0,0,170,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,163,194,218,178,60,0,0,0,0,170,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,170,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,227,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,254,232,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,254,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,254,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,254,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,64,0,0,0,0,0,0,0,128,128,255,128,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,64,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,64,255,255,128,0,0,0,0,0,191,255,255,191,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,191,255,191,0,0,0,0,128,255,255,255,191,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,128,128,128,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,97,178,254,254,255,184,12,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,79,110,143,209,209,253,253,253,249,243,252,253,20,0,0,0,0,0,0,0,0,0,0,0,0,3,152,253,253,253,253,253,253,215,188,165,49,18,232,253,20,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,240,143,133,40,34,14,0,0,8,196,253,184,3,0,0,0,0,0,0,0,0,0,0,0,0,4,143,131,25,0,0,0,0,0,0,0,45,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,253,229,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,228,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,134,84,32,95,95,95,95,171,253,253,114,95,95,95,41,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,251,253,253,253,253,253,253,253,253,253,253,253,109,0,0,0,0,0,0,0,0,0,0,0,0,71,148,148,148,204,248,248,251,253,253,250,248,209,195,148,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,244,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,237,253,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,243,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,96,254,254,254,255,254,217,91,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,180,251,253,253,253,253,240,245,253,253,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,253,180,188,173,146,28,77,240,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,253,221,71,22,15,0,0,0,222,253,237,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,129,4,0,0,0,0,0,65,237,253,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,155,253,253,190,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,253,253,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,253,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,235,253,253,162,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,249,253,253,143,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,9,9,9,9,116,121,172,232,253,253,249,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,174,253,253,253,253,253,253,253,253,253,173,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,161,253,253,253,253,253,253,253,253,253,253,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,173,253,253,253,189,168,253,253,253,253,253,253,48,0,0,0,0,0,0,0,0,0,0,0,0,0,15,161,253,253,253,253,227,218,253,253,253,253,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,91,253,253,253,253,253,253,253,253,253,163,173,253,253,233,64,0,0,0,0,0,0,0,0,0,0,0,0,91,253,253,253,253,253,253,238,195,142,10,99,253,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,38,211,253,253,253,253,171,78,0,0,0,99,253,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,22,179,179,100,15,7,0,0,0,0,99,253,253,241,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,105,224,255,247,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,254,254,243,252,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,225,254,224,48,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,109,252,254,254,254,197,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,181,254,254,240,229,237,254,252,152,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,143,254,254,226,36,0,22,138,254,254,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,181,254,254,250,64,0,0,0,2,53,236,252,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,254,254,254,111,0,0,0,0,0,0,56,243,251,42,0,0,0,0,0,0,0,0,0,0,0,0,30,186,254,254,206,29,0,0,0,0,0,0,0,199,254,91,0,0,0,0,0,0,0,0,0,0,0,0,92,254,254,237,13,0,0,0,0,0,0,0,0,134,254,91,0,0,0,0,0,0,0,0,0,0,0,0,133,254,254,126,0,0,0,0,0,0,0,0,0,134,250,17,0,0,0,0,0,0,0,0,0,0,0,0,187,254,237,23,0,0,0,0,0,0,0,0,0,200,183,0,0,0,0,0,0,0,0,0,0,0,0,0,187,254,213,0,0,0,0,0,0,0,0,2,134,252,101,0,0,0,0,0,0,0,0,0,0,0,0,0,183,254,133,0,0,0,0,0,0,0,0,14,254,234,34,0,0,0,0,0,0,0,0,0,0,0,0,0,92,254,161,0,0,0,0,0,0,0,84,204,254,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,254,229,0,0,0,0,0,0,85,252,252,188,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,252,229,0,0,0,0,3,53,235,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,245,130,68,68,134,214,254,254,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,254,254,254,254,254,233,95,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,152,254,254,254,186,157,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,254,254,254,255,254,254,168,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,246,253,253,253,253,253,253,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,201,253,253,216,122,40,208,253,253,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,183,61,31,0,18,211,253,249,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,106,253,248,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,56,235,253,234,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,186,253,253,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,200,248,250,253,217,35,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,246,253,253,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,235,253,253,253,253,193,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,68,68,134,225,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,108,253,226,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,187,253,253,155,39,0,0,0,0,0,0,0,0,0,0,0,40,104,25,0,0,0,0,0,0,0,12,182,253,253,219,32,0,0,0,0,0,0,0,0,0,0,0,39,222,253,61,0,0,0,0,0,0,61,176,253,253,219,41,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,108,29,25,0,0,22,100,239,253,253,253,42,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,253,253,213,209,179,179,205,253,253,249,208,75,4,0,0,0,0,0,0,0,0,0,0,0,0,0,44,222,232,248,253,253,253,253,253,253,212,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,116,116,116,116,116,116,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,91,154,255,254,122,91,91,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,200,253,253,253,253,253,253,253,211,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,253,253,253,253,253,253,253,229,146,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,124,248,253,253,230,156,56,56,56,56,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,253,253,253,213,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,50,195,253,253,222,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,253,253,253,217,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,253,204,66,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,231,253,253,253,253,253,221,156,156,156,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,249,253,253,253,253,253,253,253,253,253,253,250,220,40,0,0,0,0,0,0,0,0,0,0,0,0,0,17,253,253,253,253,253,253,253,253,253,253,253,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,17,253,253,253,234,154,154,154,154,154,193,253,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,5,65,65,65,52,0,0,0,0,0,99,253,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,169,253,253,234,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,34,0,0,0,94,238,253,253,234,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,190,203,0,0,82,250,253,253,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,253,247,131,101,241,253,253,253,194,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,177,253,253,253,253,253,253,195,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,193,253,253,253,253,197,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,179,253,253,94,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,241,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,246,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,244,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,253,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,192,154,0,0,0,0,0,77,253,247,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,181,0,0,0,0,13,191,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,120,246,231,63,0,0,0,0,143,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,205,253,231,63,0,0,0,0,46,191,253,199,24,0,0,0,0,0,0,0,0,0,0,0,0,0,26,139,253,253,138,0,0,0,0,0,176,253,246,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,244,253,253,83,37,0,0,0,11,192,253,237,50,0,0,0,0,0,0,0,0,0,0,0,0,0,45,244,253,253,253,253,229,176,176,176,192,253,253,214,50,0,0,0,0,0,0,0,0,0,0,0,0,0,181,253,253,253,233,253,253,253,253,253,253,253,247,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,147,221,104,44,91,91,128,221,245,253,253,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,196,253,235,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,253,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,228,253,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,253,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,253,226,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,80,80,153,250,80,80,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,254,254,254,254,254,254,228,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,254,254,254,254,254,254,245,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,114,114,114,114,114,206,254,254,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,106,243,254,254,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,254,254,254,254,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,254,254,254,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,185,254,254,254,224,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,70,70,70,230,219,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,254,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,254,207,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,254,231,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,243,254,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,237,254,254,225,24,0,0,0,0,0,0,0,0,0,0,0,0,0,28,52,0,0,0,0,0,40,116,153,254,254,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,221,194,194,194,194,194,215,254,254,254,214,61,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,211,254,254,254,254,254,254,254,254,254,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,231,254,254,254,254,254,254,205,78,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,208,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,239,176,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,200,254,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,254,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,232,254,222,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,254,251,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,252,254,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,185,254,254,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,254,223,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,236,254,254,52,0,0,0,0,0,29,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,254,173,8,0,0,0,2,49,207,195,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,226,254,240,54,0,0,0,0,22,254,254,254,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,254,124,0,0,0,2,22,207,254,254,254,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,254,124,0,0,0,117,254,254,254,254,254,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,241,7,0,0,66,251,254,254,254,254,221,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,253,150,84,84,129,254,255,254,254,221,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,254,254,254,254,254,254,254,254,253,125,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,174,254,254,254,254,254,254,254,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,96,167,234,234,239,254,254,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,142,254,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,229,253,226,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,169,225,233,96,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,197,110,85,85,110,197,246,253,208,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,252,252,252,253,252,252,252,128,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,179,255,253,244,225,114,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,253,139,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,253,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,254,253,216,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,234,252,252,169,144,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,143,168,216,252,234,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,128,252,240,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,250,242,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,253,122,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,253,252,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,113,0,0,0,0,0,0,0,0,153,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,76,0,0,0,0,0,0,26,254,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,231,57,38,0,57,57,95,243,253,214,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,243,253,252,234,197,253,252,252,252,244,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,140,190,190,240,253,252,252,202,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,138,170,253,201,244,212,222,138,86,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,252,252,252,252,253,252,252,252,252,245,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,246,205,69,69,69,69,69,69,69,69,205,253,240,50,0,0,0,0,0,0,0,0,0,0,0,0,0,187,252,218,34,0,0,0,0,0,0,0,116,253,252,69,0,0,0,0,0,0,0,0,0,0,0,0,116,248,252,253,92,0,0,0,0,0,0,95,230,253,157,6,0,0,0,0,0,0,0,0,0,0,0,0,116,249,253,189,42,0,0,0,0,36,170,253,243,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,252,245,140,34,0,0,57,219,252,235,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,205,253,252,234,184,184,253,240,100,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,161,219,252,252,252,234,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,203,252,252,252,251,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,76,255,253,205,168,220,255,253,137,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,252,249,132,25,0,0,180,252,252,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,220,252,199,0,0,0,0,38,186,252,154,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,252,252,21,0,0,0,0,0,67,252,252,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,252,200,0,0,0,0,0,0,47,252,252,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,253,201,0,0,0,0,0,3,118,253,245,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,252,252,0,0,0,0,0,97,252,252,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,240,252,123,70,70,112,184,222,252,170,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,253,252,252,252,252,245,139,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,75,253,252,221,137,137,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,122,199,255,215,91,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,197,253,253,253,253,253,182,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,214,253,252,148,71,71,242,253,186,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,245,93,0,0,0,9,173,245,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,253,124,0,0,0,0,0,0,171,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,247,244,10,0,0,0,0,0,0,103,251,153,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,243,0,0,0,0,0,0,58,235,253,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,253,243,0,0,0,0,0,183,234,253,253,253,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,253,243,0,0,0,0,0,224,253,253,253,249,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,243,34,13,0,0,0,8,198,253,253,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,251,233,59,0,0,0,8,199,253,232,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,138,253,253,122,29,130,169,240,253,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,211,253,253,253,253,253,253,253,253,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,156,231,253,233,156,119,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,10,8,0,34,253,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,253,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,253,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,253,253,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,6,113,115,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,44,44,3,0,59,152,222,254,254,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,254,185,4,26,200,254,254,254,254,155,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,157,252,229,40,0,0,151,128,27,27,27,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,158,254,244,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,184,232,187,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,222,254,254,239,234,211,86,17,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,241,252,200,200,200,212,254,254,123,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,52,0,0,0,12,93,209,254,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,36,0,0,0,0,0,0,0,0,0,66,218,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,192,21,0,0,0,0,0,0,0,0,13,218,198,5,0,0,0,0,0,0,0,0,0,0,0,0,0,65,186,210,82,0,0,0,0,0,0,0,22,254,194,4,0,0,0,0,0,0,0,0,0,0,0,0,0,17,164,252,126,19,0,0,0,0,6,107,246,236,51,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,205,254,229,174,107,66,119,191,254,254,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,151,184,254,254,254,254,254,254,56,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,103,114,114,114,44,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,248,48,0,0,0,0,3,154,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,77,0,0,0,0,58,254,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,240,20,0,0,0,0,107,254,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,235,0,0,0,0,0,201,254,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,247,235,0,0,0,0,21,227,193,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,254,235,0,0,0,0,113,254,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,254,178,0,0,0,0,140,254,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,172,254,131,0,0,0,0,220,254,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,254,217,13,0,0,0,25,242,245,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,232,144,144,144,144,214,254,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,254,254,254,254,254,254,254,254,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,177,177,177,177,177,182,254,254,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,224,254,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,254,233,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,255,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,226,254,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,254,179,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,254,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,244,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,254,255,141,49,92,92,0,0,0,46,101,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,240,253,253,247,203,248,248,200,200,200,224,253,251,116,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,204,94,56,240,253,253,253,253,253,253,253,145,0,0,0,0,0,0,0,0,0,0,0,0,54,245,253,118,5,0,0,6,21,160,186,253,253,253,189,4,0,0,0,0,0,0,0,0,0,0,0,8,163,253,224,28,0,0,0,0,0,0,70,253,253,253,92,0,0,0,0,0,0,0,0,0,0,0,0,47,253,253,214,0,0,0,0,0,0,0,70,253,253,219,42,0,0,0,0,0,0,0,0,0,0,0,0,47,253,253,69,0,0,0,0,0,0,42,225,253,214,34,0,0,0,0,0,0,0,0,0,0,0,0,0,13,157,166,17,0,0,0,0,0,36,218,253,253,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,253,245,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,246,253,232,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,233,253,253,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,190,253,253,193,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,253,253,232,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,68,231,253,248,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,166,253,253,221,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,139,253,253,252,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,235,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,194,0,0,0,0,0,0,18,106,143,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,236,164,0,0,0,0,0,0,132,252,162,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,40,0,0,0,0,0,40,227,206,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,211,167,1,0,0,0,0,0,157,252,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,240,81,0,0,0,0,0,0,209,238,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,246,159,0,0,0,0,0,0,53,243,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,252,88,0,0,0,0,0,2,170,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,236,248,72,0,0,0,0,0,34,252,192,4,0,0,0,27,12,0,0,0,0,0,0,0,0,0,0,67,252,237,27,0,0,0,0,0,67,252,72,0,17,78,127,83,17,0,0,0,0,0,0,0,0,0,0,67,252,252,159,24,0,0,0,0,143,252,134,168,227,166,40,0,0,0,0,0,0,0,0,0,0,0,0,0,44,219,253,253,200,143,143,191,255,245,220,162,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,77,77,129,186,186,244,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,240,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,251,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,252,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,252,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,171,255,156,101,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,154,126,183,236,253,253,253,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,244,253,253,253,253,253,253,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,250,253,253,132,7,7,7,44,220,253,252,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,214,238,214,111,0,0,0,0,162,253,245,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,0,0,0,0,0,0,162,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,248,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,253,253,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,235,253,197,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,241,253,251,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,177,253,253,245,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,124,124,124,124,124,159,253,253,253,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,224,251,244,183,247,253,253,253,253,253,198,11,0,0,0,0,0,0,0,0,0,0,0,0,0,9,166,233,253,187,74,0,137,253,253,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,22,195,253,235,137,8,15,116,241,253,253,253,253,253,219,42,0,0,0,0,0,0,0,0,0,0,0,25,191,253,230,69,34,207,220,253,253,253,223,191,233,253,253,223,0,0,0,0,0,0,0,0,0,0,0,101,253,253,163,126,212,253,253,253,251,231,47,0,71,249,253,245,5,0,0,0,0,0,0,0,0,0,0,101,253,253,253,253,253,253,253,253,111,0,0,0,0,116,253,253,191,20,0,0,0,0,0,0,0,0,0,80,209,253,253,253,253,202,180,45,4,0,0,0,0,116,253,253,253,45,0,0,0,0,0,0,0,0,0,0,19,99,99,99,99,6,0,0,0,0,0,0,0,116,253,253,187,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,191,255,191,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,64,0,64,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,64,0,0,0,0,191,255,128,64,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,64,0,0,0,0,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,128,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,64,128,191,0,0,0,0,0,0,0,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,191,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,109,191,255,253,253,253,110,109,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,227,252,252,253,252,252,252,253,252,206,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,252,217,132,215,236,253,252,252,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,252,252,168,0,0,0,62,108,232,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,73,233,252,252,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,68,252,253,252,122,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,175,252,252,253,210,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,129,253,255,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,227,252,252,253,252,220,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,247,252,252,253,252,241,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,108,108,108,232,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,222,253,63,0,0,0,0,0,0,0,0,0,0,0,32,197,196,31,0,0,0,0,0,0,0,0,0,21,201,252,144,0,0,0,0,0,0,0,0,0,0,0,212,252,246,92,0,0,0,0,0,0,0,0,0,176,252,252,144,0,0,0,0,0,0,0,0,0,0,0,253,252,215,0,0,0,0,0,0,0,0,0,63,237,252,252,62,0,0,0,0,0,0,0,0,0,0,0,255,253,232,109,62,0,0,0,0,0,16,191,255,253,237,62,0,0,0,0,0,0,0,0,0,0,0,0,98,242,252,252,237,217,114,73,135,217,222,252,253,252,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,180,252,252,252,252,252,253,252,252,252,217,174,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,108,108,232,252,252,253,252,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,172,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,241,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,220,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,70,0,0,0,0,161,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,240,30,0,0,66,252,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,244,40,0,0,80,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,254,207,193,132,152,254,105,0,0,70,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,158,254,250,245,254,254,254,191,115,184,228,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,205,46,3,109,254,254,254,254,238,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,243,244,67,0,0,0,225,233,94,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,194,0,0,0,0,254,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,254,80,0,0,0,83,254,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,140,5,0,0,0,88,255,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,254,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,202,227,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,235,194,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,254,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,196,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,139,253,253,172,132,132,35,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,253,252,252,236,245,252,252,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,21,241,228,96,96,32,69,198,252,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,216,225,40,0,0,0,0,73,252,220,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,252,103,0,0,0,0,0,73,252,229,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,252,46,0,0,0,0,81,210,252,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,244,230,41,0,0,137,239,252,143,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,252,121,10,115,241,252,143,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,252,241,231,252,179,58,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,253,241,115,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,162,253,253,255,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,209,252,242,251,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,184,252,192,55,241,253,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,229,252,213,127,0,241,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,229,252,206,36,0,27,244,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,156,252,206,14,0,28,150,252,244,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,252,252,151,0,0,97,252,252,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,252,252,198,97,137,230,252,252,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,114,252,252,252,252,252,252,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,131,218,252,252,148,80,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,114,255,255,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,226,255,170,170,141,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,198,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,141,0,0,0,0,0,0,0,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,86,0,0,0,0,0,0,0,86,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,255,198,0,0,0,0,0,0,0,0,226,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,198,0,0,0,0,0,0,0,86,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,255,86,0,0,0,0,29,141,255,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,255,255,198,114,141,170,255,255,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,141,170,226,170,114,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,247,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,248,254,230,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,254,254,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,254,212,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,223,254,252,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,254,254,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,195,254,254,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,254,246,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,254,254,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,239,254,254,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,218,254,254,167,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,254,254,254,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,187,254,254,234,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,254,254,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,247,254,255,219,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,222,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,213,254,235,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,254,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,254,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,202,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,132,255,247,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,121,236,254,254,254,210,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,192,254,244,140,104,236,254,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,254,220,72,0,0,170,254,240,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,246,243,67,0,0,0,79,254,246,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,251,254,140,0,0,0,7,172,254,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,254,237,45,0,0,7,164,254,254,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,238,254,180,9,8,134,254,254,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,254,226,225,254,254,254,239,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,55,125,196,231,238,137,254,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,38,26,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,243,236,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,221,251,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,81,7,0,0,0,0,0,0,106,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,191,17,0,0,0,0,38,241,252,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,253,236,133,96,96,110,242,254,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,214,254,254,254,254,238,151,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,101,167,183,210,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,128,253,255,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,225,226,225,246,252,252,253,243,116,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,228,195,195,202,252,253,252,252,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,223,126,0,0,10,84,84,218,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,239,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,242,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,243,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,252,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,253,228,47,0,0,0,0,0,0,0,0,0,0,0,0,0,48,147,225,116,85,85,48,0,0,26,225,253,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,54,227,253,252,252,252,252,229,197,88,156,252,253,233,43,0,0,0,0,0,0,0,0,0,0,0,10,138,224,252,240,223,114,99,223,253,252,252,252,252,240,71,0,0,0,0,0,0,0,0,0,0,0,0,163,252,252,252,140,0,0,0,0,253,252,252,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,240,63,0,0,0,13,113,255,253,253,253,253,192,12,0,0,0,0,0,0,0,0,0,0,0,0,225,252,99,0,0,29,85,181,252,253,252,252,252,252,253,181,19,0,0,0,0,0,0,0,0,0,0,89,246,252,215,197,198,215,252,252,252,228,148,55,155,252,253,252,177,19,0,0,0,0,0,0,0,0,0,38,209,246,252,252,253,252,252,233,145,47,0,0,10,84,237,252,214,28,0,0,0,0,0,0,0,0,0,0,0,88,205,252,253,252,141,37,0,0,0,0,0,0,50,112,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,173,180,159,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,243,253,253,253,220,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,173,194,254,253,253,253,253,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,216,253,253,254,213,208,253,253,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,220,253,253,253,217,26,201,253,253,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,193,253,253,253,246,105,87,253,253,225,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,253,253,253,212,106,47,245,253,253,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,253,253,219,67,56,247,253,253,125,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,230,253,103,14,205,254,253,234,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,253,193,146,253,254,239,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,207,254,254,254,255,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,253,253,253,254,189,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,160,253,253,253,254,253,226,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,253,253,225,198,253,253,228,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,173,253,253,219,71,5,53,253,253,190,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,253,248,87,7,44,133,253,253,253,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,253,253,180,96,206,254,253,253,253,188,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,242,253,253,253,253,254,253,230,133,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,253,253,253,201,117,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,131,180,128,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,255,223,102,233,130,130,130,37,7,7,7,7,116,130,130,6,0,0,0,0,0,0,0,0,0,0,1,148,253,224,158,243,253,253,253,253,253,253,253,253,253,253,253,18,0,0,0,0,0,0,0,0,0,0,13,253,253,251,86,19,111,111,202,235,235,235,235,241,253,253,253,66,0,0,0,0,0,0,0,0,0,4,142,253,253,149,0,0,0,0,0,0,0,0,43,184,253,253,127,5,0,0,0,0,0,0,0,0,0,0,136,253,238,39,0,0,0,0,0,0,0,0,54,239,253,240,64,0,0,0,0,0,0,0,0,0,0,0,117,216,195,0,0,0,0,0,0,0,0,31,172,253,239,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,253,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,175,253,235,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,253,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,239,253,189,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,239,253,192,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,119,253,231,161,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,179,253,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,253,196,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,242,253,200,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,243,253,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,200,253,253,151,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,129,253,253,231,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,253,253,233,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,67,239,255,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,147,252,252,253,252,252,203,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,252,252,209,92,146,252,252,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,251,248,116,6,0,32,220,252,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,234,252,184,0,0,0,0,78,250,233,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,252,205,22,0,0,0,0,0,242,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,131,0,0,0,0,3,146,251,250,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,64,0,0,0,6,99,252,252,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,21,0,0,0,148,252,252,252,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,165,20,111,206,253,252,252,243,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,246,253,253,253,253,236,243,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,247,241,186,138,34,176,252,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,36,0,0,0,176,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,249,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,219,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,219,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,219,252,127,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,252,252,252,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,252,252,202,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,138,252,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,124,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,246,251,251,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,190,251,251,251,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,174,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,176,253,253,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,228,251,251,157,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,180,231,253,251,96,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,255,211,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,221,251,251,242,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,190,251,251,251,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,251,251,251,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,255,253,253,221,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,157,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,147,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,34,169,254,253,155,155,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,214,236,253,252,244,250,253,241,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,253,253,229,151,2,54,203,253,245,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,250,254,172,22,0,0,0,29,253,254,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,229,253,127,36,0,0,0,0,5,128,254,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,253,238,34,0,0,0,0,0,0,160,251,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,253,151,0,135,185,70,0,0,45,231,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,231,253,246,167,247,253,251,48,40,215,253,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,253,253,253,253,254,253,207,254,253,227,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,49,244,253,253,253,253,253,253,253,120,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,253,252,209,252,253,253,253,253,253,229,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,107,0,132,179,114,95,139,234,254,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,241,253,69,0,52,18,0,0,0,94,234,241,148,4,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,69,0,0,0,0,0,0,0,125,253,244,47,0,0,0,0,0,0,0,0,0,0,0,0,0,32,254,138,8,0,0,0,0,0,0,0,25,217,236,32,0,0,0,0,0,0,0,0,0,0,0,0,0,21,253,216,49,0,0,0,0,0,0,0,8,203,229,19,0,0,0,0,0,0,0,0,0,0,0,0,0,21,254,254,167,80,22,1,14,0,30,63,186,253,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,159,253,253,253,228,191,215,190,244,253,254,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,190,241,253,254,254,253,254,253,253,231,107,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,110,153,173,253,167,100,88,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,190,134,253,253,191,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,208,252,252,252,252,253,247,240,240,204,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,252,252,242,158,208,253,252,252,252,252,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,252,239,84,0,21,39,165,172,240,252,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,252,107,0,0,0,0,0,75,244,252,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,198,63,0,0,0,0,0,122,252,252,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,230,252,185,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,252,252,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,247,252,205,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,255,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,246,253,252,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,172,252,253,107,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,252,252,253,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,233,252,252,123,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,190,252,252,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,155,252,252,221,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,252,252,235,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,230,252,250,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,224,252,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,131,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,243,253,130,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,214,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,252,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,243,253,171,0,0,0,0,21,142,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,253,254,112,0,0,0,21,173,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,232,253,151,0,0,0,102,253,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,253,51,51,51,213,254,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,252,253,252,253,252,253,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,82,203,234,253,254,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,253,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,254,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,233,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,243,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,234,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,206,229,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,125,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,254,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,240,254,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,254,254,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,129,254,254,220,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,254,254,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,179,254,254,254,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,254,254,183,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,254,254,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,111,252,254,254,232,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,254,254,254,216,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,192,254,254,254,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,192,254,254,254,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,254,254,255,241,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,235,254,254,254,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,238,254,254,254,219,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,254,254,254,216,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,254,254,254,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,170,254,254,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,254,254,254,254,171,133,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,253,253,253,253,253,253,234,184,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,185,232,138,10,10,93,173,230,253,215,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,24,132,253,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,253,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,118,155,252,253,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,253,253,253,234,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,205,253,228,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,253,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,164,253,206,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,222,253,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,249,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,115,115,94,51,131,245,253,250,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,210,253,253,253,253,253,246,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,48,149,233,253,217,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,253,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,236,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,236,251,251,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,251,251,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,255,253,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,188,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,211,253,251,235,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,211,251,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,255,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,251,253,168,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,221,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,190,251,251,251,221,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,251,251,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,246,137,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,180,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,254,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,231,250,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,211,254,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,254,250,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,251,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,251,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,253,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,254,235,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,254,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,254,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,254,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,254,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,254,254,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,196,168,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,208,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,212,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,225,254,254,232,147,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,248,254,254,254,254,254,230,148,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,250,254,245,226,254,254,254,254,254,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,205,254,250,101,20,194,254,254,254,254,229,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,254,94,0,0,14,124,187,254,254,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,252,254,206,15,0,0,0,0,3,6,51,231,254,94,0,0,0,0,0,0,0,0,0,0,0,0,50,246,254,254,20,0,0,0,0,0,0,0,0,200,254,96,0,0,0,0,0,0,0,0,0,0,0,21,184,254,254,147,2,0,0,0,0,0,0,0,0,200,254,96,0,0,0,0,0,0,0,0,0,0,0,177,254,254,218,33,0,0,0,0,0,0,0,0,16,211,254,96,0,0,0,0,0,0,0,0,0,0,11,219,254,251,92,0,0,0,0,0,0,0,0,0,84,254,232,44,0,0,0,0,0,0,0,0,0,0,101,254,254,141,0,0,0,0,0,0,0,0,0,0,162,254,231,42,0,0,0,0,0,0,0,0,0,0,235,254,227,42,0,0,0,0,0,0,0,0,0,51,238,254,213,0,0,0,0,0,0,0,0,0,0,0,235,254,199,0,0,0,0,0,0,0,0,0,0,160,254,229,52,0,0,0,0,0,0,0,0,0,0,0,235,254,199,0,0,0,0,0,0,0,10,84,150,253,254,147,0,0,0,0,0,0,0,0,0,0,0,0,235,254,213,20,0,0,0,0,17,63,158,254,254,254,155,12,0,0,0,0,0,0,0,0,0,0,0,0,122,248,254,204,98,42,177,180,200,254,254,253,213,82,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,254,254,254,254,254,254,251,219,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,221,254,254,254,254,254,217,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,202,254,254,254,254,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,106,253,253,253,253,253,238,183,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,253,253,253,249,240,253,253,253,201,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,246,133,95,16,133,247,253,253,199,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,142,27,0,0,0,0,81,236,253,254,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,254,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,254,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,254,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,239,253,236,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,253,253,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,254,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,139,251,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,131,253,253,224,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,253,253,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,250,253,253,226,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,214,253,253,253,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,253,253,253,253,141,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,206,253,253,253,253,251,239,241,239,239,239,239,239,239,239,239,240,0,0,0,0,0,0,0,0,0,0,0,99,221,253,253,253,253,253,254,253,253,253,253,253,253,253,218,120,0,0,0,0,0,0,0,0,0,0,0,0,31,104,104,104,130,253,255,253,253,253,209,104,104,104,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,212,253,255,253,232,109,192,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,218,247,252,252,253,252,252,252,253,242,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,206,253,252,246,215,217,174,71,175,253,252,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,128,92,0,0,0,1,144,253,252,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,253,220,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,242,252,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,37,182,242,252,252,154,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,160,252,253,252,231,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,253,253,253,255,159,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,252,252,191,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,232,252,252,252,253,149,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,108,128,252,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,255,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,32,115,62,0,0,0,0,0,0,0,0,0,253,252,174,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,71,0,0,0,0,0,0,0,6,120,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,154,0,0,0,0,0,0,0,37,252,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,253,109,78,0,0,47,109,212,253,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,180,252,252,252,242,217,217,233,252,252,252,222,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,180,252,252,252,252,252,253,252,246,132,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,108,108,148,252,168,108,108,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,69,148,210,218,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,142,252,252,253,252,238,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,213,252,252,190,127,212,252,186,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,252,247,119,14,0,85,252,252,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,252,187,0,0,0,50,244,252,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,254,204,9,0,0,0,0,110,253,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,168,0,0,0,0,0,22,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,253,210,11,0,0,0,8,173,252,252,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,253,252,118,0,0,38,171,252,252,199,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,240,106,194,236,252,252,155,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,199,253,253,253,255,253,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,159,168,203,253,252,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,253,245,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,214,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,228,254,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,216,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,254,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,252,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,140,11,0,0,0,9,182,254,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,251,42,0,0,0,96,254,254,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,246,249,0,0,0,0,178,254,218,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,250,35,0,0,96,245,254,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,247,254,254,232,194,96,218,255,254,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,254,254,254,254,254,254,254,254,254,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,103,74,8,135,245,254,254,250,190,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,255,254,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,178,254,240,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,254,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,254,235,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,239,254,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,150,216,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,118,164,254,255,174,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,203,248,183,128,128,228,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,201,224,96,0,0,0,167,235,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,249,61,0,0,0,0,84,237,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,249,152,0,0,0,0,0,101,152,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,254,106,0,0,0,0,64,239,202,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,182,2,0,0,0,0,196,254,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,242,105,0,0,0,0,0,235,254,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,254,105,0,0,0,0,54,248,216,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,240,124,0,0,0,27,214,245,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,204,3,5,33,209,254,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,254,186,199,254,254,254,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,167,230,223,156,138,254,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,16,21,206,254,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,254,203,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,254,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,248,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,115,253,253,253,96,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,112,51,131,214,251,251,251,251,253,185,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,221,251,251,251,253,251,251,251,251,253,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,251,251,235,188,31,31,31,31,129,213,251,156,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,212,251,89,0,0,0,0,0,0,96,251,251,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,253,253,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,214,251,235,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,253,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,240,253,251,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,251,253,231,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,174,253,253,219,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,158,251,251,251,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,128,127,127,127,127,253,251,251,251,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,104,240,253,251,251,251,251,253,251,251,196,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,205,251,251,253,251,251,251,251,253,251,251,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,253,253,253,255,253,253,253,253,255,253,253,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,71,251,251,251,253,251,251,223,220,63,185,251,251,251,230,47,0,0,0,0,0,0,0,0,0,0,0,0,16,188,251,251,253,235,126,15,0,0,32,251,251,251,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,16,31,31,31,27,0,0,0,0,4,31,185,251,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,193,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,231,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,254,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,247,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,248,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,245,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,230,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,251,253,243,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,242,195,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,206,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,240,253,252,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,156,252,253,186,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,252,252,240,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,249,252,242,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,252,252,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,107,253,252,198,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,243,252,215,33,0,0,0,0,0,0,57,163,226,178,19,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,140,0,0,0,0,0,19,57,187,252,253,252,87,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,47,0,0,0,0,76,196,252,252,252,253,252,195,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,0,0,0,0,0,191,252,252,252,252,253,252,118,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,63,0,0,13,191,255,253,253,174,253,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,241,178,85,181,252,253,252,252,252,252,215,33,0,0,0,0,0,0,0,0,0,0,0,0,0,75,233,252,253,252,252,252,252,253,252,252,245,195,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,239,253,252,252,252,252,253,242,192,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,174,252,252,252,252,190,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,145,230,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,254,254,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,254,229,180,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,232,254,74,254,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,254,42,164,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,254,71,156,155,0,26,74,74,167,149,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,254,151,83,137,93,235,254,243,187,92,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,254,253,125,237,254,207,94,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,217,254,254,252,129,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,221,254,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,227,254,254,254,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,220,195,201,231,254,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,229,49,22,177,254,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,202,241,25,0,12,254,249,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,246,84,0,0,6,254,254,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,248,220,0,0,0,109,254,254,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,125,0,0,45,225,254,160,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,254,128,3,67,242,254,201,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,239,245,188,254,240,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,246,255,162,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,244,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,91,236,249,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,0,0,23,252,252,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,238,152,0,0,0,0,0,137,252,245,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,252,208,0,0,0,0,66,249,252,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,241,252,122,0,0,0,0,137,252,209,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,113,252,247,52,0,0,0,0,209,251,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,252,252,154,0,0,0,0,41,236,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,245,252,252,21,0,0,0,0,148,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,252,252,252,223,220,138,111,15,209,252,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,229,253,253,253,253,253,253,253,255,253,253,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,128,77,77,81,186,186,186,253,252,252,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,170,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,253,247,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,231,253,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,252,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,31,130,130,225,255,255,255,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,253,253,244,244,253,253,249,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,225,111,30,69,253,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,203,204,0,0,69,253,253,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,139,0,0,84,253,243,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,231,253,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,253,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,253,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,253,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,233,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,239,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,220,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,187,220,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,255,253,253,253,253,114,113,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,196,252,253,252,252,252,252,253,252,246,225,225,226,72,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,124,208,214,227,253,220,252,252,252,253,233,43,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,27,19,28,47,84,37,84,84,177,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,135,252,252,190,12,0,0,0,0,0,0,0,140,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,255,27,0,0,0,0,0,0,13,191,255,253,56,0,0,0,0,0,0,0,0,0,0,0,0,53,177,204,27,3,0,0,0,0,0,19,181,252,253,176,6,0,0,0,0,0,0,0,0,0,0,0,0,0,7,25,0,0,0,0,0,0,0,57,252,252,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,252,252,178,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,227,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,253,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,147,249,252,179,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,165,253,252,208,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,131,252,253,242,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,252,252,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,222,253,253,204,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,234,252,252,127,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,222,252,252,245,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,198,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,204,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,191,181,0,0,0,0,0,0,13,80,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,105,0,0,0,0,0,0,165,244,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,252,70,0,0,0,0,0,39,250,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,228,0,0,0,0,0,0,42,255,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,247,136,0,0,0,0,0,0,133,254,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,254,125,0,0,0,0,0,0,172,254,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,254,125,0,0,0,0,0,43,252,254,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,254,125,0,0,0,0,0,100,254,254,64,53,61,128,8,0,0,0,0,0,0,0,0,0,0,0,0,37,254,228,203,197,100,144,203,223,254,254,254,254,254,228,22,0,0,0,0,0,0,0,0,0,0,0,0,1,82,209,254,254,254,254,254,254,254,240,115,109,109,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,62,111,98,62,84,237,240,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,252,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,254,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,254,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,241,169,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,254,218,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,254,214,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,225,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,117,254,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,254,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,254,142,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,252,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,70,58,0,0,0,0,0,120,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,254,84,0,0,0,0,0,207,254,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,132,252,251,56,0,0,0,0,109,251,229,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,254,252,116,0,0,0,0,14,224,254,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,233,254,244,18,93,48,0,0,108,254,254,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,254,254,242,254,247,169,130,241,254,213,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,254,254,226,195,195,195,233,254,254,254,190,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,138,48,26,0,0,0,117,254,254,164,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,212,254,231,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,255,254,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,254,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,163,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,134,253,253,121,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,129,252,252,252,253,240,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,252,252,252,252,253,252,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,207,252,252,241,39,39,96,90,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,252,252,252,203,0,0,190,247,193,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,252,252,252,106,0,90,249,252,252,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,252,252,233,33,0,121,252,252,252,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,252,252,242,69,27,204,252,252,252,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,252,252,252,126,246,253,252,252,252,189,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,252,252,252,246,196,253,252,252,252,252,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,222,253,253,253,253,255,253,253,253,253,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,252,252,252,252,253,195,252,252,252,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,118,89,158,158,26,157,252,252,227,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,252,252,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,252,252,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,252,252,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,252,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,250,252,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,252,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,109,212,253,110,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,73,233,252,252,252,253,242,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,150,252,253,252,252,252,253,252,241,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,217,252,252,253,252,148,108,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,206,103,0,0,62,237,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,222,200,97,20,0,0,0,32,227,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,20,0,0,0,0,0,212,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,255,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,252,253,231,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,32,21,37,37,32,0,0,73,232,252,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,175,236,206,253,252,236,144,63,237,252,252,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,63,253,253,253,191,145,238,253,253,255,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,237,252,231,158,15,0,93,252,252,253,252,241,97,0,0,0,0,0,0,0,0,0,0,0,0,0,11,191,252,236,71,0,0,37,181,252,252,253,252,221,16,0,0,0,0,0,0,0,0,0,0,0,0,0,155,252,252,62,0,105,144,253,252,252,252,253,252,252,190,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,253,109,233,253,253,255,253,237,62,63,238,253,253,63,0,0,0,0,0,0,0,0,0,0,0,78,242,252,252,252,252,252,252,253,148,30,0,0,175,252,252,238,196,41,0,0,0,0,0,0,0,0,0,0,62,180,252,252,220,215,132,72,10,0,0,0,63,241,252,253,158,0,0,0,0,0,0,0,0,0,0,0,0,16,108,108,15,0,0,0,0,0,0,0,0,181,252,191,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,64,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,64,0,0,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,128,64,0,0,0,128,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,191,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,255,233,48,84,96,96,96,96,96,194,255,233,48,0,0,0,0,0,0,0,0,0,0,0,0,0,48,228,253,251,220,244,251,253,251,251,251,251,253,247,110,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,253,251,188,236,251,253,251,251,251,251,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,251,253,223,15,27,129,189,69,31,86,251,253,220,0,0,0,0,0,0,0,0,0,0,0,0,0,80,240,251,253,121,0,0,0,0,0,0,162,251,253,220,0,0,0,0,0,0,0,0,0,0,0,0,20,206,253,253,219,39,0,0,0,0,0,48,234,253,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,111,228,231,138,0,0,0,0,0,44,221,251,251,161,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,47,0,0,0,0,0,0,190,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,205,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,251,251,211,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,194,255,253,253,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,186,251,253,251,235,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,253,156,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,84,236,251,251,229,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,251,251,251,251,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,255,253,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,228,253,251,251,184,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,251,253,251,188,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,251,253,243,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,193,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,135,167,254,254,255,169,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,236,253,253,253,253,253,253,209,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,241,253,253,250,165,146,251,253,253,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,210,175,102,39,0,0,66,222,253,204,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,160,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,235,253,249,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,253,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,215,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,250,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,103,33,9,0,0,0,147,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,219,253,253,200,65,0,0,200,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,247,253,253,253,253,200,92,21,221,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,191,253,219,119,216,253,253,253,246,253,221,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,253,102,0,4,102,238,253,253,253,124,0,0,0,0,0,9,48,0,0,0,0,0,0,0,0,0,38,253,253,210,71,0,0,195,253,253,253,232,139,104,4,0,42,168,242,31,0,0,0,0,0,0,0,0,1,162,235,253,252,102,121,252,253,253,253,253,253,253,249,249,251,253,214,17,0,0,0,0,0,0,0,0,0,0,34,106,253,253,253,229,84,75,115,183,230,253,253,253,253,214,87,0,0,0,0,0,0,0,0,0,0,0,0,7,72,242,186,50,0,0,0,0,25,37,141,145,55,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,249,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,218,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,254,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,212,232,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,12,0,0,0,3,141,254,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,208,166,0,0,0,111,254,234,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,210,254,88,0,0,3,191,254,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,181,34,0,0,121,254,236,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,242,255,181,100,16,0,203,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,224,254,254,254,254,249,167,254,248,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,254,245,166,124,188,254,254,254,184,89,89,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,120,65,0,0,4,130,254,254,224,223,155,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,243,254,109,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,254,207,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,190,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,254,245,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,254,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,203,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,149,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,230,253,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,253,253,232,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,253,217,39,0,0,0,0,0,0,0,0,36,35,0,0,0,0,0,0,0,0,0,0,0,0,0,18,191,253,178,0,0,0,0,0,0,0,0,107,233,233,145,4,0,0,0,0,0,0,0,0,0,0,0,78,253,253,178,0,0,0,0,0,0,0,0,121,253,253,237,12,0,0,0,0,0,0,0,0,0,0,0,209,253,253,99,0,0,0,0,0,0,0,0,121,253,237,56,0,0,0,0,0,0,0,0,0,0,0,0,210,253,253,29,0,0,0,0,0,0,0,6,167,253,170,0,0,0,0,0,0,0,0,0,0,0,0,81,243,250,137,7,0,0,0,0,0,0,0,42,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,106,253,238,0,0,0,0,0,0,0,0,0,164,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,106,254,246,56,0,0,0,0,0,0,0,61,254,255,223,44,0,0,63,0,0,0,0,0,0,0,0,0,19,217,253,161,43,0,0,0,0,0,0,60,253,253,196,78,210,210,198,0,0,0,0,0,0,0,0,0,0,201,253,253,227,164,86,16,15,15,165,185,253,253,253,253,253,239,108,0,0,0,0,0,0,0,0,0,0,32,211,253,253,253,253,253,253,253,255,253,253,253,253,253,189,8,0,0,0,0,0,0,0,0,0,0,0,0,28,178,200,253,253,253,253,253,254,253,253,253,186,72,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,74,74,215,223,134,74,117,253,253,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,253,253,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,253,253,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,69,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,201,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,225,243,252,226,100,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,231,252,252,252,253,252,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,252,252,252,253,252,233,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,140,253,252,252,236,112,174,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,255,253,228,47,0,114,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,223,52,0,0,113,252,201,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,195,196,52,0,0,32,222,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,153,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,207,253,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,85,48,0,182,252,252,215,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,57,198,197,197,234,252,229,197,240,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,252,253,242,145,227,252,253,252,252,252,252,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,215,252,190,74,0,29,252,253,252,252,252,252,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,190,79,0,26,207,253,255,253,253,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,76,246,242,74,38,131,231,252,252,253,129,136,224,252,241,178,19,0,0,0,0,0,0,0,0,0,0,0,85,252,246,197,222,252,252,252,220,133,6,0,137,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,85,252,252,252,253,252,252,217,37,0,0,0,10,161,225,176,19,0,0,0,0,0,0,0,0,0,0,0,38,221,252,252,253,252,141,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,85,255,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,225,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,200,255,254,194,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,55,224,253,253,253,253,242,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,253,241,164,82,82,250,253,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,242,85,0,0,0,72,253,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,138,251,245,83,0,0,0,0,12,253,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,251,78,0,0,0,0,0,167,253,248,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,253,77,0,0,0,0,0,59,251,253,253,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,253,34,22,4,24,24,124,243,253,253,227,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,253,253,245,175,253,253,253,253,253,253,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,193,253,253,253,253,239,194,194,248,253,205,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,59,59,59,59,45,0,74,248,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,209,253,199,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,253,253,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,253,190,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,222,253,198,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,221,253,239,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,170,253,238,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,253,170,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,176,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,242,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,51,53,71,110,68,53,53,53,53,81,110,228,253,180,20,0,0,0,0,0,0,0,0,0,0,0,0,189,252,253,253,253,253,253,253,253,253,254,225,250,253,46,0,0,0,0,0,0,0,0,0,0,0,0,0,188,218,218,200,130,130,160,197,184,130,44,17,236,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,249,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,231,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,128,109,88,88,88,248,253,105,58,15,40,88,88,118,0,0,0,0,0,0,0,0,0,0,0,0,0,124,254,254,254,254,255,254,254,254,254,254,254,254,193,27,0,0,0,0,0,0,0,0,0,0,0,0,0,16,105,183,185,253,254,253,253,238,183,183,114,60,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,17,245,253,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,253,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,200,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,248,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,248,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,225,255,242,80,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,158,158,207,253,253,253,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,62,177,252,253,253,253,253,253,253,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,253,253,127,113,113,176,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,253,253,146,0,7,138,253,253,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,253,133,130,13,0,121,253,253,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,51,51,2,0,0,0,211,253,253,243,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,228,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,220,253,253,234,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,237,253,253,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,167,167,167,217,253,253,253,177,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,246,246,246,251,253,253,253,253,253,253,170,4,0,0,0,0,0,0,0,0,0,0,0,0,0,37,149,167,253,253,253,253,253,253,253,253,253,175,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,253,247,222,253,253,253,253,253,253,148,9,0,0,0,0,0,0,0,0,0,0,0,0,42,131,245,253,230,122,214,182,253,253,253,253,253,253,253,43,0,0,0,0,0,0,0,0,0,0,0,0,104,253,253,253,245,211,244,253,253,253,253,228,253,253,253,72,20,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,253,253,253,253,253,213,138,43,206,253,253,253,190,107,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,253,245,229,40,0,0,36,234,253,253,253,247,109,0,0,0,0,0,0,0,0,0,187,253,253,253,253,253,243,92,0,0,0,0,0,161,253,253,253,168,0,0,0,0,0,0,0,0,0,0,25,187,253,253,222,78,70,0,0,0,0,0,0,17,78,78,78,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,29,66,141,204,253,253,253,255,253,231,225,229,110,0,0,0,0,0,0,0,0,0,0,0,0,0,101,179,252,252,252,228,214,196,145,84,84,19,0,60,103,0,0,0,0,0,0,0,0,0,0,0,0,104,246,253,233,80,56,31,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,246,202,241,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,244,253,40,0,0,0,0,0,0,0,0,0,0,0,13,41,141,131,0,0,0,0,0,0,0,0,0,0,169,252,215,57,57,57,32,0,0,0,0,0,13,57,194,247,121,19,0,0,0,0,0,0,0,0,0,0,63,234,252,253,252,252,228,198,122,85,47,10,172,252,127,50,0,0,0,0,0,0,0,0,0,0,0,0,0,59,190,253,252,252,252,253,252,252,240,229,252,77,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,25,0,13,113,223,253,254,253,253,103,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,234,227,134,159,240,252,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,234,252,103,0,0,159,252,247,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,214,15,0,0,10,178,253,209,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,247,50,0,0,0,0,63,254,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,171,0,0,0,0,0,113,253,252,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,231,19,0,0,0,0,29,210,253,252,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,225,0,0,0,0,26,210,252,253,202,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,242,66,29,29,104,253,253,253,239,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,252,252,252,253,252,252,252,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,252,252,252,253,252,186,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,165,252,202,140,65,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,253,253,255,127,121,121,121,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,249,252,252,195,252,253,252,252,252,252,249,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,252,252,109,12,26,159,158,193,252,252,252,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,216,252,176,15,0,0,0,0,15,107,252,252,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,252,209,17,0,0,0,0,0,0,116,252,252,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,171,87,0,0,0,0,0,0,20,221,252,241,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,229,252,252,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,252,252,213,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,246,252,252,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,253,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,107,253,252,212,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,252,253,212,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,236,252,215,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,184,252,252,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,197,252,249,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,252,252,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,228,252,221,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,252,221,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,224,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,188,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,161,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,152,235,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,254,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,208,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,249,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,239,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,241,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,254,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,254,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,229,4,0,22,120,234,237,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,227,0,75,237,255,148,165,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,232,57,243,149,35,2,195,219,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,254,254,190,0,0,114,242,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,254,254,152,115,202,252,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,254,246,243,254,237,97,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,231,41,27,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,18,145,255,254,249,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,253,253,253,253,253,242,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,223,253,212,101,82,250,247,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,225,242,154,15,0,0,193,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,225,253,170,0,0,0,93,252,238,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,224,253,182,11,0,0,0,162,253,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,248,57,0,0,0,47,242,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,253,140,0,0,6,24,165,253,236,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,251,160,160,182,253,253,253,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,247,253,253,253,253,253,253,253,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,61,165,132,230,253,253,166,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,206,253,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,167,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,162,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,253,194,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,163,253,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,253,180,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,253,220,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,253,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,242,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,18,94,137,173,211,85,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,157,254,254,246,230,254,254,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,254,249,127,64,25,182,250,251,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,254,231,0,0,0,0,232,254,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,254,231,0,0,0,34,240,254,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,254,231,0,0,0,145,254,249,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,254,253,149,2,2,215,254,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,171,254,251,70,144,254,254,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,95,79,38,233,254,183,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,254,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,237,254,90,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,240,232,124,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,245,254,195,0,0,0,117,218,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,184,254,227,40,0,0,112,254,254,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,254,254,95,0,0,0,114,254,255,212,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,190,254,254,199,166,166,166,153,252,254,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,254,254,254,254,239,209,254,254,254,254,242,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,245,254,254,247,152,41,16,97,247,254,254,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,254,254,252,84,0,0,0,0,129,254,243,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,254,254,82,0,0,0,0,0,8,17,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,249,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,131,252,254,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,254,254,249,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,238,254,254,247,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,246,254,254,254,254,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,245,254,254,198,217,254,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,244,254,254,183,15,151,254,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,196,254,115,16,22,236,250,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,52,17,10,158,254,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,66,66,66,163,197,173,56,67,254,254,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,107,212,254,254,254,254,254,254,245,232,254,250,85,0,0,0,0,0,0,0,0,0,0,0,0,0,22,198,254,254,104,71,71,71,109,254,254,254,254,140,0,0,0,0,0,0,0,0,0,0,0,0,0,78,209,254,238,98,14,0,0,0,53,254,254,254,255,104,0,0,0,0,0,0,0,0,0,0,0,0,80,207,254,168,54,0,0,0,0,10,151,254,254,254,254,191,0,0,0,0,0,0,0,0,0,0,0,0,202,254,187,9,0,0,0,0,26,152,254,254,232,243,254,247,72,0,0,0,0,0,0,0,0,0,0,0,249,243,67,0,0,0,0,59,232,254,254,212,33,83,255,254,111,0,0,0,0,0,0,0,0,0,0,0,249,209,22,0,8,64,151,234,254,250,208,32,0,33,255,254,121,0,0,0,0,0,0,0,0,0,0,0,249,254,209,144,184,254,254,254,210,85,0,0,0,33,254,254,242,7,0,0,0,0,0,0,0,0,0,0,243,254,254,254,254,254,252,211,27,0,0,0,0,33,249,254,244,54,0,0,0,0,0,0,0,0,0,0,0,118,124,242,207,124,86,0,0,0,0,0,0,0,13,124,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,47,153,255,254,254,254,254,254,254,176,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,253,253,253,253,230,160,160,196,253,253,234,65,0,0,0,0,0,0,0,0,0,0,0,0,0,7,155,253,253,209,114,22,8,0,0,4,10,46,245,251,82,0,0,0,0,0,0,0,0,0,0,0,0,47,253,242,94,6,0,0,0,0,0,0,0,0,239,253,129,0,0,0,0,0,0,0,0,0,0,0,0,47,253,174,0,0,0,0,0,0,0,0,0,0,196,253,129,0,0,0,0,0,0,0,0,0,0,0,0,15,116,170,28,0,0,0,0,0,0,0,0,0,239,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,246,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,232,253,234,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,6,46,234,253,253,134,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,198,253,253,253,253,253,253,205,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,236,253,253,253,253,219,248,253,253,240,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,99,212,212,129,6,3,4,37,179,253,243,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,225,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,230,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,193,122,0,0,0,0,3,96,231,253,248,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,210,228,24,0,0,0,52,175,253,253,235,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,179,115,155,218,245,253,253,240,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,187,253,253,253,253,253,253,223,123,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,72,152,253,213,149,114,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,191,0,255,255,255,191,128,0,0,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,128,255,191,0,0,0,64,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,0,0,0,0,0,0,64,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,64,0,0,0,0,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,0,0,0,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,64,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,128,0,0,191,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,64,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,0,0,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,255,254,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,183,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,232,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,228,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,228,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,226,253,195,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,218,253,228,117,14,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,219,253,253,253,211,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,123,149,230,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,238,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,252,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,135,253,252,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,252,253,242,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,215,252,204,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,200,252,230,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,252,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,252,220,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,255,253,56,0,0,0,0,0,0,63,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,252,253,176,6,0,0,0,0,0,26,240,241,178,19,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,58,0,0,0,0,0,76,203,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,38,224,252,178,9,0,0,0,76,169,234,252,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,140,0,0,0,0,191,252,220,112,189,253,204,25,0,0,0,0,0,0,0,0,0,0,0,0,198,253,253,141,0,0,29,253,255,253,56,29,253,255,106,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,178,9,19,181,252,253,204,91,181,252,152,3,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,252,253,203,209,252,252,253,252,252,245,195,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,180,252,253,252,252,252,252,253,252,245,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,189,253,252,252,252,252,253,127,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,144,196,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,198,58,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,251,164,90,64,15,15,16,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,240,209,245,253,253,253,254,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,246,178,0,25,30,87,104,74,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,248,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,243,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,230,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,54,0,0,31,75,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,255,214,250,254,254,255,254,254,183,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,196,254,253,192,106,45,45,45,120,239,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,238,155,50,1,0,0,0,0,0,80,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,211,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,254,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,104,7,0,0,0,0,0,8,139,251,159,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,253,56,0,0,1,29,90,197,245,116,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,212,196,120,181,197,253,253,178,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,214,254,253,182,165,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,203,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,240,240,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,234,252,242,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,207,252,252,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,203,253,252,220,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,255,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,181,252,253,176,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,252,252,228,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,203,252,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,178,252,252,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,253,253,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,252,252,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,135,253,252,176,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,189,253,204,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,254,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,254,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,254,179,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,246,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,253,255,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,246,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,105,254,254,224,59,59,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,254,253,253,253,253,253,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,235,254,253,253,253,253,253,247,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,101,244,253,254,234,241,253,253,253,253,186,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,253,253,253,232,83,109,170,253,253,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,253,196,0,0,40,253,253,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,8,141,247,253,253,237,29,0,0,6,38,171,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,13,146,253,253,253,253,57,0,0,0,0,0,156,253,253,116,0,0,0,0,0,0,0,0,0,0,0,0,40,253,253,253,253,178,27,0,0,0,0,0,156,253,253,116,0,0,0,0,0,0,0,0,0,0,0,136,204,253,253,253,192,27,0,0,0,0,0,0,156,253,253,116,0,0,0,0,0,0,0,0,0,0,28,195,254,254,254,250,135,0,0,0,0,0,0,99,255,254,254,117,0,0,0,0,0,0,0,0,0,0,118,253,253,253,253,142,0,0,0,0,0,0,19,170,253,253,216,62,0,0,0,0,0,0,0,0,0,42,212,253,253,253,253,38,0,0,0,0,0,124,188,253,253,253,174,0,0,0,0,0,0,0,0,0,0,59,253,253,253,237,93,3,0,0,31,40,130,247,253,253,253,204,13,0,0,0,0,0,0,0,0,0,0,59,253,253,253,154,0,0,0,54,218,254,253,253,253,253,253,38,0,0,0,0,0,0,0,0,0,0,0,59,253,253,253,215,156,156,156,209,253,255,253,253,253,192,97,15,0,0,0,0,0,0,0,0,0,0,0,55,242,253,253,253,253,253,253,253,253,254,253,253,204,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,253,253,253,253,253,253,254,216,174,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,116,243,253,253,253,253,253,146,117,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,132,253,253,192,57,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,113,207,253,255,253,143,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,219,252,252,252,253,252,252,234,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,252,239,180,55,196,214,252,252,252,57,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,176,65,0,0,0,28,199,252,252,253,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,205,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,255,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,106,253,252,246,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,249,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,0,0,225,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,191,255,168,0,0,0,0,163,253,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,252,253,243,50,0,0,0,85,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,252,55,0,0,0,85,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,239,253,252,187,56,0,0,178,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,252,177,63,0,225,252,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,253,253,253,253,176,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,253,252,252,252,252,253,252,252,84,0,0,29,66,57,85,0,0,0,0,0,0,0,0,0,0,0,0,0,196,246,252,252,252,253,252,252,215,197,198,215,239,234,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,252,252,252,225,249,252,252,252,253,252,245,208,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,112,112,112,0,100,112,112,112,112,112,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,246,231,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,159,252,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,179,253,253,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,252,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,252,186,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,175,253,227,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,154,253,251,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,252,252,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,197,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,252,252,102,0,0,0,0,13,188,187,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,206,13,0,0,10,79,254,253,253,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,252,168,0,0,0,85,252,253,227,252,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,168,0,0,0,172,252,194,162,252,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,252,205,13,0,101,246,252,138,243,214,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,244,253,253,141,216,253,253,254,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,240,252,253,252,252,252,253,189,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,168,168,224,252,252,106,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,153,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,102,0,0,0,0,0,0,163,233,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,204,235,0,0,0,0,0,0,163,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,254,209,0,0,0,0,0,27,255,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,245,232,30,0,0,0,0,0,175,254,150,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,241,253,158,0,0,0,0,0,10,217,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,193,254,203,8,0,0,7,0,0,97,253,190,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,254,192,155,98,181,207,181,181,238,253,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,254,254,255,254,254,254,254,182,223,254,254,254,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,233,199,146,108,69,18,0,10,220,253,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,120,23,0,0,0,0,0,0,47,248,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,199,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,253,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,254,230,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,253,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,254,229,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,25,25,25,25,25,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,4,126,253,253,253,253,253,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,250,178,253,253,253,253,253,211,226,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,250,246,176,245,169,72,72,72,10,31,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,248,253,207,93,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,247,253,253,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,207,253,253,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,253,242,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,52,178,253,253,254,242,225,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,191,250,255,138,3,0,0,0,0,0,0,0,0,0,0,0,0,2,22,0,0,0,0,0,0,0,0,0,0,89,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,30,244,60,0,0,0,0,0,0,0,0,0,37,253,253,163,0,0,0,0,0,0,0,0,0,0,0,0,156,242,51,0,0,0,0,0,0,0,0,28,136,253,242,49,0,0,0,0,0,0,0,0,0,0,0,0,254,253,191,50,0,0,0,0,0,0,3,171,253,242,89,0,0,0,0,0,0,0,0,0,0,0,0,0,66,222,253,242,194,102,73,73,73,73,198,253,243,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,180,253,253,253,253,253,253,253,254,245,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,59,156,156,156,156,156,156,151,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,31,130,222,255,255,154,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,101,253,244,241,241,244,253,213,136,84,0,0,0,0,0,0,0,0,0,0,0,0,0,1,19,92,145,200,19,111,33,0,0,33,217,253,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,12,242,241,81,55,5,8,0,0,0,0,81,253,241,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,253,191,172,95,16,0,0,0,97,253,118,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,93,168,221,253,235,101,38,9,66,236,253,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,108,218,150,253,188,174,239,167,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,119,253,253,253,228,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,253,253,253,253,185,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,50,139,158,191,191,241,253,196,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,147,221,149,30,0,0,0,89,242,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,205,253,173,0,0,0,0,0,0,114,253,154,120,14,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,183,17,0,0,0,0,0,0,17,224,185,237,18,0,0,0,0,0,0,0,0,0,0,0,0,16,236,227,16,0,0,0,0,0,0,0,0,217,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,65,253,176,0,0,0,0,0,0,0,0,0,171,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,143,253,220,37,0,0,0,0,0,0,0,0,142,253,253,33,0,0,0,0,0,0,0,0,0,0,0,0,92,253,253,220,88,0,0,0,0,0,34,209,250,253,157,11,0,0,0,0,0,0,0,0,0,0,0,0,2,102,185,158,250,150,112,112,112,148,241,253,212,196,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,20,155,253,253,253,253,253,216,135,25,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,30,129,129,129,129,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,170,255,148,240,203,130,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,43,136,228,253,253,253,247,253,253,253,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,253,253,248,235,131,111,57,111,243,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,228,134,74,0,0,0,0,0,236,253,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,247,195,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,87,245,253,236,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,253,253,234,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,174,242,253,208,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,93,239,253,233,148,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,93,237,253,253,253,229,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,202,253,253,253,253,253,229,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,55,55,55,55,128,253,204,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,239,253,172,6,0,0,0,0,0,0,0,0,0,45,154,195,0,0,0,0,0,0,0,0,0,0,0,48,239,253,196,6,0,0,0,0,0,0,0,0,0,176,249,148,0,0,0,0,0,0,0,0,0,0,0,139,253,214,29,0,0,0,0,0,0,0,0,0,0,194,252,158,0,0,0,0,0,0,0,0,0,32,142,249,214,90,0,0,0,0,0,0,0,0,0,0,0,30,253,240,146,0,0,0,0,0,0,0,0,132,253,253,203,12,0,0,0,0,0,0,0,0,0,0,0,1,144,253,252,236,140,20,36,55,28,112,148,250,253,212,26,0,0,0,0,0,0,0,0,0,0,0,0,0,7,91,253,253,252,244,246,248,245,253,253,253,155,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,18,129,147,253,253,253,253,253,217,90,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,232,254,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,253,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,253,253,200,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,223,253,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,253,253,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,253,200,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,213,253,253,152,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,221,253,253,153,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,215,253,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,36,36,36,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,115,220,254,254,254,183,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,0,146,254,254,254,254,254,254,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,183,115,0,190,254,254,196,80,47,47,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,109,0,63,29,29,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,139,251,253,63,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,137,254,254,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,253,254,254,161,42,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,195,205,255,254,226,126,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,59,150,177,248,192,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,253,250,75,0,0,0,0,0,0,0,0,0,0,0,0,125,199,0,0,0,0,0,0,0,0,0,0,0,250,254,141,0,0,0,0,0,0,0,0,0,0,0,0,198,220,10,0,0,0,0,0,0,0,0,0,59,252,254,146,0,0,0,0,0,0,0,0,0,0,0,0,242,254,232,116,20,0,0,0,0,0,0,26,185,254,237,37,0,0,0,0,0,0,0,0,0,0,0,0,56,214,254,254,224,166,53,48,48,48,48,222,254,247,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,71,159,243,254,254,254,254,254,254,254,225,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,53,166,218,254,254,229,171,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,35,35,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,229,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,254,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,252,254,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,254,206,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,254,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,218,233,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,244,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,255,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,254,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,241,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,254,194,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,219,254,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,223,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,50,131,241,204,77,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,232,254,250,253,254,254,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,231,249,193,71,99,171,254,12,0,0,0,0,0,0,0,0,0,0,2,24,0,0,0,0,0,0,111,229,247,96,0,0,0,119,254,12,0,0,0,0,0,0,0,0,0,0,11,216,52,0,0,0,7,121,228,246,97,0,0,0,13,234,254,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,254,254,167,0,0,0,0,179,254,199,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,254,213,21,0,0,0,17,230,254,254,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,254,131,0,0,0,18,126,254,255,232,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,254,236,147,57,97,206,254,254,231,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,236,254,254,254,254,254,254,254,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,153,186,186,208,254,254,228,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,254,254,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,245,254,179,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,245,254,224,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,198,254,225,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,133,248,254,134,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,254,254,224,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,254,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,227,39,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,254,254,254,175,106,105,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,253,253,246,225,253,253,227,211,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,89,221,210,48,141,241,253,254,232,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,204,254,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,254,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,254,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,254,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,186,255,196,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,229,253,254,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,254,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,139,251,253,217,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,253,253,250,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,253,253,137,0,0,0,0,0,0,0,0,0,93,49,0,0,0,0,0,0,0,0,0,0,0,0,199,245,253,173,7,0,32,75,172,224,224,224,224,224,246,192,0,0,0,0,0,0,0,0,0,0,20,102,245,253,173,130,179,179,211,253,253,253,253,249,223,82,74,31,0,0,0,0,0,0,0,0,0,112,212,253,253,253,253,253,253,253,254,253,253,253,133,105,0,0,0,0,0,0,0,0,0,0,0,0,100,251,253,253,253,253,253,253,253,253,164,40,14,14,2,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,253,253,253,253,229,208,94,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,227,155,174,209,104,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,116,0,0,0,0,84,125,205,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,252,248,218,185,208,251,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,253,253,253,253,253,253,253,253,253,234,0,0,0,0,0,0,0,0,0,0,0,0,0,104,138,212,251,253,127,19,19,86,19,38,210,253,242,71,0,0,0,0,0,0,0,0,0,0,0,0,0,112,243,251,218,45,5,0,0,0,0,163,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,152,112,21,0,0,0,0,0,94,244,253,225,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,243,253,240,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,240,253,180,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,103,240,253,240,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,253,240,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,181,253,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,253,184,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,241,253,242,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,179,253,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,245,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,253,253,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,230,253,249,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,253,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,219,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,222,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,196,6,0,0,0,93,166,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,254,118,0,0,0,0,185,253,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,211,18,0,0,0,16,230,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,225,39,0,0,0,100,253,61,0,0,0,13,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,236,223,136,113,137,214,253,98,137,148,215,148,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,133,217,253,254,253,211,199,169,97,31,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,254,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,247,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,255,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,251,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,234,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,225,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,86,0,0,0,0,0,198,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,170,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,141,0,0,0,0,114,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,255,255,57,0,0,0,0,226,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,114,0,0,0,0,114,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,226,0,0,0,0,0,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,198,255,255,57,0,0,0,0,141,255,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,198,114,0,0,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,141,29,114,198,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,198,255,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,255,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,180,201,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,155,252,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,252,252,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,236,252,252,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,252,252,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,255,249,184,253,253,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,244,253,185,70,252,252,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,252,247,67,70,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,244,252,94,0,70,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,246,252,200,0,0,174,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,253,203,11,0,0,123,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,212,252,252,87,0,0,0,70,252,252,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,252,221,25,0,0,0,70,252,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,248,253,252,252,215,207,208,207,220,252,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,253,252,252,252,252,253,252,252,252,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,116,116,199,230,230,231,157,206,253,253,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,244,252,234,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,234,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,242,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,191,128,255,191,128,0,64,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,191,0,0,0,0,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,191,128,255,191,0,0,0,64,191,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,128,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,0,0,0,0,191,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,191,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,191,0,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,191,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,64,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,150,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,206,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,255,253,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,251,188,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,246,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,170,251,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,251,251,253,251,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,253,253,255,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,236,251,251,253,168,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,190,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,221,251,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,40,70,84,40,62,92,40,40,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,209,253,253,253,253,254,253,253,253,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,241,113,98,98,98,99,98,98,98,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,50,228,237,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,223,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,253,253,238,137,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,185,170,253,254,248,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,230,254,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,192,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,130,24,0,0,0,0,0,0,0,41,241,253,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,253,172,84,24,0,0,0,7,115,239,250,79,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,103,223,253,230,196,195,195,204,253,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,195,255,254,254,254,231,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,39,39,39,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,95,51,40,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,107,185,206,222,166,156,156,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,125,224,137,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,179,139,21,0,0,8,20,42,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,221,14,61,141,175,129,111,56,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,10,128,255,218,106,52,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,164,234,152,159,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,208,212,110,12,0,49,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,202,53,3,0,0,0,110,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,136,182,10,0,0,0,0,62,225,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,192,10,0,0,0,4,97,193,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,62,0,0,13,80,218,164,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,194,140,140,218,188,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,102,61,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,198,255,255,231,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,25,232,224,177,229,245,227,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,194,253,57,0,0,0,170,253,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,84,238,253,209,9,0,0,0,89,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,253,253,184,7,0,0,0,0,135,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,229,54,0,0,0,7,91,234,236,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,71,0,0,0,45,102,253,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,225,218,218,218,238,253,253,253,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,253,253,253,149,150,253,253,232,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,46,132,86,11,1,71,253,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,253,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,255,251,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,244,254,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,195,253,252,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,253,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,228,253,218,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,253,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,132,247,253,211,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,253,253,211,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,213,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,66,138,255,253,253,253,201,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,228,252,252,228,236,252,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,252,252,136,32,44,69,69,69,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,194,252,134,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,252,189,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,137,24,24,24,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,252,252,253,236,78,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,253,252,233,183,215,222,252,252,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,87,33,0,21,25,135,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,252,202,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,170,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,252,252,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,252,233,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,233,252,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,253,210,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,160,253,179,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,155,252,231,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,228,252,227,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,233,252,195,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,137,117,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,222,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,219,252,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,222,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,215,253,252,198,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,215,252,253,204,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,246,252,252,27,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,200,252,252,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,252,217,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,191,255,253,133,0,0,0,0,0,169,253,192,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,252,253,176,6,0,0,0,76,117,243,252,253,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,136,0,0,0,120,246,252,252,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,7,178,252,253,27,0,4,107,253,252,245,129,177,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,27,0,107,252,253,252,118,16,203,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,255,27,57,253,253,255,253,253,253,253,255,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,181,200,252,252,253,252,252,252,252,27,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,227,253,252,252,252,252,253,252,239,180,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,252,252,252,252,253,195,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,189,221,252,252,112,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,215,254,255,254,254,254,254,254,254,254,254,254,254,238,23,0,0,0,0,0,0,0,0,0,0,0,0,10,135,148,148,148,179,229,217,174,148,148,252,254,251,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,252,233,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,252,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,252,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,202,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,254,152,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,231,205,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,254,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,234,221,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,254,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,121,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,137,237,203,131,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,111,225,254,254,254,254,243,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,218,254,217,165,83,190,253,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,217,254,190,20,0,0,0,128,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,254,246,62,0,0,0,0,54,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,251,252,79,0,0,0,0,101,241,228,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,254,249,0,0,0,0,50,238,254,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,254,252,142,68,108,142,237,254,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,217,254,254,254,254,254,254,254,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,134,195,121,119,254,255,175,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,242,254,130,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,202,254,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,91,254,252,116,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,254,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,254,247,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,254,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,254,197,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,252,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,67,228,254,255,226,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,132,172,253,253,253,253,253,203,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,198,228,253,253,253,246,253,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,214,253,253,253,227,177,46,205,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,199,253,253,253,136,75,0,0,95,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,253,253,253,201,19,19,19,107,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,253,253,253,253,253,253,253,253,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,180,253,253,253,253,253,253,253,253,253,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,224,224,224,224,224,203,107,242,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,253,190,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,201,253,253,228,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,253,253,186,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,253,253,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,225,253,253,253,108,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,215,253,253,253,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,253,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,236,253,253,251,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,253,253,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,148,253,70,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,29,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,172,252,231,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,181,252,252,253,215,197,197,198,172,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,226,243,252,252,253,252,252,252,253,252,243,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,253,255,247,225,125,101,0,0,0,16,216,253,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,252,241,84,0,0,0,0,0,0,29,252,252,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,106,56,19,0,0,0,0,0,89,204,252,186,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,237,253,227,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,29,154,253,253,228,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,70,169,234,252,253,252,121,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,252,252,252,253,252,122,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,177,139,90,40,215,252,128,0,0,0,0,0,0,0,0,0,0,0,0,16,141,44,0,0,0,0,0,0,0,0,0,0,170,253,140,0,0,0,0,0,0,0,0,0,0,0,0,104,252,168,0,0,0,0,0,0,0,0,0,0,169,252,115,0,0,0,0,0,0,0,0,0,0,0,0,229,252,80,0,0,0,0,0,0,0,0,0,147,234,148,6,0,0,0,0,0,0,0,0,0,0,0,0,203,252,193,13,0,0,0,0,0,0,0,151,253,252,56,0,0,0,0,0,0,0,0,0,0,0,0,0,13,188,247,253,141,141,53,29,13,45,178,253,254,159,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,221,253,252,252,252,207,225,252,252,134,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,119,168,234,252,253,252,186,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,28,28,28,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,24,17,19,13,0,0,0,0,0,0,0,0,9,13,24,45,138,138,13,0,0,0,0,0,0,0,0,159,252,227,236,211,162,161,161,109,161,151,120,161,194,211,253,252,252,252,96,0,0,0,0,0,0,0,0,253,252,252,252,252,253,252,252,252,252,253,252,252,252,252,253,252,252,252,168,0,0,0,0,0,0,0,0,253,252,252,252,252,253,252,252,252,252,253,252,252,252,252,253,252,252,252,157,0,0,0,0,0,0,0,0,148,252,252,252,252,253,252,252,252,252,253,252,252,252,252,253,252,252,252,137,0,0,0,0,0,0,0,0,0,74,116,63,168,231,230,230,178,230,179,230,199,229,253,255,253,253,245,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,215,252,253,252,252,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,252,252,253,252,170,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,188,252,252,253,235,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,252,252,252,190,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,253,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,219,252,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,252,221,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,252,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,252,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,253,253,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,252,252,252,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,252,195,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,202,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,254,254,254,148,24,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,254,252,252,252,252,252,121,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,237,254,252,252,252,252,252,252,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,224,252,254,252,252,252,252,252,252,135,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,216,252,252,254,231,168,252,252,252,252,252,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,212,252,252,252,242,93,32,114,177,252,252,252,158,12,0,0,0,0,0,0,0,0,0,0,0,0,75,212,252,252,252,252,231,0,0,0,116,252,252,252,252,21,0,0,0,0,0,0,0,0,0,0,0,69,216,252,252,252,252,252,62,0,0,0,116,252,252,252,252,21,0,0,0,0,0,0,0,0,0,0,0,93,252,252,252,252,252,62,0,0,0,0,21,158,252,252,252,21,0,0,0,0,0,0,0,0,0,0,64,239,252,252,252,252,252,21,0,0,0,0,0,139,252,252,252,21,0,0,0,0,0,0,0,0,0,5,87,254,254,254,254,237,41,0,0,0,0,0,11,150,254,254,254,22,0,0,0,0,0,0,0,0,5,85,252,252,252,252,222,55,0,0,0,0,0,0,116,252,252,252,214,18,0,0,0,0,0,0,0,0,24,252,252,252,252,252,91,0,0,0,0,0,0,26,153,252,252,252,45,0,0,0,0,0,0,0,0,0,24,252,252,252,252,252,91,0,0,0,0,18,93,151,252,252,252,184,28,0,0,0,0,0,0,0,0,0,24,252,252,252,252,252,164,116,116,116,117,141,252,252,252,252,252,68,0,0,0,0,0,0,0,0,0,0,24,252,252,252,252,252,252,252,252,252,254,252,252,252,252,252,163,31,0,0,0,0,0,0,0,0,0,0,9,121,252,252,252,252,252,252,252,252,254,252,252,252,178,91,33,0,0,0,0,0,0,0,0,0,0,0,0,13,119,252,252,252,252,252,252,252,254,252,252,184,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,121,252,252,252,252,252,252,254,214,45,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,21,21,169,252,252,41,22,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,179,254,255,237,115,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,234,253,253,253,253,253,188,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,249,253,221,50,10,128,245,253,140,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,174,253,173,11,0,0,0,87,249,253,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,253,239,7,0,0,0,0,0,239,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,165,0,0,0,0,0,92,249,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,140,0,0,0,7,135,246,253,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,242,22,0,0,99,253,253,253,253,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,144,253,227,82,70,208,253,252,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,192,253,253,253,253,169,128,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,51,140,193,115,1,128,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,132,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,244,253,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,253,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,253,253,255,149,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,144,236,251,251,253,251,236,144,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,251,251,251,225,253,251,251,251,251,166,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,251,251,204,41,143,205,251,251,251,253,169,15,0,0,0,0,0,0,0,0,0,0,0,0,0,79,231,253,251,225,41,0,0,41,226,251,251,253,251,164,0,0,0,0,0,0,0,0,0,0,0,0,37,253,253,255,253,35,0,0,0,0,0,79,232,255,253,227,42,0,0,0,0,0,0,0,0,0,0,0,140,251,251,253,168,15,0,0,0,0,0,0,77,253,251,251,142,0,0,0,0,0,0,0,0,0,0,21,221,251,251,164,15,0,0,0,0,0,0,0,0,227,251,251,236,61,0,0,0,0,0,0,0,0,32,190,251,251,251,0,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,73,251,251,251,251,0,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,73,253,253,253,201,0,0,0,0,0,0,0,0,0,0,73,253,253,253,72,0,0,0,0,0,0,0,0,176,251,251,251,71,0,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,253,251,251,157,10,0,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,150,251,251,204,41,0,0,0,0,0,0,0,0,124,251,251,220,180,0,0,0,0,0,0,0,0,0,130,253,251,225,41,0,0,0,0,0,0,0,0,0,73,253,253,253,253,73,73,10,0,0,0,42,73,150,253,255,253,216,0,0,0,0,0,0,0,0,0,0,31,189,251,251,251,253,251,159,144,144,145,206,251,251,251,253,168,92,0,0,0,0,0,0,0,0,0,0,0,20,195,251,251,253,251,251,251,251,253,251,251,251,225,164,15,0,0,0,0,0,0,0,0,0,0,0,0,0,21,142,220,253,251,251,251,251,253,251,251,204,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,72,174,251,251,251,253,147,71,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,93,212,175,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,151,254,250,249,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,254,227,130,237,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,224,71,1,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,214,250,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,254,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,237,237,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,254,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,246,241,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,254,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,214,254,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,218,14,0,0,5,78,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,254,113,81,140,231,237,254,251,232,113,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,254,224,245,245,153,71,53,69,189,254,141,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,254,164,80,0,0,0,0,0,7,230,254,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,245,254,9,0,0,0,0,0,0,2,145,255,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,254,11,0,0,0,0,0,1,125,254,184,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,130,0,0,0,0,21,136,254,182,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,205,249,146,63,126,172,235,249,140,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,155,238,254,254,212,129,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,210,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,209,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,254,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,88,235,254,121,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,253,253,223,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,229,253,225,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,187,253,251,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,145,253,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,253,253,238,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,253,253,155,0,0,0,0,50,134,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,254,235,49,0,0,0,52,241,254,254,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,251,253,156,0,0,0,0,235,253,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,253,80,0,0,50,158,252,253,203,253,219,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,253,80,0,5,172,254,253,61,19,209,253,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,225,38,0,14,253,254,225,19,64,242,211,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,253,80,0,113,253,254,47,70,208,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,245,253,177,41,94,253,255,178,203,253,243,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,253,253,253,253,253,255,253,253,245,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,134,249,253,253,253,255,253,248,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,133,246,190,121,120,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,39,135,147,193,147,170,216,92,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,79,197,254,254,254,228,243,227,254,254,183,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,249,230,60,32,32,21,28,21,32,88,214,242,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,207,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,248,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,254,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,237,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,227,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,157,168,131,57,0,0,0,86,254,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,222,254,254,254,251,207,167,108,238,133,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,207,254,35,10,48,126,227,249,254,254,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,254,171,9,0,0,0,0,201,254,255,182,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,237,39,0,0,0,7,127,246,201,220,254,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,216,9,0,0,12,140,254,189,9,29,155,253,102,6,14,0,0,0,0,0,0,0,0,0,0,0,0,115,254,163,71,138,205,250,115,16,0,0,0,138,254,148,200,33,0,0,0,0,0,0,0,0,0,0,0,19,211,254,254,234,109,35,0,0,0,0,0,16,220,254,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,254,255,254,191,254,254,254,210,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,253,253,253,106,157,204,253,253,248,211,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,40,40,40,14,0,20,40,184,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,225,253,253,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,82,193,253,250,217,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,200,253,253,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,147,248,251,253,253,208,24,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,250,253,253,253,253,186,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,253,253,253,253,253,253,152,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,68,68,68,68,147,253,253,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,169,253,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,187,253,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,25,0,0,0,0,0,0,0,12,182,253,253,34,0,0,0,0,0,0,0,0,0,0,0,0,0,84,248,180,0,0,0,0,0,0,0,73,253,253,163,5,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,241,98,0,0,0,0,0,146,234,253,223,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,225,253,243,179,179,45,91,179,233,253,252,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,204,253,253,253,253,253,253,253,251,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,134,253,253,253,253,253,227,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,109,227,223,155,178,211,80,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,207,229,85,0,0,0,29,214,141,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,217,244,37,0,0,0,0,0,15,183,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,254,86,0,0,0,0,0,0,0,26,221,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,238,204,0,0,0,0,0,0,0,0,0,170,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,247,97,0,0,0,0,0,0,0,0,0,170,249,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,85,0,0,0,0,0,0,0,0,29,245,254,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,118,0,0,0,0,0,0,0,82,246,254,254,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,228,14,0,0,0,0,0,0,35,236,254,254,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,227,202,47,0,0,0,0,62,203,210,229,231,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,148,252,180,101,101,125,247,157,10,248,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,156,208,222,208,80,0,34,251,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,70,254,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,255,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,254,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,254,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,254,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,209,248,88,78,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,170,249,225,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,96,96,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,171,228,253,251,220,51,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,251,251,253,251,251,251,251,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,182,236,251,211,189,236,251,251,251,242,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,194,251,251,211,35,0,71,173,251,251,253,240,158,19,0,0,0,0,0,0,0,0,0,0,0,0,64,253,255,253,205,19,0,0,0,0,40,218,255,253,253,91,0,0,0,0,0,0,0,0,0,0,0,16,186,251,253,247,110,0,0,0,0,0,0,39,233,251,251,188,0,0,0,0,0,0,0,0,0,0,16,189,251,251,205,110,0,0,0,0,0,0,0,0,48,220,251,220,48,0,0,0,0,0,0,0,0,0,72,251,251,251,158,0,0,0,0,0,0,0,0,0,0,51,251,251,232,0,0,0,0,0,0,0,0,0,190,251,251,251,59,0,0,0,0,0,0,0,0,0,0,32,251,251,251,0,0,0,0,0,0,0,0,96,253,253,253,95,0,0,0,0,0,0,0,0,0,0,0,32,253,253,193,0,0,0,0,0,0,0,0,214,251,251,204,23,0,0,0,0,0,0,0,0,0,0,0,52,251,251,94,0,0,0,0,0,0,0,0,253,251,251,109,0,0,0,0,0,0,0,0,0,0,0,48,221,251,219,47,0,0,0,0,0,0,0,0,253,251,251,70,0,0,0,0,0,0,0,0,0,0,0,234,251,251,188,0,0,0,0,0,0,0,0,0,253,251,251,188,0,0,0,0,0,0,0,0,0,40,158,253,251,172,70,0,0,0,0,0,0,0,0,0,0,191,253,253,253,96,24,0,0,0,0,12,174,253,253,255,221,0,0,0,0,0,0,0,0,0,0,0,0,71,251,251,251,253,205,190,190,190,191,197,251,251,231,221,93,0,0,0,0,0,0,0,0,0,0,0,0,16,126,236,251,253,251,251,251,251,253,251,251,140,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,188,189,188,188,188,188,189,188,109,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,81,244,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,254,239,132,215,155,71,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,226,254,254,237,232,254,254,187,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,229,252,151,67,15,2,95,251,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,229,254,105,0,0,0,0,0,185,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,229,254,102,1,0,0,0,0,0,157,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,251,232,105,1,0,0,0,0,0,0,240,254,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,102,43,0,0,0,0,0,0,0,0,246,226,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,247,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,125,254,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,254,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,254,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,199,205,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,214,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,6,6,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,44,148,152,194,241,146,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,137,205,254,254,254,254,244,173,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,120,215,254,254,213,135,61,27,23,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,155,254,254,229,180,97,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,88,191,254,199,82,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,207,254,254,218,40,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,242,208,254,254,208,137,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,8,54,139,209,254,211,8,0,0,0,0,0,0,0,0,0,0,0,0,0,13,6,0,0,0,0,0,0,0,0,0,8,93,234,228,42,0,0,0,0,0,0,0,0,0,0,0,0,172,192,94,0,0,0,0,0,0,0,0,0,35,234,254,128,0,0,0,0,0,0,0,0,0,0,0,0,80,254,233,207,126,11,0,0,0,0,0,0,35,234,244,97,0,0,0,0,0,0,0,0,0,0,0,0,2,89,167,244,254,246,177,99,28,28,28,93,247,254,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,162,248,254,254,254,255,254,254,255,159,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,64,151,158,254,254,157,80,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,45,170,46,0,0,0,0,9,128,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,252,252,45,0,0,0,0,166,252,239,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,45,0,0,0,51,240,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,45,0,0,0,164,252,252,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,252,252,45,0,0,0,184,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,46,0,0,0,185,253,253,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,253,252,252,45,0,0,0,184,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,252,202,13,0,0,34,234,252,252,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,252,89,0,0,0,47,252,252,252,249,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,252,236,135,116,116,140,252,252,252,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,243,255,253,253,253,253,255,253,253,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,252,253,252,252,252,252,253,252,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,173,122,69,69,69,69,69,154,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,252,252,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,252,252,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,168,96,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,118,70,0,0,0,0,0,0,0,0,0,0,0,0,0,53,0,0,0,0,0,0,0,0,0,0,0,7,254,247,235,235,137,37,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,63,21,0,5,216,254,230,197,254,218,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,243,210,68,0,30,61,42,15,167,254,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,254,108,0,0,0,0,43,186,254,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,254,227,0,0,0,58,177,254,253,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,230,254,227,0,65,131,238,254,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,254,254,249,252,254,254,227,47,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,254,254,254,254,169,164,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,119,220,254,254,254,153,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,187,253,254,254,254,254,254,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,47,219,254,254,245,115,210,255,250,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,254,254,254,187,71,0,187,254,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,254,248,130,3,0,34,220,254,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,218,254,110,0,0,0,126,254,243,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,254,254,103,0,0,79,248,254,227,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,240,254,139,63,123,220,254,243,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,254,254,254,254,254,254,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,115,234,234,234,185,96,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,202,255,253,253,175,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,144,190,251,253,251,251,251,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,37,166,218,236,251,251,251,253,251,251,251,251,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,251,251,253,251,251,251,251,253,251,251,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,105,241,251,251,253,251,251,251,122,72,71,71,148,251,180,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,253,253,202,253,253,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,189,251,251,251,31,189,251,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,236,251,251,96,0,124,246,142,0,0,0,0,0,0,0,21,166,21,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,217,142,0,0,0,0,0,0,32,190,251,142,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,217,142,0,0,0,0,0,0,73,251,251,142,0,0,0,0,0,0,0,0,0,73,253,253,253,72,0,0,156,103,0,0,0,0,0,0,73,253,253,253,72,0,0,0,0,0,0,0,0,73,251,251,251,174,0,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,73,251,251,251,251,0,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,42,205,251,251,251,79,0,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,0,41,226,251,251,232,77,0,0,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,0,0,166,253,253,255,253,227,73,21,0,0,0,0,0,125,253,253,143,0,0,0,0,0,0,0,0,0,0,0,16,169,251,253,251,251,251,174,105,0,0,63,144,253,251,251,142,0,0,0,0,0,0,0,0,0,0,0,0,15,35,253,251,251,251,251,243,217,217,231,251,253,251,220,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,142,236,251,251,253,251,251,251,251,253,251,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,71,200,253,251,251,251,251,201,71,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,191,255,253,137,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,236,252,207,236,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,142,234,227,130,0,44,202,227,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,252,227,50,0,0,0,90,252,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,252,79,0,0,0,0,70,252,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,253,69,0,0,0,0,81,253,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,232,252,102,9,0,47,47,228,252,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,252,252,196,184,253,221,252,227,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,67,160,194,168,211,252,252,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,2,86,252,221,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,253,244,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,248,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,252,243,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,233,253,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,197,252,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,252,252,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,252,176,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,252,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,243,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,215,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,194,252,90,0,0,0,0,0,0,89,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,253,244,25,0,0,0,0,4,128,244,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,252,93,0,0,0,0,0,104,252,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,252,56,0,0,0,0,0,229,233,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,253,202,6,0,0,0,0,101,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,184,0,0,0,0,0,126,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,84,0,0,0,0,19,231,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,171,0,0,0,0,123,252,187,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,253,221,25,0,0,0,197,252,126,113,200,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,253,216,91,29,29,204,253,254,247,137,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,234,252,252,253,252,252,252,184,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,94,168,178,252,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,178,252,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,253,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,187,252,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,224,252,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,252,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,170,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,227,252,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,253,252,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,236,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,206,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,255,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,242,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,252,252,154,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,237,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,155,253,252,179,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,150,252,253,200,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,253,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,233,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,149,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,252,252,246,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,169,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,116,137,251,178,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,229,254,254,254,254,219,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,169,83,86,231,254,169,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,121,12,0,0,110,254,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,136,254,240,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,254,254,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,124,254,250,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,222,246,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,175,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,255,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,254,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,88,131,226,206,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,230,255,254,170,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,182,254,254,174,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,182,224,254,213,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,28,237,254,248,180,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,203,254,254,246,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,45,254,254,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,121,6,109,162,253,154,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,184,246,253,240,251,252,252,252,222,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,243,252,252,209,103,26,138,183,252,252,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,240,252,248,172,92,0,0,0,11,196,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,252,252,242,32,0,0,0,0,18,204,241,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,165,252,252,217,0,0,0,88,204,252,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,188,252,252,22,17,160,240,252,194,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,252,209,199,252,243,190,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,252,252,253,252,240,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,252,252,253,252,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,141,253,253,253,255,253,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,249,252,252,252,252,253,252,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,135,247,252,252,109,38,252,253,252,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,252,252,235,151,15,10,214,253,252,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,252,252,163,0,0,0,133,253,252,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,252,202,17,0,0,10,221,253,252,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,252,115,0,0,0,35,252,253,157,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,252,227,62,27,112,213,252,240,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,250,252,252,252,252,251,238,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,224,252,252,252,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,121,96,0,0,0,64,122,121,241,254,219,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,245,253,199,18,122,241,247,254,253,253,253,253,216,34,0,0,0,0,0,0,0,0,0,0,0,0,0,10,98,253,248,232,253,248,159,160,103,26,98,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,209,253,240,158,37,0,0,0,0,55,237,253,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,229,253,107,0,0,0,0,0,0,0,165,253,224,25,0,0,0,0,0,0,0,0,0,0,0,0,0,18,212,253,80,0,0,0,0,0,0,0,68,253,253,93,0,0,0,0,0,0,0,0,0,0,0,0,0,38,225,253,80,0,0,0,0,0,0,0,68,253,253,93,0,0,0,0,0,0,0,0,0,0,0,0,0,165,253,253,80,0,0,0,0,0,0,0,82,253,228,34,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,250,75,0,0,0,0,0,0,0,201,253,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,199,0,0,0,0,0,0,0,0,201,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,254,67,0,0,0,0,0,0,0,81,254,201,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,225,38,0,0,0,0,0,0,0,137,253,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,19,0,0,0,0,0,0,0,85,249,228,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,94,253,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,232,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,247,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,243,189,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,255,184,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,121,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,213,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,114,243,253,186,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,253,253,253,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,253,253,253,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,253,253,182,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,251,253,175,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,251,253,253,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,194,253,253,214,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,205,253,253,125,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,253,253,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,231,253,253,159,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,155,253,253,172,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,214,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,207,253,253,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,162,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,125,125,125,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,209,253,253,253,253,241,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,253,253,253,253,253,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,19,19,19,110,253,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,253,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,253,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,253,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,236,253,253,247,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,189,253,253,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,161,253,253,253,246,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,94,253,253,253,253,253,252,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,161,253,253,253,253,253,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,80,234,253,253,253,253,253,253,253,252,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,147,236,253,253,253,253,253,253,249,214,207,82,0,0,0,0,0,0,0,0,0,0,0,0,14,33,147,240,253,253,253,253,253,253,231,136,81,0,0,0,0,0,0,0,0,0,0,0,0,0,13,150,196,253,253,253,253,253,253,253,234,136,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,198,253,253,253,253,253,253,248,200,104,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,242,132,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,247,247,247,247,132,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,165,253,233,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,54,252,253,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,246,252,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,120,246,239,180,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,252,180,0,0,0,0,0,4,29,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,203,253,204,25,0,0,0,0,32,153,252,203,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,255,27,0,0,0,0,147,253,253,253,255,253,56,0,0,0,0,0,0,0,0,0,0,0,0,51,243,252,215,18,0,0,0,147,249,252,252,252,253,252,180,0,0,0,0,0,0,0,0,0,0,0,0,88,252,252,110,0,0,7,135,253,252,239,233,252,253,252,86,0,0,0,0,0,0,0,0,0,0,0,0,181,252,252,0,0,7,131,252,253,242,133,224,252,253,179,19,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,79,0,57,252,252,253,214,165,252,252,190,12,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,255,253,253,253,253,255,253,253,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,177,252,253,252,252,252,252,253,223,136,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,133,196,214,252,252,252,165,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,199,252,252,216,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,205,252,112,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,149,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,251,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,190,253,251,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,251,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,253,147,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,234,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,211,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,253,253,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,251,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,217,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,228,253,253,202,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,190,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,251,251,251,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,97,173,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,73,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,144,236,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,228,251,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,253,251,251,251,251,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,231,253,251,251,251,251,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,150,253,255,253,253,253,253,255,253,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,251,251,253,168,107,169,251,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,246,251,251,164,15,0,93,241,253,251,220,21,0,0,0,0,94,217,0,0,0,0,0,0,0,0,0,144,251,251,173,0,0,0,0,180,253,251,251,142,0,0,0,0,109,173,0,0,0,0,0,0,0,0,53,221,251,251,71,0,0,0,0,51,253,251,251,220,51,0,0,0,31,20,0,0,0,0,0,0,0,0,255,253,253,221,51,0,0,0,0,0,73,253,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,142,0,0,0,0,0,0,73,251,251,251,71,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,142,0,0,0,0,0,0,99,251,251,235,61,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,142,0,0,0,0,0,79,253,251,235,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,142,0,0,0,0,79,231,253,251,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,124,73,73,99,253,253,255,253,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,251,251,251,251,253,251,251,251,251,211,107,15,0,0,0,0,0,63,144,0,0,0,0,0,0,0,0,62,236,251,251,251,253,251,251,251,225,154,0,0,0,0,0,0,0,109,251,0,0,0,0,0,0,0,0,0,83,236,251,251,253,251,251,204,41,0,0,0,0,0,0,0,0,62,142,0,0,0,0,0,0,0,0,0,0,61,71,71,72,71,71,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,142,203,203,203,162,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,253,254,253,254,253,254,253,193,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,252,253,212,151,192,253,252,253,252,142,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,0,21,142,203,243,254,213,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,253,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,21,0,0,0,0,0,72,152,254,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,243,223,203,203,203,203,203,253,252,253,130,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,254,253,254,253,254,253,254,253,132,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,50,91,91,151,151,172,252,213,252,253,212,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,183,234,253,254,172,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,151,253,252,203,20,0,0,0,0,0,0,0,0,11,92,152,131,0,0,0,0,0,0,0,0,0,0,0,0,21,203,254,172,0,0,0,0,0,0,0,0,213,252,131,30,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,252,0,0,0,0,0,0,0,0,254,253,173,31,0,0,0,0,0,0,0,0,0,0,31,51,173,253,254,172,0,0,0,0,0,0,0,0,213,252,253,232,142,102,82,0,0,41,62,102,102,183,233,252,253,252,192,30,0,0,0,0,0,0,0,0,21,183,255,253,255,253,254,253,254,253,254,253,254,253,254,253,183,61,0,0,0,0,0,0,0,0,0,0,0,0,71,151,213,252,253,252,253,252,253,252,253,171,50,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,102,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,43,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,164,247,252,252,191,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,110,245,252,252,252,252,253,237,83,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,190,252,253,252,194,162,172,200,252,252,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,252,252,236,68,4,0,0,7,77,244,242,35,0,0,0,0,0,0,0,0,0,0,0,0,0,25,201,253,253,218,0,0,0,0,0,0,0,171,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,227,252,252,169,11,0,0,0,0,0,0,0,127,252,226,0,0,0,0,0,0,0,0,0,0,0,6,153,253,252,171,7,0,0,0,0,0,0,0,0,127,252,252,0,0,0,0,0,0,0,0,0,0,6,155,252,253,169,7,0,0,0,0,0,0,0,0,0,127,252,182,0,0,0,0,0,0,0,0,0,0,110,252,252,236,37,0,0,0,0,0,0,0,0,0,0,171,252,103,0,0,0,0,0,0,0,0,0,68,245,253,253,194,27,0,0,0,0,0,0,0,0,0,146,253,243,35,0,0,0,0,0,0,0,0,0,190,252,252,137,0,0,0,0,0,0,0,0,0,0,103,237,252,153,0,0,0,0,0,0,0,0,0,48,247,252,194,4,0,0,0,0,0,0,0,0,6,153,253,252,180,7,0,0,0,0,0,0,0,0,0,174,252,252,119,0,0,0,0,0,0,0,0,41,190,252,253,205,51,0,0,0,0,0,0,0,0,0,0,253,252,235,14,0,0,0,0,0,0,0,80,223,252,252,129,11,0,0,0,0,0,0,0,0,0,0,0,255,253,236,14,0,0,0,0,29,87,210,253,253,199,62,0,0,0,0,0,0,0,0,0,0,0,0,0,218,252,252,211,102,86,85,182,232,252,253,224,116,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,247,252,252,252,253,252,252,252,244,214,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,136,231,252,253,252,221,162,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,42,42,42,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,242,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,237,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,252,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,247,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,254,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,254,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,254,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,254,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,254,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,254,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,218,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,212,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,228,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,213,224,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,211,252,252,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,252,252,252,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,252,252,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,252,252,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,227,252,238,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,252,252,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,253,252,219,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,253,241,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,255,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,180,252,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,252,252,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,242,252,252,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,252,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,243,252,216,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,227,252,215,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,252,252,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,249,252,212,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,53,177,253,255,253,162,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,252,252,194,77,153,241,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,252,98,6,0,0,80,158,137,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,233,152,3,0,0,0,0,1,83,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,244,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,241,2,45,169,232,231,231,231,159,83,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,248,171,252,252,248,208,208,208,208,122,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,252,252,229,80,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,208,252,166,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,253,253,215,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,252,146,252,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,237,179,11,214,205,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,252,164,0,93,247,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,252,93,0,0,163,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,252,55,0,0,78,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,159,1,0,78,252,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,252,41,0,78,252,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,178,221,121,179,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,234,252,219,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,43,43,96,174,253,254,138,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,199,253,252,252,252,252,253,252,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,206,253,236,231,231,143,245,252,242,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,128,21,0,0,0,148,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,252,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,253,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,253,252,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,106,106,132,246,253,137,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,139,253,255,253,253,253,253,212,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,164,247,252,252,253,252,252,252,252,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,192,252,252,238,143,51,226,252,252,252,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,186,253,252,141,28,0,218,252,247,145,215,229,27,0,0,0,0,0,0,0,0,0,0,0,0,0,54,204,252,191,68,4,27,150,253,252,99,0,18,35,0,0,0,0,0,0,0,0,0,0,0,0,0,15,192,253,236,0,0,31,218,253,247,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,252,252,112,15,85,213,252,217,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,252,226,218,237,252,242,134,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,190,252,252,252,243,153,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,252,252,208,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,150,180,255,254,255,254,254,237,150,138,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,239,253,253,253,253,253,253,253,253,253,253,204,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,202,253,253,253,253,238,217,217,217,245,253,253,240,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,253,253,248,145,38,0,0,0,51,209,253,253,236,27,0,0,0,0,0,0,0,0,0,0,0,0,4,143,253,253,238,0,0,0,0,0,0,11,177,253,253,100,0,0,0,0,0,0,0,0,0,0,0,0,109,253,253,253,135,0,0,0,0,0,0,0,79,253,253,250,65,0,0,0,0,0,0,0,0,0,0,6,190,253,253,253,31,0,0,0,0,0,0,0,10,225,253,253,93,0,0,0,0,0,0,0,0,0,0,94,253,253,253,236,23,0,0,0,0,0,0,0,0,125,253,253,93,0,0,0,0,0,0,0,0,0,0,138,253,253,253,93,0,0,0,0,0,0,0,0,0,125,253,253,93,0,0,0,0,0,0,0,0,0,0,197,253,253,227,0,0,0,0,0,0,0,0,0,0,188,253,251,74,0,0,0,0,0,0,0,0,0,0,197,253,253,227,0,0,0,0,0,0,0,0,0,0,228,253,247,37,0,0,0,0,0,0,0,0,0,0,197,253,253,227,0,0,0,0,0,0,0,0,0,77,253,253,253,93,0,0,0,0,0,0,0,0,0,0,197,253,253,227,0,0,0,0,0,0,0,0,0,115,253,253,246,23,0,0,0,0,0,0,0,0,0,0,197,253,253,241,54,0,0,0,0,0,0,0,30,220,253,253,230,0,0,0,0,0,0,0,0,0,0,0,197,253,253,253,181,0,0,0,0,0,0,0,167,253,253,253,65,0,0,0,0,0,0,0,0,0,0,0,97,253,253,253,246,36,0,0,0,0,4,135,252,253,252,135,4,0,0,0,0,0,0,0,0,0,0,0,0,174,253,253,253,215,60,0,14,68,183,253,253,253,205,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,219,253,253,253,230,218,225,253,253,253,248,211,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,226,253,253,253,253,253,253,253,174,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,46,137,218,209,149,149,91,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,59,229,254,255,255,254,229,105,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,253,253,253,253,253,253,253,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,226,252,165,133,32,118,149,252,253,250,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,205,0,0,0,0,0,68,206,253,227,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,253,170,0,0,0,0,0,0,132,253,253,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,119,10,0,0,0,0,1,37,228,253,195,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,49,159,253,253,248,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,87,94,207,253,253,253,220,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,98,175,237,253,253,253,253,252,165,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,253,253,253,253,253,253,246,137,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,134,161,161,125,54,77,195,253,253,210,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,174,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,233,253,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,253,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,209,253,215,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,251,253,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,86,210,253,253,232,46,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,76,179,204,253,253,228,174,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,253,253,154,123,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,116,254,255,254,181,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,164,253,253,254,253,253,26,0,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,190,253,253,253,235,251,253,26,11,218,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,171,253,253,230,114,18,25,207,21,63,253,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,253,248,166,22,0,0,0,12,0,207,253,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,253,172,0,0,0,0,0,0,56,247,224,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,216,11,0,0,0,0,0,16,182,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,230,130,0,0,0,0,12,127,228,253,219,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,177,36,67,100,153,230,253,245,252,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,253,253,253,253,253,254,174,6,227,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,254,254,254,254,169,88,3,0,228,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,108,174,156,93,3,0,0,17,234,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,225,17,145,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,226,137,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,218,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,244,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,253,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,11,132,41,0,0,0,0,0,0,0,0,123,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,252,203,0,0,0,0,0,0,0,21,223,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,82,0,0,0,0,0,0,0,152,253,255,91,0,0,0,0,0,0,0,0,0,0,0,0,0,41,233,252,0,0,0,0,0,0,0,0,152,252,213,10,0,0,0,0,0,0,0,0,0,0,0,0,11,213,254,192,0,0,0,0,0,0,0,0,214,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,132,252,233,50,0,0,0,0,0,0,0,123,253,252,61,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,183,0,0,0,0,0,0,0,11,213,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,41,253,252,61,0,0,0,0,0,0,0,132,252,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,163,254,192,0,0,0,0,0,0,11,51,254,253,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,203,253,232,142,102,102,102,102,183,213,252,253,252,131,10,0,0,0,0,0,0,0,0,0,0,0,0,0,123,234,253,254,253,254,253,254,253,254,253,254,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,232,253,252,253,252,151,151,253,252,172,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,203,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,233,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,252,192,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,59,59,59,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,179,251,251,251,167,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,175,161,0,0,135,194,251,251,251,251,251,186,121,0,0,0,0,0,0,0,0,0,0,0,0,28,70,240,251,231,0,127,247,253,251,223,248,251,251,251,245,107,0,0,0,0,0,0,0,0,0,0,0,175,251,251,251,231,31,180,251,253,205,47,143,191,251,251,251,115,0,0,0,0,0,0,0,0,0,0,0,175,251,251,251,111,78,251,251,97,52,0,0,37,191,251,251,199,36,0,0,0,0,0,0,0,0,0,100,239,251,251,119,7,92,251,86,0,0,0,0,0,23,219,251,251,222,0,0,0,0,0,0,0,0,19,158,251,251,220,66,20,251,208,39,0,0,0,0,0,0,214,251,251,251,0,0,0,0,0,0,0,0,164,251,251,251,153,0,9,115,53,0,0,0,0,0,0,0,214,251,251,251,0,0,0,0,0,0,0,0,253,251,251,251,153,0,0,0,0,0,0,0,0,0,0,0,214,251,251,251,0,0,0,0,0,0,0,0,255,253,253,253,154,0,0,0,0,0,0,0,0,0,0,37,224,253,253,253,0,0,0,0,0,0,0,0,253,251,251,251,153,0,0,0,0,0,0,0,0,0,0,155,251,251,251,160,0,0,0,0,0,0,0,0,253,251,251,251,153,0,0,0,0,0,0,0,0,0,68,222,251,251,156,18,0,0,0,0,0,0,0,0,72,251,251,251,244,113,36,0,0,0,0,0,28,70,240,251,251,251,115,0,0,0,0,0,0,0,0,0,36,199,251,251,251,251,239,98,98,98,99,98,204,251,251,251,251,220,71,0,0,0,0,0,0,0,0,0,0,45,204,251,251,251,251,251,251,251,253,251,251,251,251,251,239,66,0,0,0,0,0,0,0,0,0,0,0,0,26,218,239,251,251,251,251,251,253,251,251,248,231,231,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,173,239,251,208,233,253,251,196,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,115,53,90,116,115,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,143,142,104,64,64,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,252,254,253,253,253,253,253,238,223,158,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,121,244,249,209,40,15,80,80,159,158,158,70,50,0,0,0,0,0,0,0,0,0,0,0,0,0,17,218,253,235,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,174,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,254,243,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,254,253,250,193,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,115,198,247,254,195,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,197,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,254,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,177,254,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,90,223,246,253,174,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,219,189,254,254,255,254,241,218,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,73,142,142,142,142,83,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,118,118,118,118,118,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,238,253,253,253,253,253,248,208,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,247,253,253,253,253,253,253,253,253,249,209,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,253,253,246,117,61,61,184,213,253,253,253,223,40,0,0,0,0,0,0,0,0,0,0,0,0,0,80,247,253,246,115,0,0,0,0,23,182,241,253,253,220,42,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,198,0,0,0,0,0,0,0,84,253,253,253,220,40,0,0,0,0,0,0,0,0,0,0,0,188,253,253,198,0,0,0,0,0,0,0,14,127,253,253,253,223,39,0,0,0,0,0,0,0,0,0,0,254,253,253,198,0,0,0,0,0,0,0,0,1,127,253,253,253,227,42,0,0,0,0,0,0,0,0,0,254,253,253,75,0,0,0,0,0,0,0,0,0,13,83,241,253,253,96,0,0,0,0,0,0,0,0,0,254,253,253,61,0,0,0,0,0,0,0,0,0,0,0,183,253,253,213,32,0,0,0,0,0,0,0,0,254,253,253,61,0,0,0,0,0,0,0,0,0,0,0,67,243,253,253,142,0,0,0,0,0,0,0,0,254,253,253,76,0,0,0,0,0,0,0,0,0,0,0,0,199,253,253,253,0,0,0,0,0,0,0,0,176,253,253,199,3,0,0,0,0,0,0,0,0,0,0,0,199,253,253,253,0,0,0,0,0,0,0,0,118,253,253,253,82,0,0,0,0,0,0,0,0,0,0,0,199,253,253,253,0,0,0,0,0,0,0,0,70,245,253,253,245,158,51,0,0,0,0,0,0,0,0,90,221,253,253,253,0,0,0,0,0,0,0,0,0,84,240,253,253,253,236,86,83,83,67,0,3,83,138,249,253,253,246,97,0,0,0,0,0,0,0,0,0,0,87,238,253,253,253,253,253,253,243,199,201,253,253,253,253,243,102,0,0,0,0,0,0,0,0,0,0,0,0,87,217,253,253,253,253,253,253,253,253,253,253,253,187,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,96,166,232,251,253,253,251,232,232,232,114,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,116,116,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,168,254,254,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,164,253,248,163,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,253,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,250,253,201,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,242,254,210,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,187,253,243,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,253,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,215,253,205,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,210,253,230,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,253,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,254,254,210,0,0,0,0,14,246,230,144,144,71,0,0,0,0,0,0,0,0,0,0,0,0,0,16,227,253,250,107,0,0,9,96,207,253,253,253,253,240,46,0,0,0,0,0,0,0,0,0,0,0,40,161,253,253,108,0,0,44,168,253,253,201,154,188,253,236,40,0,0,0,0,0,0,0,0,0,0,0,110,253,253,197,11,0,7,220,255,248,188,10,0,4,128,252,63,0,0,0,0,0,0,0,0,0,0,15,220,253,241,43,0,30,193,253,254,163,0,0,0,59,208,224,23,0,0,0,0,0,0,0,0,0,0,67,253,253,198,0,4,165,253,253,103,17,0,47,161,218,250,88,0,0,0,0,0,0,0,0,0,0,0,72,253,253,102,0,113,253,253,99,7,41,122,239,253,253,184,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,232,155,202,253,253,167,211,253,253,253,244,123,9,0,0,0,0,0,0,0,0,0,0,0,0,18,157,250,253,253,253,253,253,253,254,253,253,169,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,167,253,253,234,143,143,81,33,33,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,249,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,227,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,254,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,242,207,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,207,255,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,255,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,195,254,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,254,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,242,249,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,254,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,242,251,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,255,255,254,255,214,125,125,125,125,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,253,253,253,253,253,253,253,253,253,252,248,164,118,48,0,0,0,0,0,0,0,0,0,0,0,0,0,184,253,153,182,253,253,253,253,253,253,253,253,253,253,246,162,0,0,0,0,0,0,0,0,0,0,0,0,66,96,2,7,19,19,19,19,117,149,149,219,253,253,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,42,216,253,252,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,241,253,253,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,174,253,253,198,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,239,253,253,247,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,166,238,253,253,246,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,253,253,253,245,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,93,237,253,253,244,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,253,253,244,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,238,253,253,193,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,169,239,253,243,117,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,33,179,253,253,227,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,253,253,253,191,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,246,253,253,193,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,248,253,253,128,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,253,253,129,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,253,199,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,25,100,106,106,106,106,106,127,162,106,106,106,40,19,0,0,0,0,0,0,0,0,0,0,29,118,143,195,254,254,254,254,250,218,218,192,193,217,218,223,254,242,129,2,0,0,0,0,0,0,0,0,241,254,254,214,126,102,44,44,39,0,0,0,0,0,0,6,44,168,254,120,0,0,0,0,0,0,0,0,191,247,83,16,0,0,0,0,0,0,0,0,0,0,0,0,0,8,163,219,0,0,0,0,0,0,0,0,37,190,222,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,255,0,0,0,0,0,0,0,0,0,45,236,166,12,0,0,0,0,0,0,0,0,0,0,0,0,0,151,253,0,0,0,0,0,0,0,0,0,0,142,254,113,0,0,0,0,0,0,0,0,0,0,0,0,22,240,173,0,0,0,0,0,0,0,0,0,0,30,157,65,0,0,0,0,0,0,0,0,0,0,0,0,57,254,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,244,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,199,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,240,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,252,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,143,239,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,254,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,218,219,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,230,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,167,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,34,21,0,0,0,2,34,116,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,67,163,254,253,223,85,0,0,70,253,253,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,237,253,253,254,253,253,164,0,74,250,253,253,33,0,0,0,0,0,0,0,0,0,0,0,0,15,196,253,250,231,134,11,103,235,194,205,247,243,192,10,2,0,0,0,0,0,0,0,0,0,0,0,63,223,253,227,163,0,0,0,128,253,253,253,253,156,0,0,0,0,0,0,0,0,0,0,0,0,0,79,251,253,253,45,0,0,0,0,138,253,253,253,98,5,0,0,0,0,0,0,0,0,0,0,0,0,3,203,252,218,45,2,0,0,0,41,238,249,223,22,5,0,0,0,0,0,0,0,0,0,0,0,0,0,115,253,183,0,0,0,0,0,88,254,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,253,183,0,0,0,0,58,245,255,204,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,162,253,192,39,0,0,135,231,253,225,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,182,254,182,57,139,254,244,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,246,253,253,253,253,181,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,253,253,253,173,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,249,253,253,253,228,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,171,253,241,159,240,253,227,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,131,253,207,129,0,107,253,253,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,253,253,175,12,99,176,253,253,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,253,253,253,253,253,253,253,220,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,253,253,253,253,226,176,156,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,143,143,133,33,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,191,192,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,248,253,254,185,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,253,253,254,253,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,239,253,140,40,39,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,253,253,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,253,243,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,254,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,253,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,253,245,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,175,253,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,231,253,223,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,255,220,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,163,240,253,219,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,239,253,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,240,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,113,193,254,253,152,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,243,253,252,253,252,253,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,253,244,122,102,162,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,243,253,171,40,0,0,142,253,252,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,253,163,20,0,0,0,142,254,253,234,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,243,253,130,20,0,0,0,82,223,253,252,91,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,254,131,51,51,51,132,214,253,254,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,252,253,252,253,252,253,252,253,252,172,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,102,234,213,203,203,132,233,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,10,0,41,233,252,233,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,253,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,243,253,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,254,253,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,182,253,212,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,254,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,233,252,213,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,233,254,151,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,233,252,213,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,255,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,243,253,212,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,80,203,184,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,218,254,230,250,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,205,205,52,15,142,252,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,231,180,33,0,0,3,254,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,213,10,0,0,0,0,255,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,97,0,0,0,0,0,254,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,4,0,0,0,0,3,254,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,254,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,250,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,254,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,254,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,221,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,177,221,45,39,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,254,254,254,254,242,220,164,128,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,244,254,254,249,247,246,248,254,254,227,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,211,254,198,107,27,0,0,19,74,123,164,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,254,168,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,216,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,133,133,41,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,95,212,253,253,253,165,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,163,253,253,253,253,253,253,217,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,210,254,253,246,124,84,119,244,253,217,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,201,253,254,207,62,0,0,0,99,245,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,200,253,253,118,26,0,0,0,0,0,218,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,60,244,253,253,172,0,0,0,0,0,0,0,218,253,253,0,0,0,0,0,0,0,0,0,0,0,0,70,200,253,253,114,2,0,0,0,0,0,0,0,218,253,253,0,0,0,0,0,0,0,0,0,0,0,21,212,253,253,114,3,0,0,0,0,0,0,0,0,218,253,253,0,0,0,0,0,0,0,0,0,0,18,204,253,253,115,2,0,0,0,0,0,0,0,0,41,235,253,195,0,0,0,0,0,0,0,0,0,7,163,254,254,175,0,0,0,0,0,0,0,0,0,39,174,254,249,69,0,0,0,0,0,0,0,0,0,145,253,253,207,26,0,0,0,0,0,0,0,0,18,148,253,253,144,0,0,0,0,0,0,0,0,0,25,212,253,206,28,0,0,0,0,0,0,0,0,25,192,253,253,222,66,0,0,0,0,0,0,0,0,0,214,253,229,28,0,0,0,0,0,0,0,5,67,226,253,253,214,29,0,0,0,0,0,0,0,0,0,0,254,253,188,0,0,0,0,0,0,0,62,137,253,253,239,101,14,0,0,0,0,0,0,0,0,0,0,0,254,253,96,0,0,0,0,0,32,130,254,253,253,204,80,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,148,86,86,120,206,206,226,253,254,253,183,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,253,253,253,253,157,87,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,253,159,144,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,132,132,132,132,132,34,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,71,104,157,158,157,157,157,157,157,119,66,0,0,0,0,0,0,0,0,0,0,0,0,0,13,122,236,244,253,253,253,254,253,253,253,253,253,253,252,236,206,0,0,0,0,0,0,0,0,0,0,13,185,253,245,200,222,248,83,26,50,114,114,38,26,26,32,50,26,0,0,0,0,0,0,0,0,0,0,77,253,230,75,0,21,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,229,253,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,253,211,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,248,253,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,247,253,238,184,141,97,97,64,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,217,253,253,253,253,253,253,253,148,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,88,88,97,175,177,254,255,229,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,39,205,253,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,253,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,35,0,0,0,0,0,0,0,16,242,253,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,241,128,44,29,0,0,0,17,198,254,243,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,231,253,253,244,201,201,201,221,253,254,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,82,166,235,238,239,236,240,205,91,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,15,5,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,130,254,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,253,253,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,228,253,253,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,253,253,149,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,220,253,241,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,253,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,214,253,228,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,253,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,255,253,179,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,221,254,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,254,251,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,234,253,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,193,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,247,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,246,253,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,194,253,180,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,113,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,253,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,188,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,229,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,120,190,194,194,195,154,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,245,253,182,178,178,188,253,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,254,180,49,0,0,0,0,157,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,189,97,0,0,0,0,0,134,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,0,0,0,0,0,139,238,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,217,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,79,139,245,255,174,79,16,0,166,220,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,206,253,194,119,128,225,253,232,187,254,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,249,137,4,0,0,8,64,196,253,254,245,186,90,20,0,0,0,0,5,0,0,0,0,0,0,0,0,254,136,0,0,0,0,24,145,253,204,60,121,207,253,236,195,176,120,154,211,0,0,0,0,0,0,0,0,254,180,75,89,149,202,239,249,130,12,0,0,2,30,96,135,218,253,218,91,0,0,0,0,0,0,0,0,206,254,254,248,224,224,162,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,45,93,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,96,122,130,148,148,96,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,252,252,252,253,252,252,237,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,252,212,170,232,247,252,252,252,216,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,215,63,0,0,63,84,170,252,253,224,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,0,0,11,86,253,252,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,253,245,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,252,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218,252,212,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,106,158,140,106,253,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,174,253,255,253,253,253,253,255,253,200,78,25,0,0,0,0,0,0,0,0,0,0,0,0,0,50,164,247,252,252,253,224,210,252,252,253,252,252,252,191,0,0,0,0,0,0,0,0,0,0,0,32,171,245,252,252,212,126,65,65,190,252,252,127,47,21,21,12,0,0,0,0,0,0,0,0,0,0,85,190,252,243,153,84,28,0,82,232,252,236,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,223,252,208,35,0,0,0,132,253,252,244,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,227,253,199,18,0,15,96,174,253,255,142,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,252,201,21,0,103,211,252,252,252,151,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,252,242,232,232,253,252,233,126,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,237,252,252,252,216,153,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,95,121,42,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,113,191,113,114,238,253,237,113,114,113,113,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,252,252,252,253,252,252,252,252,253,252,252,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,208,252,252,253,252,252,252,252,253,252,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,84,84,84,84,84,84,84,159,252,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,253,253,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,252,233,85,86,85,85,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,57,57,135,222,252,252,252,252,253,252,252,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,252,252,252,253,252,252,252,252,240,223,223,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,252,252,252,253,252,252,236,112,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,75,253,255,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,252,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,195,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,255,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,234,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,196,252,240,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,173,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,211,254,254,241,144,144,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,247,253,253,253,254,253,253,247,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,253,236,154,154,154,223,253,253,244,171,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,241,95,0,0,0,7,54,229,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,0,0,0,0,0,0,23,253,253,250,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,199,253,253,206,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,75,199,241,253,253,245,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,45,113,155,241,254,253,253,250,185,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,188,211,253,253,253,253,254,253,253,238,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,253,253,253,253,253,206,253,253,253,208,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,183,183,111,111,29,0,0,0,135,253,254,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,253,227,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,253,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,253,253,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,250,253,234,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,166,244,253,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,45,122,236,253,253,238,108,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,145,69,155,155,215,253,253,255,253,236,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,253,253,253,253,253,253,253,177,99,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,42,143,230,200,143,110,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,183,253,253,253,193,105,105,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,170,252,252,252,252,253,252,252,231,208,103,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,252,252,252,252,252,253,252,252,252,252,252,205,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,252,188,132,132,132,133,160,252,252,252,252,252,14,0,0,0,0,0,0,0,0,0,0,0,0,5,75,232,252,157,4,0,0,0,7,29,99,177,177,177,10,0,0,0,0,0,0,0,0,0,0,0,0,15,252,252,252,252,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,181,252,252,252,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,252,252,99,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,235,252,252,252,207,193,46,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,252,252,252,252,252,253,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,253,253,253,253,253,253,255,253,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,252,252,140,44,70,227,253,252,240,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,224,223,42,0,0,53,253,252,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,39,0,0,0,0,253,252,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,30,30,2,0,0,253,252,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,252,252,140,134,134,253,252,252,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,252,252,252,252,252,253,252,246,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,120,231,252,252,252,253,252,210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,155,252,252,253,128,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,70,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,253,242,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,237,248,221,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,159,254,139,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,112,128,0,0,0,0,0,0,108,254,236,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,226,253,236,0,0,0,0,0,43,232,253,134,0,0,0,0,0,0,0,0,0,0,0,0,0,3,125,254,253,192,88,0,0,0,0,7,216,253,135,17,0,0,0,0,0,0,0,0,0,0,0,0,0,157,253,254,151,13,0,0,0,0,0,170,253,236,19,0,0,0,0,0,0,0,0,0,0,0,0,0,81,237,254,151,9,0,0,0,0,0,85,254,254,80,0,0,0,0,0,0,0,0,0,0,0,0,0,55,243,253,185,9,0,0,0,0,0,38,247,254,110,4,0,0,0,0,0,0,0,0,0,0,0,0,0,237,253,234,13,0,0,0,0,0,30,212,253,146,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,246,118,93,76,0,68,93,180,253,253,185,167,17,0,0,0,0,0,0,0,0,0,0,0,0,0,119,248,254,254,255,254,254,254,254,254,254,203,93,9,0,0,0,0,0,34,0,0,0,0,0,0,0,0,0,21,107,206,207,190,128,253,254,227,73,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,253,247,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,240,253,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,204,254,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,212,244,156,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,230,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,170,254,255,254,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,140,254,215,239,254,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,254,132,4,70,254,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,252,201,15,0,35,254,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,254,40,0,0,23,236,245,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,252,135,3,0,0,85,254,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,237,254,30,0,0,0,140,254,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,254,204,4,0,0,0,207,254,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,254,227,16,0,0,34,247,254,160,192,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,250,254,173,55,88,207,254,254,254,184,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,254,254,254,254,254,254,225,62,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,211,219,249,230,254,254,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,91,254,238,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,254,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,254,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,244,225,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,254,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,254,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,237,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,142,255,175,130,107,7,7,7,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,148,253,253,253,253,253,253,253,253,162,98,13,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,253,251,235,235,238,253,253,253,253,253,253,253,213,143,31,2,0,0,0,0,0,0,0,0,0,0,0,6,174,206,0,0,18,105,105,195,235,253,253,253,253,253,253,156,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,99,99,201,222,250,253,253,207,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,238,253,253,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,245,253,233,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,156,244,253,253,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,184,253,253,253,146,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,207,253,253,229,191,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,192,240,253,253,195,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,163,239,253,253,229,136,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,175,253,253,253,190,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,218,253,253,232,133,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,109,240,253,253,187,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,175,253,253,236,69,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,112,243,253,253,186,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,253,253,242,127,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,253,253,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,237,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,253,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,255,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,253,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,119,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,253,254,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,236,130,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,114,148,255,218,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,121,221,252,252,253,252,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,48,171,245,252,252,247,143,144,231,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,252,252,253,231,180,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,141,249,252,208,86,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,210,253,241,80,0,0,0,0,0,0,0,0,22,43,7,0,0,0,0,0,0,0,0,0,0,8,112,242,253,224,66,0,0,0,0,0,0,0,50,121,221,231,28,0,0,0,0,0,0,0,0,0,0,31,252,252,153,14,0,0,0,0,0,2,48,215,245,210,118,16,0,0,0,0,0,0,0,0,0,0,0,127,252,226,0,0,0,0,0,0,57,176,252,226,128,56,0,0,0,0,0,0,0,0,0,0,0,0,0,171,252,235,0,0,0,0,45,168,225,252,182,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,253,253,237,55,48,218,253,247,176,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,154,252,253,231,247,231,168,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,218,253,252,252,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,190,252,253,252,252,231,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,223,252,252,191,103,244,252,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,227,253,225,124,0,0,66,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,252,236,21,0,0,0,22,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,252,189,22,22,128,162,234,252,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,252,252,252,252,253,252,247,189,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,156,252,252,164,191,147,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,76,139,138,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,26,68,161,194,252,253,252,227,161,15,0,0,0,0,0,0,0,0,0,0,0,0,0,49,184,184,184,215,222,252,252,252,221,190,252,252,252,22,0,0,0,0,0,0,0,0,0,0,0,0,0,233,252,252,252,252,253,252,185,160,88,5,126,252,252,22,0,0,0,0,0,0,0,0,0,0,0,0,0,86,137,221,157,32,23,22,6,0,0,11,203,252,252,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,253,215,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,193,253,223,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,188,252,215,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,209,252,252,63,17,93,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,234,252,252,252,241,234,252,234,230,231,209,116,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,253,253,243,242,230,230,239,253,255,253,253,253,86,0,0,0,0,0,0,0,0,0,0,0,0,0,9,92,92,92,50,42,0,0,34,92,92,113,240,252,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,234,252,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,221,252,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,193,252,210,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,101,0,0,0,0,0,0,74,255,253,247,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,227,67,5,47,47,47,140,244,253,244,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,234,252,190,253,252,252,252,252,173,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,194,252,253,252,252,176,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,128,23,22,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,130,215,254,254,245,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,185,250,253,253,253,253,253,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,248,254,215,140,26,47,101,253,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,126,246,253,117,10,0,0,0,171,253,145,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,251,148,0,0,0,0,38,232,253,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,129,0,0,0,9,54,220,253,253,153,12,0,0,0,0,0,0,0,0,0,0,125,6,0,0,0,201,253,215,140,171,146,208,253,253,253,153,13,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,118,214,247,235,236,150,216,253,250,121,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,88,248,251,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,250,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,254,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,250,254,77,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,164,248,253,78,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,233,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,246,235,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,231,237,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,216,228,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,208,222,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,158,230,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,201,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,170,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,254,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,165,254,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,254,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,181,6,0,0,0,0,0,34,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,254,165,0,0,0,0,0,83,218,242,220,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,254,165,0,0,0,0,116,252,254,254,254,248,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,165,0,0,0,91,221,254,254,180,119,254,234,40,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,165,0,0,4,176,254,254,239,19,5,168,254,71,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,165,0,0,52,254,255,254,77,0,0,9,193,99,0,0,0,0,0,0,0,0,0,0,0,0,0,172,254,234,23,0,142,254,254,195,10,0,0,0,166,189,0,0,0,0,0,0,0,0,0,0,0,0,0,128,254,254,128,3,184,254,255,78,0,0,0,0,166,244,45,0,0,0,0,0,0,0,0,0,0,0,0,54,254,254,147,6,254,254,228,33,0,0,0,0,166,254,53,0,0,0,0,0,0,0,0,0,0,0,0,52,251,254,202,23,254,254,195,0,0,0,0,16,212,221,26,0,0,0,0,0,0,0,0,0,0,0,0,0,113,249,254,254,254,254,195,0,0,0,0,100,254,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,254,254,254,254,173,0,0,0,3,168,246,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,203,254,254,254,107,0,0,30,130,254,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,212,254,254,242,202,202,225,254,206,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,254,254,254,254,254,254,244,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,202,254,171,135,92,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,48,171,233,232,232,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,158,252,252,253,205,189,210,28,0,22,117,142,37,0,0,0,0,0,0,0,0,0,0,0,0,0,80,242,252,252,208,86,11,0,28,7,62,199,252,252,235,0,0,0,0,0,0,0,0,0,0,0,0,18,255,253,232,158,0,0,0,0,0,0,87,253,214,239,253,0,0,0,0,0,0,0,0,0,0,0,48,216,253,252,91,0,0,0,0,0,0,0,11,63,21,232,252,0,0,0,0,0,0,0,0,0,0,20,202,252,170,47,2,0,0,0,0,0,0,0,0,0,75,252,244,0,0,0,0,0,0,0,0,0,22,202,252,182,0,0,0,0,0,0,0,0,0,0,0,0,153,252,147,0,0,0,0,0,0,0,0,0,173,252,226,42,0,0,0,0,0,0,0,0,0,0,0,116,249,226,86,0,0,0,0,0,0,0,0,123,253,253,128,0,0,0,0,0,0,0,0,0,0,0,166,253,253,172,0,0,0,0,0,0,0,0,0,253,252,157,21,0,0,0,0,0,0,0,0,0,22,128,253,252,157,21,0,0,0,0,0,0,0,0,0,253,252,126,0,0,0,0,0,0,0,0,0,11,124,252,250,152,19,0,0,0,0,0,0,0,0,0,0,253,252,100,0,0,0,0,0,0,0,11,99,211,252,226,70,0,0,0,0,0,0,0,0,0,0,0,0,253,252,109,0,0,0,0,0,27,106,219,252,252,155,24,0,0,0,0,0,0,0,0,0,0,0,0,0,237,253,253,253,165,193,148,201,253,253,247,176,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,231,252,252,252,253,252,252,231,124,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,74,126,126,127,91,21,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,13,123,133,198,255,255,173,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,181,253,253,253,254,253,253,253,176,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,253,253,253,218,154,96,176,253,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,165,84,4,0,0,13,197,253,229,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,72,10,0,0,0,0,56,230,253,236,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,194,231,253,253,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,232,253,253,237,82,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,149,235,254,253,222,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,253,253,254,253,250,207,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,253,254,253,253,253,245,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,122,59,70,138,250,254,254,214,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,212,253,253,212,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,199,253,253,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,182,253,253,110,0,0,0,0,0,0,0,0,0,0,49,86,69,0,0,0,0,0,0,45,86,86,109,217,253,253,221,16,0,0,0,0,0,0,0,0,0,0,145,253,247,218,218,218,218,166,155,238,253,253,253,253,253,253,53,0,0,0,0,0,0,0,0,0,0,0,14,99,144,144,228,253,253,253,253,254,253,253,253,175,144,46,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,52,132,184,253,191,63,11,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,252,130,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,221,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,211,250,252,250,159,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,221,250,250,252,169,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,252,252,254,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,132,250,250,250,232,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,252,250,250,250,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,252,250,250,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,254,232,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,191,250,252,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,191,250,250,252,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,250,250,250,212,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,252,252,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,250,250,250,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,250,250,250,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,250,250,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,252,252,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,250,250,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,250,250,211,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,102,20,20,20,20,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,254,253,253,253,193,176,175,108,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,191,238,253,253,253,253,254,253,253,183,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,58,58,58,133,155,200,253,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,254,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,245,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,199,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,168,253,231,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,98,98,171,253,253,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,120,201,254,254,254,255,254,205,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,207,254,253,253,253,253,241,250,241,147,12,0,0,0,0,0,0,0,0,0,0,0,0,0,79,116,146,247,253,223,215,253,240,137,30,74,174,205,108,0,0,0,0,0,0,0,0,0,0,0,90,174,254,250,213,115,96,246,253,240,68,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,99,248,253,193,106,68,197,253,254,200,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,186,254,254,216,156,201,254,254,208,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,253,253,253,254,251,165,83,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,253,253,253,253,152,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,102,117,26,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,225,253,176,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,252,253,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,252,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,255,128,144,253,253,255,128,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,252,252,252,252,253,252,246,225,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,252,252,196,195,164,55,55,56,180,239,252,252,135,6,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,157,0,0,0,0,0,0,0,66,177,239,253,43,0,0,0,0,0,0,0,0,0,0,0,0,0,197,252,112,0,0,0,0,0,0,0,0,0,140,253,214,31,0,0,0,0,0,0,0,0,0,0,0,38,222,253,112,0,0,0,0,0,0,0,0,0,79,255,253,196,0,0,0,0,0,0,0,0,0,0,0,85,252,252,112,0,0,0,0,0,0,0,0,0,0,206,252,195,0,0,0,0,0,0,0,0,0,0,0,85,252,252,112,0,0,0,0,0,0,0,0,0,0,113,252,195,0,0,0,0,0,0,0,0,0,0,0,85,252,252,112,0,0,0,0,0,0,0,0,0,0,113,252,195,0,0,0,0,0,0,0,0,0,0,0,85,252,252,112,0,0,0,0,0,0,0,0,0,0,113,252,195,0,0,0,0,0,0,0,0,0,0,0,48,229,253,174,0,0,0,0,0,0,0,0,0,63,176,253,196,0,0,0,0,0,0,0,0,0,0,0,0,150,252,252,163,9,0,0,0,0,0,19,101,240,253,252,148,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,253,203,119,197,197,198,197,209,252,252,253,154,12,0,0,0,0,0,0,0,0,0,0,0,0,19,99,239,253,252,252,252,252,253,252,252,249,223,84,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,174,252,252,252,252,112,112,112,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,255,160,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,253,253,230,119,36,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,230,253,253,253,253,217,112,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,150,253,253,253,253,253,246,113,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,74,191,253,253,253,253,253,220,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,29,82,152,253,253,253,205,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,59,185,253,253,253,171,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,24,52,142,184,253,253,253,253,206,23,0,0,0,0,0,0,0,0,0,0,0,0,29,42,138,160,162,253,253,253,253,253,253,253,253,176,38,0,0,0,0,0,0,0,0,0,0,0,0,25,229,253,253,253,253,253,253,253,253,253,253,253,253,253,168,40,0,0,0,0,0,0,0,0,0,0,0,25,228,253,253,253,253,253,253,253,230,205,219,252,253,253,253,234,27,0,0,0,0,0,0,0,0,0,0,0,28,96,41,41,41,41,41,41,29,16,23,40,55,158,227,253,171,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,253,253,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,219,253,253,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,99,217,253,253,242,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,48,48,101,211,253,253,253,238,69,0,0,0,0,0,0,0,0,0,0,0,45,17,0,0,63,77,183,200,253,253,253,253,253,211,158,48,0,0,0,0,0,0,0,0,0,0,6,155,236,214,201,201,251,253,253,253,253,253,253,249,102,19,0,0,0,0,0,0,0,0,0,0,0,0,18,253,253,253,253,253,253,253,253,253,223,153,101,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,207,253,253,253,148,135,125,73,17,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,228,255,182,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,152,178,197,203,249,253,254,182,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,253,254,253,234,210,127,127,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,241,253,209,60,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,204,253,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,209,254,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,241,253,253,141,145,145,94,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,254,253,253,253,253,254,253,209,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,253,253,245,202,203,251,253,165,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,253,227,41,0,0,87,240,253,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,255,254,159,0,0,0,0,192,254,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,254,221,22,0,0,0,0,76,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,217,106,0,0,0,0,0,37,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,124,7,0,0,0,0,0,217,253,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,228,182,0,0,0,0,0,139,254,254,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,172,253,45,0,0,0,0,81,245,253,164,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,253,253,192,128,128,198,217,254,253,163,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,249,253,254,253,253,253,253,254,216,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,105,163,162,227,124,72,72,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,191,254,176,101,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,252,253,252,252,212,176,90,67,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,196,154,222,252,252,252,252,252,245,175,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,7,54,129,230,238,252,252,252,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,252,252,202,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,241,252,237,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,245,252,252,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,206,252,252,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,213,252,252,153,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,243,252,243,119,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,191,255,253,240,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,233,252,253,206,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,236,252,252,139,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,171,251,252,236,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,222,252,250,130,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,222,252,252,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,230,252,226,93,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,147,252,229,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,252,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,171,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,233,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,155,235,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,228,170,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,233,172,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,250,180,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,233,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,252,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,203,185,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,252,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,221,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,253,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,252,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,252,69,57,122,185,184,184,184,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,252,219,244,252,253,252,252,252,252,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,252,252,252,147,75,22,54,179,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,253,222,25,0,0,0,0,51,243,221,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,218,173,252,119,0,0,0,13,174,252,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,146,34,234,227,131,70,70,172,252,221,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,146,0,118,236,252,253,252,252,218,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,137,148,178,106,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,55,180,253,139,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,84,252,252,252,253,236,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,252,252,195,79,69,186,215,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,253,252,185,29,0,0,50,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,253,252,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,232,90,0,0,0,0,0,19,24,24,97,138,44,13,0,0,0,0,0,0,0,0,0,0,0,0,168,253,231,37,0,0,0,30,130,236,252,253,252,252,235,113,0,0,0,0,0,0,0,0,0,0,0,0,84,253,231,69,0,32,185,228,252,252,189,122,69,69,44,0,0,0,0,0,0,0,0,0,0,0,0,0,53,253,252,130,76,228,253,252,153,45,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,253,252,246,238,252,180,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,253,253,245,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,47,253,252,252,202,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,136,252,247,227,252,227,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,209,252,252,188,46,221,252,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,221,252,200,63,5,137,252,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,222,253,128,0,0,123,253,253,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,178,252,140,8,0,0,142,252,252,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,227,252,132,70,70,142,234,252,168,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,161,252,252,252,253,252,252,176,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,221,252,252,243,189,54,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,191,138,24,24,108,138,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,252,252,253,252,252,252,252,162,88,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,240,252,253,240,183,183,246,253,252,202,142,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,98,211,206,0,0,42,109,177,252,252,211,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,18,0,0,0,0,5,54,179,252,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,241,255,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,246,247,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,252,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,248,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,97,222,192,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,99,208,227,174,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,252,237,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,202,253,244,207,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,96,252,252,244,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,199,249,253,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,248,253,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,253,240,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,231,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,167,255,254,254,240,113,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,84,225,254,230,229,193,218,254,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,254,254,181,2,0,0,10,214,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,231,244,62,17,0,0,0,9,211,181,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,254,130,0,0,0,0,19,161,254,207,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,249,170,10,0,0,26,137,237,241,181,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,145,85,157,165,196,254,252,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,237,250,254,249,254,254,247,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,70,164,254,235,110,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,162,254,204,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,162,254,166,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,254,177,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,164,250,192,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,140,254,204,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,254,215,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,123,249,204,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,151,254,178,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,111,254,165,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,254,140,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,239,125,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,253,255,239,154,77,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,230,254,132,191,221,254,247,93,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,202,254,17,0,13,123,218,176,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,254,17,0,0,142,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,254,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,253,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,250,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,211,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,245,248,138,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,228,254,176,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,176,254,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,211,251,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,231,169,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,254,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,254,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,254,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,204,65,0,0,24,240,179,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,239,192,149,198,242,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,158,243,243,158,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,128,166,239,175,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,241,253,253,253,253,199,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,146,252,238,191,213,191,189,252,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,152,254,238,31,0,9,0,12,26,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,112,253,240,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,253,253,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,253,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,159,0,0,5,18,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,234,253,115,34,181,200,253,178,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,253,253,227,253,253,174,121,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,254,254,255,254,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,148,248,253,253,205,11,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,178,253,248,215,253,194,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,220,253,220,75,48,253,254,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,187,253,162,19,0,24,253,213,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,148,253,204,8,0,3,148,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,253,211,25,0,3,163,253,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,253,200,4,30,150,253,243,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,253,238,195,253,249,171,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,247,253,253,198,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,253,253,207,132,132,13,13,13,10,0,0,0,11,7,0,0,0,0,0,0,0,0,0,0,0,0,28,222,252,252,252,252,252,253,252,252,231,145,145,145,237,206,7,0,0,0,0,0,0,0,0,0,0,0,66,252,242,119,199,231,252,253,252,252,252,252,252,252,252,184,5,0,0,0,0,0,0,0,0,0,0,0,169,252,180,0,0,36,84,84,95,204,204,238,252,236,157,48,0,0,0,0,0,0,0,0,0,0,0,27,229,252,180,0,0,0,0,0,0,0,0,52,72,48,0,0,0,0,0,0,0,0,0,0,0,0,0,26,228,252,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,252,239,108,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,225,252,252,119,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,252,252,252,231,114,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,46,230,252,252,252,253,241,166,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,172,241,255,253,253,253,253,161,35,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,176,231,252,252,252,252,159,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,96,182,226,252,252,159,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,252,252,231,9,0,0,0,0,0,0,0,0,0,0,38,84,181,129,0,0,0,0,0,0,0,0,73,235,252,252,143,0,0,0,0,0,0,0,0,0,0,42,184,252,200,71,0,0,0,0,0,0,46,96,235,252,252,224,103,0,0,0,0,0,0,0,0,0,5,181,240,88,14,0,0,0,0,81,86,153,234,252,252,252,224,46,0,0,0,0,0,0,0,0,0,0,70,252,247,217,217,217,217,217,217,251,253,252,252,252,229,122,24,0,0,0,0,0,0,0,0,0,0,0,7,206,252,252,252,252,252,252,252,252,253,252,252,179,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,87,154,252,252,252,252,200,131,127,11,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,69,148,210,218,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,85,146,190,221,252,252,253,252,238,28,0,0,0,0,0,0,0,0,0,0,0,11,22,22,84,162,232,246,252,253,252,252,252,252,253,252,252,84,0,0,0,0,0,0,0,0,0,0,57,211,252,252,253,252,252,252,252,253,205,180,84,84,253,252,238,28,0,0,0,0,0,0,0,0,0,0,50,244,252,252,253,252,244,147,103,42,11,0,0,132,253,252,231,0,0,0,0,0,0,0,0,0,0,0,0,62,211,124,107,27,0,0,0,0,0,0,11,219,255,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,171,252,253,189,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,252,252,241,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,202,252,252,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,252,252,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,253,199,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,253,252,236,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,223,253,245,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,190,252,253,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,252,252,174,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,245,253,236,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,185,252,252,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,252,251,134,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,148,252,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,226,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,223,253,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,253,254,253,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,142,253,252,172,252,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,132,253,203,20,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,252,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,233,244,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,203,0,0,0,0,0,0,0,0,0,62,102,102,142,204,162,41,0,0,0,0,0,0,0,0,0,173,253,82,0,0,0,0,0,0,0,51,173,254,253,254,253,255,253,255,112,0,0,0,0,0,0,0,0,253,212,0,0,0,0,0,0,0,41,253,252,192,151,50,50,71,151,253,232,0,0,0,0,0,0,0,0,254,151,0,0,0,0,0,0,31,233,254,233,41,0,0,0,0,82,255,151,0,0,0,0,0,0,0,0,253,232,123,0,0,0,0,0,132,252,233,50,0,0,0,0,163,243,233,50,0,0,0,0,0,0,0,0,152,253,254,213,21,0,0,62,254,253,82,0,0,41,113,233,255,213,82,0,0,0,0,0,0,0,0,0,30,172,253,252,223,122,102,203,253,252,102,183,203,243,253,252,131,10,0,0,0,0,0,0,0,0,0,0,0,0,21,183,234,253,254,253,254,253,254,253,224,203,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,50,213,252,233,151,50,50,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,91,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,255,232,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,253,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,250,253,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,253,253,218,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,239,253,253,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,253,253,241,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,209,253,253,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,143,253,253,252,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,232,253,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,231,253,253,147,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,161,253,253,180,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,253,253,224,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,243,253,253,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,253,253,217,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,249,253,229,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,230,253,249,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,244,253,210,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,253,253,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,253,99,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,172,218,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,60,254,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,254,254,254,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,94,232,254,254,232,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,254,254,254,237,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,220,254,254,254,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,240,254,254,231,160,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,147,254,254,254,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,254,254,190,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,254,254,233,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,75,234,254,200,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,247,254,254,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,218,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,217,254,224,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,254,254,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,209,254,234,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,254,254,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,254,195,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,254,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,218,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,47,84,150,150,159,254,254,188,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,94,198,253,253,253,253,253,253,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,11,128,208,244,253,253,253,253,253,227,220,253,253,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,49,209,253,253,236,170,111,67,67,19,174,253,253,169,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,134,20,16,0,0,0,80,162,252,253,141,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,134,249,253,209,78,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,80,160,253,253,239,134,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,168,253,253,243,155,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,110,158,239,253,253,253,213,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,53,198,253,253,253,253,253,253,253,179,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,253,253,253,253,253,253,253,253,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,253,249,212,121,83,5,5,21,250,253,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,62,56,0,0,0,0,19,195,253,253,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,202,253,253,157,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,153,253,253,209,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,25,199,253,249,110,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,205,244,253,222,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,115,172,218,251,253,249,149,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,248,166,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,149,149,116,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,253,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,223,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,244,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,173,254,233,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,252,253,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,253,224,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,252,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,254,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,183,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,253,244,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,253,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,252,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,255,253,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,253,252,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,213,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,28,0,0,0,9,77,153,254,254,254,235,62,5,0,0,0,0,0,0,0,0,0,0,0,0,0,24,204,240,177,128,129,197,253,253,253,253,253,253,170,10,0,0,0,0,0,0,0,0,0,0,0,0,0,50,244,253,253,253,254,253,253,253,253,253,253,236,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,112,121,121,217,232,202,121,94,253,253,243,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,212,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,118,220,253,234,79,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,220,253,243,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,254,253,217,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,231,255,253,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,203,253,240,66,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,168,254,254,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,242,253,220,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,243,253,182,39,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,223,253,222,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,151,253,222,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,173,253,222,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,100,253,230,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,253,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,119,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,255,191,128,191,191,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,191,255,255,128,0,0,64,191,255,255,255,255,255,191,128,128,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,255,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,64,0,0,0,0,128,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,128,0,0,64,191,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,74,74,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,70,138,194,242,251,254,255,246,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,83,227,238,241,254,254,254,249,189,189,189,130,126,0,0,0,0,0,0,0,0,0,0,0,0,0,15,192,254,254,254,225,182,108,40,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,199,254,206,37,70,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,237,254,177,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,254,234,72,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,254,254,254,234,200,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,65,129,207,223,254,247,163,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,64,225,247,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,31,105,36,0,0,0,0,57,240,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,185,254,162,6,0,0,0,23,172,254,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,254,111,3,0,20,71,185,247,254,244,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,249,254,236,190,190,249,254,254,251,193,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,210,241,249,254,222,155,109,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,73,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,243,130,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,254,254,240,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,236,199,248,240,117,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,133,0,36,222,254,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201,133,0,0,35,94,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,238,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,225,30,30,85,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,254,254,254,244,155,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,254,236,175,148,237,254,227,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,73,24,0,0,24,109,236,208,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,254,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,254,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,254,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,251,219,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,121,20,0,0,0,0,34,194,254,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,180,0,0,0,0,50,233,254,198,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,169,0,0,0,77,233,254,198,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,215,141,76,183,249,254,215,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,254,254,254,254,214,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,69,153,198,129,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,34,136,136,136,136,136,136,136,136,89,13,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,253,253,253,253,253,253,253,253,253,253,253,204,25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,253,253,253,253,253,253,253,253,253,253,253,253,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,183,222,192,99,99,99,99,99,147,250,253,253,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,242,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,239,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,253,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,235,253,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,198,253,253,224,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,93,192,192,159,69,69,69,197,253,253,223,100,0,0,0,0,0,0,0,0,0,0,0,0,44,75,153,235,253,253,253,253,253,253,253,253,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,55,233,253,253,253,253,253,253,253,253,253,253,253,253,68,4,0,0,0,0,0,0,0,0,0,0,0,115,235,253,243,148,58,214,253,253,253,253,253,253,253,253,24,0,0,0,0,0,0,0,0,0,0,0,113,237,253,253,173,112,223,253,253,253,253,226,160,238,253,253,169,7,0,0,0,0,0,0,0,0,0,0,240,253,253,253,253,253,253,253,253,229,60,22,0,25,136,242,253,128,0,0,0,0,0,0,0,0,0,0,254,253,253,253,253,253,253,181,60,18,0,0,0,0,0,21,136,83,0,0,0,0,0,0,0,0,0,0,85,253,253,253,185,124,18,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,12,12,12,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,129,10,0,0,0,0,0,0,0,0,23,29,142,217,255,141,0,0,0,0,0,0,0,0,0,0,0,226,254,197,63,0,26,0,0,26,57,82,235,253,254,253,209,59,0,0,0,0,0,0,0,0,0,0,29,235,254,253,235,198,224,198,198,223,169,168,81,56,56,56,13,0,0,0,0,0,0,0,0,0,0,0,48,241,254,177,140,140,141,140,229,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,254,254,227,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,226,253,228,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,253,225,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,254,254,204,129,29,29,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,172,253,253,254,253,253,253,170,95,57,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,56,56,169,187,253,253,254,253,253,229,199,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,78,141,140,178,253,254,235,176,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,189,248,254,192,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,210,254,172,13,0,0,0,0,0,0,0,0,0,0,0,0,0,199,173,19,0,0,0,0,0,0,0,0,114,254,253,56,0,0,0,0,0,0,0,0,0,0,0,0,0,204,253,194,13,0,0,0,0,0,0,38,226,254,152,6,0,0,0,0,0,0,0,0,0,0,0,0,0,13,208,254,204,26,0,0,0,0,45,179,254,240,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,216,253,245,95,57,57,170,226,234,197,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,156,254,253,253,253,254,253,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,140,178,152,141,65,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,139,254,254,254,129,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,163,254,253,253,253,253,253,245,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,223,253,254,253,253,158,154,188,253,246,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,250,253,253,169,92,10,1,0,4,64,188,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,237,253,236,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,253,238,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,253,236,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,213,253,233,24,0,0,0,0,0,28,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,253,253,225,49,0,44,111,183,232,224,221,139,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,130,246,254,241,173,254,254,254,243,252,255,230,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,253,254,253,253,219,115,50,71,77,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,242,253,254,253,214,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,202,253,244,245,253,206,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,142,246,253,212,64,144,253,188,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,211,253,253,180,14,0,182,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,146,243,253,206,79,9,4,108,254,221,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,190,253,250,136,22,0,8,156,253,249,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,253,116,0,0,38,156,253,253,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,253,166,2,0,126,237,253,253,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,118,140,140,140,140,140,73,124,120,37,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,253,253,253,253,253,253,253,253,253,253,215,109,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,227,128,124,71,93,124,149,140,124,124,241,253,187,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,253,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,250,253,177,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,84,200,253,253,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,110,214,253,253,253,253,63,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,253,232,253,253,253,253,253,151,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,120,134,253,253,97,51,107,225,220,99,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,253,237,4,0,0,3,152,253,246,145,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,227,253,119,0,0,0,0,6,62,62,62,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,253,192,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,229,252,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,253,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,253,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,114,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,235,235,235,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,219,254,254,254,220,214,117,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,94,238,254,254,254,254,254,254,254,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,187,254,254,254,254,254,254,254,254,254,248,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,252,254,254,252,150,189,254,254,254,254,254,254,117,0,0,0,0,0,0,0,0,0,0,0,0,0,79,195,254,254,254,134,0,71,124,124,124,227,254,254,117,0,0,0,0,0,0,0,0,0,0,0,0,16,197,254,254,254,127,2,0,0,0,0,0,200,254,254,251,0,0,0,0,0,0,0,0,0,0,0,20,187,254,254,254,126,5,0,0,0,0,0,0,200,254,254,206,0,0,0,0,0,0,0,0,113,0,0,94,254,254,254,127,5,0,0,0,0,0,0,106,245,254,254,117,0,0,0,0,0,0,0,0,37,0,83,238,254,254,229,5,0,0,0,0,0,0,20,228,254,254,213,32,0,0,0,0,0,0,0,0,0,11,219,254,254,230,43,0,0,0,0,0,0,14,195,254,254,250,86,0,0,0,0,0,0,0,0,0,0,101,254,254,254,100,0,0,0,0,0,1,11,199,254,254,253,132,0,0,0,0,0,0,0,0,0,0,58,245,254,254,152,0,0,0,0,0,0,96,254,254,254,254,192,0,0,0,0,0,0,0,0,0,0,0,118,254,254,232,49,0,0,0,37,104,205,250,254,254,254,254,61,0,0,0,0,0,0,0,0,0,0,0,118,254,254,217,84,84,84,218,233,254,254,255,254,214,171,127,8,0,0,0,0,0,0,0,0,0,0,0,118,254,254,254,254,254,254,254,254,254,254,248,188,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,241,254,254,254,254,254,254,254,221,213,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,234,234,234,234,234,173,96,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,156,246,254,255,254,254,238,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,232,253,253,253,241,242,253,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,253,253,240,100,30,36,131,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,254,253,253,33,0,0,0,6,220,253,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,254,253,154,5,0,0,0,0,212,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,255,249,60,0,0,0,0,0,235,254,232,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,199,254,233,0,0,0,0,0,7,235,253,254,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,253,254,247,84,0,0,0,74,199,253,253,235,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,146,254,253,247,234,234,235,250,253,253,253,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,254,253,253,253,253,254,253,253,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,142,236,254,254,218,68,138,254,254,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,39,39,15,10,211,253,253,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,253,253,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,253,253,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,253,253,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,254,254,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,247,253,219,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,253,253,226,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,253,253,201,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,200,253,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,103,228,254,128,0,0,84,141,254,254,248,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,229,253,253,222,118,208,251,253,253,253,253,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,245,253,253,253,253,253,253,253,253,253,253,253,123,0,0,0,0,0,0,0,0,0,0,0,0,0,95,225,253,253,253,253,253,253,253,237,149,213,253,241,9,0,0,0,0,0,0,0,0,0,0,0,43,152,251,253,253,253,253,253,230,128,25,22,30,244,253,240,0,0,0,0,0,0,0,0,0,0,0,217,236,253,253,253,253,253,180,128,25,0,0,62,179,253,253,193,0,0,0,0,0,0,0,0,0,0,0,248,253,253,253,223,168,61,8,0,0,0,0,169,253,253,193,17,0,0,0,0,0,0,0,0,0,0,0,208,253,180,175,45,0,0,0,0,0,0,79,239,253,191,19,0,0,0,0,0,0,0,0,0,0,0,0,24,51,4,0,0,0,0,0,0,0,42,238,253,227,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,208,253,243,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,204,253,243,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,201,253,242,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,172,253,243,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,172,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,174,253,253,194,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,175,253,253,195,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,177,253,253,197,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,179,253,253,249,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,182,253,253,251,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,253,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,109,109,109,212,253,255,253,253,253,192,150,149,109,63,0,0,0,0,0,0,0,0,0,0,0,0,63,222,252,252,252,252,252,253,252,252,252,253,252,252,252,238,72,0,0,0,0,0,0,0,0,0,0,0,73,252,252,252,252,252,252,253,241,241,231,253,252,252,252,253,231,52,0,0,0,0,0,0,0,0,0,0,31,108,108,108,108,108,108,108,77,78,46,108,108,211,252,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,252,253,252,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,181,252,253,189,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,252,252,253,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,252,252,253,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,233,253,253,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,252,252,210,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,253,252,252,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,206,253,252,231,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,253,255,222,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,242,252,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,181,252,252,237,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,252,252,252,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,253,253,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,252,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,252,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,148,148,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,23,33,97,181,197,197,197,121,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,68,181,238,254,254,254,254,218,213,213,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,119,238,254,254,250,196,123,57,41,6,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,12,192,254,218,196,197,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,254,194,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,251,254,197,80,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,158,217,254,254,254,244,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,109,226,249,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,254,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,105,255,225,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,81,208,254,229,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,131,57,42,42,127,216,254,228,133,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,254,228,254,254,212,204,83,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,196,161,115,48,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,121,121,190,255,253,253,253,253,225,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,200,252,252,252,253,252,252,252,252,229,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,245,252,252,247,158,159,158,89,89,53,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,216,252,252,187,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,252,252,185,20,0,0,0,0,130,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,221,252,241,63,0,0,0,0,0,198,231,81,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,252,241,97,0,0,0,0,0,0,79,246,252,165,34,0,0,0,0,0,0,0,0,0,0,0,0,12,229,252,185,0,0,0,0,0,0,0,0,78,219,252,237,59,0,0,0,0,0,0,0,0,0,0,0,107,252,252,108,0,0,0,0,0,0,0,0,0,84,207,252,169,0,0,0,0,0,0,0,0,0,0,0,107,252,252,53,0,0,0,0,0,0,0,0,0,0,54,252,239,56,0,0,0,0,0,0,0,0,0,0,241,253,215,28,0,0,0,0,0,0,0,0,0,0,54,253,253,107,0,0,0,0,0,0,0,0,0,0,240,252,116,0,0,0,0,0,0,0,0,0,0,0,54,252,252,106,0,0,0,0,0,0,0,0,0,0,240,252,39,0,0,0,0,0,0,0,0,0,0,0,54,252,252,106,0,0,0,0,0,0,0,0,0,0,240,252,39,0,0,0,0,0,0,0,0,0,0,0,96,252,187,17,0,0,0,0,0,0,0,0,0,0,240,252,75,0,0,0,0,0,0,0,0,0,0,89,238,252,93,0,0,0,0,0,0,0,0,0,0,0,240,252,172,0,0,0,0,0,0,0,0,20,96,238,241,177,24,0,0,0,0,0,0,0,0,0,0,0,148,252,227,58,0,0,0,0,0,20,97,202,252,252,177,0,0,0,0,0,0,0,0,0,0,0,0,0,96,249,252,227,160,139,41,160,160,204,252,252,243,190,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,222,252,252,252,252,252,252,253,239,189,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,154,252,252,252,252,252,120,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,186,254,254,254,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,35,192,254,253,253,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,169,253,253,254,216,107,142,253,135,7,79,6,0,0,0,0,0,0,0,0,0,0,68,0,0,0,32,183,253,253,222,57,10,0,92,253,47,206,253,110,0,0,0,0,0,0,0,0,0,0,83,0,0,0,171,253,253,185,14,0,0,0,47,193,254,253,222,34,0,0,0,0,0,0,0,0,0,0,0,0,0,61,255,254,183,8,0,0,0,71,209,254,255,226,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,254,245,128,118,118,118,162,241,253,253,249,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,254,253,253,253,253,254,253,253,253,253,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,177,213,213,213,213,117,105,253,253,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,207,253,222,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,217,254,205,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,222,254,228,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,253,205,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,234,251,222,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,222,253,237,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,217,254,235,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,147,254,228,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,253,213,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,237,237,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,245,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,254,195,118,118,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,179,253,253,253,253,239,234,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,253,253,253,253,253,253,252,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,189,253,253,193,67,99,198,234,253,223,136,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,157,253,253,253,238,23,0,0,146,253,253,253,227,37,0,0,0,0,0,0,0,0,0,0,0,0,6,160,253,253,253,175,58,0,0,0,12,180,246,253,253,139,5,0,0,0,0,0,0,0,0,0,0,0,97,253,253,253,253,123,0,0,0,0,0,0,61,247,253,253,75,0,0,0,0,0,0,0,0,0,0,0,156,253,253,253,180,3,0,0,0,0,0,0,0,181,253,253,209,0,0,0,0,0,0,0,0,0,0,42,241,253,253,222,11,0,0,0,0,0,0,0,0,67,241,253,226,34,0,0,0,0,0,0,0,0,0,118,253,253,253,181,0,0,0,0,0,0,0,0,0,0,183,253,253,132,0,0,0,0,0,0,0,0,0,218,253,253,253,82,0,0,0,0,0,0,0,0,0,0,23,214,253,248,85,0,0,0,0,0,0,0,0,254,253,253,202,29,0,0,0,0,0,0,0,0,0,0,0,199,253,253,116,0,0,0,0,0,0,0,0,254,253,253,140,3,0,0,0,0,0,0,0,0,0,0,0,196,253,253,194,0,0,0,0,0,0,0,0,254,253,253,253,82,0,0,0,0,0,0,0,0,0,0,0,63,253,253,253,0,0,0,0,0,0,0,0,77,245,253,253,226,42,0,0,0,0,0,0,0,0,0,0,193,253,253,123,0,0,0,0,0,0,0,0,0,234,253,253,253,103,43,47,0,0,0,0,48,83,138,145,246,253,246,79,0,0,0,0,0,0,0,0,0,126,253,253,253,221,227,230,199,199,199,199,230,253,253,253,253,243,102,0,0,0,0,0,0,0,0,0,0,29,116,243,253,253,253,253,253,253,253,253,253,253,253,253,221,103,0,0,0,0,0,0,0,0,0,0,0,0,0,103,235,253,253,253,253,253,253,253,253,253,233,114,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,116,116,116,239,178,253,163,116,116,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,67,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,237,253,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,133,133,228,183,248,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,250,253,253,131,0,188,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,166,244,253,195,234,170,16,211,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,188,253,249,79,8,60,223,98,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,184,254,253,87,0,0,35,9,155,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,208,253,254,170,12,0,0,0,4,185,253,220,0,0,0,0,0,0,0,0,49,0,0,0,0,0,5,184,253,253,177,10,0,0,0,0,156,253,253,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,254,254,192,0,0,0,0,0,65,245,255,177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,247,253,233,58,0,0,0,0,39,237,253,242,82,0,0,0,0,0,0,0,0,0,0,0,0,0,90,225,253,236,59,0,0,0,0,9,181,253,253,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,248,52,0,0,0,0,19,187,253,253,128,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,253,194,0,0,0,56,85,238,253,241,112,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,235,253,251,199,199,199,254,253,253,158,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,168,253,253,253,253,253,254,246,108,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,137,211,253,220,209,100,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,66,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,117,117,117,117,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,175,176,210,251,251,251,251,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,39,39,204,233,243,251,253,251,251,251,251,226,45,0,0,0,0,0,0,0,0,0,0,0,0,0,68,122,251,251,251,251,251,251,253,251,251,251,213,59,0,0,0,0,0,0,0,0,0,0,0,0,37,155,222,251,251,251,251,251,251,251,253,251,251,226,59,0,0,0,0,0,0,0,0,0,0,0,0,0,224,251,251,251,243,231,66,44,162,251,253,242,231,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,239,107,0,7,131,251,251,253,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,251,251,233,136,136,145,251,251,251,221,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,57,192,251,251,251,251,251,251,251,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,194,217,253,253,253,253,253,255,253,253,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,206,251,251,251,251,253,251,251,230,117,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,155,251,251,251,251,212,157,251,251,251,204,161,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,216,251,251,251,203,29,18,204,251,251,249,233,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,251,251,251,253,179,98,122,251,251,251,251,251,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,251,251,251,253,251,251,251,251,251,251,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,98,242,251,253,251,251,251,251,251,251,251,251,251,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,173,192,251,251,251,251,251,251,251,251,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,115,115,115,115,115,115,115,115,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,92,132,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,142,253,252,253,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,233,254,253,234,253,254,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,253,252,233,111,71,252,253,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,254,172,41,0,72,253,254,253,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,252,172,10,0,41,193,252,253,252,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,254,213,0,0,51,233,254,253,244,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,213,10,0,82,233,252,253,252,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,234,193,254,253,254,253,254,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,252,253,252,253,252,253,252,213,10,0,0,0,0,0,0,0,41,0,0,0,0,0,0,0,0,0,0,21,142,203,203,254,253,254,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,142,253,252,172,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,253,254,131,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,253,252,172,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,254,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,253,252,172,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,253,255,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,233,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,233,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,85,85,85,85,86,85,85,85,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,252,252,252,252,253,252,252,252,221,198,72,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,242,223,223,145,225,223,223,223,223,225,249,233,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,74,0,0,0,0,0,0,0,0,0,146,252,239,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,253,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,252,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,227,252,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,253,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,219,252,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,222,233,86,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,123,215,253,74,0,4,29,29,76,59,41,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,165,252,252,253,152,140,153,252,253,252,141,99,0,0,0,0,0,0,0,0,0,0,0,26,113,113,255,253,253,253,253,255,253,228,140,140,79,0,0,0,0,0,0,0,0,0,0,0,0,0,76,231,252,252,253,252,252,252,252,168,42,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,165,233,252,253,201,195,102,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,84,84,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,93,177,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,165,254,237,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,0,0,0,0,0,0,6,164,254,181,5,216,0,0,0,0,0,0,0,0,0,0,0,0,0,3,133,225,38,0,0,0,0,0,161,254,215,7,0,104,0,0,0,0,0,0,0,0,0,0,0,0,3,133,254,218,12,0,0,0,7,150,248,246,34,0,10,19,0,0,0,0,0,0,0,0,0,0,0,30,183,254,191,47,0,0,0,7,163,254,245,81,0,10,58,0,0,0,0,0,0,0,0,0,0,0,63,240,254,189,31,0,0,0,7,162,254,245,54,0,11,72,18,0,0,0,0,0,0,0,0,0,0,90,240,254,181,11,0,0,0,7,162,254,245,54,0,25,171,10,0,0,0,0,0,0,0,0,0,0,62,241,251,142,11,0,0,0,0,154,254,245,82,0,90,218,68,0,0,0,0,0,0,0,0,0,0,0,215,254,142,0,17,0,0,0,81,232,245,54,11,143,157,34,0,0,0,0,0,0,0,0,0,0,0,0,255,254,241,221,232,221,166,221,247,254,248,210,174,107,4,0,0,0,0,0,0,0,0,0,0,0,0,0,85,169,234,195,195,201,254,254,254,137,42,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,6,164,254,245,85,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,254,246,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,228,254,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,178,80,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,91,143,254,254,254,254,255,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,180,246,253,248,237,246,238,253,253,244,183,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,230,253,253,187,99,5,131,122,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,224,253,235,71,22,0,2,119,253,253,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,229,59,0,0,0,89,253,253,197,129,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,213,50,5,0,70,240,253,216,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,253,253,253,150,139,176,253,253,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,187,200,253,253,253,253,253,163,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,98,137,253,253,253,215,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,253,253,253,248,171,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,250,132,144,245,253,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,171,0,0,16,199,228,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,171,0,0,0,116,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,171,0,0,0,63,231,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,184,14,0,0,94,244,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,210,39,0,0,116,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,189,19,0,0,116,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,196,253,181,148,148,195,253,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,199,253,253,253,219,152,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,89,89,195,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,193,254,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,212,253,232,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,193,253,243,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,240,254,253,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,205,253,254,94,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,246,254,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,238,253,253,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,246,253,253,141,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,240,255,253,168,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,240,253,254,138,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,246,254,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,238,253,232,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,246,253,243,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,187,254,253,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,253,254,138,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,254,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,222,253,173,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,188,253,186,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,253,213,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,253,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,216,216,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,252,252,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,252,186,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,252,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,255,222,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,253,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,254,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,253,196,0,0,7,57,57,57,157,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,253,196,0,76,204,252,252,252,253,240,159,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,253,196,38,237,253,252,252,252,253,252,252,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,254,253,253,241,163,38,0,0,63,194,253,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,253,252,252,65,0,0,0,0,0,57,252,252,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,253,252,186,6,0,0,0,0,0,57,252,252,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,252,68,0,0,0,0,0,63,194,252,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,253,69,0,0,0,0,26,204,253,231,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,252,224,69,57,82,169,243,253,214,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,224,252,252,253,252,252,252,194,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,139,240,253,252,164,90,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,255,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,194,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,252,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,246,252,253,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,216,253,253,163,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,179,252,252,227,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,134,253,252,186,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,252,253,227,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,128,253,253,239,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,252,252,252,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,252,252,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,213,253,252,164,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,204,253,254,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,150,252,252,197,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,229,252,252,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,237,253,252,252,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,253,253,254,253,253,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,240,252,253,227,96,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,215,252,244,93,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,228,202,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,244,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,228,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,199,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,254,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,218,184,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,248,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,222,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,211,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,250,110,0,0,0,0,0,0,21,44,44,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,241,20,0,0,0,0,18,149,240,254,254,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,209,178,0,0,0,0,17,221,238,135,143,254,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,254,161,0,0,0,8,190,239,92,23,215,187,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,242,125,0,0,0,181,254,103,3,172,229,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,203,157,0,0,46,254,108,24,185,250,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,224,220,0,0,128,255,114,229,230,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,252,173,113,219,254,254,230,66,88,150,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,220,254,215,182,224,254,254,220,137,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,214,244,71,59,95,136,136,137,125,59,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,242,253,253,253,254,253,253,253,254,241,217,156,0,0,0,0,0,0,0,0,0,0,0,0,0,4,123,254,255,245,192,156,156,121,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,186,253,217,107,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,253,221,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,254,253,182,156,127,79,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,241,255,254,254,254,255,254,211,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,136,136,136,112,65,178,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,58,253,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,253,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,111,254,249,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13,43,190,253,254,253,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167,215,215,226,227,244,253,253,254,147,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,253,253,253,254,253,253,253,218,83,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,254,254,254,255,254,225,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,130,214,214,208,125,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,247,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,235,248,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,184,254,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,254,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,254,162,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,254,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,252,252,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,185,254,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,254,254,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,226,255,200,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,254,254,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,254,160,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,245,254,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,254,253,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,254,213,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,254,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,237,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,252,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,254,231,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,254,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,147,147,147,124,8,0,0,0,0,0,32,205,184,0,0,0,0,0,0,0,0,0,0,0,0,0,25,206,254,254,254,254,199,44,0,0,0,20,225,254,184,0,0,0,0,0,0,0,0,0,1,6,1,71,206,254,253,212,240,249,251,238,76,0,29,231,254,254,133,0,0,0,0,0,0,0,0,0,32,211,29,193,254,253,125,0,0,0,38,195,35,78,251,254,254,138,0,0,0,0,0,0,0,0,0,0,0,0,5,229,254,244,0,0,0,0,0,0,80,242,254,254,142,2,0,0,0,0,0,0,0,0,0,0,0,0,6,254,254,244,0,0,0,0,0,67,209,254,253,141,5,0,0,0,0,0,0,0,0,0,0,0,0,0,3,191,254,246,40,0,0,0,18,242,254,254,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,254,254,243,46,0,42,217,254,254,142,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,216,254,254,239,180,199,254,254,171,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,145,254,254,254,254,254,241,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,178,254,254,254,254,233,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,249,254,254,241,250,253,141,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,246,254,254,218,31,108,251,254,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,242,254,254,221,80,0,36,245,254,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,159,254,254,238,57,2,121,248,254,211,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,254,254,254,125,51,170,255,254,254,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,254,254,254,246,245,254,254,254,102,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,227,254,254,254,254,254,238,152,28,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,254,254,254,254,254,163,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,181,254,220,141,38,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,114,170,170,170,255,255,255,255,198,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,255,198,170,170,170,170,141,86,170,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,226,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,226,226,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,226,255,170,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,198,255,226,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,170,255,226,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,255,226,141,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,255,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,226,141,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,170,255,255,170,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,141,255,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,226,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,255,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,226,226,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,226,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,198,141,86,114,198,255,170,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,170,255,255,255,198,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,]
		,[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,250,236,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,25,173,245,119,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,10,134,104,0,0,0,3,194,252,180,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,197,253,133,0,0,0,3,163,253,171,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,202,253,207,30,0,0,0,80,253,244,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,82,226,251,167,5,0,0,0,59,222,253,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,253,237,155,0,0,0,0,0,128,253,227,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,230,236,108,18,0,0,0,0,61,207,251,131,7,0,0,0,0,0,0,0,0,0,0,0,0,0,32,239,241,124,0,0,0,0,0,11,205,253,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,253,149,0,0,0,0,0,0,164,254,253,80,0,70,35,0,0,0,0,0,0,0,0,0,0,0,0,67,254,254,254,254,254,187,159,240,254,255,254,184,254,199,18,0,0,0,0,0,0,0,0,0,0,0,0,32,170,216,253,253,253,253