from pyparsing import Word,Literal,Forward,Suppress,oneOf,OneOrMore,ZeroOrMore,Optional,nums,alphanums,delimitedList,Dict,Group,anyOpenTag,anyCloseTag,LineEnd, Combine

class Transition:
  def __init__(self,first,second):
    self._first = first
    self._second = second
  
  @property
  def first(self):
    return self._first
  @property
  def second(self):
    return self._second
  
  def __str__(self):  
    return "%s -> %s" % (self.first, self.second)

class Effort:
  def __init__(self,txt,trans=Transition(None,None)):
    self.text=txt
    self.trans=trans
  def __str__(self):
    return "%s | %s" % (self.text, self.trans)

class Risk:
  def __init__(self,id,txt):
    self.id=id
    self.text=txt
  def __str__(self):
    return "%s | %s " % (self.id, self.text) 
    
class ActionItem:
  def __init__(self,id,txt,trans=Transition(None,None)):
    self.id=id
    self.text=txt
    self.trans=trans
  def __str__(self):
    return "%s | %s | %s" % (self.id, self.text, self.trans)
       
########################################
#NBF
########################################
class REKAParser:
  """This class can parse REKA files"""
  def __init__(self):
    self.isInitDone = False
    self.nbf = None
    
  def getNBF(self):
    if(not self.isInitDone):
      #[0.0] COMMON
      OBRACKET = Suppress("[")
      CBRACKET = Suppress("]")
      OBRACES  = Suppress("{")
      CBRACES  = Suppress("}")
      SEMI = Literal(";")
      CSLASH = Suppress(Literal("/"))
      END_DEF    =  Suppress(SEMI)
      #[0.1] TAGS
      L_RISK   = Literal("risk")+CSLASH  
      S_RISK   = Literal("r")+CSLASH
      L_EFFORT = Literal("effort")+CSLASH
      S_EFFORT = Literal("e")+CSLASH
      L_AITEM  = Literal("actionItem")+CSLASH
      S_AITEM  = Literal("i")+CSLASH
      L_PROT   = Literal("protagonist")+CSLASH
      S_PROT   = Literal("p")+CSLASH
      L_THEME  = Literal("theme")+CSLASH
      S_THEME  = Literal("t")+CSLASH
      #[1] Risk
      B_RISK     =  S_RISK | L_RISK
      KEY        =  OBRACKET+Word(nums)+CBRACKET
      TEXT       =  Group(OneOrMore(Word(alphanums+":.,[]?!")))
      RISK       =  B_RISK+KEY+TEXT+END_DEF
      #[2] Effort
      B_EFFORT   = S_EFFORT | L_EFFORT
      TRANS_SI   = Suppress(Literal('->'))
      TRANSITION = OBRACES+delimitedList(TEXT)+CBRACES+TRANS_SI+OBRACES+delimitedList(TEXT)+CBRACES
      COMMAND    = Optional(TEXT)+Optional(TRANSITION)
      EFFORT     = B_EFFORT+COMMAND+END_DEF
      #[3] ActionItem
      B_AITEM    = S_AITEM | L_AITEM
      ACTIONITME = B_AITEM+KEY+COMMAND+END_DEF
      #[4] HEADER
      B_PROT     = S_PROT | L_PROT
      PROT       = B_PROT+TEXT+END_DEF
      B_THEME    = S_THEME | L_THEME
      THEME      = B_THEME+TEXT+END_DEF
      B_COMMENT  = Literal("'")
      COMMENT    = B_COMMENT+TEXT
      EOL        = Suppress(LineEnd())
      EMPTY      = OneOrMore(EOL)
      #[5] Final
      SOURCE_LN  = THEME | PROT | RISK | ACTIONITME | EFFORT | EMPTY
      self.nbf = Dict( ZeroOrMore( Group( SOURCE_LN  ) ) ).ignore(COMMENT)
      self.isInitDone = True
    return self.nbf
      
  def getRisks(self,s):
    for line in s:
      current = self.getNBF().parseString(line)
      if 'r' in current or 'risk' in current:
        currentList = list(current)
        yield Risk(currentList[0][1]," ".join(currentList[0][2]))
        
  def getEfforts(self,s):
    for line in s:
      current = self.getNBF().parseString(line)
      if 'e' in current or 'effort' in current:
        currentList = list(current)
        if(len(currentList[0]) == 4):
          yield Effort(" ".join(currentList[0][1]),Transition(currentList[0][2],currentList[0][3]))
        yield Effort(" ".join(currentList[0][1]))
        
  def getActionItems(self,s):
    for line in s:
      current = self.getNBF().parseString(line)
      if 'i' in current or 'actionItem' in current:
        currentList = list(current)
        if(len(currentList[0]) == 5):
          yield ActionItem(currentList[0][1]," ".join(currentList[0][2]),Transition(currentList[0][3],currentList[0][4]))
        yield ActionItem(currentList[0][1]," ".join(currentList[0][2]))
        
  def getProtagonist(self,s):
    for line in s:
      current = self.getNBF().parseString(line)
      if 'p' in current or 'protagonist' in current:
        return " ".join(list(current)[0][1])      
  
  def getTheme(self,s):
    for line in s:
      current = self.getNBF().parseString(line)
      if 't' in current or 'theme' in current:
        return " ".join(list(current)[0][1])

p = REKAParser()        
iniFile = file("test.txt")
source = iniFile.readlines()

# for risk in p.getRisks(source):
    # print(risk)
    # print(' '.join(risk[0][2]))
print(p.getTheme(source))
print(p.getProtagonist(source))    
for risk in p.getRisks(source):
    print(risk)    
for aitem in p.getActionItems(source):
    print(aitem)    
for effort in p.getEfforts(source):
    print(effort)
    #print(' '.join(aitem[0][2])+' '+str(len(aitem[0])))
  #print(RISK.parseString("{5,12,33}->{6}"))