/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.saxon.Version;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.testdriver.QT3TestDriverHE;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.testdriver.TestReport;
import net.sf.saxon.value.DateTimeValue;

public class QT3TestReport
extends TestReport {
    public QT3TestReport(TestDriver testDriver, Spec sp) {
        super(testDriver, sp);
    }

    public void writeResultFilePreamble(Processor processor, XdmNode catalog) throws IOException, SaxonApiException, XMLStreamException {
        this.createWriter(processor);
        String today = DateTimeValue.getCurrentDateTime(null).toDateValue().getStringValue().substring(0, 10);
        XdmNode outermost = (XdmNode)catalog.axisIterator(Axis.CHILD, new QName(QT3TestDriverHE.CNS, "catalog")).next();
        this.results.writeStartElement("test-suite-result");
        this.results.writeDefaultNamespace(QT3TestDriverHE.RNS);
        this.results.writeStartElement("submission");
        this.results.writeAttribute("anonymous", "false");
        this.results.writeStartElement("created");
        this.results.writeAttribute("by", "Michael Kay");
        this.results.writeAttribute("email", "mike@saxonica.com");
        this.results.writeAttribute("organization", "Saxonica");
        this.results.writeAttribute("on", today);
        this.results.writeEndElement();
        this.results.writeStartElement("test-run");
        this.results.writeAttribute("test-suite-version", outermost.getAttributeValue(new QName("", "version")));
        this.results.writeAttribute("date-run", today);
        this.results.writeEndElement();
        this.results.writeStartElement("notes");
        this.results.writeEndElement();
        this.results.writeEndElement();
        this.results.writeStartElement("product");
        this.results.writeAttribute("vendor", "Saxonica");
        this.results.writeAttribute("name", this.testDriver.getProductEdition());
        this.results.writeAttribute("version", Version.getProductVersion());
        this.results.writeAttribute("released", "false");
        this.results.writeAttribute("open-source", "false");
        this.results.writeAttribute("language", this.spec.specAndVersion);
        this.results.writeAttribute("bytecode", this.testDriver.isByteCode() ? "on" : "off");
        Map<String, QT3TestDriverHE.Dependency> dependencyMap = ((QT3TestDriverHE)this.testDriver).getDependencyMap();
        if (!dependencyMap.isEmpty()) {
            for (Map.Entry<String, QT3TestDriverHE.Dependency> entry : dependencyMap.entrySet()) {
                QT3TestDriverHE.Dependency dep = entry.getValue();
                if ("spec".equals(dep.dType)) continue;
                this.results.writeStartElement("dependency");
                this.results.writeAttribute("type", dep.dType);
                this.results.writeAttribute("value", entry.getKey());
                this.results.writeAttribute("satisfied", Boolean.toString(dep.satisfied));
                this.results.writeEndElement();
            }
        }
        this.results.writeEndElement();
    }
}

