from colonyzer2 import *
import time, sys, os, numpy, PIL

def main():
    print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
    print("Note that this script requires a Colonyzer.txt file (as generated by ColonyzerParametryzer) describing initial guess for culture array")
    print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")

    # Lydall lab file naming convention
    # First 15 characters in filename identify unique plates
    # Remaining charaters can be used to store date, time etc.
    barcRange=(0,15)
    if len(sys.argv)>1:
        fmt=sys.argv[1]
    
##    # Format names and dimension definitions
##    formats=["48","96","117","384","768","1536"]
##    dims=[(6,8),(12,8),(13,9),(24,16),(48,32),(48,32)]
##    nx,ny=dims[formats.index(fmt)] 

    start=time.time()

    # Find image files which have yet to be analysed
    (fullpath,outputimages,outputdata)=colonyzer2.setupDirectories()
    barcdict=colonyzer2.getBarcodes(outputimages,outputdata,fullpath,barcRange)
    InsData=colonyzer2.readInstructions(fullpath)

    while len(barcdict)>0:
        BARCODE=barcdict.keys()[0]
        print(BARCODE)
        LATESTIMAGE=barcdict[BARCODE][0]
        EARLIESTIMAGE=barcdict[BARCODE][-1]
        imRoot=EARLIESTIMAGE.split(".")[0]
        
        # Indicate that barcode is currently being analysed, to allow parallel analysis
        tmp=open(os.path.join(outputdata,imRoot+".dat"),"w").close()

        # Get latest image for thresholding and detecting culture locations
        imN,arrN=colonyzer2.openImage(LATESTIMAGE)
        # Get earliest image for lighting gradient correction
        im0,arr0=colonyzer2.openImage(EARLIESTIMAGE)

        # If we have ColonyzerParametryzer output for this filename, use it for initial culture location estimates
        if LATESTIMAGE in InsData:
            (candx,candy,dx,dy)=colonyzer2.SetUp(InsData[LATESTIMAGE])
        else:
            (candx,candy,dx,dy)=colonyzer2.SetUp(InsData['default'])

        # Update guesses and initialise locations data frame
        locationsN=colonyzer2.locateCultures(candx,candy,dx,dy,arrN)

        # Smooth (pseudo-)empty image 
        (correction_map,average_back)=colonyzer2.makeCorrectionMap(arr0,locationsN)

        # Correct spatial gradient in final image
        corrected_arrN=arrN*correction_map

        # Trim outer part of image to remove plate walls
        trimmed_arr=arrN[max(0,min(locationsN.y)-dy):min(arr0.shape[0],(max(locationsN.y)+dy)),max(0,(min(locationsN.x)-dx)):min(arr0.shape[1],(max(locationsN.x)+dx))]
        (thresh,bindat)=colonyzer2.automaticThreshold(trimmed_arr)

        # Mask for identifying culture areas
        maskN=numpy.ones(arrN.shape,dtype=numpy.bool)
        maskN[arrN<thresh]=False

        for FILENAME in barcdict[BARCODE]:
            im,arr=colonyzer2.openImage(FILENAME)
            arr=arr*correction_map
            
            # Correct for lighting differences between plates
            arrsm=arr[numpy.min(locationsN.y):numpy.max(locationsN.y),numpy.min(locationsN.x):numpy.max(locationsN.x)]
            masksm=maskN[numpy.min(locationsN.y):numpy.max(locationsN.y),numpy.min(locationsN.x):numpy.max(locationsN.x)]
            meanPx=numpy.mean(arrsm[numpy.logical_not(masksm)])

            arr=arr+(average_back-meanPx)
            threshadj=thresh+(average_back-meanPx)

            mask=numpy.ones(arr.shape,dtype=numpy.bool)
            mask[arrN<threshadj]=False

            # Measure culture phenotypes
            locations=colonyzer2.measureSizeAndColour(locationsN,arr,im,mask,average_back,BARCODE,FILENAME[0:-4])

            # Write results to file
            locations.to_csv(os.path.join(outputdata,FILENAME[0:-4]+".out"),"\t",index=False)
            dataf=colonyzer2.saveColonyzer(os.path.join(outputdata,FILENAME[0:-4]+".dat"),locations,threshadj,dx,dy)

            # Visual check of culture locations
            imthresh=colonyzer2.threshPreview(arr,threshadj,locations)
            imthresh.save(os.path.join(outputimages,FILENAME[0:-4]+".png"))

        # Get ready for next image
        print("Finished: "+FILENAME+" "+str(time.time()-start)+" s")
        barcdict=colonyzer2.getBarcodes(outputimages,outputdata,fullpath,barcRange)
    print("No more barcodes to analyse... I'm done.")

if __name__ == '__main__':
    main()
