import numpy as np
from flopy.mbase import Package
from flopy.utils import util_2d,util_3d


class ModflowUpw(Package):
    'Upstream weighting package class\n'
    def __init__(self, model, laytyp=0, layavg=0, chani=1.0, layvka=0, laywet=0, iupwcb = 53, hdry=-1E+30, iphdry = 0,\
                 hk=1.0, hani=1.0, vka=1.0, ss=1e-5, sy=0.15, vkcb=0.0, wetdry=-0.01, noparcheck=False,        \
                 extension='upw', unitnumber = 31):
        Package.__init__(self, model, extension, 'UPW', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# UPW for MODFLOW-NWT, generated by Flopy.'
        self.url = 'upw_upstream_weighting_package.htm'
        #nrow, ncol, nlay, nper = self.parent.nrow_ncol_nlay_nper
        ## item 1
        #self.iupwcb = iupwcb # Unit number for file with cell-by-cell flow terms
        #self.hdry = hdry # Head in cells that are converted to dry during a simulation
        #self.npupw = 0 # number of LPF parameters
        #self.iphdry = iphdry
        ## First create arrays so that they have the correct size
        #self.laytyp = np.empty(nlay, dtype='int32') # Specifies both the layer type (LAYCON) and the method of computing interblock conductance
        #self.layavg = np.ones(nlay, dtype='int32') # Interblock transmissivity flag for each layer
        #self.chani = np.ones(nlay) # Horizontal anisotropy flag for each layer
        #self.layvka = np.ones(nlay, dtype='int32') # vertical hydraulic conductivity flag for each layer
        #self.laywet = np.ones(nlay, dtype='int32') # wet dry flag for each layer
        ##self.laycbd = np.ones(nlay, dtype='int32') # confining bed flag for each layer
        ## Set values of all parameters
        #self.assignarray_old( self.laytyp, laytyp )
        #self.assignarray_old( self.layavg, layavg )
        #self.assignarray_old( self.chani, chani )
        #self.assignarray_old( self.layvka, layvka )
        #self.assignarray_old( self.laywet, laywet )
        #self.hk = np.empty((nrow, ncol, nlay))
        #self.hani = np.empty((nrow, ncol, nlay))
        #self.vka = np.empty((nrow, ncol, nlay))
        #self.ss = np.empty((nrow, ncol, nlay))
        #self.sy = np.empty((nrow, ncol, nlay))
        #self.vkcb = np.empty((nrow, ncol, nlay))
        #self.assignarray_old( self.hk, hk )
        #self.assignarray_old( self.hani, hani )
        #self.assignarray_old( self.vka, vka )
        #self.assignarray_old( self.ss, ss )
        #self.assignarray_old( self.sy, sy )
        #self.assignarray_old( self.vkcb, vkcb )
        #self.parent.add_package(self)
        nrow, ncol, nlay, nper = self.parent.nrow_ncol_nlay_nper
        # item 1
        self.ilpfcb = iupwcb # Unit number for file with cell-by-cell flow terms
        self.hdry = hdry # Head in cells that are converted to dry during a simulation
        self.nplpf = 0 # number of LPF parameters
        self.iphdry = iphdry
        self.laytyp = util_2d(model,(nlay,),np.int,laytyp,name='laytyp')
        self.layavg = util_2d(model,(nlay,),np.int,layavg,name='layavg')
        self.chani = util_2d(model,(nlay,),np.int,chani,name='chani')
        self.layvka = util_2d(model,(nlay,),np.int,layvka,name='vka')
        self.laywet = util_2d(model,(nlay,),np.int,laywet,name='laywet')

        self.options = ' '
        if noparcheck: self.options = self.options + 'NOPARCHECK  '

        self.hk = util_3d(model,(nlay,nrow,ncol),np.float32,hk,name='hk',locat=self.unit_number[0])
        self.hani = util_3d(model,(nlay,nrow,ncol),np.float32,hani,name='hani',locat=self.unit_number[0])
        self.vka = util_3d(model,(nlay,nrow,ncol),np.float32,vka,name='vka',locat=self.unit_number[0])
        self.ss = util_3d(model,(nlay,nrow,ncol),np.float32,ss,name='ss',locat=self.unit_number[0])
        self.sy = util_3d(model,(nlay,nrow,ncol),np.float32,sy,name='sy',locat=self.unit_number[0])
        self.vkcb = util_3d(model,(nlay,nrow,ncol),np.float32,vkcb,name='vkcb',locat=self.unit_number[0])
        #self.wetdry = util_3d(model,(nlay,nrow,ncol),np.float32,wetdry,name='wetdry',locat=self.unit_number[0])
        self.parent.add_package(self)

    def write_file(self):
        nrow, ncol, nlay, nper = self.parent.nrow_ncol_nlay_nper
        # Open file for writing
        f_upw = open(self.fn_path, 'w')
        # Item 0: text
        f_upw.write('%s\n' % self.heading)
        # Item 1: IBCFCB, HDRY, NPLPF        
        f_upw.write('{0:10d}{1:10.3G}{2:10d}{3:10d}{4:s}\n'.format(self.ilpfcb,self.hdry,self.nplpf,self.iphdry,self.options))
        # LAYTYP array
        f_upw.write(self.laytyp.string);
        # LAYAVG array
        f_upw.write(self.layavg.string);
        # CHANI array
        f_upw.write(self.chani.string);
        # LAYVKA array
        f_upw.write(self.layvka.string)
        # LAYWET array
        f_upw.write(self.laywet.string);
        # Item 7: WETFCT, IWETIT, IHDWET
        iwetdry = self.laywet.sum()
        if iwetdry > 0:            
            f_upw.write('{0:10f}{1:10d}{2:10d}\n'.format(self.wetfct,self.iwetit,self.ihdwet))
        transient = not self.parent.get_package('DIS').steady.all()
        for k in range(nlay):           
            f_upw.write(self.hk[k].get_file_entry())
            if self.chani[k] < 1:                
                f_upw.write(self.hani[k].get_file_entry())            
            f_upw.write(self.vka[k].get_file_entry())
            if transient == True:                
                f_upw.write(self.ss[k].get_file_entry())
                if self.laytyp[k] !=0:                                        
                    f_upw.write(self.sy[k].get_file_entry())
            if self.parent.get_package('DIS').laycbd[k] > 0:                
                f_upw.write(self.vkcb[k].get_file_entry())
            if (self.laywet[k] != 0 and self.laytyp[k] != 0):               
                f_upw.write(self.laywet[k].get_file_entry())
        f_upw.close()

