# This code is so you can run the samples without installing the package
import sys
import os
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))
#

testinfo = "s, q"
tags = "Draw, cap, endcap"

import cocos
from cocos.director import director
from cocos import draw
import pyglet


class TestFigure(draw.Canvas):
    def render(self):
        x,y = director.get_window_size()
        ys = y/4
        ye = ys*3
        xs = x/4
        line_width = 50
        self.set_color( (255,0,0,150) )
        self.set_stroke_width( line_width )

        # draw lines
        self.set_endcap( draw.ROUND_CAP )
        self.move_to( (xs, ys) ); self.line_to( (xs,ye) )
        self.set_endcap( draw.SQUARE_CAP )
        self.move_to( (xs*2, ys) ); self.line_to( (xs*2,ye) )
        self.set_endcap( draw.BUTT_CAP )
        self.move_to( (xs*3, ys) ); self.line_to( (xs*3,ye) )

        # draw ruler
        self.set_stroke_width( 1 )
        self.set_color( (255,255,255,200) )

        self.move_to( (0, ye) ); self.line_to( (x,ye) )
        self.move_to( (0, ye+line_width//2) ); self.line_to( (x,ye+line_width//2) )





class TestLayer(cocos.layer.Layer):
    def __init__(self):
        super( TestLayer, self ).__init__()

        self.add( TestFigure() )
        self.schedule( lambda x: 0 )

def main():
    director.init()
    test_layer = TestLayer ()
    main_scene = cocos.scene.Scene (test_layer)
    director.run (main_scene)

if __name__ == '__main__':
    main()
