### Reserved names of common context injections

| Context name     | Type | Used by | Description |
|------------------|------|---------|-------------|
| logger           | LoggerAdapter |        | Default logger for pipeline processors |
| metrics          | IMetrics |    | Default metrics client |
|                  |      |         |              |
| storage          | IContextPool \[IStorage\] | | Pool of different storage services |
| storage.patch    | IHash | ModelStorage | Patch value storage |
| storage.context  | IStorage | LazyContentHolder | Content storage  |
|                  |      |         |              |
| cache          | IContextPool \[ICache\] | | Pool of different cache services |
| cache.context    | ICache | cached_lazy_context | Cache context generated by context manager |
| cache.processor    | ICache | @cache | Cache results of pipe processor |
|                  |      |         |              |
| model_type       | Type\[Model\] | model_processor | Default model type |
|                  |      |         |              |
| lock             | IContextPool \[ILock\] |  | Pool of ILock services |
| lock.job         | ILock | Job  | is used as a job status storage |   
| lock.context     | ILock | cached_lazy_context  | lock new context generation |   
|                  |      |         |              |
