/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers.locators;

import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.locators.Firefox3Locator;

public class Firefox3LocatorUnitTest
extends TestCase {
    public void testUsualLauncherLocationsOnWindows() {
        Firefox3Locator locator = new Firefox3Locator(){

            protected boolean runningOnWindows() {
                return true;
            }
        };
        Firefox3LocatorUnitTest.assertEquals((int)3, (int)locator.usualLauncherLocations().length);
        Firefox3LocatorUnitTest.assertTrue((boolean)locator.usualLauncherLocations()[0].endsWith("\\Firefox-3"));
        Firefox3LocatorUnitTest.assertTrue((boolean)locator.usualLauncherLocations()[1].endsWith("\\Mozilla Firefox"));
        Firefox3LocatorUnitTest.assertTrue((boolean)locator.usualLauncherLocations()[2].endsWith("\\Firefox"));
    }

    public void testUsualLauncherLocationsOnOSX() {
        Firefox3Locator locator = new Firefox3Locator(){

            protected boolean runningOnWindows() {
                return false;
            }

            protected String[] firefoxDefaultLocationsOnUbuntu() {
                return new String[0];
            }
        };
        Firefox3LocatorUnitTest.assertEquals((int)2, (int)locator.usualLauncherLocations().length);
        Firefox3LocatorUnitTest.assertEquals((String)"/Applications/Firefox-3.app/Contents/MacOS", (String)locator.usualLauncherLocations()[0]);
        Firefox3LocatorUnitTest.assertEquals((String)"/Applications/Firefox.app/Contents/MacOS", (String)locator.usualLauncherLocations()[1]);
    }

    public void testUsualLauncherLocationsOnUbuntu() {
        Firefox3Locator locator = new Firefox3Locator(){

            protected boolean runningOnWindows() {
                return false;
            }

            protected String[] firefoxDefaultLocationsOnUbuntu() {
                return new String[]{"firefox-3.0.3"};
            }
        };
        Firefox3LocatorUnitTest.assertEquals((int)1, (int)locator.usualLauncherLocations().length);
        Firefox3LocatorUnitTest.assertEquals((String)"/usr/lib/firefox-3.0.3", (String)locator.usualLauncherLocations()[0]);
    }
}

